goog.provide('sci.impl.interpreter');
goog.require('cljs.core');
goog.require('cljs.tools.reader.reader_types');
goog.require('sci.impl.analyzer');
goog.require('sci.impl.fns');
goog.require('sci.impl.interop');
goog.require('sci.impl.macros');
goog.require('sci.impl.max_or_throw');
goog.require('sci.impl.opts');
goog.require('sci.impl.parser');
goog.require('sci.impl.types');
goog.require('sci.impl.utils');
goog.require('sci.impl.vars');

sci.impl.interpreter.macros = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 19, [new cljs.core.Symbol(null,"macroexpand","macroexpand",1509933344,null),"null",new cljs.core.Symbol(null,"try","try",-1273693247,null),"null",new cljs.core.Symbol(null,"lazy-seq","lazy-seq",489632906,null),"null",new cljs.core.Symbol(null,"let","let",358118826,null),"null",new cljs.core.Symbol(null,"fn","fn",465265323,null),"null",new cljs.core.Symbol(null,"do","do",1686842252,null),"null",new cljs.core.Symbol(null,"in-ns","in-ns",-2089468466,null),"null",new cljs.core.Symbol(null,"defn","defn",-126010802,null),"null",new cljs.core.Symbol(null,"if","if",1181717262,null),"null",new cljs.core.Symbol(null,"or","or",1876275696,null),"null",new cljs.core.Symbol(null,"macroexpand-1","macroexpand-1",659241329,null),"null",new cljs.core.Symbol(null,"require","require",1172530194,null),"null",new cljs.core.Symbol(null,"syntax-quote","syntax-quote",407366680,null),"null",new cljs.core.Symbol(null,"set!","set!",250714521,null),"null",new cljs.core.Symbol(null,".",".",1975675962,null),"null",new cljs.core.Symbol(null,"quote","quote",1377916282,null),"null",new cljs.core.Symbol(null,"case","case",-1510733573,null),"null",new cljs.core.Symbol(null,"and","and",668631710,null),"null",new cljs.core.Symbol(null,"def","def",597100991,null),"null"], null), null);
/**
 * The and macro from clojure.core.
 */
sci.impl.interpreter.eval_and = (function sci$impl$interpreter$eval_and(ctx,args){
var args__$1 = cljs.core.seq(args);
var args__$2 = args__$1;
while(true){
if(args__$2){
var x = cljs.core.first(args__$2);
var xs = cljs.core.next(args__$2);
var v = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,x) : sci.impl.interpreter.interpret.call(null,ctx,x));
if(cljs.core.truth_(v)){
if(xs){
var G__42249 = xs;
args__$2 = G__42249;
continue;
} else {
return v;
}
} else {
return v;
}
} else {
return true;
}
break;
}
});
/**
 * The or macro from clojure.core.
 */
sci.impl.interpreter.eval_or = (function sci$impl$interpreter$eval_or(ctx,args){
var args__$1 = cljs.core.seq(args);
var args__$2 = args__$1;
while(true){
if(args__$2){
var x = cljs.core.first(args__$2);
var xs = cljs.core.next(args__$2);
var v = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,x) : sci.impl.interpreter.interpret.call(null,ctx,x));
if(cljs.core.truth_(v)){
return v;
} else {
if(xs){
var G__42250 = xs;
args__$2 = G__42250;
continue;
} else {
return v;
}
}
} else {
return null;
}
break;
}
});
/**
 * The let macro from clojure.core
 */
sci.impl.interpreter.eval_let = (function sci$impl$interpreter$eval_let(var_args){
var args__4742__auto__ = [];
var len__4736__auto___42251 = arguments.length;
var i__4737__auto___42252 = (0);
while(true){
if((i__4737__auto___42252 < len__4736__auto___42251)){
args__4742__auto__.push((arguments[i__4737__auto___42252]));

var G__42253 = (i__4737__auto___42252 + (1));
i__4737__auto___42252 = G__42253;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return sci.impl.interpreter.eval_let.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(sci.impl.interpreter.eval_let.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,let_bindings,exprs){
var ctx__$1 = (function (){var ctx__$1 = ctx;
var let_bindings__$1 = let_bindings;
while(true){
var let_name = cljs.core.first(let_bindings__$1);
var let_bindings__$2 = cljs.core.rest(let_bindings__$1);
var let_val = cljs.core.first(let_bindings__$2);
var rest_let_bindings = cljs.core.next(let_bindings__$2);
var val_tag = (function (){var temp__5735__auto__ = cljs.core.meta(let_val);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return new cljs.core.Keyword(null,"tag","tag",-1290361223).cljs$core$IFn$_invoke$arity$1(m);
} else {
return null;
}
})();
var let_name__$1 = (cljs.core.truth_(val_tag)?cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(let_name,cljs.core.update,new cljs.core.Keyword(null,"tag","tag",-1290361223),((function (ctx__$1,let_bindings__$1,let_name,let_bindings__$2,let_val,rest_let_bindings,val_tag){
return (function (t){
if(cljs.core.truth_(t)){
return t;
} else {
return val_tag;
}
});})(ctx__$1,let_bindings__$1,let_name,let_bindings__$2,let_val,rest_let_bindings,val_tag))
):let_name);
var v = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx__$1,let_val) : sci.impl.interpreter.interpret.call(null,ctx__$1,let_val));
var ctx__$2 = cljs.core.assoc_in(ctx__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bindings","bindings",1271397192),let_name__$1], null),v);
if(cljs.core.not(rest_let_bindings)){
return ctx__$2;
} else {
var G__42254 = ctx__$2;
var G__42255 = rest_let_bindings;
ctx__$1 = G__42254;
let_bindings__$1 = G__42255;
continue;
}
break;
}
})();
if(cljs.core.truth_(exprs)){
var exprs__$1 = exprs;
while(true){
var e = cljs.core.first(exprs__$1);
var ret = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx__$1,e) : sci.impl.interpreter.interpret.call(null,ctx__$1,e));
var nexprs = cljs.core.next(exprs__$1);
if(nexprs){
var G__42256 = nexprs;
exprs__$1 = G__42256;
continue;
} else {
return ret;
}
break;
}
} else {
return null;
}
}));

(sci.impl.interpreter.eval_let.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(sci.impl.interpreter.eval_let.cljs$lang$applyTo = (function (seq41518){
var G__41519 = cljs.core.first(seq41518);
var seq41518__$1 = cljs.core.next(seq41518);
var G__41520 = cljs.core.first(seq41518__$1);
var seq41518__$2 = cljs.core.next(seq41518__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__41519,G__41520,seq41518__$2);
}));

sci.impl.interpreter.eval_if = (function sci$impl$interpreter$eval_if(ctx,expr){
var cond = cljs.core.first(expr);
var expr__$1 = cljs.core.rest(expr);
var then = cljs.core.first(expr__$1);
var expr__$2 = cljs.core.rest(expr__$1);
var else$ = cljs.core.first(expr__$2);
if(cljs.core.truth_((sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,cond) : sci.impl.interpreter.interpret.call(null,ctx,cond)))){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,then) : sci.impl.interpreter.interpret.call(null,ctx,then));
} else {
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,else$) : sci.impl.interpreter.interpret.call(null,ctx,else$));
}
});
sci.impl.interpreter.eval_def = (function sci$impl$interpreter$eval_def(ctx,p__41528){
var vec__41529 = p__41528;
var _def = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41529,(0),null);
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41529,(1),null);
var _QMARK_docstring = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41529,(2),null);
var _QMARK_init = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41529,(3),null);
var docstring = (cljs.core.truth_(_QMARK_init)?_QMARK_docstring:null);
var init = (cljs.core.truth_(docstring)?_QMARK_init:_QMARK_docstring);
var init__$1 = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,init) : sci.impl.interpreter.interpret.call(null,ctx,init));
var m = cljs.core.meta(var_name);
var m__$1 = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,m) : sci.impl.interpreter.interpret.call(null,ctx,m));
var cnn = sci.impl.vars.getName(new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m__$1));
var assoc_in_env = (function (env){
var the_current_ns = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn], null));
var prev = cljs.core.get.cljs$core$IFn$_invoke$arity$2(the_current_ns,var_name);
var v = (cljs.core.truth_((sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("sci.impl","var.unbound","sci.impl/var.unbound",-1824207647),init__$1) : sci.impl.utils.kw_identical_QMARK_.call(null,new cljs.core.Keyword("sci.impl","var.unbound","sci.impl/var.unbound",-1824207647),init__$1)))?(function (){var G__41532 = prev;
cljs.core.alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__41532,cljs.core.merge,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m__$1], 0));

return G__41532;
})():(function (){
sci.impl.vars.bindRoot(prev,init__$1);

cljs.core.alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic(prev,cljs.core.merge,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m__$1], 0));

return prev;
})()
);
var the_current_ns__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(the_current_ns,var_name,v);
return cljs.core.assoc_in(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn], null),the_current_ns__$1);
});
var env = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),assoc_in_env);
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn,var_name], null));
});
sci.impl.interpreter.resolve_symbol = (function sci$impl$interpreter$resolve_symbol(ctx,sym){
var bindings = ctx.get(new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var temp__5733__auto__ = cljs.core.find(bindings,sym);
if(cljs.core.truth_(temp__5733__auto__)){
var v = temp__5733__auto__;
return cljs.core.second(v);
} else {
return sci.impl.utils.throw_error_with_location.cljs$core$IFn$_invoke$arity$2(["Could not resolve symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym),"\nks:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.keys(new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(ctx)))].join(''),sym);
}
});
sci.impl.interpreter.parse_libspec = (function sci$impl$interpreter$parse_libspec(libspec){
if(cljs.core.sequential_QMARK_(libspec)){
var vec__41533 = libspec;
var seq__41534 = cljs.core.seq(vec__41533);
var first__41535 = cljs.core.first(seq__41534);
var seq__41534__$1 = cljs.core.next(seq__41534);
var lib_name = first__41535;
var opts = seq__41534__$1;
var ret = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"lib-name","lib-name",1158024282),lib_name], null);
var G__41539 = opts;
var vec__41540 = G__41539;
var seq__41541 = cljs.core.seq(vec__41540);
var first__41542 = cljs.core.first(seq__41541);
var seq__41541__$1 = cljs.core.next(seq__41541);
var opt_name = first__41542;
var first__41542__$1 = cljs.core.first(seq__41541__$1);
var seq__41541__$2 = cljs.core.next(seq__41541__$1);
var fst_opt = first__41542__$1;
var rst_opts = seq__41541__$2;
var ret__$1 = ret;
var G__41539__$1 = G__41539;
while(true){
var ret__$2 = ret__$1;
var vec__41547 = G__41539__$1;
var seq__41548 = cljs.core.seq(vec__41547);
var first__41549 = cljs.core.first(seq__41548);
var seq__41548__$1 = cljs.core.next(seq__41548);
var opt_name__$1 = first__41549;
var first__41549__$1 = cljs.core.first(seq__41548__$1);
var seq__41548__$2 = cljs.core.next(seq__41548__$1);
var fst_opt__$1 = first__41549__$1;
var rst_opts__$1 = seq__41548__$2;
if(cljs.core.not(opt_name__$1)){
return ret__$2;
} else {
var G__41550 = opt_name__$1;
var G__41550__$1 = (((G__41550 instanceof cljs.core.Keyword))?G__41550.fqn:null);
switch (G__41550__$1) {
case "as":
var G__42258 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret__$2,new cljs.core.Keyword(null,"as","as",1148689641),fst_opt__$1);
var G__42259 = rst_opts__$1;
ret__$1 = G__42258;
G__41539__$1 = G__42259;
continue;

break;
case "reload":
case "reload-all":
case "verbose":
var G__42260 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret__$2,new cljs.core.Keyword(null,"reload","reload",863702807),true);
var G__42261 = cljs.core.cons(fst_opt__$1,rst_opts__$1);
ret__$1 = G__42260;
G__41539__$1 = G__42261;
continue;

break;
case "refer":
case "rename":
case "exclude":
case "only":
var G__42262 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret__$2,opt_name__$1,fst_opt__$1);
var G__42263 = rst_opts__$1;
ret__$1 = G__42262;
G__41539__$1 = G__42263;
continue;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__41550__$1)].join('')));

}
}
break;
}
} else {
if((libspec instanceof cljs.core.Symbol)){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"lib-name","lib-name",1158024282),libspec], null);
} else {
throw (new Error(["Invalid libspec: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(libspec)].join('')));

}
}
});
sci.impl.interpreter.handle_refer_all = (function sci$impl$interpreter$handle_refer_all(the_current_ns,the_loaded_ns,include_sym_QMARK_,rename_sym,only){
var only__$1 = (cljs.core.truth_(only)?cljs.core.set(only):null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ns,p__41551){
var vec__41552 = p__41551;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41552,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41552,(1),null);
if(cljs.core.truth_((((k instanceof cljs.core.Symbol))?(function (){var and__4115__auto__ = (include_sym_QMARK_.cljs$core$IFn$_invoke$arity$1 ? include_sym_QMARK_.cljs$core$IFn$_invoke$arity$1(k) : include_sym_QMARK_.call(null,k));
if(cljs.core.truth_(and__4115__auto__)){
return ((cljs.core.not(only__$1)) || (cljs.core.contains_QMARK_(only__$1,k)));
} else {
return and__4115__auto__;
}
})():false))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ns,(rename_sym.cljs$core$IFn$_invoke$arity$1 ? rename_sym.cljs$core$IFn$_invoke$arity$1(k) : rename_sym.call(null,k)),v);
} else {
return ns;
}
}),the_current_ns,the_loaded_ns);
});
sci.impl.interpreter.handle_require_libspec_env = (function sci$impl$interpreter$handle_require_libspec_env(env,use_QMARK_,current_ns,the_loaded_ns,lib_name,p__41559){
var map__41562 = p__41559;
var map__41562__$1 = (((((!((map__41562 == null))))?(((((map__41562.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41562.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41562):map__41562);
var _parsed_libspec = map__41562__$1;
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41562__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var refer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41562__$1,new cljs.core.Keyword(null,"refer","refer",-964295553));
var rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41562__$1,new cljs.core.Keyword(null,"rename","rename",1508157613));
var exclude = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41562__$1,new cljs.core.Keyword(null,"exclude","exclude",-1230250334));
var only = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41562__$1,new cljs.core.Keyword(null,"only","only",1907811652));
var the_current_ns = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),current_ns], null));
var the_current_ns__$1 = (cljs.core.truth_(as)?cljs.core.assoc_in(the_current_ns,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"aliases","aliases",1346874714),as], null),lib_name):the_current_ns);
var rename_sym = (cljs.core.truth_(rename)?(function (sym){
var or__4126__auto__ = (rename.cljs$core$IFn$_invoke$arity$1 ? rename.cljs$core$IFn$_invoke$arity$1(sym) : rename.call(null,sym));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return sym;
}
}):cljs.core.identity);
var include_sym_QMARK_ = (cljs.core.truth_(exclude)?(function (){var excludes = cljs.core.set(exclude);
return (function (sym){
return (!(cljs.core.contains_QMARK_(excludes,sym)));
});
})():cljs.core.constantly(true));
var the_current_ns__$2 = (cljs.core.truth_(refer)?(cljs.core.truth_((function (){var or__4126__auto__ = (sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"all","all",892129742),refer) : sci.impl.utils.kw_identical_QMARK_.call(null,new cljs.core.Keyword(null,"all","all",892129742),refer));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return use_QMARK_;
}
})())?sci.impl.interpreter.handle_refer_all(the_current_ns__$1,the_loaded_ns,include_sym_QMARK_,rename_sym,null):((cljs.core.sequential_QMARK_(refer))?cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ns,sym){
if(cljs.core.truth_(include_sym_QMARK_(sym))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ns,(rename_sym.cljs$core$IFn$_invoke$arity$1 ? rename_sym.cljs$core$IFn$_invoke$arity$1(sym) : rename_sym.call(null,sym)),(function (){var temp__5733__auto__ = cljs.core.find(the_loaded_ns,sym);
if(cljs.core.truth_(temp__5733__auto__)){
var vec__41565 = temp__5733__auto__;
var _k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41565,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41565,(1),null);
return v;
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym)," does not exist"].join('')));
}
})());
} else {
return ns;
}
}),the_current_ns__$1,refer):(function(){throw (new Error(":refer value must be a sequential collection of symbols"))})()
)):(cljs.core.truth_(use_QMARK_)?sci.impl.interpreter.handle_refer_all(the_current_ns__$1,the_loaded_ns,include_sym_QMARK_,rename_sym,only):the_current_ns__$1
));
var env__$1 = cljs.core.assoc_in(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),current_ns], null),the_current_ns__$2);
return env__$1;
});
sci.impl.interpreter.handle_require_libspec = (function sci$impl$interpreter$handle_require_libspec(ctx,libspec){
var map__41568 = sci.impl.interpreter.parse_libspec(libspec);
var map__41568__$1 = (((((!((map__41568 == null))))?(((((map__41568.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41568.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41568):map__41568);
var parsed_libspec = map__41568__$1;
var lib_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41568__$1,new cljs.core.Keyword(null,"lib-name","lib-name",1158024282));
var reload = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41568__$1,new cljs.core.Keyword(null,"reload","reload",863702807));
var env_STAR_ = new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx);
var env = cljs.core.deref(env_STAR_);
var cnn = sci.impl.vars.current_ns_name();
var namespaces = cljs.core.get.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469));
var use_QMARK_ = new cljs.core.Keyword("sci.impl","use","sci.impl/use",1724565881).cljs$core$IFn$_invoke$arity$1(ctx);
var temp__5733__auto__ = (cljs.core.truth_(reload)?null:cljs.core.get.cljs$core$IFn$_invoke$arity$2(namespaces,lib_name));
if(cljs.core.truth_(temp__5733__auto__)){
var the_loaded_ns = temp__5733__auto__;
return cljs.core.reset_BANG_(env_STAR_,sci.impl.interpreter.handle_require_libspec_env(env,use_QMARK_,cnn,the_loaded_ns,lib_name,parsed_libspec));
} else {
var temp__5733__auto____$1 = new cljs.core.Keyword(null,"load-fn","load-fn",-2121144334).cljs$core$IFn$_invoke$arity$1(ctx);
if(cljs.core.truth_(temp__5733__auto____$1)){
var load_fn = temp__5733__auto____$1;
var temp__5733__auto____$2 = (function (){var G__41570 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),lib_name], null);
return (load_fn.cljs$core$IFn$_invoke$arity$1 ? load_fn.cljs$core$IFn$_invoke$arity$1(G__41570) : load_fn.call(null,G__41570));
})();
if(cljs.core.truth_(temp__5733__auto____$2)){
var map__41571 = temp__5733__auto____$2;
var map__41571__$1 = (((((!((map__41571 == null))))?(((((map__41571.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41571.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41571):map__41571);
var file = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41571__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41571__$1,new cljs.core.Keyword(null,"source","source",-433931539));
try{sci.impl.vars.push_thread_bindings(cljs.core.PersistentArrayMap.createAsIfByAssoc([sci.impl.vars.current_ns,cljs.core.deref(sci.impl.vars.current_ns),sci.impl.vars.current_file,file]));

try{var G__41574_42264 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ctx,new cljs.core.Keyword(null,"bindings","bindings",1271397192),cljs.core.PersistentArrayMap.EMPTY);
var G__41575_42265 = source;
(sci.impl.interpreter.eval_string_STAR_.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.eval_string_STAR_.cljs$core$IFn$_invoke$arity$2(G__41574_42264,G__41575_42265) : sci.impl.interpreter.eval_string_STAR_.call(null,G__41574_42264,G__41575_42265));
}finally {sci.impl.vars.pop_thread_bindings();
}}catch (e41573){if((e41573 instanceof Error)){
var e_42266 = e41573;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(env_STAR_,cljs.core.update,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lib_name], 0));

throw e_42266;
} else {
throw e41573;

}
}
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(env_STAR_,(function (env__$1){
var namespaces__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(env__$1,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469));
var the_loaded_ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(namespaces__$1,lib_name);
return sci.impl.interpreter.handle_require_libspec_env(env__$1,use_QMARK_,cnn,the_loaded_ns,lib_name,parsed_libspec);
}));
} else {
var or__4126__auto__ = (cljs.core.truth_(reload)?(function (){var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(namespaces,lib_name);
if(cljs.core.truth_(temp__5735__auto__)){
var the_loaded_ns = temp__5735__auto__;
return cljs.core.reset_BANG_(env_STAR_,sci.impl.interpreter.handle_require_libspec_env(env,use_QMARK_,cnn,the_loaded_ns,lib_name,parsed_libspec));
} else {
return null;
}
})():null);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw (new Error(["Could not require ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lib_name),"."].join('')));
}
}
} else {
throw (new Error(["Could not require ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lib_name),"."].join('')));
}
}
});
sci.impl.interpreter.eval_require = (function sci$impl$interpreter$eval_require(var_args){
var args__4742__auto__ = [];
var len__4736__auto___42267 = arguments.length;
var i__4737__auto___42268 = (0);
while(true){
if((i__4737__auto___42268 < len__4736__auto___42267)){
args__4742__auto__.push((arguments[i__4737__auto___42268]));

var G__42269 = (i__4737__auto___42268 + (1));
i__4737__auto___42268 = G__42269;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return sci.impl.interpreter.eval_require.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(sci.impl.interpreter.eval_require.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,args){
var libspecs = cljs.core.PersistentVector.EMPTY;
var current_libspec = null;
var args__$1 = args;
while(true){
if(cljs.core.truth_(args__$1)){
var ret = (function (){var G__41584 = ctx;
var G__41585 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41584,G__41585) : sci.impl.interpreter.interpret.call(null,G__41584,G__41585));
})();
if((ret instanceof cljs.core.Symbol)){
var G__42270 = (function (){var G__41586 = libspecs;
if(cljs.core.truth_(current_libspec)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__41586,current_libspec);
} else {
return G__41586;
}
})();
var G__42271 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ret], null);
var G__42272 = cljs.core.next(args__$1);
libspecs = G__42270;
current_libspec = G__42271;
args__$1 = G__42272;
continue;
} else {
if((ret instanceof cljs.core.Keyword)){
var G__42273 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(libspecs,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(current_libspec,ret));
var G__42274 = null;
var G__42275 = cljs.core.next(args__$1);
libspecs = G__42273;
current_libspec = G__42274;
args__$1 = G__42275;
continue;
} else {
var G__42276 = (function (){var G__41587 = libspecs;
if(cljs.core.truth_(current_libspec)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__41587,current_libspec);
} else {
return G__41587;
}
})();
var G__42277 = ret;
var G__42278 = cljs.core.next(args__$1);
libspecs = G__42276;
current_libspec = G__42277;
args__$1 = G__42278;
continue;

}
}
} else {
var libspecs__$1 = (function (){var G__41588 = libspecs;
if(cljs.core.truth_(current_libspec)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__41588,current_libspec);
} else {
return G__41588;
}
})();
return cljs.core.run_BANG_(((function (libspecs,current_libspec,args__$1,libspecs__$1){
return (function (p1__41576_SHARP_){
return sci.impl.interpreter.handle_require_libspec(ctx,p1__41576_SHARP_);
});})(libspecs,current_libspec,args__$1,libspecs__$1))
,libspecs__$1);
}
break;
}
}));

(sci.impl.interpreter.eval_require.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sci.impl.interpreter.eval_require.cljs$lang$applyTo = (function (seq41577){
var G__41578 = cljs.core.first(seq41577);
var seq41577__$1 = cljs.core.next(seq41577);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__41578,seq41577__$1);
}));

cljs.core.vreset_BANG_(sci.impl.utils.eval_require_state,sci.impl.interpreter.eval_require);
sci.impl.interpreter.eval_use = (function sci$impl$interpreter$eval_use(var_args){
var args__4742__auto__ = [];
var len__4736__auto___42279 = arguments.length;
var i__4737__auto___42280 = (0);
while(true){
if((i__4737__auto___42280 < len__4736__auto___42279)){
args__4742__auto__.push((arguments[i__4737__auto___42280]));

var G__42281 = (i__4737__auto___42280 + (1));
i__4737__auto___42280 = G__42281;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return sci.impl.interpreter.eval_use.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(sci.impl.interpreter.eval_use.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(sci.impl.interpreter.eval_require,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ctx,new cljs.core.Keyword("sci.impl","use","sci.impl/use",1724565881),true),args);
}));

(sci.impl.interpreter.eval_use.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sci.impl.interpreter.eval_use.cljs$lang$applyTo = (function (seq41589){
var G__41590 = cljs.core.first(seq41589);
var seq41589__$1 = cljs.core.next(seq41589);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__41590,seq41589__$1);
}));

cljs.core.vreset_BANG_(sci.impl.utils.eval_use_state,sci.impl.interpreter.eval_use);
sci.impl.interpreter.eval_case = (function sci$impl$interpreter$eval_case(ctx,p__41591){
var vec__41592 = p__41591;
var _case = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41592,(0),null);
var map__41595 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41592,(1),null);
var map__41595__$1 = (((((!((map__41595 == null))))?(((((map__41595.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41595.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41595):map__41595);
var case_map = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41595__$1,new cljs.core.Keyword(null,"case-map","case-map",955082964));
var case_val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41595__$1,new cljs.core.Keyword(null,"case-val","case-val",880926521));
var case_default = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41595__$1,new cljs.core.Keyword(null,"case-default","case-default",1140470708));
var v = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,case_val) : sci.impl.interpreter.interpret.call(null,ctx,case_val));
var temp__5733__auto__ = cljs.core.find(case_map,v);
if(cljs.core.truth_(temp__5733__auto__)){
var vec__41597 = temp__5733__auto__;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41597,(0),null);
var found = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41597,(1),null);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,found) : sci.impl.interpreter.interpret.call(null,ctx,found));
} else {
if(cljs.core.vector_QMARK_(case_default)){
var G__41600 = ctx;
var G__41601 = cljs.core.second(case_default);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41600,G__41601) : sci.impl.interpreter.interpret.call(null,G__41600,G__41601));
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')));
}
}
});
sci.impl.interpreter.eval_try = (function sci$impl$interpreter$eval_try(ctx,expr){
var map__41602 = new cljs.core.Keyword("sci.impl","try","sci.impl/try",2142624741).cljs$core$IFn$_invoke$arity$1(expr);
var map__41602__$1 = (((((!((map__41602 == null))))?(((((map__41602.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41602.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41602):map__41602);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41602__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var catches = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41602__$1,new cljs.core.Keyword(null,"catches","catches",-1478797617));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41602__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
try{var _STAR_in_try_STAR__orig_val__41610 = sci.impl.utils._STAR_in_try_STAR_;
var _STAR_in_try_STAR__temp_val__41611 = true;
(sci.impl.utils._STAR_in_try_STAR_ = _STAR_in_try_STAR__temp_val__41611);

try{return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,body) : sci.impl.interpreter.interpret.call(null,ctx,body));
}finally {(sci.impl.utils._STAR_in_try_STAR_ = _STAR_in_try_STAR__orig_val__41610);
}}catch (e41604){if((e41604 instanceof Error)){
var e = e41604;
var temp__5733__auto__ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (_,c){
var clazz = new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(c);
if((e instanceof clazz)){
return cljs.core.reduced(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sci.impl.interpreter","try-result","sci.impl.interpreter/try-result",1789456125),(function (){var G__41605 = cljs.core.assoc_in(ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bindings","bindings",1271397192),new cljs.core.Keyword(null,"binding","binding",539932593).cljs$core$IFn$_invoke$arity$1(c)], null),e);
var G__41606 = new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(c);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41605,G__41606) : sci.impl.interpreter.interpret.call(null,G__41605,G__41606));
})()], null));
} else {
return null;
}
}),null,catches);
if(cljs.core.truth_(temp__5733__auto__)){
var vec__41607 = temp__5733__auto__;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41607,(0),null);
var r = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41607,(1),null);
return r;
} else {
return sci.impl.utils.rethrow_with_location_of_node(ctx,e,body);
}
} else {
throw e41604;

}
}finally {(sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,finally$) : sci.impl.interpreter.interpret.call(null,ctx,finally$));
}});
sci.impl.interpreter.eval_throw = (function sci$impl$interpreter$eval_throw(ctx,p__41612){
var vec__41613 = p__41612;
var _throw = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41613,(0),null);
var ex = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41613,(1),null);
var ex__$1 = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,ex) : sci.impl.interpreter.interpret.call(null,ctx,ex));
throw ex__$1;
});
sci.impl.interpreter.eval_static_method_invocation = (function sci$impl$interpreter$eval_static_method_invocation(ctx,expr){
return sci.impl.interop.invoke_static_method(cljs.core.first(expr),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__41616_SHARP_){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,p1__41616_SHARP_) : sci.impl.interpreter.interpret.call(null,ctx,p1__41616_SHARP_));
}),cljs.core.rest(expr)));
});
sci.impl.interpreter.eval_constructor_invocation = (function sci$impl$interpreter$eval_constructor_invocation(ctx,p__41618){
var vec__41619 = p__41618;
var _new = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41619,(0),null);
var constructor$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41619,(1),null);
var args = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41619,(2),null);
var args__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__41617_SHARP_){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,p1__41617_SHARP_) : sci.impl.interpreter.interpret.call(null,ctx,p1__41617_SHARP_));
}),args);
return sci.impl.interop.invoke_constructor(constructor$,args__$1);
});
sci.impl.interpreter.eval_instance_method_invocation = (function sci$impl$interpreter$eval_instance_method_invocation(p__41624,p__41625){
var map__41626 = p__41624;
var map__41626__$1 = (((((!((map__41626 == null))))?(((((map__41626.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41626.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41626):map__41626);
var ctx = map__41626__$1;
var class__GT_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41626__$1,new cljs.core.Keyword(null,"class->opts","class->opts",2061906477));
var vec__41627 = p__41625;
var _dot = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41627,(0),null);
var instance_expr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41627,(1),null);
var method_str = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41627,(2),null);
var args = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41627,(3),null);
var instance_meta = cljs.core.meta(instance_expr);
var tag_class = new cljs.core.Keyword(null,"tag-class","tag-class",714967874).cljs$core$IFn$_invoke$arity$1(instance_meta);
var instance_expr_STAR_ = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,instance_expr) : sci.impl.interpreter.interpret.call(null,ctx,instance_expr));
var instance_class = (function (){var or__4126__auto__ = tag_class;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.type(instance_expr_STAR_);
}
})();
var instance_class_name = instance_class.name;
var instance_class_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(instance_class_name);
var allowed_QMARK_ = (function (){var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(class__GT_opts,new cljs.core.Keyword(null,"allow","allow",-1857325745));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(class__GT_opts,instance_class_symbol);
}
})();
var target_class = (cljs.core.truth_(allowed_QMARK_)?instance_class:(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"public-class","public-class",1127293019).cljs$core$IFn$_invoke$arity$1(ctx);
if(cljs.core.truth_(temp__5735__auto__)){
var f = temp__5735__auto__;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(instance_expr_STAR_) : f.call(null,instance_expr_STAR_));
} else {
return null;
}
})());
if(cljs.core.truth_(target_class)){
} else {
sci.impl.utils.throw_error_with_location.cljs$core$IFn$_invoke$arity$2(["Method ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(method_str)," on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(instance_class)," not allowed!"].join(''),instance_expr);
}

var args__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__41623_SHARP_){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,p1__41623_SHARP_) : sci.impl.interpreter.interpret.call(null,ctx,p1__41623_SHARP_));
}),args);
return sci.impl.interop.invoke_instance_method(instance_expr_STAR_,target_class,method_str,args__$1);
});
sci.impl.interpreter.eval_in_ns = (function sci$impl$interpreter$eval_in_ns(ctx,p__41631){
var vec__41632 = p__41631;
var _in_ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41632,(0),null);
var ns_expr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41632,(1),null);
var ns_sym = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,ns_expr) : sci.impl.interpreter.interpret.call(null,ctx,ns_expr));
sci.impl.utils.set_namespace_BANG_(ctx,ns_sym,null);

return null;
});
sci.impl.interpreter.eval_refer = (function sci$impl$interpreter$eval_refer(ctx,p__41635){
var vec__41636 = p__41635;
var seq__41637 = cljs.core.seq(vec__41636);
var first__41638 = cljs.core.first(seq__41637);
var seq__41637__$1 = cljs.core.next(seq__41637);
var _ = first__41638;
var first__41638__$1 = cljs.core.first(seq__41637__$1);
var seq__41637__$2 = cljs.core.next(seq__41637__$1);
var ns_sym = first__41638__$1;
var exprs = seq__41637__$2;
var ns_sym__$1 = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,ns_sym) : sci.impl.interpreter.interpret.call(null,ctx,ns_sym));
var exprs__$1 = exprs;
while(true){
if(exprs__$1){
var vec__41639 = exprs__$1;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41639,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41639,(1),null);
var G__41642_42282 = k;
var G__41642_42283__$1 = (((G__41642_42282 instanceof cljs.core.Keyword))?G__41642_42282.fqn:null);
switch (G__41642_42283__$1) {
case "exclude":
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),((function (exprs__$1,G__41642_42282,G__41642_42283__$1,vec__41639,k,v,ns_sym__$1,vec__41636,seq__41637,first__41638,seq__41637__$1,_,first__41638__$1,seq__41637__$2,ns_sym,exprs){
return (function (env){
var cnn = sci.impl.vars.current_ns_name();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(env,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn,new cljs.core.Keyword(null,"refer","refer",-964295553),ns_sym__$1,new cljs.core.Keyword(null,"exclude","exclude",-1230250334)], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.into,cljs.core.PersistentHashSet.EMPTY),v);
});})(exprs__$1,G__41642_42282,G__41642_42283__$1,vec__41639,k,v,ns_sym__$1,vec__41636,seq__41637,first__41638,seq__41637__$1,_,first__41638__$1,seq__41637__$2,ns_sym,exprs))
);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__41642_42283__$1)].join('')));

}

var G__42285 = cljs.core.nnext(exprs__$1);
exprs__$1 = G__42285;
continue;
} else {
return null;
}
break;
}
});
sci.impl.interpreter.eval_resolve = (function sci$impl$interpreter$eval_resolve(ctx,sym){
var sym__$1 = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,sym) : sci.impl.interpreter.interpret.call(null,ctx,sym));
return cljs.core.second(sci.impl.analyzer.lookup(ctx,sym__$1,false));
});
cljs.core.vreset_BANG_(sci.impl.utils.eval_resolve_state,sci.impl.interpreter.eval_resolve);
sci.impl.interpreter.macroexpand_1 = (function sci$impl$interpreter$macroexpand_1(ctx,expr){
var original_expr = expr;
if(cljs.core.seq_QMARK_(expr)){
var op = cljs.core.first(expr);
if((op instanceof cljs.core.Symbol)){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(sci.impl.analyzer.special_syms,op))){
return expr;
} else {
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"for","for",316745208,null),null], null), null),op)){
return sci.impl.analyzer.analyze(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ctx,new cljs.core.Keyword("sci.impl","macroexpanding","sci.impl/macroexpanding",2113471825),true),expr);
} else {
var f = sci.impl.analyzer.resolve_symbol.cljs$core$IFn$_invoke$arity$3(ctx,op,true);
var f__$1 = (cljs.core.truth_(((sci.impl.vars.var_QMARK_(f))?sci.impl.vars.isMacro(f):false))?cljs.core.deref(f):f);
if(cljs.core.truth_(sci.impl.analyzer.macro_QMARK_(f__$1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f__$1,original_expr,new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(ctx),cljs.core.rest(expr));
} else {
return expr;
}

}
}
} else {
return expr;
}
} else {
return expr;
}
});
sci.impl.interpreter.macroexpand = (function sci$impl$interpreter$macroexpand(ctx,form){
var ex = sci.impl.interpreter.macroexpand_1(ctx,form);
if((ex === form)){
return form;
} else {
return (sci.impl.interpreter.macroexpand.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.macroexpand.cljs$core$IFn$_invoke$arity$2(ctx,ex) : sci.impl.interpreter.macroexpand.call(null,ctx,ex));
}
});
sci.impl.interpreter.eval_set_BANG_ = (function sci$impl$interpreter$eval_set_BANG_(ctx,p__41643){
var vec__41644 = p__41643;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41644,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41644,(1),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41644,(2),null);
var obj__$1 = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,obj) : sci.impl.interpreter.interpret.call(null,ctx,obj));
var v__$1 = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,v) : sci.impl.interpreter.interpret.call(null,ctx,v));
if(sci.impl.vars.var_QMARK_(obj__$1)){
return sci.impl.types.setVal(obj__$1,v__$1);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot set ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(obj__$1)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(v__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"obj","obj",981763962),obj__$1,new cljs.core.Keyword(null,"v","v",21465059),v__$1], null));
}
});
sci.impl.interpreter.eval_do_STAR_ = (function sci$impl$interpreter$eval_do_STAR_(ctx,exprs){
var G__41650 = exprs;
var vec__41651 = G__41650;
var seq__41652 = cljs.core.seq(vec__41651);
var first__41653 = cljs.core.first(seq__41652);
var seq__41652__$1 = cljs.core.next(seq__41652);
var expr = first__41653;
var exprs__$1 = seq__41652__$1;
var G__41650__$1 = G__41650;
while(true){
var vec__41654 = G__41650__$1;
var seq__41655 = cljs.core.seq(vec__41654);
var first__41656 = cljs.core.first(seq__41655);
var seq__41655__$1 = cljs.core.next(seq__41655);
var expr__$1 = first__41656;
var exprs__$2 = seq__41655__$1;
var ret = (function (){try{return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,expr__$1) : sci.impl.interpreter.interpret.call(null,ctx,expr__$1));
}catch (e41657){if((e41657 instanceof Error)){
var e = e41657;
return sci.impl.utils.rethrow_with_location_of_node(ctx,e,expr__$1);
} else {
throw e41657;

}
}})();
var temp__5733__auto__ = cljs.core.seq(exprs__$2);
if(temp__5733__auto__){
var exprs__$3 = temp__5733__auto__;
var G__42286 = exprs__$3;
G__41650__$1 = G__42286;
continue;
} else {
return ret;
}
break;
}
});
sci.impl.interpreter.eval_do = (function sci$impl$interpreter$eval_do(ctx,expr){
var temp__5735__auto__ = cljs.core.next(expr);
if(temp__5735__auto__){
var exprs = temp__5735__auto__;
return sci.impl.interpreter.eval_do_STAR_(ctx,exprs);
} else {
return null;
}
});
sci.impl.interpreter.fn_call = (function sci$impl$interpreter$fn_call(ctx,f,args){
var G__41850 = cljs.core.count(args);
switch (G__41850) {
case (0):
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));

break;
case (1):
var arg41660 = (function (){var G__41851 = ctx;
var G__41852 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41851,G__41852) : sci.impl.interpreter.interpret.call(null,G__41851,G__41852));
})();
var args__$1 = cljs.core.rest(args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg41660) : f.call(null,arg41660));

break;
case (2):
var arg41661 = (function (){var G__41853 = ctx;
var G__41854 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41853,G__41854) : sci.impl.interpreter.interpret.call(null,G__41853,G__41854));
})();
var args__$1 = cljs.core.rest(args);
var arg41662 = (function (){var G__41855 = ctx;
var G__41856 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41855,G__41856) : sci.impl.interpreter.interpret.call(null,G__41855,G__41856));
})();
var args__$2 = cljs.core.rest(args__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg41661,arg41662) : f.call(null,arg41661,arg41662));

break;
case (3):
var arg41663 = (function (){var G__41857 = ctx;
var G__41858 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41857,G__41858) : sci.impl.interpreter.interpret.call(null,G__41857,G__41858));
})();
var args__$1 = cljs.core.rest(args);
var arg41664 = (function (){var G__41859 = ctx;
var G__41860 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41859,G__41860) : sci.impl.interpreter.interpret.call(null,G__41859,G__41860));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg41665 = (function (){var G__41861 = ctx;
var G__41862 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41861,G__41862) : sci.impl.interpreter.interpret.call(null,G__41861,G__41862));
})();
var args__$3 = cljs.core.rest(args__$2);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg41663,arg41664,arg41665) : f.call(null,arg41663,arg41664,arg41665));

break;
case (4):
var arg41666 = (function (){var G__41863 = ctx;
var G__41864 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41863,G__41864) : sci.impl.interpreter.interpret.call(null,G__41863,G__41864));
})();
var args__$1 = cljs.core.rest(args);
var arg41667 = (function (){var G__41865 = ctx;
var G__41866 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41865,G__41866) : sci.impl.interpreter.interpret.call(null,G__41865,G__41866));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg41668 = (function (){var G__41867 = ctx;
var G__41868 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41867,G__41868) : sci.impl.interpreter.interpret.call(null,G__41867,G__41868));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg41669 = (function (){var G__41869 = ctx;
var G__41870 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41869,G__41870) : sci.impl.interpreter.interpret.call(null,G__41869,G__41870));
})();
var args__$4 = cljs.core.rest(args__$3);
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg41666,arg41667,arg41668,arg41669) : f.call(null,arg41666,arg41667,arg41668,arg41669));

break;
case (5):
var arg41670 = (function (){var G__41871 = ctx;
var G__41872 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41871,G__41872) : sci.impl.interpreter.interpret.call(null,G__41871,G__41872));
})();
var args__$1 = cljs.core.rest(args);
var arg41671 = (function (){var G__41873 = ctx;
var G__41874 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41873,G__41874) : sci.impl.interpreter.interpret.call(null,G__41873,G__41874));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg41672 = (function (){var G__41875 = ctx;
var G__41876 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41875,G__41876) : sci.impl.interpreter.interpret.call(null,G__41875,G__41876));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg41673 = (function (){var G__41877 = ctx;
var G__41878 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41877,G__41878) : sci.impl.interpreter.interpret.call(null,G__41877,G__41878));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg41674 = (function (){var G__41879 = ctx;
var G__41880 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41879,G__41880) : sci.impl.interpreter.interpret.call(null,G__41879,G__41880));
})();
var args__$5 = cljs.core.rest(args__$4);
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg41670,arg41671,arg41672,arg41673,arg41674) : f.call(null,arg41670,arg41671,arg41672,arg41673,arg41674));

break;
case (6):
var arg41675 = (function (){var G__41881 = ctx;
var G__41882 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41881,G__41882) : sci.impl.interpreter.interpret.call(null,G__41881,G__41882));
})();
var args__$1 = cljs.core.rest(args);
var arg41676 = (function (){var G__41883 = ctx;
var G__41884 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41883,G__41884) : sci.impl.interpreter.interpret.call(null,G__41883,G__41884));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg41677 = (function (){var G__41885 = ctx;
var G__41886 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41885,G__41886) : sci.impl.interpreter.interpret.call(null,G__41885,G__41886));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg41678 = (function (){var G__41887 = ctx;
var G__41888 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41887,G__41888) : sci.impl.interpreter.interpret.call(null,G__41887,G__41888));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg41679 = (function (){var G__41889 = ctx;
var G__41890 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41889,G__41890) : sci.impl.interpreter.interpret.call(null,G__41889,G__41890));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg41680 = (function (){var G__41891 = ctx;
var G__41892 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41891,G__41892) : sci.impl.interpreter.interpret.call(null,G__41891,G__41892));
})();
var args__$6 = cljs.core.rest(args__$5);
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg41675,arg41676,arg41677,arg41678,arg41679,arg41680) : f.call(null,arg41675,arg41676,arg41677,arg41678,arg41679,arg41680));

break;
case (7):
var arg41681 = (function (){var G__41893 = ctx;
var G__41894 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41893,G__41894) : sci.impl.interpreter.interpret.call(null,G__41893,G__41894));
})();
var args__$1 = cljs.core.rest(args);
var arg41682 = (function (){var G__41895 = ctx;
var G__41896 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41895,G__41896) : sci.impl.interpreter.interpret.call(null,G__41895,G__41896));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg41683 = (function (){var G__41897 = ctx;
var G__41898 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41897,G__41898) : sci.impl.interpreter.interpret.call(null,G__41897,G__41898));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg41684 = (function (){var G__41899 = ctx;
var G__41900 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41899,G__41900) : sci.impl.interpreter.interpret.call(null,G__41899,G__41900));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg41685 = (function (){var G__41901 = ctx;
var G__41902 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41901,G__41902) : sci.impl.interpreter.interpret.call(null,G__41901,G__41902));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg41686 = (function (){var G__41903 = ctx;
var G__41904 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41903,G__41904) : sci.impl.interpreter.interpret.call(null,G__41903,G__41904));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg41687 = (function (){var G__41905 = ctx;
var G__41906 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41905,G__41906) : sci.impl.interpreter.interpret.call(null,G__41905,G__41906));
})();
var args__$7 = cljs.core.rest(args__$6);
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(arg41681,arg41682,arg41683,arg41684,arg41685,arg41686,arg41687) : f.call(null,arg41681,arg41682,arg41683,arg41684,arg41685,arg41686,arg41687));

break;
case (8):
var arg41688 = (function (){var G__41907 = ctx;
var G__41908 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41907,G__41908) : sci.impl.interpreter.interpret.call(null,G__41907,G__41908));
})();
var args__$1 = cljs.core.rest(args);
var arg41689 = (function (){var G__41909 = ctx;
var G__41910 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41909,G__41910) : sci.impl.interpreter.interpret.call(null,G__41909,G__41910));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg41690 = (function (){var G__41911 = ctx;
var G__41912 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41911,G__41912) : sci.impl.interpreter.interpret.call(null,G__41911,G__41912));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg41691 = (function (){var G__41913 = ctx;
var G__41914 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41913,G__41914) : sci.impl.interpreter.interpret.call(null,G__41913,G__41914));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg41692 = (function (){var G__41915 = ctx;
var G__41916 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41915,G__41916) : sci.impl.interpreter.interpret.call(null,G__41915,G__41916));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg41693 = (function (){var G__41917 = ctx;
var G__41918 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41917,G__41918) : sci.impl.interpreter.interpret.call(null,G__41917,G__41918));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg41694 = (function (){var G__41919 = ctx;
var G__41920 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41919,G__41920) : sci.impl.interpreter.interpret.call(null,G__41919,G__41920));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg41695 = (function (){var G__41921 = ctx;
var G__41922 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41921,G__41922) : sci.impl.interpreter.interpret.call(null,G__41921,G__41922));
})();
var args__$8 = cljs.core.rest(args__$7);
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(arg41688,arg41689,arg41690,arg41691,arg41692,arg41693,arg41694,arg41695) : f.call(null,arg41688,arg41689,arg41690,arg41691,arg41692,arg41693,arg41694,arg41695));

break;
case (9):
var arg41696 = (function (){var G__41923 = ctx;
var G__41924 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41923,G__41924) : sci.impl.interpreter.interpret.call(null,G__41923,G__41924));
})();
var args__$1 = cljs.core.rest(args);
var arg41697 = (function (){var G__41925 = ctx;
var G__41926 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41925,G__41926) : sci.impl.interpreter.interpret.call(null,G__41925,G__41926));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg41698 = (function (){var G__41927 = ctx;
var G__41928 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41927,G__41928) : sci.impl.interpreter.interpret.call(null,G__41927,G__41928));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg41699 = (function (){var G__41929 = ctx;
var G__41930 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41929,G__41930) : sci.impl.interpreter.interpret.call(null,G__41929,G__41930));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg41700 = (function (){var G__41931 = ctx;
var G__41932 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41931,G__41932) : sci.impl.interpreter.interpret.call(null,G__41931,G__41932));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg41701 = (function (){var G__41933 = ctx;
var G__41934 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41933,G__41934) : sci.impl.interpreter.interpret.call(null,G__41933,G__41934));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg41702 = (function (){var G__41935 = ctx;
var G__41936 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41935,G__41936) : sci.impl.interpreter.interpret.call(null,G__41935,G__41936));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg41703 = (function (){var G__41937 = ctx;
var G__41938 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41937,G__41938) : sci.impl.interpreter.interpret.call(null,G__41937,G__41938));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg41704 = (function (){var G__41939 = ctx;
var G__41940 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41939,G__41940) : sci.impl.interpreter.interpret.call(null,G__41939,G__41940));
})();
var args__$9 = cljs.core.rest(args__$8);
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(arg41696,arg41697,arg41698,arg41699,arg41700,arg41701,arg41702,arg41703,arg41704) : f.call(null,arg41696,arg41697,arg41698,arg41699,arg41700,arg41701,arg41702,arg41703,arg41704));

break;
case (10):
var arg41705 = (function (){var G__41941 = ctx;
var G__41942 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41941,G__41942) : sci.impl.interpreter.interpret.call(null,G__41941,G__41942));
})();
var args__$1 = cljs.core.rest(args);
var arg41706 = (function (){var G__41943 = ctx;
var G__41944 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41943,G__41944) : sci.impl.interpreter.interpret.call(null,G__41943,G__41944));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg41707 = (function (){var G__41945 = ctx;
var G__41946 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41945,G__41946) : sci.impl.interpreter.interpret.call(null,G__41945,G__41946));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg41708 = (function (){var G__41947 = ctx;
var G__41948 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41947,G__41948) : sci.impl.interpreter.interpret.call(null,G__41947,G__41948));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg41709 = (function (){var G__41949 = ctx;
var G__41950 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41949,G__41950) : sci.impl.interpreter.interpret.call(null,G__41949,G__41950));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg41710 = (function (){var G__41951 = ctx;
var G__41952 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41951,G__41952) : sci.impl.interpreter.interpret.call(null,G__41951,G__41952));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg41711 = (function (){var G__41953 = ctx;
var G__41954 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41953,G__41954) : sci.impl.interpreter.interpret.call(null,G__41953,G__41954));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg41712 = (function (){var G__41955 = ctx;
var G__41956 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41955,G__41956) : sci.impl.interpreter.interpret.call(null,G__41955,G__41956));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg41713 = (function (){var G__41957 = ctx;
var G__41958 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41957,G__41958) : sci.impl.interpreter.interpret.call(null,G__41957,G__41958));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg41714 = (function (){var G__41959 = ctx;
var G__41960 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41959,G__41960) : sci.impl.interpreter.interpret.call(null,G__41959,G__41960));
})();
var args__$10 = cljs.core.rest(args__$9);
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(arg41705,arg41706,arg41707,arg41708,arg41709,arg41710,arg41711,arg41712,arg41713,arg41714) : f.call(null,arg41705,arg41706,arg41707,arg41708,arg41709,arg41710,arg41711,arg41712,arg41713,arg41714));

break;
case (11):
var arg41715 = (function (){var G__41961 = ctx;
var G__41962 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41961,G__41962) : sci.impl.interpreter.interpret.call(null,G__41961,G__41962));
})();
var args__$1 = cljs.core.rest(args);
var arg41716 = (function (){var G__41963 = ctx;
var G__41964 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41963,G__41964) : sci.impl.interpreter.interpret.call(null,G__41963,G__41964));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg41717 = (function (){var G__41965 = ctx;
var G__41966 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41965,G__41966) : sci.impl.interpreter.interpret.call(null,G__41965,G__41966));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg41718 = (function (){var G__41967 = ctx;
var G__41968 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41967,G__41968) : sci.impl.interpreter.interpret.call(null,G__41967,G__41968));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg41719 = (function (){var G__41969 = ctx;
var G__41970 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41969,G__41970) : sci.impl.interpreter.interpret.call(null,G__41969,G__41970));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg41720 = (function (){var G__41971 = ctx;
var G__41972 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41971,G__41972) : sci.impl.interpreter.interpret.call(null,G__41971,G__41972));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg41721 = (function (){var G__41973 = ctx;
var G__41974 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41973,G__41974) : sci.impl.interpreter.interpret.call(null,G__41973,G__41974));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg41722 = (function (){var G__41975 = ctx;
var G__41976 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41975,G__41976) : sci.impl.interpreter.interpret.call(null,G__41975,G__41976));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg41723 = (function (){var G__41977 = ctx;
var G__41978 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41977,G__41978) : sci.impl.interpreter.interpret.call(null,G__41977,G__41978));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg41724 = (function (){var G__41979 = ctx;
var G__41980 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41979,G__41980) : sci.impl.interpreter.interpret.call(null,G__41979,G__41980));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg41725 = (function (){var G__41981 = ctx;
var G__41982 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41981,G__41982) : sci.impl.interpreter.interpret.call(null,G__41981,G__41982));
})();
var args__$11 = cljs.core.rest(args__$10);
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(arg41715,arg41716,arg41717,arg41718,arg41719,arg41720,arg41721,arg41722,arg41723,arg41724,arg41725) : f.call(null,arg41715,arg41716,arg41717,arg41718,arg41719,arg41720,arg41721,arg41722,arg41723,arg41724,arg41725));

break;
case (12):
var arg41726 = (function (){var G__41983 = ctx;
var G__41984 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41983,G__41984) : sci.impl.interpreter.interpret.call(null,G__41983,G__41984));
})();
var args__$1 = cljs.core.rest(args);
var arg41727 = (function (){var G__41985 = ctx;
var G__41986 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41985,G__41986) : sci.impl.interpreter.interpret.call(null,G__41985,G__41986));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg41728 = (function (){var G__41987 = ctx;
var G__41988 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41987,G__41988) : sci.impl.interpreter.interpret.call(null,G__41987,G__41988));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg41729 = (function (){var G__41989 = ctx;
var G__41990 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41989,G__41990) : sci.impl.interpreter.interpret.call(null,G__41989,G__41990));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg41730 = (function (){var G__41991 = ctx;
var G__41992 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41991,G__41992) : sci.impl.interpreter.interpret.call(null,G__41991,G__41992));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg41731 = (function (){var G__41993 = ctx;
var G__41994 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41993,G__41994) : sci.impl.interpreter.interpret.call(null,G__41993,G__41994));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg41732 = (function (){var G__41995 = ctx;
var G__41996 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41995,G__41996) : sci.impl.interpreter.interpret.call(null,G__41995,G__41996));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg41733 = (function (){var G__41997 = ctx;
var G__41998 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41997,G__41998) : sci.impl.interpreter.interpret.call(null,G__41997,G__41998));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg41734 = (function (){var G__41999 = ctx;
var G__42000 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__41999,G__42000) : sci.impl.interpreter.interpret.call(null,G__41999,G__42000));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg41735 = (function (){var G__42001 = ctx;
var G__42002 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42001,G__42002) : sci.impl.interpreter.interpret.call(null,G__42001,G__42002));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg41736 = (function (){var G__42003 = ctx;
var G__42004 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42003,G__42004) : sci.impl.interpreter.interpret.call(null,G__42003,G__42004));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg41737 = (function (){var G__42005 = ctx;
var G__42006 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42005,G__42006) : sci.impl.interpreter.interpret.call(null,G__42005,G__42006));
})();
var args__$12 = cljs.core.rest(args__$11);
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(arg41726,arg41727,arg41728,arg41729,arg41730,arg41731,arg41732,arg41733,arg41734,arg41735,arg41736,arg41737) : f.call(null,arg41726,arg41727,arg41728,arg41729,arg41730,arg41731,arg41732,arg41733,arg41734,arg41735,arg41736,arg41737));

break;
case (13):
var arg41738 = (function (){var G__42007 = ctx;
var G__42008 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42007,G__42008) : sci.impl.interpreter.interpret.call(null,G__42007,G__42008));
})();
var args__$1 = cljs.core.rest(args);
var arg41739 = (function (){var G__42009 = ctx;
var G__42010 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42009,G__42010) : sci.impl.interpreter.interpret.call(null,G__42009,G__42010));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg41740 = (function (){var G__42011 = ctx;
var G__42012 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42011,G__42012) : sci.impl.interpreter.interpret.call(null,G__42011,G__42012));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg41741 = (function (){var G__42013 = ctx;
var G__42014 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42013,G__42014) : sci.impl.interpreter.interpret.call(null,G__42013,G__42014));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg41742 = (function (){var G__42015 = ctx;
var G__42016 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42015,G__42016) : sci.impl.interpreter.interpret.call(null,G__42015,G__42016));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg41743 = (function (){var G__42017 = ctx;
var G__42018 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42017,G__42018) : sci.impl.interpreter.interpret.call(null,G__42017,G__42018));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg41744 = (function (){var G__42019 = ctx;
var G__42020 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42019,G__42020) : sci.impl.interpreter.interpret.call(null,G__42019,G__42020));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg41745 = (function (){var G__42021 = ctx;
var G__42022 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42021,G__42022) : sci.impl.interpreter.interpret.call(null,G__42021,G__42022));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg41746 = (function (){var G__42023 = ctx;
var G__42024 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42023,G__42024) : sci.impl.interpreter.interpret.call(null,G__42023,G__42024));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg41747 = (function (){var G__42025 = ctx;
var G__42026 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42025,G__42026) : sci.impl.interpreter.interpret.call(null,G__42025,G__42026));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg41748 = (function (){var G__42027 = ctx;
var G__42028 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42027,G__42028) : sci.impl.interpreter.interpret.call(null,G__42027,G__42028));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg41749 = (function (){var G__42029 = ctx;
var G__42030 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42029,G__42030) : sci.impl.interpreter.interpret.call(null,G__42029,G__42030));
})();
var args__$12 = cljs.core.rest(args__$11);
var arg41750 = (function (){var G__42031 = ctx;
var G__42032 = cljs.core.first(args__$12);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42031,G__42032) : sci.impl.interpreter.interpret.call(null,G__42031,G__42032));
})();
var args__$13 = cljs.core.rest(args__$12);
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(arg41738,arg41739,arg41740,arg41741,arg41742,arg41743,arg41744,arg41745,arg41746,arg41747,arg41748,arg41749,arg41750) : f.call(null,arg41738,arg41739,arg41740,arg41741,arg41742,arg41743,arg41744,arg41745,arg41746,arg41747,arg41748,arg41749,arg41750));

break;
case (14):
var arg41751 = (function (){var G__42033 = ctx;
var G__42034 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42033,G__42034) : sci.impl.interpreter.interpret.call(null,G__42033,G__42034));
})();
var args__$1 = cljs.core.rest(args);
var arg41752 = (function (){var G__42035 = ctx;
var G__42036 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42035,G__42036) : sci.impl.interpreter.interpret.call(null,G__42035,G__42036));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg41753 = (function (){var G__42037 = ctx;
var G__42038 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42037,G__42038) : sci.impl.interpreter.interpret.call(null,G__42037,G__42038));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg41754 = (function (){var G__42039 = ctx;
var G__42040 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42039,G__42040) : sci.impl.interpreter.interpret.call(null,G__42039,G__42040));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg41755 = (function (){var G__42041 = ctx;
var G__42042 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42041,G__42042) : sci.impl.interpreter.interpret.call(null,G__42041,G__42042));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg41756 = (function (){var G__42043 = ctx;
var G__42044 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42043,G__42044) : sci.impl.interpreter.interpret.call(null,G__42043,G__42044));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg41757 = (function (){var G__42045 = ctx;
var G__42046 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42045,G__42046) : sci.impl.interpreter.interpret.call(null,G__42045,G__42046));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg41758 = (function (){var G__42047 = ctx;
var G__42048 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42047,G__42048) : sci.impl.interpreter.interpret.call(null,G__42047,G__42048));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg41759 = (function (){var G__42049 = ctx;
var G__42050 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42049,G__42050) : sci.impl.interpreter.interpret.call(null,G__42049,G__42050));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg41760 = (function (){var G__42051 = ctx;
var G__42052 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42051,G__42052) : sci.impl.interpreter.interpret.call(null,G__42051,G__42052));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg41761 = (function (){var G__42053 = ctx;
var G__42054 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42053,G__42054) : sci.impl.interpreter.interpret.call(null,G__42053,G__42054));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg41762 = (function (){var G__42055 = ctx;
var G__42056 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42055,G__42056) : sci.impl.interpreter.interpret.call(null,G__42055,G__42056));
})();
var args__$12 = cljs.core.rest(args__$11);
var arg41763 = (function (){var G__42057 = ctx;
var G__42058 = cljs.core.first(args__$12);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42057,G__42058) : sci.impl.interpreter.interpret.call(null,G__42057,G__42058));
})();
var args__$13 = cljs.core.rest(args__$12);
var arg41764 = (function (){var G__42059 = ctx;
var G__42060 = cljs.core.first(args__$13);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42059,G__42060) : sci.impl.interpreter.interpret.call(null,G__42059,G__42060));
})();
var args__$14 = cljs.core.rest(args__$13);
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(arg41751,arg41752,arg41753,arg41754,arg41755,arg41756,arg41757,arg41758,arg41759,arg41760,arg41761,arg41762,arg41763,arg41764) : f.call(null,arg41751,arg41752,arg41753,arg41754,arg41755,arg41756,arg41757,arg41758,arg41759,arg41760,arg41761,arg41762,arg41763,arg41764));

break;
case (15):
var arg41765 = (function (){var G__42061 = ctx;
var G__42062 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42061,G__42062) : sci.impl.interpreter.interpret.call(null,G__42061,G__42062));
})();
var args__$1 = cljs.core.rest(args);
var arg41766 = (function (){var G__42063 = ctx;
var G__42064 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42063,G__42064) : sci.impl.interpreter.interpret.call(null,G__42063,G__42064));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg41767 = (function (){var G__42065 = ctx;
var G__42066 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42065,G__42066) : sci.impl.interpreter.interpret.call(null,G__42065,G__42066));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg41768 = (function (){var G__42067 = ctx;
var G__42068 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42067,G__42068) : sci.impl.interpreter.interpret.call(null,G__42067,G__42068));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg41769 = (function (){var G__42069 = ctx;
var G__42070 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42069,G__42070) : sci.impl.interpreter.interpret.call(null,G__42069,G__42070));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg41770 = (function (){var G__42071 = ctx;
var G__42072 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42071,G__42072) : sci.impl.interpreter.interpret.call(null,G__42071,G__42072));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg41771 = (function (){var G__42073 = ctx;
var G__42074 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42073,G__42074) : sci.impl.interpreter.interpret.call(null,G__42073,G__42074));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg41772 = (function (){var G__42075 = ctx;
var G__42076 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42075,G__42076) : sci.impl.interpreter.interpret.call(null,G__42075,G__42076));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg41773 = (function (){var G__42077 = ctx;
var G__42078 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42077,G__42078) : sci.impl.interpreter.interpret.call(null,G__42077,G__42078));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg41774 = (function (){var G__42079 = ctx;
var G__42080 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42079,G__42080) : sci.impl.interpreter.interpret.call(null,G__42079,G__42080));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg41775 = (function (){var G__42081 = ctx;
var G__42082 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42081,G__42082) : sci.impl.interpreter.interpret.call(null,G__42081,G__42082));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg41776 = (function (){var G__42083 = ctx;
var G__42084 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42083,G__42084) : sci.impl.interpreter.interpret.call(null,G__42083,G__42084));
})();
var args__$12 = cljs.core.rest(args__$11);
var arg41777 = (function (){var G__42085 = ctx;
var G__42086 = cljs.core.first(args__$12);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42085,G__42086) : sci.impl.interpreter.interpret.call(null,G__42085,G__42086));
})();
var args__$13 = cljs.core.rest(args__$12);
var arg41778 = (function (){var G__42087 = ctx;
var G__42088 = cljs.core.first(args__$13);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42087,G__42088) : sci.impl.interpreter.interpret.call(null,G__42087,G__42088));
})();
var args__$14 = cljs.core.rest(args__$13);
var arg41779 = (function (){var G__42089 = ctx;
var G__42090 = cljs.core.first(args__$14);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42089,G__42090) : sci.impl.interpreter.interpret.call(null,G__42089,G__42090));
})();
var args__$15 = cljs.core.rest(args__$14);
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(arg41765,arg41766,arg41767,arg41768,arg41769,arg41770,arg41771,arg41772,arg41773,arg41774,arg41775,arg41776,arg41777,arg41778,arg41779) : f.call(null,arg41765,arg41766,arg41767,arg41768,arg41769,arg41770,arg41771,arg41772,arg41773,arg41774,arg41775,arg41776,arg41777,arg41778,arg41779));

break;
case (16):
var arg41780 = (function (){var G__42091 = ctx;
var G__42092 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42091,G__42092) : sci.impl.interpreter.interpret.call(null,G__42091,G__42092));
})();
var args__$1 = cljs.core.rest(args);
var arg41781 = (function (){var G__42093 = ctx;
var G__42094 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42093,G__42094) : sci.impl.interpreter.interpret.call(null,G__42093,G__42094));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg41782 = (function (){var G__42095 = ctx;
var G__42096 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42095,G__42096) : sci.impl.interpreter.interpret.call(null,G__42095,G__42096));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg41783 = (function (){var G__42097 = ctx;
var G__42098 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42097,G__42098) : sci.impl.interpreter.interpret.call(null,G__42097,G__42098));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg41784 = (function (){var G__42099 = ctx;
var G__42100 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42099,G__42100) : sci.impl.interpreter.interpret.call(null,G__42099,G__42100));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg41785 = (function (){var G__42101 = ctx;
var G__42102 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42101,G__42102) : sci.impl.interpreter.interpret.call(null,G__42101,G__42102));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg41786 = (function (){var G__42103 = ctx;
var G__42104 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42103,G__42104) : sci.impl.interpreter.interpret.call(null,G__42103,G__42104));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg41787 = (function (){var G__42105 = ctx;
var G__42106 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42105,G__42106) : sci.impl.interpreter.interpret.call(null,G__42105,G__42106));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg41788 = (function (){var G__42107 = ctx;
var G__42108 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42107,G__42108) : sci.impl.interpreter.interpret.call(null,G__42107,G__42108));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg41789 = (function (){var G__42109 = ctx;
var G__42110 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42109,G__42110) : sci.impl.interpreter.interpret.call(null,G__42109,G__42110));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg41790 = (function (){var G__42111 = ctx;
var G__42112 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42111,G__42112) : sci.impl.interpreter.interpret.call(null,G__42111,G__42112));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg41791 = (function (){var G__42113 = ctx;
var G__42114 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42113,G__42114) : sci.impl.interpreter.interpret.call(null,G__42113,G__42114));
})();
var args__$12 = cljs.core.rest(args__$11);
var arg41792 = (function (){var G__42115 = ctx;
var G__42116 = cljs.core.first(args__$12);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42115,G__42116) : sci.impl.interpreter.interpret.call(null,G__42115,G__42116));
})();
var args__$13 = cljs.core.rest(args__$12);
var arg41793 = (function (){var G__42117 = ctx;
var G__42118 = cljs.core.first(args__$13);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42117,G__42118) : sci.impl.interpreter.interpret.call(null,G__42117,G__42118));
})();
var args__$14 = cljs.core.rest(args__$13);
var arg41794 = (function (){var G__42119 = ctx;
var G__42120 = cljs.core.first(args__$14);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42119,G__42120) : sci.impl.interpreter.interpret.call(null,G__42119,G__42120));
})();
var args__$15 = cljs.core.rest(args__$14);
var arg41795 = (function (){var G__42121 = ctx;
var G__42122 = cljs.core.first(args__$15);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42121,G__42122) : sci.impl.interpreter.interpret.call(null,G__42121,G__42122));
})();
var args__$16 = cljs.core.rest(args__$15);
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(arg41780,arg41781,arg41782,arg41783,arg41784,arg41785,arg41786,arg41787,arg41788,arg41789,arg41790,arg41791,arg41792,arg41793,arg41794,arg41795) : f.call(null,arg41780,arg41781,arg41782,arg41783,arg41784,arg41785,arg41786,arg41787,arg41788,arg41789,arg41790,arg41791,arg41792,arg41793,arg41794,arg41795));

break;
case (17):
var arg41796 = (function (){var G__42123 = ctx;
var G__42124 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42123,G__42124) : sci.impl.interpreter.interpret.call(null,G__42123,G__42124));
})();
var args__$1 = cljs.core.rest(args);
var arg41797 = (function (){var G__42125 = ctx;
var G__42126 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42125,G__42126) : sci.impl.interpreter.interpret.call(null,G__42125,G__42126));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg41798 = (function (){var G__42127 = ctx;
var G__42128 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42127,G__42128) : sci.impl.interpreter.interpret.call(null,G__42127,G__42128));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg41799 = (function (){var G__42129 = ctx;
var G__42130 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42129,G__42130) : sci.impl.interpreter.interpret.call(null,G__42129,G__42130));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg41800 = (function (){var G__42131 = ctx;
var G__42132 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42131,G__42132) : sci.impl.interpreter.interpret.call(null,G__42131,G__42132));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg41801 = (function (){var G__42133 = ctx;
var G__42134 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42133,G__42134) : sci.impl.interpreter.interpret.call(null,G__42133,G__42134));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg41802 = (function (){var G__42135 = ctx;
var G__42136 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42135,G__42136) : sci.impl.interpreter.interpret.call(null,G__42135,G__42136));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg41803 = (function (){var G__42137 = ctx;
var G__42138 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42137,G__42138) : sci.impl.interpreter.interpret.call(null,G__42137,G__42138));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg41804 = (function (){var G__42139 = ctx;
var G__42140 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42139,G__42140) : sci.impl.interpreter.interpret.call(null,G__42139,G__42140));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg41805 = (function (){var G__42141 = ctx;
var G__42142 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42141,G__42142) : sci.impl.interpreter.interpret.call(null,G__42141,G__42142));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg41806 = (function (){var G__42143 = ctx;
var G__42144 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42143,G__42144) : sci.impl.interpreter.interpret.call(null,G__42143,G__42144));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg41807 = (function (){var G__42145 = ctx;
var G__42146 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42145,G__42146) : sci.impl.interpreter.interpret.call(null,G__42145,G__42146));
})();
var args__$12 = cljs.core.rest(args__$11);
var arg41808 = (function (){var G__42147 = ctx;
var G__42148 = cljs.core.first(args__$12);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42147,G__42148) : sci.impl.interpreter.interpret.call(null,G__42147,G__42148));
})();
var args__$13 = cljs.core.rest(args__$12);
var arg41809 = (function (){var G__42149 = ctx;
var G__42150 = cljs.core.first(args__$13);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42149,G__42150) : sci.impl.interpreter.interpret.call(null,G__42149,G__42150));
})();
var args__$14 = cljs.core.rest(args__$13);
var arg41810 = (function (){var G__42151 = ctx;
var G__42152 = cljs.core.first(args__$14);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42151,G__42152) : sci.impl.interpreter.interpret.call(null,G__42151,G__42152));
})();
var args__$15 = cljs.core.rest(args__$14);
var arg41811 = (function (){var G__42153 = ctx;
var G__42154 = cljs.core.first(args__$15);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42153,G__42154) : sci.impl.interpreter.interpret.call(null,G__42153,G__42154));
})();
var args__$16 = cljs.core.rest(args__$15);
var arg41812 = (function (){var G__42155 = ctx;
var G__42156 = cljs.core.first(args__$16);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42155,G__42156) : sci.impl.interpreter.interpret.call(null,G__42155,G__42156));
})();
var args__$17 = cljs.core.rest(args__$16);
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(arg41796,arg41797,arg41798,arg41799,arg41800,arg41801,arg41802,arg41803,arg41804,arg41805,arg41806,arg41807,arg41808,arg41809,arg41810,arg41811,arg41812) : f.call(null,arg41796,arg41797,arg41798,arg41799,arg41800,arg41801,arg41802,arg41803,arg41804,arg41805,arg41806,arg41807,arg41808,arg41809,arg41810,arg41811,arg41812));

break;
case (18):
var arg41813 = (function (){var G__42157 = ctx;
var G__42158 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42157,G__42158) : sci.impl.interpreter.interpret.call(null,G__42157,G__42158));
})();
var args__$1 = cljs.core.rest(args);
var arg41814 = (function (){var G__42159 = ctx;
var G__42160 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42159,G__42160) : sci.impl.interpreter.interpret.call(null,G__42159,G__42160));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg41815 = (function (){var G__42161 = ctx;
var G__42162 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42161,G__42162) : sci.impl.interpreter.interpret.call(null,G__42161,G__42162));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg41816 = (function (){var G__42163 = ctx;
var G__42164 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42163,G__42164) : sci.impl.interpreter.interpret.call(null,G__42163,G__42164));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg41817 = (function (){var G__42165 = ctx;
var G__42166 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42165,G__42166) : sci.impl.interpreter.interpret.call(null,G__42165,G__42166));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg41818 = (function (){var G__42167 = ctx;
var G__42168 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42167,G__42168) : sci.impl.interpreter.interpret.call(null,G__42167,G__42168));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg41819 = (function (){var G__42169 = ctx;
var G__42170 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42169,G__42170) : sci.impl.interpreter.interpret.call(null,G__42169,G__42170));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg41820 = (function (){var G__42171 = ctx;
var G__42172 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42171,G__42172) : sci.impl.interpreter.interpret.call(null,G__42171,G__42172));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg41821 = (function (){var G__42173 = ctx;
var G__42174 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42173,G__42174) : sci.impl.interpreter.interpret.call(null,G__42173,G__42174));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg41822 = (function (){var G__42175 = ctx;
var G__42176 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42175,G__42176) : sci.impl.interpreter.interpret.call(null,G__42175,G__42176));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg41823 = (function (){var G__42177 = ctx;
var G__42178 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42177,G__42178) : sci.impl.interpreter.interpret.call(null,G__42177,G__42178));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg41824 = (function (){var G__42179 = ctx;
var G__42180 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42179,G__42180) : sci.impl.interpreter.interpret.call(null,G__42179,G__42180));
})();
var args__$12 = cljs.core.rest(args__$11);
var arg41825 = (function (){var G__42181 = ctx;
var G__42182 = cljs.core.first(args__$12);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42181,G__42182) : sci.impl.interpreter.interpret.call(null,G__42181,G__42182));
})();
var args__$13 = cljs.core.rest(args__$12);
var arg41826 = (function (){var G__42183 = ctx;
var G__42184 = cljs.core.first(args__$13);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42183,G__42184) : sci.impl.interpreter.interpret.call(null,G__42183,G__42184));
})();
var args__$14 = cljs.core.rest(args__$13);
var arg41827 = (function (){var G__42185 = ctx;
var G__42186 = cljs.core.first(args__$14);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42185,G__42186) : sci.impl.interpreter.interpret.call(null,G__42185,G__42186));
})();
var args__$15 = cljs.core.rest(args__$14);
var arg41828 = (function (){var G__42187 = ctx;
var G__42188 = cljs.core.first(args__$15);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42187,G__42188) : sci.impl.interpreter.interpret.call(null,G__42187,G__42188));
})();
var args__$16 = cljs.core.rest(args__$15);
var arg41829 = (function (){var G__42189 = ctx;
var G__42190 = cljs.core.first(args__$16);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42189,G__42190) : sci.impl.interpreter.interpret.call(null,G__42189,G__42190));
})();
var args__$17 = cljs.core.rest(args__$16);
var arg41830 = (function (){var G__42191 = ctx;
var G__42192 = cljs.core.first(args__$17);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42191,G__42192) : sci.impl.interpreter.interpret.call(null,G__42191,G__42192));
})();
var args__$18 = cljs.core.rest(args__$17);
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(arg41813,arg41814,arg41815,arg41816,arg41817,arg41818,arg41819,arg41820,arg41821,arg41822,arg41823,arg41824,arg41825,arg41826,arg41827,arg41828,arg41829,arg41830) : f.call(null,arg41813,arg41814,arg41815,arg41816,arg41817,arg41818,arg41819,arg41820,arg41821,arg41822,arg41823,arg41824,arg41825,arg41826,arg41827,arg41828,arg41829,arg41830));

break;
case (19):
var arg41831 = (function (){var G__42193 = ctx;
var G__42194 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42193,G__42194) : sci.impl.interpreter.interpret.call(null,G__42193,G__42194));
})();
var args__$1 = cljs.core.rest(args);
var arg41832 = (function (){var G__42195 = ctx;
var G__42196 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42195,G__42196) : sci.impl.interpreter.interpret.call(null,G__42195,G__42196));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg41833 = (function (){var G__42197 = ctx;
var G__42198 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42197,G__42198) : sci.impl.interpreter.interpret.call(null,G__42197,G__42198));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg41834 = (function (){var G__42199 = ctx;
var G__42200 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42199,G__42200) : sci.impl.interpreter.interpret.call(null,G__42199,G__42200));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg41835 = (function (){var G__42201 = ctx;
var G__42202 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42201,G__42202) : sci.impl.interpreter.interpret.call(null,G__42201,G__42202));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg41836 = (function (){var G__42203 = ctx;
var G__42204 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42203,G__42204) : sci.impl.interpreter.interpret.call(null,G__42203,G__42204));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg41837 = (function (){var G__42205 = ctx;
var G__42206 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42205,G__42206) : sci.impl.interpreter.interpret.call(null,G__42205,G__42206));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg41838 = (function (){var G__42207 = ctx;
var G__42208 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42207,G__42208) : sci.impl.interpreter.interpret.call(null,G__42207,G__42208));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg41839 = (function (){var G__42209 = ctx;
var G__42210 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42209,G__42210) : sci.impl.interpreter.interpret.call(null,G__42209,G__42210));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg41840 = (function (){var G__42211 = ctx;
var G__42212 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42211,G__42212) : sci.impl.interpreter.interpret.call(null,G__42211,G__42212));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg41841 = (function (){var G__42213 = ctx;
var G__42214 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42213,G__42214) : sci.impl.interpreter.interpret.call(null,G__42213,G__42214));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg41842 = (function (){var G__42215 = ctx;
var G__42216 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42215,G__42216) : sci.impl.interpreter.interpret.call(null,G__42215,G__42216));
})();
var args__$12 = cljs.core.rest(args__$11);
var arg41843 = (function (){var G__42217 = ctx;
var G__42218 = cljs.core.first(args__$12);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42217,G__42218) : sci.impl.interpreter.interpret.call(null,G__42217,G__42218));
})();
var args__$13 = cljs.core.rest(args__$12);
var arg41844 = (function (){var G__42219 = ctx;
var G__42220 = cljs.core.first(args__$13);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42219,G__42220) : sci.impl.interpreter.interpret.call(null,G__42219,G__42220));
})();
var args__$14 = cljs.core.rest(args__$13);
var arg41845 = (function (){var G__42221 = ctx;
var G__42222 = cljs.core.first(args__$14);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42221,G__42222) : sci.impl.interpreter.interpret.call(null,G__42221,G__42222));
})();
var args__$15 = cljs.core.rest(args__$14);
var arg41846 = (function (){var G__42223 = ctx;
var G__42224 = cljs.core.first(args__$15);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42223,G__42224) : sci.impl.interpreter.interpret.call(null,G__42223,G__42224));
})();
var args__$16 = cljs.core.rest(args__$15);
var arg41847 = (function (){var G__42225 = ctx;
var G__42226 = cljs.core.first(args__$16);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42225,G__42226) : sci.impl.interpreter.interpret.call(null,G__42225,G__42226));
})();
var args__$17 = cljs.core.rest(args__$16);
var arg41848 = (function (){var G__42227 = ctx;
var G__42228 = cljs.core.first(args__$17);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42227,G__42228) : sci.impl.interpreter.interpret.call(null,G__42227,G__42228));
})();
var args__$18 = cljs.core.rest(args__$17);
var arg41849 = (function (){var G__42229 = ctx;
var G__42230 = cljs.core.first(args__$18);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42229,G__42230) : sci.impl.interpreter.interpret.call(null,G__42229,G__42230));
})();
var args__$19 = cljs.core.rest(args__$18);
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(arg41831,arg41832,arg41833,arg41834,arg41835,arg41836,arg41837,arg41838,arg41839,arg41840,arg41841,arg41842,arg41843,arg41844,arg41845,arg41846,arg41847,arg41848,arg41849) : f.call(null,arg41831,arg41832,arg41833,arg41834,arg41835,arg41836,arg41837,arg41838,arg41839,arg41840,arg41841,arg41842,arg41843,arg41844,arg41845,arg41846,arg41847,arg41848,arg41849));

break;
default:
var args__$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__2704_SHARP_){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,p1__2704_SHARP_) : sci.impl.interpreter.interpret.call(null,ctx,p1__2704_SHARP_));
}),args);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args__$1);

}
});
sci.impl.interpreter.eval_special_call = (function sci$impl$interpreter$eval_special_call(ctx,f_sym,expr){
var G__42231 = sci.impl.utils.strip_core_ns(f_sym);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,".",".",1975675962,null),G__42231)){
if(cljs.core.truth_(ctx.get(new cljs.core.Keyword(null,"dry-run","dry-run",-1102788647)))){
return null;
} else {
return sci.impl.interpreter.eval_instance_method_invocation(ctx,expr);
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"and","and",668631710,null),G__42231)){
return sci.impl.interpreter.eval_and(ctx,cljs.core.rest(expr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"case","case",-1510733573,null),G__42231)){
return sci.impl.interpreter.eval_case(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"if","if",1181717262,null),G__42231)){
return sci.impl.interpreter.eval_if(ctx,cljs.core.rest(expr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"do","do",1686842252,null),G__42231)){
return sci.impl.interpreter.eval_do(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"macroexpand","macroexpand",1509933344,null),G__42231)){
return sci.impl.interpreter.macroexpand(ctx,(function (){var G__42232 = ctx;
var G__42233 = cljs.core.second(expr);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42232,G__42233) : sci.impl.interpreter.interpret.call(null,G__42232,G__42233));
})());
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"def","def",597100991,null),G__42231)){
return sci.impl.interpreter.eval_def(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"let","let",358118826,null),G__42231)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(sci.impl.interpreter.eval_let,ctx,cljs.core.rest(expr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"in-ns","in-ns",-2089468466,null),G__42231)){
return sci.impl.interpreter.eval_in_ns(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"use","use",-205850897,null),G__42231)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(sci.impl.interpreter.eval_use,ctx,cljs.core.rest(expr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"set!","set!",250714521,null),G__42231)){
return sci.impl.interpreter.eval_set_BANG_(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"recur","recur",1202958259,null),G__42231)){
return sci.impl.interpreter.fn_call(ctx,cljs.core.comp.cljs$core$IFn$_invoke$arity$2(sci.impl.fns.__GT_Recur,cljs.core.vector),cljs.core.rest(expr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"require","require",1172530194,null),G__42231)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(sci.impl.interpreter.eval_require,ctx,cljs.core.rest(expr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"new","new",-444906321,null),G__42231)){
if(cljs.core.truth_(ctx.get(new cljs.core.Keyword(null,"dry-run","dry-run",-1102788647)))){
return null;
} else {
return sci.impl.interpreter.eval_constructor_invocation(ctx,expr);
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"macroexpand-1","macroexpand-1",659241329,null),G__42231)){
return sci.impl.interpreter.macroexpand_1(ctx,(function (){var G__42234 = ctx;
var G__42235 = cljs.core.second(expr);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42234,G__42235) : sci.impl.interpreter.interpret.call(null,G__42234,G__42235));
})());
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"refer","refer",676235974,null),G__42231)){
return sci.impl.interpreter.eval_refer(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"lazy-seq","lazy-seq",489632906,null),G__42231)){
return (new cljs.core.LazySeq(null,(function (){var G__42236 = ctx;
var G__42237 = cljs.core.second(expr);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__42236,G__42237) : sci.impl.interpreter.interpret.call(null,G__42236,G__42237));
})(),null,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"throw","throw",595905694,null),G__42231)){
return sci.impl.interpreter.eval_throw(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"try","try",-1273693247,null),G__42231)){
return sci.impl.interpreter.eval_try(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"resolve","resolve",56086045,null),G__42231)){
return sci.impl.interpreter.eval_resolve(ctx,cljs.core.second(expr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"or","or",1876275696,null),G__42231)){
return sci.impl.interpreter.eval_or(ctx,cljs.core.rest(expr));
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__42231)].join('')));

}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
sci.impl.interpreter.eval_call = (function sci$impl$interpreter$eval_call(ctx,expr){
try{var f = cljs.core.first(expr);
var m = cljs.core.meta(f);
var op = (cljs.core.truth_(m)?m.get(new cljs.core.Keyword("sci.impl","op","sci.impl/op",950953978)):null);
if((((f instanceof cljs.core.Symbol)) && (cljs.core.not(op)))){
return sci.impl.interpreter.eval_special_call(ctx,f,expr);
} else {
if(cljs.core.truth_((sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"static-access","static-access",-1860919441)) : sci.impl.utils.kw_identical_QMARK_.call(null,op,new cljs.core.Keyword(null,"static-access","static-access",-1860919441))))){
if(cljs.core.truth_(ctx.get(new cljs.core.Keyword(null,"dry-run","dry-run",-1102788647)))){
return null;
} else {
return sci.impl.interpreter.eval_static_method_invocation(ctx,expr);
}
} else {
var f__$1 = (cljs.core.truth_(op)?(sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,f) : sci.impl.interpreter.interpret.call(null,ctx,f)):f);
if(cljs.core.ifn_QMARK_(f__$1)){
if(cljs.core.truth_(ctx.get(new cljs.core.Keyword(null,"dry-run","dry-run",-1102788647)))){
return null;
} else {
return sci.impl.interpreter.fn_call(ctx,f__$1,cljs.core.rest(expr));
}
} else {
throw (new Error(["Cannot call ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([f__$1], 0))," as a function."].join('')));
}

}
}
}catch (e42238){if((e42238 instanceof Error)){
var e = e42238;
return sci.impl.utils.rethrow_with_location_of_node(ctx,e,expr);
} else {
throw e42238;

}
}});
sci.impl.interpreter.fix_meta = (function sci$impl$interpreter$fix_meta(v,old_meta){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(v);
if(cljs.core.truth_(and__4115__auto__)){
return (((!(sci.impl.vars.var_QMARK_(v)))) && ((!(sci.impl.vars.namespace_QMARK_(v)))));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2(v,(function (m){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,new cljs.core.Keyword("sci.impl","op","sci.impl/op",950953978)),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(old_meta));
}));
} else {
return v;
}
});
sci.impl.interpreter.interpret = (function sci$impl$interpreter$interpret(ctx,expr){
if((expr instanceof sci.impl.types.EvalVar)){
var v = expr.sci$impl$types$IBox$getVal$arity$1(null);
if(cljs.core.not(sci.impl.vars.isMacro(v))){
return cljs.core.deref(v);
} else {
throw (new Error(["Can't take value of a macro: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(v),""].join('')));
}
} else {
var m = cljs.core.meta(expr);
var op = (cljs.core.truth_(m)?m.get(new cljs.core.Keyword("sci.impl","op","sci.impl/op",950953978)):null);
var ret = ((cljs.core.not(op))?expr:(function (){var G__42242 = op;
var G__42242__$1 = (((G__42242 instanceof cljs.core.Keyword))?G__42242.fqn:null);
switch (G__42242__$1) {
case "call":
return sci.impl.interpreter.eval_call(ctx,expr);

break;
case "try":
return sci.impl.interpreter.eval_try(ctx,expr);

break;
case "fn":
return sci.impl.fns.eval_fn(ctx,sci.impl.interpreter.interpret,sci.impl.interpreter.eval_do_STAR_,expr);

break;
case "static-access":
return sci.impl.interop.get_static_field(expr);

break;
case "var-value":
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(expr,(0));

break;
case "deref!":
var v = cljs.core.first(expr);
var v__$1 = ((sci.impl.vars.var_QMARK_(v))?cljs.core.deref(v):v);
var v__$2 = cljs.core.force(v__$1);
return v__$2;

break;
case "resolve-sym":
return sci.impl.interpreter.resolve_symbol(ctx,expr);

break;
case "needs-ctx":
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2(expr,ctx);

break;
default:
if(cljs.core.map_QMARK_(expr)){
return cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__42239_SHARP_){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,p1__42239_SHARP_) : sci.impl.interpreter.interpret.call(null,ctx,p1__42239_SHARP_));
}),cljs.core.keys(expr)),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__42240_SHARP_){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,p1__42240_SHARP_) : sci.impl.interpreter.interpret.call(null,ctx,p1__42240_SHARP_));
}),cljs.core.vals(expr)));
} else {
if(((cljs.core.vector_QMARK_(expr)) || (cljs.core.set_QMARK_(expr)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.empty(expr),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__42241_SHARP_){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,p1__42241_SHARP_) : sci.impl.interpreter.interpret.call(null,ctx,p1__42241_SHARP_));
}),expr));
} else {
throw (new Error(["unexpected: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr),", type: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(expr)),", meta:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(expr))].join('')));

}
}

}
})());
var ret__$1 = (cljs.core.truth_(m)?sci.impl.interpreter.fix_meta(ret,m):ret);
var temp__5733__auto__ = ctx.get(new cljs.core.Keyword(null,"realize-max","realize-max",-1846442543));
if(cljs.core.truth_(temp__5733__auto__)){
var n = temp__5733__auto__;
return sci.impl.max_or_throw.max_or_throw(ret__$1,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ctx,new cljs.core.Keyword(null,"expression","expression",202311876),expr),n);
} else {
return ret__$1;
}
}
});
sci.impl.interpreter.do_QMARK_ = (function sci$impl$interpreter$do_QMARK_(expr){
return ((cljs.core.list_QMARK_(expr)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.first(expr))));
});
sci.impl.interpreter.eval_form = (function sci$impl$interpreter$eval_form(ctx,form){
if(sci.impl.interpreter.do_QMARK_(form)){
var exprs = cljs.core.rest(form);
var ret = null;
while(true){
if(cljs.core.seq(exprs)){
var G__42289 = cljs.core.rest(exprs);
var G__42290 = (function (){var G__42245 = ctx;
var G__42246 = cljs.core.first(exprs);
return (sci.impl.interpreter.eval_form.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.eval_form.cljs$core$IFn$_invoke$arity$2(G__42245,G__42246) : sci.impl.interpreter.eval_form.call(null,G__42245,G__42246));
})();
exprs = G__42289;
ret = G__42290;
continue;
} else {
return ret;
}
break;
}
} else {
var analyzed = sci.impl.analyzer.analyze(ctx,form);
var ret = sci.impl.interpreter.interpret(ctx,analyzed);
return ret;
}
});
cljs.core.vreset_BANG_(sci.impl.utils.eval_form_state,sci.impl.interpreter.eval_form);
sci.impl.interpreter.eval_string_STAR_ = (function sci$impl$interpreter$eval_string_STAR_(ctx,s){
var reader = cljs.tools.reader.reader_types.indexing_push_back_reader.cljs$core$IFn$_invoke$arity$1(cljs.tools.reader.reader_types.string_push_back_reader.cljs$core$IFn$_invoke$arity$1(s));
var ret = null;
while(true){
var expr = sci.impl.parser.parse_next.cljs$core$IFn$_invoke$arity$2(ctx,reader);
if(cljs.core.truth_((sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("edamame.impl.parser","eof","edamame.impl.parser/eof",720552006),expr) : sci.impl.utils.kw_identical_QMARK_.call(null,new cljs.core.Keyword("edamame.impl.parser","eof","edamame.impl.parser/eof",720552006),expr)))){
return ret;
} else {
var ret__$1 = sci.impl.interpreter.eval_form(ctx,expr);
var G__42291 = ret__$1;
ret = G__42291;
continue;
}
break;
}
});
sci.impl.interpreter.eval_string = (function sci$impl$interpreter$eval_string(var_args){
var G__42248 = arguments.length;
switch (G__42248) {
case 1:
return sci.impl.interpreter.eval_string.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sci.impl.interpreter.eval_string.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sci.impl.interpreter.eval_string.cljs$core$IFn$_invoke$arity$1 = (function (s){
return sci.impl.interpreter.eval_string.cljs$core$IFn$_invoke$arity$2(s,null);
}));

(sci.impl.interpreter.eval_string.cljs$core$IFn$_invoke$arity$2 = (function (s,opts){
var init_ctx = sci.impl.opts.init(opts);
var ret = (function (){
sci.impl.vars.push_thread_bindings((cljs.core.truth_(cljs.core.deref(sci.impl.vars.current_ns))?null:cljs.core.PersistentArrayMap.createAsIfByAssoc([sci.impl.vars.current_ns,sci.impl.opts.user_ns])));

try{return sci.impl.interpreter.eval_string_STAR_(init_ctx,s);
}finally {sci.impl.vars.pop_thread_bindings();
}})()
;
return ret;
}));

(sci.impl.interpreter.eval_string.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=sci.impl.interpreter.js.map
