goog.provide('re_frame.trace');
goog.require('cljs.core');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('goog.functions');
re_frame.trace.id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_(re_frame.trace.id,(0));
});
/**
 * @define {boolean}
 */
re_frame.trace.trace_enabled_QMARK_ = goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/day8/re-frame-10x#installation."], 0));
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__27902){
var map__27903 = p__27902;
var map__27903__$1 = (((((!((map__27903 == null))))?(((((map__27903.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27903.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27903):map__27903);
var operation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27903__$1,new cljs.core.Keyword(null,"operation","operation",-1267664310));
var op_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27903__$1,new cljs.core.Keyword(null,"op-type","op-type",-1636141668));
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27903__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
var child_of = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27903__$1,new cljs.core.Keyword(null,"child-of","child-of",-903376662));
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),re_frame.trace.next_id(),new cljs.core.Keyword(null,"operation","operation",-1267664310),operation,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),op_type,new cljs.core.Keyword(null,"tags","tags",1771418977),tags,new cljs.core.Keyword(null,"child-of","child-of",-903376662),(function (){var or__4126__auto__ = child_of;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),new cljs.core.Keyword(null,"start","start",-355208981),re_frame.interop.now()], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce((function re_frame$trace$tracing_cb_debounced(){
var seq__27905_27932 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__27906_27933 = null;
var count__27907_27934 = (0);
var i__27908_27935 = (0);
while(true){
if((i__27908_27935 < count__27907_27934)){
var vec__27919_27936 = chunk__27906_27933.cljs$core$IIndexed$_nth$arity$2(null,i__27908_27935);
var k_27937 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27919_27936,(0),null);
var cb_27938 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27919_27936,(1),null);
try{var G__27923_27939 = cljs.core.deref(re_frame.trace.traces);
(cb_27938.cljs$core$IFn$_invoke$arity$1 ? cb_27938.cljs$core$IFn$_invoke$arity$1(G__27923_27939) : cb_27938.call(null,G__27923_27939));
}catch (e27922){var e_27940 = e27922;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_27937,"while storing",cljs.core.deref(re_frame.trace.traces),e_27940], 0));
}

var G__27941 = seq__27905_27932;
var G__27942 = chunk__27906_27933;
var G__27943 = count__27907_27934;
var G__27944 = (i__27908_27935 + (1));
seq__27905_27932 = G__27941;
chunk__27906_27933 = G__27942;
count__27907_27934 = G__27943;
i__27908_27935 = G__27944;
continue;
} else {
var temp__5735__auto___27945 = cljs.core.seq(seq__27905_27932);
if(temp__5735__auto___27945){
var seq__27905_27946__$1 = temp__5735__auto___27945;
if(cljs.core.chunked_seq_QMARK_(seq__27905_27946__$1)){
var c__4556__auto___27947 = cljs.core.chunk_first(seq__27905_27946__$1);
var G__27948 = cljs.core.chunk_rest(seq__27905_27946__$1);
var G__27949 = c__4556__auto___27947;
var G__27950 = cljs.core.count(c__4556__auto___27947);
var G__27951 = (0);
seq__27905_27932 = G__27948;
chunk__27906_27933 = G__27949;
count__27907_27934 = G__27950;
i__27908_27935 = G__27951;
continue;
} else {
var vec__27924_27952 = cljs.core.first(seq__27905_27946__$1);
var k_27953 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27924_27952,(0),null);
var cb_27954 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27924_27952,(1),null);
try{var G__27928_27955 = cljs.core.deref(re_frame.trace.traces);
(cb_27954.cljs$core$IFn$_invoke$arity$1 ? cb_27954.cljs$core$IFn$_invoke$arity$1(G__27928_27955) : cb_27954.call(null,G__27928_27955));
}catch (e27927){var e_27956 = e27927;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_27953,"while storing",cljs.core.deref(re_frame.trace.traces),e_27956], 0));
}

var G__27957 = cljs.core.next(seq__27905_27946__$1);
var G__27958 = null;
var G__27959 = (0);
var G__27960 = (0);
seq__27905_27932 = G__27957;
chunk__27906_27933 = G__27958;
count__27907_27934 = G__27959;
i__27908_27935 = G__27960;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref(re_frame.trace.next_delivery) - (25)) < now)){
(re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0 ? re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0() : re_frame.trace.schedule_debounce.call(null));

return cljs.core.reset_BANG_(re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});

//# sourceMappingURL=re_frame.trace.js.map
