goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR__orig_val__28176 = re_frame.trace._STAR_current_trace_STAR_;
var _STAR_current_trace_STAR__temp_val__28177 = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));
(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__temp_val__28177);

try{try{var seq__28178 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__28179 = null;
var count__28180 = (0);
var i__28181 = (0);
while(true){
if((i__28181 < count__28180)){
var vec__28190 = chunk__28179.cljs$core$IIndexed$_nth$arity$2(null,i__28181);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28190,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28190,(1),null);
var temp__5733__auto___28233 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___28233)){
var effect_fn_28234 = temp__5733__auto___28233;
(effect_fn_28234.cljs$core$IFn$_invoke$arity$1 ? effect_fn_28234.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_28234.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__28235 = seq__28178;
var G__28236 = chunk__28179;
var G__28237 = count__28180;
var G__28238 = (i__28181 + (1));
seq__28178 = G__28235;
chunk__28179 = G__28236;
count__28180 = G__28237;
i__28181 = G__28238;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28178);
if(temp__5735__auto__){
var seq__28178__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28178__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28178__$1);
var G__28239 = cljs.core.chunk_rest(seq__28178__$1);
var G__28240 = c__4556__auto__;
var G__28241 = cljs.core.count(c__4556__auto__);
var G__28242 = (0);
seq__28178 = G__28239;
chunk__28179 = G__28240;
count__28180 = G__28241;
i__28181 = G__28242;
continue;
} else {
var vec__28193 = cljs.core.first(seq__28178__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28193,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28193,(1),null);
var temp__5733__auto___28243 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___28243)){
var effect_fn_28244 = temp__5733__auto___28243;
(effect_fn_28244.cljs$core$IFn$_invoke$arity$1 ? effect_fn_28244.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_28244.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__28245 = cljs.core.next(seq__28178__$1);
var G__28246 = null;
var G__28247 = (0);
var G__28248 = (0);
seq__28178 = G__28245;
chunk__28179 = G__28246;
count__28180 = G__28247;
i__28181 = G__28248;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__27882__auto___28250 = re_frame.interop.now();
var duration__27883__auto___28251 = (end__27882__auto___28250 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__27883__auto___28251,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__27882__auto___28250);
} else {
}
}}finally {(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__orig_val__28176);
}} else {
var seq__28196 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__28197 = null;
var count__28198 = (0);
var i__28199 = (0);
while(true){
if((i__28199 < count__28198)){
var vec__28207 = chunk__28197.cljs$core$IIndexed$_nth$arity$2(null,i__28199);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28207,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28207,(1),null);
var temp__5733__auto___28255 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___28255)){
var effect_fn_28256 = temp__5733__auto___28255;
(effect_fn_28256.cljs$core$IFn$_invoke$arity$1 ? effect_fn_28256.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_28256.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__28257 = seq__28196;
var G__28258 = chunk__28197;
var G__28259 = count__28198;
var G__28260 = (i__28199 + (1));
seq__28196 = G__28257;
chunk__28197 = G__28258;
count__28198 = G__28259;
i__28199 = G__28260;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28196);
if(temp__5735__auto__){
var seq__28196__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28196__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28196__$1);
var G__28264 = cljs.core.chunk_rest(seq__28196__$1);
var G__28265 = c__4556__auto__;
var G__28266 = cljs.core.count(c__4556__auto__);
var G__28267 = (0);
seq__28196 = G__28264;
chunk__28197 = G__28265;
count__28198 = G__28266;
i__28199 = G__28267;
continue;
} else {
var vec__28210 = cljs.core.first(seq__28196__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28210,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28210,(1),null);
var temp__5733__auto___28268 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___28268)){
var effect_fn_28269 = temp__5733__auto___28268;
(effect_fn_28269.cljs$core$IFn$_invoke$arity$1 ? effect_fn_28269.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_28269.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__28270 = cljs.core.next(seq__28196__$1);
var G__28271 = null;
var G__28272 = (0);
var G__28273 = (0);
seq__28196 = G__28270;
chunk__28197 = G__28271;
count__28198 = G__28272;
i__28199 = G__28273;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__28213 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__28214 = null;
var count__28215 = (0);
var i__28216 = (0);
while(true){
if((i__28216 < count__28215)){
var map__28221 = chunk__28214.cljs$core$IIndexed$_nth$arity$2(null,i__28216);
var map__28221__$1 = (((((!((map__28221 == null))))?(((((map__28221.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28221.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28221):map__28221);
var effect = map__28221__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28221__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28221__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__28213,chunk__28214,count__28215,i__28216,map__28221,map__28221__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__28213,chunk__28214,count__28215,i__28216,map__28221,map__28221__$1,effect,ms,dispatch))
,ms);
}


var G__28274 = seq__28213;
var G__28275 = chunk__28214;
var G__28276 = count__28215;
var G__28277 = (i__28216 + (1));
seq__28213 = G__28274;
chunk__28214 = G__28275;
count__28215 = G__28276;
i__28216 = G__28277;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28213);
if(temp__5735__auto__){
var seq__28213__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28213__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28213__$1);
var G__28278 = cljs.core.chunk_rest(seq__28213__$1);
var G__28279 = c__4556__auto__;
var G__28280 = cljs.core.count(c__4556__auto__);
var G__28281 = (0);
seq__28213 = G__28278;
chunk__28214 = G__28279;
count__28215 = G__28280;
i__28216 = G__28281;
continue;
} else {
var map__28223 = cljs.core.first(seq__28213__$1);
var map__28223__$1 = (((((!((map__28223 == null))))?(((((map__28223.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28223.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28223):map__28223);
var effect = map__28223__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28223__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28223__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__28213,chunk__28214,count__28215,i__28216,map__28223,map__28223__$1,effect,ms,dispatch,seq__28213__$1,temp__5735__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__28213,chunk__28214,count__28215,i__28216,map__28223,map__28223__$1,effect,ms,dispatch,seq__28213__$1,temp__5735__auto__))
,ms);
}


var G__28284 = cljs.core.next(seq__28213__$1);
var G__28285 = null;
var G__28286 = (0);
var G__28287 = (0);
seq__28213 = G__28284;
chunk__28214 = G__28285;
count__28215 = G__28286;
i__28216 = G__28287;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if((!(cljs.core.vector_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if((!(cljs.core.sequential_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value], 0));
} else {
var seq__28225 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__28226 = null;
var count__28227 = (0);
var i__28228 = (0);
while(true){
if((i__28228 < count__28227)){
var event = chunk__28226.cljs$core$IIndexed$_nth$arity$2(null,i__28228);
re_frame.router.dispatch(event);


var G__28288 = seq__28225;
var G__28289 = chunk__28226;
var G__28290 = count__28227;
var G__28291 = (i__28228 + (1));
seq__28225 = G__28288;
chunk__28226 = G__28289;
count__28227 = G__28290;
i__28228 = G__28291;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28225);
if(temp__5735__auto__){
var seq__28225__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28225__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28225__$1);
var G__28292 = cljs.core.chunk_rest(seq__28225__$1);
var G__28293 = c__4556__auto__;
var G__28294 = cljs.core.count(c__4556__auto__);
var G__28295 = (0);
seq__28225 = G__28292;
chunk__28226 = G__28293;
count__28227 = G__28294;
i__28228 = G__28295;
continue;
} else {
var event = cljs.core.first(seq__28225__$1);
re_frame.router.dispatch(event);


var G__28296 = cljs.core.next(seq__28225__$1);
var G__28297 = null;
var G__28298 = (0);
var G__28299 = (0);
seq__28225 = G__28296;
chunk__28226 = G__28297;
count__28227 = G__28298;
i__28228 = G__28299;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__28229 = cljs.core.seq(value);
var chunk__28230 = null;
var count__28231 = (0);
var i__28232 = (0);
while(true){
if((i__28232 < count__28231)){
var event = chunk__28230.cljs$core$IIndexed$_nth$arity$2(null,i__28232);
clear_event(event);


var G__28300 = seq__28229;
var G__28301 = chunk__28230;
var G__28302 = count__28231;
var G__28303 = (i__28232 + (1));
seq__28229 = G__28300;
chunk__28230 = G__28301;
count__28231 = G__28302;
i__28232 = G__28303;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28229);
if(temp__5735__auto__){
var seq__28229__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28229__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28229__$1);
var G__28304 = cljs.core.chunk_rest(seq__28229__$1);
var G__28305 = c__4556__auto__;
var G__28306 = cljs.core.count(c__4556__auto__);
var G__28307 = (0);
seq__28229 = G__28304;
chunk__28230 = G__28305;
count__28231 = G__28306;
i__28232 = G__28307;
continue;
} else {
var event = cljs.core.first(seq__28229__$1);
clear_event(event);


var G__28308 = cljs.core.next(seq__28229__$1);
var G__28309 = null;
var G__28310 = (0);
var G__28311 = (0);
seq__28229 = G__28308;
chunk__28230 = G__28309;
count__28231 = G__28310;
i__28232 = G__28311;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if((!((cljs.core.deref(re_frame.db.app_db) === value)))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=re_frame.fx.js.map
