goog.provide('goldly.app');
goog.require('cljs.core');
goog.require('cljs.pprint');
goog.require('taoensso.timbre');
goog.require('reagent.dom');
goog.require('re_frame.core');
goog.require('pinkie.default_setup');
goog.require('picasso.default_config');
goog.require('pinkgorilla.ui.default_renderer');
goog.require('pinkgorilla.ui.config');
goog.require('goldly.web.ws');
goog.require('goldly.web.views');
goog.require('goldly.web.routes');
goog.require('goldly.events');
goog.require('goldly.puppet.subs');
goog.require('goldly.puppet.db');
goog.require('goldly.user.auth.view');
pinkgorilla.ui.config.set_prefix_BANG_("/r/");
goldly.app.print_log_init_BANG_ = (function goldly$app$print_log_init_BANG_(){
cljs.core.enable_console_print_BANG_();

return taoensso.timbre.set_level_BANG_(new cljs.core.Keyword(null,"debug","debug",-1608172596));
});
goldly.app.mount_app = (function goldly$app$mount_app(){
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [goldly.web.views.goldly_app_page], null),document.getElementById("app"));
});
goldly.app.before_reload = (function goldly$app$before_reload(){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["shadow-cljs reload: before"], 0));

return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"goldly.app","/tmp/form-init1437201128234415960.clj",36,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["shadow-cljs reload: before"], null);
}),null)),null,1798915082);
});
goldly.app.after_reload = (function goldly$app$after_reload(){
goldly.app.print_log_init_BANG_();

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["shadow-cljs reload: after"], 0));

taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"goldly.app","/tmp/form-init1437201128234415960.clj",41,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["shadow-cljs reload: after"], null);
}),null)),null,235055975);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["clearing reframe subscription cache.."], 0));

(re_frame.core.clear_subscription_cache_BANG_.cljs$core$IFn$_invoke$arity$0 ? re_frame.core.clear_subscription_cache_BANG_.cljs$core$IFn$_invoke$arity$0() : re_frame.core.clear_subscription_cache_BANG_.call(null));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-loading configuration from server.."], 0));

goldly.web.routes.init_routes();

goldly.web.ws.start_router_BANG_();

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["mounting notebook-app .."], 0));

return goldly.app.mount_app();
});
goldly.app.after_reload();

//# sourceMappingURL=goldly.app.js.map
