goog.provide('com.rpl.specter');
goog.require('cljs.core');
goog.require('com.rpl.specter.protocols');
goog.require('com.rpl.specter.impl');
goog.require('com.rpl.specter.navs');
goog.require('clojure.set');
com.rpl.specter.static_path_QMARK_ = (function com$rpl$specter$static_path_QMARK_(path){
if(cljs.core.sequential_QMARK_(path)){
return cljs.core.every_QMARK_(com.rpl.specter.static_path_QMARK_,path);
} else {
return (!(com.rpl.specter.impl.dynamic_param_QMARK_(path)));
}
});
com.rpl.specter.wrap_dynamic_nav = (function com$rpl$specter$wrap_dynamic_nav(f){
return (function() { 
var G__32902__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
if(((cljs.core.sequential_QMARK_(ret)) && (com.rpl.specter.static_path_QMARK_(ret)))){
return com.rpl.specter.impl.comp_paths_STAR_(ret);
} else {
if(((cljs.core.sequential_QMARK_(ret)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(ret))))){
return cljs.core.first(ret);
} else {
return ret;

}
}
};
var G__32902 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__32906__i = 0, G__32906__a = new Array(arguments.length -  0);
while (G__32906__i < G__32906__a.length) {G__32906__a[G__32906__i] = arguments[G__32906__i + 0]; ++G__32906__i;}
  args = new cljs.core.IndexedSeq(G__32906__a,0,null);
} 
return G__32902__delegate.call(this,args);};
G__32902.cljs$lang$maxFixedArity = 0;
G__32902.cljs$lang$applyTo = (function (arglist__32907){
var args = cljs.core.seq(arglist__32907);
return G__32902__delegate(args);
});
G__32902.cljs$core$IFn$_invoke$arity$variadic = G__32902__delegate;
return G__32902;
})()
;
});
/**
 * Returns a compiled version of the given path for use with
 * compiled-{select/transform/setval/etc.} functions.
 */
com.rpl.specter.comp_paths = (function com$rpl$specter$comp_paths(var_args){
var args__4742__auto__ = [];
var len__4736__auto___32908 = arguments.length;
var i__4737__auto___32909 = (0);
while(true){
if((i__4737__auto___32909 < len__4736__auto___32908)){
args__4742__auto__.push((arguments[i__4737__auto___32909]));

var G__32910 = (i__4737__auto___32909 + (1));
i__4737__auto___32909 = G__32910;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic = (function (apath){
return com.rpl.specter.impl.comp_paths_STAR_(cljs.core.vec(apath));
}));

(com.rpl.specter.comp_paths.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.rpl.specter.comp_paths.cljs$lang$applyTo = (function (seq32582){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq32582));
}));

/**
 * Version of select that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select = com.rpl.specter.impl.compiled_select_STAR_;
/**
 * Navigates to and returns a sequence of all the elements specified by the path.
 */
com.rpl.specter.select_STAR_ = (function com$rpl$specter$select_STAR_(path,structure){
var G__32583 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__32584 = structure;
return (com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(G__32583,G__32584) : com.rpl.specter.compiled_select.call(null,G__32583,G__32584));
});
/**
 * Version of select-one that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one = com.rpl.specter.impl.compiled_select_one_STAR_;
/**
 * Like select, but returns either one element or nil. Throws exception if multiple elements found
 */
com.rpl.specter.select_one_STAR_ = (function com$rpl$specter$select_one_STAR_(path,structure){
var G__32585 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__32586 = structure;
return (com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(G__32585,G__32586) : com.rpl.specter.compiled_select_one.call(null,G__32585,G__32586));
});
/**
 * Version of select-one! that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one_BANG_ = com.rpl.specter.impl.compiled_select_one_BANG__STAR_;
/**
 * Returns exactly one element, throws exception if zero or multiple elements found
 */
com.rpl.specter.select_one_BANG__STAR_ = (function com$rpl$specter$select_one_BANG__STAR_(path,structure){
var G__32587 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__32588 = structure;
return (com.rpl.specter.compiled_select_one_BANG_.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one_BANG_.cljs$core$IFn$_invoke$arity$2(G__32587,G__32588) : com.rpl.specter.compiled_select_one_BANG_.call(null,G__32587,G__32588));
});
/**
 * Version of select-first that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_first = com.rpl.specter.impl.compiled_select_first_STAR_;
/**
 * Returns first element found.
 */
com.rpl.specter.select_first_STAR_ = (function com$rpl$specter$select_first_STAR_(path,structure){
var G__32589 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__32590 = structure;
return (com.rpl.specter.compiled_select_first.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_first.cljs$core$IFn$_invoke$arity$2(G__32589,G__32590) : com.rpl.specter.compiled_select_first.call(null,G__32589,G__32590));
});
/**
 * Version of select-any that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_any = com.rpl.specter.impl.compiled_select_any_STAR_;
/**
 * Global value used to indicate no elements selected during
 *           [[select-any]].
 */
com.rpl.specter.NONE = com.rpl.specter.impl.NONE;
/**
 * Returns any element found or [[NONE]] if nothing selected. This is the most
 * efficient of the various selection operations.
 */
com.rpl.specter.select_any_STAR_ = (function com$rpl$specter$select_any_STAR_(path,structure){
var G__32591 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__32592 = structure;
return (com.rpl.specter.compiled_select_any.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_any.cljs$core$IFn$_invoke$arity$2(G__32591,G__32592) : com.rpl.specter.compiled_select_any.call(null,G__32591,G__32592));
});
/**
 * Version of selected-any? that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_selected_any_QMARK_ = com.rpl.specter.impl.compiled_selected_any_QMARK__STAR_;
/**
 * Returns true if any element was selected, false otherwise.
 */
com.rpl.specter.selected_any_QMARK__STAR_ = (function com$rpl$specter$selected_any_QMARK__STAR_(path,structure){
var G__32593 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__32594 = structure;
return (com.rpl.specter.compiled_selected_any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_selected_any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__32593,G__32594) : com.rpl.specter.compiled_selected_any_QMARK_.call(null,G__32593,G__32594));
});
/**
 * Version of traverse that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse = com.rpl.specter.impl.do_compiled_traverse;
/**
 * Return a reducible object that traverses over `structure` to every element
 * specified by the path
 */
com.rpl.specter.traverse_STAR_ = (function com$rpl$specter$traverse_STAR_(apath,structure){
var G__32595 = com.rpl.specter.impl.comp_paths_STAR_(apath);
var G__32596 = structure;
return (com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(G__32595,G__32596) : com.rpl.specter.compiled_traverse.call(null,G__32595,G__32596));
});
/**
 * Version of traverse-all that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse_all = com.rpl.specter.impl.compiled_traverse_all_STAR_;
/**
 * Returns a transducer that traverses over each element with the given path.
 */
com.rpl.specter.traverse_all_STAR_ = (function com$rpl$specter$traverse_all_STAR_(apath){
var G__32597 = com.rpl.specter.impl.comp_paths_STAR_(apath);
return (com.rpl.specter.compiled_traverse_all.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.compiled_traverse_all.cljs$core$IFn$_invoke$arity$1(G__32597) : com.rpl.specter.compiled_traverse_all.call(null,G__32597));
});
/**
 * Version of transform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_transform = com.rpl.specter.impl.compiled_transform_STAR_;
/**
 * Version of vtransform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_vtransform = com.rpl.specter.impl.compiled_vtransform_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by the result of running
 *   the transform-fn on it
 */
com.rpl.specter.transform_STAR_ = (function com$rpl$specter$transform_STAR_(path,transform_fn,structure){
var G__32598 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__32599 = transform_fn;
var G__32600 = structure;
return (com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(G__32598,G__32599,G__32600) : com.rpl.specter.compiled_transform.call(null,G__32598,G__32599,G__32600));
});
/**
 * Version of `multi-transform` that takes in a path precompiled with `comp-paths`
 */
com.rpl.specter.compiled_multi_transform = com.rpl.specter.impl.compiled_multi_transform_STAR_;
/**
 * Just like `transform` but expects transform functions to be specified
 * inline in the path using `terminal` or `vterminal`. Error is thrown if navigation finishes
 * at a non-terminal navigator. `terminal-val` is a wrapper around `terminal` and is
 * the `multi-transform` equivalent of `setval`.
 */
com.rpl.specter.multi_transform_STAR_ = (function com$rpl$specter$multi_transform_STAR_(path,structure){
var G__32601 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__32602 = structure;
return (com.rpl.specter.compiled_multi_transform.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_multi_transform.cljs$core$IFn$_invoke$arity$2(G__32601,G__32602) : com.rpl.specter.compiled_multi_transform.call(null,G__32601,G__32602));
});
/**
 * Version of setval that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_setval = com.rpl.specter.impl.compiled_setval_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by val
 */
com.rpl.specter.setval_STAR_ = (function com$rpl$specter$setval_STAR_(path,val,structure){
var G__32603 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__32604 = val;
var G__32605 = structure;
return (com.rpl.specter.compiled_setval.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_setval.cljs$core$IFn$_invoke$arity$3(G__32603,G__32604,G__32605) : com.rpl.specter.compiled_setval.call(null,G__32603,G__32604,G__32605));
});
/**
 * Version of replace-in that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_replace_in = com.rpl.specter.impl.compiled_replace_in_STAR_;
/**
 * Similar to transform, except returns a pair of [transformed-structure sequence-of-user-ret].
 * The transform-fn in this case is expected to return [ret user-ret]. ret is
 * what's used to transform the data structure, while user-ret will be added to the user-ret sequence
 * in the final return. replace-in is useful for situations where you need to know the specific values
 * of what was transformed in the data structure.
 */
com.rpl.specter.replace_in_STAR_ = (function com$rpl$specter$replace_in_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___32914 = arguments.length;
var i__4737__auto___32915 = (0);
while(true){
if((i__4737__auto___32915 < len__4736__auto___32914)){
args__4742__auto__.push((arguments[i__4737__auto___32915]));

var G__32916 = (i__4737__auto___32915 + (1));
i__4737__auto___32915 = G__32916;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (path,transform_fn,structure,p__32610){
var map__32611 = p__32610;
var map__32611__$1 = (((((!((map__32611 == null))))?(((((map__32611.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32611.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32611):map__32611);
var merge_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32611__$1,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),cljs.core.concat);
var G__32613 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__32614 = transform_fn;
var G__32615 = structure;
var G__32616 = new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341);
var G__32617 = merge_fn;
return (com.rpl.specter.compiled_replace_in.cljs$core$IFn$_invoke$arity$5 ? com.rpl.specter.compiled_replace_in.cljs$core$IFn$_invoke$arity$5(G__32613,G__32614,G__32615,G__32616,G__32617) : com.rpl.specter.compiled_replace_in.call(null,G__32613,G__32614,G__32615,G__32616,G__32617));
}));

(com.rpl.specter.replace_in_STAR_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(com.rpl.specter.replace_in_STAR_.cljs$lang$applyTo = (function (seq32606){
var G__32607 = cljs.core.first(seq32606);
var seq32606__$1 = cljs.core.next(seq32606);
var G__32608 = cljs.core.first(seq32606__$1);
var seq32606__$2 = cljs.core.next(seq32606__$1);
var G__32609 = cljs.core.first(seq32606__$2);
var seq32606__$3 = cljs.core.next(seq32606__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32607,G__32608,G__32609,seq32606__$3);
}));

com.rpl.specter.late_path = com.rpl.specter.impl.late_path;
com.rpl.specter.dynamic_param_QMARK_ = com.rpl.specter.impl.dynamic_param_QMARK_;
com.rpl.specter.late_resolved_fn = com.rpl.specter.impl.late_resolved_fn;
/**
 * Turns a navigator that takes one argument into a navigator that takes
 *        many arguments and uses the same navigator with each argument. There
 *        is no performance cost to using this. See implementation of `keypath`
 */
com.rpl.specter.eachnav = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (navfn){
var latenavfn = (com.rpl.specter.late_resolved_fn.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_resolved_fn.cljs$core$IFn$_invoke$arity$1(navfn) : com.rpl.specter.late_resolved_fn.call(null,navfn));
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__32918__delegate = function (args){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(latenavfn,args);
};
var G__32918 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__32919__i = 0, G__32919__a = new Array(arguments.length -  0);
while (G__32919__i < G__32919__a.length) {G__32919__a[G__32919__i] = arguments[G__32919__i + 0]; ++G__32919__i;}
  args = new cljs.core.IndexedSeq(G__32919__a,0,null);
} 
return G__32918__delegate.call(this,args);};
G__32918.cljs$lang$maxFixedArity = 0;
G__32918.cljs$lang$applyTo = (function (arglist__32920){
var args = cljs.core.seq(arglist__32920);
return G__32918__delegate(args);
});
G__32918.cljs$core$IFn$_invoke$arity$variadic = G__32918__delegate;
return G__32918;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.local_declarepath = com.rpl.specter.impl.local_declarepath;


com.rpl.specter.STOP_select_STAR_ = (function com$rpl$specter$STOP_select_STAR_(structure,next_fn){
return com.rpl.specter.NONE;
});

com.rpl.specter.STOP_transform_STAR_ = (function com$rpl$specter$STOP_transform_STAR_(structure,next_fn){
return structure;
});

/**
 * Stops navigation at this point. For selection returns nothing and for
 *        transformation returns the structure unchanged
 */
com.rpl.specter.STOP = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32618 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32618 = (function (meta32619){
this.meta32619 = meta32619;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32618.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32620,meta32619__$1){
var self__ = this;
var _32620__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32618(meta32619__$1));
}));

(com.rpl.specter.t_com$rpl$specter32618.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32620){
var self__ = this;
var _32620__$1 = this;
return self__.meta32619;
}));

(com.rpl.specter.t_com$rpl$specter32618.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32618.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter32618.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return structure;
}));

(com.rpl.specter.t_com$rpl$specter32618.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta32619","meta32619",1701917578,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32618.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32618.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32618");

(com.rpl.specter.t_com$rpl$specter32618.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32618");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32618.
 */
com.rpl.specter.__GT_t_com$rpl$specter32618 = (function com$rpl$specter$__GT_t_com$rpl$specter32618(meta32619){
return (new com.rpl.specter.t_com$rpl$specter32618(meta32619));
});

}

return (new com.rpl.specter.t_com$rpl$specter32618(null));
})()
;
/**
 * Stays navigated at the current point. Essentially a no-op navigator.
 */
com.rpl.specter.STAY = com.rpl.specter.impl.STAY_STAR_;
/**
 * Defines an endpoint in the navigation the transform function run. The transform
 *        function works just like it does in `transform`, with collected values
 *        given as the first arguments
 */
com.rpl.specter.terminal = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32621 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32621 = (function (afn,meta32622){
this.afn = afn;
this.meta32622 = meta32622;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32621.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32623,meta32622__$1){
var self__ = this;
var _32623__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32621(self__.afn,meta32622__$1));
}));

(com.rpl.specter.t_com$rpl$specter32621.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32623){
var self__ = this;
var _32623__$1 = this;
return self__.meta32622;
}));

(com.rpl.specter.t_com$rpl$specter32621.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32621.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter32621.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.terminal_STAR_(self__.afn,vals,structure);
}));

(com.rpl.specter.t_com$rpl$specter32621.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta32622","meta32622",-1878367983,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32621.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32621.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32621");

(com.rpl.specter.t_com$rpl$specter32621.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32621");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32621.
 */
com.rpl.specter.__GT_t_com$rpl$specter32621 = (function com$rpl$specter$__GT_t_com$rpl$specter32621(afn__$1,meta32622){
return (new com.rpl.specter.t_com$rpl$specter32621(afn__$1,meta32622));
});

}

return (new com.rpl.specter.t_com$rpl$specter32621(afn,null));
}));
/**
 * Defines an endpoint in the navigation the transform function run.The transform
 *        function works differently than it does in `transform`. Rather than receive
 *        collected vals spliced in as the first arguments to the function, this function
 *        always takes two arguemnts. The first is all collected vals in a vector, and
 *        the second is the navigated value.
 */
com.rpl.specter.vterminal = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32624 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32624 = (function (afn,meta32625){
this.afn = afn;
this.meta32625 = meta32625;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32624.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32626,meta32625__$1){
var self__ = this;
var _32626__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32624(self__.afn,meta32625__$1));
}));

(com.rpl.specter.t_com$rpl$specter32624.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32626){
var self__ = this;
var _32626__$1 = this;
return self__.meta32625;
}));

(com.rpl.specter.t_com$rpl$specter32624.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32624.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter32624.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(vals,structure) : self__.afn.call(null,vals,structure));
}));

(com.rpl.specter.t_com$rpl$specter32624.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta32625","meta32625",1535816932,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32624.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32624.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32624");

(com.rpl.specter.t_com$rpl$specter32624.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32624");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32624.
 */
com.rpl.specter.__GT_t_com$rpl$specter32624 = (function com$rpl$specter$__GT_t_com$rpl$specter32624(afn__$1,meta32625){
return (new com.rpl.specter.t_com$rpl$specter32624(afn__$1,meta32625));
});

}

return (new com.rpl.specter.t_com$rpl$specter32624(afn,null));
}));
/**
 * Like `terminal` but specifies a val to set at the location regardless of
 * the collected values or the value at the location.
 */
com.rpl.specter.terminal_val = (function com$rpl$specter$terminal_val(v){
var G__32627 = com.rpl.specter.impl.fast_constantly(v);
return (com.rpl.specter.terminal.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.terminal.cljs$core$IFn$_invoke$arity$1(G__32627) : com.rpl.specter.terminal.call(null,G__32627));
});


com.rpl.specter.ALL_select_STAR_ = (function com$rpl$specter$ALL_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.ALL_transform_STAR_ = (function com$rpl$specter$ALL_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_transform(structure,next_fn);
});

/**
 * Navigate to every element of the collection. For maps navigates to
 *        a vector of `[key value]`.
 */
com.rpl.specter.ALL = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32628 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32628 = (function (meta32629){
this.meta32629 = meta32629;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32628.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32630,meta32629__$1){
var self__ = this;
var _32630__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32628(meta32629__$1));
}));

(com.rpl.specter.t_com$rpl$specter32628.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32630){
var self__ = this;
var _32630__$1 = this;
return self__.meta32629;
}));

(com.rpl.specter.t_com$rpl$specter32628.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32628.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return com.rpl.specter.navs.all_select(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter32628.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return com.rpl.specter.navs.all_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter32628.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta32629","meta32629",1972123062,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32628.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32628.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32628");

(com.rpl.specter.t_com$rpl$specter32628.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32628");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32628.
 */
com.rpl.specter.__GT_t_com$rpl$specter32628 = (function com$rpl$specter$__GT_t_com$rpl$specter32628(meta32629){
return (new com.rpl.specter.t_com$rpl$specter32628(meta32629));
});

}

return (new com.rpl.specter.t_com$rpl$specter32628(null));
})()
;


com.rpl.specter.ALL_WITH_META_select_STAR_ = (function com$rpl$specter$ALL_WITH_META_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.ALL_WITH_META_transform_STAR_ = (function com$rpl$specter$ALL_WITH_META_transform_STAR_(structure,next_fn){
var m = cljs.core.meta(structure);
var res = com.rpl.specter.navs.all_transform(structure,next_fn);
if((!((res == null)))){
return cljs.core.with_meta(res,m);
} else {
return null;
}
});

/**
 * Same as ALL, except maintains metadata on the structure.
 */
com.rpl.specter.ALL_WITH_META = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32631 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32631 = (function (meta32632){
this.meta32632 = meta32632;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32631.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32633,meta32632__$1){
var self__ = this;
var _32633__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32631(meta32632__$1));
}));

(com.rpl.specter.t_com$rpl$specter32631.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32633){
var self__ = this;
var _32633__$1 = this;
return self__.meta32632;
}));

(com.rpl.specter.t_com$rpl$specter32631.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32631.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return com.rpl.specter.navs.all_select(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter32631.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
var m = cljs.core.meta(structure);
var res = com.rpl.specter.navs.all_transform(structure,next_fn);
if((!((res == null)))){
return cljs.core.with_meta(res,m);
} else {
return null;
}
}));

(com.rpl.specter.t_com$rpl$specter32631.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta32632","meta32632",155573223,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32631.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32631.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32631");

(com.rpl.specter.t_com$rpl$specter32631.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32631");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32631.
 */
com.rpl.specter.__GT_t_com$rpl$specter32631 = (function com$rpl$specter$__GT_t_com$rpl$specter32631(meta32632){
return (new com.rpl.specter.t_com$rpl$specter32631(meta32632));
});

}

return (new com.rpl.specter.t_com$rpl$specter32631(null));
})()
;


com.rpl.specter.MAP_VALS_select_STAR_ = (function com$rpl$specter$MAP_VALS_select_STAR_(structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__28558__auto__,v){
var ret__28559__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(v) : next_fn.call(null,v));
if((ret__28559__auto__ === com.rpl.specter.NONE)){
return curr__28558__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__28559__auto__)){
return cljs.core.reduced(ret__28559__auto__);
} else {
return ret__28559__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals(structure));
});

com.rpl.specter.MAP_VALS_transform_STAR_ = (function com$rpl$specter$MAP_VALS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_vals_transform(structure,next_fn);
});

/**
 * Navigate to each value of the map. This is more efficient than
 *        navigating via [ALL LAST]
 */
com.rpl.specter.MAP_VALS = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32634 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32634 = (function (meta32635){
this.meta32635 = meta32635;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32634.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32636,meta32635__$1){
var self__ = this;
var _32636__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32634(meta32635__$1));
}));

(com.rpl.specter.t_com$rpl$specter32634.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32636){
var self__ = this;
var _32636__$1 = this;
return self__.meta32635;
}));

(com.rpl.specter.t_com$rpl$specter32634.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32634.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__28558__auto__,v){
var ret__28559__auto__ = next_fn(v);
if((ret__28559__auto__ === com.rpl.specter.NONE)){
return curr__28558__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__28559__auto__)){
return cljs.core.reduced(ret__28559__auto__);
} else {
return ret__28559__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals(structure));
}));

(com.rpl.specter.t_com$rpl$specter32634.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return com.rpl.specter.navs.map_vals_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter32634.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta32635","meta32635",-1420870163,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32634.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32634.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32634");

(com.rpl.specter.t_com$rpl$specter32634.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32634");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32634.
 */
com.rpl.specter.__GT_t_com$rpl$specter32634 = (function com$rpl$specter$__GT_t_com$rpl$specter32634(meta32635){
return (new com.rpl.specter.t_com$rpl$specter32634(meta32635));
});

}

return (new com.rpl.specter.t_com$rpl$specter32634(null));
})()
;


com.rpl.specter.MAP_KEYS_select_STAR_ = (function com$rpl$specter$MAP_KEYS_select_STAR_(structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__28558__auto__,k){
var ret__28559__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(k) : next_fn.call(null,k));
if((ret__28559__auto__ === com.rpl.specter.NONE)){
return curr__28558__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__28559__auto__)){
return cljs.core.reduced(ret__28559__auto__);
} else {
return ret__28559__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys(structure));
});

com.rpl.specter.MAP_KEYS_transform_STAR_ = (function com$rpl$specter$MAP_KEYS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_keys_transform(structure,next_fn);
});

/**
 * Navigate to each key of the map. This is more efficient than
 *        navigating via [ALL FIRST]
 */
com.rpl.specter.MAP_KEYS = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32637 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32637 = (function (meta32638){
this.meta32638 = meta32638;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32637.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32639,meta32638__$1){
var self__ = this;
var _32639__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32637(meta32638__$1));
}));

(com.rpl.specter.t_com$rpl$specter32637.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32639){
var self__ = this;
var _32639__$1 = this;
return self__.meta32638;
}));

(com.rpl.specter.t_com$rpl$specter32637.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32637.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__28558__auto__,k){
var ret__28559__auto__ = next_fn(k);
if((ret__28559__auto__ === com.rpl.specter.NONE)){
return curr__28558__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__28559__auto__)){
return cljs.core.reduced(ret__28559__auto__);
} else {
return ret__28559__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys(structure));
}));

(com.rpl.specter.t_com$rpl$specter32637.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return com.rpl.specter.navs.map_keys_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter32637.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta32638","meta32638",-1033984365,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32637.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32637.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32637");

(com.rpl.specter.t_com$rpl$specter32637.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32637");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32637.
 */
com.rpl.specter.__GT_t_com$rpl$specter32637 = (function com$rpl$specter$__GT_t_com$rpl$specter32637(meta32638){
return (new com.rpl.specter.t_com$rpl$specter32637(meta32638));
});

}

return (new com.rpl.specter.t_com$rpl$specter32637(null));
})()
;
com.rpl.specter.VAL = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32640 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32640 = (function (meta32641){
this.meta32641 = meta32641;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32640.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32642,meta32641__$1){
var self__ = this;
var _32642__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32640(meta32641__$1));
}));

(com.rpl.specter.t_com$rpl$specter32640.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32642){
var self__ = this;
var _32642__$1 = this;
return self__.meta32641;
}));

(com.rpl.specter.t_com$rpl$specter32640.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32640.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__31550__auto__,vals__31551__auto__,structure,next_fn__31552__auto__){
var self__ = this;
var this__31550__auto____$1 = this;
var G__32643 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__31551__auto__,structure);
var G__32644 = structure;
return (next_fn__31552__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__31552__auto__.cljs$core$IFn$_invoke$arity$2(G__32643,G__32644) : next_fn__31552__auto__.call(null,G__32643,G__32644));
}));

(com.rpl.specter.t_com$rpl$specter32640.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__31550__auto__,vals__31551__auto__,structure,next_fn__31552__auto__){
var self__ = this;
var this__31550__auto____$1 = this;
var G__32645 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__31551__auto__,structure);
var G__32646 = structure;
return (next_fn__31552__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__31552__auto__.cljs$core$IFn$_invoke$arity$2(G__32645,G__32646) : next_fn__31552__auto__.call(null,G__32645,G__32646));
}));

(com.rpl.specter.t_com$rpl$specter32640.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta32641","meta32641",1441791765,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32640.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32640.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32640");

(com.rpl.specter.t_com$rpl$specter32640.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32640");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32640.
 */
com.rpl.specter.__GT_t_com$rpl$specter32640 = (function com$rpl$specter$__GT_t_com$rpl$specter32640(meta32641){
return (new com.rpl.specter.t_com$rpl$specter32640(meta32641));
});

}

return (new com.rpl.specter.t_com$rpl$specter32640(null));
})()
;
/**
 * Navigate to the last element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.LAST = (com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last) : com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last));
/**
 * Navigate to the first element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.FIRST = (com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first) : com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first));


com.rpl.specter.srange_dynamic_select_STAR_ = (function com$rpl$specter$srange_dynamic_select_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = (start_index_fn.cljs$core$IFn$_invoke$arity$1 ? start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : start_index_fn.call(null,structure));
return com.rpl.specter.navs.srange_select(structure,s,com.rpl.specter.navs.invoke_end_fn(end_index_fn,structure,s),next_fn);
});

com.rpl.specter.srange_dynamic_transform_STAR_ = (function com$rpl$specter$srange_dynamic_transform_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = (start_index_fn.cljs$core$IFn$_invoke$arity$1 ? start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : start_index_fn.call(null,structure));
var G__32647 = structure;
var G__32648 = s;
var G__32649 = com.rpl.specter.navs.invoke_end_fn(end_index_fn,structure,s);
var G__32650 = next_fn;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(G__32647,G__32648,G__32649,G__32650) : com.rpl.specter.navs.srange_transform.call(null,G__32647,G__32648,G__32649,G__32650));
});

/**
 * Uses start-index-fn and end-index-fn to determine the bounds of the subsequence
 *        to select when navigating. `start-index-fn` takes in the structure as input. `end-index-fn`
 *        can be one of two forms. If a regular function (e.g. defined with `fn`), it takes in only the structure as input. If a function defined using special `end-fn` macro, it takes in the structure and the result of `start-index-fn`.
 */
com.rpl.specter.srange_dynamic = com.rpl.specter.impl.direct_nav_obj((function (start_index_fn,end_index_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32651 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32651 = (function (start_index_fn,end_index_fn,meta32652){
this.start_index_fn = start_index_fn;
this.end_index_fn = end_index_fn;
this.meta32652 = meta32652;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32651.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32653,meta32652__$1){
var self__ = this;
var _32653__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32651(self__.start_index_fn,self__.end_index_fn,meta32652__$1));
}));

(com.rpl.specter.t_com$rpl$specter32651.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32653){
var self__ = this;
var _32653__$1 = this;
return self__.meta32652;
}));

(com.rpl.specter.t_com$rpl$specter32651.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32651.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
var s = (self__.start_index_fn.cljs$core$IFn$_invoke$arity$1 ? self__.start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.start_index_fn.call(null,structure));
return com.rpl.specter.navs.srange_select(structure,s,com.rpl.specter.navs.invoke_end_fn(self__.end_index_fn,structure,s),next_fn);
}));

(com.rpl.specter.t_com$rpl$specter32651.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
var s = (self__.start_index_fn.cljs$core$IFn$_invoke$arity$1 ? self__.start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.start_index_fn.call(null,structure));
var G__32654 = structure;
var G__32655 = s;
var G__32656 = com.rpl.specter.navs.invoke_end_fn(self__.end_index_fn,structure,s);
var G__32657 = next_fn;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(G__32654,G__32655,G__32656,G__32657) : com.rpl.specter.navs.srange_transform.call(null,G__32654,G__32655,G__32656,G__32657));
}));

(com.rpl.specter.t_com$rpl$specter32651.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start-index-fn","start-index-fn",-344842645,null),new cljs.core.Symbol(null,"end-index-fn","end-index-fn",1237092062,null),new cljs.core.Symbol(null,"meta32652","meta32652",-1494184648,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32651.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32651.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32651");

(com.rpl.specter.t_com$rpl$specter32651.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32651");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32651.
 */
com.rpl.specter.__GT_t_com$rpl$specter32651 = (function com$rpl$specter$__GT_t_com$rpl$specter32651(start_index_fn__$1,end_index_fn__$1,meta32652){
return (new com.rpl.specter.t_com$rpl$specter32651(start_index_fn__$1,end_index_fn__$1,meta32652));
});

}

return (new com.rpl.specter.t_com$rpl$specter32651(start_index_fn,end_index_fn,null));
}));


com.rpl.specter.srange_select_STAR_ = (function com$rpl$specter$srange_select_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_select(structure,start,end,next_fn);
});

com.rpl.specter.srange_transform_STAR_ = (function com$rpl$specter$srange_transform_STAR_(start,end,structure,next_fn){
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(structure,start,end,next_fn) : com.rpl.specter.navs.srange_transform.call(null,structure,start,end,next_fn));
});

/**
 * Navigates to the subsequence bound by the indexes start (inclusive)
 *        and end (exclusive)
 */
com.rpl.specter.srange = com.rpl.specter.impl.direct_nav_obj((function (start,end){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32658 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32658 = (function (start,end,meta32659){
this.start = start;
this.end = end;
this.meta32659 = meta32659;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32658.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32660,meta32659__$1){
var self__ = this;
var _32660__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32658(self__.start,self__.end,meta32659__$1));
}));

(com.rpl.specter.t_com$rpl$specter32658.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32660){
var self__ = this;
var _32660__$1 = this;
return self__.meta32659;
}));

(com.rpl.specter.t_com$rpl$specter32658.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32658.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return com.rpl.specter.navs.srange_select(structure,self__.start,self__.end,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter32658.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(structure,self__.start,self__.end,next_fn) : com.rpl.specter.navs.srange_transform.call(null,structure,self__.start,self__.end,next_fn));
}));

(com.rpl.specter.t_com$rpl$specter32658.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"meta32659","meta32659",-1486481413,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32658.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32658.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32658");

(com.rpl.specter.t_com$rpl$specter32658.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32658");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32658.
 */
com.rpl.specter.__GT_t_com$rpl$specter32658 = (function com$rpl$specter$__GT_t_com$rpl$specter32658(start__$1,end__$1,meta32659){
return (new com.rpl.specter.t_com$rpl$specter32658(start__$1,end__$1,meta32659));
});

}

return (new com.rpl.specter.t_com$rpl$specter32658(start,end,null));
}));


com.rpl.specter.continuous_subseqs_select_STAR_ = (function com$rpl$specter$continuous_subseqs_select_STAR_(pred,structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__28558__auto__,p__32661){
var vec__32662 = p__32661;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32662,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32662,(1),null);
var ret__28559__auto__ = com.rpl.specter.navs.srange_select(structure,s,e,next_fn);
if((ret__28559__auto__ === com.rpl.specter.NONE)){
return curr__28558__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__28559__auto__)){
return cljs.core.reduced(ret__28559__auto__);
} else {
return ret__28559__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges(structure,pred));
});

com.rpl.specter.continuous_subseqs_transform_STAR_ = (function com$rpl$specter$continuous_subseqs_transform_STAR_(pred,structure,next_fn){
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_(pred,structure,next_fn);
});

/**
 * Navigates to every continuous subsequence of elements matching `pred`
 */
com.rpl.specter.continuous_subseqs = com.rpl.specter.impl.direct_nav_obj((function (pred){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32665 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32665 = (function (pred,meta32666){
this.pred = pred;
this.meta32666 = meta32666;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32665.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32667,meta32666__$1){
var self__ = this;
var _32667__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32665(self__.pred,meta32666__$1));
}));

(com.rpl.specter.t_com$rpl$specter32665.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32667){
var self__ = this;
var _32667__$1 = this;
return self__.meta32666;
}));

(com.rpl.specter.t_com$rpl$specter32665.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32665.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__28558__auto__,p__32668){
var vec__32669 = p__32668;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32669,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32669,(1),null);
var ret__28559__auto__ = com.rpl.specter.navs.srange_select(structure,s,e,next_fn);
if((ret__28559__auto__ === com.rpl.specter.NONE)){
return curr__28558__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__28559__auto__)){
return cljs.core.reduced(ret__28559__auto__);
} else {
return ret__28559__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges(structure,self__.pred));
}));

(com.rpl.specter.t_com$rpl$specter32665.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_(self__.pred,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter32665.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"meta32666","meta32666",1377074124,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32665.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32665.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32665");

(com.rpl.specter.t_com$rpl$specter32665.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32665");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32665.
 */
com.rpl.specter.__GT_t_com$rpl$specter32665 = (function com$rpl$specter$__GT_t_com$rpl$specter32665(pred__$1,meta32666){
return (new com.rpl.specter.t_com$rpl$specter32665(pred__$1,meta32666));
});

}

return (new com.rpl.specter.t_com$rpl$specter32665(pred,null));
}));


com.rpl.specter.BEGINNING_select_STAR_ = (function com$rpl$specter$BEGINNING_select_STAR_(structure,next_fn){
var G__32672 = ((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__32672) : next_fn.call(null,G__32672));
});

com.rpl.specter.BEGINNING_transform_STAR_ = (function com$rpl$specter$BEGINNING_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1("") : next_fn.call(null,""))),structure].join('');
} else {
var to_prepend = (function (){var G__32673 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__32673) : next_fn.call(null,G__32673));
})();
return com.rpl.specter.navs.prepend_all(structure,to_prepend);
}
});

/**
 * Navigate to the empty subsequence before the first element of the collection.
 */
com.rpl.specter.BEGINNING = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32674 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32674 = (function (meta32675){
this.meta32675 = meta32675;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32674.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32676,meta32675__$1){
var self__ = this;
var _32676__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32674(meta32675__$1));
}));

(com.rpl.specter.t_com$rpl$specter32674.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32676){
var self__ = this;
var _32676__$1 = this;
return self__.meta32675;
}));

(com.rpl.specter.t_com$rpl$specter32674.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32674.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return next_fn(((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
}));

(com.rpl.specter.t_com$rpl$specter32674.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn("")),structure].join('');
} else {
var to_prepend = next_fn(cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all(structure,to_prepend);
}
}));

(com.rpl.specter.t_com$rpl$specter32674.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta32675","meta32675",1528629600,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32674.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32674.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32674");

(com.rpl.specter.t_com$rpl$specter32674.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32674");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32674.
 */
com.rpl.specter.__GT_t_com$rpl$specter32674 = (function com$rpl$specter$__GT_t_com$rpl$specter32674(meta32675){
return (new com.rpl.specter.t_com$rpl$specter32674(meta32675));
});

}

return (new com.rpl.specter.t_com$rpl$specter32674(null));
})()
;


com.rpl.specter.END_select_STAR_ = (function com$rpl$specter$END_select_STAR_(structure,next_fn){
var G__32677 = ((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__32677) : next_fn.call(null,G__32677));
});

com.rpl.specter.END_transform_STAR_ = (function com$rpl$specter$END_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [structure,cljs.core.str.cljs$core$IFn$_invoke$arity$1((next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1("") : next_fn.call(null,"")))].join('');
} else {
var to_append = (function (){var G__32678 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__32678) : next_fn.call(null,G__32678));
})();
return com.rpl.specter.navs.append_all(structure,to_append);
}
});

/**
 * Navigate to the empty subsequence after the last element of the collection.
 */
com.rpl.specter.END = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32679 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32679 = (function (meta32680){
this.meta32680 = meta32680;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32679.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32681,meta32680__$1){
var self__ = this;
var _32681__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32679(meta32680__$1));
}));

(com.rpl.specter.t_com$rpl$specter32679.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32681){
var self__ = this;
var _32681__$1 = this;
return self__.meta32680;
}));

(com.rpl.specter.t_com$rpl$specter32679.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32679.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return next_fn(((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
}));

(com.rpl.specter.t_com$rpl$specter32679.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
if(typeof structure === 'string'){
return [structure,cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn(""))].join('');
} else {
var to_append = next_fn(cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all(structure,to_append);
}
}));

(com.rpl.specter.t_com$rpl$specter32679.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta32680","meta32680",-1801301463,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32679.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32679.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32679");

(com.rpl.specter.t_com$rpl$specter32679.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32679");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32679.
 */
com.rpl.specter.__GT_t_com$rpl$specter32679 = (function com$rpl$specter$__GT_t_com$rpl$specter32679(meta32680){
return (new com.rpl.specter.t_com$rpl$specter32679(meta32680));
});

}

return (new com.rpl.specter.t_com$rpl$specter32679(null));
})()
;


com.rpl.specter.NONE_ELEM_select_STAR_ = (function com$rpl$specter$NONE_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.NONE_ELEM_transform_STAR_ = (function com$rpl$specter$NONE_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(structure,newe);
}
}
});

/**
 * Navigate to 'void' elem in the set.
 *        For transformations - if result is not `NONE`,
 *        then add that value to the set.
 */
com.rpl.specter.NONE_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32682 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32682 = (function (meta32683){
this.meta32683 = meta32683;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32682.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32684,meta32683__$1){
var self__ = this;
var _32684__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32682(meta32683__$1));
}));

(com.rpl.specter.t_com$rpl$specter32682.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32684){
var self__ = this;
var _32684__$1 = this;
return self__.meta32683;
}));

(com.rpl.specter.t_com$rpl$specter32682.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32682.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter32682.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(structure,newe);
}
}
}));

(com.rpl.specter.t_com$rpl$specter32682.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta32683","meta32683",753219947,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32682.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32682.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32682");

(com.rpl.specter.t_com$rpl$specter32682.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32682");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32682.
 */
com.rpl.specter.__GT_t_com$rpl$specter32682 = (function com$rpl$specter$__GT_t_com$rpl$specter32682(meta32683){
return (new com.rpl.specter.t_com$rpl$specter32682(meta32683));
});

}

return (new com.rpl.specter.t_com$rpl$specter32682(null));
})()
;


com.rpl.specter.BEFORE_ELEM_select_STAR_ = (function com$rpl$specter$BEFORE_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.BEFORE_ELEM_transform_STAR_ = (function com$rpl$specter$BEFORE_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one(structure,newe);
}
});

/**
 * Navigate to 'void' element before the sequence.
 *        For transformations – if result is not `NONE`,
 *        then prepend that value.
 */
com.rpl.specter.BEFORE_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32685 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32685 = (function (meta32686){
this.meta32686 = meta32686;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32685.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32687,meta32686__$1){
var self__ = this;
var _32687__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32685(meta32686__$1));
}));

(com.rpl.specter.t_com$rpl$specter32685.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32687){
var self__ = this;
var _32687__$1 = this;
return self__.meta32686;
}));

(com.rpl.specter.t_com$rpl$specter32685.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32685.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter32685.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one(structure,newe);
}
}));

(com.rpl.specter.t_com$rpl$specter32685.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta32686","meta32686",-901104203,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32685.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32685.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32685");

(com.rpl.specter.t_com$rpl$specter32685.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32685");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32685.
 */
com.rpl.specter.__GT_t_com$rpl$specter32685 = (function com$rpl$specter$__GT_t_com$rpl$specter32685(meta32686){
return (new com.rpl.specter.t_com$rpl$specter32685(meta32686));
});

}

return (new com.rpl.specter.t_com$rpl$specter32685(null));
})()
;


com.rpl.specter.AFTER_ELEM_select_STAR_ = (function com$rpl$specter$AFTER_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.AFTER_ELEM_transform_STAR_ = (function com$rpl$specter$AFTER_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one(structure,newe);
}
});

/**
 * Navigate to 'void' element after the sequence.
 *        For transformations – if result is not `NONE`,
 *        then append that value.
 */
com.rpl.specter.AFTER_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32688 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32688 = (function (meta32689){
this.meta32689 = meta32689;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32688.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32690,meta32689__$1){
var self__ = this;
var _32690__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32688(meta32689__$1));
}));

(com.rpl.specter.t_com$rpl$specter32688.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32690){
var self__ = this;
var _32690__$1 = this;
return self__.meta32689;
}));

(com.rpl.specter.t_com$rpl$specter32688.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32688.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter32688.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one(structure,newe);
}
}));

(com.rpl.specter.t_com$rpl$specter32688.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta32689","meta32689",1402506225,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32688.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32688.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32688");

(com.rpl.specter.t_com$rpl$specter32688.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32688");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32688.
 */
com.rpl.specter.__GT_t_com$rpl$specter32688 = (function com$rpl$specter$__GT_t_com$rpl$specter32688(meta32689){
return (new com.rpl.specter.t_com$rpl$specter32688(meta32689));
});

}

return (new com.rpl.specter.t_com$rpl$specter32688(null));
})()
;


com.rpl.specter.subset_select_STAR_ = (function com$rpl$specter$subset_select_STAR_(aset,structure,next_fn){
var G__32691 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,aset);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__32691) : next_fn.call(null,G__32691));
});

com.rpl.specter.subset_transform_STAR_ = (function com$rpl$specter$subset_transform_STAR_(aset,structure,next_fn){
var subset = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,aset);
var newset = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(subset) : next_fn.call(null,subset));
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(structure,subset),newset);
});

/**
 * Navigates to the specified subset (by taking an intersection).
 *        In a transform, that subset in the original set is changed to the
 *        new value of the subset.
 */
com.rpl.specter.subset = com.rpl.specter.impl.direct_nav_obj((function (aset){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32692 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32692 = (function (aset,meta32693){
this.aset = aset;
this.meta32693 = meta32693;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32692.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32694,meta32693__$1){
var self__ = this;
var _32694__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32692(self__.aset,meta32693__$1));
}));

(com.rpl.specter.t_com$rpl$specter32692.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32694){
var self__ = this;
var _32694__$1 = this;
return self__.meta32693;
}));

(com.rpl.specter.t_com$rpl$specter32692.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32692.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return next_fn(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,self__.aset));
}));

(com.rpl.specter.t_com$rpl$specter32692.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
var subset = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,self__.aset);
var newset = next_fn(subset);
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(structure,subset),newset);
}));

(com.rpl.specter.t_com$rpl$specter32692.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"aset","aset",900773178,null),new cljs.core.Symbol(null,"meta32693","meta32693",174096489,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32692.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32692.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32692");

(com.rpl.specter.t_com$rpl$specter32692.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32692");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32692.
 */
com.rpl.specter.__GT_t_com$rpl$specter32692 = (function com$rpl$specter$__GT_t_com$rpl$specter32692(aset__$1,meta32693){
return (new com.rpl.specter.t_com$rpl$specter32692(aset__$1,meta32693));
});

}

return (new com.rpl.specter.t_com$rpl$specter32692(aset,null));
}));


com.rpl.specter.submap_select_STAR_ = (function com$rpl$specter$submap_select_STAR_(m_keys,structure,next_fn){
var G__32695 = cljs.core.select_keys(structure,m_keys);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__32695) : next_fn.call(null,G__32695));
});

com.rpl.specter.submap_transform_STAR_ = (function com$rpl$specter$submap_transform_STAR_(m_keys,structure,next_fn){
var submap = cljs.core.select_keys(structure,m_keys);
var newmap = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(submap) : next_fn.call(null,submap));
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,structure,m_keys),newmap], 0));
});

/**
 * Navigates to the specified submap (using select-keys).
 *        In a transform, that submap in the original map is changed to the new
 *        value of the submap.
 */
com.rpl.specter.submap = com.rpl.specter.impl.direct_nav_obj((function (m_keys){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32696 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32696 = (function (m_keys,meta32697){
this.m_keys = m_keys;
this.meta32697 = meta32697;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32696.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32698,meta32697__$1){
var self__ = this;
var _32698__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32696(self__.m_keys,meta32697__$1));
}));

(com.rpl.specter.t_com$rpl$specter32696.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32698){
var self__ = this;
var _32698__$1 = this;
return self__.meta32697;
}));

(com.rpl.specter.t_com$rpl$specter32696.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32696.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return next_fn(cljs.core.select_keys(structure,self__.m_keys));
}));

(com.rpl.specter.t_com$rpl$specter32696.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
var submap = cljs.core.select_keys(structure,self__.m_keys);
var newmap = next_fn(submap);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,structure,self__.m_keys),newmap], 0));
}));

(com.rpl.specter.t_com$rpl$specter32696.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"m-keys","m-keys",-197459035,null),new cljs.core.Symbol(null,"meta32697","meta32697",-797394256,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32696.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32696.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32696");

(com.rpl.specter.t_com$rpl$specter32696.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32696");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32696.
 */
com.rpl.specter.__GT_t_com$rpl$specter32696 = (function com$rpl$specter$__GT_t_com$rpl$specter32696(m_keys__$1,meta32697){
return (new com.rpl.specter.t_com$rpl$specter32696(m_keys__$1,meta32697));
});

}

return (new com.rpl.specter.t_com$rpl$specter32696(m_keys,null));
}));
/**
 * Navigates to a sequence that contains the results of (select ...),
 *   but is a view to the original structure that can be transformed.
 * 
 *   Requires that the input navigators will walk the structure's
 *   children in the same order when executed on "select" and then
 *   "transform".
 * 
 *   If transformed sequence is smaller than input sequence, missing entries
 *   will be filled in with NONE, triggering removal if supported by that navigator.
 * 
 *   Value collection (e.g. collect, collect-one) may not be used in the subpath.
 */
com.rpl.specter.subselect = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__32930__delegate = function (path){
var builder__31553__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32699 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32699 = (function (path,late,meta32700){
this.path = path;
this.late = late;
this.meta32700 = meta32700;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32699.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32701,meta32700__$1){
var self__ = this;
var _32701__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32699(self__.path,self__.late,meta32700__$1));
}));

(com.rpl.specter.t_com$rpl$specter32699.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32701){
var self__ = this;
var _32701__$1 = this;
return self__.meta32700;
}));

(com.rpl.specter.t_com$rpl$specter32699.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32699.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return next_fn((com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
}));

(com.rpl.specter.t_com$rpl$specter32699.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
var select_result = (com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure));
var transformed = next_fn(select_result);
var values_to_insert = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(transformed));
var G__32702 = self__.late;
var G__32703 = (function (_){
var vs = com.rpl.specter.impl.get_cell(values_to_insert);
if(cljs.core.truth_(vs)){
com.rpl.specter.impl.update_cell_BANG_(values_to_insert,cljs.core.next);

return cljs.core.first(vs);
} else {
return com.rpl.specter.NONE;
}
});
var G__32704 = structure;
return (com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(G__32702,G__32703,G__32704) : com.rpl.specter.compiled_transform.call(null,G__32702,G__32703,G__32704));
}));

(com.rpl.specter.t_com$rpl$specter32699.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta32700","meta32700",-949191092,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32699.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32699.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32699");

(com.rpl.specter.t_com$rpl$specter32699.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32699");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32699.
 */
com.rpl.specter.__GT_t_com$rpl$specter32699 = (function com$rpl$specter$__GT_t_com$rpl$specter32699(path__$1,late__$1,meta32700){
return (new com.rpl.specter.t_com$rpl$specter32699(path__$1,late__$1,meta32700));
});

}

return (new com.rpl.specter.t_com$rpl$specter32699(path,late,null));
}));
var curr_params__31554__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__31554__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__31553__auto__,curr_params__31554__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__31553__auto__,curr_params__31554__auto__,null);
}
};
var G__32930 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__32931__i = 0, G__32931__a = new Array(arguments.length -  0);
while (G__32931__i < G__32931__a.length) {G__32931__a[G__32931__i] = arguments[G__32931__i + 0]; ++G__32931__i;}
  path = new cljs.core.IndexedSeq(G__32931__a,0,null);
} 
return G__32930__delegate.call(this,path);};
G__32930.cljs$lang$maxFixedArity = 0;
G__32930.cljs$lang$applyTo = (function (arglist__32932){
var path = cljs.core.seq(arglist__32932);
return G__32930__delegate(path);
});
G__32930.cljs$core$IFn$_invoke$arity$variadic = G__32930__delegate;
return G__32930;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the given key in the map (not to the value). Navigates only if the
 *        key currently exists in the map. Can transform to NONE to remove the key/value
 *        pair from the map.
 */
com.rpl.specter.map_key = com.rpl.specter.impl.direct_nav_obj((function (key){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32705 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32705 = (function (key,meta32706){
this.key = key;
this.meta32706 = meta32706;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32705.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32707,meta32706__$1){
var self__ = this;
var _32707__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32705(self__.key,meta32706__$1));
}));

(com.rpl.specter.t_com$rpl$specter32705.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32707){
var self__ = this;
var _32707__$1 = this;
return self__.meta32706;
}));

(com.rpl.specter.t_com$rpl$specter32705.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32705.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.key)){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.key) : next_fn.call(null,vals,self__.key));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter32705.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.key)){
var newkey = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.key) : next_fn.call(null,vals,self__.key));
var dissoced = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(structure,self__.key);
if((com.rpl.specter.NONE === newkey)){
return dissoced;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(dissoced,newkey,cljs.core.get.cljs$core$IFn$_invoke$arity$2(structure,self__.key));
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter32705.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"meta32706","meta32706",-1935693441,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32705.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32705.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32705");

(com.rpl.specter.t_com$rpl$specter32705.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32705");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32705.
 */
com.rpl.specter.__GT_t_com$rpl$specter32705 = (function com$rpl$specter$__GT_t_com$rpl$specter32705(key__$1,meta32706){
return (new com.rpl.specter.t_com$rpl$specter32705(key__$1,meta32706));
});

}

return (new com.rpl.specter.t_com$rpl$specter32705(key,null));
}));
/**
 * Navigates to the given element in the set only if it exists in the set.
 *        Can transform to NONE to remove the element from the set.
 */
com.rpl.specter.set_elem = com.rpl.specter.impl.direct_nav_obj((function (elem){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32708 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32708 = (function (elem,meta32709){
this.elem = elem;
this.meta32709 = meta32709;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32708.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32710,meta32709__$1){
var self__ = this;
var _32710__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32708(self__.elem,meta32709__$1));
}));

(com.rpl.specter.t_com$rpl$specter32708.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32710){
var self__ = this;
var _32710__$1 = this;
return self__.meta32709;
}));

(com.rpl.specter.t_com$rpl$specter32708.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32708.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.elem)){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.elem) : next_fn.call(null,vals,self__.elem));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter32708.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.elem)){
var newelem = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.elem) : next_fn.call(null,vals,self__.elem));
var removed = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(structure,self__.elem);
if((com.rpl.specter.NONE === newelem)){
return removed;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(removed,newelem);
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter32708.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"elem","elem",-2035804713,null),new cljs.core.Symbol(null,"meta32709","meta32709",-1695605243,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32708.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32708.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32708");

(com.rpl.specter.t_com$rpl$specter32708.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32708");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32708.
 */
com.rpl.specter.__GT_t_com$rpl$specter32708 = (function com$rpl$specter$__GT_t_com$rpl$specter32708(elem__$1,meta32709){
return (new com.rpl.specter.t_com$rpl$specter32708(elem__$1,meta32709));
});

}

return (new com.rpl.specter.t_com$rpl$specter32708(elem,null));
}));
/**
 * Navigate to the specified keys one after another. If navigate to NONE,
 *           that element is removed from the map or vector.
 */
com.rpl.specter.keypath = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.keypath_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.keypath_STAR_));
/**
 * Navigate to the specified keys one after another, only if they exist
 *           in the data structure. If navigate to NONE, that element is removed
 *           from the map or vector.
 */
com.rpl.specter.must = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.must_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.must_STAR_));
/**
 * Navigate to the specified indices one after another. If navigate to
 *          NONE, that element is removed from the sequence.
 */
com.rpl.specter.nthpath = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.nthpath_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.nthpath_STAR_));
/**
 * Navigates to the empty space between the index and the prior index. For select
 *        navigates to NONE, and transforms to non-NONE insert at that position.
 */
com.rpl.specter.before_index = com.rpl.specter.impl.direct_nav_obj((function (index){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32711 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32711 = (function (index,meta32712){
this.index = index;
this.meta32712 = meta32712;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32711.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32713,meta32712__$1){
var self__ = this;
var _32713__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32711(self__.index,meta32712__$1));
}));

(com.rpl.specter.t_com$rpl$specter32711.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32713){
var self__ = this;
var _32713__$1 = this;
return self__.meta32712;
}));

(com.rpl.specter.t_com$rpl$specter32711.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32711.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter32711.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var v = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,com.rpl.specter.NONE) : next_fn.call(null,vals,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === v)){
return structure;
} else {
return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__31560__auto__ = com.rpl.specter.pathcache32714;
var info__31560__auto____$1 = (((info__31560__auto__ == null))?(function (){var info32715 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.srange,new cljs.core.Var(function(){return com.rpl.specter.srange;},new cljs.core.Symbol("com.rpl.specter","srange","com.rpl.specter/srange",-978851939,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"srange","srange",-1324254972,null),"com/rpl/specter.cljc",9,1,755,758,cljs.core.List.EMPTY,"Navigates to the subsequence bound by the indexes start (inclusive)\n          and end (exclusive)",(cljs.core.truth_(com.rpl.specter.srange)?com.rpl.specter.srange.cljs$lang$test:null)])),new cljs.core.Symbol(null,"srange","srange",-1324254972,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(self__.index,new cljs.core.Symbol(null,"index","index",108845612,null)),com.rpl.specter.impl.__GT_LocalSym(self__.index,new cljs.core.Symbol(null,"index","index",108845612,null))], null),cljs.core.list(new cljs.core.Symbol(null,"srange","srange",-1324254972,null),new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"srange","srange",-1324254972,null),new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)], null));
com.rpl.specter.pathcache32714 = info32715;

return info32715;
})():info__31560__auto__);
var precompiled32716 = com.rpl.specter.impl.cached_path_info_precompiled(info__31560__auto____$1);
var dynamic_QMARK___31561__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__31560__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___31561__auto__)){
var G__32717 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.srange,self__.index,self__.index], null);
return (precompiled32716.cljs$core$IFn$_invoke$arity$1 ? precompiled32716.cljs$core$IFn$_invoke$arity$1(G__32717) : precompiled32716.call(null,G__32717));
} else {
return precompiled32716;
}
})(),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v], null),structure);
}
}));

(com.rpl.specter.t_com$rpl$specter32711.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"meta32712","meta32712",-255668307,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32711.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32711.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32711");

(com.rpl.specter.t_com$rpl$specter32711.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32711");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32711.
 */
com.rpl.specter.__GT_t_com$rpl$specter32711 = (function com$rpl$specter$__GT_t_com$rpl$specter32711(index__$1,meta32712){
return (new com.rpl.specter.t_com$rpl$specter32711(index__$1,meta32712));
});

}

return (new com.rpl.specter.t_com$rpl$specter32711(index,null));
}));
/**
 * Navigates to the index of the sequence if within 0 and size. Transforms move element
 *        at that index to the new index, shifting other elements in the sequence.
 */
com.rpl.specter.index_nav = com.rpl.specter.impl.direct_nav_obj((function (i){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32718 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32718 = (function (i,meta32719){
this.i = i;
this.meta32719 = meta32719;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32718.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32720,meta32719__$1){
var self__ = this;
var _32720__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32718(self__.i,meta32719__$1));
}));

(com.rpl.specter.t_com$rpl$specter32718.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32720){
var self__ = this;
var _32720__$1 = this;
return self__.meta32719;
}));

(com.rpl.specter.t_com$rpl$specter32718.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32718.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if((((self__.i >= (0))) && ((self__.i < cljs.core.count(structure))))){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.i) : next_fn.call(null,vals,self__.i));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter32718.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if((((self__.i >= (0))) && ((self__.i < cljs.core.count(structure))))){
var newi = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.i) : next_fn.call(null,vals,self__.i));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(newi,self__.i)){
return structure;
} else {
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(structure,self__.i);
if(cljs.core.vector_QMARK_(structure)){
var shifted = (((newi < self__.i))?(function (){var j = (self__.i - (1));
var s = structure;
while(true){
if((j < newi)){
return s;
} else {
var G__32933 = (j - (1));
var G__32934 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,(j + (1)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(s,j));
j = G__32933;
s = G__32934;
continue;
}
break;
}
})():(function (){var j = (self__.i + (1));
var s = structure;
while(true){
if((j > newi)){
return s;
} else {
var G__32935 = (j + (1));
var G__32936 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,(j - (1)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(s,j));
j = G__32935;
s = G__32936;
continue;
}
break;
}
})());
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(shifted,newi,v);
} else {
return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__31560__auto__ = com.rpl.specter.pathcache32721;
var info__31560__auto____$1 = (((info__31560__auto__ == null))?(function (){var info32722 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.before_index,new cljs.core.Var(function(){return com.rpl.specter.before_index;},new cljs.core.Symbol("com.rpl.specter","before-index","com.rpl.specter/before-index",1952616274,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),"com/rpl/specter.cljc",15,1,968,971,cljs.core.List.EMPTY,"Navigates to the empty space between the index and the prior index. For select\n          navigates to NONE, and transforms to non-NONE insert at that position.",(cljs.core.truth_(com.rpl.specter.before_index)?com.rpl.specter.before_index.cljs$lang$test:null)])),new cljs.core.Symbol(null,"before-index","before-index",-407870261,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(newi,new cljs.core.Symbol(null,"newi","newi",857919881,null))], null),cljs.core.list(new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null));
com.rpl.specter.pathcache32721 = info32722;

return info32722;
})():info__31560__auto__);
var precompiled32723 = com.rpl.specter.impl.cached_path_info_precompiled(info__31560__auto____$1);
var dynamic_QMARK___31561__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__31560__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___31561__auto__)){
var G__32724 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.before_index,newi], null);
return (precompiled32723.cljs$core$IFn$_invoke$arity$1 ? precompiled32723.cljs$core$IFn$_invoke$arity$1(G__32724) : precompiled32723.call(null,G__32724));
} else {
return precompiled32723;
}
})(),v,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__31560__auto__ = com.rpl.specter.pathcache32725;
var info__31560__auto____$1 = (((info__31560__auto__ == null))?(function (){var info32726 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(self__.i,new cljs.core.Symbol(null,"i","i",253690212,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"i","i",253690212,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"i","i",253690212,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"i","i",253690212,null)], null));
com.rpl.specter.pathcache32725 = info32726;

return info32726;
})():info__31560__auto__);
var precompiled32727 = com.rpl.specter.impl.cached_path_info_precompiled(info__31560__auto____$1);
var dynamic_QMARK___31561__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__31560__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___31561__auto__)){
var G__32728 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,self__.i], null);
return (precompiled32727.cljs$core$IFn$_invoke$arity$1 ? precompiled32727.cljs$core$IFn$_invoke$arity$1(G__32728) : precompiled32727.call(null,G__32728));
} else {
return precompiled32727;
}
})(),com.rpl.specter.NONE,structure));
}
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter32718.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta32719","meta32719",-799962050,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32718.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32718.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32718");

(com.rpl.specter.t_com$rpl$specter32718.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32718");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32718.
 */
com.rpl.specter.__GT_t_com$rpl$specter32718 = (function com$rpl$specter$__GT_t_com$rpl$specter32718(i__$1,meta32719){
return (new com.rpl.specter.t_com$rpl$specter32718(i__$1,meta32719));
});

}

return (new com.rpl.specter.t_com$rpl$specter32718(i,null));
}));


com.rpl.specter.indexed_vals_select_STAR_ = (function com$rpl$specter$indexed_vals_select_STAR_(start,structure,next_fn){
var i = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1((start - (1)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__28558__auto__,e){
var ret__28559__auto__ = (function (){
com.rpl.specter.impl.update_cell_BANG_(i,cljs.core.inc);

var G__32731 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.get_cell(i),e], null);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__32731) : next_fn.call(null,G__32731));
})()
;
if((ret__28559__auto__ === com.rpl.specter.NONE)){
return curr__28558__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__28559__auto__)){
return cljs.core.reduced(ret__28559__auto__);
} else {
return ret__28559__auto__;
}
}
}),com.rpl.specter.NONE,structure);
});

com.rpl.specter.indexed_vals_transform_STAR_ = (function com$rpl$specter$indexed_vals_transform_STAR_(start,structure,next_fn){
var indices = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(structure)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s,e){
var curri = cljs.core.first(com.rpl.specter.impl.get_cell(indices));
var vec__32732 = (function (){var G__32735 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(start + curri),e], null);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__32735) : next_fn.call(null,G__32735));
})();
var newi_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32732,(0),null);
var newe = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32732,(1),null);
var newi = (newi_STAR_ - start);
com.rpl.specter.impl.update_cell_BANG_(indices,(function (ii){
var ii2 = cljs.core.next(ii);
if((newi > curri)){
return com.rpl.specter.impl.compiled_transform_STAR_((function (){var info__31560__auto__ = com.rpl.specter.pathcache32736;
var info__31560__auto____$1 = (((info__31560__auto__ == null))?(function (){var info32737 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__32729_SHARP_){
return (p1__32729_SHARP_ >= (curri + (1)));
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__32729#","p1__32729#",-1005425733,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__32729#","p1__32729#",-1005425733,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null))))),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__32730_SHARP_){
return (p1__32730_SHARP_ <= newi);
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__32730#","p1__32730#",841452715,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__32730#","p1__32730#",841452715,null),new cljs.core.Symbol(null,"newi","newi",857919881,null))))], null)], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__32729#","p1__32729#",-1005425733,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__32729#","p1__32729#",-1005425733,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__32730#","p1__32730#",841452715,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__32730#","p1__32730#",841452715,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__32729#","p1__32729#",-1005425733,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__32729#","p1__32729#",-1005425733,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__32730#","p1__32730#",841452715,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__32730#","p1__32730#",841452715,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null));
com.rpl.specter.pathcache32736 = info32737;

return info32737;
})():info__31560__auto__);
var precompiled32738 = com.rpl.specter.impl.cached_path_info_precompiled(info__31560__auto____$1);
var dynamic_QMARK___31561__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__31560__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___31561__auto__)){
var G__32739 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,(function (p1__32729_SHARP_){
return (p1__32729_SHARP_ >= (curri + (1)));
}),(function (p1__32730_SHARP_){
return (p1__32730_SHARP_ <= newi);
})], null),com.rpl.specter.ALL,(function (p1__32729_SHARP_){
return (p1__32729_SHARP_ >= (curri + (1)));
}),(function (p1__32730_SHARP_){
return (p1__32730_SHARP_ <= newi);
})], null);
return (precompiled32738.cljs$core$IFn$_invoke$arity$1 ? precompiled32738.cljs$core$IFn$_invoke$arity$1(G__32739) : precompiled32738.call(null,G__32739));
} else {
return precompiled32738;
}
})(),cljs.core.dec,ii2);
} else {
return ii2;
}
}));

return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__31560__auto__ = com.rpl.specter.pathcache32740;
var info__31560__auto____$1 = (((info__31560__auto__ == null))?(function (){var info32741 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.index_nav,new cljs.core.Var(function(){return com.rpl.specter.index_nav;},new cljs.core.Symbol("com.rpl.specter","index-nav","com.rpl.specter/index-nav",2054501071,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),"com/rpl/specter.cljc",12,1,983,986,cljs.core.List.EMPTY,"Navigates to the index of the sequence if within 0 and size. Transforms move element\n          at that index to the new index, shifting other elements in the sequence.",(cljs.core.truth_(com.rpl.specter.index_nav)?com.rpl.specter.index_nav.cljs$lang$test:null)])),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache32740 = info32741;

return info32741;
})():info__31560__auto__);
var precompiled32742 = com.rpl.specter.impl.cached_path_info_precompiled(info__31560__auto____$1);
var dynamic_QMARK___31561__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__31560__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___31561__auto__)){
var G__32743 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.index_nav,curri], null);
return (precompiled32742.cljs$core$IFn$_invoke$arity$1 ? precompiled32742.cljs$core$IFn$_invoke$arity$1(G__32743) : precompiled32742.call(null,G__32743));
} else {
return precompiled32742;
}
})(),newi,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__31560__auto__ = com.rpl.specter.pathcache32744;
var info__31560__auto____$1 = (((info__31560__auto__ == null))?(function (){var info32745 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache32744 = info32745;

return info32745;
})():info__31560__auto__);
var precompiled32746 = com.rpl.specter.impl.cached_path_info_precompiled(info__31560__auto____$1);
var dynamic_QMARK___31561__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__31560__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___31561__auto__)){
var G__32747 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,curri], null);
return (precompiled32746.cljs$core$IFn$_invoke$arity$1 ? precompiled32746.cljs$core$IFn$_invoke$arity$1(G__32747) : precompiled32746.call(null,G__32747));
} else {
return precompiled32746;
}
})(),newe,s));
}),structure,structure);
});

/**
 * Navigate to [index elem] pairs for each element in a sequence. The sequence will be indexed
 *        starting from `start`. Changing index in transform has same effect as `index-nav`. Indices seen
 *        during transform take into account any shifting from prior sequence elements changing indices.
 */
com.rpl.specter.indexed_vals = com.rpl.specter.impl.direct_nav_obj((function (start){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32748 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32748 = (function (start,meta32749){
this.start = start;
this.meta32749 = meta32749;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32748.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32750,meta32749__$1){
var self__ = this;
var _32750__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32748(self__.start,meta32749__$1));
}));

(com.rpl.specter.t_com$rpl$specter32748.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32750){
var self__ = this;
var _32750__$1 = this;
return self__.meta32749;
}));

(com.rpl.specter.t_com$rpl$specter32748.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32748.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
var i = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1((self__.start - (1)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__28558__auto__,e){
var ret__28559__auto__ = (function (){
com.rpl.specter.impl.update_cell_BANG_(i,cljs.core.inc);

return next_fn(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.get_cell(i),e], null));
})()
;
if((ret__28559__auto__ === com.rpl.specter.NONE)){
return curr__28558__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__28559__auto__)){
return cljs.core.reduced(ret__28559__auto__);
} else {
return ret__28559__auto__;
}
}
}),com.rpl.specter.NONE,structure);
}));

(com.rpl.specter.t_com$rpl$specter32748.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
var indices = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(structure)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s,e){
var curri = cljs.core.first(com.rpl.specter.impl.get_cell(indices));
var vec__32751 = next_fn(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.start + curri),e], null));
var newi_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32751,(0),null);
var newe = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32751,(1),null);
var newi = (newi_STAR_ - self__.start);
com.rpl.specter.impl.update_cell_BANG_(indices,(function (ii){
var ii2 = cljs.core.next(ii);
if((newi > curri)){
return com.rpl.specter.impl.compiled_transform_STAR_((function (){var info__31560__auto__ = com.rpl.specter.pathcache32754;
var info__31560__auto____$1 = (((info__31560__auto__ == null))?(function (){var info32755 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__32729_SHARP_){
return (p1__32729_SHARP_ >= (curri + (1)));
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__32729#","p1__32729#",-1005425733,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__32729#","p1__32729#",-1005425733,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null))))),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__32730_SHARP_){
return (p1__32730_SHARP_ <= newi);
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__32730#","p1__32730#",841452715,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__32730#","p1__32730#",841452715,null),new cljs.core.Symbol(null,"newi","newi",857919881,null))))], null)], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__32729#","p1__32729#",-1005425733,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__32729#","p1__32729#",-1005425733,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__32730#","p1__32730#",841452715,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__32730#","p1__32730#",841452715,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__32729#","p1__32729#",-1005425733,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__32729#","p1__32729#",-1005425733,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__32730#","p1__32730#",841452715,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__32730#","p1__32730#",841452715,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null));
com.rpl.specter.pathcache32754 = info32755;

return info32755;
})():info__31560__auto__);
var precompiled32756 = com.rpl.specter.impl.cached_path_info_precompiled(info__31560__auto____$1);
var dynamic_QMARK___31561__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__31560__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___31561__auto__)){
var G__32757 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,(function (p1__32729_SHARP_){
return (p1__32729_SHARP_ >= (curri + (1)));
}),(function (p1__32730_SHARP_){
return (p1__32730_SHARP_ <= newi);
})], null),com.rpl.specter.ALL,(function (p1__32729_SHARP_){
return (p1__32729_SHARP_ >= (curri + (1)));
}),(function (p1__32730_SHARP_){
return (p1__32730_SHARP_ <= newi);
})], null);
return (precompiled32756.cljs$core$IFn$_invoke$arity$1 ? precompiled32756.cljs$core$IFn$_invoke$arity$1(G__32757) : precompiled32756.call(null,G__32757));
} else {
return precompiled32756;
}
})(),cljs.core.dec,ii2);
} else {
return ii2;
}
}));

return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__31560__auto__ = com.rpl.specter.pathcache32758;
var info__31560__auto____$1 = (((info__31560__auto__ == null))?(function (){var info32759 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.index_nav,new cljs.core.Var(function(){return com.rpl.specter.index_nav;},new cljs.core.Symbol("com.rpl.specter","index-nav","com.rpl.specter/index-nav",2054501071,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),"com/rpl/specter.cljc",12,1,983,986,cljs.core.List.EMPTY,"Navigates to the index of the sequence if within 0 and size. Transforms move element\n          at that index to the new index, shifting other elements in the sequence.",(cljs.core.truth_(com.rpl.specter.index_nav)?com.rpl.specter.index_nav.cljs$lang$test:null)])),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache32758 = info32759;

return info32759;
})():info__31560__auto__);
var precompiled32760 = com.rpl.specter.impl.cached_path_info_precompiled(info__31560__auto____$1);
var dynamic_QMARK___31561__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__31560__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___31561__auto__)){
var G__32761 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.index_nav,curri], null);
return (precompiled32760.cljs$core$IFn$_invoke$arity$1 ? precompiled32760.cljs$core$IFn$_invoke$arity$1(G__32761) : precompiled32760.call(null,G__32761));
} else {
return precompiled32760;
}
})(),newi,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__31560__auto__ = com.rpl.specter.pathcache32762;
var info__31560__auto____$1 = (((info__31560__auto__ == null))?(function (){var info32763 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache32762 = info32763;

return info32763;
})():info__31560__auto__);
var precompiled32764 = com.rpl.specter.impl.cached_path_info_precompiled(info__31560__auto____$1);
var dynamic_QMARK___31561__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__31560__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___31561__auto__)){
var G__32765 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,curri], null);
return (precompiled32764.cljs$core$IFn$_invoke$arity$1 ? precompiled32764.cljs$core$IFn$_invoke$arity$1(G__32765) : precompiled32764.call(null,G__32765));
} else {
return precompiled32764;
}
})(),newe,s));
}),structure,structure);
}));

(com.rpl.specter.t_com$rpl$specter32748.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"meta32749","meta32749",-360495940,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32748.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32748.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32748");

(com.rpl.specter.t_com$rpl$specter32748.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32748");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32748.
 */
com.rpl.specter.__GT_t_com$rpl$specter32748 = (function com$rpl$specter$__GT_t_com$rpl$specter32748(start__$1,meta32749){
return (new com.rpl.specter.t_com$rpl$specter32748(start__$1,meta32749));
});

}

return (new com.rpl.specter.t_com$rpl$specter32748(start,null));
}));
/**
 * `indexed-vals` with a starting index of 0.
 */
com.rpl.specter.INDEXED_VALS = (com.rpl.specter.indexed_vals.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.indexed_vals.cljs$core$IFn$_invoke$arity$1((0)) : com.rpl.specter.indexed_vals.call(null,(0)));
/**
 * Navigates to result of running `afn` on the currently navigated value.
 */
com.rpl.specter.view = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32766 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32766 = (function (afn,meta32767){
this.afn = afn;
this.meta32767 = meta32767;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32766.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32768,meta32767__$1){
var self__ = this;
var _32768__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32766(self__.afn,meta32767__$1));
}));

(com.rpl.specter.t_com$rpl$specter32766.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32768){
var self__ = this;
var _32768__$1 = this;
return self__.meta32767;
}));

(com.rpl.specter.t_com$rpl$specter32766.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32766.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__32769 = vals;
var G__32770 = (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(structure) : self__.afn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__32769,G__32770) : next_fn.call(null,G__32769,G__32770));
}));

(com.rpl.specter.t_com$rpl$specter32766.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__32771 = vals;
var G__32772 = (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(structure) : self__.afn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__32771,G__32772) : next_fn.call(null,G__32771,G__32772));
}));

(com.rpl.specter.t_com$rpl$specter32766.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta32767","meta32767",-978647819,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32766.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32766.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32766");

(com.rpl.specter.t_com$rpl$specter32766.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32766");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32766.
 */
com.rpl.specter.__GT_t_com$rpl$specter32766 = (function com$rpl$specter$__GT_t_com$rpl$specter32766(afn__$1,meta32767){
return (new com.rpl.specter.t_com$rpl$specter32766(afn__$1,meta32767));
});

}

return (new com.rpl.specter.t_com$rpl$specter32766(afn,null));
}));


com.rpl.specter.parser_select_STAR_ = (function com$rpl$specter$parser_select_STAR_(parse_fn,unparse_fn,structure,next_fn){
var G__32773 = (parse_fn.cljs$core$IFn$_invoke$arity$1 ? parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : parse_fn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__32773) : next_fn.call(null,G__32773));
});

com.rpl.specter.parser_transform_STAR_ = (function com$rpl$specter$parser_transform_STAR_(parse_fn,unparse_fn,structure,next_fn){
var G__32774 = (function (){var G__32775 = (parse_fn.cljs$core$IFn$_invoke$arity$1 ? parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : parse_fn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__32775) : next_fn.call(null,G__32775));
})();
return (unparse_fn.cljs$core$IFn$_invoke$arity$1 ? unparse_fn.cljs$core$IFn$_invoke$arity$1(G__32774) : unparse_fn.call(null,G__32774));
});

/**
 * Navigate to the result of running `parse-fn` on the value. For
 *        transforms, the transformed value then has `unparse-fn` run on
 *        it to get the final value at this point.
 */
com.rpl.specter.parser = com.rpl.specter.impl.direct_nav_obj((function (parse_fn,unparse_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32776 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32776 = (function (parse_fn,unparse_fn,meta32777){
this.parse_fn = parse_fn;
this.unparse_fn = unparse_fn;
this.meta32777 = meta32777;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32776.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32778,meta32777__$1){
var self__ = this;
var _32778__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32776(self__.parse_fn,self__.unparse_fn,meta32777__$1));
}));

(com.rpl.specter.t_com$rpl$specter32776.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32778){
var self__ = this;
var _32778__$1 = this;
return self__.meta32777;
}));

(com.rpl.specter.t_com$rpl$specter32776.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32776.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return next_fn((self__.parse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.parse_fn.call(null,structure)));
}));

(com.rpl.specter.t_com$rpl$specter32776.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
var G__32779 = next_fn((self__.parse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.parse_fn.call(null,structure)));
return (self__.unparse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.unparse_fn.cljs$core$IFn$_invoke$arity$1(G__32779) : self__.unparse_fn.call(null,G__32779));
}));

(com.rpl.specter.t_com$rpl$specter32776.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parse-fn","parse-fn",-836029424,null),new cljs.core.Symbol(null,"unparse-fn","unparse-fn",407187734,null),new cljs.core.Symbol(null,"meta32777","meta32777",-1018460784,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32776.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32776.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32776");

(com.rpl.specter.t_com$rpl$specter32776.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32776");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32776.
 */
com.rpl.specter.__GT_t_com$rpl$specter32776 = (function com$rpl$specter$__GT_t_com$rpl$specter32776(parse_fn__$1,unparse_fn__$1,meta32777){
return (new com.rpl.specter.t_com$rpl$specter32776(parse_fn__$1,unparse_fn__$1,meta32777));
});

}

return (new com.rpl.specter.t_com$rpl$specter32776(parse_fn,unparse_fn,null));
}));


com.rpl.specter.ATOM_select_STAR_ = (function com$rpl$specter$ATOM_select_STAR_(structure,next_fn){
var G__32780 = cljs.core.deref(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__32780) : next_fn.call(null,G__32780));
});

com.rpl.specter.ATOM_transform_STAR_ = (function com$rpl$specter$ATOM_transform_STAR_(structure,next_fn){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(structure,next_fn);

return structure;
});

/**
 * Navigates to atom value.
 */
com.rpl.specter.ATOM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32781 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32781 = (function (meta32782){
this.meta32782 = meta32782;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32781.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32783,meta32782__$1){
var self__ = this;
var _32783__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32781(meta32782__$1));
}));

(com.rpl.specter.t_com$rpl$specter32781.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32783){
var self__ = this;
var _32783__$1 = this;
return self__.meta32782;
}));

(com.rpl.specter.t_com$rpl$specter32781.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32781.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return next_fn(cljs.core.deref(structure));
}));

(com.rpl.specter.t_com$rpl$specter32781.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(structure,next_fn);

return structure;
}));

(com.rpl.specter.t_com$rpl$specter32781.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta32782","meta32782",-1115054895,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32781.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32781.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32781");

(com.rpl.specter.t_com$rpl$specter32781.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32781");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32781.
 */
com.rpl.specter.__GT_t_com$rpl$specter32781 = (function com$rpl$specter$__GT_t_com$rpl$specter32781(meta32782){
return (new com.rpl.specter.t_com$rpl$specter32781(meta32782));
});

}

return (new com.rpl.specter.t_com$rpl$specter32781(null));
})()
;


com.rpl.specter.regex_nav_select_STAR_ = (function com$rpl$specter$regex_nav_select_STAR_(re,structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__28558__auto__,s){
var ret__28559__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(s) : next_fn.call(null,s));
if((ret__28559__auto__ === com.rpl.specter.NONE)){
return curr__28558__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__28559__auto__)){
return cljs.core.reduced(ret__28559__auto__);
} else {
return ret__28559__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.re_seq(re,structure));
});

com.rpl.specter.regex_nav_transform_STAR_ = (function com$rpl$specter$regex_nav_transform_STAR_(re,structure,next_fn){
return clojure.string.replace(structure,re,next_fn);
});

com.rpl.specter.regex_nav = com.rpl.specter.impl.direct_nav_obj((function (re){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32784 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32784 = (function (re,meta32785){
this.re = re;
this.meta32785 = meta32785;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32784.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32786,meta32785__$1){
var self__ = this;
var _32786__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32784(self__.re,meta32785__$1));
}));

(com.rpl.specter.t_com$rpl$specter32784.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32786){
var self__ = this;
var _32786__$1 = this;
return self__.meta32785;
}));

(com.rpl.specter.t_com$rpl$specter32784.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32784.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__28558__auto__,s){
var ret__28559__auto__ = next_fn(s);
if((ret__28559__auto__ === com.rpl.specter.NONE)){
return curr__28558__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__28559__auto__)){
return cljs.core.reduced(ret__28559__auto__);
} else {
return ret__28559__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.re_seq(self__.re,structure));
}));

(com.rpl.specter.t_com$rpl$specter32784.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return clojure.string.replace(structure,self__.re,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter32784.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"re","re",1869207729,null),new cljs.core.Symbol(null,"meta32785","meta32785",-1380342572,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32784.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32784.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32784");

(com.rpl.specter.t_com$rpl$specter32784.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32784");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32784.
 */
com.rpl.specter.__GT_t_com$rpl$specter32784 = (function com$rpl$specter$__GT_t_com$rpl$specter32784(re__$1,meta32785){
return (new com.rpl.specter.t_com$rpl$specter32784(re__$1,meta32785));
});

}

return (new com.rpl.specter.t_com$rpl$specter32784(re,null));
}));
/**
 * Filters the current value based on whether a path finds anything.
 *   e.g. (selected? :vals ALL even?) keeps the current element only if an
 *   even number exists for the :vals key.
 */
com.rpl.specter.selected_QMARK_ = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__32942__delegate = function (path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(path);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
return afn;
} else {
var builder__31553__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32789 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32789 = (function (path,temp__5733__auto__,late,meta32790){
this.path = path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late = late;
this.meta32790 = meta32790;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32789.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32791,meta32790__$1){
var self__ = this;
var _32791__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32789(self__.path,self__.temp__5733__auto__,self__.late,meta32790__$1));
}));

(com.rpl.specter.t_com$rpl$specter32789.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32791){
var self__ = this;
var _32791__$1 = this;
return self__.meta32790;
}));

(com.rpl.specter.t_com$rpl$specter32789.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32789.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select((function (p1__32787_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late,vals,p1__32787_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter32789.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform((function (p1__32788_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late,vals,p1__32788_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter32789.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta32790","meta32790",1502979359,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32789.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32789.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32789");

(com.rpl.specter.t_com$rpl$specter32789.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32789");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32789.
 */
com.rpl.specter.__GT_t_com$rpl$specter32789 = (function com$rpl$specter$__GT_t_com$rpl$specter32789(path__$1,temp__5733__auto____$1,late__$1,meta32790){
return (new com.rpl.specter.t_com$rpl$specter32789(path__$1,temp__5733__auto____$1,late__$1,meta32790));
});

}

return (new com.rpl.specter.t_com$rpl$specter32789(path,temp__5733__auto__,late,null));
}));
var curr_params__31554__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__31554__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__31553__auto__,curr_params__31554__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__31553__auto__,curr_params__31554__auto__,null);
}
}
};
var G__32942 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__32943__i = 0, G__32943__a = new Array(arguments.length -  0);
while (G__32943__i < G__32943__a.length) {G__32943__a[G__32943__i] = arguments[G__32943__i + 0]; ++G__32943__i;}
  path = new cljs.core.IndexedSeq(G__32943__a,0,null);
} 
return G__32942__delegate.call(this,path);};
G__32942.cljs$lang$maxFixedArity = 0;
G__32942.cljs$lang$applyTo = (function (arglist__32944){
var path = cljs.core.seq(arglist__32944);
return G__32942__delegate(path);
});
G__32942.cljs$core$IFn$_invoke$arity$variadic = G__32942__delegate;
return G__32942;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.not_selected_QMARK_ = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__32945__delegate = function (path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(path);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
return (function (s){
return cljs.core.not((afn.cljs$core$IFn$_invoke$arity$1 ? afn.cljs$core$IFn$_invoke$arity$1(s) : afn.call(null,s)));
});
} else {
var builder__31553__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32794 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32794 = (function (path,temp__5733__auto__,late,meta32795){
this.path = path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late = late;
this.meta32795 = meta32795;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32794.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32796,meta32795__$1){
var self__ = this;
var _32796__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32794(self__.path,self__.temp__5733__auto__,self__.late,meta32795__$1));
}));

(com.rpl.specter.t_com$rpl$specter32794.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32796){
var self__ = this;
var _32796__$1 = this;
return self__.meta32795;
}));

(com.rpl.specter.t_com$rpl$specter32794.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32794.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select((function (p1__32792_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_(self__.late,vals,p1__32792_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter32794.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform((function (p1__32793_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_(self__.late,vals,p1__32793_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter32794.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta32795","meta32795",1170017713,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32794.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32794.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32794");

(com.rpl.specter.t_com$rpl$specter32794.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32794");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32794.
 */
com.rpl.specter.__GT_t_com$rpl$specter32794 = (function com$rpl$specter$__GT_t_com$rpl$specter32794(path__$1,temp__5733__auto____$1,late__$1,meta32795){
return (new com.rpl.specter.t_com$rpl$specter32794(path__$1,temp__5733__auto____$1,late__$1,meta32795));
});

}

return (new com.rpl.specter.t_com$rpl$specter32794(path,temp__5733__auto__,late,null));
}));
var curr_params__31554__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__31554__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__31553__auto__,curr_params__31554__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__31553__auto__,curr_params__31554__auto__,null);
}
}
};
var G__32945 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__32947__i = 0, G__32947__a = new Array(arguments.length -  0);
while (G__32947__i < G__32947__a.length) {G__32947__a[G__32947__i] = arguments[G__32947__i + 0]; ++G__32947__i;}
  path = new cljs.core.IndexedSeq(G__32947__a,0,null);
} 
return G__32945__delegate.call(this,path);};
G__32945.cljs$lang$maxFixedArity = 0;
G__32945.cljs$lang$applyTo = (function (arglist__32949){
var path = cljs.core.seq(arglist__32949);
return G__32945__delegate(path);
});
G__32945.cljs$core$IFn$_invoke$arity$variadic = G__32945__delegate;
return G__32945;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current sequence that only contains elements that
 *   match the given path. An element matches the selector path if calling select
 *   on that element with the path yields anything other than an empty sequence.
 * 
 *   For transformation: `NONE` entries in the result sequence cause corresponding entries in
 *   input to be removed. A result sequence smaller than the input sequence is equivalent to
 *   padding the result sequence with `NONE` at the end until the same size as the input.
 */
com.rpl.specter.filterer = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__32951__delegate = function (path){
var G__32797 = com.rpl.specter.ALL;
var G__32798 = (com.rpl.specter.selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.selected_QMARK_.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.selected_QMARK_.call(null,path));
return (com.rpl.specter.subselect.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.subselect.cljs$core$IFn$_invoke$arity$2(G__32797,G__32798) : com.rpl.specter.subselect.call(null,G__32797,G__32798));
};
var G__32951 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__32952__i = 0, G__32952__a = new Array(arguments.length -  0);
while (G__32952__i < G__32952__a.length) {G__32952__a[G__32952__i] = arguments[G__32952__i + 0]; ++G__32952__i;}
  path = new cljs.core.IndexedSeq(G__32952__a,0,null);
} 
return G__32951__delegate.call(this,path);};
G__32951.cljs$lang$maxFixedArity = 0;
G__32951.cljs$lang$applyTo = (function (arglist__32953){
var path = cljs.core.seq(arglist__32953);
return G__32951__delegate(path);
});
G__32951.cljs$core$IFn$_invoke$arity$variadic = G__32951__delegate;
return G__32951;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming it with the
 * specified path and update-fn.
 */
com.rpl.specter.transformed = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (path,update_fn){
var builder__31553__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late,late_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32799 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32799 = (function (path,update_fn,late,late_fn,meta32800){
this.path = path;
this.update_fn = update_fn;
this.late = late;
this.late_fn = late_fn;
this.meta32800 = meta32800;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32799.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32801,meta32800__$1){
var self__ = this;
var _32801__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32799(self__.path,self__.update_fn,self__.late,self__.late_fn,meta32800__$1));
}));

(com.rpl.specter.t_com$rpl$specter32799.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32801){
var self__ = this;
var _32801__$1 = this;
return self__.meta32800;
}));

(com.rpl.specter.t_com$rpl$specter32799.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32799.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return next_fn((com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(self__.late,self__.late_fn,structure) : com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure)));
}));

(com.rpl.specter.t_com$rpl$specter32799.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return next_fn((com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(self__.late,self__.late_fn,structure) : com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure)));
}));

(com.rpl.specter.t_com$rpl$specter32799.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"update-fn","update-fn",-1943348456,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta32800","meta32800",1261544519,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32799.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32799.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32799");

(com.rpl.specter.t_com$rpl$specter32799.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32799");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32799.
 */
com.rpl.specter.__GT_t_com$rpl$specter32799 = (function com$rpl$specter$__GT_t_com$rpl$specter32799(path__$1,update_fn__$1,late__$1,late_fn__$1,meta32800){
return (new com.rpl.specter.t_com$rpl$specter32799(path__$1,update_fn__$1,late__$1,late_fn__$1,meta32800));
});

}

return (new com.rpl.specter.t_com$rpl$specter32799(path,update_fn,late,late_fn,null));
}));
var curr_params__31554__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path)),update_fn], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__31554__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__31553__auto__,curr_params__31554__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__31553__auto__,curr_params__31554__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming with a reduction over
 * the specified traversal.
 */
com.rpl.specter.traversed = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (path,reduce_fn){
var builder__31553__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late,late_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32802 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32802 = (function (path,reduce_fn,late,late_fn,meta32803){
this.path = path;
this.reduce_fn = reduce_fn;
this.late = late;
this.late_fn = late_fn;
this.meta32803 = meta32803;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32802.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32804,meta32803__$1){
var self__ = this;
var _32804__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32802(self__.path,self__.reduce_fn,self__.late,self__.late_fn,meta32803__$1));
}));

(com.rpl.specter.t_com$rpl$specter32802.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32804){
var self__ = this;
var _32804__$1 = this;
return self__.meta32803;
}));

(com.rpl.specter.t_com$rpl$specter32802.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32802.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return next_fn(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(self__.late_fn,(com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_traverse.call(null,self__.late,structure))));
}));

(com.rpl.specter.t_com$rpl$specter32802.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return next_fn(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(self__.late_fn,(com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_traverse.call(null,self__.late,structure))));
}));

(com.rpl.specter.t_com$rpl$specter32802.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"reduce-fn","reduce-fn",-1484020844,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta32803","meta32803",-1518347288,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32802.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32802.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32802");

(com.rpl.specter.t_com$rpl$specter32802.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32802");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32802.
 */
com.rpl.specter.__GT_t_com$rpl$specter32802 = (function com$rpl$specter$__GT_t_com$rpl$specter32802(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta32803){
return (new com.rpl.specter.t_com$rpl$specter32802(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta32803));
});

}

return (new com.rpl.specter.t_com$rpl$specter32802(path,reduce_fn,late,late_fn,null));
}));
var curr_params__31554__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path)),reduce_fn], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__31554__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__31553__auto__,curr_params__31554__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__31553__auto__,curr_params__31554__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Keeps the element only if it matches the supplied predicate. Functions in paths
 *        implicitly convert to this navigator.
 */
com.rpl.specter.pred = com.rpl.specter.impl.pred_STAR_;
com.rpl.specter.pred_EQ_ = (function com$rpl$specter$pred_EQ_(v){
var G__32806 = (function (p1__32805_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__32805_SHARP_,v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__32806) : com.rpl.specter.pred.call(null,G__32806));
});
com.rpl.specter.pred_LT_ = (function com$rpl$specter$pred_LT_(v){
var G__32808 = (function (p1__32807_SHARP_){
return (p1__32807_SHARP_ < v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__32808) : com.rpl.specter.pred.call(null,G__32808));
});
com.rpl.specter.pred_GT_ = (function com$rpl$specter$pred_GT_(v){
var G__32810 = (function (p1__32809_SHARP_){
return (p1__32809_SHARP_ > v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__32810) : com.rpl.specter.pred.call(null,G__32810));
});
com.rpl.specter.pred_LT__EQ_ = (function com$rpl$specter$pred_LT__EQ_(v){
var G__32812 = (function (p1__32811_SHARP_){
return (p1__32811_SHARP_ <= v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__32812) : com.rpl.specter.pred.call(null,G__32812));
});
com.rpl.specter.pred_GT__EQ_ = (function com$rpl$specter$pred_GT__EQ_(v){
var G__32814 = (function (p1__32813_SHARP_){
return (p1__32813_SHARP_ >= v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__32814) : com.rpl.specter.pred.call(null,G__32814));
});
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"null",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"null",(function (this$){
return com.rpl.specter.STAY;
}));
(cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
(cljs.core.Symbol.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Symbol.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"string",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"string",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"number",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"number",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
(cljs.core.char$.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.char$.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"boolean",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"boolean",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"function",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"function",(function (this$){
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.pred.call(null,this$));
}));
(cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.pred.call(null,this$__$1));
}));
(RegExp.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(RegExp.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.regex_nav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.regex_nav.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.regex_nav.call(null,this$__$1));
}));


com.rpl.specter.nil__GT_val_select_STAR_ = (function com$rpl$specter$nil__GT_val_select_STAR_(v,structure,next_fn){
var G__32815 = (((structure == null))?v:structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__32815) : next_fn.call(null,G__32815));
});

com.rpl.specter.nil__GT_val_transform_STAR_ = (function com$rpl$specter$nil__GT_val_transform_STAR_(v,structure,next_fn){
var G__32816 = (((structure == null))?v:structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__32816) : next_fn.call(null,G__32816));
});

/**
 * Navigates to the provided val if the structure is nil. Otherwise it stays
 *        navigated at the structure.
 */
com.rpl.specter.nil__GT_val = com.rpl.specter.impl.direct_nav_obj((function (v){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32817 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32817 = (function (v,meta32818){
this.v = v;
this.meta32818 = meta32818;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32817.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32819,meta32818__$1){
var self__ = this;
var _32819__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32817(self__.v,meta32818__$1));
}));

(com.rpl.specter.t_com$rpl$specter32817.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32819){
var self__ = this;
var _32819__$1 = this;
return self__.meta32818;
}));

(com.rpl.specter.t_com$rpl$specter32817.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32817.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return next_fn((((structure == null))?self__.v:structure));
}));

(com.rpl.specter.t_com$rpl$specter32817.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return next_fn((((structure == null))?self__.v:structure));
}));

(com.rpl.specter.t_com$rpl$specter32817.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"meta32818","meta32818",-1342398360,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32817.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32817.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32817");

(com.rpl.specter.t_com$rpl$specter32817.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32817");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32817.
 */
com.rpl.specter.__GT_t_com$rpl$specter32817 = (function com$rpl$specter$__GT_t_com$rpl$specter32817(v__$1,meta32818){
return (new com.rpl.specter.t_com$rpl$specter32817(v__$1,meta32818));
});

}

return (new com.rpl.specter.t_com$rpl$specter32817(v,null));
}));
/**
 * Navigates to #{} if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_SET = (function (){var G__32820 = cljs.core.PersistentHashSet.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__32820) : com.rpl.specter.nil__GT_val.call(null,G__32820));
})();
/**
 * Navigates to '() if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_LIST = (function (){var G__32821 = cljs.core.List.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__32821) : com.rpl.specter.nil__GT_val.call(null,G__32821));
})();
/**
 * Navigates to [] if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_VECTOR = (function (){var G__32822 = cljs.core.PersistentVector.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__32822) : com.rpl.specter.nil__GT_val.call(null,G__32822));
})();


com.rpl.specter.META_select_STAR_ = (function com$rpl$specter$META_select_STAR_(structure,next_fn){
var G__32823 = cljs.core.meta(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__32823) : next_fn.call(null,G__32823));
});

com.rpl.specter.META_transform_STAR_ = (function com$rpl$specter$META_transform_STAR_(structure,next_fn){
return cljs.core.with_meta(structure,(function (){var G__32824 = cljs.core.meta(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__32824) : next_fn.call(null,G__32824));
})());
});

/**
 * Navigates to the metadata of the structure, or nil if
 *   the structure has no metadata or may not contain metadata.
 */
com.rpl.specter.META = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32825 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32825 = (function (meta32826){
this.meta32826 = meta32826;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32825.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32827,meta32826__$1){
var self__ = this;
var _32827__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32825(meta32826__$1));
}));

(com.rpl.specter.t_com$rpl$specter32825.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32827){
var self__ = this;
var _32827__$1 = this;
return self__.meta32826;
}));

(com.rpl.specter.t_com$rpl$specter32825.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32825.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return next_fn(cljs.core.meta(structure));
}));

(com.rpl.specter.t_com$rpl$specter32825.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return cljs.core.with_meta(structure,next_fn(cljs.core.meta(structure)));
}));

(com.rpl.specter.t_com$rpl$specter32825.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta32826","meta32826",2118718780,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32825.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32825.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32825");

(com.rpl.specter.t_com$rpl$specter32825.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32825");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32825.
 */
com.rpl.specter.__GT_t_com$rpl$specter32825 = (function com$rpl$specter$__GT_t_com$rpl$specter32825(meta32826){
return (new com.rpl.specter.t_com$rpl$specter32825(meta32826));
});

}

return (new com.rpl.specter.t_com$rpl$specter32825(null));
})()
;


com.rpl.specter.NAME_select_STAR_ = (function com$rpl$specter$NAME_select_STAR_(structure,next_fn){
var G__32828 = cljs.core.name(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__32828) : next_fn.call(null,G__32828));
});

com.rpl.specter.NAME_transform_STAR_ = (function com$rpl$specter$NAME_transform_STAR_(structure,next_fn){
var new_name = (function (){var G__32829 = cljs.core.name(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__32829) : next_fn.call(null,G__32829));
})();
var ns = cljs.core.namespace(structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAME can only be used on symbols or keywords - ",structure], 0));

}
}
});

/**
 * Navigates to the name portion of the keyword or symbol
 */
com.rpl.specter.NAME = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32830 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32830 = (function (meta32831){
this.meta32831 = meta32831;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32830.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32832,meta32831__$1){
var self__ = this;
var _32832__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32830(meta32831__$1));
}));

(com.rpl.specter.t_com$rpl$specter32830.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32832){
var self__ = this;
var _32832__$1 = this;
return self__.meta32831;
}));

(com.rpl.specter.t_com$rpl$specter32830.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32830.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return next_fn(cljs.core.name(structure));
}));

(com.rpl.specter.t_com$rpl$specter32830.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
var new_name = next_fn(cljs.core.name(structure));
var ns = cljs.core.namespace(structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAME can only be used on symbols or keywords - ",structure], 0));

}
}
}));

(com.rpl.specter.t_com$rpl$specter32830.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta32831","meta32831",1067571359,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32830.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32830.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32830");

(com.rpl.specter.t_com$rpl$specter32830.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32830");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32830.
 */
com.rpl.specter.__GT_t_com$rpl$specter32830 = (function com$rpl$specter$__GT_t_com$rpl$specter32830(meta32831){
return (new com.rpl.specter.t_com$rpl$specter32830(meta32831));
});

}

return (new com.rpl.specter.t_com$rpl$specter32830(null));
})()
;


com.rpl.specter.NAMESPACE_select_STAR_ = (function com$rpl$specter$NAMESPACE_select_STAR_(structure,next_fn){
var G__32833 = cljs.core.namespace(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__32833) : next_fn.call(null,G__32833));
});

com.rpl.specter.NAMESPACE_transform_STAR_ = (function com$rpl$specter$NAMESPACE_transform_STAR_(structure,next_fn){
var name = cljs.core.name(structure);
var new_ns = (function (){var G__32834 = cljs.core.namespace(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__32834) : next_fn.call(null,G__32834));
})();
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAMESPACE can only be used on symbols or keywords - ",structure], 0));

}
}
});

/**
 * Navigates to the namespace portion of the keyword or symbol
 */
com.rpl.specter.NAMESPACE = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32835 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32835 = (function (meta32836){
this.meta32836 = meta32836;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32835.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32837,meta32836__$1){
var self__ = this;
var _32837__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32835(meta32836__$1));
}));

(com.rpl.specter.t_com$rpl$specter32835.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32837){
var self__ = this;
var _32837__$1 = this;
return self__.meta32836;
}));

(com.rpl.specter.t_com$rpl$specter32835.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32835.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
return next_fn(cljs.core.namespace(structure));
}));

(com.rpl.specter.t_com$rpl$specter32835.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__30724__auto__,vals__30725__auto__,structure,next_fn__30726__auto__){
var self__ = this;
var this__30724__auto____$1 = this;
var next_fn = (function (s__30727__auto__){
return (next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__30726__auto__.cljs$core$IFn$_invoke$arity$2(vals__30725__auto__,s__30727__auto__) : next_fn__30726__auto__.call(null,vals__30725__auto__,s__30727__auto__));
});
var name = cljs.core.name(structure);
var new_ns = next_fn(cljs.core.namespace(structure));
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAMESPACE can only be used on symbols or keywords - ",structure], 0));

}
}
}));

(com.rpl.specter.t_com$rpl$specter32835.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta32836","meta32836",963580259,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32835.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32835.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32835");

(com.rpl.specter.t_com$rpl$specter32835.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32835");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32835.
 */
com.rpl.specter.__GT_t_com$rpl$specter32835 = (function com$rpl$specter$__GT_t_com$rpl$specter32835(meta32836){
return (new com.rpl.specter.t_com$rpl$specter32835(meta32836));
});

}

return (new com.rpl.specter.t_com$rpl$specter32835(null));
})()
;
/**
 * Adds the result of running select with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__32957__delegate = function (path){
var builder__31553__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32838 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32838 = (function (path,late,meta32839){
this.path = path;
this.late = late;
this.meta32839 = meta32839;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32838.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32840,meta32839__$1){
var self__ = this;
var _32840__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32838(self__.path,self__.late,meta32839__$1));
}));

(com.rpl.specter.t_com$rpl$specter32838.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32840){
var self__ = this;
var _32840__$1 = this;
return self__.meta32839;
}));

(com.rpl.specter.t_com$rpl$specter32838.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32838.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__31550__auto__,vals__31551__auto__,structure,next_fn__31552__auto__){
var self__ = this;
var this__31550__auto____$1 = this;
var G__32841 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__31551__auto__,(com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
var G__32842 = structure;
return (next_fn__31552__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__31552__auto__.cljs$core$IFn$_invoke$arity$2(G__32841,G__32842) : next_fn__31552__auto__.call(null,G__32841,G__32842));
}));

(com.rpl.specter.t_com$rpl$specter32838.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__31550__auto__,vals__31551__auto__,structure,next_fn__31552__auto__){
var self__ = this;
var this__31550__auto____$1 = this;
var G__32843 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__31551__auto__,(com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
var G__32844 = structure;
return (next_fn__31552__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__31552__auto__.cljs$core$IFn$_invoke$arity$2(G__32843,G__32844) : next_fn__31552__auto__.call(null,G__32843,G__32844));
}));

(com.rpl.specter.t_com$rpl$specter32838.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta32839","meta32839",1901742144,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32838.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32838.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32838");

(com.rpl.specter.t_com$rpl$specter32838.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32838");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32838.
 */
com.rpl.specter.__GT_t_com$rpl$specter32838 = (function com$rpl$specter$__GT_t_com$rpl$specter32838(path__$1,late__$1,meta32839){
return (new com.rpl.specter.t_com$rpl$specter32838(path__$1,late__$1,meta32839));
});

}

return (new com.rpl.specter.t_com$rpl$specter32838(path,late,null));
}));
var curr_params__31554__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__31554__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__31553__auto__,curr_params__31554__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__31553__auto__,curr_params__31554__auto__,null);
}
};
var G__32957 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__32958__i = 0, G__32958__a = new Array(arguments.length -  0);
while (G__32958__i < G__32958__a.length) {G__32958__a[G__32958__i] = arguments[G__32958__i + 0]; ++G__32958__i;}
  path = new cljs.core.IndexedSeq(G__32958__a,0,null);
} 
return G__32957__delegate.call(this,path);};
G__32957.cljs$lang$maxFixedArity = 0;
G__32957.cljs$lang$applyTo = (function (arglist__32959){
var path = cljs.core.seq(arglist__32959);
return G__32957__delegate(path);
});
G__32957.cljs$core$IFn$_invoke$arity$variadic = G__32957__delegate;
return G__32957;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds the result of running select-one with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect_one = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__32960__delegate = function (path){
var builder__31553__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32845 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32845 = (function (path,late,meta32846){
this.path = path;
this.late = late;
this.meta32846 = meta32846;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32845.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32847,meta32846__$1){
var self__ = this;
var _32847__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32845(self__.path,self__.late,meta32846__$1));
}));

(com.rpl.specter.t_com$rpl$specter32845.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32847){
var self__ = this;
var _32847__$1 = this;
return self__.meta32846;
}));

(com.rpl.specter.t_com$rpl$specter32845.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32845.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__31550__auto__,vals__31551__auto__,structure,next_fn__31552__auto__){
var self__ = this;
var this__31550__auto____$1 = this;
var G__32848 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__31551__auto__,(com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select_one.call(null,self__.late,structure)));
var G__32849 = structure;
return (next_fn__31552__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__31552__auto__.cljs$core$IFn$_invoke$arity$2(G__32848,G__32849) : next_fn__31552__auto__.call(null,G__32848,G__32849));
}));

(com.rpl.specter.t_com$rpl$specter32845.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__31550__auto__,vals__31551__auto__,structure,next_fn__31552__auto__){
var self__ = this;
var this__31550__auto____$1 = this;
var G__32850 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__31551__auto__,(com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select_one.call(null,self__.late,structure)));
var G__32851 = structure;
return (next_fn__31552__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__31552__auto__.cljs$core$IFn$_invoke$arity$2(G__32850,G__32851) : next_fn__31552__auto__.call(null,G__32850,G__32851));
}));

(com.rpl.specter.t_com$rpl$specter32845.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta32846","meta32846",1904872570,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32845.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32845.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32845");

(com.rpl.specter.t_com$rpl$specter32845.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32845");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32845.
 */
com.rpl.specter.__GT_t_com$rpl$specter32845 = (function com$rpl$specter$__GT_t_com$rpl$specter32845(path__$1,late__$1,meta32846){
return (new com.rpl.specter.t_com$rpl$specter32845(path__$1,late__$1,meta32846));
});

}

return (new com.rpl.specter.t_com$rpl$specter32845(path,late,null));
}));
var curr_params__31554__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__31554__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__31553__auto__,curr_params__31554__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__31553__auto__,curr_params__31554__auto__,null);
}
};
var G__32960 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__32961__i = 0, G__32961__a = new Array(arguments.length -  0);
while (G__32961__i < G__32961__a.length) {G__32961__a[G__32961__i] = arguments[G__32961__i + 0]; ++G__32961__i;}
  path = new cljs.core.IndexedSeq(G__32961__a,0,null);
} 
return G__32960__delegate.call(this,path);};
G__32960.cljs$lang$maxFixedArity = 0;
G__32960.cljs$lang$applyTo = (function (arglist__32962){
var path = cljs.core.seq(arglist__32962);
return G__32960__delegate(path);
});
G__32960.cljs$core$IFn$_invoke$arity$variadic = G__32960__delegate;
return G__32960;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds an external value to the collected vals. Useful when additional arguments
 *   are required to the transform function that would otherwise require partial
 *   application or a wrapper function.
 * 
 *   e.g., incrementing val at path [:a :b] by 3:
 *   (transform [:a :b (putval 3)] + some-map)
 */
com.rpl.specter.putval = com.rpl.specter.impl.direct_nav_obj((function (val){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32852 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32852 = (function (val,meta32853){
this.val = val;
this.meta32853 = meta32853;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32852.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32854,meta32853__$1){
var self__ = this;
var _32854__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32852(self__.val,meta32853__$1));
}));

(com.rpl.specter.t_com$rpl$specter32852.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32854){
var self__ = this;
var _32854__$1 = this;
return self__.meta32853;
}));

(com.rpl.specter.t_com$rpl$specter32852.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32852.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__31550__auto__,vals__31551__auto__,structure,next_fn__31552__auto__){
var self__ = this;
var this__31550__auto____$1 = this;
var G__32855 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__31551__auto__,self__.val);
var G__32856 = structure;
return (next_fn__31552__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__31552__auto__.cljs$core$IFn$_invoke$arity$2(G__32855,G__32856) : next_fn__31552__auto__.call(null,G__32855,G__32856));
}));

(com.rpl.specter.t_com$rpl$specter32852.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__31550__auto__,vals__31551__auto__,structure,next_fn__31552__auto__){
var self__ = this;
var this__31550__auto____$1 = this;
var G__32857 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__31551__auto__,self__.val);
var G__32858 = structure;
return (next_fn__31552__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__31552__auto__.cljs$core$IFn$_invoke$arity$2(G__32857,G__32858) : next_fn__31552__auto__.call(null,G__32857,G__32858));
}));

(com.rpl.specter.t_com$rpl$specter32852.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"meta32853","meta32853",1757555012,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32852.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32852.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32852");

(com.rpl.specter.t_com$rpl$specter32852.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32852");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32852.
 */
com.rpl.specter.__GT_t_com$rpl$specter32852 = (function com$rpl$specter$__GT_t_com$rpl$specter32852(val__$1,meta32853){
return (new com.rpl.specter.t_com$rpl$specter32852(val__$1,meta32853));
});

}

return (new com.rpl.specter.t_com$rpl$specter32852(val,null));
}));
/**
 * Continues navigating on the given path with the collected vals reset to []. Once
 *   navigation leaves the scope of with-fresh-collected, the collected vals revert
 *   to what they were before.
 */
com.rpl.specter.with_fresh_collected = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__32963__delegate = function (path){
var builder__31553__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32859 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32859 = (function (path,late,meta32860){
this.path = path;
this.late = late;
this.meta32860 = meta32860;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32859.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32861,meta32860__$1){
var self__ = this;
var _32861__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32859(self__.path,self__.late,meta32860__$1));
}));

(com.rpl.specter.t_com$rpl$specter32859.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32861){
var self__ = this;
var _32861__$1 = this;
return self__.meta32860;
}));

(com.rpl.specter.t_com$rpl$specter32859.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32859.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.select_STAR_(self__.late,cljs.core.PersistentVector.EMPTY,structure,(function (_,structure__$1){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,structure__$1) : next_fn.call(null,vals,structure__$1));
}));
}));

(com.rpl.specter.t_com$rpl$specter32859.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.transform_STAR_(self__.late,cljs.core.PersistentVector.EMPTY,structure,(function (_,structure__$1){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,structure__$1) : next_fn.call(null,vals,structure__$1));
}));
}));

(com.rpl.specter.t_com$rpl$specter32859.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta32860","meta32860",-1881999007,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32859.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32859.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32859");

(com.rpl.specter.t_com$rpl$specter32859.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32859");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32859.
 */
com.rpl.specter.__GT_t_com$rpl$specter32859 = (function com$rpl$specter$__GT_t_com$rpl$specter32859(path__$1,late__$1,meta32860){
return (new com.rpl.specter.t_com$rpl$specter32859(path__$1,late__$1,meta32860));
});

}

return (new com.rpl.specter.t_com$rpl$specter32859(path,late,null));
}));
var curr_params__31554__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__31554__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__31553__auto__,curr_params__31554__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__31553__auto__,curr_params__31554__auto__,null);
}
};
var G__32963 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__32964__i = 0, G__32964__a = new Array(arguments.length -  0);
while (G__32964__i < G__32964__a.length) {G__32964__a[G__32964__i] = arguments[G__32964__i + 0]; ++G__32964__i;}
  path = new cljs.core.IndexedSeq(G__32964__a,0,null);
} 
return G__32963__delegate.call(this,path);};
G__32963.cljs$lang$maxFixedArity = 0;
G__32963.cljs$lang$applyTo = (function (arglist__32965){
var path = cljs.core.seq(arglist__32965);
return G__32963__delegate(path);
});
G__32963.cljs$core$IFn$_invoke$arity$variadic = G__32963__delegate;
return G__32963;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Drops all collected values for subsequent navigation.
 */
com.rpl.specter.DISPENSE = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32864 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32864 = (function (meta32865){
this.meta32865 = meta32865;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32864.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32866,meta32865__$1){
var self__ = this;
var _32866__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32864(meta32865__$1));
}));

(com.rpl.specter.t_com$rpl$specter32864.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32866){
var self__ = this;
var _32866__$1 = this;
return self__.meta32865;
}));

(com.rpl.specter.t_com$rpl$specter32864.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32864.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__32867 = cljs.core.PersistentVector.EMPTY;
var G__32868 = structure;
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__32867,G__32868) : next_fn.call(null,G__32867,G__32868));
}));

(com.rpl.specter.t_com$rpl$specter32864.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__32869 = cljs.core.PersistentVector.EMPTY;
var G__32870 = structure;
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__32869,G__32870) : next_fn.call(null,G__32869,G__32870));
}));

(com.rpl.specter.t_com$rpl$specter32864.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta32865","meta32865",721459185,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32864.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32864.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32864");

(com.rpl.specter.t_com$rpl$specter32864.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32864");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32864.
 */
com.rpl.specter.__GT_t_com$rpl$specter32864 = (function com$rpl$specter$__GT_t_com$rpl$specter32864(meta32865){
return (new com.rpl.specter.t_com$rpl$specter32864(meta32865));
});

}

return (new com.rpl.specter.t_com$rpl$specter32864(null));
})()
;
/**
 * Like cond-path, but with if semantics.
 */
com.rpl.specter.if_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() {
var G__32966 = null;
var G__32966__2 = (function (cond_p,then_path){
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3(cond_p,then_path,com.rpl.specter.STOP) : com.rpl.specter.if_path.call(null,cond_p,then_path,com.rpl.specter.STOP));
});
var G__32966__3 = (function (cond_p,then_path,else_path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(cond_p);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
var builder__31553__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late_then,late_else){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32873 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32873 = (function (cond_p,then_path,else_path,temp__5733__auto__,afn,late_then,late_else,meta32874){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__5733__auto__ = temp__5733__auto__;
this.afn = afn;
this.late_then = late_then;
this.late_else = late_else;
this.meta32874 = meta32874;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32873.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32875,meta32874__$1){
var self__ = this;
var _32875__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32873(self__.cond_p,self__.then_path,self__.else_path,self__.temp__5733__auto__,self__.afn,self__.late_then,self__.late_else,meta32874__$1));
}));

(com.rpl.specter.t_com$rpl$specter32873.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32875){
var self__ = this;
var _32875__$1 = this;
return self__.meta32874;
}));

(com.rpl.specter.t_com$rpl$specter32873.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32873.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select(vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter32873.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform(vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter32873.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta32874","meta32874",1473211415,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32873.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32873.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32873");

(com.rpl.specter.t_com$rpl$specter32873.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32873");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32873.
 */
com.rpl.specter.__GT_t_com$rpl$specter32873 = (function com$rpl$specter$__GT_t_com$rpl$specter32873(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,afn__$1,late_then__$1,late_else__$1,meta32874){
return (new com.rpl.specter.t_com$rpl$specter32873(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,afn__$1,late_then__$1,late_else__$1,meta32874));
});

}

return (new com.rpl.specter.t_com$rpl$specter32873(cond_p,then_path,else_path,temp__5733__auto__,afn,late_then,late_else,null));
}));
var curr_params__31554__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(then_path) : com.rpl.specter.late_path.call(null,then_path)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(else_path) : com.rpl.specter.late_path.call(null,else_path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__31554__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__31553__auto__,curr_params__31554__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__31553__auto__,curr_params__31554__auto__,null);
}
} else {
var builder__31553__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late_cond,late_then,late_else){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32876 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32876 = (function (cond_p,then_path,else_path,temp__5733__auto__,late_cond,late_then,late_else,meta32877){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late_cond = late_cond;
this.late_then = late_then;
this.late_else = late_else;
this.meta32877 = meta32877;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32876.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32878,meta32877__$1){
var self__ = this;
var _32878__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32876(self__.cond_p,self__.then_path,self__.else_path,self__.temp__5733__auto__,self__.late_cond,self__.late_then,self__.late_else,meta32877__$1));
}));

(com.rpl.specter.t_com$rpl$specter32876.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32878){
var self__ = this;
var _32878__$1 = this;
return self__.meta32877;
}));

(com.rpl.specter.t_com$rpl$specter32876.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32876.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select(vals,structure,next_fn,(function (p1__32871_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late_cond,vals,p1__32871_SHARP_);
}),self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter32876.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform(vals,structure,next_fn,(function (p1__32872_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late_cond,vals,p1__32872_SHARP_);
}),self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter32876.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late-cond","late-cond",1031862828,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta32877","meta32877",643435503,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32876.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32876.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32876");

(com.rpl.specter.t_com$rpl$specter32876.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32876");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32876.
 */
com.rpl.specter.__GT_t_com$rpl$specter32876 = (function com$rpl$specter$__GT_t_com$rpl$specter32876(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta32877){
return (new com.rpl.specter.t_com$rpl$specter32876(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta32877));
});

}

return (new com.rpl.specter.t_com$rpl$specter32876(cond_p,then_path,else_path,temp__5733__auto__,late_cond,late_then,late_else,null));
}));
var curr_params__31554__auto__ = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(cond_p) : com.rpl.specter.late_path.call(null,cond_p)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(then_path) : com.rpl.specter.late_path.call(null,then_path)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(else_path) : com.rpl.specter.late_path.call(null,else_path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__31554__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__31553__auto__,curr_params__31554__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__31553__auto__,curr_params__31554__auto__,null);
}
}
});
G__32966 = function(cond_p,then_path,else_path){
switch(arguments.length){
case 2:
return G__32966__2.call(this,cond_p,then_path);
case 3:
return G__32966__3.call(this,cond_p,then_path,else_path);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__32966.cljs$core$IFn$_invoke$arity$2 = G__32966__2;
G__32966.cljs$core$IFn$_invoke$arity$3 = G__32966__3;
return G__32966;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Takes in alternating cond-path path cond-path path...
 * Tests the structure if selecting with cond-path returns anything.
 * If so, it uses the following path for this portion of the navigation.
 * Otherwise, it tries the next cond-path. If nothing matches, then the structure
 * is not selected.
 */
com.rpl.specter.cond_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__32969__delegate = function (conds){
var pairs = cljs.core.reverse(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),conds));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p,p__32879){
var vec__32880 = p__32879;
var tester = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32880,(0),null);
var apath = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32880,(1),null);
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3(tester,apath,p) : com.rpl.specter.if_path.call(null,tester,apath,p));
}),com.rpl.specter.STOP,pairs);
};
var G__32969 = function (var_args){
var conds = null;
if (arguments.length > 0) {
var G__32970__i = 0, G__32970__a = new Array(arguments.length -  0);
while (G__32970__i < G__32970__a.length) {G__32970__a[G__32970__i] = arguments[G__32970__i + 0]; ++G__32970__i;}
  conds = new cljs.core.IndexedSeq(G__32970__a,0,null);
} 
return G__32969__delegate.call(this,conds);};
G__32969.cljs$lang$maxFixedArity = 0;
G__32969.cljs$lang$applyTo = (function (arglist__32971){
var conds = cljs.core.seq(arglist__32971);
return G__32969__delegate(conds);
});
G__32969.cljs$core$IFn$_invoke$arity$variadic = G__32969__delegate;
return G__32969;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * A path that branches on multiple paths. For updates,
 * applies updates to the paths in order.
 */
com.rpl.specter.multi_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() {
var G__32973 = null;
var G__32973__0 = (function (){
return com.rpl.specter.STAY;
});
var G__32973__1 = (function (path){
return path;
});
var G__32973__2 = (function (path1,path2){
var builder__31553__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late1,late2){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter32883 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter32883 = (function (path1,path2,late1,late2,meta32884){
this.path1 = path1;
this.path2 = path2;
this.late1 = late1;
this.late2 = late2;
this.meta32884 = meta32884;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter32883.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32885,meta32884__$1){
var self__ = this;
var _32885__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter32883(self__.path1,self__.path2,self__.late1,self__.late2,meta32884__$1));
}));

(com.rpl.specter.t_com$rpl$specter32883.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32885){
var self__ = this;
var _32885__$1 = this;
return self__.meta32884;
}));

(com.rpl.specter.t_com$rpl$specter32883.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter32883.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var res1 = com.rpl.specter.protocols.select_STAR_(self__.late1,vals,structure,next_fn);
if(cljs.core.reduced_QMARK_(res1)){
return res1;
} else {
var res2 = com.rpl.specter.protocols.select_STAR_(self__.late2,vals,structure,next_fn);
if((com.rpl.specter.NONE === res1)){
return res2;
} else {
return res1;
}
}
}));

(com.rpl.specter.t_com$rpl$specter32883.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var s1 = com.rpl.specter.protocols.transform_STAR_(self__.late1,vals,structure,next_fn);
return com.rpl.specter.protocols.transform_STAR_(self__.late2,vals,s1,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter32883.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path1","path1",-2002517142,null),new cljs.core.Symbol(null,"path2","path2",-1937913521,null),new cljs.core.Symbol(null,"late1","late1",-1413016621,null),new cljs.core.Symbol(null,"late2","late2",-681717994,null),new cljs.core.Symbol(null,"meta32884","meta32884",-1275401594,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter32883.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter32883.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter32883");

(com.rpl.specter.t_com$rpl$specter32883.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter32883");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter32883.
 */
com.rpl.specter.__GT_t_com$rpl$specter32883 = (function com$rpl$specter$__GT_t_com$rpl$specter32883(path1__$1,path2__$1,late1__$1,late2__$1,meta32884){
return (new com.rpl.specter.t_com$rpl$specter32883(path1__$1,path2__$1,late1__$1,late2__$1,meta32884));
});

}

return (new com.rpl.specter.t_com$rpl$specter32883(path1,path2,late1,late2,null));
}));
var curr_params__31554__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path1) : com.rpl.specter.late_path.call(null,path1)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path2) : com.rpl.specter.late_path.call(null,path2))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__31554__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__31553__auto__,curr_params__31554__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__31553__auto__,curr_params__31554__auto__,null);
}
});
var G__32973__3 = (function() { 
var G__32976__delegate = function (path1,path2,paths){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(com.rpl.specter.multi_path,(com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(path1,path2) : com.rpl.specter.multi_path.call(null,path1,path2)),paths);
};
var G__32976 = function (path1,path2,var_args){
var paths = null;
if (arguments.length > 2) {
var G__32977__i = 0, G__32977__a = new Array(arguments.length -  2);
while (G__32977__i < G__32977__a.length) {G__32977__a[G__32977__i] = arguments[G__32977__i + 2]; ++G__32977__i;}
  paths = new cljs.core.IndexedSeq(G__32977__a,0,null);
} 
return G__32976__delegate.call(this,path1,path2,paths);};
G__32976.cljs$lang$maxFixedArity = 2;
G__32976.cljs$lang$applyTo = (function (arglist__32978){
var path1 = cljs.core.first(arglist__32978);
arglist__32978 = cljs.core.next(arglist__32978);
var path2 = cljs.core.first(arglist__32978);
var paths = cljs.core.rest(arglist__32978);
return G__32976__delegate(path1,path2,paths);
});
G__32976.cljs$core$IFn$_invoke$arity$variadic = G__32976__delegate;
return G__32976;
})()
;
G__32973 = function(path1,path2,var_args){
var paths = var_args;
switch(arguments.length){
case 0:
return G__32973__0.call(this);
case 1:
return G__32973__1.call(this,path1);
case 2:
return G__32973__2.call(this,path1,path2);
default:
var G__32979 = null;
if (arguments.length > 2) {
var G__32980__i = 0, G__32980__a = new Array(arguments.length -  2);
while (G__32980__i < G__32980__a.length) {G__32980__a[G__32980__i] = arguments[G__32980__i + 2]; ++G__32980__i;}
G__32979 = new cljs.core.IndexedSeq(G__32980__a,0,null);
}
return G__32973__3.cljs$core$IFn$_invoke$arity$variadic(path1,path2, G__32979);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__32973.cljs$lang$maxFixedArity = 2;
G__32973.cljs$lang$applyTo = G__32973__3.cljs$lang$applyTo;
G__32973.cljs$core$IFn$_invoke$arity$0 = G__32973__0;
G__32973.cljs$core$IFn$_invoke$arity$1 = G__32973__1;
G__32973.cljs$core$IFn$_invoke$arity$2 = G__32973__2;
G__32973.cljs$core$IFn$_invoke$arity$variadic = G__32973__3.cljs$core$IFn$_invoke$arity$variadic;
return G__32973;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the current element and then navigates via the provided path.
 * This can be used to implement pre-order traversal.
 */
com.rpl.specter.stay_then_continue = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__32981__delegate = function (path){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.STAY,path) : com.rpl.specter.multi_path.call(null,com.rpl.specter.STAY,path));
};
var G__32981 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__32982__i = 0, G__32982__a = new Array(arguments.length -  0);
while (G__32982__i < G__32982__a.length) {G__32982__a[G__32982__i] = arguments[G__32982__i + 0]; ++G__32982__i;}
  path = new cljs.core.IndexedSeq(G__32982__a,0,null);
} 
return G__32981__delegate.call(this,path);};
G__32981.cljs$lang$maxFixedArity = 0;
G__32981.cljs$lang$applyTo = (function (arglist__32983){
var path = cljs.core.seq(arglist__32983);
return G__32981__delegate(path);
});
G__32981.cljs$core$IFn$_invoke$arity$variadic = G__32981__delegate;
return G__32981;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the provided path and then to the current element. This can be used
 * to implement post-order traversal.
 */
com.rpl.specter.continue_then_stay = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__32985__delegate = function (path){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(path,com.rpl.specter.STAY) : com.rpl.specter.multi_path.call(null,path,com.rpl.specter.STAY));
};
var G__32985 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__32987__i = 0, G__32987__a = new Array(arguments.length -  0);
while (G__32987__i < G__32987__a.length) {G__32987__a[G__32987__i] = arguments[G__32987__i + 0]; ++G__32987__i;}
  path = new cljs.core.IndexedSeq(G__32987__a,0,null);
} 
return G__32985__delegate.call(this,path);};
G__32985.cljs$lang$maxFixedArity = 0;
G__32985.cljs$lang$applyTo = (function (arglist__32988){
var path = cljs.core.seq(arglist__32988);
return G__32985__delegate(path);
});
G__32985.cljs$core$IFn$_invoke$arity$variadic = G__32985__delegate;
return G__32985;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigate the data structure until reaching
 *        a value for which `afn` returns truthy. Has
 *        same semantics as clojure.walk.
 */
com.rpl.specter.walker = com.rpl.specter.impl.direct_nav_obj((function (afn){
var p = com.rpl.specter.impl.local_declarepath();
com.rpl.specter.impl.providepath_STAR_(p,(function (){var info__31560__auto__ = com.rpl.specter.pathcache32890;
var info__31560__auto____$1 = (((info__31560__auto__ == null))?(function (){var info32891 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"com/rpl/specter.cljc",25,1,1394,1394,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"com/rpl/specter.cljc",7,1,true,1175,1179,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. Functions in paths\n          implicitly convert to this navigator.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"com/rpl/specter.cljc",7,1,644,646,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse(cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",12,1,2133,2133,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",(cljs.core.truth_(cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_LocalSym(p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache32890 = info32891;

return info32891;
})():info__31560__auto__);
var precompiled32892 = com.rpl.specter.impl.cached_path_info_precompiled(info__31560__auto____$1);
var dynamic_QMARK___31561__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__31560__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___31561__auto__)){
var G__32893 = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,p], null),com.rpl.specter.ALL,p], null);
return (precompiled32892.cljs$core$IFn$_invoke$arity$1 ? precompiled32892.cljs$core$IFn$_invoke$arity$1(G__32893) : precompiled32892.call(null,G__32893));
} else {
return precompiled32892;
}
})());

return p;
}));
/**
 * Like `walker` but maintains metadata of any forms traversed.
 */
com.rpl.specter.codewalker = com.rpl.specter.impl.direct_nav_obj((function (afn){
var p = com.rpl.specter.impl.local_declarepath();
com.rpl.specter.impl.providepath_STAR_(p,(function (){var info__31560__auto__ = com.rpl.specter.pathcache32894;
var info__31560__auto____$1 = (((info__31560__auto__ == null))?(function (){var info32895 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"com/rpl/specter.cljc",25,1,1394,1394,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"com/rpl/specter.cljc",7,1,true,1175,1179,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. Functions in paths\n          implicitly convert to this navigator.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"com/rpl/specter.cljc",7,1,644,646,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse(cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",12,1,2133,2133,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",(cljs.core.truth_(cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL_WITH_META,new cljs.core.Var(function(){return com.rpl.specter.ALL_WITH_META;},new cljs.core.Symbol("com.rpl.specter","ALL-WITH-META","com.rpl.specter/ALL-WITH-META",-1161868995,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),"com/rpl/specter.cljc",16,1,689,691,cljs.core.List.EMPTY,"Same as ALL, except maintains metadata on the structure.",(cljs.core.truth_(com.rpl.specter.ALL_WITH_META)?com.rpl.specter.ALL_WITH_META.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null)),com.rpl.specter.impl.__GT_LocalSym(p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache32894 = info32895;

return info32895;
})():info__31560__auto__);
var precompiled32896 = com.rpl.specter.impl.cached_path_info_precompiled(info__31560__auto____$1);
var dynamic_QMARK___31561__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__31560__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___31561__auto__)){
var G__32897 = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL_WITH_META,p], null),com.rpl.specter.ALL_WITH_META,p], null);
return (precompiled32896.cljs$core$IFn$_invoke$arity$1 ? precompiled32896.cljs$core$IFn$_invoke$arity$1(G__32897) : precompiled32896.call(null,G__32897));
} else {
return precompiled32896;
}
})());

return p;
}));
var empty__GT_NONE_32995 = (function (){var G__32898 = cljs.core.empty_QMARK_;
var G__32899 = com.rpl.specter.terminal_val(com.rpl.specter.NONE);
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$2(G__32898,G__32899) : com.rpl.specter.if_path.call(null,G__32898,G__32899));
})();
var compact_STAR__32996 = (function (nav){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(nav,empty__GT_NONE_32995) : com.rpl.specter.multi_path.call(null,nav,empty__GT_NONE_32995));
});
/**
 * During transforms, after each step of navigation in subpath check if the
 *  value is empty. If so, remove that value by setting it to NONE.
 */
com.rpl.specter.compact = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__32997__delegate = function (path){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(compact_STAR__32996,path);
};
var G__32997 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__32998__i = 0, G__32998__a = new Array(arguments.length -  0);
while (G__32998__i < G__32998__a.length) {G__32998__a[G__32998__i] = arguments[G__32998__i + 0]; ++G__32998__i;}
  path = new cljs.core.IndexedSeq(G__32998__a,0,null);
} 
return G__32997__delegate.call(this,path);};
G__32997.cljs$lang$maxFixedArity = 0;
G__32997.cljs$lang$applyTo = (function (arglist__32999){
var path = cljs.core.seq(arglist__32999);
return G__32997__delegate(path);
});
G__32997.cljs$core$IFn$_invoke$arity$variadic = G__32997__delegate;
return G__32997;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);

//# sourceMappingURL=com.rpl.specter.js.map
