goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__34794 = arguments.length;
switch (G__34794) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async34795 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34795 = (function (f,blockable,meta34796){
this.f = f;
this.blockable = blockable;
this.meta34796 = meta34796;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async34795.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34797,meta34796__$1){
var self__ = this;
var _34797__$1 = this;
return (new cljs.core.async.t_cljs$core$async34795(self__.f,self__.blockable,meta34796__$1));
}));

(cljs.core.async.t_cljs$core$async34795.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34797){
var self__ = this;
var _34797__$1 = this;
return self__.meta34796;
}));

(cljs.core.async.t_cljs$core$async34795.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async34795.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async34795.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async34795.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async34795.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta34796","meta34796",-1726344712,null)], null);
}));

(cljs.core.async.t_cljs$core$async34795.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async34795.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34795");

(cljs.core.async.t_cljs$core$async34795.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async34795");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async34795.
 */
cljs.core.async.__GT_t_cljs$core$async34795 = (function cljs$core$async$__GT_t_cljs$core$async34795(f__$1,blockable__$1,meta34796){
return (new cljs.core.async.t_cljs$core$async34795(f__$1,blockable__$1,meta34796));
});

}

return (new cljs.core.async.t_cljs$core$async34795(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__34800 = arguments.length;
switch (G__34800) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__34803 = arguments.length;
switch (G__34803) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__34808 = arguments.length;
switch (G__34808) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_36293 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_36293) : fn1.call(null,val_36293));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_36293) : fn1.call(null,val_36293));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__34812 = arguments.length;
switch (G__34812) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___36299 = n;
var x_36300 = (0);
while(true){
if((x_36300 < n__4613__auto___36299)){
(a[x_36300] = x_36300);

var G__36301 = (x_36300 + (1));
x_36300 = G__36301;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async34813 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34813 = (function (flag,meta34814){
this.flag = flag;
this.meta34814 = meta34814;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async34813.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34815,meta34814__$1){
var self__ = this;
var _34815__$1 = this;
return (new cljs.core.async.t_cljs$core$async34813(self__.flag,meta34814__$1));
}));

(cljs.core.async.t_cljs$core$async34813.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34815){
var self__ = this;
var _34815__$1 = this;
return self__.meta34814;
}));

(cljs.core.async.t_cljs$core$async34813.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async34813.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async34813.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async34813.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async34813.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta34814","meta34814",-2131964750,null)], null);
}));

(cljs.core.async.t_cljs$core$async34813.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async34813.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34813");

(cljs.core.async.t_cljs$core$async34813.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async34813");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async34813.
 */
cljs.core.async.__GT_t_cljs$core$async34813 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async34813(flag__$1,meta34814){
return (new cljs.core.async.t_cljs$core$async34813(flag__$1,meta34814));
});

}

return (new cljs.core.async.t_cljs$core$async34813(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async34816 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34816 = (function (flag,cb,meta34817){
this.flag = flag;
this.cb = cb;
this.meta34817 = meta34817;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async34816.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34818,meta34817__$1){
var self__ = this;
var _34818__$1 = this;
return (new cljs.core.async.t_cljs$core$async34816(self__.flag,self__.cb,meta34817__$1));
}));

(cljs.core.async.t_cljs$core$async34816.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34818){
var self__ = this;
var _34818__$1 = this;
return self__.meta34817;
}));

(cljs.core.async.t_cljs$core$async34816.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async34816.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async34816.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async34816.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async34816.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta34817","meta34817",-705483839,null)], null);
}));

(cljs.core.async.t_cljs$core$async34816.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async34816.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34816");

(cljs.core.async.t_cljs$core$async34816.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async34816");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async34816.
 */
cljs.core.async.__GT_t_cljs$core$async34816 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async34816(flag__$1,cb__$1,meta34817){
return (new cljs.core.async.t_cljs$core$async34816(flag__$1,cb__$1,meta34817));
});

}

return (new cljs.core.async.t_cljs$core$async34816(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__34819_SHARP_){
var G__34821 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__34819_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__34821) : fret.call(null,G__34821));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__34820_SHARP_){
var G__34822 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__34820_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__34822) : fret.call(null,G__34822));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__36327 = (i + (1));
i = G__36327;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___36335 = arguments.length;
var i__4737__auto___36336 = (0);
while(true){
if((i__4737__auto___36336 < len__4736__auto___36335)){
args__4742__auto__.push((arguments[i__4737__auto___36336]));

var G__36340 = (i__4737__auto___36336 + (1));
i__4737__auto___36336 = G__36340;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__34825){
var map__34826 = p__34825;
var map__34826__$1 = (((((!((map__34826 == null))))?(((((map__34826.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34826.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34826):map__34826);
var opts = map__34826__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq34823){
var G__34824 = cljs.core.first(seq34823);
var seq34823__$1 = cljs.core.next(seq34823);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34824,seq34823__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__34829 = arguments.length;
switch (G__34829) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__34736__auto___36371 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34737__auto__ = (function (){var switch__34700__auto__ = (function (state_34853){
var state_val_34854 = (state_34853[(1)]);
if((state_val_34854 === (7))){
var inst_34849 = (state_34853[(2)]);
var state_34853__$1 = state_34853;
var statearr_34855_36372 = state_34853__$1;
(statearr_34855_36372[(2)] = inst_34849);

(statearr_34855_36372[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34854 === (1))){
var state_34853__$1 = state_34853;
var statearr_34856_36373 = state_34853__$1;
(statearr_34856_36373[(2)] = null);

(statearr_34856_36373[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34854 === (4))){
var inst_34832 = (state_34853[(7)]);
var inst_34832__$1 = (state_34853[(2)]);
var inst_34833 = (inst_34832__$1 == null);
var state_34853__$1 = (function (){var statearr_34857 = state_34853;
(statearr_34857[(7)] = inst_34832__$1);

return statearr_34857;
})();
if(cljs.core.truth_(inst_34833)){
var statearr_34858_36376 = state_34853__$1;
(statearr_34858_36376[(1)] = (5));

} else {
var statearr_34859_36377 = state_34853__$1;
(statearr_34859_36377[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34854 === (13))){
var state_34853__$1 = state_34853;
var statearr_34860_36380 = state_34853__$1;
(statearr_34860_36380[(2)] = null);

(statearr_34860_36380[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34854 === (6))){
var inst_34832 = (state_34853[(7)]);
var state_34853__$1 = state_34853;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34853__$1,(11),to,inst_34832);
} else {
if((state_val_34854 === (3))){
var inst_34851 = (state_34853[(2)]);
var state_34853__$1 = state_34853;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34853__$1,inst_34851);
} else {
if((state_val_34854 === (12))){
var state_34853__$1 = state_34853;
var statearr_34861_36386 = state_34853__$1;
(statearr_34861_36386[(2)] = null);

(statearr_34861_36386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34854 === (2))){
var state_34853__$1 = state_34853;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34853__$1,(4),from);
} else {
if((state_val_34854 === (11))){
var inst_34842 = (state_34853[(2)]);
var state_34853__$1 = state_34853;
if(cljs.core.truth_(inst_34842)){
var statearr_34862_36390 = state_34853__$1;
(statearr_34862_36390[(1)] = (12));

} else {
var statearr_34863_36392 = state_34853__$1;
(statearr_34863_36392[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34854 === (9))){
var state_34853__$1 = state_34853;
var statearr_34864_36393 = state_34853__$1;
(statearr_34864_36393[(2)] = null);

(statearr_34864_36393[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34854 === (5))){
var state_34853__$1 = state_34853;
if(cljs.core.truth_(close_QMARK_)){
var statearr_34865_36395 = state_34853__$1;
(statearr_34865_36395[(1)] = (8));

} else {
var statearr_34866_36396 = state_34853__$1;
(statearr_34866_36396[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34854 === (14))){
var inst_34847 = (state_34853[(2)]);
var state_34853__$1 = state_34853;
var statearr_34867_36402 = state_34853__$1;
(statearr_34867_36402[(2)] = inst_34847);

(statearr_34867_36402[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34854 === (10))){
var inst_34839 = (state_34853[(2)]);
var state_34853__$1 = state_34853;
var statearr_34868_36408 = state_34853__$1;
(statearr_34868_36408[(2)] = inst_34839);

(statearr_34868_36408[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34854 === (8))){
var inst_34836 = cljs.core.async.close_BANG_(to);
var state_34853__$1 = state_34853;
var statearr_34869_36412 = state_34853__$1;
(statearr_34869_36412[(2)] = inst_34836);

(statearr_34869_36412[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__34701__auto__ = null;
var cljs$core$async$state_machine__34701__auto____0 = (function (){
var statearr_34870 = [null,null,null,null,null,null,null,null];
(statearr_34870[(0)] = cljs$core$async$state_machine__34701__auto__);

(statearr_34870[(1)] = (1));

return statearr_34870;
});
var cljs$core$async$state_machine__34701__auto____1 = (function (state_34853){
while(true){
var ret_value__34702__auto__ = (function (){try{while(true){
var result__34703__auto__ = switch__34700__auto__(state_34853);
if(cljs.core.keyword_identical_QMARK_(result__34703__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34703__auto__;
}
break;
}
}catch (e34871){var ex__34704__auto__ = e34871;
var statearr_34872_36416 = state_34853;
(statearr_34872_36416[(2)] = ex__34704__auto__);


if(cljs.core.seq((state_34853[(4)]))){
var statearr_34873_36419 = state_34853;
(statearr_34873_36419[(1)] = cljs.core.first((state_34853[(4)])));

} else {
throw ex__34704__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34702__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36420 = state_34853;
state_34853 = G__36420;
continue;
} else {
return ret_value__34702__auto__;
}
break;
}
});
cljs$core$async$state_machine__34701__auto__ = function(state_34853){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__34701__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__34701__auto____1.call(this,state_34853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__34701__auto____0;
cljs$core$async$state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__34701__auto____1;
return cljs$core$async$state_machine__34701__auto__;
})()
})();
var state__34738__auto__ = (function (){var statearr_34874 = f__34737__auto__();
(statearr_34874[(6)] = c__34736__auto___36371);

return statearr_34874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34738__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__34875){
var vec__34876 = p__34875;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34876,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34876,(1),null);
var job = vec__34876;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__34736__auto___36432 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34737__auto__ = (function (){var switch__34700__auto__ = (function (state_34883){
var state_val_34884 = (state_34883[(1)]);
if((state_val_34884 === (1))){
var state_34883__$1 = state_34883;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34883__$1,(2),res,v);
} else {
if((state_val_34884 === (2))){
var inst_34880 = (state_34883[(2)]);
var inst_34881 = cljs.core.async.close_BANG_(res);
var state_34883__$1 = (function (){var statearr_34885 = state_34883;
(statearr_34885[(7)] = inst_34880);

return statearr_34885;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_34883__$1,inst_34881);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____0 = (function (){
var statearr_34886 = [null,null,null,null,null,null,null,null];
(statearr_34886[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__);

(statearr_34886[(1)] = (1));

return statearr_34886;
});
var cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____1 = (function (state_34883){
while(true){
var ret_value__34702__auto__ = (function (){try{while(true){
var result__34703__auto__ = switch__34700__auto__(state_34883);
if(cljs.core.keyword_identical_QMARK_(result__34703__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34703__auto__;
}
break;
}
}catch (e34887){var ex__34704__auto__ = e34887;
var statearr_34888_36443 = state_34883;
(statearr_34888_36443[(2)] = ex__34704__auto__);


if(cljs.core.seq((state_34883[(4)]))){
var statearr_34889_36445 = state_34883;
(statearr_34889_36445[(1)] = cljs.core.first((state_34883[(4)])));

} else {
throw ex__34704__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34702__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36450 = state_34883;
state_34883 = G__36450;
continue;
} else {
return ret_value__34702__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__ = function(state_34883){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____1.call(this,state_34883);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__;
})()
})();
var state__34738__auto__ = (function (){var statearr_34890 = f__34737__auto__();
(statearr_34890[(6)] = c__34736__auto___36432);

return statearr_34890;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34738__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__34891){
var vec__34892 = p__34891;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34892,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34892,(1),null);
var job = vec__34892;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___36465 = n;
var __36467 = (0);
while(true){
if((__36467 < n__4613__auto___36465)){
var G__34895_36468 = type;
var G__34895_36469__$1 = (((G__34895_36468 instanceof cljs.core.Keyword))?G__34895_36468.fqn:null);
switch (G__34895_36469__$1) {
case "compute":
var c__34736__auto___36471 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__36467,c__34736__auto___36471,G__34895_36468,G__34895_36469__$1,n__4613__auto___36465,jobs,results,process,async){
return (function (){
var f__34737__auto__ = (function (){var switch__34700__auto__ = ((function (__36467,c__34736__auto___36471,G__34895_36468,G__34895_36469__$1,n__4613__auto___36465,jobs,results,process,async){
return (function (state_34908){
var state_val_34909 = (state_34908[(1)]);
if((state_val_34909 === (1))){
var state_34908__$1 = state_34908;
var statearr_34910_36472 = state_34908__$1;
(statearr_34910_36472[(2)] = null);

(statearr_34910_36472[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34909 === (2))){
var state_34908__$1 = state_34908;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34908__$1,(4),jobs);
} else {
if((state_val_34909 === (3))){
var inst_34906 = (state_34908[(2)]);
var state_34908__$1 = state_34908;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34908__$1,inst_34906);
} else {
if((state_val_34909 === (4))){
var inst_34898 = (state_34908[(2)]);
var inst_34899 = process(inst_34898);
var state_34908__$1 = state_34908;
if(cljs.core.truth_(inst_34899)){
var statearr_34911_36475 = state_34908__$1;
(statearr_34911_36475[(1)] = (5));

} else {
var statearr_34912_36476 = state_34908__$1;
(statearr_34912_36476[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34909 === (5))){
var state_34908__$1 = state_34908;
var statearr_34913_36479 = state_34908__$1;
(statearr_34913_36479[(2)] = null);

(statearr_34913_36479[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34909 === (6))){
var state_34908__$1 = state_34908;
var statearr_34914_36481 = state_34908__$1;
(statearr_34914_36481[(2)] = null);

(statearr_34914_36481[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34909 === (7))){
var inst_34904 = (state_34908[(2)]);
var state_34908__$1 = state_34908;
var statearr_34915_36484 = state_34908__$1;
(statearr_34915_36484[(2)] = inst_34904);

(statearr_34915_36484[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__36467,c__34736__auto___36471,G__34895_36468,G__34895_36469__$1,n__4613__auto___36465,jobs,results,process,async))
;
return ((function (__36467,switch__34700__auto__,c__34736__auto___36471,G__34895_36468,G__34895_36469__$1,n__4613__auto___36465,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____0 = (function (){
var statearr_34916 = [null,null,null,null,null,null,null];
(statearr_34916[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__);

(statearr_34916[(1)] = (1));

return statearr_34916;
});
var cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____1 = (function (state_34908){
while(true){
var ret_value__34702__auto__ = (function (){try{while(true){
var result__34703__auto__ = switch__34700__auto__(state_34908);
if(cljs.core.keyword_identical_QMARK_(result__34703__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34703__auto__;
}
break;
}
}catch (e34917){var ex__34704__auto__ = e34917;
var statearr_34918_36488 = state_34908;
(statearr_34918_36488[(2)] = ex__34704__auto__);


if(cljs.core.seq((state_34908[(4)]))){
var statearr_34919_36489 = state_34908;
(statearr_34919_36489[(1)] = cljs.core.first((state_34908[(4)])));

} else {
throw ex__34704__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34702__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36493 = state_34908;
state_34908 = G__36493;
continue;
} else {
return ret_value__34702__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__ = function(state_34908){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____1.call(this,state_34908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__;
})()
;})(__36467,switch__34700__auto__,c__34736__auto___36471,G__34895_36468,G__34895_36469__$1,n__4613__auto___36465,jobs,results,process,async))
})();
var state__34738__auto__ = (function (){var statearr_34920 = f__34737__auto__();
(statearr_34920[(6)] = c__34736__auto___36471);

return statearr_34920;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34738__auto__);
});})(__36467,c__34736__auto___36471,G__34895_36468,G__34895_36469__$1,n__4613__auto___36465,jobs,results,process,async))
);


break;
case "async":
var c__34736__auto___36494 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__36467,c__34736__auto___36494,G__34895_36468,G__34895_36469__$1,n__4613__auto___36465,jobs,results,process,async){
return (function (){
var f__34737__auto__ = (function (){var switch__34700__auto__ = ((function (__36467,c__34736__auto___36494,G__34895_36468,G__34895_36469__$1,n__4613__auto___36465,jobs,results,process,async){
return (function (state_34933){
var state_val_34934 = (state_34933[(1)]);
if((state_val_34934 === (1))){
var state_34933__$1 = state_34933;
var statearr_34935_36496 = state_34933__$1;
(statearr_34935_36496[(2)] = null);

(statearr_34935_36496[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34934 === (2))){
var state_34933__$1 = state_34933;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34933__$1,(4),jobs);
} else {
if((state_val_34934 === (3))){
var inst_34931 = (state_34933[(2)]);
var state_34933__$1 = state_34933;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34933__$1,inst_34931);
} else {
if((state_val_34934 === (4))){
var inst_34923 = (state_34933[(2)]);
var inst_34924 = async(inst_34923);
var state_34933__$1 = state_34933;
if(cljs.core.truth_(inst_34924)){
var statearr_34936_36501 = state_34933__$1;
(statearr_34936_36501[(1)] = (5));

} else {
var statearr_34937_36502 = state_34933__$1;
(statearr_34937_36502[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34934 === (5))){
var state_34933__$1 = state_34933;
var statearr_34938_36503 = state_34933__$1;
(statearr_34938_36503[(2)] = null);

(statearr_34938_36503[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34934 === (6))){
var state_34933__$1 = state_34933;
var statearr_34939_36504 = state_34933__$1;
(statearr_34939_36504[(2)] = null);

(statearr_34939_36504[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34934 === (7))){
var inst_34929 = (state_34933[(2)]);
var state_34933__$1 = state_34933;
var statearr_34940_36505 = state_34933__$1;
(statearr_34940_36505[(2)] = inst_34929);

(statearr_34940_36505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__36467,c__34736__auto___36494,G__34895_36468,G__34895_36469__$1,n__4613__auto___36465,jobs,results,process,async))
;
return ((function (__36467,switch__34700__auto__,c__34736__auto___36494,G__34895_36468,G__34895_36469__$1,n__4613__auto___36465,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____0 = (function (){
var statearr_34941 = [null,null,null,null,null,null,null];
(statearr_34941[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__);

(statearr_34941[(1)] = (1));

return statearr_34941;
});
var cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____1 = (function (state_34933){
while(true){
var ret_value__34702__auto__ = (function (){try{while(true){
var result__34703__auto__ = switch__34700__auto__(state_34933);
if(cljs.core.keyword_identical_QMARK_(result__34703__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34703__auto__;
}
break;
}
}catch (e34942){var ex__34704__auto__ = e34942;
var statearr_34943_36508 = state_34933;
(statearr_34943_36508[(2)] = ex__34704__auto__);


if(cljs.core.seq((state_34933[(4)]))){
var statearr_34944_36510 = state_34933;
(statearr_34944_36510[(1)] = cljs.core.first((state_34933[(4)])));

} else {
throw ex__34704__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34702__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36511 = state_34933;
state_34933 = G__36511;
continue;
} else {
return ret_value__34702__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__ = function(state_34933){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____1.call(this,state_34933);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__;
})()
;})(__36467,switch__34700__auto__,c__34736__auto___36494,G__34895_36468,G__34895_36469__$1,n__4613__auto___36465,jobs,results,process,async))
})();
var state__34738__auto__ = (function (){var statearr_34945 = f__34737__auto__();
(statearr_34945[(6)] = c__34736__auto___36494);

return statearr_34945;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34738__auto__);
});})(__36467,c__34736__auto___36494,G__34895_36468,G__34895_36469__$1,n__4613__auto___36465,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__34895_36469__$1)].join('')));

}

var G__36514 = (__36467 + (1));
__36467 = G__36514;
continue;
} else {
}
break;
}

var c__34736__auto___36515 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34737__auto__ = (function (){var switch__34700__auto__ = (function (state_34967){
var state_val_34968 = (state_34967[(1)]);
if((state_val_34968 === (7))){
var inst_34963 = (state_34967[(2)]);
var state_34967__$1 = state_34967;
var statearr_34969_36517 = state_34967__$1;
(statearr_34969_36517[(2)] = inst_34963);

(statearr_34969_36517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34968 === (1))){
var state_34967__$1 = state_34967;
var statearr_34970_36518 = state_34967__$1;
(statearr_34970_36518[(2)] = null);

(statearr_34970_36518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34968 === (4))){
var inst_34948 = (state_34967[(7)]);
var inst_34948__$1 = (state_34967[(2)]);
var inst_34949 = (inst_34948__$1 == null);
var state_34967__$1 = (function (){var statearr_34971 = state_34967;
(statearr_34971[(7)] = inst_34948__$1);

return statearr_34971;
})();
if(cljs.core.truth_(inst_34949)){
var statearr_34972_36525 = state_34967__$1;
(statearr_34972_36525[(1)] = (5));

} else {
var statearr_34973_36526 = state_34967__$1;
(statearr_34973_36526[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34968 === (6))){
var inst_34953 = (state_34967[(8)]);
var inst_34948 = (state_34967[(7)]);
var inst_34953__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_34954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34955 = [inst_34948,inst_34953__$1];
var inst_34956 = (new cljs.core.PersistentVector(null,2,(5),inst_34954,inst_34955,null));
var state_34967__$1 = (function (){var statearr_34974 = state_34967;
(statearr_34974[(8)] = inst_34953__$1);

return statearr_34974;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34967__$1,(8),jobs,inst_34956);
} else {
if((state_val_34968 === (3))){
var inst_34965 = (state_34967[(2)]);
var state_34967__$1 = state_34967;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34967__$1,inst_34965);
} else {
if((state_val_34968 === (2))){
var state_34967__$1 = state_34967;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34967__$1,(4),from);
} else {
if((state_val_34968 === (9))){
var inst_34960 = (state_34967[(2)]);
var state_34967__$1 = (function (){var statearr_34975 = state_34967;
(statearr_34975[(9)] = inst_34960);

return statearr_34975;
})();
var statearr_34976_36528 = state_34967__$1;
(statearr_34976_36528[(2)] = null);

(statearr_34976_36528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34968 === (5))){
var inst_34951 = cljs.core.async.close_BANG_(jobs);
var state_34967__$1 = state_34967;
var statearr_34977_36539 = state_34967__$1;
(statearr_34977_36539[(2)] = inst_34951);

(statearr_34977_36539[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34968 === (8))){
var inst_34953 = (state_34967[(8)]);
var inst_34958 = (state_34967[(2)]);
var state_34967__$1 = (function (){var statearr_34978 = state_34967;
(statearr_34978[(10)] = inst_34958);

return statearr_34978;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34967__$1,(9),results,inst_34953);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____0 = (function (){
var statearr_34979 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34979[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__);

(statearr_34979[(1)] = (1));

return statearr_34979;
});
var cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____1 = (function (state_34967){
while(true){
var ret_value__34702__auto__ = (function (){try{while(true){
var result__34703__auto__ = switch__34700__auto__(state_34967);
if(cljs.core.keyword_identical_QMARK_(result__34703__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34703__auto__;
}
break;
}
}catch (e34980){var ex__34704__auto__ = e34980;
var statearr_34981_36542 = state_34967;
(statearr_34981_36542[(2)] = ex__34704__auto__);


if(cljs.core.seq((state_34967[(4)]))){
var statearr_34982_36546 = state_34967;
(statearr_34982_36546[(1)] = cljs.core.first((state_34967[(4)])));

} else {
throw ex__34704__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34702__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36547 = state_34967;
state_34967 = G__36547;
continue;
} else {
return ret_value__34702__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__ = function(state_34967){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____1.call(this,state_34967);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__;
})()
})();
var state__34738__auto__ = (function (){var statearr_34983 = f__34737__auto__();
(statearr_34983[(6)] = c__34736__auto___36515);

return statearr_34983;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34738__auto__);
}));


var c__34736__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34737__auto__ = (function (){var switch__34700__auto__ = (function (state_35021){
var state_val_35022 = (state_35021[(1)]);
if((state_val_35022 === (7))){
var inst_35017 = (state_35021[(2)]);
var state_35021__$1 = state_35021;
var statearr_35023_36551 = state_35021__$1;
(statearr_35023_36551[(2)] = inst_35017);

(statearr_35023_36551[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35022 === (20))){
var state_35021__$1 = state_35021;
var statearr_35024_36552 = state_35021__$1;
(statearr_35024_36552[(2)] = null);

(statearr_35024_36552[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35022 === (1))){
var state_35021__$1 = state_35021;
var statearr_35025_36553 = state_35021__$1;
(statearr_35025_36553[(2)] = null);

(statearr_35025_36553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35022 === (4))){
var inst_34986 = (state_35021[(7)]);
var inst_34986__$1 = (state_35021[(2)]);
var inst_34987 = (inst_34986__$1 == null);
var state_35021__$1 = (function (){var statearr_35026 = state_35021;
(statearr_35026[(7)] = inst_34986__$1);

return statearr_35026;
})();
if(cljs.core.truth_(inst_34987)){
var statearr_35027_36558 = state_35021__$1;
(statearr_35027_36558[(1)] = (5));

} else {
var statearr_35028_36561 = state_35021__$1;
(statearr_35028_36561[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35022 === (15))){
var inst_34999 = (state_35021[(8)]);
var state_35021__$1 = state_35021;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35021__$1,(18),to,inst_34999);
} else {
if((state_val_35022 === (21))){
var inst_35012 = (state_35021[(2)]);
var state_35021__$1 = state_35021;
var statearr_35029_36563 = state_35021__$1;
(statearr_35029_36563[(2)] = inst_35012);

(statearr_35029_36563[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35022 === (13))){
var inst_35014 = (state_35021[(2)]);
var state_35021__$1 = (function (){var statearr_35030 = state_35021;
(statearr_35030[(9)] = inst_35014);

return statearr_35030;
})();
var statearr_35031_36567 = state_35021__$1;
(statearr_35031_36567[(2)] = null);

(statearr_35031_36567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35022 === (6))){
var inst_34986 = (state_35021[(7)]);
var state_35021__$1 = state_35021;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35021__$1,(11),inst_34986);
} else {
if((state_val_35022 === (17))){
var inst_35007 = (state_35021[(2)]);
var state_35021__$1 = state_35021;
if(cljs.core.truth_(inst_35007)){
var statearr_35032_36568 = state_35021__$1;
(statearr_35032_36568[(1)] = (19));

} else {
var statearr_35033_36569 = state_35021__$1;
(statearr_35033_36569[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35022 === (3))){
var inst_35019 = (state_35021[(2)]);
var state_35021__$1 = state_35021;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35021__$1,inst_35019);
} else {
if((state_val_35022 === (12))){
var inst_34996 = (state_35021[(10)]);
var state_35021__$1 = state_35021;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35021__$1,(14),inst_34996);
} else {
if((state_val_35022 === (2))){
var state_35021__$1 = state_35021;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35021__$1,(4),results);
} else {
if((state_val_35022 === (19))){
var state_35021__$1 = state_35021;
var statearr_35034_36572 = state_35021__$1;
(statearr_35034_36572[(2)] = null);

(statearr_35034_36572[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35022 === (11))){
var inst_34996 = (state_35021[(2)]);
var state_35021__$1 = (function (){var statearr_35035 = state_35021;
(statearr_35035[(10)] = inst_34996);

return statearr_35035;
})();
var statearr_35036_36576 = state_35021__$1;
(statearr_35036_36576[(2)] = null);

(statearr_35036_36576[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35022 === (9))){
var state_35021__$1 = state_35021;
var statearr_35037_36577 = state_35021__$1;
(statearr_35037_36577[(2)] = null);

(statearr_35037_36577[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35022 === (5))){
var state_35021__$1 = state_35021;
if(cljs.core.truth_(close_QMARK_)){
var statearr_35038_36578 = state_35021__$1;
(statearr_35038_36578[(1)] = (8));

} else {
var statearr_35039_36580 = state_35021__$1;
(statearr_35039_36580[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35022 === (14))){
var inst_34999 = (state_35021[(8)]);
var inst_34999__$1 = (state_35021[(2)]);
var inst_35000 = (inst_34999__$1 == null);
var inst_35001 = cljs.core.not(inst_35000);
var state_35021__$1 = (function (){var statearr_35040 = state_35021;
(statearr_35040[(8)] = inst_34999__$1);

return statearr_35040;
})();
if(inst_35001){
var statearr_35041_36583 = state_35021__$1;
(statearr_35041_36583[(1)] = (15));

} else {
var statearr_35042_36585 = state_35021__$1;
(statearr_35042_36585[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35022 === (16))){
var state_35021__$1 = state_35021;
var statearr_35043_36587 = state_35021__$1;
(statearr_35043_36587[(2)] = false);

(statearr_35043_36587[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35022 === (10))){
var inst_34993 = (state_35021[(2)]);
var state_35021__$1 = state_35021;
var statearr_35044_36588 = state_35021__$1;
(statearr_35044_36588[(2)] = inst_34993);

(statearr_35044_36588[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35022 === (18))){
var inst_35004 = (state_35021[(2)]);
var state_35021__$1 = state_35021;
var statearr_35045_36590 = state_35021__$1;
(statearr_35045_36590[(2)] = inst_35004);

(statearr_35045_36590[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35022 === (8))){
var inst_34990 = cljs.core.async.close_BANG_(to);
var state_35021__$1 = state_35021;
var statearr_35046_36592 = state_35021__$1;
(statearr_35046_36592[(2)] = inst_34990);

(statearr_35046_36592[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____0 = (function (){
var statearr_35047 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35047[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__);

(statearr_35047[(1)] = (1));

return statearr_35047;
});
var cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____1 = (function (state_35021){
while(true){
var ret_value__34702__auto__ = (function (){try{while(true){
var result__34703__auto__ = switch__34700__auto__(state_35021);
if(cljs.core.keyword_identical_QMARK_(result__34703__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34703__auto__;
}
break;
}
}catch (e35048){var ex__34704__auto__ = e35048;
var statearr_35049_36597 = state_35021;
(statearr_35049_36597[(2)] = ex__34704__auto__);


if(cljs.core.seq((state_35021[(4)]))){
var statearr_35050_36599 = state_35021;
(statearr_35050_36599[(1)] = cljs.core.first((state_35021[(4)])));

} else {
throw ex__34704__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34702__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36600 = state_35021;
state_35021 = G__36600;
continue;
} else {
return ret_value__34702__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__ = function(state_35021){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____1.call(this,state_35021);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__34701__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__34701__auto__;
})()
})();
var state__34738__auto__ = (function (){var statearr_35051 = f__34737__auto__();
(statearr_35051[(6)] = c__34736__auto__);

return statearr_35051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34738__auto__);
}));

return c__34736__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__35053 = arguments.length;
switch (G__35053) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__35055 = arguments.length;
switch (G__35055) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__35057 = arguments.length;
switch (G__35057) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__34736__auto___36620 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34737__auto__ = (function (){var switch__34700__auto__ = (function (state_35083){
var state_val_35084 = (state_35083[(1)]);
if((state_val_35084 === (7))){
var inst_35079 = (state_35083[(2)]);
var state_35083__$1 = state_35083;
var statearr_35085_36625 = state_35083__$1;
(statearr_35085_36625[(2)] = inst_35079);

(statearr_35085_36625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35084 === (1))){
var state_35083__$1 = state_35083;
var statearr_35086_36628 = state_35083__$1;
(statearr_35086_36628[(2)] = null);

(statearr_35086_36628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35084 === (4))){
var inst_35060 = (state_35083[(7)]);
var inst_35060__$1 = (state_35083[(2)]);
var inst_35061 = (inst_35060__$1 == null);
var state_35083__$1 = (function (){var statearr_35087 = state_35083;
(statearr_35087[(7)] = inst_35060__$1);

return statearr_35087;
})();
if(cljs.core.truth_(inst_35061)){
var statearr_35088_36633 = state_35083__$1;
(statearr_35088_36633[(1)] = (5));

} else {
var statearr_35089_36634 = state_35083__$1;
(statearr_35089_36634[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35084 === (13))){
var state_35083__$1 = state_35083;
var statearr_35090_36637 = state_35083__$1;
(statearr_35090_36637[(2)] = null);

(statearr_35090_36637[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35084 === (6))){
var inst_35060 = (state_35083[(7)]);
var inst_35066 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_35060) : p.call(null,inst_35060));
var state_35083__$1 = state_35083;
if(cljs.core.truth_(inst_35066)){
var statearr_35091_36642 = state_35083__$1;
(statearr_35091_36642[(1)] = (9));

} else {
var statearr_35092_36643 = state_35083__$1;
(statearr_35092_36643[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35084 === (3))){
var inst_35081 = (state_35083[(2)]);
var state_35083__$1 = state_35083;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35083__$1,inst_35081);
} else {
if((state_val_35084 === (12))){
var state_35083__$1 = state_35083;
var statearr_35093_36644 = state_35083__$1;
(statearr_35093_36644[(2)] = null);

(statearr_35093_36644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35084 === (2))){
var state_35083__$1 = state_35083;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35083__$1,(4),ch);
} else {
if((state_val_35084 === (11))){
var inst_35060 = (state_35083[(7)]);
var inst_35070 = (state_35083[(2)]);
var state_35083__$1 = state_35083;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35083__$1,(8),inst_35070,inst_35060);
} else {
if((state_val_35084 === (9))){
var state_35083__$1 = state_35083;
var statearr_35094_36651 = state_35083__$1;
(statearr_35094_36651[(2)] = tc);

(statearr_35094_36651[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35084 === (5))){
var inst_35063 = cljs.core.async.close_BANG_(tc);
var inst_35064 = cljs.core.async.close_BANG_(fc);
var state_35083__$1 = (function (){var statearr_35095 = state_35083;
(statearr_35095[(8)] = inst_35063);

return statearr_35095;
})();
var statearr_35096_36654 = state_35083__$1;
(statearr_35096_36654[(2)] = inst_35064);

(statearr_35096_36654[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35084 === (14))){
var inst_35077 = (state_35083[(2)]);
var state_35083__$1 = state_35083;
var statearr_35097_36659 = state_35083__$1;
(statearr_35097_36659[(2)] = inst_35077);

(statearr_35097_36659[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35084 === (10))){
var state_35083__$1 = state_35083;
var statearr_35098_36660 = state_35083__$1;
(statearr_35098_36660[(2)] = fc);

(statearr_35098_36660[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35084 === (8))){
var inst_35072 = (state_35083[(2)]);
var state_35083__$1 = state_35083;
if(cljs.core.truth_(inst_35072)){
var statearr_35099_36664 = state_35083__$1;
(statearr_35099_36664[(1)] = (12));

} else {
var statearr_35100_36665 = state_35083__$1;
(statearr_35100_36665[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__34701__auto__ = null;
var cljs$core$async$state_machine__34701__auto____0 = (function (){
var statearr_35101 = [null,null,null,null,null,null,null,null,null];
(statearr_35101[(0)] = cljs$core$async$state_machine__34701__auto__);

(statearr_35101[(1)] = (1));

return statearr_35101;
});
var cljs$core$async$state_machine__34701__auto____1 = (function (state_35083){
while(true){
var ret_value__34702__auto__ = (function (){try{while(true){
var result__34703__auto__ = switch__34700__auto__(state_35083);
if(cljs.core.keyword_identical_QMARK_(result__34703__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34703__auto__;
}
break;
}
}catch (e35102){var ex__34704__auto__ = e35102;
var statearr_35103_36671 = state_35083;
(statearr_35103_36671[(2)] = ex__34704__auto__);


if(cljs.core.seq((state_35083[(4)]))){
var statearr_35104_36673 = state_35083;
(statearr_35104_36673[(1)] = cljs.core.first((state_35083[(4)])));

} else {
throw ex__34704__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34702__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36675 = state_35083;
state_35083 = G__36675;
continue;
} else {
return ret_value__34702__auto__;
}
break;
}
});
cljs$core$async$state_machine__34701__auto__ = function(state_35083){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__34701__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__34701__auto____1.call(this,state_35083);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__34701__auto____0;
cljs$core$async$state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__34701__auto____1;
return cljs$core$async$state_machine__34701__auto__;
})()
})();
var state__34738__auto__ = (function (){var statearr_35105 = f__34737__auto__();
(statearr_35105[(6)] = c__34736__auto___36620);

return statearr_35105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34738__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__34736__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34737__auto__ = (function (){var switch__34700__auto__ = (function (state_35127){
var state_val_35128 = (state_35127[(1)]);
if((state_val_35128 === (7))){
var inst_35123 = (state_35127[(2)]);
var state_35127__$1 = state_35127;
var statearr_35129_36680 = state_35127__$1;
(statearr_35129_36680[(2)] = inst_35123);

(statearr_35129_36680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35128 === (1))){
var inst_35106 = init;
var inst_35107 = inst_35106;
var state_35127__$1 = (function (){var statearr_35130 = state_35127;
(statearr_35130[(7)] = inst_35107);

return statearr_35130;
})();
var statearr_35131_36683 = state_35127__$1;
(statearr_35131_36683[(2)] = null);

(statearr_35131_36683[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35128 === (4))){
var inst_35110 = (state_35127[(8)]);
var inst_35110__$1 = (state_35127[(2)]);
var inst_35111 = (inst_35110__$1 == null);
var state_35127__$1 = (function (){var statearr_35132 = state_35127;
(statearr_35132[(8)] = inst_35110__$1);

return statearr_35132;
})();
if(cljs.core.truth_(inst_35111)){
var statearr_35133_36687 = state_35127__$1;
(statearr_35133_36687[(1)] = (5));

} else {
var statearr_35134_36688 = state_35127__$1;
(statearr_35134_36688[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35128 === (6))){
var inst_35107 = (state_35127[(7)]);
var inst_35110 = (state_35127[(8)]);
var inst_35114 = (state_35127[(9)]);
var inst_35114__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_35107,inst_35110) : f.call(null,inst_35107,inst_35110));
var inst_35115 = cljs.core.reduced_QMARK_(inst_35114__$1);
var state_35127__$1 = (function (){var statearr_35135 = state_35127;
(statearr_35135[(9)] = inst_35114__$1);

return statearr_35135;
})();
if(inst_35115){
var statearr_35136_36693 = state_35127__$1;
(statearr_35136_36693[(1)] = (8));

} else {
var statearr_35137_36694 = state_35127__$1;
(statearr_35137_36694[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35128 === (3))){
var inst_35125 = (state_35127[(2)]);
var state_35127__$1 = state_35127;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35127__$1,inst_35125);
} else {
if((state_val_35128 === (2))){
var state_35127__$1 = state_35127;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35127__$1,(4),ch);
} else {
if((state_val_35128 === (9))){
var inst_35114 = (state_35127[(9)]);
var inst_35107 = inst_35114;
var state_35127__$1 = (function (){var statearr_35138 = state_35127;
(statearr_35138[(7)] = inst_35107);

return statearr_35138;
})();
var statearr_35139_36703 = state_35127__$1;
(statearr_35139_36703[(2)] = null);

(statearr_35139_36703[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35128 === (5))){
var inst_35107 = (state_35127[(7)]);
var state_35127__$1 = state_35127;
var statearr_35140_36705 = state_35127__$1;
(statearr_35140_36705[(2)] = inst_35107);

(statearr_35140_36705[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35128 === (10))){
var inst_35121 = (state_35127[(2)]);
var state_35127__$1 = state_35127;
var statearr_35141_36710 = state_35127__$1;
(statearr_35141_36710[(2)] = inst_35121);

(statearr_35141_36710[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35128 === (8))){
var inst_35114 = (state_35127[(9)]);
var inst_35117 = cljs.core.deref(inst_35114);
var state_35127__$1 = state_35127;
var statearr_35142_36712 = state_35127__$1;
(statearr_35142_36712[(2)] = inst_35117);

(statearr_35142_36712[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__34701__auto__ = null;
var cljs$core$async$reduce_$_state_machine__34701__auto____0 = (function (){
var statearr_35143 = [null,null,null,null,null,null,null,null,null,null];
(statearr_35143[(0)] = cljs$core$async$reduce_$_state_machine__34701__auto__);

(statearr_35143[(1)] = (1));

return statearr_35143;
});
var cljs$core$async$reduce_$_state_machine__34701__auto____1 = (function (state_35127){
while(true){
var ret_value__34702__auto__ = (function (){try{while(true){
var result__34703__auto__ = switch__34700__auto__(state_35127);
if(cljs.core.keyword_identical_QMARK_(result__34703__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34703__auto__;
}
break;
}
}catch (e35144){var ex__34704__auto__ = e35144;
var statearr_35145_36720 = state_35127;
(statearr_35145_36720[(2)] = ex__34704__auto__);


if(cljs.core.seq((state_35127[(4)]))){
var statearr_35146_36722 = state_35127;
(statearr_35146_36722[(1)] = cljs.core.first((state_35127[(4)])));

} else {
throw ex__34704__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34702__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36729 = state_35127;
state_35127 = G__36729;
continue;
} else {
return ret_value__34702__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__34701__auto__ = function(state_35127){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__34701__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__34701__auto____1.call(this,state_35127);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__34701__auto____0;
cljs$core$async$reduce_$_state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__34701__auto____1;
return cljs$core$async$reduce_$_state_machine__34701__auto__;
})()
})();
var state__34738__auto__ = (function (){var statearr_35147 = f__34737__auto__();
(statearr_35147[(6)] = c__34736__auto__);

return statearr_35147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34738__auto__);
}));

return c__34736__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__34736__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34737__auto__ = (function (){var switch__34700__auto__ = (function (state_35153){
var state_val_35154 = (state_35153[(1)]);
if((state_val_35154 === (1))){
var inst_35148 = cljs.core.async.reduce(f__$1,init,ch);
var state_35153__$1 = state_35153;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35153__$1,(2),inst_35148);
} else {
if((state_val_35154 === (2))){
var inst_35150 = (state_35153[(2)]);
var inst_35151 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_35150) : f__$1.call(null,inst_35150));
var state_35153__$1 = state_35153;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35153__$1,inst_35151);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__34701__auto__ = null;
var cljs$core$async$transduce_$_state_machine__34701__auto____0 = (function (){
var statearr_35155 = [null,null,null,null,null,null,null];
(statearr_35155[(0)] = cljs$core$async$transduce_$_state_machine__34701__auto__);

(statearr_35155[(1)] = (1));

return statearr_35155;
});
var cljs$core$async$transduce_$_state_machine__34701__auto____1 = (function (state_35153){
while(true){
var ret_value__34702__auto__ = (function (){try{while(true){
var result__34703__auto__ = switch__34700__auto__(state_35153);
if(cljs.core.keyword_identical_QMARK_(result__34703__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34703__auto__;
}
break;
}
}catch (e35156){var ex__34704__auto__ = e35156;
var statearr_35157_36743 = state_35153;
(statearr_35157_36743[(2)] = ex__34704__auto__);


if(cljs.core.seq((state_35153[(4)]))){
var statearr_35158_36747 = state_35153;
(statearr_35158_36747[(1)] = cljs.core.first((state_35153[(4)])));

} else {
throw ex__34704__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34702__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36752 = state_35153;
state_35153 = G__36752;
continue;
} else {
return ret_value__34702__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__34701__auto__ = function(state_35153){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__34701__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__34701__auto____1.call(this,state_35153);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__34701__auto____0;
cljs$core$async$transduce_$_state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__34701__auto____1;
return cljs$core$async$transduce_$_state_machine__34701__auto__;
})()
})();
var state__34738__auto__ = (function (){var statearr_35159 = f__34737__auto__();
(statearr_35159[(6)] = c__34736__auto__);

return statearr_35159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34738__auto__);
}));

return c__34736__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__35161 = arguments.length;
switch (G__35161) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__34736__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34737__auto__ = (function (){var switch__34700__auto__ = (function (state_35186){
var state_val_35187 = (state_35186[(1)]);
if((state_val_35187 === (7))){
var inst_35168 = (state_35186[(2)]);
var state_35186__$1 = state_35186;
var statearr_35188_36764 = state_35186__$1;
(statearr_35188_36764[(2)] = inst_35168);

(statearr_35188_36764[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35187 === (1))){
var inst_35162 = cljs.core.seq(coll);
var inst_35163 = inst_35162;
var state_35186__$1 = (function (){var statearr_35189 = state_35186;
(statearr_35189[(7)] = inst_35163);

return statearr_35189;
})();
var statearr_35190_36802 = state_35186__$1;
(statearr_35190_36802[(2)] = null);

(statearr_35190_36802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35187 === (4))){
var inst_35163 = (state_35186[(7)]);
var inst_35166 = cljs.core.first(inst_35163);
var state_35186__$1 = state_35186;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35186__$1,(7),ch,inst_35166);
} else {
if((state_val_35187 === (13))){
var inst_35180 = (state_35186[(2)]);
var state_35186__$1 = state_35186;
var statearr_35191_36803 = state_35186__$1;
(statearr_35191_36803[(2)] = inst_35180);

(statearr_35191_36803[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35187 === (6))){
var inst_35171 = (state_35186[(2)]);
var state_35186__$1 = state_35186;
if(cljs.core.truth_(inst_35171)){
var statearr_35192_36804 = state_35186__$1;
(statearr_35192_36804[(1)] = (8));

} else {
var statearr_35193_36805 = state_35186__$1;
(statearr_35193_36805[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35187 === (3))){
var inst_35184 = (state_35186[(2)]);
var state_35186__$1 = state_35186;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35186__$1,inst_35184);
} else {
if((state_val_35187 === (12))){
var state_35186__$1 = state_35186;
var statearr_35194_36806 = state_35186__$1;
(statearr_35194_36806[(2)] = null);

(statearr_35194_36806[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35187 === (2))){
var inst_35163 = (state_35186[(7)]);
var state_35186__$1 = state_35186;
if(cljs.core.truth_(inst_35163)){
var statearr_35195_36807 = state_35186__$1;
(statearr_35195_36807[(1)] = (4));

} else {
var statearr_35196_36808 = state_35186__$1;
(statearr_35196_36808[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35187 === (11))){
var inst_35177 = cljs.core.async.close_BANG_(ch);
var state_35186__$1 = state_35186;
var statearr_35197_36809 = state_35186__$1;
(statearr_35197_36809[(2)] = inst_35177);

(statearr_35197_36809[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35187 === (9))){
var state_35186__$1 = state_35186;
if(cljs.core.truth_(close_QMARK_)){
var statearr_35198_36810 = state_35186__$1;
(statearr_35198_36810[(1)] = (11));

} else {
var statearr_35199_36811 = state_35186__$1;
(statearr_35199_36811[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35187 === (5))){
var inst_35163 = (state_35186[(7)]);
var state_35186__$1 = state_35186;
var statearr_35200_36812 = state_35186__$1;
(statearr_35200_36812[(2)] = inst_35163);

(statearr_35200_36812[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35187 === (10))){
var inst_35182 = (state_35186[(2)]);
var state_35186__$1 = state_35186;
var statearr_35201_36813 = state_35186__$1;
(statearr_35201_36813[(2)] = inst_35182);

(statearr_35201_36813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35187 === (8))){
var inst_35163 = (state_35186[(7)]);
var inst_35173 = cljs.core.next(inst_35163);
var inst_35163__$1 = inst_35173;
var state_35186__$1 = (function (){var statearr_35202 = state_35186;
(statearr_35202[(7)] = inst_35163__$1);

return statearr_35202;
})();
var statearr_35203_36814 = state_35186__$1;
(statearr_35203_36814[(2)] = null);

(statearr_35203_36814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__34701__auto__ = null;
var cljs$core$async$state_machine__34701__auto____0 = (function (){
var statearr_35204 = [null,null,null,null,null,null,null,null];
(statearr_35204[(0)] = cljs$core$async$state_machine__34701__auto__);

(statearr_35204[(1)] = (1));

return statearr_35204;
});
var cljs$core$async$state_machine__34701__auto____1 = (function (state_35186){
while(true){
var ret_value__34702__auto__ = (function (){try{while(true){
var result__34703__auto__ = switch__34700__auto__(state_35186);
if(cljs.core.keyword_identical_QMARK_(result__34703__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34703__auto__;
}
break;
}
}catch (e35205){var ex__34704__auto__ = e35205;
var statearr_35206_36815 = state_35186;
(statearr_35206_36815[(2)] = ex__34704__auto__);


if(cljs.core.seq((state_35186[(4)]))){
var statearr_35207_36816 = state_35186;
(statearr_35207_36816[(1)] = cljs.core.first((state_35186[(4)])));

} else {
throw ex__34704__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34702__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36817 = state_35186;
state_35186 = G__36817;
continue;
} else {
return ret_value__34702__auto__;
}
break;
}
});
cljs$core$async$state_machine__34701__auto__ = function(state_35186){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__34701__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__34701__auto____1.call(this,state_35186);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__34701__auto____0;
cljs$core$async$state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__34701__auto____1;
return cljs$core$async$state_machine__34701__auto__;
})()
})();
var state__34738__auto__ = (function (){var statearr_35208 = f__34737__auto__();
(statearr_35208[(6)] = c__34736__auto__);

return statearr_35208;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34738__auto__);
}));

return c__34736__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__35210 = arguments.length;
switch (G__35210) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_36819 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_36819(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_36820 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_36820(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_36821 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_36821(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_36822 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_36822(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async35211 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35211 = (function (ch,cs,meta35212){
this.ch = ch;
this.cs = cs;
this.meta35212 = meta35212;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async35211.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35213,meta35212__$1){
var self__ = this;
var _35213__$1 = this;
return (new cljs.core.async.t_cljs$core$async35211(self__.ch,self__.cs,meta35212__$1));
}));

(cljs.core.async.t_cljs$core$async35211.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35213){
var self__ = this;
var _35213__$1 = this;
return self__.meta35212;
}));

(cljs.core.async.t_cljs$core$async35211.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async35211.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async35211.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async35211.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async35211.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async35211.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async35211.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta35212","meta35212",-1725080654,null)], null);
}));

(cljs.core.async.t_cljs$core$async35211.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async35211.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35211");

(cljs.core.async.t_cljs$core$async35211.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async35211");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async35211.
 */
cljs.core.async.__GT_t_cljs$core$async35211 = (function cljs$core$async$mult_$___GT_t_cljs$core$async35211(ch__$1,cs__$1,meta35212){
return (new cljs.core.async.t_cljs$core$async35211(ch__$1,cs__$1,meta35212));
});

}

return (new cljs.core.async.t_cljs$core$async35211(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__34736__auto___36900 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34737__auto__ = (function (){var switch__34700__auto__ = (function (state_35346){
var state_val_35347 = (state_35346[(1)]);
if((state_val_35347 === (7))){
var inst_35342 = (state_35346[(2)]);
var state_35346__$1 = state_35346;
var statearr_35348_36901 = state_35346__$1;
(statearr_35348_36901[(2)] = inst_35342);

(statearr_35348_36901[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (20))){
var inst_35247 = (state_35346[(7)]);
var inst_35259 = cljs.core.first(inst_35247);
var inst_35260 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35259,(0),null);
var inst_35261 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35259,(1),null);
var state_35346__$1 = (function (){var statearr_35349 = state_35346;
(statearr_35349[(8)] = inst_35260);

return statearr_35349;
})();
if(cljs.core.truth_(inst_35261)){
var statearr_35350_36902 = state_35346__$1;
(statearr_35350_36902[(1)] = (22));

} else {
var statearr_35351_36903 = state_35346__$1;
(statearr_35351_36903[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (27))){
var inst_35296 = (state_35346[(9)]);
var inst_35289 = (state_35346[(10)]);
var inst_35291 = (state_35346[(11)]);
var inst_35216 = (state_35346[(12)]);
var inst_35296__$1 = cljs.core._nth(inst_35289,inst_35291);
var inst_35297 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_35296__$1,inst_35216,done);
var state_35346__$1 = (function (){var statearr_35352 = state_35346;
(statearr_35352[(9)] = inst_35296__$1);

return statearr_35352;
})();
if(cljs.core.truth_(inst_35297)){
var statearr_35353_36904 = state_35346__$1;
(statearr_35353_36904[(1)] = (30));

} else {
var statearr_35354_36905 = state_35346__$1;
(statearr_35354_36905[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (1))){
var state_35346__$1 = state_35346;
var statearr_35355_36906 = state_35346__$1;
(statearr_35355_36906[(2)] = null);

(statearr_35355_36906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (24))){
var inst_35247 = (state_35346[(7)]);
var inst_35266 = (state_35346[(2)]);
var inst_35267 = cljs.core.next(inst_35247);
var inst_35225 = inst_35267;
var inst_35226 = null;
var inst_35227 = (0);
var inst_35228 = (0);
var state_35346__$1 = (function (){var statearr_35356 = state_35346;
(statearr_35356[(13)] = inst_35227);

(statearr_35356[(14)] = inst_35266);

(statearr_35356[(15)] = inst_35225);

(statearr_35356[(16)] = inst_35226);

(statearr_35356[(17)] = inst_35228);

return statearr_35356;
})();
var statearr_35357_36907 = state_35346__$1;
(statearr_35357_36907[(2)] = null);

(statearr_35357_36907[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (39))){
var state_35346__$1 = state_35346;
var statearr_35361_36908 = state_35346__$1;
(statearr_35361_36908[(2)] = null);

(statearr_35361_36908[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (4))){
var inst_35216 = (state_35346[(12)]);
var inst_35216__$1 = (state_35346[(2)]);
var inst_35217 = (inst_35216__$1 == null);
var state_35346__$1 = (function (){var statearr_35362 = state_35346;
(statearr_35362[(12)] = inst_35216__$1);

return statearr_35362;
})();
if(cljs.core.truth_(inst_35217)){
var statearr_35363_36909 = state_35346__$1;
(statearr_35363_36909[(1)] = (5));

} else {
var statearr_35364_36910 = state_35346__$1;
(statearr_35364_36910[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (15))){
var inst_35227 = (state_35346[(13)]);
var inst_35225 = (state_35346[(15)]);
var inst_35226 = (state_35346[(16)]);
var inst_35228 = (state_35346[(17)]);
var inst_35243 = (state_35346[(2)]);
var inst_35244 = (inst_35228 + (1));
var tmp35358 = inst_35227;
var tmp35359 = inst_35225;
var tmp35360 = inst_35226;
var inst_35225__$1 = tmp35359;
var inst_35226__$1 = tmp35360;
var inst_35227__$1 = tmp35358;
var inst_35228__$1 = inst_35244;
var state_35346__$1 = (function (){var statearr_35365 = state_35346;
(statearr_35365[(13)] = inst_35227__$1);

(statearr_35365[(18)] = inst_35243);

(statearr_35365[(15)] = inst_35225__$1);

(statearr_35365[(16)] = inst_35226__$1);

(statearr_35365[(17)] = inst_35228__$1);

return statearr_35365;
})();
var statearr_35366_36911 = state_35346__$1;
(statearr_35366_36911[(2)] = null);

(statearr_35366_36911[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (21))){
var inst_35270 = (state_35346[(2)]);
var state_35346__$1 = state_35346;
var statearr_35370_36912 = state_35346__$1;
(statearr_35370_36912[(2)] = inst_35270);

(statearr_35370_36912[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (31))){
var inst_35296 = (state_35346[(9)]);
var inst_35300 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_35296);
var state_35346__$1 = state_35346;
var statearr_35371_36913 = state_35346__$1;
(statearr_35371_36913[(2)] = inst_35300);

(statearr_35371_36913[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (32))){
var inst_35289 = (state_35346[(10)]);
var inst_35290 = (state_35346[(19)]);
var inst_35288 = (state_35346[(20)]);
var inst_35291 = (state_35346[(11)]);
var inst_35302 = (state_35346[(2)]);
var inst_35303 = (inst_35291 + (1));
var tmp35367 = inst_35289;
var tmp35368 = inst_35290;
var tmp35369 = inst_35288;
var inst_35288__$1 = tmp35369;
var inst_35289__$1 = tmp35367;
var inst_35290__$1 = tmp35368;
var inst_35291__$1 = inst_35303;
var state_35346__$1 = (function (){var statearr_35372 = state_35346;
(statearr_35372[(10)] = inst_35289__$1);

(statearr_35372[(19)] = inst_35290__$1);

(statearr_35372[(20)] = inst_35288__$1);

(statearr_35372[(11)] = inst_35291__$1);

(statearr_35372[(21)] = inst_35302);

return statearr_35372;
})();
var statearr_35373_36914 = state_35346__$1;
(statearr_35373_36914[(2)] = null);

(statearr_35373_36914[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (40))){
var inst_35315 = (state_35346[(22)]);
var inst_35319 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_35315);
var state_35346__$1 = state_35346;
var statearr_35374_36915 = state_35346__$1;
(statearr_35374_36915[(2)] = inst_35319);

(statearr_35374_36915[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (33))){
var inst_35306 = (state_35346[(23)]);
var inst_35308 = cljs.core.chunked_seq_QMARK_(inst_35306);
var state_35346__$1 = state_35346;
if(inst_35308){
var statearr_35375_36916 = state_35346__$1;
(statearr_35375_36916[(1)] = (36));

} else {
var statearr_35376_36917 = state_35346__$1;
(statearr_35376_36917[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (13))){
var inst_35237 = (state_35346[(24)]);
var inst_35240 = cljs.core.async.close_BANG_(inst_35237);
var state_35346__$1 = state_35346;
var statearr_35377_36918 = state_35346__$1;
(statearr_35377_36918[(2)] = inst_35240);

(statearr_35377_36918[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (22))){
var inst_35260 = (state_35346[(8)]);
var inst_35263 = cljs.core.async.close_BANG_(inst_35260);
var state_35346__$1 = state_35346;
var statearr_35378_36919 = state_35346__$1;
(statearr_35378_36919[(2)] = inst_35263);

(statearr_35378_36919[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (36))){
var inst_35306 = (state_35346[(23)]);
var inst_35310 = cljs.core.chunk_first(inst_35306);
var inst_35311 = cljs.core.chunk_rest(inst_35306);
var inst_35312 = cljs.core.count(inst_35310);
var inst_35288 = inst_35311;
var inst_35289 = inst_35310;
var inst_35290 = inst_35312;
var inst_35291 = (0);
var state_35346__$1 = (function (){var statearr_35379 = state_35346;
(statearr_35379[(10)] = inst_35289);

(statearr_35379[(19)] = inst_35290);

(statearr_35379[(20)] = inst_35288);

(statearr_35379[(11)] = inst_35291);

return statearr_35379;
})();
var statearr_35380_36923 = state_35346__$1;
(statearr_35380_36923[(2)] = null);

(statearr_35380_36923[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (41))){
var inst_35306 = (state_35346[(23)]);
var inst_35321 = (state_35346[(2)]);
var inst_35322 = cljs.core.next(inst_35306);
var inst_35288 = inst_35322;
var inst_35289 = null;
var inst_35290 = (0);
var inst_35291 = (0);
var state_35346__$1 = (function (){var statearr_35381 = state_35346;
(statearr_35381[(10)] = inst_35289);

(statearr_35381[(19)] = inst_35290);

(statearr_35381[(20)] = inst_35288);

(statearr_35381[(25)] = inst_35321);

(statearr_35381[(11)] = inst_35291);

return statearr_35381;
})();
var statearr_35382_36946 = state_35346__$1;
(statearr_35382_36946[(2)] = null);

(statearr_35382_36946[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (43))){
var state_35346__$1 = state_35346;
var statearr_35383_36955 = state_35346__$1;
(statearr_35383_36955[(2)] = null);

(statearr_35383_36955[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (29))){
var inst_35330 = (state_35346[(2)]);
var state_35346__$1 = state_35346;
var statearr_35384_36966 = state_35346__$1;
(statearr_35384_36966[(2)] = inst_35330);

(statearr_35384_36966[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (44))){
var inst_35339 = (state_35346[(2)]);
var state_35346__$1 = (function (){var statearr_35385 = state_35346;
(statearr_35385[(26)] = inst_35339);

return statearr_35385;
})();
var statearr_35386_36981 = state_35346__$1;
(statearr_35386_36981[(2)] = null);

(statearr_35386_36981[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (6))){
var inst_35280 = (state_35346[(27)]);
var inst_35279 = cljs.core.deref(cs);
var inst_35280__$1 = cljs.core.keys(inst_35279);
var inst_35281 = cljs.core.count(inst_35280__$1);
var inst_35282 = cljs.core.reset_BANG_(dctr,inst_35281);
var inst_35287 = cljs.core.seq(inst_35280__$1);
var inst_35288 = inst_35287;
var inst_35289 = null;
var inst_35290 = (0);
var inst_35291 = (0);
var state_35346__$1 = (function (){var statearr_35387 = state_35346;
(statearr_35387[(10)] = inst_35289);

(statearr_35387[(28)] = inst_35282);

(statearr_35387[(19)] = inst_35290);

(statearr_35387[(20)] = inst_35288);

(statearr_35387[(27)] = inst_35280__$1);

(statearr_35387[(11)] = inst_35291);

return statearr_35387;
})();
var statearr_35388_37000 = state_35346__$1;
(statearr_35388_37000[(2)] = null);

(statearr_35388_37000[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (28))){
var inst_35306 = (state_35346[(23)]);
var inst_35288 = (state_35346[(20)]);
var inst_35306__$1 = cljs.core.seq(inst_35288);
var state_35346__$1 = (function (){var statearr_35389 = state_35346;
(statearr_35389[(23)] = inst_35306__$1);

return statearr_35389;
})();
if(inst_35306__$1){
var statearr_35390_37003 = state_35346__$1;
(statearr_35390_37003[(1)] = (33));

} else {
var statearr_35391_37004 = state_35346__$1;
(statearr_35391_37004[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (25))){
var inst_35290 = (state_35346[(19)]);
var inst_35291 = (state_35346[(11)]);
var inst_35293 = (inst_35291 < inst_35290);
var inst_35294 = inst_35293;
var state_35346__$1 = state_35346;
if(cljs.core.truth_(inst_35294)){
var statearr_35392_37005 = state_35346__$1;
(statearr_35392_37005[(1)] = (27));

} else {
var statearr_35393_37006 = state_35346__$1;
(statearr_35393_37006[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (34))){
var state_35346__$1 = state_35346;
var statearr_35394_37007 = state_35346__$1;
(statearr_35394_37007[(2)] = null);

(statearr_35394_37007[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (17))){
var state_35346__$1 = state_35346;
var statearr_35395_37008 = state_35346__$1;
(statearr_35395_37008[(2)] = null);

(statearr_35395_37008[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (3))){
var inst_35344 = (state_35346[(2)]);
var state_35346__$1 = state_35346;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35346__$1,inst_35344);
} else {
if((state_val_35347 === (12))){
var inst_35275 = (state_35346[(2)]);
var state_35346__$1 = state_35346;
var statearr_35396_37009 = state_35346__$1;
(statearr_35396_37009[(2)] = inst_35275);

(statearr_35396_37009[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (2))){
var state_35346__$1 = state_35346;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35346__$1,(4),ch);
} else {
if((state_val_35347 === (23))){
var state_35346__$1 = state_35346;
var statearr_35397_37010 = state_35346__$1;
(statearr_35397_37010[(2)] = null);

(statearr_35397_37010[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (35))){
var inst_35328 = (state_35346[(2)]);
var state_35346__$1 = state_35346;
var statearr_35398_37011 = state_35346__$1;
(statearr_35398_37011[(2)] = inst_35328);

(statearr_35398_37011[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (19))){
var inst_35247 = (state_35346[(7)]);
var inst_35251 = cljs.core.chunk_first(inst_35247);
var inst_35252 = cljs.core.chunk_rest(inst_35247);
var inst_35253 = cljs.core.count(inst_35251);
var inst_35225 = inst_35252;
var inst_35226 = inst_35251;
var inst_35227 = inst_35253;
var inst_35228 = (0);
var state_35346__$1 = (function (){var statearr_35399 = state_35346;
(statearr_35399[(13)] = inst_35227);

(statearr_35399[(15)] = inst_35225);

(statearr_35399[(16)] = inst_35226);

(statearr_35399[(17)] = inst_35228);

return statearr_35399;
})();
var statearr_35400_37012 = state_35346__$1;
(statearr_35400_37012[(2)] = null);

(statearr_35400_37012[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (11))){
var inst_35247 = (state_35346[(7)]);
var inst_35225 = (state_35346[(15)]);
var inst_35247__$1 = cljs.core.seq(inst_35225);
var state_35346__$1 = (function (){var statearr_35401 = state_35346;
(statearr_35401[(7)] = inst_35247__$1);

return statearr_35401;
})();
if(inst_35247__$1){
var statearr_35402_37013 = state_35346__$1;
(statearr_35402_37013[(1)] = (16));

} else {
var statearr_35403_37014 = state_35346__$1;
(statearr_35403_37014[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (9))){
var inst_35277 = (state_35346[(2)]);
var state_35346__$1 = state_35346;
var statearr_35404_37015 = state_35346__$1;
(statearr_35404_37015[(2)] = inst_35277);

(statearr_35404_37015[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (5))){
var inst_35223 = cljs.core.deref(cs);
var inst_35224 = cljs.core.seq(inst_35223);
var inst_35225 = inst_35224;
var inst_35226 = null;
var inst_35227 = (0);
var inst_35228 = (0);
var state_35346__$1 = (function (){var statearr_35405 = state_35346;
(statearr_35405[(13)] = inst_35227);

(statearr_35405[(15)] = inst_35225);

(statearr_35405[(16)] = inst_35226);

(statearr_35405[(17)] = inst_35228);

return statearr_35405;
})();
var statearr_35406_37016 = state_35346__$1;
(statearr_35406_37016[(2)] = null);

(statearr_35406_37016[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (14))){
var state_35346__$1 = state_35346;
var statearr_35407_37017 = state_35346__$1;
(statearr_35407_37017[(2)] = null);

(statearr_35407_37017[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (45))){
var inst_35336 = (state_35346[(2)]);
var state_35346__$1 = state_35346;
var statearr_35408_37018 = state_35346__$1;
(statearr_35408_37018[(2)] = inst_35336);

(statearr_35408_37018[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (26))){
var inst_35280 = (state_35346[(27)]);
var inst_35332 = (state_35346[(2)]);
var inst_35333 = cljs.core.seq(inst_35280);
var state_35346__$1 = (function (){var statearr_35409 = state_35346;
(statearr_35409[(29)] = inst_35332);

return statearr_35409;
})();
if(inst_35333){
var statearr_35410_37019 = state_35346__$1;
(statearr_35410_37019[(1)] = (42));

} else {
var statearr_35411_37020 = state_35346__$1;
(statearr_35411_37020[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (16))){
var inst_35247 = (state_35346[(7)]);
var inst_35249 = cljs.core.chunked_seq_QMARK_(inst_35247);
var state_35346__$1 = state_35346;
if(inst_35249){
var statearr_35412_37021 = state_35346__$1;
(statearr_35412_37021[(1)] = (19));

} else {
var statearr_35413_37022 = state_35346__$1;
(statearr_35413_37022[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (38))){
var inst_35325 = (state_35346[(2)]);
var state_35346__$1 = state_35346;
var statearr_35414_37023 = state_35346__$1;
(statearr_35414_37023[(2)] = inst_35325);

(statearr_35414_37023[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (30))){
var state_35346__$1 = state_35346;
var statearr_35415_37024 = state_35346__$1;
(statearr_35415_37024[(2)] = null);

(statearr_35415_37024[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (10))){
var inst_35226 = (state_35346[(16)]);
var inst_35228 = (state_35346[(17)]);
var inst_35236 = cljs.core._nth(inst_35226,inst_35228);
var inst_35237 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35236,(0),null);
var inst_35238 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35236,(1),null);
var state_35346__$1 = (function (){var statearr_35416 = state_35346;
(statearr_35416[(24)] = inst_35237);

return statearr_35416;
})();
if(cljs.core.truth_(inst_35238)){
var statearr_35417_37025 = state_35346__$1;
(statearr_35417_37025[(1)] = (13));

} else {
var statearr_35418_37026 = state_35346__$1;
(statearr_35418_37026[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (18))){
var inst_35273 = (state_35346[(2)]);
var state_35346__$1 = state_35346;
var statearr_35419_37027 = state_35346__$1;
(statearr_35419_37027[(2)] = inst_35273);

(statearr_35419_37027[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (42))){
var state_35346__$1 = state_35346;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35346__$1,(45),dchan);
} else {
if((state_val_35347 === (37))){
var inst_35306 = (state_35346[(23)]);
var inst_35216 = (state_35346[(12)]);
var inst_35315 = (state_35346[(22)]);
var inst_35315__$1 = cljs.core.first(inst_35306);
var inst_35316 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_35315__$1,inst_35216,done);
var state_35346__$1 = (function (){var statearr_35420 = state_35346;
(statearr_35420[(22)] = inst_35315__$1);

return statearr_35420;
})();
if(cljs.core.truth_(inst_35316)){
var statearr_35421_37028 = state_35346__$1;
(statearr_35421_37028[(1)] = (39));

} else {
var statearr_35422_37029 = state_35346__$1;
(statearr_35422_37029[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35347 === (8))){
var inst_35227 = (state_35346[(13)]);
var inst_35228 = (state_35346[(17)]);
var inst_35230 = (inst_35228 < inst_35227);
var inst_35231 = inst_35230;
var state_35346__$1 = state_35346;
if(cljs.core.truth_(inst_35231)){
var statearr_35423_37030 = state_35346__$1;
(statearr_35423_37030[(1)] = (10));

} else {
var statearr_35424_37031 = state_35346__$1;
(statearr_35424_37031[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__34701__auto__ = null;
var cljs$core$async$mult_$_state_machine__34701__auto____0 = (function (){
var statearr_35425 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35425[(0)] = cljs$core$async$mult_$_state_machine__34701__auto__);

(statearr_35425[(1)] = (1));

return statearr_35425;
});
var cljs$core$async$mult_$_state_machine__34701__auto____1 = (function (state_35346){
while(true){
var ret_value__34702__auto__ = (function (){try{while(true){
var result__34703__auto__ = switch__34700__auto__(state_35346);
if(cljs.core.keyword_identical_QMARK_(result__34703__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34703__auto__;
}
break;
}
}catch (e35426){var ex__34704__auto__ = e35426;
var statearr_35427_37032 = state_35346;
(statearr_35427_37032[(2)] = ex__34704__auto__);


if(cljs.core.seq((state_35346[(4)]))){
var statearr_35428_37033 = state_35346;
(statearr_35428_37033[(1)] = cljs.core.first((state_35346[(4)])));

} else {
throw ex__34704__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34702__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37034 = state_35346;
state_35346 = G__37034;
continue;
} else {
return ret_value__34702__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__34701__auto__ = function(state_35346){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__34701__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__34701__auto____1.call(this,state_35346);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__34701__auto____0;
cljs$core$async$mult_$_state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__34701__auto____1;
return cljs$core$async$mult_$_state_machine__34701__auto__;
})()
})();
var state__34738__auto__ = (function (){var statearr_35429 = f__34737__auto__();
(statearr_35429[(6)] = c__34736__auto___36900);

return statearr_35429;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34738__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__35431 = arguments.length;
switch (G__35431) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_37036 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_37036(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_37037 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_37037(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_37038 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_37038(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_37039 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_37039(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_37040 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_37040(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___37042 = arguments.length;
var i__4737__auto___37043 = (0);
while(true){
if((i__4737__auto___37043 < len__4736__auto___37042)){
args__4742__auto__.push((arguments[i__4737__auto___37043]));

var G__37044 = (i__4737__auto___37043 + (1));
i__4737__auto___37043 = G__37044;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__35436){
var map__35437 = p__35436;
var map__35437__$1 = (((((!((map__35437 == null))))?(((((map__35437.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35437.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35437):map__35437);
var opts = map__35437__$1;
var statearr_35439_37045 = state;
(statearr_35439_37045[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_35440_37046 = state;
(statearr_35440_37046[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_35441_37047 = state;
(statearr_35441_37047[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq35432){
var G__35433 = cljs.core.first(seq35432);
var seq35432__$1 = cljs.core.next(seq35432);
var G__35434 = cljs.core.first(seq35432__$1);
var seq35432__$2 = cljs.core.next(seq35432__$1);
var G__35435 = cljs.core.first(seq35432__$2);
var seq35432__$3 = cljs.core.next(seq35432__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__35433,G__35434,G__35435,seq35432__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async35442 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35442 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta35443){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta35443 = meta35443;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async35442.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35444,meta35443__$1){
var self__ = this;
var _35444__$1 = this;
return (new cljs.core.async.t_cljs$core$async35442(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta35443__$1));
}));

(cljs.core.async.t_cljs$core$async35442.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35444){
var self__ = this;
var _35444__$1 = this;
return self__.meta35443;
}));

(cljs.core.async.t_cljs$core$async35442.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async35442.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async35442.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async35442.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async35442.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async35442.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async35442.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async35442.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async35442.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta35443","meta35443",950839484,null)], null);
}));

(cljs.core.async.t_cljs$core$async35442.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async35442.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35442");

(cljs.core.async.t_cljs$core$async35442.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async35442");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async35442.
 */
cljs.core.async.__GT_t_cljs$core$async35442 = (function cljs$core$async$mix_$___GT_t_cljs$core$async35442(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta35443){
return (new cljs.core.async.t_cljs$core$async35442(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta35443));
});

}

return (new cljs.core.async.t_cljs$core$async35442(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__34736__auto___37053 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34737__auto__ = (function (){var switch__34700__auto__ = (function (state_35546){
var state_val_35547 = (state_35546[(1)]);
if((state_val_35547 === (7))){
var inst_35461 = (state_35546[(2)]);
var state_35546__$1 = state_35546;
var statearr_35548_37054 = state_35546__$1;
(statearr_35548_37054[(2)] = inst_35461);

(statearr_35548_37054[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (20))){
var inst_35473 = (state_35546[(7)]);
var state_35546__$1 = state_35546;
var statearr_35549_37055 = state_35546__$1;
(statearr_35549_37055[(2)] = inst_35473);

(statearr_35549_37055[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (27))){
var state_35546__$1 = state_35546;
var statearr_35550_37056 = state_35546__$1;
(statearr_35550_37056[(2)] = null);

(statearr_35550_37056[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (1))){
var inst_35448 = (state_35546[(8)]);
var inst_35448__$1 = calc_state();
var inst_35450 = (inst_35448__$1 == null);
var inst_35451 = cljs.core.not(inst_35450);
var state_35546__$1 = (function (){var statearr_35551 = state_35546;
(statearr_35551[(8)] = inst_35448__$1);

return statearr_35551;
})();
if(inst_35451){
var statearr_35552_37057 = state_35546__$1;
(statearr_35552_37057[(1)] = (2));

} else {
var statearr_35553_37058 = state_35546__$1;
(statearr_35553_37058[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (24))){
var inst_35506 = (state_35546[(9)]);
var inst_35520 = (state_35546[(10)]);
var inst_35497 = (state_35546[(11)]);
var inst_35520__$1 = (inst_35497.cljs$core$IFn$_invoke$arity$1 ? inst_35497.cljs$core$IFn$_invoke$arity$1(inst_35506) : inst_35497.call(null,inst_35506));
var state_35546__$1 = (function (){var statearr_35554 = state_35546;
(statearr_35554[(10)] = inst_35520__$1);

return statearr_35554;
})();
if(cljs.core.truth_(inst_35520__$1)){
var statearr_35555_37059 = state_35546__$1;
(statearr_35555_37059[(1)] = (29));

} else {
var statearr_35556_37060 = state_35546__$1;
(statearr_35556_37060[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (4))){
var inst_35464 = (state_35546[(2)]);
var state_35546__$1 = state_35546;
if(cljs.core.truth_(inst_35464)){
var statearr_35557_37061 = state_35546__$1;
(statearr_35557_37061[(1)] = (8));

} else {
var statearr_35558_37062 = state_35546__$1;
(statearr_35558_37062[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (15))){
var inst_35491 = (state_35546[(2)]);
var state_35546__$1 = state_35546;
if(cljs.core.truth_(inst_35491)){
var statearr_35559_37063 = state_35546__$1;
(statearr_35559_37063[(1)] = (19));

} else {
var statearr_35560_37064 = state_35546__$1;
(statearr_35560_37064[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (21))){
var inst_35496 = (state_35546[(12)]);
var inst_35496__$1 = (state_35546[(2)]);
var inst_35497 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35496__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_35498 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35496__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_35499 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35496__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_35546__$1 = (function (){var statearr_35561 = state_35546;
(statearr_35561[(12)] = inst_35496__$1);

(statearr_35561[(11)] = inst_35497);

(statearr_35561[(13)] = inst_35498);

return statearr_35561;
})();
return cljs.core.async.ioc_alts_BANG_(state_35546__$1,(22),inst_35499);
} else {
if((state_val_35547 === (31))){
var inst_35528 = (state_35546[(2)]);
var state_35546__$1 = state_35546;
if(cljs.core.truth_(inst_35528)){
var statearr_35562_37065 = state_35546__$1;
(statearr_35562_37065[(1)] = (32));

} else {
var statearr_35563_37066 = state_35546__$1;
(statearr_35563_37066[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (32))){
var inst_35505 = (state_35546[(14)]);
var state_35546__$1 = state_35546;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35546__$1,(35),out,inst_35505);
} else {
if((state_val_35547 === (33))){
var inst_35496 = (state_35546[(12)]);
var inst_35473 = inst_35496;
var state_35546__$1 = (function (){var statearr_35564 = state_35546;
(statearr_35564[(7)] = inst_35473);

return statearr_35564;
})();
var statearr_35565_37067 = state_35546__$1;
(statearr_35565_37067[(2)] = null);

(statearr_35565_37067[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (13))){
var inst_35473 = (state_35546[(7)]);
var inst_35480 = inst_35473.cljs$lang$protocol_mask$partition0$;
var inst_35481 = (inst_35480 & (64));
var inst_35482 = inst_35473.cljs$core$ISeq$;
var inst_35483 = (cljs.core.PROTOCOL_SENTINEL === inst_35482);
var inst_35484 = ((inst_35481) || (inst_35483));
var state_35546__$1 = state_35546;
if(cljs.core.truth_(inst_35484)){
var statearr_35566_37068 = state_35546__$1;
(statearr_35566_37068[(1)] = (16));

} else {
var statearr_35567_37069 = state_35546__$1;
(statearr_35567_37069[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (22))){
var inst_35506 = (state_35546[(9)]);
var inst_35505 = (state_35546[(14)]);
var inst_35504 = (state_35546[(2)]);
var inst_35505__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35504,(0),null);
var inst_35506__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35504,(1),null);
var inst_35507 = (inst_35505__$1 == null);
var inst_35508 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_35506__$1,change);
var inst_35509 = ((inst_35507) || (inst_35508));
var state_35546__$1 = (function (){var statearr_35568 = state_35546;
(statearr_35568[(9)] = inst_35506__$1);

(statearr_35568[(14)] = inst_35505__$1);

return statearr_35568;
})();
if(cljs.core.truth_(inst_35509)){
var statearr_35569_37070 = state_35546__$1;
(statearr_35569_37070[(1)] = (23));

} else {
var statearr_35570_37071 = state_35546__$1;
(statearr_35570_37071[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (36))){
var inst_35496 = (state_35546[(12)]);
var inst_35473 = inst_35496;
var state_35546__$1 = (function (){var statearr_35571 = state_35546;
(statearr_35571[(7)] = inst_35473);

return statearr_35571;
})();
var statearr_35572_37072 = state_35546__$1;
(statearr_35572_37072[(2)] = null);

(statearr_35572_37072[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (29))){
var inst_35520 = (state_35546[(10)]);
var state_35546__$1 = state_35546;
var statearr_35573_37073 = state_35546__$1;
(statearr_35573_37073[(2)] = inst_35520);

(statearr_35573_37073[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (6))){
var state_35546__$1 = state_35546;
var statearr_35574_37074 = state_35546__$1;
(statearr_35574_37074[(2)] = false);

(statearr_35574_37074[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (28))){
var inst_35516 = (state_35546[(2)]);
var inst_35517 = calc_state();
var inst_35473 = inst_35517;
var state_35546__$1 = (function (){var statearr_35575 = state_35546;
(statearr_35575[(15)] = inst_35516);

(statearr_35575[(7)] = inst_35473);

return statearr_35575;
})();
var statearr_35576_37075 = state_35546__$1;
(statearr_35576_37075[(2)] = null);

(statearr_35576_37075[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (25))){
var inst_35542 = (state_35546[(2)]);
var state_35546__$1 = state_35546;
var statearr_35577_37077 = state_35546__$1;
(statearr_35577_37077[(2)] = inst_35542);

(statearr_35577_37077[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (34))){
var inst_35540 = (state_35546[(2)]);
var state_35546__$1 = state_35546;
var statearr_35578_37081 = state_35546__$1;
(statearr_35578_37081[(2)] = inst_35540);

(statearr_35578_37081[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (17))){
var state_35546__$1 = state_35546;
var statearr_35579_37083 = state_35546__$1;
(statearr_35579_37083[(2)] = false);

(statearr_35579_37083[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (3))){
var state_35546__$1 = state_35546;
var statearr_35580_37107 = state_35546__$1;
(statearr_35580_37107[(2)] = false);

(statearr_35580_37107[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (12))){
var inst_35544 = (state_35546[(2)]);
var state_35546__$1 = state_35546;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35546__$1,inst_35544);
} else {
if((state_val_35547 === (2))){
var inst_35448 = (state_35546[(8)]);
var inst_35453 = inst_35448.cljs$lang$protocol_mask$partition0$;
var inst_35454 = (inst_35453 & (64));
var inst_35455 = inst_35448.cljs$core$ISeq$;
var inst_35456 = (cljs.core.PROTOCOL_SENTINEL === inst_35455);
var inst_35457 = ((inst_35454) || (inst_35456));
var state_35546__$1 = state_35546;
if(cljs.core.truth_(inst_35457)){
var statearr_35581_37124 = state_35546__$1;
(statearr_35581_37124[(1)] = (5));

} else {
var statearr_35582_37125 = state_35546__$1;
(statearr_35582_37125[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (23))){
var inst_35505 = (state_35546[(14)]);
var inst_35511 = (inst_35505 == null);
var state_35546__$1 = state_35546;
if(cljs.core.truth_(inst_35511)){
var statearr_35583_37126 = state_35546__$1;
(statearr_35583_37126[(1)] = (26));

} else {
var statearr_35584_37127 = state_35546__$1;
(statearr_35584_37127[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (35))){
var inst_35531 = (state_35546[(2)]);
var state_35546__$1 = state_35546;
if(cljs.core.truth_(inst_35531)){
var statearr_35585_37128 = state_35546__$1;
(statearr_35585_37128[(1)] = (36));

} else {
var statearr_35586_37129 = state_35546__$1;
(statearr_35586_37129[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (19))){
var inst_35473 = (state_35546[(7)]);
var inst_35493 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_35473);
var state_35546__$1 = state_35546;
var statearr_35587_37130 = state_35546__$1;
(statearr_35587_37130[(2)] = inst_35493);

(statearr_35587_37130[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (11))){
var inst_35473 = (state_35546[(7)]);
var inst_35477 = (inst_35473 == null);
var inst_35478 = cljs.core.not(inst_35477);
var state_35546__$1 = state_35546;
if(inst_35478){
var statearr_35588_37131 = state_35546__$1;
(statearr_35588_37131[(1)] = (13));

} else {
var statearr_35589_37132 = state_35546__$1;
(statearr_35589_37132[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (9))){
var inst_35448 = (state_35546[(8)]);
var state_35546__$1 = state_35546;
var statearr_35590_37133 = state_35546__$1;
(statearr_35590_37133[(2)] = inst_35448);

(statearr_35590_37133[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (5))){
var state_35546__$1 = state_35546;
var statearr_35591_37134 = state_35546__$1;
(statearr_35591_37134[(2)] = true);

(statearr_35591_37134[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (14))){
var state_35546__$1 = state_35546;
var statearr_35592_37135 = state_35546__$1;
(statearr_35592_37135[(2)] = false);

(statearr_35592_37135[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (26))){
var inst_35506 = (state_35546[(9)]);
var inst_35513 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_35506);
var state_35546__$1 = state_35546;
var statearr_35593_37136 = state_35546__$1;
(statearr_35593_37136[(2)] = inst_35513);

(statearr_35593_37136[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (16))){
var state_35546__$1 = state_35546;
var statearr_35594_37137 = state_35546__$1;
(statearr_35594_37137[(2)] = true);

(statearr_35594_37137[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (38))){
var inst_35536 = (state_35546[(2)]);
var state_35546__$1 = state_35546;
var statearr_35595_37138 = state_35546__$1;
(statearr_35595_37138[(2)] = inst_35536);

(statearr_35595_37138[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (30))){
var inst_35506 = (state_35546[(9)]);
var inst_35497 = (state_35546[(11)]);
var inst_35498 = (state_35546[(13)]);
var inst_35523 = cljs.core.empty_QMARK_(inst_35497);
var inst_35524 = (inst_35498.cljs$core$IFn$_invoke$arity$1 ? inst_35498.cljs$core$IFn$_invoke$arity$1(inst_35506) : inst_35498.call(null,inst_35506));
var inst_35525 = cljs.core.not(inst_35524);
var inst_35526 = ((inst_35523) && (inst_35525));
var state_35546__$1 = state_35546;
var statearr_35596_37139 = state_35546__$1;
(statearr_35596_37139[(2)] = inst_35526);

(statearr_35596_37139[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (10))){
var inst_35448 = (state_35546[(8)]);
var inst_35469 = (state_35546[(2)]);
var inst_35470 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35469,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_35471 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35469,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_35472 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35469,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_35473 = inst_35448;
var state_35546__$1 = (function (){var statearr_35597 = state_35546;
(statearr_35597[(16)] = inst_35470);

(statearr_35597[(17)] = inst_35472);

(statearr_35597[(18)] = inst_35471);

(statearr_35597[(7)] = inst_35473);

return statearr_35597;
})();
var statearr_35598_37140 = state_35546__$1;
(statearr_35598_37140[(2)] = null);

(statearr_35598_37140[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (18))){
var inst_35488 = (state_35546[(2)]);
var state_35546__$1 = state_35546;
var statearr_35599_37141 = state_35546__$1;
(statearr_35599_37141[(2)] = inst_35488);

(statearr_35599_37141[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (37))){
var state_35546__$1 = state_35546;
var statearr_35600_37142 = state_35546__$1;
(statearr_35600_37142[(2)] = null);

(statearr_35600_37142[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35547 === (8))){
var inst_35448 = (state_35546[(8)]);
var inst_35466 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_35448);
var state_35546__$1 = state_35546;
var statearr_35601_37143 = state_35546__$1;
(statearr_35601_37143[(2)] = inst_35466);

(statearr_35601_37143[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__34701__auto__ = null;
var cljs$core$async$mix_$_state_machine__34701__auto____0 = (function (){
var statearr_35602 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35602[(0)] = cljs$core$async$mix_$_state_machine__34701__auto__);

(statearr_35602[(1)] = (1));

return statearr_35602;
});
var cljs$core$async$mix_$_state_machine__34701__auto____1 = (function (state_35546){
while(true){
var ret_value__34702__auto__ = (function (){try{while(true){
var result__34703__auto__ = switch__34700__auto__(state_35546);
if(cljs.core.keyword_identical_QMARK_(result__34703__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34703__auto__;
}
break;
}
}catch (e35603){var ex__34704__auto__ = e35603;
var statearr_35604_37144 = state_35546;
(statearr_35604_37144[(2)] = ex__34704__auto__);


if(cljs.core.seq((state_35546[(4)]))){
var statearr_35605_37145 = state_35546;
(statearr_35605_37145[(1)] = cljs.core.first((state_35546[(4)])));

} else {
throw ex__34704__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34702__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37146 = state_35546;
state_35546 = G__37146;
continue;
} else {
return ret_value__34702__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__34701__auto__ = function(state_35546){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__34701__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__34701__auto____1.call(this,state_35546);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__34701__auto____0;
cljs$core$async$mix_$_state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__34701__auto____1;
return cljs$core$async$mix_$_state_machine__34701__auto__;
})()
})();
var state__34738__auto__ = (function (){var statearr_35606 = f__34737__auto__();
(statearr_35606[(6)] = c__34736__auto___37053);

return statearr_35606;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34738__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_37147 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_37147(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_37148 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_37148(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_37149 = (function() {
var G__37150 = null;
var G__37150__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__37150__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__37150 = function(p,v){
switch(arguments.length){
case 1:
return G__37150__1.call(this,p);
case 2:
return G__37150__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37150.cljs$core$IFn$_invoke$arity$1 = G__37150__1;
G__37150.cljs$core$IFn$_invoke$arity$2 = G__37150__2;
return G__37150;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__35608 = arguments.length;
switch (G__35608) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_37149(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_37149(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__35611 = arguments.length;
switch (G__35611) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__35609_SHARP_){
if(cljs.core.truth_((p1__35609_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__35609_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__35609_SHARP_.call(null,topic)))){
return p1__35609_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__35609_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async35612 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35612 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta35613){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta35613 = meta35613;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async35612.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35614,meta35613__$1){
var self__ = this;
var _35614__$1 = this;
return (new cljs.core.async.t_cljs$core$async35612(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta35613__$1));
}));

(cljs.core.async.t_cljs$core$async35612.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35614){
var self__ = this;
var _35614__$1 = this;
return self__.meta35613;
}));

(cljs.core.async.t_cljs$core$async35612.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async35612.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async35612.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async35612.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async35612.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async35612.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async35612.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async35612.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta35613","meta35613",-536138059,null)], null);
}));

(cljs.core.async.t_cljs$core$async35612.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async35612.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35612");

(cljs.core.async.t_cljs$core$async35612.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async35612");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async35612.
 */
cljs.core.async.__GT_t_cljs$core$async35612 = (function cljs$core$async$__GT_t_cljs$core$async35612(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta35613){
return (new cljs.core.async.t_cljs$core$async35612(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta35613));
});

}

return (new cljs.core.async.t_cljs$core$async35612(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__34736__auto___37230 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34737__auto__ = (function (){var switch__34700__auto__ = (function (state_35686){
var state_val_35687 = (state_35686[(1)]);
if((state_val_35687 === (7))){
var inst_35682 = (state_35686[(2)]);
var state_35686__$1 = state_35686;
var statearr_35688_37231 = state_35686__$1;
(statearr_35688_37231[(2)] = inst_35682);

(statearr_35688_37231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35687 === (20))){
var state_35686__$1 = state_35686;
var statearr_35689_37232 = state_35686__$1;
(statearr_35689_37232[(2)] = null);

(statearr_35689_37232[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35687 === (1))){
var state_35686__$1 = state_35686;
var statearr_35690_37233 = state_35686__$1;
(statearr_35690_37233[(2)] = null);

(statearr_35690_37233[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35687 === (24))){
var inst_35665 = (state_35686[(7)]);
var inst_35674 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_35665);
var state_35686__$1 = state_35686;
var statearr_35691_37234 = state_35686__$1;
(statearr_35691_37234[(2)] = inst_35674);

(statearr_35691_37234[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35687 === (4))){
var inst_35617 = (state_35686[(8)]);
var inst_35617__$1 = (state_35686[(2)]);
var inst_35618 = (inst_35617__$1 == null);
var state_35686__$1 = (function (){var statearr_35692 = state_35686;
(statearr_35692[(8)] = inst_35617__$1);

return statearr_35692;
})();
if(cljs.core.truth_(inst_35618)){
var statearr_35693_37235 = state_35686__$1;
(statearr_35693_37235[(1)] = (5));

} else {
var statearr_35694_37236 = state_35686__$1;
(statearr_35694_37236[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35687 === (15))){
var inst_35659 = (state_35686[(2)]);
var state_35686__$1 = state_35686;
var statearr_35695_37237 = state_35686__$1;
(statearr_35695_37237[(2)] = inst_35659);

(statearr_35695_37237[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35687 === (21))){
var inst_35679 = (state_35686[(2)]);
var state_35686__$1 = (function (){var statearr_35696 = state_35686;
(statearr_35696[(9)] = inst_35679);

return statearr_35696;
})();
var statearr_35697_37238 = state_35686__$1;
(statearr_35697_37238[(2)] = null);

(statearr_35697_37238[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35687 === (13))){
var inst_35641 = (state_35686[(10)]);
var inst_35643 = cljs.core.chunked_seq_QMARK_(inst_35641);
var state_35686__$1 = state_35686;
if(inst_35643){
var statearr_35698_37239 = state_35686__$1;
(statearr_35698_37239[(1)] = (16));

} else {
var statearr_35699_37240 = state_35686__$1;
(statearr_35699_37240[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35687 === (22))){
var inst_35671 = (state_35686[(2)]);
var state_35686__$1 = state_35686;
if(cljs.core.truth_(inst_35671)){
var statearr_35700_37241 = state_35686__$1;
(statearr_35700_37241[(1)] = (23));

} else {
var statearr_35701_37242 = state_35686__$1;
(statearr_35701_37242[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35687 === (6))){
var inst_35667 = (state_35686[(11)]);
var inst_35617 = (state_35686[(8)]);
var inst_35665 = (state_35686[(7)]);
var inst_35665__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_35617) : topic_fn.call(null,inst_35617));
var inst_35666 = cljs.core.deref(mults);
var inst_35667__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35666,inst_35665__$1);
var state_35686__$1 = (function (){var statearr_35702 = state_35686;
(statearr_35702[(11)] = inst_35667__$1);

(statearr_35702[(7)] = inst_35665__$1);

return statearr_35702;
})();
if(cljs.core.truth_(inst_35667__$1)){
var statearr_35703_37243 = state_35686__$1;
(statearr_35703_37243[(1)] = (19));

} else {
var statearr_35704_37244 = state_35686__$1;
(statearr_35704_37244[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35687 === (25))){
var inst_35676 = (state_35686[(2)]);
var state_35686__$1 = state_35686;
var statearr_35705_37245 = state_35686__$1;
(statearr_35705_37245[(2)] = inst_35676);

(statearr_35705_37245[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35687 === (17))){
var inst_35641 = (state_35686[(10)]);
var inst_35650 = cljs.core.first(inst_35641);
var inst_35651 = cljs.core.async.muxch_STAR_(inst_35650);
var inst_35652 = cljs.core.async.close_BANG_(inst_35651);
var inst_35653 = cljs.core.next(inst_35641);
var inst_35627 = inst_35653;
var inst_35628 = null;
var inst_35629 = (0);
var inst_35630 = (0);
var state_35686__$1 = (function (){var statearr_35706 = state_35686;
(statearr_35706[(12)] = inst_35629);

(statearr_35706[(13)] = inst_35627);

(statearr_35706[(14)] = inst_35652);

(statearr_35706[(15)] = inst_35630);

(statearr_35706[(16)] = inst_35628);

return statearr_35706;
})();
var statearr_35707_37246 = state_35686__$1;
(statearr_35707_37246[(2)] = null);

(statearr_35707_37246[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35687 === (3))){
var inst_35684 = (state_35686[(2)]);
var state_35686__$1 = state_35686;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35686__$1,inst_35684);
} else {
if((state_val_35687 === (12))){
var inst_35661 = (state_35686[(2)]);
var state_35686__$1 = state_35686;
var statearr_35708_37248 = state_35686__$1;
(statearr_35708_37248[(2)] = inst_35661);

(statearr_35708_37248[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35687 === (2))){
var state_35686__$1 = state_35686;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35686__$1,(4),ch);
} else {
if((state_val_35687 === (23))){
var state_35686__$1 = state_35686;
var statearr_35709_37253 = state_35686__$1;
(statearr_35709_37253[(2)] = null);

(statearr_35709_37253[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35687 === (19))){
var inst_35667 = (state_35686[(11)]);
var inst_35617 = (state_35686[(8)]);
var inst_35669 = cljs.core.async.muxch_STAR_(inst_35667);
var state_35686__$1 = state_35686;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35686__$1,(22),inst_35669,inst_35617);
} else {
if((state_val_35687 === (11))){
var inst_35641 = (state_35686[(10)]);
var inst_35627 = (state_35686[(13)]);
var inst_35641__$1 = cljs.core.seq(inst_35627);
var state_35686__$1 = (function (){var statearr_35710 = state_35686;
(statearr_35710[(10)] = inst_35641__$1);

return statearr_35710;
})();
if(inst_35641__$1){
var statearr_35711_37280 = state_35686__$1;
(statearr_35711_37280[(1)] = (13));

} else {
var statearr_35712_37285 = state_35686__$1;
(statearr_35712_37285[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35687 === (9))){
var inst_35663 = (state_35686[(2)]);
var state_35686__$1 = state_35686;
var statearr_35713_37294 = state_35686__$1;
(statearr_35713_37294[(2)] = inst_35663);

(statearr_35713_37294[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35687 === (5))){
var inst_35624 = cljs.core.deref(mults);
var inst_35625 = cljs.core.vals(inst_35624);
var inst_35626 = cljs.core.seq(inst_35625);
var inst_35627 = inst_35626;
var inst_35628 = null;
var inst_35629 = (0);
var inst_35630 = (0);
var state_35686__$1 = (function (){var statearr_35714 = state_35686;
(statearr_35714[(12)] = inst_35629);

(statearr_35714[(13)] = inst_35627);

(statearr_35714[(15)] = inst_35630);

(statearr_35714[(16)] = inst_35628);

return statearr_35714;
})();
var statearr_35715_37321 = state_35686__$1;
(statearr_35715_37321[(2)] = null);

(statearr_35715_37321[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35687 === (14))){
var state_35686__$1 = state_35686;
var statearr_35719_37326 = state_35686__$1;
(statearr_35719_37326[(2)] = null);

(statearr_35719_37326[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35687 === (16))){
var inst_35641 = (state_35686[(10)]);
var inst_35645 = cljs.core.chunk_first(inst_35641);
var inst_35646 = cljs.core.chunk_rest(inst_35641);
var inst_35647 = cljs.core.count(inst_35645);
var inst_35627 = inst_35646;
var inst_35628 = inst_35645;
var inst_35629 = inst_35647;
var inst_35630 = (0);
var state_35686__$1 = (function (){var statearr_35720 = state_35686;
(statearr_35720[(12)] = inst_35629);

(statearr_35720[(13)] = inst_35627);

(statearr_35720[(15)] = inst_35630);

(statearr_35720[(16)] = inst_35628);

return statearr_35720;
})();
var statearr_35721_37331 = state_35686__$1;
(statearr_35721_37331[(2)] = null);

(statearr_35721_37331[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35687 === (10))){
var inst_35629 = (state_35686[(12)]);
var inst_35627 = (state_35686[(13)]);
var inst_35630 = (state_35686[(15)]);
var inst_35628 = (state_35686[(16)]);
var inst_35635 = cljs.core._nth(inst_35628,inst_35630);
var inst_35636 = cljs.core.async.muxch_STAR_(inst_35635);
var inst_35637 = cljs.core.async.close_BANG_(inst_35636);
var inst_35638 = (inst_35630 + (1));
var tmp35716 = inst_35629;
var tmp35717 = inst_35627;
var tmp35718 = inst_35628;
var inst_35627__$1 = tmp35717;
var inst_35628__$1 = tmp35718;
var inst_35629__$1 = tmp35716;
var inst_35630__$1 = inst_35638;
var state_35686__$1 = (function (){var statearr_35722 = state_35686;
(statearr_35722[(12)] = inst_35629__$1);

(statearr_35722[(13)] = inst_35627__$1);

(statearr_35722[(17)] = inst_35637);

(statearr_35722[(15)] = inst_35630__$1);

(statearr_35722[(16)] = inst_35628__$1);

return statearr_35722;
})();
var statearr_35723_37332 = state_35686__$1;
(statearr_35723_37332[(2)] = null);

(statearr_35723_37332[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35687 === (18))){
var inst_35656 = (state_35686[(2)]);
var state_35686__$1 = state_35686;
var statearr_35724_37333 = state_35686__$1;
(statearr_35724_37333[(2)] = inst_35656);

(statearr_35724_37333[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35687 === (8))){
var inst_35629 = (state_35686[(12)]);
var inst_35630 = (state_35686[(15)]);
var inst_35632 = (inst_35630 < inst_35629);
var inst_35633 = inst_35632;
var state_35686__$1 = state_35686;
if(cljs.core.truth_(inst_35633)){
var statearr_35725_37334 = state_35686__$1;
(statearr_35725_37334[(1)] = (10));

} else {
var statearr_35726_37335 = state_35686__$1;
(statearr_35726_37335[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__34701__auto__ = null;
var cljs$core$async$state_machine__34701__auto____0 = (function (){
var statearr_35727 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35727[(0)] = cljs$core$async$state_machine__34701__auto__);

(statearr_35727[(1)] = (1));

return statearr_35727;
});
var cljs$core$async$state_machine__34701__auto____1 = (function (state_35686){
while(true){
var ret_value__34702__auto__ = (function (){try{while(true){
var result__34703__auto__ = switch__34700__auto__(state_35686);
if(cljs.core.keyword_identical_QMARK_(result__34703__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34703__auto__;
}
break;
}
}catch (e35728){var ex__34704__auto__ = e35728;
var statearr_35729_37336 = state_35686;
(statearr_35729_37336[(2)] = ex__34704__auto__);


if(cljs.core.seq((state_35686[(4)]))){
var statearr_35730_37337 = state_35686;
(statearr_35730_37337[(1)] = cljs.core.first((state_35686[(4)])));

} else {
throw ex__34704__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34702__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37338 = state_35686;
state_35686 = G__37338;
continue;
} else {
return ret_value__34702__auto__;
}
break;
}
});
cljs$core$async$state_machine__34701__auto__ = function(state_35686){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__34701__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__34701__auto____1.call(this,state_35686);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__34701__auto____0;
cljs$core$async$state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__34701__auto____1;
return cljs$core$async$state_machine__34701__auto__;
})()
})();
var state__34738__auto__ = (function (){var statearr_35731 = f__34737__auto__();
(statearr_35731[(6)] = c__34736__auto___37230);

return statearr_35731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34738__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__35733 = arguments.length;
switch (G__35733) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__35735 = arguments.length;
switch (G__35735) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__35737 = arguments.length;
switch (G__35737) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__34736__auto___37342 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34737__auto__ = (function (){var switch__34700__auto__ = (function (state_35780){
var state_val_35781 = (state_35780[(1)]);
if((state_val_35781 === (7))){
var state_35780__$1 = state_35780;
var statearr_35782_37343 = state_35780__$1;
(statearr_35782_37343[(2)] = null);

(statearr_35782_37343[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35781 === (1))){
var state_35780__$1 = state_35780;
var statearr_35783_37344 = state_35780__$1;
(statearr_35783_37344[(2)] = null);

(statearr_35783_37344[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35781 === (4))){
var inst_35740 = (state_35780[(7)]);
var inst_35741 = (state_35780[(8)]);
var inst_35743 = (inst_35741 < inst_35740);
var state_35780__$1 = state_35780;
if(cljs.core.truth_(inst_35743)){
var statearr_35784_37345 = state_35780__$1;
(statearr_35784_37345[(1)] = (6));

} else {
var statearr_35785_37346 = state_35780__$1;
(statearr_35785_37346[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35781 === (15))){
var inst_35766 = (state_35780[(9)]);
var inst_35771 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_35766);
var state_35780__$1 = state_35780;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35780__$1,(17),out,inst_35771);
} else {
if((state_val_35781 === (13))){
var inst_35766 = (state_35780[(9)]);
var inst_35766__$1 = (state_35780[(2)]);
var inst_35767 = cljs.core.some(cljs.core.nil_QMARK_,inst_35766__$1);
var state_35780__$1 = (function (){var statearr_35786 = state_35780;
(statearr_35786[(9)] = inst_35766__$1);

return statearr_35786;
})();
if(cljs.core.truth_(inst_35767)){
var statearr_35787_37347 = state_35780__$1;
(statearr_35787_37347[(1)] = (14));

} else {
var statearr_35788_37348 = state_35780__$1;
(statearr_35788_37348[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35781 === (6))){
var state_35780__$1 = state_35780;
var statearr_35789_37349 = state_35780__$1;
(statearr_35789_37349[(2)] = null);

(statearr_35789_37349[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35781 === (17))){
var inst_35773 = (state_35780[(2)]);
var state_35780__$1 = (function (){var statearr_35791 = state_35780;
(statearr_35791[(10)] = inst_35773);

return statearr_35791;
})();
var statearr_35792_37350 = state_35780__$1;
(statearr_35792_37350[(2)] = null);

(statearr_35792_37350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35781 === (3))){
var inst_35778 = (state_35780[(2)]);
var state_35780__$1 = state_35780;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35780__$1,inst_35778);
} else {
if((state_val_35781 === (12))){
var _ = (function (){var statearr_35793 = state_35780;
(statearr_35793[(4)] = cljs.core.rest((state_35780[(4)])));

return statearr_35793;
})();
var state_35780__$1 = state_35780;
var ex35790 = (state_35780__$1[(2)]);
var statearr_35794_37351 = state_35780__$1;
(statearr_35794_37351[(5)] = ex35790);


if((ex35790 instanceof Object)){
var statearr_35795_37352 = state_35780__$1;
(statearr_35795_37352[(1)] = (11));

(statearr_35795_37352[(5)] = null);

} else {
throw ex35790;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35781 === (2))){
var inst_35739 = cljs.core.reset_BANG_(dctr,cnt);
var inst_35740 = cnt;
var inst_35741 = (0);
var state_35780__$1 = (function (){var statearr_35796 = state_35780;
(statearr_35796[(11)] = inst_35739);

(statearr_35796[(7)] = inst_35740);

(statearr_35796[(8)] = inst_35741);

return statearr_35796;
})();
var statearr_35797_37353 = state_35780__$1;
(statearr_35797_37353[(2)] = null);

(statearr_35797_37353[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35781 === (11))){
var inst_35745 = (state_35780[(2)]);
var inst_35746 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_35780__$1 = (function (){var statearr_35798 = state_35780;
(statearr_35798[(12)] = inst_35745);

return statearr_35798;
})();
var statearr_35799_37354 = state_35780__$1;
(statearr_35799_37354[(2)] = inst_35746);

(statearr_35799_37354[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35781 === (9))){
var inst_35741 = (state_35780[(8)]);
var _ = (function (){var statearr_35800 = state_35780;
(statearr_35800[(4)] = cljs.core.cons((12),(state_35780[(4)])));

return statearr_35800;
})();
var inst_35752 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_35741) : chs__$1.call(null,inst_35741));
var inst_35753 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_35741) : done.call(null,inst_35741));
var inst_35754 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_35752,inst_35753);
var ___$1 = (function (){var statearr_35801 = state_35780;
(statearr_35801[(4)] = cljs.core.rest((state_35780[(4)])));

return statearr_35801;
})();
var state_35780__$1 = state_35780;
var statearr_35802_37355 = state_35780__$1;
(statearr_35802_37355[(2)] = inst_35754);

(statearr_35802_37355[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35781 === (5))){
var inst_35764 = (state_35780[(2)]);
var state_35780__$1 = (function (){var statearr_35803 = state_35780;
(statearr_35803[(13)] = inst_35764);

return statearr_35803;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35780__$1,(13),dchan);
} else {
if((state_val_35781 === (14))){
var inst_35769 = cljs.core.async.close_BANG_(out);
var state_35780__$1 = state_35780;
var statearr_35804_37356 = state_35780__$1;
(statearr_35804_37356[(2)] = inst_35769);

(statearr_35804_37356[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35781 === (16))){
var inst_35776 = (state_35780[(2)]);
var state_35780__$1 = state_35780;
var statearr_35805_37357 = state_35780__$1;
(statearr_35805_37357[(2)] = inst_35776);

(statearr_35805_37357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35781 === (10))){
var inst_35741 = (state_35780[(8)]);
var inst_35757 = (state_35780[(2)]);
var inst_35758 = (inst_35741 + (1));
var inst_35741__$1 = inst_35758;
var state_35780__$1 = (function (){var statearr_35806 = state_35780;
(statearr_35806[(14)] = inst_35757);

(statearr_35806[(8)] = inst_35741__$1);

return statearr_35806;
})();
var statearr_35807_37358 = state_35780__$1;
(statearr_35807_37358[(2)] = null);

(statearr_35807_37358[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35781 === (8))){
var inst_35762 = (state_35780[(2)]);
var state_35780__$1 = state_35780;
var statearr_35808_37359 = state_35780__$1;
(statearr_35808_37359[(2)] = inst_35762);

(statearr_35808_37359[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__34701__auto__ = null;
var cljs$core$async$state_machine__34701__auto____0 = (function (){
var statearr_35809 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35809[(0)] = cljs$core$async$state_machine__34701__auto__);

(statearr_35809[(1)] = (1));

return statearr_35809;
});
var cljs$core$async$state_machine__34701__auto____1 = (function (state_35780){
while(true){
var ret_value__34702__auto__ = (function (){try{while(true){
var result__34703__auto__ = switch__34700__auto__(state_35780);
if(cljs.core.keyword_identical_QMARK_(result__34703__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34703__auto__;
}
break;
}
}catch (e35810){var ex__34704__auto__ = e35810;
var statearr_35811_37360 = state_35780;
(statearr_35811_37360[(2)] = ex__34704__auto__);


if(cljs.core.seq((state_35780[(4)]))){
var statearr_35812_37361 = state_35780;
(statearr_35812_37361[(1)] = cljs.core.first((state_35780[(4)])));

} else {
throw ex__34704__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34702__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37362 = state_35780;
state_35780 = G__37362;
continue;
} else {
return ret_value__34702__auto__;
}
break;
}
});
cljs$core$async$state_machine__34701__auto__ = function(state_35780){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__34701__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__34701__auto____1.call(this,state_35780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__34701__auto____0;
cljs$core$async$state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__34701__auto____1;
return cljs$core$async$state_machine__34701__auto__;
})()
})();
var state__34738__auto__ = (function (){var statearr_35813 = f__34737__auto__();
(statearr_35813[(6)] = c__34736__auto___37342);

return statearr_35813;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34738__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__35816 = arguments.length;
switch (G__35816) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__34736__auto___37364 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34737__auto__ = (function (){var switch__34700__auto__ = (function (state_35848){
var state_val_35849 = (state_35848[(1)]);
if((state_val_35849 === (7))){
var inst_35828 = (state_35848[(7)]);
var inst_35827 = (state_35848[(8)]);
var inst_35827__$1 = (state_35848[(2)]);
var inst_35828__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35827__$1,(0),null);
var inst_35829 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35827__$1,(1),null);
var inst_35830 = (inst_35828__$1 == null);
var state_35848__$1 = (function (){var statearr_35850 = state_35848;
(statearr_35850[(9)] = inst_35829);

(statearr_35850[(7)] = inst_35828__$1);

(statearr_35850[(8)] = inst_35827__$1);

return statearr_35850;
})();
if(cljs.core.truth_(inst_35830)){
var statearr_35851_37365 = state_35848__$1;
(statearr_35851_37365[(1)] = (8));

} else {
var statearr_35852_37366 = state_35848__$1;
(statearr_35852_37366[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35849 === (1))){
var inst_35817 = cljs.core.vec(chs);
var inst_35818 = inst_35817;
var state_35848__$1 = (function (){var statearr_35853 = state_35848;
(statearr_35853[(10)] = inst_35818);

return statearr_35853;
})();
var statearr_35854_37367 = state_35848__$1;
(statearr_35854_37367[(2)] = null);

(statearr_35854_37367[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35849 === (4))){
var inst_35818 = (state_35848[(10)]);
var state_35848__$1 = state_35848;
return cljs.core.async.ioc_alts_BANG_(state_35848__$1,(7),inst_35818);
} else {
if((state_val_35849 === (6))){
var inst_35844 = (state_35848[(2)]);
var state_35848__$1 = state_35848;
var statearr_35855_37368 = state_35848__$1;
(statearr_35855_37368[(2)] = inst_35844);

(statearr_35855_37368[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35849 === (3))){
var inst_35846 = (state_35848[(2)]);
var state_35848__$1 = state_35848;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35848__$1,inst_35846);
} else {
if((state_val_35849 === (2))){
var inst_35818 = (state_35848[(10)]);
var inst_35820 = cljs.core.count(inst_35818);
var inst_35821 = (inst_35820 > (0));
var state_35848__$1 = state_35848;
if(cljs.core.truth_(inst_35821)){
var statearr_35857_37369 = state_35848__$1;
(statearr_35857_37369[(1)] = (4));

} else {
var statearr_35858_37370 = state_35848__$1;
(statearr_35858_37370[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35849 === (11))){
var inst_35818 = (state_35848[(10)]);
var inst_35837 = (state_35848[(2)]);
var tmp35856 = inst_35818;
var inst_35818__$1 = tmp35856;
var state_35848__$1 = (function (){var statearr_35859 = state_35848;
(statearr_35859[(10)] = inst_35818__$1);

(statearr_35859[(11)] = inst_35837);

return statearr_35859;
})();
var statearr_35860_37371 = state_35848__$1;
(statearr_35860_37371[(2)] = null);

(statearr_35860_37371[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35849 === (9))){
var inst_35828 = (state_35848[(7)]);
var state_35848__$1 = state_35848;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35848__$1,(11),out,inst_35828);
} else {
if((state_val_35849 === (5))){
var inst_35842 = cljs.core.async.close_BANG_(out);
var state_35848__$1 = state_35848;
var statearr_35861_37373 = state_35848__$1;
(statearr_35861_37373[(2)] = inst_35842);

(statearr_35861_37373[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35849 === (10))){
var inst_35840 = (state_35848[(2)]);
var state_35848__$1 = state_35848;
var statearr_35862_37374 = state_35848__$1;
(statearr_35862_37374[(2)] = inst_35840);

(statearr_35862_37374[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35849 === (8))){
var inst_35818 = (state_35848[(10)]);
var inst_35829 = (state_35848[(9)]);
var inst_35828 = (state_35848[(7)]);
var inst_35827 = (state_35848[(8)]);
var inst_35832 = (function (){var cs = inst_35818;
var vec__35823 = inst_35827;
var v = inst_35828;
var c = inst_35829;
return (function (p1__35814_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__35814_SHARP_);
});
})();
var inst_35833 = cljs.core.filterv(inst_35832,inst_35818);
var inst_35818__$1 = inst_35833;
var state_35848__$1 = (function (){var statearr_35863 = state_35848;
(statearr_35863[(10)] = inst_35818__$1);

return statearr_35863;
})();
var statearr_35864_37375 = state_35848__$1;
(statearr_35864_37375[(2)] = null);

(statearr_35864_37375[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__34701__auto__ = null;
var cljs$core$async$state_machine__34701__auto____0 = (function (){
var statearr_35865 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35865[(0)] = cljs$core$async$state_machine__34701__auto__);

(statearr_35865[(1)] = (1));

return statearr_35865;
});
var cljs$core$async$state_machine__34701__auto____1 = (function (state_35848){
while(true){
var ret_value__34702__auto__ = (function (){try{while(true){
var result__34703__auto__ = switch__34700__auto__(state_35848);
if(cljs.core.keyword_identical_QMARK_(result__34703__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34703__auto__;
}
break;
}
}catch (e35866){var ex__34704__auto__ = e35866;
var statearr_35867_37376 = state_35848;
(statearr_35867_37376[(2)] = ex__34704__auto__);


if(cljs.core.seq((state_35848[(4)]))){
var statearr_35868_37377 = state_35848;
(statearr_35868_37377[(1)] = cljs.core.first((state_35848[(4)])));

} else {
throw ex__34704__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34702__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37378 = state_35848;
state_35848 = G__37378;
continue;
} else {
return ret_value__34702__auto__;
}
break;
}
});
cljs$core$async$state_machine__34701__auto__ = function(state_35848){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__34701__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__34701__auto____1.call(this,state_35848);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__34701__auto____0;
cljs$core$async$state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__34701__auto____1;
return cljs$core$async$state_machine__34701__auto__;
})()
})();
var state__34738__auto__ = (function (){var statearr_35869 = f__34737__auto__();
(statearr_35869[(6)] = c__34736__auto___37364);

return statearr_35869;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34738__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__35871 = arguments.length;
switch (G__35871) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__34736__auto___37382 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34737__auto__ = (function (){var switch__34700__auto__ = (function (state_35895){
var state_val_35896 = (state_35895[(1)]);
if((state_val_35896 === (7))){
var inst_35877 = (state_35895[(7)]);
var inst_35877__$1 = (state_35895[(2)]);
var inst_35878 = (inst_35877__$1 == null);
var inst_35879 = cljs.core.not(inst_35878);
var state_35895__$1 = (function (){var statearr_35897 = state_35895;
(statearr_35897[(7)] = inst_35877__$1);

return statearr_35897;
})();
if(inst_35879){
var statearr_35898_37385 = state_35895__$1;
(statearr_35898_37385[(1)] = (8));

} else {
var statearr_35899_37386 = state_35895__$1;
(statearr_35899_37386[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35896 === (1))){
var inst_35872 = (0);
var state_35895__$1 = (function (){var statearr_35900 = state_35895;
(statearr_35900[(8)] = inst_35872);

return statearr_35900;
})();
var statearr_35901_37387 = state_35895__$1;
(statearr_35901_37387[(2)] = null);

(statearr_35901_37387[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35896 === (4))){
var state_35895__$1 = state_35895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35895__$1,(7),ch);
} else {
if((state_val_35896 === (6))){
var inst_35890 = (state_35895[(2)]);
var state_35895__$1 = state_35895;
var statearr_35902_37389 = state_35895__$1;
(statearr_35902_37389[(2)] = inst_35890);

(statearr_35902_37389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35896 === (3))){
var inst_35892 = (state_35895[(2)]);
var inst_35893 = cljs.core.async.close_BANG_(out);
var state_35895__$1 = (function (){var statearr_35903 = state_35895;
(statearr_35903[(9)] = inst_35892);

return statearr_35903;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_35895__$1,inst_35893);
} else {
if((state_val_35896 === (2))){
var inst_35872 = (state_35895[(8)]);
var inst_35874 = (inst_35872 < n);
var state_35895__$1 = state_35895;
if(cljs.core.truth_(inst_35874)){
var statearr_35904_37390 = state_35895__$1;
(statearr_35904_37390[(1)] = (4));

} else {
var statearr_35905_37391 = state_35895__$1;
(statearr_35905_37391[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35896 === (11))){
var inst_35872 = (state_35895[(8)]);
var inst_35882 = (state_35895[(2)]);
var inst_35883 = (inst_35872 + (1));
var inst_35872__$1 = inst_35883;
var state_35895__$1 = (function (){var statearr_35906 = state_35895;
(statearr_35906[(8)] = inst_35872__$1);

(statearr_35906[(10)] = inst_35882);

return statearr_35906;
})();
var statearr_35907_37392 = state_35895__$1;
(statearr_35907_37392[(2)] = null);

(statearr_35907_37392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35896 === (9))){
var state_35895__$1 = state_35895;
var statearr_35908_37393 = state_35895__$1;
(statearr_35908_37393[(2)] = null);

(statearr_35908_37393[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35896 === (5))){
var state_35895__$1 = state_35895;
var statearr_35909_37394 = state_35895__$1;
(statearr_35909_37394[(2)] = null);

(statearr_35909_37394[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35896 === (10))){
var inst_35887 = (state_35895[(2)]);
var state_35895__$1 = state_35895;
var statearr_35910_37395 = state_35895__$1;
(statearr_35910_37395[(2)] = inst_35887);

(statearr_35910_37395[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35896 === (8))){
var inst_35877 = (state_35895[(7)]);
var state_35895__$1 = state_35895;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35895__$1,(11),out,inst_35877);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__34701__auto__ = null;
var cljs$core$async$state_machine__34701__auto____0 = (function (){
var statearr_35911 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35911[(0)] = cljs$core$async$state_machine__34701__auto__);

(statearr_35911[(1)] = (1));

return statearr_35911;
});
var cljs$core$async$state_machine__34701__auto____1 = (function (state_35895){
while(true){
var ret_value__34702__auto__ = (function (){try{while(true){
var result__34703__auto__ = switch__34700__auto__(state_35895);
if(cljs.core.keyword_identical_QMARK_(result__34703__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34703__auto__;
}
break;
}
}catch (e35912){var ex__34704__auto__ = e35912;
var statearr_35913_37396 = state_35895;
(statearr_35913_37396[(2)] = ex__34704__auto__);


if(cljs.core.seq((state_35895[(4)]))){
var statearr_35914_37397 = state_35895;
(statearr_35914_37397[(1)] = cljs.core.first((state_35895[(4)])));

} else {
throw ex__34704__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34702__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37398 = state_35895;
state_35895 = G__37398;
continue;
} else {
return ret_value__34702__auto__;
}
break;
}
});
cljs$core$async$state_machine__34701__auto__ = function(state_35895){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__34701__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__34701__auto____1.call(this,state_35895);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__34701__auto____0;
cljs$core$async$state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__34701__auto____1;
return cljs$core$async$state_machine__34701__auto__;
})()
})();
var state__34738__auto__ = (function (){var statearr_35915 = f__34737__auto__();
(statearr_35915[(6)] = c__34736__auto___37382);

return statearr_35915;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34738__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async35917 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35917 = (function (f,ch,meta35918){
this.f = f;
this.ch = ch;
this.meta35918 = meta35918;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async35917.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35919,meta35918__$1){
var self__ = this;
var _35919__$1 = this;
return (new cljs.core.async.t_cljs$core$async35917(self__.f,self__.ch,meta35918__$1));
}));

(cljs.core.async.t_cljs$core$async35917.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35919){
var self__ = this;
var _35919__$1 = this;
return self__.meta35918;
}));

(cljs.core.async.t_cljs$core$async35917.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async35917.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async35917.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async35917.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async35917.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async35920 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35920 = (function (f,ch,meta35918,_,fn1,meta35921){
this.f = f;
this.ch = ch;
this.meta35918 = meta35918;
this._ = _;
this.fn1 = fn1;
this.meta35921 = meta35921;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async35920.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35922,meta35921__$1){
var self__ = this;
var _35922__$1 = this;
return (new cljs.core.async.t_cljs$core$async35920(self__.f,self__.ch,self__.meta35918,self__._,self__.fn1,meta35921__$1));
}));

(cljs.core.async.t_cljs$core$async35920.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35922){
var self__ = this;
var _35922__$1 = this;
return self__.meta35921;
}));

(cljs.core.async.t_cljs$core$async35920.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async35920.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async35920.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async35920.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__35916_SHARP_){
var G__35923 = (((p1__35916_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__35916_SHARP_) : self__.f.call(null,p1__35916_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__35923) : f1.call(null,G__35923));
});
}));

(cljs.core.async.t_cljs$core$async35920.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta35918","meta35918",-1906266949,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async35917","cljs.core.async/t_cljs$core$async35917",1142828966,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta35921","meta35921",-1626385516,null)], null);
}));

(cljs.core.async.t_cljs$core$async35920.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async35920.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35920");

(cljs.core.async.t_cljs$core$async35920.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async35920");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async35920.
 */
cljs.core.async.__GT_t_cljs$core$async35920 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async35920(f__$1,ch__$1,meta35918__$1,___$2,fn1__$1,meta35921){
return (new cljs.core.async.t_cljs$core$async35920(f__$1,ch__$1,meta35918__$1,___$2,fn1__$1,meta35921));
});

}

return (new cljs.core.async.t_cljs$core$async35920(self__.f,self__.ch,self__.meta35918,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__35924 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__35924) : self__.f.call(null,G__35924));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async35917.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async35917.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async35917.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta35918","meta35918",-1906266949,null)], null);
}));

(cljs.core.async.t_cljs$core$async35917.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async35917.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35917");

(cljs.core.async.t_cljs$core$async35917.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async35917");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async35917.
 */
cljs.core.async.__GT_t_cljs$core$async35917 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async35917(f__$1,ch__$1,meta35918){
return (new cljs.core.async.t_cljs$core$async35917(f__$1,ch__$1,meta35918));
});

}

return (new cljs.core.async.t_cljs$core$async35917(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async35925 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35925 = (function (f,ch,meta35926){
this.f = f;
this.ch = ch;
this.meta35926 = meta35926;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async35925.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35927,meta35926__$1){
var self__ = this;
var _35927__$1 = this;
return (new cljs.core.async.t_cljs$core$async35925(self__.f,self__.ch,meta35926__$1));
}));

(cljs.core.async.t_cljs$core$async35925.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35927){
var self__ = this;
var _35927__$1 = this;
return self__.meta35926;
}));

(cljs.core.async.t_cljs$core$async35925.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async35925.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async35925.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async35925.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async35925.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async35925.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async35925.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta35926","meta35926",-414464790,null)], null);
}));

(cljs.core.async.t_cljs$core$async35925.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async35925.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35925");

(cljs.core.async.t_cljs$core$async35925.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async35925");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async35925.
 */
cljs.core.async.__GT_t_cljs$core$async35925 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async35925(f__$1,ch__$1,meta35926){
return (new cljs.core.async.t_cljs$core$async35925(f__$1,ch__$1,meta35926));
});

}

return (new cljs.core.async.t_cljs$core$async35925(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async35928 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35928 = (function (p,ch,meta35929){
this.p = p;
this.ch = ch;
this.meta35929 = meta35929;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async35928.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35930,meta35929__$1){
var self__ = this;
var _35930__$1 = this;
return (new cljs.core.async.t_cljs$core$async35928(self__.p,self__.ch,meta35929__$1));
}));

(cljs.core.async.t_cljs$core$async35928.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35930){
var self__ = this;
var _35930__$1 = this;
return self__.meta35929;
}));

(cljs.core.async.t_cljs$core$async35928.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async35928.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async35928.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async35928.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async35928.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async35928.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async35928.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async35928.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta35929","meta35929",-1550647858,null)], null);
}));

(cljs.core.async.t_cljs$core$async35928.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async35928.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35928");

(cljs.core.async.t_cljs$core$async35928.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async35928");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async35928.
 */
cljs.core.async.__GT_t_cljs$core$async35928 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async35928(p__$1,ch__$1,meta35929){
return (new cljs.core.async.t_cljs$core$async35928(p__$1,ch__$1,meta35929));
});

}

return (new cljs.core.async.t_cljs$core$async35928(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__35932 = arguments.length;
switch (G__35932) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__34736__auto___37400 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34737__auto__ = (function (){var switch__34700__auto__ = (function (state_35953){
var state_val_35954 = (state_35953[(1)]);
if((state_val_35954 === (7))){
var inst_35949 = (state_35953[(2)]);
var state_35953__$1 = state_35953;
var statearr_35955_37401 = state_35953__$1;
(statearr_35955_37401[(2)] = inst_35949);

(statearr_35955_37401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35954 === (1))){
var state_35953__$1 = state_35953;
var statearr_35956_37402 = state_35953__$1;
(statearr_35956_37402[(2)] = null);

(statearr_35956_37402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35954 === (4))){
var inst_35935 = (state_35953[(7)]);
var inst_35935__$1 = (state_35953[(2)]);
var inst_35936 = (inst_35935__$1 == null);
var state_35953__$1 = (function (){var statearr_35957 = state_35953;
(statearr_35957[(7)] = inst_35935__$1);

return statearr_35957;
})();
if(cljs.core.truth_(inst_35936)){
var statearr_35958_37403 = state_35953__$1;
(statearr_35958_37403[(1)] = (5));

} else {
var statearr_35959_37404 = state_35953__$1;
(statearr_35959_37404[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35954 === (6))){
var inst_35935 = (state_35953[(7)]);
var inst_35940 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_35935) : p.call(null,inst_35935));
var state_35953__$1 = state_35953;
if(cljs.core.truth_(inst_35940)){
var statearr_35960_37405 = state_35953__$1;
(statearr_35960_37405[(1)] = (8));

} else {
var statearr_35961_37406 = state_35953__$1;
(statearr_35961_37406[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35954 === (3))){
var inst_35951 = (state_35953[(2)]);
var state_35953__$1 = state_35953;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35953__$1,inst_35951);
} else {
if((state_val_35954 === (2))){
var state_35953__$1 = state_35953;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35953__$1,(4),ch);
} else {
if((state_val_35954 === (11))){
var inst_35943 = (state_35953[(2)]);
var state_35953__$1 = state_35953;
var statearr_35962_37407 = state_35953__$1;
(statearr_35962_37407[(2)] = inst_35943);

(statearr_35962_37407[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35954 === (9))){
var state_35953__$1 = state_35953;
var statearr_35963_37411 = state_35953__$1;
(statearr_35963_37411[(2)] = null);

(statearr_35963_37411[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35954 === (5))){
var inst_35938 = cljs.core.async.close_BANG_(out);
var state_35953__$1 = state_35953;
var statearr_35964_37414 = state_35953__$1;
(statearr_35964_37414[(2)] = inst_35938);

(statearr_35964_37414[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35954 === (10))){
var inst_35946 = (state_35953[(2)]);
var state_35953__$1 = (function (){var statearr_35965 = state_35953;
(statearr_35965[(8)] = inst_35946);

return statearr_35965;
})();
var statearr_35966_37418 = state_35953__$1;
(statearr_35966_37418[(2)] = null);

(statearr_35966_37418[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35954 === (8))){
var inst_35935 = (state_35953[(7)]);
var state_35953__$1 = state_35953;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35953__$1,(11),out,inst_35935);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__34701__auto__ = null;
var cljs$core$async$state_machine__34701__auto____0 = (function (){
var statearr_35967 = [null,null,null,null,null,null,null,null,null];
(statearr_35967[(0)] = cljs$core$async$state_machine__34701__auto__);

(statearr_35967[(1)] = (1));

return statearr_35967;
});
var cljs$core$async$state_machine__34701__auto____1 = (function (state_35953){
while(true){
var ret_value__34702__auto__ = (function (){try{while(true){
var result__34703__auto__ = switch__34700__auto__(state_35953);
if(cljs.core.keyword_identical_QMARK_(result__34703__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34703__auto__;
}
break;
}
}catch (e35968){var ex__34704__auto__ = e35968;
var statearr_35969_37433 = state_35953;
(statearr_35969_37433[(2)] = ex__34704__auto__);


if(cljs.core.seq((state_35953[(4)]))){
var statearr_35970_37435 = state_35953;
(statearr_35970_37435[(1)] = cljs.core.first((state_35953[(4)])));

} else {
throw ex__34704__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34702__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37436 = state_35953;
state_35953 = G__37436;
continue;
} else {
return ret_value__34702__auto__;
}
break;
}
});
cljs$core$async$state_machine__34701__auto__ = function(state_35953){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__34701__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__34701__auto____1.call(this,state_35953);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__34701__auto____0;
cljs$core$async$state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__34701__auto____1;
return cljs$core$async$state_machine__34701__auto__;
})()
})();
var state__34738__auto__ = (function (){var statearr_35971 = f__34737__auto__();
(statearr_35971[(6)] = c__34736__auto___37400);

return statearr_35971;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34738__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__35973 = arguments.length;
switch (G__35973) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__34736__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34737__auto__ = (function (){var switch__34700__auto__ = (function (state_36035){
var state_val_36036 = (state_36035[(1)]);
if((state_val_36036 === (7))){
var inst_36031 = (state_36035[(2)]);
var state_36035__$1 = state_36035;
var statearr_36037_37451 = state_36035__$1;
(statearr_36037_37451[(2)] = inst_36031);

(statearr_36037_37451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36036 === (20))){
var inst_36001 = (state_36035[(7)]);
var inst_36012 = (state_36035[(2)]);
var inst_36013 = cljs.core.next(inst_36001);
var inst_35987 = inst_36013;
var inst_35988 = null;
var inst_35989 = (0);
var inst_35990 = (0);
var state_36035__$1 = (function (){var statearr_36038 = state_36035;
(statearr_36038[(8)] = inst_36012);

(statearr_36038[(9)] = inst_35989);

(statearr_36038[(10)] = inst_35987);

(statearr_36038[(11)] = inst_35988);

(statearr_36038[(12)] = inst_35990);

return statearr_36038;
})();
var statearr_36039_37491 = state_36035__$1;
(statearr_36039_37491[(2)] = null);

(statearr_36039_37491[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36036 === (1))){
var state_36035__$1 = state_36035;
var statearr_36040_37492 = state_36035__$1;
(statearr_36040_37492[(2)] = null);

(statearr_36040_37492[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36036 === (4))){
var inst_35976 = (state_36035[(13)]);
var inst_35976__$1 = (state_36035[(2)]);
var inst_35977 = (inst_35976__$1 == null);
var state_36035__$1 = (function (){var statearr_36041 = state_36035;
(statearr_36041[(13)] = inst_35976__$1);

return statearr_36041;
})();
if(cljs.core.truth_(inst_35977)){
var statearr_36042_37493 = state_36035__$1;
(statearr_36042_37493[(1)] = (5));

} else {
var statearr_36043_37494 = state_36035__$1;
(statearr_36043_37494[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36036 === (15))){
var state_36035__$1 = state_36035;
var statearr_36047_37495 = state_36035__$1;
(statearr_36047_37495[(2)] = null);

(statearr_36047_37495[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36036 === (21))){
var state_36035__$1 = state_36035;
var statearr_36048_37496 = state_36035__$1;
(statearr_36048_37496[(2)] = null);

(statearr_36048_37496[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36036 === (13))){
var inst_35989 = (state_36035[(9)]);
var inst_35987 = (state_36035[(10)]);
var inst_35988 = (state_36035[(11)]);
var inst_35990 = (state_36035[(12)]);
var inst_35997 = (state_36035[(2)]);
var inst_35998 = (inst_35990 + (1));
var tmp36044 = inst_35989;
var tmp36045 = inst_35987;
var tmp36046 = inst_35988;
var inst_35987__$1 = tmp36045;
var inst_35988__$1 = tmp36046;
var inst_35989__$1 = tmp36044;
var inst_35990__$1 = inst_35998;
var state_36035__$1 = (function (){var statearr_36049 = state_36035;
(statearr_36049[(9)] = inst_35989__$1);

(statearr_36049[(14)] = inst_35997);

(statearr_36049[(10)] = inst_35987__$1);

(statearr_36049[(11)] = inst_35988__$1);

(statearr_36049[(12)] = inst_35990__$1);

return statearr_36049;
})();
var statearr_36050_37497 = state_36035__$1;
(statearr_36050_37497[(2)] = null);

(statearr_36050_37497[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36036 === (22))){
var state_36035__$1 = state_36035;
var statearr_36051_37498 = state_36035__$1;
(statearr_36051_37498[(2)] = null);

(statearr_36051_37498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36036 === (6))){
var inst_35976 = (state_36035[(13)]);
var inst_35985 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_35976) : f.call(null,inst_35976));
var inst_35986 = cljs.core.seq(inst_35985);
var inst_35987 = inst_35986;
var inst_35988 = null;
var inst_35989 = (0);
var inst_35990 = (0);
var state_36035__$1 = (function (){var statearr_36052 = state_36035;
(statearr_36052[(9)] = inst_35989);

(statearr_36052[(10)] = inst_35987);

(statearr_36052[(11)] = inst_35988);

(statearr_36052[(12)] = inst_35990);

return statearr_36052;
})();
var statearr_36053_37499 = state_36035__$1;
(statearr_36053_37499[(2)] = null);

(statearr_36053_37499[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36036 === (17))){
var inst_36001 = (state_36035[(7)]);
var inst_36005 = cljs.core.chunk_first(inst_36001);
var inst_36006 = cljs.core.chunk_rest(inst_36001);
var inst_36007 = cljs.core.count(inst_36005);
var inst_35987 = inst_36006;
var inst_35988 = inst_36005;
var inst_35989 = inst_36007;
var inst_35990 = (0);
var state_36035__$1 = (function (){var statearr_36054 = state_36035;
(statearr_36054[(9)] = inst_35989);

(statearr_36054[(10)] = inst_35987);

(statearr_36054[(11)] = inst_35988);

(statearr_36054[(12)] = inst_35990);

return statearr_36054;
})();
var statearr_36055_37500 = state_36035__$1;
(statearr_36055_37500[(2)] = null);

(statearr_36055_37500[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36036 === (3))){
var inst_36033 = (state_36035[(2)]);
var state_36035__$1 = state_36035;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36035__$1,inst_36033);
} else {
if((state_val_36036 === (12))){
var inst_36021 = (state_36035[(2)]);
var state_36035__$1 = state_36035;
var statearr_36056_37501 = state_36035__$1;
(statearr_36056_37501[(2)] = inst_36021);

(statearr_36056_37501[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36036 === (2))){
var state_36035__$1 = state_36035;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36035__$1,(4),in$);
} else {
if((state_val_36036 === (23))){
var inst_36029 = (state_36035[(2)]);
var state_36035__$1 = state_36035;
var statearr_36057_37502 = state_36035__$1;
(statearr_36057_37502[(2)] = inst_36029);

(statearr_36057_37502[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36036 === (19))){
var inst_36016 = (state_36035[(2)]);
var state_36035__$1 = state_36035;
var statearr_36058_37503 = state_36035__$1;
(statearr_36058_37503[(2)] = inst_36016);

(statearr_36058_37503[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36036 === (11))){
var inst_36001 = (state_36035[(7)]);
var inst_35987 = (state_36035[(10)]);
var inst_36001__$1 = cljs.core.seq(inst_35987);
var state_36035__$1 = (function (){var statearr_36059 = state_36035;
(statearr_36059[(7)] = inst_36001__$1);

return statearr_36059;
})();
if(inst_36001__$1){
var statearr_36060_37504 = state_36035__$1;
(statearr_36060_37504[(1)] = (14));

} else {
var statearr_36061_37505 = state_36035__$1;
(statearr_36061_37505[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36036 === (9))){
var inst_36023 = (state_36035[(2)]);
var inst_36024 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_36035__$1 = (function (){var statearr_36062 = state_36035;
(statearr_36062[(15)] = inst_36023);

return statearr_36062;
})();
if(cljs.core.truth_(inst_36024)){
var statearr_36063_37506 = state_36035__$1;
(statearr_36063_37506[(1)] = (21));

} else {
var statearr_36064_37507 = state_36035__$1;
(statearr_36064_37507[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36036 === (5))){
var inst_35979 = cljs.core.async.close_BANG_(out);
var state_36035__$1 = state_36035;
var statearr_36065_37508 = state_36035__$1;
(statearr_36065_37508[(2)] = inst_35979);

(statearr_36065_37508[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36036 === (14))){
var inst_36001 = (state_36035[(7)]);
var inst_36003 = cljs.core.chunked_seq_QMARK_(inst_36001);
var state_36035__$1 = state_36035;
if(inst_36003){
var statearr_36066_37509 = state_36035__$1;
(statearr_36066_37509[(1)] = (17));

} else {
var statearr_36067_37510 = state_36035__$1;
(statearr_36067_37510[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36036 === (16))){
var inst_36019 = (state_36035[(2)]);
var state_36035__$1 = state_36035;
var statearr_36068_37511 = state_36035__$1;
(statearr_36068_37511[(2)] = inst_36019);

(statearr_36068_37511[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36036 === (10))){
var inst_35988 = (state_36035[(11)]);
var inst_35990 = (state_36035[(12)]);
var inst_35995 = cljs.core._nth(inst_35988,inst_35990);
var state_36035__$1 = state_36035;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36035__$1,(13),out,inst_35995);
} else {
if((state_val_36036 === (18))){
var inst_36001 = (state_36035[(7)]);
var inst_36010 = cljs.core.first(inst_36001);
var state_36035__$1 = state_36035;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36035__$1,(20),out,inst_36010);
} else {
if((state_val_36036 === (8))){
var inst_35989 = (state_36035[(9)]);
var inst_35990 = (state_36035[(12)]);
var inst_35992 = (inst_35990 < inst_35989);
var inst_35993 = inst_35992;
var state_36035__$1 = state_36035;
if(cljs.core.truth_(inst_35993)){
var statearr_36069_37512 = state_36035__$1;
(statearr_36069_37512[(1)] = (10));

} else {
var statearr_36070_37513 = state_36035__$1;
(statearr_36070_37513[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__34701__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__34701__auto____0 = (function (){
var statearr_36071 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36071[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__34701__auto__);

(statearr_36071[(1)] = (1));

return statearr_36071;
});
var cljs$core$async$mapcat_STAR__$_state_machine__34701__auto____1 = (function (state_36035){
while(true){
var ret_value__34702__auto__ = (function (){try{while(true){
var result__34703__auto__ = switch__34700__auto__(state_36035);
if(cljs.core.keyword_identical_QMARK_(result__34703__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34703__auto__;
}
break;
}
}catch (e36072){var ex__34704__auto__ = e36072;
var statearr_36073_37514 = state_36035;
(statearr_36073_37514[(2)] = ex__34704__auto__);


if(cljs.core.seq((state_36035[(4)]))){
var statearr_36074_37515 = state_36035;
(statearr_36074_37515[(1)] = cljs.core.first((state_36035[(4)])));

} else {
throw ex__34704__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34702__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37592 = state_36035;
state_36035 = G__37592;
continue;
} else {
return ret_value__34702__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__34701__auto__ = function(state_36035){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__34701__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__34701__auto____1.call(this,state_36035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__34701__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__34701__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__34701__auto__;
})()
})();
var state__34738__auto__ = (function (){var statearr_36075 = f__34737__auto__();
(statearr_36075[(6)] = c__34736__auto__);

return statearr_36075;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34738__auto__);
}));

return c__34736__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__36077 = arguments.length;
switch (G__36077) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__36079 = arguments.length;
switch (G__36079) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__36081 = arguments.length;
switch (G__36081) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__34736__auto___37602 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34737__auto__ = (function (){var switch__34700__auto__ = (function (state_36105){
var state_val_36106 = (state_36105[(1)]);
if((state_val_36106 === (7))){
var inst_36100 = (state_36105[(2)]);
var state_36105__$1 = state_36105;
var statearr_36107_37603 = state_36105__$1;
(statearr_36107_37603[(2)] = inst_36100);

(statearr_36107_37603[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36106 === (1))){
var inst_36082 = null;
var state_36105__$1 = (function (){var statearr_36108 = state_36105;
(statearr_36108[(7)] = inst_36082);

return statearr_36108;
})();
var statearr_36109_37604 = state_36105__$1;
(statearr_36109_37604[(2)] = null);

(statearr_36109_37604[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36106 === (4))){
var inst_36085 = (state_36105[(8)]);
var inst_36085__$1 = (state_36105[(2)]);
var inst_36086 = (inst_36085__$1 == null);
var inst_36087 = cljs.core.not(inst_36086);
var state_36105__$1 = (function (){var statearr_36110 = state_36105;
(statearr_36110[(8)] = inst_36085__$1);

return statearr_36110;
})();
if(inst_36087){
var statearr_36111_37605 = state_36105__$1;
(statearr_36111_37605[(1)] = (5));

} else {
var statearr_36112_37606 = state_36105__$1;
(statearr_36112_37606[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36106 === (6))){
var state_36105__$1 = state_36105;
var statearr_36113_37607 = state_36105__$1;
(statearr_36113_37607[(2)] = null);

(statearr_36113_37607[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36106 === (3))){
var inst_36102 = (state_36105[(2)]);
var inst_36103 = cljs.core.async.close_BANG_(out);
var state_36105__$1 = (function (){var statearr_36114 = state_36105;
(statearr_36114[(9)] = inst_36102);

return statearr_36114;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_36105__$1,inst_36103);
} else {
if((state_val_36106 === (2))){
var state_36105__$1 = state_36105;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36105__$1,(4),ch);
} else {
if((state_val_36106 === (11))){
var inst_36085 = (state_36105[(8)]);
var inst_36094 = (state_36105[(2)]);
var inst_36082 = inst_36085;
var state_36105__$1 = (function (){var statearr_36115 = state_36105;
(statearr_36115[(7)] = inst_36082);

(statearr_36115[(10)] = inst_36094);

return statearr_36115;
})();
var statearr_36116_37608 = state_36105__$1;
(statearr_36116_37608[(2)] = null);

(statearr_36116_37608[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36106 === (9))){
var inst_36085 = (state_36105[(8)]);
var state_36105__$1 = state_36105;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36105__$1,(11),out,inst_36085);
} else {
if((state_val_36106 === (5))){
var inst_36082 = (state_36105[(7)]);
var inst_36085 = (state_36105[(8)]);
var inst_36089 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_36085,inst_36082);
var state_36105__$1 = state_36105;
if(inst_36089){
var statearr_36118_37609 = state_36105__$1;
(statearr_36118_37609[(1)] = (8));

} else {
var statearr_36119_37610 = state_36105__$1;
(statearr_36119_37610[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36106 === (10))){
var inst_36097 = (state_36105[(2)]);
var state_36105__$1 = state_36105;
var statearr_36120_37611 = state_36105__$1;
(statearr_36120_37611[(2)] = inst_36097);

(statearr_36120_37611[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36106 === (8))){
var inst_36082 = (state_36105[(7)]);
var tmp36117 = inst_36082;
var inst_36082__$1 = tmp36117;
var state_36105__$1 = (function (){var statearr_36121 = state_36105;
(statearr_36121[(7)] = inst_36082__$1);

return statearr_36121;
})();
var statearr_36122_37612 = state_36105__$1;
(statearr_36122_37612[(2)] = null);

(statearr_36122_37612[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__34701__auto__ = null;
var cljs$core$async$state_machine__34701__auto____0 = (function (){
var statearr_36123 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_36123[(0)] = cljs$core$async$state_machine__34701__auto__);

(statearr_36123[(1)] = (1));

return statearr_36123;
});
var cljs$core$async$state_machine__34701__auto____1 = (function (state_36105){
while(true){
var ret_value__34702__auto__ = (function (){try{while(true){
var result__34703__auto__ = switch__34700__auto__(state_36105);
if(cljs.core.keyword_identical_QMARK_(result__34703__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34703__auto__;
}
break;
}
}catch (e36124){var ex__34704__auto__ = e36124;
var statearr_36125_37614 = state_36105;
(statearr_36125_37614[(2)] = ex__34704__auto__);


if(cljs.core.seq((state_36105[(4)]))){
var statearr_36126_37615 = state_36105;
(statearr_36126_37615[(1)] = cljs.core.first((state_36105[(4)])));

} else {
throw ex__34704__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34702__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37616 = state_36105;
state_36105 = G__37616;
continue;
} else {
return ret_value__34702__auto__;
}
break;
}
});
cljs$core$async$state_machine__34701__auto__ = function(state_36105){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__34701__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__34701__auto____1.call(this,state_36105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__34701__auto____0;
cljs$core$async$state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__34701__auto____1;
return cljs$core$async$state_machine__34701__auto__;
})()
})();
var state__34738__auto__ = (function (){var statearr_36127 = f__34737__auto__();
(statearr_36127[(6)] = c__34736__auto___37602);

return statearr_36127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34738__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__36129 = arguments.length;
switch (G__36129) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__34736__auto___37654 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34737__auto__ = (function (){var switch__34700__auto__ = (function (state_36167){
var state_val_36168 = (state_36167[(1)]);
if((state_val_36168 === (7))){
var inst_36163 = (state_36167[(2)]);
var state_36167__$1 = state_36167;
var statearr_36169_37669 = state_36167__$1;
(statearr_36169_37669[(2)] = inst_36163);

(statearr_36169_37669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36168 === (1))){
var inst_36130 = (new Array(n));
var inst_36131 = inst_36130;
var inst_36132 = (0);
var state_36167__$1 = (function (){var statearr_36170 = state_36167;
(statearr_36170[(7)] = inst_36132);

(statearr_36170[(8)] = inst_36131);

return statearr_36170;
})();
var statearr_36171_37686 = state_36167__$1;
(statearr_36171_37686[(2)] = null);

(statearr_36171_37686[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36168 === (4))){
var inst_36135 = (state_36167[(9)]);
var inst_36135__$1 = (state_36167[(2)]);
var inst_36136 = (inst_36135__$1 == null);
var inst_36137 = cljs.core.not(inst_36136);
var state_36167__$1 = (function (){var statearr_36172 = state_36167;
(statearr_36172[(9)] = inst_36135__$1);

return statearr_36172;
})();
if(inst_36137){
var statearr_36173_37699 = state_36167__$1;
(statearr_36173_37699[(1)] = (5));

} else {
var statearr_36174_37700 = state_36167__$1;
(statearr_36174_37700[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36168 === (15))){
var inst_36157 = (state_36167[(2)]);
var state_36167__$1 = state_36167;
var statearr_36175_37703 = state_36167__$1;
(statearr_36175_37703[(2)] = inst_36157);

(statearr_36175_37703[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36168 === (13))){
var state_36167__$1 = state_36167;
var statearr_36176_37704 = state_36167__$1;
(statearr_36176_37704[(2)] = null);

(statearr_36176_37704[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36168 === (6))){
var inst_36132 = (state_36167[(7)]);
var inst_36153 = (inst_36132 > (0));
var state_36167__$1 = state_36167;
if(cljs.core.truth_(inst_36153)){
var statearr_36177_37705 = state_36167__$1;
(statearr_36177_37705[(1)] = (12));

} else {
var statearr_36178_37706 = state_36167__$1;
(statearr_36178_37706[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36168 === (3))){
var inst_36165 = (state_36167[(2)]);
var state_36167__$1 = state_36167;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36167__$1,inst_36165);
} else {
if((state_val_36168 === (12))){
var inst_36131 = (state_36167[(8)]);
var inst_36155 = cljs.core.vec(inst_36131);
var state_36167__$1 = state_36167;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36167__$1,(15),out,inst_36155);
} else {
if((state_val_36168 === (2))){
var state_36167__$1 = state_36167;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36167__$1,(4),ch);
} else {
if((state_val_36168 === (11))){
var inst_36147 = (state_36167[(2)]);
var inst_36148 = (new Array(n));
var inst_36131 = inst_36148;
var inst_36132 = (0);
var state_36167__$1 = (function (){var statearr_36179 = state_36167;
(statearr_36179[(10)] = inst_36147);

(statearr_36179[(7)] = inst_36132);

(statearr_36179[(8)] = inst_36131);

return statearr_36179;
})();
var statearr_36180_37707 = state_36167__$1;
(statearr_36180_37707[(2)] = null);

(statearr_36180_37707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36168 === (9))){
var inst_36131 = (state_36167[(8)]);
var inst_36145 = cljs.core.vec(inst_36131);
var state_36167__$1 = state_36167;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36167__$1,(11),out,inst_36145);
} else {
if((state_val_36168 === (5))){
var inst_36132 = (state_36167[(7)]);
var inst_36140 = (state_36167[(11)]);
var inst_36135 = (state_36167[(9)]);
var inst_36131 = (state_36167[(8)]);
var inst_36139 = (inst_36131[inst_36132] = inst_36135);
var inst_36140__$1 = (inst_36132 + (1));
var inst_36141 = (inst_36140__$1 < n);
var state_36167__$1 = (function (){var statearr_36181 = state_36167;
(statearr_36181[(12)] = inst_36139);

(statearr_36181[(11)] = inst_36140__$1);

return statearr_36181;
})();
if(cljs.core.truth_(inst_36141)){
var statearr_36182_37708 = state_36167__$1;
(statearr_36182_37708[(1)] = (8));

} else {
var statearr_36183_37709 = state_36167__$1;
(statearr_36183_37709[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36168 === (14))){
var inst_36160 = (state_36167[(2)]);
var inst_36161 = cljs.core.async.close_BANG_(out);
var state_36167__$1 = (function (){var statearr_36185 = state_36167;
(statearr_36185[(13)] = inst_36160);

return statearr_36185;
})();
var statearr_36186_37710 = state_36167__$1;
(statearr_36186_37710[(2)] = inst_36161);

(statearr_36186_37710[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36168 === (10))){
var inst_36151 = (state_36167[(2)]);
var state_36167__$1 = state_36167;
var statearr_36187_37711 = state_36167__$1;
(statearr_36187_37711[(2)] = inst_36151);

(statearr_36187_37711[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36168 === (8))){
var inst_36140 = (state_36167[(11)]);
var inst_36131 = (state_36167[(8)]);
var tmp36184 = inst_36131;
var inst_36131__$1 = tmp36184;
var inst_36132 = inst_36140;
var state_36167__$1 = (function (){var statearr_36188 = state_36167;
(statearr_36188[(7)] = inst_36132);

(statearr_36188[(8)] = inst_36131__$1);

return statearr_36188;
})();
var statearr_36189_37712 = state_36167__$1;
(statearr_36189_37712[(2)] = null);

(statearr_36189_37712[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__34701__auto__ = null;
var cljs$core$async$state_machine__34701__auto____0 = (function (){
var statearr_36190 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36190[(0)] = cljs$core$async$state_machine__34701__auto__);

(statearr_36190[(1)] = (1));

return statearr_36190;
});
var cljs$core$async$state_machine__34701__auto____1 = (function (state_36167){
while(true){
var ret_value__34702__auto__ = (function (){try{while(true){
var result__34703__auto__ = switch__34700__auto__(state_36167);
if(cljs.core.keyword_identical_QMARK_(result__34703__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34703__auto__;
}
break;
}
}catch (e36191){var ex__34704__auto__ = e36191;
var statearr_36192_37713 = state_36167;
(statearr_36192_37713[(2)] = ex__34704__auto__);


if(cljs.core.seq((state_36167[(4)]))){
var statearr_36193_37714 = state_36167;
(statearr_36193_37714[(1)] = cljs.core.first((state_36167[(4)])));

} else {
throw ex__34704__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34702__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37715 = state_36167;
state_36167 = G__37715;
continue;
} else {
return ret_value__34702__auto__;
}
break;
}
});
cljs$core$async$state_machine__34701__auto__ = function(state_36167){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__34701__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__34701__auto____1.call(this,state_36167);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__34701__auto____0;
cljs$core$async$state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__34701__auto____1;
return cljs$core$async$state_machine__34701__auto__;
})()
})();
var state__34738__auto__ = (function (){var statearr_36194 = f__34737__auto__();
(statearr_36194[(6)] = c__34736__auto___37654);

return statearr_36194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34738__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__36196 = arguments.length;
switch (G__36196) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__34736__auto___37717 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34737__auto__ = (function (){var switch__34700__auto__ = (function (state_36238){
var state_val_36239 = (state_36238[(1)]);
if((state_val_36239 === (7))){
var inst_36234 = (state_36238[(2)]);
var state_36238__$1 = state_36238;
var statearr_36240_37718 = state_36238__$1;
(statearr_36240_37718[(2)] = inst_36234);

(statearr_36240_37718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36239 === (1))){
var inst_36197 = [];
var inst_36198 = inst_36197;
var inst_36199 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_36238__$1 = (function (){var statearr_36241 = state_36238;
(statearr_36241[(7)] = inst_36199);

(statearr_36241[(8)] = inst_36198);

return statearr_36241;
})();
var statearr_36242_37719 = state_36238__$1;
(statearr_36242_37719[(2)] = null);

(statearr_36242_37719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36239 === (4))){
var inst_36202 = (state_36238[(9)]);
var inst_36202__$1 = (state_36238[(2)]);
var inst_36203 = (inst_36202__$1 == null);
var inst_36204 = cljs.core.not(inst_36203);
var state_36238__$1 = (function (){var statearr_36243 = state_36238;
(statearr_36243[(9)] = inst_36202__$1);

return statearr_36243;
})();
if(inst_36204){
var statearr_36244_37720 = state_36238__$1;
(statearr_36244_37720[(1)] = (5));

} else {
var statearr_36245_37721 = state_36238__$1;
(statearr_36245_37721[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36239 === (15))){
var inst_36228 = (state_36238[(2)]);
var state_36238__$1 = state_36238;
var statearr_36246_37722 = state_36238__$1;
(statearr_36246_37722[(2)] = inst_36228);

(statearr_36246_37722[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36239 === (13))){
var state_36238__$1 = state_36238;
var statearr_36247_37723 = state_36238__$1;
(statearr_36247_37723[(2)] = null);

(statearr_36247_37723[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36239 === (6))){
var inst_36198 = (state_36238[(8)]);
var inst_36223 = inst_36198.length;
var inst_36224 = (inst_36223 > (0));
var state_36238__$1 = state_36238;
if(cljs.core.truth_(inst_36224)){
var statearr_36248_37724 = state_36238__$1;
(statearr_36248_37724[(1)] = (12));

} else {
var statearr_36249_37725 = state_36238__$1;
(statearr_36249_37725[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36239 === (3))){
var inst_36236 = (state_36238[(2)]);
var state_36238__$1 = state_36238;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36238__$1,inst_36236);
} else {
if((state_val_36239 === (12))){
var inst_36198 = (state_36238[(8)]);
var inst_36226 = cljs.core.vec(inst_36198);
var state_36238__$1 = state_36238;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36238__$1,(15),out,inst_36226);
} else {
if((state_val_36239 === (2))){
var state_36238__$1 = state_36238;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36238__$1,(4),ch);
} else {
if((state_val_36239 === (11))){
var inst_36206 = (state_36238[(10)]);
var inst_36202 = (state_36238[(9)]);
var inst_36216 = (state_36238[(2)]);
var inst_36217 = [];
var inst_36218 = inst_36217.push(inst_36202);
var inst_36198 = inst_36217;
var inst_36199 = inst_36206;
var state_36238__$1 = (function (){var statearr_36250 = state_36238;
(statearr_36250[(11)] = inst_36216);

(statearr_36250[(12)] = inst_36218);

(statearr_36250[(7)] = inst_36199);

(statearr_36250[(8)] = inst_36198);

return statearr_36250;
})();
var statearr_36251_37726 = state_36238__$1;
(statearr_36251_37726[(2)] = null);

(statearr_36251_37726[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36239 === (9))){
var inst_36198 = (state_36238[(8)]);
var inst_36214 = cljs.core.vec(inst_36198);
var state_36238__$1 = state_36238;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36238__$1,(11),out,inst_36214);
} else {
if((state_val_36239 === (5))){
var inst_36199 = (state_36238[(7)]);
var inst_36206 = (state_36238[(10)]);
var inst_36202 = (state_36238[(9)]);
var inst_36206__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_36202) : f.call(null,inst_36202));
var inst_36207 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_36206__$1,inst_36199);
var inst_36208 = cljs.core.keyword_identical_QMARK_(inst_36199,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_36209 = ((inst_36207) || (inst_36208));
var state_36238__$1 = (function (){var statearr_36252 = state_36238;
(statearr_36252[(10)] = inst_36206__$1);

return statearr_36252;
})();
if(cljs.core.truth_(inst_36209)){
var statearr_36253_37727 = state_36238__$1;
(statearr_36253_37727[(1)] = (8));

} else {
var statearr_36254_37728 = state_36238__$1;
(statearr_36254_37728[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36239 === (14))){
var inst_36231 = (state_36238[(2)]);
var inst_36232 = cljs.core.async.close_BANG_(out);
var state_36238__$1 = (function (){var statearr_36256 = state_36238;
(statearr_36256[(13)] = inst_36231);

return statearr_36256;
})();
var statearr_36257_37729 = state_36238__$1;
(statearr_36257_37729[(2)] = inst_36232);

(statearr_36257_37729[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36239 === (10))){
var inst_36221 = (state_36238[(2)]);
var state_36238__$1 = state_36238;
var statearr_36258_37730 = state_36238__$1;
(statearr_36258_37730[(2)] = inst_36221);

(statearr_36258_37730[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36239 === (8))){
var inst_36206 = (state_36238[(10)]);
var inst_36202 = (state_36238[(9)]);
var inst_36198 = (state_36238[(8)]);
var inst_36211 = inst_36198.push(inst_36202);
var tmp36255 = inst_36198;
var inst_36198__$1 = tmp36255;
var inst_36199 = inst_36206;
var state_36238__$1 = (function (){var statearr_36259 = state_36238;
(statearr_36259[(7)] = inst_36199);

(statearr_36259[(14)] = inst_36211);

(statearr_36259[(8)] = inst_36198__$1);

return statearr_36259;
})();
var statearr_36260_37731 = state_36238__$1;
(statearr_36260_37731[(2)] = null);

(statearr_36260_37731[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__34701__auto__ = null;
var cljs$core$async$state_machine__34701__auto____0 = (function (){
var statearr_36261 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36261[(0)] = cljs$core$async$state_machine__34701__auto__);

(statearr_36261[(1)] = (1));

return statearr_36261;
});
var cljs$core$async$state_machine__34701__auto____1 = (function (state_36238){
while(true){
var ret_value__34702__auto__ = (function (){try{while(true){
var result__34703__auto__ = switch__34700__auto__(state_36238);
if(cljs.core.keyword_identical_QMARK_(result__34703__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34703__auto__;
}
break;
}
}catch (e36262){var ex__34704__auto__ = e36262;
var statearr_36263_37732 = state_36238;
(statearr_36263_37732[(2)] = ex__34704__auto__);


if(cljs.core.seq((state_36238[(4)]))){
var statearr_36264_37733 = state_36238;
(statearr_36264_37733[(1)] = cljs.core.first((state_36238[(4)])));

} else {
throw ex__34704__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34702__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37734 = state_36238;
state_36238 = G__37734;
continue;
} else {
return ret_value__34702__auto__;
}
break;
}
});
cljs$core$async$state_machine__34701__auto__ = function(state_36238){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__34701__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__34701__auto____1.call(this,state_36238);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__34701__auto____0;
cljs$core$async$state_machine__34701__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__34701__auto____1;
return cljs$core$async$state_machine__34701__auto__;
})()
})();
var state__34738__auto__ = (function (){var statearr_36265 = f__34737__auto__();
(statearr_36265[(6)] = c__34736__auto___37717);

return statearr_36265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34738__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
