goog.provide('sci.impl.interpreter');
goog.require('cljs.core');
goog.require('cljs.tools.reader.reader_types');
goog.require('sci.impl.analyzer');
goog.require('sci.impl.fns');
goog.require('sci.impl.interop');
goog.require('sci.impl.macros');
goog.require('sci.impl.max_or_throw');
goog.require('sci.impl.opts');
goog.require('sci.impl.parser');
goog.require('sci.impl.types');
goog.require('sci.impl.utils');
goog.require('sci.impl.vars');

sci.impl.interpreter.macros = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 19, [new cljs.core.Symbol(null,"macroexpand","macroexpand",1509933344,null),"null",new cljs.core.Symbol(null,"try","try",-1273693247,null),"null",new cljs.core.Symbol(null,"lazy-seq","lazy-seq",489632906,null),"null",new cljs.core.Symbol(null,"let","let",358118826,null),"null",new cljs.core.Symbol(null,"fn","fn",465265323,null),"null",new cljs.core.Symbol(null,"do","do",1686842252,null),"null",new cljs.core.Symbol(null,"in-ns","in-ns",-2089468466,null),"null",new cljs.core.Symbol(null,"defn","defn",-126010802,null),"null",new cljs.core.Symbol(null,"if","if",1181717262,null),"null",new cljs.core.Symbol(null,"or","or",1876275696,null),"null",new cljs.core.Symbol(null,"macroexpand-1","macroexpand-1",659241329,null),"null",new cljs.core.Symbol(null,"require","require",1172530194,null),"null",new cljs.core.Symbol(null,"syntax-quote","syntax-quote",407366680,null),"null",new cljs.core.Symbol(null,"set!","set!",250714521,null),"null",new cljs.core.Symbol(null,".",".",1975675962,null),"null",new cljs.core.Symbol(null,"quote","quote",1377916282,null),"null",new cljs.core.Symbol(null,"case","case",-1510733573,null),"null",new cljs.core.Symbol(null,"and","and",668631710,null),"null",new cljs.core.Symbol(null,"def","def",597100991,null),"null"], null), null);
/**
 * The and macro from clojure.core.
 */
sci.impl.interpreter.eval_and = (function sci$impl$interpreter$eval_and(ctx,args){
var args__$1 = cljs.core.seq(args);
var args__$2 = args__$1;
while(true){
if(args__$2){
var x = cljs.core.first(args__$2);
var xs = cljs.core.next(args__$2);
var v = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,x) : sci.impl.interpreter.interpret.call(null,ctx,x));
if(cljs.core.truth_(v)){
if(xs){
var G__38572 = xs;
args__$2 = G__38572;
continue;
} else {
return v;
}
} else {
return v;
}
} else {
return true;
}
break;
}
});
/**
 * The or macro from clojure.core.
 */
sci.impl.interpreter.eval_or = (function sci$impl$interpreter$eval_or(ctx,args){
var args__$1 = cljs.core.seq(args);
var args__$2 = args__$1;
while(true){
if(args__$2){
var x = cljs.core.first(args__$2);
var xs = cljs.core.next(args__$2);
var v = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,x) : sci.impl.interpreter.interpret.call(null,ctx,x));
if(cljs.core.truth_(v)){
return v;
} else {
if(xs){
var G__38573 = xs;
args__$2 = G__38573;
continue;
} else {
return v;
}
}
} else {
return null;
}
break;
}
});
/**
 * The let macro from clojure.core
 */
sci.impl.interpreter.eval_let = (function sci$impl$interpreter$eval_let(var_args){
var args__4742__auto__ = [];
var len__4736__auto___38574 = arguments.length;
var i__4737__auto___38575 = (0);
while(true){
if((i__4737__auto___38575 < len__4736__auto___38574)){
args__4742__auto__.push((arguments[i__4737__auto___38575]));

var G__38576 = (i__4737__auto___38575 + (1));
i__4737__auto___38575 = G__38576;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return sci.impl.interpreter.eval_let.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(sci.impl.interpreter.eval_let.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,let_bindings,exprs){
var ctx__$1 = (function (){var ctx__$1 = ctx;
var let_bindings__$1 = let_bindings;
while(true){
var let_name = cljs.core.first(let_bindings__$1);
var let_bindings__$2 = cljs.core.rest(let_bindings__$1);
var let_val = cljs.core.first(let_bindings__$2);
var rest_let_bindings = cljs.core.next(let_bindings__$2);
var val_tag = (function (){var temp__5735__auto__ = cljs.core.meta(let_val);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return new cljs.core.Keyword(null,"tag","tag",-1290361223).cljs$core$IFn$_invoke$arity$1(m);
} else {
return null;
}
})();
var let_name__$1 = (cljs.core.truth_(val_tag)?cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(let_name,cljs.core.update,new cljs.core.Keyword(null,"tag","tag",-1290361223),((function (ctx__$1,let_bindings__$1,let_name,let_bindings__$2,let_val,rest_let_bindings,val_tag){
return (function (t){
if(cljs.core.truth_(t)){
return t;
} else {
return val_tag;
}
});})(ctx__$1,let_bindings__$1,let_name,let_bindings__$2,let_val,rest_let_bindings,val_tag))
):let_name);
var v = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx__$1,let_val) : sci.impl.interpreter.interpret.call(null,ctx__$1,let_val));
var ctx__$2 = cljs.core.assoc_in(ctx__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bindings","bindings",1271397192),let_name__$1], null),v);
if(cljs.core.not(rest_let_bindings)){
return ctx__$2;
} else {
var G__38577 = ctx__$2;
var G__38578 = rest_let_bindings;
ctx__$1 = G__38577;
let_bindings__$1 = G__38578;
continue;
}
break;
}
})();
if(cljs.core.truth_(exprs)){
var exprs__$1 = exprs;
while(true){
var e = cljs.core.first(exprs__$1);
var ret = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx__$1,e) : sci.impl.interpreter.interpret.call(null,ctx__$1,e));
var nexprs = cljs.core.next(exprs__$1);
if(nexprs){
var G__38579 = nexprs;
exprs__$1 = G__38579;
continue;
} else {
return ret;
}
break;
}
} else {
return null;
}
}));

(sci.impl.interpreter.eval_let.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(sci.impl.interpreter.eval_let.cljs$lang$applyTo = (function (seq37844){
var G__37845 = cljs.core.first(seq37844);
var seq37844__$1 = cljs.core.next(seq37844);
var G__37846 = cljs.core.first(seq37844__$1);
var seq37844__$2 = cljs.core.next(seq37844__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37845,G__37846,seq37844__$2);
}));

sci.impl.interpreter.eval_if = (function sci$impl$interpreter$eval_if(ctx,expr){
var cond = cljs.core.first(expr);
var expr__$1 = cljs.core.rest(expr);
var then = cljs.core.first(expr__$1);
var expr__$2 = cljs.core.rest(expr__$1);
var else$ = cljs.core.first(expr__$2);
if(cljs.core.truth_((sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,cond) : sci.impl.interpreter.interpret.call(null,ctx,cond)))){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,then) : sci.impl.interpreter.interpret.call(null,ctx,then));
} else {
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,else$) : sci.impl.interpreter.interpret.call(null,ctx,else$));
}
});
sci.impl.interpreter.eval_def = (function sci$impl$interpreter$eval_def(ctx,p__37851){
var vec__37852 = p__37851;
var _def = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37852,(0),null);
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37852,(1),null);
var _QMARK_docstring = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37852,(2),null);
var _QMARK_init = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37852,(3),null);
var docstring = (cljs.core.truth_(_QMARK_init)?_QMARK_docstring:null);
var init = (cljs.core.truth_(docstring)?_QMARK_init:_QMARK_docstring);
var init__$1 = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,init) : sci.impl.interpreter.interpret.call(null,ctx,init));
var m = cljs.core.meta(var_name);
var m__$1 = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,m) : sci.impl.interpreter.interpret.call(null,ctx,m));
var cnn = sci.impl.vars.getName(new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m__$1));
var assoc_in_env = (function (env){
var the_current_ns = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn], null));
var prev = cljs.core.get.cljs$core$IFn$_invoke$arity$2(the_current_ns,var_name);
var v = (cljs.core.truth_((sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("sci.impl","var.unbound","sci.impl/var.unbound",-1824207647),init__$1) : sci.impl.utils.kw_identical_QMARK_.call(null,new cljs.core.Keyword("sci.impl","var.unbound","sci.impl/var.unbound",-1824207647),init__$1)))?(function (){var G__37855 = prev;
cljs.core.alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__37855,cljs.core.merge,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m__$1], 0));

return G__37855;
})():(function (){
sci.impl.vars.bindRoot(prev,init__$1);

cljs.core.alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic(prev,cljs.core.merge,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m__$1], 0));

return prev;
})()
);
var the_current_ns__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(the_current_ns,var_name,v);
return cljs.core.assoc_in(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn], null),the_current_ns__$1);
});
var env = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),assoc_in_env);
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn,var_name], null));
});
sci.impl.interpreter.resolve_symbol = (function sci$impl$interpreter$resolve_symbol(ctx,sym){
var bindings = ctx.get(new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var temp__5733__auto__ = cljs.core.find(bindings,sym);
if(cljs.core.truth_(temp__5733__auto__)){
var v = temp__5733__auto__;
return cljs.core.second(v);
} else {
return sci.impl.utils.throw_error_with_location.cljs$core$IFn$_invoke$arity$2(["Could not resolve symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym),"\nks:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.keys(new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(ctx)))].join(''),sym);
}
});
sci.impl.interpreter.parse_libspec = (function sci$impl$interpreter$parse_libspec(libspec){
if(cljs.core.sequential_QMARK_(libspec)){
var vec__37856 = libspec;
var seq__37857 = cljs.core.seq(vec__37856);
var first__37858 = cljs.core.first(seq__37857);
var seq__37857__$1 = cljs.core.next(seq__37857);
var lib_name = first__37858;
var opts = seq__37857__$1;
var ret = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"lib-name","lib-name",1158024282),lib_name], null);
var G__37862 = opts;
var vec__37863 = G__37862;
var seq__37864 = cljs.core.seq(vec__37863);
var first__37865 = cljs.core.first(seq__37864);
var seq__37864__$1 = cljs.core.next(seq__37864);
var opt_name = first__37865;
var first__37865__$1 = cljs.core.first(seq__37864__$1);
var seq__37864__$2 = cljs.core.next(seq__37864__$1);
var fst_opt = first__37865__$1;
var rst_opts = seq__37864__$2;
var ret__$1 = ret;
var G__37862__$1 = G__37862;
while(true){
var ret__$2 = ret__$1;
var vec__37870 = G__37862__$1;
var seq__37871 = cljs.core.seq(vec__37870);
var first__37872 = cljs.core.first(seq__37871);
var seq__37871__$1 = cljs.core.next(seq__37871);
var opt_name__$1 = first__37872;
var first__37872__$1 = cljs.core.first(seq__37871__$1);
var seq__37871__$2 = cljs.core.next(seq__37871__$1);
var fst_opt__$1 = first__37872__$1;
var rst_opts__$1 = seq__37871__$2;
if(cljs.core.not(opt_name__$1)){
return ret__$2;
} else {
var G__37873 = opt_name__$1;
var G__37873__$1 = (((G__37873 instanceof cljs.core.Keyword))?G__37873.fqn:null);
switch (G__37873__$1) {
case "as":
var G__38581 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret__$2,new cljs.core.Keyword(null,"as","as",1148689641),fst_opt__$1);
var G__38582 = rst_opts__$1;
ret__$1 = G__38581;
G__37862__$1 = G__38582;
continue;

break;
case "reload":
case "reload-all":
case "verbose":
var G__38583 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret__$2,new cljs.core.Keyword(null,"reload","reload",863702807),true);
var G__38584 = cljs.core.cons(fst_opt__$1,rst_opts__$1);
ret__$1 = G__38583;
G__37862__$1 = G__38584;
continue;

break;
case "refer":
case "rename":
case "exclude":
case "only":
var G__38585 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret__$2,opt_name__$1,fst_opt__$1);
var G__38586 = rst_opts__$1;
ret__$1 = G__38585;
G__37862__$1 = G__38586;
continue;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__37873__$1)].join('')));

}
}
break;
}
} else {
if((libspec instanceof cljs.core.Symbol)){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"lib-name","lib-name",1158024282),libspec], null);
} else {
throw (new Error(["Invalid libspec: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(libspec)].join('')));

}
}
});
sci.impl.interpreter.handle_refer_all = (function sci$impl$interpreter$handle_refer_all(the_current_ns,the_loaded_ns,include_sym_QMARK_,rename_sym,only){
var only__$1 = (cljs.core.truth_(only)?cljs.core.set(only):null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ns,p__37881){
var vec__37882 = p__37881;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37882,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37882,(1),null);
if(cljs.core.truth_((((k instanceof cljs.core.Symbol))?(function (){var and__4115__auto__ = (include_sym_QMARK_.cljs$core$IFn$_invoke$arity$1 ? include_sym_QMARK_.cljs$core$IFn$_invoke$arity$1(k) : include_sym_QMARK_.call(null,k));
if(cljs.core.truth_(and__4115__auto__)){
return ((cljs.core.not(only__$1)) || (cljs.core.contains_QMARK_(only__$1,k)));
} else {
return and__4115__auto__;
}
})():false))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ns,(rename_sym.cljs$core$IFn$_invoke$arity$1 ? rename_sym.cljs$core$IFn$_invoke$arity$1(k) : rename_sym.call(null,k)),v);
} else {
return ns;
}
}),the_current_ns,the_loaded_ns);
});
sci.impl.interpreter.handle_require_libspec_env = (function sci$impl$interpreter$handle_require_libspec_env(env,use_QMARK_,current_ns,the_loaded_ns,lib_name,p__37885){
var map__37886 = p__37885;
var map__37886__$1 = (((((!((map__37886 == null))))?(((((map__37886.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37886.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37886):map__37886);
var _parsed_libspec = map__37886__$1;
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37886__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var refer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37886__$1,new cljs.core.Keyword(null,"refer","refer",-964295553));
var rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37886__$1,new cljs.core.Keyword(null,"rename","rename",1508157613));
var exclude = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37886__$1,new cljs.core.Keyword(null,"exclude","exclude",-1230250334));
var only = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37886__$1,new cljs.core.Keyword(null,"only","only",1907811652));
var the_current_ns = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),current_ns], null));
var the_current_ns__$1 = (cljs.core.truth_(as)?cljs.core.assoc_in(the_current_ns,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"aliases","aliases",1346874714),as], null),lib_name):the_current_ns);
var rename_sym = (cljs.core.truth_(rename)?(function (sym){
var or__4126__auto__ = (rename.cljs$core$IFn$_invoke$arity$1 ? rename.cljs$core$IFn$_invoke$arity$1(sym) : rename.call(null,sym));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return sym;
}
}):cljs.core.identity);
var include_sym_QMARK_ = (cljs.core.truth_(exclude)?(function (){var excludes = cljs.core.set(exclude);
return (function (sym){
return (!(cljs.core.contains_QMARK_(excludes,sym)));
});
})():cljs.core.constantly(true));
var the_current_ns__$2 = (cljs.core.truth_(refer)?(cljs.core.truth_((function (){var or__4126__auto__ = (sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"all","all",892129742),refer) : sci.impl.utils.kw_identical_QMARK_.call(null,new cljs.core.Keyword(null,"all","all",892129742),refer));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return use_QMARK_;
}
})())?sci.impl.interpreter.handle_refer_all(the_current_ns__$1,the_loaded_ns,include_sym_QMARK_,rename_sym,null):((cljs.core.sequential_QMARK_(refer))?cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ns,sym){
if(cljs.core.truth_(include_sym_QMARK_(sym))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ns,(rename_sym.cljs$core$IFn$_invoke$arity$1 ? rename_sym.cljs$core$IFn$_invoke$arity$1(sym) : rename_sym.call(null,sym)),(function (){var temp__5733__auto__ = cljs.core.find(the_loaded_ns,sym);
if(cljs.core.truth_(temp__5733__auto__)){
var vec__37888 = temp__5733__auto__;
var _k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37888,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37888,(1),null);
return v;
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym)," does not exist"].join('')));
}
})());
} else {
return ns;
}
}),the_current_ns__$1,refer):(function(){throw (new Error(":refer value must be a sequential collection of symbols"))})()
)):(cljs.core.truth_(use_QMARK_)?sci.impl.interpreter.handle_refer_all(the_current_ns__$1,the_loaded_ns,include_sym_QMARK_,rename_sym,only):the_current_ns__$1
));
var env__$1 = cljs.core.assoc_in(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),current_ns], null),the_current_ns__$2);
return env__$1;
});
sci.impl.interpreter.handle_require_libspec = (function sci$impl$interpreter$handle_require_libspec(ctx,libspec){
var map__37891 = sci.impl.interpreter.parse_libspec(libspec);
var map__37891__$1 = (((((!((map__37891 == null))))?(((((map__37891.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37891.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37891):map__37891);
var parsed_libspec = map__37891__$1;
var lib_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37891__$1,new cljs.core.Keyword(null,"lib-name","lib-name",1158024282));
var reload = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37891__$1,new cljs.core.Keyword(null,"reload","reload",863702807));
var env_STAR_ = new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx);
var env = cljs.core.deref(env_STAR_);
var cnn = sci.impl.vars.current_ns_name();
var namespaces = cljs.core.get.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469));
var use_QMARK_ = new cljs.core.Keyword("sci.impl","use","sci.impl/use",1724565881).cljs$core$IFn$_invoke$arity$1(ctx);
var temp__5733__auto__ = (cljs.core.truth_(reload)?null:cljs.core.get.cljs$core$IFn$_invoke$arity$2(namespaces,lib_name));
if(cljs.core.truth_(temp__5733__auto__)){
var the_loaded_ns = temp__5733__auto__;
return cljs.core.reset_BANG_(env_STAR_,sci.impl.interpreter.handle_require_libspec_env(env,use_QMARK_,cnn,the_loaded_ns,lib_name,parsed_libspec));
} else {
var temp__5733__auto____$1 = new cljs.core.Keyword(null,"load-fn","load-fn",-2121144334).cljs$core$IFn$_invoke$arity$1(ctx);
if(cljs.core.truth_(temp__5733__auto____$1)){
var load_fn = temp__5733__auto____$1;
var temp__5733__auto____$2 = (function (){var G__37893 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),lib_name], null);
return (load_fn.cljs$core$IFn$_invoke$arity$1 ? load_fn.cljs$core$IFn$_invoke$arity$1(G__37893) : load_fn.call(null,G__37893));
})();
if(cljs.core.truth_(temp__5733__auto____$2)){
var map__37894 = temp__5733__auto____$2;
var map__37894__$1 = (((((!((map__37894 == null))))?(((((map__37894.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37894.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37894):map__37894);
var file = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37894__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37894__$1,new cljs.core.Keyword(null,"source","source",-433931539));
try{sci.impl.vars.push_thread_bindings(cljs.core.PersistentArrayMap.createAsIfByAssoc([sci.impl.vars.current_ns,cljs.core.deref(sci.impl.vars.current_ns),sci.impl.vars.current_file,file]));

try{var G__37897_38587 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ctx,new cljs.core.Keyword(null,"bindings","bindings",1271397192),cljs.core.PersistentArrayMap.EMPTY);
var G__37898_38588 = source;
(sci.impl.interpreter.eval_string_STAR_.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.eval_string_STAR_.cljs$core$IFn$_invoke$arity$2(G__37897_38587,G__37898_38588) : sci.impl.interpreter.eval_string_STAR_.call(null,G__37897_38587,G__37898_38588));
}finally {sci.impl.vars.pop_thread_bindings();
}}catch (e37896){if((e37896 instanceof Error)){
var e_38589 = e37896;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(env_STAR_,cljs.core.update,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lib_name], 0));

throw e_38589;
} else {
throw e37896;

}
}
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(env_STAR_,(function (env__$1){
var namespaces__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(env__$1,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469));
var the_loaded_ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(namespaces__$1,lib_name);
return sci.impl.interpreter.handle_require_libspec_env(env__$1,use_QMARK_,cnn,the_loaded_ns,lib_name,parsed_libspec);
}));
} else {
var or__4126__auto__ = (cljs.core.truth_(reload)?(function (){var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(namespaces,lib_name);
if(cljs.core.truth_(temp__5735__auto__)){
var the_loaded_ns = temp__5735__auto__;
return cljs.core.reset_BANG_(env_STAR_,sci.impl.interpreter.handle_require_libspec_env(env,use_QMARK_,cnn,the_loaded_ns,lib_name,parsed_libspec));
} else {
return null;
}
})():null);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw (new Error(["Could not require ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lib_name),"."].join('')));
}
}
} else {
throw (new Error(["Could not require ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lib_name),"."].join('')));
}
}
});
sci.impl.interpreter.eval_require = (function sci$impl$interpreter$eval_require(var_args){
var args__4742__auto__ = [];
var len__4736__auto___38590 = arguments.length;
var i__4737__auto___38591 = (0);
while(true){
if((i__4737__auto___38591 < len__4736__auto___38590)){
args__4742__auto__.push((arguments[i__4737__auto___38591]));

var G__38592 = (i__4737__auto___38591 + (1));
i__4737__auto___38591 = G__38592;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return sci.impl.interpreter.eval_require.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(sci.impl.interpreter.eval_require.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,args){
var libspecs = cljs.core.PersistentVector.EMPTY;
var current_libspec = null;
var args__$1 = args;
while(true){
if(cljs.core.truth_(args__$1)){
var ret = (function (){var G__37907 = ctx;
var G__37908 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__37907,G__37908) : sci.impl.interpreter.interpret.call(null,G__37907,G__37908));
})();
if((ret instanceof cljs.core.Symbol)){
var G__38593 = (function (){var G__37909 = libspecs;
if(cljs.core.truth_(current_libspec)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__37909,current_libspec);
} else {
return G__37909;
}
})();
var G__38594 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ret], null);
var G__38595 = cljs.core.next(args__$1);
libspecs = G__38593;
current_libspec = G__38594;
args__$1 = G__38595;
continue;
} else {
if((ret instanceof cljs.core.Keyword)){
var G__38596 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(libspecs,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(current_libspec,ret));
var G__38597 = null;
var G__38598 = cljs.core.next(args__$1);
libspecs = G__38596;
current_libspec = G__38597;
args__$1 = G__38598;
continue;
} else {
var G__38599 = (function (){var G__37910 = libspecs;
if(cljs.core.truth_(current_libspec)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__37910,current_libspec);
} else {
return G__37910;
}
})();
var G__38600 = ret;
var G__38601 = cljs.core.next(args__$1);
libspecs = G__38599;
current_libspec = G__38600;
args__$1 = G__38601;
continue;

}
}
} else {
var libspecs__$1 = (function (){var G__37911 = libspecs;
if(cljs.core.truth_(current_libspec)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__37911,current_libspec);
} else {
return G__37911;
}
})();
return cljs.core.run_BANG_(((function (libspecs,current_libspec,args__$1,libspecs__$1){
return (function (p1__37899_SHARP_){
return sci.impl.interpreter.handle_require_libspec(ctx,p1__37899_SHARP_);
});})(libspecs,current_libspec,args__$1,libspecs__$1))
,libspecs__$1);
}
break;
}
}));

(sci.impl.interpreter.eval_require.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sci.impl.interpreter.eval_require.cljs$lang$applyTo = (function (seq37900){
var G__37901 = cljs.core.first(seq37900);
var seq37900__$1 = cljs.core.next(seq37900);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37901,seq37900__$1);
}));

cljs.core.vreset_BANG_(sci.impl.utils.eval_require_state,sci.impl.interpreter.eval_require);
sci.impl.interpreter.eval_use = (function sci$impl$interpreter$eval_use(var_args){
var args__4742__auto__ = [];
var len__4736__auto___38602 = arguments.length;
var i__4737__auto___38603 = (0);
while(true){
if((i__4737__auto___38603 < len__4736__auto___38602)){
args__4742__auto__.push((arguments[i__4737__auto___38603]));

var G__38604 = (i__4737__auto___38603 + (1));
i__4737__auto___38603 = G__38604;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return sci.impl.interpreter.eval_use.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(sci.impl.interpreter.eval_use.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(sci.impl.interpreter.eval_require,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ctx,new cljs.core.Keyword("sci.impl","use","sci.impl/use",1724565881),true),args);
}));

(sci.impl.interpreter.eval_use.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sci.impl.interpreter.eval_use.cljs$lang$applyTo = (function (seq37912){
var G__37913 = cljs.core.first(seq37912);
var seq37912__$1 = cljs.core.next(seq37912);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37913,seq37912__$1);
}));

cljs.core.vreset_BANG_(sci.impl.utils.eval_use_state,sci.impl.interpreter.eval_use);
sci.impl.interpreter.eval_case = (function sci$impl$interpreter$eval_case(ctx,p__37914){
var vec__37915 = p__37914;
var _case = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37915,(0),null);
var map__37918 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37915,(1),null);
var map__37918__$1 = (((((!((map__37918 == null))))?(((((map__37918.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37918.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37918):map__37918);
var case_map = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37918__$1,new cljs.core.Keyword(null,"case-map","case-map",955082964));
var case_val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37918__$1,new cljs.core.Keyword(null,"case-val","case-val",880926521));
var case_default = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37918__$1,new cljs.core.Keyword(null,"case-default","case-default",1140470708));
var v = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,case_val) : sci.impl.interpreter.interpret.call(null,ctx,case_val));
var temp__5733__auto__ = cljs.core.find(case_map,v);
if(cljs.core.truth_(temp__5733__auto__)){
var vec__37920 = temp__5733__auto__;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37920,(0),null);
var found = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37920,(1),null);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,found) : sci.impl.interpreter.interpret.call(null,ctx,found));
} else {
if(cljs.core.vector_QMARK_(case_default)){
var G__37923 = ctx;
var G__37924 = cljs.core.second(case_default);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__37923,G__37924) : sci.impl.interpreter.interpret.call(null,G__37923,G__37924));
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')));
}
}
});
sci.impl.interpreter.eval_try = (function sci$impl$interpreter$eval_try(ctx,expr){
var map__37925 = new cljs.core.Keyword("sci.impl","try","sci.impl/try",2142624741).cljs$core$IFn$_invoke$arity$1(expr);
var map__37925__$1 = (((((!((map__37925 == null))))?(((((map__37925.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37925.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37925):map__37925);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37925__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var catches = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37925__$1,new cljs.core.Keyword(null,"catches","catches",-1478797617));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37925__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
try{var _STAR_in_try_STAR__orig_val__37933 = sci.impl.utils._STAR_in_try_STAR_;
var _STAR_in_try_STAR__temp_val__37934 = true;
(sci.impl.utils._STAR_in_try_STAR_ = _STAR_in_try_STAR__temp_val__37934);

try{return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,body) : sci.impl.interpreter.interpret.call(null,ctx,body));
}finally {(sci.impl.utils._STAR_in_try_STAR_ = _STAR_in_try_STAR__orig_val__37933);
}}catch (e37927){if((e37927 instanceof Error)){
var e = e37927;
var temp__5733__auto__ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (_,c){
var clazz = new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(c);
if((e instanceof clazz)){
return cljs.core.reduced(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sci.impl.interpreter","try-result","sci.impl.interpreter/try-result",1789456125),(function (){var G__37928 = cljs.core.assoc_in(ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bindings","bindings",1271397192),new cljs.core.Keyword(null,"binding","binding",539932593).cljs$core$IFn$_invoke$arity$1(c)], null),e);
var G__37929 = new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(c);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__37928,G__37929) : sci.impl.interpreter.interpret.call(null,G__37928,G__37929));
})()], null));
} else {
return null;
}
}),null,catches);
if(cljs.core.truth_(temp__5733__auto__)){
var vec__37930 = temp__5733__auto__;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37930,(0),null);
var r = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37930,(1),null);
return r;
} else {
return sci.impl.utils.rethrow_with_location_of_node(ctx,e,body);
}
} else {
throw e37927;

}
}finally {(sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,finally$) : sci.impl.interpreter.interpret.call(null,ctx,finally$));
}});
sci.impl.interpreter.eval_throw = (function sci$impl$interpreter$eval_throw(ctx,p__37935){
var vec__37936 = p__37935;
var _throw = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37936,(0),null);
var ex = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37936,(1),null);
var ex__$1 = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,ex) : sci.impl.interpreter.interpret.call(null,ctx,ex));
throw ex__$1;
});
sci.impl.interpreter.eval_static_method_invocation = (function sci$impl$interpreter$eval_static_method_invocation(ctx,expr){
return sci.impl.interop.invoke_static_method(cljs.core.first(expr),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__37939_SHARP_){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,p1__37939_SHARP_) : sci.impl.interpreter.interpret.call(null,ctx,p1__37939_SHARP_));
}),cljs.core.rest(expr)));
});
sci.impl.interpreter.eval_constructor_invocation = (function sci$impl$interpreter$eval_constructor_invocation(ctx,p__37941){
var vec__37942 = p__37941;
var _new = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37942,(0),null);
var constructor$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37942,(1),null);
var args = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37942,(2),null);
var args__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__37940_SHARP_){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,p1__37940_SHARP_) : sci.impl.interpreter.interpret.call(null,ctx,p1__37940_SHARP_));
}),args);
return sci.impl.interop.invoke_constructor(constructor$,args__$1);
});
sci.impl.interpreter.eval_instance_method_invocation = (function sci$impl$interpreter$eval_instance_method_invocation(p__37947,p__37948){
var map__37949 = p__37947;
var map__37949__$1 = (((((!((map__37949 == null))))?(((((map__37949.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37949.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37949):map__37949);
var ctx = map__37949__$1;
var class__GT_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37949__$1,new cljs.core.Keyword(null,"class->opts","class->opts",2061906477));
var vec__37950 = p__37948;
var _dot = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37950,(0),null);
var instance_expr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37950,(1),null);
var method_str = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37950,(2),null);
var args = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37950,(3),null);
var instance_meta = cljs.core.meta(instance_expr);
var tag_class = new cljs.core.Keyword(null,"tag-class","tag-class",714967874).cljs$core$IFn$_invoke$arity$1(instance_meta);
var instance_expr_STAR_ = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,instance_expr) : sci.impl.interpreter.interpret.call(null,ctx,instance_expr));
var instance_class = (function (){var or__4126__auto__ = tag_class;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.type(instance_expr_STAR_);
}
})();
var instance_class_name = instance_class.name;
var instance_class_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(instance_class_name);
var allowed_QMARK_ = (function (){var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(class__GT_opts,new cljs.core.Keyword(null,"allow","allow",-1857325745));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(class__GT_opts,instance_class_symbol);
}
})();
var target_class = (cljs.core.truth_(allowed_QMARK_)?instance_class:(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"public-class","public-class",1127293019).cljs$core$IFn$_invoke$arity$1(ctx);
if(cljs.core.truth_(temp__5735__auto__)){
var f = temp__5735__auto__;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(instance_expr_STAR_) : f.call(null,instance_expr_STAR_));
} else {
return null;
}
})());
if(cljs.core.truth_(target_class)){
} else {
sci.impl.utils.throw_error_with_location.cljs$core$IFn$_invoke$arity$2(["Method ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(method_str)," on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(instance_class)," not allowed!"].join(''),instance_expr);
}

var args__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__37946_SHARP_){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,p1__37946_SHARP_) : sci.impl.interpreter.interpret.call(null,ctx,p1__37946_SHARP_));
}),args);
return sci.impl.interop.invoke_instance_method(instance_expr_STAR_,target_class,method_str,args__$1);
});
sci.impl.interpreter.eval_in_ns = (function sci$impl$interpreter$eval_in_ns(ctx,p__37954){
var vec__37955 = p__37954;
var _in_ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37955,(0),null);
var ns_expr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37955,(1),null);
var ns_sym = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,ns_expr) : sci.impl.interpreter.interpret.call(null,ctx,ns_expr));
sci.impl.utils.set_namespace_BANG_(ctx,ns_sym,null);

return null;
});
sci.impl.interpreter.eval_refer = (function sci$impl$interpreter$eval_refer(ctx,p__37958){
var vec__37959 = p__37958;
var seq__37960 = cljs.core.seq(vec__37959);
var first__37961 = cljs.core.first(seq__37960);
var seq__37960__$1 = cljs.core.next(seq__37960);
var _ = first__37961;
var first__37961__$1 = cljs.core.first(seq__37960__$1);
var seq__37960__$2 = cljs.core.next(seq__37960__$1);
var ns_sym = first__37961__$1;
var exprs = seq__37960__$2;
var ns_sym__$1 = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,ns_sym) : sci.impl.interpreter.interpret.call(null,ctx,ns_sym));
var exprs__$1 = exprs;
while(true){
if(exprs__$1){
var vec__37962 = exprs__$1;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37962,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37962,(1),null);
var G__37965_38605 = k;
var G__37965_38606__$1 = (((G__37965_38605 instanceof cljs.core.Keyword))?G__37965_38605.fqn:null);
switch (G__37965_38606__$1) {
case "exclude":
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),((function (exprs__$1,G__37965_38605,G__37965_38606__$1,vec__37962,k,v,ns_sym__$1,vec__37959,seq__37960,first__37961,seq__37960__$1,_,first__37961__$1,seq__37960__$2,ns_sym,exprs){
return (function (env){
var cnn = sci.impl.vars.current_ns_name();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(env,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn,new cljs.core.Keyword(null,"refer","refer",-964295553),ns_sym__$1,new cljs.core.Keyword(null,"exclude","exclude",-1230250334)], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.into,cljs.core.PersistentHashSet.EMPTY),v);
});})(exprs__$1,G__37965_38605,G__37965_38606__$1,vec__37962,k,v,ns_sym__$1,vec__37959,seq__37960,first__37961,seq__37960__$1,_,first__37961__$1,seq__37960__$2,ns_sym,exprs))
);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__37965_38606__$1)].join('')));

}

var G__38608 = cljs.core.nnext(exprs__$1);
exprs__$1 = G__38608;
continue;
} else {
return null;
}
break;
}
});
sci.impl.interpreter.eval_resolve = (function sci$impl$interpreter$eval_resolve(ctx,sym){
var sym__$1 = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,sym) : sci.impl.interpreter.interpret.call(null,ctx,sym));
return cljs.core.second(sci.impl.analyzer.lookup(ctx,sym__$1,false));
});
cljs.core.vreset_BANG_(sci.impl.utils.eval_resolve_state,sci.impl.interpreter.eval_resolve);
sci.impl.interpreter.macroexpand_1 = (function sci$impl$interpreter$macroexpand_1(ctx,expr){
var original_expr = expr;
if(cljs.core.seq_QMARK_(expr)){
var op = cljs.core.first(expr);
if((op instanceof cljs.core.Symbol)){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(sci.impl.analyzer.special_syms,op))){
return expr;
} else {
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"for","for",316745208,null),null], null), null),op)){
return sci.impl.analyzer.analyze(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ctx,new cljs.core.Keyword("sci.impl","macroexpanding","sci.impl/macroexpanding",2113471825),true),expr);
} else {
var f = sci.impl.analyzer.resolve_symbol.cljs$core$IFn$_invoke$arity$3(ctx,op,true);
var f__$1 = (cljs.core.truth_(((sci.impl.vars.var_QMARK_(f))?sci.impl.vars.isMacro(f):false))?cljs.core.deref(f):f);
if(cljs.core.truth_(sci.impl.analyzer.macro_QMARK_(f__$1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f__$1,original_expr,new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(ctx),cljs.core.rest(expr));
} else {
return expr;
}

}
}
} else {
return expr;
}
} else {
return expr;
}
});
sci.impl.interpreter.macroexpand = (function sci$impl$interpreter$macroexpand(ctx,form){
var ex = sci.impl.interpreter.macroexpand_1(ctx,form);
if((ex === form)){
return form;
} else {
return (sci.impl.interpreter.macroexpand.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.macroexpand.cljs$core$IFn$_invoke$arity$2(ctx,ex) : sci.impl.interpreter.macroexpand.call(null,ctx,ex));
}
});
sci.impl.interpreter.eval_set_BANG_ = (function sci$impl$interpreter$eval_set_BANG_(ctx,p__37966){
var vec__37967 = p__37966;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37967,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37967,(1),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37967,(2),null);
var obj__$1 = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,obj) : sci.impl.interpreter.interpret.call(null,ctx,obj));
var v__$1 = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,v) : sci.impl.interpreter.interpret.call(null,ctx,v));
if(sci.impl.vars.var_QMARK_(obj__$1)){
return sci.impl.types.setVal(obj__$1,v__$1);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot set ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(obj__$1)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(v__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"obj","obj",981763962),obj__$1,new cljs.core.Keyword(null,"v","v",21465059),v__$1], null));
}
});
sci.impl.interpreter.eval_do_STAR_ = (function sci$impl$interpreter$eval_do_STAR_(ctx,exprs){
var G__37973 = exprs;
var vec__37974 = G__37973;
var seq__37975 = cljs.core.seq(vec__37974);
var first__37976 = cljs.core.first(seq__37975);
var seq__37975__$1 = cljs.core.next(seq__37975);
var expr = first__37976;
var exprs__$1 = seq__37975__$1;
var G__37973__$1 = G__37973;
while(true){
var vec__37977 = G__37973__$1;
var seq__37978 = cljs.core.seq(vec__37977);
var first__37979 = cljs.core.first(seq__37978);
var seq__37978__$1 = cljs.core.next(seq__37978);
var expr__$1 = first__37979;
var exprs__$2 = seq__37978__$1;
var ret = (function (){try{return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,expr__$1) : sci.impl.interpreter.interpret.call(null,ctx,expr__$1));
}catch (e37980){if((e37980 instanceof Error)){
var e = e37980;
return sci.impl.utils.rethrow_with_location_of_node(ctx,e,expr__$1);
} else {
throw e37980;

}
}})();
var temp__5733__auto__ = cljs.core.seq(exprs__$2);
if(temp__5733__auto__){
var exprs__$3 = temp__5733__auto__;
var G__38609 = exprs__$3;
G__37973__$1 = G__38609;
continue;
} else {
return ret;
}
break;
}
});
sci.impl.interpreter.eval_do = (function sci$impl$interpreter$eval_do(ctx,expr){
var temp__5735__auto__ = cljs.core.next(expr);
if(temp__5735__auto__){
var exprs = temp__5735__auto__;
return sci.impl.interpreter.eval_do_STAR_(ctx,exprs);
} else {
return null;
}
});
sci.impl.interpreter.fn_call = (function sci$impl$interpreter$fn_call(ctx,f,args){
var G__38173 = cljs.core.count(args);
switch (G__38173) {
case (0):
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));

break;
case (1):
var arg37983 = (function (){var G__38174 = ctx;
var G__38175 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38174,G__38175) : sci.impl.interpreter.interpret.call(null,G__38174,G__38175));
})();
var args__$1 = cljs.core.rest(args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg37983) : f.call(null,arg37983));

break;
case (2):
var arg37984 = (function (){var G__38176 = ctx;
var G__38177 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38176,G__38177) : sci.impl.interpreter.interpret.call(null,G__38176,G__38177));
})();
var args__$1 = cljs.core.rest(args);
var arg37985 = (function (){var G__38178 = ctx;
var G__38179 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38178,G__38179) : sci.impl.interpreter.interpret.call(null,G__38178,G__38179));
})();
var args__$2 = cljs.core.rest(args__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg37984,arg37985) : f.call(null,arg37984,arg37985));

break;
case (3):
var arg37986 = (function (){var G__38180 = ctx;
var G__38181 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38180,G__38181) : sci.impl.interpreter.interpret.call(null,G__38180,G__38181));
})();
var args__$1 = cljs.core.rest(args);
var arg37987 = (function (){var G__38182 = ctx;
var G__38183 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38182,G__38183) : sci.impl.interpreter.interpret.call(null,G__38182,G__38183));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg37988 = (function (){var G__38184 = ctx;
var G__38185 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38184,G__38185) : sci.impl.interpreter.interpret.call(null,G__38184,G__38185));
})();
var args__$3 = cljs.core.rest(args__$2);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg37986,arg37987,arg37988) : f.call(null,arg37986,arg37987,arg37988));

break;
case (4):
var arg37989 = (function (){var G__38186 = ctx;
var G__38187 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38186,G__38187) : sci.impl.interpreter.interpret.call(null,G__38186,G__38187));
})();
var args__$1 = cljs.core.rest(args);
var arg37990 = (function (){var G__38188 = ctx;
var G__38189 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38188,G__38189) : sci.impl.interpreter.interpret.call(null,G__38188,G__38189));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg37991 = (function (){var G__38190 = ctx;
var G__38191 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38190,G__38191) : sci.impl.interpreter.interpret.call(null,G__38190,G__38191));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg37992 = (function (){var G__38192 = ctx;
var G__38193 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38192,G__38193) : sci.impl.interpreter.interpret.call(null,G__38192,G__38193));
})();
var args__$4 = cljs.core.rest(args__$3);
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg37989,arg37990,arg37991,arg37992) : f.call(null,arg37989,arg37990,arg37991,arg37992));

break;
case (5):
var arg37993 = (function (){var G__38194 = ctx;
var G__38195 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38194,G__38195) : sci.impl.interpreter.interpret.call(null,G__38194,G__38195));
})();
var args__$1 = cljs.core.rest(args);
var arg37994 = (function (){var G__38196 = ctx;
var G__38197 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38196,G__38197) : sci.impl.interpreter.interpret.call(null,G__38196,G__38197));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg37995 = (function (){var G__38198 = ctx;
var G__38199 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38198,G__38199) : sci.impl.interpreter.interpret.call(null,G__38198,G__38199));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg37996 = (function (){var G__38200 = ctx;
var G__38201 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38200,G__38201) : sci.impl.interpreter.interpret.call(null,G__38200,G__38201));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg37997 = (function (){var G__38202 = ctx;
var G__38203 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38202,G__38203) : sci.impl.interpreter.interpret.call(null,G__38202,G__38203));
})();
var args__$5 = cljs.core.rest(args__$4);
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg37993,arg37994,arg37995,arg37996,arg37997) : f.call(null,arg37993,arg37994,arg37995,arg37996,arg37997));

break;
case (6):
var arg37998 = (function (){var G__38204 = ctx;
var G__38205 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38204,G__38205) : sci.impl.interpreter.interpret.call(null,G__38204,G__38205));
})();
var args__$1 = cljs.core.rest(args);
var arg37999 = (function (){var G__38206 = ctx;
var G__38207 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38206,G__38207) : sci.impl.interpreter.interpret.call(null,G__38206,G__38207));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg38000 = (function (){var G__38208 = ctx;
var G__38209 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38208,G__38209) : sci.impl.interpreter.interpret.call(null,G__38208,G__38209));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg38001 = (function (){var G__38210 = ctx;
var G__38211 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38210,G__38211) : sci.impl.interpreter.interpret.call(null,G__38210,G__38211));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg38002 = (function (){var G__38212 = ctx;
var G__38213 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38212,G__38213) : sci.impl.interpreter.interpret.call(null,G__38212,G__38213));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg38003 = (function (){var G__38214 = ctx;
var G__38215 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38214,G__38215) : sci.impl.interpreter.interpret.call(null,G__38214,G__38215));
})();
var args__$6 = cljs.core.rest(args__$5);
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg37998,arg37999,arg38000,arg38001,arg38002,arg38003) : f.call(null,arg37998,arg37999,arg38000,arg38001,arg38002,arg38003));

break;
case (7):
var arg38004 = (function (){var G__38216 = ctx;
var G__38217 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38216,G__38217) : sci.impl.interpreter.interpret.call(null,G__38216,G__38217));
})();
var args__$1 = cljs.core.rest(args);
var arg38005 = (function (){var G__38218 = ctx;
var G__38219 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38218,G__38219) : sci.impl.interpreter.interpret.call(null,G__38218,G__38219));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg38006 = (function (){var G__38220 = ctx;
var G__38221 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38220,G__38221) : sci.impl.interpreter.interpret.call(null,G__38220,G__38221));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg38007 = (function (){var G__38222 = ctx;
var G__38223 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38222,G__38223) : sci.impl.interpreter.interpret.call(null,G__38222,G__38223));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg38008 = (function (){var G__38224 = ctx;
var G__38225 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38224,G__38225) : sci.impl.interpreter.interpret.call(null,G__38224,G__38225));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg38009 = (function (){var G__38226 = ctx;
var G__38227 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38226,G__38227) : sci.impl.interpreter.interpret.call(null,G__38226,G__38227));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg38010 = (function (){var G__38228 = ctx;
var G__38229 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38228,G__38229) : sci.impl.interpreter.interpret.call(null,G__38228,G__38229));
})();
var args__$7 = cljs.core.rest(args__$6);
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(arg38004,arg38005,arg38006,arg38007,arg38008,arg38009,arg38010) : f.call(null,arg38004,arg38005,arg38006,arg38007,arg38008,arg38009,arg38010));

break;
case (8):
var arg38011 = (function (){var G__38230 = ctx;
var G__38231 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38230,G__38231) : sci.impl.interpreter.interpret.call(null,G__38230,G__38231));
})();
var args__$1 = cljs.core.rest(args);
var arg38012 = (function (){var G__38232 = ctx;
var G__38233 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38232,G__38233) : sci.impl.interpreter.interpret.call(null,G__38232,G__38233));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg38013 = (function (){var G__38234 = ctx;
var G__38235 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38234,G__38235) : sci.impl.interpreter.interpret.call(null,G__38234,G__38235));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg38014 = (function (){var G__38236 = ctx;
var G__38237 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38236,G__38237) : sci.impl.interpreter.interpret.call(null,G__38236,G__38237));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg38015 = (function (){var G__38238 = ctx;
var G__38239 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38238,G__38239) : sci.impl.interpreter.interpret.call(null,G__38238,G__38239));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg38016 = (function (){var G__38240 = ctx;
var G__38241 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38240,G__38241) : sci.impl.interpreter.interpret.call(null,G__38240,G__38241));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg38017 = (function (){var G__38242 = ctx;
var G__38243 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38242,G__38243) : sci.impl.interpreter.interpret.call(null,G__38242,G__38243));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg38018 = (function (){var G__38244 = ctx;
var G__38245 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38244,G__38245) : sci.impl.interpreter.interpret.call(null,G__38244,G__38245));
})();
var args__$8 = cljs.core.rest(args__$7);
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(arg38011,arg38012,arg38013,arg38014,arg38015,arg38016,arg38017,arg38018) : f.call(null,arg38011,arg38012,arg38013,arg38014,arg38015,arg38016,arg38017,arg38018));

break;
case (9):
var arg38019 = (function (){var G__38246 = ctx;
var G__38247 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38246,G__38247) : sci.impl.interpreter.interpret.call(null,G__38246,G__38247));
})();
var args__$1 = cljs.core.rest(args);
var arg38020 = (function (){var G__38248 = ctx;
var G__38249 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38248,G__38249) : sci.impl.interpreter.interpret.call(null,G__38248,G__38249));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg38021 = (function (){var G__38250 = ctx;
var G__38251 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38250,G__38251) : sci.impl.interpreter.interpret.call(null,G__38250,G__38251));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg38022 = (function (){var G__38252 = ctx;
var G__38253 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38252,G__38253) : sci.impl.interpreter.interpret.call(null,G__38252,G__38253));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg38023 = (function (){var G__38254 = ctx;
var G__38255 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38254,G__38255) : sci.impl.interpreter.interpret.call(null,G__38254,G__38255));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg38024 = (function (){var G__38256 = ctx;
var G__38257 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38256,G__38257) : sci.impl.interpreter.interpret.call(null,G__38256,G__38257));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg38025 = (function (){var G__38258 = ctx;
var G__38259 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38258,G__38259) : sci.impl.interpreter.interpret.call(null,G__38258,G__38259));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg38026 = (function (){var G__38260 = ctx;
var G__38261 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38260,G__38261) : sci.impl.interpreter.interpret.call(null,G__38260,G__38261));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg38027 = (function (){var G__38262 = ctx;
var G__38263 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38262,G__38263) : sci.impl.interpreter.interpret.call(null,G__38262,G__38263));
})();
var args__$9 = cljs.core.rest(args__$8);
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(arg38019,arg38020,arg38021,arg38022,arg38023,arg38024,arg38025,arg38026,arg38027) : f.call(null,arg38019,arg38020,arg38021,arg38022,arg38023,arg38024,arg38025,arg38026,arg38027));

break;
case (10):
var arg38028 = (function (){var G__38264 = ctx;
var G__38265 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38264,G__38265) : sci.impl.interpreter.interpret.call(null,G__38264,G__38265));
})();
var args__$1 = cljs.core.rest(args);
var arg38029 = (function (){var G__38266 = ctx;
var G__38267 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38266,G__38267) : sci.impl.interpreter.interpret.call(null,G__38266,G__38267));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg38030 = (function (){var G__38268 = ctx;
var G__38269 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38268,G__38269) : sci.impl.interpreter.interpret.call(null,G__38268,G__38269));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg38031 = (function (){var G__38270 = ctx;
var G__38271 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38270,G__38271) : sci.impl.interpreter.interpret.call(null,G__38270,G__38271));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg38032 = (function (){var G__38272 = ctx;
var G__38273 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38272,G__38273) : sci.impl.interpreter.interpret.call(null,G__38272,G__38273));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg38033 = (function (){var G__38274 = ctx;
var G__38275 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38274,G__38275) : sci.impl.interpreter.interpret.call(null,G__38274,G__38275));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg38034 = (function (){var G__38276 = ctx;
var G__38277 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38276,G__38277) : sci.impl.interpreter.interpret.call(null,G__38276,G__38277));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg38035 = (function (){var G__38278 = ctx;
var G__38279 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38278,G__38279) : sci.impl.interpreter.interpret.call(null,G__38278,G__38279));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg38036 = (function (){var G__38280 = ctx;
var G__38281 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38280,G__38281) : sci.impl.interpreter.interpret.call(null,G__38280,G__38281));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg38037 = (function (){var G__38282 = ctx;
var G__38283 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38282,G__38283) : sci.impl.interpreter.interpret.call(null,G__38282,G__38283));
})();
var args__$10 = cljs.core.rest(args__$9);
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(arg38028,arg38029,arg38030,arg38031,arg38032,arg38033,arg38034,arg38035,arg38036,arg38037) : f.call(null,arg38028,arg38029,arg38030,arg38031,arg38032,arg38033,arg38034,arg38035,arg38036,arg38037));

break;
case (11):
var arg38038 = (function (){var G__38284 = ctx;
var G__38285 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38284,G__38285) : sci.impl.interpreter.interpret.call(null,G__38284,G__38285));
})();
var args__$1 = cljs.core.rest(args);
var arg38039 = (function (){var G__38286 = ctx;
var G__38287 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38286,G__38287) : sci.impl.interpreter.interpret.call(null,G__38286,G__38287));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg38040 = (function (){var G__38288 = ctx;
var G__38289 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38288,G__38289) : sci.impl.interpreter.interpret.call(null,G__38288,G__38289));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg38041 = (function (){var G__38290 = ctx;
var G__38291 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38290,G__38291) : sci.impl.interpreter.interpret.call(null,G__38290,G__38291));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg38042 = (function (){var G__38292 = ctx;
var G__38293 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38292,G__38293) : sci.impl.interpreter.interpret.call(null,G__38292,G__38293));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg38043 = (function (){var G__38294 = ctx;
var G__38295 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38294,G__38295) : sci.impl.interpreter.interpret.call(null,G__38294,G__38295));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg38044 = (function (){var G__38296 = ctx;
var G__38297 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38296,G__38297) : sci.impl.interpreter.interpret.call(null,G__38296,G__38297));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg38045 = (function (){var G__38298 = ctx;
var G__38299 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38298,G__38299) : sci.impl.interpreter.interpret.call(null,G__38298,G__38299));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg38046 = (function (){var G__38300 = ctx;
var G__38301 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38300,G__38301) : sci.impl.interpreter.interpret.call(null,G__38300,G__38301));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg38047 = (function (){var G__38302 = ctx;
var G__38303 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38302,G__38303) : sci.impl.interpreter.interpret.call(null,G__38302,G__38303));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg38048 = (function (){var G__38304 = ctx;
var G__38305 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38304,G__38305) : sci.impl.interpreter.interpret.call(null,G__38304,G__38305));
})();
var args__$11 = cljs.core.rest(args__$10);
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(arg38038,arg38039,arg38040,arg38041,arg38042,arg38043,arg38044,arg38045,arg38046,arg38047,arg38048) : f.call(null,arg38038,arg38039,arg38040,arg38041,arg38042,arg38043,arg38044,arg38045,arg38046,arg38047,arg38048));

break;
case (12):
var arg38049 = (function (){var G__38306 = ctx;
var G__38307 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38306,G__38307) : sci.impl.interpreter.interpret.call(null,G__38306,G__38307));
})();
var args__$1 = cljs.core.rest(args);
var arg38050 = (function (){var G__38308 = ctx;
var G__38309 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38308,G__38309) : sci.impl.interpreter.interpret.call(null,G__38308,G__38309));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg38051 = (function (){var G__38310 = ctx;
var G__38311 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38310,G__38311) : sci.impl.interpreter.interpret.call(null,G__38310,G__38311));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg38052 = (function (){var G__38312 = ctx;
var G__38313 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38312,G__38313) : sci.impl.interpreter.interpret.call(null,G__38312,G__38313));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg38053 = (function (){var G__38314 = ctx;
var G__38315 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38314,G__38315) : sci.impl.interpreter.interpret.call(null,G__38314,G__38315));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg38054 = (function (){var G__38316 = ctx;
var G__38317 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38316,G__38317) : sci.impl.interpreter.interpret.call(null,G__38316,G__38317));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg38055 = (function (){var G__38318 = ctx;
var G__38319 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38318,G__38319) : sci.impl.interpreter.interpret.call(null,G__38318,G__38319));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg38056 = (function (){var G__38320 = ctx;
var G__38321 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38320,G__38321) : sci.impl.interpreter.interpret.call(null,G__38320,G__38321));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg38057 = (function (){var G__38322 = ctx;
var G__38323 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38322,G__38323) : sci.impl.interpreter.interpret.call(null,G__38322,G__38323));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg38058 = (function (){var G__38324 = ctx;
var G__38325 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38324,G__38325) : sci.impl.interpreter.interpret.call(null,G__38324,G__38325));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg38059 = (function (){var G__38326 = ctx;
var G__38327 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38326,G__38327) : sci.impl.interpreter.interpret.call(null,G__38326,G__38327));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg38060 = (function (){var G__38328 = ctx;
var G__38329 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38328,G__38329) : sci.impl.interpreter.interpret.call(null,G__38328,G__38329));
})();
var args__$12 = cljs.core.rest(args__$11);
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(arg38049,arg38050,arg38051,arg38052,arg38053,arg38054,arg38055,arg38056,arg38057,arg38058,arg38059,arg38060) : f.call(null,arg38049,arg38050,arg38051,arg38052,arg38053,arg38054,arg38055,arg38056,arg38057,arg38058,arg38059,arg38060));

break;
case (13):
var arg38061 = (function (){var G__38330 = ctx;
var G__38331 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38330,G__38331) : sci.impl.interpreter.interpret.call(null,G__38330,G__38331));
})();
var args__$1 = cljs.core.rest(args);
var arg38062 = (function (){var G__38332 = ctx;
var G__38333 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38332,G__38333) : sci.impl.interpreter.interpret.call(null,G__38332,G__38333));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg38063 = (function (){var G__38334 = ctx;
var G__38335 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38334,G__38335) : sci.impl.interpreter.interpret.call(null,G__38334,G__38335));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg38064 = (function (){var G__38336 = ctx;
var G__38337 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38336,G__38337) : sci.impl.interpreter.interpret.call(null,G__38336,G__38337));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg38065 = (function (){var G__38338 = ctx;
var G__38339 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38338,G__38339) : sci.impl.interpreter.interpret.call(null,G__38338,G__38339));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg38066 = (function (){var G__38340 = ctx;
var G__38341 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38340,G__38341) : sci.impl.interpreter.interpret.call(null,G__38340,G__38341));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg38067 = (function (){var G__38342 = ctx;
var G__38343 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38342,G__38343) : sci.impl.interpreter.interpret.call(null,G__38342,G__38343));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg38068 = (function (){var G__38344 = ctx;
var G__38345 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38344,G__38345) : sci.impl.interpreter.interpret.call(null,G__38344,G__38345));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg38069 = (function (){var G__38346 = ctx;
var G__38347 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38346,G__38347) : sci.impl.interpreter.interpret.call(null,G__38346,G__38347));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg38070 = (function (){var G__38348 = ctx;
var G__38349 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38348,G__38349) : sci.impl.interpreter.interpret.call(null,G__38348,G__38349));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg38071 = (function (){var G__38350 = ctx;
var G__38351 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38350,G__38351) : sci.impl.interpreter.interpret.call(null,G__38350,G__38351));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg38072 = (function (){var G__38352 = ctx;
var G__38353 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38352,G__38353) : sci.impl.interpreter.interpret.call(null,G__38352,G__38353));
})();
var args__$12 = cljs.core.rest(args__$11);
var arg38073 = (function (){var G__38354 = ctx;
var G__38355 = cljs.core.first(args__$12);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38354,G__38355) : sci.impl.interpreter.interpret.call(null,G__38354,G__38355));
})();
var args__$13 = cljs.core.rest(args__$12);
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(arg38061,arg38062,arg38063,arg38064,arg38065,arg38066,arg38067,arg38068,arg38069,arg38070,arg38071,arg38072,arg38073) : f.call(null,arg38061,arg38062,arg38063,arg38064,arg38065,arg38066,arg38067,arg38068,arg38069,arg38070,arg38071,arg38072,arg38073));

break;
case (14):
var arg38074 = (function (){var G__38356 = ctx;
var G__38357 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38356,G__38357) : sci.impl.interpreter.interpret.call(null,G__38356,G__38357));
})();
var args__$1 = cljs.core.rest(args);
var arg38075 = (function (){var G__38358 = ctx;
var G__38359 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38358,G__38359) : sci.impl.interpreter.interpret.call(null,G__38358,G__38359));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg38076 = (function (){var G__38360 = ctx;
var G__38361 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38360,G__38361) : sci.impl.interpreter.interpret.call(null,G__38360,G__38361));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg38077 = (function (){var G__38362 = ctx;
var G__38363 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38362,G__38363) : sci.impl.interpreter.interpret.call(null,G__38362,G__38363));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg38078 = (function (){var G__38364 = ctx;
var G__38365 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38364,G__38365) : sci.impl.interpreter.interpret.call(null,G__38364,G__38365));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg38079 = (function (){var G__38366 = ctx;
var G__38367 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38366,G__38367) : sci.impl.interpreter.interpret.call(null,G__38366,G__38367));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg38080 = (function (){var G__38368 = ctx;
var G__38369 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38368,G__38369) : sci.impl.interpreter.interpret.call(null,G__38368,G__38369));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg38081 = (function (){var G__38370 = ctx;
var G__38371 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38370,G__38371) : sci.impl.interpreter.interpret.call(null,G__38370,G__38371));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg38082 = (function (){var G__38372 = ctx;
var G__38373 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38372,G__38373) : sci.impl.interpreter.interpret.call(null,G__38372,G__38373));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg38083 = (function (){var G__38374 = ctx;
var G__38375 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38374,G__38375) : sci.impl.interpreter.interpret.call(null,G__38374,G__38375));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg38084 = (function (){var G__38376 = ctx;
var G__38377 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38376,G__38377) : sci.impl.interpreter.interpret.call(null,G__38376,G__38377));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg38085 = (function (){var G__38378 = ctx;
var G__38379 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38378,G__38379) : sci.impl.interpreter.interpret.call(null,G__38378,G__38379));
})();
var args__$12 = cljs.core.rest(args__$11);
var arg38086 = (function (){var G__38380 = ctx;
var G__38381 = cljs.core.first(args__$12);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38380,G__38381) : sci.impl.interpreter.interpret.call(null,G__38380,G__38381));
})();
var args__$13 = cljs.core.rest(args__$12);
var arg38087 = (function (){var G__38382 = ctx;
var G__38383 = cljs.core.first(args__$13);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38382,G__38383) : sci.impl.interpreter.interpret.call(null,G__38382,G__38383));
})();
var args__$14 = cljs.core.rest(args__$13);
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(arg38074,arg38075,arg38076,arg38077,arg38078,arg38079,arg38080,arg38081,arg38082,arg38083,arg38084,arg38085,arg38086,arg38087) : f.call(null,arg38074,arg38075,arg38076,arg38077,arg38078,arg38079,arg38080,arg38081,arg38082,arg38083,arg38084,arg38085,arg38086,arg38087));

break;
case (15):
var arg38088 = (function (){var G__38384 = ctx;
var G__38385 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38384,G__38385) : sci.impl.interpreter.interpret.call(null,G__38384,G__38385));
})();
var args__$1 = cljs.core.rest(args);
var arg38089 = (function (){var G__38386 = ctx;
var G__38387 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38386,G__38387) : sci.impl.interpreter.interpret.call(null,G__38386,G__38387));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg38090 = (function (){var G__38388 = ctx;
var G__38389 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38388,G__38389) : sci.impl.interpreter.interpret.call(null,G__38388,G__38389));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg38091 = (function (){var G__38390 = ctx;
var G__38391 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38390,G__38391) : sci.impl.interpreter.interpret.call(null,G__38390,G__38391));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg38092 = (function (){var G__38392 = ctx;
var G__38393 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38392,G__38393) : sci.impl.interpreter.interpret.call(null,G__38392,G__38393));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg38093 = (function (){var G__38394 = ctx;
var G__38395 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38394,G__38395) : sci.impl.interpreter.interpret.call(null,G__38394,G__38395));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg38094 = (function (){var G__38396 = ctx;
var G__38397 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38396,G__38397) : sci.impl.interpreter.interpret.call(null,G__38396,G__38397));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg38095 = (function (){var G__38398 = ctx;
var G__38399 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38398,G__38399) : sci.impl.interpreter.interpret.call(null,G__38398,G__38399));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg38096 = (function (){var G__38400 = ctx;
var G__38401 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38400,G__38401) : sci.impl.interpreter.interpret.call(null,G__38400,G__38401));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg38097 = (function (){var G__38402 = ctx;
var G__38403 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38402,G__38403) : sci.impl.interpreter.interpret.call(null,G__38402,G__38403));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg38098 = (function (){var G__38404 = ctx;
var G__38405 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38404,G__38405) : sci.impl.interpreter.interpret.call(null,G__38404,G__38405));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg38099 = (function (){var G__38406 = ctx;
var G__38407 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38406,G__38407) : sci.impl.interpreter.interpret.call(null,G__38406,G__38407));
})();
var args__$12 = cljs.core.rest(args__$11);
var arg38100 = (function (){var G__38408 = ctx;
var G__38409 = cljs.core.first(args__$12);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38408,G__38409) : sci.impl.interpreter.interpret.call(null,G__38408,G__38409));
})();
var args__$13 = cljs.core.rest(args__$12);
var arg38101 = (function (){var G__38410 = ctx;
var G__38411 = cljs.core.first(args__$13);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38410,G__38411) : sci.impl.interpreter.interpret.call(null,G__38410,G__38411));
})();
var args__$14 = cljs.core.rest(args__$13);
var arg38102 = (function (){var G__38412 = ctx;
var G__38413 = cljs.core.first(args__$14);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38412,G__38413) : sci.impl.interpreter.interpret.call(null,G__38412,G__38413));
})();
var args__$15 = cljs.core.rest(args__$14);
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(arg38088,arg38089,arg38090,arg38091,arg38092,arg38093,arg38094,arg38095,arg38096,arg38097,arg38098,arg38099,arg38100,arg38101,arg38102) : f.call(null,arg38088,arg38089,arg38090,arg38091,arg38092,arg38093,arg38094,arg38095,arg38096,arg38097,arg38098,arg38099,arg38100,arg38101,arg38102));

break;
case (16):
var arg38103 = (function (){var G__38414 = ctx;
var G__38415 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38414,G__38415) : sci.impl.interpreter.interpret.call(null,G__38414,G__38415));
})();
var args__$1 = cljs.core.rest(args);
var arg38104 = (function (){var G__38416 = ctx;
var G__38417 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38416,G__38417) : sci.impl.interpreter.interpret.call(null,G__38416,G__38417));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg38105 = (function (){var G__38418 = ctx;
var G__38419 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38418,G__38419) : sci.impl.interpreter.interpret.call(null,G__38418,G__38419));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg38106 = (function (){var G__38420 = ctx;
var G__38421 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38420,G__38421) : sci.impl.interpreter.interpret.call(null,G__38420,G__38421));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg38107 = (function (){var G__38422 = ctx;
var G__38423 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38422,G__38423) : sci.impl.interpreter.interpret.call(null,G__38422,G__38423));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg38108 = (function (){var G__38424 = ctx;
var G__38425 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38424,G__38425) : sci.impl.interpreter.interpret.call(null,G__38424,G__38425));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg38109 = (function (){var G__38426 = ctx;
var G__38427 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38426,G__38427) : sci.impl.interpreter.interpret.call(null,G__38426,G__38427));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg38110 = (function (){var G__38428 = ctx;
var G__38429 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38428,G__38429) : sci.impl.interpreter.interpret.call(null,G__38428,G__38429));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg38111 = (function (){var G__38430 = ctx;
var G__38431 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38430,G__38431) : sci.impl.interpreter.interpret.call(null,G__38430,G__38431));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg38112 = (function (){var G__38432 = ctx;
var G__38433 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38432,G__38433) : sci.impl.interpreter.interpret.call(null,G__38432,G__38433));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg38113 = (function (){var G__38434 = ctx;
var G__38435 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38434,G__38435) : sci.impl.interpreter.interpret.call(null,G__38434,G__38435));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg38114 = (function (){var G__38436 = ctx;
var G__38437 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38436,G__38437) : sci.impl.interpreter.interpret.call(null,G__38436,G__38437));
})();
var args__$12 = cljs.core.rest(args__$11);
var arg38115 = (function (){var G__38438 = ctx;
var G__38439 = cljs.core.first(args__$12);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38438,G__38439) : sci.impl.interpreter.interpret.call(null,G__38438,G__38439));
})();
var args__$13 = cljs.core.rest(args__$12);
var arg38116 = (function (){var G__38440 = ctx;
var G__38441 = cljs.core.first(args__$13);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38440,G__38441) : sci.impl.interpreter.interpret.call(null,G__38440,G__38441));
})();
var args__$14 = cljs.core.rest(args__$13);
var arg38117 = (function (){var G__38442 = ctx;
var G__38443 = cljs.core.first(args__$14);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38442,G__38443) : sci.impl.interpreter.interpret.call(null,G__38442,G__38443));
})();
var args__$15 = cljs.core.rest(args__$14);
var arg38118 = (function (){var G__38444 = ctx;
var G__38445 = cljs.core.first(args__$15);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38444,G__38445) : sci.impl.interpreter.interpret.call(null,G__38444,G__38445));
})();
var args__$16 = cljs.core.rest(args__$15);
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(arg38103,arg38104,arg38105,arg38106,arg38107,arg38108,arg38109,arg38110,arg38111,arg38112,arg38113,arg38114,arg38115,arg38116,arg38117,arg38118) : f.call(null,arg38103,arg38104,arg38105,arg38106,arg38107,arg38108,arg38109,arg38110,arg38111,arg38112,arg38113,arg38114,arg38115,arg38116,arg38117,arg38118));

break;
case (17):
var arg38119 = (function (){var G__38446 = ctx;
var G__38447 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38446,G__38447) : sci.impl.interpreter.interpret.call(null,G__38446,G__38447));
})();
var args__$1 = cljs.core.rest(args);
var arg38120 = (function (){var G__38448 = ctx;
var G__38449 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38448,G__38449) : sci.impl.interpreter.interpret.call(null,G__38448,G__38449));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg38121 = (function (){var G__38450 = ctx;
var G__38451 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38450,G__38451) : sci.impl.interpreter.interpret.call(null,G__38450,G__38451));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg38122 = (function (){var G__38452 = ctx;
var G__38453 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38452,G__38453) : sci.impl.interpreter.interpret.call(null,G__38452,G__38453));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg38123 = (function (){var G__38454 = ctx;
var G__38455 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38454,G__38455) : sci.impl.interpreter.interpret.call(null,G__38454,G__38455));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg38124 = (function (){var G__38456 = ctx;
var G__38457 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38456,G__38457) : sci.impl.interpreter.interpret.call(null,G__38456,G__38457));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg38125 = (function (){var G__38458 = ctx;
var G__38459 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38458,G__38459) : sci.impl.interpreter.interpret.call(null,G__38458,G__38459));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg38126 = (function (){var G__38460 = ctx;
var G__38461 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38460,G__38461) : sci.impl.interpreter.interpret.call(null,G__38460,G__38461));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg38127 = (function (){var G__38462 = ctx;
var G__38463 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38462,G__38463) : sci.impl.interpreter.interpret.call(null,G__38462,G__38463));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg38128 = (function (){var G__38464 = ctx;
var G__38465 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38464,G__38465) : sci.impl.interpreter.interpret.call(null,G__38464,G__38465));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg38129 = (function (){var G__38466 = ctx;
var G__38467 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38466,G__38467) : sci.impl.interpreter.interpret.call(null,G__38466,G__38467));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg38130 = (function (){var G__38468 = ctx;
var G__38469 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38468,G__38469) : sci.impl.interpreter.interpret.call(null,G__38468,G__38469));
})();
var args__$12 = cljs.core.rest(args__$11);
var arg38131 = (function (){var G__38470 = ctx;
var G__38471 = cljs.core.first(args__$12);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38470,G__38471) : sci.impl.interpreter.interpret.call(null,G__38470,G__38471));
})();
var args__$13 = cljs.core.rest(args__$12);
var arg38132 = (function (){var G__38472 = ctx;
var G__38473 = cljs.core.first(args__$13);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38472,G__38473) : sci.impl.interpreter.interpret.call(null,G__38472,G__38473));
})();
var args__$14 = cljs.core.rest(args__$13);
var arg38133 = (function (){var G__38474 = ctx;
var G__38475 = cljs.core.first(args__$14);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38474,G__38475) : sci.impl.interpreter.interpret.call(null,G__38474,G__38475));
})();
var args__$15 = cljs.core.rest(args__$14);
var arg38134 = (function (){var G__38476 = ctx;
var G__38477 = cljs.core.first(args__$15);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38476,G__38477) : sci.impl.interpreter.interpret.call(null,G__38476,G__38477));
})();
var args__$16 = cljs.core.rest(args__$15);
var arg38135 = (function (){var G__38478 = ctx;
var G__38479 = cljs.core.first(args__$16);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38478,G__38479) : sci.impl.interpreter.interpret.call(null,G__38478,G__38479));
})();
var args__$17 = cljs.core.rest(args__$16);
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(arg38119,arg38120,arg38121,arg38122,arg38123,arg38124,arg38125,arg38126,arg38127,arg38128,arg38129,arg38130,arg38131,arg38132,arg38133,arg38134,arg38135) : f.call(null,arg38119,arg38120,arg38121,arg38122,arg38123,arg38124,arg38125,arg38126,arg38127,arg38128,arg38129,arg38130,arg38131,arg38132,arg38133,arg38134,arg38135));

break;
case (18):
var arg38136 = (function (){var G__38480 = ctx;
var G__38481 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38480,G__38481) : sci.impl.interpreter.interpret.call(null,G__38480,G__38481));
})();
var args__$1 = cljs.core.rest(args);
var arg38137 = (function (){var G__38482 = ctx;
var G__38483 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38482,G__38483) : sci.impl.interpreter.interpret.call(null,G__38482,G__38483));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg38138 = (function (){var G__38484 = ctx;
var G__38485 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38484,G__38485) : sci.impl.interpreter.interpret.call(null,G__38484,G__38485));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg38139 = (function (){var G__38486 = ctx;
var G__38487 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38486,G__38487) : sci.impl.interpreter.interpret.call(null,G__38486,G__38487));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg38140 = (function (){var G__38488 = ctx;
var G__38489 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38488,G__38489) : sci.impl.interpreter.interpret.call(null,G__38488,G__38489));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg38141 = (function (){var G__38490 = ctx;
var G__38491 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38490,G__38491) : sci.impl.interpreter.interpret.call(null,G__38490,G__38491));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg38142 = (function (){var G__38492 = ctx;
var G__38493 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38492,G__38493) : sci.impl.interpreter.interpret.call(null,G__38492,G__38493));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg38143 = (function (){var G__38494 = ctx;
var G__38495 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38494,G__38495) : sci.impl.interpreter.interpret.call(null,G__38494,G__38495));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg38144 = (function (){var G__38496 = ctx;
var G__38497 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38496,G__38497) : sci.impl.interpreter.interpret.call(null,G__38496,G__38497));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg38145 = (function (){var G__38498 = ctx;
var G__38499 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38498,G__38499) : sci.impl.interpreter.interpret.call(null,G__38498,G__38499));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg38146 = (function (){var G__38500 = ctx;
var G__38501 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38500,G__38501) : sci.impl.interpreter.interpret.call(null,G__38500,G__38501));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg38147 = (function (){var G__38502 = ctx;
var G__38503 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38502,G__38503) : sci.impl.interpreter.interpret.call(null,G__38502,G__38503));
})();
var args__$12 = cljs.core.rest(args__$11);
var arg38148 = (function (){var G__38504 = ctx;
var G__38505 = cljs.core.first(args__$12);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38504,G__38505) : sci.impl.interpreter.interpret.call(null,G__38504,G__38505));
})();
var args__$13 = cljs.core.rest(args__$12);
var arg38149 = (function (){var G__38506 = ctx;
var G__38507 = cljs.core.first(args__$13);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38506,G__38507) : sci.impl.interpreter.interpret.call(null,G__38506,G__38507));
})();
var args__$14 = cljs.core.rest(args__$13);
var arg38150 = (function (){var G__38508 = ctx;
var G__38509 = cljs.core.first(args__$14);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38508,G__38509) : sci.impl.interpreter.interpret.call(null,G__38508,G__38509));
})();
var args__$15 = cljs.core.rest(args__$14);
var arg38151 = (function (){var G__38510 = ctx;
var G__38511 = cljs.core.first(args__$15);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38510,G__38511) : sci.impl.interpreter.interpret.call(null,G__38510,G__38511));
})();
var args__$16 = cljs.core.rest(args__$15);
var arg38152 = (function (){var G__38512 = ctx;
var G__38513 = cljs.core.first(args__$16);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38512,G__38513) : sci.impl.interpreter.interpret.call(null,G__38512,G__38513));
})();
var args__$17 = cljs.core.rest(args__$16);
var arg38153 = (function (){var G__38514 = ctx;
var G__38515 = cljs.core.first(args__$17);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38514,G__38515) : sci.impl.interpreter.interpret.call(null,G__38514,G__38515));
})();
var args__$18 = cljs.core.rest(args__$17);
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(arg38136,arg38137,arg38138,arg38139,arg38140,arg38141,arg38142,arg38143,arg38144,arg38145,arg38146,arg38147,arg38148,arg38149,arg38150,arg38151,arg38152,arg38153) : f.call(null,arg38136,arg38137,arg38138,arg38139,arg38140,arg38141,arg38142,arg38143,arg38144,arg38145,arg38146,arg38147,arg38148,arg38149,arg38150,arg38151,arg38152,arg38153));

break;
case (19):
var arg38154 = (function (){var G__38516 = ctx;
var G__38517 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38516,G__38517) : sci.impl.interpreter.interpret.call(null,G__38516,G__38517));
})();
var args__$1 = cljs.core.rest(args);
var arg38155 = (function (){var G__38518 = ctx;
var G__38519 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38518,G__38519) : sci.impl.interpreter.interpret.call(null,G__38518,G__38519));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg38156 = (function (){var G__38520 = ctx;
var G__38521 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38520,G__38521) : sci.impl.interpreter.interpret.call(null,G__38520,G__38521));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg38157 = (function (){var G__38522 = ctx;
var G__38523 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38522,G__38523) : sci.impl.interpreter.interpret.call(null,G__38522,G__38523));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg38158 = (function (){var G__38524 = ctx;
var G__38525 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38524,G__38525) : sci.impl.interpreter.interpret.call(null,G__38524,G__38525));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg38159 = (function (){var G__38526 = ctx;
var G__38527 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38526,G__38527) : sci.impl.interpreter.interpret.call(null,G__38526,G__38527));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg38160 = (function (){var G__38528 = ctx;
var G__38529 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38528,G__38529) : sci.impl.interpreter.interpret.call(null,G__38528,G__38529));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg38161 = (function (){var G__38530 = ctx;
var G__38531 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38530,G__38531) : sci.impl.interpreter.interpret.call(null,G__38530,G__38531));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg38162 = (function (){var G__38532 = ctx;
var G__38533 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38532,G__38533) : sci.impl.interpreter.interpret.call(null,G__38532,G__38533));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg38163 = (function (){var G__38534 = ctx;
var G__38535 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38534,G__38535) : sci.impl.interpreter.interpret.call(null,G__38534,G__38535));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg38164 = (function (){var G__38536 = ctx;
var G__38537 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38536,G__38537) : sci.impl.interpreter.interpret.call(null,G__38536,G__38537));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg38165 = (function (){var G__38538 = ctx;
var G__38539 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38538,G__38539) : sci.impl.interpreter.interpret.call(null,G__38538,G__38539));
})();
var args__$12 = cljs.core.rest(args__$11);
var arg38166 = (function (){var G__38540 = ctx;
var G__38541 = cljs.core.first(args__$12);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38540,G__38541) : sci.impl.interpreter.interpret.call(null,G__38540,G__38541));
})();
var args__$13 = cljs.core.rest(args__$12);
var arg38167 = (function (){var G__38542 = ctx;
var G__38543 = cljs.core.first(args__$13);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38542,G__38543) : sci.impl.interpreter.interpret.call(null,G__38542,G__38543));
})();
var args__$14 = cljs.core.rest(args__$13);
var arg38168 = (function (){var G__38544 = ctx;
var G__38545 = cljs.core.first(args__$14);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38544,G__38545) : sci.impl.interpreter.interpret.call(null,G__38544,G__38545));
})();
var args__$15 = cljs.core.rest(args__$14);
var arg38169 = (function (){var G__38546 = ctx;
var G__38547 = cljs.core.first(args__$15);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38546,G__38547) : sci.impl.interpreter.interpret.call(null,G__38546,G__38547));
})();
var args__$16 = cljs.core.rest(args__$15);
var arg38170 = (function (){var G__38548 = ctx;
var G__38549 = cljs.core.first(args__$16);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38548,G__38549) : sci.impl.interpreter.interpret.call(null,G__38548,G__38549));
})();
var args__$17 = cljs.core.rest(args__$16);
var arg38171 = (function (){var G__38550 = ctx;
var G__38551 = cljs.core.first(args__$17);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38550,G__38551) : sci.impl.interpreter.interpret.call(null,G__38550,G__38551));
})();
var args__$18 = cljs.core.rest(args__$17);
var arg38172 = (function (){var G__38552 = ctx;
var G__38553 = cljs.core.first(args__$18);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38552,G__38553) : sci.impl.interpreter.interpret.call(null,G__38552,G__38553));
})();
var args__$19 = cljs.core.rest(args__$18);
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(arg38154,arg38155,arg38156,arg38157,arg38158,arg38159,arg38160,arg38161,arg38162,arg38163,arg38164,arg38165,arg38166,arg38167,arg38168,arg38169,arg38170,arg38171,arg38172) : f.call(null,arg38154,arg38155,arg38156,arg38157,arg38158,arg38159,arg38160,arg38161,arg38162,arg38163,arg38164,arg38165,arg38166,arg38167,arg38168,arg38169,arg38170,arg38171,arg38172));

break;
default:
var args__$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__2704_SHARP_){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,p1__2704_SHARP_) : sci.impl.interpreter.interpret.call(null,ctx,p1__2704_SHARP_));
}),args);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args__$1);

}
});
sci.impl.interpreter.eval_special_call = (function sci$impl$interpreter$eval_special_call(ctx,f_sym,expr){
var G__38554 = sci.impl.utils.strip_core_ns(f_sym);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,".",".",1975675962,null),G__38554)){
if(cljs.core.truth_(ctx.get(new cljs.core.Keyword(null,"dry-run","dry-run",-1102788647)))){
return null;
} else {
return sci.impl.interpreter.eval_instance_method_invocation(ctx,expr);
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"and","and",668631710,null),G__38554)){
return sci.impl.interpreter.eval_and(ctx,cljs.core.rest(expr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"case","case",-1510733573,null),G__38554)){
return sci.impl.interpreter.eval_case(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"if","if",1181717262,null),G__38554)){
return sci.impl.interpreter.eval_if(ctx,cljs.core.rest(expr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"do","do",1686842252,null),G__38554)){
return sci.impl.interpreter.eval_do(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"macroexpand","macroexpand",1509933344,null),G__38554)){
return sci.impl.interpreter.macroexpand(ctx,(function (){var G__38555 = ctx;
var G__38556 = cljs.core.second(expr);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38555,G__38556) : sci.impl.interpreter.interpret.call(null,G__38555,G__38556));
})());
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"def","def",597100991,null),G__38554)){
return sci.impl.interpreter.eval_def(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"let","let",358118826,null),G__38554)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(sci.impl.interpreter.eval_let,ctx,cljs.core.rest(expr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"in-ns","in-ns",-2089468466,null),G__38554)){
return sci.impl.interpreter.eval_in_ns(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"use","use",-205850897,null),G__38554)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(sci.impl.interpreter.eval_use,ctx,cljs.core.rest(expr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"set!","set!",250714521,null),G__38554)){
return sci.impl.interpreter.eval_set_BANG_(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"recur","recur",1202958259,null),G__38554)){
return sci.impl.interpreter.fn_call(ctx,cljs.core.comp.cljs$core$IFn$_invoke$arity$2(sci.impl.fns.__GT_Recur,cljs.core.vector),cljs.core.rest(expr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"require","require",1172530194,null),G__38554)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(sci.impl.interpreter.eval_require,ctx,cljs.core.rest(expr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"new","new",-444906321,null),G__38554)){
if(cljs.core.truth_(ctx.get(new cljs.core.Keyword(null,"dry-run","dry-run",-1102788647)))){
return null;
} else {
return sci.impl.interpreter.eval_constructor_invocation(ctx,expr);
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"macroexpand-1","macroexpand-1",659241329,null),G__38554)){
return sci.impl.interpreter.macroexpand_1(ctx,(function (){var G__38557 = ctx;
var G__38558 = cljs.core.second(expr);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38557,G__38558) : sci.impl.interpreter.interpret.call(null,G__38557,G__38558));
})());
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"refer","refer",676235974,null),G__38554)){
return sci.impl.interpreter.eval_refer(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"lazy-seq","lazy-seq",489632906,null),G__38554)){
return (new cljs.core.LazySeq(null,(function (){var G__38559 = ctx;
var G__38560 = cljs.core.second(expr);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__38559,G__38560) : sci.impl.interpreter.interpret.call(null,G__38559,G__38560));
})(),null,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"throw","throw",595905694,null),G__38554)){
return sci.impl.interpreter.eval_throw(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"try","try",-1273693247,null),G__38554)){
return sci.impl.interpreter.eval_try(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"resolve","resolve",56086045,null),G__38554)){
return sci.impl.interpreter.eval_resolve(ctx,cljs.core.second(expr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"or","or",1876275696,null),G__38554)){
return sci.impl.interpreter.eval_or(ctx,cljs.core.rest(expr));
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__38554)].join('')));

}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
sci.impl.interpreter.eval_call = (function sci$impl$interpreter$eval_call(ctx,expr){
try{var f = cljs.core.first(expr);
var m = cljs.core.meta(f);
var op = (cljs.core.truth_(m)?m.get(new cljs.core.Keyword("sci.impl","op","sci.impl/op",950953978)):null);
if((((f instanceof cljs.core.Symbol)) && (cljs.core.not(op)))){
return sci.impl.interpreter.eval_special_call(ctx,f,expr);
} else {
if(cljs.core.truth_((sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"static-access","static-access",-1860919441)) : sci.impl.utils.kw_identical_QMARK_.call(null,op,new cljs.core.Keyword(null,"static-access","static-access",-1860919441))))){
if(cljs.core.truth_(ctx.get(new cljs.core.Keyword(null,"dry-run","dry-run",-1102788647)))){
return null;
} else {
return sci.impl.interpreter.eval_static_method_invocation(ctx,expr);
}
} else {
var f__$1 = (cljs.core.truth_(op)?(sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,f) : sci.impl.interpreter.interpret.call(null,ctx,f)):f);
if(cljs.core.ifn_QMARK_(f__$1)){
if(cljs.core.truth_(ctx.get(new cljs.core.Keyword(null,"dry-run","dry-run",-1102788647)))){
return null;
} else {
return sci.impl.interpreter.fn_call(ctx,f__$1,cljs.core.rest(expr));
}
} else {
throw (new Error(["Cannot call ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([f__$1], 0))," as a function."].join('')));
}

}
}
}catch (e38561){if((e38561 instanceof Error)){
var e = e38561;
return sci.impl.utils.rethrow_with_location_of_node(ctx,e,expr);
} else {
throw e38561;

}
}});
sci.impl.interpreter.fix_meta = (function sci$impl$interpreter$fix_meta(v,old_meta){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(v);
if(cljs.core.truth_(and__4115__auto__)){
return (((!(sci.impl.vars.var_QMARK_(v)))) && ((!(sci.impl.vars.namespace_QMARK_(v)))));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2(v,(function (m){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,new cljs.core.Keyword("sci.impl","op","sci.impl/op",950953978)),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(old_meta));
}));
} else {
return v;
}
});
sci.impl.interpreter.interpret = (function sci$impl$interpreter$interpret(ctx,expr){
if((expr instanceof sci.impl.types.EvalVar)){
var v = expr.sci$impl$types$IBox$getVal$arity$1(null);
if(cljs.core.not(sci.impl.vars.isMacro(v))){
return cljs.core.deref(v);
} else {
throw (new Error(["Can't take value of a macro: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(v),""].join('')));
}
} else {
var m = cljs.core.meta(expr);
var op = (cljs.core.truth_(m)?m.get(new cljs.core.Keyword("sci.impl","op","sci.impl/op",950953978)):null);
var ret = ((cljs.core.not(op))?expr:(function (){var G__38565 = op;
var G__38565__$1 = (((G__38565 instanceof cljs.core.Keyword))?G__38565.fqn:null);
switch (G__38565__$1) {
case "call":
return sci.impl.interpreter.eval_call(ctx,expr);

break;
case "try":
return sci.impl.interpreter.eval_try(ctx,expr);

break;
case "fn":
return sci.impl.fns.eval_fn(ctx,sci.impl.interpreter.interpret,sci.impl.interpreter.eval_do_STAR_,expr);

break;
case "static-access":
return sci.impl.interop.get_static_field(expr);

break;
case "var-value":
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(expr,(0));

break;
case "deref!":
var v = cljs.core.first(expr);
var v__$1 = ((sci.impl.vars.var_QMARK_(v))?cljs.core.deref(v):v);
var v__$2 = cljs.core.force(v__$1);
return v__$2;

break;
case "resolve-sym":
return sci.impl.interpreter.resolve_symbol(ctx,expr);

break;
case "needs-ctx":
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2(expr,ctx);

break;
default:
if(cljs.core.map_QMARK_(expr)){
return cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__38562_SHARP_){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,p1__38562_SHARP_) : sci.impl.interpreter.interpret.call(null,ctx,p1__38562_SHARP_));
}),cljs.core.keys(expr)),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__38563_SHARP_){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,p1__38563_SHARP_) : sci.impl.interpreter.interpret.call(null,ctx,p1__38563_SHARP_));
}),cljs.core.vals(expr)));
} else {
if(((cljs.core.vector_QMARK_(expr)) || (cljs.core.set_QMARK_(expr)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.empty(expr),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__38564_SHARP_){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,p1__38564_SHARP_) : sci.impl.interpreter.interpret.call(null,ctx,p1__38564_SHARP_));
}),expr));
} else {
throw (new Error(["unexpected: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr),", type: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(expr)),", meta:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(expr))].join('')));

}
}

}
})());
var ret__$1 = (cljs.core.truth_(m)?sci.impl.interpreter.fix_meta(ret,m):ret);
var temp__5733__auto__ = ctx.get(new cljs.core.Keyword(null,"realize-max","realize-max",-1846442543));
if(cljs.core.truth_(temp__5733__auto__)){
var n = temp__5733__auto__;
return sci.impl.max_or_throw.max_or_throw(ret__$1,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ctx,new cljs.core.Keyword(null,"expression","expression",202311876),expr),n);
} else {
return ret__$1;
}
}
});
sci.impl.interpreter.do_QMARK_ = (function sci$impl$interpreter$do_QMARK_(expr){
return ((cljs.core.list_QMARK_(expr)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.first(expr))));
});
sci.impl.interpreter.eval_form = (function sci$impl$interpreter$eval_form(ctx,form){
if(sci.impl.interpreter.do_QMARK_(form)){
var exprs = cljs.core.rest(form);
var ret = null;
while(true){
if(cljs.core.seq(exprs)){
var G__38612 = cljs.core.rest(exprs);
var G__38613 = (function (){var G__38568 = ctx;
var G__38569 = cljs.core.first(exprs);
return (sci.impl.interpreter.eval_form.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.eval_form.cljs$core$IFn$_invoke$arity$2(G__38568,G__38569) : sci.impl.interpreter.eval_form.call(null,G__38568,G__38569));
})();
exprs = G__38612;
ret = G__38613;
continue;
} else {
return ret;
}
break;
}
} else {
var analyzed = sci.impl.analyzer.analyze(ctx,form);
var ret = sci.impl.interpreter.interpret(ctx,analyzed);
return ret;
}
});
cljs.core.vreset_BANG_(sci.impl.utils.eval_form_state,sci.impl.interpreter.eval_form);
sci.impl.interpreter.eval_string_STAR_ = (function sci$impl$interpreter$eval_string_STAR_(ctx,s){
var reader = cljs.tools.reader.reader_types.indexing_push_back_reader.cljs$core$IFn$_invoke$arity$1(cljs.tools.reader.reader_types.string_push_back_reader.cljs$core$IFn$_invoke$arity$1(s));
var ret = null;
while(true){
var expr = sci.impl.parser.parse_next.cljs$core$IFn$_invoke$arity$2(ctx,reader);
if(cljs.core.truth_((sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("edamame.impl.parser","eof","edamame.impl.parser/eof",720552006),expr) : sci.impl.utils.kw_identical_QMARK_.call(null,new cljs.core.Keyword("edamame.impl.parser","eof","edamame.impl.parser/eof",720552006),expr)))){
return ret;
} else {
var ret__$1 = sci.impl.interpreter.eval_form(ctx,expr);
var G__38614 = ret__$1;
ret = G__38614;
continue;
}
break;
}
});
sci.impl.interpreter.eval_string = (function sci$impl$interpreter$eval_string(var_args){
var G__38571 = arguments.length;
switch (G__38571) {
case 1:
return sci.impl.interpreter.eval_string.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sci.impl.interpreter.eval_string.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sci.impl.interpreter.eval_string.cljs$core$IFn$_invoke$arity$1 = (function (s){
return sci.impl.interpreter.eval_string.cljs$core$IFn$_invoke$arity$2(s,null);
}));

(sci.impl.interpreter.eval_string.cljs$core$IFn$_invoke$arity$2 = (function (s,opts){
var init_ctx = sci.impl.opts.init(opts);
var ret = (function (){
sci.impl.vars.push_thread_bindings((cljs.core.truth_(cljs.core.deref(sci.impl.vars.current_ns))?null:cljs.core.PersistentArrayMap.createAsIfByAssoc([sci.impl.vars.current_ns,sci.impl.opts.user_ns])));

try{return sci.impl.interpreter.eval_string_STAR_(init_ctx,s);
}finally {sci.impl.vars.pop_thread_bindings();
}})()
;
return ret;
}));

(sci.impl.interpreter.eval_string.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=sci.impl.interpreter.js.map
