goog.provide('pinkgorilla.ui.gorilla_plot.plot');
goog.require('cljs.core');
goog.require('pinkgorilla.ui.gorilla_plot.vega');
goog.require('pinkgorilla.ui.gorilla_plot.util');
pinkgorilla.ui.gorilla_plot.plot.merge_with_meta = (function pinkgorilla$ui$gorilla_plot$plot$merge_with_meta(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28826 = arguments.length;
var i__4737__auto___28827 = (0);
while(true){
if((i__4737__auto___28827 < len__4736__auto___28826)){
args__4742__auto__.push((arguments[i__4737__auto___28827]));

var G__28828 = (i__4737__auto___28827 + (1));
i__4737__auto___28827 = G__28828;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$core$IFn$_invoke$arity$variadic = (function (data){
var metas = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.meta,data);
var merged_meta = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.merge,metas);
return cljs.core.with_meta(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.merge,data),merged_meta);
}));

(pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$lang$applyTo = (function (seq28773){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28773));
}));

pinkgorilla.ui.gorilla_plot.plot.add_indices = (function pinkgorilla$ui$gorilla_plot$plot$add_indices(d){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(d)),d);
});
/**
 * Function for plotting list data.
 */
pinkgorilla.ui.gorilla_plot.plot.list_plot = (function pinkgorilla$ui$gorilla_plot$plot$list_plot(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28829 = arguments.length;
var i__4737__auto___28830 = (0);
while(true){
if((i__4737__auto___28830 < len__4736__auto___28829)){
args__4742__auto__.push((arguments[i__4737__auto___28830]));

var G__28831 = (i__4737__auto___28830 + (1));
i__4737__auto___28830 = G__28831;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.plot.list_plot.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.plot.list_plot.cljs$core$IFn$_invoke$arity$variadic = (function (data,p__28780){
var map__28781 = p__28780;
var map__28781__$1 = (((((!((map__28781 == null))))?(((((map__28781.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28781.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28781):map__28781);
var plot_range = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28781__$1,new cljs.core.Keyword(null,"plot-range","plot-range",-1426783143),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.Keyword(null,"all","all",892129742)], null));
var colour = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28781__$1,new cljs.core.Keyword(null,"colour","colour",2137094554));
var y_title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28781__$1,new cljs.core.Keyword(null,"y-title","y-title",220785852));
var aspect_ratio = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28781__$1,new cljs.core.Keyword(null,"aspect-ratio","aspect-ratio",1674013504),1.618);
var joined = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28781__$1,new cljs.core.Keyword(null,"joined","joined",-231861661),false);
var color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28781__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var series_name = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28781__$1,new cljs.core.Keyword(null,"series-name","series-name",-128514906),pinkgorilla.ui.gorilla_plot.util.gen_uuid());
var x_title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28781__$1,new cljs.core.Keyword(null,"x-title","x-title",698054088));
var plot_size = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28781__$1,new cljs.core.Keyword(null,"plot-size","plot-size",1218885548),(400));
var symbol_size = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28781__$1,new cljs.core.Keyword(null,"symbol-size","symbol-size",-1099583279),(70));
var opacity = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28781__$1,new cljs.core.Keyword(null,"opacity","opacity",397153780),(1));
var plot_data = ((cljs.core.sequential_QMARK_(cljs.core.first(data)))?data:pinkgorilla.ui.gorilla_plot.plot.add_indices(data));
return pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pinkgorilla.ui.gorilla_plot.vega.container(plot_size,aspect_ratio),pinkgorilla.ui.gorilla_plot.vega.data_from_list(series_name,plot_data),(cljs.core.truth_(joined)?pinkgorilla.ui.gorilla_plot.vega.line_plot_marks(series_name,(function (){var or__4126__auto__ = colour;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return color;
}
})(),opacity):pinkgorilla.ui.gorilla_plot.vega.list_plot_marks(series_name,(function (){var or__4126__auto__ = colour;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return color;
}
})(),symbol_size,opacity)),pinkgorilla.ui.gorilla_plot.vega.default_list_plot_scales(series_name,plot_range),pinkgorilla.ui.gorilla_plot.vega.default_plot_axes(x_title,y_title)], 0));
}));

(pinkgorilla.ui.gorilla_plot.plot.list_plot.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.plot.list_plot.cljs$lang$applyTo = (function (seq28777){
var G__28778 = cljs.core.first(seq28777);
var seq28777__$1 = cljs.core.next(seq28777);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28778,seq28777__$1);
}));

pinkgorilla.ui.gorilla_plot.plot.timeseries_plot = (function pinkgorilla$ui$gorilla_plot$plot$timeseries_plot(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28832 = arguments.length;
var i__4737__auto___28833 = (0);
while(true){
if((i__4737__auto___28833 < len__4736__auto___28832)){
args__4742__auto__.push((arguments[i__4737__auto___28833]));

var G__28834 = (i__4737__auto___28833 + (1));
i__4737__auto___28833 = G__28834;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.plot.timeseries_plot.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.plot.timeseries_plot.cljs$core$IFn$_invoke$arity$variadic = (function (data,keys){
var series_name = pinkgorilla.ui.gorilla_plot.util.gen_uuid();
var params = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [data,new cljs.core.Keyword(null,"series-name","series-name",-128514906),series_name], null),keys));
var plot = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(pinkgorilla.ui.gorilla_plot.plot.list_plot,params);
var plot_range = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.Keyword(null,"all","all",892129742)], null);
return pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([plot,pinkgorilla.ui.gorilla_plot.vega.timeseries_list_plot_scales(series_name,plot_range)], 0));
}));

(pinkgorilla.ui.gorilla_plot.plot.timeseries_plot.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.plot.timeseries_plot.cljs$lang$applyTo = (function (seq28787){
var G__28788 = cljs.core.first(seq28787);
var seq28787__$1 = cljs.core.next(seq28787);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28788,seq28787__$1);
}));

/**
 * Function for plotting functions of a single variable.
 */
pinkgorilla.ui.gorilla_plot.plot.plot = (function pinkgorilla$ui$gorilla_plot$plot$plot(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28838 = arguments.length;
var i__4737__auto___28839 = (0);
while(true){
if((i__4737__auto___28839 < len__4736__auto___28838)){
args__4742__auto__.push((arguments[i__4737__auto___28839]));

var G__28841 = (i__4737__auto___28839 + (1));
i__4737__auto___28839 = G__28841;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.plot.plot.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.plot.plot.cljs$core$IFn$_invoke$arity$variadic = (function (func,p__28793,p__28794){
var vec__28795 = p__28793;
var xmin = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28795,(0),null);
var xmax = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28795,(1),null);
var map__28798 = p__28794;
var map__28798__$1 = (((((!((map__28798 == null))))?(((((map__28798.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28798.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28798):map__28798);
var opts = map__28798__$1;
var plot_points = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28798__$1,new cljs.core.Keyword(null,"plot-points","plot-points",-1364232040),100.0);
var xs = cljs.core.range.cljs$core$IFn$_invoke$arity$3(xmin,xmax,((xmax - xmin) / plot_points));
var plot_data = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__28789_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__28789_SHARP_,(func.cljs$core$IFn$_invoke$arity$1 ? func.cljs$core$IFn$_invoke$arity$1(p1__28789_SHARP_) : func.call(null,p1__28789_SHARP_))],null));
}),xs);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(pinkgorilla.ui.gorilla_plot.plot.list_plot,plot_data),cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.identity,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"joined","joined",-231861661),true], null),opts], 0))], 0)));
}));

(pinkgorilla.ui.gorilla_plot.plot.plot.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.plot.plot.cljs$lang$applyTo = (function (seq28790){
var G__28791 = cljs.core.first(seq28790);
var seq28790__$1 = cljs.core.next(seq28790);
var G__28792 = cljs.core.first(seq28790__$1);
var seq28790__$2 = cljs.core.next(seq28790__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28791,G__28792,seq28790__$2);
}));

pinkgorilla.ui.gorilla_plot.plot.bar_chart = (function pinkgorilla$ui$gorilla_plot$plot$bar_chart(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28842 = arguments.length;
var i__4737__auto___28843 = (0);
while(true){
if((i__4737__auto___28843 < len__4736__auto___28842)){
args__4742__auto__.push((arguments[i__4737__auto___28843]));

var G__28844 = (i__4737__auto___28843 + (1));
i__4737__auto___28843 = G__28844;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.plot.bar_chart.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.plot.bar_chart.cljs$core$IFn$_invoke$arity$variadic = (function (categories,values,p__28808){
var map__28809 = p__28808;
var map__28809__$1 = (((((!((map__28809 == null))))?(((((map__28809.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28809.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28809):map__28809);
var plot_size = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28809__$1,new cljs.core.Keyword(null,"plot-size","plot-size",1218885548),(400));
var aspect_ratio = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28809__$1,new cljs.core.Keyword(null,"aspect-ratio","aspect-ratio",1674013504),1.618);
var plot_range = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28809__$1,new cljs.core.Keyword(null,"plot-range","plot-range",-1426783143),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.Keyword(null,"all","all",892129742)], null));
var opacity = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28809__$1,new cljs.core.Keyword(null,"opacity","opacity",397153780),(1));
var colour = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28809__$1,new cljs.core.Keyword(null,"colour","colour",2137094554));
var color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28809__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var x_title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28809__$1,new cljs.core.Keyword(null,"x-title","x-title",698054088));
var y_title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28809__$1,new cljs.core.Keyword(null,"y-title","y-title",220785852));
var series_name = pinkgorilla.ui.gorilla_plot.util.gen_uuid();
return pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pinkgorilla.ui.gorilla_plot.vega.container(plot_size,aspect_ratio),pinkgorilla.ui.gorilla_plot.vega.data_from_list(series_name,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,categories,values)),pinkgorilla.ui.gorilla_plot.vega.bar_chart_marks(series_name,(function (){var or__4126__auto__ = colour;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return color;
}
})(),opacity),pinkgorilla.ui.gorilla_plot.vega.default_bar_chart_scales(series_name,plot_range),pinkgorilla.ui.gorilla_plot.vega.default_plot_axes(x_title,y_title)], 0));
}));

(pinkgorilla.ui.gorilla_plot.plot.bar_chart.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.plot.bar_chart.cljs$lang$applyTo = (function (seq28803){
var G__28804 = cljs.core.first(seq28803);
var seq28803__$1 = cljs.core.next(seq28803);
var G__28805 = cljs.core.first(seq28803__$1);
var seq28803__$2 = cljs.core.next(seq28803__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28804,G__28805,seq28803__$2);
}));

/**
 * Plot the histogram of a sample.
 */
pinkgorilla.ui.gorilla_plot.plot.histogram = (function pinkgorilla$ui$gorilla_plot$plot$histogram(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28845 = arguments.length;
var i__4737__auto___28846 = (0);
while(true){
if((i__4737__auto___28846 < len__4736__auto___28845)){
args__4742__auto__.push((arguments[i__4737__auto___28846]));

var G__28847 = (i__4737__auto___28846 + (1));
i__4737__auto___28846 = G__28847;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.plot.histogram.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.plot.histogram.cljs$core$IFn$_invoke$arity$variadic = (function (data,p__28816){
var map__28817 = p__28816;
var map__28817__$1 = (((((!((map__28817 == null))))?(((((map__28817.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28817.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28817):map__28817);
var plot_range = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28817__$1,new cljs.core.Keyword(null,"plot-range","plot-range",-1426783143),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.Keyword(null,"all","all",892129742)], null));
var colour = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28817__$1,new cljs.core.Keyword(null,"colour","colour",2137094554));
var y_title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28817__$1,new cljs.core.Keyword(null,"y-title","y-title",220785852));
var normalize = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28817__$1,new cljs.core.Keyword(null,"normalize","normalize",-1904390051));
var fill_opacity = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28817__$1,new cljs.core.Keyword(null,"fill-opacity","fill-opacity",-537571170),0.4);
var aspect_ratio = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28817__$1,new cljs.core.Keyword(null,"aspect-ratio","aspect-ratio",1674013504),1.618);
var color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28817__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var x_title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28817__$1,new cljs.core.Keyword(null,"x-title","x-title",698054088));
var bins = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28817__$1,new cljs.core.Keyword(null,"bins","bins",1670395210),new cljs.core.Keyword(null,"automatic","automatic",104479799));
var plot_size = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28817__$1,new cljs.core.Keyword(null,"plot-size","plot-size",1218885548),(400));
var normalise = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28817__$1,new cljs.core.Keyword(null,"normalise","normalise",-1794807087));
var opacity = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28817__$1,new cljs.core.Keyword(null,"opacity","opacity",397153780),(1));
var bin_range_spec = cljs.core.first(plot_range);
var range_min = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(bin_range_spec,new cljs.core.Keyword(null,"all","all",892129742)))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,data):cljs.core.first(bin_range_spec));
var range_max_raw = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(bin_range_spec,new cljs.core.Keyword(null,"all","all",892129742)))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,data):cljs.core.second(bin_range_spec));
var range_max = (range_max_raw + Math.ulp(range_max_raw));
var points_in_range = pinkgorilla.ui.gorilla_plot.util.count_in_range(data,range_min,range_max);
var num_bins = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(bins,new cljs.core.Keyword(null,"automatic","automatic",104479799)))?Math.ceil(((1) + (Math.log(points_in_range) / Math.log((2))))):bins);
var bin_size_raw = ((range_max - range_min) / num_bins);
var bin_size = (((bin_size_raw < 1.0E-15))?1.0:bin_size_raw);
var cat_counts = pinkgorilla.ui.gorilla_plot.util.bin_counts(data,range_min,range_max,bin_size);
var norm = (function (){var G__28819 = (function (){var or__4126__auto__ = normalize;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = normalise;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return new cljs.core.Keyword(null,"count","count",2139924085);
}
}
})();
var G__28819__$1 = (((G__28819 instanceof cljs.core.Keyword))?G__28819.fqn:null);
switch (G__28819__$1) {
case "probability":
return cljs.core.count(data);

break;
case "probability-density":
return (cljs.core.count(data) * bin_size);

break;
case "count":
return (1);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28819__$1)].join('')));

}
})();
var cat_data = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__28811_SHARP_){
return (p1__28811_SHARP_ / norm);
}),cat_counts);
var series_name = pinkgorilla.ui.gorilla_plot.util.gen_uuid();
var x_data = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,bin_size),cljs.core.range.cljs$core$IFn$_invoke$arity$3((range_min - bin_size),(range_max + bin_size),bin_size));
var y_data = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cat_data,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null)], 0));
var plot_data = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,x_data,y_data);
return pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pinkgorilla.ui.gorilla_plot.vega.container(plot_size,aspect_ratio),pinkgorilla.ui.gorilla_plot.vega.data_from_list(series_name,plot_data),pinkgorilla.ui.gorilla_plot.vega.histogram_marks(series_name,(function (){var or__4126__auto__ = colour;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return color;
}
})(),opacity,fill_opacity),pinkgorilla.ui.gorilla_plot.vega.default_list_plot_scales(series_name,plot_range),pinkgorilla.ui.gorilla_plot.vega.default_plot_axes(x_title,y_title)], 0));
}));

(pinkgorilla.ui.gorilla_plot.plot.histogram.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.plot.histogram.cljs$lang$applyTo = (function (seq28814){
var G__28815 = cljs.core.first(seq28814);
var seq28814__$1 = cljs.core.next(seq28814);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28815,seq28814__$1);
}));

pinkgorilla.ui.gorilla_plot.plot.compose = (function pinkgorilla$ui$gorilla_plot$plot$compose(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28849 = arguments.length;
var i__4737__auto___28850 = (0);
while(true){
if((i__4737__auto___28850 < len__4736__auto___28849)){
args__4742__auto__.push((arguments[i__4737__auto___28850]));

var G__28851 = (i__4737__auto___28850 + (1));
i__4737__auto___28850 = G__28851;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.plot.compose.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.plot.compose.cljs$core$IFn$_invoke$arity$variadic = (function (plots){
var first_plot = cljs.core.first(plots);
var map__28824 = first_plot;
var map__28824__$1 = (((((!((map__28824 == null))))?(((((map__28824.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28824.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28824):map__28824);
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28824__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28824__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var padding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28824__$1,new cljs.core.Keyword(null,"padding","padding",1660304693));
var scales = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28824__$1,new cljs.core.Keyword(null,"scales","scales",-1197224722));
var axes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28824__$1,new cljs.core.Keyword(null,"axes","axes",1970866440));
var data = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"data","data",-232669377),plots));
var marks = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"marks","marks",-1844991497),plots));
return cljs.core.with_meta(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"width","width",-384071477),width,new cljs.core.Keyword(null,"height","height",1025178622),height,new cljs.core.Keyword(null,"padding","padding",1660304693),padding,new cljs.core.Keyword(null,"scales","scales",-1197224722),scales,new cljs.core.Keyword(null,"axes","axes",1970866440),axes,new cljs.core.Keyword(null,"data","data",-232669377),data,new cljs.core.Keyword(null,"marks","marks",-1844991497),marks], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("p","render-as","p/render-as",-1497012127),new cljs.core.Keyword("p","vega","p/vega",-1657842969)], null));
}));

(pinkgorilla.ui.gorilla_plot.plot.compose.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.plot.compose.cljs$lang$applyTo = (function (seq28823){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28823));
}));


//# sourceMappingURL=pinkgorilla.ui.gorilla_plot.plot.js.map
