goog.provide('pinkgorilla.ui.gorilla_plot.multi');
goog.require('cljs.core');
goog.require('cljs_time.core');
goog.require('cljs_time.coerce');
/**
 * vega-lite container (version 4)
 */
pinkgorilla.ui.gorilla_plot.multi.container_lite = (function pinkgorilla$ui$gorilla_plot$multi$container_lite(){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"$schema","$schema",1635092088),"https://vega.github.io/schema/vega-lite/v4.json"], null);
});
pinkgorilla.ui.gorilla_plot.multi.make_time_axis = (function pinkgorilla$ui$gorilla_plot$multi$make_time_axis(size){
var start_dt = cljs_time.core.plus.cljs$core$IFn$_invoke$arity$2(cljs_time.core.today_at.cljs$core$IFn$_invoke$arity$2((12),(0)),cljs_time.core.months.cljs$core$IFn$_invoke$arity$1(((-1) * size)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs_time.coerce.to_long(cljs_time.core.plus.cljs$core$IFn$_invoke$arity$2(start_dt,cljs_time.core.months.cljs$core$IFn$_invoke$arity$1((idx + (1)))));
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(size));
});
pinkgorilla.ui.gorilla_plot.multi.make_linear_axis = (function pinkgorilla$ui$gorilla_plot$multi$make_linear_axis(size){
return cljs.core.range.cljs$core$IFn$_invoke$arity$1(size);
});
/**
 * converts a series [vector of number]
 * to a vega data spec with name
 */
pinkgorilla.ui.gorilla_plot.multi.convert_series = (function pinkgorilla$ui$gorilla_plot$multi$convert_series(series,time){
var time_sanitized = (cljs.core.truth_(time)?time:pinkgorilla.ui.gorilla_plot.multi.make_time_axis(cljs.core.count(series)));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"values","values",372645556),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3((function (x,y){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"x","x",2099068185),x,new cljs.core.Keyword(null,"y","y",-1757859776),y], null);
}),time_sanitized,series))], null);
});
/**
 * builds a vega lite plot-spec for a single series
 */
pinkgorilla.ui.gorilla_plot.multi.build_series_rect = (function pinkgorilla$ui$gorilla_plot$multi$build_series_rect(width,_,___$1,m){
var map__29482 = m;
var map__29482__$1 = (((((!((map__29482 == null))))?(((((map__29482.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29482.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29482):map__29482);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29482__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29482__$1,new cljs.core.Keyword(null,"height","height",1025178622));
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(cljs.core.truth_(height)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"height","height",1025178622),height], null):null),(cljs.core.truth_(width)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"width","width",-384071477),width], null):null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"mark","mark",-373816345),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),"rect"], null),new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"values","values",372645556),data], null),new cljs.core.Keyword(null,"encoding","encoding",1728578272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"field","field",-1302436500),"start",new cljs.core.Keyword(null,"type","type",1174270348),"temporal"], null),new cljs.core.Keyword(null,"x2","x2",-1362513475),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),"end"], null),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),"color"], null)], null)], null)], 0));
});
/**
 * builds a vega lite plot-spec for a single series
 */
pinkgorilla.ui.gorilla_plot.multi.build_series_all = (function pinkgorilla$ui$gorilla_plot$multi$build_series_all(width,time,last_QMARK_,m){
var map__29484 = m;
var map__29484__$1 = (((((!((map__29484 == null))))?(((((map__29484.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29484.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29484):map__29484);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29484__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var color = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29484__$1,new cljs.core.Keyword(null,"color","color",1011675173),"#85C5A6");
var title = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29484__$1,new cljs.core.Keyword(null,"title","title",636505583),null);
var orient = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29484__$1,new cljs.core.Keyword(null,"orient","orient",1933743565),"left");
var height = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29484__$1,new cljs.core.Keyword(null,"height","height",1025178622),null);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29484__$1,new cljs.core.Keyword(null,"type","type",1174270348),"point");
var scale = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29484__$1,new cljs.core.Keyword(null,"scale","scale",-230427353),"linear");
var zero_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29484__$1,new cljs.core.Keyword(null,"zero?","zero?",-1314772630),true);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(cljs.core.truth_(height)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"height","height",1025178622),height], null):null),(cljs.core.truth_(width)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"width","width",-384071477),width], null):null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"mark","mark",-373816345),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"color","color",1011675173),color], null),new cljs.core.Keyword(null,"data","data",-232669377),pinkgorilla.ui.gorilla_plot.multi.convert_series(data,time),new cljs.core.Keyword(null,"encoding","encoding",1728578272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"field","field",-1302436500),"x",new cljs.core.Keyword(null,"type","type",1174270348),"temporal",new cljs.core.Keyword(null,"axis","axis",-1215390822),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"title","title",636505583),"",new cljs.core.Keyword(null,"labels","labels",-626734591),last_QMARK_], null)], null),new cljs.core.Keyword(null,"y","y",-1757859776),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(cljs.core.truth_(title)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"axis","axis",-1215390822),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"title","title",636505583),title,new cljs.core.Keyword(null,"titleColor","titleColor",608094610),"black",new cljs.core.Keyword(null,"orient","orient",1933743565),orient], null)], null):null),(cljs.core.truth_(scale)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"scale","scale",-230427353),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),scale,new cljs.core.Keyword(null,"zero","zero",-858964576),zero_QMARK_], null)], null):null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"field","field",-1302436500),"y",new cljs.core.Keyword(null,"type","type",1174270348),"quantitative"], null)], 0))], null)], null)], 0));
});
pinkgorilla.ui.gorilla_plot.multi.build_series = (function pinkgorilla$ui$gorilla_plot$multi$build_series(width,time,last_QMARK_,m){
var type = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m);
var G__29486 = type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"rect","rect",-108902628),G__29486)){
return pinkgorilla.ui.gorilla_plot.multi.build_series_rect(width,time,last_QMARK_,m);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("rect",G__29486)){
return pinkgorilla.ui.gorilla_plot.multi.build_series_rect(width,time,last_QMARK_,m);
} else {
return pinkgorilla.ui.gorilla_plot.multi.build_series_all(width,time,last_QMARK_,m);

}
}
});
/**
 * builds a plot that can contain one or more series
 */
pinkgorilla.ui.gorilla_plot.multi.build_plot = (function pinkgorilla$ui$gorilla_plot$multi$build_plot(width,time,last_QMARK_,series){
if(cljs.core.vector_QMARK_(series)){
if((cljs.core.count(series) > (1))){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"layer","layer",-1601820589),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$4(pinkgorilla.ui.gorilla_plot.multi.build_plot,width,time,last_QMARK_),series)),new cljs.core.Keyword(null,"resolve","resolve",-1584445482),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"scale","scale",-230427353),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"y","y",-1757859776),"independent"], null)], null)], null);
} else {
return pinkgorilla.ui.gorilla_plot.multi.build_series(width,time,last_QMARK_,cljs.core.first(series));
}
} else {
return pinkgorilla.ui.gorilla_plot.multi.build_series(width,time,last_QMARK_,series);
}
});
/**
 * builds one or more plots.
 * multiple plots are organized vertically
 */
pinkgorilla.ui.gorilla_plot.multi.build_plots = (function pinkgorilla$ui$gorilla_plot$multi$build_plots(var_args){
var args__4742__auto__ = [];
var len__4736__auto___29497 = arguments.length;
var i__4737__auto___29498 = (0);
while(true){
if((i__4737__auto___29498 < len__4736__auto___29497)){
args__4742__auto__.push((arguments[i__4737__auto___29498]));

var G__29499 = (i__4737__auto___29498 + (1));
i__4737__auto___29498 = G__29499;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.multi.build_plots.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.multi.build_plots.cljs$core$IFn$_invoke$arity$variadic = (function (width,time,plots){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(plots),(1))){
return pinkgorilla.ui.gorilla_plot.multi.build_plot(width,time,true,cljs.core.first(plots));
} else {
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"vconcat","vconcat",-2012274180),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$4(pinkgorilla.ui.gorilla_plot.multi.build_plot,width,time,false),cljs.core.butlast(plots))),pinkgorilla.ui.gorilla_plot.multi.build_plot(width,time,true,cljs.core.last(plots)))], null);
}
}));

(pinkgorilla.ui.gorilla_plot.multi.build_plots.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.multi.build_plots.cljs$lang$applyTo = (function (seq29487){
var G__29488 = cljs.core.first(seq29487);
var seq29487__$1 = cljs.core.next(seq29487);
var G__29489 = cljs.core.first(seq29487__$1);
var seq29487__$2 = cljs.core.next(seq29487__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29488,G__29489,seq29487__$2);
}));

/**
 * plots one or more timeseries plots (stacked vertically)
 * input: [options vector-of-plots]
 * 
 * options
 * - is optional
 * - if specified, a map with optional keys:
 *   :width (pixels)
 *   :time (time data as unix-long)
 * 
 * a plot contains either 
 * - one series (map)
 * - more series (vector of maps)
 * 
 * a series is a map
 * - mandatory keys:
 *    :data - vector of (length n)
 * - optional keys:
 *    :color
 *    :orient   :left :right
 *    :title   (of the axis)    
 *    :height
 *    :width
 * 
 * example:
 * (def a [1 2 4 3 2])
 * (def b [-1 1 -2 3 0])
 * (def c [6 5 1 7 5])
 * 
 * (multi-plot {:width 100} 
 *    {:data c :orient :left :title "C" :color "blue" :height 20 } 
 *    [{:data a :orient :right :title "A" :color "red" :height 50} 
 *    {:data b :orient :left :title "B" :height 50}])) 
 *   
 * note that the first plot is single series (therefore a map), 
 * the second plot has 2 series (vector of maps)
 *  
 */
pinkgorilla.ui.gorilla_plot.multi.multi_plot = (function pinkgorilla$ui$gorilla_plot$multi$multi_plot(var_args){
var args__4742__auto__ = [];
var len__4736__auto___29505 = arguments.length;
var i__4737__auto___29507 = (0);
while(true){
if((i__4737__auto___29507 < len__4736__auto___29505)){
args__4742__auto__.push((arguments[i__4737__auto___29507]));

var G__29508 = (i__4737__auto___29507 + (1));
i__4737__auto___29507 = G__29508;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.multi.multi_plot.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.multi.multi_plot.cljs$core$IFn$_invoke$arity$variadic = (function (plots){
var vec__29491 = ((cljs.core.map_QMARK_(cljs.core.first(plots)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(plots),cljs.core.rest(plots)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,plots], null));
var args = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29491,(0),null);
var plots__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29491,(1),null);
var map__29494 = args;
var map__29494__$1 = (((((!((map__29494 == null))))?(((((map__29494.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29494.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29494):map__29494);
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29494__$1,new cljs.core.Keyword(null,"width","width",-384071477),(800));
var time = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29494__$1,new cljs.core.Keyword(null,"time","time",1385887882),null);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pinkgorilla.ui.gorilla_plot.multi.container_lite(),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(pinkgorilla.ui.gorilla_plot.multi.build_plots,width,time),plots__$1)], 0));
}));

(pinkgorilla.ui.gorilla_plot.multi.multi_plot.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.multi.multi_plot.cljs$lang$applyTo = (function (seq29490){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29490));
}));


//# sourceMappingURL=pinkgorilla.ui.gorilla_plot.multi.js.map
