goog.provide('goldly.puppet.loader');
goog.require('cljs.core');
goog.require('goog.History');
goog.require('cljs.pprint');
goog.require('taoensso.timbre');
goog.require('reagent.core');
goog.require('re_frame.core');
goog.require('bidi.bidi');
goog.require('goldly.web.routes');
goog.require('goldly.system');
goog.require('goldly.events');
goog.require('goldly.puppet.subs');
goldly.puppet.loader.error_boundary = (function goldly$puppet$loader$error_boundary(_){
var error = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var info = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(null);
return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"component-did-catch","component-did-catch",652725810),(function (___$1,___$2,i){
return cljs.core.reset_BANG_(info,i);
}),new cljs.core.Keyword(null,"get-derived-state-from-error","get-derived-state-from-error",1473896468),(function (e){
cljs.core.reset_BANG_(error,e);

return ({});
}),new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),(function (comp){
if(cljs.core.truth_(cljs.core.deref(error))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),"Something went wrong.",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(error))], null)], null);
} else {
return comp;
}
})], null));
});
goldly.puppet.loader.system_loading = (function goldly$puppet$loader$system_loading(id){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.bg-orange-300.m-16","div.bg-orange-300.m-16",2053233810),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h1","h1",-1896887462),"loading system "], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),id], null)], null);
});
goldly.puppet.loader.system_nil = (function goldly$puppet$loader$system_nil(id){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.bg-red-500.m-16","div.bg-red-500.m-16",2088004196),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h1","h1",-1896887462),"system does not exist!"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),id], null)], null);
});
/**
 * requests system with id from server
 * and displays it.
 */
goldly.puppet.loader.system = (function goldly$puppet$loader$system(id){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"goldly.puppet.loader","/tmp/form-init4367801117013088455.clj",46,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["showing system: ",id], null);
}),null)),null,-375793095);

var G__43202_43206 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("goldly","system-store","goldly/system-store",-2008850013),new cljs.core.Keyword("g","system-loading","g/system-loading",276604425)], null);
(re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1(G__43202_43206) : re_frame.core.dispatch_sync.call(null,G__43202_43206));

var G__43203_43207 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("goldly","send","goldly/send",181321881),new cljs.core.Keyword("goldly","system","goldly/system",1429584215),id], null);
(re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__43203_43207) : re_frame.core.dispatch.call(null,G__43203_43207));

var system = (function (){var G__43204 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"system","system",-29381724)], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__43204) : re_frame.core.subscribe.call(null,G__43204));
})();
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"<>","<>",1280186386),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"m-2 bg-blue-200 border-dotted border-orange-400",new cljs.core.Keyword(null,"href","href",-793805698),bidi.bidi.path_for(goldly.web.routes.app_routes,new cljs.core.Keyword(null,"main","main",-2117802661))], null),"Systems"], null),(function (){var G__43205 = cljs.core.deref(system);
var G__43205__$1 = (((G__43205 instanceof cljs.core.Keyword))?G__43205.fqn:null);
switch (G__43205__$1) {
case "g/system-nil":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [goldly.puppet.loader.system_nil,id], null);

break;
case "g/system-loading":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [goldly.puppet.loader.system_loading,id], null);

break;
default:
if((cljs.core.deref(system) == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h1","h1",-1896887462),"something is broken"], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"<>","<>",1280186386),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h1.bg-orange-300","h1.bg-orange-300",-521715806),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(system)))," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)].join('')], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [goldly.puppet.loader.error_boundary,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [goldly.system.render_system,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(system))], null),new cljs.core.Keyword(null,"cljs","cljs",1492417629).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(system)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"fns-clj","fns-clj",1003510986),new cljs.core.Keyword(null,"fns-clj","fns-clj",1003510986).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(system))], null)], 0))], null)], null)], null);
}

}
})()], null);
});
});

//# sourceMappingURL=goldly.puppet.loader.js.map
