goog.provide('com.rpl.specter');
goog.require('cljs.core');
goog.require('com.rpl.specter.protocols');
goog.require('com.rpl.specter.impl');
goog.require('com.rpl.specter.navs');
goog.require('clojure.set');
com.rpl.specter.static_path_QMARK_ = (function com$rpl$specter$static_path_QMARK_(path){
if(cljs.core.sequential_QMARK_(path)){
return cljs.core.every_QMARK_(com.rpl.specter.static_path_QMARK_,path);
} else {
return (!(com.rpl.specter.impl.dynamic_param_QMARK_(path)));
}
});
com.rpl.specter.wrap_dynamic_nav = (function com$rpl$specter$wrap_dynamic_nav(f){
return (function() { 
var G__43029__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
if(((cljs.core.sequential_QMARK_(ret)) && (com.rpl.specter.static_path_QMARK_(ret)))){
return com.rpl.specter.impl.comp_paths_STAR_(ret);
} else {
if(((cljs.core.sequential_QMARK_(ret)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(ret))))){
return cljs.core.first(ret);
} else {
return ret;

}
}
};
var G__43029 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__43030__i = 0, G__43030__a = new Array(arguments.length -  0);
while (G__43030__i < G__43030__a.length) {G__43030__a[G__43030__i] = arguments[G__43030__i + 0]; ++G__43030__i;}
  args = new cljs.core.IndexedSeq(G__43030__a,0,null);
} 
return G__43029__delegate.call(this,args);};
G__43029.cljs$lang$maxFixedArity = 0;
G__43029.cljs$lang$applyTo = (function (arglist__43031){
var args = cljs.core.seq(arglist__43031);
return G__43029__delegate(args);
});
G__43029.cljs$core$IFn$_invoke$arity$variadic = G__43029__delegate;
return G__43029;
})()
;
});
/**
 * Returns a compiled version of the given path for use with
 * compiled-{select/transform/setval/etc.} functions.
 */
com.rpl.specter.comp_paths = (function com$rpl$specter$comp_paths(var_args){
var args__4742__auto__ = [];
var len__4736__auto___43032 = arguments.length;
var i__4737__auto___43033 = (0);
while(true){
if((i__4737__auto___43033 < len__4736__auto___43032)){
args__4742__auto__.push((arguments[i__4737__auto___43033]));

var G__43034 = (i__4737__auto___43033 + (1));
i__4737__auto___43033 = G__43034;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic = (function (apath){
return com.rpl.specter.impl.comp_paths_STAR_(cljs.core.vec(apath));
}));

(com.rpl.specter.comp_paths.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.rpl.specter.comp_paths.cljs$lang$applyTo = (function (seq42711){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42711));
}));

/**
 * Version of select that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select = com.rpl.specter.impl.compiled_select_STAR_;
/**
 * Navigates to and returns a sequence of all the elements specified by the path.
 */
com.rpl.specter.select_STAR_ = (function com$rpl$specter$select_STAR_(path,structure){
var G__42712 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__42713 = structure;
return (com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(G__42712,G__42713) : com.rpl.specter.compiled_select.call(null,G__42712,G__42713));
});
/**
 * Version of select-one that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one = com.rpl.specter.impl.compiled_select_one_STAR_;
/**
 * Like select, but returns either one element or nil. Throws exception if multiple elements found
 */
com.rpl.specter.select_one_STAR_ = (function com$rpl$specter$select_one_STAR_(path,structure){
var G__42714 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__42715 = structure;
return (com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(G__42714,G__42715) : com.rpl.specter.compiled_select_one.call(null,G__42714,G__42715));
});
/**
 * Version of select-one! that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one_BANG_ = com.rpl.specter.impl.compiled_select_one_BANG__STAR_;
/**
 * Returns exactly one element, throws exception if zero or multiple elements found
 */
com.rpl.specter.select_one_BANG__STAR_ = (function com$rpl$specter$select_one_BANG__STAR_(path,structure){
var G__42716 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__42717 = structure;
return (com.rpl.specter.compiled_select_one_BANG_.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one_BANG_.cljs$core$IFn$_invoke$arity$2(G__42716,G__42717) : com.rpl.specter.compiled_select_one_BANG_.call(null,G__42716,G__42717));
});
/**
 * Version of select-first that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_first = com.rpl.specter.impl.compiled_select_first_STAR_;
/**
 * Returns first element found.
 */
com.rpl.specter.select_first_STAR_ = (function com$rpl$specter$select_first_STAR_(path,structure){
var G__42718 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__42719 = structure;
return (com.rpl.specter.compiled_select_first.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_first.cljs$core$IFn$_invoke$arity$2(G__42718,G__42719) : com.rpl.specter.compiled_select_first.call(null,G__42718,G__42719));
});
/**
 * Version of select-any that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_any = com.rpl.specter.impl.compiled_select_any_STAR_;
/**
 * Global value used to indicate no elements selected during
 *           [[select-any]].
 */
com.rpl.specter.NONE = com.rpl.specter.impl.NONE;
/**
 * Returns any element found or [[NONE]] if nothing selected. This is the most
 * efficient of the various selection operations.
 */
com.rpl.specter.select_any_STAR_ = (function com$rpl$specter$select_any_STAR_(path,structure){
var G__42720 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__42721 = structure;
return (com.rpl.specter.compiled_select_any.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_any.cljs$core$IFn$_invoke$arity$2(G__42720,G__42721) : com.rpl.specter.compiled_select_any.call(null,G__42720,G__42721));
});
/**
 * Version of selected-any? that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_selected_any_QMARK_ = com.rpl.specter.impl.compiled_selected_any_QMARK__STAR_;
/**
 * Returns true if any element was selected, false otherwise.
 */
com.rpl.specter.selected_any_QMARK__STAR_ = (function com$rpl$specter$selected_any_QMARK__STAR_(path,structure){
var G__42722 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__42723 = structure;
return (com.rpl.specter.compiled_selected_any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_selected_any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__42722,G__42723) : com.rpl.specter.compiled_selected_any_QMARK_.call(null,G__42722,G__42723));
});
/**
 * Version of traverse that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse = com.rpl.specter.impl.do_compiled_traverse;
/**
 * Return a reducible object that traverses over `structure` to every element
 * specified by the path
 */
com.rpl.specter.traverse_STAR_ = (function com$rpl$specter$traverse_STAR_(apath,structure){
var G__42724 = com.rpl.specter.impl.comp_paths_STAR_(apath);
var G__42725 = structure;
return (com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(G__42724,G__42725) : com.rpl.specter.compiled_traverse.call(null,G__42724,G__42725));
});
/**
 * Version of traverse-all that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse_all = com.rpl.specter.impl.compiled_traverse_all_STAR_;
/**
 * Returns a transducer that traverses over each element with the given path.
 */
com.rpl.specter.traverse_all_STAR_ = (function com$rpl$specter$traverse_all_STAR_(apath){
var G__42726 = com.rpl.specter.impl.comp_paths_STAR_(apath);
return (com.rpl.specter.compiled_traverse_all.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.compiled_traverse_all.cljs$core$IFn$_invoke$arity$1(G__42726) : com.rpl.specter.compiled_traverse_all.call(null,G__42726));
});
/**
 * Version of transform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_transform = com.rpl.specter.impl.compiled_transform_STAR_;
/**
 * Version of vtransform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_vtransform = com.rpl.specter.impl.compiled_vtransform_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by the result of running
 *   the transform-fn on it
 */
com.rpl.specter.transform_STAR_ = (function com$rpl$specter$transform_STAR_(path,transform_fn,structure){
var G__42727 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__42728 = transform_fn;
var G__42729 = structure;
return (com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(G__42727,G__42728,G__42729) : com.rpl.specter.compiled_transform.call(null,G__42727,G__42728,G__42729));
});
/**
 * Version of `multi-transform` that takes in a path precompiled with `comp-paths`
 */
com.rpl.specter.compiled_multi_transform = com.rpl.specter.impl.compiled_multi_transform_STAR_;
/**
 * Just like `transform` but expects transform functions to be specified
 * inline in the path using `terminal` or `vterminal`. Error is thrown if navigation finishes
 * at a non-terminal navigator. `terminal-val` is a wrapper around `terminal` and is
 * the `multi-transform` equivalent of `setval`.
 */
com.rpl.specter.multi_transform_STAR_ = (function com$rpl$specter$multi_transform_STAR_(path,structure){
var G__42730 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__42731 = structure;
return (com.rpl.specter.compiled_multi_transform.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_multi_transform.cljs$core$IFn$_invoke$arity$2(G__42730,G__42731) : com.rpl.specter.compiled_multi_transform.call(null,G__42730,G__42731));
});
/**
 * Version of setval that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_setval = com.rpl.specter.impl.compiled_setval_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by val
 */
com.rpl.specter.setval_STAR_ = (function com$rpl$specter$setval_STAR_(path,val,structure){
var G__42732 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__42733 = val;
var G__42734 = structure;
return (com.rpl.specter.compiled_setval.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_setval.cljs$core$IFn$_invoke$arity$3(G__42732,G__42733,G__42734) : com.rpl.specter.compiled_setval.call(null,G__42732,G__42733,G__42734));
});
/**
 * Version of replace-in that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_replace_in = com.rpl.specter.impl.compiled_replace_in_STAR_;
/**
 * Similar to transform, except returns a pair of [transformed-structure sequence-of-user-ret].
 * The transform-fn in this case is expected to return [ret user-ret]. ret is
 * what's used to transform the data structure, while user-ret will be added to the user-ret sequence
 * in the final return. replace-in is useful for situations where you need to know the specific values
 * of what was transformed in the data structure.
 */
com.rpl.specter.replace_in_STAR_ = (function com$rpl$specter$replace_in_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___43037 = arguments.length;
var i__4737__auto___43038 = (0);
while(true){
if((i__4737__auto___43038 < len__4736__auto___43037)){
args__4742__auto__.push((arguments[i__4737__auto___43038]));

var G__43039 = (i__4737__auto___43038 + (1));
i__4737__auto___43038 = G__43039;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (path,transform_fn,structure,p__42739){
var map__42740 = p__42739;
var map__42740__$1 = (((((!((map__42740 == null))))?(((((map__42740.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42740.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42740):map__42740);
var merge_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42740__$1,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),cljs.core.concat);
var G__42742 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__42743 = transform_fn;
var G__42744 = structure;
var G__42745 = new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341);
var G__42746 = merge_fn;
return (com.rpl.specter.compiled_replace_in.cljs$core$IFn$_invoke$arity$5 ? com.rpl.specter.compiled_replace_in.cljs$core$IFn$_invoke$arity$5(G__42742,G__42743,G__42744,G__42745,G__42746) : com.rpl.specter.compiled_replace_in.call(null,G__42742,G__42743,G__42744,G__42745,G__42746));
}));

(com.rpl.specter.replace_in_STAR_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(com.rpl.specter.replace_in_STAR_.cljs$lang$applyTo = (function (seq42735){
var G__42736 = cljs.core.first(seq42735);
var seq42735__$1 = cljs.core.next(seq42735);
var G__42737 = cljs.core.first(seq42735__$1);
var seq42735__$2 = cljs.core.next(seq42735__$1);
var G__42738 = cljs.core.first(seq42735__$2);
var seq42735__$3 = cljs.core.next(seq42735__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__42736,G__42737,G__42738,seq42735__$3);
}));

com.rpl.specter.late_path = com.rpl.specter.impl.late_path;
com.rpl.specter.dynamic_param_QMARK_ = com.rpl.specter.impl.dynamic_param_QMARK_;
com.rpl.specter.late_resolved_fn = com.rpl.specter.impl.late_resolved_fn;
/**
 * Turns a navigator that takes one argument into a navigator that takes
 *        many arguments and uses the same navigator with each argument. There
 *        is no performance cost to using this. See implementation of `keypath`
 */
com.rpl.specter.eachnav = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (navfn){
var latenavfn = (com.rpl.specter.late_resolved_fn.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_resolved_fn.cljs$core$IFn$_invoke$arity$1(navfn) : com.rpl.specter.late_resolved_fn.call(null,navfn));
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43040__delegate = function (args){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(latenavfn,args);
};
var G__43040 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__43041__i = 0, G__43041__a = new Array(arguments.length -  0);
while (G__43041__i < G__43041__a.length) {G__43041__a[G__43041__i] = arguments[G__43041__i + 0]; ++G__43041__i;}
  args = new cljs.core.IndexedSeq(G__43041__a,0,null);
} 
return G__43040__delegate.call(this,args);};
G__43040.cljs$lang$maxFixedArity = 0;
G__43040.cljs$lang$applyTo = (function (arglist__43042){
var args = cljs.core.seq(arglist__43042);
return G__43040__delegate(args);
});
G__43040.cljs$core$IFn$_invoke$arity$variadic = G__43040__delegate;
return G__43040;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.local_declarepath = com.rpl.specter.impl.local_declarepath;


com.rpl.specter.STOP_select_STAR_ = (function com$rpl$specter$STOP_select_STAR_(structure,next_fn){
return com.rpl.specter.NONE;
});

com.rpl.specter.STOP_transform_STAR_ = (function com$rpl$specter$STOP_transform_STAR_(structure,next_fn){
return structure;
});

/**
 * Stops navigation at this point. For selection returns nothing and for
 *        transformation returns the structure unchanged
 */
com.rpl.specter.STOP = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42747 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42747 = (function (meta42748){
this.meta42748 = meta42748;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42747.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42749,meta42748__$1){
var self__ = this;
var _42749__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42747(meta42748__$1));
}));

(com.rpl.specter.t_com$rpl$specter42747.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42749){
var self__ = this;
var _42749__$1 = this;
return self__.meta42748;
}));

(com.rpl.specter.t_com$rpl$specter42747.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42747.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter42747.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return structure;
}));

(com.rpl.specter.t_com$rpl$specter42747.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42748","meta42748",-202032111,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42747.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42747.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42747");

(com.rpl.specter.t_com$rpl$specter42747.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42747");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42747.
 */
com.rpl.specter.__GT_t_com$rpl$specter42747 = (function com$rpl$specter$__GT_t_com$rpl$specter42747(meta42748){
return (new com.rpl.specter.t_com$rpl$specter42747(meta42748));
});

}

return (new com.rpl.specter.t_com$rpl$specter42747(null));
})()
;
/**
 * Stays navigated at the current point. Essentially a no-op navigator.
 */
com.rpl.specter.STAY = com.rpl.specter.impl.STAY_STAR_;
/**
 * Defines an endpoint in the navigation the transform function run. The transform
 *        function works just like it does in `transform`, with collected values
 *        given as the first arguments
 */
com.rpl.specter.terminal = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42750 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42750 = (function (afn,meta42751){
this.afn = afn;
this.meta42751 = meta42751;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42750.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42752,meta42751__$1){
var self__ = this;
var _42752__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42750(self__.afn,meta42751__$1));
}));

(com.rpl.specter.t_com$rpl$specter42750.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42752){
var self__ = this;
var _42752__$1 = this;
return self__.meta42751;
}));

(com.rpl.specter.t_com$rpl$specter42750.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42750.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter42750.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.terminal_STAR_(self__.afn,vals,structure);
}));

(com.rpl.specter.t_com$rpl$specter42750.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta42751","meta42751",1989450818,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42750.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42750.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42750");

(com.rpl.specter.t_com$rpl$specter42750.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42750");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42750.
 */
com.rpl.specter.__GT_t_com$rpl$specter42750 = (function com$rpl$specter$__GT_t_com$rpl$specter42750(afn__$1,meta42751){
return (new com.rpl.specter.t_com$rpl$specter42750(afn__$1,meta42751));
});

}

return (new com.rpl.specter.t_com$rpl$specter42750(afn,null));
}));
/**
 * Defines an endpoint in the navigation the transform function run.The transform
 *        function works differently than it does in `transform`. Rather than receive
 *        collected vals spliced in as the first arguments to the function, this function
 *        always takes two arguemnts. The first is all collected vals in a vector, and
 *        the second is the navigated value.
 */
com.rpl.specter.vterminal = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42753 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42753 = (function (afn,meta42754){
this.afn = afn;
this.meta42754 = meta42754;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42753.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42755,meta42754__$1){
var self__ = this;
var _42755__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42753(self__.afn,meta42754__$1));
}));

(com.rpl.specter.t_com$rpl$specter42753.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42755){
var self__ = this;
var _42755__$1 = this;
return self__.meta42754;
}));

(com.rpl.specter.t_com$rpl$specter42753.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42753.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter42753.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(vals,structure) : self__.afn.call(null,vals,structure));
}));

(com.rpl.specter.t_com$rpl$specter42753.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta42754","meta42754",871830530,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42753.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42753.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42753");

(com.rpl.specter.t_com$rpl$specter42753.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42753");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42753.
 */
com.rpl.specter.__GT_t_com$rpl$specter42753 = (function com$rpl$specter$__GT_t_com$rpl$specter42753(afn__$1,meta42754){
return (new com.rpl.specter.t_com$rpl$specter42753(afn__$1,meta42754));
});

}

return (new com.rpl.specter.t_com$rpl$specter42753(afn,null));
}));
/**
 * Like `terminal` but specifies a val to set at the location regardless of
 * the collected values or the value at the location.
 */
com.rpl.specter.terminal_val = (function com$rpl$specter$terminal_val(v){
var G__42756 = com.rpl.specter.impl.fast_constantly(v);
return (com.rpl.specter.terminal.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.terminal.cljs$core$IFn$_invoke$arity$1(G__42756) : com.rpl.specter.terminal.call(null,G__42756));
});


com.rpl.specter.ALL_select_STAR_ = (function com$rpl$specter$ALL_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.ALL_transform_STAR_ = (function com$rpl$specter$ALL_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_transform(structure,next_fn);
});

/**
 * Navigate to every element of the collection. For maps navigates to
 *        a vector of `[key value]`.
 */
com.rpl.specter.ALL = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42757 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42757 = (function (meta42758){
this.meta42758 = meta42758;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42757.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42759,meta42758__$1){
var self__ = this;
var _42759__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42757(meta42758__$1));
}));

(com.rpl.specter.t_com$rpl$specter42757.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42759){
var self__ = this;
var _42759__$1 = this;
return self__.meta42758;
}));

(com.rpl.specter.t_com$rpl$specter42757.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42757.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return com.rpl.specter.navs.all_select(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42757.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return com.rpl.specter.navs.all_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42757.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42758","meta42758",-1070270311,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42757.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42757.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42757");

(com.rpl.specter.t_com$rpl$specter42757.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42757");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42757.
 */
com.rpl.specter.__GT_t_com$rpl$specter42757 = (function com$rpl$specter$__GT_t_com$rpl$specter42757(meta42758){
return (new com.rpl.specter.t_com$rpl$specter42757(meta42758));
});

}

return (new com.rpl.specter.t_com$rpl$specter42757(null));
})()
;


com.rpl.specter.ALL_WITH_META_select_STAR_ = (function com$rpl$specter$ALL_WITH_META_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.ALL_WITH_META_transform_STAR_ = (function com$rpl$specter$ALL_WITH_META_transform_STAR_(structure,next_fn){
var m = cljs.core.meta(structure);
var res = com.rpl.specter.navs.all_transform(structure,next_fn);
if((!((res == null)))){
return cljs.core.with_meta(res,m);
} else {
return null;
}
});

/**
 * Same as ALL, except maintains metadata on the structure.
 */
com.rpl.specter.ALL_WITH_META = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42760 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42760 = (function (meta42761){
this.meta42761 = meta42761;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42760.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42762,meta42761__$1){
var self__ = this;
var _42762__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42760(meta42761__$1));
}));

(com.rpl.specter.t_com$rpl$specter42760.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42762){
var self__ = this;
var _42762__$1 = this;
return self__.meta42761;
}));

(com.rpl.specter.t_com$rpl$specter42760.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42760.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return com.rpl.specter.navs.all_select(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42760.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
var m = cljs.core.meta(structure);
var res = com.rpl.specter.navs.all_transform(structure,next_fn);
if((!((res == null)))){
return cljs.core.with_meta(res,m);
} else {
return null;
}
}));

(com.rpl.specter.t_com$rpl$specter42760.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42761","meta42761",439212431,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42760.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42760.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42760");

(com.rpl.specter.t_com$rpl$specter42760.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42760");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42760.
 */
com.rpl.specter.__GT_t_com$rpl$specter42760 = (function com$rpl$specter$__GT_t_com$rpl$specter42760(meta42761){
return (new com.rpl.specter.t_com$rpl$specter42760(meta42761));
});

}

return (new com.rpl.specter.t_com$rpl$specter42760(null));
})()
;


com.rpl.specter.MAP_VALS_select_STAR_ = (function com$rpl$specter$MAP_VALS_select_STAR_(structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38664__auto__,v){
var ret__38665__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(v) : next_fn.call(null,v));
if((ret__38665__auto__ === com.rpl.specter.NONE)){
return curr__38664__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38665__auto__)){
return cljs.core.reduced(ret__38665__auto__);
} else {
return ret__38665__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals(structure));
});

com.rpl.specter.MAP_VALS_transform_STAR_ = (function com$rpl$specter$MAP_VALS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_vals_transform(structure,next_fn);
});

/**
 * Navigate to each value of the map. This is more efficient than
 *        navigating via [ALL LAST]
 */
com.rpl.specter.MAP_VALS = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42763 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42763 = (function (meta42764){
this.meta42764 = meta42764;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42763.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42765,meta42764__$1){
var self__ = this;
var _42765__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42763(meta42764__$1));
}));

(com.rpl.specter.t_com$rpl$specter42763.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42765){
var self__ = this;
var _42765__$1 = this;
return self__.meta42764;
}));

(com.rpl.specter.t_com$rpl$specter42763.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42763.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38664__auto__,v){
var ret__38665__auto__ = next_fn(v);
if((ret__38665__auto__ === com.rpl.specter.NONE)){
return curr__38664__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38665__auto__)){
return cljs.core.reduced(ret__38665__auto__);
} else {
return ret__38665__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals(structure));
}));

(com.rpl.specter.t_com$rpl$specter42763.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return com.rpl.specter.navs.map_vals_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42763.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42764","meta42764",1125708378,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42763.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42763.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42763");

(com.rpl.specter.t_com$rpl$specter42763.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42763");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42763.
 */
com.rpl.specter.__GT_t_com$rpl$specter42763 = (function com$rpl$specter$__GT_t_com$rpl$specter42763(meta42764){
return (new com.rpl.specter.t_com$rpl$specter42763(meta42764));
});

}

return (new com.rpl.specter.t_com$rpl$specter42763(null));
})()
;


com.rpl.specter.MAP_KEYS_select_STAR_ = (function com$rpl$specter$MAP_KEYS_select_STAR_(structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38664__auto__,k){
var ret__38665__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(k) : next_fn.call(null,k));
if((ret__38665__auto__ === com.rpl.specter.NONE)){
return curr__38664__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38665__auto__)){
return cljs.core.reduced(ret__38665__auto__);
} else {
return ret__38665__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys(structure));
});

com.rpl.specter.MAP_KEYS_transform_STAR_ = (function com$rpl$specter$MAP_KEYS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_keys_transform(structure,next_fn);
});

/**
 * Navigate to each key of the map. This is more efficient than
 *        navigating via [ALL FIRST]
 */
com.rpl.specter.MAP_KEYS = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42766 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42766 = (function (meta42767){
this.meta42767 = meta42767;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42766.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42768,meta42767__$1){
var self__ = this;
var _42768__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42766(meta42767__$1));
}));

(com.rpl.specter.t_com$rpl$specter42766.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42768){
var self__ = this;
var _42768__$1 = this;
return self__.meta42767;
}));

(com.rpl.specter.t_com$rpl$specter42766.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42766.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38664__auto__,k){
var ret__38665__auto__ = next_fn(k);
if((ret__38665__auto__ === com.rpl.specter.NONE)){
return curr__38664__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38665__auto__)){
return cljs.core.reduced(ret__38665__auto__);
} else {
return ret__38665__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys(structure));
}));

(com.rpl.specter.t_com$rpl$specter42766.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return com.rpl.specter.navs.map_keys_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42766.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42767","meta42767",-943765708,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42766.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42766.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42766");

(com.rpl.specter.t_com$rpl$specter42766.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42766");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42766.
 */
com.rpl.specter.__GT_t_com$rpl$specter42766 = (function com$rpl$specter$__GT_t_com$rpl$specter42766(meta42767){
return (new com.rpl.specter.t_com$rpl$specter42766(meta42767));
});

}

return (new com.rpl.specter.t_com$rpl$specter42766(null));
})()
;
com.rpl.specter.VAL = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42769 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42769 = (function (meta42770){
this.meta42770 = meta42770;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42769.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42771,meta42770__$1){
var self__ = this;
var _42771__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42769(meta42770__$1));
}));

(com.rpl.specter.t_com$rpl$specter42769.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42771){
var self__ = this;
var _42771__$1 = this;
return self__.meta42770;
}));

(com.rpl.specter.t_com$rpl$specter42769.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42769.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41678__auto__,vals__41679__auto__,structure,next_fn__41680__auto__){
var self__ = this;
var this__41678__auto____$1 = this;
var G__42772 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__41679__auto__,structure);
var G__42773 = structure;
return (next_fn__41680__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41680__auto__.cljs$core$IFn$_invoke$arity$2(G__42772,G__42773) : next_fn__41680__auto__.call(null,G__42772,G__42773));
}));

(com.rpl.specter.t_com$rpl$specter42769.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41678__auto__,vals__41679__auto__,structure,next_fn__41680__auto__){
var self__ = this;
var this__41678__auto____$1 = this;
var G__42774 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__41679__auto__,structure);
var G__42775 = structure;
return (next_fn__41680__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41680__auto__.cljs$core$IFn$_invoke$arity$2(G__42774,G__42775) : next_fn__41680__auto__.call(null,G__42774,G__42775));
}));

(com.rpl.specter.t_com$rpl$specter42769.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42770","meta42770",1019193231,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42769.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42769.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42769");

(com.rpl.specter.t_com$rpl$specter42769.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42769");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42769.
 */
com.rpl.specter.__GT_t_com$rpl$specter42769 = (function com$rpl$specter$__GT_t_com$rpl$specter42769(meta42770){
return (new com.rpl.specter.t_com$rpl$specter42769(meta42770));
});

}

return (new com.rpl.specter.t_com$rpl$specter42769(null));
})()
;
/**
 * Navigate to the last element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.LAST = (com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last) : com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last));
/**
 * Navigate to the first element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.FIRST = (com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first) : com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first));


com.rpl.specter.srange_dynamic_select_STAR_ = (function com$rpl$specter$srange_dynamic_select_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = (start_index_fn.cljs$core$IFn$_invoke$arity$1 ? start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : start_index_fn.call(null,structure));
return com.rpl.specter.navs.srange_select(structure,s,com.rpl.specter.navs.invoke_end_fn(end_index_fn,structure,s),next_fn);
});

com.rpl.specter.srange_dynamic_transform_STAR_ = (function com$rpl$specter$srange_dynamic_transform_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = (start_index_fn.cljs$core$IFn$_invoke$arity$1 ? start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : start_index_fn.call(null,structure));
var G__42776 = structure;
var G__42777 = s;
var G__42778 = com.rpl.specter.navs.invoke_end_fn(end_index_fn,structure,s);
var G__42779 = next_fn;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(G__42776,G__42777,G__42778,G__42779) : com.rpl.specter.navs.srange_transform.call(null,G__42776,G__42777,G__42778,G__42779));
});

/**
 * Uses start-index-fn and end-index-fn to determine the bounds of the subsequence
 *        to select when navigating. `start-index-fn` takes in the structure as input. `end-index-fn`
 *        can be one of two forms. If a regular function (e.g. defined with `fn`), it takes in only the structure as input. If a function defined using special `end-fn` macro, it takes in the structure and the result of `start-index-fn`.
 */
com.rpl.specter.srange_dynamic = com.rpl.specter.impl.direct_nav_obj((function (start_index_fn,end_index_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42780 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42780 = (function (start_index_fn,end_index_fn,meta42781){
this.start_index_fn = start_index_fn;
this.end_index_fn = end_index_fn;
this.meta42781 = meta42781;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42780.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42782,meta42781__$1){
var self__ = this;
var _42782__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42780(self__.start_index_fn,self__.end_index_fn,meta42781__$1));
}));

(com.rpl.specter.t_com$rpl$specter42780.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42782){
var self__ = this;
var _42782__$1 = this;
return self__.meta42781;
}));

(com.rpl.specter.t_com$rpl$specter42780.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42780.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
var s = (self__.start_index_fn.cljs$core$IFn$_invoke$arity$1 ? self__.start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.start_index_fn.call(null,structure));
return com.rpl.specter.navs.srange_select(structure,s,com.rpl.specter.navs.invoke_end_fn(self__.end_index_fn,structure,s),next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42780.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
var s = (self__.start_index_fn.cljs$core$IFn$_invoke$arity$1 ? self__.start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.start_index_fn.call(null,structure));
var G__42783 = structure;
var G__42784 = s;
var G__42785 = com.rpl.specter.navs.invoke_end_fn(self__.end_index_fn,structure,s);
var G__42786 = next_fn;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(G__42783,G__42784,G__42785,G__42786) : com.rpl.specter.navs.srange_transform.call(null,G__42783,G__42784,G__42785,G__42786));
}));

(com.rpl.specter.t_com$rpl$specter42780.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start-index-fn","start-index-fn",-344842645,null),new cljs.core.Symbol(null,"end-index-fn","end-index-fn",1237092062,null),new cljs.core.Symbol(null,"meta42781","meta42781",-2133615513,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42780.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42780.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42780");

(com.rpl.specter.t_com$rpl$specter42780.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42780");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42780.
 */
com.rpl.specter.__GT_t_com$rpl$specter42780 = (function com$rpl$specter$__GT_t_com$rpl$specter42780(start_index_fn__$1,end_index_fn__$1,meta42781){
return (new com.rpl.specter.t_com$rpl$specter42780(start_index_fn__$1,end_index_fn__$1,meta42781));
});

}

return (new com.rpl.specter.t_com$rpl$specter42780(start_index_fn,end_index_fn,null));
}));


com.rpl.specter.srange_select_STAR_ = (function com$rpl$specter$srange_select_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_select(structure,start,end,next_fn);
});

com.rpl.specter.srange_transform_STAR_ = (function com$rpl$specter$srange_transform_STAR_(start,end,structure,next_fn){
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(structure,start,end,next_fn) : com.rpl.specter.navs.srange_transform.call(null,structure,start,end,next_fn));
});

/**
 * Navigates to the subsequence bound by the indexes start (inclusive)
 *        and end (exclusive)
 */
com.rpl.specter.srange = com.rpl.specter.impl.direct_nav_obj((function (start,end){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42787 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42787 = (function (start,end,meta42788){
this.start = start;
this.end = end;
this.meta42788 = meta42788;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42787.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42789,meta42788__$1){
var self__ = this;
var _42789__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42787(self__.start,self__.end,meta42788__$1));
}));

(com.rpl.specter.t_com$rpl$specter42787.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42789){
var self__ = this;
var _42789__$1 = this;
return self__.meta42788;
}));

(com.rpl.specter.t_com$rpl$specter42787.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42787.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return com.rpl.specter.navs.srange_select(structure,self__.start,self__.end,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42787.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(structure,self__.start,self__.end,next_fn) : com.rpl.specter.navs.srange_transform.call(null,structure,self__.start,self__.end,next_fn));
}));

(com.rpl.specter.t_com$rpl$specter42787.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"meta42788","meta42788",1647694281,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42787.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42787.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42787");

(com.rpl.specter.t_com$rpl$specter42787.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42787");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42787.
 */
com.rpl.specter.__GT_t_com$rpl$specter42787 = (function com$rpl$specter$__GT_t_com$rpl$specter42787(start__$1,end__$1,meta42788){
return (new com.rpl.specter.t_com$rpl$specter42787(start__$1,end__$1,meta42788));
});

}

return (new com.rpl.specter.t_com$rpl$specter42787(start,end,null));
}));


com.rpl.specter.continuous_subseqs_select_STAR_ = (function com$rpl$specter$continuous_subseqs_select_STAR_(pred,structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38664__auto__,p__42790){
var vec__42791 = p__42790;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42791,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42791,(1),null);
var ret__38665__auto__ = com.rpl.specter.navs.srange_select(structure,s,e,next_fn);
if((ret__38665__auto__ === com.rpl.specter.NONE)){
return curr__38664__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38665__auto__)){
return cljs.core.reduced(ret__38665__auto__);
} else {
return ret__38665__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges(structure,pred));
});

com.rpl.specter.continuous_subseqs_transform_STAR_ = (function com$rpl$specter$continuous_subseqs_transform_STAR_(pred,structure,next_fn){
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_(pred,structure,next_fn);
});

/**
 * Navigates to every continuous subsequence of elements matching `pred`
 */
com.rpl.specter.continuous_subseqs = com.rpl.specter.impl.direct_nav_obj((function (pred){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42794 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42794 = (function (pred,meta42795){
this.pred = pred;
this.meta42795 = meta42795;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42794.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42796,meta42795__$1){
var self__ = this;
var _42796__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42794(self__.pred,meta42795__$1));
}));

(com.rpl.specter.t_com$rpl$specter42794.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42796){
var self__ = this;
var _42796__$1 = this;
return self__.meta42795;
}));

(com.rpl.specter.t_com$rpl$specter42794.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42794.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38664__auto__,p__42797){
var vec__42798 = p__42797;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42798,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42798,(1),null);
var ret__38665__auto__ = com.rpl.specter.navs.srange_select(structure,s,e,next_fn);
if((ret__38665__auto__ === com.rpl.specter.NONE)){
return curr__38664__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38665__auto__)){
return cljs.core.reduced(ret__38665__auto__);
} else {
return ret__38665__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges(structure,self__.pred));
}));

(com.rpl.specter.t_com$rpl$specter42794.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_(self__.pred,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42794.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"meta42795","meta42795",-276519875,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42794.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42794.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42794");

(com.rpl.specter.t_com$rpl$specter42794.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42794");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42794.
 */
com.rpl.specter.__GT_t_com$rpl$specter42794 = (function com$rpl$specter$__GT_t_com$rpl$specter42794(pred__$1,meta42795){
return (new com.rpl.specter.t_com$rpl$specter42794(pred__$1,meta42795));
});

}

return (new com.rpl.specter.t_com$rpl$specter42794(pred,null));
}));


com.rpl.specter.BEGINNING_select_STAR_ = (function com$rpl$specter$BEGINNING_select_STAR_(structure,next_fn){
var G__42801 = ((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42801) : next_fn.call(null,G__42801));
});

com.rpl.specter.BEGINNING_transform_STAR_ = (function com$rpl$specter$BEGINNING_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1("") : next_fn.call(null,""))),structure].join('');
} else {
var to_prepend = (function (){var G__42802 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42802) : next_fn.call(null,G__42802));
})();
return com.rpl.specter.navs.prepend_all(structure,to_prepend);
}
});

/**
 * Navigate to the empty subsequence before the first element of the collection.
 */
com.rpl.specter.BEGINNING = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42803 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42803 = (function (meta42804){
this.meta42804 = meta42804;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42803.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42805,meta42804__$1){
var self__ = this;
var _42805__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42803(meta42804__$1));
}));

(com.rpl.specter.t_com$rpl$specter42803.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42805){
var self__ = this;
var _42805__$1 = this;
return self__.meta42804;
}));

(com.rpl.specter.t_com$rpl$specter42803.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42803.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return next_fn(((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
}));

(com.rpl.specter.t_com$rpl$specter42803.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn("")),structure].join('');
} else {
var to_prepend = next_fn(cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all(structure,to_prepend);
}
}));

(com.rpl.specter.t_com$rpl$specter42803.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42804","meta42804",-943326350,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42803.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42803.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42803");

(com.rpl.specter.t_com$rpl$specter42803.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42803");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42803.
 */
com.rpl.specter.__GT_t_com$rpl$specter42803 = (function com$rpl$specter$__GT_t_com$rpl$specter42803(meta42804){
return (new com.rpl.specter.t_com$rpl$specter42803(meta42804));
});

}

return (new com.rpl.specter.t_com$rpl$specter42803(null));
})()
;


com.rpl.specter.END_select_STAR_ = (function com$rpl$specter$END_select_STAR_(structure,next_fn){
var G__42806 = ((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42806) : next_fn.call(null,G__42806));
});

com.rpl.specter.END_transform_STAR_ = (function com$rpl$specter$END_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [structure,cljs.core.str.cljs$core$IFn$_invoke$arity$1((next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1("") : next_fn.call(null,"")))].join('');
} else {
var to_append = (function (){var G__42807 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42807) : next_fn.call(null,G__42807));
})();
return com.rpl.specter.navs.append_all(structure,to_append);
}
});

/**
 * Navigate to the empty subsequence after the last element of the collection.
 */
com.rpl.specter.END = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42808 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42808 = (function (meta42809){
this.meta42809 = meta42809;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42808.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42810,meta42809__$1){
var self__ = this;
var _42810__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42808(meta42809__$1));
}));

(com.rpl.specter.t_com$rpl$specter42808.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42810){
var self__ = this;
var _42810__$1 = this;
return self__.meta42809;
}));

(com.rpl.specter.t_com$rpl$specter42808.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42808.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return next_fn(((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
}));

(com.rpl.specter.t_com$rpl$specter42808.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
if(typeof structure === 'string'){
return [structure,cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn(""))].join('');
} else {
var to_append = next_fn(cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all(structure,to_append);
}
}));

(com.rpl.specter.t_com$rpl$specter42808.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42809","meta42809",1847877152,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42808.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42808.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42808");

(com.rpl.specter.t_com$rpl$specter42808.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42808");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42808.
 */
com.rpl.specter.__GT_t_com$rpl$specter42808 = (function com$rpl$specter$__GT_t_com$rpl$specter42808(meta42809){
return (new com.rpl.specter.t_com$rpl$specter42808(meta42809));
});

}

return (new com.rpl.specter.t_com$rpl$specter42808(null));
})()
;


com.rpl.specter.NONE_ELEM_select_STAR_ = (function com$rpl$specter$NONE_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.NONE_ELEM_transform_STAR_ = (function com$rpl$specter$NONE_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(structure,newe);
}
}
});

/**
 * Navigate to 'void' elem in the set.
 *        For transformations - if result is not `NONE`,
 *        then add that value to the set.
 */
com.rpl.specter.NONE_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42811 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42811 = (function (meta42812){
this.meta42812 = meta42812;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42811.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42813,meta42812__$1){
var self__ = this;
var _42813__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42811(meta42812__$1));
}));

(com.rpl.specter.t_com$rpl$specter42811.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42813){
var self__ = this;
var _42813__$1 = this;
return self__.meta42812;
}));

(com.rpl.specter.t_com$rpl$specter42811.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42811.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter42811.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(structure,newe);
}
}
}));

(com.rpl.specter.t_com$rpl$specter42811.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42812","meta42812",767849606,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42811.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42811.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42811");

(com.rpl.specter.t_com$rpl$specter42811.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42811");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42811.
 */
com.rpl.specter.__GT_t_com$rpl$specter42811 = (function com$rpl$specter$__GT_t_com$rpl$specter42811(meta42812){
return (new com.rpl.specter.t_com$rpl$specter42811(meta42812));
});

}

return (new com.rpl.specter.t_com$rpl$specter42811(null));
})()
;


com.rpl.specter.BEFORE_ELEM_select_STAR_ = (function com$rpl$specter$BEFORE_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.BEFORE_ELEM_transform_STAR_ = (function com$rpl$specter$BEFORE_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one(structure,newe);
}
});

/**
 * Navigate to 'void' element before the sequence.
 *        For transformations – if result is not `NONE`,
 *        then prepend that value.
 */
com.rpl.specter.BEFORE_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42814 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42814 = (function (meta42815){
this.meta42815 = meta42815;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42814.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42816,meta42815__$1){
var self__ = this;
var _42816__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42814(meta42815__$1));
}));

(com.rpl.specter.t_com$rpl$specter42814.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42816){
var self__ = this;
var _42816__$1 = this;
return self__.meta42815;
}));

(com.rpl.specter.t_com$rpl$specter42814.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42814.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter42814.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one(structure,newe);
}
}));

(com.rpl.specter.t_com$rpl$specter42814.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42815","meta42815",1591070598,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42814.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42814.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42814");

(com.rpl.specter.t_com$rpl$specter42814.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42814");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42814.
 */
com.rpl.specter.__GT_t_com$rpl$specter42814 = (function com$rpl$specter$__GT_t_com$rpl$specter42814(meta42815){
return (new com.rpl.specter.t_com$rpl$specter42814(meta42815));
});

}

return (new com.rpl.specter.t_com$rpl$specter42814(null));
})()
;


com.rpl.specter.AFTER_ELEM_select_STAR_ = (function com$rpl$specter$AFTER_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.AFTER_ELEM_transform_STAR_ = (function com$rpl$specter$AFTER_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one(structure,newe);
}
});

/**
 * Navigate to 'void' element after the sequence.
 *        For transformations – if result is not `NONE`,
 *        then append that value.
 */
com.rpl.specter.AFTER_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42817 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42817 = (function (meta42818){
this.meta42818 = meta42818;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42817.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42819,meta42818__$1){
var self__ = this;
var _42819__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42817(meta42818__$1));
}));

(com.rpl.specter.t_com$rpl$specter42817.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42819){
var self__ = this;
var _42819__$1 = this;
return self__.meta42818;
}));

(com.rpl.specter.t_com$rpl$specter42817.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42817.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter42817.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one(structure,newe);
}
}));

(com.rpl.specter.t_com$rpl$specter42817.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42818","meta42818",-1032888857,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42817.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42817.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42817");

(com.rpl.specter.t_com$rpl$specter42817.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42817");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42817.
 */
com.rpl.specter.__GT_t_com$rpl$specter42817 = (function com$rpl$specter$__GT_t_com$rpl$specter42817(meta42818){
return (new com.rpl.specter.t_com$rpl$specter42817(meta42818));
});

}

return (new com.rpl.specter.t_com$rpl$specter42817(null));
})()
;


com.rpl.specter.subset_select_STAR_ = (function com$rpl$specter$subset_select_STAR_(aset,structure,next_fn){
var G__42820 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,aset);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42820) : next_fn.call(null,G__42820));
});

com.rpl.specter.subset_transform_STAR_ = (function com$rpl$specter$subset_transform_STAR_(aset,structure,next_fn){
var subset = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,aset);
var newset = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(subset) : next_fn.call(null,subset));
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(structure,subset),newset);
});

/**
 * Navigates to the specified subset (by taking an intersection).
 *        In a transform, that subset in the original set is changed to the
 *        new value of the subset.
 */
com.rpl.specter.subset = com.rpl.specter.impl.direct_nav_obj((function (aset){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42821 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42821 = (function (aset,meta42822){
this.aset = aset;
this.meta42822 = meta42822;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42821.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42823,meta42822__$1){
var self__ = this;
var _42823__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42821(self__.aset,meta42822__$1));
}));

(com.rpl.specter.t_com$rpl$specter42821.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42823){
var self__ = this;
var _42823__$1 = this;
return self__.meta42822;
}));

(com.rpl.specter.t_com$rpl$specter42821.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42821.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return next_fn(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,self__.aset));
}));

(com.rpl.specter.t_com$rpl$specter42821.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
var subset = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,self__.aset);
var newset = next_fn(subset);
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(structure,subset),newset);
}));

(com.rpl.specter.t_com$rpl$specter42821.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"aset","aset",900773178,null),new cljs.core.Symbol(null,"meta42822","meta42822",1195328240,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42821.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42821.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42821");

(com.rpl.specter.t_com$rpl$specter42821.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42821");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42821.
 */
com.rpl.specter.__GT_t_com$rpl$specter42821 = (function com$rpl$specter$__GT_t_com$rpl$specter42821(aset__$1,meta42822){
return (new com.rpl.specter.t_com$rpl$specter42821(aset__$1,meta42822));
});

}

return (new com.rpl.specter.t_com$rpl$specter42821(aset,null));
}));


com.rpl.specter.submap_select_STAR_ = (function com$rpl$specter$submap_select_STAR_(m_keys,structure,next_fn){
var G__42824 = cljs.core.select_keys(structure,m_keys);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42824) : next_fn.call(null,G__42824));
});

com.rpl.specter.submap_transform_STAR_ = (function com$rpl$specter$submap_transform_STAR_(m_keys,structure,next_fn){
var submap = cljs.core.select_keys(structure,m_keys);
var newmap = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(submap) : next_fn.call(null,submap));
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,structure,m_keys),newmap], 0));
});

/**
 * Navigates to the specified submap (using select-keys).
 *        In a transform, that submap in the original map is changed to the new
 *        value of the submap.
 */
com.rpl.specter.submap = com.rpl.specter.impl.direct_nav_obj((function (m_keys){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42825 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42825 = (function (m_keys,meta42826){
this.m_keys = m_keys;
this.meta42826 = meta42826;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42825.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42827,meta42826__$1){
var self__ = this;
var _42827__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42825(self__.m_keys,meta42826__$1));
}));

(com.rpl.specter.t_com$rpl$specter42825.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42827){
var self__ = this;
var _42827__$1 = this;
return self__.meta42826;
}));

(com.rpl.specter.t_com$rpl$specter42825.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42825.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return next_fn(cljs.core.select_keys(structure,self__.m_keys));
}));

(com.rpl.specter.t_com$rpl$specter42825.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
var submap = cljs.core.select_keys(structure,self__.m_keys);
var newmap = next_fn(submap);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,structure,self__.m_keys),newmap], 0));
}));

(com.rpl.specter.t_com$rpl$specter42825.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"m-keys","m-keys",-197459035,null),new cljs.core.Symbol(null,"meta42826","meta42826",-1199999997,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42825.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42825.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42825");

(com.rpl.specter.t_com$rpl$specter42825.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42825");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42825.
 */
com.rpl.specter.__GT_t_com$rpl$specter42825 = (function com$rpl$specter$__GT_t_com$rpl$specter42825(m_keys__$1,meta42826){
return (new com.rpl.specter.t_com$rpl$specter42825(m_keys__$1,meta42826));
});

}

return (new com.rpl.specter.t_com$rpl$specter42825(m_keys,null));
}));
/**
 * Navigates to a sequence that contains the results of (select ...),
 *   but is a view to the original structure that can be transformed.
 * 
 *   Requires that the input navigators will walk the structure's
 *   children in the same order when executed on "select" and then
 *   "transform".
 * 
 *   If transformed sequence is smaller than input sequence, missing entries
 *   will be filled in with NONE, triggering removal if supported by that navigator.
 * 
 *   Value collection (e.g. collect, collect-one) may not be used in the subpath.
 */
com.rpl.specter.subselect = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43075__delegate = function (path){
var builder__41681__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42828 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42828 = (function (path,late,meta42829){
this.path = path;
this.late = late;
this.meta42829 = meta42829;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42828.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42830,meta42829__$1){
var self__ = this;
var _42830__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42828(self__.path,self__.late,meta42829__$1));
}));

(com.rpl.specter.t_com$rpl$specter42828.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42830){
var self__ = this;
var _42830__$1 = this;
return self__.meta42829;
}));

(com.rpl.specter.t_com$rpl$specter42828.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42828.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return next_fn((com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
}));

(com.rpl.specter.t_com$rpl$specter42828.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
var select_result = (com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure));
var transformed = next_fn(select_result);
var values_to_insert = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(transformed));
var G__42831 = self__.late;
var G__42832 = (function (_){
var vs = com.rpl.specter.impl.get_cell(values_to_insert);
if(cljs.core.truth_(vs)){
com.rpl.specter.impl.update_cell_BANG_(values_to_insert,cljs.core.next);

return cljs.core.first(vs);
} else {
return com.rpl.specter.NONE;
}
});
var G__42833 = structure;
return (com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(G__42831,G__42832,G__42833) : com.rpl.specter.compiled_transform.call(null,G__42831,G__42832,G__42833));
}));

(com.rpl.specter.t_com$rpl$specter42828.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta42829","meta42829",484359850,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42828.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42828.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42828");

(com.rpl.specter.t_com$rpl$specter42828.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42828");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42828.
 */
com.rpl.specter.__GT_t_com$rpl$specter42828 = (function com$rpl$specter$__GT_t_com$rpl$specter42828(path__$1,late__$1,meta42829){
return (new com.rpl.specter.t_com$rpl$specter42828(path__$1,late__$1,meta42829));
});

}

return (new com.rpl.specter.t_com$rpl$specter42828(path,late,null));
}));
var curr_params__41682__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__41682__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__41681__auto__,curr_params__41682__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__41681__auto__,curr_params__41682__auto__,null);
}
};
var G__43075 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__43076__i = 0, G__43076__a = new Array(arguments.length -  0);
while (G__43076__i < G__43076__a.length) {G__43076__a[G__43076__i] = arguments[G__43076__i + 0]; ++G__43076__i;}
  path = new cljs.core.IndexedSeq(G__43076__a,0,null);
} 
return G__43075__delegate.call(this,path);};
G__43075.cljs$lang$maxFixedArity = 0;
G__43075.cljs$lang$applyTo = (function (arglist__43077){
var path = cljs.core.seq(arglist__43077);
return G__43075__delegate(path);
});
G__43075.cljs$core$IFn$_invoke$arity$variadic = G__43075__delegate;
return G__43075;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the given key in the map (not to the value). Navigates only if the
 *        key currently exists in the map. Can transform to NONE to remove the key/value
 *        pair from the map.
 */
com.rpl.specter.map_key = com.rpl.specter.impl.direct_nav_obj((function (key){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42834 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42834 = (function (key,meta42835){
this.key = key;
this.meta42835 = meta42835;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42834.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42836,meta42835__$1){
var self__ = this;
var _42836__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42834(self__.key,meta42835__$1));
}));

(com.rpl.specter.t_com$rpl$specter42834.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42836){
var self__ = this;
var _42836__$1 = this;
return self__.meta42835;
}));

(com.rpl.specter.t_com$rpl$specter42834.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42834.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.key)){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.key) : next_fn.call(null,vals,self__.key));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter42834.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.key)){
var newkey = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.key) : next_fn.call(null,vals,self__.key));
var dissoced = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(structure,self__.key);
if((com.rpl.specter.NONE === newkey)){
return dissoced;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(dissoced,newkey,cljs.core.get.cljs$core$IFn$_invoke$arity$2(structure,self__.key));
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter42834.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"meta42835","meta42835",-334253514,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42834.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42834.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42834");

(com.rpl.specter.t_com$rpl$specter42834.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42834");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42834.
 */
com.rpl.specter.__GT_t_com$rpl$specter42834 = (function com$rpl$specter$__GT_t_com$rpl$specter42834(key__$1,meta42835){
return (new com.rpl.specter.t_com$rpl$specter42834(key__$1,meta42835));
});

}

return (new com.rpl.specter.t_com$rpl$specter42834(key,null));
}));
/**
 * Navigates to the given element in the set only if it exists in the set.
 *        Can transform to NONE to remove the element from the set.
 */
com.rpl.specter.set_elem = com.rpl.specter.impl.direct_nav_obj((function (elem){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42837 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42837 = (function (elem,meta42838){
this.elem = elem;
this.meta42838 = meta42838;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42837.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42839,meta42838__$1){
var self__ = this;
var _42839__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42837(self__.elem,meta42838__$1));
}));

(com.rpl.specter.t_com$rpl$specter42837.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42839){
var self__ = this;
var _42839__$1 = this;
return self__.meta42838;
}));

(com.rpl.specter.t_com$rpl$specter42837.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42837.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.elem)){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.elem) : next_fn.call(null,vals,self__.elem));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter42837.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.elem)){
var newelem = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.elem) : next_fn.call(null,vals,self__.elem));
var removed = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(structure,self__.elem);
if((com.rpl.specter.NONE === newelem)){
return removed;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(removed,newelem);
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter42837.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"elem","elem",-2035804713,null),new cljs.core.Symbol(null,"meta42838","meta42838",-130523657,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42837.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42837.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42837");

(com.rpl.specter.t_com$rpl$specter42837.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42837");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42837.
 */
com.rpl.specter.__GT_t_com$rpl$specter42837 = (function com$rpl$specter$__GT_t_com$rpl$specter42837(elem__$1,meta42838){
return (new com.rpl.specter.t_com$rpl$specter42837(elem__$1,meta42838));
});

}

return (new com.rpl.specter.t_com$rpl$specter42837(elem,null));
}));
/**
 * Navigate to the specified keys one after another. If navigate to NONE,
 *           that element is removed from the map or vector.
 */
com.rpl.specter.keypath = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.keypath_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.keypath_STAR_));
/**
 * Navigate to the specified keys one after another, only if they exist
 *           in the data structure. If navigate to NONE, that element is removed
 *           from the map or vector.
 */
com.rpl.specter.must = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.must_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.must_STAR_));
/**
 * Navigate to the specified indices one after another. If navigate to
 *          NONE, that element is removed from the sequence.
 */
com.rpl.specter.nthpath = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.nthpath_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.nthpath_STAR_));
/**
 * Navigates to the empty space between the index and the prior index. For select
 *        navigates to NONE, and transforms to non-NONE insert at that position.
 */
com.rpl.specter.before_index = com.rpl.specter.impl.direct_nav_obj((function (index){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42840 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42840 = (function (index,meta42841){
this.index = index;
this.meta42841 = meta42841;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42840.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42842,meta42841__$1){
var self__ = this;
var _42842__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42840(self__.index,meta42841__$1));
}));

(com.rpl.specter.t_com$rpl$specter42840.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42842){
var self__ = this;
var _42842__$1 = this;
return self__.meta42841;
}));

(com.rpl.specter.t_com$rpl$specter42840.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42840.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter42840.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var v = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,com.rpl.specter.NONE) : next_fn.call(null,vals,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === v)){
return structure;
} else {
return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__41688__auto__ = com.rpl.specter.pathcache42843;
var info__41688__auto____$1 = (((info__41688__auto__ == null))?(function (){var info42844 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.srange,new cljs.core.Var(function(){return com.rpl.specter.srange;},new cljs.core.Symbol("com.rpl.specter","srange","com.rpl.specter/srange",-978851939,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"srange","srange",-1324254972,null),"com/rpl/specter.cljc",9,1,755,758,cljs.core.List.EMPTY,"Navigates to the subsequence bound by the indexes start (inclusive)\n          and end (exclusive)",(cljs.core.truth_(com.rpl.specter.srange)?com.rpl.specter.srange.cljs$lang$test:null)])),new cljs.core.Symbol(null,"srange","srange",-1324254972,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(self__.index,new cljs.core.Symbol(null,"index","index",108845612,null)),com.rpl.specter.impl.__GT_LocalSym(self__.index,new cljs.core.Symbol(null,"index","index",108845612,null))], null),cljs.core.list(new cljs.core.Symbol(null,"srange","srange",-1324254972,null),new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"srange","srange",-1324254972,null),new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)], null));
com.rpl.specter.pathcache42843 = info42844;

return info42844;
})():info__41688__auto__);
var precompiled42845 = com.rpl.specter.impl.cached_path_info_precompiled(info__41688__auto____$1);
var dynamic_QMARK___41689__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41688__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41689__auto__)){
var G__42846 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.srange,self__.index,self__.index], null);
return (precompiled42845.cljs$core$IFn$_invoke$arity$1 ? precompiled42845.cljs$core$IFn$_invoke$arity$1(G__42846) : precompiled42845.call(null,G__42846));
} else {
return precompiled42845;
}
})(),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v], null),structure);
}
}));

(com.rpl.specter.t_com$rpl$specter42840.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"meta42841","meta42841",1149460474,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42840.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42840.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42840");

(com.rpl.specter.t_com$rpl$specter42840.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42840");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42840.
 */
com.rpl.specter.__GT_t_com$rpl$specter42840 = (function com$rpl$specter$__GT_t_com$rpl$specter42840(index__$1,meta42841){
return (new com.rpl.specter.t_com$rpl$specter42840(index__$1,meta42841));
});

}

return (new com.rpl.specter.t_com$rpl$specter42840(index,null));
}));
/**
 * Navigates to the index of the sequence if within 0 and size. Transforms move element
 *        at that index to the new index, shifting other elements in the sequence.
 */
com.rpl.specter.index_nav = com.rpl.specter.impl.direct_nav_obj((function (i){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42847 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42847 = (function (i,meta42848){
this.i = i;
this.meta42848 = meta42848;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42847.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42849,meta42848__$1){
var self__ = this;
var _42849__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42847(self__.i,meta42848__$1));
}));

(com.rpl.specter.t_com$rpl$specter42847.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42849){
var self__ = this;
var _42849__$1 = this;
return self__.meta42848;
}));

(com.rpl.specter.t_com$rpl$specter42847.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42847.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if((((self__.i >= (0))) && ((self__.i < cljs.core.count(structure))))){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.i) : next_fn.call(null,vals,self__.i));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter42847.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if((((self__.i >= (0))) && ((self__.i < cljs.core.count(structure))))){
var newi = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.i) : next_fn.call(null,vals,self__.i));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(newi,self__.i)){
return structure;
} else {
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(structure,self__.i);
if(cljs.core.vector_QMARK_(structure)){
var shifted = (((newi < self__.i))?(function (){var j = (self__.i - (1));
var s = structure;
while(true){
if((j < newi)){
return s;
} else {
var G__43078 = (j - (1));
var G__43079 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,(j + (1)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(s,j));
j = G__43078;
s = G__43079;
continue;
}
break;
}
})():(function (){var j = (self__.i + (1));
var s = structure;
while(true){
if((j > newi)){
return s;
} else {
var G__43080 = (j + (1));
var G__43081 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,(j - (1)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(s,j));
j = G__43080;
s = G__43081;
continue;
}
break;
}
})());
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(shifted,newi,v);
} else {
return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__41688__auto__ = com.rpl.specter.pathcache42850;
var info__41688__auto____$1 = (((info__41688__auto__ == null))?(function (){var info42851 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.before_index,new cljs.core.Var(function(){return com.rpl.specter.before_index;},new cljs.core.Symbol("com.rpl.specter","before-index","com.rpl.specter/before-index",1952616274,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),"com/rpl/specter.cljc",15,1,968,971,cljs.core.List.EMPTY,"Navigates to the empty space between the index and the prior index. For select\n          navigates to NONE, and transforms to non-NONE insert at that position.",(cljs.core.truth_(com.rpl.specter.before_index)?com.rpl.specter.before_index.cljs$lang$test:null)])),new cljs.core.Symbol(null,"before-index","before-index",-407870261,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(newi,new cljs.core.Symbol(null,"newi","newi",857919881,null))], null),cljs.core.list(new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null));
com.rpl.specter.pathcache42850 = info42851;

return info42851;
})():info__41688__auto__);
var precompiled42852 = com.rpl.specter.impl.cached_path_info_precompiled(info__41688__auto____$1);
var dynamic_QMARK___41689__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41688__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41689__auto__)){
var G__42853 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.before_index,newi], null);
return (precompiled42852.cljs$core$IFn$_invoke$arity$1 ? precompiled42852.cljs$core$IFn$_invoke$arity$1(G__42853) : precompiled42852.call(null,G__42853));
} else {
return precompiled42852;
}
})(),v,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__41688__auto__ = com.rpl.specter.pathcache42854;
var info__41688__auto____$1 = (((info__41688__auto__ == null))?(function (){var info42855 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(self__.i,new cljs.core.Symbol(null,"i","i",253690212,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"i","i",253690212,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"i","i",253690212,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"i","i",253690212,null)], null));
com.rpl.specter.pathcache42854 = info42855;

return info42855;
})():info__41688__auto__);
var precompiled42856 = com.rpl.specter.impl.cached_path_info_precompiled(info__41688__auto____$1);
var dynamic_QMARK___41689__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41688__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41689__auto__)){
var G__42857 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,self__.i], null);
return (precompiled42856.cljs$core$IFn$_invoke$arity$1 ? precompiled42856.cljs$core$IFn$_invoke$arity$1(G__42857) : precompiled42856.call(null,G__42857));
} else {
return precompiled42856;
}
})(),com.rpl.specter.NONE,structure));
}
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter42847.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta42848","meta42848",1686182864,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42847.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42847.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42847");

(com.rpl.specter.t_com$rpl$specter42847.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42847");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42847.
 */
com.rpl.specter.__GT_t_com$rpl$specter42847 = (function com$rpl$specter$__GT_t_com$rpl$specter42847(i__$1,meta42848){
return (new com.rpl.specter.t_com$rpl$specter42847(i__$1,meta42848));
});

}

return (new com.rpl.specter.t_com$rpl$specter42847(i,null));
}));


com.rpl.specter.indexed_vals_select_STAR_ = (function com$rpl$specter$indexed_vals_select_STAR_(start,structure,next_fn){
var i = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1((start - (1)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38664__auto__,e){
var ret__38665__auto__ = (function (){
com.rpl.specter.impl.update_cell_BANG_(i,cljs.core.inc);

var G__42860 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.get_cell(i),e], null);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42860) : next_fn.call(null,G__42860));
})()
;
if((ret__38665__auto__ === com.rpl.specter.NONE)){
return curr__38664__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38665__auto__)){
return cljs.core.reduced(ret__38665__auto__);
} else {
return ret__38665__auto__;
}
}
}),com.rpl.specter.NONE,structure);
});

com.rpl.specter.indexed_vals_transform_STAR_ = (function com$rpl$specter$indexed_vals_transform_STAR_(start,structure,next_fn){
var indices = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(structure)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s,e){
var curri = cljs.core.first(com.rpl.specter.impl.get_cell(indices));
var vec__42861 = (function (){var G__42864 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(start + curri),e], null);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42864) : next_fn.call(null,G__42864));
})();
var newi_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42861,(0),null);
var newe = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42861,(1),null);
var newi = (newi_STAR_ - start);
com.rpl.specter.impl.update_cell_BANG_(indices,(function (ii){
var ii2 = cljs.core.next(ii);
if((newi > curri)){
return com.rpl.specter.impl.compiled_transform_STAR_((function (){var info__41688__auto__ = com.rpl.specter.pathcache42865;
var info__41688__auto____$1 = (((info__41688__auto__ == null))?(function (){var info42866 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__42858_SHARP_){
return (p1__42858_SHARP_ >= (curri + (1)));
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42858#","p1__42858#",1501574397,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__42858#","p1__42858#",1501574397,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null))))),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__42859_SHARP_){
return (p1__42859_SHARP_ <= newi);
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42859#","p1__42859#",-259211668,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__42859#","p1__42859#",-259211668,null),new cljs.core.Symbol(null,"newi","newi",857919881,null))))], null)], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42858#","p1__42858#",1501574397,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__42858#","p1__42858#",1501574397,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42859#","p1__42859#",-259211668,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__42859#","p1__42859#",-259211668,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42858#","p1__42858#",1501574397,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__42858#","p1__42858#",1501574397,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42859#","p1__42859#",-259211668,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__42859#","p1__42859#",-259211668,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null));
com.rpl.specter.pathcache42865 = info42866;

return info42866;
})():info__41688__auto__);
var precompiled42867 = com.rpl.specter.impl.cached_path_info_precompiled(info__41688__auto____$1);
var dynamic_QMARK___41689__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41688__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41689__auto__)){
var G__42868 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,(function (p1__42858_SHARP_){
return (p1__42858_SHARP_ >= (curri + (1)));
}),(function (p1__42859_SHARP_){
return (p1__42859_SHARP_ <= newi);
})], null),com.rpl.specter.ALL,(function (p1__42858_SHARP_){
return (p1__42858_SHARP_ >= (curri + (1)));
}),(function (p1__42859_SHARP_){
return (p1__42859_SHARP_ <= newi);
})], null);
return (precompiled42867.cljs$core$IFn$_invoke$arity$1 ? precompiled42867.cljs$core$IFn$_invoke$arity$1(G__42868) : precompiled42867.call(null,G__42868));
} else {
return precompiled42867;
}
})(),cljs.core.dec,ii2);
} else {
return ii2;
}
}));

return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__41688__auto__ = com.rpl.specter.pathcache42869;
var info__41688__auto____$1 = (((info__41688__auto__ == null))?(function (){var info42870 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.index_nav,new cljs.core.Var(function(){return com.rpl.specter.index_nav;},new cljs.core.Symbol("com.rpl.specter","index-nav","com.rpl.specter/index-nav",2054501071,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),"com/rpl/specter.cljc",12,1,983,986,cljs.core.List.EMPTY,"Navigates to the index of the sequence if within 0 and size. Transforms move element\n          at that index to the new index, shifting other elements in the sequence.",(cljs.core.truth_(com.rpl.specter.index_nav)?com.rpl.specter.index_nav.cljs$lang$test:null)])),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache42869 = info42870;

return info42870;
})():info__41688__auto__);
var precompiled42871 = com.rpl.specter.impl.cached_path_info_precompiled(info__41688__auto____$1);
var dynamic_QMARK___41689__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41688__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41689__auto__)){
var G__42872 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.index_nav,curri], null);
return (precompiled42871.cljs$core$IFn$_invoke$arity$1 ? precompiled42871.cljs$core$IFn$_invoke$arity$1(G__42872) : precompiled42871.call(null,G__42872));
} else {
return precompiled42871;
}
})(),newi,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__41688__auto__ = com.rpl.specter.pathcache42873;
var info__41688__auto____$1 = (((info__41688__auto__ == null))?(function (){var info42874 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache42873 = info42874;

return info42874;
})():info__41688__auto__);
var precompiled42875 = com.rpl.specter.impl.cached_path_info_precompiled(info__41688__auto____$1);
var dynamic_QMARK___41689__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41688__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41689__auto__)){
var G__42876 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,curri], null);
return (precompiled42875.cljs$core$IFn$_invoke$arity$1 ? precompiled42875.cljs$core$IFn$_invoke$arity$1(G__42876) : precompiled42875.call(null,G__42876));
} else {
return precompiled42875;
}
})(),newe,s));
}),structure,structure);
});

/**
 * Navigate to [index elem] pairs for each element in a sequence. The sequence will be indexed
 *        starting from `start`. Changing index in transform has same effect as `index-nav`. Indices seen
 *        during transform take into account any shifting from prior sequence elements changing indices.
 */
com.rpl.specter.indexed_vals = com.rpl.specter.impl.direct_nav_obj((function (start){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42877 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42877 = (function (start,meta42878){
this.start = start;
this.meta42878 = meta42878;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42877.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42879,meta42878__$1){
var self__ = this;
var _42879__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42877(self__.start,meta42878__$1));
}));

(com.rpl.specter.t_com$rpl$specter42877.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42879){
var self__ = this;
var _42879__$1 = this;
return self__.meta42878;
}));

(com.rpl.specter.t_com$rpl$specter42877.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42877.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
var i = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1((self__.start - (1)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38664__auto__,e){
var ret__38665__auto__ = (function (){
com.rpl.specter.impl.update_cell_BANG_(i,cljs.core.inc);

return next_fn(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.get_cell(i),e], null));
})()
;
if((ret__38665__auto__ === com.rpl.specter.NONE)){
return curr__38664__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38665__auto__)){
return cljs.core.reduced(ret__38665__auto__);
} else {
return ret__38665__auto__;
}
}
}),com.rpl.specter.NONE,structure);
}));

(com.rpl.specter.t_com$rpl$specter42877.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
var indices = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(structure)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s,e){
var curri = cljs.core.first(com.rpl.specter.impl.get_cell(indices));
var vec__42880 = next_fn(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.start + curri),e], null));
var newi_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42880,(0),null);
var newe = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42880,(1),null);
var newi = (newi_STAR_ - self__.start);
com.rpl.specter.impl.update_cell_BANG_(indices,(function (ii){
var ii2 = cljs.core.next(ii);
if((newi > curri)){
return com.rpl.specter.impl.compiled_transform_STAR_((function (){var info__41688__auto__ = com.rpl.specter.pathcache42883;
var info__41688__auto____$1 = (((info__41688__auto__ == null))?(function (){var info42884 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__42858_SHARP_){
return (p1__42858_SHARP_ >= (curri + (1)));
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42858#","p1__42858#",1501574397,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__42858#","p1__42858#",1501574397,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null))))),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__42859_SHARP_){
return (p1__42859_SHARP_ <= newi);
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42859#","p1__42859#",-259211668,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__42859#","p1__42859#",-259211668,null),new cljs.core.Symbol(null,"newi","newi",857919881,null))))], null)], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42858#","p1__42858#",1501574397,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__42858#","p1__42858#",1501574397,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42859#","p1__42859#",-259211668,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__42859#","p1__42859#",-259211668,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42858#","p1__42858#",1501574397,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__42858#","p1__42858#",1501574397,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42859#","p1__42859#",-259211668,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__42859#","p1__42859#",-259211668,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null));
com.rpl.specter.pathcache42883 = info42884;

return info42884;
})():info__41688__auto__);
var precompiled42885 = com.rpl.specter.impl.cached_path_info_precompiled(info__41688__auto____$1);
var dynamic_QMARK___41689__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41688__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41689__auto__)){
var G__42886 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,(function (p1__42858_SHARP_){
return (p1__42858_SHARP_ >= (curri + (1)));
}),(function (p1__42859_SHARP_){
return (p1__42859_SHARP_ <= newi);
})], null),com.rpl.specter.ALL,(function (p1__42858_SHARP_){
return (p1__42858_SHARP_ >= (curri + (1)));
}),(function (p1__42859_SHARP_){
return (p1__42859_SHARP_ <= newi);
})], null);
return (precompiled42885.cljs$core$IFn$_invoke$arity$1 ? precompiled42885.cljs$core$IFn$_invoke$arity$1(G__42886) : precompiled42885.call(null,G__42886));
} else {
return precompiled42885;
}
})(),cljs.core.dec,ii2);
} else {
return ii2;
}
}));

return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__41688__auto__ = com.rpl.specter.pathcache42887;
var info__41688__auto____$1 = (((info__41688__auto__ == null))?(function (){var info42888 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.index_nav,new cljs.core.Var(function(){return com.rpl.specter.index_nav;},new cljs.core.Symbol("com.rpl.specter","index-nav","com.rpl.specter/index-nav",2054501071,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),"com/rpl/specter.cljc",12,1,983,986,cljs.core.List.EMPTY,"Navigates to the index of the sequence if within 0 and size. Transforms move element\n          at that index to the new index, shifting other elements in the sequence.",(cljs.core.truth_(com.rpl.specter.index_nav)?com.rpl.specter.index_nav.cljs$lang$test:null)])),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache42887 = info42888;

return info42888;
})():info__41688__auto__);
var precompiled42889 = com.rpl.specter.impl.cached_path_info_precompiled(info__41688__auto____$1);
var dynamic_QMARK___41689__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41688__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41689__auto__)){
var G__42890 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.index_nav,curri], null);
return (precompiled42889.cljs$core$IFn$_invoke$arity$1 ? precompiled42889.cljs$core$IFn$_invoke$arity$1(G__42890) : precompiled42889.call(null,G__42890));
} else {
return precompiled42889;
}
})(),newi,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__41688__auto__ = com.rpl.specter.pathcache42891;
var info__41688__auto____$1 = (((info__41688__auto__ == null))?(function (){var info42892 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache42891 = info42892;

return info42892;
})():info__41688__auto__);
var precompiled42893 = com.rpl.specter.impl.cached_path_info_precompiled(info__41688__auto____$1);
var dynamic_QMARK___41689__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41688__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41689__auto__)){
var G__42894 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,curri], null);
return (precompiled42893.cljs$core$IFn$_invoke$arity$1 ? precompiled42893.cljs$core$IFn$_invoke$arity$1(G__42894) : precompiled42893.call(null,G__42894));
} else {
return precompiled42893;
}
})(),newe,s));
}),structure,structure);
}));

(com.rpl.specter.t_com$rpl$specter42877.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"meta42878","meta42878",1317123696,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42877.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42877.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42877");

(com.rpl.specter.t_com$rpl$specter42877.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42877");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42877.
 */
com.rpl.specter.__GT_t_com$rpl$specter42877 = (function com$rpl$specter$__GT_t_com$rpl$specter42877(start__$1,meta42878){
return (new com.rpl.specter.t_com$rpl$specter42877(start__$1,meta42878));
});

}

return (new com.rpl.specter.t_com$rpl$specter42877(start,null));
}));
/**
 * `indexed-vals` with a starting index of 0.
 */
com.rpl.specter.INDEXED_VALS = (com.rpl.specter.indexed_vals.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.indexed_vals.cljs$core$IFn$_invoke$arity$1((0)) : com.rpl.specter.indexed_vals.call(null,(0)));
/**
 * Navigates to result of running `afn` on the currently navigated value.
 */
com.rpl.specter.view = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42895 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42895 = (function (afn,meta42896){
this.afn = afn;
this.meta42896 = meta42896;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42895.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42897,meta42896__$1){
var self__ = this;
var _42897__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42895(self__.afn,meta42896__$1));
}));

(com.rpl.specter.t_com$rpl$specter42895.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42897){
var self__ = this;
var _42897__$1 = this;
return self__.meta42896;
}));

(com.rpl.specter.t_com$rpl$specter42895.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42895.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__42898 = vals;
var G__42899 = (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(structure) : self__.afn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__42898,G__42899) : next_fn.call(null,G__42898,G__42899));
}));

(com.rpl.specter.t_com$rpl$specter42895.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__42900 = vals;
var G__42901 = (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(structure) : self__.afn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__42900,G__42901) : next_fn.call(null,G__42900,G__42901));
}));

(com.rpl.specter.t_com$rpl$specter42895.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta42896","meta42896",1597314292,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42895.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42895.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42895");

(com.rpl.specter.t_com$rpl$specter42895.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42895");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42895.
 */
com.rpl.specter.__GT_t_com$rpl$specter42895 = (function com$rpl$specter$__GT_t_com$rpl$specter42895(afn__$1,meta42896){
return (new com.rpl.specter.t_com$rpl$specter42895(afn__$1,meta42896));
});

}

return (new com.rpl.specter.t_com$rpl$specter42895(afn,null));
}));


com.rpl.specter.parser_select_STAR_ = (function com$rpl$specter$parser_select_STAR_(parse_fn,unparse_fn,structure,next_fn){
var G__42902 = (parse_fn.cljs$core$IFn$_invoke$arity$1 ? parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : parse_fn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42902) : next_fn.call(null,G__42902));
});

com.rpl.specter.parser_transform_STAR_ = (function com$rpl$specter$parser_transform_STAR_(parse_fn,unparse_fn,structure,next_fn){
var G__42903 = (function (){var G__42904 = (parse_fn.cljs$core$IFn$_invoke$arity$1 ? parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : parse_fn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42904) : next_fn.call(null,G__42904));
})();
return (unparse_fn.cljs$core$IFn$_invoke$arity$1 ? unparse_fn.cljs$core$IFn$_invoke$arity$1(G__42903) : unparse_fn.call(null,G__42903));
});

/**
 * Navigate to the result of running `parse-fn` on the value. For
 *        transforms, the transformed value then has `unparse-fn` run on
 *        it to get the final value at this point.
 */
com.rpl.specter.parser = com.rpl.specter.impl.direct_nav_obj((function (parse_fn,unparse_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42905 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42905 = (function (parse_fn,unparse_fn,meta42906){
this.parse_fn = parse_fn;
this.unparse_fn = unparse_fn;
this.meta42906 = meta42906;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42905.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42907,meta42906__$1){
var self__ = this;
var _42907__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42905(self__.parse_fn,self__.unparse_fn,meta42906__$1));
}));

(com.rpl.specter.t_com$rpl$specter42905.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42907){
var self__ = this;
var _42907__$1 = this;
return self__.meta42906;
}));

(com.rpl.specter.t_com$rpl$specter42905.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42905.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return next_fn((self__.parse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.parse_fn.call(null,structure)));
}));

(com.rpl.specter.t_com$rpl$specter42905.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
var G__42908 = next_fn((self__.parse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.parse_fn.call(null,structure)));
return (self__.unparse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.unparse_fn.cljs$core$IFn$_invoke$arity$1(G__42908) : self__.unparse_fn.call(null,G__42908));
}));

(com.rpl.specter.t_com$rpl$specter42905.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parse-fn","parse-fn",-836029424,null),new cljs.core.Symbol(null,"unparse-fn","unparse-fn",407187734,null),new cljs.core.Symbol(null,"meta42906","meta42906",2078119191,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42905.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42905.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42905");

(com.rpl.specter.t_com$rpl$specter42905.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42905");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42905.
 */
com.rpl.specter.__GT_t_com$rpl$specter42905 = (function com$rpl$specter$__GT_t_com$rpl$specter42905(parse_fn__$1,unparse_fn__$1,meta42906){
return (new com.rpl.specter.t_com$rpl$specter42905(parse_fn__$1,unparse_fn__$1,meta42906));
});

}

return (new com.rpl.specter.t_com$rpl$specter42905(parse_fn,unparse_fn,null));
}));


com.rpl.specter.ATOM_select_STAR_ = (function com$rpl$specter$ATOM_select_STAR_(structure,next_fn){
var G__42909 = cljs.core.deref(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42909) : next_fn.call(null,G__42909));
});

com.rpl.specter.ATOM_transform_STAR_ = (function com$rpl$specter$ATOM_transform_STAR_(structure,next_fn){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(structure,next_fn);

return structure;
});

/**
 * Navigates to atom value.
 */
com.rpl.specter.ATOM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42910 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42910 = (function (meta42911){
this.meta42911 = meta42911;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42910.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42912,meta42911__$1){
var self__ = this;
var _42912__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42910(meta42911__$1));
}));

(com.rpl.specter.t_com$rpl$specter42910.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42912){
var self__ = this;
var _42912__$1 = this;
return self__.meta42911;
}));

(com.rpl.specter.t_com$rpl$specter42910.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42910.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return next_fn(cljs.core.deref(structure));
}));

(com.rpl.specter.t_com$rpl$specter42910.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(structure,next_fn);

return structure;
}));

(com.rpl.specter.t_com$rpl$specter42910.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42911","meta42911",1757726252,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42910.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42910.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42910");

(com.rpl.specter.t_com$rpl$specter42910.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42910");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42910.
 */
com.rpl.specter.__GT_t_com$rpl$specter42910 = (function com$rpl$specter$__GT_t_com$rpl$specter42910(meta42911){
return (new com.rpl.specter.t_com$rpl$specter42910(meta42911));
});

}

return (new com.rpl.specter.t_com$rpl$specter42910(null));
})()
;


com.rpl.specter.regex_nav_select_STAR_ = (function com$rpl$specter$regex_nav_select_STAR_(re,structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38664__auto__,s){
var ret__38665__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(s) : next_fn.call(null,s));
if((ret__38665__auto__ === com.rpl.specter.NONE)){
return curr__38664__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38665__auto__)){
return cljs.core.reduced(ret__38665__auto__);
} else {
return ret__38665__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.re_seq(re,structure));
});

com.rpl.specter.regex_nav_transform_STAR_ = (function com$rpl$specter$regex_nav_transform_STAR_(re,structure,next_fn){
return clojure.string.replace(structure,re,next_fn);
});

com.rpl.specter.regex_nav = com.rpl.specter.impl.direct_nav_obj((function (re){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42913 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42913 = (function (re,meta42914){
this.re = re;
this.meta42914 = meta42914;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42913.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42915,meta42914__$1){
var self__ = this;
var _42915__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42913(self__.re,meta42914__$1));
}));

(com.rpl.specter.t_com$rpl$specter42913.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42915){
var self__ = this;
var _42915__$1 = this;
return self__.meta42914;
}));

(com.rpl.specter.t_com$rpl$specter42913.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42913.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38664__auto__,s){
var ret__38665__auto__ = next_fn(s);
if((ret__38665__auto__ === com.rpl.specter.NONE)){
return curr__38664__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38665__auto__)){
return cljs.core.reduced(ret__38665__auto__);
} else {
return ret__38665__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.re_seq(self__.re,structure));
}));

(com.rpl.specter.t_com$rpl$specter42913.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return clojure.string.replace(structure,self__.re,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42913.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"re","re",1869207729,null),new cljs.core.Symbol(null,"meta42914","meta42914",-929964804,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42913.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42913.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42913");

(com.rpl.specter.t_com$rpl$specter42913.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42913");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42913.
 */
com.rpl.specter.__GT_t_com$rpl$specter42913 = (function com$rpl$specter$__GT_t_com$rpl$specter42913(re__$1,meta42914){
return (new com.rpl.specter.t_com$rpl$specter42913(re__$1,meta42914));
});

}

return (new com.rpl.specter.t_com$rpl$specter42913(re,null));
}));
/**
 * Filters the current value based on whether a path finds anything.
 *   e.g. (selected? :vals ALL even?) keeps the current element only if an
 *   even number exists for the :vals key.
 */
com.rpl.specter.selected_QMARK_ = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43102__delegate = function (path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(path);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
return afn;
} else {
var builder__41681__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42918 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42918 = (function (path,temp__5733__auto__,late,meta42919){
this.path = path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late = late;
this.meta42919 = meta42919;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42918.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42920,meta42919__$1){
var self__ = this;
var _42920__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42918(self__.path,self__.temp__5733__auto__,self__.late,meta42919__$1));
}));

(com.rpl.specter.t_com$rpl$specter42918.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42920){
var self__ = this;
var _42920__$1 = this;
return self__.meta42919;
}));

(com.rpl.specter.t_com$rpl$specter42918.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42918.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select((function (p1__42916_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late,vals,p1__42916_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42918.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform((function (p1__42917_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late,vals,p1__42917_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42918.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta42919","meta42919",794648158,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42918.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42918.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42918");

(com.rpl.specter.t_com$rpl$specter42918.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42918");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42918.
 */
com.rpl.specter.__GT_t_com$rpl$specter42918 = (function com$rpl$specter$__GT_t_com$rpl$specter42918(path__$1,temp__5733__auto____$1,late__$1,meta42919){
return (new com.rpl.specter.t_com$rpl$specter42918(path__$1,temp__5733__auto____$1,late__$1,meta42919));
});

}

return (new com.rpl.specter.t_com$rpl$specter42918(path,temp__5733__auto__,late,null));
}));
var curr_params__41682__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__41682__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__41681__auto__,curr_params__41682__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__41681__auto__,curr_params__41682__auto__,null);
}
}
};
var G__43102 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__43103__i = 0, G__43103__a = new Array(arguments.length -  0);
while (G__43103__i < G__43103__a.length) {G__43103__a[G__43103__i] = arguments[G__43103__i + 0]; ++G__43103__i;}
  path = new cljs.core.IndexedSeq(G__43103__a,0,null);
} 
return G__43102__delegate.call(this,path);};
G__43102.cljs$lang$maxFixedArity = 0;
G__43102.cljs$lang$applyTo = (function (arglist__43104){
var path = cljs.core.seq(arglist__43104);
return G__43102__delegate(path);
});
G__43102.cljs$core$IFn$_invoke$arity$variadic = G__43102__delegate;
return G__43102;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.not_selected_QMARK_ = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43105__delegate = function (path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(path);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
return (function (s){
return cljs.core.not((afn.cljs$core$IFn$_invoke$arity$1 ? afn.cljs$core$IFn$_invoke$arity$1(s) : afn.call(null,s)));
});
} else {
var builder__41681__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42923 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42923 = (function (path,temp__5733__auto__,late,meta42924){
this.path = path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late = late;
this.meta42924 = meta42924;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42923.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42925,meta42924__$1){
var self__ = this;
var _42925__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42923(self__.path,self__.temp__5733__auto__,self__.late,meta42924__$1));
}));

(com.rpl.specter.t_com$rpl$specter42923.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42925){
var self__ = this;
var _42925__$1 = this;
return self__.meta42924;
}));

(com.rpl.specter.t_com$rpl$specter42923.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42923.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select((function (p1__42921_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_(self__.late,vals,p1__42921_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42923.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform((function (p1__42922_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_(self__.late,vals,p1__42922_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42923.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta42924","meta42924",-1943707251,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42923.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42923.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42923");

(com.rpl.specter.t_com$rpl$specter42923.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42923");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42923.
 */
com.rpl.specter.__GT_t_com$rpl$specter42923 = (function com$rpl$specter$__GT_t_com$rpl$specter42923(path__$1,temp__5733__auto____$1,late__$1,meta42924){
return (new com.rpl.specter.t_com$rpl$specter42923(path__$1,temp__5733__auto____$1,late__$1,meta42924));
});

}

return (new com.rpl.specter.t_com$rpl$specter42923(path,temp__5733__auto__,late,null));
}));
var curr_params__41682__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__41682__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__41681__auto__,curr_params__41682__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__41681__auto__,curr_params__41682__auto__,null);
}
}
};
var G__43105 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__43106__i = 0, G__43106__a = new Array(arguments.length -  0);
while (G__43106__i < G__43106__a.length) {G__43106__a[G__43106__i] = arguments[G__43106__i + 0]; ++G__43106__i;}
  path = new cljs.core.IndexedSeq(G__43106__a,0,null);
} 
return G__43105__delegate.call(this,path);};
G__43105.cljs$lang$maxFixedArity = 0;
G__43105.cljs$lang$applyTo = (function (arglist__43107){
var path = cljs.core.seq(arglist__43107);
return G__43105__delegate(path);
});
G__43105.cljs$core$IFn$_invoke$arity$variadic = G__43105__delegate;
return G__43105;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current sequence that only contains elements that
 *   match the given path. An element matches the selector path if calling select
 *   on that element with the path yields anything other than an empty sequence.
 * 
 *   For transformation: `NONE` entries in the result sequence cause corresponding entries in
 *   input to be removed. A result sequence smaller than the input sequence is equivalent to
 *   padding the result sequence with `NONE` at the end until the same size as the input.
 */
com.rpl.specter.filterer = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43108__delegate = function (path){
var G__42926 = com.rpl.specter.ALL;
var G__42927 = (com.rpl.specter.selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.selected_QMARK_.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.selected_QMARK_.call(null,path));
return (com.rpl.specter.subselect.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.subselect.cljs$core$IFn$_invoke$arity$2(G__42926,G__42927) : com.rpl.specter.subselect.call(null,G__42926,G__42927));
};
var G__43108 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__43109__i = 0, G__43109__a = new Array(arguments.length -  0);
while (G__43109__i < G__43109__a.length) {G__43109__a[G__43109__i] = arguments[G__43109__i + 0]; ++G__43109__i;}
  path = new cljs.core.IndexedSeq(G__43109__a,0,null);
} 
return G__43108__delegate.call(this,path);};
G__43108.cljs$lang$maxFixedArity = 0;
G__43108.cljs$lang$applyTo = (function (arglist__43110){
var path = cljs.core.seq(arglist__43110);
return G__43108__delegate(path);
});
G__43108.cljs$core$IFn$_invoke$arity$variadic = G__43108__delegate;
return G__43108;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming it with the
 * specified path and update-fn.
 */
com.rpl.specter.transformed = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (path,update_fn){
var builder__41681__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late,late_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42928 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42928 = (function (path,update_fn,late,late_fn,meta42929){
this.path = path;
this.update_fn = update_fn;
this.late = late;
this.late_fn = late_fn;
this.meta42929 = meta42929;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42928.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42930,meta42929__$1){
var self__ = this;
var _42930__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42928(self__.path,self__.update_fn,self__.late,self__.late_fn,meta42929__$1));
}));

(com.rpl.specter.t_com$rpl$specter42928.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42930){
var self__ = this;
var _42930__$1 = this;
return self__.meta42929;
}));

(com.rpl.specter.t_com$rpl$specter42928.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42928.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return next_fn((com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(self__.late,self__.late_fn,structure) : com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure)));
}));

(com.rpl.specter.t_com$rpl$specter42928.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return next_fn((com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(self__.late,self__.late_fn,structure) : com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure)));
}));

(com.rpl.specter.t_com$rpl$specter42928.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"update-fn","update-fn",-1943348456,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta42929","meta42929",694345892,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42928.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42928.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42928");

(com.rpl.specter.t_com$rpl$specter42928.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42928");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42928.
 */
com.rpl.specter.__GT_t_com$rpl$specter42928 = (function com$rpl$specter$__GT_t_com$rpl$specter42928(path__$1,update_fn__$1,late__$1,late_fn__$1,meta42929){
return (new com.rpl.specter.t_com$rpl$specter42928(path__$1,update_fn__$1,late__$1,late_fn__$1,meta42929));
});

}

return (new com.rpl.specter.t_com$rpl$specter42928(path,update_fn,late,late_fn,null));
}));
var curr_params__41682__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path)),update_fn], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__41682__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__41681__auto__,curr_params__41682__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__41681__auto__,curr_params__41682__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming with a reduction over
 * the specified traversal.
 */
com.rpl.specter.traversed = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (path,reduce_fn){
var builder__41681__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late,late_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42931 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42931 = (function (path,reduce_fn,late,late_fn,meta42932){
this.path = path;
this.reduce_fn = reduce_fn;
this.late = late;
this.late_fn = late_fn;
this.meta42932 = meta42932;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42931.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42933,meta42932__$1){
var self__ = this;
var _42933__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42931(self__.path,self__.reduce_fn,self__.late,self__.late_fn,meta42932__$1));
}));

(com.rpl.specter.t_com$rpl$specter42931.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42933){
var self__ = this;
var _42933__$1 = this;
return self__.meta42932;
}));

(com.rpl.specter.t_com$rpl$specter42931.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42931.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return next_fn(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(self__.late_fn,(com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_traverse.call(null,self__.late,structure))));
}));

(com.rpl.specter.t_com$rpl$specter42931.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return next_fn(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(self__.late_fn,(com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_traverse.call(null,self__.late,structure))));
}));

(com.rpl.specter.t_com$rpl$specter42931.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"reduce-fn","reduce-fn",-1484020844,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta42932","meta42932",-1258722412,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42931.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42931.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42931");

(com.rpl.specter.t_com$rpl$specter42931.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42931");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42931.
 */
com.rpl.specter.__GT_t_com$rpl$specter42931 = (function com$rpl$specter$__GT_t_com$rpl$specter42931(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta42932){
return (new com.rpl.specter.t_com$rpl$specter42931(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta42932));
});

}

return (new com.rpl.specter.t_com$rpl$specter42931(path,reduce_fn,late,late_fn,null));
}));
var curr_params__41682__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path)),reduce_fn], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__41682__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__41681__auto__,curr_params__41682__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__41681__auto__,curr_params__41682__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Keeps the element only if it matches the supplied predicate. Functions in paths
 *        implicitly convert to this navigator.
 */
com.rpl.specter.pred = com.rpl.specter.impl.pred_STAR_;
com.rpl.specter.pred_EQ_ = (function com$rpl$specter$pred_EQ_(v){
var G__42935 = (function (p1__42934_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__42934_SHARP_,v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__42935) : com.rpl.specter.pred.call(null,G__42935));
});
com.rpl.specter.pred_LT_ = (function com$rpl$specter$pred_LT_(v){
var G__42937 = (function (p1__42936_SHARP_){
return (p1__42936_SHARP_ < v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__42937) : com.rpl.specter.pred.call(null,G__42937));
});
com.rpl.specter.pred_GT_ = (function com$rpl$specter$pred_GT_(v){
var G__42939 = (function (p1__42938_SHARP_){
return (p1__42938_SHARP_ > v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__42939) : com.rpl.specter.pred.call(null,G__42939));
});
com.rpl.specter.pred_LT__EQ_ = (function com$rpl$specter$pred_LT__EQ_(v){
var G__42941 = (function (p1__42940_SHARP_){
return (p1__42940_SHARP_ <= v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__42941) : com.rpl.specter.pred.call(null,G__42941));
});
com.rpl.specter.pred_GT__EQ_ = (function com$rpl$specter$pred_GT__EQ_(v){
var G__42943 = (function (p1__42942_SHARP_){
return (p1__42942_SHARP_ >= v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__42943) : com.rpl.specter.pred.call(null,G__42943));
});
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"null",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"null",(function (this$){
return com.rpl.specter.STAY;
}));
(cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
(cljs.core.Symbol.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Symbol.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"string",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"string",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"number",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"number",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
(cljs.core.char$.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.char$.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"boolean",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"boolean",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"function",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"function",(function (this$){
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.pred.call(null,this$));
}));
(cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.pred.call(null,this$__$1));
}));
(RegExp.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(RegExp.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.regex_nav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.regex_nav.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.regex_nav.call(null,this$__$1));
}));


com.rpl.specter.nil__GT_val_select_STAR_ = (function com$rpl$specter$nil__GT_val_select_STAR_(v,structure,next_fn){
var G__42944 = (((structure == null))?v:structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42944) : next_fn.call(null,G__42944));
});

com.rpl.specter.nil__GT_val_transform_STAR_ = (function com$rpl$specter$nil__GT_val_transform_STAR_(v,structure,next_fn){
var G__42945 = (((structure == null))?v:structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42945) : next_fn.call(null,G__42945));
});

/**
 * Navigates to the provided val if the structure is nil. Otherwise it stays
 *        navigated at the structure.
 */
com.rpl.specter.nil__GT_val = com.rpl.specter.impl.direct_nav_obj((function (v){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42946 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42946 = (function (v,meta42947){
this.v = v;
this.meta42947 = meta42947;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42946.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42948,meta42947__$1){
var self__ = this;
var _42948__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42946(self__.v,meta42947__$1));
}));

(com.rpl.specter.t_com$rpl$specter42946.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42948){
var self__ = this;
var _42948__$1 = this;
return self__.meta42947;
}));

(com.rpl.specter.t_com$rpl$specter42946.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42946.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return next_fn((((structure == null))?self__.v:structure));
}));

(com.rpl.specter.t_com$rpl$specter42946.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return next_fn((((structure == null))?self__.v:structure));
}));

(com.rpl.specter.t_com$rpl$specter42946.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"meta42947","meta42947",-838891994,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42946.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42946.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42946");

(com.rpl.specter.t_com$rpl$specter42946.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42946");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42946.
 */
com.rpl.specter.__GT_t_com$rpl$specter42946 = (function com$rpl$specter$__GT_t_com$rpl$specter42946(v__$1,meta42947){
return (new com.rpl.specter.t_com$rpl$specter42946(v__$1,meta42947));
});

}

return (new com.rpl.specter.t_com$rpl$specter42946(v,null));
}));
/**
 * Navigates to #{} if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_SET = (function (){var G__42949 = cljs.core.PersistentHashSet.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__42949) : com.rpl.specter.nil__GT_val.call(null,G__42949));
})();
/**
 * Navigates to '() if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_LIST = (function (){var G__42950 = cljs.core.List.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__42950) : com.rpl.specter.nil__GT_val.call(null,G__42950));
})();
/**
 * Navigates to [] if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_VECTOR = (function (){var G__42951 = cljs.core.PersistentVector.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__42951) : com.rpl.specter.nil__GT_val.call(null,G__42951));
})();


com.rpl.specter.META_select_STAR_ = (function com$rpl$specter$META_select_STAR_(structure,next_fn){
var G__42952 = cljs.core.meta(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42952) : next_fn.call(null,G__42952));
});

com.rpl.specter.META_transform_STAR_ = (function com$rpl$specter$META_transform_STAR_(structure,next_fn){
return cljs.core.with_meta(structure,(function (){var G__42953 = cljs.core.meta(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42953) : next_fn.call(null,G__42953));
})());
});

/**
 * Navigates to the metadata of the structure, or nil if
 *   the structure has no metadata or may not contain metadata.
 */
com.rpl.specter.META = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42954 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42954 = (function (meta42955){
this.meta42955 = meta42955;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42954.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42956,meta42955__$1){
var self__ = this;
var _42956__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42954(meta42955__$1));
}));

(com.rpl.specter.t_com$rpl$specter42954.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42956){
var self__ = this;
var _42956__$1 = this;
return self__.meta42955;
}));

(com.rpl.specter.t_com$rpl$specter42954.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42954.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return next_fn(cljs.core.meta(structure));
}));

(com.rpl.specter.t_com$rpl$specter42954.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return cljs.core.with_meta(structure,next_fn(cljs.core.meta(structure)));
}));

(com.rpl.specter.t_com$rpl$specter42954.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42955","meta42955",77450745,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42954.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42954.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42954");

(com.rpl.specter.t_com$rpl$specter42954.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42954");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42954.
 */
com.rpl.specter.__GT_t_com$rpl$specter42954 = (function com$rpl$specter$__GT_t_com$rpl$specter42954(meta42955){
return (new com.rpl.specter.t_com$rpl$specter42954(meta42955));
});

}

return (new com.rpl.specter.t_com$rpl$specter42954(null));
})()
;


com.rpl.specter.NAME_select_STAR_ = (function com$rpl$specter$NAME_select_STAR_(structure,next_fn){
var G__42957 = cljs.core.name(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42957) : next_fn.call(null,G__42957));
});

com.rpl.specter.NAME_transform_STAR_ = (function com$rpl$specter$NAME_transform_STAR_(structure,next_fn){
var new_name = (function (){var G__42958 = cljs.core.name(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42958) : next_fn.call(null,G__42958));
})();
var ns = cljs.core.namespace(structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAME can only be used on symbols or keywords - ",structure], 0));

}
}
});

/**
 * Navigates to the name portion of the keyword or symbol
 */
com.rpl.specter.NAME = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42959 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42959 = (function (meta42960){
this.meta42960 = meta42960;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42959.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42961,meta42960__$1){
var self__ = this;
var _42961__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42959(meta42960__$1));
}));

(com.rpl.specter.t_com$rpl$specter42959.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42961){
var self__ = this;
var _42961__$1 = this;
return self__.meta42960;
}));

(com.rpl.specter.t_com$rpl$specter42959.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42959.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return next_fn(cljs.core.name(structure));
}));

(com.rpl.specter.t_com$rpl$specter42959.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
var new_name = next_fn(cljs.core.name(structure));
var ns = cljs.core.namespace(structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAME can only be used on symbols or keywords - ",structure], 0));

}
}
}));

(com.rpl.specter.t_com$rpl$specter42959.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42960","meta42960",1339802673,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42959.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42959.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42959");

(com.rpl.specter.t_com$rpl$specter42959.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42959");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42959.
 */
com.rpl.specter.__GT_t_com$rpl$specter42959 = (function com$rpl$specter$__GT_t_com$rpl$specter42959(meta42960){
return (new com.rpl.specter.t_com$rpl$specter42959(meta42960));
});

}

return (new com.rpl.specter.t_com$rpl$specter42959(null));
})()
;


com.rpl.specter.NAMESPACE_select_STAR_ = (function com$rpl$specter$NAMESPACE_select_STAR_(structure,next_fn){
var G__42962 = cljs.core.namespace(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42962) : next_fn.call(null,G__42962));
});

com.rpl.specter.NAMESPACE_transform_STAR_ = (function com$rpl$specter$NAMESPACE_transform_STAR_(structure,next_fn){
var name = cljs.core.name(structure);
var new_ns = (function (){var G__42963 = cljs.core.namespace(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42963) : next_fn.call(null,G__42963));
})();
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAMESPACE can only be used on symbols or keywords - ",structure], 0));

}
}
});

/**
 * Navigates to the namespace portion of the keyword or symbol
 */
com.rpl.specter.NAMESPACE = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42964 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42964 = (function (meta42965){
this.meta42965 = meta42965;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42964.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42966,meta42965__$1){
var self__ = this;
var _42966__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42964(meta42965__$1));
}));

(com.rpl.specter.t_com$rpl$specter42964.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42966){
var self__ = this;
var _42966__$1 = this;
return self__.meta42965;
}));

(com.rpl.specter.t_com$rpl$specter42964.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42964.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
return next_fn(cljs.core.namespace(structure));
}));

(com.rpl.specter.t_com$rpl$specter42964.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40853__auto__,vals__40854__auto__,structure,next_fn__40855__auto__){
var self__ = this;
var this__40853__auto____$1 = this;
var next_fn = (function (s__40856__auto__){
return (next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40855__auto__.cljs$core$IFn$_invoke$arity$2(vals__40854__auto__,s__40856__auto__) : next_fn__40855__auto__.call(null,vals__40854__auto__,s__40856__auto__));
});
var name = cljs.core.name(structure);
var new_ns = next_fn(cljs.core.namespace(structure));
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAMESPACE can only be used on symbols or keywords - ",structure], 0));

}
}
}));

(com.rpl.specter.t_com$rpl$specter42964.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42965","meta42965",1502895446,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42964.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42964.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42964");

(com.rpl.specter.t_com$rpl$specter42964.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42964");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42964.
 */
com.rpl.specter.__GT_t_com$rpl$specter42964 = (function com$rpl$specter$__GT_t_com$rpl$specter42964(meta42965){
return (new com.rpl.specter.t_com$rpl$specter42964(meta42965));
});

}

return (new com.rpl.specter.t_com$rpl$specter42964(null));
})()
;
/**
 * Adds the result of running select with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43140__delegate = function (path){
var builder__41681__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42967 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42967 = (function (path,late,meta42968){
this.path = path;
this.late = late;
this.meta42968 = meta42968;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42967.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42969,meta42968__$1){
var self__ = this;
var _42969__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42967(self__.path,self__.late,meta42968__$1));
}));

(com.rpl.specter.t_com$rpl$specter42967.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42969){
var self__ = this;
var _42969__$1 = this;
return self__.meta42968;
}));

(com.rpl.specter.t_com$rpl$specter42967.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42967.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41678__auto__,vals__41679__auto__,structure,next_fn__41680__auto__){
var self__ = this;
var this__41678__auto____$1 = this;
var G__42970 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__41679__auto__,(com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
var G__42971 = structure;
return (next_fn__41680__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41680__auto__.cljs$core$IFn$_invoke$arity$2(G__42970,G__42971) : next_fn__41680__auto__.call(null,G__42970,G__42971));
}));

(com.rpl.specter.t_com$rpl$specter42967.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41678__auto__,vals__41679__auto__,structure,next_fn__41680__auto__){
var self__ = this;
var this__41678__auto____$1 = this;
var G__42972 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__41679__auto__,(com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
var G__42973 = structure;
return (next_fn__41680__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41680__auto__.cljs$core$IFn$_invoke$arity$2(G__42972,G__42973) : next_fn__41680__auto__.call(null,G__42972,G__42973));
}));

(com.rpl.specter.t_com$rpl$specter42967.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta42968","meta42968",283717985,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42967.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42967.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42967");

(com.rpl.specter.t_com$rpl$specter42967.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42967");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42967.
 */
com.rpl.specter.__GT_t_com$rpl$specter42967 = (function com$rpl$specter$__GT_t_com$rpl$specter42967(path__$1,late__$1,meta42968){
return (new com.rpl.specter.t_com$rpl$specter42967(path__$1,late__$1,meta42968));
});

}

return (new com.rpl.specter.t_com$rpl$specter42967(path,late,null));
}));
var curr_params__41682__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__41682__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__41681__auto__,curr_params__41682__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__41681__auto__,curr_params__41682__auto__,null);
}
};
var G__43140 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__43146__i = 0, G__43146__a = new Array(arguments.length -  0);
while (G__43146__i < G__43146__a.length) {G__43146__a[G__43146__i] = arguments[G__43146__i + 0]; ++G__43146__i;}
  path = new cljs.core.IndexedSeq(G__43146__a,0,null);
} 
return G__43140__delegate.call(this,path);};
G__43140.cljs$lang$maxFixedArity = 0;
G__43140.cljs$lang$applyTo = (function (arglist__43151){
var path = cljs.core.seq(arglist__43151);
return G__43140__delegate(path);
});
G__43140.cljs$core$IFn$_invoke$arity$variadic = G__43140__delegate;
return G__43140;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds the result of running select-one with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect_one = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43153__delegate = function (path){
var builder__41681__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42974 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42974 = (function (path,late,meta42975){
this.path = path;
this.late = late;
this.meta42975 = meta42975;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42974.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42976,meta42975__$1){
var self__ = this;
var _42976__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42974(self__.path,self__.late,meta42975__$1));
}));

(com.rpl.specter.t_com$rpl$specter42974.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42976){
var self__ = this;
var _42976__$1 = this;
return self__.meta42975;
}));

(com.rpl.specter.t_com$rpl$specter42974.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42974.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41678__auto__,vals__41679__auto__,structure,next_fn__41680__auto__){
var self__ = this;
var this__41678__auto____$1 = this;
var G__42977 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__41679__auto__,(com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select_one.call(null,self__.late,structure)));
var G__42978 = structure;
return (next_fn__41680__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41680__auto__.cljs$core$IFn$_invoke$arity$2(G__42977,G__42978) : next_fn__41680__auto__.call(null,G__42977,G__42978));
}));

(com.rpl.specter.t_com$rpl$specter42974.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41678__auto__,vals__41679__auto__,structure,next_fn__41680__auto__){
var self__ = this;
var this__41678__auto____$1 = this;
var G__42979 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__41679__auto__,(com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select_one.call(null,self__.late,structure)));
var G__42980 = structure;
return (next_fn__41680__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41680__auto__.cljs$core$IFn$_invoke$arity$2(G__42979,G__42980) : next_fn__41680__auto__.call(null,G__42979,G__42980));
}));

(com.rpl.specter.t_com$rpl$specter42974.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta42975","meta42975",1134621572,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42974.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42974.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42974");

(com.rpl.specter.t_com$rpl$specter42974.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42974");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42974.
 */
com.rpl.specter.__GT_t_com$rpl$specter42974 = (function com$rpl$specter$__GT_t_com$rpl$specter42974(path__$1,late__$1,meta42975){
return (new com.rpl.specter.t_com$rpl$specter42974(path__$1,late__$1,meta42975));
});

}

return (new com.rpl.specter.t_com$rpl$specter42974(path,late,null));
}));
var curr_params__41682__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__41682__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__41681__auto__,curr_params__41682__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__41681__auto__,curr_params__41682__auto__,null);
}
};
var G__43153 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__43157__i = 0, G__43157__a = new Array(arguments.length -  0);
while (G__43157__i < G__43157__a.length) {G__43157__a[G__43157__i] = arguments[G__43157__i + 0]; ++G__43157__i;}
  path = new cljs.core.IndexedSeq(G__43157__a,0,null);
} 
return G__43153__delegate.call(this,path);};
G__43153.cljs$lang$maxFixedArity = 0;
G__43153.cljs$lang$applyTo = (function (arglist__43158){
var path = cljs.core.seq(arglist__43158);
return G__43153__delegate(path);
});
G__43153.cljs$core$IFn$_invoke$arity$variadic = G__43153__delegate;
return G__43153;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds an external value to the collected vals. Useful when additional arguments
 *   are required to the transform function that would otherwise require partial
 *   application or a wrapper function.
 * 
 *   e.g., incrementing val at path [:a :b] by 3:
 *   (transform [:a :b (putval 3)] + some-map)
 */
com.rpl.specter.putval = com.rpl.specter.impl.direct_nav_obj((function (val){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42981 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42981 = (function (val,meta42982){
this.val = val;
this.meta42982 = meta42982;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42981.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42983,meta42982__$1){
var self__ = this;
var _42983__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42981(self__.val,meta42982__$1));
}));

(com.rpl.specter.t_com$rpl$specter42981.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42983){
var self__ = this;
var _42983__$1 = this;
return self__.meta42982;
}));

(com.rpl.specter.t_com$rpl$specter42981.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42981.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41678__auto__,vals__41679__auto__,structure,next_fn__41680__auto__){
var self__ = this;
var this__41678__auto____$1 = this;
var G__42984 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__41679__auto__,self__.val);
var G__42985 = structure;
return (next_fn__41680__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41680__auto__.cljs$core$IFn$_invoke$arity$2(G__42984,G__42985) : next_fn__41680__auto__.call(null,G__42984,G__42985));
}));

(com.rpl.specter.t_com$rpl$specter42981.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41678__auto__,vals__41679__auto__,structure,next_fn__41680__auto__){
var self__ = this;
var this__41678__auto____$1 = this;
var G__42986 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__41679__auto__,self__.val);
var G__42987 = structure;
return (next_fn__41680__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41680__auto__.cljs$core$IFn$_invoke$arity$2(G__42986,G__42987) : next_fn__41680__auto__.call(null,G__42986,G__42987));
}));

(com.rpl.specter.t_com$rpl$specter42981.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"meta42982","meta42982",2050528824,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42981.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42981.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42981");

(com.rpl.specter.t_com$rpl$specter42981.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42981");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42981.
 */
com.rpl.specter.__GT_t_com$rpl$specter42981 = (function com$rpl$specter$__GT_t_com$rpl$specter42981(val__$1,meta42982){
return (new com.rpl.specter.t_com$rpl$specter42981(val__$1,meta42982));
});

}

return (new com.rpl.specter.t_com$rpl$specter42981(val,null));
}));
/**
 * Continues navigating on the given path with the collected vals reset to []. Once
 *   navigation leaves the scope of with-fresh-collected, the collected vals revert
 *   to what they were before.
 */
com.rpl.specter.with_fresh_collected = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43160__delegate = function (path){
var builder__41681__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42988 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42988 = (function (path,late,meta42989){
this.path = path;
this.late = late;
this.meta42989 = meta42989;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42988.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42990,meta42989__$1){
var self__ = this;
var _42990__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42988(self__.path,self__.late,meta42989__$1));
}));

(com.rpl.specter.t_com$rpl$specter42988.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42990){
var self__ = this;
var _42990__$1 = this;
return self__.meta42989;
}));

(com.rpl.specter.t_com$rpl$specter42988.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42988.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.select_STAR_(self__.late,cljs.core.PersistentVector.EMPTY,structure,(function (_,structure__$1){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,structure__$1) : next_fn.call(null,vals,structure__$1));
}));
}));

(com.rpl.specter.t_com$rpl$specter42988.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.transform_STAR_(self__.late,cljs.core.PersistentVector.EMPTY,structure,(function (_,structure__$1){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,structure__$1) : next_fn.call(null,vals,structure__$1));
}));
}));

(com.rpl.specter.t_com$rpl$specter42988.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta42989","meta42989",694674806,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42988.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42988.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42988");

(com.rpl.specter.t_com$rpl$specter42988.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42988");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42988.
 */
com.rpl.specter.__GT_t_com$rpl$specter42988 = (function com$rpl$specter$__GT_t_com$rpl$specter42988(path__$1,late__$1,meta42989){
return (new com.rpl.specter.t_com$rpl$specter42988(path__$1,late__$1,meta42989));
});

}

return (new com.rpl.specter.t_com$rpl$specter42988(path,late,null));
}));
var curr_params__41682__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__41682__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__41681__auto__,curr_params__41682__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__41681__auto__,curr_params__41682__auto__,null);
}
};
var G__43160 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__43167__i = 0, G__43167__a = new Array(arguments.length -  0);
while (G__43167__i < G__43167__a.length) {G__43167__a[G__43167__i] = arguments[G__43167__i + 0]; ++G__43167__i;}
  path = new cljs.core.IndexedSeq(G__43167__a,0,null);
} 
return G__43160__delegate.call(this,path);};
G__43160.cljs$lang$maxFixedArity = 0;
G__43160.cljs$lang$applyTo = (function (arglist__43168){
var path = cljs.core.seq(arglist__43168);
return G__43160__delegate(path);
});
G__43160.cljs$core$IFn$_invoke$arity$variadic = G__43160__delegate;
return G__43160;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Drops all collected values for subsequent navigation.
 */
com.rpl.specter.DISPENSE = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42993 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42993 = (function (meta42994){
this.meta42994 = meta42994;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42993.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42995,meta42994__$1){
var self__ = this;
var _42995__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42993(meta42994__$1));
}));

(com.rpl.specter.t_com$rpl$specter42993.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42995){
var self__ = this;
var _42995__$1 = this;
return self__.meta42994;
}));

(com.rpl.specter.t_com$rpl$specter42993.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42993.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__42996 = cljs.core.PersistentVector.EMPTY;
var G__42997 = structure;
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__42996,G__42997) : next_fn.call(null,G__42996,G__42997));
}));

(com.rpl.specter.t_com$rpl$specter42993.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__42998 = cljs.core.PersistentVector.EMPTY;
var G__42999 = structure;
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__42998,G__42999) : next_fn.call(null,G__42998,G__42999));
}));

(com.rpl.specter.t_com$rpl$specter42993.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42994","meta42994",-624681126,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42993.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42993.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42993");

(com.rpl.specter.t_com$rpl$specter42993.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42993");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42993.
 */
com.rpl.specter.__GT_t_com$rpl$specter42993 = (function com$rpl$specter$__GT_t_com$rpl$specter42993(meta42994){
return (new com.rpl.specter.t_com$rpl$specter42993(meta42994));
});

}

return (new com.rpl.specter.t_com$rpl$specter42993(null));
})()
;
/**
 * Like cond-path, but with if semantics.
 */
com.rpl.specter.if_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() {
var G__43169 = null;
var G__43169__2 = (function (cond_p,then_path){
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3(cond_p,then_path,com.rpl.specter.STOP) : com.rpl.specter.if_path.call(null,cond_p,then_path,com.rpl.specter.STOP));
});
var G__43169__3 = (function (cond_p,then_path,else_path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(cond_p);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
var builder__41681__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late_then,late_else){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter43002 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter43002 = (function (cond_p,then_path,else_path,temp__5733__auto__,afn,late_then,late_else,meta43003){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__5733__auto__ = temp__5733__auto__;
this.afn = afn;
this.late_then = late_then;
this.late_else = late_else;
this.meta43003 = meta43003;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter43002.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43004,meta43003__$1){
var self__ = this;
var _43004__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter43002(self__.cond_p,self__.then_path,self__.else_path,self__.temp__5733__auto__,self__.afn,self__.late_then,self__.late_else,meta43003__$1));
}));

(com.rpl.specter.t_com$rpl$specter43002.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43004){
var self__ = this;
var _43004__$1 = this;
return self__.meta43003;
}));

(com.rpl.specter.t_com$rpl$specter43002.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter43002.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select(vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter43002.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform(vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter43002.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta43003","meta43003",458261594,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter43002.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter43002.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter43002");

(com.rpl.specter.t_com$rpl$specter43002.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter43002");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter43002.
 */
com.rpl.specter.__GT_t_com$rpl$specter43002 = (function com$rpl$specter$__GT_t_com$rpl$specter43002(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,afn__$1,late_then__$1,late_else__$1,meta43003){
return (new com.rpl.specter.t_com$rpl$specter43002(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,afn__$1,late_then__$1,late_else__$1,meta43003));
});

}

return (new com.rpl.specter.t_com$rpl$specter43002(cond_p,then_path,else_path,temp__5733__auto__,afn,late_then,late_else,null));
}));
var curr_params__41682__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(then_path) : com.rpl.specter.late_path.call(null,then_path)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(else_path) : com.rpl.specter.late_path.call(null,else_path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__41682__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__41681__auto__,curr_params__41682__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__41681__auto__,curr_params__41682__auto__,null);
}
} else {
var builder__41681__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late_cond,late_then,late_else){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter43005 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter43005 = (function (cond_p,then_path,else_path,temp__5733__auto__,late_cond,late_then,late_else,meta43006){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late_cond = late_cond;
this.late_then = late_then;
this.late_else = late_else;
this.meta43006 = meta43006;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter43005.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43007,meta43006__$1){
var self__ = this;
var _43007__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter43005(self__.cond_p,self__.then_path,self__.else_path,self__.temp__5733__auto__,self__.late_cond,self__.late_then,self__.late_else,meta43006__$1));
}));

(com.rpl.specter.t_com$rpl$specter43005.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43007){
var self__ = this;
var _43007__$1 = this;
return self__.meta43006;
}));

(com.rpl.specter.t_com$rpl$specter43005.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter43005.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select(vals,structure,next_fn,(function (p1__43000_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late_cond,vals,p1__43000_SHARP_);
}),self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter43005.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform(vals,structure,next_fn,(function (p1__43001_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late_cond,vals,p1__43001_SHARP_);
}),self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter43005.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late-cond","late-cond",1031862828,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta43006","meta43006",-1466011285,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter43005.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter43005.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter43005");

(com.rpl.specter.t_com$rpl$specter43005.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter43005");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter43005.
 */
com.rpl.specter.__GT_t_com$rpl$specter43005 = (function com$rpl$specter$__GT_t_com$rpl$specter43005(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta43006){
return (new com.rpl.specter.t_com$rpl$specter43005(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta43006));
});

}

return (new com.rpl.specter.t_com$rpl$specter43005(cond_p,then_path,else_path,temp__5733__auto__,late_cond,late_then,late_else,null));
}));
var curr_params__41682__auto__ = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(cond_p) : com.rpl.specter.late_path.call(null,cond_p)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(then_path) : com.rpl.specter.late_path.call(null,then_path)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(else_path) : com.rpl.specter.late_path.call(null,else_path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__41682__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__41681__auto__,curr_params__41682__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__41681__auto__,curr_params__41682__auto__,null);
}
}
});
G__43169 = function(cond_p,then_path,else_path){
switch(arguments.length){
case 2:
return G__43169__2.call(this,cond_p,then_path);
case 3:
return G__43169__3.call(this,cond_p,then_path,else_path);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43169.cljs$core$IFn$_invoke$arity$2 = G__43169__2;
G__43169.cljs$core$IFn$_invoke$arity$3 = G__43169__3;
return G__43169;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Takes in alternating cond-path path cond-path path...
 * Tests the structure if selecting with cond-path returns anything.
 * If so, it uses the following path for this portion of the navigation.
 * Otherwise, it tries the next cond-path. If nothing matches, then the structure
 * is not selected.
 */
com.rpl.specter.cond_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43170__delegate = function (conds){
var pairs = cljs.core.reverse(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),conds));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p,p__43008){
var vec__43009 = p__43008;
var tester = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43009,(0),null);
var apath = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43009,(1),null);
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3(tester,apath,p) : com.rpl.specter.if_path.call(null,tester,apath,p));
}),com.rpl.specter.STOP,pairs);
};
var G__43170 = function (var_args){
var conds = null;
if (arguments.length > 0) {
var G__43171__i = 0, G__43171__a = new Array(arguments.length -  0);
while (G__43171__i < G__43171__a.length) {G__43171__a[G__43171__i] = arguments[G__43171__i + 0]; ++G__43171__i;}
  conds = new cljs.core.IndexedSeq(G__43171__a,0,null);
} 
return G__43170__delegate.call(this,conds);};
G__43170.cljs$lang$maxFixedArity = 0;
G__43170.cljs$lang$applyTo = (function (arglist__43172){
var conds = cljs.core.seq(arglist__43172);
return G__43170__delegate(conds);
});
G__43170.cljs$core$IFn$_invoke$arity$variadic = G__43170__delegate;
return G__43170;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * A path that branches on multiple paths. For updates,
 * applies updates to the paths in order.
 */
com.rpl.specter.multi_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() {
var G__43173 = null;
var G__43173__0 = (function (){
return com.rpl.specter.STAY;
});
var G__43173__1 = (function (path){
return path;
});
var G__43173__2 = (function (path1,path2){
var builder__41681__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late1,late2){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter43012 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter43012 = (function (path1,path2,late1,late2,meta43013){
this.path1 = path1;
this.path2 = path2;
this.late1 = late1;
this.late2 = late2;
this.meta43013 = meta43013;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter43012.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43014,meta43013__$1){
var self__ = this;
var _43014__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter43012(self__.path1,self__.path2,self__.late1,self__.late2,meta43013__$1));
}));

(com.rpl.specter.t_com$rpl$specter43012.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43014){
var self__ = this;
var _43014__$1 = this;
return self__.meta43013;
}));

(com.rpl.specter.t_com$rpl$specter43012.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter43012.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var res1 = com.rpl.specter.protocols.select_STAR_(self__.late1,vals,structure,next_fn);
if(cljs.core.reduced_QMARK_(res1)){
return res1;
} else {
var res2 = com.rpl.specter.protocols.select_STAR_(self__.late2,vals,structure,next_fn);
if((com.rpl.specter.NONE === res1)){
return res2;
} else {
return res1;
}
}
}));

(com.rpl.specter.t_com$rpl$specter43012.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var s1 = com.rpl.specter.protocols.transform_STAR_(self__.late1,vals,structure,next_fn);
return com.rpl.specter.protocols.transform_STAR_(self__.late2,vals,s1,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter43012.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path1","path1",-2002517142,null),new cljs.core.Symbol(null,"path2","path2",-1937913521,null),new cljs.core.Symbol(null,"late1","late1",-1413016621,null),new cljs.core.Symbol(null,"late2","late2",-681717994,null),new cljs.core.Symbol(null,"meta43013","meta43013",-840639824,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter43012.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter43012.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter43012");

(com.rpl.specter.t_com$rpl$specter43012.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter43012");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter43012.
 */
com.rpl.specter.__GT_t_com$rpl$specter43012 = (function com$rpl$specter$__GT_t_com$rpl$specter43012(path1__$1,path2__$1,late1__$1,late2__$1,meta43013){
return (new com.rpl.specter.t_com$rpl$specter43012(path1__$1,path2__$1,late1__$1,late2__$1,meta43013));
});

}

return (new com.rpl.specter.t_com$rpl$specter43012(path1,path2,late1,late2,null));
}));
var curr_params__41682__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path1) : com.rpl.specter.late_path.call(null,path1)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path2) : com.rpl.specter.late_path.call(null,path2))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__41682__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__41681__auto__,curr_params__41682__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__41681__auto__,curr_params__41682__auto__,null);
}
});
var G__43173__3 = (function() { 
var G__43174__delegate = function (path1,path2,paths){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(com.rpl.specter.multi_path,(com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(path1,path2) : com.rpl.specter.multi_path.call(null,path1,path2)),paths);
};
var G__43174 = function (path1,path2,var_args){
var paths = null;
if (arguments.length > 2) {
var G__43175__i = 0, G__43175__a = new Array(arguments.length -  2);
while (G__43175__i < G__43175__a.length) {G__43175__a[G__43175__i] = arguments[G__43175__i + 2]; ++G__43175__i;}
  paths = new cljs.core.IndexedSeq(G__43175__a,0,null);
} 
return G__43174__delegate.call(this,path1,path2,paths);};
G__43174.cljs$lang$maxFixedArity = 2;
G__43174.cljs$lang$applyTo = (function (arglist__43176){
var path1 = cljs.core.first(arglist__43176);
arglist__43176 = cljs.core.next(arglist__43176);
var path2 = cljs.core.first(arglist__43176);
var paths = cljs.core.rest(arglist__43176);
return G__43174__delegate(path1,path2,paths);
});
G__43174.cljs$core$IFn$_invoke$arity$variadic = G__43174__delegate;
return G__43174;
})()
;
G__43173 = function(path1,path2,var_args){
var paths = var_args;
switch(arguments.length){
case 0:
return G__43173__0.call(this);
case 1:
return G__43173__1.call(this,path1);
case 2:
return G__43173__2.call(this,path1,path2);
default:
var G__43177 = null;
if (arguments.length > 2) {
var G__43178__i = 0, G__43178__a = new Array(arguments.length -  2);
while (G__43178__i < G__43178__a.length) {G__43178__a[G__43178__i] = arguments[G__43178__i + 2]; ++G__43178__i;}
G__43177 = new cljs.core.IndexedSeq(G__43178__a,0,null);
}
return G__43173__3.cljs$core$IFn$_invoke$arity$variadic(path1,path2, G__43177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43173.cljs$lang$maxFixedArity = 2;
G__43173.cljs$lang$applyTo = G__43173__3.cljs$lang$applyTo;
G__43173.cljs$core$IFn$_invoke$arity$0 = G__43173__0;
G__43173.cljs$core$IFn$_invoke$arity$1 = G__43173__1;
G__43173.cljs$core$IFn$_invoke$arity$2 = G__43173__2;
G__43173.cljs$core$IFn$_invoke$arity$variadic = G__43173__3.cljs$core$IFn$_invoke$arity$variadic;
return G__43173;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the current element and then navigates via the provided path.
 * This can be used to implement pre-order traversal.
 */
com.rpl.specter.stay_then_continue = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43179__delegate = function (path){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.STAY,path) : com.rpl.specter.multi_path.call(null,com.rpl.specter.STAY,path));
};
var G__43179 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__43180__i = 0, G__43180__a = new Array(arguments.length -  0);
while (G__43180__i < G__43180__a.length) {G__43180__a[G__43180__i] = arguments[G__43180__i + 0]; ++G__43180__i;}
  path = new cljs.core.IndexedSeq(G__43180__a,0,null);
} 
return G__43179__delegate.call(this,path);};
G__43179.cljs$lang$maxFixedArity = 0;
G__43179.cljs$lang$applyTo = (function (arglist__43181){
var path = cljs.core.seq(arglist__43181);
return G__43179__delegate(path);
});
G__43179.cljs$core$IFn$_invoke$arity$variadic = G__43179__delegate;
return G__43179;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the provided path and then to the current element. This can be used
 * to implement post-order traversal.
 */
com.rpl.specter.continue_then_stay = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43182__delegate = function (path){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(path,com.rpl.specter.STAY) : com.rpl.specter.multi_path.call(null,path,com.rpl.specter.STAY));
};
var G__43182 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__43183__i = 0, G__43183__a = new Array(arguments.length -  0);
while (G__43183__i < G__43183__a.length) {G__43183__a[G__43183__i] = arguments[G__43183__i + 0]; ++G__43183__i;}
  path = new cljs.core.IndexedSeq(G__43183__a,0,null);
} 
return G__43182__delegate.call(this,path);};
G__43182.cljs$lang$maxFixedArity = 0;
G__43182.cljs$lang$applyTo = (function (arglist__43184){
var path = cljs.core.seq(arglist__43184);
return G__43182__delegate(path);
});
G__43182.cljs$core$IFn$_invoke$arity$variadic = G__43182__delegate;
return G__43182;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigate the data structure until reaching
 *        a value for which `afn` returns truthy. Has
 *        same semantics as clojure.walk.
 */
com.rpl.specter.walker = com.rpl.specter.impl.direct_nav_obj((function (afn){
var p = com.rpl.specter.impl.local_declarepath();
com.rpl.specter.impl.providepath_STAR_(p,(function (){var info__41688__auto__ = com.rpl.specter.pathcache43019;
var info__41688__auto____$1 = (((info__41688__auto__ == null))?(function (){var info43020 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"com/rpl/specter.cljc",25,1,1394,1394,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"com/rpl/specter.cljc",7,1,true,1175,1179,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. Functions in paths\n          implicitly convert to this navigator.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"com/rpl/specter.cljc",7,1,644,646,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse(cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",12,1,2133,2133,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",(cljs.core.truth_(cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_LocalSym(p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache43019 = info43020;

return info43020;
})():info__41688__auto__);
var precompiled43021 = com.rpl.specter.impl.cached_path_info_precompiled(info__41688__auto____$1);
var dynamic_QMARK___41689__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41688__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41689__auto__)){
var G__43022 = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,p], null),com.rpl.specter.ALL,p], null);
return (precompiled43021.cljs$core$IFn$_invoke$arity$1 ? precompiled43021.cljs$core$IFn$_invoke$arity$1(G__43022) : precompiled43021.call(null,G__43022));
} else {
return precompiled43021;
}
})());

return p;
}));
/**
 * Like `walker` but maintains metadata of any forms traversed.
 */
com.rpl.specter.codewalker = com.rpl.specter.impl.direct_nav_obj((function (afn){
var p = com.rpl.specter.impl.local_declarepath();
com.rpl.specter.impl.providepath_STAR_(p,(function (){var info__41688__auto__ = com.rpl.specter.pathcache43023;
var info__41688__auto____$1 = (((info__41688__auto__ == null))?(function (){var info43024 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"com/rpl/specter.cljc",25,1,1394,1394,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"com/rpl/specter.cljc",7,1,true,1175,1179,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. Functions in paths\n          implicitly convert to this navigator.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"com/rpl/specter.cljc",7,1,644,646,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse(cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",12,1,2133,2133,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",(cljs.core.truth_(cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL_WITH_META,new cljs.core.Var(function(){return com.rpl.specter.ALL_WITH_META;},new cljs.core.Symbol("com.rpl.specter","ALL-WITH-META","com.rpl.specter/ALL-WITH-META",-1161868995,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),"com/rpl/specter.cljc",16,1,689,691,cljs.core.List.EMPTY,"Same as ALL, except maintains metadata on the structure.",(cljs.core.truth_(com.rpl.specter.ALL_WITH_META)?com.rpl.specter.ALL_WITH_META.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null)),com.rpl.specter.impl.__GT_LocalSym(p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache43023 = info43024;

return info43024;
})():info__41688__auto__);
var precompiled43025 = com.rpl.specter.impl.cached_path_info_precompiled(info__41688__auto____$1);
var dynamic_QMARK___41689__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41688__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41689__auto__)){
var G__43026 = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL_WITH_META,p], null),com.rpl.specter.ALL_WITH_META,p], null);
return (precompiled43025.cljs$core$IFn$_invoke$arity$1 ? precompiled43025.cljs$core$IFn$_invoke$arity$1(G__43026) : precompiled43025.call(null,G__43026));
} else {
return precompiled43025;
}
})());

return p;
}));
var empty__GT_NONE_43185 = (function (){var G__43027 = cljs.core.empty_QMARK_;
var G__43028 = com.rpl.specter.terminal_val(com.rpl.specter.NONE);
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$2(G__43027,G__43028) : com.rpl.specter.if_path.call(null,G__43027,G__43028));
})();
var compact_STAR__43186 = (function (nav){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(nav,empty__GT_NONE_43185) : com.rpl.specter.multi_path.call(null,nav,empty__GT_NONE_43185));
});
/**
 * During transforms, after each step of navigation in subpath check if the
 *  value is empty. If so, remove that value by setting it to NONE.
 */
com.rpl.specter.compact = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43187__delegate = function (path){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(compact_STAR__43186,path);
};
var G__43187 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__43188__i = 0, G__43188__a = new Array(arguments.length -  0);
while (G__43188__i < G__43188__a.length) {G__43188__a[G__43188__i] = arguments[G__43188__i + 0]; ++G__43188__i;}
  path = new cljs.core.IndexedSeq(G__43188__a,0,null);
} 
return G__43187__delegate.call(this,path);};
G__43187.cljs$lang$maxFixedArity = 0;
G__43187.cljs$lang$applyTo = (function (arglist__43189){
var path = cljs.core.seq(arglist__43189);
return G__43187__delegate(path);
});
G__43187.cljs$core$IFn$_invoke$arity$variadic = G__43187__delegate;
return G__43187;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);

//# sourceMappingURL=com.rpl.specter.js.map
