goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__31127 = arguments.length;
switch (G__31127) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31128 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31128 = (function (f,blockable,meta31129){
this.f = f;
this.blockable = blockable;
this.meta31129 = meta31129;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31128.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31130,meta31129__$1){
var self__ = this;
var _31130__$1 = this;
return (new cljs.core.async.t_cljs$core$async31128(self__.f,self__.blockable,meta31129__$1));
}));

(cljs.core.async.t_cljs$core$async31128.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31130){
var self__ = this;
var _31130__$1 = this;
return self__.meta31129;
}));

(cljs.core.async.t_cljs$core$async31128.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31128.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async31128.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async31128.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async31128.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta31129","meta31129",1501844187,null)], null);
}));

(cljs.core.async.t_cljs$core$async31128.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31128.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31128");

(cljs.core.async.t_cljs$core$async31128.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async31128");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31128.
 */
cljs.core.async.__GT_t_cljs$core$async31128 = (function cljs$core$async$__GT_t_cljs$core$async31128(f__$1,blockable__$1,meta31129){
return (new cljs.core.async.t_cljs$core$async31128(f__$1,blockable__$1,meta31129));
});

}

return (new cljs.core.async.t_cljs$core$async31128(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__31133 = arguments.length;
switch (G__31133) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__31136 = arguments.length;
switch (G__31136) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__31141 = arguments.length;
switch (G__31141) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_32613 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_32613) : fn1.call(null,val_32613));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_32613) : fn1.call(null,val_32613));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__31145 = arguments.length;
switch (G__31145) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___32622 = n;
var x_32623 = (0);
while(true){
if((x_32623 < n__4613__auto___32622)){
(a[x_32623] = x_32623);

var G__32626 = (x_32623 + (1));
x_32623 = G__32626;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31146 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31146 = (function (flag,meta31147){
this.flag = flag;
this.meta31147 = meta31147;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31146.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31148,meta31147__$1){
var self__ = this;
var _31148__$1 = this;
return (new cljs.core.async.t_cljs$core$async31146(self__.flag,meta31147__$1));
}));

(cljs.core.async.t_cljs$core$async31146.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31148){
var self__ = this;
var _31148__$1 = this;
return self__.meta31147;
}));

(cljs.core.async.t_cljs$core$async31146.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31146.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async31146.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async31146.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async31146.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta31147","meta31147",1868148959,null)], null);
}));

(cljs.core.async.t_cljs$core$async31146.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31146.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31146");

(cljs.core.async.t_cljs$core$async31146.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async31146");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31146.
 */
cljs.core.async.__GT_t_cljs$core$async31146 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async31146(flag__$1,meta31147){
return (new cljs.core.async.t_cljs$core$async31146(flag__$1,meta31147));
});

}

return (new cljs.core.async.t_cljs$core$async31146(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31149 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31149 = (function (flag,cb,meta31150){
this.flag = flag;
this.cb = cb;
this.meta31150 = meta31150;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31149.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31151,meta31150__$1){
var self__ = this;
var _31151__$1 = this;
return (new cljs.core.async.t_cljs$core$async31149(self__.flag,self__.cb,meta31150__$1));
}));

(cljs.core.async.t_cljs$core$async31149.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31151){
var self__ = this;
var _31151__$1 = this;
return self__.meta31150;
}));

(cljs.core.async.t_cljs$core$async31149.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31149.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async31149.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async31149.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async31149.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta31150","meta31150",1955243389,null)], null);
}));

(cljs.core.async.t_cljs$core$async31149.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31149.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31149");

(cljs.core.async.t_cljs$core$async31149.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async31149");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31149.
 */
cljs.core.async.__GT_t_cljs$core$async31149 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async31149(flag__$1,cb__$1,meta31150){
return (new cljs.core.async.t_cljs$core$async31149(flag__$1,cb__$1,meta31150));
});

}

return (new cljs.core.async.t_cljs$core$async31149(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31152_SHARP_){
var G__31154 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31152_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31154) : fret.call(null,G__31154));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31153_SHARP_){
var G__31155 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31153_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31155) : fret.call(null,G__31155));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__32635 = (i + (1));
i = G__32635;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___32636 = arguments.length;
var i__4737__auto___32638 = (0);
while(true){
if((i__4737__auto___32638 < len__4736__auto___32636)){
args__4742__auto__.push((arguments[i__4737__auto___32638]));

var G__32640 = (i__4737__auto___32638 + (1));
i__4737__auto___32638 = G__32640;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__31158){
var map__31159 = p__31158;
var map__31159__$1 = (((((!((map__31159 == null))))?(((((map__31159.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31159.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31159):map__31159);
var opts = map__31159__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq31156){
var G__31157 = cljs.core.first(seq31156);
var seq31156__$1 = cljs.core.next(seq31156);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__31157,seq31156__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__31162 = arguments.length;
switch (G__31162) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__31069__auto___32651 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31070__auto__ = (function (){var switch__31033__auto__ = (function (state_31186){
var state_val_31187 = (state_31186[(1)]);
if((state_val_31187 === (7))){
var inst_31182 = (state_31186[(2)]);
var state_31186__$1 = state_31186;
var statearr_31188_32653 = state_31186__$1;
(statearr_31188_32653[(2)] = inst_31182);

(statearr_31188_32653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31187 === (1))){
var state_31186__$1 = state_31186;
var statearr_31189_32654 = state_31186__$1;
(statearr_31189_32654[(2)] = null);

(statearr_31189_32654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31187 === (4))){
var inst_31165 = (state_31186[(7)]);
var inst_31165__$1 = (state_31186[(2)]);
var inst_31166 = (inst_31165__$1 == null);
var state_31186__$1 = (function (){var statearr_31190 = state_31186;
(statearr_31190[(7)] = inst_31165__$1);

return statearr_31190;
})();
if(cljs.core.truth_(inst_31166)){
var statearr_31191_32664 = state_31186__$1;
(statearr_31191_32664[(1)] = (5));

} else {
var statearr_31192_32665 = state_31186__$1;
(statearr_31192_32665[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31187 === (13))){
var state_31186__$1 = state_31186;
var statearr_31193_32668 = state_31186__$1;
(statearr_31193_32668[(2)] = null);

(statearr_31193_32668[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31187 === (6))){
var inst_31165 = (state_31186[(7)]);
var state_31186__$1 = state_31186;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31186__$1,(11),to,inst_31165);
} else {
if((state_val_31187 === (3))){
var inst_31184 = (state_31186[(2)]);
var state_31186__$1 = state_31186;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31186__$1,inst_31184);
} else {
if((state_val_31187 === (12))){
var state_31186__$1 = state_31186;
var statearr_31194_32671 = state_31186__$1;
(statearr_31194_32671[(2)] = null);

(statearr_31194_32671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31187 === (2))){
var state_31186__$1 = state_31186;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31186__$1,(4),from);
} else {
if((state_val_31187 === (11))){
var inst_31175 = (state_31186[(2)]);
var state_31186__$1 = state_31186;
if(cljs.core.truth_(inst_31175)){
var statearr_31195_32674 = state_31186__$1;
(statearr_31195_32674[(1)] = (12));

} else {
var statearr_31196_32676 = state_31186__$1;
(statearr_31196_32676[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31187 === (9))){
var state_31186__$1 = state_31186;
var statearr_31197_32680 = state_31186__$1;
(statearr_31197_32680[(2)] = null);

(statearr_31197_32680[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31187 === (5))){
var state_31186__$1 = state_31186;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31198_32683 = state_31186__$1;
(statearr_31198_32683[(1)] = (8));

} else {
var statearr_31199_32686 = state_31186__$1;
(statearr_31199_32686[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31187 === (14))){
var inst_31180 = (state_31186[(2)]);
var state_31186__$1 = state_31186;
var statearr_31200_32689 = state_31186__$1;
(statearr_31200_32689[(2)] = inst_31180);

(statearr_31200_32689[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31187 === (10))){
var inst_31172 = (state_31186[(2)]);
var state_31186__$1 = state_31186;
var statearr_31201_32696 = state_31186__$1;
(statearr_31201_32696[(2)] = inst_31172);

(statearr_31201_32696[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31187 === (8))){
var inst_31169 = cljs.core.async.close_BANG_(to);
var state_31186__$1 = state_31186;
var statearr_31202_32701 = state_31186__$1;
(statearr_31202_32701[(2)] = inst_31169);

(statearr_31202_32701[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__31034__auto__ = null;
var cljs$core$async$state_machine__31034__auto____0 = (function (){
var statearr_31203 = [null,null,null,null,null,null,null,null];
(statearr_31203[(0)] = cljs$core$async$state_machine__31034__auto__);

(statearr_31203[(1)] = (1));

return statearr_31203;
});
var cljs$core$async$state_machine__31034__auto____1 = (function (state_31186){
while(true){
var ret_value__31035__auto__ = (function (){try{while(true){
var result__31036__auto__ = switch__31033__auto__(state_31186);
if(cljs.core.keyword_identical_QMARK_(result__31036__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31036__auto__;
}
break;
}
}catch (e31204){var ex__31037__auto__ = e31204;
var statearr_31205_32712 = state_31186;
(statearr_31205_32712[(2)] = ex__31037__auto__);


if(cljs.core.seq((state_31186[(4)]))){
var statearr_31206_32714 = state_31186;
(statearr_31206_32714[(1)] = cljs.core.first((state_31186[(4)])));

} else {
throw ex__31037__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32721 = state_31186;
state_31186 = G__32721;
continue;
} else {
return ret_value__31035__auto__;
}
break;
}
});
cljs$core$async$state_machine__31034__auto__ = function(state_31186){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31034__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31034__auto____1.call(this,state_31186);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31034__auto____0;
cljs$core$async$state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31034__auto____1;
return cljs$core$async$state_machine__31034__auto__;
})()
})();
var state__31071__auto__ = (function (){var statearr_31207 = f__31070__auto__();
(statearr_31207[(6)] = c__31069__auto___32651);

return statearr_31207;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31071__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__31208){
var vec__31209 = p__31208;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31209,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31209,(1),null);
var job = vec__31209;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__31069__auto___32724 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31070__auto__ = (function (){var switch__31033__auto__ = (function (state_31216){
var state_val_31217 = (state_31216[(1)]);
if((state_val_31217 === (1))){
var state_31216__$1 = state_31216;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31216__$1,(2),res,v);
} else {
if((state_val_31217 === (2))){
var inst_31213 = (state_31216[(2)]);
var inst_31214 = cljs.core.async.close_BANG_(res);
var state_31216__$1 = (function (){var statearr_31218 = state_31216;
(statearr_31218[(7)] = inst_31213);

return statearr_31218;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31216__$1,inst_31214);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____0 = (function (){
var statearr_31219 = [null,null,null,null,null,null,null,null];
(statearr_31219[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__);

(statearr_31219[(1)] = (1));

return statearr_31219;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____1 = (function (state_31216){
while(true){
var ret_value__31035__auto__ = (function (){try{while(true){
var result__31036__auto__ = switch__31033__auto__(state_31216);
if(cljs.core.keyword_identical_QMARK_(result__31036__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31036__auto__;
}
break;
}
}catch (e31220){var ex__31037__auto__ = e31220;
var statearr_31221_32735 = state_31216;
(statearr_31221_32735[(2)] = ex__31037__auto__);


if(cljs.core.seq((state_31216[(4)]))){
var statearr_31222_32737 = state_31216;
(statearr_31222_32737[(1)] = cljs.core.first((state_31216[(4)])));

} else {
throw ex__31037__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32738 = state_31216;
state_31216 = G__32738;
continue;
} else {
return ret_value__31035__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__ = function(state_31216){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____1.call(this,state_31216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__;
})()
})();
var state__31071__auto__ = (function (){var statearr_31223 = f__31070__auto__();
(statearr_31223[(6)] = c__31069__auto___32724);

return statearr_31223;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31071__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__31224){
var vec__31225 = p__31224;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31225,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31225,(1),null);
var job = vec__31225;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___32753 = n;
var __32754 = (0);
while(true){
if((__32754 < n__4613__auto___32753)){
var G__31228_32758 = type;
var G__31228_32759__$1 = (((G__31228_32758 instanceof cljs.core.Keyword))?G__31228_32758.fqn:null);
switch (G__31228_32759__$1) {
case "compute":
var c__31069__auto___32761 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__32754,c__31069__auto___32761,G__31228_32758,G__31228_32759__$1,n__4613__auto___32753,jobs,results,process,async){
return (function (){
var f__31070__auto__ = (function (){var switch__31033__auto__ = ((function (__32754,c__31069__auto___32761,G__31228_32758,G__31228_32759__$1,n__4613__auto___32753,jobs,results,process,async){
return (function (state_31241){
var state_val_31242 = (state_31241[(1)]);
if((state_val_31242 === (1))){
var state_31241__$1 = state_31241;
var statearr_31243_32762 = state_31241__$1;
(statearr_31243_32762[(2)] = null);

(statearr_31243_32762[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (2))){
var state_31241__$1 = state_31241;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31241__$1,(4),jobs);
} else {
if((state_val_31242 === (3))){
var inst_31239 = (state_31241[(2)]);
var state_31241__$1 = state_31241;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31241__$1,inst_31239);
} else {
if((state_val_31242 === (4))){
var inst_31231 = (state_31241[(2)]);
var inst_31232 = process(inst_31231);
var state_31241__$1 = state_31241;
if(cljs.core.truth_(inst_31232)){
var statearr_31244_32771 = state_31241__$1;
(statearr_31244_32771[(1)] = (5));

} else {
var statearr_31245_32774 = state_31241__$1;
(statearr_31245_32774[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (5))){
var state_31241__$1 = state_31241;
var statearr_31246_32776 = state_31241__$1;
(statearr_31246_32776[(2)] = null);

(statearr_31246_32776[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (6))){
var state_31241__$1 = state_31241;
var statearr_31247_32778 = state_31241__$1;
(statearr_31247_32778[(2)] = null);

(statearr_31247_32778[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (7))){
var inst_31237 = (state_31241[(2)]);
var state_31241__$1 = state_31241;
var statearr_31248_32781 = state_31241__$1;
(statearr_31248_32781[(2)] = inst_31237);

(statearr_31248_32781[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__32754,c__31069__auto___32761,G__31228_32758,G__31228_32759__$1,n__4613__auto___32753,jobs,results,process,async))
;
return ((function (__32754,switch__31033__auto__,c__31069__auto___32761,G__31228_32758,G__31228_32759__$1,n__4613__auto___32753,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____0 = (function (){
var statearr_31249 = [null,null,null,null,null,null,null];
(statearr_31249[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__);

(statearr_31249[(1)] = (1));

return statearr_31249;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____1 = (function (state_31241){
while(true){
var ret_value__31035__auto__ = (function (){try{while(true){
var result__31036__auto__ = switch__31033__auto__(state_31241);
if(cljs.core.keyword_identical_QMARK_(result__31036__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31036__auto__;
}
break;
}
}catch (e31250){var ex__31037__auto__ = e31250;
var statearr_31251_32789 = state_31241;
(statearr_31251_32789[(2)] = ex__31037__auto__);


if(cljs.core.seq((state_31241[(4)]))){
var statearr_31252_32792 = state_31241;
(statearr_31252_32792[(1)] = cljs.core.first((state_31241[(4)])));

} else {
throw ex__31037__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32795 = state_31241;
state_31241 = G__32795;
continue;
} else {
return ret_value__31035__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__ = function(state_31241){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____1.call(this,state_31241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__;
})()
;})(__32754,switch__31033__auto__,c__31069__auto___32761,G__31228_32758,G__31228_32759__$1,n__4613__auto___32753,jobs,results,process,async))
})();
var state__31071__auto__ = (function (){var statearr_31253 = f__31070__auto__();
(statearr_31253[(6)] = c__31069__auto___32761);

return statearr_31253;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31071__auto__);
});})(__32754,c__31069__auto___32761,G__31228_32758,G__31228_32759__$1,n__4613__auto___32753,jobs,results,process,async))
);


break;
case "async":
var c__31069__auto___32803 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__32754,c__31069__auto___32803,G__31228_32758,G__31228_32759__$1,n__4613__auto___32753,jobs,results,process,async){
return (function (){
var f__31070__auto__ = (function (){var switch__31033__auto__ = ((function (__32754,c__31069__auto___32803,G__31228_32758,G__31228_32759__$1,n__4613__auto___32753,jobs,results,process,async){
return (function (state_31266){
var state_val_31267 = (state_31266[(1)]);
if((state_val_31267 === (1))){
var state_31266__$1 = state_31266;
var statearr_31268_32812 = state_31266__$1;
(statearr_31268_32812[(2)] = null);

(statearr_31268_32812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31267 === (2))){
var state_31266__$1 = state_31266;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31266__$1,(4),jobs);
} else {
if((state_val_31267 === (3))){
var inst_31264 = (state_31266[(2)]);
var state_31266__$1 = state_31266;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31266__$1,inst_31264);
} else {
if((state_val_31267 === (4))){
var inst_31256 = (state_31266[(2)]);
var inst_31257 = async(inst_31256);
var state_31266__$1 = state_31266;
if(cljs.core.truth_(inst_31257)){
var statearr_31269_32816 = state_31266__$1;
(statearr_31269_32816[(1)] = (5));

} else {
var statearr_31270_32817 = state_31266__$1;
(statearr_31270_32817[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31267 === (5))){
var state_31266__$1 = state_31266;
var statearr_31271_32820 = state_31266__$1;
(statearr_31271_32820[(2)] = null);

(statearr_31271_32820[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31267 === (6))){
var state_31266__$1 = state_31266;
var statearr_31272_32821 = state_31266__$1;
(statearr_31272_32821[(2)] = null);

(statearr_31272_32821[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31267 === (7))){
var inst_31262 = (state_31266[(2)]);
var state_31266__$1 = state_31266;
var statearr_31273_32824 = state_31266__$1;
(statearr_31273_32824[(2)] = inst_31262);

(statearr_31273_32824[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__32754,c__31069__auto___32803,G__31228_32758,G__31228_32759__$1,n__4613__auto___32753,jobs,results,process,async))
;
return ((function (__32754,switch__31033__auto__,c__31069__auto___32803,G__31228_32758,G__31228_32759__$1,n__4613__auto___32753,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____0 = (function (){
var statearr_31274 = [null,null,null,null,null,null,null];
(statearr_31274[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__);

(statearr_31274[(1)] = (1));

return statearr_31274;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____1 = (function (state_31266){
while(true){
var ret_value__31035__auto__ = (function (){try{while(true){
var result__31036__auto__ = switch__31033__auto__(state_31266);
if(cljs.core.keyword_identical_QMARK_(result__31036__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31036__auto__;
}
break;
}
}catch (e31275){var ex__31037__auto__ = e31275;
var statearr_31276_32829 = state_31266;
(statearr_31276_32829[(2)] = ex__31037__auto__);


if(cljs.core.seq((state_31266[(4)]))){
var statearr_31277_32832 = state_31266;
(statearr_31277_32832[(1)] = cljs.core.first((state_31266[(4)])));

} else {
throw ex__31037__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32833 = state_31266;
state_31266 = G__32833;
continue;
} else {
return ret_value__31035__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__ = function(state_31266){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____1.call(this,state_31266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__;
})()
;})(__32754,switch__31033__auto__,c__31069__auto___32803,G__31228_32758,G__31228_32759__$1,n__4613__auto___32753,jobs,results,process,async))
})();
var state__31071__auto__ = (function (){var statearr_31278 = f__31070__auto__();
(statearr_31278[(6)] = c__31069__auto___32803);

return statearr_31278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31071__auto__);
});})(__32754,c__31069__auto___32803,G__31228_32758,G__31228_32759__$1,n__4613__auto___32753,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31228_32759__$1)].join('')));

}

var G__32837 = (__32754 + (1));
__32754 = G__32837;
continue;
} else {
}
break;
}

var c__31069__auto___32838 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31070__auto__ = (function (){var switch__31033__auto__ = (function (state_31300){
var state_val_31301 = (state_31300[(1)]);
if((state_val_31301 === (7))){
var inst_31296 = (state_31300[(2)]);
var state_31300__$1 = state_31300;
var statearr_31302_32839 = state_31300__$1;
(statearr_31302_32839[(2)] = inst_31296);

(statearr_31302_32839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31301 === (1))){
var state_31300__$1 = state_31300;
var statearr_31303_32841 = state_31300__$1;
(statearr_31303_32841[(2)] = null);

(statearr_31303_32841[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31301 === (4))){
var inst_31281 = (state_31300[(7)]);
var inst_31281__$1 = (state_31300[(2)]);
var inst_31282 = (inst_31281__$1 == null);
var state_31300__$1 = (function (){var statearr_31304 = state_31300;
(statearr_31304[(7)] = inst_31281__$1);

return statearr_31304;
})();
if(cljs.core.truth_(inst_31282)){
var statearr_31305_32842 = state_31300__$1;
(statearr_31305_32842[(1)] = (5));

} else {
var statearr_31306_32843 = state_31300__$1;
(statearr_31306_32843[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31301 === (6))){
var inst_31281 = (state_31300[(7)]);
var inst_31286 = (state_31300[(8)]);
var inst_31286__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_31287 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31288 = [inst_31281,inst_31286__$1];
var inst_31289 = (new cljs.core.PersistentVector(null,2,(5),inst_31287,inst_31288,null));
var state_31300__$1 = (function (){var statearr_31307 = state_31300;
(statearr_31307[(8)] = inst_31286__$1);

return statearr_31307;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31300__$1,(8),jobs,inst_31289);
} else {
if((state_val_31301 === (3))){
var inst_31298 = (state_31300[(2)]);
var state_31300__$1 = state_31300;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31300__$1,inst_31298);
} else {
if((state_val_31301 === (2))){
var state_31300__$1 = state_31300;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31300__$1,(4),from);
} else {
if((state_val_31301 === (9))){
var inst_31293 = (state_31300[(2)]);
var state_31300__$1 = (function (){var statearr_31308 = state_31300;
(statearr_31308[(9)] = inst_31293);

return statearr_31308;
})();
var statearr_31309_32850 = state_31300__$1;
(statearr_31309_32850[(2)] = null);

(statearr_31309_32850[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31301 === (5))){
var inst_31284 = cljs.core.async.close_BANG_(jobs);
var state_31300__$1 = state_31300;
var statearr_31310_32851 = state_31300__$1;
(statearr_31310_32851[(2)] = inst_31284);

(statearr_31310_32851[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31301 === (8))){
var inst_31286 = (state_31300[(8)]);
var inst_31291 = (state_31300[(2)]);
var state_31300__$1 = (function (){var statearr_31311 = state_31300;
(statearr_31311[(10)] = inst_31291);

return statearr_31311;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31300__$1,(9),results,inst_31286);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____0 = (function (){
var statearr_31312 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31312[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__);

(statearr_31312[(1)] = (1));

return statearr_31312;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____1 = (function (state_31300){
while(true){
var ret_value__31035__auto__ = (function (){try{while(true){
var result__31036__auto__ = switch__31033__auto__(state_31300);
if(cljs.core.keyword_identical_QMARK_(result__31036__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31036__auto__;
}
break;
}
}catch (e31313){var ex__31037__auto__ = e31313;
var statearr_31314_32855 = state_31300;
(statearr_31314_32855[(2)] = ex__31037__auto__);


if(cljs.core.seq((state_31300[(4)]))){
var statearr_31315_32856 = state_31300;
(statearr_31315_32856[(1)] = cljs.core.first((state_31300[(4)])));

} else {
throw ex__31037__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32857 = state_31300;
state_31300 = G__32857;
continue;
} else {
return ret_value__31035__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__ = function(state_31300){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____1.call(this,state_31300);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__;
})()
})();
var state__31071__auto__ = (function (){var statearr_31316 = f__31070__auto__();
(statearr_31316[(6)] = c__31069__auto___32838);

return statearr_31316;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31071__auto__);
}));


var c__31069__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31070__auto__ = (function (){var switch__31033__auto__ = (function (state_31354){
var state_val_31355 = (state_31354[(1)]);
if((state_val_31355 === (7))){
var inst_31350 = (state_31354[(2)]);
var state_31354__$1 = state_31354;
var statearr_31356_32865 = state_31354__$1;
(statearr_31356_32865[(2)] = inst_31350);

(statearr_31356_32865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31355 === (20))){
var state_31354__$1 = state_31354;
var statearr_31357_32866 = state_31354__$1;
(statearr_31357_32866[(2)] = null);

(statearr_31357_32866[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31355 === (1))){
var state_31354__$1 = state_31354;
var statearr_31358_32867 = state_31354__$1;
(statearr_31358_32867[(2)] = null);

(statearr_31358_32867[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31355 === (4))){
var inst_31319 = (state_31354[(7)]);
var inst_31319__$1 = (state_31354[(2)]);
var inst_31320 = (inst_31319__$1 == null);
var state_31354__$1 = (function (){var statearr_31359 = state_31354;
(statearr_31359[(7)] = inst_31319__$1);

return statearr_31359;
})();
if(cljs.core.truth_(inst_31320)){
var statearr_31360_32869 = state_31354__$1;
(statearr_31360_32869[(1)] = (5));

} else {
var statearr_31361_32870 = state_31354__$1;
(statearr_31361_32870[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31355 === (15))){
var inst_31332 = (state_31354[(8)]);
var state_31354__$1 = state_31354;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31354__$1,(18),to,inst_31332);
} else {
if((state_val_31355 === (21))){
var inst_31345 = (state_31354[(2)]);
var state_31354__$1 = state_31354;
var statearr_31362_32881 = state_31354__$1;
(statearr_31362_32881[(2)] = inst_31345);

(statearr_31362_32881[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31355 === (13))){
var inst_31347 = (state_31354[(2)]);
var state_31354__$1 = (function (){var statearr_31363 = state_31354;
(statearr_31363[(9)] = inst_31347);

return statearr_31363;
})();
var statearr_31364_32882 = state_31354__$1;
(statearr_31364_32882[(2)] = null);

(statearr_31364_32882[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31355 === (6))){
var inst_31319 = (state_31354[(7)]);
var state_31354__$1 = state_31354;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31354__$1,(11),inst_31319);
} else {
if((state_val_31355 === (17))){
var inst_31340 = (state_31354[(2)]);
var state_31354__$1 = state_31354;
if(cljs.core.truth_(inst_31340)){
var statearr_31365_32883 = state_31354__$1;
(statearr_31365_32883[(1)] = (19));

} else {
var statearr_31366_32885 = state_31354__$1;
(statearr_31366_32885[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31355 === (3))){
var inst_31352 = (state_31354[(2)]);
var state_31354__$1 = state_31354;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31354__$1,inst_31352);
} else {
if((state_val_31355 === (12))){
var inst_31329 = (state_31354[(10)]);
var state_31354__$1 = state_31354;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31354__$1,(14),inst_31329);
} else {
if((state_val_31355 === (2))){
var state_31354__$1 = state_31354;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31354__$1,(4),results);
} else {
if((state_val_31355 === (19))){
var state_31354__$1 = state_31354;
var statearr_31367_32892 = state_31354__$1;
(statearr_31367_32892[(2)] = null);

(statearr_31367_32892[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31355 === (11))){
var inst_31329 = (state_31354[(2)]);
var state_31354__$1 = (function (){var statearr_31368 = state_31354;
(statearr_31368[(10)] = inst_31329);

return statearr_31368;
})();
var statearr_31369_32894 = state_31354__$1;
(statearr_31369_32894[(2)] = null);

(statearr_31369_32894[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31355 === (9))){
var state_31354__$1 = state_31354;
var statearr_31370_32895 = state_31354__$1;
(statearr_31370_32895[(2)] = null);

(statearr_31370_32895[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31355 === (5))){
var state_31354__$1 = state_31354;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31371_32896 = state_31354__$1;
(statearr_31371_32896[(1)] = (8));

} else {
var statearr_31372_32897 = state_31354__$1;
(statearr_31372_32897[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31355 === (14))){
var inst_31332 = (state_31354[(8)]);
var inst_31332__$1 = (state_31354[(2)]);
var inst_31333 = (inst_31332__$1 == null);
var inst_31334 = cljs.core.not(inst_31333);
var state_31354__$1 = (function (){var statearr_31373 = state_31354;
(statearr_31373[(8)] = inst_31332__$1);

return statearr_31373;
})();
if(inst_31334){
var statearr_31374_32902 = state_31354__$1;
(statearr_31374_32902[(1)] = (15));

} else {
var statearr_31375_32903 = state_31354__$1;
(statearr_31375_32903[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31355 === (16))){
var state_31354__$1 = state_31354;
var statearr_31376_32907 = state_31354__$1;
(statearr_31376_32907[(2)] = false);

(statearr_31376_32907[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31355 === (10))){
var inst_31326 = (state_31354[(2)]);
var state_31354__$1 = state_31354;
var statearr_31377_32908 = state_31354__$1;
(statearr_31377_32908[(2)] = inst_31326);

(statearr_31377_32908[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31355 === (18))){
var inst_31337 = (state_31354[(2)]);
var state_31354__$1 = state_31354;
var statearr_31378_32912 = state_31354__$1;
(statearr_31378_32912[(2)] = inst_31337);

(statearr_31378_32912[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31355 === (8))){
var inst_31323 = cljs.core.async.close_BANG_(to);
var state_31354__$1 = state_31354;
var statearr_31379_32913 = state_31354__$1;
(statearr_31379_32913[(2)] = inst_31323);

(statearr_31379_32913[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____0 = (function (){
var statearr_31380 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31380[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__);

(statearr_31380[(1)] = (1));

return statearr_31380;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____1 = (function (state_31354){
while(true){
var ret_value__31035__auto__ = (function (){try{while(true){
var result__31036__auto__ = switch__31033__auto__(state_31354);
if(cljs.core.keyword_identical_QMARK_(result__31036__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31036__auto__;
}
break;
}
}catch (e31381){var ex__31037__auto__ = e31381;
var statearr_31382_32914 = state_31354;
(statearr_31382_32914[(2)] = ex__31037__auto__);


if(cljs.core.seq((state_31354[(4)]))){
var statearr_31383_32917 = state_31354;
(statearr_31383_32917[(1)] = cljs.core.first((state_31354[(4)])));

} else {
throw ex__31037__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32918 = state_31354;
state_31354 = G__32918;
continue;
} else {
return ret_value__31035__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__ = function(state_31354){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____1.call(this,state_31354);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31034__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31034__auto__;
})()
})();
var state__31071__auto__ = (function (){var statearr_31384 = f__31070__auto__();
(statearr_31384[(6)] = c__31069__auto__);

return statearr_31384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31071__auto__);
}));

return c__31069__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__31386 = arguments.length;
switch (G__31386) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__31388 = arguments.length;
switch (G__31388) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__31390 = arguments.length;
switch (G__31390) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__31069__auto___32938 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31070__auto__ = (function (){var switch__31033__auto__ = (function (state_31416){
var state_val_31417 = (state_31416[(1)]);
if((state_val_31417 === (7))){
var inst_31412 = (state_31416[(2)]);
var state_31416__$1 = state_31416;
var statearr_31418_32941 = state_31416__$1;
(statearr_31418_32941[(2)] = inst_31412);

(statearr_31418_32941[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31417 === (1))){
var state_31416__$1 = state_31416;
var statearr_31419_32944 = state_31416__$1;
(statearr_31419_32944[(2)] = null);

(statearr_31419_32944[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31417 === (4))){
var inst_31393 = (state_31416[(7)]);
var inst_31393__$1 = (state_31416[(2)]);
var inst_31394 = (inst_31393__$1 == null);
var state_31416__$1 = (function (){var statearr_31420 = state_31416;
(statearr_31420[(7)] = inst_31393__$1);

return statearr_31420;
})();
if(cljs.core.truth_(inst_31394)){
var statearr_31421_32946 = state_31416__$1;
(statearr_31421_32946[(1)] = (5));

} else {
var statearr_31422_32947 = state_31416__$1;
(statearr_31422_32947[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31417 === (13))){
var state_31416__$1 = state_31416;
var statearr_31423_32948 = state_31416__$1;
(statearr_31423_32948[(2)] = null);

(statearr_31423_32948[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31417 === (6))){
var inst_31393 = (state_31416[(7)]);
var inst_31399 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_31393) : p.call(null,inst_31393));
var state_31416__$1 = state_31416;
if(cljs.core.truth_(inst_31399)){
var statearr_31424_32949 = state_31416__$1;
(statearr_31424_32949[(1)] = (9));

} else {
var statearr_31425_32950 = state_31416__$1;
(statearr_31425_32950[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31417 === (3))){
var inst_31414 = (state_31416[(2)]);
var state_31416__$1 = state_31416;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31416__$1,inst_31414);
} else {
if((state_val_31417 === (12))){
var state_31416__$1 = state_31416;
var statearr_31426_32951 = state_31416__$1;
(statearr_31426_32951[(2)] = null);

(statearr_31426_32951[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31417 === (2))){
var state_31416__$1 = state_31416;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31416__$1,(4),ch);
} else {
if((state_val_31417 === (11))){
var inst_31393 = (state_31416[(7)]);
var inst_31403 = (state_31416[(2)]);
var state_31416__$1 = state_31416;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31416__$1,(8),inst_31403,inst_31393);
} else {
if((state_val_31417 === (9))){
var state_31416__$1 = state_31416;
var statearr_31427_32957 = state_31416__$1;
(statearr_31427_32957[(2)] = tc);

(statearr_31427_32957[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31417 === (5))){
var inst_31396 = cljs.core.async.close_BANG_(tc);
var inst_31397 = cljs.core.async.close_BANG_(fc);
var state_31416__$1 = (function (){var statearr_31428 = state_31416;
(statearr_31428[(8)] = inst_31396);

return statearr_31428;
})();
var statearr_31429_32959 = state_31416__$1;
(statearr_31429_32959[(2)] = inst_31397);

(statearr_31429_32959[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31417 === (14))){
var inst_31410 = (state_31416[(2)]);
var state_31416__$1 = state_31416;
var statearr_31430_32964 = state_31416__$1;
(statearr_31430_32964[(2)] = inst_31410);

(statearr_31430_32964[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31417 === (10))){
var state_31416__$1 = state_31416;
var statearr_31431_32967 = state_31416__$1;
(statearr_31431_32967[(2)] = fc);

(statearr_31431_32967[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31417 === (8))){
var inst_31405 = (state_31416[(2)]);
var state_31416__$1 = state_31416;
if(cljs.core.truth_(inst_31405)){
var statearr_31432_32972 = state_31416__$1;
(statearr_31432_32972[(1)] = (12));

} else {
var statearr_31433_32973 = state_31416__$1;
(statearr_31433_32973[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__31034__auto__ = null;
var cljs$core$async$state_machine__31034__auto____0 = (function (){
var statearr_31434 = [null,null,null,null,null,null,null,null,null];
(statearr_31434[(0)] = cljs$core$async$state_machine__31034__auto__);

(statearr_31434[(1)] = (1));

return statearr_31434;
});
var cljs$core$async$state_machine__31034__auto____1 = (function (state_31416){
while(true){
var ret_value__31035__auto__ = (function (){try{while(true){
var result__31036__auto__ = switch__31033__auto__(state_31416);
if(cljs.core.keyword_identical_QMARK_(result__31036__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31036__auto__;
}
break;
}
}catch (e31435){var ex__31037__auto__ = e31435;
var statearr_31436_32980 = state_31416;
(statearr_31436_32980[(2)] = ex__31037__auto__);


if(cljs.core.seq((state_31416[(4)]))){
var statearr_31437_32981 = state_31416;
(statearr_31437_32981[(1)] = cljs.core.first((state_31416[(4)])));

} else {
throw ex__31037__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32986 = state_31416;
state_31416 = G__32986;
continue;
} else {
return ret_value__31035__auto__;
}
break;
}
});
cljs$core$async$state_machine__31034__auto__ = function(state_31416){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31034__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31034__auto____1.call(this,state_31416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31034__auto____0;
cljs$core$async$state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31034__auto____1;
return cljs$core$async$state_machine__31034__auto__;
})()
})();
var state__31071__auto__ = (function (){var statearr_31438 = f__31070__auto__();
(statearr_31438[(6)] = c__31069__auto___32938);

return statearr_31438;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31071__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__31069__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31070__auto__ = (function (){var switch__31033__auto__ = (function (state_31460){
var state_val_31461 = (state_31460[(1)]);
if((state_val_31461 === (7))){
var inst_31456 = (state_31460[(2)]);
var state_31460__$1 = state_31460;
var statearr_31462_32991 = state_31460__$1;
(statearr_31462_32991[(2)] = inst_31456);

(statearr_31462_32991[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31461 === (1))){
var inst_31439 = init;
var inst_31440 = inst_31439;
var state_31460__$1 = (function (){var statearr_31463 = state_31460;
(statearr_31463[(7)] = inst_31440);

return statearr_31463;
})();
var statearr_31464_32994 = state_31460__$1;
(statearr_31464_32994[(2)] = null);

(statearr_31464_32994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31461 === (4))){
var inst_31443 = (state_31460[(8)]);
var inst_31443__$1 = (state_31460[(2)]);
var inst_31444 = (inst_31443__$1 == null);
var state_31460__$1 = (function (){var statearr_31465 = state_31460;
(statearr_31465[(8)] = inst_31443__$1);

return statearr_31465;
})();
if(cljs.core.truth_(inst_31444)){
var statearr_31466_33001 = state_31460__$1;
(statearr_31466_33001[(1)] = (5));

} else {
var statearr_31467_33002 = state_31460__$1;
(statearr_31467_33002[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31461 === (6))){
var inst_31440 = (state_31460[(7)]);
var inst_31447 = (state_31460[(9)]);
var inst_31443 = (state_31460[(8)]);
var inst_31447__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_31440,inst_31443) : f.call(null,inst_31440,inst_31443));
var inst_31448 = cljs.core.reduced_QMARK_(inst_31447__$1);
var state_31460__$1 = (function (){var statearr_31468 = state_31460;
(statearr_31468[(9)] = inst_31447__$1);

return statearr_31468;
})();
if(inst_31448){
var statearr_31469_33007 = state_31460__$1;
(statearr_31469_33007[(1)] = (8));

} else {
var statearr_31470_33009 = state_31460__$1;
(statearr_31470_33009[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31461 === (3))){
var inst_31458 = (state_31460[(2)]);
var state_31460__$1 = state_31460;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31460__$1,inst_31458);
} else {
if((state_val_31461 === (2))){
var state_31460__$1 = state_31460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31460__$1,(4),ch);
} else {
if((state_val_31461 === (9))){
var inst_31447 = (state_31460[(9)]);
var inst_31440 = inst_31447;
var state_31460__$1 = (function (){var statearr_31471 = state_31460;
(statearr_31471[(7)] = inst_31440);

return statearr_31471;
})();
var statearr_31472_33015 = state_31460__$1;
(statearr_31472_33015[(2)] = null);

(statearr_31472_33015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31461 === (5))){
var inst_31440 = (state_31460[(7)]);
var state_31460__$1 = state_31460;
var statearr_31473_33016 = state_31460__$1;
(statearr_31473_33016[(2)] = inst_31440);

(statearr_31473_33016[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31461 === (10))){
var inst_31454 = (state_31460[(2)]);
var state_31460__$1 = state_31460;
var statearr_31474_33019 = state_31460__$1;
(statearr_31474_33019[(2)] = inst_31454);

(statearr_31474_33019[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31461 === (8))){
var inst_31447 = (state_31460[(9)]);
var inst_31450 = cljs.core.deref(inst_31447);
var state_31460__$1 = state_31460;
var statearr_31475_33021 = state_31460__$1;
(statearr_31475_33021[(2)] = inst_31450);

(statearr_31475_33021[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__31034__auto__ = null;
var cljs$core$async$reduce_$_state_machine__31034__auto____0 = (function (){
var statearr_31476 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31476[(0)] = cljs$core$async$reduce_$_state_machine__31034__auto__);

(statearr_31476[(1)] = (1));

return statearr_31476;
});
var cljs$core$async$reduce_$_state_machine__31034__auto____1 = (function (state_31460){
while(true){
var ret_value__31035__auto__ = (function (){try{while(true){
var result__31036__auto__ = switch__31033__auto__(state_31460);
if(cljs.core.keyword_identical_QMARK_(result__31036__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31036__auto__;
}
break;
}
}catch (e31477){var ex__31037__auto__ = e31477;
var statearr_31478_33028 = state_31460;
(statearr_31478_33028[(2)] = ex__31037__auto__);


if(cljs.core.seq((state_31460[(4)]))){
var statearr_31479_33029 = state_31460;
(statearr_31479_33029[(1)] = cljs.core.first((state_31460[(4)])));

} else {
throw ex__31037__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33032 = state_31460;
state_31460 = G__33032;
continue;
} else {
return ret_value__31035__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__31034__auto__ = function(state_31460){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__31034__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__31034__auto____1.call(this,state_31460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__31034__auto____0;
cljs$core$async$reduce_$_state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__31034__auto____1;
return cljs$core$async$reduce_$_state_machine__31034__auto__;
})()
})();
var state__31071__auto__ = (function (){var statearr_31480 = f__31070__auto__();
(statearr_31480[(6)] = c__31069__auto__);

return statearr_31480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31071__auto__);
}));

return c__31069__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__31069__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31070__auto__ = (function (){var switch__31033__auto__ = (function (state_31486){
var state_val_31487 = (state_31486[(1)]);
if((state_val_31487 === (1))){
var inst_31481 = cljs.core.async.reduce(f__$1,init,ch);
var state_31486__$1 = state_31486;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31486__$1,(2),inst_31481);
} else {
if((state_val_31487 === (2))){
var inst_31483 = (state_31486[(2)]);
var inst_31484 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_31483) : f__$1.call(null,inst_31483));
var state_31486__$1 = state_31486;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31486__$1,inst_31484);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__31034__auto__ = null;
var cljs$core$async$transduce_$_state_machine__31034__auto____0 = (function (){
var statearr_31488 = [null,null,null,null,null,null,null];
(statearr_31488[(0)] = cljs$core$async$transduce_$_state_machine__31034__auto__);

(statearr_31488[(1)] = (1));

return statearr_31488;
});
var cljs$core$async$transduce_$_state_machine__31034__auto____1 = (function (state_31486){
while(true){
var ret_value__31035__auto__ = (function (){try{while(true){
var result__31036__auto__ = switch__31033__auto__(state_31486);
if(cljs.core.keyword_identical_QMARK_(result__31036__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31036__auto__;
}
break;
}
}catch (e31489){var ex__31037__auto__ = e31489;
var statearr_31490_33049 = state_31486;
(statearr_31490_33049[(2)] = ex__31037__auto__);


if(cljs.core.seq((state_31486[(4)]))){
var statearr_31491_33050 = state_31486;
(statearr_31491_33050[(1)] = cljs.core.first((state_31486[(4)])));

} else {
throw ex__31037__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33054 = state_31486;
state_31486 = G__33054;
continue;
} else {
return ret_value__31035__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__31034__auto__ = function(state_31486){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__31034__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__31034__auto____1.call(this,state_31486);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__31034__auto____0;
cljs$core$async$transduce_$_state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__31034__auto____1;
return cljs$core$async$transduce_$_state_machine__31034__auto__;
})()
})();
var state__31071__auto__ = (function (){var statearr_31492 = f__31070__auto__();
(statearr_31492[(6)] = c__31069__auto__);

return statearr_31492;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31071__auto__);
}));

return c__31069__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__31494 = arguments.length;
switch (G__31494) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__31069__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31070__auto__ = (function (){var switch__31033__auto__ = (function (state_31519){
var state_val_31520 = (state_31519[(1)]);
if((state_val_31520 === (7))){
var inst_31501 = (state_31519[(2)]);
var state_31519__$1 = state_31519;
var statearr_31521_33070 = state_31519__$1;
(statearr_31521_33070[(2)] = inst_31501);

(statearr_31521_33070[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31520 === (1))){
var inst_31495 = cljs.core.seq(coll);
var inst_31496 = inst_31495;
var state_31519__$1 = (function (){var statearr_31522 = state_31519;
(statearr_31522[(7)] = inst_31496);

return statearr_31522;
})();
var statearr_31523_33074 = state_31519__$1;
(statearr_31523_33074[(2)] = null);

(statearr_31523_33074[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31520 === (4))){
var inst_31496 = (state_31519[(7)]);
var inst_31499 = cljs.core.first(inst_31496);
var state_31519__$1 = state_31519;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31519__$1,(7),ch,inst_31499);
} else {
if((state_val_31520 === (13))){
var inst_31513 = (state_31519[(2)]);
var state_31519__$1 = state_31519;
var statearr_31524_33082 = state_31519__$1;
(statearr_31524_33082[(2)] = inst_31513);

(statearr_31524_33082[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31520 === (6))){
var inst_31504 = (state_31519[(2)]);
var state_31519__$1 = state_31519;
if(cljs.core.truth_(inst_31504)){
var statearr_31525_33083 = state_31519__$1;
(statearr_31525_33083[(1)] = (8));

} else {
var statearr_31526_33084 = state_31519__$1;
(statearr_31526_33084[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31520 === (3))){
var inst_31517 = (state_31519[(2)]);
var state_31519__$1 = state_31519;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31519__$1,inst_31517);
} else {
if((state_val_31520 === (12))){
var state_31519__$1 = state_31519;
var statearr_31527_33092 = state_31519__$1;
(statearr_31527_33092[(2)] = null);

(statearr_31527_33092[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31520 === (2))){
var inst_31496 = (state_31519[(7)]);
var state_31519__$1 = state_31519;
if(cljs.core.truth_(inst_31496)){
var statearr_31528_33097 = state_31519__$1;
(statearr_31528_33097[(1)] = (4));

} else {
var statearr_31529_33099 = state_31519__$1;
(statearr_31529_33099[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31520 === (11))){
var inst_31510 = cljs.core.async.close_BANG_(ch);
var state_31519__$1 = state_31519;
var statearr_31530_33100 = state_31519__$1;
(statearr_31530_33100[(2)] = inst_31510);

(statearr_31530_33100[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31520 === (9))){
var state_31519__$1 = state_31519;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31531_33101 = state_31519__$1;
(statearr_31531_33101[(1)] = (11));

} else {
var statearr_31532_33103 = state_31519__$1;
(statearr_31532_33103[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31520 === (5))){
var inst_31496 = (state_31519[(7)]);
var state_31519__$1 = state_31519;
var statearr_31533_33108 = state_31519__$1;
(statearr_31533_33108[(2)] = inst_31496);

(statearr_31533_33108[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31520 === (10))){
var inst_31515 = (state_31519[(2)]);
var state_31519__$1 = state_31519;
var statearr_31534_33146 = state_31519__$1;
(statearr_31534_33146[(2)] = inst_31515);

(statearr_31534_33146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31520 === (8))){
var inst_31496 = (state_31519[(7)]);
var inst_31506 = cljs.core.next(inst_31496);
var inst_31496__$1 = inst_31506;
var state_31519__$1 = (function (){var statearr_31535 = state_31519;
(statearr_31535[(7)] = inst_31496__$1);

return statearr_31535;
})();
var statearr_31536_33147 = state_31519__$1;
(statearr_31536_33147[(2)] = null);

(statearr_31536_33147[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__31034__auto__ = null;
var cljs$core$async$state_machine__31034__auto____0 = (function (){
var statearr_31537 = [null,null,null,null,null,null,null,null];
(statearr_31537[(0)] = cljs$core$async$state_machine__31034__auto__);

(statearr_31537[(1)] = (1));

return statearr_31537;
});
var cljs$core$async$state_machine__31034__auto____1 = (function (state_31519){
while(true){
var ret_value__31035__auto__ = (function (){try{while(true){
var result__31036__auto__ = switch__31033__auto__(state_31519);
if(cljs.core.keyword_identical_QMARK_(result__31036__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31036__auto__;
}
break;
}
}catch (e31538){var ex__31037__auto__ = e31538;
var statearr_31539_33148 = state_31519;
(statearr_31539_33148[(2)] = ex__31037__auto__);


if(cljs.core.seq((state_31519[(4)]))){
var statearr_31540_33149 = state_31519;
(statearr_31540_33149[(1)] = cljs.core.first((state_31519[(4)])));

} else {
throw ex__31037__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33150 = state_31519;
state_31519 = G__33150;
continue;
} else {
return ret_value__31035__auto__;
}
break;
}
});
cljs$core$async$state_machine__31034__auto__ = function(state_31519){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31034__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31034__auto____1.call(this,state_31519);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31034__auto____0;
cljs$core$async$state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31034__auto____1;
return cljs$core$async$state_machine__31034__auto__;
})()
})();
var state__31071__auto__ = (function (){var statearr_31541 = f__31070__auto__();
(statearr_31541[(6)] = c__31069__auto__);

return statearr_31541;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31071__auto__);
}));

return c__31069__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__31543 = arguments.length;
switch (G__31543) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_33152 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_33152(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_33153 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_33153(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_33154 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_33154(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_33155 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_33155(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31544 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31544 = (function (ch,cs,meta31545){
this.ch = ch;
this.cs = cs;
this.meta31545 = meta31545;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31544.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31546,meta31545__$1){
var self__ = this;
var _31546__$1 = this;
return (new cljs.core.async.t_cljs$core$async31544(self__.ch,self__.cs,meta31545__$1));
}));

(cljs.core.async.t_cljs$core$async31544.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31546){
var self__ = this;
var _31546__$1 = this;
return self__.meta31545;
}));

(cljs.core.async.t_cljs$core$async31544.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31544.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async31544.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31544.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async31544.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async31544.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async31544.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta31545","meta31545",547790322,null)], null);
}));

(cljs.core.async.t_cljs$core$async31544.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31544.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31544");

(cljs.core.async.t_cljs$core$async31544.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async31544");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31544.
 */
cljs.core.async.__GT_t_cljs$core$async31544 = (function cljs$core$async$mult_$___GT_t_cljs$core$async31544(ch__$1,cs__$1,meta31545){
return (new cljs.core.async.t_cljs$core$async31544(ch__$1,cs__$1,meta31545));
});

}

return (new cljs.core.async.t_cljs$core$async31544(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__31069__auto___33156 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31070__auto__ = (function (){var switch__31033__auto__ = (function (state_31679){
var state_val_31680 = (state_31679[(1)]);
if((state_val_31680 === (7))){
var inst_31675 = (state_31679[(2)]);
var state_31679__$1 = state_31679;
var statearr_31681_33157 = state_31679__$1;
(statearr_31681_33157[(2)] = inst_31675);

(statearr_31681_33157[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (20))){
var inst_31580 = (state_31679[(7)]);
var inst_31592 = cljs.core.first(inst_31580);
var inst_31593 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31592,(0),null);
var inst_31594 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31592,(1),null);
var state_31679__$1 = (function (){var statearr_31682 = state_31679;
(statearr_31682[(8)] = inst_31593);

return statearr_31682;
})();
if(cljs.core.truth_(inst_31594)){
var statearr_31683_33194 = state_31679__$1;
(statearr_31683_33194[(1)] = (22));

} else {
var statearr_31684_33231 = state_31679__$1;
(statearr_31684_33231[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (27))){
var inst_31622 = (state_31679[(9)]);
var inst_31549 = (state_31679[(10)]);
var inst_31624 = (state_31679[(11)]);
var inst_31629 = (state_31679[(12)]);
var inst_31629__$1 = cljs.core._nth(inst_31622,inst_31624);
var inst_31630 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_31629__$1,inst_31549,done);
var state_31679__$1 = (function (){var statearr_31685 = state_31679;
(statearr_31685[(12)] = inst_31629__$1);

return statearr_31685;
})();
if(cljs.core.truth_(inst_31630)){
var statearr_31686_33236 = state_31679__$1;
(statearr_31686_33236[(1)] = (30));

} else {
var statearr_31687_33237 = state_31679__$1;
(statearr_31687_33237[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (1))){
var state_31679__$1 = state_31679;
var statearr_31688_33238 = state_31679__$1;
(statearr_31688_33238[(2)] = null);

(statearr_31688_33238[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (24))){
var inst_31580 = (state_31679[(7)]);
var inst_31599 = (state_31679[(2)]);
var inst_31600 = cljs.core.next(inst_31580);
var inst_31558 = inst_31600;
var inst_31559 = null;
var inst_31560 = (0);
var inst_31561 = (0);
var state_31679__$1 = (function (){var statearr_31689 = state_31679;
(statearr_31689[(13)] = inst_31561);

(statearr_31689[(14)] = inst_31599);

(statearr_31689[(15)] = inst_31558);

(statearr_31689[(16)] = inst_31559);

(statearr_31689[(17)] = inst_31560);

return statearr_31689;
})();
var statearr_31690_33240 = state_31679__$1;
(statearr_31690_33240[(2)] = null);

(statearr_31690_33240[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (39))){
var state_31679__$1 = state_31679;
var statearr_31694_33241 = state_31679__$1;
(statearr_31694_33241[(2)] = null);

(statearr_31694_33241[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (4))){
var inst_31549 = (state_31679[(10)]);
var inst_31549__$1 = (state_31679[(2)]);
var inst_31550 = (inst_31549__$1 == null);
var state_31679__$1 = (function (){var statearr_31695 = state_31679;
(statearr_31695[(10)] = inst_31549__$1);

return statearr_31695;
})();
if(cljs.core.truth_(inst_31550)){
var statearr_31696_33242 = state_31679__$1;
(statearr_31696_33242[(1)] = (5));

} else {
var statearr_31697_33243 = state_31679__$1;
(statearr_31697_33243[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (15))){
var inst_31561 = (state_31679[(13)]);
var inst_31558 = (state_31679[(15)]);
var inst_31559 = (state_31679[(16)]);
var inst_31560 = (state_31679[(17)]);
var inst_31576 = (state_31679[(2)]);
var inst_31577 = (inst_31561 + (1));
var tmp31691 = inst_31558;
var tmp31692 = inst_31559;
var tmp31693 = inst_31560;
var inst_31558__$1 = tmp31691;
var inst_31559__$1 = tmp31692;
var inst_31560__$1 = tmp31693;
var inst_31561__$1 = inst_31577;
var state_31679__$1 = (function (){var statearr_31698 = state_31679;
(statearr_31698[(18)] = inst_31576);

(statearr_31698[(13)] = inst_31561__$1);

(statearr_31698[(15)] = inst_31558__$1);

(statearr_31698[(16)] = inst_31559__$1);

(statearr_31698[(17)] = inst_31560__$1);

return statearr_31698;
})();
var statearr_31699_33244 = state_31679__$1;
(statearr_31699_33244[(2)] = null);

(statearr_31699_33244[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (21))){
var inst_31603 = (state_31679[(2)]);
var state_31679__$1 = state_31679;
var statearr_31703_33245 = state_31679__$1;
(statearr_31703_33245[(2)] = inst_31603);

(statearr_31703_33245[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (31))){
var inst_31629 = (state_31679[(12)]);
var inst_31633 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_31629);
var state_31679__$1 = state_31679;
var statearr_31704_33246 = state_31679__$1;
(statearr_31704_33246[(2)] = inst_31633);

(statearr_31704_33246[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (32))){
var inst_31621 = (state_31679[(19)]);
var inst_31623 = (state_31679[(20)]);
var inst_31622 = (state_31679[(9)]);
var inst_31624 = (state_31679[(11)]);
var inst_31635 = (state_31679[(2)]);
var inst_31636 = (inst_31624 + (1));
var tmp31700 = inst_31621;
var tmp31701 = inst_31623;
var tmp31702 = inst_31622;
var inst_31621__$1 = tmp31700;
var inst_31622__$1 = tmp31702;
var inst_31623__$1 = tmp31701;
var inst_31624__$1 = inst_31636;
var state_31679__$1 = (function (){var statearr_31705 = state_31679;
(statearr_31705[(19)] = inst_31621__$1);

(statearr_31705[(20)] = inst_31623__$1);

(statearr_31705[(9)] = inst_31622__$1);

(statearr_31705[(21)] = inst_31635);

(statearr_31705[(11)] = inst_31624__$1);

return statearr_31705;
})();
var statearr_31706_33247 = state_31679__$1;
(statearr_31706_33247[(2)] = null);

(statearr_31706_33247[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (40))){
var inst_31648 = (state_31679[(22)]);
var inst_31652 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_31648);
var state_31679__$1 = state_31679;
var statearr_31707_33248 = state_31679__$1;
(statearr_31707_33248[(2)] = inst_31652);

(statearr_31707_33248[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (33))){
var inst_31639 = (state_31679[(23)]);
var inst_31641 = cljs.core.chunked_seq_QMARK_(inst_31639);
var state_31679__$1 = state_31679;
if(inst_31641){
var statearr_31708_33249 = state_31679__$1;
(statearr_31708_33249[(1)] = (36));

} else {
var statearr_31709_33250 = state_31679__$1;
(statearr_31709_33250[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (13))){
var inst_31570 = (state_31679[(24)]);
var inst_31573 = cljs.core.async.close_BANG_(inst_31570);
var state_31679__$1 = state_31679;
var statearr_31710_33251 = state_31679__$1;
(statearr_31710_33251[(2)] = inst_31573);

(statearr_31710_33251[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (22))){
var inst_31593 = (state_31679[(8)]);
var inst_31596 = cljs.core.async.close_BANG_(inst_31593);
var state_31679__$1 = state_31679;
var statearr_31711_33252 = state_31679__$1;
(statearr_31711_33252[(2)] = inst_31596);

(statearr_31711_33252[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (36))){
var inst_31639 = (state_31679[(23)]);
var inst_31643 = cljs.core.chunk_first(inst_31639);
var inst_31644 = cljs.core.chunk_rest(inst_31639);
var inst_31645 = cljs.core.count(inst_31643);
var inst_31621 = inst_31644;
var inst_31622 = inst_31643;
var inst_31623 = inst_31645;
var inst_31624 = (0);
var state_31679__$1 = (function (){var statearr_31712 = state_31679;
(statearr_31712[(19)] = inst_31621);

(statearr_31712[(20)] = inst_31623);

(statearr_31712[(9)] = inst_31622);

(statearr_31712[(11)] = inst_31624);

return statearr_31712;
})();
var statearr_31713_33256 = state_31679__$1;
(statearr_31713_33256[(2)] = null);

(statearr_31713_33256[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (41))){
var inst_31639 = (state_31679[(23)]);
var inst_31654 = (state_31679[(2)]);
var inst_31655 = cljs.core.next(inst_31639);
var inst_31621 = inst_31655;
var inst_31622 = null;
var inst_31623 = (0);
var inst_31624 = (0);
var state_31679__$1 = (function (){var statearr_31714 = state_31679;
(statearr_31714[(19)] = inst_31621);

(statearr_31714[(20)] = inst_31623);

(statearr_31714[(9)] = inst_31622);

(statearr_31714[(25)] = inst_31654);

(statearr_31714[(11)] = inst_31624);

return statearr_31714;
})();
var statearr_31715_33283 = state_31679__$1;
(statearr_31715_33283[(2)] = null);

(statearr_31715_33283[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (43))){
var state_31679__$1 = state_31679;
var statearr_31716_33292 = state_31679__$1;
(statearr_31716_33292[(2)] = null);

(statearr_31716_33292[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (29))){
var inst_31663 = (state_31679[(2)]);
var state_31679__$1 = state_31679;
var statearr_31717_33304 = state_31679__$1;
(statearr_31717_33304[(2)] = inst_31663);

(statearr_31717_33304[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (44))){
var inst_31672 = (state_31679[(2)]);
var state_31679__$1 = (function (){var statearr_31718 = state_31679;
(statearr_31718[(26)] = inst_31672);

return statearr_31718;
})();
var statearr_31719_33320 = state_31679__$1;
(statearr_31719_33320[(2)] = null);

(statearr_31719_33320[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (6))){
var inst_31613 = (state_31679[(27)]);
var inst_31612 = cljs.core.deref(cs);
var inst_31613__$1 = cljs.core.keys(inst_31612);
var inst_31614 = cljs.core.count(inst_31613__$1);
var inst_31615 = cljs.core.reset_BANG_(dctr,inst_31614);
var inst_31620 = cljs.core.seq(inst_31613__$1);
var inst_31621 = inst_31620;
var inst_31622 = null;
var inst_31623 = (0);
var inst_31624 = (0);
var state_31679__$1 = (function (){var statearr_31720 = state_31679;
(statearr_31720[(19)] = inst_31621);

(statearr_31720[(20)] = inst_31623);

(statearr_31720[(9)] = inst_31622);

(statearr_31720[(11)] = inst_31624);

(statearr_31720[(28)] = inst_31615);

(statearr_31720[(27)] = inst_31613__$1);

return statearr_31720;
})();
var statearr_31721_33335 = state_31679__$1;
(statearr_31721_33335[(2)] = null);

(statearr_31721_33335[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (28))){
var inst_31621 = (state_31679[(19)]);
var inst_31639 = (state_31679[(23)]);
var inst_31639__$1 = cljs.core.seq(inst_31621);
var state_31679__$1 = (function (){var statearr_31722 = state_31679;
(statearr_31722[(23)] = inst_31639__$1);

return statearr_31722;
})();
if(inst_31639__$1){
var statearr_31723_33336 = state_31679__$1;
(statearr_31723_33336[(1)] = (33));

} else {
var statearr_31724_33337 = state_31679__$1;
(statearr_31724_33337[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (25))){
var inst_31623 = (state_31679[(20)]);
var inst_31624 = (state_31679[(11)]);
var inst_31626 = (inst_31624 < inst_31623);
var inst_31627 = inst_31626;
var state_31679__$1 = state_31679;
if(cljs.core.truth_(inst_31627)){
var statearr_31725_33338 = state_31679__$1;
(statearr_31725_33338[(1)] = (27));

} else {
var statearr_31726_33339 = state_31679__$1;
(statearr_31726_33339[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (34))){
var state_31679__$1 = state_31679;
var statearr_31727_33340 = state_31679__$1;
(statearr_31727_33340[(2)] = null);

(statearr_31727_33340[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (17))){
var state_31679__$1 = state_31679;
var statearr_31728_33341 = state_31679__$1;
(statearr_31728_33341[(2)] = null);

(statearr_31728_33341[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (3))){
var inst_31677 = (state_31679[(2)]);
var state_31679__$1 = state_31679;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31679__$1,inst_31677);
} else {
if((state_val_31680 === (12))){
var inst_31608 = (state_31679[(2)]);
var state_31679__$1 = state_31679;
var statearr_31729_33342 = state_31679__$1;
(statearr_31729_33342[(2)] = inst_31608);

(statearr_31729_33342[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (2))){
var state_31679__$1 = state_31679;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31679__$1,(4),ch);
} else {
if((state_val_31680 === (23))){
var state_31679__$1 = state_31679;
var statearr_31730_33343 = state_31679__$1;
(statearr_31730_33343[(2)] = null);

(statearr_31730_33343[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (35))){
var inst_31661 = (state_31679[(2)]);
var state_31679__$1 = state_31679;
var statearr_31731_33344 = state_31679__$1;
(statearr_31731_33344[(2)] = inst_31661);

(statearr_31731_33344[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (19))){
var inst_31580 = (state_31679[(7)]);
var inst_31584 = cljs.core.chunk_first(inst_31580);
var inst_31585 = cljs.core.chunk_rest(inst_31580);
var inst_31586 = cljs.core.count(inst_31584);
var inst_31558 = inst_31585;
var inst_31559 = inst_31584;
var inst_31560 = inst_31586;
var inst_31561 = (0);
var state_31679__$1 = (function (){var statearr_31732 = state_31679;
(statearr_31732[(13)] = inst_31561);

(statearr_31732[(15)] = inst_31558);

(statearr_31732[(16)] = inst_31559);

(statearr_31732[(17)] = inst_31560);

return statearr_31732;
})();
var statearr_31733_33345 = state_31679__$1;
(statearr_31733_33345[(2)] = null);

(statearr_31733_33345[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (11))){
var inst_31580 = (state_31679[(7)]);
var inst_31558 = (state_31679[(15)]);
var inst_31580__$1 = cljs.core.seq(inst_31558);
var state_31679__$1 = (function (){var statearr_31734 = state_31679;
(statearr_31734[(7)] = inst_31580__$1);

return statearr_31734;
})();
if(inst_31580__$1){
var statearr_31735_33346 = state_31679__$1;
(statearr_31735_33346[(1)] = (16));

} else {
var statearr_31736_33347 = state_31679__$1;
(statearr_31736_33347[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (9))){
var inst_31610 = (state_31679[(2)]);
var state_31679__$1 = state_31679;
var statearr_31737_33348 = state_31679__$1;
(statearr_31737_33348[(2)] = inst_31610);

(statearr_31737_33348[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (5))){
var inst_31556 = cljs.core.deref(cs);
var inst_31557 = cljs.core.seq(inst_31556);
var inst_31558 = inst_31557;
var inst_31559 = null;
var inst_31560 = (0);
var inst_31561 = (0);
var state_31679__$1 = (function (){var statearr_31738 = state_31679;
(statearr_31738[(13)] = inst_31561);

(statearr_31738[(15)] = inst_31558);

(statearr_31738[(16)] = inst_31559);

(statearr_31738[(17)] = inst_31560);

return statearr_31738;
})();
var statearr_31739_33349 = state_31679__$1;
(statearr_31739_33349[(2)] = null);

(statearr_31739_33349[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (14))){
var state_31679__$1 = state_31679;
var statearr_31740_33350 = state_31679__$1;
(statearr_31740_33350[(2)] = null);

(statearr_31740_33350[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (45))){
var inst_31669 = (state_31679[(2)]);
var state_31679__$1 = state_31679;
var statearr_31741_33351 = state_31679__$1;
(statearr_31741_33351[(2)] = inst_31669);

(statearr_31741_33351[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (26))){
var inst_31613 = (state_31679[(27)]);
var inst_31665 = (state_31679[(2)]);
var inst_31666 = cljs.core.seq(inst_31613);
var state_31679__$1 = (function (){var statearr_31742 = state_31679;
(statearr_31742[(29)] = inst_31665);

return statearr_31742;
})();
if(inst_31666){
var statearr_31743_33352 = state_31679__$1;
(statearr_31743_33352[(1)] = (42));

} else {
var statearr_31744_33353 = state_31679__$1;
(statearr_31744_33353[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (16))){
var inst_31580 = (state_31679[(7)]);
var inst_31582 = cljs.core.chunked_seq_QMARK_(inst_31580);
var state_31679__$1 = state_31679;
if(inst_31582){
var statearr_31745_33354 = state_31679__$1;
(statearr_31745_33354[(1)] = (19));

} else {
var statearr_31746_33355 = state_31679__$1;
(statearr_31746_33355[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (38))){
var inst_31658 = (state_31679[(2)]);
var state_31679__$1 = state_31679;
var statearr_31747_33356 = state_31679__$1;
(statearr_31747_33356[(2)] = inst_31658);

(statearr_31747_33356[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (30))){
var state_31679__$1 = state_31679;
var statearr_31748_33357 = state_31679__$1;
(statearr_31748_33357[(2)] = null);

(statearr_31748_33357[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (10))){
var inst_31561 = (state_31679[(13)]);
var inst_31559 = (state_31679[(16)]);
var inst_31569 = cljs.core._nth(inst_31559,inst_31561);
var inst_31570 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31569,(0),null);
var inst_31571 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31569,(1),null);
var state_31679__$1 = (function (){var statearr_31749 = state_31679;
(statearr_31749[(24)] = inst_31570);

return statearr_31749;
})();
if(cljs.core.truth_(inst_31571)){
var statearr_31750_33358 = state_31679__$1;
(statearr_31750_33358[(1)] = (13));

} else {
var statearr_31751_33359 = state_31679__$1;
(statearr_31751_33359[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (18))){
var inst_31606 = (state_31679[(2)]);
var state_31679__$1 = state_31679;
var statearr_31752_33360 = state_31679__$1;
(statearr_31752_33360[(2)] = inst_31606);

(statearr_31752_33360[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (42))){
var state_31679__$1 = state_31679;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31679__$1,(45),dchan);
} else {
if((state_val_31680 === (37))){
var inst_31549 = (state_31679[(10)]);
var inst_31648 = (state_31679[(22)]);
var inst_31639 = (state_31679[(23)]);
var inst_31648__$1 = cljs.core.first(inst_31639);
var inst_31649 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_31648__$1,inst_31549,done);
var state_31679__$1 = (function (){var statearr_31753 = state_31679;
(statearr_31753[(22)] = inst_31648__$1);

return statearr_31753;
})();
if(cljs.core.truth_(inst_31649)){
var statearr_31754_33361 = state_31679__$1;
(statearr_31754_33361[(1)] = (39));

} else {
var statearr_31755_33362 = state_31679__$1;
(statearr_31755_33362[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31680 === (8))){
var inst_31561 = (state_31679[(13)]);
var inst_31560 = (state_31679[(17)]);
var inst_31563 = (inst_31561 < inst_31560);
var inst_31564 = inst_31563;
var state_31679__$1 = state_31679;
if(cljs.core.truth_(inst_31564)){
var statearr_31756_33363 = state_31679__$1;
(statearr_31756_33363[(1)] = (10));

} else {
var statearr_31757_33364 = state_31679__$1;
(statearr_31757_33364[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__31034__auto__ = null;
var cljs$core$async$mult_$_state_machine__31034__auto____0 = (function (){
var statearr_31758 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31758[(0)] = cljs$core$async$mult_$_state_machine__31034__auto__);

(statearr_31758[(1)] = (1));

return statearr_31758;
});
var cljs$core$async$mult_$_state_machine__31034__auto____1 = (function (state_31679){
while(true){
var ret_value__31035__auto__ = (function (){try{while(true){
var result__31036__auto__ = switch__31033__auto__(state_31679);
if(cljs.core.keyword_identical_QMARK_(result__31036__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31036__auto__;
}
break;
}
}catch (e31759){var ex__31037__auto__ = e31759;
var statearr_31760_33365 = state_31679;
(statearr_31760_33365[(2)] = ex__31037__auto__);


if(cljs.core.seq((state_31679[(4)]))){
var statearr_31761_33366 = state_31679;
(statearr_31761_33366[(1)] = cljs.core.first((state_31679[(4)])));

} else {
throw ex__31037__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33367 = state_31679;
state_31679 = G__33367;
continue;
} else {
return ret_value__31035__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__31034__auto__ = function(state_31679){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__31034__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__31034__auto____1.call(this,state_31679);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__31034__auto____0;
cljs$core$async$mult_$_state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__31034__auto____1;
return cljs$core$async$mult_$_state_machine__31034__auto__;
})()
})();
var state__31071__auto__ = (function (){var statearr_31762 = f__31070__auto__();
(statearr_31762[(6)] = c__31069__auto___33156);

return statearr_31762;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31071__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__31764 = arguments.length;
switch (G__31764) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_33369 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_33369(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_33370 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_33370(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_33371 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_33371(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_33372 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_33372(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_33373 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_33373(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33375 = arguments.length;
var i__4737__auto___33376 = (0);
while(true){
if((i__4737__auto___33376 < len__4736__auto___33375)){
args__4742__auto__.push((arguments[i__4737__auto___33376]));

var G__33377 = (i__4737__auto___33376 + (1));
i__4737__auto___33376 = G__33377;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__31769){
var map__31770 = p__31769;
var map__31770__$1 = (((((!((map__31770 == null))))?(((((map__31770.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31770.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31770):map__31770);
var opts = map__31770__$1;
var statearr_31772_33378 = state;
(statearr_31772_33378[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_31773_33379 = state;
(statearr_31773_33379[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_31774_33380 = state;
(statearr_31774_33380[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq31765){
var G__31766 = cljs.core.first(seq31765);
var seq31765__$1 = cljs.core.next(seq31765);
var G__31767 = cljs.core.first(seq31765__$1);
var seq31765__$2 = cljs.core.next(seq31765__$1);
var G__31768 = cljs.core.first(seq31765__$2);
var seq31765__$3 = cljs.core.next(seq31765__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__31766,G__31767,G__31768,seq31765__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31775 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31775 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta31776){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta31776 = meta31776;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31775.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31777,meta31776__$1){
var self__ = this;
var _31777__$1 = this;
return (new cljs.core.async.t_cljs$core$async31775(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta31776__$1));
}));

(cljs.core.async.t_cljs$core$async31775.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31777){
var self__ = this;
var _31777__$1 = this;
return self__.meta31776;
}));

(cljs.core.async.t_cljs$core$async31775.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31775.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async31775.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31775.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31775.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31775.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31775.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31775.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31775.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta31776","meta31776",-152264658,null)], null);
}));

(cljs.core.async.t_cljs$core$async31775.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31775.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31775");

(cljs.core.async.t_cljs$core$async31775.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async31775");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31775.
 */
cljs.core.async.__GT_t_cljs$core$async31775 = (function cljs$core$async$mix_$___GT_t_cljs$core$async31775(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta31776){
return (new cljs.core.async.t_cljs$core$async31775(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta31776));
});

}

return (new cljs.core.async.t_cljs$core$async31775(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__31069__auto___33386 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31070__auto__ = (function (){var switch__31033__auto__ = (function (state_31879){
var state_val_31880 = (state_31879[(1)]);
if((state_val_31880 === (7))){
var inst_31794 = (state_31879[(2)]);
var state_31879__$1 = state_31879;
var statearr_31881_33387 = state_31879__$1;
(statearr_31881_33387[(2)] = inst_31794);

(statearr_31881_33387[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (20))){
var inst_31806 = (state_31879[(7)]);
var state_31879__$1 = state_31879;
var statearr_31882_33388 = state_31879__$1;
(statearr_31882_33388[(2)] = inst_31806);

(statearr_31882_33388[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (27))){
var state_31879__$1 = state_31879;
var statearr_31883_33389 = state_31879__$1;
(statearr_31883_33389[(2)] = null);

(statearr_31883_33389[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (1))){
var inst_31781 = (state_31879[(8)]);
var inst_31781__$1 = calc_state();
var inst_31783 = (inst_31781__$1 == null);
var inst_31784 = cljs.core.not(inst_31783);
var state_31879__$1 = (function (){var statearr_31884 = state_31879;
(statearr_31884[(8)] = inst_31781__$1);

return statearr_31884;
})();
if(inst_31784){
var statearr_31885_33390 = state_31879__$1;
(statearr_31885_33390[(1)] = (2));

} else {
var statearr_31886_33391 = state_31879__$1;
(statearr_31886_33391[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (24))){
var inst_31839 = (state_31879[(9)]);
var inst_31853 = (state_31879[(10)]);
var inst_31830 = (state_31879[(11)]);
var inst_31853__$1 = (inst_31830.cljs$core$IFn$_invoke$arity$1 ? inst_31830.cljs$core$IFn$_invoke$arity$1(inst_31839) : inst_31830.call(null,inst_31839));
var state_31879__$1 = (function (){var statearr_31887 = state_31879;
(statearr_31887[(10)] = inst_31853__$1);

return statearr_31887;
})();
if(cljs.core.truth_(inst_31853__$1)){
var statearr_31888_33392 = state_31879__$1;
(statearr_31888_33392[(1)] = (29));

} else {
var statearr_31889_33393 = state_31879__$1;
(statearr_31889_33393[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (4))){
var inst_31797 = (state_31879[(2)]);
var state_31879__$1 = state_31879;
if(cljs.core.truth_(inst_31797)){
var statearr_31890_33394 = state_31879__$1;
(statearr_31890_33394[(1)] = (8));

} else {
var statearr_31891_33395 = state_31879__$1;
(statearr_31891_33395[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (15))){
var inst_31824 = (state_31879[(2)]);
var state_31879__$1 = state_31879;
if(cljs.core.truth_(inst_31824)){
var statearr_31892_33396 = state_31879__$1;
(statearr_31892_33396[(1)] = (19));

} else {
var statearr_31893_33397 = state_31879__$1;
(statearr_31893_33397[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (21))){
var inst_31829 = (state_31879[(12)]);
var inst_31829__$1 = (state_31879[(2)]);
var inst_31830 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31829__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31831 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31829__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31832 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31829__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_31879__$1 = (function (){var statearr_31894 = state_31879;
(statearr_31894[(12)] = inst_31829__$1);

(statearr_31894[(13)] = inst_31831);

(statearr_31894[(11)] = inst_31830);

return statearr_31894;
})();
return cljs.core.async.ioc_alts_BANG_(state_31879__$1,(22),inst_31832);
} else {
if((state_val_31880 === (31))){
var inst_31861 = (state_31879[(2)]);
var state_31879__$1 = state_31879;
if(cljs.core.truth_(inst_31861)){
var statearr_31895_33398 = state_31879__$1;
(statearr_31895_33398[(1)] = (32));

} else {
var statearr_31896_33399 = state_31879__$1;
(statearr_31896_33399[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (32))){
var inst_31838 = (state_31879[(14)]);
var state_31879__$1 = state_31879;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31879__$1,(35),out,inst_31838);
} else {
if((state_val_31880 === (33))){
var inst_31829 = (state_31879[(12)]);
var inst_31806 = inst_31829;
var state_31879__$1 = (function (){var statearr_31897 = state_31879;
(statearr_31897[(7)] = inst_31806);

return statearr_31897;
})();
var statearr_31898_33400 = state_31879__$1;
(statearr_31898_33400[(2)] = null);

(statearr_31898_33400[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (13))){
var inst_31806 = (state_31879[(7)]);
var inst_31813 = inst_31806.cljs$lang$protocol_mask$partition0$;
var inst_31814 = (inst_31813 & (64));
var inst_31815 = inst_31806.cljs$core$ISeq$;
var inst_31816 = (cljs.core.PROTOCOL_SENTINEL === inst_31815);
var inst_31817 = ((inst_31814) || (inst_31816));
var state_31879__$1 = state_31879;
if(cljs.core.truth_(inst_31817)){
var statearr_31899_33401 = state_31879__$1;
(statearr_31899_33401[(1)] = (16));

} else {
var statearr_31900_33402 = state_31879__$1;
(statearr_31900_33402[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (22))){
var inst_31838 = (state_31879[(14)]);
var inst_31839 = (state_31879[(9)]);
var inst_31837 = (state_31879[(2)]);
var inst_31838__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31837,(0),null);
var inst_31839__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31837,(1),null);
var inst_31840 = (inst_31838__$1 == null);
var inst_31841 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31839__$1,change);
var inst_31842 = ((inst_31840) || (inst_31841));
var state_31879__$1 = (function (){var statearr_31901 = state_31879;
(statearr_31901[(14)] = inst_31838__$1);

(statearr_31901[(9)] = inst_31839__$1);

return statearr_31901;
})();
if(cljs.core.truth_(inst_31842)){
var statearr_31902_33403 = state_31879__$1;
(statearr_31902_33403[(1)] = (23));

} else {
var statearr_31903_33404 = state_31879__$1;
(statearr_31903_33404[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (36))){
var inst_31829 = (state_31879[(12)]);
var inst_31806 = inst_31829;
var state_31879__$1 = (function (){var statearr_31904 = state_31879;
(statearr_31904[(7)] = inst_31806);

return statearr_31904;
})();
var statearr_31905_33405 = state_31879__$1;
(statearr_31905_33405[(2)] = null);

(statearr_31905_33405[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (29))){
var inst_31853 = (state_31879[(10)]);
var state_31879__$1 = state_31879;
var statearr_31906_33406 = state_31879__$1;
(statearr_31906_33406[(2)] = inst_31853);

(statearr_31906_33406[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (6))){
var state_31879__$1 = state_31879;
var statearr_31907_33407 = state_31879__$1;
(statearr_31907_33407[(2)] = false);

(statearr_31907_33407[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (28))){
var inst_31849 = (state_31879[(2)]);
var inst_31850 = calc_state();
var inst_31806 = inst_31850;
var state_31879__$1 = (function (){var statearr_31908 = state_31879;
(statearr_31908[(7)] = inst_31806);

(statearr_31908[(15)] = inst_31849);

return statearr_31908;
})();
var statearr_31909_33408 = state_31879__$1;
(statearr_31909_33408[(2)] = null);

(statearr_31909_33408[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (25))){
var inst_31875 = (state_31879[(2)]);
var state_31879__$1 = state_31879;
var statearr_31910_33409 = state_31879__$1;
(statearr_31910_33409[(2)] = inst_31875);

(statearr_31910_33409[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (34))){
var inst_31873 = (state_31879[(2)]);
var state_31879__$1 = state_31879;
var statearr_31911_33413 = state_31879__$1;
(statearr_31911_33413[(2)] = inst_31873);

(statearr_31911_33413[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (17))){
var state_31879__$1 = state_31879;
var statearr_31912_33415 = state_31879__$1;
(statearr_31912_33415[(2)] = false);

(statearr_31912_33415[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (3))){
var state_31879__$1 = state_31879;
var statearr_31913_33419 = state_31879__$1;
(statearr_31913_33419[(2)] = false);

(statearr_31913_33419[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (12))){
var inst_31877 = (state_31879[(2)]);
var state_31879__$1 = state_31879;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31879__$1,inst_31877);
} else {
if((state_val_31880 === (2))){
var inst_31781 = (state_31879[(8)]);
var inst_31786 = inst_31781.cljs$lang$protocol_mask$partition0$;
var inst_31787 = (inst_31786 & (64));
var inst_31788 = inst_31781.cljs$core$ISeq$;
var inst_31789 = (cljs.core.PROTOCOL_SENTINEL === inst_31788);
var inst_31790 = ((inst_31787) || (inst_31789));
var state_31879__$1 = state_31879;
if(cljs.core.truth_(inst_31790)){
var statearr_31914_33457 = state_31879__$1;
(statearr_31914_33457[(1)] = (5));

} else {
var statearr_31915_33458 = state_31879__$1;
(statearr_31915_33458[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (23))){
var inst_31838 = (state_31879[(14)]);
var inst_31844 = (inst_31838 == null);
var state_31879__$1 = state_31879;
if(cljs.core.truth_(inst_31844)){
var statearr_31916_33459 = state_31879__$1;
(statearr_31916_33459[(1)] = (26));

} else {
var statearr_31917_33460 = state_31879__$1;
(statearr_31917_33460[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (35))){
var inst_31864 = (state_31879[(2)]);
var state_31879__$1 = state_31879;
if(cljs.core.truth_(inst_31864)){
var statearr_31918_33461 = state_31879__$1;
(statearr_31918_33461[(1)] = (36));

} else {
var statearr_31919_33462 = state_31879__$1;
(statearr_31919_33462[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (19))){
var inst_31806 = (state_31879[(7)]);
var inst_31826 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_31806);
var state_31879__$1 = state_31879;
var statearr_31920_33463 = state_31879__$1;
(statearr_31920_33463[(2)] = inst_31826);

(statearr_31920_33463[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (11))){
var inst_31806 = (state_31879[(7)]);
var inst_31810 = (inst_31806 == null);
var inst_31811 = cljs.core.not(inst_31810);
var state_31879__$1 = state_31879;
if(inst_31811){
var statearr_31921_33464 = state_31879__$1;
(statearr_31921_33464[(1)] = (13));

} else {
var statearr_31922_33465 = state_31879__$1;
(statearr_31922_33465[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (9))){
var inst_31781 = (state_31879[(8)]);
var state_31879__$1 = state_31879;
var statearr_31923_33466 = state_31879__$1;
(statearr_31923_33466[(2)] = inst_31781);

(statearr_31923_33466[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (5))){
var state_31879__$1 = state_31879;
var statearr_31924_33467 = state_31879__$1;
(statearr_31924_33467[(2)] = true);

(statearr_31924_33467[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (14))){
var state_31879__$1 = state_31879;
var statearr_31925_33468 = state_31879__$1;
(statearr_31925_33468[(2)] = false);

(statearr_31925_33468[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (26))){
var inst_31839 = (state_31879[(9)]);
var inst_31846 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_31839);
var state_31879__$1 = state_31879;
var statearr_31926_33469 = state_31879__$1;
(statearr_31926_33469[(2)] = inst_31846);

(statearr_31926_33469[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (16))){
var state_31879__$1 = state_31879;
var statearr_31927_33470 = state_31879__$1;
(statearr_31927_33470[(2)] = true);

(statearr_31927_33470[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (38))){
var inst_31869 = (state_31879[(2)]);
var state_31879__$1 = state_31879;
var statearr_31928_33471 = state_31879__$1;
(statearr_31928_33471[(2)] = inst_31869);

(statearr_31928_33471[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (30))){
var inst_31839 = (state_31879[(9)]);
var inst_31831 = (state_31879[(13)]);
var inst_31830 = (state_31879[(11)]);
var inst_31856 = cljs.core.empty_QMARK_(inst_31830);
var inst_31857 = (inst_31831.cljs$core$IFn$_invoke$arity$1 ? inst_31831.cljs$core$IFn$_invoke$arity$1(inst_31839) : inst_31831.call(null,inst_31839));
var inst_31858 = cljs.core.not(inst_31857);
var inst_31859 = ((inst_31856) && (inst_31858));
var state_31879__$1 = state_31879;
var statearr_31929_33472 = state_31879__$1;
(statearr_31929_33472[(2)] = inst_31859);

(statearr_31929_33472[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (10))){
var inst_31781 = (state_31879[(8)]);
var inst_31802 = (state_31879[(2)]);
var inst_31803 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31802,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31804 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31802,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31805 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31802,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_31806 = inst_31781;
var state_31879__$1 = (function (){var statearr_31930 = state_31879;
(statearr_31930[(16)] = inst_31803);

(statearr_31930[(17)] = inst_31805);

(statearr_31930[(7)] = inst_31806);

(statearr_31930[(18)] = inst_31804);

return statearr_31930;
})();
var statearr_31931_33473 = state_31879__$1;
(statearr_31931_33473[(2)] = null);

(statearr_31931_33473[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (18))){
var inst_31821 = (state_31879[(2)]);
var state_31879__$1 = state_31879;
var statearr_31932_33474 = state_31879__$1;
(statearr_31932_33474[(2)] = inst_31821);

(statearr_31932_33474[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (37))){
var state_31879__$1 = state_31879;
var statearr_31933_33475 = state_31879__$1;
(statearr_31933_33475[(2)] = null);

(statearr_31933_33475[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31880 === (8))){
var inst_31781 = (state_31879[(8)]);
var inst_31799 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_31781);
var state_31879__$1 = state_31879;
var statearr_31934_33476 = state_31879__$1;
(statearr_31934_33476[(2)] = inst_31799);

(statearr_31934_33476[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__31034__auto__ = null;
var cljs$core$async$mix_$_state_machine__31034__auto____0 = (function (){
var statearr_31935 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31935[(0)] = cljs$core$async$mix_$_state_machine__31034__auto__);

(statearr_31935[(1)] = (1));

return statearr_31935;
});
var cljs$core$async$mix_$_state_machine__31034__auto____1 = (function (state_31879){
while(true){
var ret_value__31035__auto__ = (function (){try{while(true){
var result__31036__auto__ = switch__31033__auto__(state_31879);
if(cljs.core.keyword_identical_QMARK_(result__31036__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31036__auto__;
}
break;
}
}catch (e31936){var ex__31037__auto__ = e31936;
var statearr_31937_33477 = state_31879;
(statearr_31937_33477[(2)] = ex__31037__auto__);


if(cljs.core.seq((state_31879[(4)]))){
var statearr_31938_33478 = state_31879;
(statearr_31938_33478[(1)] = cljs.core.first((state_31879[(4)])));

} else {
throw ex__31037__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33479 = state_31879;
state_31879 = G__33479;
continue;
} else {
return ret_value__31035__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__31034__auto__ = function(state_31879){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__31034__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__31034__auto____1.call(this,state_31879);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__31034__auto____0;
cljs$core$async$mix_$_state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__31034__auto____1;
return cljs$core$async$mix_$_state_machine__31034__auto__;
})()
})();
var state__31071__auto__ = (function (){var statearr_31939 = f__31070__auto__();
(statearr_31939[(6)] = c__31069__auto___33386);

return statearr_31939;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31071__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_33480 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_33480(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_33481 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_33481(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_33482 = (function() {
var G__33483 = null;
var G__33483__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__33483__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__33483 = function(p,v){
switch(arguments.length){
case 1:
return G__33483__1.call(this,p);
case 2:
return G__33483__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__33483.cljs$core$IFn$_invoke$arity$1 = G__33483__1;
G__33483.cljs$core$IFn$_invoke$arity$2 = G__33483__2;
return G__33483;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__31941 = arguments.length;
switch (G__31941) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_33482(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_33482(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__31944 = arguments.length;
switch (G__31944) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__31942_SHARP_){
if(cljs.core.truth_((p1__31942_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__31942_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__31942_SHARP_.call(null,topic)))){
return p1__31942_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__31942_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31945 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31945 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta31946){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta31946 = meta31946;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31945.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31947,meta31946__$1){
var self__ = this;
var _31947__$1 = this;
return (new cljs.core.async.t_cljs$core$async31945(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta31946__$1));
}));

(cljs.core.async.t_cljs$core$async31945.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31947){
var self__ = this;
var _31947__$1 = this;
return self__.meta31946;
}));

(cljs.core.async.t_cljs$core$async31945.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31945.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async31945.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31945.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async31945.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async31945.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async31945.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async31945.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta31946","meta31946",-1862736147,null)], null);
}));

(cljs.core.async.t_cljs$core$async31945.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31945.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31945");

(cljs.core.async.t_cljs$core$async31945.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async31945");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31945.
 */
cljs.core.async.__GT_t_cljs$core$async31945 = (function cljs$core$async$__GT_t_cljs$core$async31945(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31946){
return (new cljs.core.async.t_cljs$core$async31945(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31946));
});

}

return (new cljs.core.async.t_cljs$core$async31945(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__31069__auto___33563 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31070__auto__ = (function (){var switch__31033__auto__ = (function (state_32019){
var state_val_32020 = (state_32019[(1)]);
if((state_val_32020 === (7))){
var inst_32015 = (state_32019[(2)]);
var state_32019__$1 = state_32019;
var statearr_32021_33564 = state_32019__$1;
(statearr_32021_33564[(2)] = inst_32015);

(statearr_32021_33564[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32020 === (20))){
var state_32019__$1 = state_32019;
var statearr_32022_33565 = state_32019__$1;
(statearr_32022_33565[(2)] = null);

(statearr_32022_33565[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32020 === (1))){
var state_32019__$1 = state_32019;
var statearr_32023_33566 = state_32019__$1;
(statearr_32023_33566[(2)] = null);

(statearr_32023_33566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32020 === (24))){
var inst_31998 = (state_32019[(7)]);
var inst_32007 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_31998);
var state_32019__$1 = state_32019;
var statearr_32024_33567 = state_32019__$1;
(statearr_32024_33567[(2)] = inst_32007);

(statearr_32024_33567[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32020 === (4))){
var inst_31950 = (state_32019[(8)]);
var inst_31950__$1 = (state_32019[(2)]);
var inst_31951 = (inst_31950__$1 == null);
var state_32019__$1 = (function (){var statearr_32025 = state_32019;
(statearr_32025[(8)] = inst_31950__$1);

return statearr_32025;
})();
if(cljs.core.truth_(inst_31951)){
var statearr_32026_33568 = state_32019__$1;
(statearr_32026_33568[(1)] = (5));

} else {
var statearr_32027_33569 = state_32019__$1;
(statearr_32027_33569[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32020 === (15))){
var inst_31992 = (state_32019[(2)]);
var state_32019__$1 = state_32019;
var statearr_32028_33570 = state_32019__$1;
(statearr_32028_33570[(2)] = inst_31992);

(statearr_32028_33570[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32020 === (21))){
var inst_32012 = (state_32019[(2)]);
var state_32019__$1 = (function (){var statearr_32029 = state_32019;
(statearr_32029[(9)] = inst_32012);

return statearr_32029;
})();
var statearr_32030_33571 = state_32019__$1;
(statearr_32030_33571[(2)] = null);

(statearr_32030_33571[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32020 === (13))){
var inst_31974 = (state_32019[(10)]);
var inst_31976 = cljs.core.chunked_seq_QMARK_(inst_31974);
var state_32019__$1 = state_32019;
if(inst_31976){
var statearr_32031_33572 = state_32019__$1;
(statearr_32031_33572[(1)] = (16));

} else {
var statearr_32032_33573 = state_32019__$1;
(statearr_32032_33573[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32020 === (22))){
var inst_32004 = (state_32019[(2)]);
var state_32019__$1 = state_32019;
if(cljs.core.truth_(inst_32004)){
var statearr_32033_33575 = state_32019__$1;
(statearr_32033_33575[(1)] = (23));

} else {
var statearr_32034_33576 = state_32019__$1;
(statearr_32034_33576[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32020 === (6))){
var inst_32000 = (state_32019[(11)]);
var inst_31950 = (state_32019[(8)]);
var inst_31998 = (state_32019[(7)]);
var inst_31998__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_31950) : topic_fn.call(null,inst_31950));
var inst_31999 = cljs.core.deref(mults);
var inst_32000__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31999,inst_31998__$1);
var state_32019__$1 = (function (){var statearr_32035 = state_32019;
(statearr_32035[(11)] = inst_32000__$1);

(statearr_32035[(7)] = inst_31998__$1);

return statearr_32035;
})();
if(cljs.core.truth_(inst_32000__$1)){
var statearr_32036_33595 = state_32019__$1;
(statearr_32036_33595[(1)] = (19));

} else {
var statearr_32037_33600 = state_32019__$1;
(statearr_32037_33600[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32020 === (25))){
var inst_32009 = (state_32019[(2)]);
var state_32019__$1 = state_32019;
var statearr_32038_33610 = state_32019__$1;
(statearr_32038_33610[(2)] = inst_32009);

(statearr_32038_33610[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32020 === (17))){
var inst_31974 = (state_32019[(10)]);
var inst_31983 = cljs.core.first(inst_31974);
var inst_31984 = cljs.core.async.muxch_STAR_(inst_31983);
var inst_31985 = cljs.core.async.close_BANG_(inst_31984);
var inst_31986 = cljs.core.next(inst_31974);
var inst_31960 = inst_31986;
var inst_31961 = null;
var inst_31962 = (0);
var inst_31963 = (0);
var state_32019__$1 = (function (){var statearr_32039 = state_32019;
(statearr_32039[(12)] = inst_31963);

(statearr_32039[(13)] = inst_31960);

(statearr_32039[(14)] = inst_31962);

(statearr_32039[(15)] = inst_31961);

(statearr_32039[(16)] = inst_31985);

return statearr_32039;
})();
var statearr_32040_33642 = state_32019__$1;
(statearr_32040_33642[(2)] = null);

(statearr_32040_33642[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32020 === (3))){
var inst_32017 = (state_32019[(2)]);
var state_32019__$1 = state_32019;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32019__$1,inst_32017);
} else {
if((state_val_32020 === (12))){
var inst_31994 = (state_32019[(2)]);
var state_32019__$1 = state_32019;
var statearr_32041_33653 = state_32019__$1;
(statearr_32041_33653[(2)] = inst_31994);

(statearr_32041_33653[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32020 === (2))){
var state_32019__$1 = state_32019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32019__$1,(4),ch);
} else {
if((state_val_32020 === (23))){
var state_32019__$1 = state_32019;
var statearr_32042_33657 = state_32019__$1;
(statearr_32042_33657[(2)] = null);

(statearr_32042_33657[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32020 === (19))){
var inst_32000 = (state_32019[(11)]);
var inst_31950 = (state_32019[(8)]);
var inst_32002 = cljs.core.async.muxch_STAR_(inst_32000);
var state_32019__$1 = state_32019;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32019__$1,(22),inst_32002,inst_31950);
} else {
if((state_val_32020 === (11))){
var inst_31960 = (state_32019[(13)]);
var inst_31974 = (state_32019[(10)]);
var inst_31974__$1 = cljs.core.seq(inst_31960);
var state_32019__$1 = (function (){var statearr_32043 = state_32019;
(statearr_32043[(10)] = inst_31974__$1);

return statearr_32043;
})();
if(inst_31974__$1){
var statearr_32044_33659 = state_32019__$1;
(statearr_32044_33659[(1)] = (13));

} else {
var statearr_32045_33660 = state_32019__$1;
(statearr_32045_33660[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32020 === (9))){
var inst_31996 = (state_32019[(2)]);
var state_32019__$1 = state_32019;
var statearr_32046_33661 = state_32019__$1;
(statearr_32046_33661[(2)] = inst_31996);

(statearr_32046_33661[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32020 === (5))){
var inst_31957 = cljs.core.deref(mults);
var inst_31958 = cljs.core.vals(inst_31957);
var inst_31959 = cljs.core.seq(inst_31958);
var inst_31960 = inst_31959;
var inst_31961 = null;
var inst_31962 = (0);
var inst_31963 = (0);
var state_32019__$1 = (function (){var statearr_32047 = state_32019;
(statearr_32047[(12)] = inst_31963);

(statearr_32047[(13)] = inst_31960);

(statearr_32047[(14)] = inst_31962);

(statearr_32047[(15)] = inst_31961);

return statearr_32047;
})();
var statearr_32048_33662 = state_32019__$1;
(statearr_32048_33662[(2)] = null);

(statearr_32048_33662[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32020 === (14))){
var state_32019__$1 = state_32019;
var statearr_32052_33663 = state_32019__$1;
(statearr_32052_33663[(2)] = null);

(statearr_32052_33663[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32020 === (16))){
var inst_31974 = (state_32019[(10)]);
var inst_31978 = cljs.core.chunk_first(inst_31974);
var inst_31979 = cljs.core.chunk_rest(inst_31974);
var inst_31980 = cljs.core.count(inst_31978);
var inst_31960 = inst_31979;
var inst_31961 = inst_31978;
var inst_31962 = inst_31980;
var inst_31963 = (0);
var state_32019__$1 = (function (){var statearr_32053 = state_32019;
(statearr_32053[(12)] = inst_31963);

(statearr_32053[(13)] = inst_31960);

(statearr_32053[(14)] = inst_31962);

(statearr_32053[(15)] = inst_31961);

return statearr_32053;
})();
var statearr_32054_33664 = state_32019__$1;
(statearr_32054_33664[(2)] = null);

(statearr_32054_33664[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32020 === (10))){
var inst_31963 = (state_32019[(12)]);
var inst_31960 = (state_32019[(13)]);
var inst_31962 = (state_32019[(14)]);
var inst_31961 = (state_32019[(15)]);
var inst_31968 = cljs.core._nth(inst_31961,inst_31963);
var inst_31969 = cljs.core.async.muxch_STAR_(inst_31968);
var inst_31970 = cljs.core.async.close_BANG_(inst_31969);
var inst_31971 = (inst_31963 + (1));
var tmp32049 = inst_31960;
var tmp32050 = inst_31962;
var tmp32051 = inst_31961;
var inst_31960__$1 = tmp32049;
var inst_31961__$1 = tmp32051;
var inst_31962__$1 = tmp32050;
var inst_31963__$1 = inst_31971;
var state_32019__$1 = (function (){var statearr_32055 = state_32019;
(statearr_32055[(12)] = inst_31963__$1);

(statearr_32055[(13)] = inst_31960__$1);

(statearr_32055[(14)] = inst_31962__$1);

(statearr_32055[(17)] = inst_31970);

(statearr_32055[(15)] = inst_31961__$1);

return statearr_32055;
})();
var statearr_32056_33665 = state_32019__$1;
(statearr_32056_33665[(2)] = null);

(statearr_32056_33665[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32020 === (18))){
var inst_31989 = (state_32019[(2)]);
var state_32019__$1 = state_32019;
var statearr_32057_33666 = state_32019__$1;
(statearr_32057_33666[(2)] = inst_31989);

(statearr_32057_33666[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32020 === (8))){
var inst_31963 = (state_32019[(12)]);
var inst_31962 = (state_32019[(14)]);
var inst_31965 = (inst_31963 < inst_31962);
var inst_31966 = inst_31965;
var state_32019__$1 = state_32019;
if(cljs.core.truth_(inst_31966)){
var statearr_32058_33667 = state_32019__$1;
(statearr_32058_33667[(1)] = (10));

} else {
var statearr_32059_33668 = state_32019__$1;
(statearr_32059_33668[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__31034__auto__ = null;
var cljs$core$async$state_machine__31034__auto____0 = (function (){
var statearr_32060 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32060[(0)] = cljs$core$async$state_machine__31034__auto__);

(statearr_32060[(1)] = (1));

return statearr_32060;
});
var cljs$core$async$state_machine__31034__auto____1 = (function (state_32019){
while(true){
var ret_value__31035__auto__ = (function (){try{while(true){
var result__31036__auto__ = switch__31033__auto__(state_32019);
if(cljs.core.keyword_identical_QMARK_(result__31036__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31036__auto__;
}
break;
}
}catch (e32061){var ex__31037__auto__ = e32061;
var statearr_32062_33669 = state_32019;
(statearr_32062_33669[(2)] = ex__31037__auto__);


if(cljs.core.seq((state_32019[(4)]))){
var statearr_32063_33670 = state_32019;
(statearr_32063_33670[(1)] = cljs.core.first((state_32019[(4)])));

} else {
throw ex__31037__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33671 = state_32019;
state_32019 = G__33671;
continue;
} else {
return ret_value__31035__auto__;
}
break;
}
});
cljs$core$async$state_machine__31034__auto__ = function(state_32019){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31034__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31034__auto____1.call(this,state_32019);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31034__auto____0;
cljs$core$async$state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31034__auto____1;
return cljs$core$async$state_machine__31034__auto__;
})()
})();
var state__31071__auto__ = (function (){var statearr_32064 = f__31070__auto__();
(statearr_32064[(6)] = c__31069__auto___33563);

return statearr_32064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31071__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__32066 = arguments.length;
switch (G__32066) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__32068 = arguments.length;
switch (G__32068) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__32070 = arguments.length;
switch (G__32070) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__31069__auto___33675 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31070__auto__ = (function (){var switch__31033__auto__ = (function (state_32113){
var state_val_32114 = (state_32113[(1)]);
if((state_val_32114 === (7))){
var state_32113__$1 = state_32113;
var statearr_32115_33676 = state_32113__$1;
(statearr_32115_33676[(2)] = null);

(statearr_32115_33676[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32114 === (1))){
var state_32113__$1 = state_32113;
var statearr_32116_33677 = state_32113__$1;
(statearr_32116_33677[(2)] = null);

(statearr_32116_33677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32114 === (4))){
var inst_32074 = (state_32113[(7)]);
var inst_32073 = (state_32113[(8)]);
var inst_32076 = (inst_32074 < inst_32073);
var state_32113__$1 = state_32113;
if(cljs.core.truth_(inst_32076)){
var statearr_32117_33678 = state_32113__$1;
(statearr_32117_33678[(1)] = (6));

} else {
var statearr_32118_33679 = state_32113__$1;
(statearr_32118_33679[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32114 === (15))){
var inst_32099 = (state_32113[(9)]);
var inst_32104 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_32099);
var state_32113__$1 = state_32113;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32113__$1,(17),out,inst_32104);
} else {
if((state_val_32114 === (13))){
var inst_32099 = (state_32113[(9)]);
var inst_32099__$1 = (state_32113[(2)]);
var inst_32100 = cljs.core.some(cljs.core.nil_QMARK_,inst_32099__$1);
var state_32113__$1 = (function (){var statearr_32119 = state_32113;
(statearr_32119[(9)] = inst_32099__$1);

return statearr_32119;
})();
if(cljs.core.truth_(inst_32100)){
var statearr_32120_33680 = state_32113__$1;
(statearr_32120_33680[(1)] = (14));

} else {
var statearr_32121_33681 = state_32113__$1;
(statearr_32121_33681[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32114 === (6))){
var state_32113__$1 = state_32113;
var statearr_32122_33682 = state_32113__$1;
(statearr_32122_33682[(2)] = null);

(statearr_32122_33682[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32114 === (17))){
var inst_32106 = (state_32113[(2)]);
var state_32113__$1 = (function (){var statearr_32124 = state_32113;
(statearr_32124[(10)] = inst_32106);

return statearr_32124;
})();
var statearr_32125_33683 = state_32113__$1;
(statearr_32125_33683[(2)] = null);

(statearr_32125_33683[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32114 === (3))){
var inst_32111 = (state_32113[(2)]);
var state_32113__$1 = state_32113;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32113__$1,inst_32111);
} else {
if((state_val_32114 === (12))){
var _ = (function (){var statearr_32126 = state_32113;
(statearr_32126[(4)] = cljs.core.rest((state_32113[(4)])));

return statearr_32126;
})();
var state_32113__$1 = state_32113;
var ex32123 = (state_32113__$1[(2)]);
var statearr_32127_33684 = state_32113__$1;
(statearr_32127_33684[(5)] = ex32123);


if((ex32123 instanceof Object)){
var statearr_32128_33685 = state_32113__$1;
(statearr_32128_33685[(1)] = (11));

(statearr_32128_33685[(5)] = null);

} else {
throw ex32123;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32114 === (2))){
var inst_32072 = cljs.core.reset_BANG_(dctr,cnt);
var inst_32073 = cnt;
var inst_32074 = (0);
var state_32113__$1 = (function (){var statearr_32129 = state_32113;
(statearr_32129[(7)] = inst_32074);

(statearr_32129[(11)] = inst_32072);

(statearr_32129[(8)] = inst_32073);

return statearr_32129;
})();
var statearr_32130_33686 = state_32113__$1;
(statearr_32130_33686[(2)] = null);

(statearr_32130_33686[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32114 === (11))){
var inst_32078 = (state_32113[(2)]);
var inst_32079 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_32113__$1 = (function (){var statearr_32131 = state_32113;
(statearr_32131[(12)] = inst_32078);

return statearr_32131;
})();
var statearr_32132_33687 = state_32113__$1;
(statearr_32132_33687[(2)] = inst_32079);

(statearr_32132_33687[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32114 === (9))){
var inst_32074 = (state_32113[(7)]);
var _ = (function (){var statearr_32133 = state_32113;
(statearr_32133[(4)] = cljs.core.cons((12),(state_32113[(4)])));

return statearr_32133;
})();
var inst_32085 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_32074) : chs__$1.call(null,inst_32074));
var inst_32086 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_32074) : done.call(null,inst_32074));
var inst_32087 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_32085,inst_32086);
var ___$1 = (function (){var statearr_32134 = state_32113;
(statearr_32134[(4)] = cljs.core.rest((state_32113[(4)])));

return statearr_32134;
})();
var state_32113__$1 = state_32113;
var statearr_32135_33688 = state_32113__$1;
(statearr_32135_33688[(2)] = inst_32087);

(statearr_32135_33688[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32114 === (5))){
var inst_32097 = (state_32113[(2)]);
var state_32113__$1 = (function (){var statearr_32136 = state_32113;
(statearr_32136[(13)] = inst_32097);

return statearr_32136;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32113__$1,(13),dchan);
} else {
if((state_val_32114 === (14))){
var inst_32102 = cljs.core.async.close_BANG_(out);
var state_32113__$1 = state_32113;
var statearr_32137_33689 = state_32113__$1;
(statearr_32137_33689[(2)] = inst_32102);

(statearr_32137_33689[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32114 === (16))){
var inst_32109 = (state_32113[(2)]);
var state_32113__$1 = state_32113;
var statearr_32138_33690 = state_32113__$1;
(statearr_32138_33690[(2)] = inst_32109);

(statearr_32138_33690[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32114 === (10))){
var inst_32074 = (state_32113[(7)]);
var inst_32090 = (state_32113[(2)]);
var inst_32091 = (inst_32074 + (1));
var inst_32074__$1 = inst_32091;
var state_32113__$1 = (function (){var statearr_32139 = state_32113;
(statearr_32139[(7)] = inst_32074__$1);

(statearr_32139[(14)] = inst_32090);

return statearr_32139;
})();
var statearr_32140_33691 = state_32113__$1;
(statearr_32140_33691[(2)] = null);

(statearr_32140_33691[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32114 === (8))){
var inst_32095 = (state_32113[(2)]);
var state_32113__$1 = state_32113;
var statearr_32141_33692 = state_32113__$1;
(statearr_32141_33692[(2)] = inst_32095);

(statearr_32141_33692[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__31034__auto__ = null;
var cljs$core$async$state_machine__31034__auto____0 = (function (){
var statearr_32142 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32142[(0)] = cljs$core$async$state_machine__31034__auto__);

(statearr_32142[(1)] = (1));

return statearr_32142;
});
var cljs$core$async$state_machine__31034__auto____1 = (function (state_32113){
while(true){
var ret_value__31035__auto__ = (function (){try{while(true){
var result__31036__auto__ = switch__31033__auto__(state_32113);
if(cljs.core.keyword_identical_QMARK_(result__31036__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31036__auto__;
}
break;
}
}catch (e32143){var ex__31037__auto__ = e32143;
var statearr_32144_33694 = state_32113;
(statearr_32144_33694[(2)] = ex__31037__auto__);


if(cljs.core.seq((state_32113[(4)]))){
var statearr_32145_33695 = state_32113;
(statearr_32145_33695[(1)] = cljs.core.first((state_32113[(4)])));

} else {
throw ex__31037__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33696 = state_32113;
state_32113 = G__33696;
continue;
} else {
return ret_value__31035__auto__;
}
break;
}
});
cljs$core$async$state_machine__31034__auto__ = function(state_32113){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31034__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31034__auto____1.call(this,state_32113);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31034__auto____0;
cljs$core$async$state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31034__auto____1;
return cljs$core$async$state_machine__31034__auto__;
})()
})();
var state__31071__auto__ = (function (){var statearr_32146 = f__31070__auto__();
(statearr_32146[(6)] = c__31069__auto___33675);

return statearr_32146;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31071__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__32149 = arguments.length;
switch (G__32149) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31069__auto___33698 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31070__auto__ = (function (){var switch__31033__auto__ = (function (state_32181){
var state_val_32182 = (state_32181[(1)]);
if((state_val_32182 === (7))){
var inst_32160 = (state_32181[(7)]);
var inst_32161 = (state_32181[(8)]);
var inst_32160__$1 = (state_32181[(2)]);
var inst_32161__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32160__$1,(0),null);
var inst_32162 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32160__$1,(1),null);
var inst_32163 = (inst_32161__$1 == null);
var state_32181__$1 = (function (){var statearr_32183 = state_32181;
(statearr_32183[(7)] = inst_32160__$1);

(statearr_32183[(8)] = inst_32161__$1);

(statearr_32183[(9)] = inst_32162);

return statearr_32183;
})();
if(cljs.core.truth_(inst_32163)){
var statearr_32184_33700 = state_32181__$1;
(statearr_32184_33700[(1)] = (8));

} else {
var statearr_32185_33702 = state_32181__$1;
(statearr_32185_33702[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32182 === (1))){
var inst_32150 = cljs.core.vec(chs);
var inst_32151 = inst_32150;
var state_32181__$1 = (function (){var statearr_32186 = state_32181;
(statearr_32186[(10)] = inst_32151);

return statearr_32186;
})();
var statearr_32187_33705 = state_32181__$1;
(statearr_32187_33705[(2)] = null);

(statearr_32187_33705[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32182 === (4))){
var inst_32151 = (state_32181[(10)]);
var state_32181__$1 = state_32181;
return cljs.core.async.ioc_alts_BANG_(state_32181__$1,(7),inst_32151);
} else {
if((state_val_32182 === (6))){
var inst_32177 = (state_32181[(2)]);
var state_32181__$1 = state_32181;
var statearr_32188_33706 = state_32181__$1;
(statearr_32188_33706[(2)] = inst_32177);

(statearr_32188_33706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32182 === (3))){
var inst_32179 = (state_32181[(2)]);
var state_32181__$1 = state_32181;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32181__$1,inst_32179);
} else {
if((state_val_32182 === (2))){
var inst_32151 = (state_32181[(10)]);
var inst_32153 = cljs.core.count(inst_32151);
var inst_32154 = (inst_32153 > (0));
var state_32181__$1 = state_32181;
if(cljs.core.truth_(inst_32154)){
var statearr_32190_33708 = state_32181__$1;
(statearr_32190_33708[(1)] = (4));

} else {
var statearr_32191_33709 = state_32181__$1;
(statearr_32191_33709[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32182 === (11))){
var inst_32151 = (state_32181[(10)]);
var inst_32170 = (state_32181[(2)]);
var tmp32189 = inst_32151;
var inst_32151__$1 = tmp32189;
var state_32181__$1 = (function (){var statearr_32192 = state_32181;
(statearr_32192[(11)] = inst_32170);

(statearr_32192[(10)] = inst_32151__$1);

return statearr_32192;
})();
var statearr_32193_33710 = state_32181__$1;
(statearr_32193_33710[(2)] = null);

(statearr_32193_33710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32182 === (9))){
var inst_32161 = (state_32181[(8)]);
var state_32181__$1 = state_32181;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32181__$1,(11),out,inst_32161);
} else {
if((state_val_32182 === (5))){
var inst_32175 = cljs.core.async.close_BANG_(out);
var state_32181__$1 = state_32181;
var statearr_32194_33711 = state_32181__$1;
(statearr_32194_33711[(2)] = inst_32175);

(statearr_32194_33711[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32182 === (10))){
var inst_32173 = (state_32181[(2)]);
var state_32181__$1 = state_32181;
var statearr_32195_33712 = state_32181__$1;
(statearr_32195_33712[(2)] = inst_32173);

(statearr_32195_33712[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32182 === (8))){
var inst_32160 = (state_32181[(7)]);
var inst_32161 = (state_32181[(8)]);
var inst_32162 = (state_32181[(9)]);
var inst_32151 = (state_32181[(10)]);
var inst_32165 = (function (){var cs = inst_32151;
var vec__32156 = inst_32160;
var v = inst_32161;
var c = inst_32162;
return (function (p1__32147_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__32147_SHARP_);
});
})();
var inst_32166 = cljs.core.filterv(inst_32165,inst_32151);
var inst_32151__$1 = inst_32166;
var state_32181__$1 = (function (){var statearr_32196 = state_32181;
(statearr_32196[(10)] = inst_32151__$1);

return statearr_32196;
})();
var statearr_32197_33713 = state_32181__$1;
(statearr_32197_33713[(2)] = null);

(statearr_32197_33713[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__31034__auto__ = null;
var cljs$core$async$state_machine__31034__auto____0 = (function (){
var statearr_32198 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32198[(0)] = cljs$core$async$state_machine__31034__auto__);

(statearr_32198[(1)] = (1));

return statearr_32198;
});
var cljs$core$async$state_machine__31034__auto____1 = (function (state_32181){
while(true){
var ret_value__31035__auto__ = (function (){try{while(true){
var result__31036__auto__ = switch__31033__auto__(state_32181);
if(cljs.core.keyword_identical_QMARK_(result__31036__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31036__auto__;
}
break;
}
}catch (e32199){var ex__31037__auto__ = e32199;
var statearr_32200_33714 = state_32181;
(statearr_32200_33714[(2)] = ex__31037__auto__);


if(cljs.core.seq((state_32181[(4)]))){
var statearr_32201_33715 = state_32181;
(statearr_32201_33715[(1)] = cljs.core.first((state_32181[(4)])));

} else {
throw ex__31037__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33716 = state_32181;
state_32181 = G__33716;
continue;
} else {
return ret_value__31035__auto__;
}
break;
}
});
cljs$core$async$state_machine__31034__auto__ = function(state_32181){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31034__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31034__auto____1.call(this,state_32181);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31034__auto____0;
cljs$core$async$state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31034__auto____1;
return cljs$core$async$state_machine__31034__auto__;
})()
})();
var state__31071__auto__ = (function (){var statearr_32202 = f__31070__auto__();
(statearr_32202[(6)] = c__31069__auto___33698);

return statearr_32202;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31071__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__32204 = arguments.length;
switch (G__32204) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31069__auto___33718 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31070__auto__ = (function (){var switch__31033__auto__ = (function (state_32228){
var state_val_32229 = (state_32228[(1)]);
if((state_val_32229 === (7))){
var inst_32210 = (state_32228[(7)]);
var inst_32210__$1 = (state_32228[(2)]);
var inst_32211 = (inst_32210__$1 == null);
var inst_32212 = cljs.core.not(inst_32211);
var state_32228__$1 = (function (){var statearr_32230 = state_32228;
(statearr_32230[(7)] = inst_32210__$1);

return statearr_32230;
})();
if(inst_32212){
var statearr_32231_33719 = state_32228__$1;
(statearr_32231_33719[(1)] = (8));

} else {
var statearr_32232_33720 = state_32228__$1;
(statearr_32232_33720[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32229 === (1))){
var inst_32205 = (0);
var state_32228__$1 = (function (){var statearr_32233 = state_32228;
(statearr_32233[(8)] = inst_32205);

return statearr_32233;
})();
var statearr_32234_33721 = state_32228__$1;
(statearr_32234_33721[(2)] = null);

(statearr_32234_33721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32229 === (4))){
var state_32228__$1 = state_32228;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32228__$1,(7),ch);
} else {
if((state_val_32229 === (6))){
var inst_32223 = (state_32228[(2)]);
var state_32228__$1 = state_32228;
var statearr_32235_33722 = state_32228__$1;
(statearr_32235_33722[(2)] = inst_32223);

(statearr_32235_33722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32229 === (3))){
var inst_32225 = (state_32228[(2)]);
var inst_32226 = cljs.core.async.close_BANG_(out);
var state_32228__$1 = (function (){var statearr_32236 = state_32228;
(statearr_32236[(9)] = inst_32225);

return statearr_32236;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32228__$1,inst_32226);
} else {
if((state_val_32229 === (2))){
var inst_32205 = (state_32228[(8)]);
var inst_32207 = (inst_32205 < n);
var state_32228__$1 = state_32228;
if(cljs.core.truth_(inst_32207)){
var statearr_32237_33723 = state_32228__$1;
(statearr_32237_33723[(1)] = (4));

} else {
var statearr_32238_33724 = state_32228__$1;
(statearr_32238_33724[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32229 === (11))){
var inst_32205 = (state_32228[(8)]);
var inst_32215 = (state_32228[(2)]);
var inst_32216 = (inst_32205 + (1));
var inst_32205__$1 = inst_32216;
var state_32228__$1 = (function (){var statearr_32239 = state_32228;
(statearr_32239[(10)] = inst_32215);

(statearr_32239[(8)] = inst_32205__$1);

return statearr_32239;
})();
var statearr_32240_33725 = state_32228__$1;
(statearr_32240_33725[(2)] = null);

(statearr_32240_33725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32229 === (9))){
var state_32228__$1 = state_32228;
var statearr_32241_33726 = state_32228__$1;
(statearr_32241_33726[(2)] = null);

(statearr_32241_33726[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32229 === (5))){
var state_32228__$1 = state_32228;
var statearr_32242_33727 = state_32228__$1;
(statearr_32242_33727[(2)] = null);

(statearr_32242_33727[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32229 === (10))){
var inst_32220 = (state_32228[(2)]);
var state_32228__$1 = state_32228;
var statearr_32243_33728 = state_32228__$1;
(statearr_32243_33728[(2)] = inst_32220);

(statearr_32243_33728[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32229 === (8))){
var inst_32210 = (state_32228[(7)]);
var state_32228__$1 = state_32228;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32228__$1,(11),out,inst_32210);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__31034__auto__ = null;
var cljs$core$async$state_machine__31034__auto____0 = (function (){
var statearr_32244 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32244[(0)] = cljs$core$async$state_machine__31034__auto__);

(statearr_32244[(1)] = (1));

return statearr_32244;
});
var cljs$core$async$state_machine__31034__auto____1 = (function (state_32228){
while(true){
var ret_value__31035__auto__ = (function (){try{while(true){
var result__31036__auto__ = switch__31033__auto__(state_32228);
if(cljs.core.keyword_identical_QMARK_(result__31036__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31036__auto__;
}
break;
}
}catch (e32245){var ex__31037__auto__ = e32245;
var statearr_32246_33729 = state_32228;
(statearr_32246_33729[(2)] = ex__31037__auto__);


if(cljs.core.seq((state_32228[(4)]))){
var statearr_32247_33730 = state_32228;
(statearr_32247_33730[(1)] = cljs.core.first((state_32228[(4)])));

} else {
throw ex__31037__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33731 = state_32228;
state_32228 = G__33731;
continue;
} else {
return ret_value__31035__auto__;
}
break;
}
});
cljs$core$async$state_machine__31034__auto__ = function(state_32228){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31034__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31034__auto____1.call(this,state_32228);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31034__auto____0;
cljs$core$async$state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31034__auto____1;
return cljs$core$async$state_machine__31034__auto__;
})()
})();
var state__31071__auto__ = (function (){var statearr_32248 = f__31070__auto__();
(statearr_32248[(6)] = c__31069__auto___33718);

return statearr_32248;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31071__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32250 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32250 = (function (f,ch,meta32251){
this.f = f;
this.ch = ch;
this.meta32251 = meta32251;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32250.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32252,meta32251__$1){
var self__ = this;
var _32252__$1 = this;
return (new cljs.core.async.t_cljs$core$async32250(self__.f,self__.ch,meta32251__$1));
}));

(cljs.core.async.t_cljs$core$async32250.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32252){
var self__ = this;
var _32252__$1 = this;
return self__.meta32251;
}));

(cljs.core.async.t_cljs$core$async32250.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32250.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32250.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32250.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32250.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32253 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32253 = (function (f,ch,meta32251,_,fn1,meta32254){
this.f = f;
this.ch = ch;
this.meta32251 = meta32251;
this._ = _;
this.fn1 = fn1;
this.meta32254 = meta32254;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32253.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32255,meta32254__$1){
var self__ = this;
var _32255__$1 = this;
return (new cljs.core.async.t_cljs$core$async32253(self__.f,self__.ch,self__.meta32251,self__._,self__.fn1,meta32254__$1));
}));

(cljs.core.async.t_cljs$core$async32253.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32255){
var self__ = this;
var _32255__$1 = this;
return self__.meta32254;
}));

(cljs.core.async.t_cljs$core$async32253.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32253.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async32253.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async32253.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__32249_SHARP_){
var G__32256 = (((p1__32249_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__32249_SHARP_) : self__.f.call(null,p1__32249_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__32256) : f1.call(null,G__32256));
});
}));

(cljs.core.async.t_cljs$core$async32253.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32251","meta32251",-1934744391,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async32250","cljs.core.async/t_cljs$core$async32250",1543946668,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta32254","meta32254",-1663629717,null)], null);
}));

(cljs.core.async.t_cljs$core$async32253.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32253.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32253");

(cljs.core.async.t_cljs$core$async32253.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async32253");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32253.
 */
cljs.core.async.__GT_t_cljs$core$async32253 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32253(f__$1,ch__$1,meta32251__$1,___$2,fn1__$1,meta32254){
return (new cljs.core.async.t_cljs$core$async32253(f__$1,ch__$1,meta32251__$1,___$2,fn1__$1,meta32254));
});

}

return (new cljs.core.async.t_cljs$core$async32253(self__.f,self__.ch,self__.meta32251,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__32257 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__32257) : self__.f.call(null,G__32257));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async32250.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32250.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async32250.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32251","meta32251",-1934744391,null)], null);
}));

(cljs.core.async.t_cljs$core$async32250.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32250.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32250");

(cljs.core.async.t_cljs$core$async32250.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async32250");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32250.
 */
cljs.core.async.__GT_t_cljs$core$async32250 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32250(f__$1,ch__$1,meta32251){
return (new cljs.core.async.t_cljs$core$async32250(f__$1,ch__$1,meta32251));
});

}

return (new cljs.core.async.t_cljs$core$async32250(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32258 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32258 = (function (f,ch,meta32259){
this.f = f;
this.ch = ch;
this.meta32259 = meta32259;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32258.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32260,meta32259__$1){
var self__ = this;
var _32260__$1 = this;
return (new cljs.core.async.t_cljs$core$async32258(self__.f,self__.ch,meta32259__$1));
}));

(cljs.core.async.t_cljs$core$async32258.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32260){
var self__ = this;
var _32260__$1 = this;
return self__.meta32259;
}));

(cljs.core.async.t_cljs$core$async32258.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32258.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32258.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32258.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async32258.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32258.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async32258.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32259","meta32259",-450042833,null)], null);
}));

(cljs.core.async.t_cljs$core$async32258.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32258.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32258");

(cljs.core.async.t_cljs$core$async32258.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async32258");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32258.
 */
cljs.core.async.__GT_t_cljs$core$async32258 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async32258(f__$1,ch__$1,meta32259){
return (new cljs.core.async.t_cljs$core$async32258(f__$1,ch__$1,meta32259));
});

}

return (new cljs.core.async.t_cljs$core$async32258(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32261 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32261 = (function (p,ch,meta32262){
this.p = p;
this.ch = ch;
this.meta32262 = meta32262;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32261.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32263,meta32262__$1){
var self__ = this;
var _32263__$1 = this;
return (new cljs.core.async.t_cljs$core$async32261(self__.p,self__.ch,meta32262__$1));
}));

(cljs.core.async.t_cljs$core$async32261.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32263){
var self__ = this;
var _32263__$1 = this;
return self__.meta32262;
}));

(cljs.core.async.t_cljs$core$async32261.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32261.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32261.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32261.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32261.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async32261.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32261.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async32261.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32262","meta32262",-984269054,null)], null);
}));

(cljs.core.async.t_cljs$core$async32261.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32261.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32261");

(cljs.core.async.t_cljs$core$async32261.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async32261");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32261.
 */
cljs.core.async.__GT_t_cljs$core$async32261 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async32261(p__$1,ch__$1,meta32262){
return (new cljs.core.async.t_cljs$core$async32261(p__$1,ch__$1,meta32262));
});

}

return (new cljs.core.async.t_cljs$core$async32261(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__32265 = arguments.length;
switch (G__32265) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31069__auto___33808 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31070__auto__ = (function (){var switch__31033__auto__ = (function (state_32286){
var state_val_32287 = (state_32286[(1)]);
if((state_val_32287 === (7))){
var inst_32282 = (state_32286[(2)]);
var state_32286__$1 = state_32286;
var statearr_32288_33809 = state_32286__$1;
(statearr_32288_33809[(2)] = inst_32282);

(statearr_32288_33809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32287 === (1))){
var state_32286__$1 = state_32286;
var statearr_32289_33810 = state_32286__$1;
(statearr_32289_33810[(2)] = null);

(statearr_32289_33810[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32287 === (4))){
var inst_32268 = (state_32286[(7)]);
var inst_32268__$1 = (state_32286[(2)]);
var inst_32269 = (inst_32268__$1 == null);
var state_32286__$1 = (function (){var statearr_32290 = state_32286;
(statearr_32290[(7)] = inst_32268__$1);

return statearr_32290;
})();
if(cljs.core.truth_(inst_32269)){
var statearr_32291_33811 = state_32286__$1;
(statearr_32291_33811[(1)] = (5));

} else {
var statearr_32292_33812 = state_32286__$1;
(statearr_32292_33812[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32287 === (6))){
var inst_32268 = (state_32286[(7)]);
var inst_32273 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_32268) : p.call(null,inst_32268));
var state_32286__$1 = state_32286;
if(cljs.core.truth_(inst_32273)){
var statearr_32293_33813 = state_32286__$1;
(statearr_32293_33813[(1)] = (8));

} else {
var statearr_32294_33814 = state_32286__$1;
(statearr_32294_33814[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32287 === (3))){
var inst_32284 = (state_32286[(2)]);
var state_32286__$1 = state_32286;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32286__$1,inst_32284);
} else {
if((state_val_32287 === (2))){
var state_32286__$1 = state_32286;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32286__$1,(4),ch);
} else {
if((state_val_32287 === (11))){
var inst_32276 = (state_32286[(2)]);
var state_32286__$1 = state_32286;
var statearr_32295_33815 = state_32286__$1;
(statearr_32295_33815[(2)] = inst_32276);

(statearr_32295_33815[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32287 === (9))){
var state_32286__$1 = state_32286;
var statearr_32296_33816 = state_32286__$1;
(statearr_32296_33816[(2)] = null);

(statearr_32296_33816[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32287 === (5))){
var inst_32271 = cljs.core.async.close_BANG_(out);
var state_32286__$1 = state_32286;
var statearr_32297_33817 = state_32286__$1;
(statearr_32297_33817[(2)] = inst_32271);

(statearr_32297_33817[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32287 === (10))){
var inst_32279 = (state_32286[(2)]);
var state_32286__$1 = (function (){var statearr_32298 = state_32286;
(statearr_32298[(8)] = inst_32279);

return statearr_32298;
})();
var statearr_32299_33818 = state_32286__$1;
(statearr_32299_33818[(2)] = null);

(statearr_32299_33818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32287 === (8))){
var inst_32268 = (state_32286[(7)]);
var state_32286__$1 = state_32286;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32286__$1,(11),out,inst_32268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__31034__auto__ = null;
var cljs$core$async$state_machine__31034__auto____0 = (function (){
var statearr_32300 = [null,null,null,null,null,null,null,null,null];
(statearr_32300[(0)] = cljs$core$async$state_machine__31034__auto__);

(statearr_32300[(1)] = (1));

return statearr_32300;
});
var cljs$core$async$state_machine__31034__auto____1 = (function (state_32286){
while(true){
var ret_value__31035__auto__ = (function (){try{while(true){
var result__31036__auto__ = switch__31033__auto__(state_32286);
if(cljs.core.keyword_identical_QMARK_(result__31036__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31036__auto__;
}
break;
}
}catch (e32301){var ex__31037__auto__ = e32301;
var statearr_32302_33900 = state_32286;
(statearr_32302_33900[(2)] = ex__31037__auto__);


if(cljs.core.seq((state_32286[(4)]))){
var statearr_32303_33901 = state_32286;
(statearr_32303_33901[(1)] = cljs.core.first((state_32286[(4)])));

} else {
throw ex__31037__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33902 = state_32286;
state_32286 = G__33902;
continue;
} else {
return ret_value__31035__auto__;
}
break;
}
});
cljs$core$async$state_machine__31034__auto__ = function(state_32286){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31034__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31034__auto____1.call(this,state_32286);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31034__auto____0;
cljs$core$async$state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31034__auto____1;
return cljs$core$async$state_machine__31034__auto__;
})()
})();
var state__31071__auto__ = (function (){var statearr_32304 = f__31070__auto__();
(statearr_32304[(6)] = c__31069__auto___33808);

return statearr_32304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31071__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__32306 = arguments.length;
switch (G__32306) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__31069__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31070__auto__ = (function (){var switch__31033__auto__ = (function (state_32368){
var state_val_32369 = (state_32368[(1)]);
if((state_val_32369 === (7))){
var inst_32364 = (state_32368[(2)]);
var state_32368__$1 = state_32368;
var statearr_32370_33905 = state_32368__$1;
(statearr_32370_33905[(2)] = inst_32364);

(statearr_32370_33905[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32369 === (20))){
var inst_32334 = (state_32368[(7)]);
var inst_32345 = (state_32368[(2)]);
var inst_32346 = cljs.core.next(inst_32334);
var inst_32320 = inst_32346;
var inst_32321 = null;
var inst_32322 = (0);
var inst_32323 = (0);
var state_32368__$1 = (function (){var statearr_32371 = state_32368;
(statearr_32371[(8)] = inst_32320);

(statearr_32371[(9)] = inst_32345);

(statearr_32371[(10)] = inst_32321);

(statearr_32371[(11)] = inst_32322);

(statearr_32371[(12)] = inst_32323);

return statearr_32371;
})();
var statearr_32372_33906 = state_32368__$1;
(statearr_32372_33906[(2)] = null);

(statearr_32372_33906[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32369 === (1))){
var state_32368__$1 = state_32368;
var statearr_32373_33907 = state_32368__$1;
(statearr_32373_33907[(2)] = null);

(statearr_32373_33907[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32369 === (4))){
var inst_32309 = (state_32368[(13)]);
var inst_32309__$1 = (state_32368[(2)]);
var inst_32310 = (inst_32309__$1 == null);
var state_32368__$1 = (function (){var statearr_32374 = state_32368;
(statearr_32374[(13)] = inst_32309__$1);

return statearr_32374;
})();
if(cljs.core.truth_(inst_32310)){
var statearr_32375_33908 = state_32368__$1;
(statearr_32375_33908[(1)] = (5));

} else {
var statearr_32376_33909 = state_32368__$1;
(statearr_32376_33909[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32369 === (15))){
var state_32368__$1 = state_32368;
var statearr_32380_33910 = state_32368__$1;
(statearr_32380_33910[(2)] = null);

(statearr_32380_33910[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32369 === (21))){
var state_32368__$1 = state_32368;
var statearr_32381_33911 = state_32368__$1;
(statearr_32381_33911[(2)] = null);

(statearr_32381_33911[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32369 === (13))){
var inst_32320 = (state_32368[(8)]);
var inst_32321 = (state_32368[(10)]);
var inst_32322 = (state_32368[(11)]);
var inst_32323 = (state_32368[(12)]);
var inst_32330 = (state_32368[(2)]);
var inst_32331 = (inst_32323 + (1));
var tmp32377 = inst_32320;
var tmp32378 = inst_32321;
var tmp32379 = inst_32322;
var inst_32320__$1 = tmp32377;
var inst_32321__$1 = tmp32378;
var inst_32322__$1 = tmp32379;
var inst_32323__$1 = inst_32331;
var state_32368__$1 = (function (){var statearr_32382 = state_32368;
(statearr_32382[(8)] = inst_32320__$1);

(statearr_32382[(14)] = inst_32330);

(statearr_32382[(10)] = inst_32321__$1);

(statearr_32382[(11)] = inst_32322__$1);

(statearr_32382[(12)] = inst_32323__$1);

return statearr_32382;
})();
var statearr_32383_33912 = state_32368__$1;
(statearr_32383_33912[(2)] = null);

(statearr_32383_33912[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32369 === (22))){
var state_32368__$1 = state_32368;
var statearr_32384_33913 = state_32368__$1;
(statearr_32384_33913[(2)] = null);

(statearr_32384_33913[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32369 === (6))){
var inst_32309 = (state_32368[(13)]);
var inst_32318 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_32309) : f.call(null,inst_32309));
var inst_32319 = cljs.core.seq(inst_32318);
var inst_32320 = inst_32319;
var inst_32321 = null;
var inst_32322 = (0);
var inst_32323 = (0);
var state_32368__$1 = (function (){var statearr_32385 = state_32368;
(statearr_32385[(8)] = inst_32320);

(statearr_32385[(10)] = inst_32321);

(statearr_32385[(11)] = inst_32322);

(statearr_32385[(12)] = inst_32323);

return statearr_32385;
})();
var statearr_32386_33914 = state_32368__$1;
(statearr_32386_33914[(2)] = null);

(statearr_32386_33914[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32369 === (17))){
var inst_32334 = (state_32368[(7)]);
var inst_32338 = cljs.core.chunk_first(inst_32334);
var inst_32339 = cljs.core.chunk_rest(inst_32334);
var inst_32340 = cljs.core.count(inst_32338);
var inst_32320 = inst_32339;
var inst_32321 = inst_32338;
var inst_32322 = inst_32340;
var inst_32323 = (0);
var state_32368__$1 = (function (){var statearr_32387 = state_32368;
(statearr_32387[(8)] = inst_32320);

(statearr_32387[(10)] = inst_32321);

(statearr_32387[(11)] = inst_32322);

(statearr_32387[(12)] = inst_32323);

return statearr_32387;
})();
var statearr_32388_33915 = state_32368__$1;
(statearr_32388_33915[(2)] = null);

(statearr_32388_33915[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32369 === (3))){
var inst_32366 = (state_32368[(2)]);
var state_32368__$1 = state_32368;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32368__$1,inst_32366);
} else {
if((state_val_32369 === (12))){
var inst_32354 = (state_32368[(2)]);
var state_32368__$1 = state_32368;
var statearr_32389_33917 = state_32368__$1;
(statearr_32389_33917[(2)] = inst_32354);

(statearr_32389_33917[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32369 === (2))){
var state_32368__$1 = state_32368;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32368__$1,(4),in$);
} else {
if((state_val_32369 === (23))){
var inst_32362 = (state_32368[(2)]);
var state_32368__$1 = state_32368;
var statearr_32390_33928 = state_32368__$1;
(statearr_32390_33928[(2)] = inst_32362);

(statearr_32390_33928[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32369 === (19))){
var inst_32349 = (state_32368[(2)]);
var state_32368__$1 = state_32368;
var statearr_32391_33940 = state_32368__$1;
(statearr_32391_33940[(2)] = inst_32349);

(statearr_32391_33940[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32369 === (11))){
var inst_32320 = (state_32368[(8)]);
var inst_32334 = (state_32368[(7)]);
var inst_32334__$1 = cljs.core.seq(inst_32320);
var state_32368__$1 = (function (){var statearr_32392 = state_32368;
(statearr_32392[(7)] = inst_32334__$1);

return statearr_32392;
})();
if(inst_32334__$1){
var statearr_32393_33958 = state_32368__$1;
(statearr_32393_33958[(1)] = (14));

} else {
var statearr_32394_33963 = state_32368__$1;
(statearr_32394_33963[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32369 === (9))){
var inst_32356 = (state_32368[(2)]);
var inst_32357 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_32368__$1 = (function (){var statearr_32395 = state_32368;
(statearr_32395[(15)] = inst_32356);

return statearr_32395;
})();
if(cljs.core.truth_(inst_32357)){
var statearr_32396_33978 = state_32368__$1;
(statearr_32396_33978[(1)] = (21));

} else {
var statearr_32397_33983 = state_32368__$1;
(statearr_32397_33983[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32369 === (5))){
var inst_32312 = cljs.core.async.close_BANG_(out);
var state_32368__$1 = state_32368;
var statearr_32398_33993 = state_32368__$1;
(statearr_32398_33993[(2)] = inst_32312);

(statearr_32398_33993[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32369 === (14))){
var inst_32334 = (state_32368[(7)]);
var inst_32336 = cljs.core.chunked_seq_QMARK_(inst_32334);
var state_32368__$1 = state_32368;
if(inst_32336){
var statearr_32399_34003 = state_32368__$1;
(statearr_32399_34003[(1)] = (17));

} else {
var statearr_32400_34004 = state_32368__$1;
(statearr_32400_34004[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32369 === (16))){
var inst_32352 = (state_32368[(2)]);
var state_32368__$1 = state_32368;
var statearr_32401_34006 = state_32368__$1;
(statearr_32401_34006[(2)] = inst_32352);

(statearr_32401_34006[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32369 === (10))){
var inst_32321 = (state_32368[(10)]);
var inst_32323 = (state_32368[(12)]);
var inst_32328 = cljs.core._nth(inst_32321,inst_32323);
var state_32368__$1 = state_32368;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32368__$1,(13),out,inst_32328);
} else {
if((state_val_32369 === (18))){
var inst_32334 = (state_32368[(7)]);
var inst_32343 = cljs.core.first(inst_32334);
var state_32368__$1 = state_32368;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32368__$1,(20),out,inst_32343);
} else {
if((state_val_32369 === (8))){
var inst_32322 = (state_32368[(11)]);
var inst_32323 = (state_32368[(12)]);
var inst_32325 = (inst_32323 < inst_32322);
var inst_32326 = inst_32325;
var state_32368__$1 = state_32368;
if(cljs.core.truth_(inst_32326)){
var statearr_32402_34008 = state_32368__$1;
(statearr_32402_34008[(1)] = (10));

} else {
var statearr_32403_34009 = state_32368__$1;
(statearr_32403_34009[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__31034__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__31034__auto____0 = (function (){
var statearr_32404 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32404[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__31034__auto__);

(statearr_32404[(1)] = (1));

return statearr_32404;
});
var cljs$core$async$mapcat_STAR__$_state_machine__31034__auto____1 = (function (state_32368){
while(true){
var ret_value__31035__auto__ = (function (){try{while(true){
var result__31036__auto__ = switch__31033__auto__(state_32368);
if(cljs.core.keyword_identical_QMARK_(result__31036__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31036__auto__;
}
break;
}
}catch (e32405){var ex__31037__auto__ = e32405;
var statearr_32406_34010 = state_32368;
(statearr_32406_34010[(2)] = ex__31037__auto__);


if(cljs.core.seq((state_32368[(4)]))){
var statearr_32407_34011 = state_32368;
(statearr_32407_34011[(1)] = cljs.core.first((state_32368[(4)])));

} else {
throw ex__31037__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34012 = state_32368;
state_32368 = G__34012;
continue;
} else {
return ret_value__31035__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__31034__auto__ = function(state_32368){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__31034__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__31034__auto____1.call(this,state_32368);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__31034__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__31034__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__31034__auto__;
})()
})();
var state__31071__auto__ = (function (){var statearr_32408 = f__31070__auto__();
(statearr_32408[(6)] = c__31069__auto__);

return statearr_32408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31071__auto__);
}));

return c__31069__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__32410 = arguments.length;
switch (G__32410) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__32412 = arguments.length;
switch (G__32412) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__32414 = arguments.length;
switch (G__32414) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31069__auto___34016 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31070__auto__ = (function (){var switch__31033__auto__ = (function (state_32438){
var state_val_32439 = (state_32438[(1)]);
if((state_val_32439 === (7))){
var inst_32433 = (state_32438[(2)]);
var state_32438__$1 = state_32438;
var statearr_32440_34017 = state_32438__$1;
(statearr_32440_34017[(2)] = inst_32433);

(statearr_32440_34017[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32439 === (1))){
var inst_32415 = null;
var state_32438__$1 = (function (){var statearr_32441 = state_32438;
(statearr_32441[(7)] = inst_32415);

return statearr_32441;
})();
var statearr_32442_34018 = state_32438__$1;
(statearr_32442_34018[(2)] = null);

(statearr_32442_34018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32439 === (4))){
var inst_32418 = (state_32438[(8)]);
var inst_32418__$1 = (state_32438[(2)]);
var inst_32419 = (inst_32418__$1 == null);
var inst_32420 = cljs.core.not(inst_32419);
var state_32438__$1 = (function (){var statearr_32443 = state_32438;
(statearr_32443[(8)] = inst_32418__$1);

return statearr_32443;
})();
if(inst_32420){
var statearr_32444_34019 = state_32438__$1;
(statearr_32444_34019[(1)] = (5));

} else {
var statearr_32445_34020 = state_32438__$1;
(statearr_32445_34020[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32439 === (6))){
var state_32438__$1 = state_32438;
var statearr_32446_34021 = state_32438__$1;
(statearr_32446_34021[(2)] = null);

(statearr_32446_34021[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32439 === (3))){
var inst_32435 = (state_32438[(2)]);
var inst_32436 = cljs.core.async.close_BANG_(out);
var state_32438__$1 = (function (){var statearr_32447 = state_32438;
(statearr_32447[(9)] = inst_32435);

return statearr_32447;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32438__$1,inst_32436);
} else {
if((state_val_32439 === (2))){
var state_32438__$1 = state_32438;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32438__$1,(4),ch);
} else {
if((state_val_32439 === (11))){
var inst_32418 = (state_32438[(8)]);
var inst_32427 = (state_32438[(2)]);
var inst_32415 = inst_32418;
var state_32438__$1 = (function (){var statearr_32448 = state_32438;
(statearr_32448[(7)] = inst_32415);

(statearr_32448[(10)] = inst_32427);

return statearr_32448;
})();
var statearr_32449_34022 = state_32438__$1;
(statearr_32449_34022[(2)] = null);

(statearr_32449_34022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32439 === (9))){
var inst_32418 = (state_32438[(8)]);
var state_32438__$1 = state_32438;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32438__$1,(11),out,inst_32418);
} else {
if((state_val_32439 === (5))){
var inst_32418 = (state_32438[(8)]);
var inst_32415 = (state_32438[(7)]);
var inst_32422 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32418,inst_32415);
var state_32438__$1 = state_32438;
if(inst_32422){
var statearr_32451_34023 = state_32438__$1;
(statearr_32451_34023[(1)] = (8));

} else {
var statearr_32452_34024 = state_32438__$1;
(statearr_32452_34024[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32439 === (10))){
var inst_32430 = (state_32438[(2)]);
var state_32438__$1 = state_32438;
var statearr_32453_34025 = state_32438__$1;
(statearr_32453_34025[(2)] = inst_32430);

(statearr_32453_34025[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32439 === (8))){
var inst_32415 = (state_32438[(7)]);
var tmp32450 = inst_32415;
var inst_32415__$1 = tmp32450;
var state_32438__$1 = (function (){var statearr_32454 = state_32438;
(statearr_32454[(7)] = inst_32415__$1);

return statearr_32454;
})();
var statearr_32455_34026 = state_32438__$1;
(statearr_32455_34026[(2)] = null);

(statearr_32455_34026[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__31034__auto__ = null;
var cljs$core$async$state_machine__31034__auto____0 = (function (){
var statearr_32456 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32456[(0)] = cljs$core$async$state_machine__31034__auto__);

(statearr_32456[(1)] = (1));

return statearr_32456;
});
var cljs$core$async$state_machine__31034__auto____1 = (function (state_32438){
while(true){
var ret_value__31035__auto__ = (function (){try{while(true){
var result__31036__auto__ = switch__31033__auto__(state_32438);
if(cljs.core.keyword_identical_QMARK_(result__31036__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31036__auto__;
}
break;
}
}catch (e32457){var ex__31037__auto__ = e32457;
var statearr_32458_34027 = state_32438;
(statearr_32458_34027[(2)] = ex__31037__auto__);


if(cljs.core.seq((state_32438[(4)]))){
var statearr_32459_34028 = state_32438;
(statearr_32459_34028[(1)] = cljs.core.first((state_32438[(4)])));

} else {
throw ex__31037__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34029 = state_32438;
state_32438 = G__34029;
continue;
} else {
return ret_value__31035__auto__;
}
break;
}
});
cljs$core$async$state_machine__31034__auto__ = function(state_32438){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31034__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31034__auto____1.call(this,state_32438);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31034__auto____0;
cljs$core$async$state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31034__auto____1;
return cljs$core$async$state_machine__31034__auto__;
})()
})();
var state__31071__auto__ = (function (){var statearr_32460 = f__31070__auto__();
(statearr_32460[(6)] = c__31069__auto___34016);

return statearr_32460;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31071__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__32462 = arguments.length;
switch (G__32462) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31069__auto___34031 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31070__auto__ = (function (){var switch__31033__auto__ = (function (state_32500){
var state_val_32501 = (state_32500[(1)]);
if((state_val_32501 === (7))){
var inst_32496 = (state_32500[(2)]);
var state_32500__$1 = state_32500;
var statearr_32502_34032 = state_32500__$1;
(statearr_32502_34032[(2)] = inst_32496);

(statearr_32502_34032[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32501 === (1))){
var inst_32463 = (new Array(n));
var inst_32464 = inst_32463;
var inst_32465 = (0);
var state_32500__$1 = (function (){var statearr_32503 = state_32500;
(statearr_32503[(7)] = inst_32465);

(statearr_32503[(8)] = inst_32464);

return statearr_32503;
})();
var statearr_32504_34033 = state_32500__$1;
(statearr_32504_34033[(2)] = null);

(statearr_32504_34033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32501 === (4))){
var inst_32468 = (state_32500[(9)]);
var inst_32468__$1 = (state_32500[(2)]);
var inst_32469 = (inst_32468__$1 == null);
var inst_32470 = cljs.core.not(inst_32469);
var state_32500__$1 = (function (){var statearr_32505 = state_32500;
(statearr_32505[(9)] = inst_32468__$1);

return statearr_32505;
})();
if(inst_32470){
var statearr_32506_34034 = state_32500__$1;
(statearr_32506_34034[(1)] = (5));

} else {
var statearr_32507_34035 = state_32500__$1;
(statearr_32507_34035[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32501 === (15))){
var inst_32490 = (state_32500[(2)]);
var state_32500__$1 = state_32500;
var statearr_32508_34036 = state_32500__$1;
(statearr_32508_34036[(2)] = inst_32490);

(statearr_32508_34036[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32501 === (13))){
var state_32500__$1 = state_32500;
var statearr_32509_34037 = state_32500__$1;
(statearr_32509_34037[(2)] = null);

(statearr_32509_34037[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32501 === (6))){
var inst_32465 = (state_32500[(7)]);
var inst_32486 = (inst_32465 > (0));
var state_32500__$1 = state_32500;
if(cljs.core.truth_(inst_32486)){
var statearr_32510_34038 = state_32500__$1;
(statearr_32510_34038[(1)] = (12));

} else {
var statearr_32511_34039 = state_32500__$1;
(statearr_32511_34039[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32501 === (3))){
var inst_32498 = (state_32500[(2)]);
var state_32500__$1 = state_32500;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32500__$1,inst_32498);
} else {
if((state_val_32501 === (12))){
var inst_32464 = (state_32500[(8)]);
var inst_32488 = cljs.core.vec(inst_32464);
var state_32500__$1 = state_32500;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32500__$1,(15),out,inst_32488);
} else {
if((state_val_32501 === (2))){
var state_32500__$1 = state_32500;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32500__$1,(4),ch);
} else {
if((state_val_32501 === (11))){
var inst_32480 = (state_32500[(2)]);
var inst_32481 = (new Array(n));
var inst_32464 = inst_32481;
var inst_32465 = (0);
var state_32500__$1 = (function (){var statearr_32512 = state_32500;
(statearr_32512[(7)] = inst_32465);

(statearr_32512[(8)] = inst_32464);

(statearr_32512[(10)] = inst_32480);

return statearr_32512;
})();
var statearr_32513_34040 = state_32500__$1;
(statearr_32513_34040[(2)] = null);

(statearr_32513_34040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32501 === (9))){
var inst_32464 = (state_32500[(8)]);
var inst_32478 = cljs.core.vec(inst_32464);
var state_32500__$1 = state_32500;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32500__$1,(11),out,inst_32478);
} else {
if((state_val_32501 === (5))){
var inst_32465 = (state_32500[(7)]);
var inst_32468 = (state_32500[(9)]);
var inst_32464 = (state_32500[(8)]);
var inst_32473 = (state_32500[(11)]);
var inst_32472 = (inst_32464[inst_32465] = inst_32468);
var inst_32473__$1 = (inst_32465 + (1));
var inst_32474 = (inst_32473__$1 < n);
var state_32500__$1 = (function (){var statearr_32514 = state_32500;
(statearr_32514[(11)] = inst_32473__$1);

(statearr_32514[(12)] = inst_32472);

return statearr_32514;
})();
if(cljs.core.truth_(inst_32474)){
var statearr_32515_34041 = state_32500__$1;
(statearr_32515_34041[(1)] = (8));

} else {
var statearr_32516_34042 = state_32500__$1;
(statearr_32516_34042[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32501 === (14))){
var inst_32493 = (state_32500[(2)]);
var inst_32494 = cljs.core.async.close_BANG_(out);
var state_32500__$1 = (function (){var statearr_32518 = state_32500;
(statearr_32518[(13)] = inst_32493);

return statearr_32518;
})();
var statearr_32519_34043 = state_32500__$1;
(statearr_32519_34043[(2)] = inst_32494);

(statearr_32519_34043[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32501 === (10))){
var inst_32484 = (state_32500[(2)]);
var state_32500__$1 = state_32500;
var statearr_32520_34044 = state_32500__$1;
(statearr_32520_34044[(2)] = inst_32484);

(statearr_32520_34044[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32501 === (8))){
var inst_32464 = (state_32500[(8)]);
var inst_32473 = (state_32500[(11)]);
var tmp32517 = inst_32464;
var inst_32464__$1 = tmp32517;
var inst_32465 = inst_32473;
var state_32500__$1 = (function (){var statearr_32521 = state_32500;
(statearr_32521[(7)] = inst_32465);

(statearr_32521[(8)] = inst_32464__$1);

return statearr_32521;
})();
var statearr_32522_34045 = state_32500__$1;
(statearr_32522_34045[(2)] = null);

(statearr_32522_34045[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__31034__auto__ = null;
var cljs$core$async$state_machine__31034__auto____0 = (function (){
var statearr_32523 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32523[(0)] = cljs$core$async$state_machine__31034__auto__);

(statearr_32523[(1)] = (1));

return statearr_32523;
});
var cljs$core$async$state_machine__31034__auto____1 = (function (state_32500){
while(true){
var ret_value__31035__auto__ = (function (){try{while(true){
var result__31036__auto__ = switch__31033__auto__(state_32500);
if(cljs.core.keyword_identical_QMARK_(result__31036__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31036__auto__;
}
break;
}
}catch (e32524){var ex__31037__auto__ = e32524;
var statearr_32525_34046 = state_32500;
(statearr_32525_34046[(2)] = ex__31037__auto__);


if(cljs.core.seq((state_32500[(4)]))){
var statearr_32526_34047 = state_32500;
(statearr_32526_34047[(1)] = cljs.core.first((state_32500[(4)])));

} else {
throw ex__31037__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34048 = state_32500;
state_32500 = G__34048;
continue;
} else {
return ret_value__31035__auto__;
}
break;
}
});
cljs$core$async$state_machine__31034__auto__ = function(state_32500){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31034__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31034__auto____1.call(this,state_32500);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31034__auto____0;
cljs$core$async$state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31034__auto____1;
return cljs$core$async$state_machine__31034__auto__;
})()
})();
var state__31071__auto__ = (function (){var statearr_32527 = f__31070__auto__();
(statearr_32527[(6)] = c__31069__auto___34031);

return statearr_32527;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31071__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__32529 = arguments.length;
switch (G__32529) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31069__auto___34050 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31070__auto__ = (function (){var switch__31033__auto__ = (function (state_32571){
var state_val_32572 = (state_32571[(1)]);
if((state_val_32572 === (7))){
var inst_32567 = (state_32571[(2)]);
var state_32571__$1 = state_32571;
var statearr_32573_34051 = state_32571__$1;
(statearr_32573_34051[(2)] = inst_32567);

(statearr_32573_34051[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32572 === (1))){
var inst_32530 = [];
var inst_32531 = inst_32530;
var inst_32532 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_32571__$1 = (function (){var statearr_32574 = state_32571;
(statearr_32574[(7)] = inst_32532);

(statearr_32574[(8)] = inst_32531);

return statearr_32574;
})();
var statearr_32575_34052 = state_32571__$1;
(statearr_32575_34052[(2)] = null);

(statearr_32575_34052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32572 === (4))){
var inst_32535 = (state_32571[(9)]);
var inst_32535__$1 = (state_32571[(2)]);
var inst_32536 = (inst_32535__$1 == null);
var inst_32537 = cljs.core.not(inst_32536);
var state_32571__$1 = (function (){var statearr_32576 = state_32571;
(statearr_32576[(9)] = inst_32535__$1);

return statearr_32576;
})();
if(inst_32537){
var statearr_32577_34053 = state_32571__$1;
(statearr_32577_34053[(1)] = (5));

} else {
var statearr_32578_34054 = state_32571__$1;
(statearr_32578_34054[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32572 === (15))){
var inst_32561 = (state_32571[(2)]);
var state_32571__$1 = state_32571;
var statearr_32579_34055 = state_32571__$1;
(statearr_32579_34055[(2)] = inst_32561);

(statearr_32579_34055[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32572 === (13))){
var state_32571__$1 = state_32571;
var statearr_32580_34056 = state_32571__$1;
(statearr_32580_34056[(2)] = null);

(statearr_32580_34056[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32572 === (6))){
var inst_32531 = (state_32571[(8)]);
var inst_32556 = inst_32531.length;
var inst_32557 = (inst_32556 > (0));
var state_32571__$1 = state_32571;
if(cljs.core.truth_(inst_32557)){
var statearr_32581_34057 = state_32571__$1;
(statearr_32581_34057[(1)] = (12));

} else {
var statearr_32582_34058 = state_32571__$1;
(statearr_32582_34058[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32572 === (3))){
var inst_32569 = (state_32571[(2)]);
var state_32571__$1 = state_32571;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32571__$1,inst_32569);
} else {
if((state_val_32572 === (12))){
var inst_32531 = (state_32571[(8)]);
var inst_32559 = cljs.core.vec(inst_32531);
var state_32571__$1 = state_32571;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32571__$1,(15),out,inst_32559);
} else {
if((state_val_32572 === (2))){
var state_32571__$1 = state_32571;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32571__$1,(4),ch);
} else {
if((state_val_32572 === (11))){
var inst_32539 = (state_32571[(10)]);
var inst_32535 = (state_32571[(9)]);
var inst_32549 = (state_32571[(2)]);
var inst_32550 = [];
var inst_32551 = inst_32550.push(inst_32535);
var inst_32531 = inst_32550;
var inst_32532 = inst_32539;
var state_32571__$1 = (function (){var statearr_32583 = state_32571;
(statearr_32583[(11)] = inst_32549);

(statearr_32583[(12)] = inst_32551);

(statearr_32583[(7)] = inst_32532);

(statearr_32583[(8)] = inst_32531);

return statearr_32583;
})();
var statearr_32584_34059 = state_32571__$1;
(statearr_32584_34059[(2)] = null);

(statearr_32584_34059[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32572 === (9))){
var inst_32531 = (state_32571[(8)]);
var inst_32547 = cljs.core.vec(inst_32531);
var state_32571__$1 = state_32571;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32571__$1,(11),out,inst_32547);
} else {
if((state_val_32572 === (5))){
var inst_32539 = (state_32571[(10)]);
var inst_32532 = (state_32571[(7)]);
var inst_32535 = (state_32571[(9)]);
var inst_32539__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_32535) : f.call(null,inst_32535));
var inst_32540 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32539__$1,inst_32532);
var inst_32541 = cljs.core.keyword_identical_QMARK_(inst_32532,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_32542 = ((inst_32540) || (inst_32541));
var state_32571__$1 = (function (){var statearr_32585 = state_32571;
(statearr_32585[(10)] = inst_32539__$1);

return statearr_32585;
})();
if(cljs.core.truth_(inst_32542)){
var statearr_32586_34060 = state_32571__$1;
(statearr_32586_34060[(1)] = (8));

} else {
var statearr_32587_34062 = state_32571__$1;
(statearr_32587_34062[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32572 === (14))){
var inst_32564 = (state_32571[(2)]);
var inst_32565 = cljs.core.async.close_BANG_(out);
var state_32571__$1 = (function (){var statearr_32589 = state_32571;
(statearr_32589[(13)] = inst_32564);

return statearr_32589;
})();
var statearr_32590_34063 = state_32571__$1;
(statearr_32590_34063[(2)] = inst_32565);

(statearr_32590_34063[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32572 === (10))){
var inst_32554 = (state_32571[(2)]);
var state_32571__$1 = state_32571;
var statearr_32591_34064 = state_32571__$1;
(statearr_32591_34064[(2)] = inst_32554);

(statearr_32591_34064[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32572 === (8))){
var inst_32539 = (state_32571[(10)]);
var inst_32535 = (state_32571[(9)]);
var inst_32531 = (state_32571[(8)]);
var inst_32544 = inst_32531.push(inst_32535);
var tmp32588 = inst_32531;
var inst_32531__$1 = tmp32588;
var inst_32532 = inst_32539;
var state_32571__$1 = (function (){var statearr_32592 = state_32571;
(statearr_32592[(14)] = inst_32544);

(statearr_32592[(7)] = inst_32532);

(statearr_32592[(8)] = inst_32531__$1);

return statearr_32592;
})();
var statearr_32593_34065 = state_32571__$1;
(statearr_32593_34065[(2)] = null);

(statearr_32593_34065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__31034__auto__ = null;
var cljs$core$async$state_machine__31034__auto____0 = (function (){
var statearr_32594 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32594[(0)] = cljs$core$async$state_machine__31034__auto__);

(statearr_32594[(1)] = (1));

return statearr_32594;
});
var cljs$core$async$state_machine__31034__auto____1 = (function (state_32571){
while(true){
var ret_value__31035__auto__ = (function (){try{while(true){
var result__31036__auto__ = switch__31033__auto__(state_32571);
if(cljs.core.keyword_identical_QMARK_(result__31036__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31036__auto__;
}
break;
}
}catch (e32595){var ex__31037__auto__ = e32595;
var statearr_32596_34066 = state_32571;
(statearr_32596_34066[(2)] = ex__31037__auto__);


if(cljs.core.seq((state_32571[(4)]))){
var statearr_32597_34067 = state_32571;
(statearr_32597_34067[(1)] = cljs.core.first((state_32571[(4)])));

} else {
throw ex__31037__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34068 = state_32571;
state_32571 = G__34068;
continue;
} else {
return ret_value__31035__auto__;
}
break;
}
});
cljs$core$async$state_machine__31034__auto__ = function(state_32571){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31034__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31034__auto____1.call(this,state_32571);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31034__auto____0;
cljs$core$async$state_machine__31034__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31034__auto____1;
return cljs$core$async$state_machine__31034__auto__;
})()
})();
var state__31071__auto__ = (function (){var statearr_32598 = f__31070__auto__();
(statearr_32598[(6)] = c__31069__auto___34050);

return statearr_32598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31071__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
