goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR__orig_val__28178 = re_frame.trace._STAR_current_trace_STAR_;
var _STAR_current_trace_STAR__temp_val__28179 = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));
(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__temp_val__28179);

try{try{var seq__28180 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__28181 = null;
var count__28182 = (0);
var i__28183 = (0);
while(true){
if((i__28183 < count__28182)){
var vec__28190 = chunk__28181.cljs$core$IIndexed$_nth$arity$2(null,i__28183);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28190,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28190,(1),null);
var temp__5733__auto___28242 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___28242)){
var effect_fn_28243 = temp__5733__auto___28242;
(effect_fn_28243.cljs$core$IFn$_invoke$arity$1 ? effect_fn_28243.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_28243.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__28244 = seq__28180;
var G__28245 = chunk__28181;
var G__28246 = count__28182;
var G__28247 = (i__28183 + (1));
seq__28180 = G__28244;
chunk__28181 = G__28245;
count__28182 = G__28246;
i__28183 = G__28247;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28180);
if(temp__5735__auto__){
var seq__28180__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28180__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28180__$1);
var G__28248 = cljs.core.chunk_rest(seq__28180__$1);
var G__28249 = c__4556__auto__;
var G__28250 = cljs.core.count(c__4556__auto__);
var G__28251 = (0);
seq__28180 = G__28248;
chunk__28181 = G__28249;
count__28182 = G__28250;
i__28183 = G__28251;
continue;
} else {
var vec__28194 = cljs.core.first(seq__28180__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28194,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28194,(1),null);
var temp__5733__auto___28252 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___28252)){
var effect_fn_28253 = temp__5733__auto___28252;
(effect_fn_28253.cljs$core$IFn$_invoke$arity$1 ? effect_fn_28253.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_28253.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__28254 = cljs.core.next(seq__28180__$1);
var G__28255 = null;
var G__28256 = (0);
var G__28257 = (0);
seq__28180 = G__28254;
chunk__28181 = G__28255;
count__28182 = G__28256;
i__28183 = G__28257;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__27882__auto___28258 = re_frame.interop.now();
var duration__27883__auto___28259 = (end__27882__auto___28258 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__27883__auto___28259,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__27882__auto___28258);
} else {
}
}}finally {(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__orig_val__28178);
}} else {
var seq__28197 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__28198 = null;
var count__28199 = (0);
var i__28200 = (0);
while(true){
if((i__28200 < count__28199)){
var vec__28207 = chunk__28198.cljs$core$IIndexed$_nth$arity$2(null,i__28200);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28207,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28207,(1),null);
var temp__5733__auto___28260 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___28260)){
var effect_fn_28261 = temp__5733__auto___28260;
(effect_fn_28261.cljs$core$IFn$_invoke$arity$1 ? effect_fn_28261.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_28261.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__28262 = seq__28197;
var G__28263 = chunk__28198;
var G__28264 = count__28199;
var G__28265 = (i__28200 + (1));
seq__28197 = G__28262;
chunk__28198 = G__28263;
count__28199 = G__28264;
i__28200 = G__28265;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28197);
if(temp__5735__auto__){
var seq__28197__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28197__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28197__$1);
var G__28266 = cljs.core.chunk_rest(seq__28197__$1);
var G__28267 = c__4556__auto__;
var G__28268 = cljs.core.count(c__4556__auto__);
var G__28269 = (0);
seq__28197 = G__28266;
chunk__28198 = G__28267;
count__28199 = G__28268;
i__28200 = G__28269;
continue;
} else {
var vec__28210 = cljs.core.first(seq__28197__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28210,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28210,(1),null);
var temp__5733__auto___28270 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___28270)){
var effect_fn_28271 = temp__5733__auto___28270;
(effect_fn_28271.cljs$core$IFn$_invoke$arity$1 ? effect_fn_28271.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_28271.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__28272 = cljs.core.next(seq__28197__$1);
var G__28273 = null;
var G__28274 = (0);
var G__28275 = (0);
seq__28197 = G__28272;
chunk__28198 = G__28273;
count__28199 = G__28274;
i__28200 = G__28275;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__28213 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__28214 = null;
var count__28215 = (0);
var i__28216 = (0);
while(true){
if((i__28216 < count__28215)){
var map__28221 = chunk__28214.cljs$core$IIndexed$_nth$arity$2(null,i__28216);
var map__28221__$1 = (((((!((map__28221 == null))))?(((((map__28221.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28221.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28221):map__28221);
var effect = map__28221__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28221__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28221__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__28213,chunk__28214,count__28215,i__28216,map__28221,map__28221__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__28213,chunk__28214,count__28215,i__28216,map__28221,map__28221__$1,effect,ms,dispatch))
,ms);
}


var G__28276 = seq__28213;
var G__28277 = chunk__28214;
var G__28278 = count__28215;
var G__28279 = (i__28216 + (1));
seq__28213 = G__28276;
chunk__28214 = G__28277;
count__28215 = G__28278;
i__28216 = G__28279;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28213);
if(temp__5735__auto__){
var seq__28213__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28213__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28213__$1);
var G__28282 = cljs.core.chunk_rest(seq__28213__$1);
var G__28283 = c__4556__auto__;
var G__28284 = cljs.core.count(c__4556__auto__);
var G__28285 = (0);
seq__28213 = G__28282;
chunk__28214 = G__28283;
count__28215 = G__28284;
i__28216 = G__28285;
continue;
} else {
var map__28223 = cljs.core.first(seq__28213__$1);
var map__28223__$1 = (((((!((map__28223 == null))))?(((((map__28223.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28223.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28223):map__28223);
var effect = map__28223__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28223__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28223__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__28213,chunk__28214,count__28215,i__28216,map__28223,map__28223__$1,effect,ms,dispatch,seq__28213__$1,temp__5735__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__28213,chunk__28214,count__28215,i__28216,map__28223,map__28223__$1,effect,ms,dispatch,seq__28213__$1,temp__5735__auto__))
,ms);
}


var G__28287 = cljs.core.next(seq__28213__$1);
var G__28288 = null;
var G__28289 = (0);
var G__28290 = (0);
seq__28213 = G__28287;
chunk__28214 = G__28288;
count__28215 = G__28289;
i__28216 = G__28290;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if((!(cljs.core.vector_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if((!(cljs.core.sequential_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value], 0));
} else {
var seq__28225 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__28226 = null;
var count__28227 = (0);
var i__28228 = (0);
while(true){
if((i__28228 < count__28227)){
var event = chunk__28226.cljs$core$IIndexed$_nth$arity$2(null,i__28228);
re_frame.router.dispatch(event);


var G__28291 = seq__28225;
var G__28292 = chunk__28226;
var G__28293 = count__28227;
var G__28294 = (i__28228 + (1));
seq__28225 = G__28291;
chunk__28226 = G__28292;
count__28227 = G__28293;
i__28228 = G__28294;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28225);
if(temp__5735__auto__){
var seq__28225__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28225__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28225__$1);
var G__28298 = cljs.core.chunk_rest(seq__28225__$1);
var G__28299 = c__4556__auto__;
var G__28300 = cljs.core.count(c__4556__auto__);
var G__28301 = (0);
seq__28225 = G__28298;
chunk__28226 = G__28299;
count__28227 = G__28300;
i__28228 = G__28301;
continue;
} else {
var event = cljs.core.first(seq__28225__$1);
re_frame.router.dispatch(event);


var G__28302 = cljs.core.next(seq__28225__$1);
var G__28303 = null;
var G__28304 = (0);
var G__28305 = (0);
seq__28225 = G__28302;
chunk__28226 = G__28303;
count__28227 = G__28304;
i__28228 = G__28305;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__28233 = cljs.core.seq(value);
var chunk__28234 = null;
var count__28235 = (0);
var i__28236 = (0);
while(true){
if((i__28236 < count__28235)){
var event = chunk__28234.cljs$core$IIndexed$_nth$arity$2(null,i__28236);
clear_event(event);


var G__28306 = seq__28233;
var G__28307 = chunk__28234;
var G__28308 = count__28235;
var G__28309 = (i__28236 + (1));
seq__28233 = G__28306;
chunk__28234 = G__28307;
count__28235 = G__28308;
i__28236 = G__28309;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28233);
if(temp__5735__auto__){
var seq__28233__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28233__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28233__$1);
var G__28310 = cljs.core.chunk_rest(seq__28233__$1);
var G__28311 = c__4556__auto__;
var G__28312 = cljs.core.count(c__4556__auto__);
var G__28313 = (0);
seq__28233 = G__28310;
chunk__28234 = G__28311;
count__28235 = G__28312;
i__28236 = G__28313;
continue;
} else {
var event = cljs.core.first(seq__28233__$1);
clear_event(event);


var G__28314 = cljs.core.next(seq__28233__$1);
var G__28315 = null;
var G__28316 = (0);
var G__28317 = (0);
seq__28233 = G__28314;
chunk__28234 = G__28315;
count__28235 = G__28316;
i__28236 = G__28317;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if((!((cljs.core.deref(re_frame.db.app_db) === value)))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=re_frame.fx.js.map
