goog.provide('goldly.system');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('taoensso.timbre');
goog.require('clojure.walk');
goog.require('sci.core');
goog.require('cljs.tools.reader');
goog.require('cljs.reader');
goog.require('reagent.core');
goog.require('reagent.dom');
goog.require('re_frame.core');
goog.require('cljs_uuid_utils.core');
goog.require('com.rpl.specter');
goog.require('pinkgorilla.ui.pinkie');
goog.require('pinkgorilla.ui.gorilla_plot.pinkie');
goldly.system.walk_ns = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Symbol(null,"postwalk","postwalk",967039904,null),clojure.walk.postwalk,new cljs.core.Symbol(null,"prewalk","prewalk",1337993264,null),clojure.walk.prewalk,new cljs.core.Symbol(null,"keywordize-keys","keywordize-keys",-1343651517,null),clojure.walk.keywordize_keys,new cljs.core.Symbol(null,"walk","walk",1673453164,null),clojure.walk.walk,new cljs.core.Symbol(null,"postwalk-replace","postwalk-replace",77744733,null),clojure.walk.postwalk_replace,new cljs.core.Symbol(null,"prewalk-replace","prewalk-replace",2117002030,null),clojure.walk.prewalk_replace,new cljs.core.Symbol(null,"stringify-keys","stringify-keys",1735215919,null),clojure.walk.stringify_keys], null);
goldly.system.compile = (function goldly$system$compile(code,bindings){
return sci.core.eval_string.cljs$core$IFn$_invoke$arity$2(code,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"bindings","bindings",1271397192),bindings,new cljs.core.Keyword(null,"preset","preset",777387345),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"termination-safe","termination-safe",-1845225130),true], null),new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"walk","walk",1673453164,null),goldly.system.walk_ns], null)], null));
});
goldly.system.edn_QMARK_ = (function goldly$system$edn_QMARK_(obj){
return ((typeof obj === 'number') || (typeof obj === 'string') || (cljs.core.coll_QMARK_(obj)) || (cljs.core.boolean_QMARK_(obj)) || ((obj == null)) || (cljs.core.regexp_QMARK_(obj)) || ((obj instanceof cljs.core.Symbol)) || ((obj instanceof cljs.core.Keyword)));
});
goldly.system.norm_evt = (function goldly$system$norm_evt(obj){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(goldly.system.edn_QMARK_,cljs.core.second),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__43035_SHARP_){
var norm = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(p1__43035_SHARP_,/[A-Z]/,(function (r){
return ["-",clojure.string.lower_case(r)].join('');
})));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [norm,(obj[p1__43035_SHARP_])], null);
}),Object.getOwnPropertyNames(Object.getPrototypeOf(obj)))));
});
goldly.system.eventhandler_fn = (function goldly$system$eventhandler_fn(state,fun){
return (function() { 
var G__43069__delegate = function (e,args){
try{taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"goldly.system","/tmp/form-init1184326760233356127.clj",67,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, ["running eventhandler fn: ",fun,"e:",e," args: ",args], null);
}),null)),null,1100440321);

e.preventDefault();

e.stopPropagation();

var e_norm = goldly.system.norm_evt(e.target);
var _ = cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["eventhandler e-norm: ",e_norm], 0));
var ___$1 = cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["args: ",args], 0));
var fun_args = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e_norm,cljs.core.deref(state)], null);
var fun_args__$1 = (((args == null))?fun_args:cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fun_args,args)));
var ___$2 = cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["fun-args: ",fun_args__$1], 0));
cljs.core.reset_BANG_(state,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fun,fun_args__$1));

return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["new state: ",cljs.core.deref(state)], 0));
}catch (e43039){var e__$1 = e43039;
return console.log("eventhandler-fn exception: ",e__$1);
}};
var G__43069 = function (e,var_args){
var args = null;
if (arguments.length > 1) {
var G__43070__i = 0, G__43070__a = new Array(arguments.length -  1);
while (G__43070__i < G__43070__a.length) {G__43070__a[G__43070__i] = arguments[G__43070__i + 1]; ++G__43070__i;}
  args = new cljs.core.IndexedSeq(G__43070__a,0,null);
} 
return G__43069__delegate.call(this,e,args);};
G__43069.cljs$lang$maxFixedArity = 1;
G__43069.cljs$lang$applyTo = (function (arglist__43071){
var e = cljs.core.first(arglist__43071);
var args = cljs.core.rest(arglist__43071);
return G__43069__delegate(e,args);
});
G__43069.cljs$core$IFn$_invoke$arity$variadic = G__43069__delegate;
return G__43069;
})()
;
});
goldly.system.no_op_fun = (function goldly$system$no_op_fun(f_name){
return (function (state,e_norm){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["running function ",f_name," (no-fun) .."], 0));
});
});
/**
 * compiles a system/fns. 
 * On compile error returns no-op-fun
 */
goldly.system.compile_fn = (function goldly$system$compile_fn(bindings,f_name,f_body){
var _ = cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["compile-fn ",f_name," bindings: ",cljs.core.keys(bindings)," code: ",f_body], 0));
var f_body__$1 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(f_body);
var ___$1 = cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["fbody: ",f_body__$1], 0));
var fun = goldly.system.compile(f_body__$1,bindings);
var ___$2 = cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["fun: ",fun], 0));
var fun__$1 = (cljs.core.truth_(fun)?fun:(function (){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["compile error in system/fn ",f_name], 0));

return goldly.system.no_op_fun(f_name);
})()
);
return fun__$1;
});
goldly.system.clj_fun = (function goldly$system$clj_fun(run_id,system_id,fn_clj){
return (function() { 
var G__43072__delegate = function (args){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"goldly.system","/tmp/form-init1184326760233356127.clj",106,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["runner %s : system %s calling fn-clj %s",run_id,system_id,fn_clj], null);
}),null)),null,73763853);

var fn_vec = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [run_id,system_id,fn_clj], null);
var fn_vec__$1 = (cljs.core.truth_(args)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(fn_vec,args):fn_vec);
var G__43043_43073 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("goldly","send","goldly/send",181321881),new cljs.core.Keyword("goldly","dispatch","goldly/dispatch",-1397389788),fn_vec__$1], null);
(re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__43043_43073) : re_frame.core.dispatch.call(null,G__43043_43073));

return null;
};
var G__43072 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__43074__i = 0, G__43074__a = new Array(arguments.length -  0);
while (G__43074__i < G__43074__a.length) {G__43074__a[G__43074__i] = arguments[G__43074__i + 0]; ++G__43074__i;}
  args = new cljs.core.IndexedSeq(G__43074__a,0,null);
} 
return G__43072__delegate.call(this,args);};
G__43072.cljs$lang$maxFixedArity = 0;
G__43072.cljs$lang$applyTo = (function (arglist__43075){
var args = cljs.core.seq(arglist__43075);
return G__43072__delegate(args);
});
G__43072.cljs$core$IFn$_invoke$arity$variadic = G__43072__delegate;
return G__43072;
})()
;
});
goldly.system.binding_symbol = (function goldly$system$binding_symbol(f_name){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.name(f_name)].join(''));
});
goldly.system.__GT_bindings_clj = (function goldly$system$__GT_bindings_clj(run_id,system_id,fns_clj){
var fns_clj__$1 = (function (){var or__4126__auto__ = fns_clj;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})();
var fns_keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(goldly.system.binding_symbol,fns_clj__$1);
var bindings_clj = cljs.core.zipmap(fns_keys,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(goldly.system.clj_fun,run_id,system_id),fns_clj__$1));
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["bindings-clj: ",bindings_clj], 0));

return bindings_clj;
});
goldly.system.__GT_bindings_cljs = (function goldly$system$__GT_bindings_cljs(state,fns){
var bindings = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"state","state",-348086572,null),state,new cljs.core.Symbol(null,"sin","sin",1721439389,null),pinkgorilla.ui.gorilla_plot.pinkie.sin], null);
var bindings_cljs = cljs.core.into.cljs$core$IFn$_invoke$arity$2(bindings,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__43047){
var vec__43048 = p__43047;
var f_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43048,(0),null);
var f_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43048,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [goldly.system.binding_symbol(f_name),goldly.system.eventhandler_fn(state,goldly.system.compile_fn(bindings,f_name,f_body))], null);
}),fns));
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["bindings-cljs: ",bindings_cljs], 0));

return bindings_cljs;
});
goldly.system.tap = (function goldly$system$tap(x){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["tap:",x], 0));

return x;
});
goldly.system.compile_error = (function goldly$system$compile_error(s,b,e){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.border.border-red-500.m-5.p-3","div.border.border-red-500.m-5.p-3",-719344994),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h3.text-purple-700-w-full.bg-pink-300.mb-5","h3.text-purple-700-w-full.bg-pink-300.mb-5",1882337344),"Error compiling system"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h1.text-blue-300","h1.text-blue-300",-1101967322),"system"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s], 0))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h1.text-blue-300","h1.text-blue-300",-1101967322),"bindings"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([b], 0))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h1.text-blue-300","h1.text-blue-300",-1101967322),"Error"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0))], null)], null);
});
/**
 * compiles a system and creates a reagent component that displays the system;
 * or that displays a compile error
 * returns: component
 *          component expects system state as parameter as atom
 */
goldly.system.compile_system = (function goldly$system$compile_system(run_id,state_a,p__43051){
var map__43052 = p__43051;
var map__43052__$1 = (((((!((map__43052 == null))))?(((((map__43052.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43052.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43052):map__43052);
var system = map__43052__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43052__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43052__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var html = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43052__$1,new cljs.core.Keyword(null,"html","html",-998796897));
var fns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43052__$1,new cljs.core.Keyword(null,"fns","fns",1185138786));
var fns_clj = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43052__$1,new cljs.core.Keyword(null,"fns-clj","fns-clj",1003510986));
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"goldly.system","/tmp/form-init1184326760233356127.clj",154,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["compiling system: ",system], null);
}),null)),null,-1015971061);

if((html == null)){
return (function (_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h1","h1",-1896887462),"Error: system html is nil!"], null);
});
} else {
var _ = cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["compile-system .."], 0));
var bindings_cljs = goldly.system.__GT_bindings_cljs(state_a,fns);
var bindings_clj = goldly.system.__GT_bindings_clj(run_id,id,fns_clj);
var bindings = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([bindings_clj,bindings_cljs], 0));
var ___$1 = cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["bindings-system: ",bindings], 0));
var component = (function (state_a__$1){
try{return pinkgorilla.ui.pinkie.tag_inject(goldly.system.compile(html,bindings));
}catch (e43054){var e = e43054;
console.log(e);

return (function (state_a__$2){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [goldly.system.compile_error,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"state","state",-1988618099),cljs.core.deref(state_a__$2),new cljs.core.Keyword(null,"html","html",-998796897),html,new cljs.core.Keyword(null,"fns","fns",1185138786),fns,new cljs.core.Keyword(null,"fns-clj","fns-clj",1003510986),fns_clj], null),bindings,e], null);
});
}});
return component;
}
});
goldly.system.specter_resolve = (function goldly$system$specter_resolve(specter_vector){
return clojure.walk.prewalk((function (x){
if((x instanceof cljs.core.Keyword)){
var G__43055 = x;
var G__43055__$1 = (((G__43055 instanceof cljs.core.Keyword))?G__43055.fqn:null);
switch (G__43055__$1) {
case "END":
return com.rpl.specter.END;

break;
default:
return x;

}
} else {
return x;
}
}),specter_vector);
});
goldly.system.update_state_from_clj_result = (function goldly$system$update_state_from_clj_result(state,result,where){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"goldly.system","/tmp/form-init1184326760233356127.clj",185,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["updating state from clj result: %s where: %s",result,where], null);
}),null)),null,1775242968);

try{var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"goldly.system","/tmp/form-init1184326760233356127.clj",188,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["specter where: ",where], null);
}),null)),null,-1604617286);
var where_resolved = goldly.system.specter_resolve(where);
var ___$1 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"goldly.system","/tmp/form-init1184326760233356127.clj",190,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["specter resolved: ",where_resolved], null);
}),null)),null,-194234460);
cljs.core.reset_BANG_(state,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__41690__auto__ = goldly.system.pathcache43057;
var info__41690__auto____$1 = (((info__41690__auto__ == null))?(function (){var info43058 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(where_resolved,new cljs.core.Symbol(null,"where-resolved","where-resolved",453826419,null))], null),"goldly.system",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"where-resolved","where-resolved",453826419,null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"where-resolved","where-resolved",453826419,null)], null));
goldly.system.pathcache43057 = info43058;

return info43058;
})():info__41690__auto__);
var precompiled43059 = com.rpl.specter.impl.cached_path_info_precompiled(info__41690__auto____$1);
var dynamic_QMARK___41691__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41690__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41691__auto__)){
var G__43060 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [where_resolved], null);
return (precompiled43059.cljs$core$IFn$_invoke$arity$1 ? precompiled43059.cljs$core$IFn$_invoke$arity$1(G__43060) : precompiled43059.call(null,G__43060));
} else {
return precompiled43059;
}
})(),result,cljs.core.deref(state)));

taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"goldly.system","/tmp/form-init1184326760233356127.clj",192,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["update state from clj success!"], null);
}),null)),null,1763997576);

return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"goldly.system","/tmp/form-init1184326760233356127.clj",193,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["system state after clj-update: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state], 0))], null);
}),null)),null,1802606434);
}catch (e43056){var e = e43056;
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"goldly.system","/tmp/form-init1184326760233356127.clj",195,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["exception in updating state after clj result call:",e], null);
}),null)),null,1019189089);
}});
goldly.system.render_system_impl = (function goldly$system$render_system_impl(run_id){
return (function (p__43061){
var map__43062 = p__43061;
var map__43062__$1 = (((((!((map__43062 == null))))?(((((map__43062.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43062.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43062):map__43062);
var system = map__43062__$1;
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43062__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var html = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43062__$1,new cljs.core.Keyword(null,"html","html",-998796897));
var fns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43062__$1,new cljs.core.Keyword(null,"fns","fns",1185138786));
var fns_clj = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43062__$1,new cljs.core.Keyword(null,"fns-clj","fns-clj",1003510986));
if((html == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h1","h1",-1896887462),"Error: system html is nil!"], null);
} else {
var state_a = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(state);
var component = goldly.system.compile_system(run_id,state_a,system);
var update_state = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(goldly.system.update_state_from_clj_result,state_a);
var G__43064_43077 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("goldly","add-running-system","goldly/add-running-system",-2139724490),run_id,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([system,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"update-state","update-state",-653396259),update_state], null)], 0))], null);
(re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__43064_43077) : re_frame.core.dispatch.call(null,G__43064_43077));

return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [component,state_a], null);
});
}
});
});
goldly.system.render_system = (function goldly$system$render_system(p__43065){
var map__43066 = p__43065;
var map__43066__$1 = (((((!((map__43066 == null))))?(((((map__43066.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43066.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43066):map__43066);
var system = map__43066__$1;
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43066__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var html = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43066__$1,new cljs.core.Keyword(null,"html","html",-998796897));
var fns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43066__$1,new cljs.core.Keyword(null,"fns","fns",1185138786));
var fns_clj = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43066__$1,new cljs.core.Keyword(null,"fns-clj","fns-clj",1003510986));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43066__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var id__$1 = cljs_uuid_utils.core.uuid_string(cljs_uuid_utils.core.make_random_uuid());
return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display-name","display-name",694513143),"goldly-render-system",new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),goldly.system.render_system_impl(id__$1),new cljs.core.Keyword(null,"component-will-unmount","component-will-unmount",-2058314698),(function (this$){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"goldly.system","/tmp/form-init1184326760233356127.clj",218,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["render-system id: %s - will unmount",id__$1], null);
}),null)),null,654064745);

var G__43068 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("goldly","remove-running-system","goldly/remove-running-system",733892004),id__$1], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__43068) : re_frame.core.dispatch.call(null,G__43068));
})], null));
});

//# sourceMappingURL=goldly.system.js.map
