goog.provide('com.rpl.specter');
goog.require('cljs.core');
goog.require('com.rpl.specter.protocols');
goog.require('com.rpl.specter.impl');
goog.require('com.rpl.specter.navs');
goog.require('clojure.set');
com.rpl.specter.static_path_QMARK_ = (function com$rpl$specter$static_path_QMARK_(path){
if(cljs.core.sequential_QMARK_(path)){
return cljs.core.every_QMARK_(com.rpl.specter.static_path_QMARK_,path);
} else {
return (!(com.rpl.specter.impl.dynamic_param_QMARK_(path)));
}
});
com.rpl.specter.wrap_dynamic_nav = (function com$rpl$specter$wrap_dynamic_nav(f){
return (function() { 
var G__43032__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
if(((cljs.core.sequential_QMARK_(ret)) && (com.rpl.specter.static_path_QMARK_(ret)))){
return com.rpl.specter.impl.comp_paths_STAR_(ret);
} else {
if(((cljs.core.sequential_QMARK_(ret)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(ret))))){
return cljs.core.first(ret);
} else {
return ret;

}
}
};
var G__43032 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__43033__i = 0, G__43033__a = new Array(arguments.length -  0);
while (G__43033__i < G__43033__a.length) {G__43033__a[G__43033__i] = arguments[G__43033__i + 0]; ++G__43033__i;}
  args = new cljs.core.IndexedSeq(G__43033__a,0,null);
} 
return G__43032__delegate.call(this,args);};
G__43032.cljs$lang$maxFixedArity = 0;
G__43032.cljs$lang$applyTo = (function (arglist__43034){
var args = cljs.core.seq(arglist__43034);
return G__43032__delegate(args);
});
G__43032.cljs$core$IFn$_invoke$arity$variadic = G__43032__delegate;
return G__43032;
})()
;
});
/**
 * Returns a compiled version of the given path for use with
 * compiled-{select/transform/setval/etc.} functions.
 */
com.rpl.specter.comp_paths = (function com$rpl$specter$comp_paths(var_args){
var args__4742__auto__ = [];
var len__4736__auto___43036 = arguments.length;
var i__4737__auto___43037 = (0);
while(true){
if((i__4737__auto___43037 < len__4736__auto___43036)){
args__4742__auto__.push((arguments[i__4737__auto___43037]));

var G__43038 = (i__4737__auto___43037 + (1));
i__4737__auto___43037 = G__43038;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic = (function (apath){
return com.rpl.specter.impl.comp_paths_STAR_(cljs.core.vec(apath));
}));

(com.rpl.specter.comp_paths.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.rpl.specter.comp_paths.cljs$lang$applyTo = (function (seq42714){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42714));
}));

/**
 * Version of select that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select = com.rpl.specter.impl.compiled_select_STAR_;
/**
 * Navigates to and returns a sequence of all the elements specified by the path.
 */
com.rpl.specter.select_STAR_ = (function com$rpl$specter$select_STAR_(path,structure){
var G__42715 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__42716 = structure;
return (com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(G__42715,G__42716) : com.rpl.specter.compiled_select.call(null,G__42715,G__42716));
});
/**
 * Version of select-one that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one = com.rpl.specter.impl.compiled_select_one_STAR_;
/**
 * Like select, but returns either one element or nil. Throws exception if multiple elements found
 */
com.rpl.specter.select_one_STAR_ = (function com$rpl$specter$select_one_STAR_(path,structure){
var G__42717 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__42718 = structure;
return (com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(G__42717,G__42718) : com.rpl.specter.compiled_select_one.call(null,G__42717,G__42718));
});
/**
 * Version of select-one! that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one_BANG_ = com.rpl.specter.impl.compiled_select_one_BANG__STAR_;
/**
 * Returns exactly one element, throws exception if zero or multiple elements found
 */
com.rpl.specter.select_one_BANG__STAR_ = (function com$rpl$specter$select_one_BANG__STAR_(path,structure){
var G__42719 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__42720 = structure;
return (com.rpl.specter.compiled_select_one_BANG_.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one_BANG_.cljs$core$IFn$_invoke$arity$2(G__42719,G__42720) : com.rpl.specter.compiled_select_one_BANG_.call(null,G__42719,G__42720));
});
/**
 * Version of select-first that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_first = com.rpl.specter.impl.compiled_select_first_STAR_;
/**
 * Returns first element found.
 */
com.rpl.specter.select_first_STAR_ = (function com$rpl$specter$select_first_STAR_(path,structure){
var G__42721 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__42722 = structure;
return (com.rpl.specter.compiled_select_first.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_first.cljs$core$IFn$_invoke$arity$2(G__42721,G__42722) : com.rpl.specter.compiled_select_first.call(null,G__42721,G__42722));
});
/**
 * Version of select-any that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_any = com.rpl.specter.impl.compiled_select_any_STAR_;
/**
 * Global value used to indicate no elements selected during
 *           [[select-any]].
 */
com.rpl.specter.NONE = com.rpl.specter.impl.NONE;
/**
 * Returns any element found or [[NONE]] if nothing selected. This is the most
 * efficient of the various selection operations.
 */
com.rpl.specter.select_any_STAR_ = (function com$rpl$specter$select_any_STAR_(path,structure){
var G__42723 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__42724 = structure;
return (com.rpl.specter.compiled_select_any.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_any.cljs$core$IFn$_invoke$arity$2(G__42723,G__42724) : com.rpl.specter.compiled_select_any.call(null,G__42723,G__42724));
});
/**
 * Version of selected-any? that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_selected_any_QMARK_ = com.rpl.specter.impl.compiled_selected_any_QMARK__STAR_;
/**
 * Returns true if any element was selected, false otherwise.
 */
com.rpl.specter.selected_any_QMARK__STAR_ = (function com$rpl$specter$selected_any_QMARK__STAR_(path,structure){
var G__42725 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__42726 = structure;
return (com.rpl.specter.compiled_selected_any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_selected_any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__42725,G__42726) : com.rpl.specter.compiled_selected_any_QMARK_.call(null,G__42725,G__42726));
});
/**
 * Version of traverse that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse = com.rpl.specter.impl.do_compiled_traverse;
/**
 * Return a reducible object that traverses over `structure` to every element
 * specified by the path
 */
com.rpl.specter.traverse_STAR_ = (function com$rpl$specter$traverse_STAR_(apath,structure){
var G__42727 = com.rpl.specter.impl.comp_paths_STAR_(apath);
var G__42728 = structure;
return (com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(G__42727,G__42728) : com.rpl.specter.compiled_traverse.call(null,G__42727,G__42728));
});
/**
 * Version of traverse-all that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse_all = com.rpl.specter.impl.compiled_traverse_all_STAR_;
/**
 * Returns a transducer that traverses over each element with the given path.
 */
com.rpl.specter.traverse_all_STAR_ = (function com$rpl$specter$traverse_all_STAR_(apath){
var G__42729 = com.rpl.specter.impl.comp_paths_STAR_(apath);
return (com.rpl.specter.compiled_traverse_all.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.compiled_traverse_all.cljs$core$IFn$_invoke$arity$1(G__42729) : com.rpl.specter.compiled_traverse_all.call(null,G__42729));
});
/**
 * Version of transform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_transform = com.rpl.specter.impl.compiled_transform_STAR_;
/**
 * Version of vtransform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_vtransform = com.rpl.specter.impl.compiled_vtransform_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by the result of running
 *   the transform-fn on it
 */
com.rpl.specter.transform_STAR_ = (function com$rpl$specter$transform_STAR_(path,transform_fn,structure){
var G__42730 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__42731 = transform_fn;
var G__42732 = structure;
return (com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(G__42730,G__42731,G__42732) : com.rpl.specter.compiled_transform.call(null,G__42730,G__42731,G__42732));
});
/**
 * Version of `multi-transform` that takes in a path precompiled with `comp-paths`
 */
com.rpl.specter.compiled_multi_transform = com.rpl.specter.impl.compiled_multi_transform_STAR_;
/**
 * Just like `transform` but expects transform functions to be specified
 * inline in the path using `terminal` or `vterminal`. Error is thrown if navigation finishes
 * at a non-terminal navigator. `terminal-val` is a wrapper around `terminal` and is
 * the `multi-transform` equivalent of `setval`.
 */
com.rpl.specter.multi_transform_STAR_ = (function com$rpl$specter$multi_transform_STAR_(path,structure){
var G__42733 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__42734 = structure;
return (com.rpl.specter.compiled_multi_transform.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_multi_transform.cljs$core$IFn$_invoke$arity$2(G__42733,G__42734) : com.rpl.specter.compiled_multi_transform.call(null,G__42733,G__42734));
});
/**
 * Version of setval that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_setval = com.rpl.specter.impl.compiled_setval_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by val
 */
com.rpl.specter.setval_STAR_ = (function com$rpl$specter$setval_STAR_(path,val,structure){
var G__42735 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__42736 = val;
var G__42737 = structure;
return (com.rpl.specter.compiled_setval.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_setval.cljs$core$IFn$_invoke$arity$3(G__42735,G__42736,G__42737) : com.rpl.specter.compiled_setval.call(null,G__42735,G__42736,G__42737));
});
/**
 * Version of replace-in that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_replace_in = com.rpl.specter.impl.compiled_replace_in_STAR_;
/**
 * Similar to transform, except returns a pair of [transformed-structure sequence-of-user-ret].
 * The transform-fn in this case is expected to return [ret user-ret]. ret is
 * what's used to transform the data structure, while user-ret will be added to the user-ret sequence
 * in the final return. replace-in is useful for situations where you need to know the specific values
 * of what was transformed in the data structure.
 */
com.rpl.specter.replace_in_STAR_ = (function com$rpl$specter$replace_in_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___43040 = arguments.length;
var i__4737__auto___43041 = (0);
while(true){
if((i__4737__auto___43041 < len__4736__auto___43040)){
args__4742__auto__.push((arguments[i__4737__auto___43041]));

var G__43042 = (i__4737__auto___43041 + (1));
i__4737__auto___43041 = G__43042;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (path,transform_fn,structure,p__42742){
var map__42743 = p__42742;
var map__42743__$1 = (((((!((map__42743 == null))))?(((((map__42743.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42743.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42743):map__42743);
var merge_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42743__$1,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),cljs.core.concat);
var G__42745 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__42746 = transform_fn;
var G__42747 = structure;
var G__42748 = new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341);
var G__42749 = merge_fn;
return (com.rpl.specter.compiled_replace_in.cljs$core$IFn$_invoke$arity$5 ? com.rpl.specter.compiled_replace_in.cljs$core$IFn$_invoke$arity$5(G__42745,G__42746,G__42747,G__42748,G__42749) : com.rpl.specter.compiled_replace_in.call(null,G__42745,G__42746,G__42747,G__42748,G__42749));
}));

(com.rpl.specter.replace_in_STAR_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(com.rpl.specter.replace_in_STAR_.cljs$lang$applyTo = (function (seq42738){
var G__42739 = cljs.core.first(seq42738);
var seq42738__$1 = cljs.core.next(seq42738);
var G__42740 = cljs.core.first(seq42738__$1);
var seq42738__$2 = cljs.core.next(seq42738__$1);
var G__42741 = cljs.core.first(seq42738__$2);
var seq42738__$3 = cljs.core.next(seq42738__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__42739,G__42740,G__42741,seq42738__$3);
}));

com.rpl.specter.late_path = com.rpl.specter.impl.late_path;
com.rpl.specter.dynamic_param_QMARK_ = com.rpl.specter.impl.dynamic_param_QMARK_;
com.rpl.specter.late_resolved_fn = com.rpl.specter.impl.late_resolved_fn;
/**
 * Turns a navigator that takes one argument into a navigator that takes
 *        many arguments and uses the same navigator with each argument. There
 *        is no performance cost to using this. See implementation of `keypath`
 */
com.rpl.specter.eachnav = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (navfn){
var latenavfn = (com.rpl.specter.late_resolved_fn.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_resolved_fn.cljs$core$IFn$_invoke$arity$1(navfn) : com.rpl.specter.late_resolved_fn.call(null,navfn));
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43044__delegate = function (args){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(latenavfn,args);
};
var G__43044 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__43045__i = 0, G__43045__a = new Array(arguments.length -  0);
while (G__43045__i < G__43045__a.length) {G__43045__a[G__43045__i] = arguments[G__43045__i + 0]; ++G__43045__i;}
  args = new cljs.core.IndexedSeq(G__43045__a,0,null);
} 
return G__43044__delegate.call(this,args);};
G__43044.cljs$lang$maxFixedArity = 0;
G__43044.cljs$lang$applyTo = (function (arglist__43046){
var args = cljs.core.seq(arglist__43046);
return G__43044__delegate(args);
});
G__43044.cljs$core$IFn$_invoke$arity$variadic = G__43044__delegate;
return G__43044;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.local_declarepath = com.rpl.specter.impl.local_declarepath;


com.rpl.specter.STOP_select_STAR_ = (function com$rpl$specter$STOP_select_STAR_(structure,next_fn){
return com.rpl.specter.NONE;
});

com.rpl.specter.STOP_transform_STAR_ = (function com$rpl$specter$STOP_transform_STAR_(structure,next_fn){
return structure;
});

/**
 * Stops navigation at this point. For selection returns nothing and for
 *        transformation returns the structure unchanged
 */
com.rpl.specter.STOP = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42750 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42750 = (function (meta42751){
this.meta42751 = meta42751;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42750.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42752,meta42751__$1){
var self__ = this;
var _42752__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42750(meta42751__$1));
}));

(com.rpl.specter.t_com$rpl$specter42750.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42752){
var self__ = this;
var _42752__$1 = this;
return self__.meta42751;
}));

(com.rpl.specter.t_com$rpl$specter42750.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42750.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter42750.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return structure;
}));

(com.rpl.specter.t_com$rpl$specter42750.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42751","meta42751",1989450818,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42750.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42750.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42750");

(com.rpl.specter.t_com$rpl$specter42750.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42750");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42750.
 */
com.rpl.specter.__GT_t_com$rpl$specter42750 = (function com$rpl$specter$__GT_t_com$rpl$specter42750(meta42751){
return (new com.rpl.specter.t_com$rpl$specter42750(meta42751));
});

}

return (new com.rpl.specter.t_com$rpl$specter42750(null));
})()
;
/**
 * Stays navigated at the current point. Essentially a no-op navigator.
 */
com.rpl.specter.STAY = com.rpl.specter.impl.STAY_STAR_;
/**
 * Defines an endpoint in the navigation the transform function run. The transform
 *        function works just like it does in `transform`, with collected values
 *        given as the first arguments
 */
com.rpl.specter.terminal = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42753 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42753 = (function (afn,meta42754){
this.afn = afn;
this.meta42754 = meta42754;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42753.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42755,meta42754__$1){
var self__ = this;
var _42755__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42753(self__.afn,meta42754__$1));
}));

(com.rpl.specter.t_com$rpl$specter42753.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42755){
var self__ = this;
var _42755__$1 = this;
return self__.meta42754;
}));

(com.rpl.specter.t_com$rpl$specter42753.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42753.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter42753.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.terminal_STAR_(self__.afn,vals,structure);
}));

(com.rpl.specter.t_com$rpl$specter42753.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta42754","meta42754",871830530,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42753.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42753.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42753");

(com.rpl.specter.t_com$rpl$specter42753.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42753");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42753.
 */
com.rpl.specter.__GT_t_com$rpl$specter42753 = (function com$rpl$specter$__GT_t_com$rpl$specter42753(afn__$1,meta42754){
return (new com.rpl.specter.t_com$rpl$specter42753(afn__$1,meta42754));
});

}

return (new com.rpl.specter.t_com$rpl$specter42753(afn,null));
}));
/**
 * Defines an endpoint in the navigation the transform function run.The transform
 *        function works differently than it does in `transform`. Rather than receive
 *        collected vals spliced in as the first arguments to the function, this function
 *        always takes two arguemnts. The first is all collected vals in a vector, and
 *        the second is the navigated value.
 */
com.rpl.specter.vterminal = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42756 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42756 = (function (afn,meta42757){
this.afn = afn;
this.meta42757 = meta42757;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42756.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42758,meta42757__$1){
var self__ = this;
var _42758__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42756(self__.afn,meta42757__$1));
}));

(com.rpl.specter.t_com$rpl$specter42756.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42758){
var self__ = this;
var _42758__$1 = this;
return self__.meta42757;
}));

(com.rpl.specter.t_com$rpl$specter42756.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42756.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter42756.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(vals,structure) : self__.afn.call(null,vals,structure));
}));

(com.rpl.specter.t_com$rpl$specter42756.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta42757","meta42757",655242148,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42756.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42756.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42756");

(com.rpl.specter.t_com$rpl$specter42756.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42756");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42756.
 */
com.rpl.specter.__GT_t_com$rpl$specter42756 = (function com$rpl$specter$__GT_t_com$rpl$specter42756(afn__$1,meta42757){
return (new com.rpl.specter.t_com$rpl$specter42756(afn__$1,meta42757));
});

}

return (new com.rpl.specter.t_com$rpl$specter42756(afn,null));
}));
/**
 * Like `terminal` but specifies a val to set at the location regardless of
 * the collected values or the value at the location.
 */
com.rpl.specter.terminal_val = (function com$rpl$specter$terminal_val(v){
var G__42759 = com.rpl.specter.impl.fast_constantly(v);
return (com.rpl.specter.terminal.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.terminal.cljs$core$IFn$_invoke$arity$1(G__42759) : com.rpl.specter.terminal.call(null,G__42759));
});


com.rpl.specter.ALL_select_STAR_ = (function com$rpl$specter$ALL_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.ALL_transform_STAR_ = (function com$rpl$specter$ALL_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_transform(structure,next_fn);
});

/**
 * Navigate to every element of the collection. For maps navigates to
 *        a vector of `[key value]`.
 */
com.rpl.specter.ALL = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42760 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42760 = (function (meta42761){
this.meta42761 = meta42761;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42760.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42762,meta42761__$1){
var self__ = this;
var _42762__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42760(meta42761__$1));
}));

(com.rpl.specter.t_com$rpl$specter42760.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42762){
var self__ = this;
var _42762__$1 = this;
return self__.meta42761;
}));

(com.rpl.specter.t_com$rpl$specter42760.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42760.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return com.rpl.specter.navs.all_select(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42760.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return com.rpl.specter.navs.all_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42760.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42761","meta42761",439212431,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42760.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42760.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42760");

(com.rpl.specter.t_com$rpl$specter42760.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42760");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42760.
 */
com.rpl.specter.__GT_t_com$rpl$specter42760 = (function com$rpl$specter$__GT_t_com$rpl$specter42760(meta42761){
return (new com.rpl.specter.t_com$rpl$specter42760(meta42761));
});

}

return (new com.rpl.specter.t_com$rpl$specter42760(null));
})()
;


com.rpl.specter.ALL_WITH_META_select_STAR_ = (function com$rpl$specter$ALL_WITH_META_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.ALL_WITH_META_transform_STAR_ = (function com$rpl$specter$ALL_WITH_META_transform_STAR_(structure,next_fn){
var m = cljs.core.meta(structure);
var res = com.rpl.specter.navs.all_transform(structure,next_fn);
if((!((res == null)))){
return cljs.core.with_meta(res,m);
} else {
return null;
}
});

/**
 * Same as ALL, except maintains metadata on the structure.
 */
com.rpl.specter.ALL_WITH_META = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42763 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42763 = (function (meta42764){
this.meta42764 = meta42764;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42763.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42765,meta42764__$1){
var self__ = this;
var _42765__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42763(meta42764__$1));
}));

(com.rpl.specter.t_com$rpl$specter42763.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42765){
var self__ = this;
var _42765__$1 = this;
return self__.meta42764;
}));

(com.rpl.specter.t_com$rpl$specter42763.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42763.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return com.rpl.specter.navs.all_select(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42763.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
var m = cljs.core.meta(structure);
var res = com.rpl.specter.navs.all_transform(structure,next_fn);
if((!((res == null)))){
return cljs.core.with_meta(res,m);
} else {
return null;
}
}));

(com.rpl.specter.t_com$rpl$specter42763.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42764","meta42764",1125708378,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42763.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42763.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42763");

(com.rpl.specter.t_com$rpl$specter42763.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42763");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42763.
 */
com.rpl.specter.__GT_t_com$rpl$specter42763 = (function com$rpl$specter$__GT_t_com$rpl$specter42763(meta42764){
return (new com.rpl.specter.t_com$rpl$specter42763(meta42764));
});

}

return (new com.rpl.specter.t_com$rpl$specter42763(null));
})()
;


com.rpl.specter.MAP_VALS_select_STAR_ = (function com$rpl$specter$MAP_VALS_select_STAR_(structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38667__auto__,v){
var ret__38668__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(v) : next_fn.call(null,v));
if((ret__38668__auto__ === com.rpl.specter.NONE)){
return curr__38667__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38668__auto__)){
return cljs.core.reduced(ret__38668__auto__);
} else {
return ret__38668__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals(structure));
});

com.rpl.specter.MAP_VALS_transform_STAR_ = (function com$rpl$specter$MAP_VALS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_vals_transform(structure,next_fn);
});

/**
 * Navigate to each value of the map. This is more efficient than
 *        navigating via [ALL LAST]
 */
com.rpl.specter.MAP_VALS = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42766 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42766 = (function (meta42767){
this.meta42767 = meta42767;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42766.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42768,meta42767__$1){
var self__ = this;
var _42768__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42766(meta42767__$1));
}));

(com.rpl.specter.t_com$rpl$specter42766.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42768){
var self__ = this;
var _42768__$1 = this;
return self__.meta42767;
}));

(com.rpl.specter.t_com$rpl$specter42766.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42766.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38667__auto__,v){
var ret__38668__auto__ = next_fn(v);
if((ret__38668__auto__ === com.rpl.specter.NONE)){
return curr__38667__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38668__auto__)){
return cljs.core.reduced(ret__38668__auto__);
} else {
return ret__38668__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals(structure));
}));

(com.rpl.specter.t_com$rpl$specter42766.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return com.rpl.specter.navs.map_vals_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42766.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42767","meta42767",-943765708,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42766.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42766.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42766");

(com.rpl.specter.t_com$rpl$specter42766.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42766");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42766.
 */
com.rpl.specter.__GT_t_com$rpl$specter42766 = (function com$rpl$specter$__GT_t_com$rpl$specter42766(meta42767){
return (new com.rpl.specter.t_com$rpl$specter42766(meta42767));
});

}

return (new com.rpl.specter.t_com$rpl$specter42766(null));
})()
;


com.rpl.specter.MAP_KEYS_select_STAR_ = (function com$rpl$specter$MAP_KEYS_select_STAR_(structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38667__auto__,k){
var ret__38668__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(k) : next_fn.call(null,k));
if((ret__38668__auto__ === com.rpl.specter.NONE)){
return curr__38667__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38668__auto__)){
return cljs.core.reduced(ret__38668__auto__);
} else {
return ret__38668__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys(structure));
});

com.rpl.specter.MAP_KEYS_transform_STAR_ = (function com$rpl$specter$MAP_KEYS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_keys_transform(structure,next_fn);
});

/**
 * Navigate to each key of the map. This is more efficient than
 *        navigating via [ALL FIRST]
 */
com.rpl.specter.MAP_KEYS = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42769 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42769 = (function (meta42770){
this.meta42770 = meta42770;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42769.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42771,meta42770__$1){
var self__ = this;
var _42771__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42769(meta42770__$1));
}));

(com.rpl.specter.t_com$rpl$specter42769.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42771){
var self__ = this;
var _42771__$1 = this;
return self__.meta42770;
}));

(com.rpl.specter.t_com$rpl$specter42769.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42769.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38667__auto__,k){
var ret__38668__auto__ = next_fn(k);
if((ret__38668__auto__ === com.rpl.specter.NONE)){
return curr__38667__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38668__auto__)){
return cljs.core.reduced(ret__38668__auto__);
} else {
return ret__38668__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys(structure));
}));

(com.rpl.specter.t_com$rpl$specter42769.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return com.rpl.specter.navs.map_keys_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42769.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42770","meta42770",1019193231,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42769.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42769.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42769");

(com.rpl.specter.t_com$rpl$specter42769.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42769");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42769.
 */
com.rpl.specter.__GT_t_com$rpl$specter42769 = (function com$rpl$specter$__GT_t_com$rpl$specter42769(meta42770){
return (new com.rpl.specter.t_com$rpl$specter42769(meta42770));
});

}

return (new com.rpl.specter.t_com$rpl$specter42769(null));
})()
;
com.rpl.specter.VAL = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42772 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42772 = (function (meta42773){
this.meta42773 = meta42773;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42772.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42774,meta42773__$1){
var self__ = this;
var _42774__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42772(meta42773__$1));
}));

(com.rpl.specter.t_com$rpl$specter42772.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42774){
var self__ = this;
var _42774__$1 = this;
return self__.meta42773;
}));

(com.rpl.specter.t_com$rpl$specter42772.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42772.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41680__auto__,vals__41681__auto__,structure,next_fn__41682__auto__){
var self__ = this;
var this__41680__auto____$1 = this;
var G__42775 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__41681__auto__,structure);
var G__42776 = structure;
return (next_fn__41682__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41682__auto__.cljs$core$IFn$_invoke$arity$2(G__42775,G__42776) : next_fn__41682__auto__.call(null,G__42775,G__42776));
}));

(com.rpl.specter.t_com$rpl$specter42772.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41680__auto__,vals__41681__auto__,structure,next_fn__41682__auto__){
var self__ = this;
var this__41680__auto____$1 = this;
var G__42777 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__41681__auto__,structure);
var G__42778 = structure;
return (next_fn__41682__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41682__auto__.cljs$core$IFn$_invoke$arity$2(G__42777,G__42778) : next_fn__41682__auto__.call(null,G__42777,G__42778));
}));

(com.rpl.specter.t_com$rpl$specter42772.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42773","meta42773",-496183339,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42772.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42772.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42772");

(com.rpl.specter.t_com$rpl$specter42772.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42772");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42772.
 */
com.rpl.specter.__GT_t_com$rpl$specter42772 = (function com$rpl$specter$__GT_t_com$rpl$specter42772(meta42773){
return (new com.rpl.specter.t_com$rpl$specter42772(meta42773));
});

}

return (new com.rpl.specter.t_com$rpl$specter42772(null));
})()
;
/**
 * Navigate to the last element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.LAST = (com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last) : com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last));
/**
 * Navigate to the first element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.FIRST = (com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first) : com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first));


com.rpl.specter.srange_dynamic_select_STAR_ = (function com$rpl$specter$srange_dynamic_select_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = (start_index_fn.cljs$core$IFn$_invoke$arity$1 ? start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : start_index_fn.call(null,structure));
return com.rpl.specter.navs.srange_select(structure,s,com.rpl.specter.navs.invoke_end_fn(end_index_fn,structure,s),next_fn);
});

com.rpl.specter.srange_dynamic_transform_STAR_ = (function com$rpl$specter$srange_dynamic_transform_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = (start_index_fn.cljs$core$IFn$_invoke$arity$1 ? start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : start_index_fn.call(null,structure));
var G__42779 = structure;
var G__42780 = s;
var G__42781 = com.rpl.specter.navs.invoke_end_fn(end_index_fn,structure,s);
var G__42782 = next_fn;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(G__42779,G__42780,G__42781,G__42782) : com.rpl.specter.navs.srange_transform.call(null,G__42779,G__42780,G__42781,G__42782));
});

/**
 * Uses start-index-fn and end-index-fn to determine the bounds of the subsequence
 *        to select when navigating. `start-index-fn` takes in the structure as input. `end-index-fn`
 *        can be one of two forms. If a regular function (e.g. defined with `fn`), it takes in only the structure as input. If a function defined using special `end-fn` macro, it takes in the structure and the result of `start-index-fn`.
 */
com.rpl.specter.srange_dynamic = com.rpl.specter.impl.direct_nav_obj((function (start_index_fn,end_index_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42783 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42783 = (function (start_index_fn,end_index_fn,meta42784){
this.start_index_fn = start_index_fn;
this.end_index_fn = end_index_fn;
this.meta42784 = meta42784;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42783.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42785,meta42784__$1){
var self__ = this;
var _42785__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42783(self__.start_index_fn,self__.end_index_fn,meta42784__$1));
}));

(com.rpl.specter.t_com$rpl$specter42783.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42785){
var self__ = this;
var _42785__$1 = this;
return self__.meta42784;
}));

(com.rpl.specter.t_com$rpl$specter42783.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42783.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
var s = (self__.start_index_fn.cljs$core$IFn$_invoke$arity$1 ? self__.start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.start_index_fn.call(null,structure));
return com.rpl.specter.navs.srange_select(structure,s,com.rpl.specter.navs.invoke_end_fn(self__.end_index_fn,structure,s),next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42783.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
var s = (self__.start_index_fn.cljs$core$IFn$_invoke$arity$1 ? self__.start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.start_index_fn.call(null,structure));
var G__42786 = structure;
var G__42787 = s;
var G__42788 = com.rpl.specter.navs.invoke_end_fn(self__.end_index_fn,structure,s);
var G__42789 = next_fn;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(G__42786,G__42787,G__42788,G__42789) : com.rpl.specter.navs.srange_transform.call(null,G__42786,G__42787,G__42788,G__42789));
}));

(com.rpl.specter.t_com$rpl$specter42783.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start-index-fn","start-index-fn",-344842645,null),new cljs.core.Symbol(null,"end-index-fn","end-index-fn",1237092062,null),new cljs.core.Symbol(null,"meta42784","meta42784",-64272760,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42783.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42783.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42783");

(com.rpl.specter.t_com$rpl$specter42783.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42783");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42783.
 */
com.rpl.specter.__GT_t_com$rpl$specter42783 = (function com$rpl$specter$__GT_t_com$rpl$specter42783(start_index_fn__$1,end_index_fn__$1,meta42784){
return (new com.rpl.specter.t_com$rpl$specter42783(start_index_fn__$1,end_index_fn__$1,meta42784));
});

}

return (new com.rpl.specter.t_com$rpl$specter42783(start_index_fn,end_index_fn,null));
}));


com.rpl.specter.srange_select_STAR_ = (function com$rpl$specter$srange_select_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_select(structure,start,end,next_fn);
});

com.rpl.specter.srange_transform_STAR_ = (function com$rpl$specter$srange_transform_STAR_(start,end,structure,next_fn){
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(structure,start,end,next_fn) : com.rpl.specter.navs.srange_transform.call(null,structure,start,end,next_fn));
});

/**
 * Navigates to the subsequence bound by the indexes start (inclusive)
 *        and end (exclusive)
 */
com.rpl.specter.srange = com.rpl.specter.impl.direct_nav_obj((function (start,end){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42790 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42790 = (function (start,end,meta42791){
this.start = start;
this.end = end;
this.meta42791 = meta42791;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42790.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42792,meta42791__$1){
var self__ = this;
var _42792__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42790(self__.start,self__.end,meta42791__$1));
}));

(com.rpl.specter.t_com$rpl$specter42790.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42792){
var self__ = this;
var _42792__$1 = this;
return self__.meta42791;
}));

(com.rpl.specter.t_com$rpl$specter42790.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42790.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return com.rpl.specter.navs.srange_select(structure,self__.start,self__.end,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42790.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(structure,self__.start,self__.end,next_fn) : com.rpl.specter.navs.srange_transform.call(null,structure,self__.start,self__.end,next_fn));
}));

(com.rpl.specter.t_com$rpl$specter42790.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"meta42791","meta42791",274484758,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42790.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42790.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42790");

(com.rpl.specter.t_com$rpl$specter42790.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42790");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42790.
 */
com.rpl.specter.__GT_t_com$rpl$specter42790 = (function com$rpl$specter$__GT_t_com$rpl$specter42790(start__$1,end__$1,meta42791){
return (new com.rpl.specter.t_com$rpl$specter42790(start__$1,end__$1,meta42791));
});

}

return (new com.rpl.specter.t_com$rpl$specter42790(start,end,null));
}));


com.rpl.specter.continuous_subseqs_select_STAR_ = (function com$rpl$specter$continuous_subseqs_select_STAR_(pred,structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38667__auto__,p__42793){
var vec__42794 = p__42793;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42794,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42794,(1),null);
var ret__38668__auto__ = com.rpl.specter.navs.srange_select(structure,s,e,next_fn);
if((ret__38668__auto__ === com.rpl.specter.NONE)){
return curr__38667__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38668__auto__)){
return cljs.core.reduced(ret__38668__auto__);
} else {
return ret__38668__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges(structure,pred));
});

com.rpl.specter.continuous_subseqs_transform_STAR_ = (function com$rpl$specter$continuous_subseqs_transform_STAR_(pred,structure,next_fn){
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_(pred,structure,next_fn);
});

/**
 * Navigates to every continuous subsequence of elements matching `pred`
 */
com.rpl.specter.continuous_subseqs = com.rpl.specter.impl.direct_nav_obj((function (pred){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42797 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42797 = (function (pred,meta42798){
this.pred = pred;
this.meta42798 = meta42798;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42797.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42799,meta42798__$1){
var self__ = this;
var _42799__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42797(self__.pred,meta42798__$1));
}));

(com.rpl.specter.t_com$rpl$specter42797.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42799){
var self__ = this;
var _42799__$1 = this;
return self__.meta42798;
}));

(com.rpl.specter.t_com$rpl$specter42797.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42797.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38667__auto__,p__42800){
var vec__42801 = p__42800;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42801,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42801,(1),null);
var ret__38668__auto__ = com.rpl.specter.navs.srange_select(structure,s,e,next_fn);
if((ret__38668__auto__ === com.rpl.specter.NONE)){
return curr__38667__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38668__auto__)){
return cljs.core.reduced(ret__38668__auto__);
} else {
return ret__38668__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges(structure,self__.pred));
}));

(com.rpl.specter.t_com$rpl$specter42797.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_(self__.pred,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42797.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"meta42798","meta42798",-455404325,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42797.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42797.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42797");

(com.rpl.specter.t_com$rpl$specter42797.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42797");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42797.
 */
com.rpl.specter.__GT_t_com$rpl$specter42797 = (function com$rpl$specter$__GT_t_com$rpl$specter42797(pred__$1,meta42798){
return (new com.rpl.specter.t_com$rpl$specter42797(pred__$1,meta42798));
});

}

return (new com.rpl.specter.t_com$rpl$specter42797(pred,null));
}));


com.rpl.specter.BEGINNING_select_STAR_ = (function com$rpl$specter$BEGINNING_select_STAR_(structure,next_fn){
var G__42804 = ((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42804) : next_fn.call(null,G__42804));
});

com.rpl.specter.BEGINNING_transform_STAR_ = (function com$rpl$specter$BEGINNING_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1("") : next_fn.call(null,""))),structure].join('');
} else {
var to_prepend = (function (){var G__42805 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42805) : next_fn.call(null,G__42805));
})();
return com.rpl.specter.navs.prepend_all(structure,to_prepend);
}
});

/**
 * Navigate to the empty subsequence before the first element of the collection.
 */
com.rpl.specter.BEGINNING = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42806 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42806 = (function (meta42807){
this.meta42807 = meta42807;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42806.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42808,meta42807__$1){
var self__ = this;
var _42808__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42806(meta42807__$1));
}));

(com.rpl.specter.t_com$rpl$specter42806.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42808){
var self__ = this;
var _42808__$1 = this;
return self__.meta42807;
}));

(com.rpl.specter.t_com$rpl$specter42806.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42806.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return next_fn(((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
}));

(com.rpl.specter.t_com$rpl$specter42806.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn("")),structure].join('');
} else {
var to_prepend = next_fn(cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all(structure,to_prepend);
}
}));

(com.rpl.specter.t_com$rpl$specter42806.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42807","meta42807",-2110746000,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42806.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42806.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42806");

(com.rpl.specter.t_com$rpl$specter42806.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42806");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42806.
 */
com.rpl.specter.__GT_t_com$rpl$specter42806 = (function com$rpl$specter$__GT_t_com$rpl$specter42806(meta42807){
return (new com.rpl.specter.t_com$rpl$specter42806(meta42807));
});

}

return (new com.rpl.specter.t_com$rpl$specter42806(null));
})()
;


com.rpl.specter.END_select_STAR_ = (function com$rpl$specter$END_select_STAR_(structure,next_fn){
var G__42809 = ((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42809) : next_fn.call(null,G__42809));
});

com.rpl.specter.END_transform_STAR_ = (function com$rpl$specter$END_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [structure,cljs.core.str.cljs$core$IFn$_invoke$arity$1((next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1("") : next_fn.call(null,"")))].join('');
} else {
var to_append = (function (){var G__42810 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42810) : next_fn.call(null,G__42810));
})();
return com.rpl.specter.navs.append_all(structure,to_append);
}
});

/**
 * Navigate to the empty subsequence after the last element of the collection.
 */
com.rpl.specter.END = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42811 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42811 = (function (meta42812){
this.meta42812 = meta42812;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42811.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42813,meta42812__$1){
var self__ = this;
var _42813__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42811(meta42812__$1));
}));

(com.rpl.specter.t_com$rpl$specter42811.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42813){
var self__ = this;
var _42813__$1 = this;
return self__.meta42812;
}));

(com.rpl.specter.t_com$rpl$specter42811.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42811.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return next_fn(((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
}));

(com.rpl.specter.t_com$rpl$specter42811.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
if(typeof structure === 'string'){
return [structure,cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn(""))].join('');
} else {
var to_append = next_fn(cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all(structure,to_append);
}
}));

(com.rpl.specter.t_com$rpl$specter42811.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42812","meta42812",767849606,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42811.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42811.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42811");

(com.rpl.specter.t_com$rpl$specter42811.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42811");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42811.
 */
com.rpl.specter.__GT_t_com$rpl$specter42811 = (function com$rpl$specter$__GT_t_com$rpl$specter42811(meta42812){
return (new com.rpl.specter.t_com$rpl$specter42811(meta42812));
});

}

return (new com.rpl.specter.t_com$rpl$specter42811(null));
})()
;


com.rpl.specter.NONE_ELEM_select_STAR_ = (function com$rpl$specter$NONE_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.NONE_ELEM_transform_STAR_ = (function com$rpl$specter$NONE_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(structure,newe);
}
}
});

/**
 * Navigate to 'void' elem in the set.
 *        For transformations - if result is not `NONE`,
 *        then add that value to the set.
 */
com.rpl.specter.NONE_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42814 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42814 = (function (meta42815){
this.meta42815 = meta42815;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42814.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42816,meta42815__$1){
var self__ = this;
var _42816__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42814(meta42815__$1));
}));

(com.rpl.specter.t_com$rpl$specter42814.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42816){
var self__ = this;
var _42816__$1 = this;
return self__.meta42815;
}));

(com.rpl.specter.t_com$rpl$specter42814.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42814.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter42814.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(structure,newe);
}
}
}));

(com.rpl.specter.t_com$rpl$specter42814.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42815","meta42815",1591070598,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42814.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42814.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42814");

(com.rpl.specter.t_com$rpl$specter42814.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42814");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42814.
 */
com.rpl.specter.__GT_t_com$rpl$specter42814 = (function com$rpl$specter$__GT_t_com$rpl$specter42814(meta42815){
return (new com.rpl.specter.t_com$rpl$specter42814(meta42815));
});

}

return (new com.rpl.specter.t_com$rpl$specter42814(null));
})()
;


com.rpl.specter.BEFORE_ELEM_select_STAR_ = (function com$rpl$specter$BEFORE_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.BEFORE_ELEM_transform_STAR_ = (function com$rpl$specter$BEFORE_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one(structure,newe);
}
});

/**
 * Navigate to 'void' element before the sequence.
 *        For transformations – if result is not `NONE`,
 *        then prepend that value.
 */
com.rpl.specter.BEFORE_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42817 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42817 = (function (meta42818){
this.meta42818 = meta42818;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42817.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42819,meta42818__$1){
var self__ = this;
var _42819__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42817(meta42818__$1));
}));

(com.rpl.specter.t_com$rpl$specter42817.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42819){
var self__ = this;
var _42819__$1 = this;
return self__.meta42818;
}));

(com.rpl.specter.t_com$rpl$specter42817.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42817.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter42817.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one(structure,newe);
}
}));

(com.rpl.specter.t_com$rpl$specter42817.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42818","meta42818",-1032888857,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42817.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42817.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42817");

(com.rpl.specter.t_com$rpl$specter42817.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42817");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42817.
 */
com.rpl.specter.__GT_t_com$rpl$specter42817 = (function com$rpl$specter$__GT_t_com$rpl$specter42817(meta42818){
return (new com.rpl.specter.t_com$rpl$specter42817(meta42818));
});

}

return (new com.rpl.specter.t_com$rpl$specter42817(null));
})()
;


com.rpl.specter.AFTER_ELEM_select_STAR_ = (function com$rpl$specter$AFTER_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.AFTER_ELEM_transform_STAR_ = (function com$rpl$specter$AFTER_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one(structure,newe);
}
});

/**
 * Navigate to 'void' element after the sequence.
 *        For transformations – if result is not `NONE`,
 *        then append that value.
 */
com.rpl.specter.AFTER_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42820 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42820 = (function (meta42821){
this.meta42821 = meta42821;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42820.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42822,meta42821__$1){
var self__ = this;
var _42822__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42820(meta42821__$1));
}));

(com.rpl.specter.t_com$rpl$specter42820.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42822){
var self__ = this;
var _42822__$1 = this;
return self__.meta42821;
}));

(com.rpl.specter.t_com$rpl$specter42820.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42820.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter42820.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one(structure,newe);
}
}));

(com.rpl.specter.t_com$rpl$specter42820.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42821","meta42821",-422517319,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42820.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42820.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42820");

(com.rpl.specter.t_com$rpl$specter42820.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42820");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42820.
 */
com.rpl.specter.__GT_t_com$rpl$specter42820 = (function com$rpl$specter$__GT_t_com$rpl$specter42820(meta42821){
return (new com.rpl.specter.t_com$rpl$specter42820(meta42821));
});

}

return (new com.rpl.specter.t_com$rpl$specter42820(null));
})()
;


com.rpl.specter.subset_select_STAR_ = (function com$rpl$specter$subset_select_STAR_(aset,structure,next_fn){
var G__42823 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,aset);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42823) : next_fn.call(null,G__42823));
});

com.rpl.specter.subset_transform_STAR_ = (function com$rpl$specter$subset_transform_STAR_(aset,structure,next_fn){
var subset = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,aset);
var newset = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(subset) : next_fn.call(null,subset));
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(structure,subset),newset);
});

/**
 * Navigates to the specified subset (by taking an intersection).
 *        In a transform, that subset in the original set is changed to the
 *        new value of the subset.
 */
com.rpl.specter.subset = com.rpl.specter.impl.direct_nav_obj((function (aset){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42824 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42824 = (function (aset,meta42825){
this.aset = aset;
this.meta42825 = meta42825;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42824.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42826,meta42825__$1){
var self__ = this;
var _42826__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42824(self__.aset,meta42825__$1));
}));

(com.rpl.specter.t_com$rpl$specter42824.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42826){
var self__ = this;
var _42826__$1 = this;
return self__.meta42825;
}));

(com.rpl.specter.t_com$rpl$specter42824.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42824.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return next_fn(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,self__.aset));
}));

(com.rpl.specter.t_com$rpl$specter42824.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
var subset = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,self__.aset);
var newset = next_fn(subset);
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(structure,subset),newset);
}));

(com.rpl.specter.t_com$rpl$specter42824.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"aset","aset",900773178,null),new cljs.core.Symbol(null,"meta42825","meta42825",1801271759,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42824.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42824.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42824");

(com.rpl.specter.t_com$rpl$specter42824.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42824");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42824.
 */
com.rpl.specter.__GT_t_com$rpl$specter42824 = (function com$rpl$specter$__GT_t_com$rpl$specter42824(aset__$1,meta42825){
return (new com.rpl.specter.t_com$rpl$specter42824(aset__$1,meta42825));
});

}

return (new com.rpl.specter.t_com$rpl$specter42824(aset,null));
}));


com.rpl.specter.submap_select_STAR_ = (function com$rpl$specter$submap_select_STAR_(m_keys,structure,next_fn){
var G__42827 = cljs.core.select_keys(structure,m_keys);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42827) : next_fn.call(null,G__42827));
});

com.rpl.specter.submap_transform_STAR_ = (function com$rpl$specter$submap_transform_STAR_(m_keys,structure,next_fn){
var submap = cljs.core.select_keys(structure,m_keys);
var newmap = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(submap) : next_fn.call(null,submap));
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,structure,m_keys),newmap], 0));
});

/**
 * Navigates to the specified submap (using select-keys).
 *        In a transform, that submap in the original map is changed to the new
 *        value of the submap.
 */
com.rpl.specter.submap = com.rpl.specter.impl.direct_nav_obj((function (m_keys){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42828 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42828 = (function (m_keys,meta42829){
this.m_keys = m_keys;
this.meta42829 = meta42829;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42828.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42830,meta42829__$1){
var self__ = this;
var _42830__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42828(self__.m_keys,meta42829__$1));
}));

(com.rpl.specter.t_com$rpl$specter42828.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42830){
var self__ = this;
var _42830__$1 = this;
return self__.meta42829;
}));

(com.rpl.specter.t_com$rpl$specter42828.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42828.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return next_fn(cljs.core.select_keys(structure,self__.m_keys));
}));

(com.rpl.specter.t_com$rpl$specter42828.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
var submap = cljs.core.select_keys(structure,self__.m_keys);
var newmap = next_fn(submap);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,structure,self__.m_keys),newmap], 0));
}));

(com.rpl.specter.t_com$rpl$specter42828.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"m-keys","m-keys",-197459035,null),new cljs.core.Symbol(null,"meta42829","meta42829",484359850,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42828.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42828.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42828");

(com.rpl.specter.t_com$rpl$specter42828.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42828");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42828.
 */
com.rpl.specter.__GT_t_com$rpl$specter42828 = (function com$rpl$specter$__GT_t_com$rpl$specter42828(m_keys__$1,meta42829){
return (new com.rpl.specter.t_com$rpl$specter42828(m_keys__$1,meta42829));
});

}

return (new com.rpl.specter.t_com$rpl$specter42828(m_keys,null));
}));
/**
 * Navigates to a sequence that contains the results of (select ...),
 *   but is a view to the original structure that can be transformed.
 * 
 *   Requires that the input navigators will walk the structure's
 *   children in the same order when executed on "select" and then
 *   "transform".
 * 
 *   If transformed sequence is smaller than input sequence, missing entries
 *   will be filled in with NONE, triggering removal if supported by that navigator.
 * 
 *   Value collection (e.g. collect, collect-one) may not be used in the subpath.
 */
com.rpl.specter.subselect = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43078__delegate = function (path){
var builder__41683__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42831 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42831 = (function (path,late,meta42832){
this.path = path;
this.late = late;
this.meta42832 = meta42832;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42831.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42833,meta42832__$1){
var self__ = this;
var _42833__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42831(self__.path,self__.late,meta42832__$1));
}));

(com.rpl.specter.t_com$rpl$specter42831.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42833){
var self__ = this;
var _42833__$1 = this;
return self__.meta42832;
}));

(com.rpl.specter.t_com$rpl$specter42831.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42831.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return next_fn((com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
}));

(com.rpl.specter.t_com$rpl$specter42831.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
var select_result = (com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure));
var transformed = next_fn(select_result);
var values_to_insert = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(transformed));
var G__42834 = self__.late;
var G__42835 = (function (_){
var vs = com.rpl.specter.impl.get_cell(values_to_insert);
if(cljs.core.truth_(vs)){
com.rpl.specter.impl.update_cell_BANG_(values_to_insert,cljs.core.next);

return cljs.core.first(vs);
} else {
return com.rpl.specter.NONE;
}
});
var G__42836 = structure;
return (com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(G__42834,G__42835,G__42836) : com.rpl.specter.compiled_transform.call(null,G__42834,G__42835,G__42836));
}));

(com.rpl.specter.t_com$rpl$specter42831.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta42832","meta42832",-172980149,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42831.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42831.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42831");

(com.rpl.specter.t_com$rpl$specter42831.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42831");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42831.
 */
com.rpl.specter.__GT_t_com$rpl$specter42831 = (function com$rpl$specter$__GT_t_com$rpl$specter42831(path__$1,late__$1,meta42832){
return (new com.rpl.specter.t_com$rpl$specter42831(path__$1,late__$1,meta42832));
});

}

return (new com.rpl.specter.t_com$rpl$specter42831(path,late,null));
}));
var curr_params__41684__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__41684__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__41683__auto__,curr_params__41684__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__41683__auto__,curr_params__41684__auto__,null);
}
};
var G__43078 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__43079__i = 0, G__43079__a = new Array(arguments.length -  0);
while (G__43079__i < G__43079__a.length) {G__43079__a[G__43079__i] = arguments[G__43079__i + 0]; ++G__43079__i;}
  path = new cljs.core.IndexedSeq(G__43079__a,0,null);
} 
return G__43078__delegate.call(this,path);};
G__43078.cljs$lang$maxFixedArity = 0;
G__43078.cljs$lang$applyTo = (function (arglist__43080){
var path = cljs.core.seq(arglist__43080);
return G__43078__delegate(path);
});
G__43078.cljs$core$IFn$_invoke$arity$variadic = G__43078__delegate;
return G__43078;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the given key in the map (not to the value). Navigates only if the
 *        key currently exists in the map. Can transform to NONE to remove the key/value
 *        pair from the map.
 */
com.rpl.specter.map_key = com.rpl.specter.impl.direct_nav_obj((function (key){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42837 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42837 = (function (key,meta42838){
this.key = key;
this.meta42838 = meta42838;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42837.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42839,meta42838__$1){
var self__ = this;
var _42839__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42837(self__.key,meta42838__$1));
}));

(com.rpl.specter.t_com$rpl$specter42837.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42839){
var self__ = this;
var _42839__$1 = this;
return self__.meta42838;
}));

(com.rpl.specter.t_com$rpl$specter42837.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42837.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.key)){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.key) : next_fn.call(null,vals,self__.key));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter42837.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.key)){
var newkey = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.key) : next_fn.call(null,vals,self__.key));
var dissoced = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(structure,self__.key);
if((com.rpl.specter.NONE === newkey)){
return dissoced;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(dissoced,newkey,cljs.core.get.cljs$core$IFn$_invoke$arity$2(structure,self__.key));
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter42837.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"meta42838","meta42838",-130523657,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42837.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42837.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42837");

(com.rpl.specter.t_com$rpl$specter42837.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42837");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42837.
 */
com.rpl.specter.__GT_t_com$rpl$specter42837 = (function com$rpl$specter$__GT_t_com$rpl$specter42837(key__$1,meta42838){
return (new com.rpl.specter.t_com$rpl$specter42837(key__$1,meta42838));
});

}

return (new com.rpl.specter.t_com$rpl$specter42837(key,null));
}));
/**
 * Navigates to the given element in the set only if it exists in the set.
 *        Can transform to NONE to remove the element from the set.
 */
com.rpl.specter.set_elem = com.rpl.specter.impl.direct_nav_obj((function (elem){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42840 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42840 = (function (elem,meta42841){
this.elem = elem;
this.meta42841 = meta42841;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42840.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42842,meta42841__$1){
var self__ = this;
var _42842__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42840(self__.elem,meta42841__$1));
}));

(com.rpl.specter.t_com$rpl$specter42840.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42842){
var self__ = this;
var _42842__$1 = this;
return self__.meta42841;
}));

(com.rpl.specter.t_com$rpl$specter42840.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42840.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.elem)){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.elem) : next_fn.call(null,vals,self__.elem));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter42840.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.elem)){
var newelem = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.elem) : next_fn.call(null,vals,self__.elem));
var removed = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(structure,self__.elem);
if((com.rpl.specter.NONE === newelem)){
return removed;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(removed,newelem);
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter42840.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"elem","elem",-2035804713,null),new cljs.core.Symbol(null,"meta42841","meta42841",1149460474,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42840.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42840.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42840");

(com.rpl.specter.t_com$rpl$specter42840.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42840");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42840.
 */
com.rpl.specter.__GT_t_com$rpl$specter42840 = (function com$rpl$specter$__GT_t_com$rpl$specter42840(elem__$1,meta42841){
return (new com.rpl.specter.t_com$rpl$specter42840(elem__$1,meta42841));
});

}

return (new com.rpl.specter.t_com$rpl$specter42840(elem,null));
}));
/**
 * Navigate to the specified keys one after another. If navigate to NONE,
 *           that element is removed from the map or vector.
 */
com.rpl.specter.keypath = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.keypath_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.keypath_STAR_));
/**
 * Navigate to the specified keys one after another, only if they exist
 *           in the data structure. If navigate to NONE, that element is removed
 *           from the map or vector.
 */
com.rpl.specter.must = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.must_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.must_STAR_));
/**
 * Navigate to the specified indices one after another. If navigate to
 *          NONE, that element is removed from the sequence.
 */
com.rpl.specter.nthpath = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.nthpath_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.nthpath_STAR_));
/**
 * Navigates to the empty space between the index and the prior index. For select
 *        navigates to NONE, and transforms to non-NONE insert at that position.
 */
com.rpl.specter.before_index = com.rpl.specter.impl.direct_nav_obj((function (index){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42843 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42843 = (function (index,meta42844){
this.index = index;
this.meta42844 = meta42844;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42843.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42845,meta42844__$1){
var self__ = this;
var _42845__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42843(self__.index,meta42844__$1));
}));

(com.rpl.specter.t_com$rpl$specter42843.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42845){
var self__ = this;
var _42845__$1 = this;
return self__.meta42844;
}));

(com.rpl.specter.t_com$rpl$specter42843.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42843.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter42843.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var v = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,com.rpl.specter.NONE) : next_fn.call(null,vals,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === v)){
return structure;
} else {
return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__41690__auto__ = com.rpl.specter.pathcache42846;
var info__41690__auto____$1 = (((info__41690__auto__ == null))?(function (){var info42847 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.srange,new cljs.core.Var(function(){return com.rpl.specter.srange;},new cljs.core.Symbol("com.rpl.specter","srange","com.rpl.specter/srange",-978851939,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"srange","srange",-1324254972,null),"com/rpl/specter.cljc",9,1,755,758,cljs.core.List.EMPTY,"Navigates to the subsequence bound by the indexes start (inclusive)\n          and end (exclusive)",(cljs.core.truth_(com.rpl.specter.srange)?com.rpl.specter.srange.cljs$lang$test:null)])),new cljs.core.Symbol(null,"srange","srange",-1324254972,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(self__.index,new cljs.core.Symbol(null,"index","index",108845612,null)),com.rpl.specter.impl.__GT_LocalSym(self__.index,new cljs.core.Symbol(null,"index","index",108845612,null))], null),cljs.core.list(new cljs.core.Symbol(null,"srange","srange",-1324254972,null),new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"srange","srange",-1324254972,null),new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)], null));
com.rpl.specter.pathcache42846 = info42847;

return info42847;
})():info__41690__auto__);
var precompiled42848 = com.rpl.specter.impl.cached_path_info_precompiled(info__41690__auto____$1);
var dynamic_QMARK___41691__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41690__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41691__auto__)){
var G__42849 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.srange,self__.index,self__.index], null);
return (precompiled42848.cljs$core$IFn$_invoke$arity$1 ? precompiled42848.cljs$core$IFn$_invoke$arity$1(G__42849) : precompiled42848.call(null,G__42849));
} else {
return precompiled42848;
}
})(),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v], null),structure);
}
}));

(com.rpl.specter.t_com$rpl$specter42843.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"meta42844","meta42844",469235647,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42843.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42843.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42843");

(com.rpl.specter.t_com$rpl$specter42843.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42843");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42843.
 */
com.rpl.specter.__GT_t_com$rpl$specter42843 = (function com$rpl$specter$__GT_t_com$rpl$specter42843(index__$1,meta42844){
return (new com.rpl.specter.t_com$rpl$specter42843(index__$1,meta42844));
});

}

return (new com.rpl.specter.t_com$rpl$specter42843(index,null));
}));
/**
 * Navigates to the index of the sequence if within 0 and size. Transforms move element
 *        at that index to the new index, shifting other elements in the sequence.
 */
com.rpl.specter.index_nav = com.rpl.specter.impl.direct_nav_obj((function (i){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42850 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42850 = (function (i,meta42851){
this.i = i;
this.meta42851 = meta42851;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42850.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42852,meta42851__$1){
var self__ = this;
var _42852__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42850(self__.i,meta42851__$1));
}));

(com.rpl.specter.t_com$rpl$specter42850.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42852){
var self__ = this;
var _42852__$1 = this;
return self__.meta42851;
}));

(com.rpl.specter.t_com$rpl$specter42850.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42850.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if((((self__.i >= (0))) && ((self__.i < cljs.core.count(structure))))){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.i) : next_fn.call(null,vals,self__.i));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter42850.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if((((self__.i >= (0))) && ((self__.i < cljs.core.count(structure))))){
var newi = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.i) : next_fn.call(null,vals,self__.i));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(newi,self__.i)){
return structure;
} else {
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(structure,self__.i);
if(cljs.core.vector_QMARK_(structure)){
var shifted = (((newi < self__.i))?(function (){var j = (self__.i - (1));
var s = structure;
while(true){
if((j < newi)){
return s;
} else {
var G__43081 = (j - (1));
var G__43082 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,(j + (1)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(s,j));
j = G__43081;
s = G__43082;
continue;
}
break;
}
})():(function (){var j = (self__.i + (1));
var s = structure;
while(true){
if((j > newi)){
return s;
} else {
var G__43083 = (j + (1));
var G__43084 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,(j - (1)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(s,j));
j = G__43083;
s = G__43084;
continue;
}
break;
}
})());
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(shifted,newi,v);
} else {
return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__41690__auto__ = com.rpl.specter.pathcache42853;
var info__41690__auto____$1 = (((info__41690__auto__ == null))?(function (){var info42854 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.before_index,new cljs.core.Var(function(){return com.rpl.specter.before_index;},new cljs.core.Symbol("com.rpl.specter","before-index","com.rpl.specter/before-index",1952616274,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),"com/rpl/specter.cljc",15,1,968,971,cljs.core.List.EMPTY,"Navigates to the empty space between the index and the prior index. For select\n          navigates to NONE, and transforms to non-NONE insert at that position.",(cljs.core.truth_(com.rpl.specter.before_index)?com.rpl.specter.before_index.cljs$lang$test:null)])),new cljs.core.Symbol(null,"before-index","before-index",-407870261,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(newi,new cljs.core.Symbol(null,"newi","newi",857919881,null))], null),cljs.core.list(new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null));
com.rpl.specter.pathcache42853 = info42854;

return info42854;
})():info__41690__auto__);
var precompiled42855 = com.rpl.specter.impl.cached_path_info_precompiled(info__41690__auto____$1);
var dynamic_QMARK___41691__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41690__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41691__auto__)){
var G__42856 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.before_index,newi], null);
return (precompiled42855.cljs$core$IFn$_invoke$arity$1 ? precompiled42855.cljs$core$IFn$_invoke$arity$1(G__42856) : precompiled42855.call(null,G__42856));
} else {
return precompiled42855;
}
})(),v,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__41690__auto__ = com.rpl.specter.pathcache42857;
var info__41690__auto____$1 = (((info__41690__auto__ == null))?(function (){var info42858 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(self__.i,new cljs.core.Symbol(null,"i","i",253690212,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"i","i",253690212,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"i","i",253690212,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"i","i",253690212,null)], null));
com.rpl.specter.pathcache42857 = info42858;

return info42858;
})():info__41690__auto__);
var precompiled42859 = com.rpl.specter.impl.cached_path_info_precompiled(info__41690__auto____$1);
var dynamic_QMARK___41691__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41690__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41691__auto__)){
var G__42860 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,self__.i], null);
return (precompiled42859.cljs$core$IFn$_invoke$arity$1 ? precompiled42859.cljs$core$IFn$_invoke$arity$1(G__42860) : precompiled42859.call(null,G__42860));
} else {
return precompiled42859;
}
})(),com.rpl.specter.NONE,structure));
}
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter42850.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta42851","meta42851",1463756593,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42850.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42850.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42850");

(com.rpl.specter.t_com$rpl$specter42850.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42850");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42850.
 */
com.rpl.specter.__GT_t_com$rpl$specter42850 = (function com$rpl$specter$__GT_t_com$rpl$specter42850(i__$1,meta42851){
return (new com.rpl.specter.t_com$rpl$specter42850(i__$1,meta42851));
});

}

return (new com.rpl.specter.t_com$rpl$specter42850(i,null));
}));


com.rpl.specter.indexed_vals_select_STAR_ = (function com$rpl$specter$indexed_vals_select_STAR_(start,structure,next_fn){
var i = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1((start - (1)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38667__auto__,e){
var ret__38668__auto__ = (function (){
com.rpl.specter.impl.update_cell_BANG_(i,cljs.core.inc);

var G__42863 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.get_cell(i),e], null);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42863) : next_fn.call(null,G__42863));
})()
;
if((ret__38668__auto__ === com.rpl.specter.NONE)){
return curr__38667__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38668__auto__)){
return cljs.core.reduced(ret__38668__auto__);
} else {
return ret__38668__auto__;
}
}
}),com.rpl.specter.NONE,structure);
});

com.rpl.specter.indexed_vals_transform_STAR_ = (function com$rpl$specter$indexed_vals_transform_STAR_(start,structure,next_fn){
var indices = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(structure)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s,e){
var curri = cljs.core.first(com.rpl.specter.impl.get_cell(indices));
var vec__42864 = (function (){var G__42867 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(start + curri),e], null);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42867) : next_fn.call(null,G__42867));
})();
var newi_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42864,(0),null);
var newe = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42864,(1),null);
var newi = (newi_STAR_ - start);
com.rpl.specter.impl.update_cell_BANG_(indices,(function (ii){
var ii2 = cljs.core.next(ii);
if((newi > curri)){
return com.rpl.specter.impl.compiled_transform_STAR_((function (){var info__41690__auto__ = com.rpl.specter.pathcache42868;
var info__41690__auto____$1 = (((info__41690__auto__ == null))?(function (){var info42869 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__42861_SHARP_){
return (p1__42861_SHARP_ >= (curri + (1)));
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42861#","p1__42861#",1859102105,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__42861#","p1__42861#",1859102105,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null))))),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__42862_SHARP_){
return (p1__42862_SHARP_ <= newi);
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42862#","p1__42862#",493273116,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__42862#","p1__42862#",493273116,null),new cljs.core.Symbol(null,"newi","newi",857919881,null))))], null)], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42861#","p1__42861#",1859102105,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__42861#","p1__42861#",1859102105,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42862#","p1__42862#",493273116,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__42862#","p1__42862#",493273116,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42861#","p1__42861#",1859102105,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__42861#","p1__42861#",1859102105,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42862#","p1__42862#",493273116,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__42862#","p1__42862#",493273116,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null));
com.rpl.specter.pathcache42868 = info42869;

return info42869;
})():info__41690__auto__);
var precompiled42870 = com.rpl.specter.impl.cached_path_info_precompiled(info__41690__auto____$1);
var dynamic_QMARK___41691__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41690__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41691__auto__)){
var G__42871 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,(function (p1__42861_SHARP_){
return (p1__42861_SHARP_ >= (curri + (1)));
}),(function (p1__42862_SHARP_){
return (p1__42862_SHARP_ <= newi);
})], null),com.rpl.specter.ALL,(function (p1__42861_SHARP_){
return (p1__42861_SHARP_ >= (curri + (1)));
}),(function (p1__42862_SHARP_){
return (p1__42862_SHARP_ <= newi);
})], null);
return (precompiled42870.cljs$core$IFn$_invoke$arity$1 ? precompiled42870.cljs$core$IFn$_invoke$arity$1(G__42871) : precompiled42870.call(null,G__42871));
} else {
return precompiled42870;
}
})(),cljs.core.dec,ii2);
} else {
return ii2;
}
}));

return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__41690__auto__ = com.rpl.specter.pathcache42872;
var info__41690__auto____$1 = (((info__41690__auto__ == null))?(function (){var info42873 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.index_nav,new cljs.core.Var(function(){return com.rpl.specter.index_nav;},new cljs.core.Symbol("com.rpl.specter","index-nav","com.rpl.specter/index-nav",2054501071,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),"com/rpl/specter.cljc",12,1,983,986,cljs.core.List.EMPTY,"Navigates to the index of the sequence if within 0 and size. Transforms move element\n          at that index to the new index, shifting other elements in the sequence.",(cljs.core.truth_(com.rpl.specter.index_nav)?com.rpl.specter.index_nav.cljs$lang$test:null)])),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache42872 = info42873;

return info42873;
})():info__41690__auto__);
var precompiled42874 = com.rpl.specter.impl.cached_path_info_precompiled(info__41690__auto____$1);
var dynamic_QMARK___41691__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41690__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41691__auto__)){
var G__42875 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.index_nav,curri], null);
return (precompiled42874.cljs$core$IFn$_invoke$arity$1 ? precompiled42874.cljs$core$IFn$_invoke$arity$1(G__42875) : precompiled42874.call(null,G__42875));
} else {
return precompiled42874;
}
})(),newi,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__41690__auto__ = com.rpl.specter.pathcache42876;
var info__41690__auto____$1 = (((info__41690__auto__ == null))?(function (){var info42877 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache42876 = info42877;

return info42877;
})():info__41690__auto__);
var precompiled42878 = com.rpl.specter.impl.cached_path_info_precompiled(info__41690__auto____$1);
var dynamic_QMARK___41691__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41690__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41691__auto__)){
var G__42879 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,curri], null);
return (precompiled42878.cljs$core$IFn$_invoke$arity$1 ? precompiled42878.cljs$core$IFn$_invoke$arity$1(G__42879) : precompiled42878.call(null,G__42879));
} else {
return precompiled42878;
}
})(),newe,s));
}),structure,structure);
});

/**
 * Navigate to [index elem] pairs for each element in a sequence. The sequence will be indexed
 *        starting from `start`. Changing index in transform has same effect as `index-nav`. Indices seen
 *        during transform take into account any shifting from prior sequence elements changing indices.
 */
com.rpl.specter.indexed_vals = com.rpl.specter.impl.direct_nav_obj((function (start){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42880 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42880 = (function (start,meta42881){
this.start = start;
this.meta42881 = meta42881;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42880.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42882,meta42881__$1){
var self__ = this;
var _42882__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42880(self__.start,meta42881__$1));
}));

(com.rpl.specter.t_com$rpl$specter42880.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42882){
var self__ = this;
var _42882__$1 = this;
return self__.meta42881;
}));

(com.rpl.specter.t_com$rpl$specter42880.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42880.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
var i = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1((self__.start - (1)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38667__auto__,e){
var ret__38668__auto__ = (function (){
com.rpl.specter.impl.update_cell_BANG_(i,cljs.core.inc);

return next_fn(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.get_cell(i),e], null));
})()
;
if((ret__38668__auto__ === com.rpl.specter.NONE)){
return curr__38667__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38668__auto__)){
return cljs.core.reduced(ret__38668__auto__);
} else {
return ret__38668__auto__;
}
}
}),com.rpl.specter.NONE,structure);
}));

(com.rpl.specter.t_com$rpl$specter42880.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
var indices = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(structure)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s,e){
var curri = cljs.core.first(com.rpl.specter.impl.get_cell(indices));
var vec__42883 = next_fn(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.start + curri),e], null));
var newi_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42883,(0),null);
var newe = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42883,(1),null);
var newi = (newi_STAR_ - self__.start);
com.rpl.specter.impl.update_cell_BANG_(indices,(function (ii){
var ii2 = cljs.core.next(ii);
if((newi > curri)){
return com.rpl.specter.impl.compiled_transform_STAR_((function (){var info__41690__auto__ = com.rpl.specter.pathcache42886;
var info__41690__auto____$1 = (((info__41690__auto__ == null))?(function (){var info42887 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__42861_SHARP_){
return (p1__42861_SHARP_ >= (curri + (1)));
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42861#","p1__42861#",1859102105,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__42861#","p1__42861#",1859102105,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null))))),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__42862_SHARP_){
return (p1__42862_SHARP_ <= newi);
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42862#","p1__42862#",493273116,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__42862#","p1__42862#",493273116,null),new cljs.core.Symbol(null,"newi","newi",857919881,null))))], null)], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42861#","p1__42861#",1859102105,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__42861#","p1__42861#",1859102105,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42862#","p1__42862#",493273116,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__42862#","p1__42862#",493273116,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42861#","p1__42861#",1859102105,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__42861#","p1__42861#",1859102105,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__42862#","p1__42862#",493273116,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__42862#","p1__42862#",493273116,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null));
com.rpl.specter.pathcache42886 = info42887;

return info42887;
})():info__41690__auto__);
var precompiled42888 = com.rpl.specter.impl.cached_path_info_precompiled(info__41690__auto____$1);
var dynamic_QMARK___41691__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41690__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41691__auto__)){
var G__42889 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,(function (p1__42861_SHARP_){
return (p1__42861_SHARP_ >= (curri + (1)));
}),(function (p1__42862_SHARP_){
return (p1__42862_SHARP_ <= newi);
})], null),com.rpl.specter.ALL,(function (p1__42861_SHARP_){
return (p1__42861_SHARP_ >= (curri + (1)));
}),(function (p1__42862_SHARP_){
return (p1__42862_SHARP_ <= newi);
})], null);
return (precompiled42888.cljs$core$IFn$_invoke$arity$1 ? precompiled42888.cljs$core$IFn$_invoke$arity$1(G__42889) : precompiled42888.call(null,G__42889));
} else {
return precompiled42888;
}
})(),cljs.core.dec,ii2);
} else {
return ii2;
}
}));

return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__41690__auto__ = com.rpl.specter.pathcache42890;
var info__41690__auto____$1 = (((info__41690__auto__ == null))?(function (){var info42891 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.index_nav,new cljs.core.Var(function(){return com.rpl.specter.index_nav;},new cljs.core.Symbol("com.rpl.specter","index-nav","com.rpl.specter/index-nav",2054501071,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),"com/rpl/specter.cljc",12,1,983,986,cljs.core.List.EMPTY,"Navigates to the index of the sequence if within 0 and size. Transforms move element\n          at that index to the new index, shifting other elements in the sequence.",(cljs.core.truth_(com.rpl.specter.index_nav)?com.rpl.specter.index_nav.cljs$lang$test:null)])),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache42890 = info42891;

return info42891;
})():info__41690__auto__);
var precompiled42892 = com.rpl.specter.impl.cached_path_info_precompiled(info__41690__auto____$1);
var dynamic_QMARK___41691__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41690__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41691__auto__)){
var G__42893 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.index_nav,curri], null);
return (precompiled42892.cljs$core$IFn$_invoke$arity$1 ? precompiled42892.cljs$core$IFn$_invoke$arity$1(G__42893) : precompiled42892.call(null,G__42893));
} else {
return precompiled42892;
}
})(),newi,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__41690__auto__ = com.rpl.specter.pathcache42894;
var info__41690__auto____$1 = (((info__41690__auto__ == null))?(function (){var info42895 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache42894 = info42895;

return info42895;
})():info__41690__auto__);
var precompiled42896 = com.rpl.specter.impl.cached_path_info_precompiled(info__41690__auto____$1);
var dynamic_QMARK___41691__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41690__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41691__auto__)){
var G__42897 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,curri], null);
return (precompiled42896.cljs$core$IFn$_invoke$arity$1 ? precompiled42896.cljs$core$IFn$_invoke$arity$1(G__42897) : precompiled42896.call(null,G__42897));
} else {
return precompiled42896;
}
})(),newe,s));
}),structure,structure);
}));

(com.rpl.specter.t_com$rpl$specter42880.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"meta42881","meta42881",-707921093,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42880.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42880.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42880");

(com.rpl.specter.t_com$rpl$specter42880.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42880");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42880.
 */
com.rpl.specter.__GT_t_com$rpl$specter42880 = (function com$rpl$specter$__GT_t_com$rpl$specter42880(start__$1,meta42881){
return (new com.rpl.specter.t_com$rpl$specter42880(start__$1,meta42881));
});

}

return (new com.rpl.specter.t_com$rpl$specter42880(start,null));
}));
/**
 * `indexed-vals` with a starting index of 0.
 */
com.rpl.specter.INDEXED_VALS = (com.rpl.specter.indexed_vals.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.indexed_vals.cljs$core$IFn$_invoke$arity$1((0)) : com.rpl.specter.indexed_vals.call(null,(0)));
/**
 * Navigates to result of running `afn` on the currently navigated value.
 */
com.rpl.specter.view = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42898 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42898 = (function (afn,meta42899){
this.afn = afn;
this.meta42899 = meta42899;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42898.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42900,meta42899__$1){
var self__ = this;
var _42900__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42898(self__.afn,meta42899__$1));
}));

(com.rpl.specter.t_com$rpl$specter42898.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42900){
var self__ = this;
var _42900__$1 = this;
return self__.meta42899;
}));

(com.rpl.specter.t_com$rpl$specter42898.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42898.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__42901 = vals;
var G__42902 = (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(structure) : self__.afn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__42901,G__42902) : next_fn.call(null,G__42901,G__42902));
}));

(com.rpl.specter.t_com$rpl$specter42898.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__42903 = vals;
var G__42904 = (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(structure) : self__.afn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__42903,G__42904) : next_fn.call(null,G__42903,G__42904));
}));

(com.rpl.specter.t_com$rpl$specter42898.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta42899","meta42899",-434882936,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42898.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42898.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42898");

(com.rpl.specter.t_com$rpl$specter42898.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42898");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42898.
 */
com.rpl.specter.__GT_t_com$rpl$specter42898 = (function com$rpl$specter$__GT_t_com$rpl$specter42898(afn__$1,meta42899){
return (new com.rpl.specter.t_com$rpl$specter42898(afn__$1,meta42899));
});

}

return (new com.rpl.specter.t_com$rpl$specter42898(afn,null));
}));


com.rpl.specter.parser_select_STAR_ = (function com$rpl$specter$parser_select_STAR_(parse_fn,unparse_fn,structure,next_fn){
var G__42905 = (parse_fn.cljs$core$IFn$_invoke$arity$1 ? parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : parse_fn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42905) : next_fn.call(null,G__42905));
});

com.rpl.specter.parser_transform_STAR_ = (function com$rpl$specter$parser_transform_STAR_(parse_fn,unparse_fn,structure,next_fn){
var G__42906 = (function (){var G__42907 = (parse_fn.cljs$core$IFn$_invoke$arity$1 ? parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : parse_fn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42907) : next_fn.call(null,G__42907));
})();
return (unparse_fn.cljs$core$IFn$_invoke$arity$1 ? unparse_fn.cljs$core$IFn$_invoke$arity$1(G__42906) : unparse_fn.call(null,G__42906));
});

/**
 * Navigate to the result of running `parse-fn` on the value. For
 *        transforms, the transformed value then has `unparse-fn` run on
 *        it to get the final value at this point.
 */
com.rpl.specter.parser = com.rpl.specter.impl.direct_nav_obj((function (parse_fn,unparse_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42908 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42908 = (function (parse_fn,unparse_fn,meta42909){
this.parse_fn = parse_fn;
this.unparse_fn = unparse_fn;
this.meta42909 = meta42909;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42908.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42910,meta42909__$1){
var self__ = this;
var _42910__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42908(self__.parse_fn,self__.unparse_fn,meta42909__$1));
}));

(com.rpl.specter.t_com$rpl$specter42908.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42910){
var self__ = this;
var _42910__$1 = this;
return self__.meta42909;
}));

(com.rpl.specter.t_com$rpl$specter42908.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42908.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return next_fn((self__.parse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.parse_fn.call(null,structure)));
}));

(com.rpl.specter.t_com$rpl$specter42908.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
var G__42911 = next_fn((self__.parse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.parse_fn.call(null,structure)));
return (self__.unparse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.unparse_fn.cljs$core$IFn$_invoke$arity$1(G__42911) : self__.unparse_fn.call(null,G__42911));
}));

(com.rpl.specter.t_com$rpl$specter42908.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parse-fn","parse-fn",-836029424,null),new cljs.core.Symbol(null,"unparse-fn","unparse-fn",407187734,null),new cljs.core.Symbol(null,"meta42909","meta42909",-1312052892,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42908.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42908.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42908");

(com.rpl.specter.t_com$rpl$specter42908.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42908");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42908.
 */
com.rpl.specter.__GT_t_com$rpl$specter42908 = (function com$rpl$specter$__GT_t_com$rpl$specter42908(parse_fn__$1,unparse_fn__$1,meta42909){
return (new com.rpl.specter.t_com$rpl$specter42908(parse_fn__$1,unparse_fn__$1,meta42909));
});

}

return (new com.rpl.specter.t_com$rpl$specter42908(parse_fn,unparse_fn,null));
}));


com.rpl.specter.ATOM_select_STAR_ = (function com$rpl$specter$ATOM_select_STAR_(structure,next_fn){
var G__42912 = cljs.core.deref(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42912) : next_fn.call(null,G__42912));
});

com.rpl.specter.ATOM_transform_STAR_ = (function com$rpl$specter$ATOM_transform_STAR_(structure,next_fn){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(structure,next_fn);

return structure;
});

/**
 * Navigates to atom value.
 */
com.rpl.specter.ATOM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42913 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42913 = (function (meta42914){
this.meta42914 = meta42914;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42913.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42915,meta42914__$1){
var self__ = this;
var _42915__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42913(meta42914__$1));
}));

(com.rpl.specter.t_com$rpl$specter42913.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42915){
var self__ = this;
var _42915__$1 = this;
return self__.meta42914;
}));

(com.rpl.specter.t_com$rpl$specter42913.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42913.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return next_fn(cljs.core.deref(structure));
}));

(com.rpl.specter.t_com$rpl$specter42913.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(structure,next_fn);

return structure;
}));

(com.rpl.specter.t_com$rpl$specter42913.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42914","meta42914",-929964804,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42913.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42913.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42913");

(com.rpl.specter.t_com$rpl$specter42913.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42913");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42913.
 */
com.rpl.specter.__GT_t_com$rpl$specter42913 = (function com$rpl$specter$__GT_t_com$rpl$specter42913(meta42914){
return (new com.rpl.specter.t_com$rpl$specter42913(meta42914));
});

}

return (new com.rpl.specter.t_com$rpl$specter42913(null));
})()
;


com.rpl.specter.regex_nav_select_STAR_ = (function com$rpl$specter$regex_nav_select_STAR_(re,structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38667__auto__,s){
var ret__38668__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(s) : next_fn.call(null,s));
if((ret__38668__auto__ === com.rpl.specter.NONE)){
return curr__38667__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38668__auto__)){
return cljs.core.reduced(ret__38668__auto__);
} else {
return ret__38668__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.re_seq(re,structure));
});

com.rpl.specter.regex_nav_transform_STAR_ = (function com$rpl$specter$regex_nav_transform_STAR_(re,structure,next_fn){
return clojure.string.replace(structure,re,next_fn);
});

com.rpl.specter.regex_nav = com.rpl.specter.impl.direct_nav_obj((function (re){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42916 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42916 = (function (re,meta42917){
this.re = re;
this.meta42917 = meta42917;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42916.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42918,meta42917__$1){
var self__ = this;
var _42918__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42916(self__.re,meta42917__$1));
}));

(com.rpl.specter.t_com$rpl$specter42916.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42918){
var self__ = this;
var _42918__$1 = this;
return self__.meta42917;
}));

(com.rpl.specter.t_com$rpl$specter42916.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42916.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38667__auto__,s){
var ret__38668__auto__ = next_fn(s);
if((ret__38668__auto__ === com.rpl.specter.NONE)){
return curr__38667__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38668__auto__)){
return cljs.core.reduced(ret__38668__auto__);
} else {
return ret__38668__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.re_seq(self__.re,structure));
}));

(com.rpl.specter.t_com$rpl$specter42916.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return clojure.string.replace(structure,self__.re,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42916.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"re","re",1869207729,null),new cljs.core.Symbol(null,"meta42917","meta42917",-2034685127,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42916.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42916.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42916");

(com.rpl.specter.t_com$rpl$specter42916.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42916");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42916.
 */
com.rpl.specter.__GT_t_com$rpl$specter42916 = (function com$rpl$specter$__GT_t_com$rpl$specter42916(re__$1,meta42917){
return (new com.rpl.specter.t_com$rpl$specter42916(re__$1,meta42917));
});

}

return (new com.rpl.specter.t_com$rpl$specter42916(re,null));
}));
/**
 * Filters the current value based on whether a path finds anything.
 *   e.g. (selected? :vals ALL even?) keeps the current element only if an
 *   even number exists for the :vals key.
 */
com.rpl.specter.selected_QMARK_ = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43110__delegate = function (path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(path);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
return afn;
} else {
var builder__41683__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42921 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42921 = (function (path,temp__5733__auto__,late,meta42922){
this.path = path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late = late;
this.meta42922 = meta42922;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42921.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42923,meta42922__$1){
var self__ = this;
var _42923__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42921(self__.path,self__.temp__5733__auto__,self__.late,meta42922__$1));
}));

(com.rpl.specter.t_com$rpl$specter42921.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42923){
var self__ = this;
var _42923__$1 = this;
return self__.meta42922;
}));

(com.rpl.specter.t_com$rpl$specter42921.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42921.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select((function (p1__42919_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late,vals,p1__42919_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42921.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform((function (p1__42920_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late,vals,p1__42920_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42921.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta42922","meta42922",-481857359,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42921.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42921.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42921");

(com.rpl.specter.t_com$rpl$specter42921.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42921");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42921.
 */
com.rpl.specter.__GT_t_com$rpl$specter42921 = (function com$rpl$specter$__GT_t_com$rpl$specter42921(path__$1,temp__5733__auto____$1,late__$1,meta42922){
return (new com.rpl.specter.t_com$rpl$specter42921(path__$1,temp__5733__auto____$1,late__$1,meta42922));
});

}

return (new com.rpl.specter.t_com$rpl$specter42921(path,temp__5733__auto__,late,null));
}));
var curr_params__41684__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__41684__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__41683__auto__,curr_params__41684__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__41683__auto__,curr_params__41684__auto__,null);
}
}
};
var G__43110 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__43123__i = 0, G__43123__a = new Array(arguments.length -  0);
while (G__43123__i < G__43123__a.length) {G__43123__a[G__43123__i] = arguments[G__43123__i + 0]; ++G__43123__i;}
  path = new cljs.core.IndexedSeq(G__43123__a,0,null);
} 
return G__43110__delegate.call(this,path);};
G__43110.cljs$lang$maxFixedArity = 0;
G__43110.cljs$lang$applyTo = (function (arglist__43124){
var path = cljs.core.seq(arglist__43124);
return G__43110__delegate(path);
});
G__43110.cljs$core$IFn$_invoke$arity$variadic = G__43110__delegate;
return G__43110;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.not_selected_QMARK_ = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43126__delegate = function (path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(path);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
return (function (s){
return cljs.core.not((afn.cljs$core$IFn$_invoke$arity$1 ? afn.cljs$core$IFn$_invoke$arity$1(s) : afn.call(null,s)));
});
} else {
var builder__41683__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42926 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42926 = (function (path,temp__5733__auto__,late,meta42927){
this.path = path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late = late;
this.meta42927 = meta42927;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42926.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42928,meta42927__$1){
var self__ = this;
var _42928__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42926(self__.path,self__.temp__5733__auto__,self__.late,meta42927__$1));
}));

(com.rpl.specter.t_com$rpl$specter42926.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42928){
var self__ = this;
var _42928__$1 = this;
return self__.meta42927;
}));

(com.rpl.specter.t_com$rpl$specter42926.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42926.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select((function (p1__42924_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_(self__.late,vals,p1__42924_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42926.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform((function (p1__42925_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_(self__.late,vals,p1__42925_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter42926.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta42927","meta42927",-436091052,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42926.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42926.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42926");

(com.rpl.specter.t_com$rpl$specter42926.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42926");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42926.
 */
com.rpl.specter.__GT_t_com$rpl$specter42926 = (function com$rpl$specter$__GT_t_com$rpl$specter42926(path__$1,temp__5733__auto____$1,late__$1,meta42927){
return (new com.rpl.specter.t_com$rpl$specter42926(path__$1,temp__5733__auto____$1,late__$1,meta42927));
});

}

return (new com.rpl.specter.t_com$rpl$specter42926(path,temp__5733__auto__,late,null));
}));
var curr_params__41684__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__41684__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__41683__auto__,curr_params__41684__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__41683__auto__,curr_params__41684__auto__,null);
}
}
};
var G__43126 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__43139__i = 0, G__43139__a = new Array(arguments.length -  0);
while (G__43139__i < G__43139__a.length) {G__43139__a[G__43139__i] = arguments[G__43139__i + 0]; ++G__43139__i;}
  path = new cljs.core.IndexedSeq(G__43139__a,0,null);
} 
return G__43126__delegate.call(this,path);};
G__43126.cljs$lang$maxFixedArity = 0;
G__43126.cljs$lang$applyTo = (function (arglist__43140){
var path = cljs.core.seq(arglist__43140);
return G__43126__delegate(path);
});
G__43126.cljs$core$IFn$_invoke$arity$variadic = G__43126__delegate;
return G__43126;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current sequence that only contains elements that
 *   match the given path. An element matches the selector path if calling select
 *   on that element with the path yields anything other than an empty sequence.
 * 
 *   For transformation: `NONE` entries in the result sequence cause corresponding entries in
 *   input to be removed. A result sequence smaller than the input sequence is equivalent to
 *   padding the result sequence with `NONE` at the end until the same size as the input.
 */
com.rpl.specter.filterer = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43141__delegate = function (path){
var G__42929 = com.rpl.specter.ALL;
var G__42930 = (com.rpl.specter.selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.selected_QMARK_.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.selected_QMARK_.call(null,path));
return (com.rpl.specter.subselect.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.subselect.cljs$core$IFn$_invoke$arity$2(G__42929,G__42930) : com.rpl.specter.subselect.call(null,G__42929,G__42930));
};
var G__43141 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__43144__i = 0, G__43144__a = new Array(arguments.length -  0);
while (G__43144__i < G__43144__a.length) {G__43144__a[G__43144__i] = arguments[G__43144__i + 0]; ++G__43144__i;}
  path = new cljs.core.IndexedSeq(G__43144__a,0,null);
} 
return G__43141__delegate.call(this,path);};
G__43141.cljs$lang$maxFixedArity = 0;
G__43141.cljs$lang$applyTo = (function (arglist__43145){
var path = cljs.core.seq(arglist__43145);
return G__43141__delegate(path);
});
G__43141.cljs$core$IFn$_invoke$arity$variadic = G__43141__delegate;
return G__43141;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming it with the
 * specified path and update-fn.
 */
com.rpl.specter.transformed = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (path,update_fn){
var builder__41683__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late,late_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42931 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42931 = (function (path,update_fn,late,late_fn,meta42932){
this.path = path;
this.update_fn = update_fn;
this.late = late;
this.late_fn = late_fn;
this.meta42932 = meta42932;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42931.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42933,meta42932__$1){
var self__ = this;
var _42933__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42931(self__.path,self__.update_fn,self__.late,self__.late_fn,meta42932__$1));
}));

(com.rpl.specter.t_com$rpl$specter42931.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42933){
var self__ = this;
var _42933__$1 = this;
return self__.meta42932;
}));

(com.rpl.specter.t_com$rpl$specter42931.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42931.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return next_fn((com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(self__.late,self__.late_fn,structure) : com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure)));
}));

(com.rpl.specter.t_com$rpl$specter42931.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return next_fn((com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(self__.late,self__.late_fn,structure) : com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure)));
}));

(com.rpl.specter.t_com$rpl$specter42931.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"update-fn","update-fn",-1943348456,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta42932","meta42932",-1258722412,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42931.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42931.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42931");

(com.rpl.specter.t_com$rpl$specter42931.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42931");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42931.
 */
com.rpl.specter.__GT_t_com$rpl$specter42931 = (function com$rpl$specter$__GT_t_com$rpl$specter42931(path__$1,update_fn__$1,late__$1,late_fn__$1,meta42932){
return (new com.rpl.specter.t_com$rpl$specter42931(path__$1,update_fn__$1,late__$1,late_fn__$1,meta42932));
});

}

return (new com.rpl.specter.t_com$rpl$specter42931(path,update_fn,late,late_fn,null));
}));
var curr_params__41684__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path)),update_fn], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__41684__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__41683__auto__,curr_params__41684__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__41683__auto__,curr_params__41684__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming with a reduction over
 * the specified traversal.
 */
com.rpl.specter.traversed = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (path,reduce_fn){
var builder__41683__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late,late_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42934 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42934 = (function (path,reduce_fn,late,late_fn,meta42935){
this.path = path;
this.reduce_fn = reduce_fn;
this.late = late;
this.late_fn = late_fn;
this.meta42935 = meta42935;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42934.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42936,meta42935__$1){
var self__ = this;
var _42936__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42934(self__.path,self__.reduce_fn,self__.late,self__.late_fn,meta42935__$1));
}));

(com.rpl.specter.t_com$rpl$specter42934.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42936){
var self__ = this;
var _42936__$1 = this;
return self__.meta42935;
}));

(com.rpl.specter.t_com$rpl$specter42934.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42934.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return next_fn(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(self__.late_fn,(com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_traverse.call(null,self__.late,structure))));
}));

(com.rpl.specter.t_com$rpl$specter42934.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return next_fn(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(self__.late_fn,(com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_traverse.call(null,self__.late,structure))));
}));

(com.rpl.specter.t_com$rpl$specter42934.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"reduce-fn","reduce-fn",-1484020844,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta42935","meta42935",1008613526,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42934.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42934.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42934");

(com.rpl.specter.t_com$rpl$specter42934.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42934");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42934.
 */
com.rpl.specter.__GT_t_com$rpl$specter42934 = (function com$rpl$specter$__GT_t_com$rpl$specter42934(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta42935){
return (new com.rpl.specter.t_com$rpl$specter42934(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta42935));
});

}

return (new com.rpl.specter.t_com$rpl$specter42934(path,reduce_fn,late,late_fn,null));
}));
var curr_params__41684__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path)),reduce_fn], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__41684__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__41683__auto__,curr_params__41684__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__41683__auto__,curr_params__41684__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Keeps the element only if it matches the supplied predicate. Functions in paths
 *        implicitly convert to this navigator.
 */
com.rpl.specter.pred = com.rpl.specter.impl.pred_STAR_;
com.rpl.specter.pred_EQ_ = (function com$rpl$specter$pred_EQ_(v){
var G__42938 = (function (p1__42937_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__42937_SHARP_,v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__42938) : com.rpl.specter.pred.call(null,G__42938));
});
com.rpl.specter.pred_LT_ = (function com$rpl$specter$pred_LT_(v){
var G__42940 = (function (p1__42939_SHARP_){
return (p1__42939_SHARP_ < v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__42940) : com.rpl.specter.pred.call(null,G__42940));
});
com.rpl.specter.pred_GT_ = (function com$rpl$specter$pred_GT_(v){
var G__42942 = (function (p1__42941_SHARP_){
return (p1__42941_SHARP_ > v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__42942) : com.rpl.specter.pred.call(null,G__42942));
});
com.rpl.specter.pred_LT__EQ_ = (function com$rpl$specter$pred_LT__EQ_(v){
var G__42944 = (function (p1__42943_SHARP_){
return (p1__42943_SHARP_ <= v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__42944) : com.rpl.specter.pred.call(null,G__42944));
});
com.rpl.specter.pred_GT__EQ_ = (function com$rpl$specter$pred_GT__EQ_(v){
var G__42946 = (function (p1__42945_SHARP_){
return (p1__42945_SHARP_ >= v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__42946) : com.rpl.specter.pred.call(null,G__42946));
});
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"null",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"null",(function (this$){
return com.rpl.specter.STAY;
}));
(cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
(cljs.core.Symbol.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Symbol.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"string",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"string",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"number",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"number",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
(cljs.core.char$.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.char$.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"boolean",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"boolean",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"function",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"function",(function (this$){
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.pred.call(null,this$));
}));
(cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.pred.call(null,this$__$1));
}));
(RegExp.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(RegExp.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.regex_nav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.regex_nav.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.regex_nav.call(null,this$__$1));
}));


com.rpl.specter.nil__GT_val_select_STAR_ = (function com$rpl$specter$nil__GT_val_select_STAR_(v,structure,next_fn){
var G__42947 = (((structure == null))?v:structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42947) : next_fn.call(null,G__42947));
});

com.rpl.specter.nil__GT_val_transform_STAR_ = (function com$rpl$specter$nil__GT_val_transform_STAR_(v,structure,next_fn){
var G__42948 = (((structure == null))?v:structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42948) : next_fn.call(null,G__42948));
});

/**
 * Navigates to the provided val if the structure is nil. Otherwise it stays
 *        navigated at the structure.
 */
com.rpl.specter.nil__GT_val = com.rpl.specter.impl.direct_nav_obj((function (v){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42949 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42949 = (function (v,meta42950){
this.v = v;
this.meta42950 = meta42950;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42949.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42951,meta42950__$1){
var self__ = this;
var _42951__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42949(self__.v,meta42950__$1));
}));

(com.rpl.specter.t_com$rpl$specter42949.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42951){
var self__ = this;
var _42951__$1 = this;
return self__.meta42950;
}));

(com.rpl.specter.t_com$rpl$specter42949.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42949.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return next_fn((((structure == null))?self__.v:structure));
}));

(com.rpl.specter.t_com$rpl$specter42949.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return next_fn((((structure == null))?self__.v:structure));
}));

(com.rpl.specter.t_com$rpl$specter42949.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"meta42950","meta42950",1160139397,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42949.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42949.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42949");

(com.rpl.specter.t_com$rpl$specter42949.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42949");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42949.
 */
com.rpl.specter.__GT_t_com$rpl$specter42949 = (function com$rpl$specter$__GT_t_com$rpl$specter42949(v__$1,meta42950){
return (new com.rpl.specter.t_com$rpl$specter42949(v__$1,meta42950));
});

}

return (new com.rpl.specter.t_com$rpl$specter42949(v,null));
}));
/**
 * Navigates to #{} if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_SET = (function (){var G__42952 = cljs.core.PersistentHashSet.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__42952) : com.rpl.specter.nil__GT_val.call(null,G__42952));
})();
/**
 * Navigates to '() if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_LIST = (function (){var G__42953 = cljs.core.List.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__42953) : com.rpl.specter.nil__GT_val.call(null,G__42953));
})();
/**
 * Navigates to [] if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_VECTOR = (function (){var G__42954 = cljs.core.PersistentVector.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__42954) : com.rpl.specter.nil__GT_val.call(null,G__42954));
})();


com.rpl.specter.META_select_STAR_ = (function com$rpl$specter$META_select_STAR_(structure,next_fn){
var G__42955 = cljs.core.meta(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42955) : next_fn.call(null,G__42955));
});

com.rpl.specter.META_transform_STAR_ = (function com$rpl$specter$META_transform_STAR_(structure,next_fn){
return cljs.core.with_meta(structure,(function (){var G__42956 = cljs.core.meta(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42956) : next_fn.call(null,G__42956));
})());
});

/**
 * Navigates to the metadata of the structure, or nil if
 *   the structure has no metadata or may not contain metadata.
 */
com.rpl.specter.META = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42957 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42957 = (function (meta42958){
this.meta42958 = meta42958;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42957.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42959,meta42958__$1){
var self__ = this;
var _42959__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42957(meta42958__$1));
}));

(com.rpl.specter.t_com$rpl$specter42957.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42959){
var self__ = this;
var _42959__$1 = this;
return self__.meta42958;
}));

(com.rpl.specter.t_com$rpl$specter42957.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42957.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return next_fn(cljs.core.meta(structure));
}));

(com.rpl.specter.t_com$rpl$specter42957.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return cljs.core.with_meta(structure,next_fn(cljs.core.meta(structure)));
}));

(com.rpl.specter.t_com$rpl$specter42957.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42958","meta42958",472052991,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42957.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42957.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42957");

(com.rpl.specter.t_com$rpl$specter42957.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42957");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42957.
 */
com.rpl.specter.__GT_t_com$rpl$specter42957 = (function com$rpl$specter$__GT_t_com$rpl$specter42957(meta42958){
return (new com.rpl.specter.t_com$rpl$specter42957(meta42958));
});

}

return (new com.rpl.specter.t_com$rpl$specter42957(null));
})()
;


com.rpl.specter.NAME_select_STAR_ = (function com$rpl$specter$NAME_select_STAR_(structure,next_fn){
var G__42960 = cljs.core.name(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42960) : next_fn.call(null,G__42960));
});

com.rpl.specter.NAME_transform_STAR_ = (function com$rpl$specter$NAME_transform_STAR_(structure,next_fn){
var new_name = (function (){var G__42961 = cljs.core.name(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42961) : next_fn.call(null,G__42961));
})();
var ns = cljs.core.namespace(structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAME can only be used on symbols or keywords - ",structure], 0));

}
}
});

/**
 * Navigates to the name portion of the keyword or symbol
 */
com.rpl.specter.NAME = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42962 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42962 = (function (meta42963){
this.meta42963 = meta42963;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42962.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42964,meta42963__$1){
var self__ = this;
var _42964__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42962(meta42963__$1));
}));

(com.rpl.specter.t_com$rpl$specter42962.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42964){
var self__ = this;
var _42964__$1 = this;
return self__.meta42963;
}));

(com.rpl.specter.t_com$rpl$specter42962.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42962.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return next_fn(cljs.core.name(structure));
}));

(com.rpl.specter.t_com$rpl$specter42962.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
var new_name = next_fn(cljs.core.name(structure));
var ns = cljs.core.namespace(structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAME can only be used on symbols or keywords - ",structure], 0));

}
}
}));

(com.rpl.specter.t_com$rpl$specter42962.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42963","meta42963",-875088215,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42962.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42962.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42962");

(com.rpl.specter.t_com$rpl$specter42962.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42962");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42962.
 */
com.rpl.specter.__GT_t_com$rpl$specter42962 = (function com$rpl$specter$__GT_t_com$rpl$specter42962(meta42963){
return (new com.rpl.specter.t_com$rpl$specter42962(meta42963));
});

}

return (new com.rpl.specter.t_com$rpl$specter42962(null));
})()
;


com.rpl.specter.NAMESPACE_select_STAR_ = (function com$rpl$specter$NAMESPACE_select_STAR_(structure,next_fn){
var G__42965 = cljs.core.namespace(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42965) : next_fn.call(null,G__42965));
});

com.rpl.specter.NAMESPACE_transform_STAR_ = (function com$rpl$specter$NAMESPACE_transform_STAR_(structure,next_fn){
var name = cljs.core.name(structure);
var new_ns = (function (){var G__42966 = cljs.core.namespace(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__42966) : next_fn.call(null,G__42966));
})();
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAMESPACE can only be used on symbols or keywords - ",structure], 0));

}
}
});

/**
 * Navigates to the namespace portion of the keyword or symbol
 */
com.rpl.specter.NAMESPACE = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42967 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42967 = (function (meta42968){
this.meta42968 = meta42968;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42967.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42969,meta42968__$1){
var self__ = this;
var _42969__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42967(meta42968__$1));
}));

(com.rpl.specter.t_com$rpl$specter42967.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42969){
var self__ = this;
var _42969__$1 = this;
return self__.meta42968;
}));

(com.rpl.specter.t_com$rpl$specter42967.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42967.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
return next_fn(cljs.core.namespace(structure));
}));

(com.rpl.specter.t_com$rpl$specter42967.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__40860__auto__,vals__40861__auto__,structure,next_fn__40862__auto__){
var self__ = this;
var this__40860__auto____$1 = this;
var next_fn = (function (s__40863__auto__){
return (next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__40862__auto__.cljs$core$IFn$_invoke$arity$2(vals__40861__auto__,s__40863__auto__) : next_fn__40862__auto__.call(null,vals__40861__auto__,s__40863__auto__));
});
var name = cljs.core.name(structure);
var new_ns = next_fn(cljs.core.namespace(structure));
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAMESPACE can only be used on symbols or keywords - ",structure], 0));

}
}
}));

(com.rpl.specter.t_com$rpl$specter42967.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42968","meta42968",283717985,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42967.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42967.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42967");

(com.rpl.specter.t_com$rpl$specter42967.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42967");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42967.
 */
com.rpl.specter.__GT_t_com$rpl$specter42967 = (function com$rpl$specter$__GT_t_com$rpl$specter42967(meta42968){
return (new com.rpl.specter.t_com$rpl$specter42967(meta42968));
});

}

return (new com.rpl.specter.t_com$rpl$specter42967(null));
})()
;
/**
 * Adds the result of running select with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43163__delegate = function (path){
var builder__41683__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42970 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42970 = (function (path,late,meta42971){
this.path = path;
this.late = late;
this.meta42971 = meta42971;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42970.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42972,meta42971__$1){
var self__ = this;
var _42972__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42970(self__.path,self__.late,meta42971__$1));
}));

(com.rpl.specter.t_com$rpl$specter42970.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42972){
var self__ = this;
var _42972__$1 = this;
return self__.meta42971;
}));

(com.rpl.specter.t_com$rpl$specter42970.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42970.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41680__auto__,vals__41681__auto__,structure,next_fn__41682__auto__){
var self__ = this;
var this__41680__auto____$1 = this;
var G__42973 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__41681__auto__,(com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
var G__42974 = structure;
return (next_fn__41682__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41682__auto__.cljs$core$IFn$_invoke$arity$2(G__42973,G__42974) : next_fn__41682__auto__.call(null,G__42973,G__42974));
}));

(com.rpl.specter.t_com$rpl$specter42970.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41680__auto__,vals__41681__auto__,structure,next_fn__41682__auto__){
var self__ = this;
var this__41680__auto____$1 = this;
var G__42975 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__41681__auto__,(com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
var G__42976 = structure;
return (next_fn__41682__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41682__auto__.cljs$core$IFn$_invoke$arity$2(G__42975,G__42976) : next_fn__41682__auto__.call(null,G__42975,G__42976));
}));

(com.rpl.specter.t_com$rpl$specter42970.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta42971","meta42971",-797592260,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42970.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42970.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42970");

(com.rpl.specter.t_com$rpl$specter42970.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42970");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42970.
 */
com.rpl.specter.__GT_t_com$rpl$specter42970 = (function com$rpl$specter$__GT_t_com$rpl$specter42970(path__$1,late__$1,meta42971){
return (new com.rpl.specter.t_com$rpl$specter42970(path__$1,late__$1,meta42971));
});

}

return (new com.rpl.specter.t_com$rpl$specter42970(path,late,null));
}));
var curr_params__41684__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__41684__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__41683__auto__,curr_params__41684__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__41683__auto__,curr_params__41684__auto__,null);
}
};
var G__43163 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__43164__i = 0, G__43164__a = new Array(arguments.length -  0);
while (G__43164__i < G__43164__a.length) {G__43164__a[G__43164__i] = arguments[G__43164__i + 0]; ++G__43164__i;}
  path = new cljs.core.IndexedSeq(G__43164__a,0,null);
} 
return G__43163__delegate.call(this,path);};
G__43163.cljs$lang$maxFixedArity = 0;
G__43163.cljs$lang$applyTo = (function (arglist__43165){
var path = cljs.core.seq(arglist__43165);
return G__43163__delegate(path);
});
G__43163.cljs$core$IFn$_invoke$arity$variadic = G__43163__delegate;
return G__43163;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds the result of running select-one with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect_one = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43166__delegate = function (path){
var builder__41683__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42977 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42977 = (function (path,late,meta42978){
this.path = path;
this.late = late;
this.meta42978 = meta42978;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42977.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42979,meta42978__$1){
var self__ = this;
var _42979__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42977(self__.path,self__.late,meta42978__$1));
}));

(com.rpl.specter.t_com$rpl$specter42977.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42979){
var self__ = this;
var _42979__$1 = this;
return self__.meta42978;
}));

(com.rpl.specter.t_com$rpl$specter42977.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42977.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41680__auto__,vals__41681__auto__,structure,next_fn__41682__auto__){
var self__ = this;
var this__41680__auto____$1 = this;
var G__42980 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__41681__auto__,(com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select_one.call(null,self__.late,structure)));
var G__42981 = structure;
return (next_fn__41682__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41682__auto__.cljs$core$IFn$_invoke$arity$2(G__42980,G__42981) : next_fn__41682__auto__.call(null,G__42980,G__42981));
}));

(com.rpl.specter.t_com$rpl$specter42977.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41680__auto__,vals__41681__auto__,structure,next_fn__41682__auto__){
var self__ = this;
var this__41680__auto____$1 = this;
var G__42982 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__41681__auto__,(com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select_one.call(null,self__.late,structure)));
var G__42983 = structure;
return (next_fn__41682__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41682__auto__.cljs$core$IFn$_invoke$arity$2(G__42982,G__42983) : next_fn__41682__auto__.call(null,G__42982,G__42983));
}));

(com.rpl.specter.t_com$rpl$specter42977.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta42978","meta42978",1092610751,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42977.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42977.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42977");

(com.rpl.specter.t_com$rpl$specter42977.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42977");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42977.
 */
com.rpl.specter.__GT_t_com$rpl$specter42977 = (function com$rpl$specter$__GT_t_com$rpl$specter42977(path__$1,late__$1,meta42978){
return (new com.rpl.specter.t_com$rpl$specter42977(path__$1,late__$1,meta42978));
});

}

return (new com.rpl.specter.t_com$rpl$specter42977(path,late,null));
}));
var curr_params__41684__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__41684__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__41683__auto__,curr_params__41684__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__41683__auto__,curr_params__41684__auto__,null);
}
};
var G__43166 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__43167__i = 0, G__43167__a = new Array(arguments.length -  0);
while (G__43167__i < G__43167__a.length) {G__43167__a[G__43167__i] = arguments[G__43167__i + 0]; ++G__43167__i;}
  path = new cljs.core.IndexedSeq(G__43167__a,0,null);
} 
return G__43166__delegate.call(this,path);};
G__43166.cljs$lang$maxFixedArity = 0;
G__43166.cljs$lang$applyTo = (function (arglist__43168){
var path = cljs.core.seq(arglist__43168);
return G__43166__delegate(path);
});
G__43166.cljs$core$IFn$_invoke$arity$variadic = G__43166__delegate;
return G__43166;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds an external value to the collected vals. Useful when additional arguments
 *   are required to the transform function that would otherwise require partial
 *   application or a wrapper function.
 * 
 *   e.g., incrementing val at path [:a :b] by 3:
 *   (transform [:a :b (putval 3)] + some-map)
 */
com.rpl.specter.putval = com.rpl.specter.impl.direct_nav_obj((function (val){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42984 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42984 = (function (val,meta42985){
this.val = val;
this.meta42985 = meta42985;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42984.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42986,meta42985__$1){
var self__ = this;
var _42986__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42984(self__.val,meta42985__$1));
}));

(com.rpl.specter.t_com$rpl$specter42984.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42986){
var self__ = this;
var _42986__$1 = this;
return self__.meta42985;
}));

(com.rpl.specter.t_com$rpl$specter42984.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42984.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41680__auto__,vals__41681__auto__,structure,next_fn__41682__auto__){
var self__ = this;
var this__41680__auto____$1 = this;
var G__42987 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__41681__auto__,self__.val);
var G__42988 = structure;
return (next_fn__41682__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41682__auto__.cljs$core$IFn$_invoke$arity$2(G__42987,G__42988) : next_fn__41682__auto__.call(null,G__42987,G__42988));
}));

(com.rpl.specter.t_com$rpl$specter42984.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41680__auto__,vals__41681__auto__,structure,next_fn__41682__auto__){
var self__ = this;
var this__41680__auto____$1 = this;
var G__42989 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__41681__auto__,self__.val);
var G__42990 = structure;
return (next_fn__41682__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41682__auto__.cljs$core$IFn$_invoke$arity$2(G__42989,G__42990) : next_fn__41682__auto__.call(null,G__42989,G__42990));
}));

(com.rpl.specter.t_com$rpl$specter42984.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"meta42985","meta42985",-663928217,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42984.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42984.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42984");

(com.rpl.specter.t_com$rpl$specter42984.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42984");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42984.
 */
com.rpl.specter.__GT_t_com$rpl$specter42984 = (function com$rpl$specter$__GT_t_com$rpl$specter42984(val__$1,meta42985){
return (new com.rpl.specter.t_com$rpl$specter42984(val__$1,meta42985));
});

}

return (new com.rpl.specter.t_com$rpl$specter42984(val,null));
}));
/**
 * Continues navigating on the given path with the collected vals reset to []. Once
 *   navigation leaves the scope of with-fresh-collected, the collected vals revert
 *   to what they were before.
 */
com.rpl.specter.with_fresh_collected = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43169__delegate = function (path){
var builder__41683__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42991 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42991 = (function (path,late,meta42992){
this.path = path;
this.late = late;
this.meta42992 = meta42992;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42991.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42993,meta42992__$1){
var self__ = this;
var _42993__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42991(self__.path,self__.late,meta42992__$1));
}));

(com.rpl.specter.t_com$rpl$specter42991.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42993){
var self__ = this;
var _42993__$1 = this;
return self__.meta42992;
}));

(com.rpl.specter.t_com$rpl$specter42991.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42991.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.select_STAR_(self__.late,cljs.core.PersistentVector.EMPTY,structure,(function (_,structure__$1){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,structure__$1) : next_fn.call(null,vals,structure__$1));
}));
}));

(com.rpl.specter.t_com$rpl$specter42991.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.transform_STAR_(self__.late,cljs.core.PersistentVector.EMPTY,structure,(function (_,structure__$1){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,structure__$1) : next_fn.call(null,vals,structure__$1));
}));
}));

(com.rpl.specter.t_com$rpl$specter42991.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta42992","meta42992",-1987361553,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42991.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42991.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42991");

(com.rpl.specter.t_com$rpl$specter42991.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42991");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42991.
 */
com.rpl.specter.__GT_t_com$rpl$specter42991 = (function com$rpl$specter$__GT_t_com$rpl$specter42991(path__$1,late__$1,meta42992){
return (new com.rpl.specter.t_com$rpl$specter42991(path__$1,late__$1,meta42992));
});

}

return (new com.rpl.specter.t_com$rpl$specter42991(path,late,null));
}));
var curr_params__41684__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__41684__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__41683__auto__,curr_params__41684__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__41683__auto__,curr_params__41684__auto__,null);
}
};
var G__43169 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__43170__i = 0, G__43170__a = new Array(arguments.length -  0);
while (G__43170__i < G__43170__a.length) {G__43170__a[G__43170__i] = arguments[G__43170__i + 0]; ++G__43170__i;}
  path = new cljs.core.IndexedSeq(G__43170__a,0,null);
} 
return G__43169__delegate.call(this,path);};
G__43169.cljs$lang$maxFixedArity = 0;
G__43169.cljs$lang$applyTo = (function (arglist__43171){
var path = cljs.core.seq(arglist__43171);
return G__43169__delegate(path);
});
G__43169.cljs$core$IFn$_invoke$arity$variadic = G__43169__delegate;
return G__43169;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Drops all collected values for subsequent navigation.
 */
com.rpl.specter.DISPENSE = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter42996 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter42996 = (function (meta42997){
this.meta42997 = meta42997;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter42996.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42998,meta42997__$1){
var self__ = this;
var _42998__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter42996(meta42997__$1));
}));

(com.rpl.specter.t_com$rpl$specter42996.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42998){
var self__ = this;
var _42998__$1 = this;
return self__.meta42997;
}));

(com.rpl.specter.t_com$rpl$specter42996.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter42996.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__42999 = cljs.core.PersistentVector.EMPTY;
var G__43000 = structure;
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__42999,G__43000) : next_fn.call(null,G__42999,G__43000));
}));

(com.rpl.specter.t_com$rpl$specter42996.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__43001 = cljs.core.PersistentVector.EMPTY;
var G__43002 = structure;
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__43001,G__43002) : next_fn.call(null,G__43001,G__43002));
}));

(com.rpl.specter.t_com$rpl$specter42996.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta42997","meta42997",-834959131,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter42996.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter42996.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter42996");

(com.rpl.specter.t_com$rpl$specter42996.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter42996");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter42996.
 */
com.rpl.specter.__GT_t_com$rpl$specter42996 = (function com$rpl$specter$__GT_t_com$rpl$specter42996(meta42997){
return (new com.rpl.specter.t_com$rpl$specter42996(meta42997));
});

}

return (new com.rpl.specter.t_com$rpl$specter42996(null));
})()
;
/**
 * Like cond-path, but with if semantics.
 */
com.rpl.specter.if_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() {
var G__43172 = null;
var G__43172__2 = (function (cond_p,then_path){
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3(cond_p,then_path,com.rpl.specter.STOP) : com.rpl.specter.if_path.call(null,cond_p,then_path,com.rpl.specter.STOP));
});
var G__43172__3 = (function (cond_p,then_path,else_path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(cond_p);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
var builder__41683__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late_then,late_else){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter43005 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter43005 = (function (cond_p,then_path,else_path,temp__5733__auto__,afn,late_then,late_else,meta43006){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__5733__auto__ = temp__5733__auto__;
this.afn = afn;
this.late_then = late_then;
this.late_else = late_else;
this.meta43006 = meta43006;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter43005.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43007,meta43006__$1){
var self__ = this;
var _43007__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter43005(self__.cond_p,self__.then_path,self__.else_path,self__.temp__5733__auto__,self__.afn,self__.late_then,self__.late_else,meta43006__$1));
}));

(com.rpl.specter.t_com$rpl$specter43005.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43007){
var self__ = this;
var _43007__$1 = this;
return self__.meta43006;
}));

(com.rpl.specter.t_com$rpl$specter43005.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter43005.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select(vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter43005.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform(vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter43005.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta43006","meta43006",-1466011285,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter43005.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter43005.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter43005");

(com.rpl.specter.t_com$rpl$specter43005.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter43005");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter43005.
 */
com.rpl.specter.__GT_t_com$rpl$specter43005 = (function com$rpl$specter$__GT_t_com$rpl$specter43005(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,afn__$1,late_then__$1,late_else__$1,meta43006){
return (new com.rpl.specter.t_com$rpl$specter43005(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,afn__$1,late_then__$1,late_else__$1,meta43006));
});

}

return (new com.rpl.specter.t_com$rpl$specter43005(cond_p,then_path,else_path,temp__5733__auto__,afn,late_then,late_else,null));
}));
var curr_params__41684__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(then_path) : com.rpl.specter.late_path.call(null,then_path)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(else_path) : com.rpl.specter.late_path.call(null,else_path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__41684__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__41683__auto__,curr_params__41684__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__41683__auto__,curr_params__41684__auto__,null);
}
} else {
var builder__41683__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late_cond,late_then,late_else){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter43008 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter43008 = (function (cond_p,then_path,else_path,temp__5733__auto__,late_cond,late_then,late_else,meta43009){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late_cond = late_cond;
this.late_then = late_then;
this.late_else = late_else;
this.meta43009 = meta43009;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter43008.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43010,meta43009__$1){
var self__ = this;
var _43010__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter43008(self__.cond_p,self__.then_path,self__.else_path,self__.temp__5733__auto__,self__.late_cond,self__.late_then,self__.late_else,meta43009__$1));
}));

(com.rpl.specter.t_com$rpl$specter43008.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43010){
var self__ = this;
var _43010__$1 = this;
return self__.meta43009;
}));

(com.rpl.specter.t_com$rpl$specter43008.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter43008.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select(vals,structure,next_fn,(function (p1__43003_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late_cond,vals,p1__43003_SHARP_);
}),self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter43008.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform(vals,structure,next_fn,(function (p1__43004_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late_cond,vals,p1__43004_SHARP_);
}),self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter43008.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late-cond","late-cond",1031862828,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta43009","meta43009",18366956,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter43008.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter43008.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter43008");

(com.rpl.specter.t_com$rpl$specter43008.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter43008");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter43008.
 */
com.rpl.specter.__GT_t_com$rpl$specter43008 = (function com$rpl$specter$__GT_t_com$rpl$specter43008(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta43009){
return (new com.rpl.specter.t_com$rpl$specter43008(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta43009));
});

}

return (new com.rpl.specter.t_com$rpl$specter43008(cond_p,then_path,else_path,temp__5733__auto__,late_cond,late_then,late_else,null));
}));
var curr_params__41684__auto__ = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(cond_p) : com.rpl.specter.late_path.call(null,cond_p)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(then_path) : com.rpl.specter.late_path.call(null,then_path)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(else_path) : com.rpl.specter.late_path.call(null,else_path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__41684__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__41683__auto__,curr_params__41684__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__41683__auto__,curr_params__41684__auto__,null);
}
}
});
G__43172 = function(cond_p,then_path,else_path){
switch(arguments.length){
case 2:
return G__43172__2.call(this,cond_p,then_path);
case 3:
return G__43172__3.call(this,cond_p,then_path,else_path);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43172.cljs$core$IFn$_invoke$arity$2 = G__43172__2;
G__43172.cljs$core$IFn$_invoke$arity$3 = G__43172__3;
return G__43172;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Takes in alternating cond-path path cond-path path...
 * Tests the structure if selecting with cond-path returns anything.
 * If so, it uses the following path for this portion of the navigation.
 * Otherwise, it tries the next cond-path. If nothing matches, then the structure
 * is not selected.
 */
com.rpl.specter.cond_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43185__delegate = function (conds){
var pairs = cljs.core.reverse(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),conds));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p,p__43011){
var vec__43012 = p__43011;
var tester = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43012,(0),null);
var apath = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43012,(1),null);
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3(tester,apath,p) : com.rpl.specter.if_path.call(null,tester,apath,p));
}),com.rpl.specter.STOP,pairs);
};
var G__43185 = function (var_args){
var conds = null;
if (arguments.length > 0) {
var G__43186__i = 0, G__43186__a = new Array(arguments.length -  0);
while (G__43186__i < G__43186__a.length) {G__43186__a[G__43186__i] = arguments[G__43186__i + 0]; ++G__43186__i;}
  conds = new cljs.core.IndexedSeq(G__43186__a,0,null);
} 
return G__43185__delegate.call(this,conds);};
G__43185.cljs$lang$maxFixedArity = 0;
G__43185.cljs$lang$applyTo = (function (arglist__43187){
var conds = cljs.core.seq(arglist__43187);
return G__43185__delegate(conds);
});
G__43185.cljs$core$IFn$_invoke$arity$variadic = G__43185__delegate;
return G__43185;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * A path that branches on multiple paths. For updates,
 * applies updates to the paths in order.
 */
com.rpl.specter.multi_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() {
var G__43188 = null;
var G__43188__0 = (function (){
return com.rpl.specter.STAY;
});
var G__43188__1 = (function (path){
return path;
});
var G__43188__2 = (function (path1,path2){
var builder__41683__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late1,late2){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter43015 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter43015 = (function (path1,path2,late1,late2,meta43016){
this.path1 = path1;
this.path2 = path2;
this.late1 = late1;
this.late2 = late2;
this.meta43016 = meta43016;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter43015.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43017,meta43016__$1){
var self__ = this;
var _43017__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter43015(self__.path1,self__.path2,self__.late1,self__.late2,meta43016__$1));
}));

(com.rpl.specter.t_com$rpl$specter43015.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43017){
var self__ = this;
var _43017__$1 = this;
return self__.meta43016;
}));

(com.rpl.specter.t_com$rpl$specter43015.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter43015.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var res1 = com.rpl.specter.protocols.select_STAR_(self__.late1,vals,structure,next_fn);
if(cljs.core.reduced_QMARK_(res1)){
return res1;
} else {
var res2 = com.rpl.specter.protocols.select_STAR_(self__.late2,vals,structure,next_fn);
if((com.rpl.specter.NONE === res1)){
return res2;
} else {
return res1;
}
}
}));

(com.rpl.specter.t_com$rpl$specter43015.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var s1 = com.rpl.specter.protocols.transform_STAR_(self__.late1,vals,structure,next_fn);
return com.rpl.specter.protocols.transform_STAR_(self__.late2,vals,s1,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter43015.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path1","path1",-2002517142,null),new cljs.core.Symbol(null,"path2","path2",-1937913521,null),new cljs.core.Symbol(null,"late1","late1",-1413016621,null),new cljs.core.Symbol(null,"late2","late2",-681717994,null),new cljs.core.Symbol(null,"meta43016","meta43016",-173548246,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter43015.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter43015.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter43015");

(com.rpl.specter.t_com$rpl$specter43015.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter43015");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter43015.
 */
com.rpl.specter.__GT_t_com$rpl$specter43015 = (function com$rpl$specter$__GT_t_com$rpl$specter43015(path1__$1,path2__$1,late1__$1,late2__$1,meta43016){
return (new com.rpl.specter.t_com$rpl$specter43015(path1__$1,path2__$1,late1__$1,late2__$1,meta43016));
});

}

return (new com.rpl.specter.t_com$rpl$specter43015(path1,path2,late1,late2,null));
}));
var curr_params__41684__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path1) : com.rpl.specter.late_path.call(null,path1)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path2) : com.rpl.specter.late_path.call(null,path2))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__41684__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__41683__auto__,curr_params__41684__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__41683__auto__,curr_params__41684__auto__,null);
}
});
var G__43188__3 = (function() { 
var G__43189__delegate = function (path1,path2,paths){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(com.rpl.specter.multi_path,(com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(path1,path2) : com.rpl.specter.multi_path.call(null,path1,path2)),paths);
};
var G__43189 = function (path1,path2,var_args){
var paths = null;
if (arguments.length > 2) {
var G__43190__i = 0, G__43190__a = new Array(arguments.length -  2);
while (G__43190__i < G__43190__a.length) {G__43190__a[G__43190__i] = arguments[G__43190__i + 2]; ++G__43190__i;}
  paths = new cljs.core.IndexedSeq(G__43190__a,0,null);
} 
return G__43189__delegate.call(this,path1,path2,paths);};
G__43189.cljs$lang$maxFixedArity = 2;
G__43189.cljs$lang$applyTo = (function (arglist__43191){
var path1 = cljs.core.first(arglist__43191);
arglist__43191 = cljs.core.next(arglist__43191);
var path2 = cljs.core.first(arglist__43191);
var paths = cljs.core.rest(arglist__43191);
return G__43189__delegate(path1,path2,paths);
});
G__43189.cljs$core$IFn$_invoke$arity$variadic = G__43189__delegate;
return G__43189;
})()
;
G__43188 = function(path1,path2,var_args){
var paths = var_args;
switch(arguments.length){
case 0:
return G__43188__0.call(this);
case 1:
return G__43188__1.call(this,path1);
case 2:
return G__43188__2.call(this,path1,path2);
default:
var G__43192 = null;
if (arguments.length > 2) {
var G__43193__i = 0, G__43193__a = new Array(arguments.length -  2);
while (G__43193__i < G__43193__a.length) {G__43193__a[G__43193__i] = arguments[G__43193__i + 2]; ++G__43193__i;}
G__43192 = new cljs.core.IndexedSeq(G__43193__a,0,null);
}
return G__43188__3.cljs$core$IFn$_invoke$arity$variadic(path1,path2, G__43192);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43188.cljs$lang$maxFixedArity = 2;
G__43188.cljs$lang$applyTo = G__43188__3.cljs$lang$applyTo;
G__43188.cljs$core$IFn$_invoke$arity$0 = G__43188__0;
G__43188.cljs$core$IFn$_invoke$arity$1 = G__43188__1;
G__43188.cljs$core$IFn$_invoke$arity$2 = G__43188__2;
G__43188.cljs$core$IFn$_invoke$arity$variadic = G__43188__3.cljs$core$IFn$_invoke$arity$variadic;
return G__43188;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the current element and then navigates via the provided path.
 * This can be used to implement pre-order traversal.
 */
com.rpl.specter.stay_then_continue = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43194__delegate = function (path){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.STAY,path) : com.rpl.specter.multi_path.call(null,com.rpl.specter.STAY,path));
};
var G__43194 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__43195__i = 0, G__43195__a = new Array(arguments.length -  0);
while (G__43195__i < G__43195__a.length) {G__43195__a[G__43195__i] = arguments[G__43195__i + 0]; ++G__43195__i;}
  path = new cljs.core.IndexedSeq(G__43195__a,0,null);
} 
return G__43194__delegate.call(this,path);};
G__43194.cljs$lang$maxFixedArity = 0;
G__43194.cljs$lang$applyTo = (function (arglist__43196){
var path = cljs.core.seq(arglist__43196);
return G__43194__delegate(path);
});
G__43194.cljs$core$IFn$_invoke$arity$variadic = G__43194__delegate;
return G__43194;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the provided path and then to the current element. This can be used
 * to implement post-order traversal.
 */
com.rpl.specter.continue_then_stay = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43197__delegate = function (path){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(path,com.rpl.specter.STAY) : com.rpl.specter.multi_path.call(null,path,com.rpl.specter.STAY));
};
var G__43197 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__43198__i = 0, G__43198__a = new Array(arguments.length -  0);
while (G__43198__i < G__43198__a.length) {G__43198__a[G__43198__i] = arguments[G__43198__i + 0]; ++G__43198__i;}
  path = new cljs.core.IndexedSeq(G__43198__a,0,null);
} 
return G__43197__delegate.call(this,path);};
G__43197.cljs$lang$maxFixedArity = 0;
G__43197.cljs$lang$applyTo = (function (arglist__43199){
var path = cljs.core.seq(arglist__43199);
return G__43197__delegate(path);
});
G__43197.cljs$core$IFn$_invoke$arity$variadic = G__43197__delegate;
return G__43197;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigate the data structure until reaching
 *        a value for which `afn` returns truthy. Has
 *        same semantics as clojure.walk.
 */
com.rpl.specter.walker = com.rpl.specter.impl.direct_nav_obj((function (afn){
var p = com.rpl.specter.impl.local_declarepath();
com.rpl.specter.impl.providepath_STAR_(p,(function (){var info__41690__auto__ = com.rpl.specter.pathcache43022;
var info__41690__auto____$1 = (((info__41690__auto__ == null))?(function (){var info43023 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"com/rpl/specter.cljc",25,1,1394,1394,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"com/rpl/specter.cljc",7,1,true,1175,1179,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. Functions in paths\n          implicitly convert to this navigator.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"com/rpl/specter.cljc",7,1,644,646,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse(cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",12,1,2133,2133,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",(cljs.core.truth_(cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_LocalSym(p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache43022 = info43023;

return info43023;
})():info__41690__auto__);
var precompiled43024 = com.rpl.specter.impl.cached_path_info_precompiled(info__41690__auto____$1);
var dynamic_QMARK___41691__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41690__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41691__auto__)){
var G__43025 = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,p], null),com.rpl.specter.ALL,p], null);
return (precompiled43024.cljs$core$IFn$_invoke$arity$1 ? precompiled43024.cljs$core$IFn$_invoke$arity$1(G__43025) : precompiled43024.call(null,G__43025));
} else {
return precompiled43024;
}
})());

return p;
}));
/**
 * Like `walker` but maintains metadata of any forms traversed.
 */
com.rpl.specter.codewalker = com.rpl.specter.impl.direct_nav_obj((function (afn){
var p = com.rpl.specter.impl.local_declarepath();
com.rpl.specter.impl.providepath_STAR_(p,(function (){var info__41690__auto__ = com.rpl.specter.pathcache43026;
var info__41690__auto____$1 = (((info__41690__auto__ == null))?(function (){var info43027 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"com/rpl/specter.cljc",25,1,1394,1394,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"com/rpl/specter.cljc",7,1,true,1175,1179,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. Functions in paths\n          implicitly convert to this navigator.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"com/rpl/specter.cljc",7,1,644,646,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse(cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",12,1,2133,2133,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",(cljs.core.truth_(cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL_WITH_META,new cljs.core.Var(function(){return com.rpl.specter.ALL_WITH_META;},new cljs.core.Symbol("com.rpl.specter","ALL-WITH-META","com.rpl.specter/ALL-WITH-META",-1161868995,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),"com/rpl/specter.cljc",16,1,689,691,cljs.core.List.EMPTY,"Same as ALL, except maintains metadata on the structure.",(cljs.core.truth_(com.rpl.specter.ALL_WITH_META)?com.rpl.specter.ALL_WITH_META.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null)),com.rpl.specter.impl.__GT_LocalSym(p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache43026 = info43027;

return info43027;
})():info__41690__auto__);
var precompiled43028 = com.rpl.specter.impl.cached_path_info_precompiled(info__41690__auto____$1);
var dynamic_QMARK___41691__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__41690__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___41691__auto__)){
var G__43029 = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL_WITH_META,p], null),com.rpl.specter.ALL_WITH_META,p], null);
return (precompiled43028.cljs$core$IFn$_invoke$arity$1 ? precompiled43028.cljs$core$IFn$_invoke$arity$1(G__43029) : precompiled43028.call(null,G__43029));
} else {
return precompiled43028;
}
})());

return p;
}));
var empty__GT_NONE_43200 = (function (){var G__43030 = cljs.core.empty_QMARK_;
var G__43031 = com.rpl.specter.terminal_val(com.rpl.specter.NONE);
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$2(G__43030,G__43031) : com.rpl.specter.if_path.call(null,G__43030,G__43031));
})();
var compact_STAR__43201 = (function (nav){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(nav,empty__GT_NONE_43200) : com.rpl.specter.multi_path.call(null,nav,empty__GT_NONE_43200));
});
/**
 * During transforms, after each step of navigation in subpath check if the
 *  value is empty. If so, remove that value by setting it to NONE.
 */
com.rpl.specter.compact = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__43202__delegate = function (path){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(compact_STAR__43201,path);
};
var G__43202 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__43203__i = 0, G__43203__a = new Array(arguments.length -  0);
while (G__43203__i < G__43203__a.length) {G__43203__a[G__43203__i] = arguments[G__43203__i + 0]; ++G__43203__i;}
  path = new cljs.core.IndexedSeq(G__43203__a,0,null);
} 
return G__43202__delegate.call(this,path);};
G__43202.cljs$lang$maxFixedArity = 0;
G__43202.cljs$lang$applyTo = (function (arglist__43204){
var path = cljs.core.seq(arglist__43204);
return G__43202__delegate(path);
});
G__43202.cljs$core$IFn$_invoke$arity$variadic = G__43202__delegate;
return G__43202;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);

//# sourceMappingURL=com.rpl.specter.js.map
