goog.provide('re_frame.trace');
goog.require('cljs.core');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('goog.functions');
re_frame.trace.id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_(re_frame.trace.id,(0));
});
/**
 * @define {boolean}
 */
re_frame.trace.trace_enabled_QMARK_ = goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/day8/re-frame-10x#installation."], 0));
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__28047){
var map__28048 = p__28047;
var map__28048__$1 = (((((!((map__28048 == null))))?(((((map__28048.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28048.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28048):map__28048);
var operation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28048__$1,new cljs.core.Keyword(null,"operation","operation",-1267664310));
var op_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28048__$1,new cljs.core.Keyword(null,"op-type","op-type",-1636141668));
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28048__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
var child_of = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28048__$1,new cljs.core.Keyword(null,"child-of","child-of",-903376662));
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),re_frame.trace.next_id(),new cljs.core.Keyword(null,"operation","operation",-1267664310),operation,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),op_type,new cljs.core.Keyword(null,"tags","tags",1771418977),tags,new cljs.core.Keyword(null,"child-of","child-of",-903376662),(function (){var or__4126__auto__ = child_of;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),new cljs.core.Keyword(null,"start","start",-355208981),re_frame.interop.now()], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce((function re_frame$trace$tracing_cb_debounced(){
var seq__28050_28083 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__28051_28084 = null;
var count__28052_28085 = (0);
var i__28053_28086 = (0);
while(true){
if((i__28053_28086 < count__28052_28085)){
var vec__28064_28087 = chunk__28051_28084.cljs$core$IIndexed$_nth$arity$2(null,i__28053_28086);
var k_28088 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28064_28087,(0),null);
var cb_28089 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28064_28087,(1),null);
try{var G__28068_28090 = cljs.core.deref(re_frame.trace.traces);
(cb_28089.cljs$core$IFn$_invoke$arity$1 ? cb_28089.cljs$core$IFn$_invoke$arity$1(G__28068_28090) : cb_28089.call(null,G__28068_28090));
}catch (e28067){var e_28091 = e28067;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_28088,"while storing",cljs.core.deref(re_frame.trace.traces),e_28091], 0));
}

var G__28092 = seq__28050_28083;
var G__28093 = chunk__28051_28084;
var G__28094 = count__28052_28085;
var G__28095 = (i__28053_28086 + (1));
seq__28050_28083 = G__28092;
chunk__28051_28084 = G__28093;
count__28052_28085 = G__28094;
i__28053_28086 = G__28095;
continue;
} else {
var temp__5735__auto___28096 = cljs.core.seq(seq__28050_28083);
if(temp__5735__auto___28096){
var seq__28050_28097__$1 = temp__5735__auto___28096;
if(cljs.core.chunked_seq_QMARK_(seq__28050_28097__$1)){
var c__4556__auto___28098 = cljs.core.chunk_first(seq__28050_28097__$1);
var G__28099 = cljs.core.chunk_rest(seq__28050_28097__$1);
var G__28100 = c__4556__auto___28098;
var G__28101 = cljs.core.count(c__4556__auto___28098);
var G__28102 = (0);
seq__28050_28083 = G__28099;
chunk__28051_28084 = G__28100;
count__28052_28085 = G__28101;
i__28053_28086 = G__28102;
continue;
} else {
var vec__28069_28103 = cljs.core.first(seq__28050_28097__$1);
var k_28104 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28069_28103,(0),null);
var cb_28105 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28069_28103,(1),null);
try{var G__28073_28106 = cljs.core.deref(re_frame.trace.traces);
(cb_28105.cljs$core$IFn$_invoke$arity$1 ? cb_28105.cljs$core$IFn$_invoke$arity$1(G__28073_28106) : cb_28105.call(null,G__28073_28106));
}catch (e28072){var e_28107 = e28072;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_28104,"while storing",cljs.core.deref(re_frame.trace.traces),e_28107], 0));
}

var G__28108 = cljs.core.next(seq__28050_28097__$1);
var G__28109 = null;
var G__28110 = (0);
var G__28111 = (0);
seq__28050_28083 = G__28108;
chunk__28051_28084 = G__28109;
count__28052_28085 = G__28110;
i__28053_28086 = G__28111;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref(re_frame.trace.next_delivery) - (25)) < now)){
(re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0 ? re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0() : re_frame.trace.schedule_debounce.call(null));

return cljs.core.reset_BANG_(re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});

//# sourceMappingURL=re_frame.trace.js.map
