goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR__orig_val__28323 = re_frame.trace._STAR_current_trace_STAR_;
var _STAR_current_trace_STAR__temp_val__28324 = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));
(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__temp_val__28324);

try{try{var seq__28325 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__28326 = null;
var count__28327 = (0);
var i__28328 = (0);
while(true){
if((i__28328 < count__28327)){
var vec__28336 = chunk__28326.cljs$core$IIndexed$_nth$arity$2(null,i__28328);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28336,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28336,(1),null);
var temp__5733__auto___28393 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___28393)){
var effect_fn_28394 = temp__5733__auto___28393;
(effect_fn_28394.cljs$core$IFn$_invoke$arity$1 ? effect_fn_28394.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_28394.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__28395 = seq__28325;
var G__28396 = chunk__28326;
var G__28397 = count__28327;
var G__28398 = (i__28328 + (1));
seq__28325 = G__28395;
chunk__28326 = G__28396;
count__28327 = G__28397;
i__28328 = G__28398;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28325);
if(temp__5735__auto__){
var seq__28325__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28325__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28325__$1);
var G__28399 = cljs.core.chunk_rest(seq__28325__$1);
var G__28400 = c__4556__auto__;
var G__28401 = cljs.core.count(c__4556__auto__);
var G__28402 = (0);
seq__28325 = G__28399;
chunk__28326 = G__28400;
count__28327 = G__28401;
i__28328 = G__28402;
continue;
} else {
var vec__28339 = cljs.core.first(seq__28325__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28339,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28339,(1),null);
var temp__5733__auto___28403 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___28403)){
var effect_fn_28405 = temp__5733__auto___28403;
(effect_fn_28405.cljs$core$IFn$_invoke$arity$1 ? effect_fn_28405.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_28405.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__28406 = cljs.core.next(seq__28325__$1);
var G__28407 = null;
var G__28408 = (0);
var G__28409 = (0);
seq__28325 = G__28406;
chunk__28326 = G__28407;
count__28327 = G__28408;
i__28328 = G__28409;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__28027__auto___28410 = re_frame.interop.now();
var duration__28028__auto___28411 = (end__28027__auto___28410 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__28028__auto___28411,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__28027__auto___28410);
} else {
}
}}finally {(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__orig_val__28323);
}} else {
var seq__28342 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__28343 = null;
var count__28344 = (0);
var i__28345 = (0);
while(true){
if((i__28345 < count__28344)){
var vec__28352 = chunk__28343.cljs$core$IIndexed$_nth$arity$2(null,i__28345);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28352,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28352,(1),null);
var temp__5733__auto___28412 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___28412)){
var effect_fn_28413 = temp__5733__auto___28412;
(effect_fn_28413.cljs$core$IFn$_invoke$arity$1 ? effect_fn_28413.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_28413.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__28414 = seq__28342;
var G__28415 = chunk__28343;
var G__28416 = count__28344;
var G__28417 = (i__28345 + (1));
seq__28342 = G__28414;
chunk__28343 = G__28415;
count__28344 = G__28416;
i__28345 = G__28417;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28342);
if(temp__5735__auto__){
var seq__28342__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28342__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28342__$1);
var G__28418 = cljs.core.chunk_rest(seq__28342__$1);
var G__28419 = c__4556__auto__;
var G__28420 = cljs.core.count(c__4556__auto__);
var G__28421 = (0);
seq__28342 = G__28418;
chunk__28343 = G__28419;
count__28344 = G__28420;
i__28345 = G__28421;
continue;
} else {
var vec__28355 = cljs.core.first(seq__28342__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28355,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28355,(1),null);
var temp__5733__auto___28423 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___28423)){
var effect_fn_28424 = temp__5733__auto___28423;
(effect_fn_28424.cljs$core$IFn$_invoke$arity$1 ? effect_fn_28424.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_28424.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__28426 = cljs.core.next(seq__28342__$1);
var G__28427 = null;
var G__28428 = (0);
var G__28429 = (0);
seq__28342 = G__28426;
chunk__28343 = G__28427;
count__28344 = G__28428;
i__28345 = G__28429;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__28358 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__28359 = null;
var count__28360 = (0);
var i__28361 = (0);
while(true){
if((i__28361 < count__28360)){
var map__28366 = chunk__28359.cljs$core$IIndexed$_nth$arity$2(null,i__28361);
var map__28366__$1 = (((((!((map__28366 == null))))?(((((map__28366.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28366.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28366):map__28366);
var effect = map__28366__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28366__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28366__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__28358,chunk__28359,count__28360,i__28361,map__28366,map__28366__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__28358,chunk__28359,count__28360,i__28361,map__28366,map__28366__$1,effect,ms,dispatch))
,ms);
}


var G__28430 = seq__28358;
var G__28431 = chunk__28359;
var G__28432 = count__28360;
var G__28433 = (i__28361 + (1));
seq__28358 = G__28430;
chunk__28359 = G__28431;
count__28360 = G__28432;
i__28361 = G__28433;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28358);
if(temp__5735__auto__){
var seq__28358__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28358__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28358__$1);
var G__28434 = cljs.core.chunk_rest(seq__28358__$1);
var G__28435 = c__4556__auto__;
var G__28436 = cljs.core.count(c__4556__auto__);
var G__28437 = (0);
seq__28358 = G__28434;
chunk__28359 = G__28435;
count__28360 = G__28436;
i__28361 = G__28437;
continue;
} else {
var map__28372 = cljs.core.first(seq__28358__$1);
var map__28372__$1 = (((((!((map__28372 == null))))?(((((map__28372.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28372.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28372):map__28372);
var effect = map__28372__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28372__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28372__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__28358,chunk__28359,count__28360,i__28361,map__28372,map__28372__$1,effect,ms,dispatch,seq__28358__$1,temp__5735__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__28358,chunk__28359,count__28360,i__28361,map__28372,map__28372__$1,effect,ms,dispatch,seq__28358__$1,temp__5735__auto__))
,ms);
}


var G__28439 = cljs.core.next(seq__28358__$1);
var G__28440 = null;
var G__28441 = (0);
var G__28442 = (0);
seq__28358 = G__28439;
chunk__28359 = G__28440;
count__28360 = G__28441;
i__28361 = G__28442;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if((!(cljs.core.vector_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if((!(cljs.core.sequential_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value], 0));
} else {
var seq__28379 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__28380 = null;
var count__28381 = (0);
var i__28382 = (0);
while(true){
if((i__28382 < count__28381)){
var event = chunk__28380.cljs$core$IIndexed$_nth$arity$2(null,i__28382);
re_frame.router.dispatch(event);


var G__28443 = seq__28379;
var G__28444 = chunk__28380;
var G__28445 = count__28381;
var G__28446 = (i__28382 + (1));
seq__28379 = G__28443;
chunk__28380 = G__28444;
count__28381 = G__28445;
i__28382 = G__28446;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28379);
if(temp__5735__auto__){
var seq__28379__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28379__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28379__$1);
var G__28447 = cljs.core.chunk_rest(seq__28379__$1);
var G__28448 = c__4556__auto__;
var G__28449 = cljs.core.count(c__4556__auto__);
var G__28450 = (0);
seq__28379 = G__28447;
chunk__28380 = G__28448;
count__28381 = G__28449;
i__28382 = G__28450;
continue;
} else {
var event = cljs.core.first(seq__28379__$1);
re_frame.router.dispatch(event);


var G__28451 = cljs.core.next(seq__28379__$1);
var G__28452 = null;
var G__28453 = (0);
var G__28454 = (0);
seq__28379 = G__28451;
chunk__28380 = G__28452;
count__28381 = G__28453;
i__28382 = G__28454;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__28383 = cljs.core.seq(value);
var chunk__28384 = null;
var count__28385 = (0);
var i__28386 = (0);
while(true){
if((i__28386 < count__28385)){
var event = chunk__28384.cljs$core$IIndexed$_nth$arity$2(null,i__28386);
clear_event(event);


var G__28455 = seq__28383;
var G__28456 = chunk__28384;
var G__28457 = count__28385;
var G__28458 = (i__28386 + (1));
seq__28383 = G__28455;
chunk__28384 = G__28456;
count__28385 = G__28457;
i__28386 = G__28458;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28383);
if(temp__5735__auto__){
var seq__28383__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28383__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28383__$1);
var G__28459 = cljs.core.chunk_rest(seq__28383__$1);
var G__28460 = c__4556__auto__;
var G__28461 = cljs.core.count(c__4556__auto__);
var G__28462 = (0);
seq__28383 = G__28459;
chunk__28384 = G__28460;
count__28385 = G__28461;
i__28386 = G__28462;
continue;
} else {
var event = cljs.core.first(seq__28383__$1);
clear_event(event);


var G__28463 = cljs.core.next(seq__28383__$1);
var G__28464 = null;
var G__28465 = (0);
var G__28466 = (0);
seq__28383 = G__28463;
chunk__28384 = G__28464;
count__28385 = G__28465;
i__28386 = G__28466;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if((!((cljs.core.deref(re_frame.db.app_db) === value)))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=re_frame.fx.js.map
