goog.provide('pinkgorilla.ui.pinkie');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('cljs.pprint');
goog.require('reagent.core');
goog.require('reagent.impl.template');
pinkgorilla.ui.pinkie.component_registry = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
pinkgorilla.ui.pinkie.get_component = (function pinkgorilla$ui$pinkie$get_component(tag){
var G__34446 = cljs.core.deref(pinkgorilla.ui.pinkie.component_registry);
return (tag.cljs$core$IFn$_invoke$arity$1 ? tag.cljs$core$IFn$_invoke$arity$1(G__34446) : tag.call(null,G__34446));
});
pinkgorilla.ui.pinkie.get_renderer = (function pinkgorilla$ui$pinkie$get_renderer(tag){
return new cljs.core.Keyword(null,"fun","fun",-1265158045).cljs$core$IFn$_invoke$arity$1(pinkgorilla.ui.pinkie.get_component(tag));
});
pinkgorilla.ui.pinkie.component_list = (function pinkgorilla$ui$pinkie$component_list(){
return cljs.core.vals(cljs.core.deref(pinkgorilla.ui.pinkie.component_registry));
});
pinkgorilla.ui.pinkie.component_list__GT_str = (function pinkgorilla$ui$pinkie$component_list__GT_str(){
var sb__4667__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__34448_34497 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__34449_34498 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__34450_34499 = true;
var _STAR_print_fn_STAR__temp_val__34451_34500 = (function (x__4668__auto__){
return sb__4667__auto__.append(x__4668__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__34450_34499);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__34451_34500);

try{cljs.pprint.print_table.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"category","category",-593092832)], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34447_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(p1__34447_SHARP_),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"tag","tag",-1290361223).cljs$core$IFn$_invoke$arity$1(p1__34447_SHARP_),new cljs.core.Keyword(null,"fun","fun",-1265158045),new cljs.core.Keyword(null,"fun","fun",-1265158045).cljs$core$IFn$_invoke$arity$1(p1__34447_SHARP_)], null)], 0));
}),pinkgorilla.ui.pinkie.component_list()));
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__34449_34498);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__34448_34497);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4667__auto__);
});
pinkgorilla.ui.pinkie.print_components = (function pinkgorilla$ui$pinkie$print_components(){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pinkgorilla.ui.pinkie.component_list__GT_str()], 0));
});
pinkgorilla.ui.pinkie.clj__GT_json = (function pinkgorilla$ui$pinkie$clj__GT_json(ds){
return JSON.stringify(cljs.core.clj__GT_js(ds));
});
pinkgorilla.ui.pinkie.pinkie_namespace = cljs.core.namespace(new cljs.core.Keyword("p","test","p/test",577538765));
pinkgorilla.ui.pinkie.pinkie_tag_QMARK_ = (function pinkgorilla$ui$pinkie$pinkie_tag_QMARK_(tag){
var kw_namespace = cljs.core.namespace(tag);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(pinkgorilla.ui.pinkie.pinkie_namespace,kw_namespace);
});
pinkgorilla.ui.pinkie.pinkie_exclude_QMARK_ = (function pinkgorilla$ui$pinkie$pinkie_exclude_QMARK_(hiccup_vector){
return cljs.core.contains_QMARK_(cljs.core.meta(hiccup_vector),new cljs.core.Keyword(null,"r","r",-471384190));
});
pinkgorilla.ui.pinkie.hiccup_vector_QMARK_ = (function pinkgorilla$ui$pinkie$hiccup_vector_QMARK_(hiccup_vector){
return ((cljs.core.vector_QMARK_(hiccup_vector)) && ((!(cljs.core.map_entry_QMARK_(hiccup_vector)))) && ((cljs.core.first(hiccup_vector) instanceof cljs.core.Keyword)));
});
pinkgorilla.ui.pinkie.should_replace_QMARK_ = (function pinkgorilla$ui$pinkie$should_replace_QMARK_(hiccup_vector){
if(pinkgorilla.ui.pinkie.hiccup_vector_QMARK_(hiccup_vector)){
var tag = cljs.core.first(hiccup_vector);
return (((!(pinkgorilla.ui.pinkie.pinkie_exclude_QMARK_(hiccup_vector)))) && (pinkgorilla.ui.pinkie.pinkie_tag_QMARK_(tag)));
} else {
return false;
}
});
/**
 * ui component for unknown tags - so that we don't need to catch react errors
 * Currently not yet used (see resolve function)
 */
pinkgorilla.ui.pinkie.unknown_tag = (function pinkgorilla$ui$pinkie$unknown_tag(tag){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.unknown-tag","span.unknown-tag",-1604027258),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background-color","background-color",570434026),"red"], null)], null),["Unknown Tag: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag)].join('')], null);
});
/**
 * input: hiccup vector
 * if keyword (first position in vector) has been registered via register-tag,
 * then it gets replaced with the react function,
 * otherwise keyword remains
 */
pinkgorilla.ui.pinkie.replace_tag_in_hiccup_vector = (function pinkgorilla$ui$pinkie$replace_tag_in_hiccup_vector(hiccup_vector){
var tag = cljs.core.first(hiccup_vector);
var render_function = pinkgorilla.ui.pinkie.get_renderer(tag);
if((render_function == null)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["pinkie unknown tag: ",cljs.core.name(tag)], 0));

return pinkgorilla.ui.pinkie.unknown_tag(tag);
} else {
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(hiccup_vector,(0),render_function));
}
});
/**
 * resolve function-as symbol to function references in the reagent-hickup-map.
 * Leaves regular hiccup data unchanged.
 */
pinkgorilla.ui.pinkie.tag_inject = (function pinkgorilla$ui$pinkie$tag_inject(hiccup_vector){
return clojure.walk.prewalk((function (x){
if(pinkgorilla.ui.pinkie.should_replace_QMARK_(x)){
return pinkgorilla.ui.pinkie.replace_tag_in_hiccup_vector(x);
} else {
return x;
}
}),hiccup_vector);
});
pinkgorilla.ui.pinkie.to_map_style = (function pinkgorilla$ui$pinkie$to_map_style(s){
var style_vec = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34458_SHARP_){
return clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__34458_SHARP_,/:/);
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(s,/;/));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4529__auto__ = (function pinkgorilla$ui$pinkie$to_map_style_$_iter__34466(s__34467){
return (new cljs.core.LazySeq(null,(function (){
var s__34467__$1 = s__34467;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__34467__$1);
if(temp__5735__auto__){
var s__34467__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34467__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__34467__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__34469 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__34468 = (0);
while(true){
if((i__34468 < size__4528__auto__)){
var vec__34477 = cljs.core._nth(c__4527__auto__,i__34468);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34477,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34477,(1),null);
cljs.core.chunk_append(b__34469,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.trim(k)),clojure.string.trim(v)], null));

var G__34506 = (i__34468 + (1));
i__34468 = G__34506;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34469),pinkgorilla$ui$pinkie$to_map_style_$_iter__34466(cljs.core.chunk_rest(s__34467__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34469),null);
}
} else {
var vec__34480 = cljs.core.first(s__34467__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34480,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34480,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.trim(k)),clojure.string.trim(v)], null),pinkgorilla$ui$pinkie$to_map_style_$_iter__34466(cljs.core.rest(s__34467__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(style_vec);
})());
});
pinkgorilla.ui.pinkie.is_style_QMARK_ = (function pinkgorilla$ui$pinkie$is_style_QMARK_(x){
if(((cljs.core.vector_QMARK_(x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),cljs.core.count(x))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(x),new cljs.core.Keyword(null,"style","style",-496642736))) && (typeof cljs.core.second(x) === 'string'))){
return true;
} else {
return false;
}
});
pinkgorilla.ui.pinkie.replace_style = (function pinkgorilla$ui$pinkie$replace_style(x){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["pinkie replacing string style: ",x], 0));

return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(x,(1),pinkgorilla.ui.pinkie.to_map_style(cljs.core.last(x))));
});
/**
 * resolve function-as symbol to function references in the reagent-hickup-map.
 * Leaves regular hiccup data unchanged.
 */
pinkgorilla.ui.pinkie.convert_style_as_strings_to_map = (function pinkgorilla$ui$pinkie$convert_style_as_strings_to_map(hiccup_vector){
return clojure.walk.prewalk((function (x){
if(pinkgorilla.ui.pinkie.is_style_QMARK_(x)){
return pinkgorilla.ui.pinkie.replace_style(x);
} else {
return x;
}
}),hiccup_vector);
});
pinkgorilla.ui.pinkie.render_as_QMARK_ = (function pinkgorilla$ui$pinkie$render_as_QMARK_(hiccup_vector){
return cljs.core.contains_QMARK_(cljs.core.meta(hiccup_vector),new cljs.core.Keyword("p","render-as","p/render-as",-1497012127));
});
pinkgorilla.ui.pinkie.wrap_renderer = (function pinkgorilla$ui$pinkie$wrap_renderer(x){
var renderer = new cljs.core.Keyword("p","render-as","p/render-as",-1497012127).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x));
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["pinkie wrapping renderer ",renderer," to: ",x], 0));

return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [renderer,x], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"R","R",-936662523),true], null));
});
/**
 * resolve function-as symbol to function references in the reagent-hickup-map.
 * Leaves regular hiccup data unchanged.
 */
pinkgorilla.ui.pinkie.convert_render_as = (function pinkgorilla$ui$pinkie$convert_render_as(hiccup_vector){
return clojure.walk.postwalk((function (x){
if(pinkgorilla.ui.pinkie.render_as_QMARK_(x)){
return pinkgorilla.ui.pinkie.wrap_renderer(x);
} else {
return x;
}
}),hiccup_vector);
});

//# sourceMappingURL=pinkgorilla.ui.pinkie.js.map
