goog.provide('pinkgorilla.ui.gorilla_plot.plot');
goog.require('cljs.core');
goog.require('pinkgorilla.ui.gorilla_plot.vega');
goog.require('pinkgorilla.ui.gorilla_plot.util');
pinkgorilla.ui.gorilla_plot.plot.merge_with_meta = (function pinkgorilla$ui$gorilla_plot$plot$merge_with_meta(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34788 = arguments.length;
var i__4737__auto___34789 = (0);
while(true){
if((i__4737__auto___34789 < len__4736__auto___34788)){
args__4742__auto__.push((arguments[i__4737__auto___34789]));

var G__34790 = (i__4737__auto___34789 + (1));
i__4737__auto___34789 = G__34790;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$core$IFn$_invoke$arity$variadic = (function (data){
var metas = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.meta,data);
var merged_meta = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.merge,metas);
return cljs.core.with_meta(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.merge,data),merged_meta);
}));

(pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$lang$applyTo = (function (seq34722){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34722));
}));

pinkgorilla.ui.gorilla_plot.plot.add_indices = (function pinkgorilla$ui$gorilla_plot$plot$add_indices(d){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(d)),d);
});
/**
 * Function for plotting list data.
 */
pinkgorilla.ui.gorilla_plot.plot.list_plot = (function pinkgorilla$ui$gorilla_plot$plot$list_plot(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34791 = arguments.length;
var i__4737__auto___34792 = (0);
while(true){
if((i__4737__auto___34792 < len__4736__auto___34791)){
args__4742__auto__.push((arguments[i__4737__auto___34792]));

var G__34793 = (i__4737__auto___34792 + (1));
i__4737__auto___34792 = G__34793;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.plot.list_plot.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.plot.list_plot.cljs$core$IFn$_invoke$arity$variadic = (function (data,p__34734){
var map__34735 = p__34734;
var map__34735__$1 = (((((!((map__34735 == null))))?(((((map__34735.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34735.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34735):map__34735);
var plot_range = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34735__$1,new cljs.core.Keyword(null,"plot-range","plot-range",-1426783143),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.Keyword(null,"all","all",892129742)], null));
var colour = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34735__$1,new cljs.core.Keyword(null,"colour","colour",2137094554));
var y_title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34735__$1,new cljs.core.Keyword(null,"y-title","y-title",220785852));
var aspect_ratio = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34735__$1,new cljs.core.Keyword(null,"aspect-ratio","aspect-ratio",1674013504),1.618);
var joined = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34735__$1,new cljs.core.Keyword(null,"joined","joined",-231861661),false);
var color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34735__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var series_name = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34735__$1,new cljs.core.Keyword(null,"series-name","series-name",-128514906),pinkgorilla.ui.gorilla_plot.util.gen_uuid());
var x_title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34735__$1,new cljs.core.Keyword(null,"x-title","x-title",698054088));
var plot_size = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34735__$1,new cljs.core.Keyword(null,"plot-size","plot-size",1218885548),(400));
var symbol_size = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34735__$1,new cljs.core.Keyword(null,"symbol-size","symbol-size",-1099583279),(70));
var opacity = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34735__$1,new cljs.core.Keyword(null,"opacity","opacity",397153780),(1));
var plot_data = ((cljs.core.sequential_QMARK_(cljs.core.first(data)))?data:pinkgorilla.ui.gorilla_plot.plot.add_indices(data));
return pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pinkgorilla.ui.gorilla_plot.vega.container(plot_size,aspect_ratio),pinkgorilla.ui.gorilla_plot.vega.data_from_list(series_name,plot_data),(cljs.core.truth_(joined)?pinkgorilla.ui.gorilla_plot.vega.line_plot_marks(series_name,(function (){var or__4126__auto__ = colour;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return color;
}
})(),opacity):pinkgorilla.ui.gorilla_plot.vega.list_plot_marks(series_name,(function (){var or__4126__auto__ = colour;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return color;
}
})(),symbol_size,opacity)),pinkgorilla.ui.gorilla_plot.vega.default_list_plot_scales(series_name,plot_range),pinkgorilla.ui.gorilla_plot.vega.default_plot_axes(x_title,y_title)], 0));
}));

(pinkgorilla.ui.gorilla_plot.plot.list_plot.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.plot.list_plot.cljs$lang$applyTo = (function (seq34732){
var G__34733 = cljs.core.first(seq34732);
var seq34732__$1 = cljs.core.next(seq34732);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34733,seq34732__$1);
}));

pinkgorilla.ui.gorilla_plot.plot.timeseries_plot = (function pinkgorilla$ui$gorilla_plot$plot$timeseries_plot(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34794 = arguments.length;
var i__4737__auto___34795 = (0);
while(true){
if((i__4737__auto___34795 < len__4736__auto___34794)){
args__4742__auto__.push((arguments[i__4737__auto___34795]));

var G__34796 = (i__4737__auto___34795 + (1));
i__4737__auto___34795 = G__34796;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.plot.timeseries_plot.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.plot.timeseries_plot.cljs$core$IFn$_invoke$arity$variadic = (function (data,keys){
var series_name = pinkgorilla.ui.gorilla_plot.util.gen_uuid();
var params = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [data,new cljs.core.Keyword(null,"series-name","series-name",-128514906),series_name], null),keys));
var plot = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(pinkgorilla.ui.gorilla_plot.plot.list_plot,params);
var plot_range = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.Keyword(null,"all","all",892129742)], null);
return pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([plot,pinkgorilla.ui.gorilla_plot.vega.timeseries_list_plot_scales(series_name,plot_range)], 0));
}));

(pinkgorilla.ui.gorilla_plot.plot.timeseries_plot.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.plot.timeseries_plot.cljs$lang$applyTo = (function (seq34737){
var G__34738 = cljs.core.first(seq34737);
var seq34737__$1 = cljs.core.next(seq34737);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34738,seq34737__$1);
}));

/**
 * Function for plotting functions of a single variable.
 */
pinkgorilla.ui.gorilla_plot.plot.plot = (function pinkgorilla$ui$gorilla_plot$plot$plot(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34797 = arguments.length;
var i__4737__auto___34798 = (0);
while(true){
if((i__4737__auto___34798 < len__4736__auto___34797)){
args__4742__auto__.push((arguments[i__4737__auto___34798]));

var G__34799 = (i__4737__auto___34798 + (1));
i__4737__auto___34798 = G__34799;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.plot.plot.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.plot.plot.cljs$core$IFn$_invoke$arity$variadic = (function (func,p__34752,p__34753){
var vec__34754 = p__34752;
var xmin = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34754,(0),null);
var xmax = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34754,(1),null);
var map__34757 = p__34753;
var map__34757__$1 = (((((!((map__34757 == null))))?(((((map__34757.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34757.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34757):map__34757);
var opts = map__34757__$1;
var plot_points = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34757__$1,new cljs.core.Keyword(null,"plot-points","plot-points",-1364232040),100.0);
var xs = cljs.core.range.cljs$core$IFn$_invoke$arity$3(xmin,xmax,((xmax - xmin) / plot_points));
var plot_data = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34739_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__34739_SHARP_,(func.cljs$core$IFn$_invoke$arity$1 ? func.cljs$core$IFn$_invoke$arity$1(p1__34739_SHARP_) : func.call(null,p1__34739_SHARP_))],null));
}),xs);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(pinkgorilla.ui.gorilla_plot.plot.list_plot,plot_data),cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.identity,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"joined","joined",-231861661),true], null),opts], 0))], 0)));
}));

(pinkgorilla.ui.gorilla_plot.plot.plot.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.plot.plot.cljs$lang$applyTo = (function (seq34749){
var G__34750 = cljs.core.first(seq34749);
var seq34749__$1 = cljs.core.next(seq34749);
var G__34751 = cljs.core.first(seq34749__$1);
var seq34749__$2 = cljs.core.next(seq34749__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34750,G__34751,seq34749__$2);
}));

pinkgorilla.ui.gorilla_plot.plot.bar_chart = (function pinkgorilla$ui$gorilla_plot$plot$bar_chart(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34800 = arguments.length;
var i__4737__auto___34801 = (0);
while(true){
if((i__4737__auto___34801 < len__4736__auto___34800)){
args__4742__auto__.push((arguments[i__4737__auto___34801]));

var G__34802 = (i__4737__auto___34801 + (1));
i__4737__auto___34801 = G__34802;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.plot.bar_chart.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.plot.bar_chart.cljs$core$IFn$_invoke$arity$variadic = (function (categories,values,p__34762){
var map__34763 = p__34762;
var map__34763__$1 = (((((!((map__34763 == null))))?(((((map__34763.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34763.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34763):map__34763);
var plot_size = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34763__$1,new cljs.core.Keyword(null,"plot-size","plot-size",1218885548),(400));
var aspect_ratio = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34763__$1,new cljs.core.Keyword(null,"aspect-ratio","aspect-ratio",1674013504),1.618);
var plot_range = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34763__$1,new cljs.core.Keyword(null,"plot-range","plot-range",-1426783143),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.Keyword(null,"all","all",892129742)], null));
var opacity = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34763__$1,new cljs.core.Keyword(null,"opacity","opacity",397153780),(1));
var colour = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34763__$1,new cljs.core.Keyword(null,"colour","colour",2137094554));
var color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34763__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var x_title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34763__$1,new cljs.core.Keyword(null,"x-title","x-title",698054088));
var y_title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34763__$1,new cljs.core.Keyword(null,"y-title","y-title",220785852));
var series_name = pinkgorilla.ui.gorilla_plot.util.gen_uuid();
return pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pinkgorilla.ui.gorilla_plot.vega.container(plot_size,aspect_ratio),pinkgorilla.ui.gorilla_plot.vega.data_from_list(series_name,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,categories,values)),pinkgorilla.ui.gorilla_plot.vega.bar_chart_marks(series_name,(function (){var or__4126__auto__ = colour;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return color;
}
})(),opacity),pinkgorilla.ui.gorilla_plot.vega.default_bar_chart_scales(series_name,plot_range),pinkgorilla.ui.gorilla_plot.vega.default_plot_axes(x_title,y_title)], 0));
}));

(pinkgorilla.ui.gorilla_plot.plot.bar_chart.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.plot.bar_chart.cljs$lang$applyTo = (function (seq34759){
var G__34760 = cljs.core.first(seq34759);
var seq34759__$1 = cljs.core.next(seq34759);
var G__34761 = cljs.core.first(seq34759__$1);
var seq34759__$2 = cljs.core.next(seq34759__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34760,G__34761,seq34759__$2);
}));

/**
 * Plot the histogram of a sample.
 */
pinkgorilla.ui.gorilla_plot.plot.histogram = (function pinkgorilla$ui$gorilla_plot$plot$histogram(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34803 = arguments.length;
var i__4737__auto___34804 = (0);
while(true){
if((i__4737__auto___34804 < len__4736__auto___34803)){
args__4742__auto__.push((arguments[i__4737__auto___34804]));

var G__34805 = (i__4737__auto___34804 + (1));
i__4737__auto___34804 = G__34805;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.plot.histogram.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.plot.histogram.cljs$core$IFn$_invoke$arity$variadic = (function (data,p__34776){
var map__34777 = p__34776;
var map__34777__$1 = (((((!((map__34777 == null))))?(((((map__34777.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34777.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34777):map__34777);
var plot_range = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34777__$1,new cljs.core.Keyword(null,"plot-range","plot-range",-1426783143),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.Keyword(null,"all","all",892129742)], null));
var colour = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34777__$1,new cljs.core.Keyword(null,"colour","colour",2137094554));
var y_title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34777__$1,new cljs.core.Keyword(null,"y-title","y-title",220785852));
var normalize = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34777__$1,new cljs.core.Keyword(null,"normalize","normalize",-1904390051));
var fill_opacity = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34777__$1,new cljs.core.Keyword(null,"fill-opacity","fill-opacity",-537571170),0.4);
var aspect_ratio = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34777__$1,new cljs.core.Keyword(null,"aspect-ratio","aspect-ratio",1674013504),1.618);
var color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34777__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var x_title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34777__$1,new cljs.core.Keyword(null,"x-title","x-title",698054088));
var bins = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34777__$1,new cljs.core.Keyword(null,"bins","bins",1670395210),new cljs.core.Keyword(null,"automatic","automatic",104479799));
var plot_size = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34777__$1,new cljs.core.Keyword(null,"plot-size","plot-size",1218885548),(400));
var normalise = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34777__$1,new cljs.core.Keyword(null,"normalise","normalise",-1794807087));
var opacity = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34777__$1,new cljs.core.Keyword(null,"opacity","opacity",397153780),(1));
var bin_range_spec = cljs.core.first(plot_range);
var range_min = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(bin_range_spec,new cljs.core.Keyword(null,"all","all",892129742)))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,data):cljs.core.first(bin_range_spec));
var range_max_raw = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(bin_range_spec,new cljs.core.Keyword(null,"all","all",892129742)))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,data):cljs.core.second(bin_range_spec));
var range_max = (range_max_raw + Math.ulp(range_max_raw));
var points_in_range = pinkgorilla.ui.gorilla_plot.util.count_in_range(data,range_min,range_max);
var num_bins = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(bins,new cljs.core.Keyword(null,"automatic","automatic",104479799)))?Math.ceil(((1) + (Math.log(points_in_range) / Math.log((2))))):bins);
var bin_size_raw = ((range_max - range_min) / num_bins);
var bin_size = (((bin_size_raw < 1.0E-15))?1.0:bin_size_raw);
var cat_counts = pinkgorilla.ui.gorilla_plot.util.bin_counts(data,range_min,range_max,bin_size);
var norm = (function (){var G__34779 = (function (){var or__4126__auto__ = normalize;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = normalise;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return new cljs.core.Keyword(null,"count","count",2139924085);
}
}
})();
var G__34779__$1 = (((G__34779 instanceof cljs.core.Keyword))?G__34779.fqn:null);
switch (G__34779__$1) {
case "probability":
return cljs.core.count(data);

break;
case "probability-density":
return (cljs.core.count(data) * bin_size);

break;
case "count":
return (1);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__34779__$1)].join('')));

}
})();
var cat_data = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34773_SHARP_){
return (p1__34773_SHARP_ / norm);
}),cat_counts);
var series_name = pinkgorilla.ui.gorilla_plot.util.gen_uuid();
var x_data = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,bin_size),cljs.core.range.cljs$core$IFn$_invoke$arity$3((range_min - bin_size),(range_max + bin_size),bin_size));
var y_data = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cat_data,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null)], 0));
var plot_data = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,x_data,y_data);
return pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pinkgorilla.ui.gorilla_plot.vega.container(plot_size,aspect_ratio),pinkgorilla.ui.gorilla_plot.vega.data_from_list(series_name,plot_data),pinkgorilla.ui.gorilla_plot.vega.histogram_marks(series_name,(function (){var or__4126__auto__ = colour;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return color;
}
})(),opacity,fill_opacity),pinkgorilla.ui.gorilla_plot.vega.default_list_plot_scales(series_name,plot_range),pinkgorilla.ui.gorilla_plot.vega.default_plot_axes(x_title,y_title)], 0));
}));

(pinkgorilla.ui.gorilla_plot.plot.histogram.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.plot.histogram.cljs$lang$applyTo = (function (seq34774){
var G__34775 = cljs.core.first(seq34774);
var seq34774__$1 = cljs.core.next(seq34774);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34775,seq34774__$1);
}));

pinkgorilla.ui.gorilla_plot.plot.compose = (function pinkgorilla$ui$gorilla_plot$plot$compose(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34812 = arguments.length;
var i__4737__auto___34813 = (0);
while(true){
if((i__4737__auto___34813 < len__4736__auto___34812)){
args__4742__auto__.push((arguments[i__4737__auto___34813]));

var G__34814 = (i__4737__auto___34813 + (1));
i__4737__auto___34813 = G__34814;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.plot.compose.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.plot.compose.cljs$core$IFn$_invoke$arity$variadic = (function (plots){
var first_plot = cljs.core.first(plots);
var map__34786 = first_plot;
var map__34786__$1 = (((((!((map__34786 == null))))?(((((map__34786.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34786.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34786):map__34786);
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34786__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34786__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var padding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34786__$1,new cljs.core.Keyword(null,"padding","padding",1660304693));
var scales = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34786__$1,new cljs.core.Keyword(null,"scales","scales",-1197224722));
var axes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34786__$1,new cljs.core.Keyword(null,"axes","axes",1970866440));
var data = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"data","data",-232669377),plots));
var marks = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"marks","marks",-1844991497),plots));
return cljs.core.with_meta(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"width","width",-384071477),width,new cljs.core.Keyword(null,"height","height",1025178622),height,new cljs.core.Keyword(null,"padding","padding",1660304693),padding,new cljs.core.Keyword(null,"scales","scales",-1197224722),scales,new cljs.core.Keyword(null,"axes","axes",1970866440),axes,new cljs.core.Keyword(null,"data","data",-232669377),data,new cljs.core.Keyword(null,"marks","marks",-1844991497),marks], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("p","render-as","p/render-as",-1497012127),new cljs.core.Keyword("p","vega","p/vega",-1657842969)], null));
}));

(pinkgorilla.ui.gorilla_plot.plot.compose.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.plot.compose.cljs$lang$applyTo = (function (seq34785){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34785));
}));


//# sourceMappingURL=pinkgorilla.ui.gorilla_plot.plot.js.map
