goog.provide('com.rpl.specter');
goog.require('cljs.core');
goog.require('com.rpl.specter.protocols');
goog.require('com.rpl.specter.impl');
goog.require('com.rpl.specter.navs');
goog.require('clojure.set');
com.rpl.specter.static_path_QMARK_ = (function com$rpl$specter$static_path_QMARK_(path){
if(cljs.core.sequential_QMARK_(path)){
return cljs.core.every_QMARK_(com.rpl.specter.static_path_QMARK_,path);
} else {
return (!(com.rpl.specter.impl.dynamic_param_QMARK_(path)));
}
});
com.rpl.specter.wrap_dynamic_nav = (function com$rpl$specter$wrap_dynamic_nav(f){
return (function() { 
var G__34904__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
if(((cljs.core.sequential_QMARK_(ret)) && (com.rpl.specter.static_path_QMARK_(ret)))){
return com.rpl.specter.impl.comp_paths_STAR_(ret);
} else {
if(((cljs.core.sequential_QMARK_(ret)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(ret))))){
return cljs.core.first(ret);
} else {
return ret;

}
}
};
var G__34904 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__34905__i = 0, G__34905__a = new Array(arguments.length -  0);
while (G__34905__i < G__34905__a.length) {G__34905__a[G__34905__i] = arguments[G__34905__i + 0]; ++G__34905__i;}
  args = new cljs.core.IndexedSeq(G__34905__a,0,null);
} 
return G__34904__delegate.call(this,args);};
G__34904.cljs$lang$maxFixedArity = 0;
G__34904.cljs$lang$applyTo = (function (arglist__34906){
var args = cljs.core.seq(arglist__34906);
return G__34904__delegate(args);
});
G__34904.cljs$core$IFn$_invoke$arity$variadic = G__34904__delegate;
return G__34904;
})()
;
});
/**
 * Returns a compiled version of the given path for use with
 * compiled-{select/transform/setval/etc.} functions.
 */
com.rpl.specter.comp_paths = (function com$rpl$specter$comp_paths(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34907 = arguments.length;
var i__4737__auto___34908 = (0);
while(true){
if((i__4737__auto___34908 < len__4736__auto___34907)){
args__4742__auto__.push((arguments[i__4737__auto___34908]));

var G__34909 = (i__4737__auto___34908 + (1));
i__4737__auto___34908 = G__34909;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic = (function (apath){
return com.rpl.specter.impl.comp_paths_STAR_(cljs.core.vec(apath));
}));

(com.rpl.specter.comp_paths.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.rpl.specter.comp_paths.cljs$lang$applyTo = (function (seq34394){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34394));
}));

/**
 * Version of select that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select = com.rpl.specter.impl.compiled_select_STAR_;
/**
 * Navigates to and returns a sequence of all the elements specified by the path.
 */
com.rpl.specter.select_STAR_ = (function com$rpl$specter$select_STAR_(path,structure){
var G__34395 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34396 = structure;
return (com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(G__34395,G__34396) : com.rpl.specter.compiled_select.call(null,G__34395,G__34396));
});
/**
 * Version of select-one that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one = com.rpl.specter.impl.compiled_select_one_STAR_;
/**
 * Like select, but returns either one element or nil. Throws exception if multiple elements found
 */
com.rpl.specter.select_one_STAR_ = (function com$rpl$specter$select_one_STAR_(path,structure){
var G__34397 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34398 = structure;
return (com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(G__34397,G__34398) : com.rpl.specter.compiled_select_one.call(null,G__34397,G__34398));
});
/**
 * Version of select-one! that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one_BANG_ = com.rpl.specter.impl.compiled_select_one_BANG__STAR_;
/**
 * Returns exactly one element, throws exception if zero or multiple elements found
 */
com.rpl.specter.select_one_BANG__STAR_ = (function com$rpl$specter$select_one_BANG__STAR_(path,structure){
var G__34399 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34400 = structure;
return (com.rpl.specter.compiled_select_one_BANG_.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one_BANG_.cljs$core$IFn$_invoke$arity$2(G__34399,G__34400) : com.rpl.specter.compiled_select_one_BANG_.call(null,G__34399,G__34400));
});
/**
 * Version of select-first that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_first = com.rpl.specter.impl.compiled_select_first_STAR_;
/**
 * Returns first element found.
 */
com.rpl.specter.select_first_STAR_ = (function com$rpl$specter$select_first_STAR_(path,structure){
var G__34401 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34402 = structure;
return (com.rpl.specter.compiled_select_first.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_first.cljs$core$IFn$_invoke$arity$2(G__34401,G__34402) : com.rpl.specter.compiled_select_first.call(null,G__34401,G__34402));
});
/**
 * Version of select-any that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_any = com.rpl.specter.impl.compiled_select_any_STAR_;
/**
 * Global value used to indicate no elements selected during
 *           [[select-any]].
 */
com.rpl.specter.NONE = com.rpl.specter.impl.NONE;
/**
 * Returns any element found or [[NONE]] if nothing selected. This is the most
 * efficient of the various selection operations.
 */
com.rpl.specter.select_any_STAR_ = (function com$rpl$specter$select_any_STAR_(path,structure){
var G__34403 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34404 = structure;
return (com.rpl.specter.compiled_select_any.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_any.cljs$core$IFn$_invoke$arity$2(G__34403,G__34404) : com.rpl.specter.compiled_select_any.call(null,G__34403,G__34404));
});
/**
 * Version of selected-any? that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_selected_any_QMARK_ = com.rpl.specter.impl.compiled_selected_any_QMARK__STAR_;
/**
 * Returns true if any element was selected, false otherwise.
 */
com.rpl.specter.selected_any_QMARK__STAR_ = (function com$rpl$specter$selected_any_QMARK__STAR_(path,structure){
var G__34405 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34406 = structure;
return (com.rpl.specter.compiled_selected_any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_selected_any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__34405,G__34406) : com.rpl.specter.compiled_selected_any_QMARK_.call(null,G__34405,G__34406));
});
/**
 * Version of traverse that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse = com.rpl.specter.impl.do_compiled_traverse;
/**
 * Return a reducible object that traverses over `structure` to every element
 * specified by the path
 */
com.rpl.specter.traverse_STAR_ = (function com$rpl$specter$traverse_STAR_(apath,structure){
var G__34407 = com.rpl.specter.impl.comp_paths_STAR_(apath);
var G__34408 = structure;
return (com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(G__34407,G__34408) : com.rpl.specter.compiled_traverse.call(null,G__34407,G__34408));
});
/**
 * Version of traverse-all that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse_all = com.rpl.specter.impl.compiled_traverse_all_STAR_;
/**
 * Returns a transducer that traverses over each element with the given path.
 */
com.rpl.specter.traverse_all_STAR_ = (function com$rpl$specter$traverse_all_STAR_(apath){
var G__34409 = com.rpl.specter.impl.comp_paths_STAR_(apath);
return (com.rpl.specter.compiled_traverse_all.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.compiled_traverse_all.cljs$core$IFn$_invoke$arity$1(G__34409) : com.rpl.specter.compiled_traverse_all.call(null,G__34409));
});
/**
 * Version of transform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_transform = com.rpl.specter.impl.compiled_transform_STAR_;
/**
 * Version of vtransform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_vtransform = com.rpl.specter.impl.compiled_vtransform_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by the result of running
 *   the transform-fn on it
 */
com.rpl.specter.transform_STAR_ = (function com$rpl$specter$transform_STAR_(path,transform_fn,structure){
var G__34410 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34411 = transform_fn;
var G__34412 = structure;
return (com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(G__34410,G__34411,G__34412) : com.rpl.specter.compiled_transform.call(null,G__34410,G__34411,G__34412));
});
/**
 * Version of `multi-transform` that takes in a path precompiled with `comp-paths`
 */
com.rpl.specter.compiled_multi_transform = com.rpl.specter.impl.compiled_multi_transform_STAR_;
/**
 * Just like `transform` but expects transform functions to be specified
 * inline in the path using `terminal` or `vterminal`. Error is thrown if navigation finishes
 * at a non-terminal navigator. `terminal-val` is a wrapper around `terminal` and is
 * the `multi-transform` equivalent of `setval`.
 */
com.rpl.specter.multi_transform_STAR_ = (function com$rpl$specter$multi_transform_STAR_(path,structure){
var G__34413 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34414 = structure;
return (com.rpl.specter.compiled_multi_transform.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_multi_transform.cljs$core$IFn$_invoke$arity$2(G__34413,G__34414) : com.rpl.specter.compiled_multi_transform.call(null,G__34413,G__34414));
});
/**
 * Version of setval that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_setval = com.rpl.specter.impl.compiled_setval_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by val
 */
com.rpl.specter.setval_STAR_ = (function com$rpl$specter$setval_STAR_(path,val,structure){
var G__34415 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34416 = val;
var G__34417 = structure;
return (com.rpl.specter.compiled_setval.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_setval.cljs$core$IFn$_invoke$arity$3(G__34415,G__34416,G__34417) : com.rpl.specter.compiled_setval.call(null,G__34415,G__34416,G__34417));
});
/**
 * Version of replace-in that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_replace_in = com.rpl.specter.impl.compiled_replace_in_STAR_;
/**
 * Similar to transform, except returns a pair of [transformed-structure sequence-of-user-ret].
 * The transform-fn in this case is expected to return [ret user-ret]. ret is
 * what's used to transform the data structure, while user-ret will be added to the user-ret sequence
 * in the final return. replace-in is useful for situations where you need to know the specific values
 * of what was transformed in the data structure.
 */
com.rpl.specter.replace_in_STAR_ = (function com$rpl$specter$replace_in_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34910 = arguments.length;
var i__4737__auto___34911 = (0);
while(true){
if((i__4737__auto___34911 < len__4736__auto___34910)){
args__4742__auto__.push((arguments[i__4737__auto___34911]));

var G__34912 = (i__4737__auto___34911 + (1));
i__4737__auto___34911 = G__34912;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (path,transform_fn,structure,p__34422){
var map__34423 = p__34422;
var map__34423__$1 = (((((!((map__34423 == null))))?(((((map__34423.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34423.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34423):map__34423);
var merge_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34423__$1,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),cljs.core.concat);
var G__34425 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34426 = transform_fn;
var G__34427 = structure;
var G__34428 = new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341);
var G__34429 = merge_fn;
return (com.rpl.specter.compiled_replace_in.cljs$core$IFn$_invoke$arity$5 ? com.rpl.specter.compiled_replace_in.cljs$core$IFn$_invoke$arity$5(G__34425,G__34426,G__34427,G__34428,G__34429) : com.rpl.specter.compiled_replace_in.call(null,G__34425,G__34426,G__34427,G__34428,G__34429));
}));

(com.rpl.specter.replace_in_STAR_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(com.rpl.specter.replace_in_STAR_.cljs$lang$applyTo = (function (seq34418){
var G__34419 = cljs.core.first(seq34418);
var seq34418__$1 = cljs.core.next(seq34418);
var G__34420 = cljs.core.first(seq34418__$1);
var seq34418__$2 = cljs.core.next(seq34418__$1);
var G__34421 = cljs.core.first(seq34418__$2);
var seq34418__$3 = cljs.core.next(seq34418__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34419,G__34420,G__34421,seq34418__$3);
}));

com.rpl.specter.late_path = com.rpl.specter.impl.late_path;
com.rpl.specter.dynamic_param_QMARK_ = com.rpl.specter.impl.dynamic_param_QMARK_;
com.rpl.specter.late_resolved_fn = com.rpl.specter.impl.late_resolved_fn;
/**
 * Turns a navigator that takes one argument into a navigator that takes
 *        many arguments and uses the same navigator with each argument. There
 *        is no performance cost to using this. See implementation of `keypath`
 */
com.rpl.specter.eachnav = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (navfn){
var latenavfn = (com.rpl.specter.late_resolved_fn.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_resolved_fn.cljs$core$IFn$_invoke$arity$1(navfn) : com.rpl.specter.late_resolved_fn.call(null,navfn));
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34913__delegate = function (args){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(latenavfn,args);
};
var G__34913 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__34914__i = 0, G__34914__a = new Array(arguments.length -  0);
while (G__34914__i < G__34914__a.length) {G__34914__a[G__34914__i] = arguments[G__34914__i + 0]; ++G__34914__i;}
  args = new cljs.core.IndexedSeq(G__34914__a,0,null);
} 
return G__34913__delegate.call(this,args);};
G__34913.cljs$lang$maxFixedArity = 0;
G__34913.cljs$lang$applyTo = (function (arglist__34915){
var args = cljs.core.seq(arglist__34915);
return G__34913__delegate(args);
});
G__34913.cljs$core$IFn$_invoke$arity$variadic = G__34913__delegate;
return G__34913;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.local_declarepath = com.rpl.specter.impl.local_declarepath;


com.rpl.specter.STOP_select_STAR_ = (function com$rpl$specter$STOP_select_STAR_(structure,next_fn){
return com.rpl.specter.NONE;
});

com.rpl.specter.STOP_transform_STAR_ = (function com$rpl$specter$STOP_transform_STAR_(structure,next_fn){
return structure;
});

/**
 * Stops navigation at this point. For selection returns nothing and for
 *        transformation returns the structure unchanged
 */
com.rpl.specter.STOP = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34430 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34430 = (function (meta34431){
this.meta34431 = meta34431;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34430.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34432,meta34431__$1){
var self__ = this;
var _34432__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34430(meta34431__$1));
}));

(com.rpl.specter.t_com$rpl$specter34430.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34432){
var self__ = this;
var _34432__$1 = this;
return self__.meta34431;
}));

(com.rpl.specter.t_com$rpl$specter34430.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34430.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter34430.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return structure;
}));

(com.rpl.specter.t_com$rpl$specter34430.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34431","meta34431",1395574762,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34430.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34430.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34430");

(com.rpl.specter.t_com$rpl$specter34430.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34430");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34430.
 */
com.rpl.specter.__GT_t_com$rpl$specter34430 = (function com$rpl$specter$__GT_t_com$rpl$specter34430(meta34431){
return (new com.rpl.specter.t_com$rpl$specter34430(meta34431));
});

}

return (new com.rpl.specter.t_com$rpl$specter34430(null));
})()
;
/**
 * Stays navigated at the current point. Essentially a no-op navigator.
 */
com.rpl.specter.STAY = com.rpl.specter.impl.STAY_STAR_;
/**
 * Defines an endpoint in the navigation the transform function run. The transform
 *        function works just like it does in `transform`, with collected values
 *        given as the first arguments
 */
com.rpl.specter.terminal = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34433 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34433 = (function (afn,meta34434){
this.afn = afn;
this.meta34434 = meta34434;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34433.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34435,meta34434__$1){
var self__ = this;
var _34435__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34433(self__.afn,meta34434__$1));
}));

(com.rpl.specter.t_com$rpl$specter34433.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34435){
var self__ = this;
var _34435__$1 = this;
return self__.meta34434;
}));

(com.rpl.specter.t_com$rpl$specter34433.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34433.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter34433.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.terminal_STAR_(self__.afn,vals,structure);
}));

(com.rpl.specter.t_com$rpl$specter34433.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta34434","meta34434",-948508387,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34433.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34433.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34433");

(com.rpl.specter.t_com$rpl$specter34433.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34433");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34433.
 */
com.rpl.specter.__GT_t_com$rpl$specter34433 = (function com$rpl$specter$__GT_t_com$rpl$specter34433(afn__$1,meta34434){
return (new com.rpl.specter.t_com$rpl$specter34433(afn__$1,meta34434));
});

}

return (new com.rpl.specter.t_com$rpl$specter34433(afn,null));
}));
/**
 * Defines an endpoint in the navigation the transform function run.The transform
 *        function works differently than it does in `transform`. Rather than receive
 *        collected vals spliced in as the first arguments to the function, this function
 *        always takes two arguemnts. The first is all collected vals in a vector, and
 *        the second is the navigated value.
 */
com.rpl.specter.vterminal = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34436 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34436 = (function (afn,meta34437){
this.afn = afn;
this.meta34437 = meta34437;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34436.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34438,meta34437__$1){
var self__ = this;
var _34438__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34436(self__.afn,meta34437__$1));
}));

(com.rpl.specter.t_com$rpl$specter34436.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34438){
var self__ = this;
var _34438__$1 = this;
return self__.meta34437;
}));

(com.rpl.specter.t_com$rpl$specter34436.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34436.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter34436.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(vals,structure) : self__.afn.call(null,vals,structure));
}));

(com.rpl.specter.t_com$rpl$specter34436.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta34437","meta34437",-1287562169,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34436.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34436.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34436");

(com.rpl.specter.t_com$rpl$specter34436.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34436");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34436.
 */
com.rpl.specter.__GT_t_com$rpl$specter34436 = (function com$rpl$specter$__GT_t_com$rpl$specter34436(afn__$1,meta34437){
return (new com.rpl.specter.t_com$rpl$specter34436(afn__$1,meta34437));
});

}

return (new com.rpl.specter.t_com$rpl$specter34436(afn,null));
}));
/**
 * Like `terminal` but specifies a val to set at the location regardless of
 * the collected values or the value at the location.
 */
com.rpl.specter.terminal_val = (function com$rpl$specter$terminal_val(v){
var G__34439 = com.rpl.specter.impl.fast_constantly(v);
return (com.rpl.specter.terminal.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.terminal.cljs$core$IFn$_invoke$arity$1(G__34439) : com.rpl.specter.terminal.call(null,G__34439));
});


com.rpl.specter.ALL_select_STAR_ = (function com$rpl$specter$ALL_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.ALL_transform_STAR_ = (function com$rpl$specter$ALL_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_transform(structure,next_fn);
});

/**
 * Navigate to every element of the collection. For maps navigates to
 *        a vector of `[key value]`.
 */
com.rpl.specter.ALL = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34440 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34440 = (function (meta34441){
this.meta34441 = meta34441;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34440.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34442,meta34441__$1){
var self__ = this;
var _34442__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34440(meta34441__$1));
}));

(com.rpl.specter.t_com$rpl$specter34440.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34442){
var self__ = this;
var _34442__$1 = this;
return self__.meta34441;
}));

(com.rpl.specter.t_com$rpl$specter34440.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34440.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return com.rpl.specter.navs.all_select(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34440.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return com.rpl.specter.navs.all_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34440.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34441","meta34441",1166708677,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34440.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34440.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34440");

(com.rpl.specter.t_com$rpl$specter34440.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34440");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34440.
 */
com.rpl.specter.__GT_t_com$rpl$specter34440 = (function com$rpl$specter$__GT_t_com$rpl$specter34440(meta34441){
return (new com.rpl.specter.t_com$rpl$specter34440(meta34441));
});

}

return (new com.rpl.specter.t_com$rpl$specter34440(null));
})()
;


com.rpl.specter.ALL_WITH_META_select_STAR_ = (function com$rpl$specter$ALL_WITH_META_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.ALL_WITH_META_transform_STAR_ = (function com$rpl$specter$ALL_WITH_META_transform_STAR_(structure,next_fn){
var m = cljs.core.meta(structure);
var res = com.rpl.specter.navs.all_transform(structure,next_fn);
if((!((res == null)))){
return cljs.core.with_meta(res,m);
} else {
return null;
}
});

/**
 * Same as ALL, except maintains metadata on the structure.
 */
com.rpl.specter.ALL_WITH_META = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34443 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34443 = (function (meta34444){
this.meta34444 = meta34444;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34443.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34445,meta34444__$1){
var self__ = this;
var _34445__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34443(meta34444__$1));
}));

(com.rpl.specter.t_com$rpl$specter34443.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34445){
var self__ = this;
var _34445__$1 = this;
return self__.meta34444;
}));

(com.rpl.specter.t_com$rpl$specter34443.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34443.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return com.rpl.specter.navs.all_select(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34443.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var m = cljs.core.meta(structure);
var res = com.rpl.specter.navs.all_transform(structure,next_fn);
if((!((res == null)))){
return cljs.core.with_meta(res,m);
} else {
return null;
}
}));

(com.rpl.specter.t_com$rpl$specter34443.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34444","meta34444",1931128529,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34443.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34443.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34443");

(com.rpl.specter.t_com$rpl$specter34443.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34443");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34443.
 */
com.rpl.specter.__GT_t_com$rpl$specter34443 = (function com$rpl$specter$__GT_t_com$rpl$specter34443(meta34444){
return (new com.rpl.specter.t_com$rpl$specter34443(meta34444));
});

}

return (new com.rpl.specter.t_com$rpl$specter34443(null));
})()
;


com.rpl.specter.MAP_VALS_select_STAR_ = (function com$rpl$specter$MAP_VALS_select_STAR_(structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__30370__auto__,v){
var ret__30371__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(v) : next_fn.call(null,v));
if((ret__30371__auto__ === com.rpl.specter.NONE)){
return curr__30370__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__30371__auto__)){
return cljs.core.reduced(ret__30371__auto__);
} else {
return ret__30371__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals(structure));
});

com.rpl.specter.MAP_VALS_transform_STAR_ = (function com$rpl$specter$MAP_VALS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_vals_transform(structure,next_fn);
});

/**
 * Navigate to each value of the map. This is more efficient than
 *        navigating via [ALL LAST]
 */
com.rpl.specter.MAP_VALS = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34452 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34452 = (function (meta34453){
this.meta34453 = meta34453;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34452.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34454,meta34453__$1){
var self__ = this;
var _34454__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34452(meta34453__$1));
}));

(com.rpl.specter.t_com$rpl$specter34452.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34454){
var self__ = this;
var _34454__$1 = this;
return self__.meta34453;
}));

(com.rpl.specter.t_com$rpl$specter34452.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34452.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__30370__auto__,v){
var ret__30371__auto__ = next_fn(v);
if((ret__30371__auto__ === com.rpl.specter.NONE)){
return curr__30370__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__30371__auto__)){
return cljs.core.reduced(ret__30371__auto__);
} else {
return ret__30371__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals(structure));
}));

(com.rpl.specter.t_com$rpl$specter34452.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return com.rpl.specter.navs.map_vals_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34452.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34453","meta34453",310650864,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34452.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34452.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34452");

(com.rpl.specter.t_com$rpl$specter34452.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34452");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34452.
 */
com.rpl.specter.__GT_t_com$rpl$specter34452 = (function com$rpl$specter$__GT_t_com$rpl$specter34452(meta34453){
return (new com.rpl.specter.t_com$rpl$specter34452(meta34453));
});

}

return (new com.rpl.specter.t_com$rpl$specter34452(null));
})()
;


com.rpl.specter.MAP_KEYS_select_STAR_ = (function com$rpl$specter$MAP_KEYS_select_STAR_(structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__30370__auto__,k){
var ret__30371__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(k) : next_fn.call(null,k));
if((ret__30371__auto__ === com.rpl.specter.NONE)){
return curr__30370__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__30371__auto__)){
return cljs.core.reduced(ret__30371__auto__);
} else {
return ret__30371__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys(structure));
});

com.rpl.specter.MAP_KEYS_transform_STAR_ = (function com$rpl$specter$MAP_KEYS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_keys_transform(structure,next_fn);
});

/**
 * Navigate to each key of the map. This is more efficient than
 *        navigating via [ALL FIRST]
 */
com.rpl.specter.MAP_KEYS = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34455 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34455 = (function (meta34456){
this.meta34456 = meta34456;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34455.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34457,meta34456__$1){
var self__ = this;
var _34457__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34455(meta34456__$1));
}));

(com.rpl.specter.t_com$rpl$specter34455.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34457){
var self__ = this;
var _34457__$1 = this;
return self__.meta34456;
}));

(com.rpl.specter.t_com$rpl$specter34455.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34455.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__30370__auto__,k){
var ret__30371__auto__ = next_fn(k);
if((ret__30371__auto__ === com.rpl.specter.NONE)){
return curr__30370__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__30371__auto__)){
return cljs.core.reduced(ret__30371__auto__);
} else {
return ret__30371__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys(structure));
}));

(com.rpl.specter.t_com$rpl$specter34455.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return com.rpl.specter.navs.map_keys_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34455.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34456","meta34456",1457224391,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34455.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34455.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34455");

(com.rpl.specter.t_com$rpl$specter34455.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34455");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34455.
 */
com.rpl.specter.__GT_t_com$rpl$specter34455 = (function com$rpl$specter$__GT_t_com$rpl$specter34455(meta34456){
return (new com.rpl.specter.t_com$rpl$specter34455(meta34456));
});

}

return (new com.rpl.specter.t_com$rpl$specter34455(null));
})()
;
com.rpl.specter.VAL = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34459 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34459 = (function (meta34460){
this.meta34460 = meta34460;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34459.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34461,meta34460__$1){
var self__ = this;
var _34461__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34459(meta34460__$1));
}));

(com.rpl.specter.t_com$rpl$specter34459.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34461){
var self__ = this;
var _34461__$1 = this;
return self__.meta34460;
}));

(com.rpl.specter.t_com$rpl$specter34459.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34459.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__33368__auto__,vals__33369__auto__,structure,next_fn__33370__auto__){
var self__ = this;
var this__33368__auto____$1 = this;
var G__34462 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33369__auto__,structure);
var G__34463 = structure;
return (next_fn__33370__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33370__auto__.cljs$core$IFn$_invoke$arity$2(G__34462,G__34463) : next_fn__33370__auto__.call(null,G__34462,G__34463));
}));

(com.rpl.specter.t_com$rpl$specter34459.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__33368__auto__,vals__33369__auto__,structure,next_fn__33370__auto__){
var self__ = this;
var this__33368__auto____$1 = this;
var G__34464 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33369__auto__,structure);
var G__34465 = structure;
return (next_fn__33370__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33370__auto__.cljs$core$IFn$_invoke$arity$2(G__34464,G__34465) : next_fn__33370__auto__.call(null,G__34464,G__34465));
}));

(com.rpl.specter.t_com$rpl$specter34459.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34460","meta34460",-1686094954,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34459.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34459.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34459");

(com.rpl.specter.t_com$rpl$specter34459.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34459");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34459.
 */
com.rpl.specter.__GT_t_com$rpl$specter34459 = (function com$rpl$specter$__GT_t_com$rpl$specter34459(meta34460){
return (new com.rpl.specter.t_com$rpl$specter34459(meta34460));
});

}

return (new com.rpl.specter.t_com$rpl$specter34459(null));
})()
;
/**
 * Navigate to the last element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.LAST = (com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last) : com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last));
/**
 * Navigate to the first element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.FIRST = (com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first) : com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first));


com.rpl.specter.srange_dynamic_select_STAR_ = (function com$rpl$specter$srange_dynamic_select_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = (start_index_fn.cljs$core$IFn$_invoke$arity$1 ? start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : start_index_fn.call(null,structure));
return com.rpl.specter.navs.srange_select(structure,s,com.rpl.specter.navs.invoke_end_fn(end_index_fn,structure,s),next_fn);
});

com.rpl.specter.srange_dynamic_transform_STAR_ = (function com$rpl$specter$srange_dynamic_transform_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = (start_index_fn.cljs$core$IFn$_invoke$arity$1 ? start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : start_index_fn.call(null,structure));
var G__34470 = structure;
var G__34471 = s;
var G__34472 = com.rpl.specter.navs.invoke_end_fn(end_index_fn,structure,s);
var G__34473 = next_fn;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(G__34470,G__34471,G__34472,G__34473) : com.rpl.specter.navs.srange_transform.call(null,G__34470,G__34471,G__34472,G__34473));
});

/**
 * Uses start-index-fn and end-index-fn to determine the bounds of the subsequence
 *        to select when navigating. `start-index-fn` takes in the structure as input. `end-index-fn`
 *        can be one of two forms. If a regular function (e.g. defined with `fn`), it takes in only the structure as input. If a function defined using special `end-fn` macro, it takes in the structure and the result of `start-index-fn`.
 */
com.rpl.specter.srange_dynamic = com.rpl.specter.impl.direct_nav_obj((function (start_index_fn,end_index_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34474 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34474 = (function (start_index_fn,end_index_fn,meta34475){
this.start_index_fn = start_index_fn;
this.end_index_fn = end_index_fn;
this.meta34475 = meta34475;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34474.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34476,meta34475__$1){
var self__ = this;
var _34476__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34474(self__.start_index_fn,self__.end_index_fn,meta34475__$1));
}));

(com.rpl.specter.t_com$rpl$specter34474.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34476){
var self__ = this;
var _34476__$1 = this;
return self__.meta34475;
}));

(com.rpl.specter.t_com$rpl$specter34474.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34474.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var s = (self__.start_index_fn.cljs$core$IFn$_invoke$arity$1 ? self__.start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.start_index_fn.call(null,structure));
return com.rpl.specter.navs.srange_select(structure,s,com.rpl.specter.navs.invoke_end_fn(self__.end_index_fn,structure,s),next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34474.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var s = (self__.start_index_fn.cljs$core$IFn$_invoke$arity$1 ? self__.start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.start_index_fn.call(null,structure));
var G__34483 = structure;
var G__34484 = s;
var G__34485 = com.rpl.specter.navs.invoke_end_fn(self__.end_index_fn,structure,s);
var G__34486 = next_fn;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(G__34483,G__34484,G__34485,G__34486) : com.rpl.specter.navs.srange_transform.call(null,G__34483,G__34484,G__34485,G__34486));
}));

(com.rpl.specter.t_com$rpl$specter34474.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start-index-fn","start-index-fn",-344842645,null),new cljs.core.Symbol(null,"end-index-fn","end-index-fn",1237092062,null),new cljs.core.Symbol(null,"meta34475","meta34475",108229954,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34474.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34474.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34474");

(com.rpl.specter.t_com$rpl$specter34474.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34474");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34474.
 */
com.rpl.specter.__GT_t_com$rpl$specter34474 = (function com$rpl$specter$__GT_t_com$rpl$specter34474(start_index_fn__$1,end_index_fn__$1,meta34475){
return (new com.rpl.specter.t_com$rpl$specter34474(start_index_fn__$1,end_index_fn__$1,meta34475));
});

}

return (new com.rpl.specter.t_com$rpl$specter34474(start_index_fn,end_index_fn,null));
}));


com.rpl.specter.srange_select_STAR_ = (function com$rpl$specter$srange_select_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_select(structure,start,end,next_fn);
});

com.rpl.specter.srange_transform_STAR_ = (function com$rpl$specter$srange_transform_STAR_(start,end,structure,next_fn){
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(structure,start,end,next_fn) : com.rpl.specter.navs.srange_transform.call(null,structure,start,end,next_fn));
});

/**
 * Navigates to the subsequence bound by the indexes start (inclusive)
 *        and end (exclusive)
 */
com.rpl.specter.srange = com.rpl.specter.impl.direct_nav_obj((function (start,end){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34487 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34487 = (function (start,end,meta34488){
this.start = start;
this.end = end;
this.meta34488 = meta34488;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34487.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34489,meta34488__$1){
var self__ = this;
var _34489__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34487(self__.start,self__.end,meta34488__$1));
}));

(com.rpl.specter.t_com$rpl$specter34487.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34489){
var self__ = this;
var _34489__$1 = this;
return self__.meta34488;
}));

(com.rpl.specter.t_com$rpl$specter34487.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34487.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return com.rpl.specter.navs.srange_select(structure,self__.start,self__.end,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34487.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(structure,self__.start,self__.end,next_fn) : com.rpl.specter.navs.srange_transform.call(null,structure,self__.start,self__.end,next_fn));
}));

(com.rpl.specter.t_com$rpl$specter34487.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"meta34488","meta34488",550985882,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34487.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34487.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34487");

(com.rpl.specter.t_com$rpl$specter34487.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34487");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34487.
 */
com.rpl.specter.__GT_t_com$rpl$specter34487 = (function com$rpl$specter$__GT_t_com$rpl$specter34487(start__$1,end__$1,meta34488){
return (new com.rpl.specter.t_com$rpl$specter34487(start__$1,end__$1,meta34488));
});

}

return (new com.rpl.specter.t_com$rpl$specter34487(start,end,null));
}));


com.rpl.specter.continuous_subseqs_select_STAR_ = (function com$rpl$specter$continuous_subseqs_select_STAR_(pred,structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__30370__auto__,p__34490){
var vec__34491 = p__34490;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34491,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34491,(1),null);
var ret__30371__auto__ = com.rpl.specter.navs.srange_select(structure,s,e,next_fn);
if((ret__30371__auto__ === com.rpl.specter.NONE)){
return curr__30370__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__30371__auto__)){
return cljs.core.reduced(ret__30371__auto__);
} else {
return ret__30371__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges(structure,pred));
});

com.rpl.specter.continuous_subseqs_transform_STAR_ = (function com$rpl$specter$continuous_subseqs_transform_STAR_(pred,structure,next_fn){
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_(pred,structure,next_fn);
});

/**
 * Navigates to every continuous subsequence of elements matching `pred`
 */
com.rpl.specter.continuous_subseqs = com.rpl.specter.impl.direct_nav_obj((function (pred){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34494 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34494 = (function (pred,meta34495){
this.pred = pred;
this.meta34495 = meta34495;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34494.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34496,meta34495__$1){
var self__ = this;
var _34496__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34494(self__.pred,meta34495__$1));
}));

(com.rpl.specter.t_com$rpl$specter34494.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34496){
var self__ = this;
var _34496__$1 = this;
return self__.meta34495;
}));

(com.rpl.specter.t_com$rpl$specter34494.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34494.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__30370__auto__,p__34501){
var vec__34502 = p__34501;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34502,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34502,(1),null);
var ret__30371__auto__ = com.rpl.specter.navs.srange_select(structure,s,e,next_fn);
if((ret__30371__auto__ === com.rpl.specter.NONE)){
return curr__30370__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__30371__auto__)){
return cljs.core.reduced(ret__30371__auto__);
} else {
return ret__30371__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges(structure,self__.pred));
}));

(com.rpl.specter.t_com$rpl$specter34494.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_(self__.pred,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34494.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"meta34495","meta34495",1553728778,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34494.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34494.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34494");

(com.rpl.specter.t_com$rpl$specter34494.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34494");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34494.
 */
com.rpl.specter.__GT_t_com$rpl$specter34494 = (function com$rpl$specter$__GT_t_com$rpl$specter34494(pred__$1,meta34495){
return (new com.rpl.specter.t_com$rpl$specter34494(pred__$1,meta34495));
});

}

return (new com.rpl.specter.t_com$rpl$specter34494(pred,null));
}));


com.rpl.specter.BEGINNING_select_STAR_ = (function com$rpl$specter$BEGINNING_select_STAR_(structure,next_fn){
var G__34505 = ((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34505) : next_fn.call(null,G__34505));
});

com.rpl.specter.BEGINNING_transform_STAR_ = (function com$rpl$specter$BEGINNING_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1("") : next_fn.call(null,""))),structure].join('');
} else {
var to_prepend = (function (){var G__34507 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34507) : next_fn.call(null,G__34507));
})();
return com.rpl.specter.navs.prepend_all(structure,to_prepend);
}
});

/**
 * Navigate to the empty subsequence before the first element of the collection.
 */
com.rpl.specter.BEGINNING = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34508 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34508 = (function (meta34509){
this.meta34509 = meta34509;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34508.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34510,meta34509__$1){
var self__ = this;
var _34510__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34508(meta34509__$1));
}));

(com.rpl.specter.t_com$rpl$specter34508.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34510){
var self__ = this;
var _34510__$1 = this;
return self__.meta34509;
}));

(com.rpl.specter.t_com$rpl$specter34508.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34508.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
}));

(com.rpl.specter.t_com$rpl$specter34508.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn("")),structure].join('');
} else {
var to_prepend = next_fn(cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all(structure,to_prepend);
}
}));

(com.rpl.specter.t_com$rpl$specter34508.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34509","meta34509",-65411086,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34508.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34508.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34508");

(com.rpl.specter.t_com$rpl$specter34508.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34508");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34508.
 */
com.rpl.specter.__GT_t_com$rpl$specter34508 = (function com$rpl$specter$__GT_t_com$rpl$specter34508(meta34509){
return (new com.rpl.specter.t_com$rpl$specter34508(meta34509));
});

}

return (new com.rpl.specter.t_com$rpl$specter34508(null));
})()
;


com.rpl.specter.END_select_STAR_ = (function com$rpl$specter$END_select_STAR_(structure,next_fn){
var G__34511 = ((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34511) : next_fn.call(null,G__34511));
});

com.rpl.specter.END_transform_STAR_ = (function com$rpl$specter$END_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [structure,cljs.core.str.cljs$core$IFn$_invoke$arity$1((next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1("") : next_fn.call(null,"")))].join('');
} else {
var to_append = (function (){var G__34512 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34512) : next_fn.call(null,G__34512));
})();
return com.rpl.specter.navs.append_all(structure,to_append);
}
});

/**
 * Navigate to the empty subsequence after the last element of the collection.
 */
com.rpl.specter.END = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34513 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34513 = (function (meta34514){
this.meta34514 = meta34514;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34513.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34515,meta34514__$1){
var self__ = this;
var _34515__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34513(meta34514__$1));
}));

(com.rpl.specter.t_com$rpl$specter34513.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34515){
var self__ = this;
var _34515__$1 = this;
return self__.meta34514;
}));

(com.rpl.specter.t_com$rpl$specter34513.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34513.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
}));

(com.rpl.specter.t_com$rpl$specter34513.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
if(typeof structure === 'string'){
return [structure,cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn(""))].join('');
} else {
var to_append = next_fn(cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all(structure,to_append);
}
}));

(com.rpl.specter.t_com$rpl$specter34513.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34514","meta34514",1870491545,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34513.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34513.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34513");

(com.rpl.specter.t_com$rpl$specter34513.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34513");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34513.
 */
com.rpl.specter.__GT_t_com$rpl$specter34513 = (function com$rpl$specter$__GT_t_com$rpl$specter34513(meta34514){
return (new com.rpl.specter.t_com$rpl$specter34513(meta34514));
});

}

return (new com.rpl.specter.t_com$rpl$specter34513(null));
})()
;


com.rpl.specter.NONE_ELEM_select_STAR_ = (function com$rpl$specter$NONE_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.NONE_ELEM_transform_STAR_ = (function com$rpl$specter$NONE_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(structure,newe);
}
}
});

/**
 * Navigate to 'void' elem in the set.
 *        For transformations - if result is not `NONE`,
 *        then add that value to the set.
 */
com.rpl.specter.NONE_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34516 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34516 = (function (meta34517){
this.meta34517 = meta34517;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34516.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34518,meta34517__$1){
var self__ = this;
var _34518__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34516(meta34517__$1));
}));

(com.rpl.specter.t_com$rpl$specter34516.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34518){
var self__ = this;
var _34518__$1 = this;
return self__.meta34517;
}));

(com.rpl.specter.t_com$rpl$specter34516.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34516.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter34516.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(structure,newe);
}
}
}));

(com.rpl.specter.t_com$rpl$specter34516.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34517","meta34517",-1525761406,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34516.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34516.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34516");

(com.rpl.specter.t_com$rpl$specter34516.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34516");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34516.
 */
com.rpl.specter.__GT_t_com$rpl$specter34516 = (function com$rpl$specter$__GT_t_com$rpl$specter34516(meta34517){
return (new com.rpl.specter.t_com$rpl$specter34516(meta34517));
});

}

return (new com.rpl.specter.t_com$rpl$specter34516(null));
})()
;


com.rpl.specter.BEFORE_ELEM_select_STAR_ = (function com$rpl$specter$BEFORE_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.BEFORE_ELEM_transform_STAR_ = (function com$rpl$specter$BEFORE_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one(structure,newe);
}
});

/**
 * Navigate to 'void' element before the sequence.
 *        For transformations – if result is not `NONE`,
 *        then prepend that value.
 */
com.rpl.specter.BEFORE_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34519 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34519 = (function (meta34520){
this.meta34520 = meta34520;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34519.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34521,meta34520__$1){
var self__ = this;
var _34521__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34519(meta34520__$1));
}));

(com.rpl.specter.t_com$rpl$specter34519.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34521){
var self__ = this;
var _34521__$1 = this;
return self__.meta34520;
}));

(com.rpl.specter.t_com$rpl$specter34519.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34519.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter34519.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one(structure,newe);
}
}));

(com.rpl.specter.t_com$rpl$specter34519.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34520","meta34520",-24261430,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34519.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34519.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34519");

(com.rpl.specter.t_com$rpl$specter34519.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34519");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34519.
 */
com.rpl.specter.__GT_t_com$rpl$specter34519 = (function com$rpl$specter$__GT_t_com$rpl$specter34519(meta34520){
return (new com.rpl.specter.t_com$rpl$specter34519(meta34520));
});

}

return (new com.rpl.specter.t_com$rpl$specter34519(null));
})()
;


com.rpl.specter.AFTER_ELEM_select_STAR_ = (function com$rpl$specter$AFTER_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.AFTER_ELEM_transform_STAR_ = (function com$rpl$specter$AFTER_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one(structure,newe);
}
});

/**
 * Navigate to 'void' element after the sequence.
 *        For transformations – if result is not `NONE`,
 *        then append that value.
 */
com.rpl.specter.AFTER_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34522 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34522 = (function (meta34523){
this.meta34523 = meta34523;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34522.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34524,meta34523__$1){
var self__ = this;
var _34524__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34522(meta34523__$1));
}));

(com.rpl.specter.t_com$rpl$specter34522.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34524){
var self__ = this;
var _34524__$1 = this;
return self__.meta34523;
}));

(com.rpl.specter.t_com$rpl$specter34522.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34522.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter34522.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one(structure,newe);
}
}));

(com.rpl.specter.t_com$rpl$specter34522.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34523","meta34523",-1516978372,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34522.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34522.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34522");

(com.rpl.specter.t_com$rpl$specter34522.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34522");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34522.
 */
com.rpl.specter.__GT_t_com$rpl$specter34522 = (function com$rpl$specter$__GT_t_com$rpl$specter34522(meta34523){
return (new com.rpl.specter.t_com$rpl$specter34522(meta34523));
});

}

return (new com.rpl.specter.t_com$rpl$specter34522(null));
})()
;


com.rpl.specter.subset_select_STAR_ = (function com$rpl$specter$subset_select_STAR_(aset,structure,next_fn){
var G__34525 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,aset);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34525) : next_fn.call(null,G__34525));
});

com.rpl.specter.subset_transform_STAR_ = (function com$rpl$specter$subset_transform_STAR_(aset,structure,next_fn){
var subset = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,aset);
var newset = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(subset) : next_fn.call(null,subset));
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(structure,subset),newset);
});

/**
 * Navigates to the specified subset (by taking an intersection).
 *        In a transform, that subset in the original set is changed to the
 *        new value of the subset.
 */
com.rpl.specter.subset = com.rpl.specter.impl.direct_nav_obj((function (aset){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34526 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34526 = (function (aset,meta34527){
this.aset = aset;
this.meta34527 = meta34527;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34526.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34528,meta34527__$1){
var self__ = this;
var _34528__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34526(self__.aset,meta34527__$1));
}));

(com.rpl.specter.t_com$rpl$specter34526.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34528){
var self__ = this;
var _34528__$1 = this;
return self__.meta34527;
}));

(com.rpl.specter.t_com$rpl$specter34526.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34526.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,self__.aset));
}));

(com.rpl.specter.t_com$rpl$specter34526.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var subset = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,self__.aset);
var newset = next_fn(subset);
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(structure,subset),newset);
}));

(com.rpl.specter.t_com$rpl$specter34526.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"aset","aset",900773178,null),new cljs.core.Symbol(null,"meta34527","meta34527",-1553329371,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34526.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34526.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34526");

(com.rpl.specter.t_com$rpl$specter34526.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34526");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34526.
 */
com.rpl.specter.__GT_t_com$rpl$specter34526 = (function com$rpl$specter$__GT_t_com$rpl$specter34526(aset__$1,meta34527){
return (new com.rpl.specter.t_com$rpl$specter34526(aset__$1,meta34527));
});

}

return (new com.rpl.specter.t_com$rpl$specter34526(aset,null));
}));


com.rpl.specter.submap_select_STAR_ = (function com$rpl$specter$submap_select_STAR_(m_keys,structure,next_fn){
var G__34545 = cljs.core.select_keys(structure,m_keys);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34545) : next_fn.call(null,G__34545));
});

com.rpl.specter.submap_transform_STAR_ = (function com$rpl$specter$submap_transform_STAR_(m_keys,structure,next_fn){
var submap = cljs.core.select_keys(structure,m_keys);
var newmap = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(submap) : next_fn.call(null,submap));
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,structure,m_keys),newmap], 0));
});

/**
 * Navigates to the specified submap (using select-keys).
 *        In a transform, that submap in the original map is changed to the new
 *        value of the submap.
 */
com.rpl.specter.submap = com.rpl.specter.impl.direct_nav_obj((function (m_keys){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34546 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34546 = (function (m_keys,meta34547){
this.m_keys = m_keys;
this.meta34547 = meta34547;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34546.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34548,meta34547__$1){
var self__ = this;
var _34548__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34546(self__.m_keys,meta34547__$1));
}));

(com.rpl.specter.t_com$rpl$specter34546.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34548){
var self__ = this;
var _34548__$1 = this;
return self__.meta34547;
}));

(com.rpl.specter.t_com$rpl$specter34546.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34546.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(cljs.core.select_keys(structure,self__.m_keys));
}));

(com.rpl.specter.t_com$rpl$specter34546.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var submap = cljs.core.select_keys(structure,self__.m_keys);
var newmap = next_fn(submap);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,structure,self__.m_keys),newmap], 0));
}));

(com.rpl.specter.t_com$rpl$specter34546.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"m-keys","m-keys",-197459035,null),new cljs.core.Symbol(null,"meta34547","meta34547",54852239,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34546.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34546.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34546");

(com.rpl.specter.t_com$rpl$specter34546.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34546");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34546.
 */
com.rpl.specter.__GT_t_com$rpl$specter34546 = (function com$rpl$specter$__GT_t_com$rpl$specter34546(m_keys__$1,meta34547){
return (new com.rpl.specter.t_com$rpl$specter34546(m_keys__$1,meta34547));
});

}

return (new com.rpl.specter.t_com$rpl$specter34546(m_keys,null));
}));
/**
 * Navigates to a sequence that contains the results of (select ...),
 *   but is a view to the original structure that can be transformed.
 * 
 *   Requires that the input navigators will walk the structure's
 *   children in the same order when executed on "select" and then
 *   "transform".
 * 
 *   If transformed sequence is smaller than input sequence, missing entries
 *   will be filled in with NONE, triggering removal if supported by that navigator.
 * 
 *   Value collection (e.g. collect, collect-one) may not be used in the subpath.
 */
com.rpl.specter.subselect = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34926__delegate = function (path){
var builder__33371__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34549 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34549 = (function (path,late,meta34550){
this.path = path;
this.late = late;
this.meta34550 = meta34550;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34549.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34551,meta34550__$1){
var self__ = this;
var _34551__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34549(self__.path,self__.late,meta34550__$1));
}));

(com.rpl.specter.t_com$rpl$specter34549.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34551){
var self__ = this;
var _34551__$1 = this;
return self__.meta34550;
}));

(com.rpl.specter.t_com$rpl$specter34549.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34549.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn((com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
}));

(com.rpl.specter.t_com$rpl$specter34549.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var select_result = (com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure));
var transformed = next_fn(select_result);
var values_to_insert = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(transformed));
var G__34552 = self__.late;
var G__34553 = (function (_){
var vs = com.rpl.specter.impl.get_cell(values_to_insert);
if(cljs.core.truth_(vs)){
com.rpl.specter.impl.update_cell_BANG_(values_to_insert,cljs.core.next);

return cljs.core.first(vs);
} else {
return com.rpl.specter.NONE;
}
});
var G__34554 = structure;
return (com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(G__34552,G__34553,G__34554) : com.rpl.specter.compiled_transform.call(null,G__34552,G__34553,G__34554));
}));

(com.rpl.specter.t_com$rpl$specter34549.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta34550","meta34550",100701655,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34549.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34549.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34549");

(com.rpl.specter.t_com$rpl$specter34549.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34549");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34549.
 */
com.rpl.specter.__GT_t_com$rpl$specter34549 = (function com$rpl$specter$__GT_t_com$rpl$specter34549(path__$1,late__$1,meta34550){
return (new com.rpl.specter.t_com$rpl$specter34549(path__$1,late__$1,meta34550));
});

}

return (new com.rpl.specter.t_com$rpl$specter34549(path,late,null));
}));
var curr_params__33372__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33372__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33371__auto__,curr_params__33372__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33371__auto__,curr_params__33372__auto__,null);
}
};
var G__34926 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34930__i = 0, G__34930__a = new Array(arguments.length -  0);
while (G__34930__i < G__34930__a.length) {G__34930__a[G__34930__i] = arguments[G__34930__i + 0]; ++G__34930__i;}
  path = new cljs.core.IndexedSeq(G__34930__a,0,null);
} 
return G__34926__delegate.call(this,path);};
G__34926.cljs$lang$maxFixedArity = 0;
G__34926.cljs$lang$applyTo = (function (arglist__34931){
var path = cljs.core.seq(arglist__34931);
return G__34926__delegate(path);
});
G__34926.cljs$core$IFn$_invoke$arity$variadic = G__34926__delegate;
return G__34926;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the given key in the map (not to the value). Navigates only if the
 *        key currently exists in the map. Can transform to NONE to remove the key/value
 *        pair from the map.
 */
com.rpl.specter.map_key = com.rpl.specter.impl.direct_nav_obj((function (key){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34555 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34555 = (function (key,meta34556){
this.key = key;
this.meta34556 = meta34556;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34555.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34557,meta34556__$1){
var self__ = this;
var _34557__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34555(self__.key,meta34556__$1));
}));

(com.rpl.specter.t_com$rpl$specter34555.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34557){
var self__ = this;
var _34557__$1 = this;
return self__.meta34556;
}));

(com.rpl.specter.t_com$rpl$specter34555.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34555.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.key)){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.key) : next_fn.call(null,vals,self__.key));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter34555.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.key)){
var newkey = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.key) : next_fn.call(null,vals,self__.key));
var dissoced = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(structure,self__.key);
if((com.rpl.specter.NONE === newkey)){
return dissoced;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(dissoced,newkey,cljs.core.get.cljs$core$IFn$_invoke$arity$2(structure,self__.key));
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter34555.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"meta34556","meta34556",1151891271,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34555.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34555.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34555");

(com.rpl.specter.t_com$rpl$specter34555.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34555");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34555.
 */
com.rpl.specter.__GT_t_com$rpl$specter34555 = (function com$rpl$specter$__GT_t_com$rpl$specter34555(key__$1,meta34556){
return (new com.rpl.specter.t_com$rpl$specter34555(key__$1,meta34556));
});

}

return (new com.rpl.specter.t_com$rpl$specter34555(key,null));
}));
/**
 * Navigates to the given element in the set only if it exists in the set.
 *        Can transform to NONE to remove the element from the set.
 */
com.rpl.specter.set_elem = com.rpl.specter.impl.direct_nav_obj((function (elem){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34571 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34571 = (function (elem,meta34572){
this.elem = elem;
this.meta34572 = meta34572;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34571.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34573,meta34572__$1){
var self__ = this;
var _34573__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34571(self__.elem,meta34572__$1));
}));

(com.rpl.specter.t_com$rpl$specter34571.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34573){
var self__ = this;
var _34573__$1 = this;
return self__.meta34572;
}));

(com.rpl.specter.t_com$rpl$specter34571.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34571.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.elem)){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.elem) : next_fn.call(null,vals,self__.elem));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter34571.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.elem)){
var newelem = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.elem) : next_fn.call(null,vals,self__.elem));
var removed = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(structure,self__.elem);
if((com.rpl.specter.NONE === newelem)){
return removed;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(removed,newelem);
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter34571.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"elem","elem",-2035804713,null),new cljs.core.Symbol(null,"meta34572","meta34572",-681920889,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34571.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34571.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34571");

(com.rpl.specter.t_com$rpl$specter34571.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34571");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34571.
 */
com.rpl.specter.__GT_t_com$rpl$specter34571 = (function com$rpl$specter$__GT_t_com$rpl$specter34571(elem__$1,meta34572){
return (new com.rpl.specter.t_com$rpl$specter34571(elem__$1,meta34572));
});

}

return (new com.rpl.specter.t_com$rpl$specter34571(elem,null));
}));
/**
 * Navigate to the specified keys one after another. If navigate to NONE,
 *           that element is removed from the map or vector.
 */
com.rpl.specter.keypath = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.keypath_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.keypath_STAR_));
/**
 * Navigate to the specified keys one after another, only if they exist
 *           in the data structure. If navigate to NONE, that element is removed
 *           from the map or vector.
 */
com.rpl.specter.must = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.must_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.must_STAR_));
/**
 * Navigate to the specified indices one after another. If navigate to
 *          NONE, that element is removed from the sequence.
 */
com.rpl.specter.nthpath = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.nthpath_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.nthpath_STAR_));
/**
 * Navigates to the empty space between the index and the prior index. For select
 *        navigates to NONE, and transforms to non-NONE insert at that position.
 */
com.rpl.specter.before_index = com.rpl.specter.impl.direct_nav_obj((function (index){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34574 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34574 = (function (index,meta34575){
this.index = index;
this.meta34575 = meta34575;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34574.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34576,meta34575__$1){
var self__ = this;
var _34576__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34574(self__.index,meta34575__$1));
}));

(com.rpl.specter.t_com$rpl$specter34574.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34576){
var self__ = this;
var _34576__$1 = this;
return self__.meta34575;
}));

(com.rpl.specter.t_com$rpl$specter34574.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34574.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter34574.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var v = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,com.rpl.specter.NONE) : next_fn.call(null,vals,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === v)){
return structure;
} else {
return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__33379__auto__ = com.rpl.specter.pathcache34608;
var info__33379__auto____$1 = (((info__33379__auto__ == null))?(function (){var info34609 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.srange,new cljs.core.Var(function(){return com.rpl.specter.srange;},new cljs.core.Symbol("com.rpl.specter","srange","com.rpl.specter/srange",-978851939,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"srange","srange",-1324254972,null),"com/rpl/specter.cljc",9,1,755,758,cljs.core.List.EMPTY,"Navigates to the subsequence bound by the indexes start (inclusive)\n          and end (exclusive)",(cljs.core.truth_(com.rpl.specter.srange)?com.rpl.specter.srange.cljs$lang$test:null)])),new cljs.core.Symbol(null,"srange","srange",-1324254972,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(self__.index,new cljs.core.Symbol(null,"index","index",108845612,null)),com.rpl.specter.impl.__GT_LocalSym(self__.index,new cljs.core.Symbol(null,"index","index",108845612,null))], null),cljs.core.list(new cljs.core.Symbol(null,"srange","srange",-1324254972,null),new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"srange","srange",-1324254972,null),new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)], null));
com.rpl.specter.pathcache34608 = info34609;

return info34609;
})():info__33379__auto__);
var precompiled34610 = com.rpl.specter.impl.cached_path_info_precompiled(info__33379__auto____$1);
var dynamic_QMARK___33380__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33379__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33380__auto__)){
var G__34611 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.srange,self__.index,self__.index], null);
return (precompiled34610.cljs$core$IFn$_invoke$arity$1 ? precompiled34610.cljs$core$IFn$_invoke$arity$1(G__34611) : precompiled34610.call(null,G__34611));
} else {
return precompiled34610;
}
})(),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v], null),structure);
}
}));

(com.rpl.specter.t_com$rpl$specter34574.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"meta34575","meta34575",-705056944,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34574.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34574.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34574");

(com.rpl.specter.t_com$rpl$specter34574.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34574");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34574.
 */
com.rpl.specter.__GT_t_com$rpl$specter34574 = (function com$rpl$specter$__GT_t_com$rpl$specter34574(index__$1,meta34575){
return (new com.rpl.specter.t_com$rpl$specter34574(index__$1,meta34575));
});

}

return (new com.rpl.specter.t_com$rpl$specter34574(index,null));
}));
/**
 * Navigates to the index of the sequence if within 0 and size. Transforms move element
 *        at that index to the new index, shifting other elements in the sequence.
 */
com.rpl.specter.index_nav = com.rpl.specter.impl.direct_nav_obj((function (i){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34612 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34612 = (function (i,meta34613){
this.i = i;
this.meta34613 = meta34613;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34612.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34614,meta34613__$1){
var self__ = this;
var _34614__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34612(self__.i,meta34613__$1));
}));

(com.rpl.specter.t_com$rpl$specter34612.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34614){
var self__ = this;
var _34614__$1 = this;
return self__.meta34613;
}));

(com.rpl.specter.t_com$rpl$specter34612.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34612.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if((((self__.i >= (0))) && ((self__.i < cljs.core.count(structure))))){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.i) : next_fn.call(null,vals,self__.i));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter34612.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if((((self__.i >= (0))) && ((self__.i < cljs.core.count(structure))))){
var newi = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.i) : next_fn.call(null,vals,self__.i));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(newi,self__.i)){
return structure;
} else {
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(structure,self__.i);
if(cljs.core.vector_QMARK_(structure)){
var shifted = (((newi < self__.i))?(function (){var j = (self__.i - (1));
var s = structure;
while(true){
if((j < newi)){
return s;
} else {
var G__34933 = (j - (1));
var G__34934 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,(j + (1)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(s,j));
j = G__34933;
s = G__34934;
continue;
}
break;
}
})():(function (){var j = (self__.i + (1));
var s = structure;
while(true){
if((j > newi)){
return s;
} else {
var G__34935 = (j + (1));
var G__34936 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,(j - (1)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(s,j));
j = G__34935;
s = G__34936;
continue;
}
break;
}
})());
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(shifted,newi,v);
} else {
return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__33379__auto__ = com.rpl.specter.pathcache34631;
var info__33379__auto____$1 = (((info__33379__auto__ == null))?(function (){var info34632 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.before_index,new cljs.core.Var(function(){return com.rpl.specter.before_index;},new cljs.core.Symbol("com.rpl.specter","before-index","com.rpl.specter/before-index",1952616274,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),"com/rpl/specter.cljc",15,1,968,971,cljs.core.List.EMPTY,"Navigates to the empty space between the index and the prior index. For select\n          navigates to NONE, and transforms to non-NONE insert at that position.",(cljs.core.truth_(com.rpl.specter.before_index)?com.rpl.specter.before_index.cljs$lang$test:null)])),new cljs.core.Symbol(null,"before-index","before-index",-407870261,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(newi,new cljs.core.Symbol(null,"newi","newi",857919881,null))], null),cljs.core.list(new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null));
com.rpl.specter.pathcache34631 = info34632;

return info34632;
})():info__33379__auto__);
var precompiled34633 = com.rpl.specter.impl.cached_path_info_precompiled(info__33379__auto____$1);
var dynamic_QMARK___33380__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33379__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33380__auto__)){
var G__34634 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.before_index,newi], null);
return (precompiled34633.cljs$core$IFn$_invoke$arity$1 ? precompiled34633.cljs$core$IFn$_invoke$arity$1(G__34634) : precompiled34633.call(null,G__34634));
} else {
return precompiled34633;
}
})(),v,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__33379__auto__ = com.rpl.specter.pathcache34635;
var info__33379__auto____$1 = (((info__33379__auto__ == null))?(function (){var info34636 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(self__.i,new cljs.core.Symbol(null,"i","i",253690212,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"i","i",253690212,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"i","i",253690212,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"i","i",253690212,null)], null));
com.rpl.specter.pathcache34635 = info34636;

return info34636;
})():info__33379__auto__);
var precompiled34637 = com.rpl.specter.impl.cached_path_info_precompiled(info__33379__auto____$1);
var dynamic_QMARK___33380__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33379__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33380__auto__)){
var G__34638 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,self__.i], null);
return (precompiled34637.cljs$core$IFn$_invoke$arity$1 ? precompiled34637.cljs$core$IFn$_invoke$arity$1(G__34638) : precompiled34637.call(null,G__34638));
} else {
return precompiled34637;
}
})(),com.rpl.specter.NONE,structure));
}
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter34612.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta34613","meta34613",914794131,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34612.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34612.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34612");

(com.rpl.specter.t_com$rpl$specter34612.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34612");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34612.
 */
com.rpl.specter.__GT_t_com$rpl$specter34612 = (function com$rpl$specter$__GT_t_com$rpl$specter34612(i__$1,meta34613){
return (new com.rpl.specter.t_com$rpl$specter34612(i__$1,meta34613));
});

}

return (new com.rpl.specter.t_com$rpl$specter34612(i,null));
}));


com.rpl.specter.indexed_vals_select_STAR_ = (function com$rpl$specter$indexed_vals_select_STAR_(start,structure,next_fn){
var i = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1((start - (1)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__30370__auto__,e){
var ret__30371__auto__ = (function (){
com.rpl.specter.impl.update_cell_BANG_(i,cljs.core.inc);

var G__34641 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.get_cell(i),e], null);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34641) : next_fn.call(null,G__34641));
})()
;
if((ret__30371__auto__ === com.rpl.specter.NONE)){
return curr__30370__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__30371__auto__)){
return cljs.core.reduced(ret__30371__auto__);
} else {
return ret__30371__auto__;
}
}
}),com.rpl.specter.NONE,structure);
});

com.rpl.specter.indexed_vals_transform_STAR_ = (function com$rpl$specter$indexed_vals_transform_STAR_(start,structure,next_fn){
var indices = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(structure)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s,e){
var curri = cljs.core.first(com.rpl.specter.impl.get_cell(indices));
var vec__34642 = (function (){var G__34645 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(start + curri),e], null);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34645) : next_fn.call(null,G__34645));
})();
var newi_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34642,(0),null);
var newe = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34642,(1),null);
var newi = (newi_STAR_ - start);
com.rpl.specter.impl.update_cell_BANG_(indices,(function (ii){
var ii2 = cljs.core.next(ii);
if((newi > curri)){
return com.rpl.specter.impl.compiled_transform_STAR_((function (){var info__33379__auto__ = com.rpl.specter.pathcache34654;
var info__33379__auto____$1 = (((info__33379__auto__ == null))?(function (){var info34655 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__34639_SHARP_){
return (p1__34639_SHARP_ >= (curri + (1)));
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34639#","p1__34639#",1385071603,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__34639#","p1__34639#",1385071603,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null))))),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__34640_SHARP_){
return (p1__34640_SHARP_ <= newi);
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34640#","p1__34640#",-517346419,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__34640#","p1__34640#",-517346419,null),new cljs.core.Symbol(null,"newi","newi",857919881,null))))], null)], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34639#","p1__34639#",1385071603,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__34639#","p1__34639#",1385071603,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34640#","p1__34640#",-517346419,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__34640#","p1__34640#",-517346419,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34639#","p1__34639#",1385071603,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__34639#","p1__34639#",1385071603,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34640#","p1__34640#",-517346419,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__34640#","p1__34640#",-517346419,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null));
com.rpl.specter.pathcache34654 = info34655;

return info34655;
})():info__33379__auto__);
var precompiled34656 = com.rpl.specter.impl.cached_path_info_precompiled(info__33379__auto____$1);
var dynamic_QMARK___33380__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33379__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33380__auto__)){
var G__34658 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,(function (p1__34639_SHARP_){
return (p1__34639_SHARP_ >= (curri + (1)));
}),(function (p1__34640_SHARP_){
return (p1__34640_SHARP_ <= newi);
})], null),com.rpl.specter.ALL,(function (p1__34639_SHARP_){
return (p1__34639_SHARP_ >= (curri + (1)));
}),(function (p1__34640_SHARP_){
return (p1__34640_SHARP_ <= newi);
})], null);
return (precompiled34656.cljs$core$IFn$_invoke$arity$1 ? precompiled34656.cljs$core$IFn$_invoke$arity$1(G__34658) : precompiled34656.call(null,G__34658));
} else {
return precompiled34656;
}
})(),cljs.core.dec,ii2);
} else {
return ii2;
}
}));

return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__33379__auto__ = com.rpl.specter.pathcache34659;
var info__33379__auto____$1 = (((info__33379__auto__ == null))?(function (){var info34660 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.index_nav,new cljs.core.Var(function(){return com.rpl.specter.index_nav;},new cljs.core.Symbol("com.rpl.specter","index-nav","com.rpl.specter/index-nav",2054501071,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),"com/rpl/specter.cljc",12,1,983,986,cljs.core.List.EMPTY,"Navigates to the index of the sequence if within 0 and size. Transforms move element\n          at that index to the new index, shifting other elements in the sequence.",(cljs.core.truth_(com.rpl.specter.index_nav)?com.rpl.specter.index_nav.cljs$lang$test:null)])),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache34659 = info34660;

return info34660;
})():info__33379__auto__);
var precompiled34661 = com.rpl.specter.impl.cached_path_info_precompiled(info__33379__auto____$1);
var dynamic_QMARK___33380__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33379__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33380__auto__)){
var G__34662 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.index_nav,curri], null);
return (precompiled34661.cljs$core$IFn$_invoke$arity$1 ? precompiled34661.cljs$core$IFn$_invoke$arity$1(G__34662) : precompiled34661.call(null,G__34662));
} else {
return precompiled34661;
}
})(),newi,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__33379__auto__ = com.rpl.specter.pathcache34663;
var info__33379__auto____$1 = (((info__33379__auto__ == null))?(function (){var info34664 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache34663 = info34664;

return info34664;
})():info__33379__auto__);
var precompiled34665 = com.rpl.specter.impl.cached_path_info_precompiled(info__33379__auto____$1);
var dynamic_QMARK___33380__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33379__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33380__auto__)){
var G__34666 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,curri], null);
return (precompiled34665.cljs$core$IFn$_invoke$arity$1 ? precompiled34665.cljs$core$IFn$_invoke$arity$1(G__34666) : precompiled34665.call(null,G__34666));
} else {
return precompiled34665;
}
})(),newe,s));
}),structure,structure);
});

/**
 * Navigate to [index elem] pairs for each element in a sequence. The sequence will be indexed
 *        starting from `start`. Changing index in transform has same effect as `index-nav`. Indices seen
 *        during transform take into account any shifting from prior sequence elements changing indices.
 */
com.rpl.specter.indexed_vals = com.rpl.specter.impl.direct_nav_obj((function (start){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34667 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34667 = (function (start,meta34668){
this.start = start;
this.meta34668 = meta34668;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34667.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34669,meta34668__$1){
var self__ = this;
var _34669__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34667(self__.start,meta34668__$1));
}));

(com.rpl.specter.t_com$rpl$specter34667.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34669){
var self__ = this;
var _34669__$1 = this;
return self__.meta34668;
}));

(com.rpl.specter.t_com$rpl$specter34667.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34667.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var i = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1((self__.start - (1)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__30370__auto__,e){
var ret__30371__auto__ = (function (){
com.rpl.specter.impl.update_cell_BANG_(i,cljs.core.inc);

return next_fn(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.get_cell(i),e], null));
})()
;
if((ret__30371__auto__ === com.rpl.specter.NONE)){
return curr__30370__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__30371__auto__)){
return cljs.core.reduced(ret__30371__auto__);
} else {
return ret__30371__auto__;
}
}
}),com.rpl.specter.NONE,structure);
}));

(com.rpl.specter.t_com$rpl$specter34667.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var indices = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(structure)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s,e){
var curri = cljs.core.first(com.rpl.specter.impl.get_cell(indices));
var vec__34670 = next_fn(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.start + curri),e], null));
var newi_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34670,(0),null);
var newe = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34670,(1),null);
var newi = (newi_STAR_ - self__.start);
com.rpl.specter.impl.update_cell_BANG_(indices,(function (ii){
var ii2 = cljs.core.next(ii);
if((newi > curri)){
return com.rpl.specter.impl.compiled_transform_STAR_((function (){var info__33379__auto__ = com.rpl.specter.pathcache34673;
var info__33379__auto____$1 = (((info__33379__auto__ == null))?(function (){var info34674 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__34639_SHARP_){
return (p1__34639_SHARP_ >= (curri + (1)));
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34639#","p1__34639#",1385071603,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__34639#","p1__34639#",1385071603,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null))))),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__34640_SHARP_){
return (p1__34640_SHARP_ <= newi);
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34640#","p1__34640#",-517346419,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__34640#","p1__34640#",-517346419,null),new cljs.core.Symbol(null,"newi","newi",857919881,null))))], null)], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34639#","p1__34639#",1385071603,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__34639#","p1__34639#",1385071603,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34640#","p1__34640#",-517346419,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__34640#","p1__34640#",-517346419,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34639#","p1__34639#",1385071603,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__34639#","p1__34639#",1385071603,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34640#","p1__34640#",-517346419,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__34640#","p1__34640#",-517346419,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null));
com.rpl.specter.pathcache34673 = info34674;

return info34674;
})():info__33379__auto__);
var precompiled34675 = com.rpl.specter.impl.cached_path_info_precompiled(info__33379__auto____$1);
var dynamic_QMARK___33380__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33379__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33380__auto__)){
var G__34676 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,(function (p1__34639_SHARP_){
return (p1__34639_SHARP_ >= (curri + (1)));
}),(function (p1__34640_SHARP_){
return (p1__34640_SHARP_ <= newi);
})], null),com.rpl.specter.ALL,(function (p1__34639_SHARP_){
return (p1__34639_SHARP_ >= (curri + (1)));
}),(function (p1__34640_SHARP_){
return (p1__34640_SHARP_ <= newi);
})], null);
return (precompiled34675.cljs$core$IFn$_invoke$arity$1 ? precompiled34675.cljs$core$IFn$_invoke$arity$1(G__34676) : precompiled34675.call(null,G__34676));
} else {
return precompiled34675;
}
})(),cljs.core.dec,ii2);
} else {
return ii2;
}
}));

return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__33379__auto__ = com.rpl.specter.pathcache34677;
var info__33379__auto____$1 = (((info__33379__auto__ == null))?(function (){var info34678 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.index_nav,new cljs.core.Var(function(){return com.rpl.specter.index_nav;},new cljs.core.Symbol("com.rpl.specter","index-nav","com.rpl.specter/index-nav",2054501071,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),"com/rpl/specter.cljc",12,1,983,986,cljs.core.List.EMPTY,"Navigates to the index of the sequence if within 0 and size. Transforms move element\n          at that index to the new index, shifting other elements in the sequence.",(cljs.core.truth_(com.rpl.specter.index_nav)?com.rpl.specter.index_nav.cljs$lang$test:null)])),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache34677 = info34678;

return info34678;
})():info__33379__auto__);
var precompiled34679 = com.rpl.specter.impl.cached_path_info_precompiled(info__33379__auto____$1);
var dynamic_QMARK___33380__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33379__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33380__auto__)){
var G__34680 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.index_nav,curri], null);
return (precompiled34679.cljs$core$IFn$_invoke$arity$1 ? precompiled34679.cljs$core$IFn$_invoke$arity$1(G__34680) : precompiled34679.call(null,G__34680));
} else {
return precompiled34679;
}
})(),newi,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__33379__auto__ = com.rpl.specter.pathcache34681;
var info__33379__auto____$1 = (((info__33379__auto__ == null))?(function (){var info34682 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache34681 = info34682;

return info34682;
})():info__33379__auto__);
var precompiled34683 = com.rpl.specter.impl.cached_path_info_precompiled(info__33379__auto____$1);
var dynamic_QMARK___33380__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33379__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33380__auto__)){
var G__34684 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,curri], null);
return (precompiled34683.cljs$core$IFn$_invoke$arity$1 ? precompiled34683.cljs$core$IFn$_invoke$arity$1(G__34684) : precompiled34683.call(null,G__34684));
} else {
return precompiled34683;
}
})(),newe,s));
}),structure,structure);
}));

(com.rpl.specter.t_com$rpl$specter34667.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"meta34668","meta34668",1749701963,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34667.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34667.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34667");

(com.rpl.specter.t_com$rpl$specter34667.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34667");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34667.
 */
com.rpl.specter.__GT_t_com$rpl$specter34667 = (function com$rpl$specter$__GT_t_com$rpl$specter34667(start__$1,meta34668){
return (new com.rpl.specter.t_com$rpl$specter34667(start__$1,meta34668));
});

}

return (new com.rpl.specter.t_com$rpl$specter34667(start,null));
}));
/**
 * `indexed-vals` with a starting index of 0.
 */
com.rpl.specter.INDEXED_VALS = (com.rpl.specter.indexed_vals.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.indexed_vals.cljs$core$IFn$_invoke$arity$1((0)) : com.rpl.specter.indexed_vals.call(null,(0)));
/**
 * Navigates to result of running `afn` on the currently navigated value.
 */
com.rpl.specter.view = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34685 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34685 = (function (afn,meta34686){
this.afn = afn;
this.meta34686 = meta34686;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34685.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34687,meta34686__$1){
var self__ = this;
var _34687__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34685(self__.afn,meta34686__$1));
}));

(com.rpl.specter.t_com$rpl$specter34685.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34687){
var self__ = this;
var _34687__$1 = this;
return self__.meta34686;
}));

(com.rpl.specter.t_com$rpl$specter34685.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34685.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__34688 = vals;
var G__34689 = (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(structure) : self__.afn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__34688,G__34689) : next_fn.call(null,G__34688,G__34689));
}));

(com.rpl.specter.t_com$rpl$specter34685.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__34690 = vals;
var G__34691 = (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(structure) : self__.afn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__34690,G__34691) : next_fn.call(null,G__34690,G__34691));
}));

(com.rpl.specter.t_com$rpl$specter34685.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta34686","meta34686",-1577406186,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34685.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34685.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34685");

(com.rpl.specter.t_com$rpl$specter34685.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34685");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34685.
 */
com.rpl.specter.__GT_t_com$rpl$specter34685 = (function com$rpl$specter$__GT_t_com$rpl$specter34685(afn__$1,meta34686){
return (new com.rpl.specter.t_com$rpl$specter34685(afn__$1,meta34686));
});

}

return (new com.rpl.specter.t_com$rpl$specter34685(afn,null));
}));


com.rpl.specter.parser_select_STAR_ = (function com$rpl$specter$parser_select_STAR_(parse_fn,unparse_fn,structure,next_fn){
var G__34692 = (parse_fn.cljs$core$IFn$_invoke$arity$1 ? parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : parse_fn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34692) : next_fn.call(null,G__34692));
});

com.rpl.specter.parser_transform_STAR_ = (function com$rpl$specter$parser_transform_STAR_(parse_fn,unparse_fn,structure,next_fn){
var G__34693 = (function (){var G__34694 = (parse_fn.cljs$core$IFn$_invoke$arity$1 ? parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : parse_fn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34694) : next_fn.call(null,G__34694));
})();
return (unparse_fn.cljs$core$IFn$_invoke$arity$1 ? unparse_fn.cljs$core$IFn$_invoke$arity$1(G__34693) : unparse_fn.call(null,G__34693));
});

/**
 * Navigate to the result of running `parse-fn` on the value. For
 *        transforms, the transformed value then has `unparse-fn` run on
 *        it to get the final value at this point.
 */
com.rpl.specter.parser = com.rpl.specter.impl.direct_nav_obj((function (parse_fn,unparse_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34695 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34695 = (function (parse_fn,unparse_fn,meta34696){
this.parse_fn = parse_fn;
this.unparse_fn = unparse_fn;
this.meta34696 = meta34696;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34695.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34697,meta34696__$1){
var self__ = this;
var _34697__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34695(self__.parse_fn,self__.unparse_fn,meta34696__$1));
}));

(com.rpl.specter.t_com$rpl$specter34695.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34697){
var self__ = this;
var _34697__$1 = this;
return self__.meta34696;
}));

(com.rpl.specter.t_com$rpl$specter34695.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34695.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn((self__.parse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.parse_fn.call(null,structure)));
}));

(com.rpl.specter.t_com$rpl$specter34695.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var G__34698 = next_fn((self__.parse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.parse_fn.call(null,structure)));
return (self__.unparse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.unparse_fn.cljs$core$IFn$_invoke$arity$1(G__34698) : self__.unparse_fn.call(null,G__34698));
}));

(com.rpl.specter.t_com$rpl$specter34695.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parse-fn","parse-fn",-836029424,null),new cljs.core.Symbol(null,"unparse-fn","unparse-fn",407187734,null),new cljs.core.Symbol(null,"meta34696","meta34696",1298886682,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34695.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34695.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34695");

(com.rpl.specter.t_com$rpl$specter34695.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34695");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34695.
 */
com.rpl.specter.__GT_t_com$rpl$specter34695 = (function com$rpl$specter$__GT_t_com$rpl$specter34695(parse_fn__$1,unparse_fn__$1,meta34696){
return (new com.rpl.specter.t_com$rpl$specter34695(parse_fn__$1,unparse_fn__$1,meta34696));
});

}

return (new com.rpl.specter.t_com$rpl$specter34695(parse_fn,unparse_fn,null));
}));


com.rpl.specter.ATOM_select_STAR_ = (function com$rpl$specter$ATOM_select_STAR_(structure,next_fn){
var G__34703 = cljs.core.deref(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34703) : next_fn.call(null,G__34703));
});

com.rpl.specter.ATOM_transform_STAR_ = (function com$rpl$specter$ATOM_transform_STAR_(structure,next_fn){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(structure,next_fn);

return structure;
});

/**
 * Navigates to atom value.
 */
com.rpl.specter.ATOM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34704 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34704 = (function (meta34705){
this.meta34705 = meta34705;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34704.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34706,meta34705__$1){
var self__ = this;
var _34706__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34704(meta34705__$1));
}));

(com.rpl.specter.t_com$rpl$specter34704.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34706){
var self__ = this;
var _34706__$1 = this;
return self__.meta34705;
}));

(com.rpl.specter.t_com$rpl$specter34704.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34704.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(cljs.core.deref(structure));
}));

(com.rpl.specter.t_com$rpl$specter34704.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(structure,next_fn);

return structure;
}));

(com.rpl.specter.t_com$rpl$specter34704.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34705","meta34705",612420561,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34704.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34704.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34704");

(com.rpl.specter.t_com$rpl$specter34704.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34704");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34704.
 */
com.rpl.specter.__GT_t_com$rpl$specter34704 = (function com$rpl$specter$__GT_t_com$rpl$specter34704(meta34705){
return (new com.rpl.specter.t_com$rpl$specter34704(meta34705));
});

}

return (new com.rpl.specter.t_com$rpl$specter34704(null));
})()
;


com.rpl.specter.regex_nav_select_STAR_ = (function com$rpl$specter$regex_nav_select_STAR_(re,structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__30370__auto__,s){
var ret__30371__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(s) : next_fn.call(null,s));
if((ret__30371__auto__ === com.rpl.specter.NONE)){
return curr__30370__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__30371__auto__)){
return cljs.core.reduced(ret__30371__auto__);
} else {
return ret__30371__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.re_seq(re,structure));
});

com.rpl.specter.regex_nav_transform_STAR_ = (function com$rpl$specter$regex_nav_transform_STAR_(re,structure,next_fn){
return clojure.string.replace(structure,re,next_fn);
});

com.rpl.specter.regex_nav = com.rpl.specter.impl.direct_nav_obj((function (re){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34707 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34707 = (function (re,meta34708){
this.re = re;
this.meta34708 = meta34708;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34707.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34709,meta34708__$1){
var self__ = this;
var _34709__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34707(self__.re,meta34708__$1));
}));

(com.rpl.specter.t_com$rpl$specter34707.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34709){
var self__ = this;
var _34709__$1 = this;
return self__.meta34708;
}));

(com.rpl.specter.t_com$rpl$specter34707.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34707.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__30370__auto__,s){
var ret__30371__auto__ = next_fn(s);
if((ret__30371__auto__ === com.rpl.specter.NONE)){
return curr__30370__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__30371__auto__)){
return cljs.core.reduced(ret__30371__auto__);
} else {
return ret__30371__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.re_seq(self__.re,structure));
}));

(com.rpl.specter.t_com$rpl$specter34707.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return clojure.string.replace(structure,self__.re,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34707.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"re","re",1869207729,null),new cljs.core.Symbol(null,"meta34708","meta34708",554724997,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34707.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34707.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34707");

(com.rpl.specter.t_com$rpl$specter34707.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34707");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34707.
 */
com.rpl.specter.__GT_t_com$rpl$specter34707 = (function com$rpl$specter$__GT_t_com$rpl$specter34707(re__$1,meta34708){
return (new com.rpl.specter.t_com$rpl$specter34707(re__$1,meta34708));
});

}

return (new com.rpl.specter.t_com$rpl$specter34707(re,null));
}));
/**
 * Filters the current value based on whether a path finds anything.
 *   e.g. (selected? :vals ALL even?) keeps the current element only if an
 *   even number exists for the :vals key.
 */
com.rpl.specter.selected_QMARK_ = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34947__delegate = function (path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(path);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
return afn;
} else {
var builder__33371__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34712 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34712 = (function (path,temp__5733__auto__,late,meta34713){
this.path = path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late = late;
this.meta34713 = meta34713;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34712.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34714,meta34713__$1){
var self__ = this;
var _34714__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34712(self__.path,self__.temp__5733__auto__,self__.late,meta34713__$1));
}));

(com.rpl.specter.t_com$rpl$specter34712.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34714){
var self__ = this;
var _34714__$1 = this;
return self__.meta34713;
}));

(com.rpl.specter.t_com$rpl$specter34712.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34712.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select((function (p1__34710_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late,vals,p1__34710_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34712.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform((function (p1__34711_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late,vals,p1__34711_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34712.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta34713","meta34713",-159488635,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34712.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34712.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34712");

(com.rpl.specter.t_com$rpl$specter34712.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34712");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34712.
 */
com.rpl.specter.__GT_t_com$rpl$specter34712 = (function com$rpl$specter$__GT_t_com$rpl$specter34712(path__$1,temp__5733__auto____$1,late__$1,meta34713){
return (new com.rpl.specter.t_com$rpl$specter34712(path__$1,temp__5733__auto____$1,late__$1,meta34713));
});

}

return (new com.rpl.specter.t_com$rpl$specter34712(path,temp__5733__auto__,late,null));
}));
var curr_params__33372__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33372__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33371__auto__,curr_params__33372__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33371__auto__,curr_params__33372__auto__,null);
}
}
};
var G__34947 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34951__i = 0, G__34951__a = new Array(arguments.length -  0);
while (G__34951__i < G__34951__a.length) {G__34951__a[G__34951__i] = arguments[G__34951__i + 0]; ++G__34951__i;}
  path = new cljs.core.IndexedSeq(G__34951__a,0,null);
} 
return G__34947__delegate.call(this,path);};
G__34947.cljs$lang$maxFixedArity = 0;
G__34947.cljs$lang$applyTo = (function (arglist__34952){
var path = cljs.core.seq(arglist__34952);
return G__34947__delegate(path);
});
G__34947.cljs$core$IFn$_invoke$arity$variadic = G__34947__delegate;
return G__34947;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.not_selected_QMARK_ = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34953__delegate = function (path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(path);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
return (function (s){
return cljs.core.not((afn.cljs$core$IFn$_invoke$arity$1 ? afn.cljs$core$IFn$_invoke$arity$1(s) : afn.call(null,s)));
});
} else {
var builder__33371__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34719 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34719 = (function (path,temp__5733__auto__,late,meta34720){
this.path = path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late = late;
this.meta34720 = meta34720;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34719.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34721,meta34720__$1){
var self__ = this;
var _34721__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34719(self__.path,self__.temp__5733__auto__,self__.late,meta34720__$1));
}));

(com.rpl.specter.t_com$rpl$specter34719.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34721){
var self__ = this;
var _34721__$1 = this;
return self__.meta34720;
}));

(com.rpl.specter.t_com$rpl$specter34719.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34719.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select((function (p1__34717_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_(self__.late,vals,p1__34717_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34719.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform((function (p1__34718_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_(self__.late,vals,p1__34718_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34719.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta34720","meta34720",2014881108,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34719.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34719.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34719");

(com.rpl.specter.t_com$rpl$specter34719.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34719");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34719.
 */
com.rpl.specter.__GT_t_com$rpl$specter34719 = (function com$rpl$specter$__GT_t_com$rpl$specter34719(path__$1,temp__5733__auto____$1,late__$1,meta34720){
return (new com.rpl.specter.t_com$rpl$specter34719(path__$1,temp__5733__auto____$1,late__$1,meta34720));
});

}

return (new com.rpl.specter.t_com$rpl$specter34719(path,temp__5733__auto__,late,null));
}));
var curr_params__33372__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33372__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33371__auto__,curr_params__33372__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33371__auto__,curr_params__33372__auto__,null);
}
}
};
var G__34953 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34954__i = 0, G__34954__a = new Array(arguments.length -  0);
while (G__34954__i < G__34954__a.length) {G__34954__a[G__34954__i] = arguments[G__34954__i + 0]; ++G__34954__i;}
  path = new cljs.core.IndexedSeq(G__34954__a,0,null);
} 
return G__34953__delegate.call(this,path);};
G__34953.cljs$lang$maxFixedArity = 0;
G__34953.cljs$lang$applyTo = (function (arglist__34955){
var path = cljs.core.seq(arglist__34955);
return G__34953__delegate(path);
});
G__34953.cljs$core$IFn$_invoke$arity$variadic = G__34953__delegate;
return G__34953;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current sequence that only contains elements that
 *   match the given path. An element matches the selector path if calling select
 *   on that element with the path yields anything other than an empty sequence.
 * 
 *   For transformation: `NONE` entries in the result sequence cause corresponding entries in
 *   input to be removed. A result sequence smaller than the input sequence is equivalent to
 *   padding the result sequence with `NONE` at the end until the same size as the input.
 */
com.rpl.specter.filterer = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34956__delegate = function (path){
var G__34723 = com.rpl.specter.ALL;
var G__34724 = (com.rpl.specter.selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.selected_QMARK_.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.selected_QMARK_.call(null,path));
return (com.rpl.specter.subselect.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.subselect.cljs$core$IFn$_invoke$arity$2(G__34723,G__34724) : com.rpl.specter.subselect.call(null,G__34723,G__34724));
};
var G__34956 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34957__i = 0, G__34957__a = new Array(arguments.length -  0);
while (G__34957__i < G__34957__a.length) {G__34957__a[G__34957__i] = arguments[G__34957__i + 0]; ++G__34957__i;}
  path = new cljs.core.IndexedSeq(G__34957__a,0,null);
} 
return G__34956__delegate.call(this,path);};
G__34956.cljs$lang$maxFixedArity = 0;
G__34956.cljs$lang$applyTo = (function (arglist__34958){
var path = cljs.core.seq(arglist__34958);
return G__34956__delegate(path);
});
G__34956.cljs$core$IFn$_invoke$arity$variadic = G__34956__delegate;
return G__34956;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming it with the
 * specified path and update-fn.
 */
com.rpl.specter.transformed = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (path,update_fn){
var builder__33371__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late,late_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34725 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34725 = (function (path,update_fn,late,late_fn,meta34726){
this.path = path;
this.update_fn = update_fn;
this.late = late;
this.late_fn = late_fn;
this.meta34726 = meta34726;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34725.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34727,meta34726__$1){
var self__ = this;
var _34727__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34725(self__.path,self__.update_fn,self__.late,self__.late_fn,meta34726__$1));
}));

(com.rpl.specter.t_com$rpl$specter34725.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34727){
var self__ = this;
var _34727__$1 = this;
return self__.meta34726;
}));

(com.rpl.specter.t_com$rpl$specter34725.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34725.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn((com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(self__.late,self__.late_fn,structure) : com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure)));
}));

(com.rpl.specter.t_com$rpl$specter34725.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn((com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(self__.late,self__.late_fn,structure) : com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure)));
}));

(com.rpl.specter.t_com$rpl$specter34725.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"update-fn","update-fn",-1943348456,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta34726","meta34726",1267955562,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34725.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34725.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34725");

(com.rpl.specter.t_com$rpl$specter34725.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34725");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34725.
 */
com.rpl.specter.__GT_t_com$rpl$specter34725 = (function com$rpl$specter$__GT_t_com$rpl$specter34725(path__$1,update_fn__$1,late__$1,late_fn__$1,meta34726){
return (new com.rpl.specter.t_com$rpl$specter34725(path__$1,update_fn__$1,late__$1,late_fn__$1,meta34726));
});

}

return (new com.rpl.specter.t_com$rpl$specter34725(path,update_fn,late,late_fn,null));
}));
var curr_params__33372__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path)),update_fn], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33372__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33371__auto__,curr_params__33372__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33371__auto__,curr_params__33372__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming with a reduction over
 * the specified traversal.
 */
com.rpl.specter.traversed = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (path,reduce_fn){
var builder__33371__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late,late_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34728 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34728 = (function (path,reduce_fn,late,late_fn,meta34729){
this.path = path;
this.reduce_fn = reduce_fn;
this.late = late;
this.late_fn = late_fn;
this.meta34729 = meta34729;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34728.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34730,meta34729__$1){
var self__ = this;
var _34730__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34728(self__.path,self__.reduce_fn,self__.late,self__.late_fn,meta34729__$1));
}));

(com.rpl.specter.t_com$rpl$specter34728.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34730){
var self__ = this;
var _34730__$1 = this;
return self__.meta34729;
}));

(com.rpl.specter.t_com$rpl$specter34728.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34728.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(self__.late_fn,(com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_traverse.call(null,self__.late,structure))));
}));

(com.rpl.specter.t_com$rpl$specter34728.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(self__.late_fn,(com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_traverse.call(null,self__.late,structure))));
}));

(com.rpl.specter.t_com$rpl$specter34728.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"reduce-fn","reduce-fn",-1484020844,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta34729","meta34729",2084087100,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34728.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34728.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34728");

(com.rpl.specter.t_com$rpl$specter34728.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34728");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34728.
 */
com.rpl.specter.__GT_t_com$rpl$specter34728 = (function com$rpl$specter$__GT_t_com$rpl$specter34728(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta34729){
return (new com.rpl.specter.t_com$rpl$specter34728(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta34729));
});

}

return (new com.rpl.specter.t_com$rpl$specter34728(path,reduce_fn,late,late_fn,null));
}));
var curr_params__33372__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path)),reduce_fn], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33372__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33371__auto__,curr_params__33372__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33371__auto__,curr_params__33372__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Keeps the element only if it matches the supplied predicate. Functions in paths
 *        implicitly convert to this navigator.
 */
com.rpl.specter.pred = com.rpl.specter.impl.pred_STAR_;
com.rpl.specter.pred_EQ_ = (function com$rpl$specter$pred_EQ_(v){
var G__34740 = (function (p1__34731_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__34731_SHARP_,v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__34740) : com.rpl.specter.pred.call(null,G__34740));
});
com.rpl.specter.pred_LT_ = (function com$rpl$specter$pred_LT_(v){
var G__34742 = (function (p1__34741_SHARP_){
return (p1__34741_SHARP_ < v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__34742) : com.rpl.specter.pred.call(null,G__34742));
});
com.rpl.specter.pred_GT_ = (function com$rpl$specter$pred_GT_(v){
var G__34744 = (function (p1__34743_SHARP_){
return (p1__34743_SHARP_ > v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__34744) : com.rpl.specter.pred.call(null,G__34744));
});
com.rpl.specter.pred_LT__EQ_ = (function com$rpl$specter$pred_LT__EQ_(v){
var G__34746 = (function (p1__34745_SHARP_){
return (p1__34745_SHARP_ <= v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__34746) : com.rpl.specter.pred.call(null,G__34746));
});
com.rpl.specter.pred_GT__EQ_ = (function com$rpl$specter$pred_GT__EQ_(v){
var G__34748 = (function (p1__34747_SHARP_){
return (p1__34747_SHARP_ >= v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__34748) : com.rpl.specter.pred.call(null,G__34748));
});
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"null",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"null",(function (this$){
return com.rpl.specter.STAY;
}));
(cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
(cljs.core.Symbol.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Symbol.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"string",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"string",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"number",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"number",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
(cljs.core.char$.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.char$.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"boolean",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"boolean",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"function",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"function",(function (this$){
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.pred.call(null,this$));
}));
(cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.pred.call(null,this$__$1));
}));
(RegExp.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(RegExp.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.regex_nav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.regex_nav.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.regex_nav.call(null,this$__$1));
}));


com.rpl.specter.nil__GT_val_select_STAR_ = (function com$rpl$specter$nil__GT_val_select_STAR_(v,structure,next_fn){
var G__34765 = (((structure == null))?v:structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34765) : next_fn.call(null,G__34765));
});

com.rpl.specter.nil__GT_val_transform_STAR_ = (function com$rpl$specter$nil__GT_val_transform_STAR_(v,structure,next_fn){
var G__34766 = (((structure == null))?v:structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34766) : next_fn.call(null,G__34766));
});

/**
 * Navigates to the provided val if the structure is nil. Otherwise it stays
 *        navigated at the structure.
 */
com.rpl.specter.nil__GT_val = com.rpl.specter.impl.direct_nav_obj((function (v){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34767 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34767 = (function (v,meta34768){
this.v = v;
this.meta34768 = meta34768;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34767.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34769,meta34768__$1){
var self__ = this;
var _34769__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34767(self__.v,meta34768__$1));
}));

(com.rpl.specter.t_com$rpl$specter34767.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34769){
var self__ = this;
var _34769__$1 = this;
return self__.meta34768;
}));

(com.rpl.specter.t_com$rpl$specter34767.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34767.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn((((structure == null))?self__.v:structure));
}));

(com.rpl.specter.t_com$rpl$specter34767.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn((((structure == null))?self__.v:structure));
}));

(com.rpl.specter.t_com$rpl$specter34767.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"meta34768","meta34768",-494859411,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34767.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34767.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34767");

(com.rpl.specter.t_com$rpl$specter34767.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34767");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34767.
 */
com.rpl.specter.__GT_t_com$rpl$specter34767 = (function com$rpl$specter$__GT_t_com$rpl$specter34767(v__$1,meta34768){
return (new com.rpl.specter.t_com$rpl$specter34767(v__$1,meta34768));
});

}

return (new com.rpl.specter.t_com$rpl$specter34767(v,null));
}));
/**
 * Navigates to #{} if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_SET = (function (){var G__34770 = cljs.core.PersistentHashSet.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__34770) : com.rpl.specter.nil__GT_val.call(null,G__34770));
})();
/**
 * Navigates to '() if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_LIST = (function (){var G__34771 = cljs.core.List.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__34771) : com.rpl.specter.nil__GT_val.call(null,G__34771));
})();
/**
 * Navigates to [] if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_VECTOR = (function (){var G__34772 = cljs.core.PersistentVector.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__34772) : com.rpl.specter.nil__GT_val.call(null,G__34772));
})();


com.rpl.specter.META_select_STAR_ = (function com$rpl$specter$META_select_STAR_(structure,next_fn){
var G__34780 = cljs.core.meta(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34780) : next_fn.call(null,G__34780));
});

com.rpl.specter.META_transform_STAR_ = (function com$rpl$specter$META_transform_STAR_(structure,next_fn){
return cljs.core.with_meta(structure,(function (){var G__34781 = cljs.core.meta(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34781) : next_fn.call(null,G__34781));
})());
});

/**
 * Navigates to the metadata of the structure, or nil if
 *   the structure has no metadata or may not contain metadata.
 */
com.rpl.specter.META = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34782 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34782 = (function (meta34783){
this.meta34783 = meta34783;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34782.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34784,meta34783__$1){
var self__ = this;
var _34784__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34782(meta34783__$1));
}));

(com.rpl.specter.t_com$rpl$specter34782.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34784){
var self__ = this;
var _34784__$1 = this;
return self__.meta34783;
}));

(com.rpl.specter.t_com$rpl$specter34782.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34782.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(cljs.core.meta(structure));
}));

(com.rpl.specter.t_com$rpl$specter34782.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return cljs.core.with_meta(structure,next_fn(cljs.core.meta(structure)));
}));

(com.rpl.specter.t_com$rpl$specter34782.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34783","meta34783",-286839928,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34782.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34782.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34782");

(com.rpl.specter.t_com$rpl$specter34782.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34782");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34782.
 */
com.rpl.specter.__GT_t_com$rpl$specter34782 = (function com$rpl$specter$__GT_t_com$rpl$specter34782(meta34783){
return (new com.rpl.specter.t_com$rpl$specter34782(meta34783));
});

}

return (new com.rpl.specter.t_com$rpl$specter34782(null));
})()
;


com.rpl.specter.NAME_select_STAR_ = (function com$rpl$specter$NAME_select_STAR_(structure,next_fn){
var G__34806 = cljs.core.name(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34806) : next_fn.call(null,G__34806));
});

com.rpl.specter.NAME_transform_STAR_ = (function com$rpl$specter$NAME_transform_STAR_(structure,next_fn){
var new_name = (function (){var G__34807 = cljs.core.name(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34807) : next_fn.call(null,G__34807));
})();
var ns = cljs.core.namespace(structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAME can only be used on symbols or keywords - ",structure], 0));

}
}
});

/**
 * Navigates to the name portion of the keyword or symbol
 */
com.rpl.specter.NAME = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34808 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34808 = (function (meta34809){
this.meta34809 = meta34809;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34808.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34810,meta34809__$1){
var self__ = this;
var _34810__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34808(meta34809__$1));
}));

(com.rpl.specter.t_com$rpl$specter34808.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34810){
var self__ = this;
var _34810__$1 = this;
return self__.meta34809;
}));

(com.rpl.specter.t_com$rpl$specter34808.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34808.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(cljs.core.name(structure));
}));

(com.rpl.specter.t_com$rpl$specter34808.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var new_name = next_fn(cljs.core.name(structure));
var ns = cljs.core.namespace(structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAME can only be used on symbols or keywords - ",structure], 0));

}
}
}));

(com.rpl.specter.t_com$rpl$specter34808.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34809","meta34809",-1607207002,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34808.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34808.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34808");

(com.rpl.specter.t_com$rpl$specter34808.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34808");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34808.
 */
com.rpl.specter.__GT_t_com$rpl$specter34808 = (function com$rpl$specter$__GT_t_com$rpl$specter34808(meta34809){
return (new com.rpl.specter.t_com$rpl$specter34808(meta34809));
});

}

return (new com.rpl.specter.t_com$rpl$specter34808(null));
})()
;


com.rpl.specter.NAMESPACE_select_STAR_ = (function com$rpl$specter$NAMESPACE_select_STAR_(structure,next_fn){
var G__34815 = cljs.core.namespace(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34815) : next_fn.call(null,G__34815));
});

com.rpl.specter.NAMESPACE_transform_STAR_ = (function com$rpl$specter$NAMESPACE_transform_STAR_(structure,next_fn){
var name = cljs.core.name(structure);
var new_ns = (function (){var G__34816 = cljs.core.namespace(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34816) : next_fn.call(null,G__34816));
})();
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAMESPACE can only be used on symbols or keywords - ",structure], 0));

}
}
});

/**
 * Navigates to the namespace portion of the keyword or symbol
 */
com.rpl.specter.NAMESPACE = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34817 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34817 = (function (meta34818){
this.meta34818 = meta34818;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34817.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34819,meta34818__$1){
var self__ = this;
var _34819__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34817(meta34818__$1));
}));

(com.rpl.specter.t_com$rpl$specter34817.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34819){
var self__ = this;
var _34819__$1 = this;
return self__.meta34818;
}));

(com.rpl.specter.t_com$rpl$specter34817.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34817.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(cljs.core.namespace(structure));
}));

(com.rpl.specter.t_com$rpl$specter34817.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var name = cljs.core.name(structure);
var new_ns = next_fn(cljs.core.namespace(structure));
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAMESPACE can only be used on symbols or keywords - ",structure], 0));

}
}
}));

(com.rpl.specter.t_com$rpl$specter34817.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34818","meta34818",1353294172,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34817.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34817.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34817");

(com.rpl.specter.t_com$rpl$specter34817.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34817");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34817.
 */
com.rpl.specter.__GT_t_com$rpl$specter34817 = (function com$rpl$specter$__GT_t_com$rpl$specter34817(meta34818){
return (new com.rpl.specter.t_com$rpl$specter34817(meta34818));
});

}

return (new com.rpl.specter.t_com$rpl$specter34817(null));
})()
;
/**
 * Adds the result of running select with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34975__delegate = function (path){
var builder__33371__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34820 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34820 = (function (path,late,meta34821){
this.path = path;
this.late = late;
this.meta34821 = meta34821;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34820.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34822,meta34821__$1){
var self__ = this;
var _34822__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34820(self__.path,self__.late,meta34821__$1));
}));

(com.rpl.specter.t_com$rpl$specter34820.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34822){
var self__ = this;
var _34822__$1 = this;
return self__.meta34821;
}));

(com.rpl.specter.t_com$rpl$specter34820.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34820.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__33368__auto__,vals__33369__auto__,structure,next_fn__33370__auto__){
var self__ = this;
var this__33368__auto____$1 = this;
var G__34828 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33369__auto__,(com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
var G__34829 = structure;
return (next_fn__33370__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33370__auto__.cljs$core$IFn$_invoke$arity$2(G__34828,G__34829) : next_fn__33370__auto__.call(null,G__34828,G__34829));
}));

(com.rpl.specter.t_com$rpl$specter34820.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__33368__auto__,vals__33369__auto__,structure,next_fn__33370__auto__){
var self__ = this;
var this__33368__auto____$1 = this;
var G__34833 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33369__auto__,(com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
var G__34834 = structure;
return (next_fn__33370__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33370__auto__.cljs$core$IFn$_invoke$arity$2(G__34833,G__34834) : next_fn__33370__auto__.call(null,G__34833,G__34834));
}));

(com.rpl.specter.t_com$rpl$specter34820.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta34821","meta34821",-1594847841,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34820.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34820.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34820");

(com.rpl.specter.t_com$rpl$specter34820.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34820");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34820.
 */
com.rpl.specter.__GT_t_com$rpl$specter34820 = (function com$rpl$specter$__GT_t_com$rpl$specter34820(path__$1,late__$1,meta34821){
return (new com.rpl.specter.t_com$rpl$specter34820(path__$1,late__$1,meta34821));
});

}

return (new com.rpl.specter.t_com$rpl$specter34820(path,late,null));
}));
var curr_params__33372__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33372__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33371__auto__,curr_params__33372__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33371__auto__,curr_params__33372__auto__,null);
}
};
var G__34975 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34976__i = 0, G__34976__a = new Array(arguments.length -  0);
while (G__34976__i < G__34976__a.length) {G__34976__a[G__34976__i] = arguments[G__34976__i + 0]; ++G__34976__i;}
  path = new cljs.core.IndexedSeq(G__34976__a,0,null);
} 
return G__34975__delegate.call(this,path);};
G__34975.cljs$lang$maxFixedArity = 0;
G__34975.cljs$lang$applyTo = (function (arglist__34977){
var path = cljs.core.seq(arglist__34977);
return G__34975__delegate(path);
});
G__34975.cljs$core$IFn$_invoke$arity$variadic = G__34975__delegate;
return G__34975;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds the result of running select-one with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect_one = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34978__delegate = function (path){
var builder__33371__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34835 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34835 = (function (path,late,meta34836){
this.path = path;
this.late = late;
this.meta34836 = meta34836;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34835.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34837,meta34836__$1){
var self__ = this;
var _34837__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34835(self__.path,self__.late,meta34836__$1));
}));

(com.rpl.specter.t_com$rpl$specter34835.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34837){
var self__ = this;
var _34837__$1 = this;
return self__.meta34836;
}));

(com.rpl.specter.t_com$rpl$specter34835.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34835.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__33368__auto__,vals__33369__auto__,structure,next_fn__33370__auto__){
var self__ = this;
var this__33368__auto____$1 = this;
var G__34838 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33369__auto__,(com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select_one.call(null,self__.late,structure)));
var G__34839 = structure;
return (next_fn__33370__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33370__auto__.cljs$core$IFn$_invoke$arity$2(G__34838,G__34839) : next_fn__33370__auto__.call(null,G__34838,G__34839));
}));

(com.rpl.specter.t_com$rpl$specter34835.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__33368__auto__,vals__33369__auto__,structure,next_fn__33370__auto__){
var self__ = this;
var this__33368__auto____$1 = this;
var G__34840 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33369__auto__,(com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select_one.call(null,self__.late,structure)));
var G__34841 = structure;
return (next_fn__33370__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33370__auto__.cljs$core$IFn$_invoke$arity$2(G__34840,G__34841) : next_fn__33370__auto__.call(null,G__34840,G__34841));
}));

(com.rpl.specter.t_com$rpl$specter34835.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta34836","meta34836",-820760856,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34835.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34835.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34835");

(com.rpl.specter.t_com$rpl$specter34835.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34835");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34835.
 */
com.rpl.specter.__GT_t_com$rpl$specter34835 = (function com$rpl$specter$__GT_t_com$rpl$specter34835(path__$1,late__$1,meta34836){
return (new com.rpl.specter.t_com$rpl$specter34835(path__$1,late__$1,meta34836));
});

}

return (new com.rpl.specter.t_com$rpl$specter34835(path,late,null));
}));
var curr_params__33372__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33372__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33371__auto__,curr_params__33372__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33371__auto__,curr_params__33372__auto__,null);
}
};
var G__34978 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34991__i = 0, G__34991__a = new Array(arguments.length -  0);
while (G__34991__i < G__34991__a.length) {G__34991__a[G__34991__i] = arguments[G__34991__i + 0]; ++G__34991__i;}
  path = new cljs.core.IndexedSeq(G__34991__a,0,null);
} 
return G__34978__delegate.call(this,path);};
G__34978.cljs$lang$maxFixedArity = 0;
G__34978.cljs$lang$applyTo = (function (arglist__34992){
var path = cljs.core.seq(arglist__34992);
return G__34978__delegate(path);
});
G__34978.cljs$core$IFn$_invoke$arity$variadic = G__34978__delegate;
return G__34978;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds an external value to the collected vals. Useful when additional arguments
 *   are required to the transform function that would otherwise require partial
 *   application or a wrapper function.
 * 
 *   e.g., incrementing val at path [:a :b] by 3:
 *   (transform [:a :b (putval 3)] + some-map)
 */
com.rpl.specter.putval = com.rpl.specter.impl.direct_nav_obj((function (val){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34843 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34843 = (function (val,meta34844){
this.val = val;
this.meta34844 = meta34844;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34843.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34845,meta34844__$1){
var self__ = this;
var _34845__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34843(self__.val,meta34844__$1));
}));

(com.rpl.specter.t_com$rpl$specter34843.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34845){
var self__ = this;
var _34845__$1 = this;
return self__.meta34844;
}));

(com.rpl.specter.t_com$rpl$specter34843.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34843.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__33368__auto__,vals__33369__auto__,structure,next_fn__33370__auto__){
var self__ = this;
var this__33368__auto____$1 = this;
var G__34846 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33369__auto__,self__.val);
var G__34847 = structure;
return (next_fn__33370__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33370__auto__.cljs$core$IFn$_invoke$arity$2(G__34846,G__34847) : next_fn__33370__auto__.call(null,G__34846,G__34847));
}));

(com.rpl.specter.t_com$rpl$specter34843.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__33368__auto__,vals__33369__auto__,structure,next_fn__33370__auto__){
var self__ = this;
var this__33368__auto____$1 = this;
var G__34850 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33369__auto__,self__.val);
var G__34851 = structure;
return (next_fn__33370__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33370__auto__.cljs$core$IFn$_invoke$arity$2(G__34850,G__34851) : next_fn__33370__auto__.call(null,G__34850,G__34851));
}));

(com.rpl.specter.t_com$rpl$specter34843.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"meta34844","meta34844",-1191354669,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34843.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34843.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34843");

(com.rpl.specter.t_com$rpl$specter34843.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34843");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34843.
 */
com.rpl.specter.__GT_t_com$rpl$specter34843 = (function com$rpl$specter$__GT_t_com$rpl$specter34843(val__$1,meta34844){
return (new com.rpl.specter.t_com$rpl$specter34843(val__$1,meta34844));
});

}

return (new com.rpl.specter.t_com$rpl$specter34843(val,null));
}));
/**
 * Continues navigating on the given path with the collected vals reset to []. Once
 *   navigation leaves the scope of with-fresh-collected, the collected vals revert
 *   to what they were before.
 */
com.rpl.specter.with_fresh_collected = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34993__delegate = function (path){
var builder__33371__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34854 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34854 = (function (path,late,meta34855){
this.path = path;
this.late = late;
this.meta34855 = meta34855;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34854.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34856,meta34855__$1){
var self__ = this;
var _34856__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34854(self__.path,self__.late,meta34855__$1));
}));

(com.rpl.specter.t_com$rpl$specter34854.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34856){
var self__ = this;
var _34856__$1 = this;
return self__.meta34855;
}));

(com.rpl.specter.t_com$rpl$specter34854.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34854.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.select_STAR_(self__.late,cljs.core.PersistentVector.EMPTY,structure,(function (_,structure__$1){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,structure__$1) : next_fn.call(null,vals,structure__$1));
}));
}));

(com.rpl.specter.t_com$rpl$specter34854.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.transform_STAR_(self__.late,cljs.core.PersistentVector.EMPTY,structure,(function (_,structure__$1){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,structure__$1) : next_fn.call(null,vals,structure__$1));
}));
}));

(com.rpl.specter.t_com$rpl$specter34854.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta34855","meta34855",611642071,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34854.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34854.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34854");

(com.rpl.specter.t_com$rpl$specter34854.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34854");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34854.
 */
com.rpl.specter.__GT_t_com$rpl$specter34854 = (function com$rpl$specter$__GT_t_com$rpl$specter34854(path__$1,late__$1,meta34855){
return (new com.rpl.specter.t_com$rpl$specter34854(path__$1,late__$1,meta34855));
});

}

return (new com.rpl.specter.t_com$rpl$specter34854(path,late,null));
}));
var curr_params__33372__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33372__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33371__auto__,curr_params__33372__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33371__auto__,curr_params__33372__auto__,null);
}
};
var G__34993 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34994__i = 0, G__34994__a = new Array(arguments.length -  0);
while (G__34994__i < G__34994__a.length) {G__34994__a[G__34994__i] = arguments[G__34994__i + 0]; ++G__34994__i;}
  path = new cljs.core.IndexedSeq(G__34994__a,0,null);
} 
return G__34993__delegate.call(this,path);};
G__34993.cljs$lang$maxFixedArity = 0;
G__34993.cljs$lang$applyTo = (function (arglist__34995){
var path = cljs.core.seq(arglist__34995);
return G__34993__delegate(path);
});
G__34993.cljs$core$IFn$_invoke$arity$variadic = G__34993__delegate;
return G__34993;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Drops all collected values for subsequent navigation.
 */
com.rpl.specter.DISPENSE = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34864 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34864 = (function (meta34865){
this.meta34865 = meta34865;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34864.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34866,meta34865__$1){
var self__ = this;
var _34866__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34864(meta34865__$1));
}));

(com.rpl.specter.t_com$rpl$specter34864.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34866){
var self__ = this;
var _34866__$1 = this;
return self__.meta34865;
}));

(com.rpl.specter.t_com$rpl$specter34864.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34864.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__34870 = cljs.core.PersistentVector.EMPTY;
var G__34871 = structure;
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__34870,G__34871) : next_fn.call(null,G__34870,G__34871));
}));

(com.rpl.specter.t_com$rpl$specter34864.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__34872 = cljs.core.PersistentVector.EMPTY;
var G__34873 = structure;
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__34872,G__34873) : next_fn.call(null,G__34872,G__34873));
}));

(com.rpl.specter.t_com$rpl$specter34864.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34865","meta34865",1092759367,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34864.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34864.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34864");

(com.rpl.specter.t_com$rpl$specter34864.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34864");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34864.
 */
com.rpl.specter.__GT_t_com$rpl$specter34864 = (function com$rpl$specter$__GT_t_com$rpl$specter34864(meta34865){
return (new com.rpl.specter.t_com$rpl$specter34864(meta34865));
});

}

return (new com.rpl.specter.t_com$rpl$specter34864(null));
})()
;
/**
 * Like cond-path, but with if semantics.
 */
com.rpl.specter.if_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() {
var G__34996 = null;
var G__34996__2 = (function (cond_p,then_path){
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3(cond_p,then_path,com.rpl.specter.STOP) : com.rpl.specter.if_path.call(null,cond_p,then_path,com.rpl.specter.STOP));
});
var G__34996__3 = (function (cond_p,then_path,else_path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(cond_p);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
var builder__33371__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late_then,late_else){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34877 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34877 = (function (cond_p,then_path,else_path,temp__5733__auto__,afn,late_then,late_else,meta34878){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__5733__auto__ = temp__5733__auto__;
this.afn = afn;
this.late_then = late_then;
this.late_else = late_else;
this.meta34878 = meta34878;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34877.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34879,meta34878__$1){
var self__ = this;
var _34879__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34877(self__.cond_p,self__.then_path,self__.else_path,self__.temp__5733__auto__,self__.afn,self__.late_then,self__.late_else,meta34878__$1));
}));

(com.rpl.specter.t_com$rpl$specter34877.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34879){
var self__ = this;
var _34879__$1 = this;
return self__.meta34878;
}));

(com.rpl.specter.t_com$rpl$specter34877.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34877.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select(vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter34877.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform(vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter34877.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta34878","meta34878",-299324894,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34877.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34877.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34877");

(com.rpl.specter.t_com$rpl$specter34877.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34877");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34877.
 */
com.rpl.specter.__GT_t_com$rpl$specter34877 = (function com$rpl$specter$__GT_t_com$rpl$specter34877(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,afn__$1,late_then__$1,late_else__$1,meta34878){
return (new com.rpl.specter.t_com$rpl$specter34877(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,afn__$1,late_then__$1,late_else__$1,meta34878));
});

}

return (new com.rpl.specter.t_com$rpl$specter34877(cond_p,then_path,else_path,temp__5733__auto__,afn,late_then,late_else,null));
}));
var curr_params__33372__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(then_path) : com.rpl.specter.late_path.call(null,then_path)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(else_path) : com.rpl.specter.late_path.call(null,else_path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33372__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33371__auto__,curr_params__33372__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33371__auto__,curr_params__33372__auto__,null);
}
} else {
var builder__33371__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late_cond,late_then,late_else){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34880 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34880 = (function (cond_p,then_path,else_path,temp__5733__auto__,late_cond,late_then,late_else,meta34881){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late_cond = late_cond;
this.late_then = late_then;
this.late_else = late_else;
this.meta34881 = meta34881;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34880.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34882,meta34881__$1){
var self__ = this;
var _34882__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34880(self__.cond_p,self__.then_path,self__.else_path,self__.temp__5733__auto__,self__.late_cond,self__.late_then,self__.late_else,meta34881__$1));
}));

(com.rpl.specter.t_com$rpl$specter34880.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34882){
var self__ = this;
var _34882__$1 = this;
return self__.meta34881;
}));

(com.rpl.specter.t_com$rpl$specter34880.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34880.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select(vals,structure,next_fn,(function (p1__34875_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late_cond,vals,p1__34875_SHARP_);
}),self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter34880.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform(vals,structure,next_fn,(function (p1__34876_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late_cond,vals,p1__34876_SHARP_);
}),self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter34880.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late-cond","late-cond",1031862828,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta34881","meta34881",1279836361,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34880.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34880.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34880");

(com.rpl.specter.t_com$rpl$specter34880.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34880");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34880.
 */
com.rpl.specter.__GT_t_com$rpl$specter34880 = (function com$rpl$specter$__GT_t_com$rpl$specter34880(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta34881){
return (new com.rpl.specter.t_com$rpl$specter34880(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta34881));
});

}

return (new com.rpl.specter.t_com$rpl$specter34880(cond_p,then_path,else_path,temp__5733__auto__,late_cond,late_then,late_else,null));
}));
var curr_params__33372__auto__ = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(cond_p) : com.rpl.specter.late_path.call(null,cond_p)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(then_path) : com.rpl.specter.late_path.call(null,then_path)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(else_path) : com.rpl.specter.late_path.call(null,else_path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33372__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33371__auto__,curr_params__33372__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33371__auto__,curr_params__33372__auto__,null);
}
}
});
G__34996 = function(cond_p,then_path,else_path){
switch(arguments.length){
case 2:
return G__34996__2.call(this,cond_p,then_path);
case 3:
return G__34996__3.call(this,cond_p,then_path,else_path);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34996.cljs$core$IFn$_invoke$arity$2 = G__34996__2;
G__34996.cljs$core$IFn$_invoke$arity$3 = G__34996__3;
return G__34996;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Takes in alternating cond-path path cond-path path...
 * Tests the structure if selecting with cond-path returns anything.
 * If so, it uses the following path for this portion of the navigation.
 * Otherwise, it tries the next cond-path. If nothing matches, then the structure
 * is not selected.
 */
com.rpl.specter.cond_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__35005__delegate = function (conds){
var pairs = cljs.core.reverse(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),conds));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p,p__34883){
var vec__34884 = p__34883;
var tester = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34884,(0),null);
var apath = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34884,(1),null);
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3(tester,apath,p) : com.rpl.specter.if_path.call(null,tester,apath,p));
}),com.rpl.specter.STOP,pairs);
};
var G__35005 = function (var_args){
var conds = null;
if (arguments.length > 0) {
var G__35006__i = 0, G__35006__a = new Array(arguments.length -  0);
while (G__35006__i < G__35006__a.length) {G__35006__a[G__35006__i] = arguments[G__35006__i + 0]; ++G__35006__i;}
  conds = new cljs.core.IndexedSeq(G__35006__a,0,null);
} 
return G__35005__delegate.call(this,conds);};
G__35005.cljs$lang$maxFixedArity = 0;
G__35005.cljs$lang$applyTo = (function (arglist__35007){
var conds = cljs.core.seq(arglist__35007);
return G__35005__delegate(conds);
});
G__35005.cljs$core$IFn$_invoke$arity$variadic = G__35005__delegate;
return G__35005;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * A path that branches on multiple paths. For updates,
 * applies updates to the paths in order.
 */
com.rpl.specter.multi_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() {
var G__35008 = null;
var G__35008__0 = (function (){
return com.rpl.specter.STAY;
});
var G__35008__1 = (function (path){
return path;
});
var G__35008__2 = (function (path1,path2){
var builder__33371__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late1,late2){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34887 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34887 = (function (path1,path2,late1,late2,meta34888){
this.path1 = path1;
this.path2 = path2;
this.late1 = late1;
this.late2 = late2;
this.meta34888 = meta34888;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34887.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34889,meta34888__$1){
var self__ = this;
var _34889__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34887(self__.path1,self__.path2,self__.late1,self__.late2,meta34888__$1));
}));

(com.rpl.specter.t_com$rpl$specter34887.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34889){
var self__ = this;
var _34889__$1 = this;
return self__.meta34888;
}));

(com.rpl.specter.t_com$rpl$specter34887.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34887.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var res1 = com.rpl.specter.protocols.select_STAR_(self__.late1,vals,structure,next_fn);
if(cljs.core.reduced_QMARK_(res1)){
return res1;
} else {
var res2 = com.rpl.specter.protocols.select_STAR_(self__.late2,vals,structure,next_fn);
if((com.rpl.specter.NONE === res1)){
return res2;
} else {
return res1;
}
}
}));

(com.rpl.specter.t_com$rpl$specter34887.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var s1 = com.rpl.specter.protocols.transform_STAR_(self__.late1,vals,structure,next_fn);
return com.rpl.specter.protocols.transform_STAR_(self__.late2,vals,s1,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34887.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path1","path1",-2002517142,null),new cljs.core.Symbol(null,"path2","path2",-1937913521,null),new cljs.core.Symbol(null,"late1","late1",-1413016621,null),new cljs.core.Symbol(null,"late2","late2",-681717994,null),new cljs.core.Symbol(null,"meta34888","meta34888",1196217389,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34887.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34887.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34887");

(com.rpl.specter.t_com$rpl$specter34887.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34887");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34887.
 */
com.rpl.specter.__GT_t_com$rpl$specter34887 = (function com$rpl$specter$__GT_t_com$rpl$specter34887(path1__$1,path2__$1,late1__$1,late2__$1,meta34888){
return (new com.rpl.specter.t_com$rpl$specter34887(path1__$1,path2__$1,late1__$1,late2__$1,meta34888));
});

}

return (new com.rpl.specter.t_com$rpl$specter34887(path1,path2,late1,late2,null));
}));
var curr_params__33372__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path1) : com.rpl.specter.late_path.call(null,path1)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path2) : com.rpl.specter.late_path.call(null,path2))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33372__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33371__auto__,curr_params__33372__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33371__auto__,curr_params__33372__auto__,null);
}
});
var G__35008__3 = (function() { 
var G__35011__delegate = function (path1,path2,paths){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(com.rpl.specter.multi_path,(com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(path1,path2) : com.rpl.specter.multi_path.call(null,path1,path2)),paths);
};
var G__35011 = function (path1,path2,var_args){
var paths = null;
if (arguments.length > 2) {
var G__35012__i = 0, G__35012__a = new Array(arguments.length -  2);
while (G__35012__i < G__35012__a.length) {G__35012__a[G__35012__i] = arguments[G__35012__i + 2]; ++G__35012__i;}
  paths = new cljs.core.IndexedSeq(G__35012__a,0,null);
} 
return G__35011__delegate.call(this,path1,path2,paths);};
G__35011.cljs$lang$maxFixedArity = 2;
G__35011.cljs$lang$applyTo = (function (arglist__35013){
var path1 = cljs.core.first(arglist__35013);
arglist__35013 = cljs.core.next(arglist__35013);
var path2 = cljs.core.first(arglist__35013);
var paths = cljs.core.rest(arglist__35013);
return G__35011__delegate(path1,path2,paths);
});
G__35011.cljs$core$IFn$_invoke$arity$variadic = G__35011__delegate;
return G__35011;
})()
;
G__35008 = function(path1,path2,var_args){
var paths = var_args;
switch(arguments.length){
case 0:
return G__35008__0.call(this);
case 1:
return G__35008__1.call(this,path1);
case 2:
return G__35008__2.call(this,path1,path2);
default:
var G__35014 = null;
if (arguments.length > 2) {
var G__35015__i = 0, G__35015__a = new Array(arguments.length -  2);
while (G__35015__i < G__35015__a.length) {G__35015__a[G__35015__i] = arguments[G__35015__i + 2]; ++G__35015__i;}
G__35014 = new cljs.core.IndexedSeq(G__35015__a,0,null);
}
return G__35008__3.cljs$core$IFn$_invoke$arity$variadic(path1,path2, G__35014);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35008.cljs$lang$maxFixedArity = 2;
G__35008.cljs$lang$applyTo = G__35008__3.cljs$lang$applyTo;
G__35008.cljs$core$IFn$_invoke$arity$0 = G__35008__0;
G__35008.cljs$core$IFn$_invoke$arity$1 = G__35008__1;
G__35008.cljs$core$IFn$_invoke$arity$2 = G__35008__2;
G__35008.cljs$core$IFn$_invoke$arity$variadic = G__35008__3.cljs$core$IFn$_invoke$arity$variadic;
return G__35008;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the current element and then navigates via the provided path.
 * This can be used to implement pre-order traversal.
 */
com.rpl.specter.stay_then_continue = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__35019__delegate = function (path){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.STAY,path) : com.rpl.specter.multi_path.call(null,com.rpl.specter.STAY,path));
};
var G__35019 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__35020__i = 0, G__35020__a = new Array(arguments.length -  0);
while (G__35020__i < G__35020__a.length) {G__35020__a[G__35020__i] = arguments[G__35020__i + 0]; ++G__35020__i;}
  path = new cljs.core.IndexedSeq(G__35020__a,0,null);
} 
return G__35019__delegate.call(this,path);};
G__35019.cljs$lang$maxFixedArity = 0;
G__35019.cljs$lang$applyTo = (function (arglist__35021){
var path = cljs.core.seq(arglist__35021);
return G__35019__delegate(path);
});
G__35019.cljs$core$IFn$_invoke$arity$variadic = G__35019__delegate;
return G__35019;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the provided path and then to the current element. This can be used
 * to implement post-order traversal.
 */
com.rpl.specter.continue_then_stay = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__35022__delegate = function (path){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(path,com.rpl.specter.STAY) : com.rpl.specter.multi_path.call(null,path,com.rpl.specter.STAY));
};
var G__35022 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__35023__i = 0, G__35023__a = new Array(arguments.length -  0);
while (G__35023__i < G__35023__a.length) {G__35023__a[G__35023__i] = arguments[G__35023__i + 0]; ++G__35023__i;}
  path = new cljs.core.IndexedSeq(G__35023__a,0,null);
} 
return G__35022__delegate.call(this,path);};
G__35022.cljs$lang$maxFixedArity = 0;
G__35022.cljs$lang$applyTo = (function (arglist__35024){
var path = cljs.core.seq(arglist__35024);
return G__35022__delegate(path);
});
G__35022.cljs$core$IFn$_invoke$arity$variadic = G__35022__delegate;
return G__35022;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigate the data structure until reaching
 *        a value for which `afn` returns truthy. Has
 *        same semantics as clojure.walk.
 */
com.rpl.specter.walker = com.rpl.specter.impl.direct_nav_obj((function (afn){
var p = com.rpl.specter.impl.local_declarepath();
com.rpl.specter.impl.providepath_STAR_(p,(function (){var info__33379__auto__ = com.rpl.specter.pathcache34894;
var info__33379__auto____$1 = (((info__33379__auto__ == null))?(function (){var info34895 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"com/rpl/specter.cljc",25,1,1394,1394,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"com/rpl/specter.cljc",7,1,true,1175,1179,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. Functions in paths\n          implicitly convert to this navigator.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"com/rpl/specter.cljc",7,1,644,646,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse(cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",12,1,2133,2133,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",(cljs.core.truth_(cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_LocalSym(p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache34894 = info34895;

return info34895;
})():info__33379__auto__);
var precompiled34896 = com.rpl.specter.impl.cached_path_info_precompiled(info__33379__auto____$1);
var dynamic_QMARK___33380__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33379__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33380__auto__)){
var G__34897 = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,p], null),com.rpl.specter.ALL,p], null);
return (precompiled34896.cljs$core$IFn$_invoke$arity$1 ? precompiled34896.cljs$core$IFn$_invoke$arity$1(G__34897) : precompiled34896.call(null,G__34897));
} else {
return precompiled34896;
}
})());

return p;
}));
/**
 * Like `walker` but maintains metadata of any forms traversed.
 */
com.rpl.specter.codewalker = com.rpl.specter.impl.direct_nav_obj((function (afn){
var p = com.rpl.specter.impl.local_declarepath();
com.rpl.specter.impl.providepath_STAR_(p,(function (){var info__33379__auto__ = com.rpl.specter.pathcache34898;
var info__33379__auto____$1 = (((info__33379__auto__ == null))?(function (){var info34899 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"com/rpl/specter.cljc",25,1,1394,1394,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"com/rpl/specter.cljc",7,1,true,1175,1179,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. Functions in paths\n          implicitly convert to this navigator.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"com/rpl/specter.cljc",7,1,644,646,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse(cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",12,1,2133,2133,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",(cljs.core.truth_(cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL_WITH_META,new cljs.core.Var(function(){return com.rpl.specter.ALL_WITH_META;},new cljs.core.Symbol("com.rpl.specter","ALL-WITH-META","com.rpl.specter/ALL-WITH-META",-1161868995,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),"com/rpl/specter.cljc",16,1,689,691,cljs.core.List.EMPTY,"Same as ALL, except maintains metadata on the structure.",(cljs.core.truth_(com.rpl.specter.ALL_WITH_META)?com.rpl.specter.ALL_WITH_META.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null)),com.rpl.specter.impl.__GT_LocalSym(p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache34898 = info34899;

return info34899;
})():info__33379__auto__);
var precompiled34900 = com.rpl.specter.impl.cached_path_info_precompiled(info__33379__auto____$1);
var dynamic_QMARK___33380__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33379__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33380__auto__)){
var G__34901 = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL_WITH_META,p], null),com.rpl.specter.ALL_WITH_META,p], null);
return (precompiled34900.cljs$core$IFn$_invoke$arity$1 ? precompiled34900.cljs$core$IFn$_invoke$arity$1(G__34901) : precompiled34900.call(null,G__34901));
} else {
return precompiled34900;
}
})());

return p;
}));
var empty__GT_NONE_35033 = (function (){var G__34902 = cljs.core.empty_QMARK_;
var G__34903 = com.rpl.specter.terminal_val(com.rpl.specter.NONE);
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$2(G__34902,G__34903) : com.rpl.specter.if_path.call(null,G__34902,G__34903));
})();
var compact_STAR__35034 = (function (nav){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(nav,empty__GT_NONE_35033) : com.rpl.specter.multi_path.call(null,nav,empty__GT_NONE_35033));
});
/**
 * During transforms, after each step of navigation in subpath check if the
 *  value is empty. If so, remove that value by setting it to NONE.
 */
com.rpl.specter.compact = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__35035__delegate = function (path){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(compact_STAR__35034,path);
};
var G__35035 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__35036__i = 0, G__35036__a = new Array(arguments.length -  0);
while (G__35036__i < G__35036__a.length) {G__35036__a[G__35036__i] = arguments[G__35036__i + 0]; ++G__35036__i;}
  path = new cljs.core.IndexedSeq(G__35036__a,0,null);
} 
return G__35035__delegate.call(this,path);};
G__35035.cljs$lang$maxFixedArity = 0;
G__35035.cljs$lang$applyTo = (function (arglist__35037){
var path = cljs.core.seq(arglist__35037);
return G__35035__delegate(path);
});
G__35035.cljs$core$IFn$_invoke$arity$variadic = G__35035__delegate;
return G__35035;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);

//# sourceMappingURL=com.rpl.specter.js.map
