goog.provide('sci.impl.interpreter');
goog.require('cljs.core');
goog.require('cljs.tools.reader.reader_types');
goog.require('sci.impl.analyzer');
goog.require('sci.impl.fns');
goog.require('sci.impl.interop');
goog.require('sci.impl.macros');
goog.require('sci.impl.max_or_throw');
goog.require('sci.impl.opts');
goog.require('sci.impl.parser');
goog.require('sci.impl.types');
goog.require('sci.impl.utils');
goog.require('sci.impl.vars');

sci.impl.interpreter.macros = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 19, [new cljs.core.Symbol(null,"macroexpand","macroexpand",1509933344,null),"null",new cljs.core.Symbol(null,"try","try",-1273693247,null),"null",new cljs.core.Symbol(null,"lazy-seq","lazy-seq",489632906,null),"null",new cljs.core.Symbol(null,"let","let",358118826,null),"null",new cljs.core.Symbol(null,"fn","fn",465265323,null),"null",new cljs.core.Symbol(null,"do","do",1686842252,null),"null",new cljs.core.Symbol(null,"in-ns","in-ns",-2089468466,null),"null",new cljs.core.Symbol(null,"defn","defn",-126010802,null),"null",new cljs.core.Symbol(null,"if","if",1181717262,null),"null",new cljs.core.Symbol(null,"or","or",1876275696,null),"null",new cljs.core.Symbol(null,"macroexpand-1","macroexpand-1",659241329,null),"null",new cljs.core.Symbol(null,"require","require",1172530194,null),"null",new cljs.core.Symbol(null,"syntax-quote","syntax-quote",407366680,null),"null",new cljs.core.Symbol(null,"set!","set!",250714521,null),"null",new cljs.core.Symbol(null,".",".",1975675962,null),"null",new cljs.core.Symbol(null,"quote","quote",1377916282,null),"null",new cljs.core.Symbol(null,"case","case",-1510733573,null),"null",new cljs.core.Symbol(null,"and","and",668631710,null),"null",new cljs.core.Symbol(null,"def","def",597100991,null),"null"], null), null);
/**
 * The and macro from clojure.core.
 */
sci.impl.interpreter.eval_and = (function sci$impl$interpreter$eval_and(ctx,args){
var args__$1 = cljs.core.seq(args);
var args__$2 = args__$1;
while(true){
if(args__$2){
var x = cljs.core.first(args__$2);
var xs = cljs.core.next(args__$2);
var v = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,x) : sci.impl.interpreter.interpret.call(null,ctx,x));
if(cljs.core.truth_(v)){
if(xs){
var G__30255 = xs;
args__$2 = G__30255;
continue;
} else {
return v;
}
} else {
return v;
}
} else {
return true;
}
break;
}
});
/**
 * The or macro from clojure.core.
 */
sci.impl.interpreter.eval_or = (function sci$impl$interpreter$eval_or(ctx,args){
var args__$1 = cljs.core.seq(args);
var args__$2 = args__$1;
while(true){
if(args__$2){
var x = cljs.core.first(args__$2);
var xs = cljs.core.next(args__$2);
var v = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,x) : sci.impl.interpreter.interpret.call(null,ctx,x));
if(cljs.core.truth_(v)){
return v;
} else {
if(xs){
var G__30256 = xs;
args__$2 = G__30256;
continue;
} else {
return v;
}
}
} else {
return null;
}
break;
}
});
/**
 * The let macro from clojure.core
 */
sci.impl.interpreter.eval_let = (function sci$impl$interpreter$eval_let(var_args){
var args__4742__auto__ = [];
var len__4736__auto___30257 = arguments.length;
var i__4737__auto___30258 = (0);
while(true){
if((i__4737__auto___30258 < len__4736__auto___30257)){
args__4742__auto__.push((arguments[i__4737__auto___30258]));

var G__30259 = (i__4737__auto___30258 + (1));
i__4737__auto___30258 = G__30259;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return sci.impl.interpreter.eval_let.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(sci.impl.interpreter.eval_let.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,let_bindings,exprs){
var ctx__$1 = (function (){var ctx__$1 = ctx;
var let_bindings__$1 = let_bindings;
while(true){
var let_name = cljs.core.first(let_bindings__$1);
var let_bindings__$2 = cljs.core.rest(let_bindings__$1);
var let_val = cljs.core.first(let_bindings__$2);
var rest_let_bindings = cljs.core.next(let_bindings__$2);
var val_tag = (function (){var temp__5735__auto__ = cljs.core.meta(let_val);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return new cljs.core.Keyword(null,"tag","tag",-1290361223).cljs$core$IFn$_invoke$arity$1(m);
} else {
return null;
}
})();
var let_name__$1 = (cljs.core.truth_(val_tag)?cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(let_name,cljs.core.update,new cljs.core.Keyword(null,"tag","tag",-1290361223),((function (ctx__$1,let_bindings__$1,let_name,let_bindings__$2,let_val,rest_let_bindings,val_tag){
return (function (t){
if(cljs.core.truth_(t)){
return t;
} else {
return val_tag;
}
});})(ctx__$1,let_bindings__$1,let_name,let_bindings__$2,let_val,rest_let_bindings,val_tag))
):let_name);
var v = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx__$1,let_val) : sci.impl.interpreter.interpret.call(null,ctx__$1,let_val));
var ctx__$2 = cljs.core.assoc_in(ctx__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bindings","bindings",1271397192),let_name__$1], null),v);
if(cljs.core.not(rest_let_bindings)){
return ctx__$2;
} else {
var G__30260 = ctx__$2;
var G__30261 = rest_let_bindings;
ctx__$1 = G__30260;
let_bindings__$1 = G__30261;
continue;
}
break;
}
})();
if(cljs.core.truth_(exprs)){
var exprs__$1 = exprs;
while(true){
var e = cljs.core.first(exprs__$1);
var ret = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx__$1,e) : sci.impl.interpreter.interpret.call(null,ctx__$1,e));
var nexprs = cljs.core.next(exprs__$1);
if(nexprs){
var G__30262 = nexprs;
exprs__$1 = G__30262;
continue;
} else {
return ret;
}
break;
}
} else {
return null;
}
}));

(sci.impl.interpreter.eval_let.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(sci.impl.interpreter.eval_let.cljs$lang$applyTo = (function (seq29531){
var G__29532 = cljs.core.first(seq29531);
var seq29531__$1 = cljs.core.next(seq29531);
var G__29533 = cljs.core.first(seq29531__$1);
var seq29531__$2 = cljs.core.next(seq29531__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29532,G__29533,seq29531__$2);
}));

sci.impl.interpreter.eval_if = (function sci$impl$interpreter$eval_if(ctx,expr){
var cond = cljs.core.first(expr);
var expr__$1 = cljs.core.rest(expr);
var then = cljs.core.first(expr__$1);
var expr__$2 = cljs.core.rest(expr__$1);
var else$ = cljs.core.first(expr__$2);
if(cljs.core.truth_((sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,cond) : sci.impl.interpreter.interpret.call(null,ctx,cond)))){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,then) : sci.impl.interpreter.interpret.call(null,ctx,then));
} else {
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,else$) : sci.impl.interpreter.interpret.call(null,ctx,else$));
}
});
sci.impl.interpreter.eval_def = (function sci$impl$interpreter$eval_def(ctx,p__29534){
var vec__29535 = p__29534;
var _def = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29535,(0),null);
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29535,(1),null);
var _QMARK_docstring = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29535,(2),null);
var _QMARK_init = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29535,(3),null);
var docstring = (cljs.core.truth_(_QMARK_init)?_QMARK_docstring:null);
var init = (cljs.core.truth_(docstring)?_QMARK_init:_QMARK_docstring);
var init__$1 = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,init) : sci.impl.interpreter.interpret.call(null,ctx,init));
var m = cljs.core.meta(var_name);
var m__$1 = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,m) : sci.impl.interpreter.interpret.call(null,ctx,m));
var cnn = sci.impl.vars.getName(new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m__$1));
var assoc_in_env = (function (env){
var the_current_ns = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn], null));
var prev = cljs.core.get.cljs$core$IFn$_invoke$arity$2(the_current_ns,var_name);
var v = (cljs.core.truth_((sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("sci.impl","var.unbound","sci.impl/var.unbound",-1824207647),init__$1) : sci.impl.utils.kw_identical_QMARK_.call(null,new cljs.core.Keyword("sci.impl","var.unbound","sci.impl/var.unbound",-1824207647),init__$1)))?(function (){var G__29538 = prev;
cljs.core.alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29538,cljs.core.merge,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m__$1], 0));

return G__29538;
})():(function (){
sci.impl.vars.bindRoot(prev,init__$1);

cljs.core.alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic(prev,cljs.core.merge,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m__$1], 0));

return prev;
})()
);
var the_current_ns__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(the_current_ns,var_name,v);
return cljs.core.assoc_in(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn], null),the_current_ns__$1);
});
var env = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),assoc_in_env);
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn,var_name], null));
});
sci.impl.interpreter.resolve_symbol = (function sci$impl$interpreter$resolve_symbol(ctx,sym){
var bindings = ctx.get(new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var temp__5733__auto__ = cljs.core.find(bindings,sym);
if(cljs.core.truth_(temp__5733__auto__)){
var v = temp__5733__auto__;
return cljs.core.second(v);
} else {
return sci.impl.utils.throw_error_with_location.cljs$core$IFn$_invoke$arity$2(["Could not resolve symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym),"\nks:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.keys(new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(ctx)))].join(''),sym);
}
});
sci.impl.interpreter.parse_libspec = (function sci$impl$interpreter$parse_libspec(libspec){
if(cljs.core.sequential_QMARK_(libspec)){
var vec__29539 = libspec;
var seq__29540 = cljs.core.seq(vec__29539);
var first__29541 = cljs.core.first(seq__29540);
var seq__29540__$1 = cljs.core.next(seq__29540);
var lib_name = first__29541;
var opts = seq__29540__$1;
var ret = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"lib-name","lib-name",1158024282),lib_name], null);
var G__29545 = opts;
var vec__29546 = G__29545;
var seq__29547 = cljs.core.seq(vec__29546);
var first__29548 = cljs.core.first(seq__29547);
var seq__29547__$1 = cljs.core.next(seq__29547);
var opt_name = first__29548;
var first__29548__$1 = cljs.core.first(seq__29547__$1);
var seq__29547__$2 = cljs.core.next(seq__29547__$1);
var fst_opt = first__29548__$1;
var rst_opts = seq__29547__$2;
var ret__$1 = ret;
var G__29545__$1 = G__29545;
while(true){
var ret__$2 = ret__$1;
var vec__29553 = G__29545__$1;
var seq__29554 = cljs.core.seq(vec__29553);
var first__29555 = cljs.core.first(seq__29554);
var seq__29554__$1 = cljs.core.next(seq__29554);
var opt_name__$1 = first__29555;
var first__29555__$1 = cljs.core.first(seq__29554__$1);
var seq__29554__$2 = cljs.core.next(seq__29554__$1);
var fst_opt__$1 = first__29555__$1;
var rst_opts__$1 = seq__29554__$2;
if(cljs.core.not(opt_name__$1)){
return ret__$2;
} else {
var G__29556 = opt_name__$1;
var G__29556__$1 = (((G__29556 instanceof cljs.core.Keyword))?G__29556.fqn:null);
switch (G__29556__$1) {
case "as":
var G__30264 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret__$2,new cljs.core.Keyword(null,"as","as",1148689641),fst_opt__$1);
var G__30265 = rst_opts__$1;
ret__$1 = G__30264;
G__29545__$1 = G__30265;
continue;

break;
case "reload":
case "reload-all":
case "verbose":
var G__30266 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret__$2,new cljs.core.Keyword(null,"reload","reload",863702807),true);
var G__30267 = cljs.core.cons(fst_opt__$1,rst_opts__$1);
ret__$1 = G__30266;
G__29545__$1 = G__30267;
continue;

break;
case "refer":
case "rename":
case "exclude":
case "only":
var G__30268 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret__$2,opt_name__$1,fst_opt__$1);
var G__30269 = rst_opts__$1;
ret__$1 = G__30268;
G__29545__$1 = G__30269;
continue;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__29556__$1)].join('')));

}
}
break;
}
} else {
if((libspec instanceof cljs.core.Symbol)){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"lib-name","lib-name",1158024282),libspec], null);
} else {
throw (new Error(["Invalid libspec: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(libspec)].join('')));

}
}
});
sci.impl.interpreter.handle_refer_all = (function sci$impl$interpreter$handle_refer_all(the_current_ns,the_loaded_ns,include_sym_QMARK_,rename_sym,only){
var only__$1 = (cljs.core.truth_(only)?cljs.core.set(only):null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ns,p__29561){
var vec__29562 = p__29561;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29562,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29562,(1),null);
if(cljs.core.truth_((((k instanceof cljs.core.Symbol))?(function (){var and__4115__auto__ = (include_sym_QMARK_.cljs$core$IFn$_invoke$arity$1 ? include_sym_QMARK_.cljs$core$IFn$_invoke$arity$1(k) : include_sym_QMARK_.call(null,k));
if(cljs.core.truth_(and__4115__auto__)){
return ((cljs.core.not(only__$1)) || (cljs.core.contains_QMARK_(only__$1,k)));
} else {
return and__4115__auto__;
}
})():false))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ns,(rename_sym.cljs$core$IFn$_invoke$arity$1 ? rename_sym.cljs$core$IFn$_invoke$arity$1(k) : rename_sym.call(null,k)),v);
} else {
return ns;
}
}),the_current_ns,the_loaded_ns);
});
sci.impl.interpreter.handle_require_libspec_env = (function sci$impl$interpreter$handle_require_libspec_env(env,use_QMARK_,current_ns,the_loaded_ns,lib_name,p__29568){
var map__29569 = p__29568;
var map__29569__$1 = (((((!((map__29569 == null))))?(((((map__29569.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29569.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29569):map__29569);
var _parsed_libspec = map__29569__$1;
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29569__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var refer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29569__$1,new cljs.core.Keyword(null,"refer","refer",-964295553));
var rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29569__$1,new cljs.core.Keyword(null,"rename","rename",1508157613));
var exclude = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29569__$1,new cljs.core.Keyword(null,"exclude","exclude",-1230250334));
var only = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29569__$1,new cljs.core.Keyword(null,"only","only",1907811652));
var the_current_ns = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),current_ns], null));
var the_current_ns__$1 = (cljs.core.truth_(as)?cljs.core.assoc_in(the_current_ns,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"aliases","aliases",1346874714),as], null),lib_name):the_current_ns);
var rename_sym = (cljs.core.truth_(rename)?(function (sym){
var or__4126__auto__ = (rename.cljs$core$IFn$_invoke$arity$1 ? rename.cljs$core$IFn$_invoke$arity$1(sym) : rename.call(null,sym));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return sym;
}
}):cljs.core.identity);
var include_sym_QMARK_ = (cljs.core.truth_(exclude)?(function (){var excludes = cljs.core.set(exclude);
return (function (sym){
return (!(cljs.core.contains_QMARK_(excludes,sym)));
});
})():cljs.core.constantly(true));
var the_current_ns__$2 = (cljs.core.truth_(refer)?(cljs.core.truth_((function (){var or__4126__auto__ = (sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"all","all",892129742),refer) : sci.impl.utils.kw_identical_QMARK_.call(null,new cljs.core.Keyword(null,"all","all",892129742),refer));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return use_QMARK_;
}
})())?sci.impl.interpreter.handle_refer_all(the_current_ns__$1,the_loaded_ns,include_sym_QMARK_,rename_sym,null):((cljs.core.sequential_QMARK_(refer))?cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ns,sym){
if(cljs.core.truth_(include_sym_QMARK_(sym))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ns,(rename_sym.cljs$core$IFn$_invoke$arity$1 ? rename_sym.cljs$core$IFn$_invoke$arity$1(sym) : rename_sym.call(null,sym)),(function (){var temp__5733__auto__ = cljs.core.find(the_loaded_ns,sym);
if(cljs.core.truth_(temp__5733__auto__)){
var vec__29571 = temp__5733__auto__;
var _k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29571,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29571,(1),null);
return v;
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym)," does not exist"].join('')));
}
})());
} else {
return ns;
}
}),the_current_ns__$1,refer):(function(){throw (new Error(":refer value must be a sequential collection of symbols"))})()
)):(cljs.core.truth_(use_QMARK_)?sci.impl.interpreter.handle_refer_all(the_current_ns__$1,the_loaded_ns,include_sym_QMARK_,rename_sym,only):the_current_ns__$1
));
var env__$1 = cljs.core.assoc_in(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),current_ns], null),the_current_ns__$2);
return env__$1;
});
sci.impl.interpreter.handle_require_libspec = (function sci$impl$interpreter$handle_require_libspec(ctx,libspec){
var map__29574 = sci.impl.interpreter.parse_libspec(libspec);
var map__29574__$1 = (((((!((map__29574 == null))))?(((((map__29574.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29574.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29574):map__29574);
var parsed_libspec = map__29574__$1;
var lib_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29574__$1,new cljs.core.Keyword(null,"lib-name","lib-name",1158024282));
var reload = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29574__$1,new cljs.core.Keyword(null,"reload","reload",863702807));
var env_STAR_ = new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx);
var env = cljs.core.deref(env_STAR_);
var cnn = sci.impl.vars.current_ns_name();
var namespaces = cljs.core.get.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469));
var use_QMARK_ = new cljs.core.Keyword("sci.impl","use","sci.impl/use",1724565881).cljs$core$IFn$_invoke$arity$1(ctx);
var temp__5733__auto__ = (cljs.core.truth_(reload)?null:cljs.core.get.cljs$core$IFn$_invoke$arity$2(namespaces,lib_name));
if(cljs.core.truth_(temp__5733__auto__)){
var the_loaded_ns = temp__5733__auto__;
return cljs.core.reset_BANG_(env_STAR_,sci.impl.interpreter.handle_require_libspec_env(env,use_QMARK_,cnn,the_loaded_ns,lib_name,parsed_libspec));
} else {
var temp__5733__auto____$1 = new cljs.core.Keyword(null,"load-fn","load-fn",-2121144334).cljs$core$IFn$_invoke$arity$1(ctx);
if(cljs.core.truth_(temp__5733__auto____$1)){
var load_fn = temp__5733__auto____$1;
var temp__5733__auto____$2 = (function (){var G__29576 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),lib_name], null);
return (load_fn.cljs$core$IFn$_invoke$arity$1 ? load_fn.cljs$core$IFn$_invoke$arity$1(G__29576) : load_fn.call(null,G__29576));
})();
if(cljs.core.truth_(temp__5733__auto____$2)){
var map__29577 = temp__5733__auto____$2;
var map__29577__$1 = (((((!((map__29577 == null))))?(((((map__29577.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29577.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29577):map__29577);
var file = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29577__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29577__$1,new cljs.core.Keyword(null,"source","source",-433931539));
try{sci.impl.vars.push_thread_bindings(cljs.core.PersistentArrayMap.createAsIfByAssoc([sci.impl.vars.current_ns,cljs.core.deref(sci.impl.vars.current_ns),sci.impl.vars.current_file,file]));

try{var G__29580_30270 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ctx,new cljs.core.Keyword(null,"bindings","bindings",1271397192),cljs.core.PersistentArrayMap.EMPTY);
var G__29581_30271 = source;
(sci.impl.interpreter.eval_string_STAR_.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.eval_string_STAR_.cljs$core$IFn$_invoke$arity$2(G__29580_30270,G__29581_30271) : sci.impl.interpreter.eval_string_STAR_.call(null,G__29580_30270,G__29581_30271));
}finally {sci.impl.vars.pop_thread_bindings();
}}catch (e29579){if((e29579 instanceof Error)){
var e_30272 = e29579;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(env_STAR_,cljs.core.update,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lib_name], 0));

throw e_30272;
} else {
throw e29579;

}
}
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(env_STAR_,(function (env__$1){
var namespaces__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(env__$1,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469));
var the_loaded_ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(namespaces__$1,lib_name);
return sci.impl.interpreter.handle_require_libspec_env(env__$1,use_QMARK_,cnn,the_loaded_ns,lib_name,parsed_libspec);
}));
} else {
var or__4126__auto__ = (cljs.core.truth_(reload)?(function (){var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(namespaces,lib_name);
if(cljs.core.truth_(temp__5735__auto__)){
var the_loaded_ns = temp__5735__auto__;
return cljs.core.reset_BANG_(env_STAR_,sci.impl.interpreter.handle_require_libspec_env(env,use_QMARK_,cnn,the_loaded_ns,lib_name,parsed_libspec));
} else {
return null;
}
})():null);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw (new Error(["Could not require ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lib_name),"."].join('')));
}
}
} else {
throw (new Error(["Could not require ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lib_name),"."].join('')));
}
}
});
sci.impl.interpreter.eval_require = (function sci$impl$interpreter$eval_require(var_args){
var args__4742__auto__ = [];
var len__4736__auto___30273 = arguments.length;
var i__4737__auto___30274 = (0);
while(true){
if((i__4737__auto___30274 < len__4736__auto___30273)){
args__4742__auto__.push((arguments[i__4737__auto___30274]));

var G__30275 = (i__4737__auto___30274 + (1));
i__4737__auto___30274 = G__30275;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return sci.impl.interpreter.eval_require.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(sci.impl.interpreter.eval_require.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,args){
var libspecs = cljs.core.PersistentVector.EMPTY;
var current_libspec = null;
var args__$1 = args;
while(true){
if(cljs.core.truth_(args__$1)){
var ret = (function (){var G__29590 = ctx;
var G__29591 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29590,G__29591) : sci.impl.interpreter.interpret.call(null,G__29590,G__29591));
})();
if((ret instanceof cljs.core.Symbol)){
var G__30276 = (function (){var G__29592 = libspecs;
if(cljs.core.truth_(current_libspec)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__29592,current_libspec);
} else {
return G__29592;
}
})();
var G__30277 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ret], null);
var G__30278 = cljs.core.next(args__$1);
libspecs = G__30276;
current_libspec = G__30277;
args__$1 = G__30278;
continue;
} else {
if((ret instanceof cljs.core.Keyword)){
var G__30279 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(libspecs,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(current_libspec,ret));
var G__30280 = null;
var G__30281 = cljs.core.next(args__$1);
libspecs = G__30279;
current_libspec = G__30280;
args__$1 = G__30281;
continue;
} else {
var G__30282 = (function (){var G__29593 = libspecs;
if(cljs.core.truth_(current_libspec)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__29593,current_libspec);
} else {
return G__29593;
}
})();
var G__30283 = ret;
var G__30284 = cljs.core.next(args__$1);
libspecs = G__30282;
current_libspec = G__30283;
args__$1 = G__30284;
continue;

}
}
} else {
var libspecs__$1 = (function (){var G__29594 = libspecs;
if(cljs.core.truth_(current_libspec)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__29594,current_libspec);
} else {
return G__29594;
}
})();
return cljs.core.run_BANG_(((function (libspecs,current_libspec,args__$1,libspecs__$1){
return (function (p1__29582_SHARP_){
return sci.impl.interpreter.handle_require_libspec(ctx,p1__29582_SHARP_);
});})(libspecs,current_libspec,args__$1,libspecs__$1))
,libspecs__$1);
}
break;
}
}));

(sci.impl.interpreter.eval_require.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sci.impl.interpreter.eval_require.cljs$lang$applyTo = (function (seq29583){
var G__29584 = cljs.core.first(seq29583);
var seq29583__$1 = cljs.core.next(seq29583);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29584,seq29583__$1);
}));

cljs.core.vreset_BANG_(sci.impl.utils.eval_require_state,sci.impl.interpreter.eval_require);
sci.impl.interpreter.eval_use = (function sci$impl$interpreter$eval_use(var_args){
var args__4742__auto__ = [];
var len__4736__auto___30285 = arguments.length;
var i__4737__auto___30286 = (0);
while(true){
if((i__4737__auto___30286 < len__4736__auto___30285)){
args__4742__auto__.push((arguments[i__4737__auto___30286]));

var G__30287 = (i__4737__auto___30286 + (1));
i__4737__auto___30286 = G__30287;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return sci.impl.interpreter.eval_use.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(sci.impl.interpreter.eval_use.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(sci.impl.interpreter.eval_require,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ctx,new cljs.core.Keyword("sci.impl","use","sci.impl/use",1724565881),true),args);
}));

(sci.impl.interpreter.eval_use.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sci.impl.interpreter.eval_use.cljs$lang$applyTo = (function (seq29595){
var G__29596 = cljs.core.first(seq29595);
var seq29595__$1 = cljs.core.next(seq29595);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29596,seq29595__$1);
}));

cljs.core.vreset_BANG_(sci.impl.utils.eval_use_state,sci.impl.interpreter.eval_use);
sci.impl.interpreter.eval_case = (function sci$impl$interpreter$eval_case(ctx,p__29597){
var vec__29598 = p__29597;
var _case = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29598,(0),null);
var map__29601 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29598,(1),null);
var map__29601__$1 = (((((!((map__29601 == null))))?(((((map__29601.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29601.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29601):map__29601);
var case_map = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29601__$1,new cljs.core.Keyword(null,"case-map","case-map",955082964));
var case_val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29601__$1,new cljs.core.Keyword(null,"case-val","case-val",880926521));
var case_default = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29601__$1,new cljs.core.Keyword(null,"case-default","case-default",1140470708));
var v = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,case_val) : sci.impl.interpreter.interpret.call(null,ctx,case_val));
var temp__5733__auto__ = cljs.core.find(case_map,v);
if(cljs.core.truth_(temp__5733__auto__)){
var vec__29603 = temp__5733__auto__;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29603,(0),null);
var found = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29603,(1),null);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,found) : sci.impl.interpreter.interpret.call(null,ctx,found));
} else {
if(cljs.core.vector_QMARK_(case_default)){
var G__29606 = ctx;
var G__29607 = cljs.core.second(case_default);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29606,G__29607) : sci.impl.interpreter.interpret.call(null,G__29606,G__29607));
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')));
}
}
});
sci.impl.interpreter.eval_try = (function sci$impl$interpreter$eval_try(ctx,expr){
var map__29608 = new cljs.core.Keyword("sci.impl","try","sci.impl/try",2142624741).cljs$core$IFn$_invoke$arity$1(expr);
var map__29608__$1 = (((((!((map__29608 == null))))?(((((map__29608.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29608.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29608):map__29608);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29608__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var catches = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29608__$1,new cljs.core.Keyword(null,"catches","catches",-1478797617));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29608__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
try{var _STAR_in_try_STAR__orig_val__29616 = sci.impl.utils._STAR_in_try_STAR_;
var _STAR_in_try_STAR__temp_val__29617 = true;
(sci.impl.utils._STAR_in_try_STAR_ = _STAR_in_try_STAR__temp_val__29617);

try{return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,body) : sci.impl.interpreter.interpret.call(null,ctx,body));
}finally {(sci.impl.utils._STAR_in_try_STAR_ = _STAR_in_try_STAR__orig_val__29616);
}}catch (e29610){if((e29610 instanceof Error)){
var e = e29610;
var temp__5733__auto__ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (_,c){
var clazz = new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(c);
if((e instanceof clazz)){
return cljs.core.reduced(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sci.impl.interpreter","try-result","sci.impl.interpreter/try-result",1789456125),(function (){var G__29611 = cljs.core.assoc_in(ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bindings","bindings",1271397192),new cljs.core.Keyword(null,"binding","binding",539932593).cljs$core$IFn$_invoke$arity$1(c)], null),e);
var G__29612 = new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(c);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29611,G__29612) : sci.impl.interpreter.interpret.call(null,G__29611,G__29612));
})()], null));
} else {
return null;
}
}),null,catches);
if(cljs.core.truth_(temp__5733__auto__)){
var vec__29613 = temp__5733__auto__;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29613,(0),null);
var r = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29613,(1),null);
return r;
} else {
return sci.impl.utils.rethrow_with_location_of_node(ctx,e,body);
}
} else {
throw e29610;

}
}finally {(sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,finally$) : sci.impl.interpreter.interpret.call(null,ctx,finally$));
}});
sci.impl.interpreter.eval_throw = (function sci$impl$interpreter$eval_throw(ctx,p__29618){
var vec__29619 = p__29618;
var _throw = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29619,(0),null);
var ex = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29619,(1),null);
var ex__$1 = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,ex) : sci.impl.interpreter.interpret.call(null,ctx,ex));
throw ex__$1;
});
sci.impl.interpreter.eval_static_method_invocation = (function sci$impl$interpreter$eval_static_method_invocation(ctx,expr){
return sci.impl.interop.invoke_static_method(cljs.core.first(expr),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29622_SHARP_){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,p1__29622_SHARP_) : sci.impl.interpreter.interpret.call(null,ctx,p1__29622_SHARP_));
}),cljs.core.rest(expr)));
});
sci.impl.interpreter.eval_constructor_invocation = (function sci$impl$interpreter$eval_constructor_invocation(ctx,p__29624){
var vec__29625 = p__29624;
var _new = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29625,(0),null);
var constructor$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29625,(1),null);
var args = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29625,(2),null);
var args__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29623_SHARP_){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,p1__29623_SHARP_) : sci.impl.interpreter.interpret.call(null,ctx,p1__29623_SHARP_));
}),args);
return sci.impl.interop.invoke_constructor(constructor$,args__$1);
});
sci.impl.interpreter.eval_instance_method_invocation = (function sci$impl$interpreter$eval_instance_method_invocation(p__29630,p__29631){
var map__29632 = p__29630;
var map__29632__$1 = (((((!((map__29632 == null))))?(((((map__29632.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29632.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29632):map__29632);
var ctx = map__29632__$1;
var class__GT_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29632__$1,new cljs.core.Keyword(null,"class->opts","class->opts",2061906477));
var vec__29633 = p__29631;
var _dot = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29633,(0),null);
var instance_expr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29633,(1),null);
var method_str = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29633,(2),null);
var args = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29633,(3),null);
var instance_meta = cljs.core.meta(instance_expr);
var tag_class = new cljs.core.Keyword(null,"tag-class","tag-class",714967874).cljs$core$IFn$_invoke$arity$1(instance_meta);
var instance_expr_STAR_ = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,instance_expr) : sci.impl.interpreter.interpret.call(null,ctx,instance_expr));
var instance_class = (function (){var or__4126__auto__ = tag_class;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.type(instance_expr_STAR_);
}
})();
var instance_class_name = instance_class.name;
var instance_class_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(instance_class_name);
var allowed_QMARK_ = (function (){var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(class__GT_opts,new cljs.core.Keyword(null,"allow","allow",-1857325745));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(class__GT_opts,instance_class_symbol);
}
})();
var target_class = (cljs.core.truth_(allowed_QMARK_)?instance_class:(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"public-class","public-class",1127293019).cljs$core$IFn$_invoke$arity$1(ctx);
if(cljs.core.truth_(temp__5735__auto__)){
var f = temp__5735__auto__;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(instance_expr_STAR_) : f.call(null,instance_expr_STAR_));
} else {
return null;
}
})());
if(cljs.core.truth_(target_class)){
} else {
sci.impl.utils.throw_error_with_location.cljs$core$IFn$_invoke$arity$2(["Method ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(method_str)," on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(instance_class)," not allowed!"].join(''),instance_expr);
}

var args__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29629_SHARP_){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,p1__29629_SHARP_) : sci.impl.interpreter.interpret.call(null,ctx,p1__29629_SHARP_));
}),args);
return sci.impl.interop.invoke_instance_method(instance_expr_STAR_,target_class,method_str,args__$1);
});
sci.impl.interpreter.eval_in_ns = (function sci$impl$interpreter$eval_in_ns(ctx,p__29637){
var vec__29638 = p__29637;
var _in_ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29638,(0),null);
var ns_expr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29638,(1),null);
var ns_sym = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,ns_expr) : sci.impl.interpreter.interpret.call(null,ctx,ns_expr));
sci.impl.utils.set_namespace_BANG_(ctx,ns_sym,null);

return null;
});
sci.impl.interpreter.eval_refer = (function sci$impl$interpreter$eval_refer(ctx,p__29641){
var vec__29642 = p__29641;
var seq__29643 = cljs.core.seq(vec__29642);
var first__29644 = cljs.core.first(seq__29643);
var seq__29643__$1 = cljs.core.next(seq__29643);
var _ = first__29644;
var first__29644__$1 = cljs.core.first(seq__29643__$1);
var seq__29643__$2 = cljs.core.next(seq__29643__$1);
var ns_sym = first__29644__$1;
var exprs = seq__29643__$2;
var ns_sym__$1 = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,ns_sym) : sci.impl.interpreter.interpret.call(null,ctx,ns_sym));
var exprs__$1 = exprs;
while(true){
if(exprs__$1){
var vec__29645 = exprs__$1;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29645,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29645,(1),null);
var G__29648_30288 = k;
var G__29648_30289__$1 = (((G__29648_30288 instanceof cljs.core.Keyword))?G__29648_30288.fqn:null);
switch (G__29648_30289__$1) {
case "exclude":
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),((function (exprs__$1,G__29648_30288,G__29648_30289__$1,vec__29645,k,v,ns_sym__$1,vec__29642,seq__29643,first__29644,seq__29643__$1,_,first__29644__$1,seq__29643__$2,ns_sym,exprs){
return (function (env){
var cnn = sci.impl.vars.current_ns_name();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(env,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn,new cljs.core.Keyword(null,"refer","refer",-964295553),ns_sym__$1,new cljs.core.Keyword(null,"exclude","exclude",-1230250334)], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.into,cljs.core.PersistentHashSet.EMPTY),v);
});})(exprs__$1,G__29648_30288,G__29648_30289__$1,vec__29645,k,v,ns_sym__$1,vec__29642,seq__29643,first__29644,seq__29643__$1,_,first__29644__$1,seq__29643__$2,ns_sym,exprs))
);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__29648_30289__$1)].join('')));

}

var G__30291 = cljs.core.nnext(exprs__$1);
exprs__$1 = G__30291;
continue;
} else {
return null;
}
break;
}
});
sci.impl.interpreter.eval_resolve = (function sci$impl$interpreter$eval_resolve(ctx,sym){
var sym__$1 = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,sym) : sci.impl.interpreter.interpret.call(null,ctx,sym));
return cljs.core.second(sci.impl.analyzer.lookup(ctx,sym__$1,false));
});
cljs.core.vreset_BANG_(sci.impl.utils.eval_resolve_state,sci.impl.interpreter.eval_resolve);
sci.impl.interpreter.macroexpand_1 = (function sci$impl$interpreter$macroexpand_1(ctx,expr){
var original_expr = expr;
if(cljs.core.seq_QMARK_(expr)){
var op = cljs.core.first(expr);
if((op instanceof cljs.core.Symbol)){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(sci.impl.analyzer.special_syms,op))){
return expr;
} else {
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"for","for",316745208,null),null], null), null),op)){
return sci.impl.analyzer.analyze(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ctx,new cljs.core.Keyword("sci.impl","macroexpanding","sci.impl/macroexpanding",2113471825),true),expr);
} else {
var f = sci.impl.analyzer.resolve_symbol.cljs$core$IFn$_invoke$arity$3(ctx,op,true);
var f__$1 = (cljs.core.truth_(((sci.impl.vars.var_QMARK_(f))?sci.impl.vars.isMacro(f):false))?cljs.core.deref(f):f);
if(cljs.core.truth_(sci.impl.analyzer.macro_QMARK_(f__$1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f__$1,original_expr,new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(ctx),cljs.core.rest(expr));
} else {
return expr;
}

}
}
} else {
return expr;
}
} else {
return expr;
}
});
sci.impl.interpreter.macroexpand = (function sci$impl$interpreter$macroexpand(ctx,form){
var ex = sci.impl.interpreter.macroexpand_1(ctx,form);
if((ex === form)){
return form;
} else {
return (sci.impl.interpreter.macroexpand.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.macroexpand.cljs$core$IFn$_invoke$arity$2(ctx,ex) : sci.impl.interpreter.macroexpand.call(null,ctx,ex));
}
});
sci.impl.interpreter.eval_set_BANG_ = (function sci$impl$interpreter$eval_set_BANG_(ctx,p__29649){
var vec__29650 = p__29649;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29650,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29650,(1),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29650,(2),null);
var obj__$1 = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,obj) : sci.impl.interpreter.interpret.call(null,ctx,obj));
var v__$1 = (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,v) : sci.impl.interpreter.interpret.call(null,ctx,v));
if(sci.impl.vars.var_QMARK_(obj__$1)){
return sci.impl.types.setVal(obj__$1,v__$1);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot set ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(obj__$1)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(v__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"obj","obj",981763962),obj__$1,new cljs.core.Keyword(null,"v","v",21465059),v__$1], null));
}
});
sci.impl.interpreter.eval_do_STAR_ = (function sci$impl$interpreter$eval_do_STAR_(ctx,exprs){
var G__29656 = exprs;
var vec__29657 = G__29656;
var seq__29658 = cljs.core.seq(vec__29657);
var first__29659 = cljs.core.first(seq__29658);
var seq__29658__$1 = cljs.core.next(seq__29658);
var expr = first__29659;
var exprs__$1 = seq__29658__$1;
var G__29656__$1 = G__29656;
while(true){
var vec__29660 = G__29656__$1;
var seq__29661 = cljs.core.seq(vec__29660);
var first__29662 = cljs.core.first(seq__29661);
var seq__29661__$1 = cljs.core.next(seq__29661);
var expr__$1 = first__29662;
var exprs__$2 = seq__29661__$1;
var ret = (function (){try{return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,expr__$1) : sci.impl.interpreter.interpret.call(null,ctx,expr__$1));
}catch (e29663){if((e29663 instanceof Error)){
var e = e29663;
return sci.impl.utils.rethrow_with_location_of_node(ctx,e,expr__$1);
} else {
throw e29663;

}
}})();
var temp__5733__auto__ = cljs.core.seq(exprs__$2);
if(temp__5733__auto__){
var exprs__$3 = temp__5733__auto__;
var G__30292 = exprs__$3;
G__29656__$1 = G__30292;
continue;
} else {
return ret;
}
break;
}
});
sci.impl.interpreter.eval_do = (function sci$impl$interpreter$eval_do(ctx,expr){
var temp__5735__auto__ = cljs.core.next(expr);
if(temp__5735__auto__){
var exprs = temp__5735__auto__;
return sci.impl.interpreter.eval_do_STAR_(ctx,exprs);
} else {
return null;
}
});
sci.impl.interpreter.fn_call = (function sci$impl$interpreter$fn_call(ctx,f,args){
var G__29856 = cljs.core.count(args);
switch (G__29856) {
case (0):
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));

break;
case (1):
var arg29666 = (function (){var G__29857 = ctx;
var G__29858 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29857,G__29858) : sci.impl.interpreter.interpret.call(null,G__29857,G__29858));
})();
var args__$1 = cljs.core.rest(args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg29666) : f.call(null,arg29666));

break;
case (2):
var arg29667 = (function (){var G__29859 = ctx;
var G__29860 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29859,G__29860) : sci.impl.interpreter.interpret.call(null,G__29859,G__29860));
})();
var args__$1 = cljs.core.rest(args);
var arg29668 = (function (){var G__29861 = ctx;
var G__29862 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29861,G__29862) : sci.impl.interpreter.interpret.call(null,G__29861,G__29862));
})();
var args__$2 = cljs.core.rest(args__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg29667,arg29668) : f.call(null,arg29667,arg29668));

break;
case (3):
var arg29669 = (function (){var G__29863 = ctx;
var G__29864 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29863,G__29864) : sci.impl.interpreter.interpret.call(null,G__29863,G__29864));
})();
var args__$1 = cljs.core.rest(args);
var arg29670 = (function (){var G__29865 = ctx;
var G__29866 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29865,G__29866) : sci.impl.interpreter.interpret.call(null,G__29865,G__29866));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg29671 = (function (){var G__29867 = ctx;
var G__29868 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29867,G__29868) : sci.impl.interpreter.interpret.call(null,G__29867,G__29868));
})();
var args__$3 = cljs.core.rest(args__$2);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg29669,arg29670,arg29671) : f.call(null,arg29669,arg29670,arg29671));

break;
case (4):
var arg29672 = (function (){var G__29869 = ctx;
var G__29870 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29869,G__29870) : sci.impl.interpreter.interpret.call(null,G__29869,G__29870));
})();
var args__$1 = cljs.core.rest(args);
var arg29673 = (function (){var G__29871 = ctx;
var G__29872 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29871,G__29872) : sci.impl.interpreter.interpret.call(null,G__29871,G__29872));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg29674 = (function (){var G__29873 = ctx;
var G__29874 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29873,G__29874) : sci.impl.interpreter.interpret.call(null,G__29873,G__29874));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg29675 = (function (){var G__29875 = ctx;
var G__29876 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29875,G__29876) : sci.impl.interpreter.interpret.call(null,G__29875,G__29876));
})();
var args__$4 = cljs.core.rest(args__$3);
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg29672,arg29673,arg29674,arg29675) : f.call(null,arg29672,arg29673,arg29674,arg29675));

break;
case (5):
var arg29676 = (function (){var G__29877 = ctx;
var G__29878 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29877,G__29878) : sci.impl.interpreter.interpret.call(null,G__29877,G__29878));
})();
var args__$1 = cljs.core.rest(args);
var arg29677 = (function (){var G__29879 = ctx;
var G__29880 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29879,G__29880) : sci.impl.interpreter.interpret.call(null,G__29879,G__29880));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg29678 = (function (){var G__29881 = ctx;
var G__29882 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29881,G__29882) : sci.impl.interpreter.interpret.call(null,G__29881,G__29882));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg29679 = (function (){var G__29883 = ctx;
var G__29884 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29883,G__29884) : sci.impl.interpreter.interpret.call(null,G__29883,G__29884));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg29680 = (function (){var G__29885 = ctx;
var G__29886 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29885,G__29886) : sci.impl.interpreter.interpret.call(null,G__29885,G__29886));
})();
var args__$5 = cljs.core.rest(args__$4);
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg29676,arg29677,arg29678,arg29679,arg29680) : f.call(null,arg29676,arg29677,arg29678,arg29679,arg29680));

break;
case (6):
var arg29681 = (function (){var G__29887 = ctx;
var G__29888 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29887,G__29888) : sci.impl.interpreter.interpret.call(null,G__29887,G__29888));
})();
var args__$1 = cljs.core.rest(args);
var arg29682 = (function (){var G__29889 = ctx;
var G__29890 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29889,G__29890) : sci.impl.interpreter.interpret.call(null,G__29889,G__29890));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg29683 = (function (){var G__29891 = ctx;
var G__29892 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29891,G__29892) : sci.impl.interpreter.interpret.call(null,G__29891,G__29892));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg29684 = (function (){var G__29893 = ctx;
var G__29894 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29893,G__29894) : sci.impl.interpreter.interpret.call(null,G__29893,G__29894));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg29685 = (function (){var G__29895 = ctx;
var G__29896 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29895,G__29896) : sci.impl.interpreter.interpret.call(null,G__29895,G__29896));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg29686 = (function (){var G__29897 = ctx;
var G__29898 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29897,G__29898) : sci.impl.interpreter.interpret.call(null,G__29897,G__29898));
})();
var args__$6 = cljs.core.rest(args__$5);
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg29681,arg29682,arg29683,arg29684,arg29685,arg29686) : f.call(null,arg29681,arg29682,arg29683,arg29684,arg29685,arg29686));

break;
case (7):
var arg29687 = (function (){var G__29899 = ctx;
var G__29900 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29899,G__29900) : sci.impl.interpreter.interpret.call(null,G__29899,G__29900));
})();
var args__$1 = cljs.core.rest(args);
var arg29688 = (function (){var G__29901 = ctx;
var G__29902 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29901,G__29902) : sci.impl.interpreter.interpret.call(null,G__29901,G__29902));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg29689 = (function (){var G__29903 = ctx;
var G__29904 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29903,G__29904) : sci.impl.interpreter.interpret.call(null,G__29903,G__29904));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg29690 = (function (){var G__29905 = ctx;
var G__29906 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29905,G__29906) : sci.impl.interpreter.interpret.call(null,G__29905,G__29906));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg29691 = (function (){var G__29907 = ctx;
var G__29908 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29907,G__29908) : sci.impl.interpreter.interpret.call(null,G__29907,G__29908));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg29692 = (function (){var G__29909 = ctx;
var G__29910 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29909,G__29910) : sci.impl.interpreter.interpret.call(null,G__29909,G__29910));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg29693 = (function (){var G__29911 = ctx;
var G__29912 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29911,G__29912) : sci.impl.interpreter.interpret.call(null,G__29911,G__29912));
})();
var args__$7 = cljs.core.rest(args__$6);
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(arg29687,arg29688,arg29689,arg29690,arg29691,arg29692,arg29693) : f.call(null,arg29687,arg29688,arg29689,arg29690,arg29691,arg29692,arg29693));

break;
case (8):
var arg29694 = (function (){var G__29913 = ctx;
var G__29914 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29913,G__29914) : sci.impl.interpreter.interpret.call(null,G__29913,G__29914));
})();
var args__$1 = cljs.core.rest(args);
var arg29695 = (function (){var G__29915 = ctx;
var G__29916 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29915,G__29916) : sci.impl.interpreter.interpret.call(null,G__29915,G__29916));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg29696 = (function (){var G__29917 = ctx;
var G__29918 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29917,G__29918) : sci.impl.interpreter.interpret.call(null,G__29917,G__29918));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg29697 = (function (){var G__29919 = ctx;
var G__29920 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29919,G__29920) : sci.impl.interpreter.interpret.call(null,G__29919,G__29920));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg29698 = (function (){var G__29921 = ctx;
var G__29922 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29921,G__29922) : sci.impl.interpreter.interpret.call(null,G__29921,G__29922));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg29699 = (function (){var G__29923 = ctx;
var G__29924 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29923,G__29924) : sci.impl.interpreter.interpret.call(null,G__29923,G__29924));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg29700 = (function (){var G__29925 = ctx;
var G__29926 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29925,G__29926) : sci.impl.interpreter.interpret.call(null,G__29925,G__29926));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg29701 = (function (){var G__29927 = ctx;
var G__29928 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29927,G__29928) : sci.impl.interpreter.interpret.call(null,G__29927,G__29928));
})();
var args__$8 = cljs.core.rest(args__$7);
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(arg29694,arg29695,arg29696,arg29697,arg29698,arg29699,arg29700,arg29701) : f.call(null,arg29694,arg29695,arg29696,arg29697,arg29698,arg29699,arg29700,arg29701));

break;
case (9):
var arg29702 = (function (){var G__29929 = ctx;
var G__29930 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29929,G__29930) : sci.impl.interpreter.interpret.call(null,G__29929,G__29930));
})();
var args__$1 = cljs.core.rest(args);
var arg29703 = (function (){var G__29931 = ctx;
var G__29932 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29931,G__29932) : sci.impl.interpreter.interpret.call(null,G__29931,G__29932));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg29704 = (function (){var G__29933 = ctx;
var G__29934 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29933,G__29934) : sci.impl.interpreter.interpret.call(null,G__29933,G__29934));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg29705 = (function (){var G__29935 = ctx;
var G__29936 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29935,G__29936) : sci.impl.interpreter.interpret.call(null,G__29935,G__29936));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg29706 = (function (){var G__29937 = ctx;
var G__29938 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29937,G__29938) : sci.impl.interpreter.interpret.call(null,G__29937,G__29938));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg29707 = (function (){var G__29939 = ctx;
var G__29940 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29939,G__29940) : sci.impl.interpreter.interpret.call(null,G__29939,G__29940));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg29708 = (function (){var G__29941 = ctx;
var G__29942 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29941,G__29942) : sci.impl.interpreter.interpret.call(null,G__29941,G__29942));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg29709 = (function (){var G__29943 = ctx;
var G__29944 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29943,G__29944) : sci.impl.interpreter.interpret.call(null,G__29943,G__29944));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg29710 = (function (){var G__29945 = ctx;
var G__29946 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29945,G__29946) : sci.impl.interpreter.interpret.call(null,G__29945,G__29946));
})();
var args__$9 = cljs.core.rest(args__$8);
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(arg29702,arg29703,arg29704,arg29705,arg29706,arg29707,arg29708,arg29709,arg29710) : f.call(null,arg29702,arg29703,arg29704,arg29705,arg29706,arg29707,arg29708,arg29709,arg29710));

break;
case (10):
var arg29711 = (function (){var G__29947 = ctx;
var G__29948 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29947,G__29948) : sci.impl.interpreter.interpret.call(null,G__29947,G__29948));
})();
var args__$1 = cljs.core.rest(args);
var arg29712 = (function (){var G__29949 = ctx;
var G__29950 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29949,G__29950) : sci.impl.interpreter.interpret.call(null,G__29949,G__29950));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg29713 = (function (){var G__29951 = ctx;
var G__29952 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29951,G__29952) : sci.impl.interpreter.interpret.call(null,G__29951,G__29952));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg29714 = (function (){var G__29953 = ctx;
var G__29954 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29953,G__29954) : sci.impl.interpreter.interpret.call(null,G__29953,G__29954));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg29715 = (function (){var G__29955 = ctx;
var G__29956 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29955,G__29956) : sci.impl.interpreter.interpret.call(null,G__29955,G__29956));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg29716 = (function (){var G__29957 = ctx;
var G__29958 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29957,G__29958) : sci.impl.interpreter.interpret.call(null,G__29957,G__29958));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg29717 = (function (){var G__29959 = ctx;
var G__29960 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29959,G__29960) : sci.impl.interpreter.interpret.call(null,G__29959,G__29960));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg29718 = (function (){var G__29961 = ctx;
var G__29962 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29961,G__29962) : sci.impl.interpreter.interpret.call(null,G__29961,G__29962));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg29719 = (function (){var G__29963 = ctx;
var G__29964 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29963,G__29964) : sci.impl.interpreter.interpret.call(null,G__29963,G__29964));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg29720 = (function (){var G__29965 = ctx;
var G__29966 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29965,G__29966) : sci.impl.interpreter.interpret.call(null,G__29965,G__29966));
})();
var args__$10 = cljs.core.rest(args__$9);
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(arg29711,arg29712,arg29713,arg29714,arg29715,arg29716,arg29717,arg29718,arg29719,arg29720) : f.call(null,arg29711,arg29712,arg29713,arg29714,arg29715,arg29716,arg29717,arg29718,arg29719,arg29720));

break;
case (11):
var arg29721 = (function (){var G__29967 = ctx;
var G__29968 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29967,G__29968) : sci.impl.interpreter.interpret.call(null,G__29967,G__29968));
})();
var args__$1 = cljs.core.rest(args);
var arg29722 = (function (){var G__29969 = ctx;
var G__29970 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29969,G__29970) : sci.impl.interpreter.interpret.call(null,G__29969,G__29970));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg29723 = (function (){var G__29971 = ctx;
var G__29972 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29971,G__29972) : sci.impl.interpreter.interpret.call(null,G__29971,G__29972));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg29724 = (function (){var G__29973 = ctx;
var G__29974 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29973,G__29974) : sci.impl.interpreter.interpret.call(null,G__29973,G__29974));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg29725 = (function (){var G__29975 = ctx;
var G__29976 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29975,G__29976) : sci.impl.interpreter.interpret.call(null,G__29975,G__29976));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg29726 = (function (){var G__29977 = ctx;
var G__29978 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29977,G__29978) : sci.impl.interpreter.interpret.call(null,G__29977,G__29978));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg29727 = (function (){var G__29979 = ctx;
var G__29980 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29979,G__29980) : sci.impl.interpreter.interpret.call(null,G__29979,G__29980));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg29728 = (function (){var G__29981 = ctx;
var G__29982 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29981,G__29982) : sci.impl.interpreter.interpret.call(null,G__29981,G__29982));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg29729 = (function (){var G__29983 = ctx;
var G__29984 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29983,G__29984) : sci.impl.interpreter.interpret.call(null,G__29983,G__29984));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg29730 = (function (){var G__29985 = ctx;
var G__29986 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29985,G__29986) : sci.impl.interpreter.interpret.call(null,G__29985,G__29986));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg29731 = (function (){var G__29987 = ctx;
var G__29988 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29987,G__29988) : sci.impl.interpreter.interpret.call(null,G__29987,G__29988));
})();
var args__$11 = cljs.core.rest(args__$10);
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(arg29721,arg29722,arg29723,arg29724,arg29725,arg29726,arg29727,arg29728,arg29729,arg29730,arg29731) : f.call(null,arg29721,arg29722,arg29723,arg29724,arg29725,arg29726,arg29727,arg29728,arg29729,arg29730,arg29731));

break;
case (12):
var arg29732 = (function (){var G__29989 = ctx;
var G__29990 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29989,G__29990) : sci.impl.interpreter.interpret.call(null,G__29989,G__29990));
})();
var args__$1 = cljs.core.rest(args);
var arg29733 = (function (){var G__29991 = ctx;
var G__29992 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29991,G__29992) : sci.impl.interpreter.interpret.call(null,G__29991,G__29992));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg29734 = (function (){var G__29993 = ctx;
var G__29994 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29993,G__29994) : sci.impl.interpreter.interpret.call(null,G__29993,G__29994));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg29735 = (function (){var G__29995 = ctx;
var G__29996 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29995,G__29996) : sci.impl.interpreter.interpret.call(null,G__29995,G__29996));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg29736 = (function (){var G__29997 = ctx;
var G__29998 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29997,G__29998) : sci.impl.interpreter.interpret.call(null,G__29997,G__29998));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg29737 = (function (){var G__29999 = ctx;
var G__30000 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__29999,G__30000) : sci.impl.interpreter.interpret.call(null,G__29999,G__30000));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg29738 = (function (){var G__30001 = ctx;
var G__30002 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30001,G__30002) : sci.impl.interpreter.interpret.call(null,G__30001,G__30002));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg29739 = (function (){var G__30003 = ctx;
var G__30004 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30003,G__30004) : sci.impl.interpreter.interpret.call(null,G__30003,G__30004));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg29740 = (function (){var G__30005 = ctx;
var G__30006 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30005,G__30006) : sci.impl.interpreter.interpret.call(null,G__30005,G__30006));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg29741 = (function (){var G__30007 = ctx;
var G__30008 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30007,G__30008) : sci.impl.interpreter.interpret.call(null,G__30007,G__30008));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg29742 = (function (){var G__30009 = ctx;
var G__30010 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30009,G__30010) : sci.impl.interpreter.interpret.call(null,G__30009,G__30010));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg29743 = (function (){var G__30011 = ctx;
var G__30012 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30011,G__30012) : sci.impl.interpreter.interpret.call(null,G__30011,G__30012));
})();
var args__$12 = cljs.core.rest(args__$11);
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(arg29732,arg29733,arg29734,arg29735,arg29736,arg29737,arg29738,arg29739,arg29740,arg29741,arg29742,arg29743) : f.call(null,arg29732,arg29733,arg29734,arg29735,arg29736,arg29737,arg29738,arg29739,arg29740,arg29741,arg29742,arg29743));

break;
case (13):
var arg29744 = (function (){var G__30013 = ctx;
var G__30014 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30013,G__30014) : sci.impl.interpreter.interpret.call(null,G__30013,G__30014));
})();
var args__$1 = cljs.core.rest(args);
var arg29745 = (function (){var G__30015 = ctx;
var G__30016 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30015,G__30016) : sci.impl.interpreter.interpret.call(null,G__30015,G__30016));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg29746 = (function (){var G__30017 = ctx;
var G__30018 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30017,G__30018) : sci.impl.interpreter.interpret.call(null,G__30017,G__30018));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg29747 = (function (){var G__30019 = ctx;
var G__30020 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30019,G__30020) : sci.impl.interpreter.interpret.call(null,G__30019,G__30020));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg29748 = (function (){var G__30021 = ctx;
var G__30022 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30021,G__30022) : sci.impl.interpreter.interpret.call(null,G__30021,G__30022));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg29749 = (function (){var G__30023 = ctx;
var G__30024 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30023,G__30024) : sci.impl.interpreter.interpret.call(null,G__30023,G__30024));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg29750 = (function (){var G__30025 = ctx;
var G__30026 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30025,G__30026) : sci.impl.interpreter.interpret.call(null,G__30025,G__30026));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg29751 = (function (){var G__30027 = ctx;
var G__30028 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30027,G__30028) : sci.impl.interpreter.interpret.call(null,G__30027,G__30028));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg29752 = (function (){var G__30029 = ctx;
var G__30030 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30029,G__30030) : sci.impl.interpreter.interpret.call(null,G__30029,G__30030));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg29753 = (function (){var G__30031 = ctx;
var G__30032 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30031,G__30032) : sci.impl.interpreter.interpret.call(null,G__30031,G__30032));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg29754 = (function (){var G__30033 = ctx;
var G__30034 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30033,G__30034) : sci.impl.interpreter.interpret.call(null,G__30033,G__30034));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg29755 = (function (){var G__30035 = ctx;
var G__30036 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30035,G__30036) : sci.impl.interpreter.interpret.call(null,G__30035,G__30036));
})();
var args__$12 = cljs.core.rest(args__$11);
var arg29756 = (function (){var G__30037 = ctx;
var G__30038 = cljs.core.first(args__$12);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30037,G__30038) : sci.impl.interpreter.interpret.call(null,G__30037,G__30038));
})();
var args__$13 = cljs.core.rest(args__$12);
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(arg29744,arg29745,arg29746,arg29747,arg29748,arg29749,arg29750,arg29751,arg29752,arg29753,arg29754,arg29755,arg29756) : f.call(null,arg29744,arg29745,arg29746,arg29747,arg29748,arg29749,arg29750,arg29751,arg29752,arg29753,arg29754,arg29755,arg29756));

break;
case (14):
var arg29757 = (function (){var G__30039 = ctx;
var G__30040 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30039,G__30040) : sci.impl.interpreter.interpret.call(null,G__30039,G__30040));
})();
var args__$1 = cljs.core.rest(args);
var arg29758 = (function (){var G__30041 = ctx;
var G__30042 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30041,G__30042) : sci.impl.interpreter.interpret.call(null,G__30041,G__30042));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg29759 = (function (){var G__30043 = ctx;
var G__30044 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30043,G__30044) : sci.impl.interpreter.interpret.call(null,G__30043,G__30044));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg29760 = (function (){var G__30045 = ctx;
var G__30046 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30045,G__30046) : sci.impl.interpreter.interpret.call(null,G__30045,G__30046));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg29761 = (function (){var G__30047 = ctx;
var G__30048 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30047,G__30048) : sci.impl.interpreter.interpret.call(null,G__30047,G__30048));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg29762 = (function (){var G__30049 = ctx;
var G__30050 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30049,G__30050) : sci.impl.interpreter.interpret.call(null,G__30049,G__30050));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg29763 = (function (){var G__30051 = ctx;
var G__30052 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30051,G__30052) : sci.impl.interpreter.interpret.call(null,G__30051,G__30052));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg29764 = (function (){var G__30053 = ctx;
var G__30054 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30053,G__30054) : sci.impl.interpreter.interpret.call(null,G__30053,G__30054));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg29765 = (function (){var G__30055 = ctx;
var G__30056 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30055,G__30056) : sci.impl.interpreter.interpret.call(null,G__30055,G__30056));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg29766 = (function (){var G__30057 = ctx;
var G__30058 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30057,G__30058) : sci.impl.interpreter.interpret.call(null,G__30057,G__30058));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg29767 = (function (){var G__30059 = ctx;
var G__30060 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30059,G__30060) : sci.impl.interpreter.interpret.call(null,G__30059,G__30060));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg29768 = (function (){var G__30061 = ctx;
var G__30062 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30061,G__30062) : sci.impl.interpreter.interpret.call(null,G__30061,G__30062));
})();
var args__$12 = cljs.core.rest(args__$11);
var arg29769 = (function (){var G__30063 = ctx;
var G__30064 = cljs.core.first(args__$12);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30063,G__30064) : sci.impl.interpreter.interpret.call(null,G__30063,G__30064));
})();
var args__$13 = cljs.core.rest(args__$12);
var arg29770 = (function (){var G__30065 = ctx;
var G__30066 = cljs.core.first(args__$13);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30065,G__30066) : sci.impl.interpreter.interpret.call(null,G__30065,G__30066));
})();
var args__$14 = cljs.core.rest(args__$13);
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(arg29757,arg29758,arg29759,arg29760,arg29761,arg29762,arg29763,arg29764,arg29765,arg29766,arg29767,arg29768,arg29769,arg29770) : f.call(null,arg29757,arg29758,arg29759,arg29760,arg29761,arg29762,arg29763,arg29764,arg29765,arg29766,arg29767,arg29768,arg29769,arg29770));

break;
case (15):
var arg29771 = (function (){var G__30067 = ctx;
var G__30068 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30067,G__30068) : sci.impl.interpreter.interpret.call(null,G__30067,G__30068));
})();
var args__$1 = cljs.core.rest(args);
var arg29772 = (function (){var G__30069 = ctx;
var G__30070 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30069,G__30070) : sci.impl.interpreter.interpret.call(null,G__30069,G__30070));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg29773 = (function (){var G__30071 = ctx;
var G__30072 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30071,G__30072) : sci.impl.interpreter.interpret.call(null,G__30071,G__30072));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg29774 = (function (){var G__30073 = ctx;
var G__30074 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30073,G__30074) : sci.impl.interpreter.interpret.call(null,G__30073,G__30074));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg29775 = (function (){var G__30075 = ctx;
var G__30076 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30075,G__30076) : sci.impl.interpreter.interpret.call(null,G__30075,G__30076));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg29776 = (function (){var G__30077 = ctx;
var G__30078 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30077,G__30078) : sci.impl.interpreter.interpret.call(null,G__30077,G__30078));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg29777 = (function (){var G__30079 = ctx;
var G__30080 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30079,G__30080) : sci.impl.interpreter.interpret.call(null,G__30079,G__30080));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg29778 = (function (){var G__30081 = ctx;
var G__30082 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30081,G__30082) : sci.impl.interpreter.interpret.call(null,G__30081,G__30082));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg29779 = (function (){var G__30083 = ctx;
var G__30084 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30083,G__30084) : sci.impl.interpreter.interpret.call(null,G__30083,G__30084));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg29780 = (function (){var G__30085 = ctx;
var G__30086 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30085,G__30086) : sci.impl.interpreter.interpret.call(null,G__30085,G__30086));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg29781 = (function (){var G__30087 = ctx;
var G__30088 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30087,G__30088) : sci.impl.interpreter.interpret.call(null,G__30087,G__30088));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg29782 = (function (){var G__30089 = ctx;
var G__30090 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30089,G__30090) : sci.impl.interpreter.interpret.call(null,G__30089,G__30090));
})();
var args__$12 = cljs.core.rest(args__$11);
var arg29783 = (function (){var G__30091 = ctx;
var G__30092 = cljs.core.first(args__$12);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30091,G__30092) : sci.impl.interpreter.interpret.call(null,G__30091,G__30092));
})();
var args__$13 = cljs.core.rest(args__$12);
var arg29784 = (function (){var G__30093 = ctx;
var G__30094 = cljs.core.first(args__$13);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30093,G__30094) : sci.impl.interpreter.interpret.call(null,G__30093,G__30094));
})();
var args__$14 = cljs.core.rest(args__$13);
var arg29785 = (function (){var G__30095 = ctx;
var G__30096 = cljs.core.first(args__$14);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30095,G__30096) : sci.impl.interpreter.interpret.call(null,G__30095,G__30096));
})();
var args__$15 = cljs.core.rest(args__$14);
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(arg29771,arg29772,arg29773,arg29774,arg29775,arg29776,arg29777,arg29778,arg29779,arg29780,arg29781,arg29782,arg29783,arg29784,arg29785) : f.call(null,arg29771,arg29772,arg29773,arg29774,arg29775,arg29776,arg29777,arg29778,arg29779,arg29780,arg29781,arg29782,arg29783,arg29784,arg29785));

break;
case (16):
var arg29786 = (function (){var G__30097 = ctx;
var G__30098 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30097,G__30098) : sci.impl.interpreter.interpret.call(null,G__30097,G__30098));
})();
var args__$1 = cljs.core.rest(args);
var arg29787 = (function (){var G__30099 = ctx;
var G__30100 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30099,G__30100) : sci.impl.interpreter.interpret.call(null,G__30099,G__30100));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg29788 = (function (){var G__30101 = ctx;
var G__30102 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30101,G__30102) : sci.impl.interpreter.interpret.call(null,G__30101,G__30102));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg29789 = (function (){var G__30103 = ctx;
var G__30104 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30103,G__30104) : sci.impl.interpreter.interpret.call(null,G__30103,G__30104));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg29790 = (function (){var G__30105 = ctx;
var G__30106 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30105,G__30106) : sci.impl.interpreter.interpret.call(null,G__30105,G__30106));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg29791 = (function (){var G__30107 = ctx;
var G__30108 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30107,G__30108) : sci.impl.interpreter.interpret.call(null,G__30107,G__30108));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg29792 = (function (){var G__30109 = ctx;
var G__30110 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30109,G__30110) : sci.impl.interpreter.interpret.call(null,G__30109,G__30110));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg29793 = (function (){var G__30111 = ctx;
var G__30112 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30111,G__30112) : sci.impl.interpreter.interpret.call(null,G__30111,G__30112));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg29794 = (function (){var G__30113 = ctx;
var G__30114 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30113,G__30114) : sci.impl.interpreter.interpret.call(null,G__30113,G__30114));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg29795 = (function (){var G__30115 = ctx;
var G__30116 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30115,G__30116) : sci.impl.interpreter.interpret.call(null,G__30115,G__30116));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg29796 = (function (){var G__30117 = ctx;
var G__30118 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30117,G__30118) : sci.impl.interpreter.interpret.call(null,G__30117,G__30118));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg29797 = (function (){var G__30119 = ctx;
var G__30120 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30119,G__30120) : sci.impl.interpreter.interpret.call(null,G__30119,G__30120));
})();
var args__$12 = cljs.core.rest(args__$11);
var arg29798 = (function (){var G__30121 = ctx;
var G__30122 = cljs.core.first(args__$12);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30121,G__30122) : sci.impl.interpreter.interpret.call(null,G__30121,G__30122));
})();
var args__$13 = cljs.core.rest(args__$12);
var arg29799 = (function (){var G__30123 = ctx;
var G__30124 = cljs.core.first(args__$13);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30123,G__30124) : sci.impl.interpreter.interpret.call(null,G__30123,G__30124));
})();
var args__$14 = cljs.core.rest(args__$13);
var arg29800 = (function (){var G__30125 = ctx;
var G__30126 = cljs.core.first(args__$14);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30125,G__30126) : sci.impl.interpreter.interpret.call(null,G__30125,G__30126));
})();
var args__$15 = cljs.core.rest(args__$14);
var arg29801 = (function (){var G__30127 = ctx;
var G__30128 = cljs.core.first(args__$15);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30127,G__30128) : sci.impl.interpreter.interpret.call(null,G__30127,G__30128));
})();
var args__$16 = cljs.core.rest(args__$15);
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(arg29786,arg29787,arg29788,arg29789,arg29790,arg29791,arg29792,arg29793,arg29794,arg29795,arg29796,arg29797,arg29798,arg29799,arg29800,arg29801) : f.call(null,arg29786,arg29787,arg29788,arg29789,arg29790,arg29791,arg29792,arg29793,arg29794,arg29795,arg29796,arg29797,arg29798,arg29799,arg29800,arg29801));

break;
case (17):
var arg29802 = (function (){var G__30129 = ctx;
var G__30130 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30129,G__30130) : sci.impl.interpreter.interpret.call(null,G__30129,G__30130));
})();
var args__$1 = cljs.core.rest(args);
var arg29803 = (function (){var G__30131 = ctx;
var G__30132 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30131,G__30132) : sci.impl.interpreter.interpret.call(null,G__30131,G__30132));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg29804 = (function (){var G__30133 = ctx;
var G__30134 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30133,G__30134) : sci.impl.interpreter.interpret.call(null,G__30133,G__30134));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg29805 = (function (){var G__30135 = ctx;
var G__30136 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30135,G__30136) : sci.impl.interpreter.interpret.call(null,G__30135,G__30136));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg29806 = (function (){var G__30137 = ctx;
var G__30138 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30137,G__30138) : sci.impl.interpreter.interpret.call(null,G__30137,G__30138));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg29807 = (function (){var G__30139 = ctx;
var G__30140 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30139,G__30140) : sci.impl.interpreter.interpret.call(null,G__30139,G__30140));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg29808 = (function (){var G__30141 = ctx;
var G__30142 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30141,G__30142) : sci.impl.interpreter.interpret.call(null,G__30141,G__30142));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg29809 = (function (){var G__30143 = ctx;
var G__30144 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30143,G__30144) : sci.impl.interpreter.interpret.call(null,G__30143,G__30144));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg29810 = (function (){var G__30145 = ctx;
var G__30146 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30145,G__30146) : sci.impl.interpreter.interpret.call(null,G__30145,G__30146));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg29811 = (function (){var G__30147 = ctx;
var G__30148 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30147,G__30148) : sci.impl.interpreter.interpret.call(null,G__30147,G__30148));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg29812 = (function (){var G__30149 = ctx;
var G__30150 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30149,G__30150) : sci.impl.interpreter.interpret.call(null,G__30149,G__30150));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg29813 = (function (){var G__30151 = ctx;
var G__30152 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30151,G__30152) : sci.impl.interpreter.interpret.call(null,G__30151,G__30152));
})();
var args__$12 = cljs.core.rest(args__$11);
var arg29814 = (function (){var G__30153 = ctx;
var G__30154 = cljs.core.first(args__$12);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30153,G__30154) : sci.impl.interpreter.interpret.call(null,G__30153,G__30154));
})();
var args__$13 = cljs.core.rest(args__$12);
var arg29815 = (function (){var G__30155 = ctx;
var G__30156 = cljs.core.first(args__$13);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30155,G__30156) : sci.impl.interpreter.interpret.call(null,G__30155,G__30156));
})();
var args__$14 = cljs.core.rest(args__$13);
var arg29816 = (function (){var G__30157 = ctx;
var G__30158 = cljs.core.first(args__$14);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30157,G__30158) : sci.impl.interpreter.interpret.call(null,G__30157,G__30158));
})();
var args__$15 = cljs.core.rest(args__$14);
var arg29817 = (function (){var G__30159 = ctx;
var G__30160 = cljs.core.first(args__$15);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30159,G__30160) : sci.impl.interpreter.interpret.call(null,G__30159,G__30160));
})();
var args__$16 = cljs.core.rest(args__$15);
var arg29818 = (function (){var G__30161 = ctx;
var G__30162 = cljs.core.first(args__$16);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30161,G__30162) : sci.impl.interpreter.interpret.call(null,G__30161,G__30162));
})();
var args__$17 = cljs.core.rest(args__$16);
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(arg29802,arg29803,arg29804,arg29805,arg29806,arg29807,arg29808,arg29809,arg29810,arg29811,arg29812,arg29813,arg29814,arg29815,arg29816,arg29817,arg29818) : f.call(null,arg29802,arg29803,arg29804,arg29805,arg29806,arg29807,arg29808,arg29809,arg29810,arg29811,arg29812,arg29813,arg29814,arg29815,arg29816,arg29817,arg29818));

break;
case (18):
var arg29819 = (function (){var G__30163 = ctx;
var G__30164 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30163,G__30164) : sci.impl.interpreter.interpret.call(null,G__30163,G__30164));
})();
var args__$1 = cljs.core.rest(args);
var arg29820 = (function (){var G__30165 = ctx;
var G__30166 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30165,G__30166) : sci.impl.interpreter.interpret.call(null,G__30165,G__30166));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg29821 = (function (){var G__30167 = ctx;
var G__30168 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30167,G__30168) : sci.impl.interpreter.interpret.call(null,G__30167,G__30168));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg29822 = (function (){var G__30169 = ctx;
var G__30170 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30169,G__30170) : sci.impl.interpreter.interpret.call(null,G__30169,G__30170));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg29823 = (function (){var G__30171 = ctx;
var G__30172 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30171,G__30172) : sci.impl.interpreter.interpret.call(null,G__30171,G__30172));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg29824 = (function (){var G__30173 = ctx;
var G__30174 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30173,G__30174) : sci.impl.interpreter.interpret.call(null,G__30173,G__30174));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg29825 = (function (){var G__30175 = ctx;
var G__30176 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30175,G__30176) : sci.impl.interpreter.interpret.call(null,G__30175,G__30176));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg29826 = (function (){var G__30177 = ctx;
var G__30178 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30177,G__30178) : sci.impl.interpreter.interpret.call(null,G__30177,G__30178));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg29827 = (function (){var G__30179 = ctx;
var G__30180 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30179,G__30180) : sci.impl.interpreter.interpret.call(null,G__30179,G__30180));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg29828 = (function (){var G__30181 = ctx;
var G__30182 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30181,G__30182) : sci.impl.interpreter.interpret.call(null,G__30181,G__30182));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg29829 = (function (){var G__30183 = ctx;
var G__30184 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30183,G__30184) : sci.impl.interpreter.interpret.call(null,G__30183,G__30184));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg29830 = (function (){var G__30185 = ctx;
var G__30186 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30185,G__30186) : sci.impl.interpreter.interpret.call(null,G__30185,G__30186));
})();
var args__$12 = cljs.core.rest(args__$11);
var arg29831 = (function (){var G__30187 = ctx;
var G__30188 = cljs.core.first(args__$12);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30187,G__30188) : sci.impl.interpreter.interpret.call(null,G__30187,G__30188));
})();
var args__$13 = cljs.core.rest(args__$12);
var arg29832 = (function (){var G__30189 = ctx;
var G__30190 = cljs.core.first(args__$13);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30189,G__30190) : sci.impl.interpreter.interpret.call(null,G__30189,G__30190));
})();
var args__$14 = cljs.core.rest(args__$13);
var arg29833 = (function (){var G__30191 = ctx;
var G__30192 = cljs.core.first(args__$14);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30191,G__30192) : sci.impl.interpreter.interpret.call(null,G__30191,G__30192));
})();
var args__$15 = cljs.core.rest(args__$14);
var arg29834 = (function (){var G__30193 = ctx;
var G__30194 = cljs.core.first(args__$15);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30193,G__30194) : sci.impl.interpreter.interpret.call(null,G__30193,G__30194));
})();
var args__$16 = cljs.core.rest(args__$15);
var arg29835 = (function (){var G__30195 = ctx;
var G__30196 = cljs.core.first(args__$16);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30195,G__30196) : sci.impl.interpreter.interpret.call(null,G__30195,G__30196));
})();
var args__$17 = cljs.core.rest(args__$16);
var arg29836 = (function (){var G__30197 = ctx;
var G__30198 = cljs.core.first(args__$17);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30197,G__30198) : sci.impl.interpreter.interpret.call(null,G__30197,G__30198));
})();
var args__$18 = cljs.core.rest(args__$17);
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(arg29819,arg29820,arg29821,arg29822,arg29823,arg29824,arg29825,arg29826,arg29827,arg29828,arg29829,arg29830,arg29831,arg29832,arg29833,arg29834,arg29835,arg29836) : f.call(null,arg29819,arg29820,arg29821,arg29822,arg29823,arg29824,arg29825,arg29826,arg29827,arg29828,arg29829,arg29830,arg29831,arg29832,arg29833,arg29834,arg29835,arg29836));

break;
case (19):
var arg29837 = (function (){var G__30199 = ctx;
var G__30200 = cljs.core.first(args);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30199,G__30200) : sci.impl.interpreter.interpret.call(null,G__30199,G__30200));
})();
var args__$1 = cljs.core.rest(args);
var arg29838 = (function (){var G__30201 = ctx;
var G__30202 = cljs.core.first(args__$1);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30201,G__30202) : sci.impl.interpreter.interpret.call(null,G__30201,G__30202));
})();
var args__$2 = cljs.core.rest(args__$1);
var arg29839 = (function (){var G__30203 = ctx;
var G__30204 = cljs.core.first(args__$2);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30203,G__30204) : sci.impl.interpreter.interpret.call(null,G__30203,G__30204));
})();
var args__$3 = cljs.core.rest(args__$2);
var arg29840 = (function (){var G__30205 = ctx;
var G__30206 = cljs.core.first(args__$3);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30205,G__30206) : sci.impl.interpreter.interpret.call(null,G__30205,G__30206));
})();
var args__$4 = cljs.core.rest(args__$3);
var arg29841 = (function (){var G__30207 = ctx;
var G__30208 = cljs.core.first(args__$4);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30207,G__30208) : sci.impl.interpreter.interpret.call(null,G__30207,G__30208));
})();
var args__$5 = cljs.core.rest(args__$4);
var arg29842 = (function (){var G__30209 = ctx;
var G__30210 = cljs.core.first(args__$5);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30209,G__30210) : sci.impl.interpreter.interpret.call(null,G__30209,G__30210));
})();
var args__$6 = cljs.core.rest(args__$5);
var arg29843 = (function (){var G__30211 = ctx;
var G__30212 = cljs.core.first(args__$6);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30211,G__30212) : sci.impl.interpreter.interpret.call(null,G__30211,G__30212));
})();
var args__$7 = cljs.core.rest(args__$6);
var arg29844 = (function (){var G__30213 = ctx;
var G__30214 = cljs.core.first(args__$7);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30213,G__30214) : sci.impl.interpreter.interpret.call(null,G__30213,G__30214));
})();
var args__$8 = cljs.core.rest(args__$7);
var arg29845 = (function (){var G__30215 = ctx;
var G__30216 = cljs.core.first(args__$8);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30215,G__30216) : sci.impl.interpreter.interpret.call(null,G__30215,G__30216));
})();
var args__$9 = cljs.core.rest(args__$8);
var arg29846 = (function (){var G__30217 = ctx;
var G__30218 = cljs.core.first(args__$9);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30217,G__30218) : sci.impl.interpreter.interpret.call(null,G__30217,G__30218));
})();
var args__$10 = cljs.core.rest(args__$9);
var arg29847 = (function (){var G__30219 = ctx;
var G__30220 = cljs.core.first(args__$10);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30219,G__30220) : sci.impl.interpreter.interpret.call(null,G__30219,G__30220));
})();
var args__$11 = cljs.core.rest(args__$10);
var arg29848 = (function (){var G__30221 = ctx;
var G__30222 = cljs.core.first(args__$11);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30221,G__30222) : sci.impl.interpreter.interpret.call(null,G__30221,G__30222));
})();
var args__$12 = cljs.core.rest(args__$11);
var arg29849 = (function (){var G__30223 = ctx;
var G__30224 = cljs.core.first(args__$12);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30223,G__30224) : sci.impl.interpreter.interpret.call(null,G__30223,G__30224));
})();
var args__$13 = cljs.core.rest(args__$12);
var arg29850 = (function (){var G__30225 = ctx;
var G__30226 = cljs.core.first(args__$13);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30225,G__30226) : sci.impl.interpreter.interpret.call(null,G__30225,G__30226));
})();
var args__$14 = cljs.core.rest(args__$13);
var arg29851 = (function (){var G__30227 = ctx;
var G__30228 = cljs.core.first(args__$14);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30227,G__30228) : sci.impl.interpreter.interpret.call(null,G__30227,G__30228));
})();
var args__$15 = cljs.core.rest(args__$14);
var arg29852 = (function (){var G__30229 = ctx;
var G__30230 = cljs.core.first(args__$15);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30229,G__30230) : sci.impl.interpreter.interpret.call(null,G__30229,G__30230));
})();
var args__$16 = cljs.core.rest(args__$15);
var arg29853 = (function (){var G__30231 = ctx;
var G__30232 = cljs.core.first(args__$16);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30231,G__30232) : sci.impl.interpreter.interpret.call(null,G__30231,G__30232));
})();
var args__$17 = cljs.core.rest(args__$16);
var arg29854 = (function (){var G__30233 = ctx;
var G__30234 = cljs.core.first(args__$17);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30233,G__30234) : sci.impl.interpreter.interpret.call(null,G__30233,G__30234));
})();
var args__$18 = cljs.core.rest(args__$17);
var arg29855 = (function (){var G__30235 = ctx;
var G__30236 = cljs.core.first(args__$18);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30235,G__30236) : sci.impl.interpreter.interpret.call(null,G__30235,G__30236));
})();
var args__$19 = cljs.core.rest(args__$18);
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(arg29837,arg29838,arg29839,arg29840,arg29841,arg29842,arg29843,arg29844,arg29845,arg29846,arg29847,arg29848,arg29849,arg29850,arg29851,arg29852,arg29853,arg29854,arg29855) : f.call(null,arg29837,arg29838,arg29839,arg29840,arg29841,arg29842,arg29843,arg29844,arg29845,arg29846,arg29847,arg29848,arg29849,arg29850,arg29851,arg29852,arg29853,arg29854,arg29855));

break;
default:
var args__$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__2704_SHARP_){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,p1__2704_SHARP_) : sci.impl.interpreter.interpret.call(null,ctx,p1__2704_SHARP_));
}),args);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args__$1);

}
});
sci.impl.interpreter.eval_special_call = (function sci$impl$interpreter$eval_special_call(ctx,f_sym,expr){
var G__30237 = sci.impl.utils.strip_core_ns(f_sym);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,".",".",1975675962,null),G__30237)){
if(cljs.core.truth_(ctx.get(new cljs.core.Keyword(null,"dry-run","dry-run",-1102788647)))){
return null;
} else {
return sci.impl.interpreter.eval_instance_method_invocation(ctx,expr);
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"and","and",668631710,null),G__30237)){
return sci.impl.interpreter.eval_and(ctx,cljs.core.rest(expr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"case","case",-1510733573,null),G__30237)){
return sci.impl.interpreter.eval_case(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"if","if",1181717262,null),G__30237)){
return sci.impl.interpreter.eval_if(ctx,cljs.core.rest(expr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"do","do",1686842252,null),G__30237)){
return sci.impl.interpreter.eval_do(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"macroexpand","macroexpand",1509933344,null),G__30237)){
return sci.impl.interpreter.macroexpand(ctx,(function (){var G__30238 = ctx;
var G__30239 = cljs.core.second(expr);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30238,G__30239) : sci.impl.interpreter.interpret.call(null,G__30238,G__30239));
})());
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"def","def",597100991,null),G__30237)){
return sci.impl.interpreter.eval_def(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"let","let",358118826,null),G__30237)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(sci.impl.interpreter.eval_let,ctx,cljs.core.rest(expr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"in-ns","in-ns",-2089468466,null),G__30237)){
return sci.impl.interpreter.eval_in_ns(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"use","use",-205850897,null),G__30237)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(sci.impl.interpreter.eval_use,ctx,cljs.core.rest(expr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"set!","set!",250714521,null),G__30237)){
return sci.impl.interpreter.eval_set_BANG_(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"recur","recur",1202958259,null),G__30237)){
return sci.impl.interpreter.fn_call(ctx,cljs.core.comp.cljs$core$IFn$_invoke$arity$2(sci.impl.fns.__GT_Recur,cljs.core.vector),cljs.core.rest(expr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"require","require",1172530194,null),G__30237)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(sci.impl.interpreter.eval_require,ctx,cljs.core.rest(expr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"new","new",-444906321,null),G__30237)){
if(cljs.core.truth_(ctx.get(new cljs.core.Keyword(null,"dry-run","dry-run",-1102788647)))){
return null;
} else {
return sci.impl.interpreter.eval_constructor_invocation(ctx,expr);
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"macroexpand-1","macroexpand-1",659241329,null),G__30237)){
return sci.impl.interpreter.macroexpand_1(ctx,(function (){var G__30240 = ctx;
var G__30241 = cljs.core.second(expr);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30240,G__30241) : sci.impl.interpreter.interpret.call(null,G__30240,G__30241));
})());
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"refer","refer",676235974,null),G__30237)){
return sci.impl.interpreter.eval_refer(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"lazy-seq","lazy-seq",489632906,null),G__30237)){
return (new cljs.core.LazySeq(null,(function (){var G__30242 = ctx;
var G__30243 = cljs.core.second(expr);
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(G__30242,G__30243) : sci.impl.interpreter.interpret.call(null,G__30242,G__30243));
})(),null,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"throw","throw",595905694,null),G__30237)){
return sci.impl.interpreter.eval_throw(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"try","try",-1273693247,null),G__30237)){
return sci.impl.interpreter.eval_try(ctx,expr);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"resolve","resolve",56086045,null),G__30237)){
return sci.impl.interpreter.eval_resolve(ctx,cljs.core.second(expr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"or","or",1876275696,null),G__30237)){
return sci.impl.interpreter.eval_or(ctx,cljs.core.rest(expr));
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30237)].join('')));

}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
sci.impl.interpreter.eval_call = (function sci$impl$interpreter$eval_call(ctx,expr){
try{var f = cljs.core.first(expr);
var m = cljs.core.meta(f);
var op = (cljs.core.truth_(m)?m.get(new cljs.core.Keyword("sci.impl","op","sci.impl/op",950953978)):null);
if((((f instanceof cljs.core.Symbol)) && (cljs.core.not(op)))){
return sci.impl.interpreter.eval_special_call(ctx,f,expr);
} else {
if(cljs.core.truth_((sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"static-access","static-access",-1860919441)) : sci.impl.utils.kw_identical_QMARK_.call(null,op,new cljs.core.Keyword(null,"static-access","static-access",-1860919441))))){
if(cljs.core.truth_(ctx.get(new cljs.core.Keyword(null,"dry-run","dry-run",-1102788647)))){
return null;
} else {
return sci.impl.interpreter.eval_static_method_invocation(ctx,expr);
}
} else {
var f__$1 = (cljs.core.truth_(op)?(sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,f) : sci.impl.interpreter.interpret.call(null,ctx,f)):f);
if(cljs.core.ifn_QMARK_(f__$1)){
if(cljs.core.truth_(ctx.get(new cljs.core.Keyword(null,"dry-run","dry-run",-1102788647)))){
return null;
} else {
return sci.impl.interpreter.fn_call(ctx,f__$1,cljs.core.rest(expr));
}
} else {
throw (new Error(["Cannot call ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([f__$1], 0))," as a function."].join('')));
}

}
}
}catch (e30244){if((e30244 instanceof Error)){
var e = e30244;
return sci.impl.utils.rethrow_with_location_of_node(ctx,e,expr);
} else {
throw e30244;

}
}});
sci.impl.interpreter.fix_meta = (function sci$impl$interpreter$fix_meta(v,old_meta){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(v);
if(cljs.core.truth_(and__4115__auto__)){
return (((!(sci.impl.vars.var_QMARK_(v)))) && ((!(sci.impl.vars.namespace_QMARK_(v)))));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2(v,(function (m){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,new cljs.core.Keyword("sci.impl","op","sci.impl/op",950953978)),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(old_meta));
}));
} else {
return v;
}
});
sci.impl.interpreter.interpret = (function sci$impl$interpreter$interpret(ctx,expr){
if((expr instanceof sci.impl.types.EvalVar)){
var v = expr.sci$impl$types$IBox$getVal$arity$1(null);
if(cljs.core.not(sci.impl.vars.isMacro(v))){
return cljs.core.deref(v);
} else {
throw (new Error(["Can't take value of a macro: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(v),""].join('')));
}
} else {
var m = cljs.core.meta(expr);
var op = (cljs.core.truth_(m)?m.get(new cljs.core.Keyword("sci.impl","op","sci.impl/op",950953978)):null);
var ret = ((cljs.core.not(op))?expr:(function (){var G__30248 = op;
var G__30248__$1 = (((G__30248 instanceof cljs.core.Keyword))?G__30248.fqn:null);
switch (G__30248__$1) {
case "call":
return sci.impl.interpreter.eval_call(ctx,expr);

break;
case "try":
return sci.impl.interpreter.eval_try(ctx,expr);

break;
case "fn":
return sci.impl.fns.eval_fn(ctx,sci.impl.interpreter.interpret,sci.impl.interpreter.eval_do_STAR_,expr);

break;
case "static-access":
return sci.impl.interop.get_static_field(expr);

break;
case "var-value":
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(expr,(0));

break;
case "deref!":
var v = cljs.core.first(expr);
var v__$1 = ((sci.impl.vars.var_QMARK_(v))?cljs.core.deref(v):v);
var v__$2 = cljs.core.force(v__$1);
return v__$2;

break;
case "resolve-sym":
return sci.impl.interpreter.resolve_symbol(ctx,expr);

break;
case "needs-ctx":
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2(expr,ctx);

break;
default:
if(cljs.core.map_QMARK_(expr)){
return cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30245_SHARP_){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,p1__30245_SHARP_) : sci.impl.interpreter.interpret.call(null,ctx,p1__30245_SHARP_));
}),cljs.core.keys(expr)),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30246_SHARP_){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,p1__30246_SHARP_) : sci.impl.interpreter.interpret.call(null,ctx,p1__30246_SHARP_));
}),cljs.core.vals(expr)));
} else {
if(((cljs.core.vector_QMARK_(expr)) || (cljs.core.set_QMARK_(expr)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.empty(expr),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30247_SHARP_){
return (sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.interpret.cljs$core$IFn$_invoke$arity$2(ctx,p1__30247_SHARP_) : sci.impl.interpreter.interpret.call(null,ctx,p1__30247_SHARP_));
}),expr));
} else {
throw (new Error(["unexpected: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr),", type: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(expr)),", meta:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(expr))].join('')));

}
}

}
})());
var ret__$1 = (cljs.core.truth_(m)?sci.impl.interpreter.fix_meta(ret,m):ret);
var temp__5733__auto__ = ctx.get(new cljs.core.Keyword(null,"realize-max","realize-max",-1846442543));
if(cljs.core.truth_(temp__5733__auto__)){
var n = temp__5733__auto__;
return sci.impl.max_or_throw.max_or_throw(ret__$1,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ctx,new cljs.core.Keyword(null,"expression","expression",202311876),expr),n);
} else {
return ret__$1;
}
}
});
sci.impl.interpreter.do_QMARK_ = (function sci$impl$interpreter$do_QMARK_(expr){
return ((cljs.core.list_QMARK_(expr)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.first(expr))));
});
sci.impl.interpreter.eval_form = (function sci$impl$interpreter$eval_form(ctx,form){
if(sci.impl.interpreter.do_QMARK_(form)){
var exprs = cljs.core.rest(form);
var ret = null;
while(true){
if(cljs.core.seq(exprs)){
var G__30295 = cljs.core.rest(exprs);
var G__30296 = (function (){var G__30251 = ctx;
var G__30252 = cljs.core.first(exprs);
return (sci.impl.interpreter.eval_form.cljs$core$IFn$_invoke$arity$2 ? sci.impl.interpreter.eval_form.cljs$core$IFn$_invoke$arity$2(G__30251,G__30252) : sci.impl.interpreter.eval_form.call(null,G__30251,G__30252));
})();
exprs = G__30295;
ret = G__30296;
continue;
} else {
return ret;
}
break;
}
} else {
var analyzed = sci.impl.analyzer.analyze(ctx,form);
var ret = sci.impl.interpreter.interpret(ctx,analyzed);
return ret;
}
});
cljs.core.vreset_BANG_(sci.impl.utils.eval_form_state,sci.impl.interpreter.eval_form);
sci.impl.interpreter.eval_string_STAR_ = (function sci$impl$interpreter$eval_string_STAR_(ctx,s){
var reader = cljs.tools.reader.reader_types.indexing_push_back_reader.cljs$core$IFn$_invoke$arity$1(cljs.tools.reader.reader_types.string_push_back_reader.cljs$core$IFn$_invoke$arity$1(s));
var ret = null;
while(true){
var expr = sci.impl.parser.parse_next.cljs$core$IFn$_invoke$arity$2(ctx,reader);
if(cljs.core.truth_((sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? sci.impl.utils.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("edamame.impl.parser","eof","edamame.impl.parser/eof",720552006),expr) : sci.impl.utils.kw_identical_QMARK_.call(null,new cljs.core.Keyword("edamame.impl.parser","eof","edamame.impl.parser/eof",720552006),expr)))){
return ret;
} else {
var ret__$1 = sci.impl.interpreter.eval_form(ctx,expr);
var G__30297 = ret__$1;
ret = G__30297;
continue;
}
break;
}
});
sci.impl.interpreter.eval_string = (function sci$impl$interpreter$eval_string(var_args){
var G__30254 = arguments.length;
switch (G__30254) {
case 1:
return sci.impl.interpreter.eval_string.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sci.impl.interpreter.eval_string.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sci.impl.interpreter.eval_string.cljs$core$IFn$_invoke$arity$1 = (function (s){
return sci.impl.interpreter.eval_string.cljs$core$IFn$_invoke$arity$2(s,null);
}));

(sci.impl.interpreter.eval_string.cljs$core$IFn$_invoke$arity$2 = (function (s,opts){
var init_ctx = sci.impl.opts.init(opts);
var ret = (function (){
sci.impl.vars.push_thread_bindings((cljs.core.truth_(cljs.core.deref(sci.impl.vars.current_ns))?null:cljs.core.PersistentArrayMap.createAsIfByAssoc([sci.impl.vars.current_ns,sci.impl.opts.user_ns])));

try{return sci.impl.interpreter.eval_string_STAR_(init_ctx,s);
}finally {sci.impl.vars.pop_thread_bindings();
}})()
;
return ret;
}));

(sci.impl.interpreter.eval_string.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=sci.impl.interpreter.js.map
