goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR__orig_val__28321 = re_frame.trace._STAR_current_trace_STAR_;
var _STAR_current_trace_STAR__temp_val__28322 = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));
(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__temp_val__28322);

try{try{var seq__28323 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__28324 = null;
var count__28325 = (0);
var i__28326 = (0);
while(true){
if((i__28326 < count__28325)){
var vec__28333 = chunk__28324.cljs$core$IIndexed$_nth$arity$2(null,i__28326);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28333,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28333,(1),null);
var temp__5733__auto___28375 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___28375)){
var effect_fn_28376 = temp__5733__auto___28375;
(effect_fn_28376.cljs$core$IFn$_invoke$arity$1 ? effect_fn_28376.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_28376.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__28377 = seq__28323;
var G__28378 = chunk__28324;
var G__28379 = count__28325;
var G__28380 = (i__28326 + (1));
seq__28323 = G__28377;
chunk__28324 = G__28378;
count__28325 = G__28379;
i__28326 = G__28380;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28323);
if(temp__5735__auto__){
var seq__28323__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28323__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28323__$1);
var G__28381 = cljs.core.chunk_rest(seq__28323__$1);
var G__28382 = c__4556__auto__;
var G__28383 = cljs.core.count(c__4556__auto__);
var G__28384 = (0);
seq__28323 = G__28381;
chunk__28324 = G__28382;
count__28325 = G__28383;
i__28326 = G__28384;
continue;
} else {
var vec__28336 = cljs.core.first(seq__28323__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28336,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28336,(1),null);
var temp__5733__auto___28385 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___28385)){
var effect_fn_28386 = temp__5733__auto___28385;
(effect_fn_28386.cljs$core$IFn$_invoke$arity$1 ? effect_fn_28386.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_28386.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__28387 = cljs.core.next(seq__28323__$1);
var G__28388 = null;
var G__28389 = (0);
var G__28390 = (0);
seq__28323 = G__28387;
chunk__28324 = G__28388;
count__28325 = G__28389;
i__28326 = G__28390;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__28027__auto___28391 = re_frame.interop.now();
var duration__28028__auto___28392 = (end__28027__auto___28391 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__28028__auto___28392,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__28027__auto___28391);
} else {
}
}}finally {(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__orig_val__28321);
}} else {
var seq__28339 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__28340 = null;
var count__28341 = (0);
var i__28342 = (0);
while(true){
if((i__28342 < count__28341)){
var vec__28349 = chunk__28340.cljs$core$IIndexed$_nth$arity$2(null,i__28342);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28349,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28349,(1),null);
var temp__5733__auto___28393 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___28393)){
var effect_fn_28394 = temp__5733__auto___28393;
(effect_fn_28394.cljs$core$IFn$_invoke$arity$1 ? effect_fn_28394.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_28394.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__28395 = seq__28339;
var G__28396 = chunk__28340;
var G__28397 = count__28341;
var G__28398 = (i__28342 + (1));
seq__28339 = G__28395;
chunk__28340 = G__28396;
count__28341 = G__28397;
i__28342 = G__28398;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28339);
if(temp__5735__auto__){
var seq__28339__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28339__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28339__$1);
var G__28399 = cljs.core.chunk_rest(seq__28339__$1);
var G__28400 = c__4556__auto__;
var G__28401 = cljs.core.count(c__4556__auto__);
var G__28402 = (0);
seq__28339 = G__28399;
chunk__28340 = G__28400;
count__28341 = G__28401;
i__28342 = G__28402;
continue;
} else {
var vec__28352 = cljs.core.first(seq__28339__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28352,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28352,(1),null);
var temp__5733__auto___28403 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___28403)){
var effect_fn_28404 = temp__5733__auto___28403;
(effect_fn_28404.cljs$core$IFn$_invoke$arity$1 ? effect_fn_28404.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_28404.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__28405 = cljs.core.next(seq__28339__$1);
var G__28406 = null;
var G__28407 = (0);
var G__28408 = (0);
seq__28339 = G__28405;
chunk__28340 = G__28406;
count__28341 = G__28407;
i__28342 = G__28408;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__28355 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__28356 = null;
var count__28357 = (0);
var i__28358 = (0);
while(true){
if((i__28358 < count__28357)){
var map__28363 = chunk__28356.cljs$core$IIndexed$_nth$arity$2(null,i__28358);
var map__28363__$1 = (((((!((map__28363 == null))))?(((((map__28363.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28363.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28363):map__28363);
var effect = map__28363__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28363__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28363__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__28355,chunk__28356,count__28357,i__28358,map__28363,map__28363__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__28355,chunk__28356,count__28357,i__28358,map__28363,map__28363__$1,effect,ms,dispatch))
,ms);
}


var G__28409 = seq__28355;
var G__28410 = chunk__28356;
var G__28411 = count__28357;
var G__28412 = (i__28358 + (1));
seq__28355 = G__28409;
chunk__28356 = G__28410;
count__28357 = G__28411;
i__28358 = G__28412;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28355);
if(temp__5735__auto__){
var seq__28355__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28355__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28355__$1);
var G__28413 = cljs.core.chunk_rest(seq__28355__$1);
var G__28414 = c__4556__auto__;
var G__28415 = cljs.core.count(c__4556__auto__);
var G__28416 = (0);
seq__28355 = G__28413;
chunk__28356 = G__28414;
count__28357 = G__28415;
i__28358 = G__28416;
continue;
} else {
var map__28365 = cljs.core.first(seq__28355__$1);
var map__28365__$1 = (((((!((map__28365 == null))))?(((((map__28365.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28365.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28365):map__28365);
var effect = map__28365__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28365__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28365__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__28355,chunk__28356,count__28357,i__28358,map__28365,map__28365__$1,effect,ms,dispatch,seq__28355__$1,temp__5735__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__28355,chunk__28356,count__28357,i__28358,map__28365,map__28365__$1,effect,ms,dispatch,seq__28355__$1,temp__5735__auto__))
,ms);
}


var G__28417 = cljs.core.next(seq__28355__$1);
var G__28418 = null;
var G__28419 = (0);
var G__28420 = (0);
seq__28355 = G__28417;
chunk__28356 = G__28418;
count__28357 = G__28419;
i__28358 = G__28420;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if((!(cljs.core.vector_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if((!(cljs.core.sequential_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value], 0));
} else {
var seq__28367 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__28368 = null;
var count__28369 = (0);
var i__28370 = (0);
while(true){
if((i__28370 < count__28369)){
var event = chunk__28368.cljs$core$IIndexed$_nth$arity$2(null,i__28370);
re_frame.router.dispatch(event);


var G__28423 = seq__28367;
var G__28424 = chunk__28368;
var G__28425 = count__28369;
var G__28426 = (i__28370 + (1));
seq__28367 = G__28423;
chunk__28368 = G__28424;
count__28369 = G__28425;
i__28370 = G__28426;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28367);
if(temp__5735__auto__){
var seq__28367__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28367__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28367__$1);
var G__28427 = cljs.core.chunk_rest(seq__28367__$1);
var G__28428 = c__4556__auto__;
var G__28429 = cljs.core.count(c__4556__auto__);
var G__28430 = (0);
seq__28367 = G__28427;
chunk__28368 = G__28428;
count__28369 = G__28429;
i__28370 = G__28430;
continue;
} else {
var event = cljs.core.first(seq__28367__$1);
re_frame.router.dispatch(event);


var G__28431 = cljs.core.next(seq__28367__$1);
var G__28432 = null;
var G__28433 = (0);
var G__28434 = (0);
seq__28367 = G__28431;
chunk__28368 = G__28432;
count__28369 = G__28433;
i__28370 = G__28434;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__28371 = cljs.core.seq(value);
var chunk__28372 = null;
var count__28373 = (0);
var i__28374 = (0);
while(true){
if((i__28374 < count__28373)){
var event = chunk__28372.cljs$core$IIndexed$_nth$arity$2(null,i__28374);
clear_event(event);


var G__28435 = seq__28371;
var G__28436 = chunk__28372;
var G__28437 = count__28373;
var G__28438 = (i__28374 + (1));
seq__28371 = G__28435;
chunk__28372 = G__28436;
count__28373 = G__28437;
i__28374 = G__28438;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28371);
if(temp__5735__auto__){
var seq__28371__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28371__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28371__$1);
var G__28439 = cljs.core.chunk_rest(seq__28371__$1);
var G__28440 = c__4556__auto__;
var G__28441 = cljs.core.count(c__4556__auto__);
var G__28442 = (0);
seq__28371 = G__28439;
chunk__28372 = G__28440;
count__28373 = G__28441;
i__28374 = G__28442;
continue;
} else {
var event = cljs.core.first(seq__28371__$1);
clear_event(event);


var G__28443 = cljs.core.next(seq__28371__$1);
var G__28444 = null;
var G__28445 = (0);
var G__28446 = (0);
seq__28371 = G__28443;
chunk__28372 = G__28444;
count__28373 = G__28445;
i__28374 = G__28446;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if((!((cljs.core.deref(re_frame.db.app_db) === value)))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=re_frame.fx.js.map
