goog.provide('pinkgorilla.ui.gorilla_plot.plot');
goog.require('cljs.core');
goog.require('pinkgorilla.ui.gorilla_plot.vega');
goog.require('pinkgorilla.ui.gorilla_plot.util');
pinkgorilla.ui.gorilla_plot.plot.merge_with_meta = (function pinkgorilla$ui$gorilla_plot$plot$merge_with_meta(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34872 = arguments.length;
var i__4737__auto___34873 = (0);
while(true){
if((i__4737__auto___34873 < len__4736__auto___34872)){
args__4742__auto__.push((arguments[i__4737__auto___34873]));

var G__34874 = (i__4737__auto___34873 + (1));
i__4737__auto___34873 = G__34874;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$core$IFn$_invoke$arity$variadic = (function (data){
var metas = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.meta,data);
var merged_meta = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.merge,metas);
return cljs.core.with_meta(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.merge,data),merged_meta);
}));

(pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$lang$applyTo = (function (seq34784){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34784));
}));

pinkgorilla.ui.gorilla_plot.plot.add_indices = (function pinkgorilla$ui$gorilla_plot$plot$add_indices(d){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(d)),d);
});
/**
 * Function for plotting list data.
 */
pinkgorilla.ui.gorilla_plot.plot.list_plot = (function pinkgorilla$ui$gorilla_plot$plot$list_plot(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34875 = arguments.length;
var i__4737__auto___34876 = (0);
while(true){
if((i__4737__auto___34876 < len__4736__auto___34875)){
args__4742__auto__.push((arguments[i__4737__auto___34876]));

var G__34877 = (i__4737__auto___34876 + (1));
i__4737__auto___34876 = G__34877;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.plot.list_plot.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.plot.list_plot.cljs$core$IFn$_invoke$arity$variadic = (function (data,p__34804){
var map__34805 = p__34804;
var map__34805__$1 = (((((!((map__34805 == null))))?(((((map__34805.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34805.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34805):map__34805);
var plot_range = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34805__$1,new cljs.core.Keyword(null,"plot-range","plot-range",-1426783143),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.Keyword(null,"all","all",892129742)], null));
var colour = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34805__$1,new cljs.core.Keyword(null,"colour","colour",2137094554));
var y_title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34805__$1,new cljs.core.Keyword(null,"y-title","y-title",220785852));
var aspect_ratio = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34805__$1,new cljs.core.Keyword(null,"aspect-ratio","aspect-ratio",1674013504),1.618);
var joined = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34805__$1,new cljs.core.Keyword(null,"joined","joined",-231861661),false);
var color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34805__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var series_name = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34805__$1,new cljs.core.Keyword(null,"series-name","series-name",-128514906),pinkgorilla.ui.gorilla_plot.util.gen_uuid());
var x_title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34805__$1,new cljs.core.Keyword(null,"x-title","x-title",698054088));
var plot_size = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34805__$1,new cljs.core.Keyword(null,"plot-size","plot-size",1218885548),(400));
var symbol_size = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34805__$1,new cljs.core.Keyword(null,"symbol-size","symbol-size",-1099583279),(70));
var opacity = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34805__$1,new cljs.core.Keyword(null,"opacity","opacity",397153780),(1));
var plot_data = ((cljs.core.sequential_QMARK_(cljs.core.first(data)))?data:pinkgorilla.ui.gorilla_plot.plot.add_indices(data));
return pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pinkgorilla.ui.gorilla_plot.vega.container(plot_size,aspect_ratio),pinkgorilla.ui.gorilla_plot.vega.data_from_list(series_name,plot_data),(cljs.core.truth_(joined)?pinkgorilla.ui.gorilla_plot.vega.line_plot_marks(series_name,(function (){var or__4126__auto__ = colour;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return color;
}
})(),opacity):pinkgorilla.ui.gorilla_plot.vega.list_plot_marks(series_name,(function (){var or__4126__auto__ = colour;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return color;
}
})(),symbol_size,opacity)),pinkgorilla.ui.gorilla_plot.vega.default_list_plot_scales(series_name,plot_range),pinkgorilla.ui.gorilla_plot.vega.default_plot_axes(x_title,y_title)], 0));
}));

(pinkgorilla.ui.gorilla_plot.plot.list_plot.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.plot.list_plot.cljs$lang$applyTo = (function (seq34789){
var G__34790 = cljs.core.first(seq34789);
var seq34789__$1 = cljs.core.next(seq34789);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34790,seq34789__$1);
}));

pinkgorilla.ui.gorilla_plot.plot.timeseries_plot = (function pinkgorilla$ui$gorilla_plot$plot$timeseries_plot(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34878 = arguments.length;
var i__4737__auto___34879 = (0);
while(true){
if((i__4737__auto___34879 < len__4736__auto___34878)){
args__4742__auto__.push((arguments[i__4737__auto___34879]));

var G__34880 = (i__4737__auto___34879 + (1));
i__4737__auto___34879 = G__34880;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.plot.timeseries_plot.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.plot.timeseries_plot.cljs$core$IFn$_invoke$arity$variadic = (function (data,keys){
var series_name = pinkgorilla.ui.gorilla_plot.util.gen_uuid();
var params = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [data,new cljs.core.Keyword(null,"series-name","series-name",-128514906),series_name], null),keys));
var plot = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(pinkgorilla.ui.gorilla_plot.plot.list_plot,params);
var plot_range = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.Keyword(null,"all","all",892129742)], null);
return pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([plot,pinkgorilla.ui.gorilla_plot.vega.timeseries_list_plot_scales(series_name,plot_range)], 0));
}));

(pinkgorilla.ui.gorilla_plot.plot.timeseries_plot.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.plot.timeseries_plot.cljs$lang$applyTo = (function (seq34807){
var G__34808 = cljs.core.first(seq34807);
var seq34807__$1 = cljs.core.next(seq34807);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34808,seq34807__$1);
}));

/**
 * Function for plotting functions of a single variable.
 */
pinkgorilla.ui.gorilla_plot.plot.plot = (function pinkgorilla$ui$gorilla_plot$plot$plot(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34881 = arguments.length;
var i__4737__auto___34882 = (0);
while(true){
if((i__4737__auto___34882 < len__4736__auto___34881)){
args__4742__auto__.push((arguments[i__4737__auto___34882]));

var G__34883 = (i__4737__auto___34882 + (1));
i__4737__auto___34882 = G__34883;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.plot.plot.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.plot.plot.cljs$core$IFn$_invoke$arity$variadic = (function (func,p__34827,p__34828){
var vec__34829 = p__34827;
var xmin = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34829,(0),null);
var xmax = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34829,(1),null);
var map__34832 = p__34828;
var map__34832__$1 = (((((!((map__34832 == null))))?(((((map__34832.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34832.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34832):map__34832);
var opts = map__34832__$1;
var plot_points = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34832__$1,new cljs.core.Keyword(null,"plot-points","plot-points",-1364232040),100.0);
var xs = cljs.core.range.cljs$core$IFn$_invoke$arity$3(xmin,xmax,((xmax - xmin) / plot_points));
var plot_data = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34812_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__34812_SHARP_,(func.cljs$core$IFn$_invoke$arity$1 ? func.cljs$core$IFn$_invoke$arity$1(p1__34812_SHARP_) : func.call(null,p1__34812_SHARP_))],null));
}),xs);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(pinkgorilla.ui.gorilla_plot.plot.list_plot,plot_data),cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.identity,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"joined","joined",-231861661),true], null),opts], 0))], 0)));
}));

(pinkgorilla.ui.gorilla_plot.plot.plot.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.plot.plot.cljs$lang$applyTo = (function (seq34813){
var G__34814 = cljs.core.first(seq34813);
var seq34813__$1 = cljs.core.next(seq34813);
var G__34815 = cljs.core.first(seq34813__$1);
var seq34813__$2 = cljs.core.next(seq34813__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34814,G__34815,seq34813__$2);
}));

pinkgorilla.ui.gorilla_plot.plot.bar_chart = (function pinkgorilla$ui$gorilla_plot$plot$bar_chart(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34884 = arguments.length;
var i__4737__auto___34885 = (0);
while(true){
if((i__4737__auto___34885 < len__4736__auto___34884)){
args__4742__auto__.push((arguments[i__4737__auto___34885]));

var G__34886 = (i__4737__auto___34885 + (1));
i__4737__auto___34885 = G__34886;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.plot.bar_chart.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.plot.bar_chart.cljs$core$IFn$_invoke$arity$variadic = (function (categories,values,p__34840){
var map__34841 = p__34840;
var map__34841__$1 = (((((!((map__34841 == null))))?(((((map__34841.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34841.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34841):map__34841);
var plot_size = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34841__$1,new cljs.core.Keyword(null,"plot-size","plot-size",1218885548),(400));
var aspect_ratio = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34841__$1,new cljs.core.Keyword(null,"aspect-ratio","aspect-ratio",1674013504),1.618);
var plot_range = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34841__$1,new cljs.core.Keyword(null,"plot-range","plot-range",-1426783143),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.Keyword(null,"all","all",892129742)], null));
var opacity = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34841__$1,new cljs.core.Keyword(null,"opacity","opacity",397153780),(1));
var colour = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34841__$1,new cljs.core.Keyword(null,"colour","colour",2137094554));
var color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34841__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var x_title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34841__$1,new cljs.core.Keyword(null,"x-title","x-title",698054088));
var y_title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34841__$1,new cljs.core.Keyword(null,"y-title","y-title",220785852));
var series_name = pinkgorilla.ui.gorilla_plot.util.gen_uuid();
return pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pinkgorilla.ui.gorilla_plot.vega.container(plot_size,aspect_ratio),pinkgorilla.ui.gorilla_plot.vega.data_from_list(series_name,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,categories,values)),pinkgorilla.ui.gorilla_plot.vega.bar_chart_marks(series_name,(function (){var or__4126__auto__ = colour;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return color;
}
})(),opacity),pinkgorilla.ui.gorilla_plot.vega.default_bar_chart_scales(series_name,plot_range),pinkgorilla.ui.gorilla_plot.vega.default_plot_axes(x_title,y_title)], 0));
}));

(pinkgorilla.ui.gorilla_plot.plot.bar_chart.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.plot.bar_chart.cljs$lang$applyTo = (function (seq34834){
var G__34835 = cljs.core.first(seq34834);
var seq34834__$1 = cljs.core.next(seq34834);
var G__34836 = cljs.core.first(seq34834__$1);
var seq34834__$2 = cljs.core.next(seq34834__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34835,G__34836,seq34834__$2);
}));

/**
 * Plot the histogram of a sample.
 */
pinkgorilla.ui.gorilla_plot.plot.histogram = (function pinkgorilla$ui$gorilla_plot$plot$histogram(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34887 = arguments.length;
var i__4737__auto___34888 = (0);
while(true){
if((i__4737__auto___34888 < len__4736__auto___34887)){
args__4742__auto__.push((arguments[i__4737__auto___34888]));

var G__34889 = (i__4737__auto___34888 + (1));
i__4737__auto___34888 = G__34889;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.plot.histogram.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.plot.histogram.cljs$core$IFn$_invoke$arity$variadic = (function (data,p__34853){
var map__34854 = p__34853;
var map__34854__$1 = (((((!((map__34854 == null))))?(((((map__34854.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34854.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34854):map__34854);
var plot_range = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34854__$1,new cljs.core.Keyword(null,"plot-range","plot-range",-1426783143),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.Keyword(null,"all","all",892129742)], null));
var colour = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34854__$1,new cljs.core.Keyword(null,"colour","colour",2137094554));
var y_title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34854__$1,new cljs.core.Keyword(null,"y-title","y-title",220785852));
var normalize = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34854__$1,new cljs.core.Keyword(null,"normalize","normalize",-1904390051));
var fill_opacity = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34854__$1,new cljs.core.Keyword(null,"fill-opacity","fill-opacity",-537571170),0.4);
var aspect_ratio = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34854__$1,new cljs.core.Keyword(null,"aspect-ratio","aspect-ratio",1674013504),1.618);
var color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34854__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var x_title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34854__$1,new cljs.core.Keyword(null,"x-title","x-title",698054088));
var bins = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34854__$1,new cljs.core.Keyword(null,"bins","bins",1670395210),new cljs.core.Keyword(null,"automatic","automatic",104479799));
var plot_size = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34854__$1,new cljs.core.Keyword(null,"plot-size","plot-size",1218885548),(400));
var normalise = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34854__$1,new cljs.core.Keyword(null,"normalise","normalise",-1794807087));
var opacity = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34854__$1,new cljs.core.Keyword(null,"opacity","opacity",397153780),(1));
var bin_range_spec = cljs.core.first(plot_range);
var range_min = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(bin_range_spec,new cljs.core.Keyword(null,"all","all",892129742)))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,data):cljs.core.first(bin_range_spec));
var range_max_raw = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(bin_range_spec,new cljs.core.Keyword(null,"all","all",892129742)))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,data):cljs.core.second(bin_range_spec));
var range_max = (range_max_raw + Math.ulp(range_max_raw));
var points_in_range = pinkgorilla.ui.gorilla_plot.util.count_in_range(data,range_min,range_max);
var num_bins = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(bins,new cljs.core.Keyword(null,"automatic","automatic",104479799)))?Math.ceil(((1) + (Math.log(points_in_range) / Math.log((2))))):bins);
var bin_size_raw = ((range_max - range_min) / num_bins);
var bin_size = (((bin_size_raw < 1.0E-15))?1.0:bin_size_raw);
var cat_counts = pinkgorilla.ui.gorilla_plot.util.bin_counts(data,range_min,range_max,bin_size);
var norm = (function (){var G__34856 = (function (){var or__4126__auto__ = normalize;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = normalise;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return new cljs.core.Keyword(null,"count","count",2139924085);
}
}
})();
var G__34856__$1 = (((G__34856 instanceof cljs.core.Keyword))?G__34856.fqn:null);
switch (G__34856__$1) {
case "probability":
return cljs.core.count(data);

break;
case "probability-density":
return (cljs.core.count(data) * bin_size);

break;
case "count":
return (1);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__34856__$1)].join('')));

}
})();
var cat_data = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34850_SHARP_){
return (p1__34850_SHARP_ / norm);
}),cat_counts);
var series_name = pinkgorilla.ui.gorilla_plot.util.gen_uuid();
var x_data = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,bin_size),cljs.core.range.cljs$core$IFn$_invoke$arity$3((range_min - bin_size),(range_max + bin_size),bin_size));
var y_data = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cat_data,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null)], 0));
var plot_data = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,x_data,y_data);
return pinkgorilla.ui.gorilla_plot.plot.merge_with_meta.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pinkgorilla.ui.gorilla_plot.vega.container(plot_size,aspect_ratio),pinkgorilla.ui.gorilla_plot.vega.data_from_list(series_name,plot_data),pinkgorilla.ui.gorilla_plot.vega.histogram_marks(series_name,(function (){var or__4126__auto__ = colour;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return color;
}
})(),opacity,fill_opacity),pinkgorilla.ui.gorilla_plot.vega.default_list_plot_scales(series_name,plot_range),pinkgorilla.ui.gorilla_plot.vega.default_plot_axes(x_title,y_title)], 0));
}));

(pinkgorilla.ui.gorilla_plot.plot.histogram.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.plot.histogram.cljs$lang$applyTo = (function (seq34851){
var G__34852 = cljs.core.first(seq34851);
var seq34851__$1 = cljs.core.next(seq34851);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34852,seq34851__$1);
}));

pinkgorilla.ui.gorilla_plot.plot.compose = (function pinkgorilla$ui$gorilla_plot$plot$compose(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34891 = arguments.length;
var i__4737__auto___34892 = (0);
while(true){
if((i__4737__auto___34892 < len__4736__auto___34891)){
args__4742__auto__.push((arguments[i__4737__auto___34892]));

var G__34893 = (i__4737__auto___34892 + (1));
i__4737__auto___34892 = G__34893;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return pinkgorilla.ui.gorilla_plot.plot.compose.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(pinkgorilla.ui.gorilla_plot.plot.compose.cljs$core$IFn$_invoke$arity$variadic = (function (plots){
var first_plot = cljs.core.first(plots);
var map__34870 = first_plot;
var map__34870__$1 = (((((!((map__34870 == null))))?(((((map__34870.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34870.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34870):map__34870);
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34870__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34870__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var padding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34870__$1,new cljs.core.Keyword(null,"padding","padding",1660304693));
var scales = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34870__$1,new cljs.core.Keyword(null,"scales","scales",-1197224722));
var axes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34870__$1,new cljs.core.Keyword(null,"axes","axes",1970866440));
var data = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"data","data",-232669377),plots));
var marks = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"marks","marks",-1844991497),plots));
return cljs.core.with_meta(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"width","width",-384071477),width,new cljs.core.Keyword(null,"height","height",1025178622),height,new cljs.core.Keyword(null,"padding","padding",1660304693),padding,new cljs.core.Keyword(null,"scales","scales",-1197224722),scales,new cljs.core.Keyword(null,"axes","axes",1970866440),axes,new cljs.core.Keyword(null,"data","data",-232669377),data,new cljs.core.Keyword(null,"marks","marks",-1844991497),marks], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("p","render-as","p/render-as",-1497012127),new cljs.core.Keyword("p","vega","p/vega",-1657842969)], null));
}));

(pinkgorilla.ui.gorilla_plot.plot.compose.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(pinkgorilla.ui.gorilla_plot.plot.compose.cljs$lang$applyTo = (function (seq34869){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34869));
}));


//# sourceMappingURL=pinkgorilla.ui.gorilla_plot.plot.js.map
