goog.provide('pinkgorilla.ui.clock');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('pinkgorilla.ui.pinkie');
goog.require('pinkgorilla.ui.html');
pinkgorilla.ui.clock.clock_style = "<style> \n\n/* Binary clock */\n\n.clock-main {\n    background: #333;\n    color: #cdcdcd;\n    padding-top: 55px;\n    padding-left: 20px;\n    float: left;\n    font-size: 28px;\n    line-height: 34px;\n    width: 620px;\n    cursor: pointer;\n}\n.clock-main.wide {\n    width: 790px;\n}\n.clock-cell {\n    width: 55px;\n    height: 55px;\n    text-align: center;\n    margin: 0 20px 20px 0;\n}\n.clock-cell.dark {\n    background-color: #454545;\n}\n.clock-cell.light {\n    background-color: #eee;\n}\n.clock-col {\n    margin: 0;\n    float: left;\n}\n.clock-legend > .clock-cell {\n    margin-top: 10px;\n}\n.clock-pair {\n    margin: 0;\n    float: left;\n}\n.clock-pair:not(:last-child) {\n    margin-right: 20px;\n    /* border-right: 1px solid #454545; */\n}\n </style>\n";
pinkgorilla.ui.clock.cell = (function pinkgorilla$ui$clock$cell(n,bit){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.clock-cell","div.clock-cell",-12507663),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),((((n & (1 << bit)) != 0))?"light":"dark")], null)], null);
});
pinkgorilla.ui.clock.column = (function pinkgorilla$ui$clock$column(n){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.clock-col","div.clock-col",1418748813),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.cell,n,(3)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.cell,n,(2)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.cell,n,(1)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.cell,n,(0)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.clock-cell","div.clock-cell",-12507663),n], null)], null);
});
pinkgorilla.ui.clock.column_pair = (function pinkgorilla$ui$clock$column_pair(n){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.clock-pair","div.clock-pair",-65283468),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.column,cljs.core.quot(n,(10))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.column,cljs.core.mod(n,(10))], null)], null);
});
pinkgorilla.ui.clock.legend = (function pinkgorilla$ui$clock$legend(var_args){
var args__4742__auto__ = [];
var len__4736__auto___42876 = arguments.length;
var i__4737__auto___42877 = (0);
while(true){
if((i__4737__auto___42877 < len__4736__auto___42876)){
args__4742__auto__.push((arguments[i__4737__auto___42877]));

var G__42878 = (i__4737__auto___42877 + (1));
i__4737__auto___42877 = G__42878;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return pinkgorilla.ui.clock.legend.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(pinkgorilla.ui.clock.legend.cljs$core$IFn$_invoke$arity$variadic = (function (items){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.clock-col.clock-legend","div.clock-col.clock-legend",-1934406846)], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,new cljs.core.Keyword(null,"div.clock-cell","div.clock-cell",-12507663)),items));
}));

(pinkgorilla.ui.clock.legend.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(pinkgorilla.ui.clock.legend.cljs$lang$applyTo = (function (seq42873){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42873));
}));

pinkgorilla.ui.clock.clock = (function pinkgorilla$ui$clock$clock(date,show_100s,toggle_100s){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.clock-main","div.clock-main",-402520242),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),toggle_100s,new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(show_100s)?"wide":null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.html.html,pinkgorilla.ui.clock.clock_style], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.legend,(8),(4),(2),(1)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.column_pair,date.getHours()], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.column_pair,date.getMinutes()], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.column_pair,date.getSeconds()], null),(cljs.core.truth_(show_100s)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.column_pair,cljs.core.quot(date.getMilliseconds(),(10))], null):null)], null);
});
pinkgorilla.ui.clock.clock_state = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"time","time",1385887882),(new Date()),new cljs.core.Keyword(null,"show-100s","show-100s",1072817186),false], null));
pinkgorilla.ui.clock.update_time = (function pinkgorilla$ui$clock$update_time(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.ui.clock.clock_state,cljs.core.assoc,new cljs.core.Keyword(null,"time","time",1385887882),(new Date()));
});
pinkgorilla.ui.clock.binary_clock = (function pinkgorilla$ui$clock$binary_clock(){
var map__42874 = cljs.core.deref(pinkgorilla.ui.clock.clock_state);
var map__42874__$1 = (((((!((map__42874 == null))))?(((((map__42874.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42874.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42874):map__42874);
var time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42874__$1,new cljs.core.Keyword(null,"time","time",1385887882));
var show_100s = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42874__$1,new cljs.core.Keyword(null,"show-100s","show-100s",1072817186));
if(cljs.core.truth_(show_100s)){
reagent.core.next_tick(pinkgorilla.ui.clock.update_time);
} else {
setTimeout(pinkgorilla.ui.clock.update_time,(1000));
}

return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.clock.clock,time,show_100s,(function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.ui.clock.clock_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"show-100s","show-100s",1072817186)], null),cljs.core.not);
})], null);
});
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkgorilla.ui.pinkie.component_registry,cljs.core.assoc,new cljs.core.Keyword("p","clock","p/clock",-894300887),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fun","fun",-1265158045),pinkgorilla.ui.clock.binary_clock,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core.meta(new cljs.core.Var(function(){return pinkgorilla.ui.clock.binary_clock;},new cljs.core.Symbol("pinkgorilla.ui.clock","binary-clock","pinkgorilla.ui.clock/binary-clock",-1677949562,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"category","category",-593092832),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Keyword(null,"demo","demo",851880189),new cljs.core.Symbol(null,"pinkgorilla.ui.clock","pinkgorilla.ui.clock",436769991,null),new cljs.core.Symbol(null,"binary-clock","binary-clock",1740616280,null),"pinkgorilla/ui/clock.cljs",15,1,98,99,cljs.core.list(cljs.core.PersistentVector.EMPTY),null,(cljs.core.truth_(pinkgorilla.ui.clock.binary_clock)?pinkgorilla.ui.clock.binary_clock.cljs$lang$test:null)]))),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword("p","clock","p/clock",-894300887)], null));

//# sourceMappingURL=pinkgorilla.ui.clock.js.map
