goog.provide('goldly.web');
goog.require('cljs.core');
goog.require('goog.History');
goog.require('cljs.pprint');
goog.require('taoensso.timbre');
goog.require('goog.events');
goog.require('goog.history.EventType');
goog.require('secretary.core');
goog.require('reagent.core');
goog.require('reagent.dom');
goog.require('re_frame.core');
goog.require('goldly.system');
goog.require('goldly.ws');
goog.require('goldly.events');
goog.require('goldly.subs');
goog.require('pinkgorilla.ui.default_setup');
goog.require('pinkgorilla.ui.default_renderer');
goog.require('pinkgorilla.ui.gorilla_plot.pinkie');
goldly.web.print_log_init_BANG_ = (function goldly$web$print_log_init_BANG_(){
cljs.core.enable_console_print_BANG_();

return taoensso.timbre.set_level_BANG_(new cljs.core.Keyword(null,"info","info",-317069002));
});
goldly.web.hook_browser_navigation_BANG_ = (function goldly$web$hook_browser_navigation_BANG_(){
var G__43088 = (new goog.History());
goog.events.listen(G__43088,goog.history.EventType.NAVIGATE,(function (event){
return secretary.core.dispatch_BANG_(event.token);
}));

G__43088.setEnabled(true);

return G__43088;
});
if((typeof goldly !== 'undefined') && (typeof goldly.web !== 'undefined') && (typeof goldly.web.history !== 'undefined')){
} else {
goldly.web.history = goldly.web.hook_browser_navigation_BANG_();
}
/**
 * navigates the browser to the url. 
 * Triggers secretary route events
 */
goldly.web.nav_BANG_ = (function goldly$web$nav_BANG_(url){
return goldly.web.history.setToken(url);
});
goldly.web.app_routes = (function goldly$web$app_routes(var_args){
var args__4742__auto__ = [];
var len__4736__auto___43130 = arguments.length;
var i__4737__auto___43131 = (0);
while(true){
if((i__4737__auto___43131 < len__4736__auto___43130)){
args__4742__auto__.push((arguments[i__4737__auto___43131]));

var G__43132 = (i__4737__auto___43131 + (1));
i__4737__auto___43131 = G__43132;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return goldly.web.app_routes.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(goldly.web.app_routes.cljs$core$IFn$_invoke$arity$variadic = (function (p__43092){
var vec__43093 = p__43092;
var map__43096 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43093,(0),null);
var map__43096__$1 = (((((!((map__43096 == null))))?(((((map__43096.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43096.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43096):map__43096);
var hook_navigation = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__43096__$1,new cljs.core.Keyword(null,"hook-navigation","hook-navigation",711871046),false);
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"goldly.web","/tmp/form-init3809659493204174866.clj",51,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Hook navigation",hook_navigation], null);
}),null)),null,-548281242);

secretary.core.set_config_BANG_(new cljs.core.Keyword(null,"prefix","prefix",-265908465),"#");

var action__26869__auto___43133 = (function (params__26870__auto__){
if(cljs.core.map_QMARK_(params__26870__auto__)){
var map__43098 = params__26870__auto__;
var map__43098__$1 = (((((!((map__43098 == null))))?(((((map__43098.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43098.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43098):map__43098);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["nav: /info"], 0));

var G__43100 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("goldly","nav","goldly/nav",-453690612),new cljs.core.Keyword(null,"info","info",-317069002)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__43100) : re_frame.core.dispatch.call(null,G__43100));
} else {
if(cljs.core.vector_QMARK_(params__26870__auto__)){
var vec__43101 = params__26870__auto__;
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["nav: /info"], 0));

var G__43104 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("goldly","nav","goldly/nav",-453690612),new cljs.core.Keyword(null,"info","info",-317069002)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__43104) : re_frame.core.dispatch.call(null,G__43104));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/info",action__26869__auto___43133);


var action__26869__auto__ = (function (params__26870__auto__){
if(cljs.core.map_QMARK_(params__26870__auto__)){
var map__43108 = params__26870__auto__;
var map__43108__$1 = (((((!((map__43108 == null))))?(((((map__43108.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43108.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43108):map__43108);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43108__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43108__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["nav: /system ",id], 0));

var G__43110 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("goldly","nav","goldly/nav",-453690612),new cljs.core.Keyword(null,"system","system",-29381724),id], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__43110) : re_frame.core.dispatch.call(null,G__43110));
} else {
if(cljs.core.vector_QMARK_(params__26870__auto__)){
var vec__43111 = params__26870__auto__;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43111,(0),null);
var query_params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43111,(1),null);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["nav: /system ",id], 0));

var G__43114 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("goldly","nav","goldly/nav",-453690612),new cljs.core.Keyword(null,"system","system",-29381724),id], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__43114) : re_frame.core.dispatch.call(null,G__43114));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/system/:id",action__26869__auto__);

return (function() { 
var G__43134__delegate = function (args__26868__auto__){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(secretary.core.render_route_STAR_,"/system/:id",args__26868__auto__);
};
var G__43134 = function (var_args){
var args__26868__auto__ = null;
if (arguments.length > 0) {
var G__43135__i = 0, G__43135__a = new Array(arguments.length -  0);
while (G__43135__i < G__43135__a.length) {G__43135__a[G__43135__i] = arguments[G__43135__i + 0]; ++G__43135__i;}
  args__26868__auto__ = new cljs.core.IndexedSeq(G__43135__a,0,null);
} 
return G__43134__delegate.call(this,args__26868__auto__);};
G__43134.cljs$lang$maxFixedArity = 0;
G__43134.cljs$lang$applyTo = (function (arglist__43136){
var args__26868__auto__ = cljs.core.seq(arglist__43136);
return G__43134__delegate(args__26868__auto__);
});
G__43134.cljs$core$IFn$_invoke$arity$variadic = G__43134__delegate;
return G__43134;
})()
;
}));

(goldly.web.app_routes.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(goldly.web.app_routes.cljs$lang$applyTo = (function (seq43091){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43091));
}));

goldly.web.infos = (function goldly$web$infos(){
var systems = (function (){var G__43115 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"systems","systems",-1015374944)], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__43115) : re_frame.core.subscribe.call(null,G__43115));
})();
var _ = cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["info: systems: ",cljs.core.deref(systems)], 0));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"<>","<>",1280186386),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h1","h1",-1896887462),"running systems: ",cljs.core.count(cljs.core.deref(systems))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__4529__auto__ = (function goldly$web$infos_$_iter__43116(s__43117){
return (new cljs.core.LazySeq(null,(function (){
var s__43117__$1 = s__43117;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__43117__$1);
if(temp__5735__auto__){
var s__43117__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__43117__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__43117__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__43119 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__43118 = (0);
while(true){
if((i__43118 < size__4528__auto__)){
var map__43120 = cljs.core._nth(c__4527__auto__,i__43118);
var map__43120__$1 = (((((!((map__43120 == null))))?(((((map__43120.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43120.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43120):map__43120);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43120__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43120__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.chunk_append(b__43119,cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.m-3","li.m-3",-1564465690),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"m-3 bg-yellow-300",new cljs.core.Keyword(null,"href","href",-793805698),["#/system/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)].join('')], null),name], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),id], null)));

var G__43137 = (i__43118 + (1));
i__43118 = G__43137;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43119),goldly$web$infos_$_iter__43116(cljs.core.chunk_rest(s__43117__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43119),null);
}
} else {
var map__43122 = cljs.core.first(s__43117__$2);
var map__43122__$1 = (((((!((map__43122 == null))))?(((((map__43122.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43122.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43122):map__43122);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43122__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43122__$1,new cljs.core.Keyword(null,"name","name",1843675177));
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.m-3","li.m-3",-1564465690),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"m-3 bg-yellow-300",new cljs.core.Keyword(null,"href","href",-793805698),["#/system/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)].join('')], null),name], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),id], null)),goldly$web$infos_$_iter__43116(cljs.core.rest(s__43117__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(cljs.core.deref(systems));
})()], null)], null);
});
goldly.web.error_boundary = (function goldly$web$error_boundary(_){
var error = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var info = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(null);
return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"component-did-catch","component-did-catch",652725810),(function (___$1,___$2,i){
return cljs.core.reset_BANG_(info,i);
}),new cljs.core.Keyword(null,"get-derived-state-from-error","get-derived-state-from-error",1473896468),(function (e){
cljs.core.reset_BANG_(error,e);

return ({});
}),new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),(function (comp){
if(cljs.core.truth_(cljs.core.deref(error))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),"Something went wrong.",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(error))], null)], null);
} else {
return comp;
}
})], null));
});
/**
 * requests system with id from server
 * and displays it.
 */
goldly.web.system = (function goldly$web$system(id){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"goldly.web","/tmp/form-init3809659493204174866.clj",91,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["showing system: ",id], null);
}),null)),null,-1853815533);

var G__43124_43138 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("goldly","system-store","goldly/system-store",-2008850013),id,null], null);
(re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1(G__43124_43138) : re_frame.core.dispatch_sync.call(null,G__43124_43138));

var G__43125_43139 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("goldly","send","goldly/send",181321881),new cljs.core.Keyword("goldly","system","goldly/system",1429584215),id], null);
(re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__43125_43139) : re_frame.core.dispatch.call(null,G__43125_43139));

var system = (function (){var G__43126 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"system","system",-29381724)], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__43126) : re_frame.core.subscribe.call(null,G__43126));
})();
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"<>","<>",1280186386),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"m-2 bg-blue-200 border-dotted border-orange-400",new cljs.core.Keyword(null,"href","href",-793805698),"#/info"], null),"Systems"], null),(((cljs.core.deref(system) == null))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h1","h1",-1896887462),"loading .."], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"<>","<>",1280186386),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h1.bg-orange-300","h1.bg-orange-300",-521715806),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(system)))," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)].join('')], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [goldly.web.error_boundary,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [goldly.system.render_system,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(system))], null),new cljs.core.Keyword(null,"cljs","cljs",1492417629).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(system)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"fns-clj","fns-clj",1003510986),new cljs.core.Keyword(null,"fns-clj","fns-clj",1003510986).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(system))], null)], 0))], null)], null)], null))], null);
});
});
goldly.web.app = (function goldly$web$app(){
var main = (function (){var G__43127 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"main","main",-2117802661)], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__43127) : re_frame.core.subscribe.call(null,G__43127));
})();
var id = (function (){var G__43128 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"system-id","system-id",-909365185)], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__43128) : re_frame.core.subscribe.call(null,G__43128));
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),(function (){var G__43129 = cljs.core.deref(main);
var G__43129__$1 = (((G__43129 instanceof cljs.core.Keyword))?G__43129.fqn:null);
switch (G__43129__$1) {
case "info":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [goldly.web.infos], null);

break;
case "system":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [goldly.web.system,cljs.core.deref(id)], null);

break;
default:
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [goldly.web.infos], null);

}
})()], null);
});
goldly.web.mount_app = (function goldly$web$mount_app(){
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [goldly.web.app], null),document.getElementById("app"));
});
goldly.web.before_reload = (function goldly$web$before_reload(){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["shadow-cljs reload: before"], 0));

return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"goldly.web","/tmp/form-init3809659493204174866.clj",128,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["shadow-cljs reload: before"], null);
}),null)),null,-1437726388);
});
goldly.web.after_reload = (function goldly$web$after_reload(){
goldly.web.print_log_init_BANG_();

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["shadow-cljs reload: after"], 0));

taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"goldly.web","/tmp/form-init3809659493204174866.clj",133,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["shadow-cljs reload: after"], null);
}),null)),null,-797265072);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["clearing reframe subscription cache.."], 0));

(re_frame.core.clear_subscription_cache_BANG_.cljs$core$IFn$_invoke$arity$0 ? re_frame.core.clear_subscription_cache_BANG_.cljs$core$IFn$_invoke$arity$0() : re_frame.core.clear_subscription_cache_BANG_.call(null));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-loading configuration from server.."], 0));

goldly.web.app_routes();

goldly.ws.start_router_BANG_();

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["mounting notebook-app .."], 0));

return goldly.web.mount_app();
});
goldly.web.after_reload();

//# sourceMappingURL=goldly.web.js.map
