goog.provide('com.rpl.specter');
goog.require('cljs.core');
goog.require('com.rpl.specter.protocols');
goog.require('com.rpl.specter.impl');
goog.require('com.rpl.specter.navs');
goog.require('clojure.set');
com.rpl.specter.static_path_QMARK_ = (function com$rpl$specter$static_path_QMARK_(path){
if(cljs.core.sequential_QMARK_(path)){
return cljs.core.every_QMARK_(com.rpl.specter.static_path_QMARK_,path);
} else {
return (!(com.rpl.specter.impl.dynamic_param_QMARK_(path)));
}
});
com.rpl.specter.wrap_dynamic_nav = (function com$rpl$specter$wrap_dynamic_nav(f){
return (function() { 
var G__34857__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
if(((cljs.core.sequential_QMARK_(ret)) && (com.rpl.specter.static_path_QMARK_(ret)))){
return com.rpl.specter.impl.comp_paths_STAR_(ret);
} else {
if(((cljs.core.sequential_QMARK_(ret)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(ret))))){
return cljs.core.first(ret);
} else {
return ret;

}
}
};
var G__34857 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__34858__i = 0, G__34858__a = new Array(arguments.length -  0);
while (G__34858__i < G__34858__a.length) {G__34858__a[G__34858__i] = arguments[G__34858__i + 0]; ++G__34858__i;}
  args = new cljs.core.IndexedSeq(G__34858__a,0,null);
} 
return G__34857__delegate.call(this,args);};
G__34857.cljs$lang$maxFixedArity = 0;
G__34857.cljs$lang$applyTo = (function (arglist__34859){
var args = cljs.core.seq(arglist__34859);
return G__34857__delegate(args);
});
G__34857.cljs$core$IFn$_invoke$arity$variadic = G__34857__delegate;
return G__34857;
})()
;
});
/**
 * Returns a compiled version of the given path for use with
 * compiled-{select/transform/setval/etc.} functions.
 */
com.rpl.specter.comp_paths = (function com$rpl$specter$comp_paths(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34860 = arguments.length;
var i__4737__auto___34861 = (0);
while(true){
if((i__4737__auto___34861 < len__4736__auto___34860)){
args__4742__auto__.push((arguments[i__4737__auto___34861]));

var G__34862 = (i__4737__auto___34861 + (1));
i__4737__auto___34861 = G__34862;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic = (function (apath){
return com.rpl.specter.impl.comp_paths_STAR_(cljs.core.vec(apath));
}));

(com.rpl.specter.comp_paths.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.rpl.specter.comp_paths.cljs$lang$applyTo = (function (seq34383){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34383));
}));

/**
 * Version of select that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select = com.rpl.specter.impl.compiled_select_STAR_;
/**
 * Navigates to and returns a sequence of all the elements specified by the path.
 */
com.rpl.specter.select_STAR_ = (function com$rpl$specter$select_STAR_(path,structure){
var G__34384 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34385 = structure;
return (com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(G__34384,G__34385) : com.rpl.specter.compiled_select.call(null,G__34384,G__34385));
});
/**
 * Version of select-one that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one = com.rpl.specter.impl.compiled_select_one_STAR_;
/**
 * Like select, but returns either one element or nil. Throws exception if multiple elements found
 */
com.rpl.specter.select_one_STAR_ = (function com$rpl$specter$select_one_STAR_(path,structure){
var G__34386 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34387 = structure;
return (com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(G__34386,G__34387) : com.rpl.specter.compiled_select_one.call(null,G__34386,G__34387));
});
/**
 * Version of select-one! that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one_BANG_ = com.rpl.specter.impl.compiled_select_one_BANG__STAR_;
/**
 * Returns exactly one element, throws exception if zero or multiple elements found
 */
com.rpl.specter.select_one_BANG__STAR_ = (function com$rpl$specter$select_one_BANG__STAR_(path,structure){
var G__34390 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34391 = structure;
return (com.rpl.specter.compiled_select_one_BANG_.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one_BANG_.cljs$core$IFn$_invoke$arity$2(G__34390,G__34391) : com.rpl.specter.compiled_select_one_BANG_.call(null,G__34390,G__34391));
});
/**
 * Version of select-first that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_first = com.rpl.specter.impl.compiled_select_first_STAR_;
/**
 * Returns first element found.
 */
com.rpl.specter.select_first_STAR_ = (function com$rpl$specter$select_first_STAR_(path,structure){
var G__34392 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34393 = structure;
return (com.rpl.specter.compiled_select_first.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_first.cljs$core$IFn$_invoke$arity$2(G__34392,G__34393) : com.rpl.specter.compiled_select_first.call(null,G__34392,G__34393));
});
/**
 * Version of select-any that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_any = com.rpl.specter.impl.compiled_select_any_STAR_;
/**
 * Global value used to indicate no elements selected during
 *           [[select-any]].
 */
com.rpl.specter.NONE = com.rpl.specter.impl.NONE;
/**
 * Returns any element found or [[NONE]] if nothing selected. This is the most
 * efficient of the various selection operations.
 */
com.rpl.specter.select_any_STAR_ = (function com$rpl$specter$select_any_STAR_(path,structure){
var G__34396 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34397 = structure;
return (com.rpl.specter.compiled_select_any.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_any.cljs$core$IFn$_invoke$arity$2(G__34396,G__34397) : com.rpl.specter.compiled_select_any.call(null,G__34396,G__34397));
});
/**
 * Version of selected-any? that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_selected_any_QMARK_ = com.rpl.specter.impl.compiled_selected_any_QMARK__STAR_;
/**
 * Returns true if any element was selected, false otherwise.
 */
com.rpl.specter.selected_any_QMARK__STAR_ = (function com$rpl$specter$selected_any_QMARK__STAR_(path,structure){
var G__34398 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34399 = structure;
return (com.rpl.specter.compiled_selected_any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_selected_any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__34398,G__34399) : com.rpl.specter.compiled_selected_any_QMARK_.call(null,G__34398,G__34399));
});
/**
 * Version of traverse that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse = com.rpl.specter.impl.do_compiled_traverse;
/**
 * Return a reducible object that traverses over `structure` to every element
 * specified by the path
 */
com.rpl.specter.traverse_STAR_ = (function com$rpl$specter$traverse_STAR_(apath,structure){
var G__34400 = com.rpl.specter.impl.comp_paths_STAR_(apath);
var G__34401 = structure;
return (com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(G__34400,G__34401) : com.rpl.specter.compiled_traverse.call(null,G__34400,G__34401));
});
/**
 * Version of traverse-all that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse_all = com.rpl.specter.impl.compiled_traverse_all_STAR_;
/**
 * Returns a transducer that traverses over each element with the given path.
 */
com.rpl.specter.traverse_all_STAR_ = (function com$rpl$specter$traverse_all_STAR_(apath){
var G__34402 = com.rpl.specter.impl.comp_paths_STAR_(apath);
return (com.rpl.specter.compiled_traverse_all.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.compiled_traverse_all.cljs$core$IFn$_invoke$arity$1(G__34402) : com.rpl.specter.compiled_traverse_all.call(null,G__34402));
});
/**
 * Version of transform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_transform = com.rpl.specter.impl.compiled_transform_STAR_;
/**
 * Version of vtransform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_vtransform = com.rpl.specter.impl.compiled_vtransform_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by the result of running
 *   the transform-fn on it
 */
com.rpl.specter.transform_STAR_ = (function com$rpl$specter$transform_STAR_(path,transform_fn,structure){
var G__34403 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34404 = transform_fn;
var G__34405 = structure;
return (com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(G__34403,G__34404,G__34405) : com.rpl.specter.compiled_transform.call(null,G__34403,G__34404,G__34405));
});
/**
 * Version of `multi-transform` that takes in a path precompiled with `comp-paths`
 */
com.rpl.specter.compiled_multi_transform = com.rpl.specter.impl.compiled_multi_transform_STAR_;
/**
 * Just like `transform` but expects transform functions to be specified
 * inline in the path using `terminal` or `vterminal`. Error is thrown if navigation finishes
 * at a non-terminal navigator. `terminal-val` is a wrapper around `terminal` and is
 * the `multi-transform` equivalent of `setval`.
 */
com.rpl.specter.multi_transform_STAR_ = (function com$rpl$specter$multi_transform_STAR_(path,structure){
var G__34407 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34408 = structure;
return (com.rpl.specter.compiled_multi_transform.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_multi_transform.cljs$core$IFn$_invoke$arity$2(G__34407,G__34408) : com.rpl.specter.compiled_multi_transform.call(null,G__34407,G__34408));
});
/**
 * Version of setval that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_setval = com.rpl.specter.impl.compiled_setval_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by val
 */
com.rpl.specter.setval_STAR_ = (function com$rpl$specter$setval_STAR_(path,val,structure){
var G__34413 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34414 = val;
var G__34415 = structure;
return (com.rpl.specter.compiled_setval.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_setval.cljs$core$IFn$_invoke$arity$3(G__34413,G__34414,G__34415) : com.rpl.specter.compiled_setval.call(null,G__34413,G__34414,G__34415));
});
/**
 * Version of replace-in that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_replace_in = com.rpl.specter.impl.compiled_replace_in_STAR_;
/**
 * Similar to transform, except returns a pair of [transformed-structure sequence-of-user-ret].
 * The transform-fn in this case is expected to return [ret user-ret]. ret is
 * what's used to transform the data structure, while user-ret will be added to the user-ret sequence
 * in the final return. replace-in is useful for situations where you need to know the specific values
 * of what was transformed in the data structure.
 */
com.rpl.specter.replace_in_STAR_ = (function com$rpl$specter$replace_in_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34863 = arguments.length;
var i__4737__auto___34864 = (0);
while(true){
if((i__4737__auto___34864 < len__4736__auto___34863)){
args__4742__auto__.push((arguments[i__4737__auto___34864]));

var G__34865 = (i__4737__auto___34864 + (1));
i__4737__auto___34864 = G__34865;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (path,transform_fn,structure,p__34420){
var map__34421 = p__34420;
var map__34421__$1 = (((((!((map__34421 == null))))?(((((map__34421.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34421.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34421):map__34421);
var merge_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34421__$1,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),cljs.core.concat);
var G__34423 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__34424 = transform_fn;
var G__34425 = structure;
var G__34426 = new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341);
var G__34427 = merge_fn;
return (com.rpl.specter.compiled_replace_in.cljs$core$IFn$_invoke$arity$5 ? com.rpl.specter.compiled_replace_in.cljs$core$IFn$_invoke$arity$5(G__34423,G__34424,G__34425,G__34426,G__34427) : com.rpl.specter.compiled_replace_in.call(null,G__34423,G__34424,G__34425,G__34426,G__34427));
}));

(com.rpl.specter.replace_in_STAR_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(com.rpl.specter.replace_in_STAR_.cljs$lang$applyTo = (function (seq34416){
var G__34417 = cljs.core.first(seq34416);
var seq34416__$1 = cljs.core.next(seq34416);
var G__34418 = cljs.core.first(seq34416__$1);
var seq34416__$2 = cljs.core.next(seq34416__$1);
var G__34419 = cljs.core.first(seq34416__$2);
var seq34416__$3 = cljs.core.next(seq34416__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34417,G__34418,G__34419,seq34416__$3);
}));

com.rpl.specter.late_path = com.rpl.specter.impl.late_path;
com.rpl.specter.dynamic_param_QMARK_ = com.rpl.specter.impl.dynamic_param_QMARK_;
com.rpl.specter.late_resolved_fn = com.rpl.specter.impl.late_resolved_fn;
/**
 * Turns a navigator that takes one argument into a navigator that takes
 *        many arguments and uses the same navigator with each argument. There
 *        is no performance cost to using this. See implementation of `keypath`
 */
com.rpl.specter.eachnav = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (navfn){
var latenavfn = (com.rpl.specter.late_resolved_fn.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_resolved_fn.cljs$core$IFn$_invoke$arity$1(navfn) : com.rpl.specter.late_resolved_fn.call(null,navfn));
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34866__delegate = function (args){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(latenavfn,args);
};
var G__34866 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__34867__i = 0, G__34867__a = new Array(arguments.length -  0);
while (G__34867__i < G__34867__a.length) {G__34867__a[G__34867__i] = arguments[G__34867__i + 0]; ++G__34867__i;}
  args = new cljs.core.IndexedSeq(G__34867__a,0,null);
} 
return G__34866__delegate.call(this,args);};
G__34866.cljs$lang$maxFixedArity = 0;
G__34866.cljs$lang$applyTo = (function (arglist__34868){
var args = cljs.core.seq(arglist__34868);
return G__34866__delegate(args);
});
G__34866.cljs$core$IFn$_invoke$arity$variadic = G__34866__delegate;
return G__34866;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.local_declarepath = com.rpl.specter.impl.local_declarepath;


com.rpl.specter.STOP_select_STAR_ = (function com$rpl$specter$STOP_select_STAR_(structure,next_fn){
return com.rpl.specter.NONE;
});

com.rpl.specter.STOP_transform_STAR_ = (function com$rpl$specter$STOP_transform_STAR_(structure,next_fn){
return structure;
});

/**
 * Stops navigation at this point. For selection returns nothing and for
 *        transformation returns the structure unchanged
 */
com.rpl.specter.STOP = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34429 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34429 = (function (meta34430){
this.meta34430 = meta34430;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34429.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34431,meta34430__$1){
var self__ = this;
var _34431__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34429(meta34430__$1));
}));

(com.rpl.specter.t_com$rpl$specter34429.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34431){
var self__ = this;
var _34431__$1 = this;
return self__.meta34430;
}));

(com.rpl.specter.t_com$rpl$specter34429.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34429.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter34429.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return structure;
}));

(com.rpl.specter.t_com$rpl$specter34429.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34430","meta34430",721131375,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34429.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34429.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34429");

(com.rpl.specter.t_com$rpl$specter34429.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34429");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34429.
 */
com.rpl.specter.__GT_t_com$rpl$specter34429 = (function com$rpl$specter$__GT_t_com$rpl$specter34429(meta34430){
return (new com.rpl.specter.t_com$rpl$specter34429(meta34430));
});

}

return (new com.rpl.specter.t_com$rpl$specter34429(null));
})()
;
/**
 * Stays navigated at the current point. Essentially a no-op navigator.
 */
com.rpl.specter.STAY = com.rpl.specter.impl.STAY_STAR_;
/**
 * Defines an endpoint in the navigation the transform function run. The transform
 *        function works just like it does in `transform`, with collected values
 *        given as the first arguments
 */
com.rpl.specter.terminal = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34432 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34432 = (function (afn,meta34433){
this.afn = afn;
this.meta34433 = meta34433;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34432.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34434,meta34433__$1){
var self__ = this;
var _34434__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34432(self__.afn,meta34433__$1));
}));

(com.rpl.specter.t_com$rpl$specter34432.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34434){
var self__ = this;
var _34434__$1 = this;
return self__.meta34433;
}));

(com.rpl.specter.t_com$rpl$specter34432.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34432.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter34432.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.terminal_STAR_(self__.afn,vals,structure);
}));

(com.rpl.specter.t_com$rpl$specter34432.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta34433","meta34433",-871095067,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34432.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34432.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34432");

(com.rpl.specter.t_com$rpl$specter34432.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34432");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34432.
 */
com.rpl.specter.__GT_t_com$rpl$specter34432 = (function com$rpl$specter$__GT_t_com$rpl$specter34432(afn__$1,meta34433){
return (new com.rpl.specter.t_com$rpl$specter34432(afn__$1,meta34433));
});

}

return (new com.rpl.specter.t_com$rpl$specter34432(afn,null));
}));
/**
 * Defines an endpoint in the navigation the transform function run.The transform
 *        function works differently than it does in `transform`. Rather than receive
 *        collected vals spliced in as the first arguments to the function, this function
 *        always takes two arguemnts. The first is all collected vals in a vector, and
 *        the second is the navigated value.
 */
com.rpl.specter.vterminal = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34435 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34435 = (function (afn,meta34436){
this.afn = afn;
this.meta34436 = meta34436;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34435.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34437,meta34436__$1){
var self__ = this;
var _34437__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34435(self__.afn,meta34436__$1));
}));

(com.rpl.specter.t_com$rpl$specter34435.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34437){
var self__ = this;
var _34437__$1 = this;
return self__.meta34436;
}));

(com.rpl.specter.t_com$rpl$specter34435.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34435.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter34435.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(vals,structure) : self__.afn.call(null,vals,structure));
}));

(com.rpl.specter.t_com$rpl$specter34435.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta34436","meta34436",244853425,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34435.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34435.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34435");

(com.rpl.specter.t_com$rpl$specter34435.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34435");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34435.
 */
com.rpl.specter.__GT_t_com$rpl$specter34435 = (function com$rpl$specter$__GT_t_com$rpl$specter34435(afn__$1,meta34436){
return (new com.rpl.specter.t_com$rpl$specter34435(afn__$1,meta34436));
});

}

return (new com.rpl.specter.t_com$rpl$specter34435(afn,null));
}));
/**
 * Like `terminal` but specifies a val to set at the location regardless of
 * the collected values or the value at the location.
 */
com.rpl.specter.terminal_val = (function com$rpl$specter$terminal_val(v){
var G__34438 = com.rpl.specter.impl.fast_constantly(v);
return (com.rpl.specter.terminal.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.terminal.cljs$core$IFn$_invoke$arity$1(G__34438) : com.rpl.specter.terminal.call(null,G__34438));
});


com.rpl.specter.ALL_select_STAR_ = (function com$rpl$specter$ALL_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.ALL_transform_STAR_ = (function com$rpl$specter$ALL_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_transform(structure,next_fn);
});

/**
 * Navigate to every element of the collection. For maps navigates to
 *        a vector of `[key value]`.
 */
com.rpl.specter.ALL = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34440 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34440 = (function (meta34441){
this.meta34441 = meta34441;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34440.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34442,meta34441__$1){
var self__ = this;
var _34442__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34440(meta34441__$1));
}));

(com.rpl.specter.t_com$rpl$specter34440.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34442){
var self__ = this;
var _34442__$1 = this;
return self__.meta34441;
}));

(com.rpl.specter.t_com$rpl$specter34440.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34440.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return com.rpl.specter.navs.all_select(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34440.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return com.rpl.specter.navs.all_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34440.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34441","meta34441",1166708677,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34440.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34440.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34440");

(com.rpl.specter.t_com$rpl$specter34440.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34440");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34440.
 */
com.rpl.specter.__GT_t_com$rpl$specter34440 = (function com$rpl$specter$__GT_t_com$rpl$specter34440(meta34441){
return (new com.rpl.specter.t_com$rpl$specter34440(meta34441));
});

}

return (new com.rpl.specter.t_com$rpl$specter34440(null));
})()
;


com.rpl.specter.ALL_WITH_META_select_STAR_ = (function com$rpl$specter$ALL_WITH_META_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.ALL_WITH_META_transform_STAR_ = (function com$rpl$specter$ALL_WITH_META_transform_STAR_(structure,next_fn){
var m = cljs.core.meta(structure);
var res = com.rpl.specter.navs.all_transform(structure,next_fn);
if((!((res == null)))){
return cljs.core.with_meta(res,m);
} else {
return null;
}
});

/**
 * Same as ALL, except maintains metadata on the structure.
 */
com.rpl.specter.ALL_WITH_META = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34443 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34443 = (function (meta34444){
this.meta34444 = meta34444;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34443.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34445,meta34444__$1){
var self__ = this;
var _34445__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34443(meta34444__$1));
}));

(com.rpl.specter.t_com$rpl$specter34443.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34445){
var self__ = this;
var _34445__$1 = this;
return self__.meta34444;
}));

(com.rpl.specter.t_com$rpl$specter34443.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34443.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return com.rpl.specter.navs.all_select(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34443.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var m = cljs.core.meta(structure);
var res = com.rpl.specter.navs.all_transform(structure,next_fn);
if((!((res == null)))){
return cljs.core.with_meta(res,m);
} else {
return null;
}
}));

(com.rpl.specter.t_com$rpl$specter34443.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34444","meta34444",1931128529,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34443.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34443.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34443");

(com.rpl.specter.t_com$rpl$specter34443.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34443");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34443.
 */
com.rpl.specter.__GT_t_com$rpl$specter34443 = (function com$rpl$specter$__GT_t_com$rpl$specter34443(meta34444){
return (new com.rpl.specter.t_com$rpl$specter34443(meta34444));
});

}

return (new com.rpl.specter.t_com$rpl$specter34443(null));
})()
;


com.rpl.specter.MAP_VALS_select_STAR_ = (function com$rpl$specter$MAP_VALS_select_STAR_(structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__30347__auto__,v){
var ret__30348__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(v) : next_fn.call(null,v));
if((ret__30348__auto__ === com.rpl.specter.NONE)){
return curr__30347__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__30348__auto__)){
return cljs.core.reduced(ret__30348__auto__);
} else {
return ret__30348__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals(structure));
});

com.rpl.specter.MAP_VALS_transform_STAR_ = (function com$rpl$specter$MAP_VALS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_vals_transform(structure,next_fn);
});

/**
 * Navigate to each value of the map. This is more efficient than
 *        navigating via [ALL LAST]
 */
com.rpl.specter.MAP_VALS = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34446 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34446 = (function (meta34447){
this.meta34447 = meta34447;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34446.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34448,meta34447__$1){
var self__ = this;
var _34448__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34446(meta34447__$1));
}));

(com.rpl.specter.t_com$rpl$specter34446.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34448){
var self__ = this;
var _34448__$1 = this;
return self__.meta34447;
}));

(com.rpl.specter.t_com$rpl$specter34446.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34446.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__30347__auto__,v){
var ret__30348__auto__ = next_fn(v);
if((ret__30348__auto__ === com.rpl.specter.NONE)){
return curr__30347__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__30348__auto__)){
return cljs.core.reduced(ret__30348__auto__);
} else {
return ret__30348__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals(structure));
}));

(com.rpl.specter.t_com$rpl$specter34446.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return com.rpl.specter.navs.map_vals_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34446.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34447","meta34447",-387355873,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34446.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34446.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34446");

(com.rpl.specter.t_com$rpl$specter34446.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34446");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34446.
 */
com.rpl.specter.__GT_t_com$rpl$specter34446 = (function com$rpl$specter$__GT_t_com$rpl$specter34446(meta34447){
return (new com.rpl.specter.t_com$rpl$specter34446(meta34447));
});

}

return (new com.rpl.specter.t_com$rpl$specter34446(null));
})()
;


com.rpl.specter.MAP_KEYS_select_STAR_ = (function com$rpl$specter$MAP_KEYS_select_STAR_(structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__30347__auto__,k){
var ret__30348__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(k) : next_fn.call(null,k));
if((ret__30348__auto__ === com.rpl.specter.NONE)){
return curr__30347__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__30348__auto__)){
return cljs.core.reduced(ret__30348__auto__);
} else {
return ret__30348__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys(structure));
});

com.rpl.specter.MAP_KEYS_transform_STAR_ = (function com$rpl$specter$MAP_KEYS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_keys_transform(structure,next_fn);
});

/**
 * Navigate to each key of the map. This is more efficient than
 *        navigating via [ALL FIRST]
 */
com.rpl.specter.MAP_KEYS = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34449 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34449 = (function (meta34450){
this.meta34450 = meta34450;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34449.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34451,meta34450__$1){
var self__ = this;
var _34451__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34449(meta34450__$1));
}));

(com.rpl.specter.t_com$rpl$specter34449.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34451){
var self__ = this;
var _34451__$1 = this;
return self__.meta34450;
}));

(com.rpl.specter.t_com$rpl$specter34449.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34449.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__30347__auto__,k){
var ret__30348__auto__ = next_fn(k);
if((ret__30348__auto__ === com.rpl.specter.NONE)){
return curr__30347__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__30348__auto__)){
return cljs.core.reduced(ret__30348__auto__);
} else {
return ret__30348__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys(structure));
}));

(com.rpl.specter.t_com$rpl$specter34449.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return com.rpl.specter.navs.map_keys_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34449.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34450","meta34450",222943141,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34449.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34449.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34449");

(com.rpl.specter.t_com$rpl$specter34449.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34449");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34449.
 */
com.rpl.specter.__GT_t_com$rpl$specter34449 = (function com$rpl$specter$__GT_t_com$rpl$specter34449(meta34450){
return (new com.rpl.specter.t_com$rpl$specter34449(meta34450));
});

}

return (new com.rpl.specter.t_com$rpl$specter34449(null));
})()
;
com.rpl.specter.VAL = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34452 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34452 = (function (meta34453){
this.meta34453 = meta34453;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34452.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34454,meta34453__$1){
var self__ = this;
var _34454__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34452(meta34453__$1));
}));

(com.rpl.specter.t_com$rpl$specter34452.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34454){
var self__ = this;
var _34454__$1 = this;
return self__.meta34453;
}));

(com.rpl.specter.t_com$rpl$specter34452.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34452.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__33374__auto__,vals__33375__auto__,structure,next_fn__33376__auto__){
var self__ = this;
var this__33374__auto____$1 = this;
var G__34455 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33375__auto__,structure);
var G__34456 = structure;
return (next_fn__33376__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33376__auto__.cljs$core$IFn$_invoke$arity$2(G__34455,G__34456) : next_fn__33376__auto__.call(null,G__34455,G__34456));
}));

(com.rpl.specter.t_com$rpl$specter34452.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__33374__auto__,vals__33375__auto__,structure,next_fn__33376__auto__){
var self__ = this;
var this__33374__auto____$1 = this;
var G__34457 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33375__auto__,structure);
var G__34458 = structure;
return (next_fn__33376__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33376__auto__.cljs$core$IFn$_invoke$arity$2(G__34457,G__34458) : next_fn__33376__auto__.call(null,G__34457,G__34458));
}));

(com.rpl.specter.t_com$rpl$specter34452.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34453","meta34453",310650864,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34452.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34452.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34452");

(com.rpl.specter.t_com$rpl$specter34452.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34452");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34452.
 */
com.rpl.specter.__GT_t_com$rpl$specter34452 = (function com$rpl$specter$__GT_t_com$rpl$specter34452(meta34453){
return (new com.rpl.specter.t_com$rpl$specter34452(meta34453));
});

}

return (new com.rpl.specter.t_com$rpl$specter34452(null));
})()
;
/**
 * Navigate to the last element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.LAST = (com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last) : com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last));
/**
 * Navigate to the first element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.FIRST = (com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first) : com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first));


com.rpl.specter.srange_dynamic_select_STAR_ = (function com$rpl$specter$srange_dynamic_select_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = (start_index_fn.cljs$core$IFn$_invoke$arity$1 ? start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : start_index_fn.call(null,structure));
return com.rpl.specter.navs.srange_select(structure,s,com.rpl.specter.navs.invoke_end_fn(end_index_fn,structure,s),next_fn);
});

com.rpl.specter.srange_dynamic_transform_STAR_ = (function com$rpl$specter$srange_dynamic_transform_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = (start_index_fn.cljs$core$IFn$_invoke$arity$1 ? start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : start_index_fn.call(null,structure));
var G__34459 = structure;
var G__34460 = s;
var G__34461 = com.rpl.specter.navs.invoke_end_fn(end_index_fn,structure,s);
var G__34462 = next_fn;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(G__34459,G__34460,G__34461,G__34462) : com.rpl.specter.navs.srange_transform.call(null,G__34459,G__34460,G__34461,G__34462));
});

/**
 * Uses start-index-fn and end-index-fn to determine the bounds of the subsequence
 *        to select when navigating. `start-index-fn` takes in the structure as input. `end-index-fn`
 *        can be one of two forms. If a regular function (e.g. defined with `fn`), it takes in only the structure as input. If a function defined using special `end-fn` macro, it takes in the structure and the result of `start-index-fn`.
 */
com.rpl.specter.srange_dynamic = com.rpl.specter.impl.direct_nav_obj((function (start_index_fn,end_index_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34463 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34463 = (function (start_index_fn,end_index_fn,meta34464){
this.start_index_fn = start_index_fn;
this.end_index_fn = end_index_fn;
this.meta34464 = meta34464;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34463.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34465,meta34464__$1){
var self__ = this;
var _34465__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34463(self__.start_index_fn,self__.end_index_fn,meta34464__$1));
}));

(com.rpl.specter.t_com$rpl$specter34463.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34465){
var self__ = this;
var _34465__$1 = this;
return self__.meta34464;
}));

(com.rpl.specter.t_com$rpl$specter34463.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34463.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var s = (self__.start_index_fn.cljs$core$IFn$_invoke$arity$1 ? self__.start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.start_index_fn.call(null,structure));
return com.rpl.specter.navs.srange_select(structure,s,com.rpl.specter.navs.invoke_end_fn(self__.end_index_fn,structure,s),next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34463.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var s = (self__.start_index_fn.cljs$core$IFn$_invoke$arity$1 ? self__.start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.start_index_fn.call(null,structure));
var G__34477 = structure;
var G__34478 = s;
var G__34479 = com.rpl.specter.navs.invoke_end_fn(self__.end_index_fn,structure,s);
var G__34480 = next_fn;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(G__34477,G__34478,G__34479,G__34480) : com.rpl.specter.navs.srange_transform.call(null,G__34477,G__34478,G__34479,G__34480));
}));

(com.rpl.specter.t_com$rpl$specter34463.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start-index-fn","start-index-fn",-344842645,null),new cljs.core.Symbol(null,"end-index-fn","end-index-fn",1237092062,null),new cljs.core.Symbol(null,"meta34464","meta34464",24082378,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34463.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34463.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34463");

(com.rpl.specter.t_com$rpl$specter34463.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34463");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34463.
 */
com.rpl.specter.__GT_t_com$rpl$specter34463 = (function com$rpl$specter$__GT_t_com$rpl$specter34463(start_index_fn__$1,end_index_fn__$1,meta34464){
return (new com.rpl.specter.t_com$rpl$specter34463(start_index_fn__$1,end_index_fn__$1,meta34464));
});

}

return (new com.rpl.specter.t_com$rpl$specter34463(start_index_fn,end_index_fn,null));
}));


com.rpl.specter.srange_select_STAR_ = (function com$rpl$specter$srange_select_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_select(structure,start,end,next_fn);
});

com.rpl.specter.srange_transform_STAR_ = (function com$rpl$specter$srange_transform_STAR_(start,end,structure,next_fn){
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(structure,start,end,next_fn) : com.rpl.specter.navs.srange_transform.call(null,structure,start,end,next_fn));
});

/**
 * Navigates to the subsequence bound by the indexes start (inclusive)
 *        and end (exclusive)
 */
com.rpl.specter.srange = com.rpl.specter.impl.direct_nav_obj((function (start,end){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34487 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34487 = (function (start,end,meta34488){
this.start = start;
this.end = end;
this.meta34488 = meta34488;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34487.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34489,meta34488__$1){
var self__ = this;
var _34489__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34487(self__.start,self__.end,meta34488__$1));
}));

(com.rpl.specter.t_com$rpl$specter34487.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34489){
var self__ = this;
var _34489__$1 = this;
return self__.meta34488;
}));

(com.rpl.specter.t_com$rpl$specter34487.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34487.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return com.rpl.specter.navs.srange_select(structure,self__.start,self__.end,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34487.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(structure,self__.start,self__.end,next_fn) : com.rpl.specter.navs.srange_transform.call(null,structure,self__.start,self__.end,next_fn));
}));

(com.rpl.specter.t_com$rpl$specter34487.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"meta34488","meta34488",550985882,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34487.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34487.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34487");

(com.rpl.specter.t_com$rpl$specter34487.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34487");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34487.
 */
com.rpl.specter.__GT_t_com$rpl$specter34487 = (function com$rpl$specter$__GT_t_com$rpl$specter34487(start__$1,end__$1,meta34488){
return (new com.rpl.specter.t_com$rpl$specter34487(start__$1,end__$1,meta34488));
});

}

return (new com.rpl.specter.t_com$rpl$specter34487(start,end,null));
}));


com.rpl.specter.continuous_subseqs_select_STAR_ = (function com$rpl$specter$continuous_subseqs_select_STAR_(pred,structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__30347__auto__,p__34494){
var vec__34495 = p__34494;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34495,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34495,(1),null);
var ret__30348__auto__ = com.rpl.specter.navs.srange_select(structure,s,e,next_fn);
if((ret__30348__auto__ === com.rpl.specter.NONE)){
return curr__30347__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__30348__auto__)){
return cljs.core.reduced(ret__30348__auto__);
} else {
return ret__30348__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges(structure,pred));
});

com.rpl.specter.continuous_subseqs_transform_STAR_ = (function com$rpl$specter$continuous_subseqs_transform_STAR_(pred,structure,next_fn){
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_(pred,structure,next_fn);
});

/**
 * Navigates to every continuous subsequence of elements matching `pred`
 */
com.rpl.specter.continuous_subseqs = com.rpl.specter.impl.direct_nav_obj((function (pred){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34498 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34498 = (function (pred,meta34499){
this.pred = pred;
this.meta34499 = meta34499;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34498.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34500,meta34499__$1){
var self__ = this;
var _34500__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34498(self__.pred,meta34499__$1));
}));

(com.rpl.specter.t_com$rpl$specter34498.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34500){
var self__ = this;
var _34500__$1 = this;
return self__.meta34499;
}));

(com.rpl.specter.t_com$rpl$specter34498.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34498.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__30347__auto__,p__34502){
var vec__34503 = p__34502;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34503,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34503,(1),null);
var ret__30348__auto__ = com.rpl.specter.navs.srange_select(structure,s,e,next_fn);
if((ret__30348__auto__ === com.rpl.specter.NONE)){
return curr__30347__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__30348__auto__)){
return cljs.core.reduced(ret__30348__auto__);
} else {
return ret__30348__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges(structure,self__.pred));
}));

(com.rpl.specter.t_com$rpl$specter34498.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_(self__.pred,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34498.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"meta34499","meta34499",-1695936349,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34498.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34498.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34498");

(com.rpl.specter.t_com$rpl$specter34498.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34498");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34498.
 */
com.rpl.specter.__GT_t_com$rpl$specter34498 = (function com$rpl$specter$__GT_t_com$rpl$specter34498(pred__$1,meta34499){
return (new com.rpl.specter.t_com$rpl$specter34498(pred__$1,meta34499));
});

}

return (new com.rpl.specter.t_com$rpl$specter34498(pred,null));
}));


com.rpl.specter.BEGINNING_select_STAR_ = (function com$rpl$specter$BEGINNING_select_STAR_(structure,next_fn){
var G__34506 = ((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34506) : next_fn.call(null,G__34506));
});

com.rpl.specter.BEGINNING_transform_STAR_ = (function com$rpl$specter$BEGINNING_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1("") : next_fn.call(null,""))),structure].join('');
} else {
var to_prepend = (function (){var G__34507 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34507) : next_fn.call(null,G__34507));
})();
return com.rpl.specter.navs.prepend_all(structure,to_prepend);
}
});

/**
 * Navigate to the empty subsequence before the first element of the collection.
 */
com.rpl.specter.BEGINNING = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34508 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34508 = (function (meta34509){
this.meta34509 = meta34509;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34508.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34510,meta34509__$1){
var self__ = this;
var _34510__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34508(meta34509__$1));
}));

(com.rpl.specter.t_com$rpl$specter34508.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34510){
var self__ = this;
var _34510__$1 = this;
return self__.meta34509;
}));

(com.rpl.specter.t_com$rpl$specter34508.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34508.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
}));

(com.rpl.specter.t_com$rpl$specter34508.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn("")),structure].join('');
} else {
var to_prepend = next_fn(cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all(structure,to_prepend);
}
}));

(com.rpl.specter.t_com$rpl$specter34508.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34509","meta34509",-65411086,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34508.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34508.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34508");

(com.rpl.specter.t_com$rpl$specter34508.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34508");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34508.
 */
com.rpl.specter.__GT_t_com$rpl$specter34508 = (function com$rpl$specter$__GT_t_com$rpl$specter34508(meta34509){
return (new com.rpl.specter.t_com$rpl$specter34508(meta34509));
});

}

return (new com.rpl.specter.t_com$rpl$specter34508(null));
})()
;


com.rpl.specter.END_select_STAR_ = (function com$rpl$specter$END_select_STAR_(structure,next_fn){
var G__34511 = ((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34511) : next_fn.call(null,G__34511));
});

com.rpl.specter.END_transform_STAR_ = (function com$rpl$specter$END_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [structure,cljs.core.str.cljs$core$IFn$_invoke$arity$1((next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1("") : next_fn.call(null,"")))].join('');
} else {
var to_append = (function (){var G__34512 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34512) : next_fn.call(null,G__34512));
})();
return com.rpl.specter.navs.append_all(structure,to_append);
}
});

/**
 * Navigate to the empty subsequence after the last element of the collection.
 */
com.rpl.specter.END = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34513 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34513 = (function (meta34514){
this.meta34514 = meta34514;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34513.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34515,meta34514__$1){
var self__ = this;
var _34515__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34513(meta34514__$1));
}));

(com.rpl.specter.t_com$rpl$specter34513.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34515){
var self__ = this;
var _34515__$1 = this;
return self__.meta34514;
}));

(com.rpl.specter.t_com$rpl$specter34513.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34513.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
}));

(com.rpl.specter.t_com$rpl$specter34513.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
if(typeof structure === 'string'){
return [structure,cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn(""))].join('');
} else {
var to_append = next_fn(cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all(structure,to_append);
}
}));

(com.rpl.specter.t_com$rpl$specter34513.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34514","meta34514",1870491545,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34513.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34513.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34513");

(com.rpl.specter.t_com$rpl$specter34513.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34513");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34513.
 */
com.rpl.specter.__GT_t_com$rpl$specter34513 = (function com$rpl$specter$__GT_t_com$rpl$specter34513(meta34514){
return (new com.rpl.specter.t_com$rpl$specter34513(meta34514));
});

}

return (new com.rpl.specter.t_com$rpl$specter34513(null));
})()
;


com.rpl.specter.NONE_ELEM_select_STAR_ = (function com$rpl$specter$NONE_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.NONE_ELEM_transform_STAR_ = (function com$rpl$specter$NONE_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(structure,newe);
}
}
});

/**
 * Navigate to 'void' elem in the set.
 *        For transformations - if result is not `NONE`,
 *        then add that value to the set.
 */
com.rpl.specter.NONE_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34516 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34516 = (function (meta34517){
this.meta34517 = meta34517;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34516.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34518,meta34517__$1){
var self__ = this;
var _34518__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34516(meta34517__$1));
}));

(com.rpl.specter.t_com$rpl$specter34516.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34518){
var self__ = this;
var _34518__$1 = this;
return self__.meta34517;
}));

(com.rpl.specter.t_com$rpl$specter34516.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34516.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter34516.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(structure,newe);
}
}
}));

(com.rpl.specter.t_com$rpl$specter34516.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34517","meta34517",-1525761406,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34516.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34516.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34516");

(com.rpl.specter.t_com$rpl$specter34516.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34516");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34516.
 */
com.rpl.specter.__GT_t_com$rpl$specter34516 = (function com$rpl$specter$__GT_t_com$rpl$specter34516(meta34517){
return (new com.rpl.specter.t_com$rpl$specter34516(meta34517));
});

}

return (new com.rpl.specter.t_com$rpl$specter34516(null));
})()
;


com.rpl.specter.BEFORE_ELEM_select_STAR_ = (function com$rpl$specter$BEFORE_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.BEFORE_ELEM_transform_STAR_ = (function com$rpl$specter$BEFORE_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one(structure,newe);
}
});

/**
 * Navigate to 'void' element before the sequence.
 *        For transformations – if result is not `NONE`,
 *        then prepend that value.
 */
com.rpl.specter.BEFORE_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34519 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34519 = (function (meta34520){
this.meta34520 = meta34520;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34519.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34521,meta34520__$1){
var self__ = this;
var _34521__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34519(meta34520__$1));
}));

(com.rpl.specter.t_com$rpl$specter34519.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34521){
var self__ = this;
var _34521__$1 = this;
return self__.meta34520;
}));

(com.rpl.specter.t_com$rpl$specter34519.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34519.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter34519.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one(structure,newe);
}
}));

(com.rpl.specter.t_com$rpl$specter34519.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34520","meta34520",-24261430,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34519.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34519.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34519");

(com.rpl.specter.t_com$rpl$specter34519.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34519");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34519.
 */
com.rpl.specter.__GT_t_com$rpl$specter34519 = (function com$rpl$specter$__GT_t_com$rpl$specter34519(meta34520){
return (new com.rpl.specter.t_com$rpl$specter34519(meta34520));
});

}

return (new com.rpl.specter.t_com$rpl$specter34519(null));
})()
;


com.rpl.specter.AFTER_ELEM_select_STAR_ = (function com$rpl$specter$AFTER_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.AFTER_ELEM_transform_STAR_ = (function com$rpl$specter$AFTER_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one(structure,newe);
}
});

/**
 * Navigate to 'void' element after the sequence.
 *        For transformations – if result is not `NONE`,
 *        then append that value.
 */
com.rpl.specter.AFTER_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34522 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34522 = (function (meta34523){
this.meta34523 = meta34523;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34522.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34524,meta34523__$1){
var self__ = this;
var _34524__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34522(meta34523__$1));
}));

(com.rpl.specter.t_com$rpl$specter34522.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34524){
var self__ = this;
var _34524__$1 = this;
return self__.meta34523;
}));

(com.rpl.specter.t_com$rpl$specter34522.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34522.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter34522.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one(structure,newe);
}
}));

(com.rpl.specter.t_com$rpl$specter34522.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34523","meta34523",-1516978372,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34522.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34522.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34522");

(com.rpl.specter.t_com$rpl$specter34522.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34522");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34522.
 */
com.rpl.specter.__GT_t_com$rpl$specter34522 = (function com$rpl$specter$__GT_t_com$rpl$specter34522(meta34523){
return (new com.rpl.specter.t_com$rpl$specter34522(meta34523));
});

}

return (new com.rpl.specter.t_com$rpl$specter34522(null));
})()
;


com.rpl.specter.subset_select_STAR_ = (function com$rpl$specter$subset_select_STAR_(aset,structure,next_fn){
var G__34525 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,aset);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34525) : next_fn.call(null,G__34525));
});

com.rpl.specter.subset_transform_STAR_ = (function com$rpl$specter$subset_transform_STAR_(aset,structure,next_fn){
var subset = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,aset);
var newset = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(subset) : next_fn.call(null,subset));
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(structure,subset),newset);
});

/**
 * Navigates to the specified subset (by taking an intersection).
 *        In a transform, that subset in the original set is changed to the
 *        new value of the subset.
 */
com.rpl.specter.subset = com.rpl.specter.impl.direct_nav_obj((function (aset){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34526 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34526 = (function (aset,meta34527){
this.aset = aset;
this.meta34527 = meta34527;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34526.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34528,meta34527__$1){
var self__ = this;
var _34528__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34526(self__.aset,meta34527__$1));
}));

(com.rpl.specter.t_com$rpl$specter34526.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34528){
var self__ = this;
var _34528__$1 = this;
return self__.meta34527;
}));

(com.rpl.specter.t_com$rpl$specter34526.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34526.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,self__.aset));
}));

(com.rpl.specter.t_com$rpl$specter34526.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var subset = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,self__.aset);
var newset = next_fn(subset);
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(structure,subset),newset);
}));

(com.rpl.specter.t_com$rpl$specter34526.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"aset","aset",900773178,null),new cljs.core.Symbol(null,"meta34527","meta34527",-1553329371,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34526.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34526.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34526");

(com.rpl.specter.t_com$rpl$specter34526.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34526");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34526.
 */
com.rpl.specter.__GT_t_com$rpl$specter34526 = (function com$rpl$specter$__GT_t_com$rpl$specter34526(aset__$1,meta34527){
return (new com.rpl.specter.t_com$rpl$specter34526(aset__$1,meta34527));
});

}

return (new com.rpl.specter.t_com$rpl$specter34526(aset,null));
}));


com.rpl.specter.submap_select_STAR_ = (function com$rpl$specter$submap_select_STAR_(m_keys,structure,next_fn){
var G__34529 = cljs.core.select_keys(structure,m_keys);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34529) : next_fn.call(null,G__34529));
});

com.rpl.specter.submap_transform_STAR_ = (function com$rpl$specter$submap_transform_STAR_(m_keys,structure,next_fn){
var submap = cljs.core.select_keys(structure,m_keys);
var newmap = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(submap) : next_fn.call(null,submap));
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,structure,m_keys),newmap], 0));
});

/**
 * Navigates to the specified submap (using select-keys).
 *        In a transform, that submap in the original map is changed to the new
 *        value of the submap.
 */
com.rpl.specter.submap = com.rpl.specter.impl.direct_nav_obj((function (m_keys){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34530 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34530 = (function (m_keys,meta34531){
this.m_keys = m_keys;
this.meta34531 = meta34531;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34530.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34532,meta34531__$1){
var self__ = this;
var _34532__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34530(self__.m_keys,meta34531__$1));
}));

(com.rpl.specter.t_com$rpl$specter34530.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34532){
var self__ = this;
var _34532__$1 = this;
return self__.meta34531;
}));

(com.rpl.specter.t_com$rpl$specter34530.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34530.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(cljs.core.select_keys(structure,self__.m_keys));
}));

(com.rpl.specter.t_com$rpl$specter34530.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var submap = cljs.core.select_keys(structure,self__.m_keys);
var newmap = next_fn(submap);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,structure,self__.m_keys),newmap], 0));
}));

(com.rpl.specter.t_com$rpl$specter34530.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"m-keys","m-keys",-197459035,null),new cljs.core.Symbol(null,"meta34531","meta34531",1160273478,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34530.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34530.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34530");

(com.rpl.specter.t_com$rpl$specter34530.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34530");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34530.
 */
com.rpl.specter.__GT_t_com$rpl$specter34530 = (function com$rpl$specter$__GT_t_com$rpl$specter34530(m_keys__$1,meta34531){
return (new com.rpl.specter.t_com$rpl$specter34530(m_keys__$1,meta34531));
});

}

return (new com.rpl.specter.t_com$rpl$specter34530(m_keys,null));
}));
/**
 * Navigates to a sequence that contains the results of (select ...),
 *   but is a view to the original structure that can be transformed.
 * 
 *   Requires that the input navigators will walk the structure's
 *   children in the same order when executed on "select" and then
 *   "transform".
 * 
 *   If transformed sequence is smaller than input sequence, missing entries
 *   will be filled in with NONE, triggering removal if supported by that navigator.
 * 
 *   Value collection (e.g. collect, collect-one) may not be used in the subpath.
 */
com.rpl.specter.subselect = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34894__delegate = function (path){
var builder__33377__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34533 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34533 = (function (path,late,meta34534){
this.path = path;
this.late = late;
this.meta34534 = meta34534;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34533.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34535,meta34534__$1){
var self__ = this;
var _34535__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34533(self__.path,self__.late,meta34534__$1));
}));

(com.rpl.specter.t_com$rpl$specter34533.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34535){
var self__ = this;
var _34535__$1 = this;
return self__.meta34534;
}));

(com.rpl.specter.t_com$rpl$specter34533.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34533.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn((com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
}));

(com.rpl.specter.t_com$rpl$specter34533.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var select_result = (com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure));
var transformed = next_fn(select_result);
var values_to_insert = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(transformed));
var G__34536 = self__.late;
var G__34537 = (function (_){
var vs = com.rpl.specter.impl.get_cell(values_to_insert);
if(cljs.core.truth_(vs)){
com.rpl.specter.impl.update_cell_BANG_(values_to_insert,cljs.core.next);

return cljs.core.first(vs);
} else {
return com.rpl.specter.NONE;
}
});
var G__34538 = structure;
return (com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(G__34536,G__34537,G__34538) : com.rpl.specter.compiled_transform.call(null,G__34536,G__34537,G__34538));
}));

(com.rpl.specter.t_com$rpl$specter34533.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta34534","meta34534",2083469526,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34533.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34533.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34533");

(com.rpl.specter.t_com$rpl$specter34533.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34533");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34533.
 */
com.rpl.specter.__GT_t_com$rpl$specter34533 = (function com$rpl$specter$__GT_t_com$rpl$specter34533(path__$1,late__$1,meta34534){
return (new com.rpl.specter.t_com$rpl$specter34533(path__$1,late__$1,meta34534));
});

}

return (new com.rpl.specter.t_com$rpl$specter34533(path,late,null));
}));
var curr_params__33378__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33378__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33377__auto__,curr_params__33378__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33377__auto__,curr_params__33378__auto__,null);
}
};
var G__34894 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34895__i = 0, G__34895__a = new Array(arguments.length -  0);
while (G__34895__i < G__34895__a.length) {G__34895__a[G__34895__i] = arguments[G__34895__i + 0]; ++G__34895__i;}
  path = new cljs.core.IndexedSeq(G__34895__a,0,null);
} 
return G__34894__delegate.call(this,path);};
G__34894.cljs$lang$maxFixedArity = 0;
G__34894.cljs$lang$applyTo = (function (arglist__34896){
var path = cljs.core.seq(arglist__34896);
return G__34894__delegate(path);
});
G__34894.cljs$core$IFn$_invoke$arity$variadic = G__34894__delegate;
return G__34894;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the given key in the map (not to the value). Navigates only if the
 *        key currently exists in the map. Can transform to NONE to remove the key/value
 *        pair from the map.
 */
com.rpl.specter.map_key = com.rpl.specter.impl.direct_nav_obj((function (key){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34539 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34539 = (function (key,meta34540){
this.key = key;
this.meta34540 = meta34540;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34539.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34541,meta34540__$1){
var self__ = this;
var _34541__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34539(self__.key,meta34540__$1));
}));

(com.rpl.specter.t_com$rpl$specter34539.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34541){
var self__ = this;
var _34541__$1 = this;
return self__.meta34540;
}));

(com.rpl.specter.t_com$rpl$specter34539.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34539.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.key)){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.key) : next_fn.call(null,vals,self__.key));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter34539.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.key)){
var newkey = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.key) : next_fn.call(null,vals,self__.key));
var dissoced = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(structure,self__.key);
if((com.rpl.specter.NONE === newkey)){
return dissoced;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(dissoced,newkey,cljs.core.get.cljs$core$IFn$_invoke$arity$2(structure,self__.key));
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter34539.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"meta34540","meta34540",779941596,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34539.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34539.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34539");

(com.rpl.specter.t_com$rpl$specter34539.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34539");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34539.
 */
com.rpl.specter.__GT_t_com$rpl$specter34539 = (function com$rpl$specter$__GT_t_com$rpl$specter34539(key__$1,meta34540){
return (new com.rpl.specter.t_com$rpl$specter34539(key__$1,meta34540));
});

}

return (new com.rpl.specter.t_com$rpl$specter34539(key,null));
}));
/**
 * Navigates to the given element in the set only if it exists in the set.
 *        Can transform to NONE to remove the element from the set.
 */
com.rpl.specter.set_elem = com.rpl.specter.impl.direct_nav_obj((function (elem){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34542 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34542 = (function (elem,meta34543){
this.elem = elem;
this.meta34543 = meta34543;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34542.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34544,meta34543__$1){
var self__ = this;
var _34544__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34542(self__.elem,meta34543__$1));
}));

(com.rpl.specter.t_com$rpl$specter34542.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34544){
var self__ = this;
var _34544__$1 = this;
return self__.meta34543;
}));

(com.rpl.specter.t_com$rpl$specter34542.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34542.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.elem)){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.elem) : next_fn.call(null,vals,self__.elem));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter34542.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.elem)){
var newelem = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.elem) : next_fn.call(null,vals,self__.elem));
var removed = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(structure,self__.elem);
if((com.rpl.specter.NONE === newelem)){
return removed;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(removed,newelem);
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter34542.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"elem","elem",-2035804713,null),new cljs.core.Symbol(null,"meta34543","meta34543",978882012,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34542.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34542.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34542");

(com.rpl.specter.t_com$rpl$specter34542.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34542");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34542.
 */
com.rpl.specter.__GT_t_com$rpl$specter34542 = (function com$rpl$specter$__GT_t_com$rpl$specter34542(elem__$1,meta34543){
return (new com.rpl.specter.t_com$rpl$specter34542(elem__$1,meta34543));
});

}

return (new com.rpl.specter.t_com$rpl$specter34542(elem,null));
}));
/**
 * Navigate to the specified keys one after another. If navigate to NONE,
 *           that element is removed from the map or vector.
 */
com.rpl.specter.keypath = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.keypath_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.keypath_STAR_));
/**
 * Navigate to the specified keys one after another, only if they exist
 *           in the data structure. If navigate to NONE, that element is removed
 *           from the map or vector.
 */
com.rpl.specter.must = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.must_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.must_STAR_));
/**
 * Navigate to the specified indices one after another. If navigate to
 *          NONE, that element is removed from the sequence.
 */
com.rpl.specter.nthpath = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.nthpath_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.nthpath_STAR_));
/**
 * Navigates to the empty space between the index and the prior index. For select
 *        navigates to NONE, and transforms to non-NONE insert at that position.
 */
com.rpl.specter.before_index = com.rpl.specter.impl.direct_nav_obj((function (index){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34545 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34545 = (function (index,meta34546){
this.index = index;
this.meta34546 = meta34546;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34545.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34547,meta34546__$1){
var self__ = this;
var _34547__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34545(self__.index,meta34546__$1));
}));

(com.rpl.specter.t_com$rpl$specter34545.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34547){
var self__ = this;
var _34547__$1 = this;
return self__.meta34546;
}));

(com.rpl.specter.t_com$rpl$specter34545.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34545.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter34545.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var v = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,com.rpl.specter.NONE) : next_fn.call(null,vals,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === v)){
return structure;
} else {
return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__33384__auto__ = com.rpl.specter.pathcache34548;
var info__33384__auto____$1 = (((info__33384__auto__ == null))?(function (){var info34549 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.srange,new cljs.core.Var(function(){return com.rpl.specter.srange;},new cljs.core.Symbol("com.rpl.specter","srange","com.rpl.specter/srange",-978851939,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"srange","srange",-1324254972,null),"com/rpl/specter.cljc",9,1,755,758,cljs.core.List.EMPTY,"Navigates to the subsequence bound by the indexes start (inclusive)\n          and end (exclusive)",(cljs.core.truth_(com.rpl.specter.srange)?com.rpl.specter.srange.cljs$lang$test:null)])),new cljs.core.Symbol(null,"srange","srange",-1324254972,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(self__.index,new cljs.core.Symbol(null,"index","index",108845612,null)),com.rpl.specter.impl.__GT_LocalSym(self__.index,new cljs.core.Symbol(null,"index","index",108845612,null))], null),cljs.core.list(new cljs.core.Symbol(null,"srange","srange",-1324254972,null),new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"srange","srange",-1324254972,null),new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)], null));
com.rpl.specter.pathcache34548 = info34549;

return info34549;
})():info__33384__auto__);
var precompiled34550 = com.rpl.specter.impl.cached_path_info_precompiled(info__33384__auto____$1);
var dynamic_QMARK___33385__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33384__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33385__auto__)){
var G__34551 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.srange,self__.index,self__.index], null);
return (precompiled34550.cljs$core$IFn$_invoke$arity$1 ? precompiled34550.cljs$core$IFn$_invoke$arity$1(G__34551) : precompiled34550.call(null,G__34551));
} else {
return precompiled34550;
}
})(),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v], null),structure);
}
}));

(com.rpl.specter.t_com$rpl$specter34545.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"meta34546","meta34546",-9742122,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34545.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34545.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34545");

(com.rpl.specter.t_com$rpl$specter34545.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34545");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34545.
 */
com.rpl.specter.__GT_t_com$rpl$specter34545 = (function com$rpl$specter$__GT_t_com$rpl$specter34545(index__$1,meta34546){
return (new com.rpl.specter.t_com$rpl$specter34545(index__$1,meta34546));
});

}

return (new com.rpl.specter.t_com$rpl$specter34545(index,null));
}));
/**
 * Navigates to the index of the sequence if within 0 and size. Transforms move element
 *        at that index to the new index, shifting other elements in the sequence.
 */
com.rpl.specter.index_nav = com.rpl.specter.impl.direct_nav_obj((function (i){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34552 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34552 = (function (i,meta34553){
this.i = i;
this.meta34553 = meta34553;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34552.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34554,meta34553__$1){
var self__ = this;
var _34554__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34552(self__.i,meta34553__$1));
}));

(com.rpl.specter.t_com$rpl$specter34552.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34554){
var self__ = this;
var _34554__$1 = this;
return self__.meta34553;
}));

(com.rpl.specter.t_com$rpl$specter34552.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34552.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if((((self__.i >= (0))) && ((self__.i < cljs.core.count(structure))))){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.i) : next_fn.call(null,vals,self__.i));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter34552.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if((((self__.i >= (0))) && ((self__.i < cljs.core.count(structure))))){
var newi = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.i) : next_fn.call(null,vals,self__.i));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(newi,self__.i)){
return structure;
} else {
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(structure,self__.i);
if(cljs.core.vector_QMARK_(structure)){
var shifted = (((newi < self__.i))?(function (){var j = (self__.i - (1));
var s = structure;
while(true){
if((j < newi)){
return s;
} else {
var G__34897 = (j - (1));
var G__34898 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,(j + (1)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(s,j));
j = G__34897;
s = G__34898;
continue;
}
break;
}
})():(function (){var j = (self__.i + (1));
var s = structure;
while(true){
if((j > newi)){
return s;
} else {
var G__34899 = (j + (1));
var G__34900 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,(j - (1)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(s,j));
j = G__34899;
s = G__34900;
continue;
}
break;
}
})());
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(shifted,newi,v);
} else {
return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__33384__auto__ = com.rpl.specter.pathcache34555;
var info__33384__auto____$1 = (((info__33384__auto__ == null))?(function (){var info34556 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.before_index,new cljs.core.Var(function(){return com.rpl.specter.before_index;},new cljs.core.Symbol("com.rpl.specter","before-index","com.rpl.specter/before-index",1952616274,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),"com/rpl/specter.cljc",15,1,968,971,cljs.core.List.EMPTY,"Navigates to the empty space between the index and the prior index. For select\n          navigates to NONE, and transforms to non-NONE insert at that position.",(cljs.core.truth_(com.rpl.specter.before_index)?com.rpl.specter.before_index.cljs$lang$test:null)])),new cljs.core.Symbol(null,"before-index","before-index",-407870261,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(newi,new cljs.core.Symbol(null,"newi","newi",857919881,null))], null),cljs.core.list(new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null));
com.rpl.specter.pathcache34555 = info34556;

return info34556;
})():info__33384__auto__);
var precompiled34557 = com.rpl.specter.impl.cached_path_info_precompiled(info__33384__auto____$1);
var dynamic_QMARK___33385__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33384__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33385__auto__)){
var G__34558 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.before_index,newi], null);
return (precompiled34557.cljs$core$IFn$_invoke$arity$1 ? precompiled34557.cljs$core$IFn$_invoke$arity$1(G__34558) : precompiled34557.call(null,G__34558));
} else {
return precompiled34557;
}
})(),v,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__33384__auto__ = com.rpl.specter.pathcache34559;
var info__33384__auto____$1 = (((info__33384__auto__ == null))?(function (){var info34560 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(self__.i,new cljs.core.Symbol(null,"i","i",253690212,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"i","i",253690212,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"i","i",253690212,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"i","i",253690212,null)], null));
com.rpl.specter.pathcache34559 = info34560;

return info34560;
})():info__33384__auto__);
var precompiled34561 = com.rpl.specter.impl.cached_path_info_precompiled(info__33384__auto____$1);
var dynamic_QMARK___33385__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33384__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33385__auto__)){
var G__34562 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,self__.i], null);
return (precompiled34561.cljs$core$IFn$_invoke$arity$1 ? precompiled34561.cljs$core$IFn$_invoke$arity$1(G__34562) : precompiled34561.call(null,G__34562));
} else {
return precompiled34561;
}
})(),com.rpl.specter.NONE,structure));
}
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter34552.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta34553","meta34553",-737610591,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34552.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34552.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34552");

(com.rpl.specter.t_com$rpl$specter34552.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34552");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34552.
 */
com.rpl.specter.__GT_t_com$rpl$specter34552 = (function com$rpl$specter$__GT_t_com$rpl$specter34552(i__$1,meta34553){
return (new com.rpl.specter.t_com$rpl$specter34552(i__$1,meta34553));
});

}

return (new com.rpl.specter.t_com$rpl$specter34552(i,null));
}));


com.rpl.specter.indexed_vals_select_STAR_ = (function com$rpl$specter$indexed_vals_select_STAR_(start,structure,next_fn){
var i = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1((start - (1)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__30347__auto__,e){
var ret__30348__auto__ = (function (){
com.rpl.specter.impl.update_cell_BANG_(i,cljs.core.inc);

var G__34565 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.get_cell(i),e], null);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34565) : next_fn.call(null,G__34565));
})()
;
if((ret__30348__auto__ === com.rpl.specter.NONE)){
return curr__30347__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__30348__auto__)){
return cljs.core.reduced(ret__30348__auto__);
} else {
return ret__30348__auto__;
}
}
}),com.rpl.specter.NONE,structure);
});

com.rpl.specter.indexed_vals_transform_STAR_ = (function com$rpl$specter$indexed_vals_transform_STAR_(start,structure,next_fn){
var indices = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(structure)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s,e){
var curri = cljs.core.first(com.rpl.specter.impl.get_cell(indices));
var vec__34579 = (function (){var G__34582 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(start + curri),e], null);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34582) : next_fn.call(null,G__34582));
})();
var newi_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34579,(0),null);
var newe = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34579,(1),null);
var newi = (newi_STAR_ - start);
com.rpl.specter.impl.update_cell_BANG_(indices,(function (ii){
var ii2 = cljs.core.next(ii);
if((newi > curri)){
return com.rpl.specter.impl.compiled_transform_STAR_((function (){var info__33384__auto__ = com.rpl.specter.pathcache34583;
var info__33384__auto____$1 = (((info__33384__auto__ == null))?(function (){var info34584 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__34563_SHARP_){
return (p1__34563_SHARP_ >= (curri + (1)));
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34563#","p1__34563#",-508583995,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__34563#","p1__34563#",-508583995,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null))))),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__34564_SHARP_){
return (p1__34564_SHARP_ <= newi);
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34564#","p1__34564#",-204693492,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__34564#","p1__34564#",-204693492,null),new cljs.core.Symbol(null,"newi","newi",857919881,null))))], null)], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34563#","p1__34563#",-508583995,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__34563#","p1__34563#",-508583995,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34564#","p1__34564#",-204693492,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__34564#","p1__34564#",-204693492,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34563#","p1__34563#",-508583995,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__34563#","p1__34563#",-508583995,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34564#","p1__34564#",-204693492,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__34564#","p1__34564#",-204693492,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null));
com.rpl.specter.pathcache34583 = info34584;

return info34584;
})():info__33384__auto__);
var precompiled34585 = com.rpl.specter.impl.cached_path_info_precompiled(info__33384__auto____$1);
var dynamic_QMARK___33385__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33384__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33385__auto__)){
var G__34586 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,(function (p1__34563_SHARP_){
return (p1__34563_SHARP_ >= (curri + (1)));
}),(function (p1__34564_SHARP_){
return (p1__34564_SHARP_ <= newi);
})], null),com.rpl.specter.ALL,(function (p1__34563_SHARP_){
return (p1__34563_SHARP_ >= (curri + (1)));
}),(function (p1__34564_SHARP_){
return (p1__34564_SHARP_ <= newi);
})], null);
return (precompiled34585.cljs$core$IFn$_invoke$arity$1 ? precompiled34585.cljs$core$IFn$_invoke$arity$1(G__34586) : precompiled34585.call(null,G__34586));
} else {
return precompiled34585;
}
})(),cljs.core.dec,ii2);
} else {
return ii2;
}
}));

return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__33384__auto__ = com.rpl.specter.pathcache34587;
var info__33384__auto____$1 = (((info__33384__auto__ == null))?(function (){var info34588 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.index_nav,new cljs.core.Var(function(){return com.rpl.specter.index_nav;},new cljs.core.Symbol("com.rpl.specter","index-nav","com.rpl.specter/index-nav",2054501071,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),"com/rpl/specter.cljc",12,1,983,986,cljs.core.List.EMPTY,"Navigates to the index of the sequence if within 0 and size. Transforms move element\n          at that index to the new index, shifting other elements in the sequence.",(cljs.core.truth_(com.rpl.specter.index_nav)?com.rpl.specter.index_nav.cljs$lang$test:null)])),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache34587 = info34588;

return info34588;
})():info__33384__auto__);
var precompiled34589 = com.rpl.specter.impl.cached_path_info_precompiled(info__33384__auto____$1);
var dynamic_QMARK___33385__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33384__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33385__auto__)){
var G__34590 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.index_nav,curri], null);
return (precompiled34589.cljs$core$IFn$_invoke$arity$1 ? precompiled34589.cljs$core$IFn$_invoke$arity$1(G__34590) : precompiled34589.call(null,G__34590));
} else {
return precompiled34589;
}
})(),newi,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__33384__auto__ = com.rpl.specter.pathcache34591;
var info__33384__auto____$1 = (((info__33384__auto__ == null))?(function (){var info34592 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache34591 = info34592;

return info34592;
})():info__33384__auto__);
var precompiled34593 = com.rpl.specter.impl.cached_path_info_precompiled(info__33384__auto____$1);
var dynamic_QMARK___33385__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33384__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33385__auto__)){
var G__34594 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,curri], null);
return (precompiled34593.cljs$core$IFn$_invoke$arity$1 ? precompiled34593.cljs$core$IFn$_invoke$arity$1(G__34594) : precompiled34593.call(null,G__34594));
} else {
return precompiled34593;
}
})(),newe,s));
}),structure,structure);
});

/**
 * Navigate to [index elem] pairs for each element in a sequence. The sequence will be indexed
 *        starting from `start`. Changing index in transform has same effect as `index-nav`. Indices seen
 *        during transform take into account any shifting from prior sequence elements changing indices.
 */
com.rpl.specter.indexed_vals = com.rpl.specter.impl.direct_nav_obj((function (start){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34598 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34598 = (function (start,meta34599){
this.start = start;
this.meta34599 = meta34599;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34598.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34600,meta34599__$1){
var self__ = this;
var _34600__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34598(self__.start,meta34599__$1));
}));

(com.rpl.specter.t_com$rpl$specter34598.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34600){
var self__ = this;
var _34600__$1 = this;
return self__.meta34599;
}));

(com.rpl.specter.t_com$rpl$specter34598.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34598.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var i = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1((self__.start - (1)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__30347__auto__,e){
var ret__30348__auto__ = (function (){
com.rpl.specter.impl.update_cell_BANG_(i,cljs.core.inc);

return next_fn(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.get_cell(i),e], null));
})()
;
if((ret__30348__auto__ === com.rpl.specter.NONE)){
return curr__30347__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__30348__auto__)){
return cljs.core.reduced(ret__30348__auto__);
} else {
return ret__30348__auto__;
}
}
}),com.rpl.specter.NONE,structure);
}));

(com.rpl.specter.t_com$rpl$specter34598.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var indices = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(structure)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s,e){
var curri = cljs.core.first(com.rpl.specter.impl.get_cell(indices));
var vec__34601 = next_fn(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.start + curri),e], null));
var newi_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34601,(0),null);
var newe = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34601,(1),null);
var newi = (newi_STAR_ - self__.start);
com.rpl.specter.impl.update_cell_BANG_(indices,(function (ii){
var ii2 = cljs.core.next(ii);
if((newi > curri)){
return com.rpl.specter.impl.compiled_transform_STAR_((function (){var info__33384__auto__ = com.rpl.specter.pathcache34604;
var info__33384__auto____$1 = (((info__33384__auto__ == null))?(function (){var info34605 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__34563_SHARP_){
return (p1__34563_SHARP_ >= (curri + (1)));
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34563#","p1__34563#",-508583995,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__34563#","p1__34563#",-508583995,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null))))),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__34564_SHARP_){
return (p1__34564_SHARP_ <= newi);
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34564#","p1__34564#",-204693492,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__34564#","p1__34564#",-204693492,null),new cljs.core.Symbol(null,"newi","newi",857919881,null))))], null)], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34563#","p1__34563#",-508583995,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__34563#","p1__34563#",-508583995,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34564#","p1__34564#",-204693492,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__34564#","p1__34564#",-204693492,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34563#","p1__34563#",-508583995,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__34563#","p1__34563#",-508583995,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__34564#","p1__34564#",-204693492,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__34564#","p1__34564#",-204693492,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null));
com.rpl.specter.pathcache34604 = info34605;

return info34605;
})():info__33384__auto__);
var precompiled34606 = com.rpl.specter.impl.cached_path_info_precompiled(info__33384__auto____$1);
var dynamic_QMARK___33385__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33384__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33385__auto__)){
var G__34607 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,(function (p1__34563_SHARP_){
return (p1__34563_SHARP_ >= (curri + (1)));
}),(function (p1__34564_SHARP_){
return (p1__34564_SHARP_ <= newi);
})], null),com.rpl.specter.ALL,(function (p1__34563_SHARP_){
return (p1__34563_SHARP_ >= (curri + (1)));
}),(function (p1__34564_SHARP_){
return (p1__34564_SHARP_ <= newi);
})], null);
return (precompiled34606.cljs$core$IFn$_invoke$arity$1 ? precompiled34606.cljs$core$IFn$_invoke$arity$1(G__34607) : precompiled34606.call(null,G__34607));
} else {
return precompiled34606;
}
})(),cljs.core.dec,ii2);
} else {
return ii2;
}
}));

return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__33384__auto__ = com.rpl.specter.pathcache34608;
var info__33384__auto____$1 = (((info__33384__auto__ == null))?(function (){var info34609 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.index_nav,new cljs.core.Var(function(){return com.rpl.specter.index_nav;},new cljs.core.Symbol("com.rpl.specter","index-nav","com.rpl.specter/index-nav",2054501071,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),"com/rpl/specter.cljc",12,1,983,986,cljs.core.List.EMPTY,"Navigates to the index of the sequence if within 0 and size. Transforms move element\n          at that index to the new index, shifting other elements in the sequence.",(cljs.core.truth_(com.rpl.specter.index_nav)?com.rpl.specter.index_nav.cljs$lang$test:null)])),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache34608 = info34609;

return info34609;
})():info__33384__auto__);
var precompiled34610 = com.rpl.specter.impl.cached_path_info_precompiled(info__33384__auto____$1);
var dynamic_QMARK___33385__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33384__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33385__auto__)){
var G__34611 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.index_nav,curri], null);
return (precompiled34610.cljs$core$IFn$_invoke$arity$1 ? precompiled34610.cljs$core$IFn$_invoke$arity$1(G__34611) : precompiled34610.call(null,G__34611));
} else {
return precompiled34610;
}
})(),newi,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__33384__auto__ = com.rpl.specter.pathcache34612;
var info__33384__auto____$1 = (((info__33384__auto__ == null))?(function (){var info34613 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache34612 = info34613;

return info34613;
})():info__33384__auto__);
var precompiled34614 = com.rpl.specter.impl.cached_path_info_precompiled(info__33384__auto____$1);
var dynamic_QMARK___33385__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33384__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33385__auto__)){
var G__34615 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,curri], null);
return (precompiled34614.cljs$core$IFn$_invoke$arity$1 ? precompiled34614.cljs$core$IFn$_invoke$arity$1(G__34615) : precompiled34614.call(null,G__34615));
} else {
return precompiled34614;
}
})(),newe,s));
}),structure,structure);
}));

(com.rpl.specter.t_com$rpl$specter34598.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"meta34599","meta34599",-1269361660,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34598.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34598.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34598");

(com.rpl.specter.t_com$rpl$specter34598.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34598");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34598.
 */
com.rpl.specter.__GT_t_com$rpl$specter34598 = (function com$rpl$specter$__GT_t_com$rpl$specter34598(start__$1,meta34599){
return (new com.rpl.specter.t_com$rpl$specter34598(start__$1,meta34599));
});

}

return (new com.rpl.specter.t_com$rpl$specter34598(start,null));
}));
/**
 * `indexed-vals` with a starting index of 0.
 */
com.rpl.specter.INDEXED_VALS = (com.rpl.specter.indexed_vals.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.indexed_vals.cljs$core$IFn$_invoke$arity$1((0)) : com.rpl.specter.indexed_vals.call(null,(0)));
/**
 * Navigates to result of running `afn` on the currently navigated value.
 */
com.rpl.specter.view = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34616 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34616 = (function (afn,meta34617){
this.afn = afn;
this.meta34617 = meta34617;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34616.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34618,meta34617__$1){
var self__ = this;
var _34618__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34616(self__.afn,meta34617__$1));
}));

(com.rpl.specter.t_com$rpl$specter34616.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34618){
var self__ = this;
var _34618__$1 = this;
return self__.meta34617;
}));

(com.rpl.specter.t_com$rpl$specter34616.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34616.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__34619 = vals;
var G__34620 = (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(structure) : self__.afn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__34619,G__34620) : next_fn.call(null,G__34619,G__34620));
}));

(com.rpl.specter.t_com$rpl$specter34616.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__34621 = vals;
var G__34622 = (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(structure) : self__.afn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__34621,G__34622) : next_fn.call(null,G__34621,G__34622));
}));

(com.rpl.specter.t_com$rpl$specter34616.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta34617","meta34617",-1789836320,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34616.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34616.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34616");

(com.rpl.specter.t_com$rpl$specter34616.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34616");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34616.
 */
com.rpl.specter.__GT_t_com$rpl$specter34616 = (function com$rpl$specter$__GT_t_com$rpl$specter34616(afn__$1,meta34617){
return (new com.rpl.specter.t_com$rpl$specter34616(afn__$1,meta34617));
});

}

return (new com.rpl.specter.t_com$rpl$specter34616(afn,null));
}));


com.rpl.specter.parser_select_STAR_ = (function com$rpl$specter$parser_select_STAR_(parse_fn,unparse_fn,structure,next_fn){
var G__34623 = (parse_fn.cljs$core$IFn$_invoke$arity$1 ? parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : parse_fn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34623) : next_fn.call(null,G__34623));
});

com.rpl.specter.parser_transform_STAR_ = (function com$rpl$specter$parser_transform_STAR_(parse_fn,unparse_fn,structure,next_fn){
var G__34624 = (function (){var G__34625 = (parse_fn.cljs$core$IFn$_invoke$arity$1 ? parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : parse_fn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34625) : next_fn.call(null,G__34625));
})();
return (unparse_fn.cljs$core$IFn$_invoke$arity$1 ? unparse_fn.cljs$core$IFn$_invoke$arity$1(G__34624) : unparse_fn.call(null,G__34624));
});

/**
 * Navigate to the result of running `parse-fn` on the value. For
 *        transforms, the transformed value then has `unparse-fn` run on
 *        it to get the final value at this point.
 */
com.rpl.specter.parser = com.rpl.specter.impl.direct_nav_obj((function (parse_fn,unparse_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34626 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34626 = (function (parse_fn,unparse_fn,meta34627){
this.parse_fn = parse_fn;
this.unparse_fn = unparse_fn;
this.meta34627 = meta34627;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34626.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34628,meta34627__$1){
var self__ = this;
var _34628__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34626(self__.parse_fn,self__.unparse_fn,meta34627__$1));
}));

(com.rpl.specter.t_com$rpl$specter34626.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34628){
var self__ = this;
var _34628__$1 = this;
return self__.meta34627;
}));

(com.rpl.specter.t_com$rpl$specter34626.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34626.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn((self__.parse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.parse_fn.call(null,structure)));
}));

(com.rpl.specter.t_com$rpl$specter34626.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var G__34635 = next_fn((self__.parse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.parse_fn.call(null,structure)));
return (self__.unparse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.unparse_fn.cljs$core$IFn$_invoke$arity$1(G__34635) : self__.unparse_fn.call(null,G__34635));
}));

(com.rpl.specter.t_com$rpl$specter34626.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parse-fn","parse-fn",-836029424,null),new cljs.core.Symbol(null,"unparse-fn","unparse-fn",407187734,null),new cljs.core.Symbol(null,"meta34627","meta34627",-2042983743,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34626.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34626.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34626");

(com.rpl.specter.t_com$rpl$specter34626.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34626");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34626.
 */
com.rpl.specter.__GT_t_com$rpl$specter34626 = (function com$rpl$specter$__GT_t_com$rpl$specter34626(parse_fn__$1,unparse_fn__$1,meta34627){
return (new com.rpl.specter.t_com$rpl$specter34626(parse_fn__$1,unparse_fn__$1,meta34627));
});

}

return (new com.rpl.specter.t_com$rpl$specter34626(parse_fn,unparse_fn,null));
}));


com.rpl.specter.ATOM_select_STAR_ = (function com$rpl$specter$ATOM_select_STAR_(structure,next_fn){
var G__34639 = cljs.core.deref(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34639) : next_fn.call(null,G__34639));
});

com.rpl.specter.ATOM_transform_STAR_ = (function com$rpl$specter$ATOM_transform_STAR_(structure,next_fn){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(structure,next_fn);

return structure;
});

/**
 * Navigates to atom value.
 */
com.rpl.specter.ATOM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34641 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34641 = (function (meta34642){
this.meta34642 = meta34642;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34641.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34643,meta34642__$1){
var self__ = this;
var _34643__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34641(meta34642__$1));
}));

(com.rpl.specter.t_com$rpl$specter34641.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34643){
var self__ = this;
var _34643__$1 = this;
return self__.meta34642;
}));

(com.rpl.specter.t_com$rpl$specter34641.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34641.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(cljs.core.deref(structure));
}));

(com.rpl.specter.t_com$rpl$specter34641.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(structure,next_fn);

return structure;
}));

(com.rpl.specter.t_com$rpl$specter34641.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34642","meta34642",-427050733,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34641.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34641.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34641");

(com.rpl.specter.t_com$rpl$specter34641.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34641");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34641.
 */
com.rpl.specter.__GT_t_com$rpl$specter34641 = (function com$rpl$specter$__GT_t_com$rpl$specter34641(meta34642){
return (new com.rpl.specter.t_com$rpl$specter34641(meta34642));
});

}

return (new com.rpl.specter.t_com$rpl$specter34641(null));
})()
;


com.rpl.specter.regex_nav_select_STAR_ = (function com$rpl$specter$regex_nav_select_STAR_(re,structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__30347__auto__,s){
var ret__30348__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(s) : next_fn.call(null,s));
if((ret__30348__auto__ === com.rpl.specter.NONE)){
return curr__30347__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__30348__auto__)){
return cljs.core.reduced(ret__30348__auto__);
} else {
return ret__30348__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.re_seq(re,structure));
});

com.rpl.specter.regex_nav_transform_STAR_ = (function com$rpl$specter$regex_nav_transform_STAR_(re,structure,next_fn){
return clojure.string.replace(structure,re,next_fn);
});

com.rpl.specter.regex_nav = com.rpl.specter.impl.direct_nav_obj((function (re){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34644 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34644 = (function (re,meta34645){
this.re = re;
this.meta34645 = meta34645;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34644.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34646,meta34645__$1){
var self__ = this;
var _34646__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34644(self__.re,meta34645__$1));
}));

(com.rpl.specter.t_com$rpl$specter34644.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34646){
var self__ = this;
var _34646__$1 = this;
return self__.meta34645;
}));

(com.rpl.specter.t_com$rpl$specter34644.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34644.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__30347__auto__,s){
var ret__30348__auto__ = next_fn(s);
if((ret__30348__auto__ === com.rpl.specter.NONE)){
return curr__30347__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__30348__auto__)){
return cljs.core.reduced(ret__30348__auto__);
} else {
return ret__30348__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.re_seq(self__.re,structure));
}));

(com.rpl.specter.t_com$rpl$specter34644.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return clojure.string.replace(structure,self__.re,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34644.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"re","re",1869207729,null),new cljs.core.Symbol(null,"meta34645","meta34645",737914888,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34644.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34644.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34644");

(com.rpl.specter.t_com$rpl$specter34644.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34644");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34644.
 */
com.rpl.specter.__GT_t_com$rpl$specter34644 = (function com$rpl$specter$__GT_t_com$rpl$specter34644(re__$1,meta34645){
return (new com.rpl.specter.t_com$rpl$specter34644(re__$1,meta34645));
});

}

return (new com.rpl.specter.t_com$rpl$specter34644(re,null));
}));
/**
 * Filters the current value based on whether a path finds anything.
 *   e.g. (selected? :vals ALL even?) keeps the current element only if an
 *   even number exists for the :vals key.
 */
com.rpl.specter.selected_QMARK_ = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34919__delegate = function (path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(path);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
return afn;
} else {
var builder__33377__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34683 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34683 = (function (path,temp__5733__auto__,late,meta34684){
this.path = path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late = late;
this.meta34684 = meta34684;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34683.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34685,meta34684__$1){
var self__ = this;
var _34685__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34683(self__.path,self__.temp__5733__auto__,self__.late,meta34684__$1));
}));

(com.rpl.specter.t_com$rpl$specter34683.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34685){
var self__ = this;
var _34685__$1 = this;
return self__.meta34684;
}));

(com.rpl.specter.t_com$rpl$specter34683.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34683.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select((function (p1__34681_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late,vals,p1__34681_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34683.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform((function (p1__34682_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late,vals,p1__34682_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34683.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta34684","meta34684",1462542078,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34683.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34683.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34683");

(com.rpl.specter.t_com$rpl$specter34683.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34683");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34683.
 */
com.rpl.specter.__GT_t_com$rpl$specter34683 = (function com$rpl$specter$__GT_t_com$rpl$specter34683(path__$1,temp__5733__auto____$1,late__$1,meta34684){
return (new com.rpl.specter.t_com$rpl$specter34683(path__$1,temp__5733__auto____$1,late__$1,meta34684));
});

}

return (new com.rpl.specter.t_com$rpl$specter34683(path,temp__5733__auto__,late,null));
}));
var curr_params__33378__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33378__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33377__auto__,curr_params__33378__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33377__auto__,curr_params__33378__auto__,null);
}
}
};
var G__34919 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34920__i = 0, G__34920__a = new Array(arguments.length -  0);
while (G__34920__i < G__34920__a.length) {G__34920__a[G__34920__i] = arguments[G__34920__i + 0]; ++G__34920__i;}
  path = new cljs.core.IndexedSeq(G__34920__a,0,null);
} 
return G__34919__delegate.call(this,path);};
G__34919.cljs$lang$maxFixedArity = 0;
G__34919.cljs$lang$applyTo = (function (arglist__34921){
var path = cljs.core.seq(arglist__34921);
return G__34919__delegate(path);
});
G__34919.cljs$core$IFn$_invoke$arity$variadic = G__34919__delegate;
return G__34919;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.not_selected_QMARK_ = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34922__delegate = function (path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(path);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
return (function (s){
return cljs.core.not((afn.cljs$core$IFn$_invoke$arity$1 ? afn.cljs$core$IFn$_invoke$arity$1(s) : afn.call(null,s)));
});
} else {
var builder__33377__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34713 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34713 = (function (path,temp__5733__auto__,late,meta34714){
this.path = path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late = late;
this.meta34714 = meta34714;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34713.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34715,meta34714__$1){
var self__ = this;
var _34715__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34713(self__.path,self__.temp__5733__auto__,self__.late,meta34714__$1));
}));

(com.rpl.specter.t_com$rpl$specter34713.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34715){
var self__ = this;
var _34715__$1 = this;
return self__.meta34714;
}));

(com.rpl.specter.t_com$rpl$specter34713.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34713.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select((function (p1__34707_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_(self__.late,vals,p1__34707_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34713.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform((function (p1__34708_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_(self__.late,vals,p1__34708_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34713.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta34714","meta34714",83683884,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34713.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34713.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34713");

(com.rpl.specter.t_com$rpl$specter34713.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34713");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34713.
 */
com.rpl.specter.__GT_t_com$rpl$specter34713 = (function com$rpl$specter$__GT_t_com$rpl$specter34713(path__$1,temp__5733__auto____$1,late__$1,meta34714){
return (new com.rpl.specter.t_com$rpl$specter34713(path__$1,temp__5733__auto____$1,late__$1,meta34714));
});

}

return (new com.rpl.specter.t_com$rpl$specter34713(path,temp__5733__auto__,late,null));
}));
var curr_params__33378__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33378__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33377__auto__,curr_params__33378__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33377__auto__,curr_params__33378__auto__,null);
}
}
};
var G__34922 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34926__i = 0, G__34926__a = new Array(arguments.length -  0);
while (G__34926__i < G__34926__a.length) {G__34926__a[G__34926__i] = arguments[G__34926__i + 0]; ++G__34926__i;}
  path = new cljs.core.IndexedSeq(G__34926__a,0,null);
} 
return G__34922__delegate.call(this,path);};
G__34922.cljs$lang$maxFixedArity = 0;
G__34922.cljs$lang$applyTo = (function (arglist__34927){
var path = cljs.core.seq(arglist__34927);
return G__34922__delegate(path);
});
G__34922.cljs$core$IFn$_invoke$arity$variadic = G__34922__delegate;
return G__34922;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current sequence that only contains elements that
 *   match the given path. An element matches the selector path if calling select
 *   on that element with the path yields anything other than an empty sequence.
 * 
 *   For transformation: `NONE` entries in the result sequence cause corresponding entries in
 *   input to be removed. A result sequence smaller than the input sequence is equivalent to
 *   padding the result sequence with `NONE` at the end until the same size as the input.
 */
com.rpl.specter.filterer = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34928__delegate = function (path){
var G__34716 = com.rpl.specter.ALL;
var G__34717 = (com.rpl.specter.selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.selected_QMARK_.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.selected_QMARK_.call(null,path));
return (com.rpl.specter.subselect.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.subselect.cljs$core$IFn$_invoke$arity$2(G__34716,G__34717) : com.rpl.specter.subselect.call(null,G__34716,G__34717));
};
var G__34928 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34929__i = 0, G__34929__a = new Array(arguments.length -  0);
while (G__34929__i < G__34929__a.length) {G__34929__a[G__34929__i] = arguments[G__34929__i + 0]; ++G__34929__i;}
  path = new cljs.core.IndexedSeq(G__34929__a,0,null);
} 
return G__34928__delegate.call(this,path);};
G__34928.cljs$lang$maxFixedArity = 0;
G__34928.cljs$lang$applyTo = (function (arglist__34930){
var path = cljs.core.seq(arglist__34930);
return G__34928__delegate(path);
});
G__34928.cljs$core$IFn$_invoke$arity$variadic = G__34928__delegate;
return G__34928;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming it with the
 * specified path and update-fn.
 */
com.rpl.specter.transformed = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (path,update_fn){
var builder__33377__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late,late_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34718 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34718 = (function (path,update_fn,late,late_fn,meta34719){
this.path = path;
this.update_fn = update_fn;
this.late = late;
this.late_fn = late_fn;
this.meta34719 = meta34719;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34718.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34720,meta34719__$1){
var self__ = this;
var _34720__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34718(self__.path,self__.update_fn,self__.late,self__.late_fn,meta34719__$1));
}));

(com.rpl.specter.t_com$rpl$specter34718.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34720){
var self__ = this;
var _34720__$1 = this;
return self__.meta34719;
}));

(com.rpl.specter.t_com$rpl$specter34718.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34718.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn((com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(self__.late,self__.late_fn,structure) : com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure)));
}));

(com.rpl.specter.t_com$rpl$specter34718.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn((com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(self__.late,self__.late_fn,structure) : com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure)));
}));

(com.rpl.specter.t_com$rpl$specter34718.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"update-fn","update-fn",-1943348456,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta34719","meta34719",-627202168,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34718.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34718.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34718");

(com.rpl.specter.t_com$rpl$specter34718.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34718");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34718.
 */
com.rpl.specter.__GT_t_com$rpl$specter34718 = (function com$rpl$specter$__GT_t_com$rpl$specter34718(path__$1,update_fn__$1,late__$1,late_fn__$1,meta34719){
return (new com.rpl.specter.t_com$rpl$specter34718(path__$1,update_fn__$1,late__$1,late_fn__$1,meta34719));
});

}

return (new com.rpl.specter.t_com$rpl$specter34718(path,update_fn,late,late_fn,null));
}));
var curr_params__33378__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path)),update_fn], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33378__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33377__auto__,curr_params__33378__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33377__auto__,curr_params__33378__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming with a reduction over
 * the specified traversal.
 */
com.rpl.specter.traversed = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (path,reduce_fn){
var builder__33377__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late,late_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34721 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34721 = (function (path,reduce_fn,late,late_fn,meta34722){
this.path = path;
this.reduce_fn = reduce_fn;
this.late = late;
this.late_fn = late_fn;
this.meta34722 = meta34722;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34721.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34723,meta34722__$1){
var self__ = this;
var _34723__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34721(self__.path,self__.reduce_fn,self__.late,self__.late_fn,meta34722__$1));
}));

(com.rpl.specter.t_com$rpl$specter34721.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34723){
var self__ = this;
var _34723__$1 = this;
return self__.meta34722;
}));

(com.rpl.specter.t_com$rpl$specter34721.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34721.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(self__.late_fn,(com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_traverse.call(null,self__.late,structure))));
}));

(com.rpl.specter.t_com$rpl$specter34721.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(self__.late_fn,(com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_traverse.call(null,self__.late,structure))));
}));

(com.rpl.specter.t_com$rpl$specter34721.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"reduce-fn","reduce-fn",-1484020844,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta34722","meta34722",448104823,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34721.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34721.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34721");

(com.rpl.specter.t_com$rpl$specter34721.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34721");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34721.
 */
com.rpl.specter.__GT_t_com$rpl$specter34721 = (function com$rpl$specter$__GT_t_com$rpl$specter34721(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta34722){
return (new com.rpl.specter.t_com$rpl$specter34721(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta34722));
});

}

return (new com.rpl.specter.t_com$rpl$specter34721(path,reduce_fn,late,late_fn,null));
}));
var curr_params__33378__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path)),reduce_fn], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33378__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33377__auto__,curr_params__33378__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33377__auto__,curr_params__33378__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Keeps the element only if it matches the supplied predicate. Functions in paths
 *        implicitly convert to this navigator.
 */
com.rpl.specter.pred = com.rpl.specter.impl.pred_STAR_;
com.rpl.specter.pred_EQ_ = (function com$rpl$specter$pred_EQ_(v){
var G__34725 = (function (p1__34724_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__34724_SHARP_,v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__34725) : com.rpl.specter.pred.call(null,G__34725));
});
com.rpl.specter.pred_LT_ = (function com$rpl$specter$pred_LT_(v){
var G__34727 = (function (p1__34726_SHARP_){
return (p1__34726_SHARP_ < v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__34727) : com.rpl.specter.pred.call(null,G__34727));
});
com.rpl.specter.pred_GT_ = (function com$rpl$specter$pred_GT_(v){
var G__34729 = (function (p1__34728_SHARP_){
return (p1__34728_SHARP_ > v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__34729) : com.rpl.specter.pred.call(null,G__34729));
});
com.rpl.specter.pred_LT__EQ_ = (function com$rpl$specter$pred_LT__EQ_(v){
var G__34731 = (function (p1__34730_SHARP_){
return (p1__34730_SHARP_ <= v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__34731) : com.rpl.specter.pred.call(null,G__34731));
});
com.rpl.specter.pred_GT__EQ_ = (function com$rpl$specter$pred_GT__EQ_(v){
var G__34733 = (function (p1__34732_SHARP_){
return (p1__34732_SHARP_ >= v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__34733) : com.rpl.specter.pred.call(null,G__34733));
});
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"null",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"null",(function (this$){
return com.rpl.specter.STAY;
}));
(cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
(cljs.core.Symbol.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Symbol.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"string",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"string",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"number",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"number",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
(cljs.core.char$.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.char$.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"boolean",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"boolean",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"function",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"function",(function (this$){
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.pred.call(null,this$));
}));
(cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.pred.call(null,this$__$1));
}));
(RegExp.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(RegExp.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.regex_nav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.regex_nav.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.regex_nav.call(null,this$__$1));
}));


com.rpl.specter.nil__GT_val_select_STAR_ = (function com$rpl$specter$nil__GT_val_select_STAR_(v,structure,next_fn){
var G__34734 = (((structure == null))?v:structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34734) : next_fn.call(null,G__34734));
});

com.rpl.specter.nil__GT_val_transform_STAR_ = (function com$rpl$specter$nil__GT_val_transform_STAR_(v,structure,next_fn){
var G__34735 = (((structure == null))?v:structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34735) : next_fn.call(null,G__34735));
});

/**
 * Navigates to the provided val if the structure is nil. Otherwise it stays
 *        navigated at the structure.
 */
com.rpl.specter.nil__GT_val = com.rpl.specter.impl.direct_nav_obj((function (v){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34736 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34736 = (function (v,meta34737){
this.v = v;
this.meta34737 = meta34737;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34736.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34738,meta34737__$1){
var self__ = this;
var _34738__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34736(self__.v,meta34737__$1));
}));

(com.rpl.specter.t_com$rpl$specter34736.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34738){
var self__ = this;
var _34738__$1 = this;
return self__.meta34737;
}));

(com.rpl.specter.t_com$rpl$specter34736.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34736.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn((((structure == null))?self__.v:structure));
}));

(com.rpl.specter.t_com$rpl$specter34736.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn((((structure == null))?self__.v:structure));
}));

(com.rpl.specter.t_com$rpl$specter34736.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"meta34737","meta34737",876031124,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34736.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34736.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34736");

(com.rpl.specter.t_com$rpl$specter34736.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34736");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34736.
 */
com.rpl.specter.__GT_t_com$rpl$specter34736 = (function com$rpl$specter$__GT_t_com$rpl$specter34736(v__$1,meta34737){
return (new com.rpl.specter.t_com$rpl$specter34736(v__$1,meta34737));
});

}

return (new com.rpl.specter.t_com$rpl$specter34736(v,null));
}));
/**
 * Navigates to #{} if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_SET = (function (){var G__34739 = cljs.core.PersistentHashSet.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__34739) : com.rpl.specter.nil__GT_val.call(null,G__34739));
})();
/**
 * Navigates to '() if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_LIST = (function (){var G__34740 = cljs.core.List.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__34740) : com.rpl.specter.nil__GT_val.call(null,G__34740));
})();
/**
 * Navigates to [] if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_VECTOR = (function (){var G__34741 = cljs.core.PersistentVector.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__34741) : com.rpl.specter.nil__GT_val.call(null,G__34741));
})();


com.rpl.specter.META_select_STAR_ = (function com$rpl$specter$META_select_STAR_(structure,next_fn){
var G__34742 = cljs.core.meta(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34742) : next_fn.call(null,G__34742));
});

com.rpl.specter.META_transform_STAR_ = (function com$rpl$specter$META_transform_STAR_(structure,next_fn){
return cljs.core.with_meta(structure,(function (){var G__34743 = cljs.core.meta(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34743) : next_fn.call(null,G__34743));
})());
});

/**
 * Navigates to the metadata of the structure, or nil if
 *   the structure has no metadata or may not contain metadata.
 */
com.rpl.specter.META = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34748 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34748 = (function (meta34749){
this.meta34749 = meta34749;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34748.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34750,meta34749__$1){
var self__ = this;
var _34750__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34748(meta34749__$1));
}));

(com.rpl.specter.t_com$rpl$specter34748.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34750){
var self__ = this;
var _34750__$1 = this;
return self__.meta34749;
}));

(com.rpl.specter.t_com$rpl$specter34748.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34748.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(cljs.core.meta(structure));
}));

(com.rpl.specter.t_com$rpl$specter34748.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return cljs.core.with_meta(structure,next_fn(cljs.core.meta(structure)));
}));

(com.rpl.specter.t_com$rpl$specter34748.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34749","meta34749",940204340,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34748.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34748.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34748");

(com.rpl.specter.t_com$rpl$specter34748.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34748");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34748.
 */
com.rpl.specter.__GT_t_com$rpl$specter34748 = (function com$rpl$specter$__GT_t_com$rpl$specter34748(meta34749){
return (new com.rpl.specter.t_com$rpl$specter34748(meta34749));
});

}

return (new com.rpl.specter.t_com$rpl$specter34748(null));
})()
;


com.rpl.specter.NAME_select_STAR_ = (function com$rpl$specter$NAME_select_STAR_(structure,next_fn){
var G__34751 = cljs.core.name(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34751) : next_fn.call(null,G__34751));
});

com.rpl.specter.NAME_transform_STAR_ = (function com$rpl$specter$NAME_transform_STAR_(structure,next_fn){
var new_name = (function (){var G__34752 = cljs.core.name(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34752) : next_fn.call(null,G__34752));
})();
var ns = cljs.core.namespace(structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAME can only be used on symbols or keywords - ",structure], 0));

}
}
});

/**
 * Navigates to the name portion of the keyword or symbol
 */
com.rpl.specter.NAME = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34753 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34753 = (function (meta34754){
this.meta34754 = meta34754;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34753.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34755,meta34754__$1){
var self__ = this;
var _34755__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34753(meta34754__$1));
}));

(com.rpl.specter.t_com$rpl$specter34753.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34755){
var self__ = this;
var _34755__$1 = this;
return self__.meta34754;
}));

(com.rpl.specter.t_com$rpl$specter34753.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34753.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(cljs.core.name(structure));
}));

(com.rpl.specter.t_com$rpl$specter34753.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var new_name = next_fn(cljs.core.name(structure));
var ns = cljs.core.namespace(structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAME can only be used on symbols or keywords - ",structure], 0));

}
}
}));

(com.rpl.specter.t_com$rpl$specter34753.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34754","meta34754",-221136215,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34753.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34753.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34753");

(com.rpl.specter.t_com$rpl$specter34753.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34753");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34753.
 */
com.rpl.specter.__GT_t_com$rpl$specter34753 = (function com$rpl$specter$__GT_t_com$rpl$specter34753(meta34754){
return (new com.rpl.specter.t_com$rpl$specter34753(meta34754));
});

}

return (new com.rpl.specter.t_com$rpl$specter34753(null));
})()
;


com.rpl.specter.NAMESPACE_select_STAR_ = (function com$rpl$specter$NAMESPACE_select_STAR_(structure,next_fn){
var G__34756 = cljs.core.namespace(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34756) : next_fn.call(null,G__34756));
});

com.rpl.specter.NAMESPACE_transform_STAR_ = (function com$rpl$specter$NAMESPACE_transform_STAR_(structure,next_fn){
var name = cljs.core.name(structure);
var new_ns = (function (){var G__34757 = cljs.core.namespace(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__34757) : next_fn.call(null,G__34757));
})();
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAMESPACE can only be used on symbols or keywords - ",structure], 0));

}
}
});

/**
 * Navigates to the namespace portion of the keyword or symbol
 */
com.rpl.specter.NAMESPACE = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34758 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34758 = (function (meta34759){
this.meta34759 = meta34759;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34758.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34760,meta34759__$1){
var self__ = this;
var _34760__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34758(meta34759__$1));
}));

(com.rpl.specter.t_com$rpl$specter34758.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34760){
var self__ = this;
var _34760__$1 = this;
return self__.meta34759;
}));

(com.rpl.specter.t_com$rpl$specter34758.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34758.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
return next_fn(cljs.core.namespace(structure));
}));

(com.rpl.specter.t_com$rpl$specter34758.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32551__auto__,vals__32552__auto__,structure,next_fn__32553__auto__){
var self__ = this;
var this__32551__auto____$1 = this;
var next_fn = (function (s__32554__auto__){
return (next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__32553__auto__.cljs$core$IFn$_invoke$arity$2(vals__32552__auto__,s__32554__auto__) : next_fn__32553__auto__.call(null,vals__32552__auto__,s__32554__auto__));
});
var name = cljs.core.name(structure);
var new_ns = next_fn(cljs.core.namespace(structure));
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAMESPACE can only be used on symbols or keywords - ",structure], 0));

}
}
}));

(com.rpl.specter.t_com$rpl$specter34758.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34759","meta34759",1248027030,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34758.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34758.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34758");

(com.rpl.specter.t_com$rpl$specter34758.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34758");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34758.
 */
com.rpl.specter.__GT_t_com$rpl$specter34758 = (function com$rpl$specter$__GT_t_com$rpl$specter34758(meta34759){
return (new com.rpl.specter.t_com$rpl$specter34758(meta34759));
});

}

return (new com.rpl.specter.t_com$rpl$specter34758(null));
})()
;
/**
 * Adds the result of running select with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34932__delegate = function (path){
var builder__33377__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34763 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34763 = (function (path,late,meta34764){
this.path = path;
this.late = late;
this.meta34764 = meta34764;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34763.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34765,meta34764__$1){
var self__ = this;
var _34765__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34763(self__.path,self__.late,meta34764__$1));
}));

(com.rpl.specter.t_com$rpl$specter34763.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34765){
var self__ = this;
var _34765__$1 = this;
return self__.meta34764;
}));

(com.rpl.specter.t_com$rpl$specter34763.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34763.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__33374__auto__,vals__33375__auto__,structure,next_fn__33376__auto__){
var self__ = this;
var this__33374__auto____$1 = this;
var G__34766 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33375__auto__,(com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
var G__34767 = structure;
return (next_fn__33376__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33376__auto__.cljs$core$IFn$_invoke$arity$2(G__34766,G__34767) : next_fn__33376__auto__.call(null,G__34766,G__34767));
}));

(com.rpl.specter.t_com$rpl$specter34763.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__33374__auto__,vals__33375__auto__,structure,next_fn__33376__auto__){
var self__ = this;
var this__33374__auto____$1 = this;
var G__34768 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33375__auto__,(com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
var G__34769 = structure;
return (next_fn__33376__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33376__auto__.cljs$core$IFn$_invoke$arity$2(G__34768,G__34769) : next_fn__33376__auto__.call(null,G__34768,G__34769));
}));

(com.rpl.specter.t_com$rpl$specter34763.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta34764","meta34764",-1515269290,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34763.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34763.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34763");

(com.rpl.specter.t_com$rpl$specter34763.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34763");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34763.
 */
com.rpl.specter.__GT_t_com$rpl$specter34763 = (function com$rpl$specter$__GT_t_com$rpl$specter34763(path__$1,late__$1,meta34764){
return (new com.rpl.specter.t_com$rpl$specter34763(path__$1,late__$1,meta34764));
});

}

return (new com.rpl.specter.t_com$rpl$specter34763(path,late,null));
}));
var curr_params__33378__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33378__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33377__auto__,curr_params__33378__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33377__auto__,curr_params__33378__auto__,null);
}
};
var G__34932 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34933__i = 0, G__34933__a = new Array(arguments.length -  0);
while (G__34933__i < G__34933__a.length) {G__34933__a[G__34933__i] = arguments[G__34933__i + 0]; ++G__34933__i;}
  path = new cljs.core.IndexedSeq(G__34933__a,0,null);
} 
return G__34932__delegate.call(this,path);};
G__34932.cljs$lang$maxFixedArity = 0;
G__34932.cljs$lang$applyTo = (function (arglist__34934){
var path = cljs.core.seq(arglist__34934);
return G__34932__delegate(path);
});
G__34932.cljs$core$IFn$_invoke$arity$variadic = G__34932__delegate;
return G__34932;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds the result of running select-one with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect_one = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34935__delegate = function (path){
var builder__33377__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34770 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34770 = (function (path,late,meta34771){
this.path = path;
this.late = late;
this.meta34771 = meta34771;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34770.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34772,meta34771__$1){
var self__ = this;
var _34772__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34770(self__.path,self__.late,meta34771__$1));
}));

(com.rpl.specter.t_com$rpl$specter34770.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34772){
var self__ = this;
var _34772__$1 = this;
return self__.meta34771;
}));

(com.rpl.specter.t_com$rpl$specter34770.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34770.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__33374__auto__,vals__33375__auto__,structure,next_fn__33376__auto__){
var self__ = this;
var this__33374__auto____$1 = this;
var G__34773 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33375__auto__,(com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select_one.call(null,self__.late,structure)));
var G__34774 = structure;
return (next_fn__33376__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33376__auto__.cljs$core$IFn$_invoke$arity$2(G__34773,G__34774) : next_fn__33376__auto__.call(null,G__34773,G__34774));
}));

(com.rpl.specter.t_com$rpl$specter34770.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__33374__auto__,vals__33375__auto__,structure,next_fn__33376__auto__){
var self__ = this;
var this__33374__auto____$1 = this;
var G__34775 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33375__auto__,(com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select_one.call(null,self__.late,structure)));
var G__34776 = structure;
return (next_fn__33376__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33376__auto__.cljs$core$IFn$_invoke$arity$2(G__34775,G__34776) : next_fn__33376__auto__.call(null,G__34775,G__34776));
}));

(com.rpl.specter.t_com$rpl$specter34770.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta34771","meta34771",-699077853,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34770.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34770.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34770");

(com.rpl.specter.t_com$rpl$specter34770.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34770");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34770.
 */
com.rpl.specter.__GT_t_com$rpl$specter34770 = (function com$rpl$specter$__GT_t_com$rpl$specter34770(path__$1,late__$1,meta34771){
return (new com.rpl.specter.t_com$rpl$specter34770(path__$1,late__$1,meta34771));
});

}

return (new com.rpl.specter.t_com$rpl$specter34770(path,late,null));
}));
var curr_params__33378__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33378__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33377__auto__,curr_params__33378__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33377__auto__,curr_params__33378__auto__,null);
}
};
var G__34935 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34936__i = 0, G__34936__a = new Array(arguments.length -  0);
while (G__34936__i < G__34936__a.length) {G__34936__a[G__34936__i] = arguments[G__34936__i + 0]; ++G__34936__i;}
  path = new cljs.core.IndexedSeq(G__34936__a,0,null);
} 
return G__34935__delegate.call(this,path);};
G__34935.cljs$lang$maxFixedArity = 0;
G__34935.cljs$lang$applyTo = (function (arglist__34937){
var path = cljs.core.seq(arglist__34937);
return G__34935__delegate(path);
});
G__34935.cljs$core$IFn$_invoke$arity$variadic = G__34935__delegate;
return G__34935;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds an external value to the collected vals. Useful when additional arguments
 *   are required to the transform function that would otherwise require partial
 *   application or a wrapper function.
 * 
 *   e.g., incrementing val at path [:a :b] by 3:
 *   (transform [:a :b (putval 3)] + some-map)
 */
com.rpl.specter.putval = com.rpl.specter.impl.direct_nav_obj((function (val){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34777 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34777 = (function (val,meta34778){
this.val = val;
this.meta34778 = meta34778;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34777.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34779,meta34778__$1){
var self__ = this;
var _34779__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34777(self__.val,meta34778__$1));
}));

(com.rpl.specter.t_com$rpl$specter34777.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34779){
var self__ = this;
var _34779__$1 = this;
return self__.meta34778;
}));

(com.rpl.specter.t_com$rpl$specter34777.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34777.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__33374__auto__,vals__33375__auto__,structure,next_fn__33376__auto__){
var self__ = this;
var this__33374__auto____$1 = this;
var G__34780 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33375__auto__,self__.val);
var G__34781 = structure;
return (next_fn__33376__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33376__auto__.cljs$core$IFn$_invoke$arity$2(G__34780,G__34781) : next_fn__33376__auto__.call(null,G__34780,G__34781));
}));

(com.rpl.specter.t_com$rpl$specter34777.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__33374__auto__,vals__33375__auto__,structure,next_fn__33376__auto__){
var self__ = this;
var this__33374__auto____$1 = this;
var G__34782 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__33375__auto__,self__.val);
var G__34783 = structure;
return (next_fn__33376__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__33376__auto__.cljs$core$IFn$_invoke$arity$2(G__34782,G__34783) : next_fn__33376__auto__.call(null,G__34782,G__34783));
}));

(com.rpl.specter.t_com$rpl$specter34777.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"meta34778","meta34778",1059248404,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34777.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34777.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34777");

(com.rpl.specter.t_com$rpl$specter34777.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34777");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34777.
 */
com.rpl.specter.__GT_t_com$rpl$specter34777 = (function com$rpl$specter$__GT_t_com$rpl$specter34777(val__$1,meta34778){
return (new com.rpl.specter.t_com$rpl$specter34777(val__$1,meta34778));
});

}

return (new com.rpl.specter.t_com$rpl$specter34777(val,null));
}));
/**
 * Continues navigating on the given path with the collected vals reset to []. Once
 *   navigation leaves the scope of with-fresh-collected, the collected vals revert
 *   to what they were before.
 */
com.rpl.specter.with_fresh_collected = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34938__delegate = function (path){
var builder__33377__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34785 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34785 = (function (path,late,meta34786){
this.path = path;
this.late = late;
this.meta34786 = meta34786;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34785.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34787,meta34786__$1){
var self__ = this;
var _34787__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34785(self__.path,self__.late,meta34786__$1));
}));

(com.rpl.specter.t_com$rpl$specter34785.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34787){
var self__ = this;
var _34787__$1 = this;
return self__.meta34786;
}));

(com.rpl.specter.t_com$rpl$specter34785.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34785.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.select_STAR_(self__.late,cljs.core.PersistentVector.EMPTY,structure,(function (_,structure__$1){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,structure__$1) : next_fn.call(null,vals,structure__$1));
}));
}));

(com.rpl.specter.t_com$rpl$specter34785.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.transform_STAR_(self__.late,cljs.core.PersistentVector.EMPTY,structure,(function (_,structure__$1){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,structure__$1) : next_fn.call(null,vals,structure__$1));
}));
}));

(com.rpl.specter.t_com$rpl$specter34785.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta34786","meta34786",-153170801,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34785.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34785.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34785");

(com.rpl.specter.t_com$rpl$specter34785.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34785");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34785.
 */
com.rpl.specter.__GT_t_com$rpl$specter34785 = (function com$rpl$specter$__GT_t_com$rpl$specter34785(path__$1,late__$1,meta34786){
return (new com.rpl.specter.t_com$rpl$specter34785(path__$1,late__$1,meta34786));
});

}

return (new com.rpl.specter.t_com$rpl$specter34785(path,late,null));
}));
var curr_params__33378__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33378__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33377__auto__,curr_params__33378__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33377__auto__,curr_params__33378__auto__,null);
}
};
var G__34938 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34939__i = 0, G__34939__a = new Array(arguments.length -  0);
while (G__34939__i < G__34939__a.length) {G__34939__a[G__34939__i] = arguments[G__34939__i + 0]; ++G__34939__i;}
  path = new cljs.core.IndexedSeq(G__34939__a,0,null);
} 
return G__34938__delegate.call(this,path);};
G__34938.cljs$lang$maxFixedArity = 0;
G__34938.cljs$lang$applyTo = (function (arglist__34940){
var path = cljs.core.seq(arglist__34940);
return G__34938__delegate(path);
});
G__34938.cljs$core$IFn$_invoke$arity$variadic = G__34938__delegate;
return G__34938;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Drops all collected values for subsequent navigation.
 */
com.rpl.specter.DISPENSE = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34792 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34792 = (function (meta34793){
this.meta34793 = meta34793;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34792.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34794,meta34793__$1){
var self__ = this;
var _34794__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34792(meta34793__$1));
}));

(com.rpl.specter.t_com$rpl$specter34792.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34794){
var self__ = this;
var _34794__$1 = this;
return self__.meta34793;
}));

(com.rpl.specter.t_com$rpl$specter34792.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34792.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__34795 = cljs.core.PersistentVector.EMPTY;
var G__34796 = structure;
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__34795,G__34796) : next_fn.call(null,G__34795,G__34796));
}));

(com.rpl.specter.t_com$rpl$specter34792.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__34797 = cljs.core.PersistentVector.EMPTY;
var G__34798 = structure;
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__34797,G__34798) : next_fn.call(null,G__34797,G__34798));
}));

(com.rpl.specter.t_com$rpl$specter34792.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta34793","meta34793",345927706,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34792.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34792.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34792");

(com.rpl.specter.t_com$rpl$specter34792.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34792");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34792.
 */
com.rpl.specter.__GT_t_com$rpl$specter34792 = (function com$rpl$specter$__GT_t_com$rpl$specter34792(meta34793){
return (new com.rpl.specter.t_com$rpl$specter34792(meta34793));
});

}

return (new com.rpl.specter.t_com$rpl$specter34792(null));
})()
;
/**
 * Like cond-path, but with if semantics.
 */
com.rpl.specter.if_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() {
var G__34941 = null;
var G__34941__2 = (function (cond_p,then_path){
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3(cond_p,then_path,com.rpl.specter.STOP) : com.rpl.specter.if_path.call(null,cond_p,then_path,com.rpl.specter.STOP));
});
var G__34941__3 = (function (cond_p,then_path,else_path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(cond_p);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
var builder__33377__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late_then,late_else){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34801 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34801 = (function (cond_p,then_path,else_path,temp__5733__auto__,afn,late_then,late_else,meta34802){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__5733__auto__ = temp__5733__auto__;
this.afn = afn;
this.late_then = late_then;
this.late_else = late_else;
this.meta34802 = meta34802;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34801.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34803,meta34802__$1){
var self__ = this;
var _34803__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34801(self__.cond_p,self__.then_path,self__.else_path,self__.temp__5733__auto__,self__.afn,self__.late_then,self__.late_else,meta34802__$1));
}));

(com.rpl.specter.t_com$rpl$specter34801.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34803){
var self__ = this;
var _34803__$1 = this;
return self__.meta34802;
}));

(com.rpl.specter.t_com$rpl$specter34801.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34801.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select(vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter34801.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform(vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter34801.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta34802","meta34802",1233397396,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34801.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34801.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34801");

(com.rpl.specter.t_com$rpl$specter34801.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34801");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34801.
 */
com.rpl.specter.__GT_t_com$rpl$specter34801 = (function com$rpl$specter$__GT_t_com$rpl$specter34801(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,afn__$1,late_then__$1,late_else__$1,meta34802){
return (new com.rpl.specter.t_com$rpl$specter34801(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,afn__$1,late_then__$1,late_else__$1,meta34802));
});

}

return (new com.rpl.specter.t_com$rpl$specter34801(cond_p,then_path,else_path,temp__5733__auto__,afn,late_then,late_else,null));
}));
var curr_params__33378__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(then_path) : com.rpl.specter.late_path.call(null,then_path)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(else_path) : com.rpl.specter.late_path.call(null,else_path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33378__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33377__auto__,curr_params__33378__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33377__auto__,curr_params__33378__auto__,null);
}
} else {
var builder__33377__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late_cond,late_then,late_else){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34809 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34809 = (function (cond_p,then_path,else_path,temp__5733__auto__,late_cond,late_then,late_else,meta34810){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late_cond = late_cond;
this.late_then = late_then;
this.late_else = late_else;
this.meta34810 = meta34810;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34809.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34811,meta34810__$1){
var self__ = this;
var _34811__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34809(self__.cond_p,self__.then_path,self__.else_path,self__.temp__5733__auto__,self__.late_cond,self__.late_then,self__.late_else,meta34810__$1));
}));

(com.rpl.specter.t_com$rpl$specter34809.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34811){
var self__ = this;
var _34811__$1 = this;
return self__.meta34810;
}));

(com.rpl.specter.t_com$rpl$specter34809.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34809.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select(vals,structure,next_fn,(function (p1__34799_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late_cond,vals,p1__34799_SHARP_);
}),self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter34809.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform(vals,structure,next_fn,(function (p1__34800_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late_cond,vals,p1__34800_SHARP_);
}),self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter34809.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late-cond","late-cond",1031862828,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta34810","meta34810",-1056202939,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34809.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34809.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34809");

(com.rpl.specter.t_com$rpl$specter34809.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34809");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34809.
 */
com.rpl.specter.__GT_t_com$rpl$specter34809 = (function com$rpl$specter$__GT_t_com$rpl$specter34809(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta34810){
return (new com.rpl.specter.t_com$rpl$specter34809(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta34810));
});

}

return (new com.rpl.specter.t_com$rpl$specter34809(cond_p,then_path,else_path,temp__5733__auto__,late_cond,late_then,late_else,null));
}));
var curr_params__33378__auto__ = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(cond_p) : com.rpl.specter.late_path.call(null,cond_p)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(then_path) : com.rpl.specter.late_path.call(null,then_path)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(else_path) : com.rpl.specter.late_path.call(null,else_path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33378__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33377__auto__,curr_params__33378__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33377__auto__,curr_params__33378__auto__,null);
}
}
});
G__34941 = function(cond_p,then_path,else_path){
switch(arguments.length){
case 2:
return G__34941__2.call(this,cond_p,then_path);
case 3:
return G__34941__3.call(this,cond_p,then_path,else_path);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34941.cljs$core$IFn$_invoke$arity$2 = G__34941__2;
G__34941.cljs$core$IFn$_invoke$arity$3 = G__34941__3;
return G__34941;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Takes in alternating cond-path path cond-path path...
 * Tests the structure if selecting with cond-path returns anything.
 * If so, it uses the following path for this portion of the navigation.
 * Otherwise, it tries the next cond-path. If nothing matches, then the structure
 * is not selected.
 */
com.rpl.specter.cond_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34942__delegate = function (conds){
var pairs = cljs.core.reverse(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),conds));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p,p__34816){
var vec__34817 = p__34816;
var tester = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34817,(0),null);
var apath = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34817,(1),null);
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3(tester,apath,p) : com.rpl.specter.if_path.call(null,tester,apath,p));
}),com.rpl.specter.STOP,pairs);
};
var G__34942 = function (var_args){
var conds = null;
if (arguments.length > 0) {
var G__34943__i = 0, G__34943__a = new Array(arguments.length -  0);
while (G__34943__i < G__34943__a.length) {G__34943__a[G__34943__i] = arguments[G__34943__i + 0]; ++G__34943__i;}
  conds = new cljs.core.IndexedSeq(G__34943__a,0,null);
} 
return G__34942__delegate.call(this,conds);};
G__34942.cljs$lang$maxFixedArity = 0;
G__34942.cljs$lang$applyTo = (function (arglist__34944){
var conds = cljs.core.seq(arglist__34944);
return G__34942__delegate(conds);
});
G__34942.cljs$core$IFn$_invoke$arity$variadic = G__34942__delegate;
return G__34942;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * A path that branches on multiple paths. For updates,
 * applies updates to the paths in order.
 */
com.rpl.specter.multi_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() {
var G__34945 = null;
var G__34945__0 = (function (){
return com.rpl.specter.STAY;
});
var G__34945__1 = (function (path){
return path;
});
var G__34945__2 = (function (path1,path2){
var builder__33377__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late1,late2){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter34820 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter34820 = (function (path1,path2,late1,late2,meta34821){
this.path1 = path1;
this.path2 = path2;
this.late1 = late1;
this.late2 = late2;
this.meta34821 = meta34821;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter34820.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34822,meta34821__$1){
var self__ = this;
var _34822__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter34820(self__.path1,self__.path2,self__.late1,self__.late2,meta34821__$1));
}));

(com.rpl.specter.t_com$rpl$specter34820.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34822){
var self__ = this;
var _34822__$1 = this;
return self__.meta34821;
}));

(com.rpl.specter.t_com$rpl$specter34820.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter34820.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var res1 = com.rpl.specter.protocols.select_STAR_(self__.late1,vals,structure,next_fn);
if(cljs.core.reduced_QMARK_(res1)){
return res1;
} else {
var res2 = com.rpl.specter.protocols.select_STAR_(self__.late2,vals,structure,next_fn);
if((com.rpl.specter.NONE === res1)){
return res2;
} else {
return res1;
}
}
}));

(com.rpl.specter.t_com$rpl$specter34820.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var s1 = com.rpl.specter.protocols.transform_STAR_(self__.late1,vals,structure,next_fn);
return com.rpl.specter.protocols.transform_STAR_(self__.late2,vals,s1,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter34820.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path1","path1",-2002517142,null),new cljs.core.Symbol(null,"path2","path2",-1937913521,null),new cljs.core.Symbol(null,"late1","late1",-1413016621,null),new cljs.core.Symbol(null,"late2","late2",-681717994,null),new cljs.core.Symbol(null,"meta34821","meta34821",-1594847841,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter34820.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter34820.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter34820");

(com.rpl.specter.t_com$rpl$specter34820.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter34820");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter34820.
 */
com.rpl.specter.__GT_t_com$rpl$specter34820 = (function com$rpl$specter$__GT_t_com$rpl$specter34820(path1__$1,path2__$1,late1__$1,late2__$1,meta34821){
return (new com.rpl.specter.t_com$rpl$specter34820(path1__$1,path2__$1,late1__$1,late2__$1,meta34821));
});

}

return (new com.rpl.specter.t_com$rpl$specter34820(path1,path2,late1,late2,null));
}));
var curr_params__33378__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path1) : com.rpl.specter.late_path.call(null,path1)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path2) : com.rpl.specter.late_path.call(null,path2))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33378__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__33377__auto__,curr_params__33378__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__33377__auto__,curr_params__33378__auto__,null);
}
});
var G__34945__3 = (function() { 
var G__34946__delegate = function (path1,path2,paths){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(com.rpl.specter.multi_path,(com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(path1,path2) : com.rpl.specter.multi_path.call(null,path1,path2)),paths);
};
var G__34946 = function (path1,path2,var_args){
var paths = null;
if (arguments.length > 2) {
var G__34947__i = 0, G__34947__a = new Array(arguments.length -  2);
while (G__34947__i < G__34947__a.length) {G__34947__a[G__34947__i] = arguments[G__34947__i + 2]; ++G__34947__i;}
  paths = new cljs.core.IndexedSeq(G__34947__a,0,null);
} 
return G__34946__delegate.call(this,path1,path2,paths);};
G__34946.cljs$lang$maxFixedArity = 2;
G__34946.cljs$lang$applyTo = (function (arglist__34948){
var path1 = cljs.core.first(arglist__34948);
arglist__34948 = cljs.core.next(arglist__34948);
var path2 = cljs.core.first(arglist__34948);
var paths = cljs.core.rest(arglist__34948);
return G__34946__delegate(path1,path2,paths);
});
G__34946.cljs$core$IFn$_invoke$arity$variadic = G__34946__delegate;
return G__34946;
})()
;
G__34945 = function(path1,path2,var_args){
var paths = var_args;
switch(arguments.length){
case 0:
return G__34945__0.call(this);
case 1:
return G__34945__1.call(this,path1);
case 2:
return G__34945__2.call(this,path1,path2);
default:
var G__34949 = null;
if (arguments.length > 2) {
var G__34950__i = 0, G__34950__a = new Array(arguments.length -  2);
while (G__34950__i < G__34950__a.length) {G__34950__a[G__34950__i] = arguments[G__34950__i + 2]; ++G__34950__i;}
G__34949 = new cljs.core.IndexedSeq(G__34950__a,0,null);
}
return G__34945__3.cljs$core$IFn$_invoke$arity$variadic(path1,path2, G__34949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34945.cljs$lang$maxFixedArity = 2;
G__34945.cljs$lang$applyTo = G__34945__3.cljs$lang$applyTo;
G__34945.cljs$core$IFn$_invoke$arity$0 = G__34945__0;
G__34945.cljs$core$IFn$_invoke$arity$1 = G__34945__1;
G__34945.cljs$core$IFn$_invoke$arity$2 = G__34945__2;
G__34945.cljs$core$IFn$_invoke$arity$variadic = G__34945__3.cljs$core$IFn$_invoke$arity$variadic;
return G__34945;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the current element and then navigates via the provided path.
 * This can be used to implement pre-order traversal.
 */
com.rpl.specter.stay_then_continue = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34951__delegate = function (path){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.STAY,path) : com.rpl.specter.multi_path.call(null,com.rpl.specter.STAY,path));
};
var G__34951 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34952__i = 0, G__34952__a = new Array(arguments.length -  0);
while (G__34952__i < G__34952__a.length) {G__34952__a[G__34952__i] = arguments[G__34952__i + 0]; ++G__34952__i;}
  path = new cljs.core.IndexedSeq(G__34952__a,0,null);
} 
return G__34951__delegate.call(this,path);};
G__34951.cljs$lang$maxFixedArity = 0;
G__34951.cljs$lang$applyTo = (function (arglist__34953){
var path = cljs.core.seq(arglist__34953);
return G__34951__delegate(path);
});
G__34951.cljs$core$IFn$_invoke$arity$variadic = G__34951__delegate;
return G__34951;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the provided path and then to the current element. This can be used
 * to implement post-order traversal.
 */
com.rpl.specter.continue_then_stay = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34954__delegate = function (path){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(path,com.rpl.specter.STAY) : com.rpl.specter.multi_path.call(null,path,com.rpl.specter.STAY));
};
var G__34954 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34955__i = 0, G__34955__a = new Array(arguments.length -  0);
while (G__34955__i < G__34955__a.length) {G__34955__a[G__34955__i] = arguments[G__34955__i + 0]; ++G__34955__i;}
  path = new cljs.core.IndexedSeq(G__34955__a,0,null);
} 
return G__34954__delegate.call(this,path);};
G__34954.cljs$lang$maxFixedArity = 0;
G__34954.cljs$lang$applyTo = (function (arglist__34956){
var path = cljs.core.seq(arglist__34956);
return G__34954__delegate(path);
});
G__34954.cljs$core$IFn$_invoke$arity$variadic = G__34954__delegate;
return G__34954;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigate the data structure until reaching
 *        a value for which `afn` returns truthy. Has
 *        same semantics as clojure.walk.
 */
com.rpl.specter.walker = com.rpl.specter.impl.direct_nav_obj((function (afn){
var p = com.rpl.specter.impl.local_declarepath();
com.rpl.specter.impl.providepath_STAR_(p,(function (){var info__33384__auto__ = com.rpl.specter.pathcache34837;
var info__33384__auto____$1 = (((info__33384__auto__ == null))?(function (){var info34838 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"com/rpl/specter.cljc",25,1,1394,1394,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"com/rpl/specter.cljc",7,1,true,1175,1179,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. Functions in paths\n          implicitly convert to this navigator.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"com/rpl/specter.cljc",7,1,644,646,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse(cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",12,1,2133,2133,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",(cljs.core.truth_(cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_LocalSym(p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache34837 = info34838;

return info34838;
})():info__33384__auto__);
var precompiled34839 = com.rpl.specter.impl.cached_path_info_precompiled(info__33384__auto____$1);
var dynamic_QMARK___33385__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33384__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33385__auto__)){
var G__34843 = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,p], null),com.rpl.specter.ALL,p], null);
return (precompiled34839.cljs$core$IFn$_invoke$arity$1 ? precompiled34839.cljs$core$IFn$_invoke$arity$1(G__34843) : precompiled34839.call(null,G__34843));
} else {
return precompiled34839;
}
})());

return p;
}));
/**
 * Like `walker` but maintains metadata of any forms traversed.
 */
com.rpl.specter.codewalker = com.rpl.specter.impl.direct_nav_obj((function (afn){
var p = com.rpl.specter.impl.local_declarepath();
com.rpl.specter.impl.providepath_STAR_(p,(function (){var info__33384__auto__ = com.rpl.specter.pathcache34844;
var info__33384__auto____$1 = (((info__33384__auto__ == null))?(function (){var info34845 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"com/rpl/specter.cljc",25,1,1394,1394,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"com/rpl/specter.cljc",7,1,true,1175,1179,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. Functions in paths\n          implicitly convert to this navigator.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"com/rpl/specter.cljc",7,1,644,646,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse(cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",12,1,2133,2133,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",(cljs.core.truth_(cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL_WITH_META,new cljs.core.Var(function(){return com.rpl.specter.ALL_WITH_META;},new cljs.core.Symbol("com.rpl.specter","ALL-WITH-META","com.rpl.specter/ALL-WITH-META",-1161868995,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),"com/rpl/specter.cljc",16,1,689,691,cljs.core.List.EMPTY,"Same as ALL, except maintains metadata on the structure.",(cljs.core.truth_(com.rpl.specter.ALL_WITH_META)?com.rpl.specter.ALL_WITH_META.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null)),com.rpl.specter.impl.__GT_LocalSym(p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache34844 = info34845;

return info34845;
})():info__33384__auto__);
var precompiled34846 = com.rpl.specter.impl.cached_path_info_precompiled(info__33384__auto____$1);
var dynamic_QMARK___33385__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__33384__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33385__auto__)){
var G__34847 = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL_WITH_META,p], null),com.rpl.specter.ALL_WITH_META,p], null);
return (precompiled34846.cljs$core$IFn$_invoke$arity$1 ? precompiled34846.cljs$core$IFn$_invoke$arity$1(G__34847) : precompiled34846.call(null,G__34847));
} else {
return precompiled34846;
}
})());

return p;
}));
var empty__GT_NONE_34957 = (function (){var G__34848 = cljs.core.empty_QMARK_;
var G__34849 = com.rpl.specter.terminal_val(com.rpl.specter.NONE);
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$2(G__34848,G__34849) : com.rpl.specter.if_path.call(null,G__34848,G__34849));
})();
var compact_STAR__34958 = (function (nav){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(nav,empty__GT_NONE_34957) : com.rpl.specter.multi_path.call(null,nav,empty__GT_NONE_34957));
});
/**
 * During transforms, after each step of navigation in subpath check if the
 *  value is empty. If so, remove that value by setting it to NONE.
 */
com.rpl.specter.compact = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__34959__delegate = function (path){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(compact_STAR__34958,path);
};
var G__34959 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__34960__i = 0, G__34960__a = new Array(arguments.length -  0);
while (G__34960__i < G__34960__a.length) {G__34960__a[G__34960__i] = arguments[G__34960__i + 0]; ++G__34960__i;}
  path = new cljs.core.IndexedSeq(G__34960__a,0,null);
} 
return G__34959__delegate.call(this,path);};
G__34959.cljs$lang$maxFixedArity = 0;
G__34959.cljs$lang$applyTo = (function (arglist__34961){
var path = cljs.core.seq(arglist__34961);
return G__34959__delegate(path);
});
G__34959.cljs$core$IFn$_invoke$arity$variadic = G__34959__delegate;
return G__34959;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);

//# sourceMappingURL=com.rpl.specter.js.map
