goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__37270 = arguments.length;
switch (G__37270) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async37271 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37271 = (function (f,blockable,meta37272){
this.f = f;
this.blockable = blockable;
this.meta37272 = meta37272;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async37271.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37273,meta37272__$1){
var self__ = this;
var _37273__$1 = this;
return (new cljs.core.async.t_cljs$core$async37271(self__.f,self__.blockable,meta37272__$1));
}));

(cljs.core.async.t_cljs$core$async37271.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37273){
var self__ = this;
var _37273__$1 = this;
return self__.meta37272;
}));

(cljs.core.async.t_cljs$core$async37271.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async37271.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async37271.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async37271.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async37271.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta37272","meta37272",389544280,null)], null);
}));

(cljs.core.async.t_cljs$core$async37271.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async37271.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37271");

(cljs.core.async.t_cljs$core$async37271.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async37271");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37271.
 */
cljs.core.async.__GT_t_cljs$core$async37271 = (function cljs$core$async$__GT_t_cljs$core$async37271(f__$1,blockable__$1,meta37272){
return (new cljs.core.async.t_cljs$core$async37271(f__$1,blockable__$1,meta37272));
});

}

return (new cljs.core.async.t_cljs$core$async37271(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__37281 = arguments.length;
switch (G__37281) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__37283 = arguments.length;
switch (G__37283) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__37285 = arguments.length;
switch (G__37285) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_38750 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_38750) : fn1.call(null,val_38750));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_38750) : fn1.call(null,val_38750));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__37287 = arguments.length;
switch (G__37287) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___38757 = n;
var x_38758 = (0);
while(true){
if((x_38758 < n__4613__auto___38757)){
(a[x_38758] = x_38758);

var G__38759 = (x_38758 + (1));
x_38758 = G__38759;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async37288 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37288 = (function (flag,meta37289){
this.flag = flag;
this.meta37289 = meta37289;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async37288.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37290,meta37289__$1){
var self__ = this;
var _37290__$1 = this;
return (new cljs.core.async.t_cljs$core$async37288(self__.flag,meta37289__$1));
}));

(cljs.core.async.t_cljs$core$async37288.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37290){
var self__ = this;
var _37290__$1 = this;
return self__.meta37289;
}));

(cljs.core.async.t_cljs$core$async37288.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async37288.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async37288.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async37288.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async37288.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta37289","meta37289",-560645192,null)], null);
}));

(cljs.core.async.t_cljs$core$async37288.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async37288.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37288");

(cljs.core.async.t_cljs$core$async37288.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async37288");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37288.
 */
cljs.core.async.__GT_t_cljs$core$async37288 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async37288(flag__$1,meta37289){
return (new cljs.core.async.t_cljs$core$async37288(flag__$1,meta37289));
});

}

return (new cljs.core.async.t_cljs$core$async37288(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async37291 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37291 = (function (flag,cb,meta37292){
this.flag = flag;
this.cb = cb;
this.meta37292 = meta37292;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async37291.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37293,meta37292__$1){
var self__ = this;
var _37293__$1 = this;
return (new cljs.core.async.t_cljs$core$async37291(self__.flag,self__.cb,meta37292__$1));
}));

(cljs.core.async.t_cljs$core$async37291.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37293){
var self__ = this;
var _37293__$1 = this;
return self__.meta37292;
}));

(cljs.core.async.t_cljs$core$async37291.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async37291.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async37291.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async37291.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async37291.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta37292","meta37292",-1954407877,null)], null);
}));

(cljs.core.async.t_cljs$core$async37291.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async37291.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37291");

(cljs.core.async.t_cljs$core$async37291.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async37291");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37291.
 */
cljs.core.async.__GT_t_cljs$core$async37291 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async37291(flag__$1,cb__$1,meta37292){
return (new cljs.core.async.t_cljs$core$async37291(flag__$1,cb__$1,meta37292));
});

}

return (new cljs.core.async.t_cljs$core$async37291(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__37294_SHARP_){
var G__37296 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37294_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__37296) : fret.call(null,G__37296));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__37295_SHARP_){
var G__37297 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37295_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__37297) : fret.call(null,G__37297));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__38769 = (i + (1));
i = G__38769;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___38770 = arguments.length;
var i__4737__auto___38771 = (0);
while(true){
if((i__4737__auto___38771 < len__4736__auto___38770)){
args__4742__auto__.push((arguments[i__4737__auto___38771]));

var G__38772 = (i__4737__auto___38771 + (1));
i__4737__auto___38771 = G__38772;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__37300){
var map__37301 = p__37300;
var map__37301__$1 = (((((!((map__37301 == null))))?(((((map__37301.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37301.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37301):map__37301);
var opts = map__37301__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq37298){
var G__37299 = cljs.core.first(seq37298);
var seq37298__$1 = cljs.core.next(seq37298);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37299,seq37298__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__37304 = arguments.length;
switch (G__37304) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__37211__auto___38774 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37212__auto__ = (function (){var switch__37175__auto__ = (function (state_37328){
var state_val_37329 = (state_37328[(1)]);
if((state_val_37329 === (7))){
var inst_37324 = (state_37328[(2)]);
var state_37328__$1 = state_37328;
var statearr_37330_38775 = state_37328__$1;
(statearr_37330_38775[(2)] = inst_37324);

(statearr_37330_38775[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37329 === (1))){
var state_37328__$1 = state_37328;
var statearr_37331_38776 = state_37328__$1;
(statearr_37331_38776[(2)] = null);

(statearr_37331_38776[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37329 === (4))){
var inst_37307 = (state_37328[(7)]);
var inst_37307__$1 = (state_37328[(2)]);
var inst_37308 = (inst_37307__$1 == null);
var state_37328__$1 = (function (){var statearr_37332 = state_37328;
(statearr_37332[(7)] = inst_37307__$1);

return statearr_37332;
})();
if(cljs.core.truth_(inst_37308)){
var statearr_37333_38777 = state_37328__$1;
(statearr_37333_38777[(1)] = (5));

} else {
var statearr_37334_38778 = state_37328__$1;
(statearr_37334_38778[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37329 === (13))){
var state_37328__$1 = state_37328;
var statearr_37335_38779 = state_37328__$1;
(statearr_37335_38779[(2)] = null);

(statearr_37335_38779[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37329 === (6))){
var inst_37307 = (state_37328[(7)]);
var state_37328__$1 = state_37328;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37328__$1,(11),to,inst_37307);
} else {
if((state_val_37329 === (3))){
var inst_37326 = (state_37328[(2)]);
var state_37328__$1 = state_37328;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37328__$1,inst_37326);
} else {
if((state_val_37329 === (12))){
var state_37328__$1 = state_37328;
var statearr_37336_38780 = state_37328__$1;
(statearr_37336_38780[(2)] = null);

(statearr_37336_38780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37329 === (2))){
var state_37328__$1 = state_37328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37328__$1,(4),from);
} else {
if((state_val_37329 === (11))){
var inst_37317 = (state_37328[(2)]);
var state_37328__$1 = state_37328;
if(cljs.core.truth_(inst_37317)){
var statearr_37337_38781 = state_37328__$1;
(statearr_37337_38781[(1)] = (12));

} else {
var statearr_37338_38782 = state_37328__$1;
(statearr_37338_38782[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37329 === (9))){
var state_37328__$1 = state_37328;
var statearr_37339_38783 = state_37328__$1;
(statearr_37339_38783[(2)] = null);

(statearr_37339_38783[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37329 === (5))){
var state_37328__$1 = state_37328;
if(cljs.core.truth_(close_QMARK_)){
var statearr_37340_38784 = state_37328__$1;
(statearr_37340_38784[(1)] = (8));

} else {
var statearr_37341_38785 = state_37328__$1;
(statearr_37341_38785[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37329 === (14))){
var inst_37322 = (state_37328[(2)]);
var state_37328__$1 = state_37328;
var statearr_37342_38786 = state_37328__$1;
(statearr_37342_38786[(2)] = inst_37322);

(statearr_37342_38786[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37329 === (10))){
var inst_37314 = (state_37328[(2)]);
var state_37328__$1 = state_37328;
var statearr_37343_38787 = state_37328__$1;
(statearr_37343_38787[(2)] = inst_37314);

(statearr_37343_38787[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37329 === (8))){
var inst_37311 = cljs.core.async.close_BANG_(to);
var state_37328__$1 = state_37328;
var statearr_37344_38788 = state_37328__$1;
(statearr_37344_38788[(2)] = inst_37311);

(statearr_37344_38788[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__37176__auto__ = null;
var cljs$core$async$state_machine__37176__auto____0 = (function (){
var statearr_37345 = [null,null,null,null,null,null,null,null];
(statearr_37345[(0)] = cljs$core$async$state_machine__37176__auto__);

(statearr_37345[(1)] = (1));

return statearr_37345;
});
var cljs$core$async$state_machine__37176__auto____1 = (function (state_37328){
while(true){
var ret_value__37177__auto__ = (function (){try{while(true){
var result__37178__auto__ = switch__37175__auto__(state_37328);
if(cljs.core.keyword_identical_QMARK_(result__37178__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37178__auto__;
}
break;
}
}catch (e37346){var ex__37179__auto__ = e37346;
var statearr_37347_38789 = state_37328;
(statearr_37347_38789[(2)] = ex__37179__auto__);


if(cljs.core.seq((state_37328[(4)]))){
var statearr_37348_38790 = state_37328;
(statearr_37348_38790[(1)] = cljs.core.first((state_37328[(4)])));

} else {
throw ex__37179__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37177__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38793 = state_37328;
state_37328 = G__38793;
continue;
} else {
return ret_value__37177__auto__;
}
break;
}
});
cljs$core$async$state_machine__37176__auto__ = function(state_37328){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37176__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37176__auto____1.call(this,state_37328);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37176__auto____0;
cljs$core$async$state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37176__auto____1;
return cljs$core$async$state_machine__37176__auto__;
})()
})();
var state__37213__auto__ = (function (){var statearr_37349 = f__37212__auto__();
(statearr_37349[(6)] = c__37211__auto___38774);

return statearr_37349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37213__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__37350){
var vec__37351 = p__37350;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37351,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37351,(1),null);
var job = vec__37351;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__37211__auto___38794 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37212__auto__ = (function (){var switch__37175__auto__ = (function (state_37358){
var state_val_37359 = (state_37358[(1)]);
if((state_val_37359 === (1))){
var state_37358__$1 = state_37358;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37358__$1,(2),res,v);
} else {
if((state_val_37359 === (2))){
var inst_37355 = (state_37358[(2)]);
var inst_37356 = cljs.core.async.close_BANG_(res);
var state_37358__$1 = (function (){var statearr_37360 = state_37358;
(statearr_37360[(7)] = inst_37355);

return statearr_37360;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_37358__$1,inst_37356);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____0 = (function (){
var statearr_37361 = [null,null,null,null,null,null,null,null];
(statearr_37361[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__);

(statearr_37361[(1)] = (1));

return statearr_37361;
});
var cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____1 = (function (state_37358){
while(true){
var ret_value__37177__auto__ = (function (){try{while(true){
var result__37178__auto__ = switch__37175__auto__(state_37358);
if(cljs.core.keyword_identical_QMARK_(result__37178__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37178__auto__;
}
break;
}
}catch (e37362){var ex__37179__auto__ = e37362;
var statearr_37363_38796 = state_37358;
(statearr_37363_38796[(2)] = ex__37179__auto__);


if(cljs.core.seq((state_37358[(4)]))){
var statearr_37364_38798 = state_37358;
(statearr_37364_38798[(1)] = cljs.core.first((state_37358[(4)])));

} else {
throw ex__37179__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37177__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38799 = state_37358;
state_37358 = G__38799;
continue;
} else {
return ret_value__37177__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__ = function(state_37358){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____1.call(this,state_37358);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__;
})()
})();
var state__37213__auto__ = (function (){var statearr_37365 = f__37212__auto__();
(statearr_37365[(6)] = c__37211__auto___38794);

return statearr_37365;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37213__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__37366){
var vec__37367 = p__37366;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37367,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37367,(1),null);
var job = vec__37367;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___38801 = n;
var __38802 = (0);
while(true){
if((__38802 < n__4613__auto___38801)){
var G__37370_38804 = type;
var G__37370_38805__$1 = (((G__37370_38804 instanceof cljs.core.Keyword))?G__37370_38804.fqn:null);
switch (G__37370_38805__$1) {
case "compute":
var c__37211__auto___38807 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__38802,c__37211__auto___38807,G__37370_38804,G__37370_38805__$1,n__4613__auto___38801,jobs,results,process,async){
return (function (){
var f__37212__auto__ = (function (){var switch__37175__auto__ = ((function (__38802,c__37211__auto___38807,G__37370_38804,G__37370_38805__$1,n__4613__auto___38801,jobs,results,process,async){
return (function (state_37383){
var state_val_37384 = (state_37383[(1)]);
if((state_val_37384 === (1))){
var state_37383__$1 = state_37383;
var statearr_37385_38809 = state_37383__$1;
(statearr_37385_38809[(2)] = null);

(statearr_37385_38809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37384 === (2))){
var state_37383__$1 = state_37383;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37383__$1,(4),jobs);
} else {
if((state_val_37384 === (3))){
var inst_37381 = (state_37383[(2)]);
var state_37383__$1 = state_37383;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37383__$1,inst_37381);
} else {
if((state_val_37384 === (4))){
var inst_37373 = (state_37383[(2)]);
var inst_37374 = process(inst_37373);
var state_37383__$1 = state_37383;
if(cljs.core.truth_(inst_37374)){
var statearr_37386_38811 = state_37383__$1;
(statearr_37386_38811[(1)] = (5));

} else {
var statearr_37387_38812 = state_37383__$1;
(statearr_37387_38812[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37384 === (5))){
var state_37383__$1 = state_37383;
var statearr_37388_38813 = state_37383__$1;
(statearr_37388_38813[(2)] = null);

(statearr_37388_38813[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37384 === (6))){
var state_37383__$1 = state_37383;
var statearr_37389_38814 = state_37383__$1;
(statearr_37389_38814[(2)] = null);

(statearr_37389_38814[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37384 === (7))){
var inst_37379 = (state_37383[(2)]);
var state_37383__$1 = state_37383;
var statearr_37390_38815 = state_37383__$1;
(statearr_37390_38815[(2)] = inst_37379);

(statearr_37390_38815[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__38802,c__37211__auto___38807,G__37370_38804,G__37370_38805__$1,n__4613__auto___38801,jobs,results,process,async))
;
return ((function (__38802,switch__37175__auto__,c__37211__auto___38807,G__37370_38804,G__37370_38805__$1,n__4613__auto___38801,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____0 = (function (){
var statearr_37391 = [null,null,null,null,null,null,null];
(statearr_37391[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__);

(statearr_37391[(1)] = (1));

return statearr_37391;
});
var cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____1 = (function (state_37383){
while(true){
var ret_value__37177__auto__ = (function (){try{while(true){
var result__37178__auto__ = switch__37175__auto__(state_37383);
if(cljs.core.keyword_identical_QMARK_(result__37178__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37178__auto__;
}
break;
}
}catch (e37392){var ex__37179__auto__ = e37392;
var statearr_37393_38816 = state_37383;
(statearr_37393_38816[(2)] = ex__37179__auto__);


if(cljs.core.seq((state_37383[(4)]))){
var statearr_37394_38817 = state_37383;
(statearr_37394_38817[(1)] = cljs.core.first((state_37383[(4)])));

} else {
throw ex__37179__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37177__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38818 = state_37383;
state_37383 = G__38818;
continue;
} else {
return ret_value__37177__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__ = function(state_37383){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____1.call(this,state_37383);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__;
})()
;})(__38802,switch__37175__auto__,c__37211__auto___38807,G__37370_38804,G__37370_38805__$1,n__4613__auto___38801,jobs,results,process,async))
})();
var state__37213__auto__ = (function (){var statearr_37395 = f__37212__auto__();
(statearr_37395[(6)] = c__37211__auto___38807);

return statearr_37395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37213__auto__);
});})(__38802,c__37211__auto___38807,G__37370_38804,G__37370_38805__$1,n__4613__auto___38801,jobs,results,process,async))
);


break;
case "async":
var c__37211__auto___38819 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__38802,c__37211__auto___38819,G__37370_38804,G__37370_38805__$1,n__4613__auto___38801,jobs,results,process,async){
return (function (){
var f__37212__auto__ = (function (){var switch__37175__auto__ = ((function (__38802,c__37211__auto___38819,G__37370_38804,G__37370_38805__$1,n__4613__auto___38801,jobs,results,process,async){
return (function (state_37408){
var state_val_37409 = (state_37408[(1)]);
if((state_val_37409 === (1))){
var state_37408__$1 = state_37408;
var statearr_37410_38820 = state_37408__$1;
(statearr_37410_38820[(2)] = null);

(statearr_37410_38820[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37409 === (2))){
var state_37408__$1 = state_37408;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37408__$1,(4),jobs);
} else {
if((state_val_37409 === (3))){
var inst_37406 = (state_37408[(2)]);
var state_37408__$1 = state_37408;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37408__$1,inst_37406);
} else {
if((state_val_37409 === (4))){
var inst_37398 = (state_37408[(2)]);
var inst_37399 = async(inst_37398);
var state_37408__$1 = state_37408;
if(cljs.core.truth_(inst_37399)){
var statearr_37411_38821 = state_37408__$1;
(statearr_37411_38821[(1)] = (5));

} else {
var statearr_37412_38822 = state_37408__$1;
(statearr_37412_38822[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37409 === (5))){
var state_37408__$1 = state_37408;
var statearr_37413_38823 = state_37408__$1;
(statearr_37413_38823[(2)] = null);

(statearr_37413_38823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37409 === (6))){
var state_37408__$1 = state_37408;
var statearr_37414_38824 = state_37408__$1;
(statearr_37414_38824[(2)] = null);

(statearr_37414_38824[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37409 === (7))){
var inst_37404 = (state_37408[(2)]);
var state_37408__$1 = state_37408;
var statearr_37415_38825 = state_37408__$1;
(statearr_37415_38825[(2)] = inst_37404);

(statearr_37415_38825[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__38802,c__37211__auto___38819,G__37370_38804,G__37370_38805__$1,n__4613__auto___38801,jobs,results,process,async))
;
return ((function (__38802,switch__37175__auto__,c__37211__auto___38819,G__37370_38804,G__37370_38805__$1,n__4613__auto___38801,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____0 = (function (){
var statearr_37416 = [null,null,null,null,null,null,null];
(statearr_37416[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__);

(statearr_37416[(1)] = (1));

return statearr_37416;
});
var cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____1 = (function (state_37408){
while(true){
var ret_value__37177__auto__ = (function (){try{while(true){
var result__37178__auto__ = switch__37175__auto__(state_37408);
if(cljs.core.keyword_identical_QMARK_(result__37178__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37178__auto__;
}
break;
}
}catch (e37417){var ex__37179__auto__ = e37417;
var statearr_37418_38826 = state_37408;
(statearr_37418_38826[(2)] = ex__37179__auto__);


if(cljs.core.seq((state_37408[(4)]))){
var statearr_37419_38827 = state_37408;
(statearr_37419_38827[(1)] = cljs.core.first((state_37408[(4)])));

} else {
throw ex__37179__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37177__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38828 = state_37408;
state_37408 = G__38828;
continue;
} else {
return ret_value__37177__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__ = function(state_37408){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____1.call(this,state_37408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__;
})()
;})(__38802,switch__37175__auto__,c__37211__auto___38819,G__37370_38804,G__37370_38805__$1,n__4613__auto___38801,jobs,results,process,async))
})();
var state__37213__auto__ = (function (){var statearr_37420 = f__37212__auto__();
(statearr_37420[(6)] = c__37211__auto___38819);

return statearr_37420;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37213__auto__);
});})(__38802,c__37211__auto___38819,G__37370_38804,G__37370_38805__$1,n__4613__auto___38801,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__37370_38805__$1)].join('')));

}

var G__38831 = (__38802 + (1));
__38802 = G__38831;
continue;
} else {
}
break;
}

var c__37211__auto___38832 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37212__auto__ = (function (){var switch__37175__auto__ = (function (state_37442){
var state_val_37443 = (state_37442[(1)]);
if((state_val_37443 === (7))){
var inst_37438 = (state_37442[(2)]);
var state_37442__$1 = state_37442;
var statearr_37444_38835 = state_37442__$1;
(statearr_37444_38835[(2)] = inst_37438);

(statearr_37444_38835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37443 === (1))){
var state_37442__$1 = state_37442;
var statearr_37445_38836 = state_37442__$1;
(statearr_37445_38836[(2)] = null);

(statearr_37445_38836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37443 === (4))){
var inst_37423 = (state_37442[(7)]);
var inst_37423__$1 = (state_37442[(2)]);
var inst_37424 = (inst_37423__$1 == null);
var state_37442__$1 = (function (){var statearr_37446 = state_37442;
(statearr_37446[(7)] = inst_37423__$1);

return statearr_37446;
})();
if(cljs.core.truth_(inst_37424)){
var statearr_37447_38839 = state_37442__$1;
(statearr_37447_38839[(1)] = (5));

} else {
var statearr_37448_38840 = state_37442__$1;
(statearr_37448_38840[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37443 === (6))){
var inst_37428 = (state_37442[(8)]);
var inst_37423 = (state_37442[(7)]);
var inst_37428__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_37429 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37430 = [inst_37423,inst_37428__$1];
var inst_37431 = (new cljs.core.PersistentVector(null,2,(5),inst_37429,inst_37430,null));
var state_37442__$1 = (function (){var statearr_37449 = state_37442;
(statearr_37449[(8)] = inst_37428__$1);

return statearr_37449;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37442__$1,(8),jobs,inst_37431);
} else {
if((state_val_37443 === (3))){
var inst_37440 = (state_37442[(2)]);
var state_37442__$1 = state_37442;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37442__$1,inst_37440);
} else {
if((state_val_37443 === (2))){
var state_37442__$1 = state_37442;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37442__$1,(4),from);
} else {
if((state_val_37443 === (9))){
var inst_37435 = (state_37442[(2)]);
var state_37442__$1 = (function (){var statearr_37450 = state_37442;
(statearr_37450[(9)] = inst_37435);

return statearr_37450;
})();
var statearr_37451_38843 = state_37442__$1;
(statearr_37451_38843[(2)] = null);

(statearr_37451_38843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37443 === (5))){
var inst_37426 = cljs.core.async.close_BANG_(jobs);
var state_37442__$1 = state_37442;
var statearr_37452_38845 = state_37442__$1;
(statearr_37452_38845[(2)] = inst_37426);

(statearr_37452_38845[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37443 === (8))){
var inst_37428 = (state_37442[(8)]);
var inst_37433 = (state_37442[(2)]);
var state_37442__$1 = (function (){var statearr_37453 = state_37442;
(statearr_37453[(10)] = inst_37433);

return statearr_37453;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37442__$1,(9),results,inst_37428);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____0 = (function (){
var statearr_37454 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_37454[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__);

(statearr_37454[(1)] = (1));

return statearr_37454;
});
var cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____1 = (function (state_37442){
while(true){
var ret_value__37177__auto__ = (function (){try{while(true){
var result__37178__auto__ = switch__37175__auto__(state_37442);
if(cljs.core.keyword_identical_QMARK_(result__37178__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37178__auto__;
}
break;
}
}catch (e37455){var ex__37179__auto__ = e37455;
var statearr_37456_38849 = state_37442;
(statearr_37456_38849[(2)] = ex__37179__auto__);


if(cljs.core.seq((state_37442[(4)]))){
var statearr_37457_38850 = state_37442;
(statearr_37457_38850[(1)] = cljs.core.first((state_37442[(4)])));

} else {
throw ex__37179__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37177__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38851 = state_37442;
state_37442 = G__38851;
continue;
} else {
return ret_value__37177__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__ = function(state_37442){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____1.call(this,state_37442);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__;
})()
})();
var state__37213__auto__ = (function (){var statearr_37458 = f__37212__auto__();
(statearr_37458[(6)] = c__37211__auto___38832);

return statearr_37458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37213__auto__);
}));


var c__37211__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37212__auto__ = (function (){var switch__37175__auto__ = (function (state_37496){
var state_val_37497 = (state_37496[(1)]);
if((state_val_37497 === (7))){
var inst_37492 = (state_37496[(2)]);
var state_37496__$1 = state_37496;
var statearr_37498_38852 = state_37496__$1;
(statearr_37498_38852[(2)] = inst_37492);

(statearr_37498_38852[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37497 === (20))){
var state_37496__$1 = state_37496;
var statearr_37499_38853 = state_37496__$1;
(statearr_37499_38853[(2)] = null);

(statearr_37499_38853[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37497 === (1))){
var state_37496__$1 = state_37496;
var statearr_37500_38860 = state_37496__$1;
(statearr_37500_38860[(2)] = null);

(statearr_37500_38860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37497 === (4))){
var inst_37461 = (state_37496[(7)]);
var inst_37461__$1 = (state_37496[(2)]);
var inst_37462 = (inst_37461__$1 == null);
var state_37496__$1 = (function (){var statearr_37501 = state_37496;
(statearr_37501[(7)] = inst_37461__$1);

return statearr_37501;
})();
if(cljs.core.truth_(inst_37462)){
var statearr_37502_38864 = state_37496__$1;
(statearr_37502_38864[(1)] = (5));

} else {
var statearr_37503_38865 = state_37496__$1;
(statearr_37503_38865[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37497 === (15))){
var inst_37474 = (state_37496[(8)]);
var state_37496__$1 = state_37496;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37496__$1,(18),to,inst_37474);
} else {
if((state_val_37497 === (21))){
var inst_37487 = (state_37496[(2)]);
var state_37496__$1 = state_37496;
var statearr_37504_38868 = state_37496__$1;
(statearr_37504_38868[(2)] = inst_37487);

(statearr_37504_38868[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37497 === (13))){
var inst_37489 = (state_37496[(2)]);
var state_37496__$1 = (function (){var statearr_37505 = state_37496;
(statearr_37505[(9)] = inst_37489);

return statearr_37505;
})();
var statearr_37506_38870 = state_37496__$1;
(statearr_37506_38870[(2)] = null);

(statearr_37506_38870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37497 === (6))){
var inst_37461 = (state_37496[(7)]);
var state_37496__$1 = state_37496;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37496__$1,(11),inst_37461);
} else {
if((state_val_37497 === (17))){
var inst_37482 = (state_37496[(2)]);
var state_37496__$1 = state_37496;
if(cljs.core.truth_(inst_37482)){
var statearr_37507_38872 = state_37496__$1;
(statearr_37507_38872[(1)] = (19));

} else {
var statearr_37508_38873 = state_37496__$1;
(statearr_37508_38873[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37497 === (3))){
var inst_37494 = (state_37496[(2)]);
var state_37496__$1 = state_37496;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37496__$1,inst_37494);
} else {
if((state_val_37497 === (12))){
var inst_37471 = (state_37496[(10)]);
var state_37496__$1 = state_37496;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37496__$1,(14),inst_37471);
} else {
if((state_val_37497 === (2))){
var state_37496__$1 = state_37496;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37496__$1,(4),results);
} else {
if((state_val_37497 === (19))){
var state_37496__$1 = state_37496;
var statearr_37509_38878 = state_37496__$1;
(statearr_37509_38878[(2)] = null);

(statearr_37509_38878[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37497 === (11))){
var inst_37471 = (state_37496[(2)]);
var state_37496__$1 = (function (){var statearr_37510 = state_37496;
(statearr_37510[(10)] = inst_37471);

return statearr_37510;
})();
var statearr_37511_38882 = state_37496__$1;
(statearr_37511_38882[(2)] = null);

(statearr_37511_38882[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37497 === (9))){
var state_37496__$1 = state_37496;
var statearr_37512_38883 = state_37496__$1;
(statearr_37512_38883[(2)] = null);

(statearr_37512_38883[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37497 === (5))){
var state_37496__$1 = state_37496;
if(cljs.core.truth_(close_QMARK_)){
var statearr_37513_38884 = state_37496__$1;
(statearr_37513_38884[(1)] = (8));

} else {
var statearr_37514_38885 = state_37496__$1;
(statearr_37514_38885[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37497 === (14))){
var inst_37474 = (state_37496[(8)]);
var inst_37474__$1 = (state_37496[(2)]);
var inst_37475 = (inst_37474__$1 == null);
var inst_37476 = cljs.core.not(inst_37475);
var state_37496__$1 = (function (){var statearr_37515 = state_37496;
(statearr_37515[(8)] = inst_37474__$1);

return statearr_37515;
})();
if(inst_37476){
var statearr_37516_38886 = state_37496__$1;
(statearr_37516_38886[(1)] = (15));

} else {
var statearr_37517_38887 = state_37496__$1;
(statearr_37517_38887[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37497 === (16))){
var state_37496__$1 = state_37496;
var statearr_37518_38888 = state_37496__$1;
(statearr_37518_38888[(2)] = false);

(statearr_37518_38888[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37497 === (10))){
var inst_37468 = (state_37496[(2)]);
var state_37496__$1 = state_37496;
var statearr_37519_38889 = state_37496__$1;
(statearr_37519_38889[(2)] = inst_37468);

(statearr_37519_38889[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37497 === (18))){
var inst_37479 = (state_37496[(2)]);
var state_37496__$1 = state_37496;
var statearr_37520_38890 = state_37496__$1;
(statearr_37520_38890[(2)] = inst_37479);

(statearr_37520_38890[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37497 === (8))){
var inst_37465 = cljs.core.async.close_BANG_(to);
var state_37496__$1 = state_37496;
var statearr_37521_38891 = state_37496__$1;
(statearr_37521_38891[(2)] = inst_37465);

(statearr_37521_38891[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____0 = (function (){
var statearr_37522 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_37522[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__);

(statearr_37522[(1)] = (1));

return statearr_37522;
});
var cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____1 = (function (state_37496){
while(true){
var ret_value__37177__auto__ = (function (){try{while(true){
var result__37178__auto__ = switch__37175__auto__(state_37496);
if(cljs.core.keyword_identical_QMARK_(result__37178__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37178__auto__;
}
break;
}
}catch (e37523){var ex__37179__auto__ = e37523;
var statearr_37524_38892 = state_37496;
(statearr_37524_38892[(2)] = ex__37179__auto__);


if(cljs.core.seq((state_37496[(4)]))){
var statearr_37525_38893 = state_37496;
(statearr_37525_38893[(1)] = cljs.core.first((state_37496[(4)])));

} else {
throw ex__37179__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37177__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38894 = state_37496;
state_37496 = G__38894;
continue;
} else {
return ret_value__37177__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__ = function(state_37496){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____1.call(this,state_37496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__37176__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__37176__auto__;
})()
})();
var state__37213__auto__ = (function (){var statearr_37526 = f__37212__auto__();
(statearr_37526[(6)] = c__37211__auto__);

return statearr_37526;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37213__auto__);
}));

return c__37211__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__37528 = arguments.length;
switch (G__37528) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__37530 = arguments.length;
switch (G__37530) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__37532 = arguments.length;
switch (G__37532) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__37211__auto___38904 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37212__auto__ = (function (){var switch__37175__auto__ = (function (state_37558){
var state_val_37559 = (state_37558[(1)]);
if((state_val_37559 === (7))){
var inst_37554 = (state_37558[(2)]);
var state_37558__$1 = state_37558;
var statearr_37560_38913 = state_37558__$1;
(statearr_37560_38913[(2)] = inst_37554);

(statearr_37560_38913[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37559 === (1))){
var state_37558__$1 = state_37558;
var statearr_37561_38915 = state_37558__$1;
(statearr_37561_38915[(2)] = null);

(statearr_37561_38915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37559 === (4))){
var inst_37535 = (state_37558[(7)]);
var inst_37535__$1 = (state_37558[(2)]);
var inst_37536 = (inst_37535__$1 == null);
var state_37558__$1 = (function (){var statearr_37562 = state_37558;
(statearr_37562[(7)] = inst_37535__$1);

return statearr_37562;
})();
if(cljs.core.truth_(inst_37536)){
var statearr_37563_38921 = state_37558__$1;
(statearr_37563_38921[(1)] = (5));

} else {
var statearr_37564_38922 = state_37558__$1;
(statearr_37564_38922[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37559 === (13))){
var state_37558__$1 = state_37558;
var statearr_37565_38925 = state_37558__$1;
(statearr_37565_38925[(2)] = null);

(statearr_37565_38925[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37559 === (6))){
var inst_37535 = (state_37558[(7)]);
var inst_37541 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_37535) : p.call(null,inst_37535));
var state_37558__$1 = state_37558;
if(cljs.core.truth_(inst_37541)){
var statearr_37566_38930 = state_37558__$1;
(statearr_37566_38930[(1)] = (9));

} else {
var statearr_37567_38931 = state_37558__$1;
(statearr_37567_38931[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37559 === (3))){
var inst_37556 = (state_37558[(2)]);
var state_37558__$1 = state_37558;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37558__$1,inst_37556);
} else {
if((state_val_37559 === (12))){
var state_37558__$1 = state_37558;
var statearr_37568_38938 = state_37558__$1;
(statearr_37568_38938[(2)] = null);

(statearr_37568_38938[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37559 === (2))){
var state_37558__$1 = state_37558;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37558__$1,(4),ch);
} else {
if((state_val_37559 === (11))){
var inst_37535 = (state_37558[(7)]);
var inst_37545 = (state_37558[(2)]);
var state_37558__$1 = state_37558;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37558__$1,(8),inst_37545,inst_37535);
} else {
if((state_val_37559 === (9))){
var state_37558__$1 = state_37558;
var statearr_37569_38939 = state_37558__$1;
(statearr_37569_38939[(2)] = tc);

(statearr_37569_38939[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37559 === (5))){
var inst_37538 = cljs.core.async.close_BANG_(tc);
var inst_37539 = cljs.core.async.close_BANG_(fc);
var state_37558__$1 = (function (){var statearr_37570 = state_37558;
(statearr_37570[(8)] = inst_37538);

return statearr_37570;
})();
var statearr_37571_38940 = state_37558__$1;
(statearr_37571_38940[(2)] = inst_37539);

(statearr_37571_38940[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37559 === (14))){
var inst_37552 = (state_37558[(2)]);
var state_37558__$1 = state_37558;
var statearr_37572_38941 = state_37558__$1;
(statearr_37572_38941[(2)] = inst_37552);

(statearr_37572_38941[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37559 === (10))){
var state_37558__$1 = state_37558;
var statearr_37573_38944 = state_37558__$1;
(statearr_37573_38944[(2)] = fc);

(statearr_37573_38944[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37559 === (8))){
var inst_37547 = (state_37558[(2)]);
var state_37558__$1 = state_37558;
if(cljs.core.truth_(inst_37547)){
var statearr_37574_38945 = state_37558__$1;
(statearr_37574_38945[(1)] = (12));

} else {
var statearr_37575_38946 = state_37558__$1;
(statearr_37575_38946[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__37176__auto__ = null;
var cljs$core$async$state_machine__37176__auto____0 = (function (){
var statearr_37576 = [null,null,null,null,null,null,null,null,null];
(statearr_37576[(0)] = cljs$core$async$state_machine__37176__auto__);

(statearr_37576[(1)] = (1));

return statearr_37576;
});
var cljs$core$async$state_machine__37176__auto____1 = (function (state_37558){
while(true){
var ret_value__37177__auto__ = (function (){try{while(true){
var result__37178__auto__ = switch__37175__auto__(state_37558);
if(cljs.core.keyword_identical_QMARK_(result__37178__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37178__auto__;
}
break;
}
}catch (e37577){var ex__37179__auto__ = e37577;
var statearr_37578_38949 = state_37558;
(statearr_37578_38949[(2)] = ex__37179__auto__);


if(cljs.core.seq((state_37558[(4)]))){
var statearr_37579_38953 = state_37558;
(statearr_37579_38953[(1)] = cljs.core.first((state_37558[(4)])));

} else {
throw ex__37179__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37177__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38956 = state_37558;
state_37558 = G__38956;
continue;
} else {
return ret_value__37177__auto__;
}
break;
}
});
cljs$core$async$state_machine__37176__auto__ = function(state_37558){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37176__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37176__auto____1.call(this,state_37558);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37176__auto____0;
cljs$core$async$state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37176__auto____1;
return cljs$core$async$state_machine__37176__auto__;
})()
})();
var state__37213__auto__ = (function (){var statearr_37580 = f__37212__auto__();
(statearr_37580[(6)] = c__37211__auto___38904);

return statearr_37580;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37213__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__37211__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37212__auto__ = (function (){var switch__37175__auto__ = (function (state_37602){
var state_val_37603 = (state_37602[(1)]);
if((state_val_37603 === (7))){
var inst_37598 = (state_37602[(2)]);
var state_37602__$1 = state_37602;
var statearr_37604_38959 = state_37602__$1;
(statearr_37604_38959[(2)] = inst_37598);

(statearr_37604_38959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37603 === (1))){
var inst_37581 = init;
var inst_37582 = inst_37581;
var state_37602__$1 = (function (){var statearr_37605 = state_37602;
(statearr_37605[(7)] = inst_37582);

return statearr_37605;
})();
var statearr_37606_38960 = state_37602__$1;
(statearr_37606_38960[(2)] = null);

(statearr_37606_38960[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37603 === (4))){
var inst_37585 = (state_37602[(8)]);
var inst_37585__$1 = (state_37602[(2)]);
var inst_37586 = (inst_37585__$1 == null);
var state_37602__$1 = (function (){var statearr_37607 = state_37602;
(statearr_37607[(8)] = inst_37585__$1);

return statearr_37607;
})();
if(cljs.core.truth_(inst_37586)){
var statearr_37608_38961 = state_37602__$1;
(statearr_37608_38961[(1)] = (5));

} else {
var statearr_37609_38962 = state_37602__$1;
(statearr_37609_38962[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37603 === (6))){
var inst_37582 = (state_37602[(7)]);
var inst_37589 = (state_37602[(9)]);
var inst_37585 = (state_37602[(8)]);
var inst_37589__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_37582,inst_37585) : f.call(null,inst_37582,inst_37585));
var inst_37590 = cljs.core.reduced_QMARK_(inst_37589__$1);
var state_37602__$1 = (function (){var statearr_37610 = state_37602;
(statearr_37610[(9)] = inst_37589__$1);

return statearr_37610;
})();
if(inst_37590){
var statearr_37611_38965 = state_37602__$1;
(statearr_37611_38965[(1)] = (8));

} else {
var statearr_37612_38966 = state_37602__$1;
(statearr_37612_38966[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37603 === (3))){
var inst_37600 = (state_37602[(2)]);
var state_37602__$1 = state_37602;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37602__$1,inst_37600);
} else {
if((state_val_37603 === (2))){
var state_37602__$1 = state_37602;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37602__$1,(4),ch);
} else {
if((state_val_37603 === (9))){
var inst_37589 = (state_37602[(9)]);
var inst_37582 = inst_37589;
var state_37602__$1 = (function (){var statearr_37613 = state_37602;
(statearr_37613[(7)] = inst_37582);

return statearr_37613;
})();
var statearr_37614_38972 = state_37602__$1;
(statearr_37614_38972[(2)] = null);

(statearr_37614_38972[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37603 === (5))){
var inst_37582 = (state_37602[(7)]);
var state_37602__$1 = state_37602;
var statearr_37615_38975 = state_37602__$1;
(statearr_37615_38975[(2)] = inst_37582);

(statearr_37615_38975[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37603 === (10))){
var inst_37596 = (state_37602[(2)]);
var state_37602__$1 = state_37602;
var statearr_37616_38979 = state_37602__$1;
(statearr_37616_38979[(2)] = inst_37596);

(statearr_37616_38979[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37603 === (8))){
var inst_37589 = (state_37602[(9)]);
var inst_37592 = cljs.core.deref(inst_37589);
var state_37602__$1 = state_37602;
var statearr_37617_38981 = state_37602__$1;
(statearr_37617_38981[(2)] = inst_37592);

(statearr_37617_38981[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__37176__auto__ = null;
var cljs$core$async$reduce_$_state_machine__37176__auto____0 = (function (){
var statearr_37618 = [null,null,null,null,null,null,null,null,null,null];
(statearr_37618[(0)] = cljs$core$async$reduce_$_state_machine__37176__auto__);

(statearr_37618[(1)] = (1));

return statearr_37618;
});
var cljs$core$async$reduce_$_state_machine__37176__auto____1 = (function (state_37602){
while(true){
var ret_value__37177__auto__ = (function (){try{while(true){
var result__37178__auto__ = switch__37175__auto__(state_37602);
if(cljs.core.keyword_identical_QMARK_(result__37178__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37178__auto__;
}
break;
}
}catch (e37619){var ex__37179__auto__ = e37619;
var statearr_37620_38988 = state_37602;
(statearr_37620_38988[(2)] = ex__37179__auto__);


if(cljs.core.seq((state_37602[(4)]))){
var statearr_37621_38989 = state_37602;
(statearr_37621_38989[(1)] = cljs.core.first((state_37602[(4)])));

} else {
throw ex__37179__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37177__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38990 = state_37602;
state_37602 = G__38990;
continue;
} else {
return ret_value__37177__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__37176__auto__ = function(state_37602){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__37176__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__37176__auto____1.call(this,state_37602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__37176__auto____0;
cljs$core$async$reduce_$_state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__37176__auto____1;
return cljs$core$async$reduce_$_state_machine__37176__auto__;
})()
})();
var state__37213__auto__ = (function (){var statearr_37622 = f__37212__auto__();
(statearr_37622[(6)] = c__37211__auto__);

return statearr_37622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37213__auto__);
}));

return c__37211__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__37211__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37212__auto__ = (function (){var switch__37175__auto__ = (function (state_37628){
var state_val_37629 = (state_37628[(1)]);
if((state_val_37629 === (1))){
var inst_37623 = cljs.core.async.reduce(f__$1,init,ch);
var state_37628__$1 = state_37628;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37628__$1,(2),inst_37623);
} else {
if((state_val_37629 === (2))){
var inst_37625 = (state_37628[(2)]);
var inst_37626 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_37625) : f__$1.call(null,inst_37625));
var state_37628__$1 = state_37628;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37628__$1,inst_37626);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__37176__auto__ = null;
var cljs$core$async$transduce_$_state_machine__37176__auto____0 = (function (){
var statearr_37630 = [null,null,null,null,null,null,null];
(statearr_37630[(0)] = cljs$core$async$transduce_$_state_machine__37176__auto__);

(statearr_37630[(1)] = (1));

return statearr_37630;
});
var cljs$core$async$transduce_$_state_machine__37176__auto____1 = (function (state_37628){
while(true){
var ret_value__37177__auto__ = (function (){try{while(true){
var result__37178__auto__ = switch__37175__auto__(state_37628);
if(cljs.core.keyword_identical_QMARK_(result__37178__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37178__auto__;
}
break;
}
}catch (e37631){var ex__37179__auto__ = e37631;
var statearr_37632_39002 = state_37628;
(statearr_37632_39002[(2)] = ex__37179__auto__);


if(cljs.core.seq((state_37628[(4)]))){
var statearr_37633_39003 = state_37628;
(statearr_37633_39003[(1)] = cljs.core.first((state_37628[(4)])));

} else {
throw ex__37179__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37177__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39004 = state_37628;
state_37628 = G__39004;
continue;
} else {
return ret_value__37177__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__37176__auto__ = function(state_37628){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__37176__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__37176__auto____1.call(this,state_37628);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__37176__auto____0;
cljs$core$async$transduce_$_state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__37176__auto____1;
return cljs$core$async$transduce_$_state_machine__37176__auto__;
})()
})();
var state__37213__auto__ = (function (){var statearr_37634 = f__37212__auto__();
(statearr_37634[(6)] = c__37211__auto__);

return statearr_37634;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37213__auto__);
}));

return c__37211__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__37636 = arguments.length;
switch (G__37636) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__37211__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37212__auto__ = (function (){var switch__37175__auto__ = (function (state_37661){
var state_val_37662 = (state_37661[(1)]);
if((state_val_37662 === (7))){
var inst_37643 = (state_37661[(2)]);
var state_37661__$1 = state_37661;
var statearr_37663_39006 = state_37661__$1;
(statearr_37663_39006[(2)] = inst_37643);

(statearr_37663_39006[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (1))){
var inst_37637 = cljs.core.seq(coll);
var inst_37638 = inst_37637;
var state_37661__$1 = (function (){var statearr_37664 = state_37661;
(statearr_37664[(7)] = inst_37638);

return statearr_37664;
})();
var statearr_37665_39007 = state_37661__$1;
(statearr_37665_39007[(2)] = null);

(statearr_37665_39007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (4))){
var inst_37638 = (state_37661[(7)]);
var inst_37641 = cljs.core.first(inst_37638);
var state_37661__$1 = state_37661;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37661__$1,(7),ch,inst_37641);
} else {
if((state_val_37662 === (13))){
var inst_37655 = (state_37661[(2)]);
var state_37661__$1 = state_37661;
var statearr_37666_39008 = state_37661__$1;
(statearr_37666_39008[(2)] = inst_37655);

(statearr_37666_39008[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (6))){
var inst_37646 = (state_37661[(2)]);
var state_37661__$1 = state_37661;
if(cljs.core.truth_(inst_37646)){
var statearr_37667_39009 = state_37661__$1;
(statearr_37667_39009[(1)] = (8));

} else {
var statearr_37668_39010 = state_37661__$1;
(statearr_37668_39010[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (3))){
var inst_37659 = (state_37661[(2)]);
var state_37661__$1 = state_37661;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37661__$1,inst_37659);
} else {
if((state_val_37662 === (12))){
var state_37661__$1 = state_37661;
var statearr_37669_39011 = state_37661__$1;
(statearr_37669_39011[(2)] = null);

(statearr_37669_39011[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (2))){
var inst_37638 = (state_37661[(7)]);
var state_37661__$1 = state_37661;
if(cljs.core.truth_(inst_37638)){
var statearr_37670_39012 = state_37661__$1;
(statearr_37670_39012[(1)] = (4));

} else {
var statearr_37671_39013 = state_37661__$1;
(statearr_37671_39013[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (11))){
var inst_37652 = cljs.core.async.close_BANG_(ch);
var state_37661__$1 = state_37661;
var statearr_37672_39014 = state_37661__$1;
(statearr_37672_39014[(2)] = inst_37652);

(statearr_37672_39014[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (9))){
var state_37661__$1 = state_37661;
if(cljs.core.truth_(close_QMARK_)){
var statearr_37673_39015 = state_37661__$1;
(statearr_37673_39015[(1)] = (11));

} else {
var statearr_37674_39020 = state_37661__$1;
(statearr_37674_39020[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (5))){
var inst_37638 = (state_37661[(7)]);
var state_37661__$1 = state_37661;
var statearr_37675_39021 = state_37661__$1;
(statearr_37675_39021[(2)] = inst_37638);

(statearr_37675_39021[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (10))){
var inst_37657 = (state_37661[(2)]);
var state_37661__$1 = state_37661;
var statearr_37676_39022 = state_37661__$1;
(statearr_37676_39022[(2)] = inst_37657);

(statearr_37676_39022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (8))){
var inst_37638 = (state_37661[(7)]);
var inst_37648 = cljs.core.next(inst_37638);
var inst_37638__$1 = inst_37648;
var state_37661__$1 = (function (){var statearr_37677 = state_37661;
(statearr_37677[(7)] = inst_37638__$1);

return statearr_37677;
})();
var statearr_37678_39023 = state_37661__$1;
(statearr_37678_39023[(2)] = null);

(statearr_37678_39023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__37176__auto__ = null;
var cljs$core$async$state_machine__37176__auto____0 = (function (){
var statearr_37679 = [null,null,null,null,null,null,null,null];
(statearr_37679[(0)] = cljs$core$async$state_machine__37176__auto__);

(statearr_37679[(1)] = (1));

return statearr_37679;
});
var cljs$core$async$state_machine__37176__auto____1 = (function (state_37661){
while(true){
var ret_value__37177__auto__ = (function (){try{while(true){
var result__37178__auto__ = switch__37175__auto__(state_37661);
if(cljs.core.keyword_identical_QMARK_(result__37178__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37178__auto__;
}
break;
}
}catch (e37680){var ex__37179__auto__ = e37680;
var statearr_37681_39024 = state_37661;
(statearr_37681_39024[(2)] = ex__37179__auto__);


if(cljs.core.seq((state_37661[(4)]))){
var statearr_37682_39025 = state_37661;
(statearr_37682_39025[(1)] = cljs.core.first((state_37661[(4)])));

} else {
throw ex__37179__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37177__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39026 = state_37661;
state_37661 = G__39026;
continue;
} else {
return ret_value__37177__auto__;
}
break;
}
});
cljs$core$async$state_machine__37176__auto__ = function(state_37661){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37176__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37176__auto____1.call(this,state_37661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37176__auto____0;
cljs$core$async$state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37176__auto____1;
return cljs$core$async$state_machine__37176__auto__;
})()
})();
var state__37213__auto__ = (function (){var statearr_37683 = f__37212__auto__();
(statearr_37683[(6)] = c__37211__auto__);

return statearr_37683;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37213__auto__);
}));

return c__37211__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__37685 = arguments.length;
switch (G__37685) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_39029 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_39029(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_39041 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_39041(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_39055 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_39055(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_39059 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_39059(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async37686 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37686 = (function (ch,cs,meta37687){
this.ch = ch;
this.cs = cs;
this.meta37687 = meta37687;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async37686.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37688,meta37687__$1){
var self__ = this;
var _37688__$1 = this;
return (new cljs.core.async.t_cljs$core$async37686(self__.ch,self__.cs,meta37687__$1));
}));

(cljs.core.async.t_cljs$core$async37686.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37688){
var self__ = this;
var _37688__$1 = this;
return self__.meta37687;
}));

(cljs.core.async.t_cljs$core$async37686.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async37686.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async37686.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async37686.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async37686.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async37686.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async37686.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta37687","meta37687",-351803952,null)], null);
}));

(cljs.core.async.t_cljs$core$async37686.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async37686.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37686");

(cljs.core.async.t_cljs$core$async37686.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async37686");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37686.
 */
cljs.core.async.__GT_t_cljs$core$async37686 = (function cljs$core$async$mult_$___GT_t_cljs$core$async37686(ch__$1,cs__$1,meta37687){
return (new cljs.core.async.t_cljs$core$async37686(ch__$1,cs__$1,meta37687));
});

}

return (new cljs.core.async.t_cljs$core$async37686(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__37211__auto___39068 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37212__auto__ = (function (){var switch__37175__auto__ = (function (state_37821){
var state_val_37822 = (state_37821[(1)]);
if((state_val_37822 === (7))){
var inst_37817 = (state_37821[(2)]);
var state_37821__$1 = state_37821;
var statearr_37823_39069 = state_37821__$1;
(statearr_37823_39069[(2)] = inst_37817);

(statearr_37823_39069[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (20))){
var inst_37722 = (state_37821[(7)]);
var inst_37734 = cljs.core.first(inst_37722);
var inst_37735 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37734,(0),null);
var inst_37736 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37734,(1),null);
var state_37821__$1 = (function (){var statearr_37824 = state_37821;
(statearr_37824[(8)] = inst_37735);

return statearr_37824;
})();
if(cljs.core.truth_(inst_37736)){
var statearr_37825_39072 = state_37821__$1;
(statearr_37825_39072[(1)] = (22));

} else {
var statearr_37826_39073 = state_37821__$1;
(statearr_37826_39073[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (27))){
var inst_37766 = (state_37821[(9)]);
var inst_37764 = (state_37821[(10)]);
var inst_37691 = (state_37821[(11)]);
var inst_37771 = (state_37821[(12)]);
var inst_37771__$1 = cljs.core._nth(inst_37764,inst_37766);
var inst_37772 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_37771__$1,inst_37691,done);
var state_37821__$1 = (function (){var statearr_37827 = state_37821;
(statearr_37827[(12)] = inst_37771__$1);

return statearr_37827;
})();
if(cljs.core.truth_(inst_37772)){
var statearr_37828_39085 = state_37821__$1;
(statearr_37828_39085[(1)] = (30));

} else {
var statearr_37829_39086 = state_37821__$1;
(statearr_37829_39086[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (1))){
var state_37821__$1 = state_37821;
var statearr_37830_39087 = state_37821__$1;
(statearr_37830_39087[(2)] = null);

(statearr_37830_39087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (24))){
var inst_37722 = (state_37821[(7)]);
var inst_37741 = (state_37821[(2)]);
var inst_37742 = cljs.core.next(inst_37722);
var inst_37700 = inst_37742;
var inst_37701 = null;
var inst_37702 = (0);
var inst_37703 = (0);
var state_37821__$1 = (function (){var statearr_37831 = state_37821;
(statearr_37831[(13)] = inst_37702);

(statearr_37831[(14)] = inst_37701);

(statearr_37831[(15)] = inst_37703);

(statearr_37831[(16)] = inst_37700);

(statearr_37831[(17)] = inst_37741);

return statearr_37831;
})();
var statearr_37832_39090 = state_37821__$1;
(statearr_37832_39090[(2)] = null);

(statearr_37832_39090[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (39))){
var state_37821__$1 = state_37821;
var statearr_37836_39091 = state_37821__$1;
(statearr_37836_39091[(2)] = null);

(statearr_37836_39091[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (4))){
var inst_37691 = (state_37821[(11)]);
var inst_37691__$1 = (state_37821[(2)]);
var inst_37692 = (inst_37691__$1 == null);
var state_37821__$1 = (function (){var statearr_37837 = state_37821;
(statearr_37837[(11)] = inst_37691__$1);

return statearr_37837;
})();
if(cljs.core.truth_(inst_37692)){
var statearr_37838_39093 = state_37821__$1;
(statearr_37838_39093[(1)] = (5));

} else {
var statearr_37839_39094 = state_37821__$1;
(statearr_37839_39094[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (15))){
var inst_37702 = (state_37821[(13)]);
var inst_37701 = (state_37821[(14)]);
var inst_37703 = (state_37821[(15)]);
var inst_37700 = (state_37821[(16)]);
var inst_37718 = (state_37821[(2)]);
var inst_37719 = (inst_37703 + (1));
var tmp37833 = inst_37702;
var tmp37834 = inst_37701;
var tmp37835 = inst_37700;
var inst_37700__$1 = tmp37835;
var inst_37701__$1 = tmp37834;
var inst_37702__$1 = tmp37833;
var inst_37703__$1 = inst_37719;
var state_37821__$1 = (function (){var statearr_37840 = state_37821;
(statearr_37840[(13)] = inst_37702__$1);

(statearr_37840[(14)] = inst_37701__$1);

(statearr_37840[(15)] = inst_37703__$1);

(statearr_37840[(18)] = inst_37718);

(statearr_37840[(16)] = inst_37700__$1);

return statearr_37840;
})();
var statearr_37841_39101 = state_37821__$1;
(statearr_37841_39101[(2)] = null);

(statearr_37841_39101[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (21))){
var inst_37745 = (state_37821[(2)]);
var state_37821__$1 = state_37821;
var statearr_37845_39102 = state_37821__$1;
(statearr_37845_39102[(2)] = inst_37745);

(statearr_37845_39102[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (31))){
var inst_37771 = (state_37821[(12)]);
var inst_37775 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_37771);
var state_37821__$1 = state_37821;
var statearr_37846_39104 = state_37821__$1;
(statearr_37846_39104[(2)] = inst_37775);

(statearr_37846_39104[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (32))){
var inst_37765 = (state_37821[(19)]);
var inst_37766 = (state_37821[(9)]);
var inst_37764 = (state_37821[(10)]);
var inst_37763 = (state_37821[(20)]);
var inst_37777 = (state_37821[(2)]);
var inst_37778 = (inst_37766 + (1));
var tmp37842 = inst_37765;
var tmp37843 = inst_37764;
var tmp37844 = inst_37763;
var inst_37763__$1 = tmp37844;
var inst_37764__$1 = tmp37843;
var inst_37765__$1 = tmp37842;
var inst_37766__$1 = inst_37778;
var state_37821__$1 = (function (){var statearr_37847 = state_37821;
(statearr_37847[(19)] = inst_37765__$1);

(statearr_37847[(9)] = inst_37766__$1);

(statearr_37847[(10)] = inst_37764__$1);

(statearr_37847[(20)] = inst_37763__$1);

(statearr_37847[(21)] = inst_37777);

return statearr_37847;
})();
var statearr_37848_39133 = state_37821__$1;
(statearr_37848_39133[(2)] = null);

(statearr_37848_39133[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (40))){
var inst_37790 = (state_37821[(22)]);
var inst_37794 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_37790);
var state_37821__$1 = state_37821;
var statearr_37849_39134 = state_37821__$1;
(statearr_37849_39134[(2)] = inst_37794);

(statearr_37849_39134[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (33))){
var inst_37781 = (state_37821[(23)]);
var inst_37783 = cljs.core.chunked_seq_QMARK_(inst_37781);
var state_37821__$1 = state_37821;
if(inst_37783){
var statearr_37850_39140 = state_37821__$1;
(statearr_37850_39140[(1)] = (36));

} else {
var statearr_37851_39142 = state_37821__$1;
(statearr_37851_39142[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (13))){
var inst_37712 = (state_37821[(24)]);
var inst_37715 = cljs.core.async.close_BANG_(inst_37712);
var state_37821__$1 = state_37821;
var statearr_37852_39144 = state_37821__$1;
(statearr_37852_39144[(2)] = inst_37715);

(statearr_37852_39144[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (22))){
var inst_37735 = (state_37821[(8)]);
var inst_37738 = cljs.core.async.close_BANG_(inst_37735);
var state_37821__$1 = state_37821;
var statearr_37853_39145 = state_37821__$1;
(statearr_37853_39145[(2)] = inst_37738);

(statearr_37853_39145[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (36))){
var inst_37781 = (state_37821[(23)]);
var inst_37785 = cljs.core.chunk_first(inst_37781);
var inst_37786 = cljs.core.chunk_rest(inst_37781);
var inst_37787 = cljs.core.count(inst_37785);
var inst_37763 = inst_37786;
var inst_37764 = inst_37785;
var inst_37765 = inst_37787;
var inst_37766 = (0);
var state_37821__$1 = (function (){var statearr_37854 = state_37821;
(statearr_37854[(19)] = inst_37765);

(statearr_37854[(9)] = inst_37766);

(statearr_37854[(10)] = inst_37764);

(statearr_37854[(20)] = inst_37763);

return statearr_37854;
})();
var statearr_37855_39149 = state_37821__$1;
(statearr_37855_39149[(2)] = null);

(statearr_37855_39149[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (41))){
var inst_37781 = (state_37821[(23)]);
var inst_37796 = (state_37821[(2)]);
var inst_37797 = cljs.core.next(inst_37781);
var inst_37763 = inst_37797;
var inst_37764 = null;
var inst_37765 = (0);
var inst_37766 = (0);
var state_37821__$1 = (function (){var statearr_37856 = state_37821;
(statearr_37856[(19)] = inst_37765);

(statearr_37856[(9)] = inst_37766);

(statearr_37856[(10)] = inst_37764);

(statearr_37856[(25)] = inst_37796);

(statearr_37856[(20)] = inst_37763);

return statearr_37856;
})();
var statearr_37857_39151 = state_37821__$1;
(statearr_37857_39151[(2)] = null);

(statearr_37857_39151[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (43))){
var state_37821__$1 = state_37821;
var statearr_37858_39152 = state_37821__$1;
(statearr_37858_39152[(2)] = null);

(statearr_37858_39152[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (29))){
var inst_37805 = (state_37821[(2)]);
var state_37821__$1 = state_37821;
var statearr_37859_39153 = state_37821__$1;
(statearr_37859_39153[(2)] = inst_37805);

(statearr_37859_39153[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (44))){
var inst_37814 = (state_37821[(2)]);
var state_37821__$1 = (function (){var statearr_37860 = state_37821;
(statearr_37860[(26)] = inst_37814);

return statearr_37860;
})();
var statearr_37861_39154 = state_37821__$1;
(statearr_37861_39154[(2)] = null);

(statearr_37861_39154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (6))){
var inst_37755 = (state_37821[(27)]);
var inst_37754 = cljs.core.deref(cs);
var inst_37755__$1 = cljs.core.keys(inst_37754);
var inst_37756 = cljs.core.count(inst_37755__$1);
var inst_37757 = cljs.core.reset_BANG_(dctr,inst_37756);
var inst_37762 = cljs.core.seq(inst_37755__$1);
var inst_37763 = inst_37762;
var inst_37764 = null;
var inst_37765 = (0);
var inst_37766 = (0);
var state_37821__$1 = (function (){var statearr_37862 = state_37821;
(statearr_37862[(19)] = inst_37765);

(statearr_37862[(9)] = inst_37766);

(statearr_37862[(10)] = inst_37764);

(statearr_37862[(27)] = inst_37755__$1);

(statearr_37862[(28)] = inst_37757);

(statearr_37862[(20)] = inst_37763);

return statearr_37862;
})();
var statearr_37863_39155 = state_37821__$1;
(statearr_37863_39155[(2)] = null);

(statearr_37863_39155[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (28))){
var inst_37781 = (state_37821[(23)]);
var inst_37763 = (state_37821[(20)]);
var inst_37781__$1 = cljs.core.seq(inst_37763);
var state_37821__$1 = (function (){var statearr_37864 = state_37821;
(statearr_37864[(23)] = inst_37781__$1);

return statearr_37864;
})();
if(inst_37781__$1){
var statearr_37865_39156 = state_37821__$1;
(statearr_37865_39156[(1)] = (33));

} else {
var statearr_37866_39157 = state_37821__$1;
(statearr_37866_39157[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (25))){
var inst_37765 = (state_37821[(19)]);
var inst_37766 = (state_37821[(9)]);
var inst_37768 = (inst_37766 < inst_37765);
var inst_37769 = inst_37768;
var state_37821__$1 = state_37821;
if(cljs.core.truth_(inst_37769)){
var statearr_37867_39158 = state_37821__$1;
(statearr_37867_39158[(1)] = (27));

} else {
var statearr_37868_39159 = state_37821__$1;
(statearr_37868_39159[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (34))){
var state_37821__$1 = state_37821;
var statearr_37869_39160 = state_37821__$1;
(statearr_37869_39160[(2)] = null);

(statearr_37869_39160[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (17))){
var state_37821__$1 = state_37821;
var statearr_37870_39163 = state_37821__$1;
(statearr_37870_39163[(2)] = null);

(statearr_37870_39163[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (3))){
var inst_37819 = (state_37821[(2)]);
var state_37821__$1 = state_37821;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37821__$1,inst_37819);
} else {
if((state_val_37822 === (12))){
var inst_37750 = (state_37821[(2)]);
var state_37821__$1 = state_37821;
var statearr_37871_39167 = state_37821__$1;
(statearr_37871_39167[(2)] = inst_37750);

(statearr_37871_39167[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (2))){
var state_37821__$1 = state_37821;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37821__$1,(4),ch);
} else {
if((state_val_37822 === (23))){
var state_37821__$1 = state_37821;
var statearr_37872_39168 = state_37821__$1;
(statearr_37872_39168[(2)] = null);

(statearr_37872_39168[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (35))){
var inst_37803 = (state_37821[(2)]);
var state_37821__$1 = state_37821;
var statearr_37873_39169 = state_37821__$1;
(statearr_37873_39169[(2)] = inst_37803);

(statearr_37873_39169[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (19))){
var inst_37722 = (state_37821[(7)]);
var inst_37726 = cljs.core.chunk_first(inst_37722);
var inst_37727 = cljs.core.chunk_rest(inst_37722);
var inst_37728 = cljs.core.count(inst_37726);
var inst_37700 = inst_37727;
var inst_37701 = inst_37726;
var inst_37702 = inst_37728;
var inst_37703 = (0);
var state_37821__$1 = (function (){var statearr_37874 = state_37821;
(statearr_37874[(13)] = inst_37702);

(statearr_37874[(14)] = inst_37701);

(statearr_37874[(15)] = inst_37703);

(statearr_37874[(16)] = inst_37700);

return statearr_37874;
})();
var statearr_37875_39173 = state_37821__$1;
(statearr_37875_39173[(2)] = null);

(statearr_37875_39173[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (11))){
var inst_37700 = (state_37821[(16)]);
var inst_37722 = (state_37821[(7)]);
var inst_37722__$1 = cljs.core.seq(inst_37700);
var state_37821__$1 = (function (){var statearr_37876 = state_37821;
(statearr_37876[(7)] = inst_37722__$1);

return statearr_37876;
})();
if(inst_37722__$1){
var statearr_37877_39211 = state_37821__$1;
(statearr_37877_39211[(1)] = (16));

} else {
var statearr_37878_39213 = state_37821__$1;
(statearr_37878_39213[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (9))){
var inst_37752 = (state_37821[(2)]);
var state_37821__$1 = state_37821;
var statearr_37879_39217 = state_37821__$1;
(statearr_37879_39217[(2)] = inst_37752);

(statearr_37879_39217[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (5))){
var inst_37698 = cljs.core.deref(cs);
var inst_37699 = cljs.core.seq(inst_37698);
var inst_37700 = inst_37699;
var inst_37701 = null;
var inst_37702 = (0);
var inst_37703 = (0);
var state_37821__$1 = (function (){var statearr_37880 = state_37821;
(statearr_37880[(13)] = inst_37702);

(statearr_37880[(14)] = inst_37701);

(statearr_37880[(15)] = inst_37703);

(statearr_37880[(16)] = inst_37700);

return statearr_37880;
})();
var statearr_37881_39221 = state_37821__$1;
(statearr_37881_39221[(2)] = null);

(statearr_37881_39221[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (14))){
var state_37821__$1 = state_37821;
var statearr_37882_39223 = state_37821__$1;
(statearr_37882_39223[(2)] = null);

(statearr_37882_39223[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (45))){
var inst_37811 = (state_37821[(2)]);
var state_37821__$1 = state_37821;
var statearr_37883_39225 = state_37821__$1;
(statearr_37883_39225[(2)] = inst_37811);

(statearr_37883_39225[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (26))){
var inst_37755 = (state_37821[(27)]);
var inst_37807 = (state_37821[(2)]);
var inst_37808 = cljs.core.seq(inst_37755);
var state_37821__$1 = (function (){var statearr_37884 = state_37821;
(statearr_37884[(29)] = inst_37807);

return statearr_37884;
})();
if(inst_37808){
var statearr_37885_39228 = state_37821__$1;
(statearr_37885_39228[(1)] = (42));

} else {
var statearr_37886_39229 = state_37821__$1;
(statearr_37886_39229[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (16))){
var inst_37722 = (state_37821[(7)]);
var inst_37724 = cljs.core.chunked_seq_QMARK_(inst_37722);
var state_37821__$1 = state_37821;
if(inst_37724){
var statearr_37887_39233 = state_37821__$1;
(statearr_37887_39233[(1)] = (19));

} else {
var statearr_37888_39234 = state_37821__$1;
(statearr_37888_39234[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (38))){
var inst_37800 = (state_37821[(2)]);
var state_37821__$1 = state_37821;
var statearr_37889_39236 = state_37821__$1;
(statearr_37889_39236[(2)] = inst_37800);

(statearr_37889_39236[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (30))){
var state_37821__$1 = state_37821;
var statearr_37890_39237 = state_37821__$1;
(statearr_37890_39237[(2)] = null);

(statearr_37890_39237[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (10))){
var inst_37701 = (state_37821[(14)]);
var inst_37703 = (state_37821[(15)]);
var inst_37711 = cljs.core._nth(inst_37701,inst_37703);
var inst_37712 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37711,(0),null);
var inst_37713 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37711,(1),null);
var state_37821__$1 = (function (){var statearr_37891 = state_37821;
(statearr_37891[(24)] = inst_37712);

return statearr_37891;
})();
if(cljs.core.truth_(inst_37713)){
var statearr_37892_39241 = state_37821__$1;
(statearr_37892_39241[(1)] = (13));

} else {
var statearr_37893_39242 = state_37821__$1;
(statearr_37893_39242[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (18))){
var inst_37748 = (state_37821[(2)]);
var state_37821__$1 = state_37821;
var statearr_37894_39243 = state_37821__$1;
(statearr_37894_39243[(2)] = inst_37748);

(statearr_37894_39243[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (42))){
var state_37821__$1 = state_37821;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37821__$1,(45),dchan);
} else {
if((state_val_37822 === (37))){
var inst_37781 = (state_37821[(23)]);
var inst_37790 = (state_37821[(22)]);
var inst_37691 = (state_37821[(11)]);
var inst_37790__$1 = cljs.core.first(inst_37781);
var inst_37791 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_37790__$1,inst_37691,done);
var state_37821__$1 = (function (){var statearr_37895 = state_37821;
(statearr_37895[(22)] = inst_37790__$1);

return statearr_37895;
})();
if(cljs.core.truth_(inst_37791)){
var statearr_37896_39247 = state_37821__$1;
(statearr_37896_39247[(1)] = (39));

} else {
var statearr_37897_39248 = state_37821__$1;
(statearr_37897_39248[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (8))){
var inst_37702 = (state_37821[(13)]);
var inst_37703 = (state_37821[(15)]);
var inst_37705 = (inst_37703 < inst_37702);
var inst_37706 = inst_37705;
var state_37821__$1 = state_37821;
if(cljs.core.truth_(inst_37706)){
var statearr_37898_39251 = state_37821__$1;
(statearr_37898_39251[(1)] = (10));

} else {
var statearr_37899_39253 = state_37821__$1;
(statearr_37899_39253[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__37176__auto__ = null;
var cljs$core$async$mult_$_state_machine__37176__auto____0 = (function (){
var statearr_37900 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37900[(0)] = cljs$core$async$mult_$_state_machine__37176__auto__);

(statearr_37900[(1)] = (1));

return statearr_37900;
});
var cljs$core$async$mult_$_state_machine__37176__auto____1 = (function (state_37821){
while(true){
var ret_value__37177__auto__ = (function (){try{while(true){
var result__37178__auto__ = switch__37175__auto__(state_37821);
if(cljs.core.keyword_identical_QMARK_(result__37178__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37178__auto__;
}
break;
}
}catch (e37901){var ex__37179__auto__ = e37901;
var statearr_37902_39257 = state_37821;
(statearr_37902_39257[(2)] = ex__37179__auto__);


if(cljs.core.seq((state_37821[(4)]))){
var statearr_37903_39259 = state_37821;
(statearr_37903_39259[(1)] = cljs.core.first((state_37821[(4)])));

} else {
throw ex__37179__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37177__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39260 = state_37821;
state_37821 = G__39260;
continue;
} else {
return ret_value__37177__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__37176__auto__ = function(state_37821){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__37176__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__37176__auto____1.call(this,state_37821);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__37176__auto____0;
cljs$core$async$mult_$_state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__37176__auto____1;
return cljs$core$async$mult_$_state_machine__37176__auto__;
})()
})();
var state__37213__auto__ = (function (){var statearr_37904 = f__37212__auto__();
(statearr_37904[(6)] = c__37211__auto___39068);

return statearr_37904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37213__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__37906 = arguments.length;
switch (G__37906) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_39357 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_39357(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_39358 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_39358(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_39359 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_39359(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_39360 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_39360(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_39361 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_39361(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___39362 = arguments.length;
var i__4737__auto___39363 = (0);
while(true){
if((i__4737__auto___39363 < len__4736__auto___39362)){
args__4742__auto__.push((arguments[i__4737__auto___39363]));

var G__39364 = (i__4737__auto___39363 + (1));
i__4737__auto___39363 = G__39364;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__37911){
var map__37912 = p__37911;
var map__37912__$1 = (((((!((map__37912 == null))))?(((((map__37912.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37912.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37912):map__37912);
var opts = map__37912__$1;
var statearr_37914_39365 = state;
(statearr_37914_39365[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_37915_39366 = state;
(statearr_37915_39366[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_37916_39367 = state;
(statearr_37916_39367[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq37907){
var G__37908 = cljs.core.first(seq37907);
var seq37907__$1 = cljs.core.next(seq37907);
var G__37909 = cljs.core.first(seq37907__$1);
var seq37907__$2 = cljs.core.next(seq37907__$1);
var G__37910 = cljs.core.first(seq37907__$2);
var seq37907__$3 = cljs.core.next(seq37907__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37908,G__37909,G__37910,seq37907__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async37917 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37917 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta37918){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta37918 = meta37918;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async37917.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37919,meta37918__$1){
var self__ = this;
var _37919__$1 = this;
return (new cljs.core.async.t_cljs$core$async37917(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta37918__$1));
}));

(cljs.core.async.t_cljs$core$async37917.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37919){
var self__ = this;
var _37919__$1 = this;
return self__.meta37918;
}));

(cljs.core.async.t_cljs$core$async37917.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async37917.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async37917.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async37917.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async37917.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async37917.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async37917.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async37917.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async37917.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta37918","meta37918",704225931,null)], null);
}));

(cljs.core.async.t_cljs$core$async37917.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async37917.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37917");

(cljs.core.async.t_cljs$core$async37917.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async37917");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37917.
 */
cljs.core.async.__GT_t_cljs$core$async37917 = (function cljs$core$async$mix_$___GT_t_cljs$core$async37917(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta37918){
return (new cljs.core.async.t_cljs$core$async37917(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta37918));
});

}

return (new cljs.core.async.t_cljs$core$async37917(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__37211__auto___39368 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37212__auto__ = (function (){var switch__37175__auto__ = (function (state_38021){
var state_val_38022 = (state_38021[(1)]);
if((state_val_38022 === (7))){
var inst_37936 = (state_38021[(2)]);
var state_38021__$1 = state_38021;
var statearr_38023_39369 = state_38021__$1;
(statearr_38023_39369[(2)] = inst_37936);

(statearr_38023_39369[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (20))){
var inst_37948 = (state_38021[(7)]);
var state_38021__$1 = state_38021;
var statearr_38024_39370 = state_38021__$1;
(statearr_38024_39370[(2)] = inst_37948);

(statearr_38024_39370[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (27))){
var state_38021__$1 = state_38021;
var statearr_38025_39371 = state_38021__$1;
(statearr_38025_39371[(2)] = null);

(statearr_38025_39371[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (1))){
var inst_37923 = (state_38021[(8)]);
var inst_37923__$1 = calc_state();
var inst_37925 = (inst_37923__$1 == null);
var inst_37926 = cljs.core.not(inst_37925);
var state_38021__$1 = (function (){var statearr_38026 = state_38021;
(statearr_38026[(8)] = inst_37923__$1);

return statearr_38026;
})();
if(inst_37926){
var statearr_38027_39372 = state_38021__$1;
(statearr_38027_39372[(1)] = (2));

} else {
var statearr_38028_39373 = state_38021__$1;
(statearr_38028_39373[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (24))){
var inst_37995 = (state_38021[(9)]);
var inst_37981 = (state_38021[(10)]);
var inst_37972 = (state_38021[(11)]);
var inst_37995__$1 = (inst_37972.cljs$core$IFn$_invoke$arity$1 ? inst_37972.cljs$core$IFn$_invoke$arity$1(inst_37981) : inst_37972.call(null,inst_37981));
var state_38021__$1 = (function (){var statearr_38029 = state_38021;
(statearr_38029[(9)] = inst_37995__$1);

return statearr_38029;
})();
if(cljs.core.truth_(inst_37995__$1)){
var statearr_38030_39374 = state_38021__$1;
(statearr_38030_39374[(1)] = (29));

} else {
var statearr_38031_39375 = state_38021__$1;
(statearr_38031_39375[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (4))){
var inst_37939 = (state_38021[(2)]);
var state_38021__$1 = state_38021;
if(cljs.core.truth_(inst_37939)){
var statearr_38032_39376 = state_38021__$1;
(statearr_38032_39376[(1)] = (8));

} else {
var statearr_38033_39377 = state_38021__$1;
(statearr_38033_39377[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (15))){
var inst_37966 = (state_38021[(2)]);
var state_38021__$1 = state_38021;
if(cljs.core.truth_(inst_37966)){
var statearr_38034_39378 = state_38021__$1;
(statearr_38034_39378[(1)] = (19));

} else {
var statearr_38035_39379 = state_38021__$1;
(statearr_38035_39379[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (21))){
var inst_37971 = (state_38021[(12)]);
var inst_37971__$1 = (state_38021[(2)]);
var inst_37972 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37971__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_37973 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37971__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_37974 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37971__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_38021__$1 = (function (){var statearr_38036 = state_38021;
(statearr_38036[(12)] = inst_37971__$1);

(statearr_38036[(13)] = inst_37973);

(statearr_38036[(11)] = inst_37972);

return statearr_38036;
})();
return cljs.core.async.ioc_alts_BANG_(state_38021__$1,(22),inst_37974);
} else {
if((state_val_38022 === (31))){
var inst_38003 = (state_38021[(2)]);
var state_38021__$1 = state_38021;
if(cljs.core.truth_(inst_38003)){
var statearr_38037_39380 = state_38021__$1;
(statearr_38037_39380[(1)] = (32));

} else {
var statearr_38038_39381 = state_38021__$1;
(statearr_38038_39381[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (32))){
var inst_37980 = (state_38021[(14)]);
var state_38021__$1 = state_38021;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38021__$1,(35),out,inst_37980);
} else {
if((state_val_38022 === (33))){
var inst_37971 = (state_38021[(12)]);
var inst_37948 = inst_37971;
var state_38021__$1 = (function (){var statearr_38039 = state_38021;
(statearr_38039[(7)] = inst_37948);

return statearr_38039;
})();
var statearr_38040_39382 = state_38021__$1;
(statearr_38040_39382[(2)] = null);

(statearr_38040_39382[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (13))){
var inst_37948 = (state_38021[(7)]);
var inst_37955 = inst_37948.cljs$lang$protocol_mask$partition0$;
var inst_37956 = (inst_37955 & (64));
var inst_37957 = inst_37948.cljs$core$ISeq$;
var inst_37958 = (cljs.core.PROTOCOL_SENTINEL === inst_37957);
var inst_37959 = ((inst_37956) || (inst_37958));
var state_38021__$1 = state_38021;
if(cljs.core.truth_(inst_37959)){
var statearr_38041_39383 = state_38021__$1;
(statearr_38041_39383[(1)] = (16));

} else {
var statearr_38042_39384 = state_38021__$1;
(statearr_38042_39384[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (22))){
var inst_37980 = (state_38021[(14)]);
var inst_37981 = (state_38021[(10)]);
var inst_37979 = (state_38021[(2)]);
var inst_37980__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37979,(0),null);
var inst_37981__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37979,(1),null);
var inst_37982 = (inst_37980__$1 == null);
var inst_37983 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_37981__$1,change);
var inst_37984 = ((inst_37982) || (inst_37983));
var state_38021__$1 = (function (){var statearr_38043 = state_38021;
(statearr_38043[(14)] = inst_37980__$1);

(statearr_38043[(10)] = inst_37981__$1);

return statearr_38043;
})();
if(cljs.core.truth_(inst_37984)){
var statearr_38044_39385 = state_38021__$1;
(statearr_38044_39385[(1)] = (23));

} else {
var statearr_38045_39386 = state_38021__$1;
(statearr_38045_39386[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (36))){
var inst_37971 = (state_38021[(12)]);
var inst_37948 = inst_37971;
var state_38021__$1 = (function (){var statearr_38046 = state_38021;
(statearr_38046[(7)] = inst_37948);

return statearr_38046;
})();
var statearr_38047_39387 = state_38021__$1;
(statearr_38047_39387[(2)] = null);

(statearr_38047_39387[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (29))){
var inst_37995 = (state_38021[(9)]);
var state_38021__$1 = state_38021;
var statearr_38048_39388 = state_38021__$1;
(statearr_38048_39388[(2)] = inst_37995);

(statearr_38048_39388[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (6))){
var state_38021__$1 = state_38021;
var statearr_38049_39389 = state_38021__$1;
(statearr_38049_39389[(2)] = false);

(statearr_38049_39389[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (28))){
var inst_37991 = (state_38021[(2)]);
var inst_37992 = calc_state();
var inst_37948 = inst_37992;
var state_38021__$1 = (function (){var statearr_38050 = state_38021;
(statearr_38050[(7)] = inst_37948);

(statearr_38050[(15)] = inst_37991);

return statearr_38050;
})();
var statearr_38051_39390 = state_38021__$1;
(statearr_38051_39390[(2)] = null);

(statearr_38051_39390[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (25))){
var inst_38017 = (state_38021[(2)]);
var state_38021__$1 = state_38021;
var statearr_38052_39391 = state_38021__$1;
(statearr_38052_39391[(2)] = inst_38017);

(statearr_38052_39391[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (34))){
var inst_38015 = (state_38021[(2)]);
var state_38021__$1 = state_38021;
var statearr_38053_39392 = state_38021__$1;
(statearr_38053_39392[(2)] = inst_38015);

(statearr_38053_39392[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (17))){
var state_38021__$1 = state_38021;
var statearr_38054_39393 = state_38021__$1;
(statearr_38054_39393[(2)] = false);

(statearr_38054_39393[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (3))){
var state_38021__$1 = state_38021;
var statearr_38055_39394 = state_38021__$1;
(statearr_38055_39394[(2)] = false);

(statearr_38055_39394[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (12))){
var inst_38019 = (state_38021[(2)]);
var state_38021__$1 = state_38021;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38021__$1,inst_38019);
} else {
if((state_val_38022 === (2))){
var inst_37923 = (state_38021[(8)]);
var inst_37928 = inst_37923.cljs$lang$protocol_mask$partition0$;
var inst_37929 = (inst_37928 & (64));
var inst_37930 = inst_37923.cljs$core$ISeq$;
var inst_37931 = (cljs.core.PROTOCOL_SENTINEL === inst_37930);
var inst_37932 = ((inst_37929) || (inst_37931));
var state_38021__$1 = state_38021;
if(cljs.core.truth_(inst_37932)){
var statearr_38056_39395 = state_38021__$1;
(statearr_38056_39395[(1)] = (5));

} else {
var statearr_38057_39396 = state_38021__$1;
(statearr_38057_39396[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (23))){
var inst_37980 = (state_38021[(14)]);
var inst_37986 = (inst_37980 == null);
var state_38021__$1 = state_38021;
if(cljs.core.truth_(inst_37986)){
var statearr_38058_39397 = state_38021__$1;
(statearr_38058_39397[(1)] = (26));

} else {
var statearr_38059_39398 = state_38021__$1;
(statearr_38059_39398[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (35))){
var inst_38006 = (state_38021[(2)]);
var state_38021__$1 = state_38021;
if(cljs.core.truth_(inst_38006)){
var statearr_38060_39399 = state_38021__$1;
(statearr_38060_39399[(1)] = (36));

} else {
var statearr_38061_39400 = state_38021__$1;
(statearr_38061_39400[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (19))){
var inst_37948 = (state_38021[(7)]);
var inst_37968 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37948);
var state_38021__$1 = state_38021;
var statearr_38062_39401 = state_38021__$1;
(statearr_38062_39401[(2)] = inst_37968);

(statearr_38062_39401[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (11))){
var inst_37948 = (state_38021[(7)]);
var inst_37952 = (inst_37948 == null);
var inst_37953 = cljs.core.not(inst_37952);
var state_38021__$1 = state_38021;
if(inst_37953){
var statearr_38063_39402 = state_38021__$1;
(statearr_38063_39402[(1)] = (13));

} else {
var statearr_38064_39479 = state_38021__$1;
(statearr_38064_39479[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (9))){
var inst_37923 = (state_38021[(8)]);
var state_38021__$1 = state_38021;
var statearr_38065_39480 = state_38021__$1;
(statearr_38065_39480[(2)] = inst_37923);

(statearr_38065_39480[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (5))){
var state_38021__$1 = state_38021;
var statearr_38066_39481 = state_38021__$1;
(statearr_38066_39481[(2)] = true);

(statearr_38066_39481[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (14))){
var state_38021__$1 = state_38021;
var statearr_38067_39482 = state_38021__$1;
(statearr_38067_39482[(2)] = false);

(statearr_38067_39482[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (26))){
var inst_37981 = (state_38021[(10)]);
var inst_37988 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_37981);
var state_38021__$1 = state_38021;
var statearr_38068_39483 = state_38021__$1;
(statearr_38068_39483[(2)] = inst_37988);

(statearr_38068_39483[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (16))){
var state_38021__$1 = state_38021;
var statearr_38069_39484 = state_38021__$1;
(statearr_38069_39484[(2)] = true);

(statearr_38069_39484[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (38))){
var inst_38011 = (state_38021[(2)]);
var state_38021__$1 = state_38021;
var statearr_38070_39485 = state_38021__$1;
(statearr_38070_39485[(2)] = inst_38011);

(statearr_38070_39485[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (30))){
var inst_37981 = (state_38021[(10)]);
var inst_37973 = (state_38021[(13)]);
var inst_37972 = (state_38021[(11)]);
var inst_37998 = cljs.core.empty_QMARK_(inst_37972);
var inst_37999 = (inst_37973.cljs$core$IFn$_invoke$arity$1 ? inst_37973.cljs$core$IFn$_invoke$arity$1(inst_37981) : inst_37973.call(null,inst_37981));
var inst_38000 = cljs.core.not(inst_37999);
var inst_38001 = ((inst_37998) && (inst_38000));
var state_38021__$1 = state_38021;
var statearr_38071_39486 = state_38021__$1;
(statearr_38071_39486[(2)] = inst_38001);

(statearr_38071_39486[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (10))){
var inst_37923 = (state_38021[(8)]);
var inst_37944 = (state_38021[(2)]);
var inst_37945 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37944,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_37946 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37944,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_37947 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37944,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_37948 = inst_37923;
var state_38021__$1 = (function (){var statearr_38072 = state_38021;
(statearr_38072[(16)] = inst_37947);

(statearr_38072[(17)] = inst_37945);

(statearr_38072[(7)] = inst_37948);

(statearr_38072[(18)] = inst_37946);

return statearr_38072;
})();
var statearr_38073_39487 = state_38021__$1;
(statearr_38073_39487[(2)] = null);

(statearr_38073_39487[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (18))){
var inst_37963 = (state_38021[(2)]);
var state_38021__$1 = state_38021;
var statearr_38074_39489 = state_38021__$1;
(statearr_38074_39489[(2)] = inst_37963);

(statearr_38074_39489[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (37))){
var state_38021__$1 = state_38021;
var statearr_38075_39490 = state_38021__$1;
(statearr_38075_39490[(2)] = null);

(statearr_38075_39490[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38022 === (8))){
var inst_37923 = (state_38021[(8)]);
var inst_37941 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37923);
var state_38021__$1 = state_38021;
var statearr_38076_39491 = state_38021__$1;
(statearr_38076_39491[(2)] = inst_37941);

(statearr_38076_39491[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__37176__auto__ = null;
var cljs$core$async$mix_$_state_machine__37176__auto____0 = (function (){
var statearr_38077 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38077[(0)] = cljs$core$async$mix_$_state_machine__37176__auto__);

(statearr_38077[(1)] = (1));

return statearr_38077;
});
var cljs$core$async$mix_$_state_machine__37176__auto____1 = (function (state_38021){
while(true){
var ret_value__37177__auto__ = (function (){try{while(true){
var result__37178__auto__ = switch__37175__auto__(state_38021);
if(cljs.core.keyword_identical_QMARK_(result__37178__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37178__auto__;
}
break;
}
}catch (e38078){var ex__37179__auto__ = e38078;
var statearr_38079_39492 = state_38021;
(statearr_38079_39492[(2)] = ex__37179__auto__);


if(cljs.core.seq((state_38021[(4)]))){
var statearr_38080_39493 = state_38021;
(statearr_38080_39493[(1)] = cljs.core.first((state_38021[(4)])));

} else {
throw ex__37179__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37177__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39494 = state_38021;
state_38021 = G__39494;
continue;
} else {
return ret_value__37177__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__37176__auto__ = function(state_38021){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__37176__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__37176__auto____1.call(this,state_38021);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__37176__auto____0;
cljs$core$async$mix_$_state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__37176__auto____1;
return cljs$core$async$mix_$_state_machine__37176__auto__;
})()
})();
var state__37213__auto__ = (function (){var statearr_38081 = f__37212__auto__();
(statearr_38081[(6)] = c__37211__auto___39368);

return statearr_38081;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37213__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_39495 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_39495(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_39496 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_39496(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_39497 = (function() {
var G__39498 = null;
var G__39498__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__39498__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__39498 = function(p,v){
switch(arguments.length){
case 1:
return G__39498__1.call(this,p);
case 2:
return G__39498__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__39498.cljs$core$IFn$_invoke$arity$1 = G__39498__1;
G__39498.cljs$core$IFn$_invoke$arity$2 = G__39498__2;
return G__39498;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__38083 = arguments.length;
switch (G__38083) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_39497(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_39497(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__38086 = arguments.length;
switch (G__38086) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__38084_SHARP_){
if(cljs.core.truth_((p1__38084_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__38084_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__38084_SHARP_.call(null,topic)))){
return p1__38084_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__38084_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async38087 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38087 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta38088){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta38088 = meta38088;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async38087.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38089,meta38088__$1){
var self__ = this;
var _38089__$1 = this;
return (new cljs.core.async.t_cljs$core$async38087(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta38088__$1));
}));

(cljs.core.async.t_cljs$core$async38087.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38089){
var self__ = this;
var _38089__$1 = this;
return self__.meta38088;
}));

(cljs.core.async.t_cljs$core$async38087.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38087.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async38087.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38087.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async38087.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async38087.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async38087.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async38087.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta38088","meta38088",57295016,null)], null);
}));

(cljs.core.async.t_cljs$core$async38087.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async38087.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38087");

(cljs.core.async.t_cljs$core$async38087.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async38087");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38087.
 */
cljs.core.async.__GT_t_cljs$core$async38087 = (function cljs$core$async$__GT_t_cljs$core$async38087(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta38088){
return (new cljs.core.async.t_cljs$core$async38087(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta38088));
});

}

return (new cljs.core.async.t_cljs$core$async38087(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__37211__auto___39578 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37212__auto__ = (function (){var switch__37175__auto__ = (function (state_38161){
var state_val_38162 = (state_38161[(1)]);
if((state_val_38162 === (7))){
var inst_38157 = (state_38161[(2)]);
var state_38161__$1 = state_38161;
var statearr_38163_39579 = state_38161__$1;
(statearr_38163_39579[(2)] = inst_38157);

(statearr_38163_39579[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38162 === (20))){
var state_38161__$1 = state_38161;
var statearr_38164_39580 = state_38161__$1;
(statearr_38164_39580[(2)] = null);

(statearr_38164_39580[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38162 === (1))){
var state_38161__$1 = state_38161;
var statearr_38165_39581 = state_38161__$1;
(statearr_38165_39581[(2)] = null);

(statearr_38165_39581[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38162 === (24))){
var inst_38140 = (state_38161[(7)]);
var inst_38149 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_38140);
var state_38161__$1 = state_38161;
var statearr_38166_39582 = state_38161__$1;
(statearr_38166_39582[(2)] = inst_38149);

(statearr_38166_39582[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38162 === (4))){
var inst_38092 = (state_38161[(8)]);
var inst_38092__$1 = (state_38161[(2)]);
var inst_38093 = (inst_38092__$1 == null);
var state_38161__$1 = (function (){var statearr_38167 = state_38161;
(statearr_38167[(8)] = inst_38092__$1);

return statearr_38167;
})();
if(cljs.core.truth_(inst_38093)){
var statearr_38168_39583 = state_38161__$1;
(statearr_38168_39583[(1)] = (5));

} else {
var statearr_38169_39584 = state_38161__$1;
(statearr_38169_39584[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38162 === (15))){
var inst_38134 = (state_38161[(2)]);
var state_38161__$1 = state_38161;
var statearr_38170_39585 = state_38161__$1;
(statearr_38170_39585[(2)] = inst_38134);

(statearr_38170_39585[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38162 === (21))){
var inst_38154 = (state_38161[(2)]);
var state_38161__$1 = (function (){var statearr_38171 = state_38161;
(statearr_38171[(9)] = inst_38154);

return statearr_38171;
})();
var statearr_38172_39586 = state_38161__$1;
(statearr_38172_39586[(2)] = null);

(statearr_38172_39586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38162 === (13))){
var inst_38116 = (state_38161[(10)]);
var inst_38118 = cljs.core.chunked_seq_QMARK_(inst_38116);
var state_38161__$1 = state_38161;
if(inst_38118){
var statearr_38173_39587 = state_38161__$1;
(statearr_38173_39587[(1)] = (16));

} else {
var statearr_38174_39588 = state_38161__$1;
(statearr_38174_39588[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38162 === (22))){
var inst_38146 = (state_38161[(2)]);
var state_38161__$1 = state_38161;
if(cljs.core.truth_(inst_38146)){
var statearr_38175_39589 = state_38161__$1;
(statearr_38175_39589[(1)] = (23));

} else {
var statearr_38176_39590 = state_38161__$1;
(statearr_38176_39590[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38162 === (6))){
var inst_38092 = (state_38161[(8)]);
var inst_38142 = (state_38161[(11)]);
var inst_38140 = (state_38161[(7)]);
var inst_38140__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_38092) : topic_fn.call(null,inst_38092));
var inst_38141 = cljs.core.deref(mults);
var inst_38142__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38141,inst_38140__$1);
var state_38161__$1 = (function (){var statearr_38177 = state_38161;
(statearr_38177[(11)] = inst_38142__$1);

(statearr_38177[(7)] = inst_38140__$1);

return statearr_38177;
})();
if(cljs.core.truth_(inst_38142__$1)){
var statearr_38178_39591 = state_38161__$1;
(statearr_38178_39591[(1)] = (19));

} else {
var statearr_38179_39592 = state_38161__$1;
(statearr_38179_39592[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38162 === (25))){
var inst_38151 = (state_38161[(2)]);
var state_38161__$1 = state_38161;
var statearr_38180_39593 = state_38161__$1;
(statearr_38180_39593[(2)] = inst_38151);

(statearr_38180_39593[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38162 === (17))){
var inst_38116 = (state_38161[(10)]);
var inst_38125 = cljs.core.first(inst_38116);
var inst_38126 = cljs.core.async.muxch_STAR_(inst_38125);
var inst_38127 = cljs.core.async.close_BANG_(inst_38126);
var inst_38128 = cljs.core.next(inst_38116);
var inst_38102 = inst_38128;
var inst_38103 = null;
var inst_38104 = (0);
var inst_38105 = (0);
var state_38161__$1 = (function (){var statearr_38181 = state_38161;
(statearr_38181[(12)] = inst_38127);

(statearr_38181[(13)] = inst_38102);

(statearr_38181[(14)] = inst_38104);

(statearr_38181[(15)] = inst_38103);

(statearr_38181[(16)] = inst_38105);

return statearr_38181;
})();
var statearr_38182_39594 = state_38161__$1;
(statearr_38182_39594[(2)] = null);

(statearr_38182_39594[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38162 === (3))){
var inst_38159 = (state_38161[(2)]);
var state_38161__$1 = state_38161;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38161__$1,inst_38159);
} else {
if((state_val_38162 === (12))){
var inst_38136 = (state_38161[(2)]);
var state_38161__$1 = state_38161;
var statearr_38183_39595 = state_38161__$1;
(statearr_38183_39595[(2)] = inst_38136);

(statearr_38183_39595[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38162 === (2))){
var state_38161__$1 = state_38161;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38161__$1,(4),ch);
} else {
if((state_val_38162 === (23))){
var state_38161__$1 = state_38161;
var statearr_38184_39596 = state_38161__$1;
(statearr_38184_39596[(2)] = null);

(statearr_38184_39596[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38162 === (19))){
var inst_38092 = (state_38161[(8)]);
var inst_38142 = (state_38161[(11)]);
var inst_38144 = cljs.core.async.muxch_STAR_(inst_38142);
var state_38161__$1 = state_38161;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38161__$1,(22),inst_38144,inst_38092);
} else {
if((state_val_38162 === (11))){
var inst_38102 = (state_38161[(13)]);
var inst_38116 = (state_38161[(10)]);
var inst_38116__$1 = cljs.core.seq(inst_38102);
var state_38161__$1 = (function (){var statearr_38185 = state_38161;
(statearr_38185[(10)] = inst_38116__$1);

return statearr_38185;
})();
if(inst_38116__$1){
var statearr_38186_39597 = state_38161__$1;
(statearr_38186_39597[(1)] = (13));

} else {
var statearr_38187_39598 = state_38161__$1;
(statearr_38187_39598[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38162 === (9))){
var inst_38138 = (state_38161[(2)]);
var state_38161__$1 = state_38161;
var statearr_38188_39599 = state_38161__$1;
(statearr_38188_39599[(2)] = inst_38138);

(statearr_38188_39599[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38162 === (5))){
var inst_38099 = cljs.core.deref(mults);
var inst_38100 = cljs.core.vals(inst_38099);
var inst_38101 = cljs.core.seq(inst_38100);
var inst_38102 = inst_38101;
var inst_38103 = null;
var inst_38104 = (0);
var inst_38105 = (0);
var state_38161__$1 = (function (){var statearr_38189 = state_38161;
(statearr_38189[(13)] = inst_38102);

(statearr_38189[(14)] = inst_38104);

(statearr_38189[(15)] = inst_38103);

(statearr_38189[(16)] = inst_38105);

return statearr_38189;
})();
var statearr_38190_39600 = state_38161__$1;
(statearr_38190_39600[(2)] = null);

(statearr_38190_39600[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38162 === (14))){
var state_38161__$1 = state_38161;
var statearr_38194_39601 = state_38161__$1;
(statearr_38194_39601[(2)] = null);

(statearr_38194_39601[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38162 === (16))){
var inst_38116 = (state_38161[(10)]);
var inst_38120 = cljs.core.chunk_first(inst_38116);
var inst_38121 = cljs.core.chunk_rest(inst_38116);
var inst_38122 = cljs.core.count(inst_38120);
var inst_38102 = inst_38121;
var inst_38103 = inst_38120;
var inst_38104 = inst_38122;
var inst_38105 = (0);
var state_38161__$1 = (function (){var statearr_38195 = state_38161;
(statearr_38195[(13)] = inst_38102);

(statearr_38195[(14)] = inst_38104);

(statearr_38195[(15)] = inst_38103);

(statearr_38195[(16)] = inst_38105);

return statearr_38195;
})();
var statearr_38196_39602 = state_38161__$1;
(statearr_38196_39602[(2)] = null);

(statearr_38196_39602[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38162 === (10))){
var inst_38102 = (state_38161[(13)]);
var inst_38104 = (state_38161[(14)]);
var inst_38103 = (state_38161[(15)]);
var inst_38105 = (state_38161[(16)]);
var inst_38110 = cljs.core._nth(inst_38103,inst_38105);
var inst_38111 = cljs.core.async.muxch_STAR_(inst_38110);
var inst_38112 = cljs.core.async.close_BANG_(inst_38111);
var inst_38113 = (inst_38105 + (1));
var tmp38191 = inst_38102;
var tmp38192 = inst_38104;
var tmp38193 = inst_38103;
var inst_38102__$1 = tmp38191;
var inst_38103__$1 = tmp38193;
var inst_38104__$1 = tmp38192;
var inst_38105__$1 = inst_38113;
var state_38161__$1 = (function (){var statearr_38197 = state_38161;
(statearr_38197[(13)] = inst_38102__$1);

(statearr_38197[(17)] = inst_38112);

(statearr_38197[(14)] = inst_38104__$1);

(statearr_38197[(15)] = inst_38103__$1);

(statearr_38197[(16)] = inst_38105__$1);

return statearr_38197;
})();
var statearr_38198_39603 = state_38161__$1;
(statearr_38198_39603[(2)] = null);

(statearr_38198_39603[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38162 === (18))){
var inst_38131 = (state_38161[(2)]);
var state_38161__$1 = state_38161;
var statearr_38199_39604 = state_38161__$1;
(statearr_38199_39604[(2)] = inst_38131);

(statearr_38199_39604[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38162 === (8))){
var inst_38104 = (state_38161[(14)]);
var inst_38105 = (state_38161[(16)]);
var inst_38107 = (inst_38105 < inst_38104);
var inst_38108 = inst_38107;
var state_38161__$1 = state_38161;
if(cljs.core.truth_(inst_38108)){
var statearr_38200_39605 = state_38161__$1;
(statearr_38200_39605[(1)] = (10));

} else {
var statearr_38201_39606 = state_38161__$1;
(statearr_38201_39606[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__37176__auto__ = null;
var cljs$core$async$state_machine__37176__auto____0 = (function (){
var statearr_38202 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38202[(0)] = cljs$core$async$state_machine__37176__auto__);

(statearr_38202[(1)] = (1));

return statearr_38202;
});
var cljs$core$async$state_machine__37176__auto____1 = (function (state_38161){
while(true){
var ret_value__37177__auto__ = (function (){try{while(true){
var result__37178__auto__ = switch__37175__auto__(state_38161);
if(cljs.core.keyword_identical_QMARK_(result__37178__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37178__auto__;
}
break;
}
}catch (e38203){var ex__37179__auto__ = e38203;
var statearr_38204_39607 = state_38161;
(statearr_38204_39607[(2)] = ex__37179__auto__);


if(cljs.core.seq((state_38161[(4)]))){
var statearr_38205_39608 = state_38161;
(statearr_38205_39608[(1)] = cljs.core.first((state_38161[(4)])));

} else {
throw ex__37179__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37177__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39609 = state_38161;
state_38161 = G__39609;
continue;
} else {
return ret_value__37177__auto__;
}
break;
}
});
cljs$core$async$state_machine__37176__auto__ = function(state_38161){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37176__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37176__auto____1.call(this,state_38161);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37176__auto____0;
cljs$core$async$state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37176__auto____1;
return cljs$core$async$state_machine__37176__auto__;
})()
})();
var state__37213__auto__ = (function (){var statearr_38206 = f__37212__auto__();
(statearr_38206[(6)] = c__37211__auto___39578);

return statearr_38206;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37213__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__38208 = arguments.length;
switch (G__38208) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__38210 = arguments.length;
switch (G__38210) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__38212 = arguments.length;
switch (G__38212) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__37211__auto___39613 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37212__auto__ = (function (){var switch__37175__auto__ = (function (state_38255){
var state_val_38256 = (state_38255[(1)]);
if((state_val_38256 === (7))){
var state_38255__$1 = state_38255;
var statearr_38257_39614 = state_38255__$1;
(statearr_38257_39614[(2)] = null);

(statearr_38257_39614[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38256 === (1))){
var state_38255__$1 = state_38255;
var statearr_38258_39620 = state_38255__$1;
(statearr_38258_39620[(2)] = null);

(statearr_38258_39620[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38256 === (4))){
var inst_38216 = (state_38255[(7)]);
var inst_38215 = (state_38255[(8)]);
var inst_38218 = (inst_38216 < inst_38215);
var state_38255__$1 = state_38255;
if(cljs.core.truth_(inst_38218)){
var statearr_38259_39621 = state_38255__$1;
(statearr_38259_39621[(1)] = (6));

} else {
var statearr_38260_39622 = state_38255__$1;
(statearr_38260_39622[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38256 === (15))){
var inst_38241 = (state_38255[(9)]);
var inst_38246 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_38241);
var state_38255__$1 = state_38255;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38255__$1,(17),out,inst_38246);
} else {
if((state_val_38256 === (13))){
var inst_38241 = (state_38255[(9)]);
var inst_38241__$1 = (state_38255[(2)]);
var inst_38242 = cljs.core.some(cljs.core.nil_QMARK_,inst_38241__$1);
var state_38255__$1 = (function (){var statearr_38261 = state_38255;
(statearr_38261[(9)] = inst_38241__$1);

return statearr_38261;
})();
if(cljs.core.truth_(inst_38242)){
var statearr_38262_39623 = state_38255__$1;
(statearr_38262_39623[(1)] = (14));

} else {
var statearr_38263_39624 = state_38255__$1;
(statearr_38263_39624[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38256 === (6))){
var state_38255__$1 = state_38255;
var statearr_38264_39625 = state_38255__$1;
(statearr_38264_39625[(2)] = null);

(statearr_38264_39625[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38256 === (17))){
var inst_38248 = (state_38255[(2)]);
var state_38255__$1 = (function (){var statearr_38266 = state_38255;
(statearr_38266[(10)] = inst_38248);

return statearr_38266;
})();
var statearr_38267_39626 = state_38255__$1;
(statearr_38267_39626[(2)] = null);

(statearr_38267_39626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38256 === (3))){
var inst_38253 = (state_38255[(2)]);
var state_38255__$1 = state_38255;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38255__$1,inst_38253);
} else {
if((state_val_38256 === (12))){
var _ = (function (){var statearr_38268 = state_38255;
(statearr_38268[(4)] = cljs.core.rest((state_38255[(4)])));

return statearr_38268;
})();
var state_38255__$1 = state_38255;
var ex38265 = (state_38255__$1[(2)]);
var statearr_38269_39627 = state_38255__$1;
(statearr_38269_39627[(5)] = ex38265);


if((ex38265 instanceof Object)){
var statearr_38270_39628 = state_38255__$1;
(statearr_38270_39628[(1)] = (11));

(statearr_38270_39628[(5)] = null);

} else {
throw ex38265;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38256 === (2))){
var inst_38214 = cljs.core.reset_BANG_(dctr,cnt);
var inst_38215 = cnt;
var inst_38216 = (0);
var state_38255__$1 = (function (){var statearr_38271 = state_38255;
(statearr_38271[(7)] = inst_38216);

(statearr_38271[(8)] = inst_38215);

(statearr_38271[(11)] = inst_38214);

return statearr_38271;
})();
var statearr_38272_39629 = state_38255__$1;
(statearr_38272_39629[(2)] = null);

(statearr_38272_39629[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38256 === (11))){
var inst_38220 = (state_38255[(2)]);
var inst_38221 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_38255__$1 = (function (){var statearr_38273 = state_38255;
(statearr_38273[(12)] = inst_38220);

return statearr_38273;
})();
var statearr_38274_39630 = state_38255__$1;
(statearr_38274_39630[(2)] = inst_38221);

(statearr_38274_39630[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38256 === (9))){
var inst_38216 = (state_38255[(7)]);
var _ = (function (){var statearr_38275 = state_38255;
(statearr_38275[(4)] = cljs.core.cons((12),(state_38255[(4)])));

return statearr_38275;
})();
var inst_38227 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_38216) : chs__$1.call(null,inst_38216));
var inst_38228 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_38216) : done.call(null,inst_38216));
var inst_38229 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_38227,inst_38228);
var ___$1 = (function (){var statearr_38276 = state_38255;
(statearr_38276[(4)] = cljs.core.rest((state_38255[(4)])));

return statearr_38276;
})();
var state_38255__$1 = state_38255;
var statearr_38277_39631 = state_38255__$1;
(statearr_38277_39631[(2)] = inst_38229);

(statearr_38277_39631[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38256 === (5))){
var inst_38239 = (state_38255[(2)]);
var state_38255__$1 = (function (){var statearr_38278 = state_38255;
(statearr_38278[(13)] = inst_38239);

return statearr_38278;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38255__$1,(13),dchan);
} else {
if((state_val_38256 === (14))){
var inst_38244 = cljs.core.async.close_BANG_(out);
var state_38255__$1 = state_38255;
var statearr_38279_39632 = state_38255__$1;
(statearr_38279_39632[(2)] = inst_38244);

(statearr_38279_39632[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38256 === (16))){
var inst_38251 = (state_38255[(2)]);
var state_38255__$1 = state_38255;
var statearr_38280_39633 = state_38255__$1;
(statearr_38280_39633[(2)] = inst_38251);

(statearr_38280_39633[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38256 === (10))){
var inst_38216 = (state_38255[(7)]);
var inst_38232 = (state_38255[(2)]);
var inst_38233 = (inst_38216 + (1));
var inst_38216__$1 = inst_38233;
var state_38255__$1 = (function (){var statearr_38281 = state_38255;
(statearr_38281[(7)] = inst_38216__$1);

(statearr_38281[(14)] = inst_38232);

return statearr_38281;
})();
var statearr_38282_39634 = state_38255__$1;
(statearr_38282_39634[(2)] = null);

(statearr_38282_39634[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38256 === (8))){
var inst_38237 = (state_38255[(2)]);
var state_38255__$1 = state_38255;
var statearr_38283_39635 = state_38255__$1;
(statearr_38283_39635[(2)] = inst_38237);

(statearr_38283_39635[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__37176__auto__ = null;
var cljs$core$async$state_machine__37176__auto____0 = (function (){
var statearr_38284 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38284[(0)] = cljs$core$async$state_machine__37176__auto__);

(statearr_38284[(1)] = (1));

return statearr_38284;
});
var cljs$core$async$state_machine__37176__auto____1 = (function (state_38255){
while(true){
var ret_value__37177__auto__ = (function (){try{while(true){
var result__37178__auto__ = switch__37175__auto__(state_38255);
if(cljs.core.keyword_identical_QMARK_(result__37178__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37178__auto__;
}
break;
}
}catch (e38285){var ex__37179__auto__ = e38285;
var statearr_38286_39637 = state_38255;
(statearr_38286_39637[(2)] = ex__37179__auto__);


if(cljs.core.seq((state_38255[(4)]))){
var statearr_38287_39638 = state_38255;
(statearr_38287_39638[(1)] = cljs.core.first((state_38255[(4)])));

} else {
throw ex__37179__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37177__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39639 = state_38255;
state_38255 = G__39639;
continue;
} else {
return ret_value__37177__auto__;
}
break;
}
});
cljs$core$async$state_machine__37176__auto__ = function(state_38255){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37176__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37176__auto____1.call(this,state_38255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37176__auto____0;
cljs$core$async$state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37176__auto____1;
return cljs$core$async$state_machine__37176__auto__;
})()
})();
var state__37213__auto__ = (function (){var statearr_38288 = f__37212__auto__();
(statearr_38288[(6)] = c__37211__auto___39613);

return statearr_38288;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37213__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__38291 = arguments.length;
switch (G__38291) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__37211__auto___39641 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37212__auto__ = (function (){var switch__37175__auto__ = (function (state_38323){
var state_val_38324 = (state_38323[(1)]);
if((state_val_38324 === (7))){
var inst_38302 = (state_38323[(7)]);
var inst_38303 = (state_38323[(8)]);
var inst_38302__$1 = (state_38323[(2)]);
var inst_38303__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38302__$1,(0),null);
var inst_38304 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38302__$1,(1),null);
var inst_38305 = (inst_38303__$1 == null);
var state_38323__$1 = (function (){var statearr_38325 = state_38323;
(statearr_38325[(9)] = inst_38304);

(statearr_38325[(7)] = inst_38302__$1);

(statearr_38325[(8)] = inst_38303__$1);

return statearr_38325;
})();
if(cljs.core.truth_(inst_38305)){
var statearr_38326_39642 = state_38323__$1;
(statearr_38326_39642[(1)] = (8));

} else {
var statearr_38327_39643 = state_38323__$1;
(statearr_38327_39643[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38324 === (1))){
var inst_38292 = cljs.core.vec(chs);
var inst_38293 = inst_38292;
var state_38323__$1 = (function (){var statearr_38328 = state_38323;
(statearr_38328[(10)] = inst_38293);

return statearr_38328;
})();
var statearr_38329_39644 = state_38323__$1;
(statearr_38329_39644[(2)] = null);

(statearr_38329_39644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38324 === (4))){
var inst_38293 = (state_38323[(10)]);
var state_38323__$1 = state_38323;
return cljs.core.async.ioc_alts_BANG_(state_38323__$1,(7),inst_38293);
} else {
if((state_val_38324 === (6))){
var inst_38319 = (state_38323[(2)]);
var state_38323__$1 = state_38323;
var statearr_38330_39645 = state_38323__$1;
(statearr_38330_39645[(2)] = inst_38319);

(statearr_38330_39645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38324 === (3))){
var inst_38321 = (state_38323[(2)]);
var state_38323__$1 = state_38323;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38323__$1,inst_38321);
} else {
if((state_val_38324 === (2))){
var inst_38293 = (state_38323[(10)]);
var inst_38295 = cljs.core.count(inst_38293);
var inst_38296 = (inst_38295 > (0));
var state_38323__$1 = state_38323;
if(cljs.core.truth_(inst_38296)){
var statearr_38332_39646 = state_38323__$1;
(statearr_38332_39646[(1)] = (4));

} else {
var statearr_38333_39647 = state_38323__$1;
(statearr_38333_39647[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38324 === (11))){
var inst_38293 = (state_38323[(10)]);
var inst_38312 = (state_38323[(2)]);
var tmp38331 = inst_38293;
var inst_38293__$1 = tmp38331;
var state_38323__$1 = (function (){var statearr_38334 = state_38323;
(statearr_38334[(10)] = inst_38293__$1);

(statearr_38334[(11)] = inst_38312);

return statearr_38334;
})();
var statearr_38335_39648 = state_38323__$1;
(statearr_38335_39648[(2)] = null);

(statearr_38335_39648[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38324 === (9))){
var inst_38303 = (state_38323[(8)]);
var state_38323__$1 = state_38323;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38323__$1,(11),out,inst_38303);
} else {
if((state_val_38324 === (5))){
var inst_38317 = cljs.core.async.close_BANG_(out);
var state_38323__$1 = state_38323;
var statearr_38336_39649 = state_38323__$1;
(statearr_38336_39649[(2)] = inst_38317);

(statearr_38336_39649[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38324 === (10))){
var inst_38315 = (state_38323[(2)]);
var state_38323__$1 = state_38323;
var statearr_38337_39650 = state_38323__$1;
(statearr_38337_39650[(2)] = inst_38315);

(statearr_38337_39650[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38324 === (8))){
var inst_38304 = (state_38323[(9)]);
var inst_38302 = (state_38323[(7)]);
var inst_38303 = (state_38323[(8)]);
var inst_38293 = (state_38323[(10)]);
var inst_38307 = (function (){var cs = inst_38293;
var vec__38298 = inst_38302;
var v = inst_38303;
var c = inst_38304;
return (function (p1__38289_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__38289_SHARP_);
});
})();
var inst_38308 = cljs.core.filterv(inst_38307,inst_38293);
var inst_38293__$1 = inst_38308;
var state_38323__$1 = (function (){var statearr_38338 = state_38323;
(statearr_38338[(10)] = inst_38293__$1);

return statearr_38338;
})();
var statearr_38339_39651 = state_38323__$1;
(statearr_38339_39651[(2)] = null);

(statearr_38339_39651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__37176__auto__ = null;
var cljs$core$async$state_machine__37176__auto____0 = (function (){
var statearr_38340 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38340[(0)] = cljs$core$async$state_machine__37176__auto__);

(statearr_38340[(1)] = (1));

return statearr_38340;
});
var cljs$core$async$state_machine__37176__auto____1 = (function (state_38323){
while(true){
var ret_value__37177__auto__ = (function (){try{while(true){
var result__37178__auto__ = switch__37175__auto__(state_38323);
if(cljs.core.keyword_identical_QMARK_(result__37178__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37178__auto__;
}
break;
}
}catch (e38341){var ex__37179__auto__ = e38341;
var statearr_38342_39696 = state_38323;
(statearr_38342_39696[(2)] = ex__37179__auto__);


if(cljs.core.seq((state_38323[(4)]))){
var statearr_38343_39697 = state_38323;
(statearr_38343_39697[(1)] = cljs.core.first((state_38323[(4)])));

} else {
throw ex__37179__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37177__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39698 = state_38323;
state_38323 = G__39698;
continue;
} else {
return ret_value__37177__auto__;
}
break;
}
});
cljs$core$async$state_machine__37176__auto__ = function(state_38323){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37176__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37176__auto____1.call(this,state_38323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37176__auto____0;
cljs$core$async$state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37176__auto____1;
return cljs$core$async$state_machine__37176__auto__;
})()
})();
var state__37213__auto__ = (function (){var statearr_38344 = f__37212__auto__();
(statearr_38344[(6)] = c__37211__auto___39641);

return statearr_38344;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37213__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__38346 = arguments.length;
switch (G__38346) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__37211__auto___39700 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37212__auto__ = (function (){var switch__37175__auto__ = (function (state_38370){
var state_val_38371 = (state_38370[(1)]);
if((state_val_38371 === (7))){
var inst_38352 = (state_38370[(7)]);
var inst_38352__$1 = (state_38370[(2)]);
var inst_38353 = (inst_38352__$1 == null);
var inst_38354 = cljs.core.not(inst_38353);
var state_38370__$1 = (function (){var statearr_38372 = state_38370;
(statearr_38372[(7)] = inst_38352__$1);

return statearr_38372;
})();
if(inst_38354){
var statearr_38373_39701 = state_38370__$1;
(statearr_38373_39701[(1)] = (8));

} else {
var statearr_38374_39702 = state_38370__$1;
(statearr_38374_39702[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38371 === (1))){
var inst_38347 = (0);
var state_38370__$1 = (function (){var statearr_38375 = state_38370;
(statearr_38375[(8)] = inst_38347);

return statearr_38375;
})();
var statearr_38376_39703 = state_38370__$1;
(statearr_38376_39703[(2)] = null);

(statearr_38376_39703[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38371 === (4))){
var state_38370__$1 = state_38370;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38370__$1,(7),ch);
} else {
if((state_val_38371 === (6))){
var inst_38365 = (state_38370[(2)]);
var state_38370__$1 = state_38370;
var statearr_38377_39704 = state_38370__$1;
(statearr_38377_39704[(2)] = inst_38365);

(statearr_38377_39704[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38371 === (3))){
var inst_38367 = (state_38370[(2)]);
var inst_38368 = cljs.core.async.close_BANG_(out);
var state_38370__$1 = (function (){var statearr_38378 = state_38370;
(statearr_38378[(9)] = inst_38367);

return statearr_38378;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38370__$1,inst_38368);
} else {
if((state_val_38371 === (2))){
var inst_38347 = (state_38370[(8)]);
var inst_38349 = (inst_38347 < n);
var state_38370__$1 = state_38370;
if(cljs.core.truth_(inst_38349)){
var statearr_38379_39705 = state_38370__$1;
(statearr_38379_39705[(1)] = (4));

} else {
var statearr_38380_39706 = state_38370__$1;
(statearr_38380_39706[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38371 === (11))){
var inst_38347 = (state_38370[(8)]);
var inst_38357 = (state_38370[(2)]);
var inst_38358 = (inst_38347 + (1));
var inst_38347__$1 = inst_38358;
var state_38370__$1 = (function (){var statearr_38381 = state_38370;
(statearr_38381[(8)] = inst_38347__$1);

(statearr_38381[(10)] = inst_38357);

return statearr_38381;
})();
var statearr_38382_39707 = state_38370__$1;
(statearr_38382_39707[(2)] = null);

(statearr_38382_39707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38371 === (9))){
var state_38370__$1 = state_38370;
var statearr_38383_39708 = state_38370__$1;
(statearr_38383_39708[(2)] = null);

(statearr_38383_39708[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38371 === (5))){
var state_38370__$1 = state_38370;
var statearr_38384_39709 = state_38370__$1;
(statearr_38384_39709[(2)] = null);

(statearr_38384_39709[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38371 === (10))){
var inst_38362 = (state_38370[(2)]);
var state_38370__$1 = state_38370;
var statearr_38385_39710 = state_38370__$1;
(statearr_38385_39710[(2)] = inst_38362);

(statearr_38385_39710[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38371 === (8))){
var inst_38352 = (state_38370[(7)]);
var state_38370__$1 = state_38370;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38370__$1,(11),out,inst_38352);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__37176__auto__ = null;
var cljs$core$async$state_machine__37176__auto____0 = (function (){
var statearr_38386 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38386[(0)] = cljs$core$async$state_machine__37176__auto__);

(statearr_38386[(1)] = (1));

return statearr_38386;
});
var cljs$core$async$state_machine__37176__auto____1 = (function (state_38370){
while(true){
var ret_value__37177__auto__ = (function (){try{while(true){
var result__37178__auto__ = switch__37175__auto__(state_38370);
if(cljs.core.keyword_identical_QMARK_(result__37178__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37178__auto__;
}
break;
}
}catch (e38387){var ex__37179__auto__ = e38387;
var statearr_38388_39711 = state_38370;
(statearr_38388_39711[(2)] = ex__37179__auto__);


if(cljs.core.seq((state_38370[(4)]))){
var statearr_38389_39712 = state_38370;
(statearr_38389_39712[(1)] = cljs.core.first((state_38370[(4)])));

} else {
throw ex__37179__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37177__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39713 = state_38370;
state_38370 = G__39713;
continue;
} else {
return ret_value__37177__auto__;
}
break;
}
});
cljs$core$async$state_machine__37176__auto__ = function(state_38370){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37176__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37176__auto____1.call(this,state_38370);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37176__auto____0;
cljs$core$async$state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37176__auto____1;
return cljs$core$async$state_machine__37176__auto__;
})()
})();
var state__37213__auto__ = (function (){var statearr_38390 = f__37212__auto__();
(statearr_38390[(6)] = c__37211__auto___39700);

return statearr_38390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37213__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async38392 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38392 = (function (f,ch,meta38393){
this.f = f;
this.ch = ch;
this.meta38393 = meta38393;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async38392.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38394,meta38393__$1){
var self__ = this;
var _38394__$1 = this;
return (new cljs.core.async.t_cljs$core$async38392(self__.f,self__.ch,meta38393__$1));
}));

(cljs.core.async.t_cljs$core$async38392.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38394){
var self__ = this;
var _38394__$1 = this;
return self__.meta38393;
}));

(cljs.core.async.t_cljs$core$async38392.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38392.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async38392.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async38392.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38392.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async38395 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38395 = (function (f,ch,meta38393,_,fn1,meta38396){
this.f = f;
this.ch = ch;
this.meta38393 = meta38393;
this._ = _;
this.fn1 = fn1;
this.meta38396 = meta38396;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async38395.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38397,meta38396__$1){
var self__ = this;
var _38397__$1 = this;
return (new cljs.core.async.t_cljs$core$async38395(self__.f,self__.ch,self__.meta38393,self__._,self__.fn1,meta38396__$1));
}));

(cljs.core.async.t_cljs$core$async38395.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38397){
var self__ = this;
var _38397__$1 = this;
return self__.meta38396;
}));

(cljs.core.async.t_cljs$core$async38395.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38395.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async38395.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async38395.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__38391_SHARP_){
var G__38398 = (((p1__38391_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__38391_SHARP_) : self__.f.call(null,p1__38391_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__38398) : f1.call(null,G__38398));
});
}));

(cljs.core.async.t_cljs$core$async38395.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38393","meta38393",-244893351,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async38392","cljs.core.async/t_cljs$core$async38392",-1493916982,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta38396","meta38396",1669603398,null)], null);
}));

(cljs.core.async.t_cljs$core$async38395.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async38395.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38395");

(cljs.core.async.t_cljs$core$async38395.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async38395");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38395.
 */
cljs.core.async.__GT_t_cljs$core$async38395 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async38395(f__$1,ch__$1,meta38393__$1,___$2,fn1__$1,meta38396){
return (new cljs.core.async.t_cljs$core$async38395(f__$1,ch__$1,meta38393__$1,___$2,fn1__$1,meta38396));
});

}

return (new cljs.core.async.t_cljs$core$async38395(self__.f,self__.ch,self__.meta38393,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__38399 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__38399) : self__.f.call(null,G__38399));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async38392.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38392.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async38392.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38393","meta38393",-244893351,null)], null);
}));

(cljs.core.async.t_cljs$core$async38392.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async38392.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38392");

(cljs.core.async.t_cljs$core$async38392.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async38392");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38392.
 */
cljs.core.async.__GT_t_cljs$core$async38392 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async38392(f__$1,ch__$1,meta38393){
return (new cljs.core.async.t_cljs$core$async38392(f__$1,ch__$1,meta38393));
});

}

return (new cljs.core.async.t_cljs$core$async38392(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async38400 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38400 = (function (f,ch,meta38401){
this.f = f;
this.ch = ch;
this.meta38401 = meta38401;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async38400.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38402,meta38401__$1){
var self__ = this;
var _38402__$1 = this;
return (new cljs.core.async.t_cljs$core$async38400(self__.f,self__.ch,meta38401__$1));
}));

(cljs.core.async.t_cljs$core$async38400.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38402){
var self__ = this;
var _38402__$1 = this;
return self__.meta38401;
}));

(cljs.core.async.t_cljs$core$async38400.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38400.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async38400.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38400.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async38400.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38400.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async38400.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38401","meta38401",1513711174,null)], null);
}));

(cljs.core.async.t_cljs$core$async38400.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async38400.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38400");

(cljs.core.async.t_cljs$core$async38400.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async38400");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38400.
 */
cljs.core.async.__GT_t_cljs$core$async38400 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async38400(f__$1,ch__$1,meta38401){
return (new cljs.core.async.t_cljs$core$async38400(f__$1,ch__$1,meta38401));
});

}

return (new cljs.core.async.t_cljs$core$async38400(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async38403 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38403 = (function (p,ch,meta38404){
this.p = p;
this.ch = ch;
this.meta38404 = meta38404;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async38403.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38405,meta38404__$1){
var self__ = this;
var _38405__$1 = this;
return (new cljs.core.async.t_cljs$core$async38403(self__.p,self__.ch,meta38404__$1));
}));

(cljs.core.async.t_cljs$core$async38403.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38405){
var self__ = this;
var _38405__$1 = this;
return self__.meta38404;
}));

(cljs.core.async.t_cljs$core$async38403.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38403.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async38403.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async38403.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38403.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async38403.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38403.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async38403.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38404","meta38404",-1008063548,null)], null);
}));

(cljs.core.async.t_cljs$core$async38403.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async38403.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38403");

(cljs.core.async.t_cljs$core$async38403.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async38403");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38403.
 */
cljs.core.async.__GT_t_cljs$core$async38403 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async38403(p__$1,ch__$1,meta38404){
return (new cljs.core.async.t_cljs$core$async38403(p__$1,ch__$1,meta38404));
});

}

return (new cljs.core.async.t_cljs$core$async38403(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__38407 = arguments.length;
switch (G__38407) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__37211__auto___39792 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37212__auto__ = (function (){var switch__37175__auto__ = (function (state_38428){
var state_val_38429 = (state_38428[(1)]);
if((state_val_38429 === (7))){
var inst_38424 = (state_38428[(2)]);
var state_38428__$1 = state_38428;
var statearr_38430_39793 = state_38428__$1;
(statearr_38430_39793[(2)] = inst_38424);

(statearr_38430_39793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38429 === (1))){
var state_38428__$1 = state_38428;
var statearr_38431_39794 = state_38428__$1;
(statearr_38431_39794[(2)] = null);

(statearr_38431_39794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38429 === (4))){
var inst_38410 = (state_38428[(7)]);
var inst_38410__$1 = (state_38428[(2)]);
var inst_38411 = (inst_38410__$1 == null);
var state_38428__$1 = (function (){var statearr_38432 = state_38428;
(statearr_38432[(7)] = inst_38410__$1);

return statearr_38432;
})();
if(cljs.core.truth_(inst_38411)){
var statearr_38433_39795 = state_38428__$1;
(statearr_38433_39795[(1)] = (5));

} else {
var statearr_38434_39796 = state_38428__$1;
(statearr_38434_39796[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38429 === (6))){
var inst_38410 = (state_38428[(7)]);
var inst_38415 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_38410) : p.call(null,inst_38410));
var state_38428__$1 = state_38428;
if(cljs.core.truth_(inst_38415)){
var statearr_38435_39797 = state_38428__$1;
(statearr_38435_39797[(1)] = (8));

} else {
var statearr_38436_39798 = state_38428__$1;
(statearr_38436_39798[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38429 === (3))){
var inst_38426 = (state_38428[(2)]);
var state_38428__$1 = state_38428;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38428__$1,inst_38426);
} else {
if((state_val_38429 === (2))){
var state_38428__$1 = state_38428;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38428__$1,(4),ch);
} else {
if((state_val_38429 === (11))){
var inst_38418 = (state_38428[(2)]);
var state_38428__$1 = state_38428;
var statearr_38437_39799 = state_38428__$1;
(statearr_38437_39799[(2)] = inst_38418);

(statearr_38437_39799[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38429 === (9))){
var state_38428__$1 = state_38428;
var statearr_38438_39800 = state_38428__$1;
(statearr_38438_39800[(2)] = null);

(statearr_38438_39800[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38429 === (5))){
var inst_38413 = cljs.core.async.close_BANG_(out);
var state_38428__$1 = state_38428;
var statearr_38439_39801 = state_38428__$1;
(statearr_38439_39801[(2)] = inst_38413);

(statearr_38439_39801[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38429 === (10))){
var inst_38421 = (state_38428[(2)]);
var state_38428__$1 = (function (){var statearr_38440 = state_38428;
(statearr_38440[(8)] = inst_38421);

return statearr_38440;
})();
var statearr_38441_39802 = state_38428__$1;
(statearr_38441_39802[(2)] = null);

(statearr_38441_39802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38429 === (8))){
var inst_38410 = (state_38428[(7)]);
var state_38428__$1 = state_38428;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38428__$1,(11),out,inst_38410);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__37176__auto__ = null;
var cljs$core$async$state_machine__37176__auto____0 = (function (){
var statearr_38442 = [null,null,null,null,null,null,null,null,null];
(statearr_38442[(0)] = cljs$core$async$state_machine__37176__auto__);

(statearr_38442[(1)] = (1));

return statearr_38442;
});
var cljs$core$async$state_machine__37176__auto____1 = (function (state_38428){
while(true){
var ret_value__37177__auto__ = (function (){try{while(true){
var result__37178__auto__ = switch__37175__auto__(state_38428);
if(cljs.core.keyword_identical_QMARK_(result__37178__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37178__auto__;
}
break;
}
}catch (e38443){var ex__37179__auto__ = e38443;
var statearr_38444_39803 = state_38428;
(statearr_38444_39803[(2)] = ex__37179__auto__);


if(cljs.core.seq((state_38428[(4)]))){
var statearr_38445_39804 = state_38428;
(statearr_38445_39804[(1)] = cljs.core.first((state_38428[(4)])));

} else {
throw ex__37179__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37177__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39805 = state_38428;
state_38428 = G__39805;
continue;
} else {
return ret_value__37177__auto__;
}
break;
}
});
cljs$core$async$state_machine__37176__auto__ = function(state_38428){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37176__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37176__auto____1.call(this,state_38428);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37176__auto____0;
cljs$core$async$state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37176__auto____1;
return cljs$core$async$state_machine__37176__auto__;
})()
})();
var state__37213__auto__ = (function (){var statearr_38446 = f__37212__auto__();
(statearr_38446[(6)] = c__37211__auto___39792);

return statearr_38446;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37213__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__38448 = arguments.length;
switch (G__38448) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__37211__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37212__auto__ = (function (){var switch__37175__auto__ = (function (state_38510){
var state_val_38511 = (state_38510[(1)]);
if((state_val_38511 === (7))){
var inst_38506 = (state_38510[(2)]);
var state_38510__$1 = state_38510;
var statearr_38512_39826 = state_38510__$1;
(statearr_38512_39826[(2)] = inst_38506);

(statearr_38512_39826[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38511 === (20))){
var inst_38476 = (state_38510[(7)]);
var inst_38487 = (state_38510[(2)]);
var inst_38488 = cljs.core.next(inst_38476);
var inst_38462 = inst_38488;
var inst_38463 = null;
var inst_38464 = (0);
var inst_38465 = (0);
var state_38510__$1 = (function (){var statearr_38513 = state_38510;
(statearr_38513[(8)] = inst_38487);

(statearr_38513[(9)] = inst_38465);

(statearr_38513[(10)] = inst_38462);

(statearr_38513[(11)] = inst_38463);

(statearr_38513[(12)] = inst_38464);

return statearr_38513;
})();
var statearr_38514_39827 = state_38510__$1;
(statearr_38514_39827[(2)] = null);

(statearr_38514_39827[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38511 === (1))){
var state_38510__$1 = state_38510;
var statearr_38515_39828 = state_38510__$1;
(statearr_38515_39828[(2)] = null);

(statearr_38515_39828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38511 === (4))){
var inst_38451 = (state_38510[(13)]);
var inst_38451__$1 = (state_38510[(2)]);
var inst_38452 = (inst_38451__$1 == null);
var state_38510__$1 = (function (){var statearr_38516 = state_38510;
(statearr_38516[(13)] = inst_38451__$1);

return statearr_38516;
})();
if(cljs.core.truth_(inst_38452)){
var statearr_38517_39829 = state_38510__$1;
(statearr_38517_39829[(1)] = (5));

} else {
var statearr_38518_39830 = state_38510__$1;
(statearr_38518_39830[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38511 === (15))){
var state_38510__$1 = state_38510;
var statearr_38522_39831 = state_38510__$1;
(statearr_38522_39831[(2)] = null);

(statearr_38522_39831[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38511 === (21))){
var state_38510__$1 = state_38510;
var statearr_38523_39832 = state_38510__$1;
(statearr_38523_39832[(2)] = null);

(statearr_38523_39832[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38511 === (13))){
var inst_38465 = (state_38510[(9)]);
var inst_38462 = (state_38510[(10)]);
var inst_38463 = (state_38510[(11)]);
var inst_38464 = (state_38510[(12)]);
var inst_38472 = (state_38510[(2)]);
var inst_38473 = (inst_38465 + (1));
var tmp38519 = inst_38462;
var tmp38520 = inst_38463;
var tmp38521 = inst_38464;
var inst_38462__$1 = tmp38519;
var inst_38463__$1 = tmp38520;
var inst_38464__$1 = tmp38521;
var inst_38465__$1 = inst_38473;
var state_38510__$1 = (function (){var statearr_38524 = state_38510;
(statearr_38524[(9)] = inst_38465__$1);

(statearr_38524[(10)] = inst_38462__$1);

(statearr_38524[(14)] = inst_38472);

(statearr_38524[(11)] = inst_38463__$1);

(statearr_38524[(12)] = inst_38464__$1);

return statearr_38524;
})();
var statearr_38525_39833 = state_38510__$1;
(statearr_38525_39833[(2)] = null);

(statearr_38525_39833[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38511 === (22))){
var state_38510__$1 = state_38510;
var statearr_38526_39834 = state_38510__$1;
(statearr_38526_39834[(2)] = null);

(statearr_38526_39834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38511 === (6))){
var inst_38451 = (state_38510[(13)]);
var inst_38460 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_38451) : f.call(null,inst_38451));
var inst_38461 = cljs.core.seq(inst_38460);
var inst_38462 = inst_38461;
var inst_38463 = null;
var inst_38464 = (0);
var inst_38465 = (0);
var state_38510__$1 = (function (){var statearr_38527 = state_38510;
(statearr_38527[(9)] = inst_38465);

(statearr_38527[(10)] = inst_38462);

(statearr_38527[(11)] = inst_38463);

(statearr_38527[(12)] = inst_38464);

return statearr_38527;
})();
var statearr_38528_39835 = state_38510__$1;
(statearr_38528_39835[(2)] = null);

(statearr_38528_39835[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38511 === (17))){
var inst_38476 = (state_38510[(7)]);
var inst_38480 = cljs.core.chunk_first(inst_38476);
var inst_38481 = cljs.core.chunk_rest(inst_38476);
var inst_38482 = cljs.core.count(inst_38480);
var inst_38462 = inst_38481;
var inst_38463 = inst_38480;
var inst_38464 = inst_38482;
var inst_38465 = (0);
var state_38510__$1 = (function (){var statearr_38529 = state_38510;
(statearr_38529[(9)] = inst_38465);

(statearr_38529[(10)] = inst_38462);

(statearr_38529[(11)] = inst_38463);

(statearr_38529[(12)] = inst_38464);

return statearr_38529;
})();
var statearr_38530_39836 = state_38510__$1;
(statearr_38530_39836[(2)] = null);

(statearr_38530_39836[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38511 === (3))){
var inst_38508 = (state_38510[(2)]);
var state_38510__$1 = state_38510;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38510__$1,inst_38508);
} else {
if((state_val_38511 === (12))){
var inst_38496 = (state_38510[(2)]);
var state_38510__$1 = state_38510;
var statearr_38531_39837 = state_38510__$1;
(statearr_38531_39837[(2)] = inst_38496);

(statearr_38531_39837[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38511 === (2))){
var state_38510__$1 = state_38510;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38510__$1,(4),in$);
} else {
if((state_val_38511 === (23))){
var inst_38504 = (state_38510[(2)]);
var state_38510__$1 = state_38510;
var statearr_38532_39838 = state_38510__$1;
(statearr_38532_39838[(2)] = inst_38504);

(statearr_38532_39838[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38511 === (19))){
var inst_38491 = (state_38510[(2)]);
var state_38510__$1 = state_38510;
var statearr_38533_39839 = state_38510__$1;
(statearr_38533_39839[(2)] = inst_38491);

(statearr_38533_39839[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38511 === (11))){
var inst_38476 = (state_38510[(7)]);
var inst_38462 = (state_38510[(10)]);
var inst_38476__$1 = cljs.core.seq(inst_38462);
var state_38510__$1 = (function (){var statearr_38534 = state_38510;
(statearr_38534[(7)] = inst_38476__$1);

return statearr_38534;
})();
if(inst_38476__$1){
var statearr_38535_39840 = state_38510__$1;
(statearr_38535_39840[(1)] = (14));

} else {
var statearr_38536_39841 = state_38510__$1;
(statearr_38536_39841[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38511 === (9))){
var inst_38498 = (state_38510[(2)]);
var inst_38499 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_38510__$1 = (function (){var statearr_38537 = state_38510;
(statearr_38537[(15)] = inst_38498);

return statearr_38537;
})();
if(cljs.core.truth_(inst_38499)){
var statearr_38538_39848 = state_38510__$1;
(statearr_38538_39848[(1)] = (21));

} else {
var statearr_38539_39851 = state_38510__$1;
(statearr_38539_39851[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38511 === (5))){
var inst_38454 = cljs.core.async.close_BANG_(out);
var state_38510__$1 = state_38510;
var statearr_38540_39858 = state_38510__$1;
(statearr_38540_39858[(2)] = inst_38454);

(statearr_38540_39858[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38511 === (14))){
var inst_38476 = (state_38510[(7)]);
var inst_38478 = cljs.core.chunked_seq_QMARK_(inst_38476);
var state_38510__$1 = state_38510;
if(inst_38478){
var statearr_38541_39867 = state_38510__$1;
(statearr_38541_39867[(1)] = (17));

} else {
var statearr_38542_39870 = state_38510__$1;
(statearr_38542_39870[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38511 === (16))){
var inst_38494 = (state_38510[(2)]);
var state_38510__$1 = state_38510;
var statearr_38543_39875 = state_38510__$1;
(statearr_38543_39875[(2)] = inst_38494);

(statearr_38543_39875[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38511 === (10))){
var inst_38465 = (state_38510[(9)]);
var inst_38463 = (state_38510[(11)]);
var inst_38470 = cljs.core._nth(inst_38463,inst_38465);
var state_38510__$1 = state_38510;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38510__$1,(13),out,inst_38470);
} else {
if((state_val_38511 === (18))){
var inst_38476 = (state_38510[(7)]);
var inst_38485 = cljs.core.first(inst_38476);
var state_38510__$1 = state_38510;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38510__$1,(20),out,inst_38485);
} else {
if((state_val_38511 === (8))){
var inst_38465 = (state_38510[(9)]);
var inst_38464 = (state_38510[(12)]);
var inst_38467 = (inst_38465 < inst_38464);
var inst_38468 = inst_38467;
var state_38510__$1 = state_38510;
if(cljs.core.truth_(inst_38468)){
var statearr_38544_39898 = state_38510__$1;
(statearr_38544_39898[(1)] = (10));

} else {
var statearr_38545_39901 = state_38510__$1;
(statearr_38545_39901[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__37176__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__37176__auto____0 = (function (){
var statearr_38546 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38546[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__37176__auto__);

(statearr_38546[(1)] = (1));

return statearr_38546;
});
var cljs$core$async$mapcat_STAR__$_state_machine__37176__auto____1 = (function (state_38510){
while(true){
var ret_value__37177__auto__ = (function (){try{while(true){
var result__37178__auto__ = switch__37175__auto__(state_38510);
if(cljs.core.keyword_identical_QMARK_(result__37178__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37178__auto__;
}
break;
}
}catch (e38547){var ex__37179__auto__ = e38547;
var statearr_38548_39908 = state_38510;
(statearr_38548_39908[(2)] = ex__37179__auto__);


if(cljs.core.seq((state_38510[(4)]))){
var statearr_38549_39909 = state_38510;
(statearr_38549_39909[(1)] = cljs.core.first((state_38510[(4)])));

} else {
throw ex__37179__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37177__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39910 = state_38510;
state_38510 = G__39910;
continue;
} else {
return ret_value__37177__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__37176__auto__ = function(state_38510){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__37176__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__37176__auto____1.call(this,state_38510);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__37176__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__37176__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__37176__auto__;
})()
})();
var state__37213__auto__ = (function (){var statearr_38550 = f__37212__auto__();
(statearr_38550[(6)] = c__37211__auto__);

return statearr_38550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37213__auto__);
}));

return c__37211__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__38552 = arguments.length;
switch (G__38552) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__38554 = arguments.length;
switch (G__38554) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__38556 = arguments.length;
switch (G__38556) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__37211__auto___39914 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37212__auto__ = (function (){var switch__37175__auto__ = (function (state_38580){
var state_val_38581 = (state_38580[(1)]);
if((state_val_38581 === (7))){
var inst_38575 = (state_38580[(2)]);
var state_38580__$1 = state_38580;
var statearr_38582_39915 = state_38580__$1;
(statearr_38582_39915[(2)] = inst_38575);

(statearr_38582_39915[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38581 === (1))){
var inst_38557 = null;
var state_38580__$1 = (function (){var statearr_38583 = state_38580;
(statearr_38583[(7)] = inst_38557);

return statearr_38583;
})();
var statearr_38584_39916 = state_38580__$1;
(statearr_38584_39916[(2)] = null);

(statearr_38584_39916[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38581 === (4))){
var inst_38560 = (state_38580[(8)]);
var inst_38560__$1 = (state_38580[(2)]);
var inst_38561 = (inst_38560__$1 == null);
var inst_38562 = cljs.core.not(inst_38561);
var state_38580__$1 = (function (){var statearr_38585 = state_38580;
(statearr_38585[(8)] = inst_38560__$1);

return statearr_38585;
})();
if(inst_38562){
var statearr_38586_39917 = state_38580__$1;
(statearr_38586_39917[(1)] = (5));

} else {
var statearr_38587_39918 = state_38580__$1;
(statearr_38587_39918[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38581 === (6))){
var state_38580__$1 = state_38580;
var statearr_38588_39919 = state_38580__$1;
(statearr_38588_39919[(2)] = null);

(statearr_38588_39919[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38581 === (3))){
var inst_38577 = (state_38580[(2)]);
var inst_38578 = cljs.core.async.close_BANG_(out);
var state_38580__$1 = (function (){var statearr_38589 = state_38580;
(statearr_38589[(9)] = inst_38577);

return statearr_38589;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38580__$1,inst_38578);
} else {
if((state_val_38581 === (2))){
var state_38580__$1 = state_38580;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38580__$1,(4),ch);
} else {
if((state_val_38581 === (11))){
var inst_38560 = (state_38580[(8)]);
var inst_38569 = (state_38580[(2)]);
var inst_38557 = inst_38560;
var state_38580__$1 = (function (){var statearr_38590 = state_38580;
(statearr_38590[(10)] = inst_38569);

(statearr_38590[(7)] = inst_38557);

return statearr_38590;
})();
var statearr_38591_39920 = state_38580__$1;
(statearr_38591_39920[(2)] = null);

(statearr_38591_39920[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38581 === (9))){
var inst_38560 = (state_38580[(8)]);
var state_38580__$1 = state_38580;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38580__$1,(11),out,inst_38560);
} else {
if((state_val_38581 === (5))){
var inst_38560 = (state_38580[(8)]);
var inst_38557 = (state_38580[(7)]);
var inst_38564 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38560,inst_38557);
var state_38580__$1 = state_38580;
if(inst_38564){
var statearr_38593_39921 = state_38580__$1;
(statearr_38593_39921[(1)] = (8));

} else {
var statearr_38594_39922 = state_38580__$1;
(statearr_38594_39922[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38581 === (10))){
var inst_38572 = (state_38580[(2)]);
var state_38580__$1 = state_38580;
var statearr_38595_39923 = state_38580__$1;
(statearr_38595_39923[(2)] = inst_38572);

(statearr_38595_39923[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38581 === (8))){
var inst_38557 = (state_38580[(7)]);
var tmp38592 = inst_38557;
var inst_38557__$1 = tmp38592;
var state_38580__$1 = (function (){var statearr_38596 = state_38580;
(statearr_38596[(7)] = inst_38557__$1);

return statearr_38596;
})();
var statearr_38597_39924 = state_38580__$1;
(statearr_38597_39924[(2)] = null);

(statearr_38597_39924[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__37176__auto__ = null;
var cljs$core$async$state_machine__37176__auto____0 = (function (){
var statearr_38598 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38598[(0)] = cljs$core$async$state_machine__37176__auto__);

(statearr_38598[(1)] = (1));

return statearr_38598;
});
var cljs$core$async$state_machine__37176__auto____1 = (function (state_38580){
while(true){
var ret_value__37177__auto__ = (function (){try{while(true){
var result__37178__auto__ = switch__37175__auto__(state_38580);
if(cljs.core.keyword_identical_QMARK_(result__37178__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37178__auto__;
}
break;
}
}catch (e38599){var ex__37179__auto__ = e38599;
var statearr_38600_39925 = state_38580;
(statearr_38600_39925[(2)] = ex__37179__auto__);


if(cljs.core.seq((state_38580[(4)]))){
var statearr_38601_39926 = state_38580;
(statearr_38601_39926[(1)] = cljs.core.first((state_38580[(4)])));

} else {
throw ex__37179__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37177__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39927 = state_38580;
state_38580 = G__39927;
continue;
} else {
return ret_value__37177__auto__;
}
break;
}
});
cljs$core$async$state_machine__37176__auto__ = function(state_38580){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37176__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37176__auto____1.call(this,state_38580);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37176__auto____0;
cljs$core$async$state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37176__auto____1;
return cljs$core$async$state_machine__37176__auto__;
})()
})();
var state__37213__auto__ = (function (){var statearr_38602 = f__37212__auto__();
(statearr_38602[(6)] = c__37211__auto___39914);

return statearr_38602;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37213__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__38604 = arguments.length;
switch (G__38604) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__37211__auto___39929 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37212__auto__ = (function (){var switch__37175__auto__ = (function (state_38642){
var state_val_38643 = (state_38642[(1)]);
if((state_val_38643 === (7))){
var inst_38638 = (state_38642[(2)]);
var state_38642__$1 = state_38642;
var statearr_38644_39930 = state_38642__$1;
(statearr_38644_39930[(2)] = inst_38638);

(statearr_38644_39930[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38643 === (1))){
var inst_38605 = (new Array(n));
var inst_38606 = inst_38605;
var inst_38607 = (0);
var state_38642__$1 = (function (){var statearr_38645 = state_38642;
(statearr_38645[(7)] = inst_38607);

(statearr_38645[(8)] = inst_38606);

return statearr_38645;
})();
var statearr_38646_39931 = state_38642__$1;
(statearr_38646_39931[(2)] = null);

(statearr_38646_39931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38643 === (4))){
var inst_38610 = (state_38642[(9)]);
var inst_38610__$1 = (state_38642[(2)]);
var inst_38611 = (inst_38610__$1 == null);
var inst_38612 = cljs.core.not(inst_38611);
var state_38642__$1 = (function (){var statearr_38647 = state_38642;
(statearr_38647[(9)] = inst_38610__$1);

return statearr_38647;
})();
if(inst_38612){
var statearr_38648_39932 = state_38642__$1;
(statearr_38648_39932[(1)] = (5));

} else {
var statearr_38649_39933 = state_38642__$1;
(statearr_38649_39933[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38643 === (15))){
var inst_38632 = (state_38642[(2)]);
var state_38642__$1 = state_38642;
var statearr_38650_39934 = state_38642__$1;
(statearr_38650_39934[(2)] = inst_38632);

(statearr_38650_39934[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38643 === (13))){
var state_38642__$1 = state_38642;
var statearr_38651_39935 = state_38642__$1;
(statearr_38651_39935[(2)] = null);

(statearr_38651_39935[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38643 === (6))){
var inst_38607 = (state_38642[(7)]);
var inst_38628 = (inst_38607 > (0));
var state_38642__$1 = state_38642;
if(cljs.core.truth_(inst_38628)){
var statearr_38652_39936 = state_38642__$1;
(statearr_38652_39936[(1)] = (12));

} else {
var statearr_38653_39937 = state_38642__$1;
(statearr_38653_39937[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38643 === (3))){
var inst_38640 = (state_38642[(2)]);
var state_38642__$1 = state_38642;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38642__$1,inst_38640);
} else {
if((state_val_38643 === (12))){
var inst_38606 = (state_38642[(8)]);
var inst_38630 = cljs.core.vec(inst_38606);
var state_38642__$1 = state_38642;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38642__$1,(15),out,inst_38630);
} else {
if((state_val_38643 === (2))){
var state_38642__$1 = state_38642;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38642__$1,(4),ch);
} else {
if((state_val_38643 === (11))){
var inst_38622 = (state_38642[(2)]);
var inst_38623 = (new Array(n));
var inst_38606 = inst_38623;
var inst_38607 = (0);
var state_38642__$1 = (function (){var statearr_38654 = state_38642;
(statearr_38654[(7)] = inst_38607);

(statearr_38654[(10)] = inst_38622);

(statearr_38654[(8)] = inst_38606);

return statearr_38654;
})();
var statearr_38655_39938 = state_38642__$1;
(statearr_38655_39938[(2)] = null);

(statearr_38655_39938[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38643 === (9))){
var inst_38606 = (state_38642[(8)]);
var inst_38620 = cljs.core.vec(inst_38606);
var state_38642__$1 = state_38642;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38642__$1,(11),out,inst_38620);
} else {
if((state_val_38643 === (5))){
var inst_38615 = (state_38642[(11)]);
var inst_38607 = (state_38642[(7)]);
var inst_38610 = (state_38642[(9)]);
var inst_38606 = (state_38642[(8)]);
var inst_38614 = (inst_38606[inst_38607] = inst_38610);
var inst_38615__$1 = (inst_38607 + (1));
var inst_38616 = (inst_38615__$1 < n);
var state_38642__$1 = (function (){var statearr_38656 = state_38642;
(statearr_38656[(11)] = inst_38615__$1);

(statearr_38656[(12)] = inst_38614);

return statearr_38656;
})();
if(cljs.core.truth_(inst_38616)){
var statearr_38657_39939 = state_38642__$1;
(statearr_38657_39939[(1)] = (8));

} else {
var statearr_38658_39940 = state_38642__$1;
(statearr_38658_39940[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38643 === (14))){
var inst_38635 = (state_38642[(2)]);
var inst_38636 = cljs.core.async.close_BANG_(out);
var state_38642__$1 = (function (){var statearr_38660 = state_38642;
(statearr_38660[(13)] = inst_38635);

return statearr_38660;
})();
var statearr_38661_39941 = state_38642__$1;
(statearr_38661_39941[(2)] = inst_38636);

(statearr_38661_39941[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38643 === (10))){
var inst_38626 = (state_38642[(2)]);
var state_38642__$1 = state_38642;
var statearr_38662_39942 = state_38642__$1;
(statearr_38662_39942[(2)] = inst_38626);

(statearr_38662_39942[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38643 === (8))){
var inst_38615 = (state_38642[(11)]);
var inst_38606 = (state_38642[(8)]);
var tmp38659 = inst_38606;
var inst_38606__$1 = tmp38659;
var inst_38607 = inst_38615;
var state_38642__$1 = (function (){var statearr_38663 = state_38642;
(statearr_38663[(7)] = inst_38607);

(statearr_38663[(8)] = inst_38606__$1);

return statearr_38663;
})();
var statearr_38664_39943 = state_38642__$1;
(statearr_38664_39943[(2)] = null);

(statearr_38664_39943[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__37176__auto__ = null;
var cljs$core$async$state_machine__37176__auto____0 = (function (){
var statearr_38665 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38665[(0)] = cljs$core$async$state_machine__37176__auto__);

(statearr_38665[(1)] = (1));

return statearr_38665;
});
var cljs$core$async$state_machine__37176__auto____1 = (function (state_38642){
while(true){
var ret_value__37177__auto__ = (function (){try{while(true){
var result__37178__auto__ = switch__37175__auto__(state_38642);
if(cljs.core.keyword_identical_QMARK_(result__37178__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37178__auto__;
}
break;
}
}catch (e38666){var ex__37179__auto__ = e38666;
var statearr_38667_39944 = state_38642;
(statearr_38667_39944[(2)] = ex__37179__auto__);


if(cljs.core.seq((state_38642[(4)]))){
var statearr_38668_39945 = state_38642;
(statearr_38668_39945[(1)] = cljs.core.first((state_38642[(4)])));

} else {
throw ex__37179__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37177__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39946 = state_38642;
state_38642 = G__39946;
continue;
} else {
return ret_value__37177__auto__;
}
break;
}
});
cljs$core$async$state_machine__37176__auto__ = function(state_38642){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37176__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37176__auto____1.call(this,state_38642);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37176__auto____0;
cljs$core$async$state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37176__auto____1;
return cljs$core$async$state_machine__37176__auto__;
})()
})();
var state__37213__auto__ = (function (){var statearr_38669 = f__37212__auto__();
(statearr_38669[(6)] = c__37211__auto___39929);

return statearr_38669;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37213__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__38671 = arguments.length;
switch (G__38671) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__37211__auto___39948 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37212__auto__ = (function (){var switch__37175__auto__ = (function (state_38713){
var state_val_38714 = (state_38713[(1)]);
if((state_val_38714 === (7))){
var inst_38709 = (state_38713[(2)]);
var state_38713__$1 = state_38713;
var statearr_38715_39949 = state_38713__$1;
(statearr_38715_39949[(2)] = inst_38709);

(statearr_38715_39949[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38714 === (1))){
var inst_38672 = [];
var inst_38673 = inst_38672;
var inst_38674 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_38713__$1 = (function (){var statearr_38716 = state_38713;
(statearr_38716[(7)] = inst_38674);

(statearr_38716[(8)] = inst_38673);

return statearr_38716;
})();
var statearr_38717_39950 = state_38713__$1;
(statearr_38717_39950[(2)] = null);

(statearr_38717_39950[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38714 === (4))){
var inst_38677 = (state_38713[(9)]);
var inst_38677__$1 = (state_38713[(2)]);
var inst_38678 = (inst_38677__$1 == null);
var inst_38679 = cljs.core.not(inst_38678);
var state_38713__$1 = (function (){var statearr_38718 = state_38713;
(statearr_38718[(9)] = inst_38677__$1);

return statearr_38718;
})();
if(inst_38679){
var statearr_38719_39951 = state_38713__$1;
(statearr_38719_39951[(1)] = (5));

} else {
var statearr_38720_39952 = state_38713__$1;
(statearr_38720_39952[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38714 === (15))){
var inst_38703 = (state_38713[(2)]);
var state_38713__$1 = state_38713;
var statearr_38721_39953 = state_38713__$1;
(statearr_38721_39953[(2)] = inst_38703);

(statearr_38721_39953[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38714 === (13))){
var state_38713__$1 = state_38713;
var statearr_38722_39954 = state_38713__$1;
(statearr_38722_39954[(2)] = null);

(statearr_38722_39954[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38714 === (6))){
var inst_38673 = (state_38713[(8)]);
var inst_38698 = inst_38673.length;
var inst_38699 = (inst_38698 > (0));
var state_38713__$1 = state_38713;
if(cljs.core.truth_(inst_38699)){
var statearr_38723_39955 = state_38713__$1;
(statearr_38723_39955[(1)] = (12));

} else {
var statearr_38724_39956 = state_38713__$1;
(statearr_38724_39956[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38714 === (3))){
var inst_38711 = (state_38713[(2)]);
var state_38713__$1 = state_38713;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38713__$1,inst_38711);
} else {
if((state_val_38714 === (12))){
var inst_38673 = (state_38713[(8)]);
var inst_38701 = cljs.core.vec(inst_38673);
var state_38713__$1 = state_38713;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38713__$1,(15),out,inst_38701);
} else {
if((state_val_38714 === (2))){
var state_38713__$1 = state_38713;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38713__$1,(4),ch);
} else {
if((state_val_38714 === (11))){
var inst_38677 = (state_38713[(9)]);
var inst_38681 = (state_38713[(10)]);
var inst_38691 = (state_38713[(2)]);
var inst_38692 = [];
var inst_38693 = inst_38692.push(inst_38677);
var inst_38673 = inst_38692;
var inst_38674 = inst_38681;
var state_38713__$1 = (function (){var statearr_38725 = state_38713;
(statearr_38725[(7)] = inst_38674);

(statearr_38725[(8)] = inst_38673);

(statearr_38725[(11)] = inst_38693);

(statearr_38725[(12)] = inst_38691);

return statearr_38725;
})();
var statearr_38726_39957 = state_38713__$1;
(statearr_38726_39957[(2)] = null);

(statearr_38726_39957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38714 === (9))){
var inst_38673 = (state_38713[(8)]);
var inst_38689 = cljs.core.vec(inst_38673);
var state_38713__$1 = state_38713;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38713__$1,(11),out,inst_38689);
} else {
if((state_val_38714 === (5))){
var inst_38674 = (state_38713[(7)]);
var inst_38677 = (state_38713[(9)]);
var inst_38681 = (state_38713[(10)]);
var inst_38681__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_38677) : f.call(null,inst_38677));
var inst_38682 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38681__$1,inst_38674);
var inst_38683 = cljs.core.keyword_identical_QMARK_(inst_38674,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_38684 = ((inst_38682) || (inst_38683));
var state_38713__$1 = (function (){var statearr_38727 = state_38713;
(statearr_38727[(10)] = inst_38681__$1);

return statearr_38727;
})();
if(cljs.core.truth_(inst_38684)){
var statearr_38728_39958 = state_38713__$1;
(statearr_38728_39958[(1)] = (8));

} else {
var statearr_38729_39959 = state_38713__$1;
(statearr_38729_39959[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38714 === (14))){
var inst_38706 = (state_38713[(2)]);
var inst_38707 = cljs.core.async.close_BANG_(out);
var state_38713__$1 = (function (){var statearr_38731 = state_38713;
(statearr_38731[(13)] = inst_38706);

return statearr_38731;
})();
var statearr_38732_39960 = state_38713__$1;
(statearr_38732_39960[(2)] = inst_38707);

(statearr_38732_39960[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38714 === (10))){
var inst_38696 = (state_38713[(2)]);
var state_38713__$1 = state_38713;
var statearr_38733_39961 = state_38713__$1;
(statearr_38733_39961[(2)] = inst_38696);

(statearr_38733_39961[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38714 === (8))){
var inst_38673 = (state_38713[(8)]);
var inst_38677 = (state_38713[(9)]);
var inst_38681 = (state_38713[(10)]);
var inst_38686 = inst_38673.push(inst_38677);
var tmp38730 = inst_38673;
var inst_38673__$1 = tmp38730;
var inst_38674 = inst_38681;
var state_38713__$1 = (function (){var statearr_38734 = state_38713;
(statearr_38734[(7)] = inst_38674);

(statearr_38734[(8)] = inst_38673__$1);

(statearr_38734[(14)] = inst_38686);

return statearr_38734;
})();
var statearr_38735_39962 = state_38713__$1;
(statearr_38735_39962[(2)] = null);

(statearr_38735_39962[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__37176__auto__ = null;
var cljs$core$async$state_machine__37176__auto____0 = (function (){
var statearr_38736 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38736[(0)] = cljs$core$async$state_machine__37176__auto__);

(statearr_38736[(1)] = (1));

return statearr_38736;
});
var cljs$core$async$state_machine__37176__auto____1 = (function (state_38713){
while(true){
var ret_value__37177__auto__ = (function (){try{while(true){
var result__37178__auto__ = switch__37175__auto__(state_38713);
if(cljs.core.keyword_identical_QMARK_(result__37178__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37178__auto__;
}
break;
}
}catch (e38737){var ex__37179__auto__ = e38737;
var statearr_38738_39963 = state_38713;
(statearr_38738_39963[(2)] = ex__37179__auto__);


if(cljs.core.seq((state_38713[(4)]))){
var statearr_38739_39964 = state_38713;
(statearr_38739_39964[(1)] = cljs.core.first((state_38713[(4)])));

} else {
throw ex__37179__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37177__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39965 = state_38713;
state_38713 = G__39965;
continue;
} else {
return ret_value__37177__auto__;
}
break;
}
});
cljs$core$async$state_machine__37176__auto__ = function(state_38713){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37176__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37176__auto____1.call(this,state_38713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37176__auto____0;
cljs$core$async$state_machine__37176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37176__auto____1;
return cljs$core$async$state_machine__37176__auto__;
})()
})();
var state__37213__auto__ = (function (){var statearr_38740 = f__37212__auto__();
(statearr_38740[(6)] = c__37211__auto___39948);

return statearr_38740;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37213__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
