;; gorilla-repl.fileformat = 2

;; @@ [meta]
{:name "mariacloud-shapes", :tagline "svg shapes (from maria cloud)", :tags "cljs,demo,mariacloud, svg", :description ""}

;; @@

;; **
;;; # Shapes (from maria cloud)
;; **

;; @@ [cljs]
(ns mariacloud.shapes.dem
  (:require
   [awb99.shapes.core :as s :refer [color-names square layer colorize]]))

;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-nil"],"nil"],"~:value","nil"]
;; <=

;; @@ [cljs]
(s/circle 20)
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:svg",["^ ","~:x",0,"~:y",0,"~:width",40,"~:height",40],["~:circle",["^ ","~:stroke","none","~:stroke-width",0,"~:fill","black","~:cx",20,"~:cy",20,"~:r",20],null]]]
;; <=

;; @@ [cljs]
{:square (s/square 25) :circle (s/circle 15)}
;; @@
;; =>
;;; ["^ ","~:type","~:list-like","~:open",["~:span",["^ ","~:class","clj-map"],"{"],"~:close",["^3",["^ ","^4","clj-map"],"}"],"~:separator",["^3",", "],"~:items",["~#list",[["^ ","^0","^1","^2",null,"^5",null,"^6",["^3"," "],"^7",["^8",[["^ ","^0","~:html","~:content",["^3",["^ ","^4","clj-keyword"],":square"],"~:value",":square"],["^ ","^0","^9","^:",["~:svg",["^ ","~:x",0,"~:y",0,"~:width",25,"~:height",25],["~:rect",["^ ","~:x",0,"~:y",0,"^>",25,"^=",25,"~:stroke","none","~:stroke-width",0,"~:fill","black"],null]]]]],"^;","[:square #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 25, :width 25, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil}]"],["^ ","^0","^1","^2",null,"^5",null,"^6",["^3"," "],"^7",["^8",[["^ ","^0","^9","^:",["^3",["^ ","^4","clj-keyword"],":circle"],"^;",":circle"],["^ ","^0","^9","^:",["^<",["^ ","~:x",0,"~:y",0,"^=",30,"^>",30],["~:circle",["^ ","^@","none","^A",0,"^B","black","~:cx",15,"~:cy",15,"~:r",15],null]]]]],"^;","[:circle #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 15, :cy 15, :r 15, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil}]"]]],"^;","{:square #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 25, :width 25, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil}, :circle #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 15, :cy 15, :r 15, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil}}"]
;; <=

;; @@ [cljs]
(doc s/circle)
;; @@

;; @@ [cljs]
(s/rectangle 100 50)
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:svg",["^ ","~:x",0,"~:y",0,"~:width",100,"~:height",50],["~:rect",["^ ","~:x",0,"~:y",0,"^5",50,"^4",100,"~:stroke","none","~:stroke-width",0,"~:fill","black"],null]]]
;; <=

;; @@ [cljs]
(map #(+ 7 %) (range 5))
;; @@
;; =>
;;; ["^ ","~:type","~:list-like","~:open",["~:span",["^ ","~:class","clj-lazy-seq"],"("],"~:close",["^3",["^ ","^4","clj-lazy-seq"],")"],"~:separator",["^3"," "],"~:items",["~#list",[["^ ","^0","~:html","~:content",["^3",["^ ","^4","clj-long"],"7"],"~:value","7"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8"],"^;","8"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9"],"^;","9"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"10"],"^;","10"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"11"],"^;","11"]]],"^;","(7 8 9 10 11)"]
;; <=

;; @@ [cljs]
(vec (map #(s/circle (+ 10 %)) (range 50)))
;; @@
;; =>
;;; ["^ ","~:type","~:list-like","~:open",["~:span",["^ ","~:class","clj-vector"],"["],"~:close",["^3",["^ ","^4","clj-vector"],"]"],"~:separator",["^3"," "],"~:items",["~#list",[["^ ","^0","~:html","~:content",["~:svg",["^ ","~:x",0,"~:y",0,"~:width",20,"~:height",20],["~:circle",["^ ","~:stroke","none","~:stroke-width",0,"~:fill","black","~:cx",10,"~:cy",10,"~:r",10],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",22,"^=",22],["^>",["^ ","^?","none","^@",0,"^A","black","^B",11,"^C",11,"~:r",11],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",24,"^=",24],["^>",["^ ","^?","none","^@",0,"^A","black","^B",12,"^C",12,"~:r",12],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",26,"^=",26],["^>",["^ ","^?","none","^@",0,"^A","black","^B",13,"^C",13,"~:r",13],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",28,"^=",28],["^>",["^ ","^?","none","^@",0,"^A","black","^B",14,"^C",14,"~:r",14],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",30,"^=",30],["^>",["^ ","^?","none","^@",0,"^A","black","^B",15,"^C",15,"~:r",15],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",32,"^=",32],["^>",["^ ","^?","none","^@",0,"^A","black","^B",16,"^C",16,"~:r",16],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",34,"^=",34],["^>",["^ ","^?","none","^@",0,"^A","black","^B",17,"^C",17,"~:r",17],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",36,"^=",36],["^>",["^ ","^?","none","^@",0,"^A","black","^B",18,"^C",18,"~:r",18],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",38,"^=",38],["^>",["^ ","^?","none","^@",0,"^A","black","^B",19,"^C",19,"~:r",19],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",40,"^=",40],["^>",["^ ","^?","none","^@",0,"^A","black","^B",20,"^C",20,"~:r",20],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",42,"^=",42],["^>",["^ ","^?","none","^@",0,"^A","black","^B",21,"^C",21,"~:r",21],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",44,"^=",44],["^>",["^ ","^?","none","^@",0,"^A","black","^B",22,"^C",22,"~:r",22],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",46,"^=",46],["^>",["^ ","^?","none","^@",0,"^A","black","^B",23,"^C",23,"~:r",23],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",48,"^=",48],["^>",["^ ","^?","none","^@",0,"^A","black","^B",24,"^C",24,"~:r",24],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",50,"^=",50],["^>",["^ ","^?","none","^@",0,"^A","black","^B",25,"^C",25,"~:r",25],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",52,"^=",52],["^>",["^ ","^?","none","^@",0,"^A","black","^B",26,"^C",26,"~:r",26],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",54,"^=",54],["^>",["^ ","^?","none","^@",0,"^A","black","^B",27,"^C",27,"~:r",27],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",56,"^=",56],["^>",["^ ","^?","none","^@",0,"^A","black","^B",28,"^C",28,"~:r",28],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",58,"^=",58],["^>",["^ ","^?","none","^@",0,"^A","black","^B",29,"^C",29,"~:r",29],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",60,"^=",60],["^>",["^ ","^?","none","^@",0,"^A","black","^B",30,"^C",30,"~:r",30],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",62,"^=",62],["^>",["^ ","^?","none","^@",0,"^A","black","^B",31,"^C",31,"~:r",31],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",64,"^=",64],["^>",["^ ","^?","none","^@",0,"^A","black","^B",32,"^C",32,"~:r",32],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",66,"^=",66],["^>",["^ ","^?","none","^@",0,"^A","black","^B",33,"^C",33,"~:r",33],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",68,"^=",68],["^>",["^ ","^?","none","^@",0,"^A","black","^B",34,"^C",34,"~:r",34],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",70,"^=",70],["^>",["^ ","^?","none","^@",0,"^A","black","^B",35,"^C",35,"~:r",35],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",72,"^=",72],["^>",["^ ","^?","none","^@",0,"^A","black","^B",36,"^C",36,"~:r",36],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",74,"^=",74],["^>",["^ ","^?","none","^@",0,"^A","black","^B",37,"^C",37,"~:r",37],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",76,"^=",76],["^>",["^ ","^?","none","^@",0,"^A","black","^B",38,"^C",38,"~:r",38],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",78,"^=",78],["^>",["^ ","^?","none","^@",0,"^A","black","^B",39,"^C",39,"~:r",39],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",80,"^=",80],["^>",["^ ","^?","none","^@",0,"^A","black","^B",40,"^C",40,"~:r",40],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",82,"^=",82],["^>",["^ ","^?","none","^@",0,"^A","black","^B",41,"^C",41,"~:r",41],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",84,"^=",84],["^>",["^ ","^?","none","^@",0,"^A","black","^B",42,"^C",42,"~:r",42],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",86,"^=",86],["^>",["^ ","^?","none","^@",0,"^A","black","^B",43,"^C",43,"~:r",43],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",88,"^=",88],["^>",["^ ","^?","none","^@",0,"^A","black","^B",44,"^C",44,"~:r",44],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",90,"^=",90],["^>",["^ ","^?","none","^@",0,"^A","black","^B",45,"^C",45,"~:r",45],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",92,"^=",92],["^>",["^ ","^?","none","^@",0,"^A","black","^B",46,"^C",46,"~:r",46],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",94,"^=",94],["^>",["^ ","^?","none","^@",0,"^A","black","^B",47,"^C",47,"~:r",47],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",96,"^=",96],["^>",["^ ","^?","none","^@",0,"^A","black","^B",48,"^C",48,"~:r",48],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",98,"^=",98],["^>",["^ ","^?","none","^@",0,"^A","black","^B",49,"^C",49,"~:r",49],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",100,"^=",100],["^>",["^ ","^?","none","^@",0,"^A","black","^B",50,"^C",50,"~:r",50],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",102,"^=",102],["^>",["^ ","^?","none","^@",0,"^A","black","^B",51,"^C",51,"~:r",51],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",104,"^=",104],["^>",["^ ","^?","none","^@",0,"^A","black","^B",52,"^C",52,"~:r",52],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",106,"^=",106],["^>",["^ ","^?","none","^@",0,"^A","black","^B",53,"^C",53,"~:r",53],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",108,"^=",108],["^>",["^ ","^?","none","^@",0,"^A","black","^B",54,"^C",54,"~:r",54],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",110,"^=",110],["^>",["^ ","^?","none","^@",0,"^A","black","^B",55,"^C",55,"~:r",55],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",112,"^=",112],["^>",["^ ","^?","none","^@",0,"^A","black","^B",56,"^C",56,"~:r",56],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",114,"^=",114],["^>",["^ ","^?","none","^@",0,"^A","black","^B",57,"^C",57,"~:r",57],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",116,"^=",116],["^>",["^ ","^?","none","^@",0,"^A","black","^B",58,"^C",58,"~:r",58],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",118,"^=",118],["^>",["^ ","^?","none","^@",0,"^A","black","^B",59,"^C",59,"~:r",59],null]]]]],"~:value","[#awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 10, :cy 10, :r 10, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 11, :cy 11, :r 11, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 12, :cy 12, :r 12, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 13, :cy 13, :r 13, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 14, :cy 14, :r 14, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 15, :cy 15, :r 15, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 16, :cy 16, :r 16, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 17, :cy 17, :r 17, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 18, :cy 18, :r 18, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 19, :cy 19, :r 19, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 20, :cy 20, :r 20, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 21, :cy 21, :r 21, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 22, :cy 22, :r 22, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 23, :cy 23, :r 23, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 24, :cy 24, :r 24, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 25, :cy 25, :r 25, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 26, :cy 26, :r 26, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 27, :cy 27, :r 27, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 28, :cy 28, :r 28, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 29, :cy 29, :r 29, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 30, :cy 30, :r 30, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 31, :cy 31, :r 31, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 32, :cy 32, :r 32, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 33, :cy 33, :r 33, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 34, :cy 34, :r 34, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 35, :cy 35, :r 35, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 36, :cy 36, :r 36, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 37, :cy 37, :r 37, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 38, :cy 38, :r 38, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 39, :cy 39, :r 39, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 40, :cy 40, :r 40, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 41, :cy 41, :r 41, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 42, :cy 42, :r 42, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 43, :cy 43, :r 43, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 44, :cy 44, :r 44, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 45, :cy 45, :r 45, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 46, :cy 46, :r 46, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 47, :cy 47, :r 47, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 48, :cy 48, :r 48, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 49, :cy 49, :r 49, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 50, :cy 50, :r 50, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 51, :cy 51, :r 51, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 52, :cy 52, :r 52, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 53, :cy 53, :r 53, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 54, :cy 54, :r 54, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 55, :cy 55, :r 55, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 56, :cy 56, :r 56, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 57, :cy 57, :r 57, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 58, :cy 58, :r 58, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 59, :cy 59, :r 59, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil}]"]
;; <=

;; @@ [clj]
; clj output
(vec (range 5))
;; @@
;; =>
;;; ["^ ","~:type","~:list-like","~:open",["~:span",["^ ","~:class","clj-vector"],"["],"~:close",["^3",["^ ","^4","clj-vector"],"]"],"~:separator",["^3"," "],"~:items",["~#list",[["^ ","^0","~:html","~:content",["^3",["^ ","^4","clj-long"],"0"],"~:value","0"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1"],"^;","1"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2"],"^;","2"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3"],"^;","3"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4"],"^;","4"]]],"^;","[0 1 2 3 4]"]
;; <=

;; @@ [cljs]
; cljs output:
(vec (range 5))
;; @@
;; =>
;;; ["^ ","~:type","~:list-like","~:open",["~:span",["^ ","~:class","clj-vector"],"["],"~:close",["^3",["^ ","^4","clj-vector"],"]"],"~:separator",["^3"," "],"~:items",["~#list",[["^ ","^0","~:html","~:content",["^3",["^ ","^4","clj-long"],"0"],"~:value","0"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1"],"^;","1"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2"],"^;","2"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3"],"^;","3"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4"],"^;","4"]]],"^;","[0 1 2 3 4]"]
;; <=

;; @@ [cljs]
(range 5)
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-unknown"],"(0 1 2 3 4)"],"~:value","(0 1 2 3 4)"]
;; <=

;; @@ [cljs]
s/color-names
;; @@
;; =>
;;; ["^ ","~:type","~:list-like","~:open",["~:span",["^ ","~:class","clj-set"],"#{"],"~:close",["^3",["^ ","^4","clj-set"],"}"],"~:separator",["^3"," "],"~:items",["~#list",[["^ ","^0","~:html","~:content",["^3",["^ ","^4","clj-string"],"\"springgreen\""],"~:value","\"springgreen\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"aqua\""],"^;","\"aqua\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"blue\""],"^;","\"blue\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"olivedrab\""],"^;","\"olivedrab\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"lightskyblue\""],"^;","\"lightskyblue\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"greenyellow\""],"^;","\"greenyellow\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"ivory\""],"^;","\"ivory\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"navajowhite\""],"^;","\"navajowhite\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"cyan\""],"^;","\"cyan\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"mediumturquoise\""],"^;","\"mediumturquoise\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"darkslateblue\""],"^;","\"darkslateblue\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"lawngreen\""],"^;","\"lawngreen\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"saddlebrown\""],"^;","\"saddlebrown\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"white\""],"^;","\"white\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"silver\""],"^;","\"silver\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"purple\""],"^;","\"purple\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"gainsboro\""],"^;","\"gainsboro\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"plum\""],"^;","\"plum\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"midnightblue\""],"^;","\"midnightblue\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"magenta\""],"^;","\"magenta\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"paleturquoise\""],"^;","\"paleturquoise\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"hotpink\""],"^;","\"hotpink\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"mediumorchid\""],"^;","\"mediumorchid\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"gold\""],"^;","\"gold\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"powderblue\""],"^;","\"powderblue\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"papayawhip\""],"^;","\"papayawhip\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"bisque\""],"^;","\"bisque\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"salmon\""],"^;","\"salmon\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"forestgreen\""],"^;","\"forestgreen\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"blanchedalmond\""],"^;","\"blanchedalmond\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"grey\""],"^;","\"grey\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"crimson\""],"^;","\"crimson\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"darkturquoise\""],"^;","\"darkturquoise\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"steelblue\""],"^;","\"steelblue\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"mediumvioletred\""],"^;","\"mediumvioletred\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"aquamarine\""],"^;","\"aquamarine\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"darkgoldenrod\""],"^;","\"darkgoldenrod\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"orange\""],"^;","\"orange\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"darkgray\""],"^;","\"darkgray\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"lime\""],"^;","\"lime\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"cornflowerblue\""],"^;","\"cornflowerblue\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"aliceblue\""],"^;","\"aliceblue\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"lightgoldenrodyellow\""],"^;","\"lightgoldenrodyellow\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"lemonchiffon\""],"^;","\"lemonchiffon\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"lightsalmon\""],"^;","\"lightsalmon\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"deepskyblue\""],"^;","\"deepskyblue\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"lightgreen\""],"^;","\"lightgreen\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"palegoldenrod\""],"^;","\"palegoldenrod\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"darkred\""],"^;","\"darkred\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"violet\""],"^;","\"violet\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"gray\""],"^;","\"gray\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"goldenrod\""],"^;","\"goldenrod\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"darksalmon\""],"^;","\"darksalmon\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"skyblue\""],"^;","\"skyblue\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"darkviolet\""],"^;","\"darkviolet\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"fuchsia\""],"^;","\"fuchsia\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"lightcoral\""],"^;","\"lightcoral\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"moccasin\""],"^;","\"moccasin\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"darkgreen\""],"^;","\"darkgreen\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"lightyellow\""],"^;","\"lightyellow\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"lavenderblush\""],"^;","\"lavenderblush\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"sienna\""],"^;","\"sienna\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"burlywood\""],"^;","\"burlywood\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"ghostwhite\""],"^;","\"ghostwhite\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"coral\""],"^;","\"coral\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"linen\""],"^;","\"linen\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"lightslategray\""],"^;","\"lightslategray\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"azure\""],"^;","\"azure\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"darkolivegreen\""],"^;","\"darkolivegreen\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"floralwhite\""],"^;","\"floralwhite\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"yellow\""],"^;","\"yellow\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"beige\""],"^;","\"beige\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"wheat\""],"^;","\"wheat\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"slategray\""],"^;","\"slategray\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"darkmagenta\""],"^;","\"darkmagenta\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"darkcyan\""],"^;","\"darkcyan\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"dodgerblue\""],"^;","\"dodgerblue\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"mediumseagreen\""],"^;","\"mediumseagreen\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"darkgrey\""],"^;","\"darkgrey\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"mediumblue\""],"^;","\"mediumblue\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"pink\""],"^;","\"pink\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"mistyrose\""],"^;","\"mistyrose\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"teal\""],"^;","\"teal\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"olive\""],"^;","\"olive\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"navy\""],"^;","\"navy\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"darkkhaki\""],"^;","\"darkkhaki\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"green\""],"^;","\"green\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"darkblue\""],"^;","\"darkblue\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"red\""],"^;","\"red\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"maroon\""],"^;","\"maroon\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"limegreen\""],"^;","\"limegreen\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"brown\""],"^;","\"brown\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"seashell\""],"^;","\"seashell\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"chocolate\""],"^;","\"chocolate\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"antiquewhite\""],"^;","\"antiquewhite\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"tan\""],"^;","\"tan\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"seagreen\""],"^;","\"seagreen\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"palevioletred\""],"^;","\"palevioletred\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"rosybrown\""],"^;","\"rosybrown\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"cornsilk\""],"^;","\"cornsilk\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"lavender\""],"^;","\"lavender\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"mediumpurple\""],"^;","\"mediumpurple\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"black\""],"^;","\"black\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"snow\""],"^;","\"snow\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"lightseagreen\""],"^;","\"lightseagreen\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"palegreen\""],"^;","\"palegreen\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"deeppink\""],"^;","\"deeppink\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"dimgray\""],"^;","\"dimgray\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"blueviolet\""],"^;","\"blueviolet\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"cadetblue\""],"^;","\"cadetblue\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"slateblue\""],"^;","\"slateblue\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"mediumspringgreen\""],"^;","\"mediumspringgreen\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"lightpink\""],"^;","\"lightpink\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"firebrick\""],"^;","\"firebrick\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"dimgrey\""],"^;","\"dimgrey\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"khaki\""],"^;","\"khaki\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"royalblue\""],"^;","\"royalblue\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"sandybrown\""],"^;","\"sandybrown\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"orangered\""],"^;","\"orangered\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"darkslategray\""],"^;","\"darkslategray\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"orchid\""],"^;","\"orchid\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"indianred\""],"^;","\"indianred\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"darkorchid\""],"^;","\"darkorchid\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"honeydew\""],"^;","\"honeydew\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"oldlace\""],"^;","\"oldlace\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"whitesmoke\""],"^;","\"whitesmoke\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"mediumaquamarine\""],"^;","\"mediumaquamarine\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"lightgrey\""],"^;","\"lightgrey\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"peru\""],"^;","\"peru\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"chartreuse\""],"^;","\"chartreuse\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"lightcyan\""],"^;","\"lightcyan\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"lightblue\""],"^;","\"lightblue\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"tomato\""],"^;","\"tomato\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"mintcream\""],"^;","\"mintcream\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"peachpuff\""],"^;","\"peachpuff\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"thistle\""],"^;","\"thistle\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"lightsteelblue\""],"^;","\"lightsteelblue\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"mediumslateblue\""],"^;","\"mediumslateblue\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"darkslategrey\""],"^;","\"darkslategrey\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"turquoise\""],"^;","\"turquoise\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"slategrey\""],"^;","\"slategrey\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"indigo\""],"^;","\"indigo\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"lightslategrey\""],"^;","\"lightslategrey\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"darkorange\""],"^;","\"darkorange\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"yellowgreen\""],"^;","\"yellowgreen\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"lightgray\""],"^;","\"lightgray\""],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"darkseagreen\""],"^;","\"darkseagreen\""]]],"^;","#{\"springgreen\" \"aqua\" \"blue\" \"olivedrab\" \"lightskyblue\" \"greenyellow\" \"ivory\" \"navajowhite\" \"cyan\" \"mediumturquoise\" \"darkslateblue\" \"lawngreen\" \"saddlebrown\" \"white\" \"silver\" \"purple\" \"gainsboro\" \"plum\" \"midnightblue\" \"magenta\" \"paleturquoise\" \"hotpink\" \"mediumorchid\" \"gold\" \"powderblue\" \"papayawhip\" \"bisque\" \"salmon\" \"forestgreen\" \"blanchedalmond\" \"grey\" \"crimson\" \"darkturquoise\" \"steelblue\" \"mediumvioletred\" \"aquamarine\" \"darkgoldenrod\" \"orange\" \"darkgray\" \"lime\" \"cornflowerblue\" \"aliceblue\" \"lightgoldenrodyellow\" \"lemonchiffon\" \"lightsalmon\" \"deepskyblue\" \"lightgreen\" \"palegoldenrod\" \"darkred\" \"violet\" \"gray\" \"goldenrod\" \"darksalmon\" \"skyblue\" \"darkviolet\" \"fuchsia\" \"lightcoral\" \"moccasin\" \"darkgreen\" \"lightyellow\" \"lavenderblush\" \"sienna\" \"burlywood\" \"ghostwhite\" \"coral\" \"linen\" \"lightslategray\" \"azure\" \"darkolivegreen\" \"floralwhite\" \"yellow\" \"beige\" \"wheat\" \"slategray\" \"darkmagenta\" \"darkcyan\" \"dodgerblue\" \"mediumseagreen\" \"darkgrey\" \"mediumblue\" \"pink\" \"mistyrose\" \"teal\" \"olive\" \"navy\" \"darkkhaki\" \"green\" \"darkblue\" \"red\" \"maroon\" \"limegreen\" \"brown\" \"seashell\" \"chocolate\" \"antiquewhite\" \"tan\" \"seagreen\" \"palevioletred\" \"rosybrown\" \"cornsilk\" \"lavender\" \"mediumpurple\" \"black\" \"snow\" \"lightseagreen\" \"palegreen\" \"deeppink\" \"dimgray\" \"blueviolet\" \"cadetblue\" \"slateblue\" \"mediumspringgreen\" \"lightpink\" \"firebrick\" \"dimgrey\" \"khaki\" \"royalblue\" \"sandybrown\" \"orangered\" \"darkslategray\" \"orchid\" \"indianred\" \"darkorchid\" \"honeydew\" \"oldlace\" \"whitesmoke\" \"mediumaquamarine\" \"lightgrey\" \"peru\" \"chartreuse\" \"lightcyan\" \"lightblue\" \"tomato\" \"mintcream\" \"peachpuff\" \"thistle\" \"lightsteelblue\" \"mediumslateblue\" \"darkslategrey\" \"turquoise\" \"slategrey\" \"indigo\" \"lightslategrey\" \"darkorange\" \"yellowgreen\" \"lightgray\" \"darkseagreen\"}"]
;; <=

;; @@ [cljs]
(s/colors-named "yellow")
;; @@
;; =>
;;; ["^ ","~:type","~:list-like","~:open",["~:span",["^ ","~:class","clj-map"],"{"],"~:close",["^3",["^ ","^4","clj-map"],"}"],"~:separator",["^3",", "],"~:items",["~#list",[["^ ","^0","^1","^2",null,"^5",null,"^6",["^3"," "],"^7",["^8",[["^ ","^0","~:html","~:content",["^3",["^ ","^4","clj-string"],"\"greenyellow\""],"~:value","\"greenyellow\""],["^ ","^0","^9","^:",["~:svg",["^ ","~:x",0,"~:y",0,"~:width",25,"~:height",25],["~:rect",["^ ","~:x",0,"~:y",0,"^>",25,"^=",25,"~:stroke","none","~:stroke-width",0,"~:fill","greenyellow"],null]]]]],"^;","[\"greenyellow\" #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 25, :width 25, :stroke \"none\", :stroke-width 0, :fill \"greenyellow\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil}]"],["^ ","^0","^1","^2",null,"^5",null,"^6",["^3"," "],"^7",["^8",[["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"lightgoldenrodyellow\""],"^;","\"lightgoldenrodyellow\""],["^ ","^0","^9","^:",["^<",["^ ","~:x",0,"~:y",0,"^=",25,"^>",25],["^?",["^ ","~:x",0,"~:y",0,"^>",25,"^=",25,"^@","none","^A",0,"^B","lightgoldenrodyellow"],null]]]]],"^;","[\"lightgoldenrodyellow\" #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 25, :width 25, :stroke \"none\", :stroke-width 0, :fill \"lightgoldenrodyellow\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil}]"],["^ ","^0","^1","^2",null,"^5",null,"^6",["^3"," "],"^7",["^8",[["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"lightyellow\""],"^;","\"lightyellow\""],["^ ","^0","^9","^:",["^<",["^ ","~:x",0,"~:y",0,"^=",25,"^>",25],["^?",["^ ","~:x",0,"~:y",0,"^>",25,"^=",25,"^@","none","^A",0,"^B","lightyellow"],null]]]]],"^;","[\"lightyellow\" #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 25, :width 25, :stroke \"none\", :stroke-width 0, :fill \"lightyellow\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil}]"],["^ ","^0","^1","^2",null,"^5",null,"^6",["^3"," "],"^7",["^8",[["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"yellow\""],"^;","\"yellow\""],["^ ","^0","^9","^:",["^<",["^ ","~:x",0,"~:y",0,"^=",25,"^>",25],["^?",["^ ","~:x",0,"~:y",0,"^>",25,"^=",25,"^@","none","^A",0,"^B","yellow"],null]]]]],"^;","[\"yellow\" #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 25, :width 25, :stroke \"none\", :stroke-width 0, :fill \"yellow\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil}]"],["^ ","^0","^1","^2",null,"^5",null,"^6",["^3"," "],"^7",["^8",[["^ ","^0","^9","^:",["^3",["^ ","^4","clj-string"],"\"yellowgreen\""],"^;","\"yellowgreen\""],["^ ","^0","^9","^:",["^<",["^ ","~:x",0,"~:y",0,"^=",25,"^>",25],["^?",["^ ","~:x",0,"~:y",0,"^>",25,"^=",25,"^@","none","^A",0,"^B","yellowgreen"],null]]]]],"^;","[\"yellowgreen\" #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 25, :width 25, :stroke \"none\", :stroke-width 0, :fill \"yellowgreen\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil}]"]]],"^;","{\"greenyellow\" #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 25, :width 25, :stroke \"none\", :stroke-width 0, :fill \"greenyellow\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil}, \"lightgoldenrodyellow\" #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 25, :width 25, :stroke \"none\", :stroke-width 0, :fill \"lightgoldenrodyellow\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil}, \"lightyellow\" #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 25, :width 25, :stroke \"none\", :stroke-width 0, :fill \"lightyellow\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil}, \"yellow\" #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 25, :width 25, :stroke \"none\", :stroke-width 0, :fill \"yellow\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil}, \"yellowgreen\" #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 25, :width 25, :stroke \"none\", :stroke-width 0, :fill \"yellowgreen\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil}}"]
;; <=

;; @@ [cljs]
(s/layer
 (s/colorize "aqua" (s/square 50))
 (s/colorize "magenta" (s/circle 25)))
;; @@
;; =>
;;; {}
;; <=

;; @@ [cljs]
(s/layer
 (s/colorize "springgreen" (s/circle 25))
 (s/position 50 25 (s/colorize "pink" (s/circle 25))))
;; @@
;; =>
;;; {}
;; <=

;; @@ [cljs]
(s/layer
 (s/colorize "aqua" (s/circle 40))
 (s/position 10 10 (s/colorize "magenta" (s/triangle 24)))
 (s/position 45 10 (s/colorize "magenta" (s/triangle 24)))
 (s/position 40 55 (s/colorize "white" (s/circle 10))))
;; @@
;; =>
;;; {}
;; <=

;; @@ [cljs]
(map s/square [2 4 8 16 32 64 128])
;; @@
;; =>
;;; ["^ ","~:type","~:list-like","~:open",["~:span",["^ ","~:class","clj-lazy-seq"],"("],"~:close",["^3",["^ ","^4","clj-lazy-seq"],")"],"~:separator",["^3"," "],"~:items",["~#list",[["^ ","^0","~:html","~:content",["~:svg",["^ ","~:x",0,"~:y",0,"~:width",2,"~:height",2],["~:rect",["^ ","~:x",0,"~:y",0,"^=",2,"^<",2,"~:stroke","none","~:stroke-width",0,"~:fill","black"],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",4,"^=",4],["^>",["^ ","~:x",0,"~:y",0,"^=",4,"^<",4,"^?","none","^@",0,"^A","black"],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",8,"^=",8],["^>",["^ ","~:x",0,"~:y",0,"^=",8,"^<",8,"^?","none","^@",0,"^A","black"],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",16,"^=",16],["^>",["^ ","~:x",0,"~:y",0,"^=",16,"^<",16,"^?","none","^@",0,"^A","black"],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",32,"^=",32],["^>",["^ ","~:x",0,"~:y",0,"^=",32,"^<",32,"^?","none","^@",0,"^A","black"],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",64,"^=",64],["^>",["^ ","~:x",0,"~:y",0,"^=",64,"^<",64,"^?","none","^@",0,"^A","black"],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",128,"^=",128],["^>",["^ ","~:x",0,"~:y",0,"^=",128,"^<",128,"^?","none","^@",0,"^A","black"],null]]]]],"~:value","(#awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 2, :width 2, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 4, :width 4, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 8, :width 8, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 16, :width 16, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 32, :width 32, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 64, :width 64, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 128, :width 128, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil})"]
;; <=

;; @@ [cljs]
(map (fn [color] (s/colorize color (s/circle 25)))
     ["red" "blue" "green"])
;; @@
;; =>
;;; ["^ ","~:type","~:list-like","~:open",["~:span",["^ ","~:class","clj-lazy-seq"],"("],"~:close",["^3",["^ ","^4","clj-lazy-seq"],")"],"~:separator",["^3"," "],"~:items",["~#list",[["^ ","^0","~:html","~:content",["~:svg",["^ ","~:x",0,"~:y",0,"~:width",50,"~:height",50],["~:circle",["^ ","~:stroke","none","~:stroke-width",0,"~:fill","red","~:cx",25,"~:cy",25,"~:r",25],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",50,"^=",50],["^>",["^ ","^?","none","^@",0,"^A","blue","^B",25,"^C",25,"~:r",25],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",50,"^=",50],["^>",["^ ","^?","none","^@",0,"^A","green","^B",25,"^C",25,"~:r",25],null]]]]],"~:value","(#awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"red\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 25, :cy 25, :r 25, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"blue\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 25, :cy 25, :r 25, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"green\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 25, :cy 25, :r 25, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil})"]
;; <=

;; @@ [cljs]
(map (fn [o] (s/opacity o (s/square 40)))
     [0, 1/4, 1/2, 3/4, 1])
;; @@
;; =>
;;; ["^ ","~:type","~:list-like","~:open",["~:span",["^ ","~:class","clj-lazy-seq"],"("],"~:close",["^3",["^ ","^4","clj-lazy-seq"],")"],"~:separator",["^3"," "],"~:items",["~#list",[["^ ","^0","~:html","~:content",["~:svg",["^ ","~:x",0,"~:y",0,"~:width",40,"~:height",40],["~:rect",["^ ","~:x",0,"~:y",0,"^=",40,"^<",40,"~:stroke","none","~:stroke-width",0,"~:fill","black","~:opacity","0"],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",40,"^=",40],["^>",["^ ","~:x",0,"~:y",0,"^=",40,"^<",40,"^?","none","^@",0,"^A","black","^B","0.25"],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",40,"^=",40],["^>",["^ ","~:x",0,"~:y",0,"^=",40,"^<",40,"^?","none","^@",0,"^A","black","^B","0.5"],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",40,"^=",40],["^>",["^ ","~:x",0,"~:y",0,"^=",40,"^<",40,"^?","none","^@",0,"^A","black","^B","0.75"],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",40,"^=",40],["^>",["^ ","~:x",0,"~:y",0,"^=",40,"^<",40,"^?","none","^@",0,"^A","black","^B","1"],null]]]]],"~:value","(#awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 40, :width 40, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity \"0\", :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 40, :width 40, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity \"0.25\", :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 40, :width 40, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity \"0.5\", :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 40, :width 40, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity \"0.75\", :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 40, :width 40, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity \"1\", :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil})"]
;; <=

;; @@ [cljs]
(let [t (s/triangle 100)] ;; <-- this vector holds our name/value pair
  ;; now we write an expression using that name:
  (s/layer t
           (s/position 50 0 t)
           (s/position 88 0 t)
           (s/position 113 0 t)
           (s/position 185 0 t)
           (s/position 195 0 t)
           (s/position 238 0 t)))
;; @@
;; =>
;;; {}
;; <=

;; @@ [cljs]
(def rainbow
  ["red" "orange" "yellow" "green" "blue" "indigo" "violet"])
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-unknown"],"#'mariacloud.shapes.dem/rainbow"],"~:value","#'mariacloud.shapes.dem/rainbow"]
;; <=

;; @@ [cljs]
(map (fn [c] (s/colorize c (s/circle 25))) rainbow)
;; @@
;; =>
;;; ["^ ","~:type","~:list-like","~:open",["~:span",["^ ","~:class","clj-lazy-seq"],"("],"~:close",["^3",["^ ","^4","clj-lazy-seq"],")"],"~:separator",["^3"," "],"~:items",["~#list",[["^ ","^0","~:html","~:content",["~:svg",["^ ","~:x",0,"~:y",0,"~:width",50,"~:height",50],["~:circle",["^ ","~:stroke","none","~:stroke-width",0,"~:fill","red","~:cx",25,"~:cy",25,"~:r",25],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",50,"^=",50],["^>",["^ ","^?","none","^@",0,"^A","orange","^B",25,"^C",25,"~:r",25],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",50,"^=",50],["^>",["^ ","^?","none","^@",0,"^A","yellow","^B",25,"^C",25,"~:r",25],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",50,"^=",50],["^>",["^ ","^?","none","^@",0,"^A","green","^B",25,"^C",25,"~:r",25],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",50,"^=",50],["^>",["^ ","^?","none","^@",0,"^A","blue","^B",25,"^C",25,"~:r",25],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",50,"^=",50],["^>",["^ ","^?","none","^@",0,"^A","indigo","^B",25,"^C",25,"~:r",25],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",50,"^=",50],["^>",["^ ","^?","none","^@",0,"^A","violet","^B",25,"^C",25,"~:r",25],null]]]]],"~:value","(#awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"red\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 25, :cy 25, :r 25, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"orange\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 25, :cy 25, :r 25, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"yellow\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 25, :cy 25, :r 25, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"green\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 25, :cy 25, :r 25, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"blue\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 25, :cy 25, :r 25, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"indigo\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 25, :cy 25, :r 25, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"violet\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 25, :cy 25, :r 25, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil})"]
;; <=

;; @@ [cljs]
(def colorized-circle
  (fn [c] (s/colorize c (s/circle 25))))
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-unknown"],"#'mariacloud.shapes.dem/colorized-circle"],"~:value","#'mariacloud.shapes.dem/colorized-circle"]
;; <=

;; @@ [cljs]
(colorized-circle "slategray")
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:svg",["^ ","~:x",0,"~:y",0,"~:width",50,"~:height",50],["~:circle",["^ ","~:stroke","none","~:stroke-width",0,"~:fill","slategray","~:cx",25,"~:cy",25,"~:r",25],null]]]
;; <=

;; @@ [cljs]
(map (fn [c] (s/colorize c (s/rectangle 300 20)))
     rainbow)
;; @@
;; =>
;;; ["^ ","~:type","~:list-like","~:open",["~:span",["^ ","~:class","clj-lazy-seq"],"("],"~:close",["^3",["^ ","^4","clj-lazy-seq"],")"],"~:separator",["^3"," "],"~:items",["~#list",[["^ ","^0","~:html","~:content",["~:svg",["^ ","~:x",0,"~:y",0,"~:width",300,"~:height",20],["~:rect",["^ ","~:x",0,"~:y",0,"^=",20,"^<",300,"~:stroke","none","~:stroke-width",0,"~:fill","red"],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",300,"^=",20],["^>",["^ ","~:x",0,"~:y",0,"^=",20,"^<",300,"^?","none","^@",0,"^A","orange"],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",300,"^=",20],["^>",["^ ","~:x",0,"~:y",0,"^=",20,"^<",300,"^?","none","^@",0,"^A","yellow"],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",300,"^=",20],["^>",["^ ","~:x",0,"~:y",0,"^=",20,"^<",300,"^?","none","^@",0,"^A","green"],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",300,"^=",20],["^>",["^ ","~:x",0,"~:y",0,"^=",20,"^<",300,"^?","none","^@",0,"^A","blue"],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",300,"^=",20],["^>",["^ ","~:x",0,"~:y",0,"^=",20,"^<",300,"^?","none","^@",0,"^A","indigo"],null]]],["^ ","^0","^9","^:",["^;",["^ ","~:x",0,"~:y",0,"^<",300,"^=",20],["^>",["^ ","~:x",0,"~:y",0,"^=",20,"^<",300,"^?","none","^@",0,"^A","violet"],null]]]]],"~:value","(#awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 20, :width 300, :stroke \"none\", :stroke-width 0, :fill \"red\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 20, :width 300, :stroke \"none\", :stroke-width 0, :fill \"orange\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 20, :width 300, :stroke \"none\", :stroke-width 0, :fill \"yellow\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 20, :width 300, :stroke \"none\", :stroke-width 0, :fill \"green\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 20, :width 300, :stroke \"none\", :stroke-width 0, :fill \"blue\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 20, :width 300, :stroke \"none\", :stroke-width 0, :fill \"indigo\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} #awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 20, :width 300, :stroke \"none\", :stroke-width 0, :fill \"violet\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil})"]
;; <=

;; @@ [cljs]
(defn vertical-flag [colors]
  (apply s/above
         (map (fn [c]
                (s/colorize c (s/rectangle 300 (/ 200 (count colors)))))
              colors)))
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-unknown"],"#'mariacloud.shapes.dem/vertical-flag"],"~:value","#'mariacloud.shapes.dem/vertical-flag"]
;; <=

;; @@ [cljs]
; germany
(vertical-flag ["black" "red" "gold"])
;; @@
;; =>
;;; {}
;; <=

;; @@ [cljs]
; indonesia
(vertical-flag ["red" "white"])
;; @@
;; =>
;;; {}
;; <=

;; @@ [cljs]

; catalonia
(vertical-flag ["gold" "red" "gold" "red" "gold" "red" "gold" "red" "gold"])

;; @@
;; =>
;;; {}
;; <=

;; @@ [cljs]
[(s/circle 25) nil]
;; @@
;; =>
;;; ["^ ","~:type","~:list-like","~:open",["~:span",["^ ","~:class","clj-vector"],"["],"~:close",["^3",["^ ","^4","clj-vector"],"]"],"~:separator",["^3"," "],"~:items",["~#list",[["^ ","^0","~:html","~:content",["~:svg",["^ ","~:x",0,"~:y",0,"~:width",50,"~:height",50],["~:circle",["^ ","~:stroke","none","~:stroke-width",0,"~:fill","black","~:cx",25,"~:cy",25,"~:r",25],null]]],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-nil"],"nil"],"~:value","nil"]]],"^D","[#awb99.shapes.core.Shape{:kind :circle, :x nil, :y nil, :height nil, :width nil, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx 25, :cy 25, :r 25, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil} nil]"]
;; <=

;; @@ [cljs]

;; @@

;; @@ [cljs]
'(1 2 3)
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-unknown"],"(1 2 3)"],"~:value","(1 2 3)"]
;; <=

;; @@ [cljs]
(sorted-map :a 1)
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-unknown"],"{:a 1}"],"~:value","{:a 1}"]
;; <=

;; @@ [cljs]
(remove nil? [(s/square 50) nil])
;; @@
;; =>
;;; ["^ ","~:type","~:list-like","~:open",["~:span",["^ ","~:class","clj-lazy-seq"],"("],"~:close",["^3",["^ ","^4","clj-lazy-seq"],")"],"~:separator",["^3"," "],"~:items",["~#list",[["^ ","^0","~:html","~:content",["~:svg",["^ ","~:x",0,"~:y",0,"~:width",50,"~:height",50],["~:rect",["^ ","~:x",0,"~:y",0,"^=",50,"^<",50,"~:stroke","none","~:stroke-width",0,"~:fill","black"],null]]]]],"~:value","(#awb99.shapes.core.Shape{:kind :rect, :x 0, :y 0, :height 50, :width 50, :stroke \"none\", :stroke-width 0, :fill \"black\", :rotate nil, :opacity nil, :bbox nil, :children nil, :cx nil, :cy nil, :r nil, :rx nil, :ry nil, :points nil, :font-size nil, :font-weight nil, :font-family nil, :text nil, :href nil})"]
;; <=

;; @@ [clj]

;; @@

;; @@ [clj]

;; @@
;; ->
;;; 
;; <-
;; =>
;;; ["^ ","~:type","html","~:value",["~:span"]]
;; <=
