/*
 * Decompiled with CFR 0.152.
 */
package org.pingles.cascading.neo4j.hadoop;

import cascading.tuple.TupleEntry;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.pingles.cascading.neo4j.IndexSpec;
import org.pingles.cascading.neo4j.StringRelationshipType;
import org.pingles.cascading.neo4j.hadoop.Neo4jTuple;
import org.pingles.cascading.neo4j.hadoop.Neo4jWritable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipTuple
extends Neo4jTuple
implements Neo4jWritable {
    private final IndexSpec fromIndexSpec;
    private final IndexSpec toIndexSpec;
    private final TupleEntry tupleEntry;

    public RelationshipTuple(IndexSpec fromIndex, IndexSpec toIndex, TupleEntry tupleEntry) {
        this.fromIndexSpec = fromIndex;
        this.toIndexSpec = toIndex;
        this.tupleEntry = tupleEntry;
    }

    @Override
    public void store(GraphDatabaseService service) {
        Object fromKey = this.tupleEntry.getObject(0);
        Object toKey = this.tupleEntry.getObject(1);
        String relationshipLabel = this.tupleEntry.getString((Comparable)Integer.valueOf(2));
        try {
            Node toNode;
            Node fromNode;
            if (this.fromIndexSpec.isByID()) {
                fromNode = this.getNodeByID(service, (Long)fromKey);
            } else {
                Index<Node> fromIndex = this.getFromIndex(service);
                fromNode = this.lookupNodeInIndex(fromIndex, this.fromIndexSpec.getFirstIndexPropertyName(), fromKey);
            }
            if (this.toIndexSpec.isByID()) {
                toNode = this.getNodeByID(service, (Long)toKey);
            } else {
                Index<Node> toIndex = this.getToIndex(service);
                toNode = this.lookupNodeInIndex(toIndex, this.toIndexSpec.getFirstIndexPropertyName(), toKey);
            }
            Relationship relationship = fromNode.createRelationshipTo(toNode, new StringRelationshipType(relationshipLabel));
            if (this.tupleEntry.getFields().size() > 3) {
                for (int i = 3; i < this.tupleEntry.size(); ++i) {
                    String propertyName = (String)((Object)this.tupleEntry.getFields().get(i));
                    Object propertyValue = this.tupleEntry.getObject(i);
                    if (propertyValue == null) continue;
                    relationship.setProperty(RelationshipTuple.cleanPropertyName(propertyName), propertyValue);
                }
            }
        }
        catch (IndexLookupException e) {
            throw new RuntimeException(e);
        }
        catch (IndexDoesNotExistException e) {
            throw new RuntimeException(e);
        }
    }

    private Node getNodeByID(GraphDatabaseService service, Long id) {
        return service.getNodeById(id);
    }

    private Node lookupNodeInIndex(Index<Node> index, String indexPropertyName, Object objectValue) throws IndexLookupException {
        String cleanPropertyName = RelationshipTuple.cleanPropertyName(indexPropertyName);
        IndexHits nodes = index.get(cleanPropertyName, objectValue);
        if (nodes.size() == 0) {
            throw new IndexLookupException(index.getName(), cleanPropertyName, objectValue);
        }
        return (Node)nodes.getSingle();
    }

    private Index<Node> getToIndex(GraphDatabaseService service) throws IndexDoesNotExistException {
        return this.getNodeIndex(service, this.toIndexSpec.getNodeTypeName());
    }

    private Index<Node> getFromIndex(GraphDatabaseService service) throws IndexDoesNotExistException {
        return this.getNodeIndex(service, this.fromIndexSpec.getNodeTypeName());
    }

    private Index<Node> getNodeIndex(GraphDatabaseService service, String indexName) throws IndexDoesNotExistException {
        if (!service.index().existsForNodes(indexName)) {
            throw new IndexDoesNotExistException(indexName);
        }
        return service.index().forNodes(indexName);
    }

    public class IndexLookupException
    extends Exception {
        private final String indexName;
        private final String propertyName;
        private final Object propertyValue;

        public IndexLookupException(String indexName, String propertyName, Object propertyValue) {
            this.indexName = indexName;
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }

        public String getMessage() {
            return String.format("Couldn't lookup object in index \"%s\" identified by property \"%s\" with value \"%s\".", this.indexName, this.propertyName, this.propertyValue);
        }
    }

    public class IndexDoesNotExistException
    extends Exception {
        public IndexDoesNotExistException(String indexName) {
            super(String.format("No Node index named \"%s\" exists.", indexName));
        }
    }
}

