/*
 * Decompiled with CFR 0.152.
 */
package org.pingles.cascading.neo4j.hadoop;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.tap.Tap;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.pingles.cascading.neo4j.hadoop.Neo4jOutputFormat;
import org.pingles.cascading.neo4j.hadoop.Neo4jTapCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Neo4jTap
extends Tap<JobConf, RecordReader, OutputCollector> {
    private final String id = UUID.randomUUID().toString();
    private final String restConnectionString;

    public Neo4jTap(String restConnectionString, Scheme scheme) {
        super(scheme);
        this.restConnectionString = restConnectionString;
    }

    public String getIdentifier() {
        return this.restConnectionString + this.id;
    }

    public TupleEntryIterator openForRead(FlowProcess<JobConf> flowProcess, RecordReader recordReader) throws IOException {
        throw new UnsupportedOperationException("Only sinking supported");
    }

    public void sinkConfInit(FlowProcess<JobConf> flowProcess, JobConf conf) {
        Neo4jOutputFormat.setNeo4jConnectionString(conf, this.restConnectionString);
        super.sinkConfInit(flowProcess, (Object)conf);
    }

    public TupleEntryCollector openForWrite(FlowProcess<JobConf> flowProcess, OutputCollector outputCollector) throws IOException {
        Neo4jTapCollector collector = new Neo4jTapCollector(flowProcess, this);
        collector.prepare();
        return collector;
    }

    public boolean createResource(JobConf conf) throws IOException {
        return true;
    }

    public boolean deleteResource(JobConf conf) throws IOException {
        return true;
    }

    public boolean resourceExists(JobConf conf) throws IOException {
        return false;
    }

    public long getModifiedTime(JobConf conf) throws IOException {
        return System.currentTimeMillis();
    }

    public String toString() {
        return "Neo4jTap{" + this.restConnectionString + '}';
    }
}

