/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.traversal;

import java.util.Arrays;
import java.util.Iterator;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;

public class RelationshipPath
implements Path {
    private final Relationship relationship;

    public RelationshipPath(Relationship relationship) {
        this.relationship = relationship;
    }

    @Override
    public Node startNode() {
        return this.relationship.getStartNode();
    }

    @Override
    public Node endNode() {
        return this.relationship.getEndNode();
    }

    @Override
    public Relationship lastRelationship() {
        return this.relationship;
    }

    @Override
    public Iterable<Relationship> relationships() {
        return Arrays.asList(this.relationship);
    }

    @Override
    public Iterable<Node> nodes() {
        return Arrays.asList(this.startNode(), this.endNode());
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public Iterator<PropertyContainer> iterator() {
        return Arrays.asList(this.startNode(), this.lastRelationship(), this.endNode()).iterator();
    }

    @Override
    public Iterable<Relationship> reverseRelationships() {
        return this.relationships();
    }

    @Override
    public Iterable<Node> reverseNodes() {
        return Arrays.asList(this.endNode(), this.startNode());
    }
}

