/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.services;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.PathParam;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.services.RemoteInvocationStrategy;
import org.neo4j.rest.graphdb.services.RequestType;
import org.neo4j.server.plugins.Name;

public class PluginInvocation
implements RemoteInvocationStrategy {
    private RestAPI restAPI;
    private String baseUri;
    private Class targetClass;

    public PluginInvocation(RestAPI restAPI, Class targetClass) {
        this.restAPI = restAPI;
        this.targetClass = targetClass;
        this.baseUri = this.createBaseUri();
    }

    private String createBaseUri() {
        return "ext/" + this.targetClass.getSimpleName() + "/graphdb/";
    }

    @Override
    public RequestResult invoke(Method method, Object[] args) {
        String uri = this.baseUri + this.getUriSuffix(method);
        Map<String, Object> params = this.getRequestParams(method, args);
        return this.restAPI.execute(RequestType.POST, uri, params);
    }

    private String getUriSuffix(Method method) {
        String suffix = method.isAnnotationPresent(Name.class) ? method.getAnnotation(Name.class).value() : method.getName();
        return suffix;
    }

    private Map<String, Object> getRequestParams(Method method, Object[] args) {
        HashMap<String, Object> requestParams = new HashMap<String, Object>(args.length);
        Class<?>[] paramTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < paramTypes.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                if (!(annotation instanceof PathParam)) continue;
                PathParam pathParam = (PathParam)annotation;
                requestParams.put(pathParam.value(), args[i]);
            }
        }
        return requestParams;
    }
}

