/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.query;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.RestResultException;
import org.neo4j.rest.graphdb.converter.RestEntityExtractor;
import org.neo4j.rest.graphdb.converter.RestTableResultExtractor;
import org.neo4j.rest.graphdb.util.ConvertedResult;
import org.neo4j.rest.graphdb.util.Handler;
import org.neo4j.rest.graphdb.util.QueryResult;
import org.neo4j.rest.graphdb.util.QueryResultBuilder;
import org.neo4j.rest.graphdb.util.ResultConverter;

public class RestGremlinQueryResult<T>
implements QueryResult<T> {
    QueryResultBuilder<T> result;
    private final RestAPI restApi;

    @Override
    public <R> ConvertedResult<R> to(Class<R> type) {
        return this.result.to(type);
    }

    @Override
    public <R> ConvertedResult<R> to(Class<R> type, ResultConverter<T, R> converter) {
        return this.result.to(type, converter);
    }

    @Override
    public void handle(Handler<T> handler) {
        this.result.handle(handler);
    }

    @Override
    public Iterator<T> iterator() {
        return this.result.iterator();
    }

    public RestGremlinQueryResult(Object result, RestAPI restApi, ResultConverter resultConverter) {
        this.restApi = restApi;
        Iterable<T> convertedResult = this.convertRestResult(result);
        this.result = new QueryResultBuilder<T>(convertedResult, resultConverter);
    }

    private Iterable<T> convertRestResult(Object result) {
        final RestEntityExtractor restEntityExtractor = new RestEntityExtractor(this.restApi);
        if (result instanceof Map) {
            Map mapResult = (Map)result;
            if (RestResultException.isExceptionResult(mapResult)) {
                throw new RestResultException(mapResult);
            }
            if (RestGremlinQueryResult.isTableResult(mapResult)) {
                return new RestTableResultExtractor(restEntityExtractor).extract(mapResult);
            }
        }
        if (result instanceof Iterable) {
            return new IterableWrapper<T, Object>((Iterable)result){

                @Override
                protected T underlyingObjectToObject(Object value) {
                    return restEntityExtractor.convertFromRepresentation(value);
                }
            };
        }
        return Collections.singletonList(restEntityExtractor.convertFromRepresentation(result));
    }

    public static boolean isTableResult(Map<?, ?> mapResult) {
        return mapResult.containsKey("columns") && mapResult.containsKey("data");
    }
}

