/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.index;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.index.lucene.QueryContext;
import org.neo4j.rest.graphdb.ExecutingRestRequest;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.RestGraphDatabase;

public abstract class RestIndex<T extends PropertyContainer>
implements Index<T> {
    private final String indexName;
    protected final RestAPI restApi;

    public String getIndexName() {
        return this.indexName;
    }

    RestIndex(String indexName, RestAPI restApi) {
        this.indexName = indexName;
        this.restApi = restApi;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return new RestGraphDatabase(this.restApi);
    }

    private String getTypeName() {
        return this.getEntityType().getSimpleName().toLowerCase();
    }

    @Override
    public void add(T entity, String key, Object value) {
        this.restApi.addToIndex(entity, this, key, value);
    }

    @Override
    public T putIfAbsent(T entity, String key, Object value) {
        return this.restApi.putIfAbsent(entity, this, key, value);
    }

    public String indexPath() {
        return "index/" + this.getTypeName() + "/" + this.indexName;
    }

    public String indexPath(String key, Object value) {
        return "index/" + this.getTypeName() + "/" + this.indexName + (key != null ? "/" + ExecutingRestRequest.encode(key) : "") + (value != null ? "/" + ExecutingRestRequest.encode(value) : "");
    }

    private String queryPath(String key, Object value) {
        return this.indexPath(key, null) + "?query=" + ExecutingRestRequest.encode(value);
    }

    @Override
    public void remove(T entity, String key, Object value) {
        this.restApi.removeFromIndex(this, entity, key, value);
    }

    @Override
    public void remove(T entity, String key) {
        this.restApi.removeFromIndex(this, entity, key);
    }

    @Override
    public void remove(T entity) {
        this.restApi.removeFromIndex(this, entity);
    }

    @Override
    public void delete() {
        this.restApi.delete(this);
    }

    @Override
    public IndexHits<T> get(String key, Object value) {
        String indexPath = this.indexPath(key, value);
        return this.restApi.queryIndex(indexPath, this.getEntityType());
    }

    @Override
    public IndexHits<T> query(String key, Object value) {
        String indexPath = this.queryPath(key, value);
        return this.restApi.queryIndex(indexPath, this.getEntityType());
    }

    @Override
    public IndexHits<T> query(Object value) {
        if (value instanceof QueryContext) {
            value = ((QueryContext)value).getQueryOrQueryObject();
        }
        return this.query("null", value);
    }

    @Override
    public String getName() {
        return this.indexName;
    }

    public String uniqueIndexPath() {
        return this.indexPath() + "?unique";
    }
}

