/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.InputStream;
import java.util.Properties;

public class UserAgent {
    public static final String NEO4J_DRIVER_PROPERTY = "org.neo4j.rest.driver";
    private final String userAgent = this.determineUserAgent();

    private String determineUserAgent() {
        String property = System.getProperty(NEO4J_DRIVER_PROPERTY);
        if (property == null || property.trim().isEmpty()) {
            Properties props = this.loadPomProperties();
            return String.format("%s/%s", props.getProperty("artifactId", "neo4j-rest-graphdb"), props.getProperty("version", "0"));
        }
        return property;
    }

    private Properties loadPomProperties() {
        Properties props = new Properties();
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("/META-INF/maven/org.neo4j/neo4j-rest-graphdb/pom.properties");
            if (is != null) {
                props.load(is);
                is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props;
    }

    public void install(Client client) {
        client.addFilter(new ClientFilter(){

            @Override
            public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
                cr.getHeaders().add("User-Agent", UserAgent.this.userAgent);
                return this.getNext().handle(cr);
            }
        });
    }
}

