/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb;

import java.util.List;
import java.util.Map;

public class RestResultException
extends RuntimeException {
    public RestResultException(Object result) {
        super(RestResultException.format(RestResultException.toMap(result)));
    }

    private static String format(Map<?, ?> result) {
        if (result == null) {
            return "Unknown Exception";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(result.get("message")).append(" at\n");
        sb.append(result.get("exception")).append("\n");
        List stacktrace = (List)result.get("stacktrace");
        if (stacktrace != null) {
            for (String line : stacktrace) {
                sb.append("   ").append(line).append("\n");
            }
        }
        if (result.containsKey("body")) {
            sb.append(RestResultException.format(RestResultException.toMap(result.get("body"))));
        }
        return sb.toString();
    }

    public static boolean isExceptionResult(Object result) {
        Map<String, Object> map = RestResultException.toMap(result);
        return map != null && (RestResultException.hasErrorStatus(map) || map.containsKey("exception") || map.containsKey("message") || RestResultException.isExceptionResult(map.get("body")));
    }

    private static boolean hasErrorStatus(Map<String, Object> map) {
        Object status = map.get("status");
        return status != null && !status.toString().startsWith("2");
    }

    private static Map<String, Object> toMap(Object result) {
        if (!(result instanceof Map)) {
            return null;
        }
        return (Map)result;
    }
}

