/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb;

import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.rest.graphdb.BatchTransaction;
import org.neo4j.rest.graphdb.ExecutingRestAPI;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.batch.BatchCallback;
import org.neo4j.rest.graphdb.batch.BatchRestAPI;
import org.neo4j.rest.graphdb.converter.RestEntityExtractor;
import org.neo4j.rest.graphdb.entity.RestEntity;
import org.neo4j.rest.graphdb.entity.RestNode;
import org.neo4j.rest.graphdb.entity.RestRelationship;
import org.neo4j.rest.graphdb.index.IndexInfo;
import org.neo4j.rest.graphdb.index.RestIndex;
import org.neo4j.rest.graphdb.index.RestIndexManager;
import org.neo4j.rest.graphdb.services.RequestType;
import org.neo4j.rest.graphdb.transaction.NullTransaction;
import org.neo4j.rest.graphdb.traversal.RestTraverser;
import org.neo4j.rest.graphdb.util.Config;
import org.neo4j.rest.graphdb.util.QueryResult;
import org.neo4j.rest.graphdb.util.ResultConverter;

public class RestAPIFacade
implements RestAPI {
    private final ExecutingRestAPI direct;

    @Override
    public RestIndexManager index() {
        return new RestIndexManager(this);
    }

    @Override
    public RestNode getNodeById(long id) {
        return this.current().getNodeById(id);
    }

    @Override
    public RestRelationship getRelationshipById(long id) {
        return this.current().getRelationshipById(id);
    }

    @Override
    public RestNode createNode(Map<String, Object> props) {
        return this.current().createNode(props);
    }

    @Override
    public RestNode createRestNode(RequestResult requestResult) {
        return this.current().createRestNode(requestResult);
    }

    @Override
    public RestRelationship createRelationship(Node startNode, Node endNode, RelationshipType type, Map<String, Object> props) {
        return this.current().createRelationship(startNode, endNode, type, props);
    }

    private RestAPI current() {
        BatchRestAPI batchRestAPI = BatchTransaction.getRestApi();
        return batchRestAPI == null ? this.direct : batchRestAPI;
    }

    @Override
    public RestRelationship createRestRelationship(RequestResult requestResult, PropertyContainer element) {
        return this.current().createRestRelationship(requestResult, element);
    }

    @Override
    public <T extends PropertyContainer> RestIndex<T> getIndex(String indexName) {
        return this.current().getIndex(indexName);
    }

    @Override
    public void createIndex(String type, String indexName, Map<String, String> config) {
        this.direct.createIndex(type, indexName, config);
    }

    @Override
    public TraversalDescription createTraversalDescription() {
        return this.current().createTraversalDescription();
    }

    @Override
    public Node getReferenceNode() {
        return this.current().getReferenceNode();
    }

    @Override
    public Transaction beginTx() {
        if (Config.useBatchTransactions()) {
            return BatchTransaction.begin(this);
        }
        return new NullTransaction();
    }

    @Override
    public <S extends PropertyContainer> IndexHits<S> queryIndex(String indexPath, Class<S> entityType) {
        return this.current().queryIndex(indexPath, entityType);
    }

    @Override
    public void deleteEntity(RestEntity entity) {
        this.current().deleteEntity(entity);
    }

    @Override
    public IndexInfo indexInfo(String indexType) {
        return this.direct.indexInfo(indexType);
    }

    @Override
    public void setPropertyOnEntity(RestEntity entity, String key, Object value) {
        this.current().setPropertyOnEntity(entity, key, value);
    }

    @Override
    public Map<String, Object> getPropertiesFromEntity(RestEntity entity) {
        return this.current().getPropertiesFromEntity(entity);
    }

    @Override
    public void delete(RestIndex index) {
        this.current().delete(index);
    }

    @Override
    public <T extends PropertyContainer> void removeFromIndex(RestIndex index, T entity, String key, Object value) {
        this.current().removeFromIndex(index, entity, key, value);
    }

    @Override
    public <T extends PropertyContainer> void removeFromIndex(RestIndex index, T entity, String key) {
        this.current().removeFromIndex(index, entity, key);
    }

    @Override
    public <T extends PropertyContainer> void removeFromIndex(RestIndex index, T entity) {
        this.current().removeFromIndex(index, entity);
    }

    @Override
    public <T extends PropertyContainer> void addToIndex(T entity, RestIndex index, String key, Object value) {
        this.current().addToIndex(entity, index, key, value);
    }

    @Override
    public <T extends PropertyContainer> T putIfAbsent(T entity, RestIndex index, String key, Object value) {
        return this.current().putIfAbsent(entity, index, key, value);
    }

    @Override
    public Map<?, ?> getData(RestEntity uri) {
        return this.current().getData(uri);
    }

    @Override
    public boolean hasToUpdate(long lastUpdate) {
        return this.current().hasToUpdate(lastUpdate);
    }

    @Override
    public void removeProperty(RestEntity entity, String key) {
        this.current().removeProperty(entity, key);
    }

    @Override
    public Map<?, ?> query(String statement, Map<String, Object> params) {
        return this.current().query(statement, params);
    }

    @Override
    public Iterable<Relationship> getRelationships(RestNode restNode, String path) {
        return this.current().getRelationships(restNode, path);
    }

    @Override
    public RestTraverser traverse(RestNode restNode, Map<String, Object> description) {
        return this.current().traverse(restNode, description);
    }

    @Override
    public String getBaseUri() {
        return this.current().getBaseUri();
    }

    @Override
    public <T> T getPlugin(Class<T> pluginType) {
        return this.current().getPlugin(pluginType);
    }

    @Override
    public <T> T getService(Class<T> type, String baseUri) {
        return this.current().getService(type, baseUri);
    }

    @Override
    public RestNode getOrCreateNode(RestIndex<Node> index, String key, Object value, Map<String, Object> properties) {
        return this.current().getOrCreateNode(index, key, value, properties);
    }

    @Override
    public RestRelationship getOrCreateRelationship(RestIndex<Relationship> index, String key, Object value, RestNode start, RestNode end, String type, Map<String, Object> properties) {
        return this.current().getOrCreateRelationship(index, key, value, start, end, type, properties);
    }

    @Override
    public QueryResult<Map<String, Object>> query(String statement, Map<String, Object> params, ResultConverter resultConverter) {
        return this.current().query(statement, params, resultConverter);
    }

    @Override
    public QueryResult<Object> run(String statement, Map<String, Object> params, ResultConverter resultConverter) {
        return this.current().run(statement, params, resultConverter);
    }

    @Override
    public RestEntityExtractor createExtractor() {
        return this.current().createExtractor();
    }

    @Override
    public <T extends PropertyContainer> RestIndex<T> createIndex(Class<T> type, String indexName, Map<String, String> config) {
        return this.current().createIndex(type, indexName, config);
    }

    @Override
    public RequestResult execute(RequestType requestType, String uri, Object params) {
        return this.current().execute(requestType, uri, params);
    }

    @Override
    public void close() {
        BatchTransaction.shutdown();
    }

    @Override
    public boolean isAutoIndexingEnabled(Class<? extends PropertyContainer> clazz) {
        return this.current().isAutoIndexingEnabled(clazz);
    }

    @Override
    public void setAutoIndexingEnabled(Class<? extends PropertyContainer> clazz, boolean enabled) {
        this.current().setAutoIndexingEnabled(clazz, enabled);
    }

    @Override
    public Set<String> getAutoIndexedProperties(Class forClass) {
        return this.current().getAutoIndexedProperties(forClass);
    }

    @Override
    public void startAutoIndexingProperty(Class forClass, String s) {
        this.current().startAutoIndexingProperty(forClass, s);
    }

    @Override
    public void stopAutoIndexingProperty(Class forClass, String s) {
        this.current().stopAutoIndexingProperty(forClass, s);
    }

    private RestAPIFacade(ExecutingRestAPI direct) {
        this.direct = direct;
    }

    public RestAPIFacade(String uri) {
        this.direct = new ExecutingRestAPI(uri, this);
    }

    public RestAPIFacade(String uri, String user, String password) {
        this.direct = new ExecutingRestAPI(uri, user, password, this);
    }

    public ExecutingRestAPI getDirect() {
        return this.direct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeBatch(BatchCallback<T> batchCallback) {
        BatchTransaction transaction = BatchTransaction.begin(this);
        try {
            T batchResult = batchCallback.recordBatch(this);
            transaction.success();
            T t = batchResult;
            return t;
        }
        finally {
            transaction.finish();
        }
    }
}

