/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb;

import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.rest.graphdb.batch.BatchCallback;
import org.neo4j.rest.graphdb.converter.RestEntityExtractor;
import org.neo4j.rest.graphdb.entity.RestEntity;
import org.neo4j.rest.graphdb.entity.RestNode;
import org.neo4j.rest.graphdb.entity.RestRelationship;
import org.neo4j.rest.graphdb.index.IndexInfo;
import org.neo4j.rest.graphdb.index.RestIndex;
import org.neo4j.rest.graphdb.index.RestIndexManager;
import org.neo4j.rest.graphdb.services.RequestType;
import org.neo4j.rest.graphdb.traversal.RestTraverser;
import org.neo4j.rest.graphdb.util.QueryResult;
import org.neo4j.rest.graphdb.util.ResultConverter;

public interface RestAPI {
    public RestIndexManager index();

    public RestNode getNodeById(long var1);

    public RestRelationship getRelationshipById(long var1);

    public RestNode createNode(Map<String, Object> var1);

    public RestNode createRestNode(RequestResult var1);

    public RestRelationship createRelationship(Node var1, Node var2, RelationshipType var3, Map<String, Object> var4);

    public RestRelationship createRestRelationship(RequestResult var1, PropertyContainer var2);

    public <T extends PropertyContainer> RestIndex<T> getIndex(String var1);

    public void createIndex(String var1, String var2, Map<String, String> var3);

    public TraversalDescription createTraversalDescription();

    public Node getReferenceNode();

    public Transaction beginTx();

    public <S extends PropertyContainer> IndexHits<S> queryIndex(String var1, Class<S> var2);

    public void deleteEntity(RestEntity var1);

    public IndexInfo indexInfo(String var1);

    public void setPropertyOnEntity(RestEntity var1, String var2, Object var3);

    public Map<String, Object> getPropertiesFromEntity(RestEntity var1);

    public void delete(RestIndex var1);

    public <T extends PropertyContainer> void removeFromIndex(RestIndex var1, T var2, String var3, Object var4);

    public <T extends PropertyContainer> void removeFromIndex(RestIndex var1, T var2, String var3);

    public <T extends PropertyContainer> void removeFromIndex(RestIndex var1, T var2);

    public <T extends PropertyContainer> void addToIndex(T var1, RestIndex var2, String var3, Object var4);

    public <T extends PropertyContainer> T putIfAbsent(T var1, RestIndex var2, String var3, Object var4);

    public Map<?, ?> getData(RestEntity var1);

    public boolean hasToUpdate(long var1);

    public void removeProperty(RestEntity var1, String var2);

    public Map<?, ?> query(String var1, Map<String, Object> var2);

    public Iterable<Relationship> getRelationships(RestNode var1, String var2);

    public RestTraverser traverse(RestNode var1, Map<String, Object> var2);

    public String getBaseUri();

    public <T> T getPlugin(Class<T> var1);

    public <T> T getService(Class<T> var1, String var2);

    public <T> T executeBatch(BatchCallback<T> var1);

    public RestNode getOrCreateNode(RestIndex<Node> var1, String var2, Object var3, Map<String, Object> var4);

    public RestRelationship getOrCreateRelationship(RestIndex<Relationship> var1, String var2, Object var3, RestNode var4, RestNode var5, String var6, Map<String, Object> var7);

    public QueryResult<Map<String, Object>> query(String var1, Map<String, Object> var2, ResultConverter var3);

    public QueryResult<Object> run(String var1, Map<String, Object> var2, ResultConverter var3);

    public RestEntityExtractor createExtractor();

    public <T extends PropertyContainer> RestIndex<T> createIndex(Class<T> var1, String var2, Map<String, String> var3);

    public RequestResult execute(RequestType var1, String var2, Object var3);

    public void close();

    public boolean isAutoIndexingEnabled(Class<? extends PropertyContainer> var1);

    public void setAutoIndexingEnabled(Class<? extends PropertyContainer> var1, boolean var2);

    public Set<String> getAutoIndexedProperties(Class var1);

    public void startAutoIndexingProperty(Class var1, String var2);

    public void stopAutoIndexingProperty(Class var1, String var2);
}

