/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.rest.graphdb.RestRequest;
import org.neo4j.rest.graphdb.UserAgent;
import org.neo4j.rest.graphdb.util.Config;
import org.neo4j.rest.graphdb.util.JsonHelper;
import org.neo4j.rest.graphdb.util.StreamJsonHelper;

public class ExecutingRestRequest
implements RestRequest {
    public static final MediaType STREAMING_JSON_TYPE = new MediaType(MediaType.APPLICATION_JSON_TYPE.getType(), MediaType.APPLICATION_JSON_TYPE.getSubtype(), MapUtil.stringMap("stream", "true"));
    private final String baseUri;
    private final UserAgent userAgent = new UserAgent();
    private final Client client;

    public ExecutingRestRequest(String baseUri) {
        this(baseUri, null, null);
    }

    public ExecutingRestRequest(String baseUri, String username, String password) {
        this.baseUri = this.uriWithoutSlash(baseUri);
        this.client = this.createClient();
        this.addAuthFilter(username, password);
    }

    protected void addAuthFilter(String username, String password) {
        if (username == null) {
            return;
        }
        this.client.addFilter(new HTTPBasicAuthFilter(username, password));
    }

    protected Client createClient() {
        Client client = Client.create();
        client.setConnectTimeout(Config.getConnectTimeout());
        client.setReadTimeout(Config.getReadTimeout());
        client.setChunkedEncodingSize(8192);
        this.userAgent.install(client);
        if (Config.useLoggingFilter()) {
            client.addFilter(new LoggingFilter());
        }
        return client;
    }

    private ExecutingRestRequest(String uri, Client client) {
        this.baseUri = this.uriWithoutSlash(uri);
        this.client = client;
    }

    protected String uriWithoutSlash(String uri) {
        return uri.endsWith("/") ? uri.substring(0, uri.length() - 1) : uri;
    }

    public static String encode(Object value) {
        if (value == null) {
            return "";
        }
        try {
            return URLEncoder.encode(value.toString(), "utf-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private WebResource.Builder builder(String path) {
        WebResource resource = this.client.resource(this.uri(this.pathOrAbsolute(path)));
        if (Config.streamingIsEnabled()) {
            return (WebResource.Builder)resource.accept(STREAMING_JSON_TYPE).header("X-Stream", "true");
        }
        return resource.accept(MediaType.APPLICATION_JSON_TYPE);
    }

    private String pathOrAbsolute(String path) {
        if (path.startsWith("http://")) {
            return path;
        }
        return this.baseUri + "/" + path;
    }

    @Override
    public RequestResult get(String path) {
        return RequestResult.extractFrom(this.builder(path).get(ClientResponse.class));
    }

    @Override
    public RequestResult get(String path, Object data) {
        WebResource.Builder builder = this.builder(path);
        if (data != null) {
            builder = (WebResource.Builder)builder.entity((Object)JsonHelper.createJsonFrom(data), MediaType.APPLICATION_JSON_TYPE);
        }
        return RequestResult.extractFrom(builder.get(ClientResponse.class));
    }

    @Override
    public RequestResult delete(String path) {
        return RequestResult.extractFrom(this.builder(path).delete(ClientResponse.class));
    }

    @Override
    public RequestResult post(String path, Object data) {
        WebResource.Builder builder = this.builder(path);
        if (data != null) {
            builder = (WebResource.Builder)builder.entity((Object)this.toInputStream(data), MediaType.APPLICATION_JSON_TYPE);
        }
        return RequestResult.extractFrom(builder.post(ClientResponse.class));
    }

    private InputStream toInputStream(Object data) {
        try {
            if (data instanceof InputStream) {
                return (InputStream)data;
            }
            PipedInputStream inputStream = new PipedInputStream(8192);
            PipedOutputStream outputStream = new PipedOutputStream(inputStream);
            StreamJsonHelper.writeJsonTo(data, outputStream);
            return inputStream;
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing " + data + " to stream", e);
        }
    }

    @Override
    public RequestResult put(String path, Object data) {
        WebResource.Builder builder = this.builder(path);
        if (data != null) {
            builder = (WebResource.Builder)builder.entity((Object)JsonHelper.createJsonFrom(data), MediaType.APPLICATION_JSON_TYPE);
        }
        return RequestResult.extractFrom(builder.put(ClientResponse.class));
    }

    @Override
    public RestRequest with(String uri) {
        return new ExecutingRestRequest(uri, this.client);
    }

    private URI uri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getUri() {
        return this.baseUri;
    }

    @Override
    public Map<?, ?> toMap(RequestResult requestResult) {
        return requestResult.toMap();
    }
}

