/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.neo4j.rest.graphdb.BatchTransaction;
import org.neo4j.rest.graphdb.RestAPI;

public class BatchTransactionManager
implements TransactionManager,
Transaction {
    private final RestAPI restAPI;

    public BatchTransactionManager(RestAPI restAPI) {
        this.restAPI = restAPI;
    }

    @Override
    public void begin() throws NotSupportedException, SystemException {
        this.restAPI.beginTx();
    }

    @Override
    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        BatchTransaction current = BatchTransaction.current();
        if (current == null) {
            throw new IllegalStateException("Not in transaction");
        }
        current.success();
        current.finish();
    }

    @Override
    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean enlistResource(XAResource xaRes) throws IllegalStateException, RollbackException, SystemException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getStatus() throws SystemException {
        BatchTransaction current = BatchTransaction.current();
        if (current == null) {
            return 0;
        }
        return 0;
    }

    @Override
    public void registerSynchronization(Synchronization synch) throws IllegalStateException, RollbackException, SystemException {
    }

    @Override
    public Transaction getTransaction() throws SystemException {
        return this;
    }

    @Override
    public void resume(Transaction tobj) throws IllegalStateException, InvalidTransactionException, SystemException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        BatchTransaction current = BatchTransaction.current();
        if (current == null) {
            throw new IllegalStateException("Not in transaction");
        }
        current.failure();
        current.finish();
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        BatchTransaction current = BatchTransaction.current();
        if (current == null) {
            throw new IllegalStateException("Not in transaction");
        }
        current.failure();
    }

    @Override
    public void setTransactionTimeout(int seconds) throws SystemException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Transaction suspend() throws SystemException {
        throw new UnsupportedOperationException();
    }
}

