/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb;

import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.rest.graphdb.RestAPIFacade;
import org.neo4j.rest.graphdb.batch.BatchRestAPI;

public class BatchTransaction
implements Transaction {
    private static ThreadLocal<BatchTransaction> current = new ThreadLocal();
    private final BatchRestAPI batchRestAPI;
    private Boolean success = null;
    private int depth = 1;

    public static BatchRestAPI getRestApi() {
        BatchTransaction currentTx = current.get();
        if (currentTx != null) {
            return currentTx.batchRestAPI;
        }
        return null;
    }

    public static BatchTransaction current() {
        return current.get();
    }

    BatchTransaction(RestAPIFacade restAPI) {
        if (current.get() != null) {
            throw new IllegalStateException("Transaction already in progress!");
        }
        this.batchRestAPI = BatchTransaction.createBatchRestAPI(restAPI);
        current.set(this);
    }

    @Override
    public void failure() {
        this.success = false;
    }

    @Override
    public void success() {
        if (this.success == null) {
            this.success = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        block6: {
            --this.depth;
            if (this.depth > 0) {
                return;
            }
            if (this.depth < 0) {
                throw new IllegalStateException("transaction already finished");
            }
            try {
                if (this.success == null || !this.success.booleanValue()) break block6;
                BatchTransaction currentTx = current.get();
                if (currentTx != null) {
                    current.remove();
                    currentTx.batchRestAPI.executeBatchRequest();
                    break block6;
                }
                throw new IllegalStateException("Not in Transaction/BatchOperation");
            }
            finally {
                current.remove();
            }
        }
    }

    @Override
    public Lock acquireWriteLock(PropertyContainer propertyContainer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Lock acquireReadLock(PropertyContainer propertyContainer) {
        throw new UnsupportedOperationException();
    }

    public static synchronized BatchTransaction begin(RestAPIFacade facade) {
        BatchTransaction batchTransaction = current.get();
        if (batchTransaction != null) {
            ++batchTransaction.depth;
            return batchTransaction;
        }
        BatchTransaction transaction = new BatchTransaction(facade);
        current.set(transaction);
        return transaction;
    }

    private static BatchRestAPI createBatchRestAPI(RestAPIFacade facade) {
        return new BatchRestAPI(facade.getBaseUri(), facade);
    }

    public static void shutdown() {
        current.remove();
        current = new ThreadLocal();
    }
}

