/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.info;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.neo4j.kernel.info.LockingTransaction;
import org.neo4j.kernel.info.ResourceType;
import org.neo4j.kernel.info.WaitingThread;

public final class LockInfo {
    private final String resource;
    private final ResourceType type;
    private final int readCount;
    private final int writeCount;
    private final List<WaitingThread> waitingThreads;
    private final LockingTransaction[] lockingTxs;

    @ConstructorProperties(value={"resourceType", "resourceId", "readCount", "writeCount", "lockingTransactions", "waitingThreads"})
    public LockInfo(ResourceType type, String resourceId, int readCount, int writeCount, List<LockingTransaction> locking, List<WaitingThread> waiting) {
        this.type = type;
        this.resource = resourceId;
        this.readCount = readCount;
        this.writeCount = writeCount;
        this.lockingTxs = locking.toArray(new LockingTransaction[locking.size()]);
        this.waitingThreads = new ArrayList<WaitingThread>(waiting);
    }

    public LockInfo(ResourceType type, String resourceId, int readCount, int writeCount, Collection<LockingTransaction> locking) {
        this.type = type;
        this.resource = resourceId;
        this.readCount = readCount;
        this.writeCount = writeCount;
        this.waitingThreads = new ArrayList<WaitingThread>();
        for (LockingTransaction tx : this.lockingTxs = locking.toArray(new LockingTransaction[locking.size()])) {
            if (!(tx instanceof WaitingThread)) continue;
            this.waitingThreads.add((WaitingThread)tx);
        }
    }

    public String toString() {
        return this.type.toString(this.resource) + "{readCount=" + this.readCount + ", writeCount=" + this.writeCount + "}";
    }

    public ResourceType getResourceType() {
        return this.type;
    }

    public String getResourceId() {
        return this.resource;
    }

    public int getWriteCount() {
        return this.writeCount;
    }

    public int getReadCount() {
        return this.readCount;
    }

    public int getWaitingThreadsCount() {
        return this.waitingThreads.size();
    }

    public List<WaitingThread> getWaitingThreads() {
        return Collections.unmodifiableList(this.waitingThreads);
    }

    public List<LockingTransaction> getLockingTransactions() {
        return Collections.unmodifiableList(Arrays.asList(this.lockingTxs));
    }
}

