/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import org.neo4j.kernel.impl.nioneo.store.Abstract64BitRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;

public class DynamicRecord
extends Abstract64BitRecord {
    private static final int MAX_BYTES_IN_TO_STRING = 8;
    private static final int MAX_CHARS_IN_TO_STRING = 16;
    private byte[] data = null;
    private int length;
    private long nextBlock = Record.NO_NEXT_BLOCK.intValue();
    private boolean isLight = true;
    private int type;

    public DynamicRecord(long id) {
        super(id);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    void setIsLight(boolean status) {
        this.isLight = status;
    }

    public boolean isLight() {
        return this.isLight;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public void setInUse(boolean inUse) {
        super.setInUse(inUse);
        if (!inUse) {
            this.data = null;
        }
    }

    public void setInUse(boolean inUse, int type) {
        this.type = type;
        this.setInUse(inUse);
    }

    public void setData(byte[] data) {
        this.isLight = false;
        this.length = data.length;
        this.data = data;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getData() {
        return this.data;
    }

    public long getNextBlock() {
        return this.nextBlock;
    }

    public void setNextBlock(long nextBlock) {
        this.nextBlock = nextBlock;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("DynamicRecord[").append(this.getId()).append(",used=").append(this.inUse()).append(",").append("light=").append(this.isLight).append("(").append(this.length).append("),type=");
        PropertyType type = PropertyType.getPropertyType(this.type << 24, true);
        if (type == null) {
            buf.append(this.type);
        } else {
            buf.append(type.name());
        }
        buf.append(",data=");
        if (this.data != null) {
            if (type == PropertyType.STRING && this.data.length <= 16) {
                buf.append('\"');
                buf.append(PropertyStore.getStringFor(this.data));
                buf.append("\",");
            } else {
                buf.append("byte[");
                if (this.data.length <= 8) {
                    for (int i = 0; i < this.data.length; ++i) {
                        if (i != 0) {
                            buf.append(',');
                        }
                        buf.append(this.data[i]);
                    }
                } else {
                    buf.append("size=").append(this.data.length);
                }
                buf.append("],");
            }
        } else {
            buf.append("null,");
        }
        buf.append("next=").append(this.nextBlock).append("]");
        return buf.toString();
    }
}

