/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.ShortArray;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.kernel.impl.util.StringLogger;

public class DynamicArrayStore
extends AbstractDynamicStore {
    static final int NUMBER_HEADER_SIZE = 3;
    static final int STRING_HEADER_SIZE = 5;
    public static final String VERSION = "ArrayPropertyStore v0.A.0";
    public static final String TYPE_DESCRIPTOR = "ArrayPropertyStore";

    public DynamicArrayStore(String fileName, Config configuration, IdType idType, IdGeneratorFactory idGeneratorFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger) {
        super(fileName, configuration, idType, idGeneratorFactory, fileSystemAbstraction, stringLogger);
    }

    @Override
    public void accept(RecordStore.Processor processor, DynamicRecord record) {
        processor.processArray(this, record);
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    private Collection<DynamicRecord> allocateFromNumbers(long startBlock, Object array) {
        Class<?> componentType = array.getClass().getComponentType();
        boolean isPrimitiveByteArray = componentType.equals(Byte.TYPE);
        boolean isByteArray = componentType.equals(Byte.class) || isPrimitiveByteArray;
        byte[] bytes = null;
        ShortArray type = ShortArray.typeOf(array);
        if (type == null) {
            throw new IllegalArgumentException(array + " not a valid array type.");
        }
        int arrayLength = Array.getLength(array);
        int requiredBits = isByteArray ? 8 : type.calculateRequiredBitsForArray(array, arrayLength);
        int totalBits = requiredBits * arrayLength;
        int numberOfBytes = (totalBits - 1) / 8 + 1;
        int bitsUsedInLastByte = totalBits % 8;
        bitsUsedInLastByte = bitsUsedInLastByte == 0 ? 8 : bitsUsedInLastByte;
        numberOfBytes += 3;
        int length = arrayLength;
        if (isByteArray) {
            bytes = new byte[3 + length];
            bytes[0] = (byte)type.intValue();
            bytes[1] = (byte)bitsUsedInLastByte;
            bytes[2] = (byte)requiredBits;
            if (isPrimitiveByteArray) {
                System.arraycopy((byte[])array, 0, bytes, 3, length);
            } else {
                Byte[] source = (Byte[])array;
                for (int i = 0; i < source.length; ++i) {
                    bytes[3 + i] = source[i];
                }
            }
        } else {
            Bits bits = Bits.bits(numberOfBytes);
            bits.put((byte)type.intValue());
            bits.put((byte)bitsUsedInLastByte);
            bits.put((byte)requiredBits);
            type.writeAll(array, length, requiredBits, bits);
            bytes = bits.asBytes();
        }
        return this.allocateRecords(startBlock, bytes);
    }

    private Collection<DynamicRecord> allocateFromString(long startBlock, String[] array) {
        ArrayList<byte[]> stringsAsBytes = new ArrayList<byte[]>();
        int totalBytesRequired = 5;
        for (String string : array) {
            byte[] bytes = PropertyStore.encodeString(string);
            stringsAsBytes.add(bytes);
            totalBytesRequired += 4 + bytes.length;
        }
        ByteBuffer buf = ByteBuffer.allocate(totalBytesRequired);
        buf.put(PropertyType.STRING.byteValue());
        buf.putInt(array.length);
        for (byte[] stringAsBytes : stringsAsBytes) {
            buf.putInt(stringAsBytes.length);
            buf.put(stringAsBytes);
        }
        return this.allocateRecords(startBlock, buf.array());
    }

    public Collection<DynamicRecord> allocateRecords(long startBlock, Object array) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException(array + " not an array");
        }
        Class<?> type = array.getClass().getComponentType();
        if (type.equals(String.class)) {
            return this.allocateFromString(startBlock, (String[])array);
        }
        return this.allocateFromNumbers(startBlock, array);
    }

    public Object getRightArray(Pair<byte[], byte[]> data) {
        byte[] header = data.first();
        byte[] bArray = data.other();
        byte typeId = header[0];
        if (typeId == PropertyType.STRING.intValue()) {
            ByteBuffer headerBuffer = ByteBuffer.wrap(header, 1, header.length - 1);
            int arrayLength = headerBuffer.getInt();
            String[] result = new String[arrayLength];
            ByteBuffer dataBuffer = ByteBuffer.wrap(bArray);
            for (int i = 0; i < arrayLength; ++i) {
                int byteLength = dataBuffer.getInt();
                byte[] stringByteArray = new byte[byteLength];
                dataBuffer.get(stringByteArray);
                result[i] = (String)PropertyStore.getStringFor(stringByteArray);
            }
            return result;
        }
        ShortArray type = ShortArray.typeOf(typeId);
        byte bitsUsedInLastByte = header[1];
        byte requiredBits = header[2];
        if (requiredBits == 0) {
            return type.createEmptyArray();
        }
        Object result = null;
        if (type == ShortArray.BYTE && requiredBits == 8) {
            result = bArray;
        } else {
            Bits bits = Bits.bitsFromBytes(bArray);
            int length = (bArray.length * 8 - (8 - bitsUsedInLastByte)) / requiredBits;
            result = type.createArray(length, bits, requiredBits);
        }
        return result;
    }

    public static abstract class Configuration
    extends AbstractDynamicStore.Configuration {
    }
}

