/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Expander;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.kernel.Traversal;

public class PathDescription {
    private final List<Expander> steps;

    public PathDescription() {
        this(new ArrayList<Expander>());
    }

    private PathDescription(List<Expander> steps) {
        this.steps = steps;
    }

    public PathDescription step(RelationshipType type) {
        return this.step(Traversal.expanderForTypes(type));
    }

    public PathDescription step(RelationshipType type, Direction direction) {
        return this.step(Traversal.expanderForTypes(type, direction));
    }

    public PathDescription step(Expander expander) {
        ArrayList<Expander> newSteps = new ArrayList<Expander>(this.steps);
        newSteps.add(expander);
        return new PathDescription(newSteps);
    }

    public PathExpander build() {
        return new CrudeAggregatedExpander(this.steps);
    }

    private static class CrudeAggregatedExpander
    implements PathExpander {
        private final List<Expander> steps;

        CrudeAggregatedExpander(List<Expander> steps) {
            this.steps = steps;
        }

        public Iterable<Relationship> expand(Path path, BranchState state) {
            Expander expansion;
            try {
                expansion = this.steps.get(path.length());
            }
            catch (IndexOutOfBoundsException e) {
                return Collections.emptyList();
            }
            return expansion.expand(path.endNode());
        }

        public PathExpander reverse() {
            ArrayList<Expander> reversedSteps = new ArrayList<Expander>();
            for (Expander step : this.steps) {
                reversedSteps.add(step.reversed());
            }
            Collections.reverse(reversedSteps);
            return new CrudeAggregatedExpander(reversedSteps);
        }
    }
}

