/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.neo4j.index.impl.lucene.LuceneUtil;

public class QueryContext {
    private final Object queryOrQueryObject;
    private Sort sorting;
    private QueryParser.Operator defaultOperator;
    private boolean tradeCorrectnessForSpeed;
    private int topHits;

    public QueryContext(Object queryOrQueryObject) {
        this.queryOrQueryObject = queryOrQueryObject;
    }

    public Object getQueryOrQueryObject() {
        return this.queryOrQueryObject;
    }

    public QueryContext sort(Sort sorting) {
        this.sorting = sorting;
        return this;
    }

    public QueryContext sort(String key, String ... additionalKeys) {
        SortField firstSortField = new SortField(key, 3);
        if (additionalKeys.length == 0) {
            return this.sort(new Sort(firstSortField));
        }
        SortField[] sortFields = new SortField[1 + additionalKeys.length];
        sortFields[0] = firstSortField;
        for (int i = 0; i < additionalKeys.length; ++i) {
            sortFields[1 + i] = new SortField(additionalKeys[i], 3);
        }
        return this.sort(new Sort(sortFields));
    }

    public QueryContext sortByScore() {
        return this.sort(Sort.RELEVANCE);
    }

    public QueryContext sortNumeric(String key, boolean reversed) {
        if (!(this.queryOrQueryObject instanceof NumericRangeQuery)) {
            throw new IllegalStateException("Not a numeric range query");
        }
        Object number = ((NumericRangeQuery)this.queryOrQueryObject).getMin();
        number = number != null ? number : ((NumericRangeQuery)this.queryOrQueryObject).getMax();
        int fieldType = 4;
        if (number instanceof Long) {
            fieldType = 6;
        } else if (number instanceof Float) {
            fieldType = 5;
        } else if (number instanceof Double) {
            fieldType = 7;
        }
        this.sort(new Sort(new SortField(key, fieldType, reversed)));
        return this;
    }

    public Sort getSorting() {
        return this.sorting;
    }

    public QueryContext defaultOperator(QueryParser.Operator defaultOperator) {
        this.defaultOperator = defaultOperator;
        return this;
    }

    public QueryParser.Operator getDefaultOperator() {
        return this.defaultOperator;
    }

    public QueryContext tradeCorrectnessForSpeed() {
        this.tradeCorrectnessForSpeed = true;
        return this;
    }

    public boolean getTradeCorrectnessForSpeed() {
        return this.tradeCorrectnessForSpeed;
    }

    public QueryContext top(int numberOfTopHits) {
        this.topHits = numberOfTopHits;
        return this;
    }

    public int getTop() {
        return this.topHits;
    }

    public static QueryContext numericRange(String key, Number from, Number to) {
        return QueryContext.numericRange(key, from, to, true, true);
    }

    public static QueryContext numericRange(String key, Number from, Number to, boolean includeFrom, boolean includeTo) {
        return new QueryContext(LuceneUtil.rangeQuery(key, from, to, includeFrom, includeTo));
    }
}

