/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.graphdb.index.IndexProvider;
import org.neo4j.index.impl.lucene.ConnectionBroker;
import org.neo4j.index.impl.lucene.LuceneDataSource;
import org.neo4j.index.impl.lucene.LuceneIndexImplementation;
import org.neo4j.index.impl.lucene.LuceneXaConnection;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.IndexStore;
import org.neo4j.kernel.impl.index.ReadOnlyIndexConnectionBroker;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;

public class LuceneIndexProvider
extends IndexProvider {
    private static List<WeakReference<LuceneIndexImplementation>> previousProviders = new ArrayList<WeakReference<LuceneIndexImplementation>>();

    public LuceneIndexProvider() {
        super("lucene");
    }

    @Override
    public IndexImplementation load(DependencyResolver dependencyResolver) {
        Config config = dependencyResolver.resolveDependency(Config.class);
        InternalAbstractGraphDatabase gdb = dependencyResolver.resolveDependency(InternalAbstractGraphDatabase.class);
        TransactionManager txManager = dependencyResolver.resolveDependency(TransactionManager.class);
        IndexStore indexStore = dependencyResolver.resolveDependency(IndexStore.class);
        XaFactory xaFactory = dependencyResolver.resolveDependency(XaFactory.class);
        FileSystemAbstraction fileSystemAbstraction = dependencyResolver.resolveDependency(FileSystemAbstraction.class);
        XaDataSourceManager xaDataSourceManager = dependencyResolver.resolveDependency(XaDataSourceManager.class);
        LuceneDataSource luceneDataSource = new LuceneDataSource(config, indexStore, fileSystemAbstraction, xaFactory);
        xaDataSourceManager.registerDataSource(luceneDataSource);
        ReadOnlyIndexConnectionBroker<LuceneXaConnection> broker = config.get(Configuration.read_only) != false ? new ReadOnlyIndexConnectionBroker(txManager) : new ConnectionBroker(txManager, luceneDataSource);
        Iterator<WeakReference<LuceneIndexImplementation>> iterator = previousProviders.iterator();
        while (iterator.hasNext()) {
            WeakReference<LuceneIndexImplementation> previousProvider = iterator.next();
            LuceneIndexImplementation indexImplementation = (LuceneIndexImplementation)previousProvider.get();
            if (indexImplementation == null) {
                iterator.remove();
                continue;
            }
            if (!indexImplementation.matches(gdb)) continue;
            indexImplementation.reset(luceneDataSource, broker);
        }
        LuceneIndexImplementation indexImplementation = new LuceneIndexImplementation(gdb, luceneDataSource, broker);
        previousProviders.add(new WeakReference<LuceneIndexImplementation>(indexImplementation));
        return indexImplementation;
    }

    public static abstract class Configuration {
        public static final GraphDatabaseSetting<Boolean> read_only = GraphDatabaseSettings.read_only;
    }
}

