/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;

public abstract class LuceneUtil {
    static void close(IndexWriter writer) {
        LuceneUtil.close((Object)writer);
    }

    static void close(IndexSearcher searcher) {
        LuceneUtil.close((Object)searcher);
    }

    private static void close(Object object) {
        if (object == null) {
            return;
        }
        try {
            if (object instanceof IndexWriter) {
                ((IndexWriter)object).close();
            } else if (object instanceof IndexSearcher) {
                ((IndexSearcher)object).close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void strictAddDocument(IndexWriter writer, Document document) {
        try {
            writer.addDocument(document);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void strictRemoveDocument(IndexWriter writer, Query query) {
        try {
            writer.deleteDocuments(query);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Query rangeQuery(String key, Number from, Number to, boolean includeFrom, boolean includeTo) {
        if (from instanceof Long || to instanceof Long) {
            return NumericRangeQuery.newLongRange(key, from != null ? from.longValue() : 0L, to != null ? to.longValue() : Long.MAX_VALUE, includeFrom, includeTo);
        }
        if (from instanceof Double || to instanceof Double) {
            return NumericRangeQuery.newDoubleRange(key, from != null ? from.doubleValue() : 0.0, to != null ? to.doubleValue() : Double.MAX_VALUE, includeFrom, includeTo);
        }
        if (from instanceof Float || to instanceof Float) {
            return NumericRangeQuery.newFloatRange(key, Float.valueOf(from != null ? from.floatValue() : 0.0f), Float.valueOf(to != null ? to.floatValue() : Float.MAX_VALUE), includeFrom, includeTo);
        }
        return NumericRangeQuery.newIntRange(key, from != null ? from.intValue() : 0, to != null ? to.intValue() : Integer.MAX_VALUE, includeFrom, includeTo);
    }
}

