/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.util.Collection;
import java.util.Iterator;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.collection.CombiningIterator;
import org.neo4j.helpers.collection.IteratorUtil;

public class CombinedIndexHits<T>
extends CombiningIterator<T>
implements IndexHits<T> {
    private final Collection<IndexHits<T>> allIndexHits;
    private final int size;

    public CombinedIndexHits(Collection<IndexHits<T>> iterators) {
        super(iterators);
        this.allIndexHits = iterators;
        this.size = this.accumulatedSize(iterators);
    }

    private int accumulatedSize(Collection<IndexHits<T>> iterators) {
        int result = 0;
        for (IndexHits<T> hits : iterators) {
            result += hits.size();
        }
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    protected IndexHits<T> currentIterator() {
        return (IndexHits)super.currentIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void close() {
        for (IndexHits<T> hits : this.allIndexHits) {
            hits.close();
        }
        this.allIndexHits.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getSingle() {
        try {
            Object t = IteratorUtil.singleOrNull(this);
            return t;
        }
        finally {
            this.close();
        }
    }

    @Override
    public float currentScore() {
        return this.currentIterator().currentScore();
    }
}

