(ns lein-git-version.plugin
  (:require [leiningen.jar :as jar]
            [leiningen.git-version :refer [gen-versions]]
            [robert.hooke :refer (add-hook)]))

(def defaults
  {:file {:cmd ["git" "rev-parse" "HEAD"]
          :fmt ["%s+%s.%s" :basever :cmdver :date]
          :filepath nil
          :filename "version.clj"}})

(defn- retain-whitelisted-keys [f & [new original]]
  (merge new (select-keys original (into jar/whitelist-keys [:version :manifest]))))

(defn hooks[]
  (add-hook #'leiningen.jar/retain-whitelisted-keys #'retain-whitelisted-keys))

(defn- regen-project [{:keys [git-version] :as project}]
  (->> (merge-with merge defaults git-version)
       (assoc project :git-version)
       gen-versions
       (reduce into)
       (assoc project :git-version)))

(defn- version-assocs [project]
  (loop [keys (keys (:git-version project))
         proj project]
      (if (empty? keys)
        proj
        (let [v ((first keys) (:git-version proj))]
          (recur (rest keys) 
                 (reduce #(assoc-in %1 %2 (:version v)) proj (:assoc-in-keys v)))))))

(defn middleware [project]
  (->> project regen-project version-assocs))
